#include "BU91R65_User.h"
#include "BU91R65.h"
// #include "BU91R65_Access.h"
#include <string.h>
/*数字显示数组*/                                /*0,     1     2       3      4      5       6      7      8     9     A     b       C    d      E     F    U     P    L      -    null*/
const uint8_t BU91R65MASK[BU91R65DIS_MAX_7] = { 0x3Fu, 0x06u, 0x5Bu, 0x4Fu, 0x66u, 0x6Du, 0x7Du, 0x07u, 0x7Fu, 0x6Fu, 0x77, 0x7C, 0x39, 0x5E, 0x79, 0x71 ,0x3E, 0x73, 0x38, 0x76,0x40,  0x00};
/*数字显示数组*/                                     /*0,        1       2          3           4           5           6           7           8           9      null       */                                   /*0,      1        2        3        4        5        6        7        8        9   */
const uint16_t BU91R65MASK_16[BU91R65DIS16_MAX_16] = { 0x00FFu, 0x040Cu, 0x8877u, 0x083Fu, 0x888Cu, 0x88BBu, 0x88FBu, 0x000Fu, 0x88FFu, 0x88BFu, \
    /* A      B        C        D        E        F        G        H        I        J        K        L       M        N      O        P   */ 
    0x88CFu,  0x2A3Fu, 0x00F3u, 0x223Fu, 0x80F3u, 0x80C3u ,0x08FBu, 0x88CCu, 0x2233u, 0x007Cu, 0x94C0u, 0x00F0u,0x05CCu,0x11CCu,0x00FFu,0x88C7u,\
    /* Q      R        S        T        U        V        W        X        Y        Z        乘x      +        -        除/      [        ]   */ 
    0x10FFu,  0x98C7u, 0x88BBu, 0x2203u, 0x00FCu, 0x44C0u, 0x50CCu, 0x5500u, 0x88BCu, 0x4433u, 0x5500u, 0xAA00u, 0x8800u, 0x4400u, 0x00E1u,0x2221u,\
    /* (      )        =        度°       下划线      null */ 
    0x1400u, 0x4100u, 0x8830u,  0x0A06u,  0x0030u,  0x0000u,};
uint8_t BU91R65_Set_Numble(const BU91R65_USER_st_t* pBU91R65User, uint8_t enBU91R65Value, BU91R65_Number_SEG_en_t enBU91R65SEGNum, uint8_t Enable)
{
    uint8_t i = 0;
    uint8_t u8Index = 0;
    uint8_t u8COM = 0;
    uint8_t BU91R65NUMBERMAX = 0;
    if (pBU91R65User == (void*)0)
    {
        return 2;
    }
    if(enBU91R65SEGNum == BU91R65_NUMBER_SEG_7)
    {
        BU91R65NUMBERMAX = 7;
    }
    else if(enBU91R65SEGNum == BU91R65_NUMBER_SEG_16)
    {
        BU91R65NUMBERMAX = 16;
    }
    else
    {
        return 2;
    }
    for (i = 0; i < BU91R65NUMBERMAX; i++)
    {
        if ((pBU91R65User[i].u8BU91R65_Seg <= BU91R65SEGMAX) && (pBU91R65User[i].enBU91R65Channel < BU91R65_CHANNEL_MAX)
         && (pBU91R65User[i].u8BU91R65_COM < BU91R65_COM_MAX))
        {
            u8Index = pBU91R65User[i].u8BU91R65_Seg;
            u8COM = pBU91R65User[i].u8BU91R65_COM;
           
            if (pBU91R65User[i].enBU91R65Channel == 0)
            {
                if(enBU91R65SEGNum == BU91R65_NUMBER_SEG_7)
                {
                    if (Enable)
                    {
                        if ((BU91R65MASK[enBU91R65Value] & (1 << i)) != 0)
                        {
                            g_stBU91R65Chip0Seg.Byte[u8Index / 2] |=  (0x1 << ((u8Index % 2)*4 + u8COM));
                        }
                        else
                        {
                            g_stBU91R65Chip0Seg.Byte[u8Index / 2] &= ~(0x1 << ((u8Index % 2)*4 + u8COM));
                        }
                     
                        
                    }
                    else
                    {
                         g_stBU91R65Chip0Seg.Byte[u8Index / 2] &= ~(0x1 << ((u8Index % 2)*4 + u8COM));
                    }
                }
                else if(enBU91R65SEGNum == BU91R65_NUMBER_SEG_16)
                {
                    if (Enable)
                    {
                        if ((BU91R65MASK_16[enBU91R65Value] & (1 << i)) != 0)
                        {
                            g_stBU91R65Chip0Seg.Byte[u8Index / 2] |=  (0x1 << ((u8Index % 2)*4 + u8COM));
                        }
                        else
                        {
                            g_stBU91R65Chip0Seg.Byte[u8Index / 2] &= ~(0x1 << ((u8Index % 2)*4 + u8COM));
                        }
                    }
                    else
                    {
                        g_stBU91R65Chip0Seg.Byte[u8Index / 2] &= ~(0x1 << ((u8Index % 2)*4 + u8COM));
                    }
                }
                else
                {
                    return 2;
                }
                
                    
            }
            else
            {

                if(enBU91R65SEGNum == BU91R65_NUMBER_SEG_7)
                {
                    if (Enable)
                    {
                        if ((BU91R65MASK[enBU91R65Value] & (1 << i)) != 0)
                        {
                            g_stBU91R65Chip1Seg.Byte[u8Index / 2] |=  (0x1 << ((u8Index % 2)*4 + u8COM));
                        }
                        else
                        {
                            g_stBU91R65Chip1Seg.Byte[u8Index / 2] &= ~(0x1 << ((u8Index % 2)*4 + u8COM));
                        }
                     
                        
                    }
                    else
                    {
                         g_stBU91R65Chip1Seg.Byte[u8Index / 2] &= ~(0x1 << ((u8Index % 2)*4 + u8COM));
                    }
                }
                else if(enBU91R65SEGNum == BU91R65_NUMBER_SEG_16)
                {
                    if (Enable)
                    {
                        if ((BU91R65MASK_16[enBU91R65Value] & (1 << i)) != 0)
                        {
                            g_stBU91R65Chip1Seg.Byte[u8Index / 2] |=  (0x1 << ((u8Index % 2)*4 + u8COM));
                        }
                        else
                        {
                            g_stBU91R65Chip1Seg.Byte[u8Index / 2] &= ~(0x1 << ((u8Index % 2)*4 + u8COM));
                        }
                    }
                    else
                    {
                        g_stBU91R65Chip1Seg.Byte[u8Index / 2] &= ~(0x1 << ((u8Index % 2)*4 + u8COM));
                    }
                }
                else
                {
                    return 2;
                }
            }
        }
        else
        {
            return 3;
        }
    }

    return 0;
}

void Clear_All_BU91R65(void)
{
    uint8_t i = 0;
    for(i = 0; i < BU91R65_BUFFER_SIZE; i ++)
    {
        BU91R65_Write_Buffer(&g_stBU91R65Chip0,i,0x00);
        BU91R65_Write_Buffer(&g_stBU91R65Chip1,i,0x00);
    }
}
/* example */


// #define SEG_7_MAX 7
// #define SEG_7(channel, com, segment) {channel, com, segment}
// const BU91R65_USER_st_t VSPEEDSEG_0[SEG_7_MAX] = {
//     SEG_7(BU91R65_CHANNEL_2, 1, 16),
//     SEG_7(BU91R65_CHANNEL_2, 1, 17),
//     SEG_7(BU91R65_CHANNEL_2, 1, 18),
//     SEG_7(BU91R65_CHANNEL_2, 0, 15),
//     SEG_7(BU91R65_CHANNEL_2, 1, 15),
//     SEG_7(BU91R65_CHANNEL_2, 0, 16),
//     SEG_7(BU91R65_CHANNEL_2, 0, 17),
// };

#define SEG_16_MAX 16
#define SEG_16(channel, com, segment) {channel, com, segment}


const BU91R65_USER_st_t MiZi_Seg_0[SEG_16_MAX] = {
    SEG_16(BU91R65_CHANNEL_1, 3, 32),
    SEG_16(BU91R65_CHANNEL_1, 3, 34),
    SEG_16(BU91R65_CHANNEL_1, 3, 35),
    SEG_16(BU91R65_CHANNEL_1, 2, 35),
    SEG_16(BU91R65_CHANNEL_1, 0, 35),
    SEG_16(BU91R65_CHANNEL_1, 0, 33),
    SEG_16(BU91R65_CHANNEL_1, 0, 32),

    SEG_16(BU91R65_CHANNEL_1, 1, 32),
    SEG_16(BU91R65_CHANNEL_1, 2, 32),
    SEG_16(BU91R65_CHANNEL_1, 3, 33),
    SEG_16(BU91R65_CHANNEL_1, 2, 34),
    SEG_16(BU91R65_CHANNEL_1, 1, 34),
    SEG_16(BU91R65_CHANNEL_1, 1, 35),
    SEG_16(BU91R65_CHANNEL_1, 0, 34),

    SEG_16(BU91R65_CHANNEL_1, 1, 33),
    SEG_16(BU91R65_CHANNEL_1, 2, 33),
};

const BU91R65_USER_st_t MiZi_Seg_1[SEG_16_MAX] = {
    SEG_16(BU91R65_CHANNEL_1, 3, 37),
    SEG_16(BU91R65_CHANNEL_1, 3, 38),
    SEG_16(BU91R65_CHANNEL_1, 3, 39),
    SEG_16(BU91R65_CHANNEL_1, 0, 40),
    SEG_16(BU91R65_CHANNEL_1, 0, 38),
    SEG_16(BU91R65_CHANNEL_1, 0, 37),
    SEG_16(BU91R65_CHANNEL_1, 1, 36),

    SEG_16(BU91R65_CHANNEL_1, 3, 36),
    SEG_16(BU91R65_CHANNEL_1, 2, 37),
    SEG_16(BU91R65_CHANNEL_1, 2, 38),
    SEG_16(BU91R65_CHANNEL_1, 2, 39),
    SEG_16(BU91R65_CHANNEL_1, 1, 39),
    SEG_16(BU91R65_CHANNEL_1, 0, 39),
    SEG_16(BU91R65_CHANNEL_1, 1, 38),

    SEG_16(BU91R65_CHANNEL_1, 1, 37),
    SEG_16(BU91R65_CHANNEL_1, 2, 36),
};

const BU91R65_USER_st_t MiZi_Seg_2[SEG_16_MAX] = {
    SEG_16(BU91R65_CHANNEL_1, 3, 41),
    SEG_16(BU91R65_CHANNEL_1, 3, 42),
    SEG_16(BU91R65_CHANNEL_1, 3, 44),
    SEG_16(BU91R65_CHANNEL_1, 2, 44),
    SEG_16(BU91R65_CHANNEL_1, 0, 43),
    SEG_16(BU91R65_CHANNEL_1, 0, 42),
    SEG_16(BU91R65_CHANNEL_1, 2, 40),

    SEG_16(BU91R65_CHANNEL_1, 3, 40),
    SEG_16(BU91R65_CHANNEL_1, 2, 41),
    SEG_16(BU91R65_CHANNEL_1, 2, 42),
    SEG_16(BU91R65_CHANNEL_1, 3, 43),
    SEG_16(BU91R65_CHANNEL_1, 2, 43),
    SEG_16(BU91R65_CHANNEL_1, 1, 43),
    SEG_16(BU91R65_CHANNEL_1, 1, 42),

    SEG_16(BU91R65_CHANNEL_1, 0, 41),
    SEG_16(BU91R65_CHANNEL_1, 1, 41),
};

const BU91R65_USER_st_t MiZi_Seg_3[SEG_16_MAX] = {
    SEG_16(BU91R65_CHANNEL_1, 3, 45),
    SEG_16(BU91R65_CHANNEL_1, 3, 47),
    SEG_16(BU91R65_CHANNEL_1, 3, 48),
    SEG_16(BU91R65_CHANNEL_1, 2, 48),
    SEG_16(BU91R65_CHANNEL_1, 0, 48),
    SEG_16(BU91R65_CHANNEL_1, 0, 46),
    SEG_16(BU91R65_CHANNEL_1, 0, 45),

    SEG_16(BU91R65_CHANNEL_1, 1, 45),
    SEG_16(BU91R65_CHANNEL_1, 2, 45),
    SEG_16(BU91R65_CHANNEL_1, 3, 46),
    SEG_16(BU91R65_CHANNEL_1, 2, 47),
    SEG_16(BU91R65_CHANNEL_1, 1, 47),
    SEG_16(BU91R65_CHANNEL_1, 1, 48),
    SEG_16(BU91R65_CHANNEL_1, 0, 47),

    SEG_16(BU91R65_CHANNEL_1, 1, 46),
    SEG_16(BU91R65_CHANNEL_1, 2, 46),
};

const BU91R65_USER_st_t MiZi_Seg_4[SEG_16_MAX] = {
    SEG_16(BU91R65_CHANNEL_1, 3, 50),
    SEG_16(BU91R65_CHANNEL_1, 3, 51),
    SEG_16(BU91R65_CHANNEL_1, 3, 52),
    SEG_16(BU91R65_CHANNEL_1, 0, 53),
    SEG_16(BU91R65_CHANNEL_1, 0, 51),
    SEG_16(BU91R65_CHANNEL_1, 0, 50),
    SEG_16(BU91R65_CHANNEL_1, 1, 49),

    SEG_16(BU91R65_CHANNEL_1, 3, 49),
    SEG_16(BU91R65_CHANNEL_1, 2, 50),
    SEG_16(BU91R65_CHANNEL_1, 2, 51),
    SEG_16(BU91R65_CHANNEL_1, 2, 52),
    SEG_16(BU91R65_CHANNEL_1, 1, 52),
    SEG_16(BU91R65_CHANNEL_1, 0, 52),
    SEG_16(BU91R65_CHANNEL_1, 1, 51),

    SEG_16(BU91R65_CHANNEL_1, 1, 50),
    SEG_16(BU91R65_CHANNEL_1, 2, 49),
};

const BU91R65_USER_st_t MiZi_Seg_5[SEG_16_MAX] = {
    SEG_16(BU91R65_CHANNEL_1, 3, 54),
    SEG_16(BU91R65_CHANNEL_1, 3, 55),
    SEG_16(BU91R65_CHANNEL_1, 3, 57),
    SEG_16(BU91R65_CHANNEL_1, 2, 57),
    SEG_16(BU91R65_CHANNEL_1, 0, 56),
    SEG_16(BU91R65_CHANNEL_1, 0, 55),
    SEG_16(BU91R65_CHANNEL_1, 2, 53),

    SEG_16(BU91R65_CHANNEL_1, 3, 53),
    SEG_16(BU91R65_CHANNEL_1, 2, 54),
    SEG_16(BU91R65_CHANNEL_1, 2, 55),
    SEG_16(BU91R65_CHANNEL_1, 3, 56),
    SEG_16(BU91R65_CHANNEL_1, 2, 56),
    SEG_16(BU91R65_CHANNEL_1, 1, 56),
    SEG_16(BU91R65_CHANNEL_1, 1, 55),

    SEG_16(BU91R65_CHANNEL_1, 0, 54),
    SEG_16(BU91R65_CHANNEL_1, 1, 54),
};

const BU91R65_USER_st_t MiZi_Seg_6[SEG_16_MAX] = {
    SEG_16(BU91R65_CHANNEL_1, 3, 58),
    SEG_16(BU91R65_CHANNEL_1, 3, 60),
    SEG_16(BU91R65_CHANNEL_1, 3, 61),
    SEG_16(BU91R65_CHANNEL_1, 2, 61),
    SEG_16(BU91R65_CHANNEL_1, 0, 61),
    SEG_16(BU91R65_CHANNEL_1, 0, 59),
    SEG_16(BU91R65_CHANNEL_1, 0, 58),

    SEG_16(BU91R65_CHANNEL_1, 1, 58),
    SEG_16(BU91R65_CHANNEL_1, 2, 58),
    SEG_16(BU91R65_CHANNEL_1, 3, 59),
    SEG_16(BU91R65_CHANNEL_1, 2, 60),
    SEG_16(BU91R65_CHANNEL_1, 1, 60),
    SEG_16(BU91R65_CHANNEL_1, 1, 61),
    SEG_16(BU91R65_CHANNEL_1, 0, 60),

    SEG_16(BU91R65_CHANNEL_1, 1, 59),
    SEG_16(BU91R65_CHANNEL_1, 2, 59),
};

const BU91R65_USER_st_t MiZi_Seg_7[SEG_16_MAX] = {
    SEG_16(BU91R65_CHANNEL_1, 3, 63),
    SEG_16(BU91R65_CHANNEL_1, 3, 64),
    SEG_16(BU91R65_CHANNEL_1, 3, 65),
    SEG_16(BU91R65_CHANNEL_1, 0, 66),
    SEG_16(BU91R65_CHANNEL_1, 0, 64),
    SEG_16(BU91R65_CHANNEL_1, 0, 63),
    SEG_16(BU91R65_CHANNEL_1, 1, 62),

    SEG_16(BU91R65_CHANNEL_1, 3, 62),
    SEG_16(BU91R65_CHANNEL_1, 2, 63),
    SEG_16(BU91R65_CHANNEL_1, 2, 64),
    SEG_16(BU91R65_CHANNEL_1, 2, 65),
    SEG_16(BU91R65_CHANNEL_1, 1, 65),
    SEG_16(BU91R65_CHANNEL_1, 0, 65),
    SEG_16(BU91R65_CHANNEL_1, 1, 64),

    SEG_16(BU91R65_CHANNEL_1, 1, 63),
    SEG_16(BU91R65_CHANNEL_1, 2, 62),
};

const BU91R65_USER_st_t MiZi_Seg_8[SEG_16_MAX] = {
    SEG_16(BU91R65_CHANNEL_1, 3, 67),
    SEG_16(BU91R65_CHANNEL_1, 3, 68),
    SEG_16(BU91R65_CHANNEL_1, 3, 70),
    SEG_16(BU91R65_CHANNEL_1, 2, 70),
    SEG_16(BU91R65_CHANNEL_1, 0, 69),
    SEG_16(BU91R65_CHANNEL_1, 0, 68),
    SEG_16(BU91R65_CHANNEL_1, 2, 66),

    SEG_16(BU91R65_CHANNEL_1, 3, 66),
    SEG_16(BU91R65_CHANNEL_1, 2, 67),
    SEG_16(BU91R65_CHANNEL_1, 2, 68),
    SEG_16(BU91R65_CHANNEL_1, 3, 69),
    SEG_16(BU91R65_CHANNEL_1, 2, 69),
    SEG_16(BU91R65_CHANNEL_1, 1, 69),
    SEG_16(BU91R65_CHANNEL_1, 1, 68),

    SEG_16(BU91R65_CHANNEL_1, 0, 67),
    SEG_16(BU91R65_CHANNEL_1, 1, 67),
};

const BU91R65_USER_st_t MiZi_Seg_9[SEG_16_MAX] = {
    SEG_16(BU91R65_CHANNEL_1, 3, 71),
    SEG_16(BU91R65_CHANNEL_1, 3, 73),
    SEG_16(BU91R65_CHANNEL_1, 3, 74),
    SEG_16(BU91R65_CHANNEL_1, 2, 74),
    SEG_16(BU91R65_CHANNEL_1, 0, 74),
    SEG_16(BU91R65_CHANNEL_1, 0, 72),
    SEG_16(BU91R65_CHANNEL_1, 0, 71),

    SEG_16(BU91R65_CHANNEL_1, 1, 71),
    SEG_16(BU91R65_CHANNEL_1, 2, 71),
    SEG_16(BU91R65_CHANNEL_1, 3, 72),
    SEG_16(BU91R65_CHANNEL_1, 2, 73),
    SEG_16(BU91R65_CHANNEL_1, 1, 73),
    SEG_16(BU91R65_CHANNEL_1, 1, 74),
    SEG_16(BU91R65_CHANNEL_1, 0, 73),

    SEG_16(BU91R65_CHANNEL_1, 1, 72),
    SEG_16(BU91R65_CHANNEL_1, 2, 72),
};

const BU91R65_USER_st_t MiZi_Seg_10[SEG_16_MAX] = {
    SEG_16(BU91R65_CHANNEL_1, 3, 76),
    SEG_16(BU91R65_CHANNEL_1, 3, 77),
    SEG_16(BU91R65_CHANNEL_1, 3, 78),
    SEG_16(BU91R65_CHANNEL_1, 0, 79),
    SEG_16(BU91R65_CHANNEL_1, 0, 77),
    SEG_16(BU91R65_CHANNEL_1, 0, 76),
    SEG_16(BU91R65_CHANNEL_1, 1, 75),

    SEG_16(BU91R65_CHANNEL_1, 3, 75),
    SEG_16(BU91R65_CHANNEL_1, 2, 76),
    SEG_16(BU91R65_CHANNEL_1, 2, 77),
    SEG_16(BU91R65_CHANNEL_1, 2, 78),
    SEG_16(BU91R65_CHANNEL_1, 1, 78),
    SEG_16(BU91R65_CHANNEL_1, 0, 78),
    SEG_16(BU91R65_CHANNEL_1, 1, 77),

    SEG_16(BU91R65_CHANNEL_1, 1, 76),
    SEG_16(BU91R65_CHANNEL_1, 2, 75),
};

const BU91R65_USER_st_t MiZi_Seg_11[SEG_16_MAX] = {
    SEG_16(BU91R65_CHANNEL_1, 3, 80),
    SEG_16(BU91R65_CHANNEL_1, 3, 81),
    SEG_16(BU91R65_CHANNEL_1, 3, 83),
    SEG_16(BU91R65_CHANNEL_1, 2, 83),
    SEG_16(BU91R65_CHANNEL_1, 0, 82),
    SEG_16(BU91R65_CHANNEL_1, 0, 81),
    SEG_16(BU91R65_CHANNEL_1, 2, 79),

    SEG_16(BU91R65_CHANNEL_1, 3, 79),
    SEG_16(BU91R65_CHANNEL_1, 2, 80),
    SEG_16(BU91R65_CHANNEL_1, 2, 81),
    SEG_16(BU91R65_CHANNEL_1, 3, 82),
    SEG_16(BU91R65_CHANNEL_1, 2, 82),
    SEG_16(BU91R65_CHANNEL_1, 1, 82),
    SEG_16(BU91R65_CHANNEL_1, 1, 81),

    SEG_16(BU91R65_CHANNEL_1, 0, 80),
    SEG_16(BU91R65_CHANNEL_1, 1, 80),
};

const BU91R65_USER_st_t MiZi_Seg_12[SEG_16_MAX] = {
    SEG_16(BU91R65_CHANNEL_1, 3, 84),
    SEG_16(BU91R65_CHANNEL_1, 3, 86),
    SEG_16(BU91R65_CHANNEL_1, 3, 87),
    SEG_16(BU91R65_CHANNEL_1, 2, 87),
    SEG_16(BU91R65_CHANNEL_1, 0, 87),
    SEG_16(BU91R65_CHANNEL_1, 0, 85),
    SEG_16(BU91R65_CHANNEL_1, 0, 84),

    SEG_16(BU91R65_CHANNEL_1, 1, 84),
    SEG_16(BU91R65_CHANNEL_1, 2, 84),
    SEG_16(BU91R65_CHANNEL_1, 3, 85),
    SEG_16(BU91R65_CHANNEL_1, 2, 86),
    SEG_16(BU91R65_CHANNEL_1, 1, 86),
    SEG_16(BU91R65_CHANNEL_1, 1, 87),
    SEG_16(BU91R65_CHANNEL_1, 0, 86),

    SEG_16(BU91R65_CHANNEL_1, 1, 85),
    SEG_16(BU91R65_CHANNEL_1, 2, 85),
};

const BU91R65_USER_st_t MiZi_Seg_13[SEG_16_MAX] = {
    SEG_16(BU91R65_CHANNEL_1, 3, 89),
    SEG_16(BU91R65_CHANNEL_1, 3, 90),
    SEG_16(BU91R65_CHANNEL_1, 3, 91),
    SEG_16(BU91R65_CHANNEL_1, 0, 92),
    SEG_16(BU91R65_CHANNEL_1, 0, 90),
    SEG_16(BU91R65_CHANNEL_1, 0, 89),
    SEG_16(BU91R65_CHANNEL_1, 1, 88),

    SEG_16(BU91R65_CHANNEL_1, 3, 88),
    SEG_16(BU91R65_CHANNEL_1, 2, 89),
    SEG_16(BU91R65_CHANNEL_1, 2, 90),
    SEG_16(BU91R65_CHANNEL_1, 2, 91),
    SEG_16(BU91R65_CHANNEL_1, 1, 91),
    SEG_16(BU91R65_CHANNEL_1, 0, 91),
    SEG_16(BU91R65_CHANNEL_1, 1, 90),

    SEG_16(BU91R65_CHANNEL_1, 1, 89),
    SEG_16(BU91R65_CHANNEL_1, 2, 88),
};

const BU91R65_USER_st_t MiZi_Seg_14[SEG_16_MAX] = {
    SEG_16(BU91R65_CHANNEL_1, 3, 93),
    SEG_16(BU91R65_CHANNEL_1, 3, 94),
    SEG_16(BU91R65_CHANNEL_1, 3, 96),
    SEG_16(BU91R65_CHANNEL_1, 2, 96),
    SEG_16(BU91R65_CHANNEL_1, 0, 95),
    SEG_16(BU91R65_CHANNEL_1, 0, 94),
    SEG_16(BU91R65_CHANNEL_1, 2, 92),

    SEG_16(BU91R65_CHANNEL_1, 3, 92),
    SEG_16(BU91R65_CHANNEL_1, 2, 93),
    SEG_16(BU91R65_CHANNEL_1, 2, 94),
    SEG_16(BU91R65_CHANNEL_1, 3, 95),
    SEG_16(BU91R65_CHANNEL_1, 2, 95),
    SEG_16(BU91R65_CHANNEL_1, 1, 95),
    SEG_16(BU91R65_CHANNEL_1, 1, 94),

    SEG_16(BU91R65_CHANNEL_1, 0, 93),
    SEG_16(BU91R65_CHANNEL_1, 1, 93),
};

const BU91R65_USER_st_t MiZi_Seg_15[SEG_16_MAX] = {
    SEG_16(BU91R65_CHANNEL_1, 3, 97),
    SEG_16(BU91R65_CHANNEL_1, 3, 99),
    SEG_16(BU91R65_CHANNEL_1, 3, 100),
    SEG_16(BU91R65_CHANNEL_1, 2, 100),
    SEG_16(BU91R65_CHANNEL_1, 0, 100),
    SEG_16(BU91R65_CHANNEL_1, 0, 98),
    SEG_16(BU91R65_CHANNEL_1, 0, 97),

    SEG_16(BU91R65_CHANNEL_1, 1, 97),
    SEG_16(BU91R65_CHANNEL_1, 2, 97),
    SEG_16(BU91R65_CHANNEL_1, 3, 98),
    SEG_16(BU91R65_CHANNEL_1, 2, 99),
    SEG_16(BU91R65_CHANNEL_1, 1, 99),
    SEG_16(BU91R65_CHANNEL_1, 1, 100),
    SEG_16(BU91R65_CHANNEL_1, 0, 99),

    SEG_16(BU91R65_CHANNEL_1, 1, 98),
    SEG_16(BU91R65_CHANNEL_1, 2, 98),
};

const BU91R65_USER_st_t *LibertyMizi[] = 
{
    &MiZi_Seg_0[0],
    &MiZi_Seg_1[0],
    &MiZi_Seg_2[0],
    &MiZi_Seg_3[0],
    &MiZi_Seg_4[0],
    &MiZi_Seg_5[0],
    &MiZi_Seg_6[0],
    &MiZi_Seg_7[0],
    &MiZi_Seg_8[0],
    &MiZi_Seg_9[0],
    &MiZi_Seg_10[0],
    &MiZi_Seg_11[0],
    &MiZi_Seg_12[0],
    &MiZi_Seg_13[0],
    &MiZi_Seg_14[0],
    &MiZi_Seg_15[0],
};

uint8_t BU91R65_num = 0;
uint8_t BU91R65_time = 0;
void BU91R65_DSIP(void)
{
    if(++BU91R65_time > 10)
    {
        BU91R65_time = 0;
        BU91R65_Set_Numble(&MiZi_Seg_0[0],BU91R65_num,BU91R65_NUMBER_SEG_16,BU91R65_Enable);
        BU91R65_num++;
        if(BU91R65_num >= BU91R65DIS16_MAX_16)
        {
            BU91R65_num = 0;
        }
    }
}

void  BU91R65_Clear_NUM_7(const BU91R65_USER_st_t* pBU91R65User)
{
    BU91R65_Set_Numble(pBU91R65User, BU91R65DIS_NUMBLE_NULL, BU91R65_NUMBER_SEG_7, BU91R65_Enable);
}


uint8_t LibertyString[LIBERTY_STRING_LENTH] = {0};
uint8_t PrefixBlankNum = 0xff;


void Liberty_String_Display_Init(void )
{
    uint8_t i = 0u;
    for(i=0; i<LIBERTY_STRING_LENTH; i++)
    {
        LibertyString[i] = 0u;
    }
    PrefixBlankNum = 0xff;
}

uint8_t String_Compare(uint8_t *bku, const uint8_t *dat, const uint8_t lenth)
{
    uint8_t i = 0u;
    uint8_t ret = 0u;
    for(i=0; i<lenth; i++)
    {
        if(bku[i] != dat[i])
        {
            break;
        }
    }
    if(i == lenth)
    {
        ret = 1u;
    }
    else
    {
        ret = 0u;
    }

    memcpy(bku, dat, lenth);

    return ret;
}

/**
 * @brief 自由项目米字格字符串显示函数。自由项目共16个米字格，此函数在16个米字格上显示字符。
 * @brief 显示内容索引：BU91R65_Numble16_Mask_en_t
 * 
 * @param f_blank_num: 有效字符前有几个米字格需要不显示内容，此参数不可以大于16
 * @param  *dat ：有效字符，必须有'\0'结尾！！
 * @param  *dat ：摄氏度的°符号，用.代替
 * 
 * @param example: Liberty_String_Display(3u, "SET TEMP      .C");
 *  * @param example:从第四个米字格开始，显示：SET TEMP       °C
* @param example: Liberty_String_Display(0u, "");
 *  * @param example:清空16个米字格
 * 
 */

void Liberty_String_Display(const uint8_t f_blank_num, const uint8_t *dat)
{
    uint8_t i = 0u;
    uint8_t idx = BU91R65DIS16_NUMBLE_NULL;
     uint8_t lenth = 0u;

    while(dat[lenth++] != '\0')
    {
    }

    if(lenth == 0u)
    {
        return;
    }

    if((lenth + f_blank_num) > LIBERTY_STRING_LENTH)
    {
        return;
    }
    
    if(String_Compare(LibertyString, dat, lenth) == 1u && PrefixBlankNum == f_blank_num)
    {
        return;
    }

    PrefixBlankNum = f_blank_num;

    for(i=0; i<LIBERTY_STRING_LENTH; i++)
    {

        if((i<f_blank_num) || (i >= f_blank_num + lenth-1))
        {
            idx = BU91R65DIS16_NUMBLE_NULL;
        }
        else
        {
            if(dat[i - f_blank_num] >= '0' && dat[i - f_blank_num] <= '9')
            {
                idx = BU91R65DIS16_NUMBLE_0 + (dat[i - f_blank_num] - '0');
            }
            else if(dat[i - f_blank_num] >= 'A' && dat[i - f_blank_num] <= 'Z')
            {
                idx = BU91R65DIS16_ALPHABET_A + (dat[i - f_blank_num] - 'A');
            }
            else
            {
                switch(dat[i - f_blank_num])
                {
                    case ' ':
                    {
                        idx = BU91R65DIS16_NUMBLE_NULL;
                        break;
                    }
                    case 'x':
                    {
                        idx = BU91R65DIS16_NUMBLE_mul;
                        break;
                    }
                    case '+':
                    {
                        idx = BU91R65DIS16_NUMBLE_add;
                        break;
                    }
                    case '-':
                    {
                        idx = BU91R65DIS16_NUMBLE_sub;
                        break;
                    }
                    case '/':
                    {
                        idx = BU91R65DIS16_NUMBLE_exc;
                        break;
                    }
                    case '[':
                    {
                        idx = BU91R65DIS16_NUMBLE_LMPar;
                        break;
                    }
                    case ']':
                    {
                        idx = BU91R65DIS16_NUMBLE_RMPar;
                        break;
                    }
                    case '(':
                    {
                        idx = BU91R65DIS16_NUMBLE_LSPar;
                        break;
                    }
                    case ')':
                    {
                        idx = BU91R65DIS16_NUMBLE_RSPar;
                        break;
                    }
                    case '=':
                    {
                        idx = BU91R65DIS16_NUMBLE_equal;
                        break;
                    }
                    case '.':
                    {
                        idx = BU91R65DIS16_NUMBLE_degrees;
                        break;
                    }
                    case '_':
                    {
                        idx = BU91R65DIS16_NUMBLE__;
                        break;
                    }

                    default:
                    {
                        idx = BU91R65DIS16_NUMBLE_NULL;
                        break;
                    }
                }
            }
        }

        

        if(idx < BU91R65DIS16_MAX_16)
        {
            BU91R65_Set_Numble(LibertyMizi[i],idx,BU91R65_NUMBER_SEG_16,BU91R65_Enable);
        }
    }
}





