
#ifndef RTE_ADC_H
#define RTE_ADC_H

#include "TYW_stdint.h"

extern volatile uint16_t AnalogFuelSensorRes;    //按键阻值,单位：0.1 Ohm
extern volatile uint16_t AnalogKeyRes;           //按键阻值,单位：0.1 Ohm
extern volatile uint16_t AnalogKeyResValid;      //按键阻值有效性

//
#define ANALOG_KL15_VOLTAGE          (AnalogKL15Voltage)           //15电压值
#define ANALOG_KL15_VOLTAGE_VALID    (AnalogKL15VoltageValid)      //15有效位 1--有效 0--无效
#define ANALOG_KL30_VOLTAGE          (AnalogKL30Voltage)           //30电压值
#define ANALOG_KL30_VOLTAGE_VALID    (AnalogKL30VoltageValid)      //30有效位 1--有效 0--无效
#define ANALOG_FUEL_SENSOR_RES       (AnalogFuelSensorRes)         //燃油传感器阻值
#define ANALOG_FUEL_SENSOR_RES_VALID (AnalogFuelSensorResValid)    //燃油传感器采集有效位 1--有效 0--无效

#define ANALOG_FUEL_VOLTAGE         (AnalogFuelVoltage)           //燃油传感器阻值
#define ANALOG_FUEL_VOLTAGE_VALID   (AnalogFuelVoltageValid)      //燃油传感器采集有效位 1--有效 0--无效
#define ANALOG_FUEL_VOLTAGE_1       (AnalogFuelVoltage_1)         //燃油传感器阻值
#define ANALOG_FUEL_VOLTAGE_VALID_1 (AnalogFuelVoltageValid_1)    //燃油传感器采集有效位 1--有效 0--无效
#define ANALOG_KEY_RES              (AnalogKeyRes)                //按键阻值
#define ANALOG_KEY_RES_VALID        (AnalogKeyResValid)           //按键采集有效位 1--有效 0--无效

#define ANALOG_NTC_VOLTAGE       (AnalogNtcVoltage)    //热敏电阻
#define ANALOG_NTC_VOLTAGE_VALID (AnalogNtcValid)

extern uint8_t NTCDegree;
#define NTCDEGREE NTCDegree

void RTE_ADC_Init(void);
void RTE_ADC_Services(void);

uint16_t RTE_ADC_SignalRead(uint16_t ADCch);
uint16_t RTE_ADC_SignalValidRead(uint16_t ADCch);
uint16_t RTE_ADC_ForceConvert(uint16_t ch);

#endif
