
#include <stddef.h>
#include "BU91R65_Access.h"
#include "WDT.h"

/******************************************************************************
* BU98R10 command list
******************************************************************************/
#define   BU98R10_CMD_DATWR                 ((uint8_t)0x0AU)   /**< Data Write */
#define   BU98R10_CMD_ADSET                 ((uint8_t)0x40U)   /**< Address Set */

#define   BU98R10_CMD_DISPOFF               ((uint8_t)0x80U)   /**< Display Off */
#define   BU98R10_CMD_DISPON                ((uint8_t)0x81U)   /**< Display On */
#define   BU98R10_CMD_ICSET                 ((uint8_t)0x88U)   /**< Set IC mode: clk, RGB/MONO */
#define   BU98R10_CMD_DRVCTRL               ((uint8_t)0x90U)   /**< Invert-On/Off, AP-On/Off */
#define   BU98R10_CMD_FREQ                  ((uint8_t)0x98U)   /**< Frame-Frequency */
#define   BU98R10_CMD_SEG_R                 ((uint8_t)0xA0U)
#define   BU98R10_CMD_SEG_G                 ((uint8_t)0xA8U)
#define   BU98R10_CMD_SEG_B                 ((uint8_t)0xB0U)
#define   BU98R10_CMD_LED_STARTR            ((uint8_t)0xB8U)
#define   BU98R10_CMD_LED_STARTG            ((uint8_t)0xC0U)
#define   BU98R10_CMD_LED_STARTB            ((uint8_t)0xC8U)
#define   BU98R10_CMD_LED_WIDTHR            ((uint8_t)0xD0U)
#define   BU98R10_CMD_LED_WIDTHG            ((uint8_t)0xD8U)
#define   BU98R10_CMD_LED_WIDTHB            ((uint8_t)0xE0U)
#define   BU98R10_CMD_LED_CTRL              ((uint8_t)0xE8U)
#define   BU98R10_CMD_SWRST                 ((uint8_t)0xF9U)   /**< Software Reset */

/******************************************************************************
* BU98R10 Parameter list
******************************************************************************/
#define   BU98R10_PAR_ICSET_RGB             ((uint8_t)0x00U)   /**< Set IC mode: RGB */
#define   BU98R10_PAR_ICSET_MONO            ((uint8_t)0x01U)   /**< Set IC mode: MONO */
#define   BU98R10_PAR_ICSET_INTOSC          ((uint8_t)0x00U)   /**< Set IC mode: Internal oscillator clock*/
#define   BU98R10_PAR_ICSET_EXTCLK          ((uint8_t)0x02U)   /**< Set IC mode: External input clock*/

#define   BU98R10_PAR_DRVCTRL_NORMAL        ((uint8_t)0x00U)   /**< Normal display */
#define   BU98R10_PAR_DRVCTRL_AP_OFF        ((uint8_t)0x01U)   /**< All segment off */
#define   BU98R10_PAR_DRVCTRL_AP_ON         ((uint8_t)0x02U)   /**< All segment on */
#define   BU98R10_PAR_DRVCTRL_INVERSE       ((uint8_t)0x03U)   /**< Inverse display mode */  /*手册是4吧*/

/******************************************************************************
* BU98R10 state
******************************************************************************/
#define   BU91R65_STATE_IDLE                 (0U)      /**< Chips are idle */
#define   BU91R65_STATE_INIT                 (1U)      /**< Chips are in the initialization process */
#define   BU91R65_STATE_RUN                  (2U)      /**< Chips are ready to run */

/******************************************************************************
* BU98R10 configuration
******************************************************************************/
#define   BU91R65_ms_DIV                    (400UL)
#define   BU91R65_RETRY_MAX_NUM             (2UL)
#define   BU91R65_WRITE_SIZE                (16U)     /**< Maximum number of bytes written in a single time */

typedef struct
{
    uint8_t   u8State;                /**< Operating state */
    uint8_t   u8ForceUpdt;            /**< SEGs to be force updated */
    uint8_t   u8InitCnt;              /**< chip init count*/
    uint8_t   u8InitSts;              /**< chip to be init*/
    uint32_t  u32SpeedTrim;           /**< Timing trim */
    BU91R65_Handler_st_t *pstCurrent;  /**< Current chip */
    BU91R65_Handler_st_t *pstList;     /**< Start of chip list */
}BU91R65_Update_Ctrl_st_t;

static int32_t BU91R65_Search(BU91R65_Handler_st_t *pHandler);
static void    BU91R65_Write_Command(BU91R65_Handler_st_t *pHandler, uint8_t u8Cmd);
static void    BU91R65_Write_Data(BU91R65_Handler_st_t *pHandler, uint8_t u8Data);
static void    BU91R65_Delay_ms(uint32_t u32Interval);
static void    BU91R65_Delay(void);

uint32_t g_u32BU91R65DelayCounter;
BU91R65_Update_Ctrl_st_t g_stBU91R65UpdateCtrl;

void BU91R65_Init(uint32_t u32SpeedTrim)
{
    g_stBU91R65UpdateCtrl.u8State      = BU91R65_STATE_IDLE;
    g_stBU91R65UpdateCtrl.u8ForceUpdt  = 0U;
    g_stBU91R65UpdateCtrl.u8InitCnt    = 0U;
    g_stBU91R65UpdateCtrl.u8InitSts    = 0U;
    g_stBU91R65UpdateCtrl.u32SpeedTrim = u32SpeedTrim;
    g_stBU91R65UpdateCtrl.pstList      = NULL;
    g_stBU91R65UpdateCtrl.pstCurrent   = NULL;
}

void BU91R65_DeInit(void)
{
    g_stBU91R65UpdateCtrl.u8State      = BU91R65_STATE_IDLE;
    g_stBU91R65UpdateCtrl.u8ForceUpdt  = 0U;
    g_stBU91R65UpdateCtrl.u8InitCnt    = 0U;
    g_stBU91R65UpdateCtrl.u8InitSts    = 0U;
    g_stBU91R65UpdateCtrl.pstList      = NULL;
    g_stBU91R65UpdateCtrl.pstCurrent   = NULL;
}


int32_t BU91R65_Add(BU91R65_Handler_st_t *pHandler, BU91R65_Config_st_t *pstCfg)
{
    uint32_t i;
    int32_t  i32Result;
    BU91R65_Pin_Map_st_t stPinMap;
    BU91R65_Handler_st_t *pstSearch;

    i32Result = -1;
    if ((BU91R65_Search(pHandler) == 0) && (pstCfg != NULL))
    {
        if (pstCfg->pu8Buffer != NULL)
        {
            stPinMap.u16PinCS     = pstCfg->u16PinCS;
            stPinMap.u16PinSCLK   = pstCfg->u16PinSCLK;
            stPinMap.u16PinSD     = pstCfg->u16PinSD;

            i32Result = BU91R65_GPIO_Init(&stPinMap);
            if (i32Result == 0)
            {
                pHandler->stPinMap.u16PinCS     = stPinMap.u16PinCS;
                pHandler->stPinMap.u16PinSCLK   = stPinMap.u16PinSCLK;
                pHandler->stPinMap.u16PinSD     = stPinMap.u16PinSD;
                pHandler->u8Counter     = 0U;
                pHandler->u8Freq        = pstCfg->u8FrameFreq;
                pHandler->pu8UserBuffer = pstCfg->pu8Buffer;
                pHandler->pstNext       = NULL;

                // pHandler->stRegVal.u8SegR     = pstCfg->stColorSetting.u8SRR << 4;
                // pHandler->stRegVal.u8SegR    |= pstCfg->stColorSetting.u8SRF & 0x0FU;
                // pHandler->stRegVal.u8SegG     = pstCfg->stColorSetting.u8SGR << 4;
                // pHandler->stRegVal.u8SegG    |= pstCfg->stColorSetting.u8SGF & 0x0FU;
                // pHandler->stRegVal.u8SegB     = pstCfg->stColorSetting.u8SBR << 4;
                // pHandler->stRegVal.u8SegB    |= pstCfg->stColorSetting.u8SBF & 0x0FU;
                // pHandler->stRegVal.u8LRS      = pstCfg->stColorSetting.u8LRS & 0x3FU;
                // pHandler->stRegVal.u8LGS      = pstCfg->stColorSetting.u8LGS & 0x3FU;
                // pHandler->stRegVal.u8LBS      = pstCfg->stColorSetting.u8LBS & 0x3FU;
                // pHandler->stRegVal.u8LRW      = pstCfg->stColorSetting.u8LRW & 0x3FU;
                // pHandler->stRegVal.u8LGW      = pstCfg->stColorSetting.u8LGW & 0x3FU;
                // pHandler->stRegVal.u8LBW      = pstCfg->stColorSetting.u8LBW & 0x3FU;

                for (i = 0UL; i < (uint32_t)BU91R65_BUFFER_SIZE; i++)
                {
                    pHandler->pu8UserBuffer[i] = pstCfg->u8DefaultVal;
                    pHandler->u8BkupBuffer[i]  = pstCfg->u8DefaultVal;
                }

                /*全局芯片注册*/
                if (g_stBU91R65UpdateCtrl.pstList == NULL)
                {
                    g_stBU91R65UpdateCtrl.pstList = pHandler;
                }
                else
                {
                    pstSearch = g_stBU91R65UpdateCtrl.pstList;
                    while (pstSearch->pstNext != NULL)
                    {
                        pstSearch = pstSearch->pstNext;
                    }

                    pstSearch->pstNext = pHandler;
                }
            }
        }
    }

    /* chip initial */
    if (i32Result == 0)
    {
        /* Step 1: Apply software reset */
        pHandler->stPinMap.u16PinCS(0U);
        BU91R65_Delay();
        BU91R65_Write_Command(pHandler, 0xFD);
        BU91R65_Write_Command(pHandler, 0x81);
        BU91R65_Delay();
        pHandler->stPinMap.u16PinCS(1U);
        BU91R65_Delay_ms(20UL);

        /* Step 2: Config chip */;
        // BU98R10_Set_nCS(&(pHandler->stPinMap), 0U);
        pHandler->stPinMap.u16PinCS(0U);
        BU91R65_Delay();
        /* Turn off display before setting */
        BU91R65_Write_Command(pHandler, 0xC0);
        /* Enter To Extension Mode */
        BU91R65_Write_Command(pHandler, 0xFD);
        /* All detections:disable */
        BU91R65_Write_Command(pHandler, 0x90);
        /* Set LCD Driving Mode/Set Frame frequency mode */
        BU91R65_Write_Command(pHandler, 0xA0);
        /* Contrast Set */
        BU91R65_Write_Command(pHandler, 0xB0);
        /* Read setting */
        BU91R65_Write_Command(pHandler, 0xC0);
        /* Com setting */
        BU91R65_Write_Command(pHandler, 0xE4);
        /* Enter to Normal Mode */
        BU91R65_Write_Command(pHandler, 0xFC);
        /* Frame Frequency */
        BU91R65_Write_Command(pHandler, 0xED);
        /* Blink setting */
        BU91R65_Write_Command(pHandler, 0xF0);
        /* Data write setting */
        BU91R65_Write_Command(pHandler, 0xF8);
        /* Sub Address Set */
        BU91R65_Write_Command(pHandler, 0xE0);
        /* Address Set1 */
        BU91R65_Write_Command(pHandler, 0x00);
        /* Address Set2 */
        BU91R65_Write_Command(pHandler, 0x40);
        // /* Transfer display data */
        // BU91R65_Write_Command(pHandler, BU98R10_CMD_DATWR);
        for (i = 0UL; i < (uint32_t)BU91R65_BUFFER_SIZE; i++)
        {
            // BU91R65_Write_Data(pHandler, pHandler->u8BkupBuffer[i]);
            BU91R65_Write_Command(pHandler, pHandler->u8BkupBuffer[i]);
        }
        BU91R65_Delay();
        pHandler->stPinMap.u16PinCS(1U);
        BU91R65_Delay();
        pHandler->stPinMap.u16PinCS(0U);
        /* Display on */
        BU91R65_Write_Command(pHandler, 0xC8);
        BU91R65_Delay();
        pHandler->stPinMap.u16PinCS(1U);
    
        g_stBU91R65UpdateCtrl.u8State = BU91R65_STATE_RUN;
    }

    return i32Result;
}

int32_t BU91R65_Del(BU91R65_Handler_st_t *pHandler)
{
    int32_t  i32Result;
    uint32_t u32Retry;
    BU91R65_Handler_st_t *pstSearch;

    i32Result = -1;
    if (BU91R65_Search(pHandler) > 0)
    {
        u32Retry = 0UL;
        do
        {
            // BU98R10_Set_nCS(&(pHandler->stPinMap), 0U);
            pHandler->stPinMap.u16PinCS(0U);
            BU91R65_Delay();

            /* Display off */
            BU91R65_Write_Command(pHandler, 0xC0);

            BU91R65_Delay();
            // BU98R10_Set_nCS(&(pHandler->stPinMap), 1U);
            pHandler->stPinMap.u16PinCS(1U);

            u32Retry++;
        } while ((u32Retry < BU91R65_RETRY_MAX_NUM) && (i32Result != 0));

        if (i32Result == 0)
        {
            /* Stop updating the current chip */
            if (g_stBU91R65UpdateCtrl.pstCurrent == pHandler)
            {
                g_stBU91R65UpdateCtrl.pstCurrent = pHandler->pstNext;
            }

            /* Remove the current chip from list */
            if (pHandler == g_stBU91R65UpdateCtrl.pstList)
            {
                g_stBU91R65UpdateCtrl.pstList = pHandler->pstNext;
            }
            else
            {
                pstSearch = g_stBU91R65UpdateCtrl.pstList;
                while ((pstSearch->pstNext != NULL) && (pstSearch->pstNext != pHandler))
                {
                    pstSearch = pstSearch->pstNext;
                }
            
                if (pstSearch->pstNext == pHandler)
                {
                    pstSearch->pstNext = pHandler->pstNext;
                }
            }
            
            /* Reset control parameters */
            pHandler->u8Counter    = 0U;
            pHandler->pstNext      = NULL;
        }
    }
    
    return i32Result;
}


void BU91R65_Refresh_Service(void)/*20ms*/
{
    #if 1
    if ((g_stBU91R65UpdateCtrl.u8State == BU91R65_STATE_RUN) && (g_stBU91R65UpdateCtrl.pstList != NULL))
    {
        /* Request update */
        if (g_stBU91R65UpdateCtrl.pstCurrent == NULL)
        {
            g_stBU91R65UpdateCtrl.pstCurrent = g_stBU91R65UpdateCtrl.pstList;
        }

        /* Update 2 SEGs per frame */
        // g_stBU91R65UpdateCtrl.u8ForceUpdt += 20U;
        // if (g_stBU91R65UpdateCtrl.u8ForceUpdt >= BU91R65_BUFFER_SIZE)
        // {
        //     g_stBU91R65UpdateCtrl.u8ForceUpdt = 0U;
        // }

        /* Init per second*/
        // g_stBU91R65UpdateCtrl.u8InitCnt++;
        // if (g_stBU91R65UpdateCtrl.u8InitCnt >= 50U)
        // {
        //     g_stBU91R65UpdateCtrl.u8InitSts = 1U;
        //     g_stBU91R65UpdateCtrl.u8InitCnt = 0U;
        // }

    }
    #endif
}

void BU91R65_Communication_Service(void)
{
    uint8_t  u8Len;
    uint8_t  u8Diff;
    uint8_t  u8Index;
    uint8_t  u8AddHigh;
    uint8_t  u8AddLow;
    uint8_t  u8Buffer[BU91R65_WRITE_SIZE] = {0};
    uint16_t u16ResetPin;
    uint32_t u32Retry;
    BU91R65_Handler_st_t *pstChip;

    if ((g_stBU91R65UpdateCtrl.u8State == BU91R65_STATE_RUN) && (g_stBU91R65UpdateCtrl.pstList != NULL) && (g_stBU91R65UpdateCtrl.pstCurrent != NULL))
    {
        pstChip = g_stBU91R65UpdateCtrl.pstCurrent;

        u8Diff  = 0U;
        u8Index = 0U;
        while ((pstChip->u8Counter < BU91R65_BUFFER_SIZE) && (u8Diff == 0U))
        {
            if (pstChip->pu8UserBuffer[pstChip->u8Counter] != pstChip->u8BkupBuffer[pstChip->u8Counter])
            // if ((pstChip->pu8UserBuffer[pstChip->u8Counter] != pstChip->u8BkupBuffer[pstChip->u8Counter]) || \
            //     ((pstChip->u8Counter & 0xFEU) == g_stBU91R65UpdateCtrl.u8ForceUpdt))
            {
                u8Diff  = 1U;
                u8Index = pstChip->u8Counter;
            }
            else
            {
                pstChip->u8Counter++;
            }
        }
        if (u8Diff)
        {
            u8Len  = 0U;
            while ((u8Diff != 0U) && (u8Len < BU91R65_WRITE_SIZE) && (u8Index < BU91R65_BUFFER_SIZE))
            {
                if (pstChip->pu8UserBuffer[u8Index] != pstChip->u8BkupBuffer[u8Index])
                // if ((pstChip->pu8UserBuffer[u8Index] != pstChip->u8BkupBuffer[u8Index]) || \
                // ((u8Index & 0xFEU) == g_stBU91R65UpdateCtrl.u8ForceUpdt))
                {
                    u8Buffer[u8Len] = pstChip->pu8UserBuffer[u8Index];
                    u8Len++;
                    u8Index++;
                }
                else
                {
                    u8Diff = 0U;
                }
            }

            /*init judgement*/
            // if (g_stBU91R65UpdateCtrl.u8InitSts)
            // {
            //     g_stBU91R65UpdateCtrl.u8InitSts = 0U;
            //     do
            //     {
            //         pstChip->stPinMap.u16PinCS(0U);
            //         /* Set frame frequency */
            //         BU91R65_Write_Command(pstChip, 0xED);
            //         // BU91R65_Write_Data(pstChip, pstChip->u8Freq);
            //         BU91R65_Delay();
            //         /* Display on */
            //         BU91R65_Write_Command(pstChip, 0xC8);  /* code */
            //         // BU98R10_Set_nCS(&(pstChip->stPinMap), 1U);
            //         BU91R65_Delay();
            //         pstChip->stPinMap.u16PinCS(0U);
            //         if (pstChip ->pstNext != NULL)
            //         {
            //             pstChip = pstChip -> pstNext;
            //         }
            //         else
            //         {
            //             pstChip = g_stBU91R65UpdateCtrl.pstList;
            //         }
            //     } while (pstChip != g_stBU91R65UpdateCtrl.pstCurrent);
            // }

            pstChip->stPinMap.u16PinCS(0U);
            BU91R65_Delay();
            /* Set start address */
            BU91R65_Write_Command(pstChip, 0xE0);
            BU91R65_Write_Command(pstChip, ((pstChip->u8Counter*2) & 0xF0)>>4);
            BU91R65_Write_Command(pstChip, ((pstChip->u8Counter*2) & 0x0F)|0x40);

            /* Transfer display data */
            for (u8Index = 0U; u8Index < u8Len; u8Index++)
            {
                BU91R65_Write_Data(pstChip, u8Buffer[u8Index]);
            }
                
            BU91R65_Delay();
            pstChip->stPinMap.u16PinCS(1U);
            for (u8Index = 0U; u8Index < u8Len; u8Index++)
            {
                pstChip->u8BkupBuffer[pstChip->u8Counter] = pstChip->pu8UserBuffer[pstChip->u8Counter];
                pstChip->u8Counter++;
            }
        }
        if (pstChip->u8Counter >= BU91R65_BUFFER_SIZE)
        {
            pstChip->u8Counter  = 0U;
        }
        g_stBU91R65UpdateCtrl.pstCurrent = pstChip->pstNext;

    }
}

int32_t BU91R65_Write_Buffer(BU91R65_Handler_st_t *pHandler, uint8_t u8Index, uint8_t u8Val)
{
    int32_t i32Result;

    i32Result = -1;
    if ((pHandler != NULL) && (u8Index < BU91R65_BUFFER_SIZE))
    {
        if (pHandler->pu8UserBuffer != NULL)
        {
            pHandler->pu8UserBuffer[u8Index] = u8Val;

            i32Result = 0;
        }
    }
    
    return i32Result;
}

int32_t BU91R65_Write_SEG(BU91R65_Handler_st_t *pHandler, uint8_t u8Index, uint8_t u8Val)
{
    uint8_t  u8Checksum;
    uint8_t  u8Status;
    uint32_t u32Retry;
    int32_t  i32Result;

    i32Result = -1;
    // u8Status  = BU98R10_Get_Status(pHandler);
    if (u8Index < BU91R65_BUFFER_SIZE)
    {
        /* Device is ready */
        pHandler->pu8UserBuffer[u8Index] = u8Val;

        u32Retry = 0UL;
        do
        {
            u8Checksum = 0U;
            // BU98R10_Set_nCS(&(pHandler->stPinMap), 0U);
            pHandler->stPinMap.u16PinCS(0U);
            BU91R65_Delay();

            /* Set start address */
            BU91R65_Write_Command(pHandler, 0xE0);
            BU91R65_Write_Command(pHandler, ((u8Index*2) & 0xF0)>>4);
            BU91R65_Write_Command(pHandler, ((u8Index*2) & 0x0F)|0x40);

            /* Transfer display data */
            // BU91R65_Write_Command(pHandler, BU98R10_CMD_DATWR);
            BU91R65_Write_Data(pHandler, u8Val);
            
            BU91R65_Delay();
            // BU98R10_Set_nCS(&(pHandler->stPinMap), 1U);
            pHandler->stPinMap.u16PinCS(1U);

            u32Retry++;
        } while ((u32Retry < BU91R65_RETRY_MAX_NUM) && (i32Result != 0));

        if (i32Result == 0)
        {
            pHandler->u8BkupBuffer[u8Index] = u8Val;
        }
    }
    
    return i32Result;
}

static int32_t BU91R65_Search(BU91R65_Handler_st_t *pHandler)
{
    int32_t i32Result;
    BU91R65_Handler_st_t *pstSearch;

    if (pHandler != NULL)
    {
        i32Result = 0;
        pstSearch = g_stBU91R65UpdateCtrl.pstList;
        while ((pstSearch != NULL) && (i32Result == 0))
        {
            if (pstSearch == pHandler)
            {
                i32Result = 1;
            }
            else
            {
                pstSearch = pstSearch->pstNext;
            }
        }
    }
    else
    {
        i32Result = -1;
    }

    return i32Result;
}

static void BU91R65_Write_Command(BU91R65_Handler_st_t *pHandler, uint8_t u8Cmd)
{
    uint32_t i;

    if (pHandler != NULL)
    {
        // BU91R65_Delay();
        /* Default value of SCLK = 1 */
        // BU98R10_Set_SCLK(&(pHandler->stPinMap), 0U);       /* SCLK = 0 */
        // pHandler->stPinMap.u16PinSCLK(0U);
        // BU98R10_Set_SD(&(pHandler->stPinMap), 0U);         /* SD = 0, Command */
        // pHandler->stPinMap.u16PinSD(0U);
        // BU91R65_Delay();
        // BU98R10_Set_SCLK(&(pHandler->stPinMap), 1U);       /* SCLK = 1, Transfer bit */
        // pHandler->stPinMap.u16PinSCLK(1U);
        
        for (i = 0UL; i < 8UL; i++)
        {
            
            BU91R65_Delay();
            // BU98R10_Set_SCLK(&(pHandler->stPinMap), 0U);   /* SCLK = 0 */
            pHandler->stPinMap.u16PinSCLK(0U);

            if (u8Cmd & 0x80U)                            /* Load bit to MOSI */
            {
                // BU98R10_Set_SD(&(pHandler->stPinMap), 1U);
                pHandler->stPinMap.u16PinSD(1U);
            }
            else
            {
                // BU98R10_Set_SD(&(pHandler->stPinMap), 0U);
                pHandler->stPinMap.u16PinSD(0U);
            }
            u8Cmd <<= 1;

            BU91R65_Delay();

            // BU98R10_Set_SCLK(&(pHandler->stPinMap), 1U);   /* SCLK = 1, Transfer bit */
            pHandler->stPinMap.u16PinSCLK(1U);
        }
        // BU91R65_Delay();
    }
}

static void BU91R65_Write_Data(BU91R65_Handler_st_t *pHandler, uint8_t u8Data)
{
    uint32_t i;

    if (pHandler != NULL)
    {
        // BU91R65_Delay();
        /* Default value of SCLK = 1 */
        // BU98R10_Set_SCLK(&(pHandler->stPinMap), 0U);       /* SCLK = 0 */
        // pHandler->stPinMap.u16PinSCLK(0U);
        // BU98R10_Set_SD(&(pHandler->stPinMap), 0U);         /* SD = 0, Command */
        // pHandler->stPinMap.u16PinSD(0U);
        // BU91R65_Delay();
        // BU98R10_Set_SCLK(&(pHandler->stPinMap), 1U);       /* SCLK = 1, Transfer bit */
        // pHandler->stPinMap.u16PinSCLK(1U);
        
        for (i = 0UL; i < 8UL; i++)
        {
            
            BU91R65_Delay();
            // BU98R10_Set_SCLK(&(pHandler->stPinMap), 0U);   /* SCLK = 0 */
            pHandler->stPinMap.u16PinSCLK(0U);

            if (u8Data & 0x01U)                            /* Load bit to MOSI */
            {
                // BU98R10_Set_SD(&(pHandler->stPinMap), 1U);
                pHandler->stPinMap.u16PinSD(1U);
            }
            else
            {
                // BU98R10_Set_SD(&(pHandler->stPinMap), 0U);
                pHandler->stPinMap.u16PinSD(0U);
            }
            u8Data >>= 1;

            BU91R65_Delay();

            // BU98R10_Set_SCLK(&(pHandler->stPinMap), 1U);   /* SCLK = 1, Transfer bit */
            pHandler->stPinMap.u16PinSCLK(1U);
        }
        BU91R65_Delay();
    }
}


static void BU91R65_Delay_ms(uint32_t u32Interval)/*未调整*/
{
    u32Interval *= BU91R65_ms_DIV;
    while (u32Interval)
    {
        BU91R65_Delay();
        u32Interval--;
    }
}

static void BU91R65_Delay(void)
{
    g_u32BU91R65DelayCounter = g_stBU91R65UpdateCtrl.u32SpeedTrim;
    while(g_u32BU91R65DelayCounter)
    {
        WDT__Clear();
        g_u32BU91R65DelayCounter--;
    }
}
