#ifndef BU91R65_PORTING_H__
#define BU91R65_PORTING_H__

#include "TYW_stdint.h"
#include "GPIO.h"

#define BU91R65_CHIP0_SD 	LCD_SDI1_OUT  
#define BU91R65_CHIP0_CSB	LCD_CSB1 
#define BU91R65_CHIP0_SCL	LCD_SCK1 


#define BU91R65_CHIP1_SD 	LCD_SDI2_OUT
#define BU91R65_CHIP1_CSB	LCD_CSB2
#define BU91R65_CHIP1_SCL	LCD_SCK2

typedef void (*pfunBU91R65_Set_nCS)(uint8_t u8Level);
typedef void (*pfunBU91R65_Set_SCLK)(uint8_t u8Level);
typedef void (*pfunBU91R65_Set_SD)(uint8_t u8Level);
typedef struct 
{
    pfunBU91R65_Set_nCS  u16PinCS;        /**< Number of CSB pin */
    pfunBU91R65_Set_SCLK u16PinSCLK;      /**< Number of SCL pin */
    pfunBU91R65_Set_SD   u16PinSD;        /**< Number of SD pin */
    uint16_t u16Rsvd;
}BU91R65_Pin_Map_st_t;

#define   BU91R65_NOT_USED_PIN               (0xFFFFU)

extern int32_t BU91R65_GPIO_Init(BU91R65_Pin_Map_st_t *pstPinMap);
extern void BU91R65_Chip0_Set_nCS(uint8_t u8Level);
extern void BU91R65_Chip0_Set_SCLK(uint8_t u8Level);
extern void BU91R65_Chip0_Set_SD(uint8_t u8Level);
extern void BU91R65_Chip1_Set_nCS(uint8_t u8Level);
extern void BU91R65_Chip1_Set_SCLK(uint8_t u8Level);
extern void BU91R65_Chip1_Set_SD(uint8_t u8Level);

#endif /* BU98R10_PORTING_H__ */
