#ifndef CHECK_Ctrl_H
#define CHECK_Ctrl_H

#include "TYW_stdint.h"



#define  SV_DID  0xF1A0//诊断读 软件版本号的DID
#define  HV_DID  0xF191//诊断读 硬件版本号的DID
#define  PV_DID  0xF187//诊断读 零件号的DID
#define  DATE_DID  0xF18B//诊断读 制造日期的DID
#define  CODE_DID  0xF18A//诊断读 供应商代码的DID
#define  FUEL_DID  0x5008//诊断读 燃油阻值的DID

uint8_t Get_DID_High_Byte(uint16_t Input_DID);
uint8_t Get_DID_Low_Byte(uint16_t Input_DID);

typedef struct
{
    uint8_t LIN_LEFT_Flag;
    uint8_t LIN_RIGHT_Flag;
    uint8_t LIN_F_Right_Flag;
}LIN_Flag_T;


extern unsigned char InterNal_Version [ 128 ];
extern unsigned char SW_Version [ 128 ];
extern unsigned char HW_Version [ 128 ];
extern unsigned char Part_Version [ 128 ];
extern unsigned char Made_Date [ 128 ];
extern unsigned char SUPPLIER [ 128 ];
extern unsigned char Voltage_UDS [ 128 ];
extern unsigned char BCM_2014 [ 128 ];
extern unsigned char Risk_Evade [ 128 ];
extern unsigned char Evade_ODO  [ 128 ];
extern unsigned char Line_IN_St [ 128 ];
extern unsigned char Res_St [ 128 ];
extern unsigned int  LINE_IN_CHECK_BEGIN;
extern unsigned int  RES_CHECK_BEGIN;
extern unsigned int  TFT_CHECN_BEGIN;
extern unsigned int  LCD_CHECN_BEGIN;
extern unsigned int  VOICE_BACK_BEGIN;
extern unsigned int  VOICE_CHECK_BEGIN;
extern unsigned int  VOICE_CHECN_BEGIN;
extern unsigned int  MENU_CHECK_STEP;
extern unsigned int  UnLock_Flag;
extern unsigned int  Global_Session;
extern unsigned int  loc_Step;
extern unsigned char KEYBUFFER [ 4 ];
extern unsigned int  CAN_Msg_Tx_Enable;
extern uint8_t       loc_Type_back;
extern uint8_t       LED_Waring ;

void         SET_IPK_NONE(void);
void         Clear_IPK_NONE(void);
void         CHECK_IPK_COUNT(void);
void         HW_CHECK_IPK_EXIST(void);
unsigned int Get_IPK_Status(void);
void         Diag_Info_Init(void);
void         Total_Check(void);
void         HW_CHECK_Ctrl(unsigned int cmd);
void         MENU_CHECK_STEP_ADD(void);
void         MENU_CHECK_STEP_SUB(void);
void         HW_ODO_Clear(void);
void         MENU_CHECK_Init(void);
void         Req_To_Secure(void);
void         Read_IPK_Session_Type(void);

#endif
