#include "CAN_Communication_Matrix.h"
#include "CAN_APP.h"
#include "RSCAN.h"

/* 2022/11/19 14:29:55 */
st_CanMsgOp CAN_CH4_CanMsgOp;
st_CanMsgTxOp CAN_CH4_CanMsgTxOp;
#define CAN_CH4 &CAN_CH4_CanMsgOp

const st_CAN_SendAttribute    CAN_CH4_CANSendAttr[CAN_CH4_ID_SEND_TOTAL] =
{
    {0x200, 100ul*1000ul, 5ul, 0u, MSG_STD, RSCAN_CHANNEL_BUF_4, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_200, (void *)0},//车速
    {0x481, 500ul*1000ul, 10ul, 0u, MSG_STD, RSCAN_CHANNEL_BUF_5, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_481, (void *)0},//时间
    {0x020, 100ul*1000ul, 15ul, 0u, MSG_STD, RSCAN_CHANNEL_BUF_6, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_020, (void *)0},//电量
    {0x042, 10ul*1000ul, 20ul, 0u, MSG_STD, RSCAN_CHANNEL_BUF_7, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_042, (void *)0},//tcs
    {0x480, 500ul*1000ul, 25ul, 0u, MSG_STD, RSCAN_CHANNEL_BUF_8, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_480, (void *)0},//GPS,4G,电话，蓝牙指示灯
    {0x280, 100ul*1000ul, 30ul, 0u, MSG_STD, RSCAN_CHANNEL_BUF_9, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_280, (void *)0},//tcs，能量回收
    {0x202, 100ul*1000ul, 35ul, 0u, MSG_STD, RSCAN_CHANNEL_BUF_10, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_202, (void *)0},//档位，续航里程，ready
    {0x001, 100ul*1000ul, 40ul, 0u, MSG_STD, RSCAN_CHANNEL_BUF_11, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_001, (void *)0},//电机过热
    {0x021, 100ul*1000ul, 45ul, 0u, MSG_STD, RSCAN_CHANNEL_BUF_12, 8u, CAN_MSG_TX_CYCLE, Can_Set_Buff_021, (void *)0},//电池过热
};

const st_CANMsgAttribute CAN_CH4_CAN_MSG_CONST_ARRAY[CAN_CH4_ID_TOTAL_MAX] =
{
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x250ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x450ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x45l,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },

};

uint8_t  Co_Can_ConvertSubID_CAN_CH4(uint32_t MsgID)
{
    uint8_t u8Result = CAN_CH4_ID_TOTAL_MAX;
    switch (MsgID)
    {
    case CAN_CH4_ID_250_Msg_Count:
        u8Result = CAN_CH4_ID_250_Msg;
        break;
    case CAN_CH4_ID_450_Msg_Count:
        u8Result = CAN_CH4_ID_450_Msg;
    break;
    case CAN_CH4_ID_451_Msg_Count:
        u8Result = CAN_CH4_ID_451_Msg;
    break;

    default :
        u8Result = CAN_CH4_ID_TOTAL_MAX;
        break;
    }
    return u8Result;
}

