#include "COM_CAN.h"
#include "CAN_Communication_Matrix.h"
#include "RTE_CAN.h"
#include "TYW_stdint.h"
#include <string.h>

uint8_t SingleOrDouble_CAN = 0;

#pragma alignvar(8)
uint32_t pRXBuff_CH4[CAN_RX_MSG_Block * CAN_CH4_ID_TOTAL_MAX];
#pragma alignvar(8)
uint32_t pTXBuff[CAN_TX_MSG_Block * CAN_CH4_ID_SEND_TOTAL];

uint8_t COM_APP_Process(st_CAN_Msg *Msg);

void COM_CAN_Init(void)
{
    /*CAN APP BUFFER INIT*/
    memset(pRXBuff_CH4, 0, sizeof(pRXBuff_CH4));
    CAN_CH4_CanMsgOp.CAN_MSG_Analysis = pRXBuff_CH4;                           
    Can_RX_BuffInit(&CAN_CH4_CanMsgOp, CAN_CH4_CAN_MSG_CONST_ARRAY, CAN_CH4_ID_TOTAL_MAX); 

    memset(pTXBuff, 0, sizeof(pTXBuff));                                                       
    CAN_CH4_CanMsgTxOp.CanMsg = pTXBuff;                                                       
    Can_TX_BuffInit(&CAN_CH4_CanMsgTxOp, CAN_CH4_CANSendAttr, CAN_CH4_ID_SEND_TOTAL, COM_APP_Process); 


    CAN_RX_SetEnable(&CAN_CH4_CanMsgOp, CAN_N_RX_Enable);
    CAN_TX_SetEnable(&CAN_CH4_CanMsgTxOp, CAN_N_TX_Enable);
}

uint8_t COM_APP_Process(st_CAN_Msg *Msg)
{
    Can_Write((_CAN_Msg *)Msg);
    return 0u;
}

void COM_TX_Process(void)
{
    Can_Write_Fun(&CAN_CH4_CanMsgTxOp, 50000u);
}

void COM_RX_Process(void)
{
    CanMSg_XMS_Analysis(&CAN_CH4_CanMsgOp, 5u);
}

