

#ifdef        GLOBALS_APP_TEST
    #define   EXTERN_APP_TEST
    
#else
    #define   EXTERN_APP_TEST     extern
#endif

#ifndef APP_TEDT_H_
#define APP_TEDT_H_

#define Motorola                0
#define Intel                   1

#define Offset_Minus            0
#define Offset_Plus             1

#define Value_Minus             0
#define Value_Plus              1

typedef struct{
    unsigned int val;
    unsigned char fval;
}s_CurValue;

typedef struct{
    CAN_message *canMsg;
    unsigned char StartByte;
    unsigned char StartBit;
    unsigned char SignalLen;
    unsigned int  Offset;
    unsigned char fOffset;
    unsigned int Factor_1;/*Denominator of Resolution*/  /*���ȵķ�ĸ*/
    unsigned int Factor_2;/*Numerator of Resolution*/    /*���ȵķ���*/
    s_CurValue *CurValue; 
    unsigned char fFormat;
}s_CAN_List;

enum
{
    ENUM_VSpeed          = 0,//����
    ENUM_RSpeed          ,//�??�??
    ENUM_WaterTemp       ,//   温度
    TCS_Warning_Lamp   ,//前轮胎压
    TCS_Work_Mode   ,//后轮胎压
    ISG_Ready,
    ISG_Power,
    ISG_Power_Enable,
    
    ABS_Warning_Lamp,
    ECU_Warning_Lamp,
    CAN_List_Num        ,
};
                                                                                    
EXTERN_APP_TEST volatile s_CurValue CurValueStr[CAN_List_Num];

static const s_CAN_List CAN_List[] = 
{
    {&CanMsg_101, 2,  0,  8,    0,   Offset_Plus,    1,       1, &CurValueStr[ENUM_VSpeed         ], Motorola},
    {&CanMsg_101, 1,  0, 16,    0,   Offset_Plus,    100,    25, &CurValueStr[ENUM_RSpeed         ], Motorola},
    {&CanMsg_101, 5,  0, 16,  273,   Offset_Minus,    10,     1, &CurValueStr[ENUM_WaterTemp      ], Motorola},

    {&CanMsg_37B, 3,  2,  1,    0,   Offset_Plus,     1,    1, &CurValueStr[TCS_Warning_Lamp ], Motorola},
    {&CanMsg_37B, 3,  4,  4,    0,   Offset_Plus,     1,    1, &CurValueStr[TCS_Work_Mode  ], Motorola},

    {&CanMsg_111, 4,  1, 1,    0,   Offset_Plus,    1,    1, &CurValueStr[ISG_Ready         ], Motorola},
    {&CanMsg_111, 4,  2, 1,    0,   Offset_Plus,    1,    1, &CurValueStr[ISG_Power         ], Motorola},
    {&CanMsg_111, 4,  4, 2,      0,   Offset_Plus,    1,     1, &CurValueStr[ISG_Power_Enable      ], Motorola},

    {&CanMsg_12B, 4,  2, 2,      0,   Offset_Plus,    1,     1, &CurValueStr[ABS_Warning_Lamp      ], Motorola},

    {&CanMsg_402, 7,  7, 1,      0,   Offset_Plus,    1,     1, &CurValueStr[ECU_Warning_Lamp      ], Motorola},

};



extern unsigned int lost_flag;
extern unsigned int CAN_init_flag;
extern unsigned int water_value;
extern unsigned int count_flag_a;
extern unsigned int speed_value;
EXTERN_APP_TEST             void                APP_Button_Proc(void);
EXTERN_APP_TEST             void                Message_Value_Calculate(s_CAN_List list);

void Bits_Operation(CAN_message *Message, unsigned char StartByte, unsigned char StartBit, unsigned char Length, unsigned char Value);  /*Do not span bytes*/



#endif /* API_CAN_H_ */
