
//---------------------------------------------------------------------------
//  重定义保护
#ifndef __BSP_H__
#define __BSP_H__

//---------------------------------------------------------------------------
//  包含头文件
#include "r_typedefs.h"


//---------------------------------------------------------------------------
//  定义相关宏
//#define BSP_USER_DEBUG               1     //  是否开启调试功能
#define		HIGH_TEMP				 1		//   温度过高
#define		ROOM_TEMP				 0		//   恢复室温

#define BSP_POWER_ON                 1     //  开启电源
#define BSP_POWER_OFF                0     //  关闭电源
#define BSP_ENABLE                   1     //  使能
#define BSP_DISABLE                  0     //  关闭
#define BSP_LCD_RUN                  1     //  屏幕正常工作
#define BSP_LCD_RST                  0     //  屏幕复位
#define BSP_LCD_SLEEP                0     //  屏幕休眠

#define SET_96751_3G                0       //96751 3G
#define SET_96751_6G                1       //96751 6G

//---------------------------------------------------------------------------
//  导出函数

////---------------------------------------------------------------------------
//  清看门狗
void BSP_WDT_Clear(void);

//  屏幕电源使能
void BSP_GPIO_TFT_EN(int in);


//  96752 1V电源使能 
void BSP_GPIO_96751_1V_EN(int in);

//  96752 1V8电源使能 
void BSP_GPIO_96751_1V8_EN(int in);

//  96751 PDB
void BSP_GPIO_96751_PDB_EN(int in);

// 948_lock检测
int BSP_GPIO_Get_948_lock(void);

//  1ms定时器中断服务函数
void BSP_FTM0_IRQHandler(void);

//  延时指定的ms数
void BSP_Delay_ms(unsigned int in);

//  初始化PWM    频率10KHz
void BSP_PWM_Init(void);

//  串口0的打印
void uart1_printf(char *str, ...);

//  初始化串口
void BSP_InitUSART(void);

//  设置背光亮度 精度千分之一
void BSP_SetBL_Brightness_PWM(uint32_t in);

//  触摸屏外部中断
void BSP_TOUCH_IRQHandler(void);

//  返回触摸中断标志
uint8_t GET_TOUCH_IRQHandler_flag(void);

//  清除触摸中断标志
void Clear_TOUCH_IRQHandler_flag(void);

//  等待I2C1发送结束
void I2C1_Send_End(void);

//  I2C0初始化
void BSP_I2C0_INIT(void);

uint8_t gpio_get_key1(void);

uint8_t gpio_get_key2(void);

uint8_t gpio_get_key3(void);

uint8_t gpio_get_key4(void);

uint8_t gpio_get_key5(void);

uint8_t gpio_get_key6(void);

uint8_t gpio_get_touch_init(void);

uint8_t gpio_get_96751_lock(void);

//void init_96751(void);
void init_951(void);
//void switch_96751_3G_6G(uint8_t in);
void switch_951_init(void);
void switch_951_Color(uint8_t in);
void AIM951_i2c_send(uint8_t addr, uint8_t data);
void AIM951_i2c_sendreceive(uint8_t sendreceive_addr,uint8_t *receive_data);
void touch_IRQ_Enable(void);
#endif  //  __BSP_H__

