#include "common_include.h"
#include <math.h>
#include "api_adc.h"
#include "FuelConfig.h"


uint8_t CurIgnSt;
uint8_t LastCurIgnSt;
uint16_t CurIgnVoltage;
uint8_t LastIgnSt = 0;
uint16_t ThermistorValue; /*qitiancun 2018-9-10*/
uint16_t ThermistorList[ 5 ]; /*qitiancun 2018-9-10*/
uint16_t ThermistorCurValue; /*qitiancun 2018-9-10*/
uint16_t ThermistorIndex; /*qitiancun 2018-9-10*/

uint8_t AbnormalPowerCondition = ABNORMAL_POWER_CONDITION_NORMAL;

void ADCInit(void)
{
    InitADC();
  
    // stc_port_pin_config_t stc_port_pin_configadc = { 
    //     .enOutputFunction      = PortOutputResourceGPIO,
    //     .enPullResistor        = PortPullResistorNone,
    //     .bInputEnable          = TRUE,
    //     .enGpioDirection       = PortGpioInput};

    // //Quiescent Current ��̬����
    // Port_SetPinConfig(1, 3, &stc_port_pin_configadc );
    // InitADCch(Quiescent_Current);
    
    // //5V��׼
    // Port_SetPinConfig(1, 7, &stc_port_pin_configadc );
    // InitADCch(KL5V_AD_CH);
    
    // Port_SetPinConfig(1, 4, &stc_port_pin_configadc );         
    // InitADCch(KEY5_AD_CH);  
 
}

uint16_t FuelVrefAdBuf[5];
uint8_t FuelVrefAdIndex = 0;
uint16_t FuelAdBuf[5];
uint8_t FuelAdIndex = 0;
uint8_t FuelCalcTimerCnts = 0;
extern volatile uint8_t FuelSampleValid;
uint8_t IgnStateCount = 0;
uint32_t KL30StateCount = 0;
uint16_t CurBatteryVoltage = 0;

uint8_t RealAirBagV = 0;
uint8_t RealAirBagVLowCnts = 0;

void InputSingalHardLine(void)
{
  
}


void GetADCVolue(void) 
{
  /*
    Adc12b_TriggerConversion(&ADC12B0, TRIP_SW2_AD_CH);
    Adc12b_TriggerConversion(&ADC12B0, TRIP_SW1_AD_CH);
    Adc12b_TriggerConversion(&ADC12B0, KL15_AD_CH);
    Adc12b_TriggerConversion(&ADC12B0, AIR_BAG_AD_CH);
    Adc12b_TriggerConversion(&ADC12B0, DMS_UP_AD_CH);
    Adc12b_TriggerConversion(&ADC12B0, DMS_DOWN_AD_CH);
  */
    // Adc12b_TriggerConversion(&ADC12B0, Quiescent_Current); //��̬����
    // Adc12b_TriggerConversion(&ADC12B0, KL5V_AD_CH); //5V
    // Adc12b_TriggerConversion(&ADC12B0, KEY5_AD_CH); 
}

void App_SwapShort(uint16_t *pData1,uint16_t *pData2);
void App_SortShort(uint16_t *SortData,uint8_t len);
/*-------------------------------------------------------------------------
* Function Name  : App_SwapShort
* Description    : ��������
* Input          : None
* Output         : None
* Return         : None
* onther         : qitiancun 2018-9-10
--------------------------------------------------------------------------*/
void App_SwapShort(uint16_t *pData1,uint16_t *pData2)
{
    uint16_t psw;
    if((*pData1) > (*pData2))
    {
        psw = (*pData2);
        (*pData2) = (*pData1);
        (*pData1) = psw;
    }
}

/*-------------------------------------------------------------------------
* Function Name  : App_SortShort
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         : qitiancun 2018-9-10
--------------------------------------------------------------------------*/
void App_SortShort(uint16_t *SortData,uint8_t len)
{
    uint8_t n=0,m;
    for(;n<len-1;n++)
    {
        for(m = n+1;m < len;m++)
        {
            App_SwapShort((uint16_t *)(SortData + n),(uint16_t *)(SortData + m));
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : calculate_Thermistor
* Description   :
* Input      : None
* Output     : None
* Return     : None
* onther     : qitiancun 2018-9-10
--------------------------------------------------------------------------*/
uint16_t Calculate_Thermistor(uint16_t AdValue)
{ 
    uint32_t resistance = 0;
    
    ThermistorList[ ThermistorIndex ] = AdValue;
    ThermistorIndex ++;
   
    ThermistorIndex = (ThermistorIndex + 1) % 6;
    
    App_SortShort(ThermistorList,6);
    
    if((ThermistorCurValue > (ThermistorList[ 2 ] + 3)) || ((ThermistorCurValue + 3) < ThermistorList[ 2 ]))
    {
        ThermistorCurValue = ThermistorList[ 2 ] ;
    }
    /*
    ad        x
    _____ = _____
    4096    5 V
   
    x = 5*ad/4096
    */
    if(ThermistorCurValue)
    {
        resistance = ((500 * ThermistorCurValue)/4095);
    }
    else
    {
        resistance = 7851;
    }
      resistance = ( resistance);
      return ( uint16_t)(resistance);
}
