/******************************************************************************
* $Revision: 423 $
* $Date:: 2017-04-07 16:03:30 +0900#$
*****************************************************************************/
/* __DISCLAIMER_START__                                                      */
/******************************************************************************
* (c)2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ( "Software" ), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ( "EULA" ).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress' s
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ( "High Risk Product" ). By
* including Cypress' s product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/
/* __DISCLAIMER_END__                                                        */
/*****************************************************************************
** \file canfd_generated.c
**
** Generated file for canfd.c module, including variables and functions
** for internal data and interrupt handling. The individual ISRs for each
** peripheral are calling the generic handler in canfd.c.
**
** \note This file must not be added to the build files - it will be included
**       by canfd.c automatically!
**
** History:
**   - 2014-06-26  0.01  HS  Initial version for Traveo
*****************************************************************************/

#ifndef __CANFD_GENERATED_C__
#define __CANFD_GENERATED_C__

/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include <interrupts.h>

/*****************************************************************************/
/* Local pre-processor symbols/macros ('#define')                            */
/*****************************************************************************/

/** Macro to return the number of enabled CAN-FD instances */
#define CANFD_INSTANCE_COUNT (uint32_t)(sizeof(m_astcCanFDInstanceDataLut) / sizeof(m_astcCanFDInstanceDataLut[0]))

/*****************************************************************************/
/* Global variable definitions (declared in header file with 'extern')       */
/*****************************************************************************/


/*****************************************************************************/
/* Local type definitions ('typedef')                                        */
/*****************************************************************************/

/* Enumeration to define an index for each enabled CAN-FD instance */
typedef enum en_canfd_instance_index
{
#if (PDL_PERIPHERAL_ENABLE_CANFD0 == PDL_ON)
        CanFDInstanceIndexCanFD0,
#endif
#if (PDL_PERIPHERAL_ENABLE_CANFD1 == PDL_ON)
        CanFDInstanceIndexCanFD1,
#endif
#if (PDL_PERIPHERAL_ENABLE_CANFD2 == PDL_ON)
        CanFDInstanceIndexCanFD2,
#endif
#if (PDL_PERIPHERAL_ENABLE_CANFD3 == PDL_ON)
        CanFDInstanceIndexCanFD3,
#endif
    CanFDInstanceIndexMax
} en_canfd_instance_index_t;

/* CAN-FD instance data type */
typedef struct stc_canfd_instance_data
{
    pstc_canfd_type_t       pstcInstance;    /* pointer to registers of an instance */
    stc_canfd_intern_data_t stcInternData;   /* module internal data of instance */
} stc_canfd_instance_data_t;

/*****************************************************************************/
/* Local variable definitions ('static')                                     */
/*****************************************************************************/

/* Look-up table for all enabled CAN-FD instances and their internal data */
static stc_canfd_instance_data_t m_astcCanFDInstanceDataLut[] =
{
#if (PDL_PERIPHERAL_ENABLE_CANFD0 == PDL_ON)
    {
        CANFD0_Type,    /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_CANFD1 == PDL_ON)
    {
        CANFD1_Type,    /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_CANFD2 == PDL_ON)
    {
        CANFD2_Type,    /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_CANFD3 == PDL_ON)
    {
        CANFD3_Type,    /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
};

/*****************************************************************************/
/* Local function prototypes ('static')                                      */
/*****************************************************************************/

/*****************************************************************************/
/* Function implementation - global ('extern') and local ('static')          */
/*****************************************************************************/

/**
*****************************************************************************
** \brief Return the internal data for a certain CAN-FD instance.
**
** \param pstcCanFD Pointer to CAN-FD instance
**
** \return Pointer to internal data or NULL if instance is not enabled (or not known)
**
*****************************************************************************/
static stc_canfd_intern_data_t* CanFDGetInternDataPtr(pstc_canfd_type_t pstcCanFD)
{
    uint32_t u32Instance;
    
    for (u32Instance = 0; u32Instance < CANFD_INSTANCE_COUNT; u32Instance++)
    {
        if (pstcCanFD == m_astcCanFDInstanceDataLut[u32Instance].pstcInstance)
        {
            return &m_astcCanFDInstanceDataLut[u32Instance].stcInternData;
        }
    }
    
    return NULL;
}

/**
*****************************************************************************
** Definition of all individual ISRs for each enabled CAN-FD instance.
**
** The individual ISR calls the generic IRQ handler with
** the instance pointer and its internal data to handle the interrupt.
*****************************************************************************/

#if (PDL_PERIPHERAL_ENABLE_CANFD0 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(CanFD_Isr_CanFD0, INTERRUPTS_IRQ_NUMBER_40)
{
    CanFDIrqHandler(CANFD0_Type, &(m_astcCanFDInstanceDataLut[CanFDInstanceIndexCanFD0].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif
#if (PDL_PERIPHERAL_ENABLE_CANFD1 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(CanFD_Isr_CanFD1, INTERRUPTS_IRQ_NUMBER_41)
{
    CanFDIrqHandler(CANFD1_Type, &(m_astcCanFDInstanceDataLut[CanFDInstanceIndexCanFD1].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif
#if (PDL_PERIPHERAL_ENABLE_CANFD2 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(CanFD_Isr_CanFD2, INTERRUPTS_IRQ_NUMBER_42)
{
    CanFDIrqHandler(CANFD2_Type, &(m_astcCanFDInstanceDataLut[CanFDInstanceIndexCanFD2].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif
#if (PDL_PERIPHERAL_ENABLE_CANFD3 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(CanFD_Isr_CanFD3, INTERRUPTS_IRQ_NUMBER_43)
{
    CanFDIrqHandler(CANFD3_Type, &(m_astcCanFDInstanceDataLut[CanFDInstanceIndexCanFD3].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#endif  // __CANFD_GENERATED_C__

