#include "common_include.h"
#include "bsp_app_tft_output.h"

uint8_t g_uiTftNum = 0;
uint8_t g_uiTftIdx = 1;
uint8_t g_stDspTftNum = 0;
uint8_t g_uiDspInx = 0;
ST_FUNC_OUT g_stTftOut[TFT_MAX_NUM];
uint8_t g_szTftName[16];
uint8_t g_TestModeBackDoorFlag = 0;
uint8_t g_SEAT_BELT_Sound_Check = 0;
uint8_t g_SEAT_BELT_Count = 0;
extern uint16_t g_SEAT_BELT_Sound_time;
void DoorOpen_1_4_20()
{
#if (CAN_2ND)
    CGW1.msg.bits.CF_Gway_DrvDrSw = 0x1;
    CGW1.msg.bits.CF_Gway_AstDrSw = 0x1;
    CGW2.msg.bits.CF_Gway_RLDrSw = 0x1;
    CGW2.msg.bits.CF_Gway_RRDrSw = 0x1;
#endif
#if (CAN_3RD)  
    ICU_02_200ms.Warn_DrvDrSwSta = 0x1;
    ICU_02_200ms.Warn_AsstDrSwSta = 0x1;
    ICU_02_200ms.Warn_RrLftDrSwSta = 0x1;
    ICU_02_200ms.Warn_RrRtDrSwSta = 0x1;
#endif
}

void DoorOpen_1_4_9()
{
#if (CAN_2ND)
    CGW1.msg.bits.CF_Gway_TrunkTgSw = 0x1;
#endif
#if (CAN_3RD)  
    ICU_05_200ms.Trunk_TrnkTlgtSwSta = 0x1;
#endif
}

void DoorOpen_1_4_11()
{
#if (CAN_2ND)
    CGW1.msg.bits.CF_Gway_HoodSw = 0x1;
#endif
#if (CAN_3RD)  
    ICU_02_200ms.Warn_HoodSwSta = 0x1;
#endif
}

void PDW_LV1_3_12_1()
{
#if (CAN_2ND)
    PAS11.msg.bits.CF_Gway_PASSystemOn = 0x1;
    PAS11.msg.bits.CF_Gway_PASOption = 0x2;
    PAS11.msg.bits.CF_Gway_PASDisplayFLH = 0x1;
    PAS11.msg.bits.CF_Gway_PASDisplayFCTR = 0x1;
    PAS11.msg.bits.CF_Gway_PASDisplayFRH = 0x1;
    PAS11.msg.bits.CF_Gway_PASDisplayRLH = 0x1;
    PAS11.msg.bits.CF_Gway_PASDisplayRCTR = 0x1;
    PAS11.msg.bits.CF_Gway_PASDisplayRRH = 0x1;
    PAS11.msg.bits.CF_Gway_PASRsound = 1;
    PAS11.msg.bits.CF_Gway_PASCheckSound = 0x1;
#endif
#if (CAN_3RD)  
    BCM_05_200ms.PDW_SysOnSta =  0x1;
    BCM_05_200ms.PDW_OptTyp = 0x2;
    BCM_05_200ms.PDW_FrLftWrngLvlDis = 0x1;
    BCM_05_200ms.PDW_FrCtrWrngLvlDis= 0x1;
    BCM_05_200ms.PDW_FrRtWrngLvlDis= 0x1;
    
    BCM_06_200ms.PDW_RrLftWrngLvlDis = 0x1;
    BCM_06_200ms.PDW_RrCtrWrngLvlDis= 0x1;
    BCM_06_200ms.PDW_RrRtWrngLvlDis= 0x1;
        
    BCM_05_200ms.PDW_SysChkSndSta= 0x1;
    BCM_05_200ms.PDW_FrSnsrWrngLvlSta= 0x1;    
#endif
}
void PDW_LV2_3_12_2()
{
#if (CAN_2ND)
    PAS11.msg.bits.CF_Gway_PASSystemOn = 0x1;
    PAS11.msg.bits.CF_Gway_PASOption = 0x2;
    PAS11.msg.bits.CF_Gway_PASDisplayFLH = 0x2;
    PAS11.msg.bits.CF_Gway_PASDisplayFCTR = 0x2;
    PAS11.msg.bits.CF_Gway_PASDisplayFRH = 0x2;
    PAS11.msg.bits.CF_Gway_PASDisplayRLH = 0x2;
    PAS11.msg.bits.CF_Gway_PASDisplayRCTR = 0x2;
    PAS11.msg.bits.CF_Gway_PASDisplayRRH = 0x2;
    PAS11.msg.bits.CF_Gway_PASRsound = 2;
    PAS11.msg.bits.CF_Gway_PASCheckSound = 0x2;
#endif
#if (CAN_3RD)  
    BCM_05_200ms.PDW_SysOnSta =  0x1;
    BCM_05_200ms.PDW_OptTyp = 0x2;
    BCM_05_200ms.PDW_FrLftWrngLvlDis = 0x2;
    BCM_05_200ms.PDW_FrCtrWrngLvlDis= 0x2;
    BCM_05_200ms.PDW_FrRtWrngLvlDis= 0x2;
    
    BCM_06_200ms.PDW_RrLftWrngLvlDis = 0x2;
    BCM_06_200ms.PDW_RrCtrWrngLvlDis= 0x2;
    BCM_06_200ms.PDW_RrRtWrngLvlDis= 0x2;

    BCM_05_200ms.PDW_SysChkSndSta= 0x2;
    BCM_05_200ms.PDW_FrSnsrWrngLvlSta= 0x2;
#endif
}
void PDW_LV3_3_12_3()
{
#if (CAN_2ND)
    PAS11.msg.bits.CF_Gway_PASSystemOn = 0x1;
    PAS11.msg.bits.CF_Gway_PASOption = 0x2;
    PAS11.msg.bits.CF_Gway_PASDisplayFLH = 0x3;
    PAS11.msg.bits.CF_Gway_PASDisplayFCTR = 0x3;
    PAS11.msg.bits.CF_Gway_PASDisplayFRH = 0x3;
    PAS11.msg.bits.CF_Gway_PASDisplayRLH = 0x3;
    PAS11.msg.bits.CF_Gway_PASDisplayRCTR = 0x3;
    PAS11.msg.bits.CF_Gway_PASDisplayRRH = 0x3;
    PAS11.msg.bits.CF_Gway_PASRsound = 3;
    PAS11.msg.bits.CF_Gway_PASCheckSound = 0x3;
#endif
#if (CAN_3RD)  
    BCM_05_200ms.PDW_SysOnSta =  0x1;
    BCM_05_200ms.PDW_OptTyp = 0x2;
    BCM_05_200ms.PDW_FrLftWrngLvlDis = 0x3;
    BCM_05_200ms.PDW_FrCtrWrngLvlDis= 0x3;
    BCM_05_200ms.PDW_FrRtWrngLvlDis= 0x3;
    
    BCM_06_200ms.PDW_RrLftWrngLvlDis = 0x3;
    BCM_06_200ms.PDW_RrCtrWrngLvlDis= 0x3;
    BCM_06_200ms.PDW_RrRtWrngLvlDis= 0x3;

    BCM_05_200ms.PDW_SysChkSndSta= 0x3;
    BCM_05_200ms.PDW_FrSnsrWrngLvlSta= 0x3;
#endif
}
void Switch_P ()
{
#if (CAN_2ND)
    CGW2.msg.bits.CF_Gway_SMKDispWarn = 0xE;
#endif
#if (CAN_3RD)
    SMK_04_200ms.Warn_DisWrngSta = 0xE;
#endif
}
void SEA ()
{
#if (CAN_2ND)
    CGW6.msg.bits.CF_ICU_SeaWarn_Lh = 0x1;
    CGW6.msg.bits.CF_ICU_SeaWarn_Rh = 0x1;
#endif
#if (CAN_3RD)
    ICU_08_200ms.Warn_LftSEA = 0x1;
    ICU_08_200ms.Warn_RhtSEA = 0x1;
#endif
}

void ESC_OFF_Content ()
{
#if (CAN_2ND)
#endif
#if (CAN_3RD)
    ESC_01_10ms.ESC_OffTempSta = 0x1;
#endif
}

void SEAT_BELT_Sound ()
{
    switch (g_SEAT_BELT_Sound_Check)
    {
        case 0:
            g_SEAT_BELT_Count = 0;
            SendCanMessage250msTimer = Timer1msCnts;
            break;
        case 1:
//            SendCanMessage250msTimer = Timer1msCnts; 
            g_uiSeatBeltSoundTimer = 12;
            g_SEAT_BELT_Sound_Check = 2;
            break;
        case 2:
            if (g_uiSeatBeltSoundTimer == 0)
                g_SEAT_BELT_Sound_Check = 1;
            break;
    }
}

uint8_t g_uiPressOkRepeatTimes = 1;

void GetInTestMode()
{
#if ((PRO_SQFL) || (PRO_PDEPE2))
    SetPressKeySequence(KEY_15,
                        KEY_SW1_OK,
                        KEY_SW1_OK,
                        KEY_SW1_OK,
                        KEY_SW1_OK,
                        KEY_SW1_OK,
                        KEY_SW1_OK,
                        KEY_SW1_OK,
                        KEY_SW1_OK,
                        KEY_SW1_OK);
    DoPressKeySimulation(TIME_0);
#elif (PRO_NQ5C)
    if(JudgePartNum() == PartNum_NQ5C_Outlet){
        SetPressKeySequence(KEY_30,
                    KEY_SW1_OK,
                    KEY_SW1_OK,
                    KEY_SW1_OK,
                    KEY_SW1_OK,
                    KEY_SW1_OK,
                    KEY_SW1_OK,
                    KEY_SW1_OK,
                    KEY_SW1_OK,
                    KEY_SW1_OK);
        DoPressKeySimulation(TIME_0);
    } else if (JudgePartNum() == PartNum_NQ5C){

        g_TestModeBackDoorFlag = 1;
#if (CAN_2ND)
            CGW1.msg.bits.CF_Gway_DrvDrSw = 0x1;
#endif
#if (CAN_3RD)
            ICU_02_200ms.Warn_DrvDrSwSta = 0x1;
            BCM_03_200ms.SBR_StBltWrngBzrSta = 0x0;
#endif
        switch(TftCurrent.count){
            case 0:
                TftCurrent.enable = 1;
                TftCurrent.count = 1;
                break;
            case 1:
                SetPressKeySequence(KEY_30,
                                    KEY_SW1_OK,
                                    KEY_SW1_OK,
                                    KEY_SW1_OK,
                                    KEY_SW1_OK,
                                    KEY_SW1_OK,
                                    KEY_SW1_OK,
                                    KEY_SW1_OK,
                                    KEY_SW1_UP_LONG,
                                    KEY_NONE);
                DoPressKeySimulation(TIME_0);
                AfterTimeGoNext(&TftCurrent,8000);
                break;
            case 2:
                TftCurrent.enable = 0;
                TftCurrent.Time   = 0;
                break;
        }
    }
#elif ((PRO_NU2) || (PRO_CN7C) || (PRO_QYC))
    g_TestModeBackDoorFlag = 1;
#if (CAN_2ND)
            CGW1.msg.bits.CF_Gway_DrvDrSw = 0x1;
#endif
#if (CAN_3RD)
            ICU_02_200ms.Warn_DrvDrSwSta = 0x1;
            BCM_03_200ms.SBR_StBltWrngBzrSta = 0x0;
#endif
    switch(TftCurrent.count){
        case 0:
            TftCurrent.enable = 1;
            TftCurrent.count = 1;
            break;
        case 1:
            SetPressKeySequence(KEY_30,
                                KEY_SW1_OK,
                                KEY_SW1_OK,
                                KEY_SW1_OK,
                                KEY_SW1_OK,
                                KEY_SW1_OK,
                                KEY_SW1_OK,
                                KEY_SW1_OK,
                                KEY_SW1_UP_LONG,
                                KEY_NONE);
            DoPressKeySimulation(TIME_0);
            AfterTimeGoNext(&TftCurrent,8000);
            break;
        case 2:
            TftCurrent.enable = 0;
            TftCurrent.Time   = 0;
            break;
        }
#elif (PRO_DL3C)
    g_TestModeBackDoorFlag = 1;
#if (CAN_2ND)
            CGW1.msg.bits.CF_Gway_DrvDrSw = 0x1;
#endif
    switch(TftCurrent.count){
        case 0:
            TftCurrent.enable = 1;
            TftCurrent.count = 1;
            break;
        case 1:
            SetPressKeySequence(KEY_30,
                                KEY_SW1_OK,
                                KEY_SW1_OK,
                                KEY_SW1_OK,
                                KEY_SW1_OK,
                                KEY_SW1_OK,
                                KEY_SW1_OK,
                                KEY_SW1_OK,
                                KEY_SW1_UP_LONG,
                                KEY_NONE);
            DoPressKeySimulation(TIME_1000);
            AfterTimeGoNext(&TftCurrent,8000);
            break;
        case 2:
            TftCurrent.enable = 0;
            TftCurrent.Time   = 0;
            break;
        }      
#elif (PRO_NX4C)
    g_TestModeBackDoorFlag = 1;
#if (CAN_3RD)
            ICU_02_200ms.Warn_DrvDrSwSta = 0x1;
            BCM_03_200ms.SBR_StBltWrngBzrSta = 0x0;
#endif
    switch(TftCurrent.count){
        case 0:
            TftCurrent.enable = 1;
            TftCurrent.count = 1;
            break;
        case 1:
            SetPressKeySequence(KEY_30,
                                KEY_SW1_OK,
                                KEY_SW1_OK,
                                KEY_SW1_OK,
                                KEY_SW1_OK,
                                KEY_SW1_OK,
                                KEY_SW1_OK,
                                KEY_SW1_OK,
                                KEY_SW1_UP_LONG,
                                KEY_NONE);
            DoPressKeySimulation(TIME_1000);
            AfterTimeGoNext(&TftCurrent,8000);
            break;
        case 2:
            TftCurrent.enable = 0;
            TftCurrent.Time   = 0;
            break;
        }    
#endif    
}

void DspColor_White()
{
#if ((PRO_SQFL) || (PRO_PDEPE2))
    SetPressKeySequence(KEY_SW1_MENU,
                        KEY_SW1_DOWN,
                        KEY_SW1_DOWN,
                        KEY_SW1_OK,
                        KEY_SW1_OK,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE);
    DoPressKeySimulation(TIME_0);
#elif (PRO_NQ5C)
    if(JudgePartNum() == PartNum_NQ5C_Outlet){
        SetPressKeySequence(KEY_SW1_MENU,
                        KEY_SW1_DOWN,
                        KEY_SW1_DOWN,
                        KEY_SW1_OK,
                        KEY_SW1_OK,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE);
        DoPressKeySimulation(TIME_0);
    } else if (JudgePartNum() == PartNum_NQ5C){
        TftCurrent.count = 0;
        SetPressKeySequence(KEY_SW1_OK,
                            KEY_SW1_OK,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE);
        DoPressKeySimulation(TIME_0);
    }
#elif ((PRO_NX4C) || (PRO_NU2) || (PRO_CN7C) || (PRO_DL3C) || (PRO_QYC))
    TftCurrent.count = 0;
    SetPressKeySequence(KEY_SW1_OK,
                        KEY_SW1_OK,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE);
    DoPressKeySimulation(TIME_0);
#endif    
}

void DspColor_Black()
{
#if ((PRO_SQFL) || (PRO_PDEPE2))
    SetPressKeySequence(KEY_SW1_OK,
                        KEY_SW1_DOWN,
                        KEY_SW1_OK,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE);
    DoPressKeySimulation(TIME_0);
#elif (PRO_NQ5C)
    if(JudgePartNum() == PartNum_NQ5C_Outlet){
        SetPressKeySequence(KEY_SW1_OK,
                            KEY_SW1_DOWN,
                            KEY_SW1_OK,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE);
        DoPressKeySimulation(TIME_0);
    } else if (JudgePartNum() == PartNum_NQ5C){
        SetPressKeySequence(KEY_SW1_OK,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE);
        DoPressKeySimulation(TIME_0);
    }
#elif ((PRO_NX4C) || (PRO_NU2) || (PRO_CN7C) || (PRO_DL3C) || (PRO_QYC))
    SetPressKeySequence(KEY_SW1_OK,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE);
    DoPressKeySimulation(TIME_0);
#endif    
}

void DspColor_Red()
{
#if ((PRO_SQFL) || (PRO_PDEPE2))
    SetPressKeySequence(KEY_SW1_OK,
                        KEY_SW1_DOWN,
                        KEY_SW1_OK,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE);
    DoPressKeySimulation(TIME_0);
#elif (PRO_NQ5C)
    if(JudgePartNum() == PartNum_NQ5C_Outlet){
        SetPressKeySequence(KEY_SW1_OK,
                            KEY_SW1_DOWN,
                            KEY_SW1_OK,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE);
        DoPressKeySimulation(TIME_0);
    } else if (JudgePartNum() == PartNum_NQ5C){
        SetPressKeySequence(KEY_SW1_OK,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE);
        DoPressKeySimulation(TIME_0);
    }
#elif ((PRO_NX4C) || (PRO_NU2) || (PRO_CN7C) || (PRO_DL3C) || (PRO_QYC))
    SetPressKeySequence(KEY_SW1_OK,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE);
    DoPressKeySimulation(TIME_0);
#endif    
}

void DspColor_Green()
{
#if ((PRO_SQFL) || (PRO_PDEPE2))
    SetPressKeySequence(KEY_SW1_OK,
                        KEY_SW1_DOWN,
                        KEY_SW1_OK,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE);
    DoPressKeySimulation(TIME_0);
#elif (PRO_NQ5C)
    if(JudgePartNum() == PartNum_NQ5C_Outlet){
        SetPressKeySequence(KEY_SW1_OK,
                            KEY_SW1_DOWN,
                            KEY_SW1_OK,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE);
        DoPressKeySimulation(TIME_0);
    } else if (JudgePartNum() == PartNum_NQ5C){
        SetPressKeySequence(KEY_SW1_OK,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE);
        DoPressKeySimulation(TIME_0);
    }
#elif ((PRO_NX4C) || (PRO_NU2) || (PRO_CN7C) || (PRO_DL3C) || (PRO_QYC))
    SetPressKeySequence(KEY_SW1_OK,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE);
    DoPressKeySimulation(TIME_0);
#endif    
}

void DspColor_Blue()
{
#if ((PRO_SQFL) || (PRO_PDEPE2))
    SetPressKeySequence(KEY_SW1_OK,
                        KEY_SW1_DOWN,
                        KEY_SW1_OK,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE);
    DoPressKeySimulation(TIME_0);
#elif (PRO_NQ5C)
    if(JudgePartNum() == PartNum_NQ5C_Outlet){
        SetPressKeySequence(KEY_SW1_OK,
                            KEY_SW1_DOWN,
                            KEY_SW1_OK,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE);
        DoPressKeySimulation(TIME_0);
    } else if (JudgePartNum() == PartNum_NQ5C){
        SetPressKeySequence(KEY_SW1_OK,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE,
                            KEY_NONE);
        DoPressKeySimulation(TIME_0);
    }
#elif ((PRO_NX4C) || (PRO_NU2) || (PRO_CN7C) || (PRO_DL3C) || (PRO_QYC))
    SetPressKeySequence(KEY_SW1_OK,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE);
    DoPressKeySimulation(TIME_0);
#endif    
}

void GetOutTestMode()
{
    g_uiPressOkRepeatTimes = 1;
#if ((PRO_SQFL) || (PRO_PDEPE2))
    SetPressKeySequence(KEY_SW1_OK,
                        KEY_SW1_MENU,
                        KEY_SW1_UP,
                        KEY_SW1_UP,
                        KEY_15,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE);
    DoPressKeySimulation(TIME_0);
#elif (PRO_QYC)
     SetPressKeySequence(KEY_30,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE);
    DoPressKeySimulation(TIME_1000);
#elif ((PRO_NQ5C) || (PRO_NU2) || (PRO_CN7C) || (PRO_DL3C))
    SetPressKeySequence(KEY_30,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE);
    DoPressKeySimulation(TIME_0);
#elif (PRO_NX4C)
    SetPressKeySequence(KEY_30,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE,
                        KEY_NONE);
    DoPressKeySimulation(TIME_1000);
#endif    
}

void SetTftPos(uint8_t *pTftName,fpFunc pFun)
{
    if(pFun != NULL){
        memcpy(g_stTftOut[g_uiTftNum].szFuncName,pTftName,strlen((const char *)pTftName) > FuncNameSize ? FuncNameSize : strlen((const char *)pTftName));
        g_stTftOut[g_uiTftNum].uiIndex = g_uiTftIdx++;
        g_stTftOut[g_uiTftNum].pFunc = pFun;
        g_uiTftNum++;
    }
}

void InitTftOrder()
{
    if(g_uiTftNum > 0)
        return; 
    g_uiTftNum = 0;
    g_uiTftIdx = 1;
#if (PRO_CONFIG_CHECK_APPLY_TYPE1)
    SetTftPos("Door Open",             DoorOpen_1_4_20); 
    SetTftPos("Trunk Open",            DoorOpen_1_4_9);
    SetTftPos("Hood Open",             DoorOpen_1_4_11);
    SetTftPos("PDW Level 1",           PDW_LV1_3_12_1);
    SetTftPos("PDW Level 2",           PDW_LV2_3_12_2);
    SetTftPos("PDW Level 3",           PDW_LV3_3_12_3);
#if (PRO_NU2)
    SetTftPos("ESC_OFF_Content",      ESC_OFF_Content);
    SetTftPos("SEAT_BELT_Sound",      SEAT_BELT_Sound);
#endif
#if ((PRO_SP2C_PE) || (PRO_CN7C))
    SetTftPos("SEAT_BELT_Sound",      SEAT_BELT_Sound);
#endif
#elif (PRO_CONFIG_CHECK_APPLY_TYPE2)
    SetTftPos("Switch_P",                    Switch_P);
    SetTftPos("SEA",                              SEA);
#endif
#if (PRO_SQFL)
    SetTftPos("In Project Mode",       GetInTestMode);
    SetTftPos("Color White",           DspColor_White);
    SetTftPos("Color Black",           DspColor_Black);
    SetTftPos("Color Red",             DspColor_Red);
    SetTftPos("Color Green",           DspColor_Green);
    SetTftPos("Color Blue",            DspColor_Blue);
    SetTftPos("Out Project Mode",      GetOutTestMode);
#endif
#if (PRO_NQ5C)
    SetTftPos("In Project Mode",       GetInTestMode);
    SetTftPos("Color White",           DspColor_White);
    SetTftPos("Color Red",             DspColor_Red);
    SetTftPos("Color Green",           DspColor_Green);
    SetTftPos("Color Blue",            DspColor_Blue);
    SetTftPos("Color Black",           DspColor_Black);
    SetTftPos("Out Project Mode",      GetOutTestMode);
#endif
#if (PRO_NX4C)
    SetTftPos("In Project Mode",       GetInTestMode);
    SetTftPos("Color White",           DspColor_White);
    SetTftPos("Color Red",             DspColor_Red);
    SetTftPos("Color Green",           DspColor_Green);
    SetTftPos("Color Blue",            DspColor_Blue);
    SetTftPos("Color Black",           DspColor_Black);
    SetTftPos("Out Project Mode",      GetOutTestMode);
#endif
#if (PRO_NU2)
    if(GetCluType() == SVC_CFG){
        SetTftPos("In Project Mode",       GetInTestMode);
        SetTftPos("Color White",           DspColor_White);
        SetTftPos("Color Red",             DspColor_Red);
        SetTftPos("Color Green",           DspColor_Green);
        SetTftPos("Color Blue",            DspColor_Blue);
        SetTftPos("Color Black",           DspColor_Black);
        SetTftPos("Out Project Mode",      GetOutTestMode);
    }
#endif
#if (PRO_CN7C)
    if(GetCluType() == SVC_CFG){
        SetTftPos("In Project Mode",       GetInTestMode);
        SetTftPos("Color White",           DspColor_White);
        SetTftPos("Color Red",             DspColor_Red);
        SetTftPos("Color Green",           DspColor_Green);
        SetTftPos("Color Blue",            DspColor_Blue);
        SetTftPos("Color Black",           DspColor_Black);
        SetTftPos("Out Project Mode",      GetOutTestMode);
    }
#endif
#if (PRO_QYC)
    if(GetCluType() == SVC_CFG){
        SetTftPos("In Project Mode",       GetInTestMode);
        SetTftPos("Color White",           DspColor_White);
        SetTftPos("Color Red",             DspColor_Red);
        SetTftPos("Color Green",           DspColor_Green);
        SetTftPos("Color Blue",            DspColor_Blue);
        SetTftPos("Color Black",           DspColor_Black);
        SetTftPos("Out Project Mode",      GetOutTestMode);
    }
#endif
#if (PRO_DL3C)
  //  if(GetCluType() == SVC_CFG){
        SetTftPos("In Project Mode",       GetInTestMode);
        SetTftPos("Color White",           DspColor_White);
        SetTftPos("Color Red",             DspColor_Red);
        SetTftPos("Color Green",           DspColor_Green);
        SetTftPos("Color Blue",            DspColor_Blue);
        SetTftPos("Color Black",           DspColor_Black);
        SetTftPos("Out Project Mode",      GetOutTestMode);
 //   }
#endif
}



void APP_TFT_OUTPUT(void) //2020.6.10WH
{
    
// #if ((PRO_QXI) || (PRO_LX2) || (PRO_AX) || (PRO_QX23) || (PRO_BR2) || (PRO_US4) || (PRO_KS) || (PRO_NUPE) || (PRO_KU) || (PRO_NQ5C))//ִ
//     uint8_t uiModLv = 6;
// #elif ((PRO_SK3) || (PRO_SP2) || (PRO_KY) || (PRO_TAM) || (PRO_NQ5) || (PRO_ONPE) || (PRO_SG2) || (PRO_SP2C_PE))//
//     uint8_t uiModLv = 8;    
// #else
//     uint8_t uiModLv = 6;    
// #endif

// #if (CAN_2ND)
// uint16_t uiDelayTime = 3;
// #endif
// #if (CAN_3RD)
// uint16_t uiDelayTime = 1;
// #endif
//     Default_flag=0;
//     LampState_L.Lamps.RELAY_F1 = 0;                  // 
//     LampState_L.Lamps.RELAY_F2 = 0;
//     LampState_L.Lamps.RELAY_F3 = 0;
//     LampState_L.Lamps.RELAY_F4 = 1;
    if (g_TftCheckDeriction == 0) {
        PressKey(OKKeyCurrent.count,KEY_SW1_MENU,TRIPSW_SHORT_PRESS);
//         TFTCurrent.enable = 0;
//         if(TFTCurrent.count == 30 * 13)
//         {
//             TFTCurrent.statu = FINISH;
//         }
//         Send_7C6_Data.msg.bits.Byte0Data = 0x02;
//         Send_7C6_Data.msg.bits.Byte1Data = 0x10;
//         Send_7C6_Data.msg.bits.Byte2Data = 0x03;  
//         CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_42, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 3);
        
//         Delay(uiDelayTime);
//         Send_7C6_Data.msg.bits.Byte0Data = 0x04;
//         Send_7C6_Data.msg.bits.Byte1Data = 0x2F;
//         Send_7C6_Data.msg.bits.Byte2Data = 0xBF;  
//         Send_7C6_Data.msg.bits.Byte3Data = 0xFC;
//         Send_7C6_Data.msg.bits.Byte4Data = TFTCurrent.count % uiModLv;
//         CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_42, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 5);
//         Delay(uiDelayTime);
//         Send_7C6_Data.msg.bits.Byte0Data = 0x04;
//         Send_7C6_Data.msg.bits.Byte1Data = 0x2F;
//         Send_7C6_Data.msg.bits.Byte2Data = 0xBF;  
//         Send_7C6_Data.msg.bits.Byte3Data = 0xFD;
// #if (PRO_KU)
//         Send_7C6_Data.msg.bits.Byte4Data = TFTCurrent.count % 16;
// #else
//         Send_7C6_Data.msg.bits.Byte4Data = TFTCurrent.count % 13;
// #endif
//         CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_42, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 5);
//         Delay(uiDelayTime);
//         Send_7C6_Data.msg.bits.Byte0Data = 0x04;
//         Send_7C6_Data.msg.bits.Byte1Data = 0x2F;
//         Send_7C6_Data.msg.bits.Byte2Data = 0xBF;  
//         Send_7C6_Data.msg.bits.Byte3Data = 0xFF;
//         Send_7C6_Data.msg.bits.Byte4Data = TFTCurrent.count % 10;
//         CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_42, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 5);
//         Delay(uiDelayTime);
//         Send_7C6_Data.msg.bits.Byte0Data = 0x04;
//         Send_7C6_Data.msg.bits.Byte1Data = 0x2F;
//         Send_7C6_Data.msg.bits.Byte2Data = 0xBF;  
//         Send_7C6_Data.msg.bits.Byte3Data = 0xFE;
//         Send_7C6_Data.msg.bits.Byte4Data = TFTCurrent.count % 5;
//         CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_42, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 5);
//         Delay(uiDelayTime);
    }
    else if (g_TftCheckDeriction == 1) {
        PressKey(UPKeyCurrent.count,KEY_SW1_UP,TRIPSW_SHORT_PRESS);
        // for(int i = 0; i < g_uiTftNum; i++)
        // {
        //     if(TFTCurrent.count == g_stTftOut[i].uiIndex)
        //     {
        //         g_stTftOut[i].pFunc();
        //         strcpy(g_szTftName,g_stTftOut[i].szFuncName);
        //         break;
        //     }
        // }
    } 
}


