#ifndef __NM_CCAN_H__
#define __NM_CCAN_H__

#include "common_include.h"
    /*
    Active	
    //
    No		Time	ע
    1	IG On		OR
    2	IG OnOff	5	
    3	SleepMessage Event Wakeup	5	
    4	Gateway-Wake-Up Dest.-Yes Signal Value Change	5	   
    5	Battery Reset	5	
    6	Tail On(Telltale ON)		
    //
    Rx C Active	
    //
    No		Time	ע
    1	IG Off& Any Message& Active⣩	-	-
    //
    Sleep	IG Off & All Message Shut Off 
    */
    typedef struct
    {
        uint8_t  STATE_NO_1 :1; 
        uint8_t  STATE_NO_2 :1;
        uint8_t  STATE_NO_3 :1;
        uint8_t  STATE_NO_4 :1;
        uint8_t  STATE_NO_5 :1;
        uint8_t  STATE_NO_6 :1;
        uint8_t  STATE_Rsv  :2;
    }_NM_CCAN_ACTIVE_STATE;
    typedef struct
    {
        uint16_t  TIME_EN_NO_1 :1; 
        uint16_t  TIME_EN_NO_2 :1;
        uint16_t  TIME_EN_NO_3 :1;
        uint16_t  TIME_EN_NO_4 :1;
        uint16_t  TIME_EN_NO_5 :1;
        uint16_t  TIME_EN_NO_6 :1;
        uint16_t  TIME_EN_Rsv  :2;
        //
        uint16_t  TIME_NO_1    :16;
        uint16_t  TIME_NO_2    :16;
        uint16_t  TIME_NO_3    :16;
        uint16_t  TIME_NO_4    :16;
        uint16_t  TIME_NO_5    :16;
        uint16_t  TIME_NO_6    :16;
    }_NM_CCAN_ACTIVE_TIME;
    
    typedef struct
    {
         uint16_t  TIME_EN;
         uint16_t  TIME;
    }_NM_CCAN_RXACTIVE;
        
    typedef struct
    {
        uint8_t                 NM_CCAN_STATE;//0:Active 1:Rx Active 2:Sleep
        _NM_CCAN_ACTIVE_STATE   NM_CCAN_ACTIVE_STATE;
        _NM_CCAN_ACTIVE_TIME    NM_CCAN_ACTIVE_TIME;
        _NM_CCAN_RXACTIVE       NM_CCAN_RXACTIVE;                         
    }_NM_CCAN;

    extern  _NM_CCAN    g_NM_CCAN;
    
    void NM_CCAN_ACTIVE_INIT(void);
    void NM_CCAN_ACTIVE_PROC_NO_1_EN(void);
    void NM_CCAN_ACTIVE_PROC_NO_1_DIS(void);
    void NM_CCAN_ACTIVE_PROC_NO_2_EN(void);
    void NM_CCAN_ACTIVE_PROC_NO_2_DIS(void);
    void NM_CCAN_ACTIVE_PROC_NO_3_EN(void);
    void NM_CCAN_ACTIVE_PROC_NO_3_DIS(void);
    void NM_CCAN_ACTIVE_PROC_NO_4_EN(void);
    void NM_CCAN_ACTIVE_PROC_NO_4_DIS(void);
    void NM_CCAN_ACTIVE_PROC_NO_5_EN(void);
    void NM_CCAN_ACTIVE_PROC_NO_5_DIS(void);
    void NM_CCAN_ACTIVE_PROC_NO_6_EN(void);
    void NM_CCAN_ACTIVE_PROC_NO_6_DIS(void);
    void NM_CCAN_ACTIVE_PROC_ALL_DIS(void);
#endif