#include "mwwmhcomm.h"
#include "TYW_stdint.h"
#include "string.h"
#define MW_WMH_COMM_FRAME_CONVERT_COND(PORT_IDX, FRAME)     ((mwWMHCommFrameTimerCnts[PORT_IDX].LowLevelTime >= mwWMHCommSequentialParams[FRAME].LowerLimit.LowLevelTime) &&\
                                                        (mwWMHCommFrameTimerCnts[PORT_IDX].LowLevelTime <= mwWMHCommSequentialParams[FRAME].UpperLimit.LowLevelTime) &&\
                                                        (mwWMHCommFrameTimerCnts[PORT_IDX].HighLevelTime >= mwWMHCommSequentialParams[FRAME].LowerLimit.HighLevelTime) &&\
                                                        (mwWMHCommFrameTimerCnts[PORT_IDX].HighLevelTime <= mwWMHCommSequentialParams[FRAME].UpperLimit.HighLevelTime))


EM_WMH_COMM_FRAME_T mwWMHCommFrame[EM_WMH_COMM_PIN_TOTAL];

static const MW_WMH_COMM_SEQUENTIAL_T mwWMHCommSequentialParams[EM_WMH_COMM_FRAME_TOTAL] = {
    // EM_WMH_COMM_FRAME_STANDBAY
    {
        { 0xFFFFFFFF,    0xFFFFFFFF, },        // Standard
        { 0xFFFFFFFF,    0xFFFFFFFF, },        // UpperLimit
        { 0xFFFFFFFF,    0xFFFFFFFF, },        // LowerLimit
    },
#if 0
    // EM_WMH_COMM_FRAME_START
    {
        { 20000,    2000, },        // Standard
        { 20400,    2040, },        // UpperLimit
        { 19600,    1960, },        // LowerLimit
    }
    // EM_WMH_COMM_FRAME_LOGIC_1
    {
        { 500,      1500, },        // Standard
        { 510,      1530, },        // UpperLimit
        { 490,      1470, },        // LowerLimit
    }
    // EM_WMH_COMM_FRAME_LOGIC_0
    {
        { 1500,      500, },        // Standard
        { 1530,      510, },        // UpperLimit
        { 1470,      490, },        // LowerLimit
    }
    // EM_WMH_COMM_FRAME_STOP
    {
        { 5000,    50000, },        // Standard
        { 5100,    51000, },        // UpperLimit
        { 4900,    49000, },        // LowerLimit
    }
#else
    // EM_WMH_COMM_FRAME_START
    {
        { 20000,    2000, },        // Standard
        { 20400,    2200, },        // UpperLimit
        { 19600,    1800, },        // LowerLimit
    },
    // EM_WMH_COMM_FRAME_LOGIC_1
    {
        { 500,      1500, },        // Standard
        { 700,      1700, },        // UpperLimit
        { 300,      1300, },        // LowerLimit
    },
    // EM_WMH_COMM_FRAME_LOGIC_0
    {
        { 1500,      500, },        // Standard
        { 1700,      700, },        // UpperLimit
        { 1300,      300, },        // LowerLimit
    },
    // EM_WMH_COMM_FRAME_STOP
    {
        { 5000,    50000, },        // Standard
        { 5200,    51000, },        // UpperLimit
        { 4800,    49000, },        // LowerLimit
    },
#endif
};

MW_WMH_COMM_TIMER_T mwWMHCommFrameTimerCnts[EM_WMH_COMM_PIN_TOTAL] = {0};

#define MAX_SERIAL_BUFF_SIZE 64u
typedef struct {
    uint8_t Buffer[MAX_SERIAL_BUFF_SIZE];
    uint16_t OptCnts;
    uint16_t FillCnts;
    uint8_t  Byte;
    uint8_t  Bit;
    uint8_t  Valid;
} MW_WMH_COMM_SERIAL_BUFFER_T;
MW_WMH_COMM_SERIAL_BUFFER_T mwWMHCommSerialBuffer[EM_WMH_COMM_PIN_TOTAL];
// #if !(defined (__GNUG__) && defined (size_t))
// __MINGW_EXTENSION typedef __SIZE_TYPE__ size_t;
// void * memset(void * __dst, int __val, size_t __n)
// {
//   return __builtin___memset_chk(__dst, __val, __n, __mingw_bos(__dst, 0));
// }

void mwWMHCommInit(void)
{
    uint8_t i = 0;
    for (i = 0; i < EM_WMH_COMM_PIN_TOTAL; i++) {
        mwWMHCommFrame[i] = EM_WMH_COMM_FRAME_STANDBAY;
        mwWMHCommFrameTimerCnts[i].LowLevelTime = 0;
        mwWMHCommFrameTimerCnts[i].HighLevelTime = 0;
        for (int j = 0; j < MAX_SERIAL_BUFF_SIZE; j++) 
        {
            mwWMHCommSerialBuffer[i].Buffer[j] = 0;
        }
        mwWMHCommSerialBuffer[i].OptCnts = 0;
        mwWMHCommSerialBuffer[i].FillCnts = 0;
        mwWMHCommSerialBuffer[i].Byte = 0;
        mwWMHCommSerialBuffer[i].Bit = 0;
        mwWMHCommSerialBuffer[i].Valid = 0;
    }

}

void mwWMHCommRecvIsr_wibox(uint32_t tmpCnts)
{
    // uint16_t n = (uint16_t)EM_WMH_COMM_PIN_RX_ID_wibox;
    // auint8_t tmpVal = (uint8_t)(RTE_GPIO_Get_Level(RTE_GPIO_PORTB_PIN10));
    // if ((mwWMHCommSerialBuffer[n].Valid == 0)&&(mwWMHCommFrame[EM_WMH_COMM_PIN_TX_IDX] == EM_WMH_COMM_FRAME_STANDBAY)) {
    //     if (tmpVal == 0) {
    //         if (mwWMHCommFrameTimerCnts[n].HighLevelTime > 0) {
    //             mwWMHCommFrameTimerCnts[n].HighLevelTime = 0;
    //             mwWMHCommFrameTimerCnts[n].LowLevelTime = 0;
    //         }
    //         mwWMHCommFrameTimerCnts[n].LowLevelTime += tmpCnts;
    //         if (mwWMHCommFrameTimerCnts[n].LowLevelTime >= 50000) {
    //             mwWMHCommFrame[n] = EM_WMH_COMM_FRAME_STANDBAY;
    //             mwWMHCommSerialBuffer[n].Byte = 0;
    //             mwWMHCommSerialBuffer[n].Bit = 0;
    //             mwWMHCommFrameTimerCnts[n].LowLevelTime = 0;
    //             mwWMHCommFrameTimerCnts[n].HighLevelTime = 0;
    //         }
    //     } else {
    //         mwWMHCommFrameTimerCnts[n].HighLevelTime += tmpCnts;
    //         if (mwWMHCommFrameTimerCnts[n].HighLevelTime > 0) {
    //             if (mwWMHCommFrame[n] == EM_WMH_COMM_FRAME_STANDBAY) {
    //                 if (MW_WMH_COMM_FRAME_CONVERT_COND(n, EM_WMH_COMM_FRAME_START) != 0) {
    //                     mwWMHCommFrame[n] = EM_WMH_COMM_FRAME_START;
    //                     mwWMHCommSerialBuffer[n].Byte = 0;
    //                     mwWMHCommSerialBuffer[n].Bit = 0;
    //                     mwWMHCommFrameTimerCnts[n].LowLevelTime = 0;
    //                     mwWMHCommFrameTimerCnts[n].HighLevelTime = 0;
    //                 }
    //             } else if (mwWMHCommFrame[n] == EM_WMH_COMM_FRAME_START) {
    //                 if (MW_WMH_COMM_FRAME_CONVERT_COND(n, EM_WMH_COMM_FRAME_LOGIC_1) != 0) {
    //                     // mwWMHCommSerialBuffer[n].Byte = mwWMHCommSerialBuffer[n].Byte << 1;
    //                     mwWMHCommSerialBuffer[n].Byte |= (1u << mwWMHCommSerialBuffer[n].Bit);
    //                     mwWMHCommSerialBuffer[n].Bit++;
    //                     mwWMHCommFrameTimerCnts[n].LowLevelTime = 0;
    //                     mwWMHCommFrameTimerCnts[n].HighLevelTime = 0;
    //                 } else if (MW_WMH_COMM_FRAME_CONVERT_COND(n, EM_WMH_COMM_FRAME_LOGIC_0) != 0) {
    //                     // mwWMHCommSerialBuffer[n].Byte = mwWMHCommSerialBuffer[n].Byte << 1;
    //                     mwWMHCommSerialBuffer[n].Byte &= ~(1u << mwWMHCommSerialBuffer[n].Bit);
    //                     mwWMHCommSerialBuffer[n].Bit++;
    //                     mwWMHCommFrameTimerCnts[n].LowLevelTime = 0;
    //                     mwWMHCommFrameTimerCnts[n].HighLevelTime = 0;
    //                 } else if (mwWMHCommFrameTimerCnts[n].HighLevelTime >= 50000) {
    //                     mwWMHCommFrame[n] = EM_WMH_COMM_FRAME_STANDBAY;
    //                     mwWMHCommSerialBuffer[n].Valid = 1;
    //                     mwWMHCommSerialBuffer[n].Byte = 0;
    //                     mwWMHCommSerialBuffer[n].Bit = 0;
    //                     mwWMHCommFrameTimerCnts[n].LowLevelTime = 0;
    //                     mwWMHCommFrameTimerCnts[n].HighLevelTime = 0;
    //                 } else {
    //                     ;
    //                 }
    //                 if (mwWMHCommSerialBuffer[n].Bit >= 8) {
    //                     mwWMHCommSerialBuffer[n].Bit = 0;
    //                     // Receive One Byte
    //                     mwWMHCommRecvByte_wibox(mwWMHCommSerialBuffer[n].Byte);
    //                     mwWMHCommSerialBuffer[n].Byte = 0;
    //                 }
    //             }
    //         }
    //     }
    // }
}
void mwWMHCommRecvIsr_0x90(uint32_t tmpCnts)
{
    // uint16_t n = (uint16_t)EM_WMH_COMM_PIN_RX_ID_0x90;
    // uint8_t tmpVal = (uint8_t)(RTE_GPIO_Get_Level(RTE_GPIO_PORTB_PIN15));
    // if (mwWMHCommSerialBuffer[n].Valid == 0) {
    //     if (tmpVal == 0) {
    //         if (mwWMHCommFrameTimerCnts[n].HighLevelTime > 0) {
    //             mwWMHCommFrameTimerCnts[n].HighLevelTime = 0;
    //             mwWMHCommFrameTimerCnts[n].LowLevelTime = 0;
    //         }
    //         mwWMHCommFrameTimerCnts[n].LowLevelTime += tmpCnts;
    //         if (mwWMHCommFrameTimerCnts[n].LowLevelTime >= 50000) {
    //             mwWMHCommFrame[n] = EM_WMH_COMM_FRAME_STANDBAY;
    //             mwWMHCommSerialBuffer[n].Byte = 0;
    //             mwWMHCommSerialBuffer[n].Bit = 0;
    //             mwWMHCommFrameTimerCnts[n].LowLevelTime = 0;
    //             mwWMHCommFrameTimerCnts[n].HighLevelTime = 0;
    //         }
    //     } else {
    //         mwWMHCommFrameTimerCnts[n].HighLevelTime += tmpCnts;
    //         if (mwWMHCommFrameTimerCnts[n].HighLevelTime > 0) {
    //             if (mwWMHCommFrame[n] == EM_WMH_COMM_FRAME_STANDBAY) {
    //                 if (MW_WMH_COMM_FRAME_CONVERT_COND(n, EM_WMH_COMM_FRAME_START) != 0) {
    //                     mwWMHCommFrame[n] = EM_WMH_COMM_FRAME_START;
    //                     mwWMHCommSerialBuffer[n].Byte = 0;
    //                     mwWMHCommSerialBuffer[n].Bit = 0;
    //                     mwWMHCommFrameTimerCnts[n].LowLevelTime = 0;
    //                     mwWMHCommFrameTimerCnts[n].HighLevelTime = 0;
    //                 }
    //             } else if (mwWMHCommFrame[n] == EM_WMH_COMM_FRAME_START) {
    //                 if (MW_WMH_COMM_FRAME_CONVERT_COND(n, EM_WMH_COMM_FRAME_LOGIC_1) != 0) {
    //                     // mwWMHCommSerialBuffer[n].Byte = mwWMHCommSerialBuffer[n].Byte << 1;
    //                     mwWMHCommSerialBuffer[n].Byte |= (1u << mwWMHCommSerialBuffer[n].Bit);
    //                     mwWMHCommSerialBuffer[n].Bit++;
    //                     mwWMHCommFrameTimerCnts[n].LowLevelTime = 0;
    //                     mwWMHCommFrameTimerCnts[n].HighLevelTime = 0;
    //                 } else if (MW_WMH_COMM_FRAME_CONVERT_COND(n, EM_WMH_COMM_FRAME_LOGIC_0) != 0) {
    //                     // mwWMHCommSerialBuffer[n].Byte = mwWMHCommSerialBuffer[n].Byte << 1;
    //                     mwWMHCommSerialBuffer[n].Byte &= ~(1u << mwWMHCommSerialBuffer[n].Bit);
    //                     mwWMHCommSerialBuffer[n].Bit++;
    //                     mwWMHCommFrameTimerCnts[n].LowLevelTime = 0;
    //                     mwWMHCommFrameTimerCnts[n].HighLevelTime = 0;
    //                 } else if (mwWMHCommFrameTimerCnts[n].HighLevelTime >= 50000) {
    //                     mwWMHCommFrame[n] = EM_WMH_COMM_FRAME_STANDBAY;
    //                     mwWMHCommSerialBuffer[n].Valid = 1;
    //                     mwWMHCommSerialBuffer[n].Byte = 0;
    //                     mwWMHCommSerialBuffer[n].Bit = 0;
    //                     mwWMHCommFrameTimerCnts[n].LowLevelTime = 0;
    //                     mwWMHCommFrameTimerCnts[n].HighLevelTime = 0;
    //                 } else {
    //                     ;
    //                 }
    //                 if (mwWMHCommSerialBuffer[n].Bit >= 8) {
    //                     mwWMHCommSerialBuffer[n].Bit = 0;
    //                     // Receive One Byte
    //                     mwWMHCommRecvByte_0x90(mwWMHCommSerialBuffer[n].Byte);
    //                     mwWMHCommSerialBuffer[n].Byte = 0;
    //                 }
    //             }
    //         }
    //     }
    // }
}

void mwWMHCommSendIsr(uint32_t tmpCnts)
{
    // uint16_t n = (uint16_t)EM_WMH_COMM_PIN_TX_IDX;
    // EM_WMH_COMM_FRAME_T tmpFrame = mwWMHCommFrame[n];
    // if (mwWMHCommFrame[EM_WMH_COMM_PIN_RX_ID_wibox] == EM_WMH_COMM_FRAME_STANDBAY){
    //     switch (tmpFrame) {
    //         case EM_WMH_COMM_FRAME_STANDBAY: {
    //             if (mwWMHCommSerialBuffer[n].OptCnts != mwWMHCommSerialBuffer[n].FillCnts) {
    //                 mwWMHCommFrame[n] = EM_WMH_COMM_FRAME_START;
    //                 mwWMHCommSerialBuffer[n].Byte = mwWMHCommSerialBuffer[n].Buffer[mwWMHCommSerialBuffer[n].OptCnts++];
    //                 mwWMHCommSerialBuffer[n].OptCnts = mwWMHCommSerialBuffer[n].OptCnts % MAX_SERIAL_BUFF_SIZE;
    //                 //RTE_GPIO_Config(RTE_GPIO_PORTB_PIN11, GpioOut_Low); 
    //                 GPIOB->PBSC = (1 << (11 + 16));
    //                 //PORT_ClrBit(GpioMapData[mwWMHCommPin[n]].IoPara.McuIo.pinGroup, GpioMapData[mwWMHCommPin[n]].IoPara.McuIo.pinNum);
    //             }
    //         }break;

    //         case EM_WMH_COMM_FRAME_START:
    //         case EM_WMH_COMM_FRAME_LOGIC_1:
    //         case EM_WMH_COMM_FRAME_LOGIC_0: 
    //         case EM_WMH_COMM_FRAME_STOP: {
    //             if (mwWMHCommFrameTimerCnts[n].LowLevelTime < mwWMHCommSequentialParams[tmpFrame].Standard.LowLevelTime) {
    //                 //RTE_GPIO_Config(RTE_GPIO_PORTB_PIN11, GpioOut_Low); 
    //                 GPIOB->PBSC = (1 << (11 + 16));
    //                 //PORT_ClrBit(GpioMapData[mwWMHCommPin[n]].IoPara.McuIo.pinGroup, GpioMapData[mwWMHCommPin[n]].IoPara.McuIo.pinNum);
    //                 mwWMHCommFrameTimerCnts[n].LowLevelTime += tmpCnts;
    //                 if (mwWMHCommFrameTimerCnts[n].LowLevelTime >= mwWMHCommSequentialParams[tmpFrame].Standard.LowLevelTime) {
    //                     GPIOB->PBSC = (1 << 11);
    //                     //RTE_GPIO_Config(RTE_GPIO_PORTB_PIN11, GpioOut_High); 
    //                     //PORT_SetBit(GpioMapData[mwWMHCommPin[n]].IoPara.McuIo.pinGroup, GpioMapData[mwWMHCommPin[n]].IoPara.McuIo.pinNum);
    //                 }
    //             } else if (mwWMHCommFrameTimerCnts[n].HighLevelTime < mwWMHCommSequentialParams[tmpFrame].Standard.HighLevelTime) {
    //                 //RTE_GPIO_Config(RTE_GPIO_PORTB_PIN11, GpioOut_High); 
    //                 GPIOB->PBSC = (1 << 11);
    //                 //PORT_SetBit(GpioMapData[mwWMHCommPin[n]].IoPara.McuIo.pinGroup, GpioMapData[mwWMHCommPin[n]].IoPara.McuIo.pinNum);
    //                 mwWMHCommFrameTimerCnts[n].HighLevelTime += tmpCnts;
    //                 if (mwWMHCommFrameTimerCnts[n].HighLevelTime >= mwWMHCommSequentialParams[tmpFrame].Standard.HighLevelTime) {
    //                     mwWMHCommFrameTimerCnts[n].LowLevelTime = 0;
    //                     mwWMHCommFrameTimerCnts[n].HighLevelTime = 0;
    //                     if (tmpFrame != EM_WMH_COMM_FRAME_STOP) {
    //                         //RTE_GPIO_Config(RTE_GPIO_PORTB_PIN11, GpioOut_Low); 
    //                         GPIOB->PBSC = (1 << (11 + 16));
    //                         //PORT_ClrBit(GpioMapData[mwWMHCommPin[n]].IoPara.McuIo.pinGroup, GpioMapData[mwWMHCommPin[n]].IoPara.McuIo.pinNum);
    //                         if (mwWMHCommSerialBuffer[n].Bit >= 8) {
    //                             mwWMHCommSerialBuffer[n].Bit = 0;
    //                             if (mwWMHCommSerialBuffer[n].OptCnts != mwWMHCommSerialBuffer[n].FillCnts) {
    //                                 mwWMHCommSerialBuffer[n].Byte = mwWMHCommSerialBuffer[n].Buffer[mwWMHCommSerialBuffer[n].OptCnts++];
    //                                 mwWMHCommSerialBuffer[n].OptCnts = mwWMHCommSerialBuffer[n].OptCnts % MAX_SERIAL_BUFF_SIZE;
    //                             } else {
    //                                 mwWMHCommFrame[n] = EM_WMH_COMM_FRAME_STOP;
    //                                 mwWMHCommSerialBuffer[n].Valid = 0;
    //                                 //RTE_GPIO_Config(RTE_GPIO_PORTB_PIN11, GpioOut_Low); 
    //                                 GPIOB->PBSC = (1 << (11 + 16));
    //                                 //PORT_ClrBit(GpioMapData[mwWMHCommPin[n]].IoPara.McuIo.pinGroup, GpioMapData[mwWMHCommPin[n]].IoPara.McuIo.pinNum);
    //                             }
    //                         }
    //                         if (mwWMHCommSerialBuffer[n].Valid != 0) {
    //                             if ((mwWMHCommSerialBuffer[n].Byte & 0x01) != 0) {
    //                                 mwWMHCommFrame[n] = EM_WMH_COMM_FRAME_LOGIC_1;
    //                             } else {
    //                                 mwWMHCommFrame[n] = EM_WMH_COMM_FRAME_LOGIC_0;
    //                             }
    //                             mwWMHCommSerialBuffer[n].Byte = ((mwWMHCommSerialBuffer[n].Byte >> 1) & 0x7Fu);
    //                             mwWMHCommSerialBuffer[n].Bit++;
    //                         }
    //                     } else {
    //                         //RTE_GPIO_Config(RTE_GPIO_PORTB_PIN11, GpioOut_High); 
    //                         GPIOB->PBSC = (1 << 11);
    //                         //PORT_SetBit(GpioMapData[mwWMHCommPin[n]].IoPara.McuIo.pinGroup, GpioMapData[mwWMHCommPin[n]].IoPara.McuIo.pinNum);
    //                         mwWMHCommFrame[n] = EM_WMH_COMM_FRAME_STANDBAY;
    //                     }
    //                 }
    //             }
    //         }break;
            
    //         default: {
    //             GPIOB->PBSC = (1 << 11);
    //             //PORT_SetBit(GpioMapData[n].IoPara.McuIo.pinGroup, GpioMapData[n].IoPara.McuIo.pinNum);
    //             mwWMHCommFrame[n] = EM_WMH_COMM_FRAME_STANDBAY;
    //         }break;
    //     }
    // } else {
    //     mwWMHCommFrameTimerCnts[n].LowLevelTime = 0;
    //     mwWMHCommFrameTimerCnts[n].HighLevelTime = 0;
    // }
}

void mwWMHCommTransmitBytes(uint8_t *data, uint32_t length)
{
    uint32_t i = 0;
    uint16_t n = (uint16_t)EM_WMH_COMM_PIN_TX_IDX;
    if ((length > 0) && (mwWMHCommSerialBuffer[n].Valid == 0)) {
        for (i = 0; i < length; i++) {
            mwWMHCommSerialBuffer[n].Buffer[mwWMHCommSerialBuffer[n].FillCnts++] = data[i];
            mwWMHCommSerialBuffer[n].FillCnts = mwWMHCommSerialBuffer[n].FillCnts % MAX_SERIAL_BUFF_SIZE;
        }
        mwWMHCommSerialBuffer[n].Valid = 1;
    }
}

void mwWMHCommRecvByte_0x90(uint8_t data)
{
    uint16_t n = (uint16_t)EM_WMH_COMM_PIN_RX_ID_0x90;
    mwWMHCommSerialBuffer[n].Buffer[mwWMHCommSerialBuffer[n].FillCnts++] = data;
    mwWMHCommSerialBuffer[n].FillCnts = mwWMHCommSerialBuffer[n].FillCnts % MAX_SERIAL_BUFF_SIZE;
}
void mwWMHCommRecvByte_wibox(uint8_t data)
{
    uint16_t n = (uint16_t)EM_WMH_COMM_PIN_RX_ID_wibox;
    mwWMHCommSerialBuffer[n].Buffer[mwWMHCommSerialBuffer[n].FillCnts++] = data;
    mwWMHCommSerialBuffer[n].FillCnts = mwWMHCommSerialBuffer[n].FillCnts % MAX_SERIAL_BUFF_SIZE;
}
uint8_t *mwWMHCommGetRecvData(uint32_t *BufferLen, uint32_t *RecvPos)
{
    uint8_t *ret = NULL_P;
    uint16_t n1 = (uint16_t)EM_WMH_COMM_PIN_RX_ID_0x90;
    uint16_t n2 = (uint16_t)EM_WMH_COMM_PIN_RX_ID_wibox;

    if (mwWMHCommSerialBuffer[n1].Valid == 1) {
        *BufferLen = MAX_SERIAL_BUFF_SIZE;
        *RecvPos = mwWMHCommSerialBuffer[n1].FillCnts;
        ret = mwWMHCommSerialBuffer[n1].Buffer;
        mwWMHCommSerialBuffer[n1].Valid = 0;
    }

    if (mwWMHCommSerialBuffer[n2].Valid == 1) {
        *BufferLen = MAX_SERIAL_BUFF_SIZE;
        *RecvPos = mwWMHCommSerialBuffer[n2].FillCnts;
        ret = mwWMHCommSerialBuffer[n2].Buffer;
        mwWMHCommSerialBuffer[n2].Valid = 0;
    }
    return ret;
}


