/***********************************************************************
 * \file     Init.c
 * \brief    Initializations during work state switching
 * \details
 * \author   Zhang Xuan
 * \version  V1.0.0
 * \date     18-Jan-2019
 * \par      History:
 *           V1.0.0 Initial release
 * \par      Copyright:
 *           (c) Heilongjiang TYW Electronics co., LTD
 ******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "r_device.h"
#include "rh850_macros.h"
#include "init.h"
#include "clock.h"
#include "Sys_Tick.h"
#include "Task_Scheduler.h"
#include "RTE_GPIO.h"
#include "TYW_stdint.h"
#include "COM_CAN.h"
#include "RTE_ADC.h"
#include "RTE_CAN.h"
#include "RTE_PWM.h"
#include "Internal_EEPROM.h"
#include "TimerB.h"
#include "Analog_Signals.h"
#include "RSCAN.h"
#include "WDT.h"
#include "RTC.h"
#include "GenDelay.h"
#include "TFT_LCD.h"
#include "RTE_WDT.h"
#include "CAN_Communication_Matrix.h"
#include "Check_Ctrl.h"
#include "Key.h"
#include "Display_Info.h"
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/***********************************************************************
 * \brief      Initializations during work state switching
 * \attention
 * \retval     None
 ******************************************************************************/

// volatile CANMsg0F6Union      CANMsg0F6;

uint8_t u8StartupMode;
void    Sys_Startup_Pre_Init(void)
{
    Clock_Run_Mode_Init( );
}
/***********************************************************************
 * \brief      Initializations during system power up
 * \attention
 * \retval     None
 ******************************************************************************/

void Sys_Startup_Init(void)
{
    RTC_Pre_Init( );    //首次上电
    WDT_Init( );
    Sys_Tick_Timer_Call_Back_Reg(Sys_Process_ISR);
    RTE_GPIO_Init( );  

    GPIO_SET_KEPP( );
    RTE_ADC_Init( );
    COM_CAN_Init( );
    Can_Init( );
    enable_interrupt( );
    Sys_Tick_Timer_Start( );
    TFT_LCD_Startup( );
    Diag_Info_Init( );
    Display_Title_Info( );
    Key_Init( );
    Buzzer_Init();
    POWER_CTRL_KL30   = 0u;  //B+
    POWER_CTRL_KL15   = 0u;  //KL15
    MENU_CHECK_STEP = 14;
}

/***********************************************************************
 * \brief      Initializations during work state switch to system sleep
 * \attention
 * \retval     None
 ******************************************************************************/
void Sys_Sleep_Init(void)
{
}

/***********************************************************************
 * \brief      Initializations during work state switch to system run
 * \attention
 * \retval     None
 ******************************************************************************/
void System_Wakeup_Init(void)
{
}
