/*********************************************************************************************************************
 * File Name     : $Source: eel_descriptor.h $
 * Mod. Revision : $Revision: 1.8 $
 * Mod. Date     : $Date: 2014/09/10 18:54:32JST $
 * Device(s)     : RV40 Flash based RH850 microcontroller
 * Description   : EEL run-time configuration descriptor variable related defines. 
 *                 To be configured according to the application needs
 *********************************************************************************************************************/

/*********************************************************************************************************************
 * DISCLAIMER 
 * This software is supplied by Renesas Electronics Corporation and is only  intended for use with Renesas products. 
 * No other uses are authorized. This software is owned by Renesas Electronics Corporation and is protected under all 
 * applicable laws, including copyright laws. 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING THIS SOFTWARE, WHETHER EXPRESS, IMPLIED 
 * OR STATUTORY, INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED. 
 * TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS ELECTRONICS CORPORATION NOR ANY OF ITS 
 * AFFILIATED COMPANIES SHALL BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR ANY 
 * REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH 
 * DAMAGES.
 * Renesas reserves the right, without notice, to make changes to this software and to discontinue the availability of 
 * this software. By using this software, you agree to the additional terms and conditions found by accessing the
 * following link: 
 * http://www.renesas.com/disclaimer 
 * 
 * Copyright (C) 2014 Renesas Electronics Corporation. All rights reserved.     
 *********************************************************************************************************************/


#ifndef R_EEL_DESCRIPTOR_H
#define R_EEL_DESCRIPTOR_H

    #include "Internal_EEPROM.h"
/*********************************************************************************************************************
 * User changable section
 *********************************************************************************************************************/

    /******************************************************************************************************************
    * Important definitions for run-time configuration of the EEL
    ******************************************************************************************************************/
    #define EEL_CONFIG_VBLK_SIZE                    32           /**< Virtual block size (# physical Flash blocks) */
    #define EEL_CONFIG_VBLK_CNT_REFRESH_THRESHOLD    3           /**< Threshold for minimum no. of prepared blocks */
    #define EEL_CONFIG_ERASE_SUSPEND_THRESHOLD      10           /**< Threshold for erase suspend cnt. Exceeding this 
                                                                      results in a warning */
    
    /******************************************************************************************************************
    * R_EEL_CONFIG_IDL_TABLE
    * Descriptor table containing data set identifier and data set length
    * as: 
    * { { <16-bit ID>, <16-bit length in bytes> }, {...}, {...}, .... }
    ******************************************************************************************************************/
    #define EEL_CONFIG_IDL_TABLE          {                       \
                                          { INTERNAL_EE_BLOCK_00, INTERNAL_EE_BLOCK_00_size },   \
                                          { INTERNAL_EE_BLOCK_01, INTERNAL_EE_BLOCK_01_size },   \
                                          { INTERNAL_EE_BLOCK_02, INTERNAL_EE_BLOCK_02_size },   \
                                          { INTERNAL_EE_BLOCK_03, INTERNAL_EE_BLOCK_03_size },   \
                                          { INTERNAL_EE_BLOCK_04, INTERNAL_EE_BLOCK_04_size },   \
                                          { INTERNAL_EE_BLOCK_05, INTERNAL_EE_BLOCK_05_size },   \
                                          { INTERNAL_EE_BLOCK_06, INTERNAL_EE_BLOCK_06_size },   \
                                          { INTERNAL_EE_BLOCK_07, INTERNAL_EE_BLOCK_07_size },   \
                                          { INTERNAL_EE_BLOCK_08, INTERNAL_EE_BLOCK_08_size },   \
                                        } 
    

/*********************************************************************************************************************
 * Even if possible, this section should not b echanged by the user
 *********************************************************************************************************************/
    
    /*****************************************************************************************************************
     * Descriptor variable declaration
     *****************************************************************************************************************/
    extern const r_eel_descriptor_t sampleApp_eelConfig_enu;


/*********************************************************************************************************************/
#endif  /* #ifndef R_EEL_DESCRIPTOR_H */
