/*===========================================================================*/
/* Module      = dr7f701684_irq.h                                            */
/* Version     = V1.00                                                       */
/*               extracted from device file dr7f701684.dvf                   */
/*               generated by DeFiXRH850 0.9.3.1                             */
/*===========================================================================*/
/*                                  COPYRIGHT                                */
/*===========================================================================*/
/* Copyright (c) 2017 by Renesas Electronics Europe GmbH,                    */
/*               a company of the Renesas Electronics Corporation            */
/*===========================================================================*/
/* Purpose:      Declarations of Interrupt Vector Table                      */
/*                                                                           */
/*===========================================================================*/
/*                                                                           */
/* Warranty Disclaimer                                                       */
/*                                                                           */
/* Because the Product(s) is licensed free of charge, there is no warranty   */
/* of any kind whatsoever and expressly disclaimed and excluded by Renesas,  */
/* either expressed or implied, including but not limited to those for       */
/* non-infringement of intellectual property, merchantability and/or         */
/* fitness for the particular purpose.                                       */
/* Renesas shall not have any obligation to maintain, service or provide bug */
/* fixes for the supplied Product(s) and/or the Application.                 */
/*                                                                           */
/* Each User is solely responsible for determining the appropriateness of    */
/* using the Product(s) and assumes all risks associated with its exercise   */
/* of rights under this Agreement, including, but not limited to the risks   */
/* and costs of program errors, compliance with applicable laws, damage to   */
/* or loss of data, programs or equipment, and unavailability or             */
/* interruption of operations.                                               */
/*                                                                           */
/* Limitation of Liability                                                   */
/*                                                                           */
/* In no event shall Renesas be liable to the User for any incidental,       */
/* consequential, indirect, or punitive damage (including but not limited    */
/* to lost profits) regardless of whether such liability is based on breach  */
/* of contract, tort, strict liability, breach of warranties, failure of     */
/* essential purpose or otherwise and even if advised of the possibility of  */
/* such damages. Renesas shall not be liable for any services or products    */
/* provided by third party vendors, developers or consultants identified or  */
/* referred to the User by Renesas in connection with the Product(s) and/or  */
/* the Application.                                                          */
/*                                                                           */
/*===========================================================================*/
/* Environment:                                                              */
/*              Device:         R7F701684                                    */
/*              IDE:            GHS Multi for V800  V6.xx or later           */
/*===========================================================================*/

#ifndef __R7F701684_IRQ_H
#define __R7F701684_IRQ_H

#define IRQ_TABLE_START 0x00000200u

#define RESET_ENABLE 0x00000001u

// #define SYSERR_ENABLE                   0x00000010u
#ifndef SYSERR_ENABLE
    #define SYSERR_ENABLE 0x00000000u
#endif

// #define FETRAPEX_ENABLE                 0x00000030u
#ifndef FETRAPEX_ENABLE
    #define FETRAPEX_ENABLE 0x00000000u
#endif

// #define EITRAP0_ENABLE                  0x00000040u
#ifndef EITRAP0_ENABLE
    #define EITRAP0_ENABLE 0x00000000u
#endif

// #define EITRAP1_ENABLE                  0x00000050u
#ifndef EITRAP1_ENABLE
    #define EITRAP1_ENABLE 0x00000000u
#endif

// #define RIEX_ENABLE                     0x00000060u
#ifndef RIEX_ENABLE
    #define RIEX_ENABLE 0x00000000u
#endif

// #define UCPOP_ENABLE                    0x00000080u
#ifndef UCPOP_ENABLE
    #define UCPOP_ENABLE 0x00000000u
#endif

// #define MIP_MDP_ENABLE                  0x00000090u
#ifndef MIP_MDP_ENABLE
    #define MIP_MDP_ENABLE 0x00000000u
#endif

// #define PIE_ENABLE                      0x000000A0u
#ifndef PIE_ENABLE
    #define PIE_ENABLE 0x00000000u
#endif

// #define MAE_ENABLE                      0x000000C0u
#ifndef MAE_ENABLE
    #define MAE_ENABLE 0x00000000u
#endif

// #define FENMI_ENABLE                    0x000000E0u
#ifndef FENMI_ENABLE
    #define FENMI_ENABLE 0x00000000u
#endif

// #define FEINT_ENABLE                    0x000000F0u
#ifndef FEINT_ENABLE
    #define FEINT_ENABLE 0x00000000u
#endif

// #define EINTPRIO_0_ENABLE               0x00000100u
#ifndef EINTPRIO_0_ENABLE
    #define EINTPRIO_0_ENABLE 0x00000000u
#endif

// #define EINTPRIO_1_ENABLE               0x00000110u
#ifndef EINTPRIO_1_ENABLE
    #define EINTPRIO_1_ENABLE 0x00000000u
#endif

// #define EINTPRIO_2_ENABLE               0x00000120u
#ifndef EINTPRIO_2_ENABLE
    #define EINTPRIO_2_ENABLE 0x00000000u
#endif

// #define EINTPRIO_3_ENABLE               0x00000130u
#ifndef EINTPRIO_3_ENABLE
    #define EINTPRIO_3_ENABLE 0x00000000u
#endif

// #define EINTPRIO_4_ENABLE               0x00000140u
#ifndef EINTPRIO_4_ENABLE
    #define EINTPRIO_4_ENABLE 0x00000000u
#endif

// #define EINTPRIO_5_ENABLE               0x00000150u
#ifndef EINTPRIO_5_ENABLE
    #define EINTPRIO_5_ENABLE 0x00000000u
#endif

// #define EINTPRIO_6_ENABLE               0x00000160u
#ifndef EINTPRIO_6_ENABLE
    #define EINTPRIO_6_ENABLE 0x00000000u
#endif

// #define EINTPRIO_7_ENABLE               0x00000170u
#ifndef EINTPRIO_7_ENABLE
    #define EINTPRIO_7_ENABLE 0x00000000u
#endif

// #define EINTPRIO_8_ENABLE               0x00000180u
#ifndef EINTPRIO_8_ENABLE
    #define EINTPRIO_8_ENABLE 0x00000000u
#endif

// #define EINTPRIO_9_ENABLE               0x00000190u
#ifndef EINTPRIO_9_ENABLE
    #define EINTPRIO_9_ENABLE 0x00000000u
#endif

// #define EINTPRIO_10_ENABLE              0x000001A0u
#ifndef EINTPRIO_10_ENABLE
    #define EINTPRIO_10_ENABLE 0x00000000u
#endif

// #define EINTPRIO_11_ENABLE              0x000001B0u
#ifndef EINTPRIO_11_ENABLE
    #define EINTPRIO_11_ENABLE 0x00000000u
#endif

// #define EINTPRIO_12_ENABLE              0x000001C0u
#ifndef EINTPRIO_12_ENABLE
    #define EINTPRIO_12_ENABLE 0x00000000u
#endif

// #define EINTPRIO_13_ENABLE              0x000001D0u
#ifndef EINTPRIO_13_ENABLE
    #define EINTPRIO_13_ENABLE 0x00000000u
#endif

// #define EINTPRIO_14_ENABLE              0x000001E0u
#ifndef EINTPRIO_14_ENABLE
    #define EINTPRIO_14_ENABLE 0x00000000u
#endif

// #define EINTPRIO_15_ENABLE              0x000001F0u
#ifndef EINTPRIO_15_ENABLE
    #define EINTPRIO_15_ENABLE 0x00000000u
#endif

// #define INTTAUD0I0_ENABLE               (IRQ_TABLE_START + 0x00000020u)
// #define INTCSIH2IC_1_ENABLE             (IRQ_TABLE_START + 0x00000020u)
#ifndef INTTAUD0I0_ENABLE
    #define INTTAUD0I0_ENABLE 0x00000000u
#endif
#ifndef INTCSIH2IC_1_ENABLE
    #define INTCSIH2IC_1_ENABLE 0x00000000u
#endif

// #define INTTAUD0I2_ENABLE               (IRQ_TABLE_START + 0x00000024u)
// #define INTCSIH3IC_1_ENABLE             (IRQ_TABLE_START + 0x00000024u)
#ifndef INTTAUD0I2_ENABLE
    #define INTTAUD0I2_ENABLE 0x00000000u
#endif
#ifndef INTCSIH3IC_1_ENABLE
    #define INTCSIH3IC_1_ENABLE 0x00000000u
#endif

// #define INTTAUD0I4_ENABLE               (IRQ_TABLE_START + 0x00000028u)
// #define INTCSIH2IR_1_ENABLE             (IRQ_TABLE_START + 0x00000028u)
#ifndef INTTAUD0I4_ENABLE
    #define INTTAUD0I4_ENABLE 0x00000000u
#endif
#ifndef INTCSIH2IR_1_ENABLE
    #define INTCSIH2IR_1_ENABLE 0x00000000u
#endif

// #define INTTAUD0I6_ENABLE               (IRQ_TABLE_START + 0x0000002Cu)
// #define INTCSIH2IRE_1_ENABLE            (IRQ_TABLE_START + 0x0000002Cu)
#ifndef INTTAUD0I6_ENABLE
    #define INTTAUD0I6_ENABLE 0x00000000u
#endif
#ifndef INTCSIH2IRE_1_ENABLE
    #define INTCSIH2IRE_1_ENABLE 0x00000000u
#endif

// #define INTTAUD0I8_ENABLE               (IRQ_TABLE_START + 0x00000030u)
// #define INTCSIH2IJC_1_ENABLE            (IRQ_TABLE_START + 0x00000030u)
#ifndef INTTAUD0I8_ENABLE
    #define INTTAUD0I8_ENABLE 0x00000000u
#endif
#ifndef INTCSIH2IJC_1_ENABLE
    #define INTCSIH2IJC_1_ENABLE 0x00000000u
#endif

// #define INTTAUD0I10_ENABLE              (IRQ_TABLE_START + 0x00000034u)
// #define INTCSIH3IR_1_ENABLE             (IRQ_TABLE_START + 0x00000034u)
#ifndef INTTAUD0I10_ENABLE
    #define INTTAUD0I10_ENABLE 0x00000000u
#endif
#ifndef INTCSIH3IR_1_ENABLE
    #define INTCSIH3IR_1_ENABLE 0x00000000u
#endif

// #define INTCSIH3IRE_1_ENABLE            (IRQ_TABLE_START + 0x00000038u)
// #define INTTAUD0I12_ENABLE              (IRQ_TABLE_START + 0x00000038u)
#ifndef INTCSIH3IRE_1_ENABLE
    #define INTCSIH3IRE_1_ENABLE 0x00000000u
#endif
#ifndef INTTAUD0I12_ENABLE
    #define INTTAUD0I12_ENABLE 0x00000000u
#endif

// #define INTTAUD0I14_ENABLE              (IRQ_TABLE_START + 0x0000003Cu)
// #define INTCSIH3IJC_1_ENABLE            (IRQ_TABLE_START + 0x0000003Cu)
#ifndef INTTAUD0I14_ENABLE
    #define INTTAUD0I14_ENABLE 0x00000000u
#endif
#ifndef INTCSIH3IJC_1_ENABLE
    #define INTCSIH3IJC_1_ENABLE 0x00000000u
#endif

// #define INTTAPA0IPEK0_ENABLE            (IRQ_TABLE_START + 0x00000040u)
// #define INTCSIH1IC_1_ENABLE             (IRQ_TABLE_START + 0x00000040u)
#ifndef INTTAPA0IPEK0_ENABLE
    #define INTTAPA0IPEK0_ENABLE 0x00000000u
#endif
#ifndef INTCSIH1IC_1_ENABLE
    #define INTCSIH1IC_1_ENABLE 0x00000000u
#endif

// #define INTTAPA0IVLY0_ENABLE            (IRQ_TABLE_START + 0x00000044u)
// #define INTCSIH1IR_1_ENABLE             (IRQ_TABLE_START + 0x00000044u)
#ifndef INTTAPA0IVLY0_ENABLE
    #define INTTAPA0IVLY0_ENABLE 0x00000000u
#endif
#ifndef INTCSIH1IR_1_ENABLE
    #define INTCSIH1IR_1_ENABLE 0x00000000u
#endif

// #define INTADCA0I0_ENABLE               (IRQ_TABLE_START + 0x00000048u)
#ifndef INTADCA0I0_ENABLE
    #define INTADCA0I0_ENABLE 0x00000000u
#endif

// #define INTADCA0I1_ENABLE               (IRQ_TABLE_START + 0x0000004Cu)
#ifndef INTADCA0I1_ENABLE
    #define INTADCA0I1_ENABLE 0x00000000u
#endif

// #define INTCSIH0IJC_1_ENABLE            (IRQ_TABLE_START + 0x00000050u)
// #define INTADCA0I2_ENABLE               (IRQ_TABLE_START + 0x00000050u)
#ifndef INTCSIH0IJC_1_ENABLE
    #define INTCSIH0IJC_1_ENABLE 0x00000000u
#endif
#ifndef INTADCA0I2_ENABLE
    #define INTADCA0I2_ENABLE 0x00000000u
#endif

// #define INTDCUTDI_ENABLE                (IRQ_TABLE_START + 0x00000054u)
#ifndef INTDCUTDI_ENABLE
    #define INTDCUTDI_ENABLE 0x00000000u
#endif

// #define INTRCANGERR0_ENABLE             (IRQ_TABLE_START + 0x00000058u)
#ifndef INTRCANGERR0_ENABLE
    #define INTRCANGERR0_ENABLE 0x00000000u
#endif

// #define INTRCANGRECC0_ENABLE            (IRQ_TABLE_START + 0x0000005Cu)
#ifndef INTRCANGRECC0_ENABLE
    #define INTRCANGRECC0_ENABLE 0x00000000u
#endif

// #define INTRCAN0ERR_ENABLE              (IRQ_TABLE_START + 0x00000060u)
#ifndef INTRCAN0ERR_ENABLE
    #define INTRCAN0ERR_ENABLE 0x00000000u
#endif

 #define INTRCAN0REC_ENABLE              (IRQ_TABLE_START + 0x00000064u)
#ifndef INTRCAN0REC_ENABLE
    #define INTRCAN0REC_ENABLE 0x00000000u
#endif

 #define INTRCAN0TRX_ENABLE              (IRQ_TABLE_START + 0x00000068u)
#ifndef INTRCAN0TRX_ENABLE
    #define INTRCAN0TRX_ENABLE 0x00000000u
#endif

// #define INTCSIG0IC_ENABLE               (IRQ_TABLE_START + 0x0000006Cu)
// #define INTCSIH1IRE_1_ENABLE            (IRQ_TABLE_START + 0x0000006Cu)
#ifndef INTCSIG0IC_ENABLE
    #define INTCSIG0IC_ENABLE 0x00000000u
#endif
#ifndef INTCSIH1IRE_1_ENABLE
    #define INTCSIH1IRE_1_ENABLE 0x00000000u
#endif

// #define INTCSIG0IR_ENABLE               (IRQ_TABLE_START + 0x00000070u)
// #define INTCSIH1IJC_1_ENABLE            (IRQ_TABLE_START + 0x00000070u)
#ifndef INTCSIG0IR_ENABLE
    #define INTCSIG0IR_ENABLE 0x00000000u
#endif
#ifndef INTCSIH1IJC_1_ENABLE
    #define INTCSIH1IJC_1_ENABLE 0x00000000u
#endif

// #define INTCSIH0IC_ENABLE               (IRQ_TABLE_START + 0x00000074u)
#ifndef INTCSIH0IC_ENABLE
    #define INTCSIH0IC_ENABLE 0x00000000u
#endif

// #define INTCSIH0IR_ENABLE               (IRQ_TABLE_START + 0x00000078u)
#ifndef INTCSIH0IR_ENABLE
    #define INTCSIH0IR_ENABLE 0x00000000u
#endif

// #define INTCSIH0IRE_ENABLE              (IRQ_TABLE_START + 0x0000007Cu)
#ifndef INTCSIH0IRE_ENABLE
    #define INTCSIH0IRE_ENABLE 0x00000000u
#endif

// #define INTCSIH0IJC_ENABLE              (IRQ_TABLE_START + 0x00000080u)
// #define INTADCA0I2_2_ENABLE             (IRQ_TABLE_START + 0x00000080u)
#ifndef INTCSIH0IJC_ENABLE
    #define INTCSIH0IJC_ENABLE 0x00000000u
#endif
#ifndef INTADCA0I2_2_ENABLE
    #define INTADCA0I2_2_ENABLE 0x00000000u
#endif

// #define INTRLIN30_ENABLE                (IRQ_TABLE_START + 0x00000084u)
#ifndef INTRLIN30_ENABLE
    #define INTRLIN30_ENABLE 0x00000000u
#endif

// #define INTRLIN30UR0_ENABLE             (IRQ_TABLE_START + 0x00000088u)
#ifndef INTRLIN30UR0_ENABLE
    #define INTRLIN30UR0_ENABLE 0x00000000u
#endif

// #define INTRLIN30UR1_ENABLE             (IRQ_TABLE_START + 0x0000008Cu)
#ifndef INTRLIN30UR1_ENABLE
    #define INTRLIN30UR1_ENABLE 0x00000000u
#endif

// #define INTRLIN30UR2_ENABLE             (IRQ_TABLE_START + 0x00000090u)
#ifndef INTRLIN30UR2_ENABLE
    #define INTRLIN30UR2_ENABLE 0x00000000u
#endif

// #define INTP0_ENABLE                    (IRQ_TABLE_START + 0x00000094u)
#ifndef INTP0_ENABLE
    #define INTP0_ENABLE 0x00000000u
#endif

// #define INTP1_ENABLE                    (IRQ_TABLE_START + 0x00000098u)
#ifndef INTP1_ENABLE
    #define INTP1_ENABLE 0x00000000u
#endif

// #define INTP2_ENABLE                    (IRQ_TABLE_START + 0x0000009Cu)
#ifndef INTP2_ENABLE
    #define INTP2_ENABLE 0x00000000u
#endif

// #define INTWDTA0_ENABLE                 (IRQ_TABLE_START + 0x000000A0u)
#ifndef INTWDTA0_ENABLE
    #define INTWDTA0_ENABLE 0x00000000u
#endif

// #define INTWDTA1_ENABLE                 (IRQ_TABLE_START + 0x000000A4u)
#ifndef INTWDTA1_ENABLE
    #define INTWDTA1_ENABLE 0x00000000u
#endif

// #define INTP3_ENABLE                    (IRQ_TABLE_START + 0x000000ACu)
#ifndef INTP3_ENABLE
    #define INTP3_ENABLE 0x00000000u
#endif

// #define INTP4_ENABLE                    (IRQ_TABLE_START + 0x000000B0u)
#ifndef INTP4_ENABLE
    #define INTP4_ENABLE 0x00000000u
#endif

// #define INTP5_ENABLE                    (IRQ_TABLE_START + 0x000000B4u)
#ifndef INTP5_ENABLE
    #define INTP5_ENABLE 0x00000000u
#endif

// #define INTP10_ENABLE                   (IRQ_TABLE_START + 0x000000B8u)
#ifndef INTP10_ENABLE
    #define INTP10_ENABLE 0x00000000u
#endif

// #define INTP11_ENABLE                   (IRQ_TABLE_START + 0x000000BCu)
#ifndef INTP11_ENABLE
    #define INTP11_ENABLE 0x00000000u
#endif

// #define INTTAUD0I1_ENABLE               (IRQ_TABLE_START + 0x000000C0u)
#ifndef INTTAUD0I1_ENABLE
    #define INTTAUD0I1_ENABLE 0x00000000u
#endif

// #define INTTAUD0I3_ENABLE               (IRQ_TABLE_START + 0x000000C4u)
#ifndef INTTAUD0I3_ENABLE
    #define INTTAUD0I3_ENABLE 0x00000000u
#endif

// #define INTTAUD0I5_ENABLE               (IRQ_TABLE_START + 0x000000C8u)
#ifndef INTTAUD0I5_ENABLE
    #define INTTAUD0I5_ENABLE 0x00000000u
#endif

// #define INTTAUD0I7_ENABLE               (IRQ_TABLE_START + 0x000000CCu)
#ifndef INTTAUD0I7_ENABLE
    #define INTTAUD0I7_ENABLE 0x00000000u
#endif

// #define INTTAUD0I9_ENABLE               (IRQ_TABLE_START + 0x000000D0u)
#ifndef INTTAUD0I9_ENABLE
    #define INTTAUD0I9_ENABLE 0x00000000u
#endif

// #define INTTAUD0I11_ENABLE              (IRQ_TABLE_START + 0x000000D4u)
#ifndef INTTAUD0I11_ENABLE
    #define INTTAUD0I11_ENABLE 0x00000000u
#endif

// #define INTTAUD0I13_ENABLE              (IRQ_TABLE_START + 0x000000D8u)
#ifndef INTTAUD0I13_ENABLE
    #define INTTAUD0I13_ENABLE 0x00000000u
#endif

// #define INTTAUD0I15_ENABLE              (IRQ_TABLE_START + 0x000000DCu)
#ifndef INTTAUD0I15_ENABLE
    #define INTTAUD0I15_ENABLE 0x00000000u
#endif

// #define INTADCA0ERR_ENABLE              (IRQ_TABLE_START + 0x000000E0u)
#ifndef INTADCA0ERR_ENABLE
    #define INTADCA0ERR_ENABLE 0x00000000u
#endif

// #define INTCSIG0IRE_ENABLE              (IRQ_TABLE_START + 0x000000E4u)
#ifndef INTCSIG0IRE_ENABLE
    #define INTCSIG0IRE_ENABLE 0x00000000u
#endif

// #define INTRLIN20_ENABLE                (IRQ_TABLE_START + 0x000000E8u)
#ifndef INTRLIN20_ENABLE
    #define INTRLIN20_ENABLE 0x00000000u
#endif

// #define INTRLIN21_ENABLE                (IRQ_TABLE_START + 0x000000ECu)
#ifndef INTRLIN21_ENABLE
    #define INTRLIN21_ENABLE 0x00000000u
#endif

// #define INTDMA0_ENABLE                  (IRQ_TABLE_START + 0x000000F0u)
#ifndef INTDMA0_ENABLE
    #define INTDMA0_ENABLE 0x00000000u
#endif

// #define INTDMA1_ENABLE                  (IRQ_TABLE_START + 0x000000F4u)
#ifndef INTDMA1_ENABLE
    #define INTDMA1_ENABLE 0x00000000u
#endif

// #define INTDMA2_ENABLE                  (IRQ_TABLE_START + 0x000000F8u)
#ifndef INTDMA2_ENABLE
    #define INTDMA2_ENABLE 0x00000000u
#endif

// #define INTDMA3_ENABLE                  (IRQ_TABLE_START + 0x000000FCu)
#ifndef INTDMA3_ENABLE
    #define INTDMA3_ENABLE 0x00000000u
#endif

// #define INTDMA4_ENABLE                  (IRQ_TABLE_START + 0x00000100u)
#ifndef INTDMA4_ENABLE
    #define INTDMA4_ENABLE 0x00000000u
#endif

// #define INTDMA5_ENABLE                  (IRQ_TABLE_START + 0x00000104u)
#ifndef INTDMA5_ENABLE
    #define INTDMA5_ENABLE 0x00000000u
#endif

// #define INTDMA6_ENABLE                  (IRQ_TABLE_START + 0x00000108u)
#ifndef INTDMA6_ENABLE
    #define INTDMA6_ENABLE 0x00000000u
#endif

// #define INTDMA7_ENABLE                  (IRQ_TABLE_START + 0x0000010Cu)
#ifndef INTDMA7_ENABLE
    #define INTDMA7_ENABLE 0x00000000u
#endif

// #define INTDMA8_ENABLE                  (IRQ_TABLE_START + 0x00000110u)
#ifndef INTDMA8_ENABLE
    #define INTDMA8_ENABLE 0x00000000u
#endif

// #define INTDMA9_ENABLE                  (IRQ_TABLE_START + 0x00000114u)
#ifndef INTDMA9_ENABLE
    #define INTDMA9_ENABLE 0x00000000u
#endif

// #define INTDMA10_ENABLE                 (IRQ_TABLE_START + 0x00000118u)
#ifndef INTDMA10_ENABLE
    #define INTDMA10_ENABLE 0x00000000u
#endif

// #define INTDMA11_ENABLE                 (IRQ_TABLE_START + 0x0000011Cu)
#ifndef INTDMA11_ENABLE
    #define INTDMA11_ENABLE 0x00000000u
#endif

// #define INTDMA12_ENABLE                 (IRQ_TABLE_START + 0x00000120u)
#ifndef INTDMA12_ENABLE
    #define INTDMA12_ENABLE 0x00000000u
#endif

// #define INTDMA13_ENABLE                 (IRQ_TABLE_START + 0x00000124u)
#ifndef INTDMA13_ENABLE
    #define INTDMA13_ENABLE 0x00000000u
#endif

// #define INTDMA14_ENABLE                 (IRQ_TABLE_START + 0x00000128u)
#ifndef INTDMA14_ENABLE
    #define INTDMA14_ENABLE 0x00000000u
#endif

// #define INTDMA15_ENABLE                 (IRQ_TABLE_START + 0x0000012Cu)
#ifndef INTDMA15_ENABLE
    #define INTDMA15_ENABLE 0x00000000u
#endif

// #define INTRIIC0TI_ENABLE               (IRQ_TABLE_START + 0x00000130u)
#ifndef INTRIIC0TI_ENABLE
    #define INTRIIC0TI_ENABLE 0x00000000u
#endif

// #define INTRIIC0EE_ENABLE               (IRQ_TABLE_START + 0x00000134u)
#ifndef INTRIIC0EE_ENABLE
    #define INTRIIC0EE_ENABLE 0x00000000u
#endif

// #define INTRIIC0RI_ENABLE               (IRQ_TABLE_START + 0x00000138u)
#ifndef INTRIIC0RI_ENABLE
    #define INTRIIC0RI_ENABLE 0x00000000u
#endif

// #define INTRIIC0TEI_ENABLE              (IRQ_TABLE_START + 0x0000013Cu)
#ifndef INTRIIC0TEI_ENABLE
    #define INTRIIC0TEI_ENABLE 0x00000000u
#endif

// #define INTTAUJ0I0_ENABLE               (IRQ_TABLE_START + 0x00000140u)
#ifndef INTTAUJ0I0_ENABLE
    #define INTTAUJ0I0_ENABLE 0x00000000u
#endif

// #define INTTAUJ0I1_ENABLE               (IRQ_TABLE_START + 0x00000144u)
#ifndef INTTAUJ0I1_ENABLE
    #define INTTAUJ0I1_ENABLE 0x00000000u
#endif

// #define INTTAUJ0I2_ENABLE               (IRQ_TABLE_START + 0x00000148u)
#ifndef INTTAUJ0I2_ENABLE
    #define INTTAUJ0I2_ENABLE 0x00000000u
#endif

// #define INTTAUJ0I3_ENABLE               (IRQ_TABLE_START + 0x0000014Cu)
#ifndef INTTAUJ0I3_ENABLE
    #define INTTAUJ0I3_ENABLE 0x00000000u
#endif

#define INTOSTM0_ENABLE (IRQ_TABLE_START + 0x00000150u)
#ifndef INTOSTM0_ENABLE
    #define INTOSTM0_ENABLE 0x00000000u
#endif

// #define INTENCA0IOV_ENABLE              (IRQ_TABLE_START + 0x00000154u)
#ifndef INTENCA0IOV_ENABLE
    #define INTENCA0IOV_ENABLE 0x00000000u
#endif

// #define INTENCA0IUD_ENABLE              (IRQ_TABLE_START + 0x00000158u)
#ifndef INTENCA0IUD_ENABLE
    #define INTENCA0IUD_ENABLE 0x00000000u
#endif

// #define INTENCA0I0_ENABLE               (IRQ_TABLE_START + 0x0000015Cu)
#ifndef INTENCA0I0_ENABLE
    #define INTENCA0I0_ENABLE 0x00000000u
#endif

// #define INTENCA0I1_ENABLE               (IRQ_TABLE_START + 0x00000160u)
#ifndef INTENCA0I1_ENABLE
    #define INTENCA0I1_ENABLE 0x00000000u
#endif

// #define INTENCA0IEC_ENABLE              (IRQ_TABLE_START + 0x00000164u)
#ifndef INTENCA0IEC_ENABLE
    #define INTENCA0IEC_ENABLE 0x00000000u
#endif

// #define INTKR0_ENABLE                   (IRQ_TABLE_START + 0x00000168u)
#ifndef INTKR0_ENABLE
    #define INTKR0_ENABLE 0x00000000u
#endif

// #define INTQFULL_ENABLE                 (IRQ_TABLE_START + 0x0000016Cu)
#ifndef INTQFULL_ENABLE
    #define INTQFULL_ENABLE 0x00000000u
#endif

// #define INTPWGAG00_ENABLE               (IRQ_TABLE_START + 0x00000170u)
#ifndef INTPWGAG00_ENABLE
    #define INTPWGAG00_ENABLE 0x00000000u
#endif

// #define INTPWGAG01_ENABLE               (IRQ_TABLE_START + 0x00000174u)
#ifndef INTPWGAG01_ENABLE
    #define INTPWGAG01_ENABLE 0x00000000u
#endif

// #define INTFLERR_ENABLE                 (IRQ_TABLE_START + 0x000001B8u)
#ifndef INTFLERR_ENABLE
    #define INTFLERR_ENABLE 0x00000000u
#endif

// #define INTFLENDNM_ENABLE               (IRQ_TABLE_START + 0x000001BCu)
#ifndef INTFLENDNM_ENABLE
    #define INTFLENDNM_ENABLE 0x00000000u
#endif

// #define INTCWEND_ENABLE                 (IRQ_TABLE_START + 0x000001C0u)
#ifndef INTCWEND_ENABLE
    #define INTCWEND_ENABLE 0x00000000u
#endif

// #define INTRCAN1ERR_ENABLE              (IRQ_TABLE_START + 0x000001C4u)
#ifndef INTRCAN1ERR_ENABLE
    #define INTRCAN1ERR_ENABLE 0x00000000u
#endif

#define INTRCAN1REC_ENABLE (IRQ_TABLE_START + 0x000001C8u)
#ifndef INTRCAN1REC_ENABLE
    #define INTRCAN1REC_ENABLE 0x00000000u
#endif

#define INTRCAN1TRX_ENABLE (IRQ_TABLE_START + 0x000001CCu)
#ifndef INTRCAN1TRX_ENABLE
    #define INTRCAN1TRX_ENABLE 0x00000000u
#endif

// #define INTCSIH1IC_ENABLE               (IRQ_TABLE_START + 0x000001D0u)
// #define INTTAPA0IPEK0_2_ENABLE          (IRQ_TABLE_START + 0x000001D0u)
#ifndef INTCSIH1IC_ENABLE
    #define INTCSIH1IC_ENABLE 0x00000000u
#endif
#ifndef INTTAPA0IPEK0_2_ENABLE
    #define INTTAPA0IPEK0_2_ENABLE 0x00000000u
#endif

// #define INTCSIH1IR_ENABLE               (IRQ_TABLE_START + 0x000001D4u)
// #define INTTAPA0IVLY0_2_ENABLE          (IRQ_TABLE_START + 0x000001D4u)
#ifndef INTCSIH1IR_ENABLE
    #define INTCSIH1IR_ENABLE 0x00000000u
#endif
#ifndef INTTAPA0IVLY0_2_ENABLE
    #define INTTAPA0IVLY0_2_ENABLE 0x00000000u
#endif

// #define INTCSIG0IC_2_ENABLE             (IRQ_TABLE_START + 0x000001D8u)
// #define INTCSIH1IRE_ENABLE              (IRQ_TABLE_START + 0x000001D8u)
#ifndef INTCSIG0IC_2_ENABLE
    #define INTCSIG0IC_2_ENABLE 0x00000000u
#endif
#ifndef INTCSIH1IRE_ENABLE
    #define INTCSIH1IRE_ENABLE 0x00000000u
#endif

// #define INTCSIG0IR_2_ENABLE             (IRQ_TABLE_START + 0x000001DCu)
// #define INTCSIH1IJC_ENABLE              (IRQ_TABLE_START + 0x000001DCu)
#ifndef INTCSIG0IR_2_ENABLE
    #define INTCSIG0IR_2_ENABLE 0x00000000u
#endif
#ifndef INTCSIH1IJC_ENABLE
    #define INTCSIH1IJC_ENABLE 0x00000000u
#endif

// #define INTRLIN31_ENABLE                (IRQ_TABLE_START + 0x000001E0u)
#ifndef INTRLIN31_ENABLE
    #define INTRLIN31_ENABLE 0x00000000u
#endif

// #define INTRLIN31UR0_ENABLE             (IRQ_TABLE_START + 0x000001E4u)
#ifndef INTRLIN31UR0_ENABLE
    #define INTRLIN31UR0_ENABLE 0x00000000u
#endif

// #define INTRLIN31UR1_ENABLE             (IRQ_TABLE_START + 0x000001E8u)
#ifndef INTRLIN31UR1_ENABLE
    #define INTRLIN31UR1_ENABLE 0x00000000u
#endif

// #define INTRLIN31UR2_ENABLE             (IRQ_TABLE_START + 0x000001ECu)
#ifndef INTRLIN31UR2_ENABLE
    #define INTRLIN31UR2_ENABLE 0x00000000u
#endif

// #define INTP6_ENABLE                    (IRQ_TABLE_START + 0x00000200u)
#ifndef INTP6_ENABLE
    #define INTP6_ENABLE 0x00000000u
#endif

// #define INTP7_ENABLE                    (IRQ_TABLE_START + 0x00000204u)
#ifndef INTP7_ENABLE
    #define INTP7_ENABLE 0x00000000u
#endif

// #define INTP8_ENABLE                    (IRQ_TABLE_START + 0x00000208u)
#ifndef INTP8_ENABLE
    #define INTP8_ENABLE 0x00000000u
#endif

// #define INTP12_ENABLE                   (IRQ_TABLE_START + 0x0000020Cu)
#ifndef INTP12_ENABLE
    #define INTP12_ENABLE 0x00000000u
#endif

// #define INTTAUD0I0_2_ENABLE             (IRQ_TABLE_START + 0x00000210u)
// #define INTCSIH2IC_ENABLE               (IRQ_TABLE_START + 0x00000210u)
#ifndef INTTAUD0I0_2_ENABLE
    #define INTTAUD0I0_2_ENABLE 0x00000000u
#endif
#ifndef INTCSIH2IC_ENABLE
    #define INTCSIH2IC_ENABLE 0x00000000u
#endif

// #define INTTAUD0I4_2_ENABLE             (IRQ_TABLE_START + 0x00000214u)
// #define INTCSIH2IR_ENABLE               (IRQ_TABLE_START + 0x00000214u)
#ifndef INTTAUD0I4_2_ENABLE
    #define INTTAUD0I4_2_ENABLE 0x00000000u
#endif
#ifndef INTCSIH2IR_ENABLE
    #define INTCSIH2IR_ENABLE 0x00000000u
#endif

// #define INTTAUD0I6_2_ENABLE             (IRQ_TABLE_START + 0x00000218u)
// #define INTCSIH2IRE_ENABLE              (IRQ_TABLE_START + 0x00000218u)
#ifndef INTTAUD0I6_2_ENABLE
    #define INTTAUD0I6_2_ENABLE 0x00000000u
#endif
#ifndef INTCSIH2IRE_ENABLE
    #define INTCSIH2IRE_ENABLE 0x00000000u
#endif

// #define INTCSIH2IJC_ENABLE              (IRQ_TABLE_START + 0x0000021Cu)
// #define INTTAUD0I8_2_ENABLE             (IRQ_TABLE_START + 0x0000021Cu)
#ifndef INTCSIH2IJC_ENABLE
    #define INTCSIH2IJC_ENABLE 0x00000000u
#endif
#ifndef INTTAUD0I8_2_ENABLE
    #define INTTAUD0I8_2_ENABLE 0x00000000u
#endif

// #define INTTAUB0I0_ENABLE               (IRQ_TABLE_START + 0x00000238u)
#ifndef INTTAUB0I0_ENABLE
    #define INTTAUB0I0_ENABLE 0x00000000u
#endif

// #define INTTAUB0I1_ENABLE               (IRQ_TABLE_START + 0x0000023Cu)
#ifndef INTTAUB0I1_ENABLE
    #define INTTAUB0I1_ENABLE 0x00000000u
#endif

// #define INTTAUB0I2_ENABLE               (IRQ_TABLE_START + 0x00000240u)
#ifndef INTTAUB0I2_ENABLE
    #define INTTAUB0I2_ENABLE 0x00000000u
#endif

// #define INTTAUB0I3_ENABLE               (IRQ_TABLE_START + 0x00000244u)
#ifndef INTTAUB0I3_ENABLE
    #define INTTAUB0I3_ENABLE 0x00000000u
#endif

// #define INTTAUB0I4_ENABLE               (IRQ_TABLE_START + 0x00000248u)
#ifndef INTTAUB0I4_ENABLE
    #define INTTAUB0I4_ENABLE 0x00000000u
#endif

// #define INTTAUB0I5_ENABLE               (IRQ_TABLE_START + 0x0000024Cu)
#ifndef INTTAUB0I5_ENABLE
    #define INTTAUB0I5_ENABLE 0x00000000u
#endif

// #define INTTAUB0I6_ENABLE               (IRQ_TABLE_START + 0x00000250u)
#ifndef INTTAUB0I6_ENABLE
    #define INTTAUB0I6_ENABLE 0x00000000u
#endif

// #define INTTAUB0I7_ENABLE               (IRQ_TABLE_START + 0x00000254u)
#ifndef INTTAUB0I7_ENABLE
    #define INTTAUB0I7_ENABLE 0x00000000u
#endif

// #define INTTAUB0I8_ENABLE               (IRQ_TABLE_START + 0x00000258u)
#ifndef INTTAUB0I8_ENABLE
    #define INTTAUB0I8_ENABLE 0x00000000u
#endif

// #define INTTAUB0I9_ENABLE               (IRQ_TABLE_START + 0x0000025Cu)
#ifndef INTTAUB0I9_ENABLE
    #define INTTAUB0I9_ENABLE 0x00000000u
#endif

// #define INTTAUB0I10_ENABLE              (IRQ_TABLE_START + 0x00000260u)
#ifndef INTTAUB0I10_ENABLE
    #define INTTAUB0I10_ENABLE 0x00000000u
#endif

// #define INTTAUB0I11_ENABLE              (IRQ_TABLE_START + 0x00000264u)
#ifndef INTTAUB0I11_ENABLE
    #define INTTAUB0I11_ENABLE 0x00000000u
#endif

// #define INTTAUB0I12_ENABLE              (IRQ_TABLE_START + 0x00000268u)
#ifndef INTTAUB0I12_ENABLE
    #define INTTAUB0I12_ENABLE 0x00000000u
#endif

// #define INTTAUB0I13_ENABLE              (IRQ_TABLE_START + 0x0000026Cu)
#ifndef INTTAUB0I13_ENABLE
    #define INTTAUB0I13_ENABLE 0x00000000u
#endif

// #define INTTAUB0I14_ENABLE              (IRQ_TABLE_START + 0x00000270u)
#ifndef INTTAUB0I14_ENABLE
    #define INTTAUB0I14_ENABLE 0x00000000u
#endif

// #define INTTAUB0I15_ENABLE              (IRQ_TABLE_START + 0x00000274u)
#ifndef INTTAUB0I15_ENABLE
    #define INTTAUB0I15_ENABLE 0x00000000u
#endif

// #define INTTAUD0I2_2_ENABLE             (IRQ_TABLE_START + 0x00000278u)
// #define INTCSIH3IC_ENABLE               (IRQ_TABLE_START + 0x00000278u)
#ifndef INTTAUD0I2_2_ENABLE
    #define INTTAUD0I2_2_ENABLE 0x00000000u
#endif
#ifndef INTCSIH3IC_ENABLE
    #define INTCSIH3IC_ENABLE 0x00000000u
#endif

// #define INTTAUD0I10_2_ENABLE            (IRQ_TABLE_START + 0x0000027Cu)
// #define INTCSIH3IR_ENABLE               (IRQ_TABLE_START + 0x0000027Cu)
#ifndef INTTAUD0I10_2_ENABLE
    #define INTTAUD0I10_2_ENABLE 0x00000000u
#endif
#ifndef INTCSIH3IR_ENABLE
    #define INTCSIH3IR_ENABLE 0x00000000u
#endif

// #define INTTAUD0I12_2_ENABLE            (IRQ_TABLE_START + 0x00000280u)
// #define INTCSIH3IRE_ENABLE              (IRQ_TABLE_START + 0x00000280u)
#ifndef INTTAUD0I12_2_ENABLE
    #define INTTAUD0I12_2_ENABLE 0x00000000u
#endif
#ifndef INTCSIH3IRE_ENABLE
    #define INTCSIH3IRE_ENABLE 0x00000000u
#endif

// #define INTTAUD0I14_2_ENABLE            (IRQ_TABLE_START + 0x00000284u)
// #define INTCSIH3IJC_ENABLE              (IRQ_TABLE_START + 0x00000284u)
#ifndef INTTAUD0I14_2_ENABLE
    #define INTTAUD0I14_2_ENABLE 0x00000000u
#endif
#ifndef INTCSIH3IJC_ENABLE
    #define INTCSIH3IJC_ENABLE 0x00000000u
#endif

// #define INTRLIN22_ENABLE                (IRQ_TABLE_START + 0x00000288u)
#ifndef INTRLIN22_ENABLE
    #define INTRLIN22_ENABLE 0x00000000u
#endif

// #define INTRLIN32_ENABLE                (IRQ_TABLE_START + 0x00000290u)
#ifndef INTRLIN32_ENABLE
    #define INTRLIN32_ENABLE 0x00000000u
#endif

// #define INTRLIN32UR0_ENABLE             (IRQ_TABLE_START + 0x00000294u)
#ifndef INTRLIN32UR0_ENABLE
    #define INTRLIN32UR0_ENABLE 0x00000000u
#endif

// #define INTRLIN32UR1_ENABLE             (IRQ_TABLE_START + 0x00000298u)
#ifndef INTRLIN32UR1_ENABLE
    #define INTRLIN32UR1_ENABLE 0x00000000u
#endif

// #define INTRLIN32UR2_ENABLE             (IRQ_TABLE_START + 0x0000029Cu)
#ifndef INTRLIN32UR2_ENABLE
    #define INTRLIN32UR2_ENABLE 0x00000000u
#endif

// #define INTTAUJ1I0_ENABLE               (IRQ_TABLE_START + 0x000002A0u)
#ifndef INTTAUJ1I0_ENABLE
    #define INTTAUJ1I0_ENABLE 0x00000000u
#endif

// #define INTTAUJ1I1_ENABLE               (IRQ_TABLE_START + 0x000002A4u)
#ifndef INTTAUJ1I1_ENABLE
    #define INTTAUJ1I1_ENABLE 0x00000000u
#endif

// #define INTTAUJ1I2_ENABLE               (IRQ_TABLE_START + 0x000002A8u)
#ifndef INTTAUJ1I2_ENABLE
    #define INTTAUJ1I2_ENABLE 0x00000000u
#endif

// #define INTTAUJ1I3_ENABLE               (IRQ_TABLE_START + 0x000002ACu)
#ifndef INTTAUJ1I3_ENABLE
    #define INTTAUJ1I3_ENABLE 0x00000000u
#endif

// #define INTP13_ENABLE                   (IRQ_TABLE_START + 0x00000338u)
#ifndef INTP13_ENABLE
    #define INTP13_ENABLE 0x00000000u
#endif

// #define INTRTCA01S_ENABLE               (IRQ_TABLE_START + 0x00000344u)
#ifndef INTRTCA01S_ENABLE
    #define INTRTCA01S_ENABLE 0x00000000u
#endif

// #define INTRTCA0AL_ENABLE               (IRQ_TABLE_START + 0x00000348u)
#ifndef INTRTCA0AL_ENABLE
    #define INTRTCA0AL_ENABLE 0x00000000u
#endif

// #define INTRTCA0R_ENABLE                (IRQ_TABLE_START + 0x0000034Cu)
#ifndef INTRTCA0R_ENABLE
    #define INTRTCA0R_ENABLE 0x00000000u
#endif

// #define INTRCAN2ERR_ENABLE              (IRQ_TABLE_START + 0x00000364u)
#ifndef INTRCAN2ERR_ENABLE
    #define INTRCAN2ERR_ENABLE 0x00000000u
#endif

 #define INTRCAN2REC_ENABLE              (IRQ_TABLE_START + 0x00000368u)
#ifndef INTRCAN2REC_ENABLE
    #define INTRCAN2REC_ENABLE 0x00000000u
#endif

 #define INTRCAN2TRX_ENABLE              (IRQ_TABLE_START + 0x0000036Cu)
#ifndef INTRCAN2TRX_ENABLE
    #define INTRCAN2TRX_ENABLE 0x00000000u
#endif

// #define INTRCAN3ERR_ENABLE              (IRQ_TABLE_START + 0x00000370u)
#ifndef INTRCAN3ERR_ENABLE
    #define INTRCAN3ERR_ENABLE 0x00000000u
#endif

 #define INTRCAN3REC_ENABLE              (IRQ_TABLE_START + 0x00000374u)
#ifndef INTRCAN3REC_ENABLE
    #define INTRCAN3REC_ENABLE 0x00000000u
#endif

 #define INTRCAN3TRX_ENABLE              (IRQ_TABLE_START + 0x00000378u)
#ifndef INTRCAN3TRX_ENABLE
    #define INTRCAN3TRX_ENABLE 0x00000000u
#endif

// #define INTRLIN33_ENABLE                (IRQ_TABLE_START + 0x00000390u)
#ifndef INTRLIN33_ENABLE
    #define INTRLIN33_ENABLE 0x00000000u
#endif

// #define INTRLIN33UR0_ENABLE             (IRQ_TABLE_START + 0x00000394u)
#ifndef INTRLIN33UR0_ENABLE
    #define INTRLIN33UR0_ENABLE 0x00000000u
#endif

// #define INTRLIN33UR1_ENABLE             (IRQ_TABLE_START + 0x00000398u)
#ifndef INTRLIN33UR1_ENABLE
    #define INTRLIN33UR1_ENABLE 0x00000000u
#endif

// #define INTRLIN33UR2_ENABLE             (IRQ_TABLE_START + 0x0000039Cu)
#ifndef INTRLIN33UR2_ENABLE
    #define INTRLIN33UR2_ENABLE 0x00000000u
#endif

// #define INTRIIC1TI_ENABLE               (IRQ_TABLE_START + 0x000003C0u)
#ifndef INTRIIC1TI_ENABLE
    #define INTRIIC1TI_ENABLE 0x00000000u
#endif

// #define INTRIIC1EE_ENABLE               (IRQ_TABLE_START + 0x000003C4u)
#ifndef INTRIIC1EE_ENABLE
    #define INTRIIC1EE_ENABLE 0x00000000u
#endif

// #define INTRIIC1RI_ENABLE               (IRQ_TABLE_START + 0x000003C8u)
#ifndef INTRIIC1RI_ENABLE
    #define INTRIIC1RI_ENABLE 0x00000000u
#endif

// #define INTRIIC1TEI_ENABLE              (IRQ_TABLE_START + 0x000003CCu)
#ifndef INTRIIC1TEI_ENABLE
    #define INTRIIC1TEI_ENABLE 0x00000000u
#endif

// #define INTRCAN4ERR_ENABLE              (IRQ_TABLE_START + 0x00000440u)
#ifndef INTRCAN4ERR_ENABLE
    #define INTRCAN4ERR_ENABLE 0x00000000u
#endif

#define INTRCAN4REC_ENABLE (IRQ_TABLE_START + 0x00000444u)
#ifndef INTRCAN4REC_ENABLE
    #define INTRCAN4REC_ENABLE 0x00000000u
#endif

#define INTRCAN4TRX_ENABLE (IRQ_TABLE_START + 0x00000448u)
#ifndef INTRCAN4TRX_ENABLE
    #define INTRCAN4TRX_ENABLE 0x00000000u
#endif

// #define INTTAUJ2I0_ENABLE               (IRQ_TABLE_START + 0x00000454u)
#ifndef INTTAUJ2I0_ENABLE
    #define INTTAUJ2I0_ENABLE 0x00000000u
#endif

// #define INTTAUJ2I1_ENABLE               (IRQ_TABLE_START + 0x00000458u)
#ifndef INTTAUJ2I1_ENABLE
    #define INTTAUJ2I1_ENABLE 0x00000000u
#endif

// #define INTTAUJ2I2_ENABLE               (IRQ_TABLE_START + 0x0000045Cu)
#ifndef INTTAUJ2I2_ENABLE
    #define INTTAUJ2I2_ENABLE 0x00000000u
#endif

// #define INTTAUJ2I3_ENABLE               (IRQ_TABLE_START + 0x00000460u)
#ifndef INTTAUJ2I3_ENABLE
    #define INTTAUJ2I3_ENABLE 0x00000000u
#endif

// #define INTTAUJ3I0_ENABLE               (IRQ_TABLE_START + 0x00000464u)
#ifndef INTTAUJ3I0_ENABLE
    #define INTTAUJ3I0_ENABLE 0x00000000u
#endif

// #define INTTAUJ3I1_ENABLE               (IRQ_TABLE_START + 0x00000468u)
#ifndef INTTAUJ3I1_ENABLE
    #define INTTAUJ3I1_ENABLE 0x00000000u
#endif

// #define INTTAUJ3I2_ENABLE               (IRQ_TABLE_START + 0x0000046Cu)
#ifndef INTTAUJ3I2_ENABLE
    #define INTTAUJ3I2_ENABLE 0x00000000u
#endif

// #define INTTAUJ3I3_ENABLE               (IRQ_TABLE_START + 0x00000470u)
#ifndef INTTAUJ3I3_ENABLE
    #define INTTAUJ3I3_ENABLE 0x00000000u
#endif

// #define INTRCAN5ERR_ENABLE              (IRQ_TABLE_START + 0x0000047Cu)
#ifndef INTRCAN5ERR_ENABLE
    #define INTRCAN5ERR_ENABLE 0x00000000u
#endif

 #define INTRCAN5REC_ENABLE              (IRQ_TABLE_START + 0x00000480u)
#ifndef INTRCAN5REC_ENABLE
    #define INTRCAN5REC_ENABLE 0x00000000u
#endif

 #define INTRCAN5TRX_ENABLE              (IRQ_TABLE_START + 0x00000484u)
#ifndef INTRCAN5TRX_ENABLE
    #define INTRCAN5TRX_ENABLE 0x00000000u
#endif

// #define INTCXP10TI_ENABLE               (IRQ_TABLE_START + 0x0000053Cu)
#ifndef INTCXP10TI_ENABLE
    #define INTCXP10TI_ENABLE 0x00000000u
#endif

// #define INTCXP10RI_ENABLE               (IRQ_TABLE_START + 0x00000540u)
#ifndef INTCXP10RI_ENABLE
    #define INTCXP10RI_ENABLE 0x00000000u
#endif

// #define INTCXP10SI_ENABLE               (IRQ_TABLE_START + 0x00000544u)
#ifndef INTCXP10SI_ENABLE
    #define INTCXP10SI_ENABLE 0x00000000u
#endif

// #define INTCXP11TI_ENABLE               (IRQ_TABLE_START + 0x00000548u)
#ifndef INTCXP11TI_ENABLE
    #define INTCXP11TI_ENABLE 0x00000000u
#endif

// #define INTCXP11RI_ENABLE               (IRQ_TABLE_START + 0x0000054Cu)
#ifndef INTCXP11RI_ENABLE
    #define INTCXP11RI_ENABLE 0x00000000u
#endif

// #define INTCXP11SI_ENABLE               (IRQ_TABLE_START + 0x00000550u)
#ifndef INTCXP11SI_ENABLE
    #define INTCXP11SI_ENABLE 0x00000000u
#endif

// #define INTCXP12TI_ENABLE               (IRQ_TABLE_START + 0x00000554u)
#ifndef INTCXP12TI_ENABLE
    #define INTCXP12TI_ENABLE 0x00000000u
#endif

// #define INTCXP12RI_ENABLE               (IRQ_TABLE_START + 0x00000558u)
#ifndef INTCXP12RI_ENABLE
    #define INTCXP12RI_ENABLE 0x00000000u
#endif

// #define INTCXP12SI_ENABLE               (IRQ_TABLE_START + 0x0000055Cu)
#ifndef INTCXP12SI_ENABLE
    #define INTCXP12SI_ENABLE 0x00000000u
#endif

// #define INTSENT0SI_ENABLE               (IRQ_TABLE_START + 0x0000056Cu)
#ifndef INTSENT0SI_ENABLE
    #define INTSENT0SI_ENABLE 0x00000000u
#endif

// #define INTSENT0RI_ENABLE               (IRQ_TABLE_START + 0x00000570u)
#ifndef INTSENT0RI_ENABLE
    #define INTSENT0RI_ENABLE 0x00000000u
#endif

// #define INTSENT1SI_ENABLE               (IRQ_TABLE_START + 0x00000574u)
#ifndef INTSENT1SI_ENABLE
    #define INTSENT1SI_ENABLE 0x00000000u
#endif

// #define INTSENT1RI_ENABLE               (IRQ_TABLE_START + 0x00000578u)
#ifndef INTSENT1RI_ENABLE
    #define INTSENT1RI_ENABLE 0x00000000u
#endif

// #define INTDPE_ENABLE                   (IRQ_TABLE_START + 0x00000590u)
#ifndef INTDPE_ENABLE
    #define INTDPE_ENABLE 0x00000000u
#endif

// #define INTAPE_ENABLE                   (IRQ_TABLE_START + 0x00000594u)
#ifndef INTAPE_ENABLE
    #define INTAPE_ENABLE 0x00000000u
#endif

#endif /* __R7F701684_IRQ_H */
