#ifndef BSP_DB8379_H_
    #define BSP_DB8379_H_

#include "common_include.h"
/*
    typedef union
    {
        uint16_t   all;
        struct
        {
            uint16_t                :1;
            uint16_t    ledData7    :1;
            uint16_t    ledData8    :1;
            uint16_t                :3;
            uint16_t    ledData6    :1;
            uint16_t    ledData5    :1;
            uint16_t    ledData4    :1;
            uint16_t    ledData3    :1;
            uint16_t    ledData2    :1;
            uint16_t    ledData1    :1;
            uint16_t    rsv         :4;
        }bit;
    }_Led_Data;
    EXTERN_BSP_DB8379                 _Led_Data                 g_LedDisp;
    
    */
    
    
    typedef union {
    uint16_t      LampData;
    struct {
        unsigned int TripSW1_1          :  1 ; //D11
        unsigned int LED8               :  1 ; //D10
        unsigned int LED7               :  1 ; //D9     
        unsigned int LED6               :  1 ; //D8     
        unsigned int LED5               :  1 ; //D7     
        unsigned int LED4               :  1 ; //D6
        unsigned int LED3               :  1 ; //D5     
        unsigned int LED2               :  1 ; //D4     
        unsigned int LED1               :  1 ; //D3     
        unsigned int RELAY_IGN3         :  1 ; //D2     
        unsigned int RELAY_IGN1         :  1 ; //D1     
        unsigned int RELAY_B            :  1 ; //D0     
        unsigned int                    :  4 ;
    }Lamps;
}LampStateStruct_L;
extern LampStateStruct_L LampState_L;

typedef union {
    uint16_t      LampData;
    struct {
        unsigned int LED7         :  1 ; //D11 
        unsigned int TripSW2_5         :  1 ; //D10 
        unsigned int TripSW2_4         :  1 ; //SW1_MENU 
        unsigned int TripSW2_3         :  1 ; //SW1_UP
        unsigned int TripSW2_2         :  1 ; //SW1_DOWN 
        unsigned int TripSW2_1         :  1 ; //SW1_OK
        unsigned int LED6         :  1 ; //D5     
        unsigned int LED5         :  1 ; //D4     
        unsigned int LED4         :  1 ; //D3     
        unsigned int LED3         :  1 ; //D2     
        unsigned int LED2         :  1 ; //D1     
        unsigned int LED1         :  1 ; //D0     
        unsigned int                   :  4 ;
    }Lamps;
}LampStateStruct_M;
extern LampStateStruct_M LampState_M;

typedef union {
    uint16_t      LampData;
    struct {
        unsigned int RELAY_L4          :  1 ; //D11    
        unsigned int RELAY_L3          :  1 ; //D10    
        unsigned int RELAY_L2          :  1 ; //menu    
        unsigned int RELAY_L1          :  1 ; //up    
        unsigned int RELAY_F4          :  1 ; //down     
        unsigned int RELAY_F3          :  1 ; //ok
        unsigned int RELAY_F2          :  1 ; //D5     
        unsigned int RELAY_F1          :  1 ; //D4     
        unsigned int Grib_3            :  1 ; //D3     
        unsigned int Grib_2            :  1 ; //D2     
        unsigned int Grib_1            :  1 ; //D1     
        unsigned int TripSW2_7         :  1 ; //D0     
        unsigned int                   :  4 ; 
    }Lamps;
}LampStateStruct_R;
extern LampStateStruct_R LampState_R;






    #define  BD8379_CLK_HIGH                          Port_SetPortPinLevel(2,5,PortGpioHigh)
    #define  BD8379_CLK_LOW                           Port_SetPortPinLevel(2,5,PortGpioLow)
    #define  BD8379_LATCH_HIGH                        Port_SetPortPinLevel(2,8,PortGpioHigh)
    #define  BD8379_LATCH_LOW                         Port_SetPortPinLevel(2,8,PortGpioLow)
    #define  BD8379_OE_HIGH                           Port_SetPortPinLevel(2,4,PortGpioHigh)
    #define  BD8379_OE_LOW                            Port_SetPortPinLevel(2,4,PortGpioLow)
    #define  BD8379_RST_HIGH                          Port_SetPortPinLevel(2,7,PortGpioHigh)
    #define  BD8379_RST_LOW                           Port_SetPortPinLevel(2,7,PortGpioLow)
    #define  BD8379_SEROUT_HIGH                       Port_SetPortPinLevel(2,6,PortGpioHigh)
    #define  BD8379_SEROUT_LOW                        Port_SetPortPinLevel(2,6,PortGpioLow)


    extern      void        bsp_BD8379_Init(void);
    extern      void        bsp_BD8379_OFF(void);
    extern      void        bsp_BD8379_WriteData(uint16_t  dataL,uint16_t  dataM,uint16_t  dataR);
#endif /* BSP_DB8379_H_ */