/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_PWU_H
#define __S6J3360_PWU_H

#include "s6j3360io_basetypes.h"

/* PWU base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define PWU	stcPWU
#else /* __IO_DEFINE */
#define PWU	(*((volatile stc_pwu_t*)0xB48C0800))
#endif /* __IO_DEFINE */

/* PWUC */
#define PWU_PWUC	(PWU.unPWUC.u8Register)  /*@rg@*/
#define PWU_PWUC_ADSTS	(PWU.unPWUC.stcField.u7ADSTS)  /*@bf@*/
#define PWU_PWUC_PWUE	(*(volatile uint_io8_t*)0xB7E04007)  /*@bfbba@*/

typedef struct stc_pwu_pwuc_field{
    uint_io8_t		u7ADSTS:7;
    uint_io8_t		u1PWUE:1;
}stc_pwu_pwuc_field_t;

typedef union un_pwu_pwuc{
    uint_io8_t		u8Register;
    stc_pwu_pwuc_field_t		stcField;
}un_pwu_pwuc_t;

/* ADTC */
#define PWU_ADTC	(PWU.unADTC.u8Register)  /*@rg@*/
#define PWU_ADTC_ADSTCH	(PWU.unADTC.stcField.u5ADSTCH)  /*@bf@*/
#define PWU_ADTC_ADHWTS	(*(volatile uint_io8_t*)0xB7E0400F)  /*@bfbba@*/

typedef struct stc_pwu_adtc_field{
    uint_io8_t		u5ADSTCH:5;
    uint_io8_t		:2;
    uint_io8_t		u1ADHWTS:1;
}stc_pwu_adtc_field_t;

typedef union un_pwu_adtc{
    uint_io8_t		u8Register;
    stc_pwu_adtc_field_t		stcField;
}un_pwu_adtc_t;


typedef struct stc_pwu{
    un_pwu_pwuc_t	unPWUC;	/* 0x00000000 */
    un_pwu_adtc_t	unADTC;	/* 0x00000001 */
    uint_io8_t	au8Reserved0[1022];	/* 0x00000002 */
}stc_pwu_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_pwu_t	stcPWU;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 1024(0x400) bytes */


#endif /* __S6J3360_PWU_H */
