#include "EOL_Para.h"

#pragma ghs section bss = ".myNonInitArea"
_EOL_F1F8           EOL_F1F8;
#pragma ghs section bss = default

void EOL_InitVal(void)
{
    EOL_F1F8.Data [ 0u ]  = 0xFFu;
    EOL_F1F8.Data [ 1u ]  = 0xFFu;
    EOL_F1F8.Data [ 2u ]  = 0xFFu;
    EOL_F1F8.Data [ 3u ]  = 0xFFu;
    EOL_F1F8.Data [ 4u ]  = 0xFFu;
    EOL_F1F8.Data [ 5u ]  = 0xFFu;
    EOL_F1F8.Data [ 6u ]  = 0xFFu;
    EOL_F1F8.Data [ 7u ]  = 0xFFu;
    EOL_F1F8.Data [ 8u ]  = 0xFFu;
    EOL_F1F8.Data [ 9u ]  = 0xFFu;
    EOL_F1F8.Data [ 10u ] = 0xFFu;
    EOL_F1F8.Data [ 11u ] = 0xFFu;
    EOL_F1F8.Data [ 12u ] = 0xFFu;
    EOL_F1F8.Data [ 13u ] = 0xFFu;
    EOL_F1F8.Data [ 14u ] = 0xFFu;
    EOL_F1F8.Data [ 15u ] = 0xFFu;
}

void EOL_SetF1F8(uint8_t EOL [], uint8_t len)
{
    uint8_t i;

    if ( len == 16u )
    {
        for ( i = 0u; i < sizeof(EOL_F1F8); i++ )
        {
            EOL_F1F8.Data [ i ] = EOL [ i ];
        }
    }
}

_EOL_F1F8 EOL_GetF1F8(void)
{
    return EOL_F1F8;
}

/*F1F8*/
/*BYTE0*/
uint8_t Val_EOL_F1F8_GearboxType(void)
{
    return (EOL_F1F8.Data [ 0u ] >> 0u) & 0x03;
}

uint8_t Val_EOL_F1F8_ButtonType(void)
{
    return (EOL_F1F8.Data [ 0u ] >> 4u) & 0x03;
}

uint8_t Val_EOL_F1F8_EngineModel(void)
{
    return (EOL_F1F8.Data [ 0u ] >> 6u) & 0x03;
}
/*BYTE1*/
uint8_t Val_EOL_F1F8_Language(void)
{
    return (EOL_F1F8.Data [ 1u ] >> 0u) & 0x03;
}

uint8_t Val_EOL_F1F8_HydraulicsPressure(void)
{
    return (EOL_F1F8.Data [ 1u ] >> 2u) & 0x03;
}

uint8_t Val_EOL_F1F8_GeneratorType(void)
{
    return (EOL_F1F8.Data [ 1u ] >> 4u) & 0x03;
}

uint8_t Val_EOL_F1F8_SeatMemory(void)
{
    return (EOL_F1F8.Data [ 1u ] >> 6u) & 0x03;
}
/*BYTE2*/
uint8_t Val_EOL_F1F8_SpeedingWarningF24(void)
{
    return (EOL_F1F8.Data [ 2u ] >> 0u) & 0x03;
}

uint8_t Val_EOL_F1F8_TirePressureProgram(void)
{
    return (EOL_F1F8.Data [ 2u ] >> 2u) & 0x03;
}

uint8_t Val_EOL_F1F8_HandbrakeType(void)
{
    return (EOL_F1F8.Data [ 2u ] >> 4u) & 0x03;
}

uint8_t Val_EOL_F1F8_TheRearSeatBeltIsNotReminded(void)
{
    return (EOL_F1F8.Data [ 2u ] >> 6u) & 0x03;
}
/*BYTE3*/
uint8_t Val_EOL_F1F8_SkylightType(void)
{
    return (EOL_F1F8.Data [ 3u ] >> 0u) & 0x03;
}

uint8_t Val_EOL_F1F8_PEPS(void)
{
    return (EOL_F1F8.Data [ 3u ] >> 2u) & 0x03;
}

uint8_t Val_EOL_F1F8_MaintenanceMileage(void)
{
    return (EOL_F1F8.Data [ 3u ] >> 4u) & 0x03;
}

uint8_t Val_EOL_F1F8_IdleStartAndStop(void)
{
    return (EOL_F1F8.Data [ 3u ] >> 6u) & 0x03;
}
/*BYTE4*/
uint8_t Val_EOL_F1F8_CruiseControl(void)
{
    return (EOL_F1F8.Data [ 4u ] >> 0u) & 0x03;
}

uint8_t Val_EOL_F1F8_ShiftReminder(void)
{
    return (EOL_F1F8.Data [ 4u ] >> 2u) & 0x03;
}

uint8_t Val_EOL_F1F8_GPF(void)
{
    return (EOL_F1F8.Data [ 4u ] >> 4u) & 0x03;
}

uint8_t Val_EOL_F1F8_GearDsisplay(void)
{
    return (EOL_F1F8.Data [ 4u ] >> 6u) & 0x03;
}
/*BYTE5*/
uint8_t Val_EOL_F1F8_TransmissionSystemFailurePrompt(void)
{
    return (EOL_F1F8.Data [ 5u ] >> 0u) & 0x03;
}

uint8_t Val_EOL_F1F8_HighTransmissionOilTemperatureReminder(void)
{
    return (EOL_F1F8.Data [ 5u ] >> 2u) & 0x03;
}

uint8_t Val_EOL_F1F8_Co_pilotSeatBelt(void)
{
    return (EOL_F1F8.Data [ 5u ] >> 4u) & 0x03;
}

uint8_t Val_EOL_F1F8_PowerSteeringMode(void)
{
    return (EOL_F1F8.Data [ 5u ] >> 6u) & 0x03;
}
/*BYTE6*/
uint8_t Val_EOL_F1F8_AVH(void)
{
    return (EOL_F1F8.Data [ 6u ] >> 0u) & 0x03;
}

uint8_t Val_EOL_F1F8_NormalMTModelStart(void)
{
    return (EOL_F1F8.Data [ 6u ] >> 2u) & 0x03;
}

uint8_t Val_EOL_F1F8_RainSensorFailureAlarm(void)
{
    return (EOL_F1F8.Data [ 6u ] >> 4u) & 0x03;
}

uint8_t Val_EOL_F1F8_LowWashingLiquidLevelAlarm(void)
{
    return (EOL_F1F8.Data [ 6u ] >> 6u) & 0x03;
}
/*BYTE7*/
uint8_t Val_EOL_F1F8_AmbientLightSensorFailureAlarm(void)
{
    return (EOL_F1F8.Data [ 7u ] >> 0u) & 0x03;
}

uint8_t Val_EOL_F1F8_MeterBacklightBrightnessAdjustment(void)
{
    return (EOL_F1F8.Data [ 7u ] >> 2u) & 0x03;
}

uint8_t Val_EOL_F1F8_ExportType(void)
{
    return (EOL_F1F8.Data [ 7u ] >> 4u) & 0x03;
}
/*BYTE8*/
uint8_t Val_EOL_F1F8_ModelClass(void)
{
    return (EOL_F1F8.Data [ 8u ] >> 0u) & 0xFF;
}
