#ifndef _BU91R65_USER_H_
#define _BU91R65_USER_H_
#include "TYW_stdint.h"


#define BU91R65SEGMAX 160   /* 段码段码最大值 */
#define SEG_7_MAX 7
#define SEG_16_MAX 16
// #define BU91R65NUMBERMAX 7 /* 数字段数最大值 */
typedef enum
{
    BU91R65_NUMBER_SEG_7 = 0,
    BU91R65_NUMBER_SEG_16,
    BU91R65_NUMBER_SEG_MAX,
} BU91R65_Number_SEG_en_t; /* 段码段 */
typedef enum
{
    BU91R65_CHANNEL_1 = 0,
    BU91R65_CHANNEL_2,
    BU91R65_CHANNEL_MAX,
} BU91R65_Channel_en_t; /* 段码通道 */

typedef enum
{
    BU91R65_COM_0 = 0,
    BU91R65_COM_1,
    BU91R65_COM_2,
    BU91R65_COM_3,
    BU91R65_COM_MAX,
} BU91R65_COM_en_t; /* 段码通道 */


typedef enum
{
    BU91R65_Disable = 0,
    BU91R65_Enable,
} BU91R65_Enable_en_t; /* 段码点亮等级 */

typedef enum
{
    BU91R65DIS_NUMBLE_0 = 0,
    BU91R65DIS_NUMBLE_1,
    BU91R65DIS_NUMBLE_2,
    BU91R65DIS_NUMBLE_3,
    BU91R65DIS_NUMBLE_4,
    BU91R65DIS_NUMBLE_5,
    BU91R65DIS_NUMBLE_6,
    BU91R65DIS_NUMBLE_7,
    BU91R65DIS_NUMBLE_8,
    BU91R65DIS_NUMBLE_9,
    BU91R65DIS_ALPHABET_A,
    BU91R65DIS_ALPHABET_B,
    BU91R65DIS_ALPHABET_C,
    BU91R65DIS_ALPHABET_D,
    BU91R65DIS_ALPHABET_E,
    BU91R65DIS_ALPHABET_F,
    BU91R65DIS_ALPHABET_U,
    BU91R65DIS_ALPHABET_P,
    BU91R65DIS_ALPHABET_L,
    BU91R65DIS_ALPHABET_H,
    BU91R65DIS_NUMBLE_LINE,
    BU91R65DIS_NUMBLE_NULL,
    BU91R65DIS_MAX_7,
} BU91R65_Numble7_Mask_en_t; /* 段码掩码(7段适用) */
typedef enum
{
    BU91R65DIS16_NUMBLE_0 = 0,
    BU91R65DIS16_NUMBLE_1,
    BU91R65DIS16_NUMBLE_2,
    BU91R65DIS16_NUMBLE_3,
    BU91R65DIS16_NUMBLE_4,
    BU91R65DIS16_NUMBLE_5,
    BU91R65DIS16_NUMBLE_6,
    BU91R65DIS16_NUMBLE_7,
    BU91R65DIS16_NUMBLE_8,
    BU91R65DIS16_NUMBLE_9,
    BU91R65DIS16_ALPHABET_A,
    BU91R65DIS16_ALPHABET_B,
    BU91R65DIS16_ALPHABET_C,
    BU91R65DIS16_ALPHABET_D,
    BU91R65DIS16_ALPHABET_E,
    BU91R65DIS16_ALPHABET_F,
    BU91R65DIS16_ALPHABET_G,
    BU91R65DIS16_ALPHABET_H,
    BU91R65DIS16_ALPHABET_I,
    BU91R65DIS16_ALPHABET_J,
    BU91R65DIS16_ALPHABET_K,
    BU91R65DIS16_ALPHABET_L,
    BU91R65DIS16_ALPHABET_M,
    BU91R65DIS16_ALPHABET_N,
    BU91R65DIS16_ALPHABET_O,
    BU91R65DIS16_ALPHABET_P,
    BU91R65DIS16_ALPHABET_Q,
    BU91R65DIS16_ALPHABET_R,
    BU91R65DIS16_ALPHABET_S,
    BU91R65DIS16_ALPHABET_T,
    BU91R65DIS16_ALPHABET_U,
    BU91R65DIS16_ALPHABET_V,
    BU91R65DIS16_ALPHABET_W,
    BU91R65DIS16_ALPHABET_X,
    BU91R65DIS16_ALPHABET_Y,
    BU91R65DIS16_ALPHABET_Z,
    BU91R65DIS16_NUMBLE_mul,//乘        x
    BU91R65DIS16_NUMBLE_add,//加        +
    BU91R65DIS16_NUMBLE_sub,//减        -
    BU91R65DIS16_NUMBLE_exc,//除        /
    BU91R65DIS16_NUMBLE_LMPar,//左中括号 [
    BU91R65DIS16_NUMBLE_RMPar,//右中括号 ]
    BU91R65DIS16_NUMBLE_LSPar,//左小括号 (
    BU91R65DIS16_NUMBLE_RSPar,//右小括号 )
    BU91R65DIS16_NUMBLE_equal,//等于     =
    BU91R65DIS16_NUMBLE_degrees,//度     °
    BU91R65DIS16_NUMBLE__,   //下划线   _
    BU91R65DIS16_NUMBLE_NULL,//空
    BU91R65DIS16_MAX_16,
} BU91R65_Numble16_Mask_en_t; /* 段码掩码(16段适用) */

typedef struct
{
    BU91R65_Channel_en_t enBU91R65Channel; /* 选择第几片段码 */
    uint8_t u8BU91R65_COM;                 /* 需显示的COM */
    uint8_t u8BU91R65_Seg;                 /* 需显示的SEG值 */
} BU91R65_USER_st_t;


/**
 * @brief 设置段码显示数字或字母显示
 * @param pBU91R65User 传入BU91R65_USER_st_t指针
 * @param enBU91R65Value 需要显示的内容 数字或者字母详见BU91R65_Numble7_Mask_en_t BU91R65_Numble27_Mask_en_t BU91R65_Numble25_Mask_en_t BU91R65_Numble23_Mask_en_t
 * @param enBU91R65SEGNum 需要显示的段码段数 详见 BU91R65_Number_SEG_en_t 以及示例图 若没有可以联系作者补上掩码
 * @param Enable 是否点亮
 * @return 0:正确 1 传入关闭等级错误 2 传入空指针 3 传入SEG错误或设置段码通道错误 或传入enBU91R65Value错误
 */
extern uint8_t BU91R65_Set_Numble(const BU91R65_USER_st_t* pBU91R65User, uint8_t enBU91R65Value, BU91R65_Number_SEG_en_t enBU91R65SEGNum, uint8_t Enable);

void Clear_All_BU91R65(void);
// void BU91R65_DSIP(void);
#define LIBERTY_STRING_LENTH 17

void Liberty_String_Display(const uint8_t f_blank_num, const uint8_t *dat);
void  BU91R65_Clear_NUM_7(const BU91R65_USER_st_t* pBU91R65User);
void Liberty_String_Display_Init(void );
#endif
