/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_CANFD_H
#define __S6J3360_CANFD_H

#include "s6j3360io_basetypes.h"

/* CPG_CANFD[0-3] base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define CPG_CANFD0	stcCPG_CANFD[0]
#define CPG_CANFD1	stcCPG_CANFD[1]
#define CPG_CANFD2	stcCPG_CANFD[2]
#define CPG_CANFD3	stcCPG_CANFD[3]
#else /* __IO_DEFINE */
#define CPG_CANFD0	(*((volatile stc_cpg_canfdn_t*)0xB4900000))
#define CPG_CANFD1	(*((volatile stc_cpg_canfdn_t*)0xB4910000))
#define CPG_CANFD2	(*((volatile stc_cpg_canfdn_t*)0xB4920000))
#define CPG_CANFD3	(*((volatile stc_cpg_canfdn_t*)0xB4930000))
#endif /* __IO_DEFINE */

/* CREL */
#define CPG_CANFD0_CREL	(CPG_CANFD0.unCREL.u32Register)  /*@rg@*/
#define CPG_CANFD0_CREL_DAY	(CPG_CANFD0.unCREL.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD0_CREL_MON	(CPG_CANFD0.unCREL.au8Byte[1])  /*@bfbyte@*/
#define CPG_CANFD0_CREL_YEAR	(CPG_CANFD0.unCREL.stcField.u4YEAR)  /*@bf@*/
#define CPG_CANFD0_CREL_SUBSTEP	(CPG_CANFD0.unCREL.stcField.u4SUBSTEP)  /*@bf@*/
#define CPG_CANFD0_CREL_STEP	(CPG_CANFD0.unCREL.stcField.u4STEP)  /*@bf@*/
#define CPG_CANFD0_CREL_REL	(CPG_CANFD0.unCREL.stcField.u4REL)  /*@bf@*/

#define CPG_CANFD1_CREL	(CPG_CANFD1.unCREL.u32Register)  /*@rg@*/
#define CPG_CANFD1_CREL_DAY	(CPG_CANFD1.unCREL.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD1_CREL_MON	(CPG_CANFD1.unCREL.au8Byte[1])  /*@bfbyte@*/
#define CPG_CANFD1_CREL_YEAR	(CPG_CANFD1.unCREL.stcField.u4YEAR)  /*@bf@*/
#define CPG_CANFD1_CREL_SUBSTEP	(CPG_CANFD1.unCREL.stcField.u4SUBSTEP)  /*@bf@*/
#define CPG_CANFD1_CREL_STEP	(CPG_CANFD1.unCREL.stcField.u4STEP)  /*@bf@*/
#define CPG_CANFD1_CREL_REL	(CPG_CANFD1.unCREL.stcField.u4REL)  /*@bf@*/

#define CPG_CANFD2_CREL	(CPG_CANFD2.unCREL.u32Register)  /*@rg@*/
#define CPG_CANFD2_CREL_DAY	(CPG_CANFD2.unCREL.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD2_CREL_MON	(CPG_CANFD2.unCREL.au8Byte[1])  /*@bfbyte@*/
#define CPG_CANFD2_CREL_YEAR	(CPG_CANFD2.unCREL.stcField.u4YEAR)  /*@bf@*/
#define CPG_CANFD2_CREL_SUBSTEP	(CPG_CANFD2.unCREL.stcField.u4SUBSTEP)  /*@bf@*/
#define CPG_CANFD2_CREL_STEP	(CPG_CANFD2.unCREL.stcField.u4STEP)  /*@bf@*/
#define CPG_CANFD2_CREL_REL	(CPG_CANFD2.unCREL.stcField.u4REL)  /*@bf@*/

#define CPG_CANFD3_CREL	(CPG_CANFD3.unCREL.u32Register)  /*@rg@*/
#define CPG_CANFD3_CREL_DAY	(CPG_CANFD3.unCREL.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD3_CREL_MON	(CPG_CANFD3.unCREL.au8Byte[1])  /*@bfbyte@*/
#define CPG_CANFD3_CREL_YEAR	(CPG_CANFD3.unCREL.stcField.u4YEAR)  /*@bf@*/
#define CPG_CANFD3_CREL_SUBSTEP	(CPG_CANFD3.unCREL.stcField.u4SUBSTEP)  /*@bf@*/
#define CPG_CANFD3_CREL_STEP	(CPG_CANFD3.unCREL.stcField.u4STEP)  /*@bf@*/
#define CPG_CANFD3_CREL_REL	(CPG_CANFD3.unCREL.stcField.u4REL)  /*@bf@*/

typedef struct stc_cpg_canfdn_crel_field{
    uint_io32_t		u8DAY:8;
    uint_io32_t		u8MON:8;
    uint_io32_t		u4YEAR:4;
    uint_io32_t		u4SUBSTEP:4;
    uint_io32_t		u4STEP:4;
    uint_io32_t		u4REL:4;
}stc_cpg_canfdn_crel_field_t;

typedef union un_cpg_canfdn_crel{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_crel_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_crel_t;

/* ENDN */
#define CPG_CANFD0_ENDN	(CPG_CANFD0.unENDN.u32Register)  /*@rg@*/
#define CPG_CANFD0_ENDN_ETV	CPG_CANFD0_ENDN  /*@bfrg@*/

#define CPG_CANFD1_ENDN	(CPG_CANFD1.unENDN.u32Register)  /*@rg@*/
#define CPG_CANFD1_ENDN_ETV	CPG_CANFD1_ENDN  /*@bfrg@*/

#define CPG_CANFD2_ENDN	(CPG_CANFD2.unENDN.u32Register)  /*@rg@*/
#define CPG_CANFD2_ENDN_ETV	CPG_CANFD2_ENDN  /*@bfrg@*/

#define CPG_CANFD3_ENDN	(CPG_CANFD3.unENDN.u32Register)  /*@rg@*/
#define CPG_CANFD3_ENDN_ETV	CPG_CANFD3_ENDN  /*@bfrg@*/

typedef union un_cpg_canfdn_endn{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_endn_t;

/* DBTP */
#define CPG_CANFD0_DBTP	(CPG_CANFD0.unDBTP.u32Register)  /*@rg@*/
#define CPG_CANFD0_DBTP_DSJW	(CPG_CANFD0.unDBTP.stcField.u4DSJW)  /*@bf@*/
#define CPG_CANFD0_DBTP_DTSEG2	(CPG_CANFD0.unDBTP.stcField.u4DTSEG2)  /*@bf@*/
#define CPG_CANFD0_DBTP_DTSEG1	(CPG_CANFD0.unDBTP.stcField.u5DTSEG1)  /*@bf@*/
#define CPG_CANFD0_DBTP_DBRP	(CPG_CANFD0.unDBTP.stcField.u5DBRP)  /*@bf@*/
#define CPG_CANFD0_DBTP_TDC	(CPG_CANFD0.unDBTP.stcField.u1TDC)  /*@bf@*/

#define CPG_CANFD1_DBTP	(CPG_CANFD1.unDBTP.u32Register)  /*@rg@*/
#define CPG_CANFD1_DBTP_DSJW	(CPG_CANFD1.unDBTP.stcField.u4DSJW)  /*@bf@*/
#define CPG_CANFD1_DBTP_DTSEG2	(CPG_CANFD1.unDBTP.stcField.u4DTSEG2)  /*@bf@*/
#define CPG_CANFD1_DBTP_DTSEG1	(CPG_CANFD1.unDBTP.stcField.u5DTSEG1)  /*@bf@*/
#define CPG_CANFD1_DBTP_DBRP	(CPG_CANFD1.unDBTP.stcField.u5DBRP)  /*@bf@*/
#define CPG_CANFD1_DBTP_TDC	(CPG_CANFD1.unDBTP.stcField.u1TDC)  /*@bf@*/

#define CPG_CANFD2_DBTP	(CPG_CANFD2.unDBTP.u32Register)  /*@rg@*/
#define CPG_CANFD2_DBTP_DSJW	(CPG_CANFD2.unDBTP.stcField.u4DSJW)  /*@bf@*/
#define CPG_CANFD2_DBTP_DTSEG2	(CPG_CANFD2.unDBTP.stcField.u4DTSEG2)  /*@bf@*/
#define CPG_CANFD2_DBTP_DTSEG1	(CPG_CANFD2.unDBTP.stcField.u5DTSEG1)  /*@bf@*/
#define CPG_CANFD2_DBTP_DBRP	(CPG_CANFD2.unDBTP.stcField.u5DBRP)  /*@bf@*/
#define CPG_CANFD2_DBTP_TDC	(CPG_CANFD2.unDBTP.stcField.u1TDC)  /*@bf@*/

#define CPG_CANFD3_DBTP	(CPG_CANFD3.unDBTP.u32Register)  /*@rg@*/
#define CPG_CANFD3_DBTP_DSJW	(CPG_CANFD3.unDBTP.stcField.u4DSJW)  /*@bf@*/
#define CPG_CANFD3_DBTP_DTSEG2	(CPG_CANFD3.unDBTP.stcField.u4DTSEG2)  /*@bf@*/
#define CPG_CANFD3_DBTP_DTSEG1	(CPG_CANFD3.unDBTP.stcField.u5DTSEG1)  /*@bf@*/
#define CPG_CANFD3_DBTP_DBRP	(CPG_CANFD3.unDBTP.stcField.u5DBRP)  /*@bf@*/
#define CPG_CANFD3_DBTP_TDC	(CPG_CANFD3.unDBTP.stcField.u1TDC)  /*@bf@*/

typedef struct stc_cpg_canfdn_dbtp_field{
    uint_io32_t		u4DSJW:4;
    uint_io32_t		u4DTSEG2:4;
    uint_io32_t		u5DTSEG1:5;
    uint_io32_t		:3;
    uint_io32_t		u5DBRP:5;
    uint_io32_t		:2;
    uint_io32_t		u1TDC:1;
    uint_io32_t		:8;
}stc_cpg_canfdn_dbtp_field_t;

typedef union un_cpg_canfdn_dbtp{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_dbtp_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_dbtp_t;

/* TEST */
#define CPG_CANFD0_TEST	(CPG_CANFD0.unTEST.u32Register)  /*@rg@*/
#define CPG_CANFD0_TEST_LBCK	(CPG_CANFD0.unTEST.stcField.u1LBCK)  /*@bf@*/
#define CPG_CANFD0_TEST_TX	(CPG_CANFD0.unTEST.stcField.u2TX)  /*@bf@*/
#define CPG_CANFD0_TEST_RX	(CPG_CANFD0.unTEST.stcField.u1RX)  /*@bf@*/

#define CPG_CANFD1_TEST	(CPG_CANFD1.unTEST.u32Register)  /*@rg@*/
#define CPG_CANFD1_TEST_LBCK	(CPG_CANFD1.unTEST.stcField.u1LBCK)  /*@bf@*/
#define CPG_CANFD1_TEST_TX	(CPG_CANFD1.unTEST.stcField.u2TX)  /*@bf@*/
#define CPG_CANFD1_TEST_RX	(CPG_CANFD1.unTEST.stcField.u1RX)  /*@bf@*/

#define CPG_CANFD2_TEST	(CPG_CANFD2.unTEST.u32Register)  /*@rg@*/
#define CPG_CANFD2_TEST_LBCK	(CPG_CANFD2.unTEST.stcField.u1LBCK)  /*@bf@*/
#define CPG_CANFD2_TEST_TX	(CPG_CANFD2.unTEST.stcField.u2TX)  /*@bf@*/
#define CPG_CANFD2_TEST_RX	(CPG_CANFD2.unTEST.stcField.u1RX)  /*@bf@*/

#define CPG_CANFD3_TEST	(CPG_CANFD3.unTEST.u32Register)  /*@rg@*/
#define CPG_CANFD3_TEST_LBCK	(CPG_CANFD3.unTEST.stcField.u1LBCK)  /*@bf@*/
#define CPG_CANFD3_TEST_TX	(CPG_CANFD3.unTEST.stcField.u2TX)  /*@bf@*/
#define CPG_CANFD3_TEST_RX	(CPG_CANFD3.unTEST.stcField.u1RX)  /*@bf@*/

typedef struct stc_cpg_canfdn_test_field{
    uint_io32_t		:4;
    uint_io32_t		u1LBCK:1;
    uint_io32_t		u2TX:2;
    uint_io32_t		u1RX:1;
    uint_io32_t		:24;
}stc_cpg_canfdn_test_field_t;

typedef union un_cpg_canfdn_test{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_test_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_test_t;

/* RWD */
#define CPG_CANFD0_RWD	(CPG_CANFD0.unRWD.u32Register)  /*@rg@*/
#define CPG_CANFD0_RWD_WDC	(CPG_CANFD0.unRWD.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD0_RWD_WDV	(CPG_CANFD0.unRWD.au8Byte[1])  /*@bfbyte@*/

#define CPG_CANFD1_RWD	(CPG_CANFD1.unRWD.u32Register)  /*@rg@*/
#define CPG_CANFD1_RWD_WDC	(CPG_CANFD1.unRWD.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD1_RWD_WDV	(CPG_CANFD1.unRWD.au8Byte[1])  /*@bfbyte@*/

#define CPG_CANFD2_RWD	(CPG_CANFD2.unRWD.u32Register)  /*@rg@*/
#define CPG_CANFD2_RWD_WDC	(CPG_CANFD2.unRWD.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD2_RWD_WDV	(CPG_CANFD2.unRWD.au8Byte[1])  /*@bfbyte@*/

#define CPG_CANFD3_RWD	(CPG_CANFD3.unRWD.u32Register)  /*@rg@*/
#define CPG_CANFD3_RWD_WDC	(CPG_CANFD3.unRWD.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD3_RWD_WDV	(CPG_CANFD3.unRWD.au8Byte[1])  /*@bfbyte@*/

typedef struct stc_cpg_canfdn_rwd_field{
    uint_io32_t		u8WDC:8;
    uint_io32_t		u8WDV:8;
    uint_io32_t		:16;
}stc_cpg_canfdn_rwd_field_t;

typedef union un_cpg_canfdn_rwd{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_rwd_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_rwd_t;

/* CCCR */
#define CPG_CANFD0_CCCR	(CPG_CANFD0.unCCCR.u32Register)  /*@rg@*/
#define CPG_CANFD0_CCCR_INIT	(CPG_CANFD0.unCCCR.stcField.u1INIT)  /*@bf@*/
#define CPG_CANFD0_CCCR_CCE	(CPG_CANFD0.unCCCR.stcField.u1CCE)  /*@bf@*/
#define CPG_CANFD0_CCCR_ASM	(CPG_CANFD0.unCCCR.stcField.u1ASM)  /*@bf@*/
#define CPG_CANFD0_CCCR_CSA	(CPG_CANFD0.unCCCR.stcField.u1CSA)  /*@bf@*/
#define CPG_CANFD0_CCCR_CSR	(CPG_CANFD0.unCCCR.stcField.u1CSR)  /*@bf@*/
#define CPG_CANFD0_CCCR_MON	(CPG_CANFD0.unCCCR.stcField.u1MON)  /*@bf@*/
#define CPG_CANFD0_CCCR_DAR	(CPG_CANFD0.unCCCR.stcField.u1DAR)  /*@bf@*/
#define CPG_CANFD0_CCCR_TEST	(CPG_CANFD0.unCCCR.stcField.u1TEST)  /*@bf@*/
#define CPG_CANFD0_CCCR_FDOE	(CPG_CANFD0.unCCCR.stcField.u1FDOE)  /*@bf@*/
#define CPG_CANFD0_CCCR_BRSE	(CPG_CANFD0.unCCCR.stcField.u1BRSE)  /*@bf@*/
#define CPG_CANFD0_CCCR_PXHD	(CPG_CANFD0.unCCCR.stcField.u1PXHD)  /*@bf@*/
#define CPG_CANFD0_CCCR_EFBI	(CPG_CANFD0.unCCCR.stcField.u1EFBI)  /*@bf@*/
#define CPG_CANFD0_CCCR_TXP	(CPG_CANFD0.unCCCR.stcField.u1TXP)  /*@bf@*/
#define CPG_CANFD0_CCCR_NISO	(CPG_CANFD0.unCCCR.stcField.u1NISO)  /*@bf@*/

#define CPG_CANFD1_CCCR	(CPG_CANFD1.unCCCR.u32Register)  /*@rg@*/
#define CPG_CANFD1_CCCR_INIT	(CPG_CANFD1.unCCCR.stcField.u1INIT)  /*@bf@*/
#define CPG_CANFD1_CCCR_CCE	(CPG_CANFD1.unCCCR.stcField.u1CCE)  /*@bf@*/
#define CPG_CANFD1_CCCR_ASM	(CPG_CANFD1.unCCCR.stcField.u1ASM)  /*@bf@*/
#define CPG_CANFD1_CCCR_CSA	(CPG_CANFD1.unCCCR.stcField.u1CSA)  /*@bf@*/
#define CPG_CANFD1_CCCR_CSR	(CPG_CANFD1.unCCCR.stcField.u1CSR)  /*@bf@*/
#define CPG_CANFD1_CCCR_MON	(CPG_CANFD1.unCCCR.stcField.u1MON)  /*@bf@*/
#define CPG_CANFD1_CCCR_DAR	(CPG_CANFD1.unCCCR.stcField.u1DAR)  /*@bf@*/
#define CPG_CANFD1_CCCR_TEST	(CPG_CANFD1.unCCCR.stcField.u1TEST)  /*@bf@*/
#define CPG_CANFD1_CCCR_FDOE	(CPG_CANFD1.unCCCR.stcField.u1FDOE)  /*@bf@*/
#define CPG_CANFD1_CCCR_BRSE	(CPG_CANFD1.unCCCR.stcField.u1BRSE)  /*@bf@*/
#define CPG_CANFD1_CCCR_PXHD	(CPG_CANFD1.unCCCR.stcField.u1PXHD)  /*@bf@*/
#define CPG_CANFD1_CCCR_EFBI	(CPG_CANFD1.unCCCR.stcField.u1EFBI)  /*@bf@*/
#define CPG_CANFD1_CCCR_TXP	(CPG_CANFD1.unCCCR.stcField.u1TXP)  /*@bf@*/
#define CPG_CANFD1_CCCR_NISO	(CPG_CANFD1.unCCCR.stcField.u1NISO)  /*@bf@*/

#define CPG_CANFD2_CCCR	(CPG_CANFD2.unCCCR.u32Register)  /*@rg@*/
#define CPG_CANFD2_CCCR_INIT	(CPG_CANFD2.unCCCR.stcField.u1INIT)  /*@bf@*/
#define CPG_CANFD2_CCCR_CCE	(CPG_CANFD2.unCCCR.stcField.u1CCE)  /*@bf@*/
#define CPG_CANFD2_CCCR_ASM	(CPG_CANFD2.unCCCR.stcField.u1ASM)  /*@bf@*/
#define CPG_CANFD2_CCCR_CSA	(CPG_CANFD2.unCCCR.stcField.u1CSA)  /*@bf@*/
#define CPG_CANFD2_CCCR_CSR	(CPG_CANFD2.unCCCR.stcField.u1CSR)  /*@bf@*/
#define CPG_CANFD2_CCCR_MON	(CPG_CANFD2.unCCCR.stcField.u1MON)  /*@bf@*/
#define CPG_CANFD2_CCCR_DAR	(CPG_CANFD2.unCCCR.stcField.u1DAR)  /*@bf@*/
#define CPG_CANFD2_CCCR_TEST	(CPG_CANFD2.unCCCR.stcField.u1TEST)  /*@bf@*/
#define CPG_CANFD2_CCCR_FDOE	(CPG_CANFD2.unCCCR.stcField.u1FDOE)  /*@bf@*/
#define CPG_CANFD2_CCCR_BRSE	(CPG_CANFD2.unCCCR.stcField.u1BRSE)  /*@bf@*/
#define CPG_CANFD2_CCCR_PXHD	(CPG_CANFD2.unCCCR.stcField.u1PXHD)  /*@bf@*/
#define CPG_CANFD2_CCCR_EFBI	(CPG_CANFD2.unCCCR.stcField.u1EFBI)  /*@bf@*/
#define CPG_CANFD2_CCCR_TXP	(CPG_CANFD2.unCCCR.stcField.u1TXP)  /*@bf@*/
#define CPG_CANFD2_CCCR_NISO	(CPG_CANFD2.unCCCR.stcField.u1NISO)  /*@bf@*/

#define CPG_CANFD3_CCCR	(CPG_CANFD3.unCCCR.u32Register)  /*@rg@*/
#define CPG_CANFD3_CCCR_INIT	(CPG_CANFD3.unCCCR.stcField.u1INIT)  /*@bf@*/
#define CPG_CANFD3_CCCR_CCE	(CPG_CANFD3.unCCCR.stcField.u1CCE)  /*@bf@*/
#define CPG_CANFD3_CCCR_ASM	(CPG_CANFD3.unCCCR.stcField.u1ASM)  /*@bf@*/
#define CPG_CANFD3_CCCR_CSA	(CPG_CANFD3.unCCCR.stcField.u1CSA)  /*@bf@*/
#define CPG_CANFD3_CCCR_CSR	(CPG_CANFD3.unCCCR.stcField.u1CSR)  /*@bf@*/
#define CPG_CANFD3_CCCR_MON	(CPG_CANFD3.unCCCR.stcField.u1MON)  /*@bf@*/
#define CPG_CANFD3_CCCR_DAR	(CPG_CANFD3.unCCCR.stcField.u1DAR)  /*@bf@*/
#define CPG_CANFD3_CCCR_TEST	(CPG_CANFD3.unCCCR.stcField.u1TEST)  /*@bf@*/
#define CPG_CANFD3_CCCR_FDOE	(CPG_CANFD3.unCCCR.stcField.u1FDOE)  /*@bf@*/
#define CPG_CANFD3_CCCR_BRSE	(CPG_CANFD3.unCCCR.stcField.u1BRSE)  /*@bf@*/
#define CPG_CANFD3_CCCR_PXHD	(CPG_CANFD3.unCCCR.stcField.u1PXHD)  /*@bf@*/
#define CPG_CANFD3_CCCR_EFBI	(CPG_CANFD3.unCCCR.stcField.u1EFBI)  /*@bf@*/
#define CPG_CANFD3_CCCR_TXP	(CPG_CANFD3.unCCCR.stcField.u1TXP)  /*@bf@*/
#define CPG_CANFD3_CCCR_NISO	(CPG_CANFD3.unCCCR.stcField.u1NISO)  /*@bf@*/

typedef struct stc_cpg_canfdn_cccr_field{
    uint_io32_t		u1INIT:1;
    uint_io32_t		u1CCE:1;
    uint_io32_t		u1ASM:1;
    uint_io32_t		u1CSA:1;
    uint_io32_t		u1CSR:1;
    uint_io32_t		u1MON:1;
    uint_io32_t		u1DAR:1;
    uint_io32_t		u1TEST:1;
    uint_io32_t		u1FDOE:1;
    uint_io32_t		u1BRSE:1;
    uint_io32_t		:2;
    uint_io32_t		u1PXHD:1;
    uint_io32_t		u1EFBI:1;
    uint_io32_t		u1TXP:1;
    uint_io32_t		u1NISO:1;
    uint_io32_t		:16;
}stc_cpg_canfdn_cccr_field_t;

typedef union un_cpg_canfdn_cccr{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_cccr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_cccr_t;

/* NBTP */
#define CPG_CANFD0_NBTP	(CPG_CANFD0.unNBTP.u32Register)  /*@rg@*/
#define CPG_CANFD0_NBTP_NTSEG2	(CPG_CANFD0.unNBTP.stcField.u7NTSEG2)  /*@bf@*/
#define CPG_CANFD0_NBTP_NTSEG1	(CPG_CANFD0.unNBTP.au8Byte[1])  /*@bfbyte@*/
#define CPG_CANFD0_NBTP_NBRP	(CPG_CANFD0.unNBTP.stcField.u9NBRP)  /*@bf@*/
#define CPG_CANFD0_NBTP_NSJW	(CPG_CANFD0.unNBTP.stcField.u7NSJW)  /*@bf@*/

#define CPG_CANFD1_NBTP	(CPG_CANFD1.unNBTP.u32Register)  /*@rg@*/
#define CPG_CANFD1_NBTP_NTSEG2	(CPG_CANFD1.unNBTP.stcField.u7NTSEG2)  /*@bf@*/
#define CPG_CANFD1_NBTP_NTSEG1	(CPG_CANFD1.unNBTP.au8Byte[1])  /*@bfbyte@*/
#define CPG_CANFD1_NBTP_NBRP	(CPG_CANFD1.unNBTP.stcField.u9NBRP)  /*@bf@*/
#define CPG_CANFD1_NBTP_NSJW	(CPG_CANFD1.unNBTP.stcField.u7NSJW)  /*@bf@*/

#define CPG_CANFD2_NBTP	(CPG_CANFD2.unNBTP.u32Register)  /*@rg@*/
#define CPG_CANFD2_NBTP_NTSEG2	(CPG_CANFD2.unNBTP.stcField.u7NTSEG2)  /*@bf@*/
#define CPG_CANFD2_NBTP_NTSEG1	(CPG_CANFD2.unNBTP.au8Byte[1])  /*@bfbyte@*/
#define CPG_CANFD2_NBTP_NBRP	(CPG_CANFD2.unNBTP.stcField.u9NBRP)  /*@bf@*/
#define CPG_CANFD2_NBTP_NSJW	(CPG_CANFD2.unNBTP.stcField.u7NSJW)  /*@bf@*/

#define CPG_CANFD3_NBTP	(CPG_CANFD3.unNBTP.u32Register)  /*@rg@*/
#define CPG_CANFD3_NBTP_NTSEG2	(CPG_CANFD3.unNBTP.stcField.u7NTSEG2)  /*@bf@*/
#define CPG_CANFD3_NBTP_NTSEG1	(CPG_CANFD3.unNBTP.au8Byte[1])  /*@bfbyte@*/
#define CPG_CANFD3_NBTP_NBRP	(CPG_CANFD3.unNBTP.stcField.u9NBRP)  /*@bf@*/
#define CPG_CANFD3_NBTP_NSJW	(CPG_CANFD3.unNBTP.stcField.u7NSJW)  /*@bf@*/

typedef struct stc_cpg_canfdn_nbtp_field{
    uint_io32_t		u7NTSEG2:7;
    uint_io32_t		:1;
    uint_io32_t		u8NTSEG1:8;
    uint_io32_t		u9NBRP:9;
    uint_io32_t		u7NSJW:7;
}stc_cpg_canfdn_nbtp_field_t;

typedef union un_cpg_canfdn_nbtp{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_nbtp_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_nbtp_t;

/* TSCC */
#define CPG_CANFD0_TSCC	(CPG_CANFD0.unTSCC.u32Register)  /*@rg@*/
#define CPG_CANFD0_TSCC_TSS	(CPG_CANFD0.unTSCC.stcField.u2TSS)  /*@bf@*/
#define CPG_CANFD0_TSCC_TCP	(CPG_CANFD0.unTSCC.stcField.u4TCP)  /*@bf@*/

#define CPG_CANFD1_TSCC	(CPG_CANFD1.unTSCC.u32Register)  /*@rg@*/
#define CPG_CANFD1_TSCC_TSS	(CPG_CANFD1.unTSCC.stcField.u2TSS)  /*@bf@*/
#define CPG_CANFD1_TSCC_TCP	(CPG_CANFD1.unTSCC.stcField.u4TCP)  /*@bf@*/

#define CPG_CANFD2_TSCC	(CPG_CANFD2.unTSCC.u32Register)  /*@rg@*/
#define CPG_CANFD2_TSCC_TSS	(CPG_CANFD2.unTSCC.stcField.u2TSS)  /*@bf@*/
#define CPG_CANFD2_TSCC_TCP	(CPG_CANFD2.unTSCC.stcField.u4TCP)  /*@bf@*/

#define CPG_CANFD3_TSCC	(CPG_CANFD3.unTSCC.u32Register)  /*@rg@*/
#define CPG_CANFD3_TSCC_TSS	(CPG_CANFD3.unTSCC.stcField.u2TSS)  /*@bf@*/
#define CPG_CANFD3_TSCC_TCP	(CPG_CANFD3.unTSCC.stcField.u4TCP)  /*@bf@*/

typedef struct stc_cpg_canfdn_tscc_field{
    uint_io32_t		u2TSS:2;
    uint_io32_t		:14;
    uint_io32_t		u4TCP:4;
    uint_io32_t		:12;
}stc_cpg_canfdn_tscc_field_t;

typedef union un_cpg_canfdn_tscc{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_tscc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_tscc_t;

/* TSCV */
#define CPG_CANFD0_TSCV	(CPG_CANFD0.unTSCV.u32Register)  /*@rg@*/
#define CPG_CANFD0_TSCV_TSC	(CPG_CANFD0.unTSCV.au16Halfword[0])  /*@bfhword@*/

#define CPG_CANFD1_TSCV	(CPG_CANFD1.unTSCV.u32Register)  /*@rg@*/
#define CPG_CANFD1_TSCV_TSC	(CPG_CANFD1.unTSCV.au16Halfword[0])  /*@bfhword@*/

#define CPG_CANFD2_TSCV	(CPG_CANFD2.unTSCV.u32Register)  /*@rg@*/
#define CPG_CANFD2_TSCV_TSC	(CPG_CANFD2.unTSCV.au16Halfword[0])  /*@bfhword@*/

#define CPG_CANFD3_TSCV	(CPG_CANFD3.unTSCV.u32Register)  /*@rg@*/
#define CPG_CANFD3_TSCV_TSC	(CPG_CANFD3.unTSCV.au16Halfword[0])  /*@bfhword@*/

typedef struct stc_cpg_canfdn_tscv_field{
    uint_io32_t		u16TSC:16;
    uint_io32_t		:16;
}stc_cpg_canfdn_tscv_field_t;

typedef union un_cpg_canfdn_tscv{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_tscv_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_tscv_t;

/* TOCC */
#define CPG_CANFD0_TOCC	(CPG_CANFD0.unTOCC.u32Register)  /*@rg@*/
#define CPG_CANFD0_TOCC_ETOC	(CPG_CANFD0.unTOCC.stcField.u1ETOC)  /*@bf@*/
#define CPG_CANFD0_TOCC_TOS	(CPG_CANFD0.unTOCC.stcField.u2TOS)  /*@bf@*/
#define CPG_CANFD0_TOCC_TOP	(CPG_CANFD0.unTOCC.au16Halfword[1])  /*@bfhword@*/

#define CPG_CANFD1_TOCC	(CPG_CANFD1.unTOCC.u32Register)  /*@rg@*/
#define CPG_CANFD1_TOCC_ETOC	(CPG_CANFD1.unTOCC.stcField.u1ETOC)  /*@bf@*/
#define CPG_CANFD1_TOCC_TOS	(CPG_CANFD1.unTOCC.stcField.u2TOS)  /*@bf@*/
#define CPG_CANFD1_TOCC_TOP	(CPG_CANFD1.unTOCC.au16Halfword[1])  /*@bfhword@*/

#define CPG_CANFD2_TOCC	(CPG_CANFD2.unTOCC.u32Register)  /*@rg@*/
#define CPG_CANFD2_TOCC_ETOC	(CPG_CANFD2.unTOCC.stcField.u1ETOC)  /*@bf@*/
#define CPG_CANFD2_TOCC_TOS	(CPG_CANFD2.unTOCC.stcField.u2TOS)  /*@bf@*/
#define CPG_CANFD2_TOCC_TOP	(CPG_CANFD2.unTOCC.au16Halfword[1])  /*@bfhword@*/

#define CPG_CANFD3_TOCC	(CPG_CANFD3.unTOCC.u32Register)  /*@rg@*/
#define CPG_CANFD3_TOCC_ETOC	(CPG_CANFD3.unTOCC.stcField.u1ETOC)  /*@bf@*/
#define CPG_CANFD3_TOCC_TOS	(CPG_CANFD3.unTOCC.stcField.u2TOS)  /*@bf@*/
#define CPG_CANFD3_TOCC_TOP	(CPG_CANFD3.unTOCC.au16Halfword[1])  /*@bfhword@*/

typedef struct stc_cpg_canfdn_tocc_field{
    uint_io32_t		u1ETOC:1;
    uint_io32_t		u2TOS:2;
    uint_io32_t		:13;
    uint_io32_t		u16TOP:16;
}stc_cpg_canfdn_tocc_field_t;

typedef union un_cpg_canfdn_tocc{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_tocc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_tocc_t;

/* TOCV */
#define CPG_CANFD0_TOCV	(CPG_CANFD0.unTOCV.u32Register)  /*@rg@*/
#define CPG_CANFD0_TOCV_TOC	(CPG_CANFD0.unTOCV.au16Halfword[0])  /*@bfhword@*/

#define CPG_CANFD1_TOCV	(CPG_CANFD1.unTOCV.u32Register)  /*@rg@*/
#define CPG_CANFD1_TOCV_TOC	(CPG_CANFD1.unTOCV.au16Halfword[0])  /*@bfhword@*/

#define CPG_CANFD2_TOCV	(CPG_CANFD2.unTOCV.u32Register)  /*@rg@*/
#define CPG_CANFD2_TOCV_TOC	(CPG_CANFD2.unTOCV.au16Halfword[0])  /*@bfhword@*/

#define CPG_CANFD3_TOCV	(CPG_CANFD3.unTOCV.u32Register)  /*@rg@*/
#define CPG_CANFD3_TOCV_TOC	(CPG_CANFD3.unTOCV.au16Halfword[0])  /*@bfhword@*/

typedef struct stc_cpg_canfdn_tocv_field{
    uint_io32_t		u16TOC:16;
    uint_io32_t		:16;
}stc_cpg_canfdn_tocv_field_t;

typedef union un_cpg_canfdn_tocv{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_tocv_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_tocv_t;

/* ECR */
#define CPG_CANFD0_ECR	(CPG_CANFD0.unECR.u32Register)  /*@rg@*/
#define CPG_CANFD0_ECR_TEC	(CPG_CANFD0.unECR.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD0_ECR_REC	(CPG_CANFD0.unECR.stcField.u7REC)  /*@bf@*/
#define CPG_CANFD0_ECR_RP	(CPG_CANFD0.unECR.stcField.u1RP)  /*@bf@*/
#define CPG_CANFD0_ECR_CEL	(CPG_CANFD0.unECR.au8Byte[2])  /*@bfbyte@*/

#define CPG_CANFD1_ECR	(CPG_CANFD1.unECR.u32Register)  /*@rg@*/
#define CPG_CANFD1_ECR_TEC	(CPG_CANFD1.unECR.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD1_ECR_REC	(CPG_CANFD1.unECR.stcField.u7REC)  /*@bf@*/
#define CPG_CANFD1_ECR_RP	(CPG_CANFD1.unECR.stcField.u1RP)  /*@bf@*/
#define CPG_CANFD1_ECR_CEL	(CPG_CANFD1.unECR.au8Byte[2])  /*@bfbyte@*/

#define CPG_CANFD2_ECR	(CPG_CANFD2.unECR.u32Register)  /*@rg@*/
#define CPG_CANFD2_ECR_TEC	(CPG_CANFD2.unECR.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD2_ECR_REC	(CPG_CANFD2.unECR.stcField.u7REC)  /*@bf@*/
#define CPG_CANFD2_ECR_RP	(CPG_CANFD2.unECR.stcField.u1RP)  /*@bf@*/
#define CPG_CANFD2_ECR_CEL	(CPG_CANFD2.unECR.au8Byte[2])  /*@bfbyte@*/

#define CPG_CANFD3_ECR	(CPG_CANFD3.unECR.u32Register)  /*@rg@*/
#define CPG_CANFD3_ECR_TEC	(CPG_CANFD3.unECR.au8Byte[0])  /*@bfbyte@*/
#define CPG_CANFD3_ECR_REC	(CPG_CANFD3.unECR.stcField.u7REC)  /*@bf@*/
#define CPG_CANFD3_ECR_RP	(CPG_CANFD3.unECR.stcField.u1RP)  /*@bf@*/
#define CPG_CANFD3_ECR_CEL	(CPG_CANFD3.unECR.au8Byte[2])  /*@bfbyte@*/

typedef struct stc_cpg_canfdn_ecr_field{
    uint_io32_t		u8TEC:8;
    uint_io32_t		u7REC:7;
    uint_io32_t		u1RP:1;
    uint_io32_t		u8CEL:8;
    uint_io32_t		:8;
}stc_cpg_canfdn_ecr_field_t;

typedef union un_cpg_canfdn_ecr{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_ecr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_ecr_t;

/* PSR */
#define CPG_CANFD0_PSR	(CPG_CANFD0.unPSR.u32Register)  /*@rg@*/
#define CPG_CANFD0_PSR_LEC	(CPG_CANFD0.unPSR.stcField.u3LEC)  /*@bf@*/
#define CPG_CANFD0_PSR_ACT	(CPG_CANFD0.unPSR.stcField.u2ACT)  /*@bf@*/
#define CPG_CANFD0_PSR_EP	(CPG_CANFD0.unPSR.stcField.u1EP)  /*@bf@*/
#define CPG_CANFD0_PSR_EW	(CPG_CANFD0.unPSR.stcField.u1EW)  /*@bf@*/
#define CPG_CANFD0_PSR_BO	(CPG_CANFD0.unPSR.stcField.u1BO)  /*@bf@*/
#define CPG_CANFD0_PSR_DLEC	(CPG_CANFD0.unPSR.stcField.u3DLEC)  /*@bf@*/
#define CPG_CANFD0_PSR_RESI	(CPG_CANFD0.unPSR.stcField.u1RESI)  /*@bf@*/
#define CPG_CANFD0_PSR_RBRS	(CPG_CANFD0.unPSR.stcField.u1RBRS)  /*@bf@*/
#define CPG_CANFD0_PSR_RFDF	(CPG_CANFD0.unPSR.stcField.u1RFDF)  /*@bf@*/
#define CPG_CANFD0_PSR_PXE	(CPG_CANFD0.unPSR.stcField.u1PXE)  /*@bf@*/
#define CPG_CANFD0_PSR_TDCV	(CPG_CANFD0.unPSR.stcField.u7TDCV)  /*@bf@*/

#define CPG_CANFD1_PSR	(CPG_CANFD1.unPSR.u32Register)  /*@rg@*/
#define CPG_CANFD1_PSR_LEC	(CPG_CANFD1.unPSR.stcField.u3LEC)  /*@bf@*/
#define CPG_CANFD1_PSR_ACT	(CPG_CANFD1.unPSR.stcField.u2ACT)  /*@bf@*/
#define CPG_CANFD1_PSR_EP	(CPG_CANFD1.unPSR.stcField.u1EP)  /*@bf@*/
#define CPG_CANFD1_PSR_EW	(CPG_CANFD1.unPSR.stcField.u1EW)  /*@bf@*/
#define CPG_CANFD1_PSR_BO	(CPG_CANFD1.unPSR.stcField.u1BO)  /*@bf@*/
#define CPG_CANFD1_PSR_DLEC	(CPG_CANFD1.unPSR.stcField.u3DLEC)  /*@bf@*/
#define CPG_CANFD1_PSR_RESI	(CPG_CANFD1.unPSR.stcField.u1RESI)  /*@bf@*/
#define CPG_CANFD1_PSR_RBRS	(CPG_CANFD1.unPSR.stcField.u1RBRS)  /*@bf@*/
#define CPG_CANFD1_PSR_RFDF	(CPG_CANFD1.unPSR.stcField.u1RFDF)  /*@bf@*/
#define CPG_CANFD1_PSR_PXE	(CPG_CANFD1.unPSR.stcField.u1PXE)  /*@bf@*/
#define CPG_CANFD1_PSR_TDCV	(CPG_CANFD1.unPSR.stcField.u7TDCV)  /*@bf@*/

#define CPG_CANFD2_PSR	(CPG_CANFD2.unPSR.u32Register)  /*@rg@*/
#define CPG_CANFD2_PSR_LEC	(CPG_CANFD2.unPSR.stcField.u3LEC)  /*@bf@*/
#define CPG_CANFD2_PSR_ACT	(CPG_CANFD2.unPSR.stcField.u2ACT)  /*@bf@*/
#define CPG_CANFD2_PSR_EP	(CPG_CANFD2.unPSR.stcField.u1EP)  /*@bf@*/
#define CPG_CANFD2_PSR_EW	(CPG_CANFD2.unPSR.stcField.u1EW)  /*@bf@*/
#define CPG_CANFD2_PSR_BO	(CPG_CANFD2.unPSR.stcField.u1BO)  /*@bf@*/
#define CPG_CANFD2_PSR_DLEC	(CPG_CANFD2.unPSR.stcField.u3DLEC)  /*@bf@*/
#define CPG_CANFD2_PSR_RESI	(CPG_CANFD2.unPSR.stcField.u1RESI)  /*@bf@*/
#define CPG_CANFD2_PSR_RBRS	(CPG_CANFD2.unPSR.stcField.u1RBRS)  /*@bf@*/
#define CPG_CANFD2_PSR_RFDF	(CPG_CANFD2.unPSR.stcField.u1RFDF)  /*@bf@*/
#define CPG_CANFD2_PSR_PXE	(CPG_CANFD2.unPSR.stcField.u1PXE)  /*@bf@*/
#define CPG_CANFD2_PSR_TDCV	(CPG_CANFD2.unPSR.stcField.u7TDCV)  /*@bf@*/

#define CPG_CANFD3_PSR	(CPG_CANFD3.unPSR.u32Register)  /*@rg@*/
#define CPG_CANFD3_PSR_LEC	(CPG_CANFD3.unPSR.stcField.u3LEC)  /*@bf@*/
#define CPG_CANFD3_PSR_ACT	(CPG_CANFD3.unPSR.stcField.u2ACT)  /*@bf@*/
#define CPG_CANFD3_PSR_EP	(CPG_CANFD3.unPSR.stcField.u1EP)  /*@bf@*/
#define CPG_CANFD3_PSR_EW	(CPG_CANFD3.unPSR.stcField.u1EW)  /*@bf@*/
#define CPG_CANFD3_PSR_BO	(CPG_CANFD3.unPSR.stcField.u1BO)  /*@bf@*/
#define CPG_CANFD3_PSR_DLEC	(CPG_CANFD3.unPSR.stcField.u3DLEC)  /*@bf@*/
#define CPG_CANFD3_PSR_RESI	(CPG_CANFD3.unPSR.stcField.u1RESI)  /*@bf@*/
#define CPG_CANFD3_PSR_RBRS	(CPG_CANFD3.unPSR.stcField.u1RBRS)  /*@bf@*/
#define CPG_CANFD3_PSR_RFDF	(CPG_CANFD3.unPSR.stcField.u1RFDF)  /*@bf@*/
#define CPG_CANFD3_PSR_PXE	(CPG_CANFD3.unPSR.stcField.u1PXE)  /*@bf@*/
#define CPG_CANFD3_PSR_TDCV	(CPG_CANFD3.unPSR.stcField.u7TDCV)  /*@bf@*/

typedef struct stc_cpg_canfdn_psr_field{
    uint_io32_t		u3LEC:3;
    uint_io32_t		u2ACT:2;
    uint_io32_t		u1EP:1;
    uint_io32_t		u1EW:1;
    uint_io32_t		u1BO:1;
    uint_io32_t		u3DLEC:3;
    uint_io32_t		u1RESI:1;
    uint_io32_t		u1RBRS:1;
    uint_io32_t		u1RFDF:1;
    uint_io32_t		u1PXE:1;
    uint_io32_t		:1;
    uint_io32_t		u7TDCV:7;
    uint_io32_t		:9;
}stc_cpg_canfdn_psr_field_t;

typedef union un_cpg_canfdn_psr{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_psr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_psr_t;

/* TDCR */
#define CPG_CANFD0_TDCR	(CPG_CANFD0.unTDCR.u32Register)  /*@rg@*/
#define CPG_CANFD0_TDCR_TDCF	(CPG_CANFD0.unTDCR.stcField.u7TDCF)  /*@bf@*/
#define CPG_CANFD0_TDCR_TDCO	(CPG_CANFD0.unTDCR.stcField.u7TDCO)  /*@bf@*/

#define CPG_CANFD1_TDCR	(CPG_CANFD1.unTDCR.u32Register)  /*@rg@*/
#define CPG_CANFD1_TDCR_TDCF	(CPG_CANFD1.unTDCR.stcField.u7TDCF)  /*@bf@*/
#define CPG_CANFD1_TDCR_TDCO	(CPG_CANFD1.unTDCR.stcField.u7TDCO)  /*@bf@*/

#define CPG_CANFD2_TDCR	(CPG_CANFD2.unTDCR.u32Register)  /*@rg@*/
#define CPG_CANFD2_TDCR_TDCF	(CPG_CANFD2.unTDCR.stcField.u7TDCF)  /*@bf@*/
#define CPG_CANFD2_TDCR_TDCO	(CPG_CANFD2.unTDCR.stcField.u7TDCO)  /*@bf@*/

#define CPG_CANFD3_TDCR	(CPG_CANFD3.unTDCR.u32Register)  /*@rg@*/
#define CPG_CANFD3_TDCR_TDCF	(CPG_CANFD3.unTDCR.stcField.u7TDCF)  /*@bf@*/
#define CPG_CANFD3_TDCR_TDCO	(CPG_CANFD3.unTDCR.stcField.u7TDCO)  /*@bf@*/

typedef struct stc_cpg_canfdn_tdcr_field{
    uint_io32_t		u7TDCF:7;
    uint_io32_t		:1;
    uint_io32_t		u7TDCO:7;
    uint_io32_t		:17;
}stc_cpg_canfdn_tdcr_field_t;

typedef union un_cpg_canfdn_tdcr{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_tdcr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_tdcr_t;

/* IR */
#define CPG_CANFD0_IR	(CPG_CANFD0.unIR.u32Register)  /*@rg@*/
#define CPG_CANFD0_IR_RF0N	(CPG_CANFD0.unIR.stcField.u1RF0N)  /*@bf@*/
#define CPG_CANFD0_IR_RF0W	(CPG_CANFD0.unIR.stcField.u1RF0W)  /*@bf@*/
#define CPG_CANFD0_IR_RF0F	(CPG_CANFD0.unIR.stcField.u1RF0F)  /*@bf@*/
#define CPG_CANFD0_IR_RF0L	(CPG_CANFD0.unIR.stcField.u1RF0L)  /*@bf@*/
#define CPG_CANFD0_IR_RF1N	(CPG_CANFD0.unIR.stcField.u1RF1N)  /*@bf@*/
#define CPG_CANFD0_IR_RF1W	(CPG_CANFD0.unIR.stcField.u1RF1W)  /*@bf@*/
#define CPG_CANFD0_IR_RF1F	(CPG_CANFD0.unIR.stcField.u1RF1F)  /*@bf@*/
#define CPG_CANFD0_IR_RF1L	(CPG_CANFD0.unIR.stcField.u1RF1L)  /*@bf@*/
#define CPG_CANFD0_IR_HPM	(CPG_CANFD0.unIR.stcField.u1HPM)  /*@bf@*/
#define CPG_CANFD0_IR_TC	(CPG_CANFD0.unIR.stcField.u1TC)  /*@bf@*/
#define CPG_CANFD0_IR_TCF	(CPG_CANFD0.unIR.stcField.u1TCF)  /*@bf@*/
#define CPG_CANFD0_IR_TFE	(CPG_CANFD0.unIR.stcField.u1TFE)  /*@bf@*/
#define CPG_CANFD0_IR_TEFN	(CPG_CANFD0.unIR.stcField.u1TEFN)  /*@bf@*/
#define CPG_CANFD0_IR_TEFW	(CPG_CANFD0.unIR.stcField.u1TEFW)  /*@bf@*/
#define CPG_CANFD0_IR_TEFF	(CPG_CANFD0.unIR.stcField.u1TEFF)  /*@bf@*/
#define CPG_CANFD0_IR_TEFL	(CPG_CANFD0.unIR.stcField.u1TEFL)  /*@bf@*/
#define CPG_CANFD0_IR_TSW	(CPG_CANFD0.unIR.stcField.u1TSW)  /*@bf@*/
#define CPG_CANFD0_IR_MRAF	(CPG_CANFD0.unIR.stcField.u1MRAF)  /*@bf@*/
#define CPG_CANFD0_IR_TOO	(CPG_CANFD0.unIR.stcField.u1TOO)  /*@bf@*/
#define CPG_CANFD0_IR_DRX	(CPG_CANFD0.unIR.stcField.u1DRX)  /*@bf@*/
#define CPG_CANFD0_IR_BEC	(CPG_CANFD0.unIR.stcField.u1BEC)  /*@bf@*/
#define CPG_CANFD0_IR_BEU	(CPG_CANFD0.unIR.stcField.u1BEU)  /*@bf@*/
#define CPG_CANFD0_IR_ELO	(CPG_CANFD0.unIR.stcField.u1ELO)  /*@bf@*/
#define CPG_CANFD0_IR_EP	(CPG_CANFD0.unIR.stcField.u1EP)  /*@bf@*/
#define CPG_CANFD0_IR_EW	(CPG_CANFD0.unIR.stcField.u1EW)  /*@bf@*/
#define CPG_CANFD0_IR_BO	(CPG_CANFD0.unIR.stcField.u1BO)  /*@bf@*/
#define CPG_CANFD0_IR_WDI	(CPG_CANFD0.unIR.stcField.u1WDI)  /*@bf@*/
#define CPG_CANFD0_IR_PEA	(CPG_CANFD0.unIR.stcField.u1PEA)  /*@bf@*/
#define CPG_CANFD0_IR_PED	(CPG_CANFD0.unIR.stcField.u1PED)  /*@bf@*/
#define CPG_CANFD0_IR_ARA	(CPG_CANFD0.unIR.stcField.u1ARA)  /*@bf@*/

#define CPG_CANFD1_IR	(CPG_CANFD1.unIR.u32Register)  /*@rg@*/
#define CPG_CANFD1_IR_RF0N	(CPG_CANFD1.unIR.stcField.u1RF0N)  /*@bf@*/
#define CPG_CANFD1_IR_RF0W	(CPG_CANFD1.unIR.stcField.u1RF0W)  /*@bf@*/
#define CPG_CANFD1_IR_RF0F	(CPG_CANFD1.unIR.stcField.u1RF0F)  /*@bf@*/
#define CPG_CANFD1_IR_RF0L	(CPG_CANFD1.unIR.stcField.u1RF0L)  /*@bf@*/
#define CPG_CANFD1_IR_RF1N	(CPG_CANFD1.unIR.stcField.u1RF1N)  /*@bf@*/
#define CPG_CANFD1_IR_RF1W	(CPG_CANFD1.unIR.stcField.u1RF1W)  /*@bf@*/
#define CPG_CANFD1_IR_RF1F	(CPG_CANFD1.unIR.stcField.u1RF1F)  /*@bf@*/
#define CPG_CANFD1_IR_RF1L	(CPG_CANFD1.unIR.stcField.u1RF1L)  /*@bf@*/
#define CPG_CANFD1_IR_HPM	(CPG_CANFD1.unIR.stcField.u1HPM)  /*@bf@*/
#define CPG_CANFD1_IR_TC	(CPG_CANFD1.unIR.stcField.u1TC)  /*@bf@*/
#define CPG_CANFD1_IR_TCF	(CPG_CANFD1.unIR.stcField.u1TCF)  /*@bf@*/
#define CPG_CANFD1_IR_TFE	(CPG_CANFD1.unIR.stcField.u1TFE)  /*@bf@*/
#define CPG_CANFD1_IR_TEFN	(CPG_CANFD1.unIR.stcField.u1TEFN)  /*@bf@*/
#define CPG_CANFD1_IR_TEFW	(CPG_CANFD1.unIR.stcField.u1TEFW)  /*@bf@*/
#define CPG_CANFD1_IR_TEFF	(CPG_CANFD1.unIR.stcField.u1TEFF)  /*@bf@*/
#define CPG_CANFD1_IR_TEFL	(CPG_CANFD1.unIR.stcField.u1TEFL)  /*@bf@*/
#define CPG_CANFD1_IR_TSW	(CPG_CANFD1.unIR.stcField.u1TSW)  /*@bf@*/
#define CPG_CANFD1_IR_MRAF	(CPG_CANFD1.unIR.stcField.u1MRAF)  /*@bf@*/
#define CPG_CANFD1_IR_TOO	(CPG_CANFD1.unIR.stcField.u1TOO)  /*@bf@*/
#define CPG_CANFD1_IR_DRX	(CPG_CANFD1.unIR.stcField.u1DRX)  /*@bf@*/
#define CPG_CANFD1_IR_BEC	(CPG_CANFD1.unIR.stcField.u1BEC)  /*@bf@*/
#define CPG_CANFD1_IR_BEU	(CPG_CANFD1.unIR.stcField.u1BEU)  /*@bf@*/
#define CPG_CANFD1_IR_ELO	(CPG_CANFD1.unIR.stcField.u1ELO)  /*@bf@*/
#define CPG_CANFD1_IR_EP	(CPG_CANFD1.unIR.stcField.u1EP)  /*@bf@*/
#define CPG_CANFD1_IR_EW	(CPG_CANFD1.unIR.stcField.u1EW)  /*@bf@*/
#define CPG_CANFD1_IR_BO	(CPG_CANFD1.unIR.stcField.u1BO)  /*@bf@*/
#define CPG_CANFD1_IR_WDI	(CPG_CANFD1.unIR.stcField.u1WDI)  /*@bf@*/
#define CPG_CANFD1_IR_PEA	(CPG_CANFD1.unIR.stcField.u1PEA)  /*@bf@*/
#define CPG_CANFD1_IR_PED	(CPG_CANFD1.unIR.stcField.u1PED)  /*@bf@*/
#define CPG_CANFD1_IR_ARA	(CPG_CANFD1.unIR.stcField.u1ARA)  /*@bf@*/

#define CPG_CANFD2_IR	(CPG_CANFD2.unIR.u32Register)  /*@rg@*/
#define CPG_CANFD2_IR_RF0N	(CPG_CANFD2.unIR.stcField.u1RF0N)  /*@bf@*/
#define CPG_CANFD2_IR_RF0W	(CPG_CANFD2.unIR.stcField.u1RF0W)  /*@bf@*/
#define CPG_CANFD2_IR_RF0F	(CPG_CANFD2.unIR.stcField.u1RF0F)  /*@bf@*/
#define CPG_CANFD2_IR_RF0L	(CPG_CANFD2.unIR.stcField.u1RF0L)  /*@bf@*/
#define CPG_CANFD2_IR_RF1N	(CPG_CANFD2.unIR.stcField.u1RF1N)  /*@bf@*/
#define CPG_CANFD2_IR_RF1W	(CPG_CANFD2.unIR.stcField.u1RF1W)  /*@bf@*/
#define CPG_CANFD2_IR_RF1F	(CPG_CANFD2.unIR.stcField.u1RF1F)  /*@bf@*/
#define CPG_CANFD2_IR_RF1L	(CPG_CANFD2.unIR.stcField.u1RF1L)  /*@bf@*/
#define CPG_CANFD2_IR_HPM	(CPG_CANFD2.unIR.stcField.u1HPM)  /*@bf@*/
#define CPG_CANFD2_IR_TC	(CPG_CANFD2.unIR.stcField.u1TC)  /*@bf@*/
#define CPG_CANFD2_IR_TCF	(CPG_CANFD2.unIR.stcField.u1TCF)  /*@bf@*/
#define CPG_CANFD2_IR_TFE	(CPG_CANFD2.unIR.stcField.u1TFE)  /*@bf@*/
#define CPG_CANFD2_IR_TEFN	(CPG_CANFD2.unIR.stcField.u1TEFN)  /*@bf@*/
#define CPG_CANFD2_IR_TEFW	(CPG_CANFD2.unIR.stcField.u1TEFW)  /*@bf@*/
#define CPG_CANFD2_IR_TEFF	(CPG_CANFD2.unIR.stcField.u1TEFF)  /*@bf@*/
#define CPG_CANFD2_IR_TEFL	(CPG_CANFD2.unIR.stcField.u1TEFL)  /*@bf@*/
#define CPG_CANFD2_IR_TSW	(CPG_CANFD2.unIR.stcField.u1TSW)  /*@bf@*/
#define CPG_CANFD2_IR_MRAF	(CPG_CANFD2.unIR.stcField.u1MRAF)  /*@bf@*/
#define CPG_CANFD2_IR_TOO	(CPG_CANFD2.unIR.stcField.u1TOO)  /*@bf@*/
#define CPG_CANFD2_IR_DRX	(CPG_CANFD2.unIR.stcField.u1DRX)  /*@bf@*/
#define CPG_CANFD2_IR_BEC	(CPG_CANFD2.unIR.stcField.u1BEC)  /*@bf@*/
#define CPG_CANFD2_IR_BEU	(CPG_CANFD2.unIR.stcField.u1BEU)  /*@bf@*/
#define CPG_CANFD2_IR_ELO	(CPG_CANFD2.unIR.stcField.u1ELO)  /*@bf@*/
#define CPG_CANFD2_IR_EP	(CPG_CANFD2.unIR.stcField.u1EP)  /*@bf@*/
#define CPG_CANFD2_IR_EW	(CPG_CANFD2.unIR.stcField.u1EW)  /*@bf@*/
#define CPG_CANFD2_IR_BO	(CPG_CANFD2.unIR.stcField.u1BO)  /*@bf@*/
#define CPG_CANFD2_IR_WDI	(CPG_CANFD2.unIR.stcField.u1WDI)  /*@bf@*/
#define CPG_CANFD2_IR_PEA	(CPG_CANFD2.unIR.stcField.u1PEA)  /*@bf@*/
#define CPG_CANFD2_IR_PED	(CPG_CANFD2.unIR.stcField.u1PED)  /*@bf@*/
#define CPG_CANFD2_IR_ARA	(CPG_CANFD2.unIR.stcField.u1ARA)  /*@bf@*/

#define CPG_CANFD3_IR	(CPG_CANFD3.unIR.u32Register)  /*@rg@*/
#define CPG_CANFD3_IR_RF0N	(CPG_CANFD3.unIR.stcField.u1RF0N)  /*@bf@*/
#define CPG_CANFD3_IR_RF0W	(CPG_CANFD3.unIR.stcField.u1RF0W)  /*@bf@*/
#define CPG_CANFD3_IR_RF0F	(CPG_CANFD3.unIR.stcField.u1RF0F)  /*@bf@*/
#define CPG_CANFD3_IR_RF0L	(CPG_CANFD3.unIR.stcField.u1RF0L)  /*@bf@*/
#define CPG_CANFD3_IR_RF1N	(CPG_CANFD3.unIR.stcField.u1RF1N)  /*@bf@*/
#define CPG_CANFD3_IR_RF1W	(CPG_CANFD3.unIR.stcField.u1RF1W)  /*@bf@*/
#define CPG_CANFD3_IR_RF1F	(CPG_CANFD3.unIR.stcField.u1RF1F)  /*@bf@*/
#define CPG_CANFD3_IR_RF1L	(CPG_CANFD3.unIR.stcField.u1RF1L)  /*@bf@*/
#define CPG_CANFD3_IR_HPM	(CPG_CANFD3.unIR.stcField.u1HPM)  /*@bf@*/
#define CPG_CANFD3_IR_TC	(CPG_CANFD3.unIR.stcField.u1TC)  /*@bf@*/
#define CPG_CANFD3_IR_TCF	(CPG_CANFD3.unIR.stcField.u1TCF)  /*@bf@*/
#define CPG_CANFD3_IR_TFE	(CPG_CANFD3.unIR.stcField.u1TFE)  /*@bf@*/
#define CPG_CANFD3_IR_TEFN	(CPG_CANFD3.unIR.stcField.u1TEFN)  /*@bf@*/
#define CPG_CANFD3_IR_TEFW	(CPG_CANFD3.unIR.stcField.u1TEFW)  /*@bf@*/
#define CPG_CANFD3_IR_TEFF	(CPG_CANFD3.unIR.stcField.u1TEFF)  /*@bf@*/
#define CPG_CANFD3_IR_TEFL	(CPG_CANFD3.unIR.stcField.u1TEFL)  /*@bf@*/
#define CPG_CANFD3_IR_TSW	(CPG_CANFD3.unIR.stcField.u1TSW)  /*@bf@*/
#define CPG_CANFD3_IR_MRAF	(CPG_CANFD3.unIR.stcField.u1MRAF)  /*@bf@*/
#define CPG_CANFD3_IR_TOO	(CPG_CANFD3.unIR.stcField.u1TOO)  /*@bf@*/
#define CPG_CANFD3_IR_DRX	(CPG_CANFD3.unIR.stcField.u1DRX)  /*@bf@*/
#define CPG_CANFD3_IR_BEC	(CPG_CANFD3.unIR.stcField.u1BEC)  /*@bf@*/
#define CPG_CANFD3_IR_BEU	(CPG_CANFD3.unIR.stcField.u1BEU)  /*@bf@*/
#define CPG_CANFD3_IR_ELO	(CPG_CANFD3.unIR.stcField.u1ELO)  /*@bf@*/
#define CPG_CANFD3_IR_EP	(CPG_CANFD3.unIR.stcField.u1EP)  /*@bf@*/
#define CPG_CANFD3_IR_EW	(CPG_CANFD3.unIR.stcField.u1EW)  /*@bf@*/
#define CPG_CANFD3_IR_BO	(CPG_CANFD3.unIR.stcField.u1BO)  /*@bf@*/
#define CPG_CANFD3_IR_WDI	(CPG_CANFD3.unIR.stcField.u1WDI)  /*@bf@*/
#define CPG_CANFD3_IR_PEA	(CPG_CANFD3.unIR.stcField.u1PEA)  /*@bf@*/
#define CPG_CANFD3_IR_PED	(CPG_CANFD3.unIR.stcField.u1PED)  /*@bf@*/
#define CPG_CANFD3_IR_ARA	(CPG_CANFD3.unIR.stcField.u1ARA)  /*@bf@*/

typedef struct stc_cpg_canfdn_ir_field{
    uint_io32_t		u1RF0N:1;
    uint_io32_t		u1RF0W:1;
    uint_io32_t		u1RF0F:1;
    uint_io32_t		u1RF0L:1;
    uint_io32_t		u1RF1N:1;
    uint_io32_t		u1RF1W:1;
    uint_io32_t		u1RF1F:1;
    uint_io32_t		u1RF1L:1;
    uint_io32_t		u1HPM:1;
    uint_io32_t		u1TC:1;
    uint_io32_t		u1TCF:1;
    uint_io32_t		u1TFE:1;
    uint_io32_t		u1TEFN:1;
    uint_io32_t		u1TEFW:1;
    uint_io32_t		u1TEFF:1;
    uint_io32_t		u1TEFL:1;
    uint_io32_t		u1TSW:1;
    uint_io32_t		u1MRAF:1;
    uint_io32_t		u1TOO:1;
    uint_io32_t		u1DRX:1;
    uint_io32_t		u1BEC:1;
    uint_io32_t		u1BEU:1;
    uint_io32_t		u1ELO:1;
    uint_io32_t		u1EP:1;
    uint_io32_t		u1EW:1;
    uint_io32_t		u1BO:1;
    uint_io32_t		u1WDI:1;
    uint_io32_t		u1PEA:1;
    uint_io32_t		u1PED:1;
    uint_io32_t		u1ARA:1;
    uint_io32_t		:2;
}stc_cpg_canfdn_ir_field_t;

typedef union un_cpg_canfdn_ir{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_ir_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_ir_t;

/* IE */
#define CPG_CANFD0_IE	(CPG_CANFD0.unIE.u32Register)  /*@rg@*/
#define CPG_CANFD0_IE_RF0NE	(CPG_CANFD0.unIE.stcField.u1RF0NE)  /*@bf@*/
#define CPG_CANFD0_IE_RF0WE	(CPG_CANFD0.unIE.stcField.u1RF0WE)  /*@bf@*/
#define CPG_CANFD0_IE_RF0FE	(CPG_CANFD0.unIE.stcField.u1RF0FE)  /*@bf@*/
#define CPG_CANFD0_IE_RF0LE	(CPG_CANFD0.unIE.stcField.u1RF0LE)  /*@bf@*/
#define CPG_CANFD0_IE_RF1NE	(CPG_CANFD0.unIE.stcField.u1RF1NE)  /*@bf@*/
#define CPG_CANFD0_IE_RF1WE	(CPG_CANFD0.unIE.stcField.u1RF1WE)  /*@bf@*/
#define CPG_CANFD0_IE_RF1FE	(CPG_CANFD0.unIE.stcField.u1RF1FE)  /*@bf@*/
#define CPG_CANFD0_IE_RF1LE	(CPG_CANFD0.unIE.stcField.u1RF1LE)  /*@bf@*/
#define CPG_CANFD0_IE_HPME	(CPG_CANFD0.unIE.stcField.u1HPME)  /*@bf@*/
#define CPG_CANFD0_IE_TCE	(CPG_CANFD0.unIE.stcField.u1TCE)  /*@bf@*/
#define CPG_CANFD0_IE_TCFE	(CPG_CANFD0.unIE.stcField.u1TCFE)  /*@bf@*/
#define CPG_CANFD0_IE_TFEE	(CPG_CANFD0.unIE.stcField.u1TFEE)  /*@bf@*/
#define CPG_CANFD0_IE_TEFNE	(CPG_CANFD0.unIE.stcField.u1TEFNE)  /*@bf@*/
#define CPG_CANFD0_IE_TEFWE	(CPG_CANFD0.unIE.stcField.u1TEFWE)  /*@bf@*/
#define CPG_CANFD0_IE_TEFFE	(CPG_CANFD0.unIE.stcField.u1TEFFE)  /*@bf@*/
#define CPG_CANFD0_IE_TEFLE	(CPG_CANFD0.unIE.stcField.u1TEFLE)  /*@bf@*/
#define CPG_CANFD0_IE_TSWE	(CPG_CANFD0.unIE.stcField.u1TSWE)  /*@bf@*/
#define CPG_CANFD0_IE_MRAFE	(CPG_CANFD0.unIE.stcField.u1MRAFE)  /*@bf@*/
#define CPG_CANFD0_IE_TOOE	(CPG_CANFD0.unIE.stcField.u1TOOE)  /*@bf@*/
#define CPG_CANFD0_IE_DRXE	(CPG_CANFD0.unIE.stcField.u1DRXE)  /*@bf@*/
#define CPG_CANFD0_IE_BECE	(CPG_CANFD0.unIE.stcField.u1BECE)  /*@bf@*/
#define CPG_CANFD0_IE_BEUE	(CPG_CANFD0.unIE.stcField.u1BEUE)  /*@bf@*/
#define CPG_CANFD0_IE_ELOE	(CPG_CANFD0.unIE.stcField.u1ELOE)  /*@bf@*/
#define CPG_CANFD0_IE_EPE	(CPG_CANFD0.unIE.stcField.u1EPE)  /*@bf@*/
#define CPG_CANFD0_IE_EWE	(CPG_CANFD0.unIE.stcField.u1EWE)  /*@bf@*/
#define CPG_CANFD0_IE_BOE	(CPG_CANFD0.unIE.stcField.u1BOE)  /*@bf@*/
#define CPG_CANFD0_IE_WDIE	(CPG_CANFD0.unIE.stcField.u1WDIE)  /*@bf@*/
#define CPG_CANFD0_IE_PEAE	(CPG_CANFD0.unIE.stcField.u1PEAE)  /*@bf@*/
#define CPG_CANFD0_IE_PEDE	(CPG_CANFD0.unIE.stcField.u1PEDE)  /*@bf@*/
#define CPG_CANFD0_IE_ARAE	(CPG_CANFD0.unIE.stcField.u1ARAE)  /*@bf@*/

#define CPG_CANFD1_IE	(CPG_CANFD1.unIE.u32Register)  /*@rg@*/
#define CPG_CANFD1_IE_RF0NE	(CPG_CANFD1.unIE.stcField.u1RF0NE)  /*@bf@*/
#define CPG_CANFD1_IE_RF0WE	(CPG_CANFD1.unIE.stcField.u1RF0WE)  /*@bf@*/
#define CPG_CANFD1_IE_RF0FE	(CPG_CANFD1.unIE.stcField.u1RF0FE)  /*@bf@*/
#define CPG_CANFD1_IE_RF0LE	(CPG_CANFD1.unIE.stcField.u1RF0LE)  /*@bf@*/
#define CPG_CANFD1_IE_RF1NE	(CPG_CANFD1.unIE.stcField.u1RF1NE)  /*@bf@*/
#define CPG_CANFD1_IE_RF1WE	(CPG_CANFD1.unIE.stcField.u1RF1WE)  /*@bf@*/
#define CPG_CANFD1_IE_RF1FE	(CPG_CANFD1.unIE.stcField.u1RF1FE)  /*@bf@*/
#define CPG_CANFD1_IE_RF1LE	(CPG_CANFD1.unIE.stcField.u1RF1LE)  /*@bf@*/
#define CPG_CANFD1_IE_HPME	(CPG_CANFD1.unIE.stcField.u1HPME)  /*@bf@*/
#define CPG_CANFD1_IE_TCE	(CPG_CANFD1.unIE.stcField.u1TCE)  /*@bf@*/
#define CPG_CANFD1_IE_TCFE	(CPG_CANFD1.unIE.stcField.u1TCFE)  /*@bf@*/
#define CPG_CANFD1_IE_TFEE	(CPG_CANFD1.unIE.stcField.u1TFEE)  /*@bf@*/
#define CPG_CANFD1_IE_TEFNE	(CPG_CANFD1.unIE.stcField.u1TEFNE)  /*@bf@*/
#define CPG_CANFD1_IE_TEFWE	(CPG_CANFD1.unIE.stcField.u1TEFWE)  /*@bf@*/
#define CPG_CANFD1_IE_TEFFE	(CPG_CANFD1.unIE.stcField.u1TEFFE)  /*@bf@*/
#define CPG_CANFD1_IE_TEFLE	(CPG_CANFD1.unIE.stcField.u1TEFLE)  /*@bf@*/
#define CPG_CANFD1_IE_TSWE	(CPG_CANFD1.unIE.stcField.u1TSWE)  /*@bf@*/
#define CPG_CANFD1_IE_MRAFE	(CPG_CANFD1.unIE.stcField.u1MRAFE)  /*@bf@*/
#define CPG_CANFD1_IE_TOOE	(CPG_CANFD1.unIE.stcField.u1TOOE)  /*@bf@*/
#define CPG_CANFD1_IE_DRXE	(CPG_CANFD1.unIE.stcField.u1DRXE)  /*@bf@*/
#define CPG_CANFD1_IE_BECE	(CPG_CANFD1.unIE.stcField.u1BECE)  /*@bf@*/
#define CPG_CANFD1_IE_BEUE	(CPG_CANFD1.unIE.stcField.u1BEUE)  /*@bf@*/
#define CPG_CANFD1_IE_ELOE	(CPG_CANFD1.unIE.stcField.u1ELOE)  /*@bf@*/
#define CPG_CANFD1_IE_EPE	(CPG_CANFD1.unIE.stcField.u1EPE)  /*@bf@*/
#define CPG_CANFD1_IE_EWE	(CPG_CANFD1.unIE.stcField.u1EWE)  /*@bf@*/
#define CPG_CANFD1_IE_BOE	(CPG_CANFD1.unIE.stcField.u1BOE)  /*@bf@*/
#define CPG_CANFD1_IE_WDIE	(CPG_CANFD1.unIE.stcField.u1WDIE)  /*@bf@*/
#define CPG_CANFD1_IE_PEAE	(CPG_CANFD1.unIE.stcField.u1PEAE)  /*@bf@*/
#define CPG_CANFD1_IE_PEDE	(CPG_CANFD1.unIE.stcField.u1PEDE)  /*@bf@*/
#define CPG_CANFD1_IE_ARAE	(CPG_CANFD1.unIE.stcField.u1ARAE)  /*@bf@*/

#define CPG_CANFD2_IE	(CPG_CANFD2.unIE.u32Register)  /*@rg@*/
#define CPG_CANFD2_IE_RF0NE	(CPG_CANFD2.unIE.stcField.u1RF0NE)  /*@bf@*/
#define CPG_CANFD2_IE_RF0WE	(CPG_CANFD2.unIE.stcField.u1RF0WE)  /*@bf@*/
#define CPG_CANFD2_IE_RF0FE	(CPG_CANFD2.unIE.stcField.u1RF0FE)  /*@bf@*/
#define CPG_CANFD2_IE_RF0LE	(CPG_CANFD2.unIE.stcField.u1RF0LE)  /*@bf@*/
#define CPG_CANFD2_IE_RF1NE	(CPG_CANFD2.unIE.stcField.u1RF1NE)  /*@bf@*/
#define CPG_CANFD2_IE_RF1WE	(CPG_CANFD2.unIE.stcField.u1RF1WE)  /*@bf@*/
#define CPG_CANFD2_IE_RF1FE	(CPG_CANFD2.unIE.stcField.u1RF1FE)  /*@bf@*/
#define CPG_CANFD2_IE_RF1LE	(CPG_CANFD2.unIE.stcField.u1RF1LE)  /*@bf@*/
#define CPG_CANFD2_IE_HPME	(CPG_CANFD2.unIE.stcField.u1HPME)  /*@bf@*/
#define CPG_CANFD2_IE_TCE	(CPG_CANFD2.unIE.stcField.u1TCE)  /*@bf@*/
#define CPG_CANFD2_IE_TCFE	(CPG_CANFD2.unIE.stcField.u1TCFE)  /*@bf@*/
#define CPG_CANFD2_IE_TFEE	(CPG_CANFD2.unIE.stcField.u1TFEE)  /*@bf@*/
#define CPG_CANFD2_IE_TEFNE	(CPG_CANFD2.unIE.stcField.u1TEFNE)  /*@bf@*/
#define CPG_CANFD2_IE_TEFWE	(CPG_CANFD2.unIE.stcField.u1TEFWE)  /*@bf@*/
#define CPG_CANFD2_IE_TEFFE	(CPG_CANFD2.unIE.stcField.u1TEFFE)  /*@bf@*/
#define CPG_CANFD2_IE_TEFLE	(CPG_CANFD2.unIE.stcField.u1TEFLE)  /*@bf@*/
#define CPG_CANFD2_IE_TSWE	(CPG_CANFD2.unIE.stcField.u1TSWE)  /*@bf@*/
#define CPG_CANFD2_IE_MRAFE	(CPG_CANFD2.unIE.stcField.u1MRAFE)  /*@bf@*/
#define CPG_CANFD2_IE_TOOE	(CPG_CANFD2.unIE.stcField.u1TOOE)  /*@bf@*/
#define CPG_CANFD2_IE_DRXE	(CPG_CANFD2.unIE.stcField.u1DRXE)  /*@bf@*/
#define CPG_CANFD2_IE_BECE	(CPG_CANFD2.unIE.stcField.u1BECE)  /*@bf@*/
#define CPG_CANFD2_IE_BEUE	(CPG_CANFD2.unIE.stcField.u1BEUE)  /*@bf@*/
#define CPG_CANFD2_IE_ELOE	(CPG_CANFD2.unIE.stcField.u1ELOE)  /*@bf@*/
#define CPG_CANFD2_IE_EPE	(CPG_CANFD2.unIE.stcField.u1EPE)  /*@bf@*/
#define CPG_CANFD2_IE_EWE	(CPG_CANFD2.unIE.stcField.u1EWE)  /*@bf@*/
#define CPG_CANFD2_IE_BOE	(CPG_CANFD2.unIE.stcField.u1BOE)  /*@bf@*/
#define CPG_CANFD2_IE_WDIE	(CPG_CANFD2.unIE.stcField.u1WDIE)  /*@bf@*/
#define CPG_CANFD2_IE_PEAE	(CPG_CANFD2.unIE.stcField.u1PEAE)  /*@bf@*/
#define CPG_CANFD2_IE_PEDE	(CPG_CANFD2.unIE.stcField.u1PEDE)  /*@bf@*/
#define CPG_CANFD2_IE_ARAE	(CPG_CANFD2.unIE.stcField.u1ARAE)  /*@bf@*/

#define CPG_CANFD3_IE	(CPG_CANFD3.unIE.u32Register)  /*@rg@*/
#define CPG_CANFD3_IE_RF0NE	(CPG_CANFD3.unIE.stcField.u1RF0NE)  /*@bf@*/
#define CPG_CANFD3_IE_RF0WE	(CPG_CANFD3.unIE.stcField.u1RF0WE)  /*@bf@*/
#define CPG_CANFD3_IE_RF0FE	(CPG_CANFD3.unIE.stcField.u1RF0FE)  /*@bf@*/
#define CPG_CANFD3_IE_RF0LE	(CPG_CANFD3.unIE.stcField.u1RF0LE)  /*@bf@*/
#define CPG_CANFD3_IE_RF1NE	(CPG_CANFD3.unIE.stcField.u1RF1NE)  /*@bf@*/
#define CPG_CANFD3_IE_RF1WE	(CPG_CANFD3.unIE.stcField.u1RF1WE)  /*@bf@*/
#define CPG_CANFD3_IE_RF1FE	(CPG_CANFD3.unIE.stcField.u1RF1FE)  /*@bf@*/
#define CPG_CANFD3_IE_RF1LE	(CPG_CANFD3.unIE.stcField.u1RF1LE)  /*@bf@*/
#define CPG_CANFD3_IE_HPME	(CPG_CANFD3.unIE.stcField.u1HPME)  /*@bf@*/
#define CPG_CANFD3_IE_TCE	(CPG_CANFD3.unIE.stcField.u1TCE)  /*@bf@*/
#define CPG_CANFD3_IE_TCFE	(CPG_CANFD3.unIE.stcField.u1TCFE)  /*@bf@*/
#define CPG_CANFD3_IE_TFEE	(CPG_CANFD3.unIE.stcField.u1TFEE)  /*@bf@*/
#define CPG_CANFD3_IE_TEFNE	(CPG_CANFD3.unIE.stcField.u1TEFNE)  /*@bf@*/
#define CPG_CANFD3_IE_TEFWE	(CPG_CANFD3.unIE.stcField.u1TEFWE)  /*@bf@*/
#define CPG_CANFD3_IE_TEFFE	(CPG_CANFD3.unIE.stcField.u1TEFFE)  /*@bf@*/
#define CPG_CANFD3_IE_TEFLE	(CPG_CANFD3.unIE.stcField.u1TEFLE)  /*@bf@*/
#define CPG_CANFD3_IE_TSWE	(CPG_CANFD3.unIE.stcField.u1TSWE)  /*@bf@*/
#define CPG_CANFD3_IE_MRAFE	(CPG_CANFD3.unIE.stcField.u1MRAFE)  /*@bf@*/
#define CPG_CANFD3_IE_TOOE	(CPG_CANFD3.unIE.stcField.u1TOOE)  /*@bf@*/
#define CPG_CANFD3_IE_DRXE	(CPG_CANFD3.unIE.stcField.u1DRXE)  /*@bf@*/
#define CPG_CANFD3_IE_BECE	(CPG_CANFD3.unIE.stcField.u1BECE)  /*@bf@*/
#define CPG_CANFD3_IE_BEUE	(CPG_CANFD3.unIE.stcField.u1BEUE)  /*@bf@*/
#define CPG_CANFD3_IE_ELOE	(CPG_CANFD3.unIE.stcField.u1ELOE)  /*@bf@*/
#define CPG_CANFD3_IE_EPE	(CPG_CANFD3.unIE.stcField.u1EPE)  /*@bf@*/
#define CPG_CANFD3_IE_EWE	(CPG_CANFD3.unIE.stcField.u1EWE)  /*@bf@*/
#define CPG_CANFD3_IE_BOE	(CPG_CANFD3.unIE.stcField.u1BOE)  /*@bf@*/
#define CPG_CANFD3_IE_WDIE	(CPG_CANFD3.unIE.stcField.u1WDIE)  /*@bf@*/
#define CPG_CANFD3_IE_PEAE	(CPG_CANFD3.unIE.stcField.u1PEAE)  /*@bf@*/
#define CPG_CANFD3_IE_PEDE	(CPG_CANFD3.unIE.stcField.u1PEDE)  /*@bf@*/
#define CPG_CANFD3_IE_ARAE	(CPG_CANFD3.unIE.stcField.u1ARAE)  /*@bf@*/

typedef struct stc_cpg_canfdn_ie_field{
    uint_io32_t		u1RF0NE:1;
    uint_io32_t		u1RF0WE:1;
    uint_io32_t		u1RF0FE:1;
    uint_io32_t		u1RF0LE:1;
    uint_io32_t		u1RF1NE:1;
    uint_io32_t		u1RF1WE:1;
    uint_io32_t		u1RF1FE:1;
    uint_io32_t		u1RF1LE:1;
    uint_io32_t		u1HPME:1;
    uint_io32_t		u1TCE:1;
    uint_io32_t		u1TCFE:1;
    uint_io32_t		u1TFEE:1;
    uint_io32_t		u1TEFNE:1;
    uint_io32_t		u1TEFWE:1;
    uint_io32_t		u1TEFFE:1;
    uint_io32_t		u1TEFLE:1;
    uint_io32_t		u1TSWE:1;
    uint_io32_t		u1MRAFE:1;
    uint_io32_t		u1TOOE:1;
    uint_io32_t		u1DRXE:1;
    uint_io32_t		u1BECE:1;
    uint_io32_t		u1BEUE:1;
    uint_io32_t		u1ELOE:1;
    uint_io32_t		u1EPE:1;
    uint_io32_t		u1EWE:1;
    uint_io32_t		u1BOE:1;
    uint_io32_t		u1WDIE:1;
    uint_io32_t		u1PEAE:1;
    uint_io32_t		u1PEDE:1;
    uint_io32_t		u1ARAE:1;
    uint_io32_t		:2;
}stc_cpg_canfdn_ie_field_t;

typedef union un_cpg_canfdn_ie{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_ie_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_ie_t;

/* ILS */
#define CPG_CANFD0_ILS	(CPG_CANFD0.unILS.u32Register)  /*@rg@*/
#define CPG_CANFD0_ILS_RF0NL	(CPG_CANFD0.unILS.stcField.u1RF0NL)  /*@bf@*/
#define CPG_CANFD0_ILS_RF0WL	(CPG_CANFD0.unILS.stcField.u1RF0WL)  /*@bf@*/
#define CPG_CANFD0_ILS_RF0FL	(CPG_CANFD0.unILS.stcField.u1RF0FL)  /*@bf@*/
#define CPG_CANFD0_ILS_RF0LL	(CPG_CANFD0.unILS.stcField.u1RF0LL)  /*@bf@*/
#define CPG_CANFD0_ILS_RF1NL	(CPG_CANFD0.unILS.stcField.u1RF1NL)  /*@bf@*/
#define CPG_CANFD0_ILS_RF1WL	(CPG_CANFD0.unILS.stcField.u1RF1WL)  /*@bf@*/
#define CPG_CANFD0_ILS_RF1FL	(CPG_CANFD0.unILS.stcField.u1RF1FL)  /*@bf@*/
#define CPG_CANFD0_ILS_RF1LL	(CPG_CANFD0.unILS.stcField.u1RF1LL)  /*@bf@*/
#define CPG_CANFD0_ILS_HPML	(CPG_CANFD0.unILS.stcField.u1HPML)  /*@bf@*/
#define CPG_CANFD0_ILS_TCL	(CPG_CANFD0.unILS.stcField.u1TCL)  /*@bf@*/
#define CPG_CANFD0_ILS_TCFL	(CPG_CANFD0.unILS.stcField.u1TCFL)  /*@bf@*/
#define CPG_CANFD0_ILS_TFEL	(CPG_CANFD0.unILS.stcField.u1TFEL)  /*@bf@*/
#define CPG_CANFD0_ILS_TEFNL	(CPG_CANFD0.unILS.stcField.u1TEFNL)  /*@bf@*/
#define CPG_CANFD0_ILS_TEFWL	(CPG_CANFD0.unILS.stcField.u1TEFWL)  /*@bf@*/
#define CPG_CANFD0_ILS_TEFFL	(CPG_CANFD0.unILS.stcField.u1TEFFL)  /*@bf@*/
#define CPG_CANFD0_ILS_TEFLL	(CPG_CANFD0.unILS.stcField.u1TEFLL)  /*@bf@*/
#define CPG_CANFD0_ILS_TSWL	(CPG_CANFD0.unILS.stcField.u1TSWL)  /*@bf@*/
#define CPG_CANFD0_ILS_MRAFL	(CPG_CANFD0.unILS.stcField.u1MRAFL)  /*@bf@*/
#define CPG_CANFD0_ILS_TOOL	(CPG_CANFD0.unILS.stcField.u1TOOL)  /*@bf@*/
#define CPG_CANFD0_ILS_DRXL	(CPG_CANFD0.unILS.stcField.u1DRXL)  /*@bf@*/
#define CPG_CANFD0_ILS_BECL	(CPG_CANFD0.unILS.stcField.u1BECL)  /*@bf@*/
#define CPG_CANFD0_ILS_BEUL	(CPG_CANFD0.unILS.stcField.u1BEUL)  /*@bf@*/
#define CPG_CANFD0_ILS_ELOL	(CPG_CANFD0.unILS.stcField.u1ELOL)  /*@bf@*/
#define CPG_CANFD0_ILS_EPL	(CPG_CANFD0.unILS.stcField.u1EPL)  /*@bf@*/
#define CPG_CANFD0_ILS_EWL	(CPG_CANFD0.unILS.stcField.u1EWL)  /*@bf@*/
#define CPG_CANFD0_ILS_BOL	(CPG_CANFD0.unILS.stcField.u1BOL)  /*@bf@*/
#define CPG_CANFD0_ILS_WDIL	(CPG_CANFD0.unILS.stcField.u1WDIL)  /*@bf@*/
#define CPG_CANFD0_ILS_PEAL	(CPG_CANFD0.unILS.stcField.u1PEAL)  /*@bf@*/
#define CPG_CANFD0_ILS_PEDL	(CPG_CANFD0.unILS.stcField.u1PEDL)  /*@bf@*/
#define CPG_CANFD0_ILS_ARAL	(CPG_CANFD0.unILS.stcField.u1ARAL)  /*@bf@*/

#define CPG_CANFD1_ILS	(CPG_CANFD1.unILS.u32Register)  /*@rg@*/
#define CPG_CANFD1_ILS_RF0NL	(CPG_CANFD1.unILS.stcField.u1RF0NL)  /*@bf@*/
#define CPG_CANFD1_ILS_RF0WL	(CPG_CANFD1.unILS.stcField.u1RF0WL)  /*@bf@*/
#define CPG_CANFD1_ILS_RF0FL	(CPG_CANFD1.unILS.stcField.u1RF0FL)  /*@bf@*/
#define CPG_CANFD1_ILS_RF0LL	(CPG_CANFD1.unILS.stcField.u1RF0LL)  /*@bf@*/
#define CPG_CANFD1_ILS_RF1NL	(CPG_CANFD1.unILS.stcField.u1RF1NL)  /*@bf@*/
#define CPG_CANFD1_ILS_RF1WL	(CPG_CANFD1.unILS.stcField.u1RF1WL)  /*@bf@*/
#define CPG_CANFD1_ILS_RF1FL	(CPG_CANFD1.unILS.stcField.u1RF1FL)  /*@bf@*/
#define CPG_CANFD1_ILS_RF1LL	(CPG_CANFD1.unILS.stcField.u1RF1LL)  /*@bf@*/
#define CPG_CANFD1_ILS_HPML	(CPG_CANFD1.unILS.stcField.u1HPML)  /*@bf@*/
#define CPG_CANFD1_ILS_TCL	(CPG_CANFD1.unILS.stcField.u1TCL)  /*@bf@*/
#define CPG_CANFD1_ILS_TCFL	(CPG_CANFD1.unILS.stcField.u1TCFL)  /*@bf@*/
#define CPG_CANFD1_ILS_TFEL	(CPG_CANFD1.unILS.stcField.u1TFEL)  /*@bf@*/
#define CPG_CANFD1_ILS_TEFNL	(CPG_CANFD1.unILS.stcField.u1TEFNL)  /*@bf@*/
#define CPG_CANFD1_ILS_TEFWL	(CPG_CANFD1.unILS.stcField.u1TEFWL)  /*@bf@*/
#define CPG_CANFD1_ILS_TEFFL	(CPG_CANFD1.unILS.stcField.u1TEFFL)  /*@bf@*/
#define CPG_CANFD1_ILS_TEFLL	(CPG_CANFD1.unILS.stcField.u1TEFLL)  /*@bf@*/
#define CPG_CANFD1_ILS_TSWL	(CPG_CANFD1.unILS.stcField.u1TSWL)  /*@bf@*/
#define CPG_CANFD1_ILS_MRAFL	(CPG_CANFD1.unILS.stcField.u1MRAFL)  /*@bf@*/
#define CPG_CANFD1_ILS_TOOL	(CPG_CANFD1.unILS.stcField.u1TOOL)  /*@bf@*/
#define CPG_CANFD1_ILS_DRXL	(CPG_CANFD1.unILS.stcField.u1DRXL)  /*@bf@*/
#define CPG_CANFD1_ILS_BECL	(CPG_CANFD1.unILS.stcField.u1BECL)  /*@bf@*/
#define CPG_CANFD1_ILS_BEUL	(CPG_CANFD1.unILS.stcField.u1BEUL)  /*@bf@*/
#define CPG_CANFD1_ILS_ELOL	(CPG_CANFD1.unILS.stcField.u1ELOL)  /*@bf@*/
#define CPG_CANFD1_ILS_EPL	(CPG_CANFD1.unILS.stcField.u1EPL)  /*@bf@*/
#define CPG_CANFD1_ILS_EWL	(CPG_CANFD1.unILS.stcField.u1EWL)  /*@bf@*/
#define CPG_CANFD1_ILS_BOL	(CPG_CANFD1.unILS.stcField.u1BOL)  /*@bf@*/
#define CPG_CANFD1_ILS_WDIL	(CPG_CANFD1.unILS.stcField.u1WDIL)  /*@bf@*/
#define CPG_CANFD1_ILS_PEAL	(CPG_CANFD1.unILS.stcField.u1PEAL)  /*@bf@*/
#define CPG_CANFD1_ILS_PEDL	(CPG_CANFD1.unILS.stcField.u1PEDL)  /*@bf@*/
#define CPG_CANFD1_ILS_ARAL	(CPG_CANFD1.unILS.stcField.u1ARAL)  /*@bf@*/

#define CPG_CANFD2_ILS	(CPG_CANFD2.unILS.u32Register)  /*@rg@*/
#define CPG_CANFD2_ILS_RF0NL	(CPG_CANFD2.unILS.stcField.u1RF0NL)  /*@bf@*/
#define CPG_CANFD2_ILS_RF0WL	(CPG_CANFD2.unILS.stcField.u1RF0WL)  /*@bf@*/
#define CPG_CANFD2_ILS_RF0FL	(CPG_CANFD2.unILS.stcField.u1RF0FL)  /*@bf@*/
#define CPG_CANFD2_ILS_RF0LL	(CPG_CANFD2.unILS.stcField.u1RF0LL)  /*@bf@*/
#define CPG_CANFD2_ILS_RF1NL	(CPG_CANFD2.unILS.stcField.u1RF1NL)  /*@bf@*/
#define CPG_CANFD2_ILS_RF1WL	(CPG_CANFD2.unILS.stcField.u1RF1WL)  /*@bf@*/
#define CPG_CANFD2_ILS_RF1FL	(CPG_CANFD2.unILS.stcField.u1RF1FL)  /*@bf@*/
#define CPG_CANFD2_ILS_RF1LL	(CPG_CANFD2.unILS.stcField.u1RF1LL)  /*@bf@*/
#define CPG_CANFD2_ILS_HPML	(CPG_CANFD2.unILS.stcField.u1HPML)  /*@bf@*/
#define CPG_CANFD2_ILS_TCL	(CPG_CANFD2.unILS.stcField.u1TCL)  /*@bf@*/
#define CPG_CANFD2_ILS_TCFL	(CPG_CANFD2.unILS.stcField.u1TCFL)  /*@bf@*/
#define CPG_CANFD2_ILS_TFEL	(CPG_CANFD2.unILS.stcField.u1TFEL)  /*@bf@*/
#define CPG_CANFD2_ILS_TEFNL	(CPG_CANFD2.unILS.stcField.u1TEFNL)  /*@bf@*/
#define CPG_CANFD2_ILS_TEFWL	(CPG_CANFD2.unILS.stcField.u1TEFWL)  /*@bf@*/
#define CPG_CANFD2_ILS_TEFFL	(CPG_CANFD2.unILS.stcField.u1TEFFL)  /*@bf@*/
#define CPG_CANFD2_ILS_TEFLL	(CPG_CANFD2.unILS.stcField.u1TEFLL)  /*@bf@*/
#define CPG_CANFD2_ILS_TSWL	(CPG_CANFD2.unILS.stcField.u1TSWL)  /*@bf@*/
#define CPG_CANFD2_ILS_MRAFL	(CPG_CANFD2.unILS.stcField.u1MRAFL)  /*@bf@*/
#define CPG_CANFD2_ILS_TOOL	(CPG_CANFD2.unILS.stcField.u1TOOL)  /*@bf@*/
#define CPG_CANFD2_ILS_DRXL	(CPG_CANFD2.unILS.stcField.u1DRXL)  /*@bf@*/
#define CPG_CANFD2_ILS_BECL	(CPG_CANFD2.unILS.stcField.u1BECL)  /*@bf@*/
#define CPG_CANFD2_ILS_BEUL	(CPG_CANFD2.unILS.stcField.u1BEUL)  /*@bf@*/
#define CPG_CANFD2_ILS_ELOL	(CPG_CANFD2.unILS.stcField.u1ELOL)  /*@bf@*/
#define CPG_CANFD2_ILS_EPL	(CPG_CANFD2.unILS.stcField.u1EPL)  /*@bf@*/
#define CPG_CANFD2_ILS_EWL	(CPG_CANFD2.unILS.stcField.u1EWL)  /*@bf@*/
#define CPG_CANFD2_ILS_BOL	(CPG_CANFD2.unILS.stcField.u1BOL)  /*@bf@*/
#define CPG_CANFD2_ILS_WDIL	(CPG_CANFD2.unILS.stcField.u1WDIL)  /*@bf@*/
#define CPG_CANFD2_ILS_PEAL	(CPG_CANFD2.unILS.stcField.u1PEAL)  /*@bf@*/
#define CPG_CANFD2_ILS_PEDL	(CPG_CANFD2.unILS.stcField.u1PEDL)  /*@bf@*/
#define CPG_CANFD2_ILS_ARAL	(CPG_CANFD2.unILS.stcField.u1ARAL)  /*@bf@*/

#define CPG_CANFD3_ILS	(CPG_CANFD3.unILS.u32Register)  /*@rg@*/
#define CPG_CANFD3_ILS_RF0NL	(CPG_CANFD3.unILS.stcField.u1RF0NL)  /*@bf@*/
#define CPG_CANFD3_ILS_RF0WL	(CPG_CANFD3.unILS.stcField.u1RF0WL)  /*@bf@*/
#define CPG_CANFD3_ILS_RF0FL	(CPG_CANFD3.unILS.stcField.u1RF0FL)  /*@bf@*/
#define CPG_CANFD3_ILS_RF0LL	(CPG_CANFD3.unILS.stcField.u1RF0LL)  /*@bf@*/
#define CPG_CANFD3_ILS_RF1NL	(CPG_CANFD3.unILS.stcField.u1RF1NL)  /*@bf@*/
#define CPG_CANFD3_ILS_RF1WL	(CPG_CANFD3.unILS.stcField.u1RF1WL)  /*@bf@*/
#define CPG_CANFD3_ILS_RF1FL	(CPG_CANFD3.unILS.stcField.u1RF1FL)  /*@bf@*/
#define CPG_CANFD3_ILS_RF1LL	(CPG_CANFD3.unILS.stcField.u1RF1LL)  /*@bf@*/
#define CPG_CANFD3_ILS_HPML	(CPG_CANFD3.unILS.stcField.u1HPML)  /*@bf@*/
#define CPG_CANFD3_ILS_TCL	(CPG_CANFD3.unILS.stcField.u1TCL)  /*@bf@*/
#define CPG_CANFD3_ILS_TCFL	(CPG_CANFD3.unILS.stcField.u1TCFL)  /*@bf@*/
#define CPG_CANFD3_ILS_TFEL	(CPG_CANFD3.unILS.stcField.u1TFEL)  /*@bf@*/
#define CPG_CANFD3_ILS_TEFNL	(CPG_CANFD3.unILS.stcField.u1TEFNL)  /*@bf@*/
#define CPG_CANFD3_ILS_TEFWL	(CPG_CANFD3.unILS.stcField.u1TEFWL)  /*@bf@*/
#define CPG_CANFD3_ILS_TEFFL	(CPG_CANFD3.unILS.stcField.u1TEFFL)  /*@bf@*/
#define CPG_CANFD3_ILS_TEFLL	(CPG_CANFD3.unILS.stcField.u1TEFLL)  /*@bf@*/
#define CPG_CANFD3_ILS_TSWL	(CPG_CANFD3.unILS.stcField.u1TSWL)  /*@bf@*/
#define CPG_CANFD3_ILS_MRAFL	(CPG_CANFD3.unILS.stcField.u1MRAFL)  /*@bf@*/
#define CPG_CANFD3_ILS_TOOL	(CPG_CANFD3.unILS.stcField.u1TOOL)  /*@bf@*/
#define CPG_CANFD3_ILS_DRXL	(CPG_CANFD3.unILS.stcField.u1DRXL)  /*@bf@*/
#define CPG_CANFD3_ILS_BECL	(CPG_CANFD3.unILS.stcField.u1BECL)  /*@bf@*/
#define CPG_CANFD3_ILS_BEUL	(CPG_CANFD3.unILS.stcField.u1BEUL)  /*@bf@*/
#define CPG_CANFD3_ILS_ELOL	(CPG_CANFD3.unILS.stcField.u1ELOL)  /*@bf@*/
#define CPG_CANFD3_ILS_EPL	(CPG_CANFD3.unILS.stcField.u1EPL)  /*@bf@*/
#define CPG_CANFD3_ILS_EWL	(CPG_CANFD3.unILS.stcField.u1EWL)  /*@bf@*/
#define CPG_CANFD3_ILS_BOL	(CPG_CANFD3.unILS.stcField.u1BOL)  /*@bf@*/
#define CPG_CANFD3_ILS_WDIL	(CPG_CANFD3.unILS.stcField.u1WDIL)  /*@bf@*/
#define CPG_CANFD3_ILS_PEAL	(CPG_CANFD3.unILS.stcField.u1PEAL)  /*@bf@*/
#define CPG_CANFD3_ILS_PEDL	(CPG_CANFD3.unILS.stcField.u1PEDL)  /*@bf@*/
#define CPG_CANFD3_ILS_ARAL	(CPG_CANFD3.unILS.stcField.u1ARAL)  /*@bf@*/

typedef struct stc_cpg_canfdn_ils_field{
    uint_io32_t		u1RF0NL:1;
    uint_io32_t		u1RF0WL:1;
    uint_io32_t		u1RF0FL:1;
    uint_io32_t		u1RF0LL:1;
    uint_io32_t		u1RF1NL:1;
    uint_io32_t		u1RF1WL:1;
    uint_io32_t		u1RF1FL:1;
    uint_io32_t		u1RF1LL:1;
    uint_io32_t		u1HPML:1;
    uint_io32_t		u1TCL:1;
    uint_io32_t		u1TCFL:1;
    uint_io32_t		u1TFEL:1;
    uint_io32_t		u1TEFNL:1;
    uint_io32_t		u1TEFWL:1;
    uint_io32_t		u1TEFFL:1;
    uint_io32_t		u1TEFLL:1;
    uint_io32_t		u1TSWL:1;
    uint_io32_t		u1MRAFL:1;
    uint_io32_t		u1TOOL:1;
    uint_io32_t		u1DRXL:1;
    uint_io32_t		u1BECL:1;
    uint_io32_t		u1BEUL:1;
    uint_io32_t		u1ELOL:1;
    uint_io32_t		u1EPL:1;
    uint_io32_t		u1EWL:1;
    uint_io32_t		u1BOL:1;
    uint_io32_t		u1WDIL:1;
    uint_io32_t		u1PEAL:1;
    uint_io32_t		u1PEDL:1;
    uint_io32_t		u1ARAL:1;
    uint_io32_t		:2;
}stc_cpg_canfdn_ils_field_t;

typedef union un_cpg_canfdn_ils{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_ils_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_ils_t;

/* ILE */
#define CPG_CANFD0_ILE	(CPG_CANFD0.unILE.u32Register)  /*@rg@*/
#define CPG_CANFD0_ILE_EINT0	(CPG_CANFD0.unILE.stcField.u1EINT0)  /*@bf@*/
#define CPG_CANFD0_ILE_EINT1	(CPG_CANFD0.unILE.stcField.u1EINT1)  /*@bf@*/

#define CPG_CANFD1_ILE	(CPG_CANFD1.unILE.u32Register)  /*@rg@*/
#define CPG_CANFD1_ILE_EINT0	(CPG_CANFD1.unILE.stcField.u1EINT0)  /*@bf@*/
#define CPG_CANFD1_ILE_EINT1	(CPG_CANFD1.unILE.stcField.u1EINT1)  /*@bf@*/

#define CPG_CANFD2_ILE	(CPG_CANFD2.unILE.u32Register)  /*@rg@*/
#define CPG_CANFD2_ILE_EINT0	(CPG_CANFD2.unILE.stcField.u1EINT0)  /*@bf@*/
#define CPG_CANFD2_ILE_EINT1	(CPG_CANFD2.unILE.stcField.u1EINT1)  /*@bf@*/

#define CPG_CANFD3_ILE	(CPG_CANFD3.unILE.u32Register)  /*@rg@*/
#define CPG_CANFD3_ILE_EINT0	(CPG_CANFD3.unILE.stcField.u1EINT0)  /*@bf@*/
#define CPG_CANFD3_ILE_EINT1	(CPG_CANFD3.unILE.stcField.u1EINT1)  /*@bf@*/

typedef struct stc_cpg_canfdn_ile_field{
    uint_io32_t		u1EINT0:1;
    uint_io32_t		u1EINT1:1;
    uint_io32_t		:30;
}stc_cpg_canfdn_ile_field_t;

typedef union un_cpg_canfdn_ile{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_ile_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_ile_t;

/* GFC */
#define CPG_CANFD0_GFC	(CPG_CANFD0.unGFC.u32Register)  /*@rg@*/
#define CPG_CANFD0_GFC_RRFE	(CPG_CANFD0.unGFC.stcField.u1RRFE)  /*@bf@*/
#define CPG_CANFD0_GFC_RRFS	(CPG_CANFD0.unGFC.stcField.u1RRFS)  /*@bf@*/
#define CPG_CANFD0_GFC_ANFE	(CPG_CANFD0.unGFC.stcField.u2ANFE)  /*@bf@*/
#define CPG_CANFD0_GFC_ANFS	(CPG_CANFD0.unGFC.stcField.u2ANFS)  /*@bf@*/

#define CPG_CANFD1_GFC	(CPG_CANFD1.unGFC.u32Register)  /*@rg@*/
#define CPG_CANFD1_GFC_RRFE	(CPG_CANFD1.unGFC.stcField.u1RRFE)  /*@bf@*/
#define CPG_CANFD1_GFC_RRFS	(CPG_CANFD1.unGFC.stcField.u1RRFS)  /*@bf@*/
#define CPG_CANFD1_GFC_ANFE	(CPG_CANFD1.unGFC.stcField.u2ANFE)  /*@bf@*/
#define CPG_CANFD1_GFC_ANFS	(CPG_CANFD1.unGFC.stcField.u2ANFS)  /*@bf@*/

#define CPG_CANFD2_GFC	(CPG_CANFD2.unGFC.u32Register)  /*@rg@*/
#define CPG_CANFD2_GFC_RRFE	(CPG_CANFD2.unGFC.stcField.u1RRFE)  /*@bf@*/
#define CPG_CANFD2_GFC_RRFS	(CPG_CANFD2.unGFC.stcField.u1RRFS)  /*@bf@*/
#define CPG_CANFD2_GFC_ANFE	(CPG_CANFD2.unGFC.stcField.u2ANFE)  /*@bf@*/
#define CPG_CANFD2_GFC_ANFS	(CPG_CANFD2.unGFC.stcField.u2ANFS)  /*@bf@*/

#define CPG_CANFD3_GFC	(CPG_CANFD3.unGFC.u32Register)  /*@rg@*/
#define CPG_CANFD3_GFC_RRFE	(CPG_CANFD3.unGFC.stcField.u1RRFE)  /*@bf@*/
#define CPG_CANFD3_GFC_RRFS	(CPG_CANFD3.unGFC.stcField.u1RRFS)  /*@bf@*/
#define CPG_CANFD3_GFC_ANFE	(CPG_CANFD3.unGFC.stcField.u2ANFE)  /*@bf@*/
#define CPG_CANFD3_GFC_ANFS	(CPG_CANFD3.unGFC.stcField.u2ANFS)  /*@bf@*/

typedef struct stc_cpg_canfdn_gfc_field{
    uint_io32_t		u1RRFE:1;
    uint_io32_t		u1RRFS:1;
    uint_io32_t		u2ANFE:2;
    uint_io32_t		u2ANFS:2;
    uint_io32_t		:26;
}stc_cpg_canfdn_gfc_field_t;

typedef union un_cpg_canfdn_gfc{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_gfc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_gfc_t;

/* SIDFC */
#define CPG_CANFD0_SIDFC	(CPG_CANFD0.unSIDFC.u32Register)  /*@rg@*/
#define CPG_CANFD0_SIDFC_FLSSA	(CPG_CANFD0.unSIDFC.stcField.u14FLSSA)  /*@bf@*/
#define CPG_CANFD0_SIDFC_LSS	(CPG_CANFD0.unSIDFC.au8Byte[2])  /*@bfbyte@*/

#define CPG_CANFD1_SIDFC	(CPG_CANFD1.unSIDFC.u32Register)  /*@rg@*/
#define CPG_CANFD1_SIDFC_FLSSA	(CPG_CANFD1.unSIDFC.stcField.u14FLSSA)  /*@bf@*/
#define CPG_CANFD1_SIDFC_LSS	(CPG_CANFD1.unSIDFC.au8Byte[2])  /*@bfbyte@*/

#define CPG_CANFD2_SIDFC	(CPG_CANFD2.unSIDFC.u32Register)  /*@rg@*/
#define CPG_CANFD2_SIDFC_FLSSA	(CPG_CANFD2.unSIDFC.stcField.u14FLSSA)  /*@bf@*/
#define CPG_CANFD2_SIDFC_LSS	(CPG_CANFD2.unSIDFC.au8Byte[2])  /*@bfbyte@*/

#define CPG_CANFD3_SIDFC	(CPG_CANFD3.unSIDFC.u32Register)  /*@rg@*/
#define CPG_CANFD3_SIDFC_FLSSA	(CPG_CANFD3.unSIDFC.stcField.u14FLSSA)  /*@bf@*/
#define CPG_CANFD3_SIDFC_LSS	(CPG_CANFD3.unSIDFC.au8Byte[2])  /*@bfbyte@*/

typedef struct stc_cpg_canfdn_sidfc_field{
    uint_io32_t		:2;
    uint_io32_t		u14FLSSA:14;
    uint_io32_t		u8LSS:8;
    uint_io32_t		:8;
}stc_cpg_canfdn_sidfc_field_t;

typedef union un_cpg_canfdn_sidfc{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_sidfc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_sidfc_t;

/* XIDFC */
#define CPG_CANFD0_XIDFC	(CPG_CANFD0.unXIDFC.u32Register)  /*@rg@*/
#define CPG_CANFD0_XIDFC_FLESA	(CPG_CANFD0.unXIDFC.stcField.u14FLESA)  /*@bf@*/
#define CPG_CANFD0_XIDFC_LSE	(CPG_CANFD0.unXIDFC.stcField.u7LSE)  /*@bf@*/

#define CPG_CANFD1_XIDFC	(CPG_CANFD1.unXIDFC.u32Register)  /*@rg@*/
#define CPG_CANFD1_XIDFC_FLESA	(CPG_CANFD1.unXIDFC.stcField.u14FLESA)  /*@bf@*/
#define CPG_CANFD1_XIDFC_LSE	(CPG_CANFD1.unXIDFC.stcField.u7LSE)  /*@bf@*/

#define CPG_CANFD2_XIDFC	(CPG_CANFD2.unXIDFC.u32Register)  /*@rg@*/
#define CPG_CANFD2_XIDFC_FLESA	(CPG_CANFD2.unXIDFC.stcField.u14FLESA)  /*@bf@*/
#define CPG_CANFD2_XIDFC_LSE	(CPG_CANFD2.unXIDFC.stcField.u7LSE)  /*@bf@*/

#define CPG_CANFD3_XIDFC	(CPG_CANFD3.unXIDFC.u32Register)  /*@rg@*/
#define CPG_CANFD3_XIDFC_FLESA	(CPG_CANFD3.unXIDFC.stcField.u14FLESA)  /*@bf@*/
#define CPG_CANFD3_XIDFC_LSE	(CPG_CANFD3.unXIDFC.stcField.u7LSE)  /*@bf@*/

typedef struct stc_cpg_canfdn_xidfc_field{
    uint_io32_t		:2;
    uint_io32_t		u14FLESA:14;
    uint_io32_t		u7LSE:7;
    uint_io32_t		:9;
}stc_cpg_canfdn_xidfc_field_t;

typedef union un_cpg_canfdn_xidfc{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_xidfc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_xidfc_t;

/* XIDAM */
#define CPG_CANFD0_XIDAM	(CPG_CANFD0.unXIDAM.u32Register)  /*@rg@*/
#define CPG_CANFD0_XIDAM_EIDM	(CPG_CANFD0.unXIDAM.stcField.u29EIDM)  /*@bf@*/

#define CPG_CANFD1_XIDAM	(CPG_CANFD1.unXIDAM.u32Register)  /*@rg@*/
#define CPG_CANFD1_XIDAM_EIDM	(CPG_CANFD1.unXIDAM.stcField.u29EIDM)  /*@bf@*/

#define CPG_CANFD2_XIDAM	(CPG_CANFD2.unXIDAM.u32Register)  /*@rg@*/
#define CPG_CANFD2_XIDAM_EIDM	(CPG_CANFD2.unXIDAM.stcField.u29EIDM)  /*@bf@*/

#define CPG_CANFD3_XIDAM	(CPG_CANFD3.unXIDAM.u32Register)  /*@rg@*/
#define CPG_CANFD3_XIDAM_EIDM	(CPG_CANFD3.unXIDAM.stcField.u29EIDM)  /*@bf@*/

typedef struct stc_cpg_canfdn_xidam_field{
    uint_io32_t		u29EIDM:29;
    uint_io32_t		:3;
}stc_cpg_canfdn_xidam_field_t;

typedef union un_cpg_canfdn_xidam{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_xidam_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_xidam_t;

/* HPMS */
#define CPG_CANFD0_HPMS	(CPG_CANFD0.unHPMS.u32Register)  /*@rg@*/
#define CPG_CANFD0_HPMS_BIDX	(CPG_CANFD0.unHPMS.stcField.u6BIDX)  /*@bf@*/
#define CPG_CANFD0_HPMS_MSI	(CPG_CANFD0.unHPMS.stcField.u2MSI)  /*@bf@*/
#define CPG_CANFD0_HPMS_FIDX	(CPG_CANFD0.unHPMS.stcField.u7FIDX)  /*@bf@*/
#define CPG_CANFD0_HPMS_FLST	(CPG_CANFD0.unHPMS.stcField.u1FLST)  /*@bf@*/

#define CPG_CANFD1_HPMS	(CPG_CANFD1.unHPMS.u32Register)  /*@rg@*/
#define CPG_CANFD1_HPMS_BIDX	(CPG_CANFD1.unHPMS.stcField.u6BIDX)  /*@bf@*/
#define CPG_CANFD1_HPMS_MSI	(CPG_CANFD1.unHPMS.stcField.u2MSI)  /*@bf@*/
#define CPG_CANFD1_HPMS_FIDX	(CPG_CANFD1.unHPMS.stcField.u7FIDX)  /*@bf@*/
#define CPG_CANFD1_HPMS_FLST	(CPG_CANFD1.unHPMS.stcField.u1FLST)  /*@bf@*/

#define CPG_CANFD2_HPMS	(CPG_CANFD2.unHPMS.u32Register)  /*@rg@*/
#define CPG_CANFD2_HPMS_BIDX	(CPG_CANFD2.unHPMS.stcField.u6BIDX)  /*@bf@*/
#define CPG_CANFD2_HPMS_MSI	(CPG_CANFD2.unHPMS.stcField.u2MSI)  /*@bf@*/
#define CPG_CANFD2_HPMS_FIDX	(CPG_CANFD2.unHPMS.stcField.u7FIDX)  /*@bf@*/
#define CPG_CANFD2_HPMS_FLST	(CPG_CANFD2.unHPMS.stcField.u1FLST)  /*@bf@*/

#define CPG_CANFD3_HPMS	(CPG_CANFD3.unHPMS.u32Register)  /*@rg@*/
#define CPG_CANFD3_HPMS_BIDX	(CPG_CANFD3.unHPMS.stcField.u6BIDX)  /*@bf@*/
#define CPG_CANFD3_HPMS_MSI	(CPG_CANFD3.unHPMS.stcField.u2MSI)  /*@bf@*/
#define CPG_CANFD3_HPMS_FIDX	(CPG_CANFD3.unHPMS.stcField.u7FIDX)  /*@bf@*/
#define CPG_CANFD3_HPMS_FLST	(CPG_CANFD3.unHPMS.stcField.u1FLST)  /*@bf@*/

typedef struct stc_cpg_canfdn_hpms_field{
    uint_io32_t		u6BIDX:6;
    uint_io32_t		u2MSI:2;
    uint_io32_t		u7FIDX:7;
    uint_io32_t		u1FLST:1;
    uint_io32_t		:16;
}stc_cpg_canfdn_hpms_field_t;

typedef union un_cpg_canfdn_hpms{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_hpms_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_hpms_t;

/* NDAT1 */
#define CPG_CANFD0_NDAT1	(CPG_CANFD0.unNDAT1.u32Register)  /*@rg@*/
#define CPG_CANFD0_NDAT1_ND0	(CPG_CANFD0.unNDAT1.stcField.u1ND0)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND1	(CPG_CANFD0.unNDAT1.stcField.u1ND1)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND2	(CPG_CANFD0.unNDAT1.stcField.u1ND2)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND3	(CPG_CANFD0.unNDAT1.stcField.u1ND3)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND4	(CPG_CANFD0.unNDAT1.stcField.u1ND4)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND5	(CPG_CANFD0.unNDAT1.stcField.u1ND5)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND6	(CPG_CANFD0.unNDAT1.stcField.u1ND6)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND7	(CPG_CANFD0.unNDAT1.stcField.u1ND7)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND8	(CPG_CANFD0.unNDAT1.stcField.u1ND8)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND9	(CPG_CANFD0.unNDAT1.stcField.u1ND9)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND10	(CPG_CANFD0.unNDAT1.stcField.u1ND10)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND11	(CPG_CANFD0.unNDAT1.stcField.u1ND11)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND12	(CPG_CANFD0.unNDAT1.stcField.u1ND12)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND13	(CPG_CANFD0.unNDAT1.stcField.u1ND13)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND14	(CPG_CANFD0.unNDAT1.stcField.u1ND14)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND15	(CPG_CANFD0.unNDAT1.stcField.u1ND15)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND16	(CPG_CANFD0.unNDAT1.stcField.u1ND16)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND17	(CPG_CANFD0.unNDAT1.stcField.u1ND17)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND18	(CPG_CANFD0.unNDAT1.stcField.u1ND18)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND19	(CPG_CANFD0.unNDAT1.stcField.u1ND19)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND20	(CPG_CANFD0.unNDAT1.stcField.u1ND20)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND21	(CPG_CANFD0.unNDAT1.stcField.u1ND21)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND22	(CPG_CANFD0.unNDAT1.stcField.u1ND22)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND23	(CPG_CANFD0.unNDAT1.stcField.u1ND23)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND24	(CPG_CANFD0.unNDAT1.stcField.u1ND24)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND25	(CPG_CANFD0.unNDAT1.stcField.u1ND25)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND26	(CPG_CANFD0.unNDAT1.stcField.u1ND26)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND27	(CPG_CANFD0.unNDAT1.stcField.u1ND27)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND28	(CPG_CANFD0.unNDAT1.stcField.u1ND28)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND29	(CPG_CANFD0.unNDAT1.stcField.u1ND29)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND30	(CPG_CANFD0.unNDAT1.stcField.u1ND30)  /*@bf@*/
#define CPG_CANFD0_NDAT1_ND31	(CPG_CANFD0.unNDAT1.stcField.u1ND31)  /*@bf@*/

#define CPG_CANFD1_NDAT1	(CPG_CANFD1.unNDAT1.u32Register)  /*@rg@*/
#define CPG_CANFD1_NDAT1_ND0	(CPG_CANFD1.unNDAT1.stcField.u1ND0)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND1	(CPG_CANFD1.unNDAT1.stcField.u1ND1)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND2	(CPG_CANFD1.unNDAT1.stcField.u1ND2)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND3	(CPG_CANFD1.unNDAT1.stcField.u1ND3)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND4	(CPG_CANFD1.unNDAT1.stcField.u1ND4)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND5	(CPG_CANFD1.unNDAT1.stcField.u1ND5)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND6	(CPG_CANFD1.unNDAT1.stcField.u1ND6)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND7	(CPG_CANFD1.unNDAT1.stcField.u1ND7)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND8	(CPG_CANFD1.unNDAT1.stcField.u1ND8)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND9	(CPG_CANFD1.unNDAT1.stcField.u1ND9)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND10	(CPG_CANFD1.unNDAT1.stcField.u1ND10)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND11	(CPG_CANFD1.unNDAT1.stcField.u1ND11)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND12	(CPG_CANFD1.unNDAT1.stcField.u1ND12)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND13	(CPG_CANFD1.unNDAT1.stcField.u1ND13)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND14	(CPG_CANFD1.unNDAT1.stcField.u1ND14)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND15	(CPG_CANFD1.unNDAT1.stcField.u1ND15)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND16	(CPG_CANFD1.unNDAT1.stcField.u1ND16)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND17	(CPG_CANFD1.unNDAT1.stcField.u1ND17)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND18	(CPG_CANFD1.unNDAT1.stcField.u1ND18)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND19	(CPG_CANFD1.unNDAT1.stcField.u1ND19)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND20	(CPG_CANFD1.unNDAT1.stcField.u1ND20)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND21	(CPG_CANFD1.unNDAT1.stcField.u1ND21)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND22	(CPG_CANFD1.unNDAT1.stcField.u1ND22)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND23	(CPG_CANFD1.unNDAT1.stcField.u1ND23)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND24	(CPG_CANFD1.unNDAT1.stcField.u1ND24)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND25	(CPG_CANFD1.unNDAT1.stcField.u1ND25)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND26	(CPG_CANFD1.unNDAT1.stcField.u1ND26)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND27	(CPG_CANFD1.unNDAT1.stcField.u1ND27)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND28	(CPG_CANFD1.unNDAT1.stcField.u1ND28)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND29	(CPG_CANFD1.unNDAT1.stcField.u1ND29)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND30	(CPG_CANFD1.unNDAT1.stcField.u1ND30)  /*@bf@*/
#define CPG_CANFD1_NDAT1_ND31	(CPG_CANFD1.unNDAT1.stcField.u1ND31)  /*@bf@*/

#define CPG_CANFD2_NDAT1	(CPG_CANFD2.unNDAT1.u32Register)  /*@rg@*/
#define CPG_CANFD2_NDAT1_ND0	(CPG_CANFD2.unNDAT1.stcField.u1ND0)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND1	(CPG_CANFD2.unNDAT1.stcField.u1ND1)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND2	(CPG_CANFD2.unNDAT1.stcField.u1ND2)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND3	(CPG_CANFD2.unNDAT1.stcField.u1ND3)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND4	(CPG_CANFD2.unNDAT1.stcField.u1ND4)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND5	(CPG_CANFD2.unNDAT1.stcField.u1ND5)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND6	(CPG_CANFD2.unNDAT1.stcField.u1ND6)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND7	(CPG_CANFD2.unNDAT1.stcField.u1ND7)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND8	(CPG_CANFD2.unNDAT1.stcField.u1ND8)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND9	(CPG_CANFD2.unNDAT1.stcField.u1ND9)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND10	(CPG_CANFD2.unNDAT1.stcField.u1ND10)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND11	(CPG_CANFD2.unNDAT1.stcField.u1ND11)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND12	(CPG_CANFD2.unNDAT1.stcField.u1ND12)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND13	(CPG_CANFD2.unNDAT1.stcField.u1ND13)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND14	(CPG_CANFD2.unNDAT1.stcField.u1ND14)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND15	(CPG_CANFD2.unNDAT1.stcField.u1ND15)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND16	(CPG_CANFD2.unNDAT1.stcField.u1ND16)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND17	(CPG_CANFD2.unNDAT1.stcField.u1ND17)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND18	(CPG_CANFD2.unNDAT1.stcField.u1ND18)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND19	(CPG_CANFD2.unNDAT1.stcField.u1ND19)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND20	(CPG_CANFD2.unNDAT1.stcField.u1ND20)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND21	(CPG_CANFD2.unNDAT1.stcField.u1ND21)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND22	(CPG_CANFD2.unNDAT1.stcField.u1ND22)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND23	(CPG_CANFD2.unNDAT1.stcField.u1ND23)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND24	(CPG_CANFD2.unNDAT1.stcField.u1ND24)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND25	(CPG_CANFD2.unNDAT1.stcField.u1ND25)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND26	(CPG_CANFD2.unNDAT1.stcField.u1ND26)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND27	(CPG_CANFD2.unNDAT1.stcField.u1ND27)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND28	(CPG_CANFD2.unNDAT1.stcField.u1ND28)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND29	(CPG_CANFD2.unNDAT1.stcField.u1ND29)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND30	(CPG_CANFD2.unNDAT1.stcField.u1ND30)  /*@bf@*/
#define CPG_CANFD2_NDAT1_ND31	(CPG_CANFD2.unNDAT1.stcField.u1ND31)  /*@bf@*/

#define CPG_CANFD3_NDAT1	(CPG_CANFD3.unNDAT1.u32Register)  /*@rg@*/
#define CPG_CANFD3_NDAT1_ND0	(CPG_CANFD3.unNDAT1.stcField.u1ND0)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND1	(CPG_CANFD3.unNDAT1.stcField.u1ND1)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND2	(CPG_CANFD3.unNDAT1.stcField.u1ND2)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND3	(CPG_CANFD3.unNDAT1.stcField.u1ND3)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND4	(CPG_CANFD3.unNDAT1.stcField.u1ND4)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND5	(CPG_CANFD3.unNDAT1.stcField.u1ND5)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND6	(CPG_CANFD3.unNDAT1.stcField.u1ND6)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND7	(CPG_CANFD3.unNDAT1.stcField.u1ND7)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND8	(CPG_CANFD3.unNDAT1.stcField.u1ND8)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND9	(CPG_CANFD3.unNDAT1.stcField.u1ND9)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND10	(CPG_CANFD3.unNDAT1.stcField.u1ND10)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND11	(CPG_CANFD3.unNDAT1.stcField.u1ND11)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND12	(CPG_CANFD3.unNDAT1.stcField.u1ND12)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND13	(CPG_CANFD3.unNDAT1.stcField.u1ND13)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND14	(CPG_CANFD3.unNDAT1.stcField.u1ND14)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND15	(CPG_CANFD3.unNDAT1.stcField.u1ND15)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND16	(CPG_CANFD3.unNDAT1.stcField.u1ND16)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND17	(CPG_CANFD3.unNDAT1.stcField.u1ND17)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND18	(CPG_CANFD3.unNDAT1.stcField.u1ND18)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND19	(CPG_CANFD3.unNDAT1.stcField.u1ND19)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND20	(CPG_CANFD3.unNDAT1.stcField.u1ND20)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND21	(CPG_CANFD3.unNDAT1.stcField.u1ND21)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND22	(CPG_CANFD3.unNDAT1.stcField.u1ND22)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND23	(CPG_CANFD3.unNDAT1.stcField.u1ND23)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND24	(CPG_CANFD3.unNDAT1.stcField.u1ND24)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND25	(CPG_CANFD3.unNDAT1.stcField.u1ND25)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND26	(CPG_CANFD3.unNDAT1.stcField.u1ND26)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND27	(CPG_CANFD3.unNDAT1.stcField.u1ND27)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND28	(CPG_CANFD3.unNDAT1.stcField.u1ND28)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND29	(CPG_CANFD3.unNDAT1.stcField.u1ND29)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND30	(CPG_CANFD3.unNDAT1.stcField.u1ND30)  /*@bf@*/
#define CPG_CANFD3_NDAT1_ND31	(CPG_CANFD3.unNDAT1.stcField.u1ND31)  /*@bf@*/

typedef struct stc_cpg_canfdn_ndat1_field{
    uint_io32_t		u1ND0:1;
    uint_io32_t		u1ND1:1;
    uint_io32_t		u1ND2:1;
    uint_io32_t		u1ND3:1;
    uint_io32_t		u1ND4:1;
    uint_io32_t		u1ND5:1;
    uint_io32_t		u1ND6:1;
    uint_io32_t		u1ND7:1;
    uint_io32_t		u1ND8:1;
    uint_io32_t		u1ND9:1;
    uint_io32_t		u1ND10:1;
    uint_io32_t		u1ND11:1;
    uint_io32_t		u1ND12:1;
    uint_io32_t		u1ND13:1;
    uint_io32_t		u1ND14:1;
    uint_io32_t		u1ND15:1;
    uint_io32_t		u1ND16:1;
    uint_io32_t		u1ND17:1;
    uint_io32_t		u1ND18:1;
    uint_io32_t		u1ND19:1;
    uint_io32_t		u1ND20:1;
    uint_io32_t		u1ND21:1;
    uint_io32_t		u1ND22:1;
    uint_io32_t		u1ND23:1;
    uint_io32_t		u1ND24:1;
    uint_io32_t		u1ND25:1;
    uint_io32_t		u1ND26:1;
    uint_io32_t		u1ND27:1;
    uint_io32_t		u1ND28:1;
    uint_io32_t		u1ND29:1;
    uint_io32_t		u1ND30:1;
    uint_io32_t		u1ND31:1;
}stc_cpg_canfdn_ndat1_field_t;

typedef union un_cpg_canfdn_ndat1{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_ndat1_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_ndat1_t;

/* NDAT2 */
#define CPG_CANFD0_NDAT2	(CPG_CANFD0.unNDAT2.u32Register)  /*@rg@*/
#define CPG_CANFD0_NDAT2_ND32	(CPG_CANFD0.unNDAT2.stcField.u1ND32)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND33	(CPG_CANFD0.unNDAT2.stcField.u1ND33)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND34	(CPG_CANFD0.unNDAT2.stcField.u1ND34)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND35	(CPG_CANFD0.unNDAT2.stcField.u1ND35)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND36	(CPG_CANFD0.unNDAT2.stcField.u1ND36)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND37	(CPG_CANFD0.unNDAT2.stcField.u1ND37)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND38	(CPG_CANFD0.unNDAT2.stcField.u1ND38)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND39	(CPG_CANFD0.unNDAT2.stcField.u1ND39)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND40	(CPG_CANFD0.unNDAT2.stcField.u1ND40)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND41	(CPG_CANFD0.unNDAT2.stcField.u1ND41)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND42	(CPG_CANFD0.unNDAT2.stcField.u1ND42)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND43	(CPG_CANFD0.unNDAT2.stcField.u1ND43)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND44	(CPG_CANFD0.unNDAT2.stcField.u1ND44)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND45	(CPG_CANFD0.unNDAT2.stcField.u1ND45)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND46	(CPG_CANFD0.unNDAT2.stcField.u1ND46)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND47	(CPG_CANFD0.unNDAT2.stcField.u1ND47)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND48	(CPG_CANFD0.unNDAT2.stcField.u1ND48)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND49	(CPG_CANFD0.unNDAT2.stcField.u1ND49)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND50	(CPG_CANFD0.unNDAT2.stcField.u1ND50)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND51	(CPG_CANFD0.unNDAT2.stcField.u1ND51)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND52	(CPG_CANFD0.unNDAT2.stcField.u1ND52)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND53	(CPG_CANFD0.unNDAT2.stcField.u1ND53)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND54	(CPG_CANFD0.unNDAT2.stcField.u1ND54)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND55	(CPG_CANFD0.unNDAT2.stcField.u1ND55)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND56	(CPG_CANFD0.unNDAT2.stcField.u1ND56)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND57	(CPG_CANFD0.unNDAT2.stcField.u1ND57)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND58	(CPG_CANFD0.unNDAT2.stcField.u1ND58)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND59	(CPG_CANFD0.unNDAT2.stcField.u1ND59)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND60	(CPG_CANFD0.unNDAT2.stcField.u1ND60)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND61	(CPG_CANFD0.unNDAT2.stcField.u1ND61)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND62	(CPG_CANFD0.unNDAT2.stcField.u1ND62)  /*@bf@*/
#define CPG_CANFD0_NDAT2_ND63	(CPG_CANFD0.unNDAT2.stcField.u1ND63)  /*@bf@*/

#define CPG_CANFD1_NDAT2	(CPG_CANFD1.unNDAT2.u32Register)  /*@rg@*/
#define CPG_CANFD1_NDAT2_ND32	(CPG_CANFD1.unNDAT2.stcField.u1ND32)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND33	(CPG_CANFD1.unNDAT2.stcField.u1ND33)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND34	(CPG_CANFD1.unNDAT2.stcField.u1ND34)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND35	(CPG_CANFD1.unNDAT2.stcField.u1ND35)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND36	(CPG_CANFD1.unNDAT2.stcField.u1ND36)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND37	(CPG_CANFD1.unNDAT2.stcField.u1ND37)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND38	(CPG_CANFD1.unNDAT2.stcField.u1ND38)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND39	(CPG_CANFD1.unNDAT2.stcField.u1ND39)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND40	(CPG_CANFD1.unNDAT2.stcField.u1ND40)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND41	(CPG_CANFD1.unNDAT2.stcField.u1ND41)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND42	(CPG_CANFD1.unNDAT2.stcField.u1ND42)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND43	(CPG_CANFD1.unNDAT2.stcField.u1ND43)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND44	(CPG_CANFD1.unNDAT2.stcField.u1ND44)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND45	(CPG_CANFD1.unNDAT2.stcField.u1ND45)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND46	(CPG_CANFD1.unNDAT2.stcField.u1ND46)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND47	(CPG_CANFD1.unNDAT2.stcField.u1ND47)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND48	(CPG_CANFD1.unNDAT2.stcField.u1ND48)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND49	(CPG_CANFD1.unNDAT2.stcField.u1ND49)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND50	(CPG_CANFD1.unNDAT2.stcField.u1ND50)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND51	(CPG_CANFD1.unNDAT2.stcField.u1ND51)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND52	(CPG_CANFD1.unNDAT2.stcField.u1ND52)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND53	(CPG_CANFD1.unNDAT2.stcField.u1ND53)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND54	(CPG_CANFD1.unNDAT2.stcField.u1ND54)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND55	(CPG_CANFD1.unNDAT2.stcField.u1ND55)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND56	(CPG_CANFD1.unNDAT2.stcField.u1ND56)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND57	(CPG_CANFD1.unNDAT2.stcField.u1ND57)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND58	(CPG_CANFD1.unNDAT2.stcField.u1ND58)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND59	(CPG_CANFD1.unNDAT2.stcField.u1ND59)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND60	(CPG_CANFD1.unNDAT2.stcField.u1ND60)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND61	(CPG_CANFD1.unNDAT2.stcField.u1ND61)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND62	(CPG_CANFD1.unNDAT2.stcField.u1ND62)  /*@bf@*/
#define CPG_CANFD1_NDAT2_ND63	(CPG_CANFD1.unNDAT2.stcField.u1ND63)  /*@bf@*/

#define CPG_CANFD2_NDAT2	(CPG_CANFD2.unNDAT2.u32Register)  /*@rg@*/
#define CPG_CANFD2_NDAT2_ND32	(CPG_CANFD2.unNDAT2.stcField.u1ND32)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND33	(CPG_CANFD2.unNDAT2.stcField.u1ND33)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND34	(CPG_CANFD2.unNDAT2.stcField.u1ND34)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND35	(CPG_CANFD2.unNDAT2.stcField.u1ND35)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND36	(CPG_CANFD2.unNDAT2.stcField.u1ND36)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND37	(CPG_CANFD2.unNDAT2.stcField.u1ND37)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND38	(CPG_CANFD2.unNDAT2.stcField.u1ND38)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND39	(CPG_CANFD2.unNDAT2.stcField.u1ND39)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND40	(CPG_CANFD2.unNDAT2.stcField.u1ND40)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND41	(CPG_CANFD2.unNDAT2.stcField.u1ND41)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND42	(CPG_CANFD2.unNDAT2.stcField.u1ND42)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND43	(CPG_CANFD2.unNDAT2.stcField.u1ND43)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND44	(CPG_CANFD2.unNDAT2.stcField.u1ND44)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND45	(CPG_CANFD2.unNDAT2.stcField.u1ND45)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND46	(CPG_CANFD2.unNDAT2.stcField.u1ND46)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND47	(CPG_CANFD2.unNDAT2.stcField.u1ND47)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND48	(CPG_CANFD2.unNDAT2.stcField.u1ND48)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND49	(CPG_CANFD2.unNDAT2.stcField.u1ND49)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND50	(CPG_CANFD2.unNDAT2.stcField.u1ND50)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND51	(CPG_CANFD2.unNDAT2.stcField.u1ND51)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND52	(CPG_CANFD2.unNDAT2.stcField.u1ND52)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND53	(CPG_CANFD2.unNDAT2.stcField.u1ND53)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND54	(CPG_CANFD2.unNDAT2.stcField.u1ND54)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND55	(CPG_CANFD2.unNDAT2.stcField.u1ND55)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND56	(CPG_CANFD2.unNDAT2.stcField.u1ND56)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND57	(CPG_CANFD2.unNDAT2.stcField.u1ND57)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND58	(CPG_CANFD2.unNDAT2.stcField.u1ND58)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND59	(CPG_CANFD2.unNDAT2.stcField.u1ND59)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND60	(CPG_CANFD2.unNDAT2.stcField.u1ND60)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND61	(CPG_CANFD2.unNDAT2.stcField.u1ND61)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND62	(CPG_CANFD2.unNDAT2.stcField.u1ND62)  /*@bf@*/
#define CPG_CANFD2_NDAT2_ND63	(CPG_CANFD2.unNDAT2.stcField.u1ND63)  /*@bf@*/

#define CPG_CANFD3_NDAT2	(CPG_CANFD3.unNDAT2.u32Register)  /*@rg@*/
#define CPG_CANFD3_NDAT2_ND32	(CPG_CANFD3.unNDAT2.stcField.u1ND32)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND33	(CPG_CANFD3.unNDAT2.stcField.u1ND33)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND34	(CPG_CANFD3.unNDAT2.stcField.u1ND34)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND35	(CPG_CANFD3.unNDAT2.stcField.u1ND35)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND36	(CPG_CANFD3.unNDAT2.stcField.u1ND36)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND37	(CPG_CANFD3.unNDAT2.stcField.u1ND37)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND38	(CPG_CANFD3.unNDAT2.stcField.u1ND38)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND39	(CPG_CANFD3.unNDAT2.stcField.u1ND39)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND40	(CPG_CANFD3.unNDAT2.stcField.u1ND40)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND41	(CPG_CANFD3.unNDAT2.stcField.u1ND41)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND42	(CPG_CANFD3.unNDAT2.stcField.u1ND42)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND43	(CPG_CANFD3.unNDAT2.stcField.u1ND43)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND44	(CPG_CANFD3.unNDAT2.stcField.u1ND44)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND45	(CPG_CANFD3.unNDAT2.stcField.u1ND45)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND46	(CPG_CANFD3.unNDAT2.stcField.u1ND46)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND47	(CPG_CANFD3.unNDAT2.stcField.u1ND47)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND48	(CPG_CANFD3.unNDAT2.stcField.u1ND48)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND49	(CPG_CANFD3.unNDAT2.stcField.u1ND49)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND50	(CPG_CANFD3.unNDAT2.stcField.u1ND50)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND51	(CPG_CANFD3.unNDAT2.stcField.u1ND51)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND52	(CPG_CANFD3.unNDAT2.stcField.u1ND52)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND53	(CPG_CANFD3.unNDAT2.stcField.u1ND53)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND54	(CPG_CANFD3.unNDAT2.stcField.u1ND54)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND55	(CPG_CANFD3.unNDAT2.stcField.u1ND55)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND56	(CPG_CANFD3.unNDAT2.stcField.u1ND56)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND57	(CPG_CANFD3.unNDAT2.stcField.u1ND57)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND58	(CPG_CANFD3.unNDAT2.stcField.u1ND58)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND59	(CPG_CANFD3.unNDAT2.stcField.u1ND59)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND60	(CPG_CANFD3.unNDAT2.stcField.u1ND60)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND61	(CPG_CANFD3.unNDAT2.stcField.u1ND61)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND62	(CPG_CANFD3.unNDAT2.stcField.u1ND62)  /*@bf@*/
#define CPG_CANFD3_NDAT2_ND63	(CPG_CANFD3.unNDAT2.stcField.u1ND63)  /*@bf@*/

typedef struct stc_cpg_canfdn_ndat2_field{
    uint_io32_t		u1ND32:1;
    uint_io32_t		u1ND33:1;
    uint_io32_t		u1ND34:1;
    uint_io32_t		u1ND35:1;
    uint_io32_t		u1ND36:1;
    uint_io32_t		u1ND37:1;
    uint_io32_t		u1ND38:1;
    uint_io32_t		u1ND39:1;
    uint_io32_t		u1ND40:1;
    uint_io32_t		u1ND41:1;
    uint_io32_t		u1ND42:1;
    uint_io32_t		u1ND43:1;
    uint_io32_t		u1ND44:1;
    uint_io32_t		u1ND45:1;
    uint_io32_t		u1ND46:1;
    uint_io32_t		u1ND47:1;
    uint_io32_t		u1ND48:1;
    uint_io32_t		u1ND49:1;
    uint_io32_t		u1ND50:1;
    uint_io32_t		u1ND51:1;
    uint_io32_t		u1ND52:1;
    uint_io32_t		u1ND53:1;
    uint_io32_t		u1ND54:1;
    uint_io32_t		u1ND55:1;
    uint_io32_t		u1ND56:1;
    uint_io32_t		u1ND57:1;
    uint_io32_t		u1ND58:1;
    uint_io32_t		u1ND59:1;
    uint_io32_t		u1ND60:1;
    uint_io32_t		u1ND61:1;
    uint_io32_t		u1ND62:1;
    uint_io32_t		u1ND63:1;
}stc_cpg_canfdn_ndat2_field_t;

typedef union un_cpg_canfdn_ndat2{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_ndat2_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_ndat2_t;

/* RXF0C */
#define CPG_CANFD0_RXF0C	(CPG_CANFD0.unRXF0C.u32Register)  /*@rg@*/
#define CPG_CANFD0_RXF0C_F0SA	(CPG_CANFD0.unRXF0C.stcField.u14F0SA)  /*@bf@*/
#define CPG_CANFD0_RXF0C_F0S	(CPG_CANFD0.unRXF0C.stcField.u7F0S)  /*@bf@*/
#define CPG_CANFD0_RXF0C_F0WM	(CPG_CANFD0.unRXF0C.stcField.u7F0WM)  /*@bf@*/
#define CPG_CANFD0_RXF0C_F0OM	(CPG_CANFD0.unRXF0C.stcField.u1F0OM)  /*@bf@*/

#define CPG_CANFD1_RXF0C	(CPG_CANFD1.unRXF0C.u32Register)  /*@rg@*/
#define CPG_CANFD1_RXF0C_F0SA	(CPG_CANFD1.unRXF0C.stcField.u14F0SA)  /*@bf@*/
#define CPG_CANFD1_RXF0C_F0S	(CPG_CANFD1.unRXF0C.stcField.u7F0S)  /*@bf@*/
#define CPG_CANFD1_RXF0C_F0WM	(CPG_CANFD1.unRXF0C.stcField.u7F0WM)  /*@bf@*/
#define CPG_CANFD1_RXF0C_F0OM	(CPG_CANFD1.unRXF0C.stcField.u1F0OM)  /*@bf@*/

#define CPG_CANFD2_RXF0C	(CPG_CANFD2.unRXF0C.u32Register)  /*@rg@*/
#define CPG_CANFD2_RXF0C_F0SA	(CPG_CANFD2.unRXF0C.stcField.u14F0SA)  /*@bf@*/
#define CPG_CANFD2_RXF0C_F0S	(CPG_CANFD2.unRXF0C.stcField.u7F0S)  /*@bf@*/
#define CPG_CANFD2_RXF0C_F0WM	(CPG_CANFD2.unRXF0C.stcField.u7F0WM)  /*@bf@*/
#define CPG_CANFD2_RXF0C_F0OM	(CPG_CANFD2.unRXF0C.stcField.u1F0OM)  /*@bf@*/

#define CPG_CANFD3_RXF0C	(CPG_CANFD3.unRXF0C.u32Register)  /*@rg@*/
#define CPG_CANFD3_RXF0C_F0SA	(CPG_CANFD3.unRXF0C.stcField.u14F0SA)  /*@bf@*/
#define CPG_CANFD3_RXF0C_F0S	(CPG_CANFD3.unRXF0C.stcField.u7F0S)  /*@bf@*/
#define CPG_CANFD3_RXF0C_F0WM	(CPG_CANFD3.unRXF0C.stcField.u7F0WM)  /*@bf@*/
#define CPG_CANFD3_RXF0C_F0OM	(CPG_CANFD3.unRXF0C.stcField.u1F0OM)  /*@bf@*/

typedef struct stc_cpg_canfdn_rxf0c_field{
    uint_io32_t		:2;
    uint_io32_t		u14F0SA:14;
    uint_io32_t		u7F0S:7;
    uint_io32_t		:1;
    uint_io32_t		u7F0WM:7;
    uint_io32_t		u1F0OM:1;
}stc_cpg_canfdn_rxf0c_field_t;

typedef union un_cpg_canfdn_rxf0c{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_rxf0c_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_rxf0c_t;

/* RXF0S */
#define CPG_CANFD0_RXF0S	(CPG_CANFD0.unRXF0S.u32Register)  /*@rg@*/
#define CPG_CANFD0_RXF0S_F0FL	(CPG_CANFD0.unRXF0S.stcField.u7F0FL)  /*@bf@*/
#define CPG_CANFD0_RXF0S_F0GI	(CPG_CANFD0.unRXF0S.stcField.u6F0GI)  /*@bf@*/
#define CPG_CANFD0_RXF0S_F0PI	(CPG_CANFD0.unRXF0S.stcField.u6F0PI)  /*@bf@*/
#define CPG_CANFD0_RXF0S_F0F	(CPG_CANFD0.unRXF0S.stcField.u1F0F)  /*@bf@*/
#define CPG_CANFD0_RXF0S_RF0L	(CPG_CANFD0.unRXF0S.stcField.u1RF0L)  /*@bf@*/

#define CPG_CANFD1_RXF0S	(CPG_CANFD1.unRXF0S.u32Register)  /*@rg@*/
#define CPG_CANFD1_RXF0S_F0FL	(CPG_CANFD1.unRXF0S.stcField.u7F0FL)  /*@bf@*/
#define CPG_CANFD1_RXF0S_F0GI	(CPG_CANFD1.unRXF0S.stcField.u6F0GI)  /*@bf@*/
#define CPG_CANFD1_RXF0S_F0PI	(CPG_CANFD1.unRXF0S.stcField.u6F0PI)  /*@bf@*/
#define CPG_CANFD1_RXF0S_F0F	(CPG_CANFD1.unRXF0S.stcField.u1F0F)  /*@bf@*/
#define CPG_CANFD1_RXF0S_RF0L	(CPG_CANFD1.unRXF0S.stcField.u1RF0L)  /*@bf@*/

#define CPG_CANFD2_RXF0S	(CPG_CANFD2.unRXF0S.u32Register)  /*@rg@*/
#define CPG_CANFD2_RXF0S_F0FL	(CPG_CANFD2.unRXF0S.stcField.u7F0FL)  /*@bf@*/
#define CPG_CANFD2_RXF0S_F0GI	(CPG_CANFD2.unRXF0S.stcField.u6F0GI)  /*@bf@*/
#define CPG_CANFD2_RXF0S_F0PI	(CPG_CANFD2.unRXF0S.stcField.u6F0PI)  /*@bf@*/
#define CPG_CANFD2_RXF0S_F0F	(CPG_CANFD2.unRXF0S.stcField.u1F0F)  /*@bf@*/
#define CPG_CANFD2_RXF0S_RF0L	(CPG_CANFD2.unRXF0S.stcField.u1RF0L)  /*@bf@*/

#define CPG_CANFD3_RXF0S	(CPG_CANFD3.unRXF0S.u32Register)  /*@rg@*/
#define CPG_CANFD3_RXF0S_F0FL	(CPG_CANFD3.unRXF0S.stcField.u7F0FL)  /*@bf@*/
#define CPG_CANFD3_RXF0S_F0GI	(CPG_CANFD3.unRXF0S.stcField.u6F0GI)  /*@bf@*/
#define CPG_CANFD3_RXF0S_F0PI	(CPG_CANFD3.unRXF0S.stcField.u6F0PI)  /*@bf@*/
#define CPG_CANFD3_RXF0S_F0F	(CPG_CANFD3.unRXF0S.stcField.u1F0F)  /*@bf@*/
#define CPG_CANFD3_RXF0S_RF0L	(CPG_CANFD3.unRXF0S.stcField.u1RF0L)  /*@bf@*/

typedef struct stc_cpg_canfdn_rxf0s_field{
    uint_io32_t		u7F0FL:7;
    uint_io32_t		:1;
    uint_io32_t		u6F0GI:6;
    uint_io32_t		:2;
    uint_io32_t		u6F0PI:6;
    uint_io32_t		:2;
    uint_io32_t		u1F0F:1;
    uint_io32_t		u1RF0L:1;
    uint_io32_t		:6;
}stc_cpg_canfdn_rxf0s_field_t;

typedef union un_cpg_canfdn_rxf0s{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_rxf0s_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_rxf0s_t;

/* RXF0A */
#define CPG_CANFD0_RXF0A	(CPG_CANFD0.unRXF0A.u32Register)  /*@rg@*/
#define CPG_CANFD0_RXF0A_F0AI	(CPG_CANFD0.unRXF0A.stcField.u6F0AI)  /*@bf@*/

#define CPG_CANFD1_RXF0A	(CPG_CANFD1.unRXF0A.u32Register)  /*@rg@*/
#define CPG_CANFD1_RXF0A_F0AI	(CPG_CANFD1.unRXF0A.stcField.u6F0AI)  /*@bf@*/

#define CPG_CANFD2_RXF0A	(CPG_CANFD2.unRXF0A.u32Register)  /*@rg@*/
#define CPG_CANFD2_RXF0A_F0AI	(CPG_CANFD2.unRXF0A.stcField.u6F0AI)  /*@bf@*/

#define CPG_CANFD3_RXF0A	(CPG_CANFD3.unRXF0A.u32Register)  /*@rg@*/
#define CPG_CANFD3_RXF0A_F0AI	(CPG_CANFD3.unRXF0A.stcField.u6F0AI)  /*@bf@*/

typedef struct stc_cpg_canfdn_rxf0a_field{
    uint_io32_t		u6F0AI:6;
    uint_io32_t		:26;
}stc_cpg_canfdn_rxf0a_field_t;

typedef union un_cpg_canfdn_rxf0a{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_rxf0a_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_rxf0a_t;

/* RXBC */
#define CPG_CANFD0_RXBC	(CPG_CANFD0.unRXBC.u32Register)  /*@rg@*/
#define CPG_CANFD0_RXBC_RBSA	(CPG_CANFD0.unRXBC.stcField.u14RBSA)  /*@bf@*/

#define CPG_CANFD1_RXBC	(CPG_CANFD1.unRXBC.u32Register)  /*@rg@*/
#define CPG_CANFD1_RXBC_RBSA	(CPG_CANFD1.unRXBC.stcField.u14RBSA)  /*@bf@*/

#define CPG_CANFD2_RXBC	(CPG_CANFD2.unRXBC.u32Register)  /*@rg@*/
#define CPG_CANFD2_RXBC_RBSA	(CPG_CANFD2.unRXBC.stcField.u14RBSA)  /*@bf@*/

#define CPG_CANFD3_RXBC	(CPG_CANFD3.unRXBC.u32Register)  /*@rg@*/
#define CPG_CANFD3_RXBC_RBSA	(CPG_CANFD3.unRXBC.stcField.u14RBSA)  /*@bf@*/

typedef struct stc_cpg_canfdn_rxbc_field{
    uint_io32_t		:2;
    uint_io32_t		u14RBSA:14;
    uint_io32_t		:16;
}stc_cpg_canfdn_rxbc_field_t;

typedef union un_cpg_canfdn_rxbc{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_rxbc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_rxbc_t;

/* RXF1C */
#define CPG_CANFD0_RXF1C	(CPG_CANFD0.unRXF1C.u32Register)  /*@rg@*/
#define CPG_CANFD0_RXF1C_F1SA	(CPG_CANFD0.unRXF1C.stcField.u14F1SA)  /*@bf@*/
#define CPG_CANFD0_RXF1C_F1S	(CPG_CANFD0.unRXF1C.stcField.u7F1S)  /*@bf@*/
#define CPG_CANFD0_RXF1C_F1WM	(CPG_CANFD0.unRXF1C.stcField.u7F1WM)  /*@bf@*/
#define CPG_CANFD0_RXF1C_F1OM	(CPG_CANFD0.unRXF1C.stcField.u1F1OM)  /*@bf@*/

#define CPG_CANFD1_RXF1C	(CPG_CANFD1.unRXF1C.u32Register)  /*@rg@*/
#define CPG_CANFD1_RXF1C_F1SA	(CPG_CANFD1.unRXF1C.stcField.u14F1SA)  /*@bf@*/
#define CPG_CANFD1_RXF1C_F1S	(CPG_CANFD1.unRXF1C.stcField.u7F1S)  /*@bf@*/
#define CPG_CANFD1_RXF1C_F1WM	(CPG_CANFD1.unRXF1C.stcField.u7F1WM)  /*@bf@*/
#define CPG_CANFD1_RXF1C_F1OM	(CPG_CANFD1.unRXF1C.stcField.u1F1OM)  /*@bf@*/

#define CPG_CANFD2_RXF1C	(CPG_CANFD2.unRXF1C.u32Register)  /*@rg@*/
#define CPG_CANFD2_RXF1C_F1SA	(CPG_CANFD2.unRXF1C.stcField.u14F1SA)  /*@bf@*/
#define CPG_CANFD2_RXF1C_F1S	(CPG_CANFD2.unRXF1C.stcField.u7F1S)  /*@bf@*/
#define CPG_CANFD2_RXF1C_F1WM	(CPG_CANFD2.unRXF1C.stcField.u7F1WM)  /*@bf@*/
#define CPG_CANFD2_RXF1C_F1OM	(CPG_CANFD2.unRXF1C.stcField.u1F1OM)  /*@bf@*/

#define CPG_CANFD3_RXF1C	(CPG_CANFD3.unRXF1C.u32Register)  /*@rg@*/
#define CPG_CANFD3_RXF1C_F1SA	(CPG_CANFD3.unRXF1C.stcField.u14F1SA)  /*@bf@*/
#define CPG_CANFD3_RXF1C_F1S	(CPG_CANFD3.unRXF1C.stcField.u7F1S)  /*@bf@*/
#define CPG_CANFD3_RXF1C_F1WM	(CPG_CANFD3.unRXF1C.stcField.u7F1WM)  /*@bf@*/
#define CPG_CANFD3_RXF1C_F1OM	(CPG_CANFD3.unRXF1C.stcField.u1F1OM)  /*@bf@*/

typedef struct stc_cpg_canfdn_rxf1c_field{
    uint_io32_t		:2;
    uint_io32_t		u14F1SA:14;
    uint_io32_t		u7F1S:7;
    uint_io32_t		:1;
    uint_io32_t		u7F1WM:7;
    uint_io32_t		u1F1OM:1;
}stc_cpg_canfdn_rxf1c_field_t;

typedef union un_cpg_canfdn_rxf1c{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_rxf1c_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_rxf1c_t;

/* RXF1S */
#define CPG_CANFD0_RXF1S	(CPG_CANFD0.unRXF1S.u32Register)  /*@rg@*/
#define CPG_CANFD0_RXF1S_F1FL	(CPG_CANFD0.unRXF1S.stcField.u7F1FL)  /*@bf@*/
#define CPG_CANFD0_RXF1S_F1GI	(CPG_CANFD0.unRXF1S.stcField.u6F1GI)  /*@bf@*/
#define CPG_CANFD0_RXF1S_F1PI	(CPG_CANFD0.unRXF1S.stcField.u6F1PI)  /*@bf@*/
#define CPG_CANFD0_RXF1S_F1F	(CPG_CANFD0.unRXF1S.stcField.u1F1F)  /*@bf@*/
#define CPG_CANFD0_RXF1S_RF1L	(CPG_CANFD0.unRXF1S.stcField.u1RF1L)  /*@bf@*/
#define CPG_CANFD0_RXF1S_DMS	(CPG_CANFD0.unRXF1S.stcField.u2DMS)  /*@bf@*/

#define CPG_CANFD1_RXF1S	(CPG_CANFD1.unRXF1S.u32Register)  /*@rg@*/
#define CPG_CANFD1_RXF1S_F1FL	(CPG_CANFD1.unRXF1S.stcField.u7F1FL)  /*@bf@*/
#define CPG_CANFD1_RXF1S_F1GI	(CPG_CANFD1.unRXF1S.stcField.u6F1GI)  /*@bf@*/
#define CPG_CANFD1_RXF1S_F1PI	(CPG_CANFD1.unRXF1S.stcField.u6F1PI)  /*@bf@*/
#define CPG_CANFD1_RXF1S_F1F	(CPG_CANFD1.unRXF1S.stcField.u1F1F)  /*@bf@*/
#define CPG_CANFD1_RXF1S_RF1L	(CPG_CANFD1.unRXF1S.stcField.u1RF1L)  /*@bf@*/
#define CPG_CANFD1_RXF1S_DMS	(CPG_CANFD1.unRXF1S.stcField.u2DMS)  /*@bf@*/

#define CPG_CANFD2_RXF1S	(CPG_CANFD2.unRXF1S.u32Register)  /*@rg@*/
#define CPG_CANFD2_RXF1S_F1FL	(CPG_CANFD2.unRXF1S.stcField.u7F1FL)  /*@bf@*/
#define CPG_CANFD2_RXF1S_F1GI	(CPG_CANFD2.unRXF1S.stcField.u6F1GI)  /*@bf@*/
#define CPG_CANFD2_RXF1S_F1PI	(CPG_CANFD2.unRXF1S.stcField.u6F1PI)  /*@bf@*/
#define CPG_CANFD2_RXF1S_F1F	(CPG_CANFD2.unRXF1S.stcField.u1F1F)  /*@bf@*/
#define CPG_CANFD2_RXF1S_RF1L	(CPG_CANFD2.unRXF1S.stcField.u1RF1L)  /*@bf@*/
#define CPG_CANFD2_RXF1S_DMS	(CPG_CANFD2.unRXF1S.stcField.u2DMS)  /*@bf@*/

#define CPG_CANFD3_RXF1S	(CPG_CANFD3.unRXF1S.u32Register)  /*@rg@*/
#define CPG_CANFD3_RXF1S_F1FL	(CPG_CANFD3.unRXF1S.stcField.u7F1FL)  /*@bf@*/
#define CPG_CANFD3_RXF1S_F1GI	(CPG_CANFD3.unRXF1S.stcField.u6F1GI)  /*@bf@*/
#define CPG_CANFD3_RXF1S_F1PI	(CPG_CANFD3.unRXF1S.stcField.u6F1PI)  /*@bf@*/
#define CPG_CANFD3_RXF1S_F1F	(CPG_CANFD3.unRXF1S.stcField.u1F1F)  /*@bf@*/
#define CPG_CANFD3_RXF1S_RF1L	(CPG_CANFD3.unRXF1S.stcField.u1RF1L)  /*@bf@*/
#define CPG_CANFD3_RXF1S_DMS	(CPG_CANFD3.unRXF1S.stcField.u2DMS)  /*@bf@*/

typedef struct stc_cpg_canfdn_rxf1s_field{
    uint_io32_t		u7F1FL:7;
    uint_io32_t		:1;
    uint_io32_t		u6F1GI:6;
    uint_io32_t		:2;
    uint_io32_t		u6F1PI:6;
    uint_io32_t		:2;
    uint_io32_t		u1F1F:1;
    uint_io32_t		u1RF1L:1;
    uint_io32_t		:4;
    uint_io32_t		u2DMS:2;
}stc_cpg_canfdn_rxf1s_field_t;

typedef union un_cpg_canfdn_rxf1s{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_rxf1s_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_rxf1s_t;

/* RXF1A */
#define CPG_CANFD0_RXF1A	(CPG_CANFD0.unRXF1A.u32Register)  /*@rg@*/
#define CPG_CANFD0_RXF1A_F1AI	(CPG_CANFD0.unRXF1A.stcField.u6F1AI)  /*@bf@*/

#define CPG_CANFD1_RXF1A	(CPG_CANFD1.unRXF1A.u32Register)  /*@rg@*/
#define CPG_CANFD1_RXF1A_F1AI	(CPG_CANFD1.unRXF1A.stcField.u6F1AI)  /*@bf@*/

#define CPG_CANFD2_RXF1A	(CPG_CANFD2.unRXF1A.u32Register)  /*@rg@*/
#define CPG_CANFD2_RXF1A_F1AI	(CPG_CANFD2.unRXF1A.stcField.u6F1AI)  /*@bf@*/

#define CPG_CANFD3_RXF1A	(CPG_CANFD3.unRXF1A.u32Register)  /*@rg@*/
#define CPG_CANFD3_RXF1A_F1AI	(CPG_CANFD3.unRXF1A.stcField.u6F1AI)  /*@bf@*/

typedef struct stc_cpg_canfdn_rxf1a_field{
    uint_io32_t		u6F1AI:6;
    uint_io32_t		:26;
}stc_cpg_canfdn_rxf1a_field_t;

typedef union un_cpg_canfdn_rxf1a{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_rxf1a_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_rxf1a_t;

/* RXESC */
#define CPG_CANFD0_RXESC	(CPG_CANFD0.unRXESC.u32Register)  /*@rg@*/
#define CPG_CANFD0_RXESC_F0DS	(CPG_CANFD0.unRXESC.stcField.u3F0DS)  /*@bf@*/
#define CPG_CANFD0_RXESC_F1DS	(CPG_CANFD0.unRXESC.stcField.u3F1DS)  /*@bf@*/
#define CPG_CANFD0_RXESC_RBDS	(CPG_CANFD0.unRXESC.stcField.u3RBDS)  /*@bf@*/

#define CPG_CANFD1_RXESC	(CPG_CANFD1.unRXESC.u32Register)  /*@rg@*/
#define CPG_CANFD1_RXESC_F0DS	(CPG_CANFD1.unRXESC.stcField.u3F0DS)  /*@bf@*/
#define CPG_CANFD1_RXESC_F1DS	(CPG_CANFD1.unRXESC.stcField.u3F1DS)  /*@bf@*/
#define CPG_CANFD1_RXESC_RBDS	(CPG_CANFD1.unRXESC.stcField.u3RBDS)  /*@bf@*/

#define CPG_CANFD2_RXESC	(CPG_CANFD2.unRXESC.u32Register)  /*@rg@*/
#define CPG_CANFD2_RXESC_F0DS	(CPG_CANFD2.unRXESC.stcField.u3F0DS)  /*@bf@*/
#define CPG_CANFD2_RXESC_F1DS	(CPG_CANFD2.unRXESC.stcField.u3F1DS)  /*@bf@*/
#define CPG_CANFD2_RXESC_RBDS	(CPG_CANFD2.unRXESC.stcField.u3RBDS)  /*@bf@*/

#define CPG_CANFD3_RXESC	(CPG_CANFD3.unRXESC.u32Register)  /*@rg@*/
#define CPG_CANFD3_RXESC_F0DS	(CPG_CANFD3.unRXESC.stcField.u3F0DS)  /*@bf@*/
#define CPG_CANFD3_RXESC_F1DS	(CPG_CANFD3.unRXESC.stcField.u3F1DS)  /*@bf@*/
#define CPG_CANFD3_RXESC_RBDS	(CPG_CANFD3.unRXESC.stcField.u3RBDS)  /*@bf@*/

typedef struct stc_cpg_canfdn_rxesc_field{
    uint_io32_t		u3F0DS:3;
    uint_io32_t		:1;
    uint_io32_t		u3F1DS:3;
    uint_io32_t		:1;
    uint_io32_t		u3RBDS:3;
    uint_io32_t		:21;
}stc_cpg_canfdn_rxesc_field_t;

typedef union un_cpg_canfdn_rxesc{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_rxesc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_rxesc_t;

/* TXBC */
#define CPG_CANFD0_TXBC	(CPG_CANFD0.unTXBC.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXBC_TBSA	(CPG_CANFD0.unTXBC.stcField.u14TBSA)  /*@bf@*/
#define CPG_CANFD0_TXBC_NDTB	(CPG_CANFD0.unTXBC.stcField.u6NDTB)  /*@bf@*/
#define CPG_CANFD0_TXBC_TFQS	(CPG_CANFD0.unTXBC.stcField.u6TFQS)  /*@bf@*/
#define CPG_CANFD0_TXBC_TFQM	(CPG_CANFD0.unTXBC.stcField.u1TFQM)  /*@bf@*/

#define CPG_CANFD1_TXBC	(CPG_CANFD1.unTXBC.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXBC_TBSA	(CPG_CANFD1.unTXBC.stcField.u14TBSA)  /*@bf@*/
#define CPG_CANFD1_TXBC_NDTB	(CPG_CANFD1.unTXBC.stcField.u6NDTB)  /*@bf@*/
#define CPG_CANFD1_TXBC_TFQS	(CPG_CANFD1.unTXBC.stcField.u6TFQS)  /*@bf@*/
#define CPG_CANFD1_TXBC_TFQM	(CPG_CANFD1.unTXBC.stcField.u1TFQM)  /*@bf@*/

#define CPG_CANFD2_TXBC	(CPG_CANFD2.unTXBC.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXBC_TBSA	(CPG_CANFD2.unTXBC.stcField.u14TBSA)  /*@bf@*/
#define CPG_CANFD2_TXBC_NDTB	(CPG_CANFD2.unTXBC.stcField.u6NDTB)  /*@bf@*/
#define CPG_CANFD2_TXBC_TFQS	(CPG_CANFD2.unTXBC.stcField.u6TFQS)  /*@bf@*/
#define CPG_CANFD2_TXBC_TFQM	(CPG_CANFD2.unTXBC.stcField.u1TFQM)  /*@bf@*/

#define CPG_CANFD3_TXBC	(CPG_CANFD3.unTXBC.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXBC_TBSA	(CPG_CANFD3.unTXBC.stcField.u14TBSA)  /*@bf@*/
#define CPG_CANFD3_TXBC_NDTB	(CPG_CANFD3.unTXBC.stcField.u6NDTB)  /*@bf@*/
#define CPG_CANFD3_TXBC_TFQS	(CPG_CANFD3.unTXBC.stcField.u6TFQS)  /*@bf@*/
#define CPG_CANFD3_TXBC_TFQM	(CPG_CANFD3.unTXBC.stcField.u1TFQM)  /*@bf@*/

typedef struct stc_cpg_canfdn_txbc_field{
    uint_io32_t		:2;
    uint_io32_t		u14TBSA:14;
    uint_io32_t		u6NDTB:6;
    uint_io32_t		:2;
    uint_io32_t		u6TFQS:6;
    uint_io32_t		u1TFQM:1;
    uint_io32_t		:1;
}stc_cpg_canfdn_txbc_field_t;

typedef union un_cpg_canfdn_txbc{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txbc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txbc_t;

/* TXFQS */
#define CPG_CANFD0_TXFQS	(CPG_CANFD0.unTXFQS.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXFQS_TFFL	(CPG_CANFD0.unTXFQS.stcField.u6TFFL)  /*@bf@*/
#define CPG_CANFD0_TXFQS_TFGI	(CPG_CANFD0.unTXFQS.stcField.u5TFGI)  /*@bf@*/
#define CPG_CANFD0_TXFQS_TFQPI	(CPG_CANFD0.unTXFQS.stcField.u5TFQPI)  /*@bf@*/
#define CPG_CANFD0_TXFQS_TFQF	(CPG_CANFD0.unTXFQS.stcField.u1TFQF)  /*@bf@*/

#define CPG_CANFD1_TXFQS	(CPG_CANFD1.unTXFQS.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXFQS_TFFL	(CPG_CANFD1.unTXFQS.stcField.u6TFFL)  /*@bf@*/
#define CPG_CANFD1_TXFQS_TFGI	(CPG_CANFD1.unTXFQS.stcField.u5TFGI)  /*@bf@*/
#define CPG_CANFD1_TXFQS_TFQPI	(CPG_CANFD1.unTXFQS.stcField.u5TFQPI)  /*@bf@*/
#define CPG_CANFD1_TXFQS_TFQF	(CPG_CANFD1.unTXFQS.stcField.u1TFQF)  /*@bf@*/

#define CPG_CANFD2_TXFQS	(CPG_CANFD2.unTXFQS.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXFQS_TFFL	(CPG_CANFD2.unTXFQS.stcField.u6TFFL)  /*@bf@*/
#define CPG_CANFD2_TXFQS_TFGI	(CPG_CANFD2.unTXFQS.stcField.u5TFGI)  /*@bf@*/
#define CPG_CANFD2_TXFQS_TFQPI	(CPG_CANFD2.unTXFQS.stcField.u5TFQPI)  /*@bf@*/
#define CPG_CANFD2_TXFQS_TFQF	(CPG_CANFD2.unTXFQS.stcField.u1TFQF)  /*@bf@*/

#define CPG_CANFD3_TXFQS	(CPG_CANFD3.unTXFQS.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXFQS_TFFL	(CPG_CANFD3.unTXFQS.stcField.u6TFFL)  /*@bf@*/
#define CPG_CANFD3_TXFQS_TFGI	(CPG_CANFD3.unTXFQS.stcField.u5TFGI)  /*@bf@*/
#define CPG_CANFD3_TXFQS_TFQPI	(CPG_CANFD3.unTXFQS.stcField.u5TFQPI)  /*@bf@*/
#define CPG_CANFD3_TXFQS_TFQF	(CPG_CANFD3.unTXFQS.stcField.u1TFQF)  /*@bf@*/

typedef struct stc_cpg_canfdn_txfqs_field{
    uint_io32_t		u6TFFL:6;
    uint_io32_t		:2;
    uint_io32_t		u5TFGI:5;
    uint_io32_t		:3;
    uint_io32_t		u5TFQPI:5;
    uint_io32_t		u1TFQF:1;
    uint_io32_t		:10;
}stc_cpg_canfdn_txfqs_field_t;

typedef union un_cpg_canfdn_txfqs{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txfqs_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txfqs_t;

/* TXESC */
#define CPG_CANFD0_TXESC	(CPG_CANFD0.unTXESC.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXESC_TBDS	(CPG_CANFD0.unTXESC.stcField.u3TBDS)  /*@bf@*/

#define CPG_CANFD1_TXESC	(CPG_CANFD1.unTXESC.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXESC_TBDS	(CPG_CANFD1.unTXESC.stcField.u3TBDS)  /*@bf@*/

#define CPG_CANFD2_TXESC	(CPG_CANFD2.unTXESC.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXESC_TBDS	(CPG_CANFD2.unTXESC.stcField.u3TBDS)  /*@bf@*/

#define CPG_CANFD3_TXESC	(CPG_CANFD3.unTXESC.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXESC_TBDS	(CPG_CANFD3.unTXESC.stcField.u3TBDS)  /*@bf@*/

typedef struct stc_cpg_canfdn_txesc_field{
    uint_io32_t		u3TBDS:3;
    uint_io32_t		:29;
}stc_cpg_canfdn_txesc_field_t;

typedef union un_cpg_canfdn_txesc{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txesc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txesc_t;

/* TXBRP */
#define CPG_CANFD0_TXBRP	(CPG_CANFD0.unTXBRP.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXBRP_TRP0	(CPG_CANFD0.unTXBRP.stcField.u1TRP0)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP1	(CPG_CANFD0.unTXBRP.stcField.u1TRP1)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP2	(CPG_CANFD0.unTXBRP.stcField.u1TRP2)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP3	(CPG_CANFD0.unTXBRP.stcField.u1TRP3)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP4	(CPG_CANFD0.unTXBRP.stcField.u1TRP4)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP5	(CPG_CANFD0.unTXBRP.stcField.u1TRP5)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP6	(CPG_CANFD0.unTXBRP.stcField.u1TRP6)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP7	(CPG_CANFD0.unTXBRP.stcField.u1TRP7)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP8	(CPG_CANFD0.unTXBRP.stcField.u1TRP8)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP9	(CPG_CANFD0.unTXBRP.stcField.u1TRP9)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP10	(CPG_CANFD0.unTXBRP.stcField.u1TRP10)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP11	(CPG_CANFD0.unTXBRP.stcField.u1TRP11)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP12	(CPG_CANFD0.unTXBRP.stcField.u1TRP12)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP13	(CPG_CANFD0.unTXBRP.stcField.u1TRP13)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP14	(CPG_CANFD0.unTXBRP.stcField.u1TRP14)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP15	(CPG_CANFD0.unTXBRP.stcField.u1TRP15)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP16	(CPG_CANFD0.unTXBRP.stcField.u1TRP16)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP17	(CPG_CANFD0.unTXBRP.stcField.u1TRP17)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP18	(CPG_CANFD0.unTXBRP.stcField.u1TRP18)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP19	(CPG_CANFD0.unTXBRP.stcField.u1TRP19)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP20	(CPG_CANFD0.unTXBRP.stcField.u1TRP20)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP21	(CPG_CANFD0.unTXBRP.stcField.u1TRP21)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP22	(CPG_CANFD0.unTXBRP.stcField.u1TRP22)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP23	(CPG_CANFD0.unTXBRP.stcField.u1TRP23)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP24	(CPG_CANFD0.unTXBRP.stcField.u1TRP24)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP25	(CPG_CANFD0.unTXBRP.stcField.u1TRP25)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP26	(CPG_CANFD0.unTXBRP.stcField.u1TRP26)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP27	(CPG_CANFD0.unTXBRP.stcField.u1TRP27)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP28	(CPG_CANFD0.unTXBRP.stcField.u1TRP28)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP29	(CPG_CANFD0.unTXBRP.stcField.u1TRP29)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP30	(CPG_CANFD0.unTXBRP.stcField.u1TRP30)  /*@bf@*/
#define CPG_CANFD0_TXBRP_TRP31	(CPG_CANFD0.unTXBRP.stcField.u1TRP31)  /*@bf@*/

#define CPG_CANFD1_TXBRP	(CPG_CANFD1.unTXBRP.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXBRP_TRP0	(CPG_CANFD1.unTXBRP.stcField.u1TRP0)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP1	(CPG_CANFD1.unTXBRP.stcField.u1TRP1)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP2	(CPG_CANFD1.unTXBRP.stcField.u1TRP2)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP3	(CPG_CANFD1.unTXBRP.stcField.u1TRP3)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP4	(CPG_CANFD1.unTXBRP.stcField.u1TRP4)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP5	(CPG_CANFD1.unTXBRP.stcField.u1TRP5)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP6	(CPG_CANFD1.unTXBRP.stcField.u1TRP6)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP7	(CPG_CANFD1.unTXBRP.stcField.u1TRP7)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP8	(CPG_CANFD1.unTXBRP.stcField.u1TRP8)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP9	(CPG_CANFD1.unTXBRP.stcField.u1TRP9)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP10	(CPG_CANFD1.unTXBRP.stcField.u1TRP10)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP11	(CPG_CANFD1.unTXBRP.stcField.u1TRP11)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP12	(CPG_CANFD1.unTXBRP.stcField.u1TRP12)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP13	(CPG_CANFD1.unTXBRP.stcField.u1TRP13)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP14	(CPG_CANFD1.unTXBRP.stcField.u1TRP14)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP15	(CPG_CANFD1.unTXBRP.stcField.u1TRP15)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP16	(CPG_CANFD1.unTXBRP.stcField.u1TRP16)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP17	(CPG_CANFD1.unTXBRP.stcField.u1TRP17)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP18	(CPG_CANFD1.unTXBRP.stcField.u1TRP18)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP19	(CPG_CANFD1.unTXBRP.stcField.u1TRP19)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP20	(CPG_CANFD1.unTXBRP.stcField.u1TRP20)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP21	(CPG_CANFD1.unTXBRP.stcField.u1TRP21)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP22	(CPG_CANFD1.unTXBRP.stcField.u1TRP22)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP23	(CPG_CANFD1.unTXBRP.stcField.u1TRP23)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP24	(CPG_CANFD1.unTXBRP.stcField.u1TRP24)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP25	(CPG_CANFD1.unTXBRP.stcField.u1TRP25)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP26	(CPG_CANFD1.unTXBRP.stcField.u1TRP26)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP27	(CPG_CANFD1.unTXBRP.stcField.u1TRP27)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP28	(CPG_CANFD1.unTXBRP.stcField.u1TRP28)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP29	(CPG_CANFD1.unTXBRP.stcField.u1TRP29)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP30	(CPG_CANFD1.unTXBRP.stcField.u1TRP30)  /*@bf@*/
#define CPG_CANFD1_TXBRP_TRP31	(CPG_CANFD1.unTXBRP.stcField.u1TRP31)  /*@bf@*/

#define CPG_CANFD2_TXBRP	(CPG_CANFD2.unTXBRP.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXBRP_TRP0	(CPG_CANFD2.unTXBRP.stcField.u1TRP0)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP1	(CPG_CANFD2.unTXBRP.stcField.u1TRP1)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP2	(CPG_CANFD2.unTXBRP.stcField.u1TRP2)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP3	(CPG_CANFD2.unTXBRP.stcField.u1TRP3)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP4	(CPG_CANFD2.unTXBRP.stcField.u1TRP4)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP5	(CPG_CANFD2.unTXBRP.stcField.u1TRP5)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP6	(CPG_CANFD2.unTXBRP.stcField.u1TRP6)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP7	(CPG_CANFD2.unTXBRP.stcField.u1TRP7)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP8	(CPG_CANFD2.unTXBRP.stcField.u1TRP8)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP9	(CPG_CANFD2.unTXBRP.stcField.u1TRP9)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP10	(CPG_CANFD2.unTXBRP.stcField.u1TRP10)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP11	(CPG_CANFD2.unTXBRP.stcField.u1TRP11)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP12	(CPG_CANFD2.unTXBRP.stcField.u1TRP12)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP13	(CPG_CANFD2.unTXBRP.stcField.u1TRP13)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP14	(CPG_CANFD2.unTXBRP.stcField.u1TRP14)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP15	(CPG_CANFD2.unTXBRP.stcField.u1TRP15)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP16	(CPG_CANFD2.unTXBRP.stcField.u1TRP16)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP17	(CPG_CANFD2.unTXBRP.stcField.u1TRP17)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP18	(CPG_CANFD2.unTXBRP.stcField.u1TRP18)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP19	(CPG_CANFD2.unTXBRP.stcField.u1TRP19)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP20	(CPG_CANFD2.unTXBRP.stcField.u1TRP20)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP21	(CPG_CANFD2.unTXBRP.stcField.u1TRP21)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP22	(CPG_CANFD2.unTXBRP.stcField.u1TRP22)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP23	(CPG_CANFD2.unTXBRP.stcField.u1TRP23)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP24	(CPG_CANFD2.unTXBRP.stcField.u1TRP24)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP25	(CPG_CANFD2.unTXBRP.stcField.u1TRP25)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP26	(CPG_CANFD2.unTXBRP.stcField.u1TRP26)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP27	(CPG_CANFD2.unTXBRP.stcField.u1TRP27)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP28	(CPG_CANFD2.unTXBRP.stcField.u1TRP28)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP29	(CPG_CANFD2.unTXBRP.stcField.u1TRP29)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP30	(CPG_CANFD2.unTXBRP.stcField.u1TRP30)  /*@bf@*/
#define CPG_CANFD2_TXBRP_TRP31	(CPG_CANFD2.unTXBRP.stcField.u1TRP31)  /*@bf@*/

#define CPG_CANFD3_TXBRP	(CPG_CANFD3.unTXBRP.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXBRP_TRP0	(CPG_CANFD3.unTXBRP.stcField.u1TRP0)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP1	(CPG_CANFD3.unTXBRP.stcField.u1TRP1)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP2	(CPG_CANFD3.unTXBRP.stcField.u1TRP2)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP3	(CPG_CANFD3.unTXBRP.stcField.u1TRP3)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP4	(CPG_CANFD3.unTXBRP.stcField.u1TRP4)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP5	(CPG_CANFD3.unTXBRP.stcField.u1TRP5)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP6	(CPG_CANFD3.unTXBRP.stcField.u1TRP6)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP7	(CPG_CANFD3.unTXBRP.stcField.u1TRP7)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP8	(CPG_CANFD3.unTXBRP.stcField.u1TRP8)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP9	(CPG_CANFD3.unTXBRP.stcField.u1TRP9)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP10	(CPG_CANFD3.unTXBRP.stcField.u1TRP10)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP11	(CPG_CANFD3.unTXBRP.stcField.u1TRP11)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP12	(CPG_CANFD3.unTXBRP.stcField.u1TRP12)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP13	(CPG_CANFD3.unTXBRP.stcField.u1TRP13)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP14	(CPG_CANFD3.unTXBRP.stcField.u1TRP14)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP15	(CPG_CANFD3.unTXBRP.stcField.u1TRP15)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP16	(CPG_CANFD3.unTXBRP.stcField.u1TRP16)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP17	(CPG_CANFD3.unTXBRP.stcField.u1TRP17)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP18	(CPG_CANFD3.unTXBRP.stcField.u1TRP18)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP19	(CPG_CANFD3.unTXBRP.stcField.u1TRP19)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP20	(CPG_CANFD3.unTXBRP.stcField.u1TRP20)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP21	(CPG_CANFD3.unTXBRP.stcField.u1TRP21)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP22	(CPG_CANFD3.unTXBRP.stcField.u1TRP22)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP23	(CPG_CANFD3.unTXBRP.stcField.u1TRP23)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP24	(CPG_CANFD3.unTXBRP.stcField.u1TRP24)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP25	(CPG_CANFD3.unTXBRP.stcField.u1TRP25)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP26	(CPG_CANFD3.unTXBRP.stcField.u1TRP26)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP27	(CPG_CANFD3.unTXBRP.stcField.u1TRP27)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP28	(CPG_CANFD3.unTXBRP.stcField.u1TRP28)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP29	(CPG_CANFD3.unTXBRP.stcField.u1TRP29)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP30	(CPG_CANFD3.unTXBRP.stcField.u1TRP30)  /*@bf@*/
#define CPG_CANFD3_TXBRP_TRP31	(CPG_CANFD3.unTXBRP.stcField.u1TRP31)  /*@bf@*/

typedef struct stc_cpg_canfdn_txbrp_field{
    uint_io32_t		u1TRP0:1;
    uint_io32_t		u1TRP1:1;
    uint_io32_t		u1TRP2:1;
    uint_io32_t		u1TRP3:1;
    uint_io32_t		u1TRP4:1;
    uint_io32_t		u1TRP5:1;
    uint_io32_t		u1TRP6:1;
    uint_io32_t		u1TRP7:1;
    uint_io32_t		u1TRP8:1;
    uint_io32_t		u1TRP9:1;
    uint_io32_t		u1TRP10:1;
    uint_io32_t		u1TRP11:1;
    uint_io32_t		u1TRP12:1;
    uint_io32_t		u1TRP13:1;
    uint_io32_t		u1TRP14:1;
    uint_io32_t		u1TRP15:1;
    uint_io32_t		u1TRP16:1;
    uint_io32_t		u1TRP17:1;
    uint_io32_t		u1TRP18:1;
    uint_io32_t		u1TRP19:1;
    uint_io32_t		u1TRP20:1;
    uint_io32_t		u1TRP21:1;
    uint_io32_t		u1TRP22:1;
    uint_io32_t		u1TRP23:1;
    uint_io32_t		u1TRP24:1;
    uint_io32_t		u1TRP25:1;
    uint_io32_t		u1TRP26:1;
    uint_io32_t		u1TRP27:1;
    uint_io32_t		u1TRP28:1;
    uint_io32_t		u1TRP29:1;
    uint_io32_t		u1TRP30:1;
    uint_io32_t		u1TRP31:1;
}stc_cpg_canfdn_txbrp_field_t;

typedef union un_cpg_canfdn_txbrp{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txbrp_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txbrp_t;

/* TXBAR */
#define CPG_CANFD0_TXBAR	(CPG_CANFD0.unTXBAR.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXBAR_AR0	(CPG_CANFD0.unTXBAR.stcField.u1AR0)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR1	(CPG_CANFD0.unTXBAR.stcField.u1AR1)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR2	(CPG_CANFD0.unTXBAR.stcField.u1AR2)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR3	(CPG_CANFD0.unTXBAR.stcField.u1AR3)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR4	(CPG_CANFD0.unTXBAR.stcField.u1AR4)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR5	(CPG_CANFD0.unTXBAR.stcField.u1AR5)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR6	(CPG_CANFD0.unTXBAR.stcField.u1AR6)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR7	(CPG_CANFD0.unTXBAR.stcField.u1AR7)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR8	(CPG_CANFD0.unTXBAR.stcField.u1AR8)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR9	(CPG_CANFD0.unTXBAR.stcField.u1AR9)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR10	(CPG_CANFD0.unTXBAR.stcField.u1AR10)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR11	(CPG_CANFD0.unTXBAR.stcField.u1AR11)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR12	(CPG_CANFD0.unTXBAR.stcField.u1AR12)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR13	(CPG_CANFD0.unTXBAR.stcField.u1AR13)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR14	(CPG_CANFD0.unTXBAR.stcField.u1AR14)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR15	(CPG_CANFD0.unTXBAR.stcField.u1AR15)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR16	(CPG_CANFD0.unTXBAR.stcField.u1AR16)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR17	(CPG_CANFD0.unTXBAR.stcField.u1AR17)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR18	(CPG_CANFD0.unTXBAR.stcField.u1AR18)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR19	(CPG_CANFD0.unTXBAR.stcField.u1AR19)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR20	(CPG_CANFD0.unTXBAR.stcField.u1AR20)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR21	(CPG_CANFD0.unTXBAR.stcField.u1AR21)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR22	(CPG_CANFD0.unTXBAR.stcField.u1AR22)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR23	(CPG_CANFD0.unTXBAR.stcField.u1AR23)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR24	(CPG_CANFD0.unTXBAR.stcField.u1AR24)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR25	(CPG_CANFD0.unTXBAR.stcField.u1AR25)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR26	(CPG_CANFD0.unTXBAR.stcField.u1AR26)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR27	(CPG_CANFD0.unTXBAR.stcField.u1AR27)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR28	(CPG_CANFD0.unTXBAR.stcField.u1AR28)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR29	(CPG_CANFD0.unTXBAR.stcField.u1AR29)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR30	(CPG_CANFD0.unTXBAR.stcField.u1AR30)  /*@bf@*/
#define CPG_CANFD0_TXBAR_AR31	(CPG_CANFD0.unTXBAR.stcField.u1AR31)  /*@bf@*/

#define CPG_CANFD1_TXBAR	(CPG_CANFD1.unTXBAR.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXBAR_AR0	(CPG_CANFD1.unTXBAR.stcField.u1AR0)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR1	(CPG_CANFD1.unTXBAR.stcField.u1AR1)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR2	(CPG_CANFD1.unTXBAR.stcField.u1AR2)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR3	(CPG_CANFD1.unTXBAR.stcField.u1AR3)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR4	(CPG_CANFD1.unTXBAR.stcField.u1AR4)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR5	(CPG_CANFD1.unTXBAR.stcField.u1AR5)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR6	(CPG_CANFD1.unTXBAR.stcField.u1AR6)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR7	(CPG_CANFD1.unTXBAR.stcField.u1AR7)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR8	(CPG_CANFD1.unTXBAR.stcField.u1AR8)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR9	(CPG_CANFD1.unTXBAR.stcField.u1AR9)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR10	(CPG_CANFD1.unTXBAR.stcField.u1AR10)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR11	(CPG_CANFD1.unTXBAR.stcField.u1AR11)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR12	(CPG_CANFD1.unTXBAR.stcField.u1AR12)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR13	(CPG_CANFD1.unTXBAR.stcField.u1AR13)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR14	(CPG_CANFD1.unTXBAR.stcField.u1AR14)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR15	(CPG_CANFD1.unTXBAR.stcField.u1AR15)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR16	(CPG_CANFD1.unTXBAR.stcField.u1AR16)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR17	(CPG_CANFD1.unTXBAR.stcField.u1AR17)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR18	(CPG_CANFD1.unTXBAR.stcField.u1AR18)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR19	(CPG_CANFD1.unTXBAR.stcField.u1AR19)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR20	(CPG_CANFD1.unTXBAR.stcField.u1AR20)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR21	(CPG_CANFD1.unTXBAR.stcField.u1AR21)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR22	(CPG_CANFD1.unTXBAR.stcField.u1AR22)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR23	(CPG_CANFD1.unTXBAR.stcField.u1AR23)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR24	(CPG_CANFD1.unTXBAR.stcField.u1AR24)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR25	(CPG_CANFD1.unTXBAR.stcField.u1AR25)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR26	(CPG_CANFD1.unTXBAR.stcField.u1AR26)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR27	(CPG_CANFD1.unTXBAR.stcField.u1AR27)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR28	(CPG_CANFD1.unTXBAR.stcField.u1AR28)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR29	(CPG_CANFD1.unTXBAR.stcField.u1AR29)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR30	(CPG_CANFD1.unTXBAR.stcField.u1AR30)  /*@bf@*/
#define CPG_CANFD1_TXBAR_AR31	(CPG_CANFD1.unTXBAR.stcField.u1AR31)  /*@bf@*/

#define CPG_CANFD2_TXBAR	(CPG_CANFD2.unTXBAR.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXBAR_AR0	(CPG_CANFD2.unTXBAR.stcField.u1AR0)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR1	(CPG_CANFD2.unTXBAR.stcField.u1AR1)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR2	(CPG_CANFD2.unTXBAR.stcField.u1AR2)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR3	(CPG_CANFD2.unTXBAR.stcField.u1AR3)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR4	(CPG_CANFD2.unTXBAR.stcField.u1AR4)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR5	(CPG_CANFD2.unTXBAR.stcField.u1AR5)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR6	(CPG_CANFD2.unTXBAR.stcField.u1AR6)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR7	(CPG_CANFD2.unTXBAR.stcField.u1AR7)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR8	(CPG_CANFD2.unTXBAR.stcField.u1AR8)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR9	(CPG_CANFD2.unTXBAR.stcField.u1AR9)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR10	(CPG_CANFD2.unTXBAR.stcField.u1AR10)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR11	(CPG_CANFD2.unTXBAR.stcField.u1AR11)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR12	(CPG_CANFD2.unTXBAR.stcField.u1AR12)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR13	(CPG_CANFD2.unTXBAR.stcField.u1AR13)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR14	(CPG_CANFD2.unTXBAR.stcField.u1AR14)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR15	(CPG_CANFD2.unTXBAR.stcField.u1AR15)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR16	(CPG_CANFD2.unTXBAR.stcField.u1AR16)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR17	(CPG_CANFD2.unTXBAR.stcField.u1AR17)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR18	(CPG_CANFD2.unTXBAR.stcField.u1AR18)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR19	(CPG_CANFD2.unTXBAR.stcField.u1AR19)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR20	(CPG_CANFD2.unTXBAR.stcField.u1AR20)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR21	(CPG_CANFD2.unTXBAR.stcField.u1AR21)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR22	(CPG_CANFD2.unTXBAR.stcField.u1AR22)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR23	(CPG_CANFD2.unTXBAR.stcField.u1AR23)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR24	(CPG_CANFD2.unTXBAR.stcField.u1AR24)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR25	(CPG_CANFD2.unTXBAR.stcField.u1AR25)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR26	(CPG_CANFD2.unTXBAR.stcField.u1AR26)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR27	(CPG_CANFD2.unTXBAR.stcField.u1AR27)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR28	(CPG_CANFD2.unTXBAR.stcField.u1AR28)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR29	(CPG_CANFD2.unTXBAR.stcField.u1AR29)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR30	(CPG_CANFD2.unTXBAR.stcField.u1AR30)  /*@bf@*/
#define CPG_CANFD2_TXBAR_AR31	(CPG_CANFD2.unTXBAR.stcField.u1AR31)  /*@bf@*/

#define CPG_CANFD3_TXBAR	(CPG_CANFD3.unTXBAR.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXBAR_AR0	(CPG_CANFD3.unTXBAR.stcField.u1AR0)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR1	(CPG_CANFD3.unTXBAR.stcField.u1AR1)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR2	(CPG_CANFD3.unTXBAR.stcField.u1AR2)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR3	(CPG_CANFD3.unTXBAR.stcField.u1AR3)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR4	(CPG_CANFD3.unTXBAR.stcField.u1AR4)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR5	(CPG_CANFD3.unTXBAR.stcField.u1AR5)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR6	(CPG_CANFD3.unTXBAR.stcField.u1AR6)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR7	(CPG_CANFD3.unTXBAR.stcField.u1AR7)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR8	(CPG_CANFD3.unTXBAR.stcField.u1AR8)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR9	(CPG_CANFD3.unTXBAR.stcField.u1AR9)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR10	(CPG_CANFD3.unTXBAR.stcField.u1AR10)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR11	(CPG_CANFD3.unTXBAR.stcField.u1AR11)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR12	(CPG_CANFD3.unTXBAR.stcField.u1AR12)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR13	(CPG_CANFD3.unTXBAR.stcField.u1AR13)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR14	(CPG_CANFD3.unTXBAR.stcField.u1AR14)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR15	(CPG_CANFD3.unTXBAR.stcField.u1AR15)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR16	(CPG_CANFD3.unTXBAR.stcField.u1AR16)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR17	(CPG_CANFD3.unTXBAR.stcField.u1AR17)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR18	(CPG_CANFD3.unTXBAR.stcField.u1AR18)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR19	(CPG_CANFD3.unTXBAR.stcField.u1AR19)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR20	(CPG_CANFD3.unTXBAR.stcField.u1AR20)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR21	(CPG_CANFD3.unTXBAR.stcField.u1AR21)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR22	(CPG_CANFD3.unTXBAR.stcField.u1AR22)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR23	(CPG_CANFD3.unTXBAR.stcField.u1AR23)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR24	(CPG_CANFD3.unTXBAR.stcField.u1AR24)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR25	(CPG_CANFD3.unTXBAR.stcField.u1AR25)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR26	(CPG_CANFD3.unTXBAR.stcField.u1AR26)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR27	(CPG_CANFD3.unTXBAR.stcField.u1AR27)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR28	(CPG_CANFD3.unTXBAR.stcField.u1AR28)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR29	(CPG_CANFD3.unTXBAR.stcField.u1AR29)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR30	(CPG_CANFD3.unTXBAR.stcField.u1AR30)  /*@bf@*/
#define CPG_CANFD3_TXBAR_AR31	(CPG_CANFD3.unTXBAR.stcField.u1AR31)  /*@bf@*/

typedef struct stc_cpg_canfdn_txbar_field{
    uint_io32_t		u1AR0:1;
    uint_io32_t		u1AR1:1;
    uint_io32_t		u1AR2:1;
    uint_io32_t		u1AR3:1;
    uint_io32_t		u1AR4:1;
    uint_io32_t		u1AR5:1;
    uint_io32_t		u1AR6:1;
    uint_io32_t		u1AR7:1;
    uint_io32_t		u1AR8:1;
    uint_io32_t		u1AR9:1;
    uint_io32_t		u1AR10:1;
    uint_io32_t		u1AR11:1;
    uint_io32_t		u1AR12:1;
    uint_io32_t		u1AR13:1;
    uint_io32_t		u1AR14:1;
    uint_io32_t		u1AR15:1;
    uint_io32_t		u1AR16:1;
    uint_io32_t		u1AR17:1;
    uint_io32_t		u1AR18:1;
    uint_io32_t		u1AR19:1;
    uint_io32_t		u1AR20:1;
    uint_io32_t		u1AR21:1;
    uint_io32_t		u1AR22:1;
    uint_io32_t		u1AR23:1;
    uint_io32_t		u1AR24:1;
    uint_io32_t		u1AR25:1;
    uint_io32_t		u1AR26:1;
    uint_io32_t		u1AR27:1;
    uint_io32_t		u1AR28:1;
    uint_io32_t		u1AR29:1;
    uint_io32_t		u1AR30:1;
    uint_io32_t		u1AR31:1;
}stc_cpg_canfdn_txbar_field_t;

typedef union un_cpg_canfdn_txbar{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txbar_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txbar_t;

/* TXBCR */
#define CPG_CANFD0_TXBCR	(CPG_CANFD0.unTXBCR.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXBCR_CR0	(CPG_CANFD0.unTXBCR.stcField.u1CR0)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR1	(CPG_CANFD0.unTXBCR.stcField.u1CR1)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR2	(CPG_CANFD0.unTXBCR.stcField.u1CR2)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR3	(CPG_CANFD0.unTXBCR.stcField.u1CR3)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR4	(CPG_CANFD0.unTXBCR.stcField.u1CR4)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR5	(CPG_CANFD0.unTXBCR.stcField.u1CR5)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR6	(CPG_CANFD0.unTXBCR.stcField.u1CR6)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR7	(CPG_CANFD0.unTXBCR.stcField.u1CR7)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR8	(CPG_CANFD0.unTXBCR.stcField.u1CR8)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR9	(CPG_CANFD0.unTXBCR.stcField.u1CR9)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR10	(CPG_CANFD0.unTXBCR.stcField.u1CR10)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR11	(CPG_CANFD0.unTXBCR.stcField.u1CR11)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR12	(CPG_CANFD0.unTXBCR.stcField.u1CR12)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR13	(CPG_CANFD0.unTXBCR.stcField.u1CR13)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR14	(CPG_CANFD0.unTXBCR.stcField.u1CR14)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR15	(CPG_CANFD0.unTXBCR.stcField.u1CR15)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR16	(CPG_CANFD0.unTXBCR.stcField.u1CR16)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR17	(CPG_CANFD0.unTXBCR.stcField.u1CR17)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR18	(CPG_CANFD0.unTXBCR.stcField.u1CR18)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR19	(CPG_CANFD0.unTXBCR.stcField.u1CR19)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR20	(CPG_CANFD0.unTXBCR.stcField.u1CR20)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR21	(CPG_CANFD0.unTXBCR.stcField.u1CR21)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR22	(CPG_CANFD0.unTXBCR.stcField.u1CR22)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR23	(CPG_CANFD0.unTXBCR.stcField.u1CR23)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR24	(CPG_CANFD0.unTXBCR.stcField.u1CR24)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR25	(CPG_CANFD0.unTXBCR.stcField.u1CR25)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR26	(CPG_CANFD0.unTXBCR.stcField.u1CR26)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR27	(CPG_CANFD0.unTXBCR.stcField.u1CR27)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR28	(CPG_CANFD0.unTXBCR.stcField.u1CR28)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR29	(CPG_CANFD0.unTXBCR.stcField.u1CR29)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR30	(CPG_CANFD0.unTXBCR.stcField.u1CR30)  /*@bf@*/
#define CPG_CANFD0_TXBCR_CR31	(CPG_CANFD0.unTXBCR.stcField.u1CR31)  /*@bf@*/

#define CPG_CANFD1_TXBCR	(CPG_CANFD1.unTXBCR.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXBCR_CR0	(CPG_CANFD1.unTXBCR.stcField.u1CR0)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR1	(CPG_CANFD1.unTXBCR.stcField.u1CR1)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR2	(CPG_CANFD1.unTXBCR.stcField.u1CR2)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR3	(CPG_CANFD1.unTXBCR.stcField.u1CR3)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR4	(CPG_CANFD1.unTXBCR.stcField.u1CR4)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR5	(CPG_CANFD1.unTXBCR.stcField.u1CR5)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR6	(CPG_CANFD1.unTXBCR.stcField.u1CR6)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR7	(CPG_CANFD1.unTXBCR.stcField.u1CR7)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR8	(CPG_CANFD1.unTXBCR.stcField.u1CR8)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR9	(CPG_CANFD1.unTXBCR.stcField.u1CR9)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR10	(CPG_CANFD1.unTXBCR.stcField.u1CR10)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR11	(CPG_CANFD1.unTXBCR.stcField.u1CR11)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR12	(CPG_CANFD1.unTXBCR.stcField.u1CR12)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR13	(CPG_CANFD1.unTXBCR.stcField.u1CR13)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR14	(CPG_CANFD1.unTXBCR.stcField.u1CR14)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR15	(CPG_CANFD1.unTXBCR.stcField.u1CR15)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR16	(CPG_CANFD1.unTXBCR.stcField.u1CR16)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR17	(CPG_CANFD1.unTXBCR.stcField.u1CR17)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR18	(CPG_CANFD1.unTXBCR.stcField.u1CR18)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR19	(CPG_CANFD1.unTXBCR.stcField.u1CR19)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR20	(CPG_CANFD1.unTXBCR.stcField.u1CR20)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR21	(CPG_CANFD1.unTXBCR.stcField.u1CR21)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR22	(CPG_CANFD1.unTXBCR.stcField.u1CR22)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR23	(CPG_CANFD1.unTXBCR.stcField.u1CR23)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR24	(CPG_CANFD1.unTXBCR.stcField.u1CR24)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR25	(CPG_CANFD1.unTXBCR.stcField.u1CR25)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR26	(CPG_CANFD1.unTXBCR.stcField.u1CR26)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR27	(CPG_CANFD1.unTXBCR.stcField.u1CR27)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR28	(CPG_CANFD1.unTXBCR.stcField.u1CR28)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR29	(CPG_CANFD1.unTXBCR.stcField.u1CR29)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR30	(CPG_CANFD1.unTXBCR.stcField.u1CR30)  /*@bf@*/
#define CPG_CANFD1_TXBCR_CR31	(CPG_CANFD1.unTXBCR.stcField.u1CR31)  /*@bf@*/

#define CPG_CANFD2_TXBCR	(CPG_CANFD2.unTXBCR.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXBCR_CR0	(CPG_CANFD2.unTXBCR.stcField.u1CR0)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR1	(CPG_CANFD2.unTXBCR.stcField.u1CR1)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR2	(CPG_CANFD2.unTXBCR.stcField.u1CR2)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR3	(CPG_CANFD2.unTXBCR.stcField.u1CR3)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR4	(CPG_CANFD2.unTXBCR.stcField.u1CR4)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR5	(CPG_CANFD2.unTXBCR.stcField.u1CR5)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR6	(CPG_CANFD2.unTXBCR.stcField.u1CR6)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR7	(CPG_CANFD2.unTXBCR.stcField.u1CR7)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR8	(CPG_CANFD2.unTXBCR.stcField.u1CR8)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR9	(CPG_CANFD2.unTXBCR.stcField.u1CR9)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR10	(CPG_CANFD2.unTXBCR.stcField.u1CR10)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR11	(CPG_CANFD2.unTXBCR.stcField.u1CR11)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR12	(CPG_CANFD2.unTXBCR.stcField.u1CR12)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR13	(CPG_CANFD2.unTXBCR.stcField.u1CR13)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR14	(CPG_CANFD2.unTXBCR.stcField.u1CR14)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR15	(CPG_CANFD2.unTXBCR.stcField.u1CR15)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR16	(CPG_CANFD2.unTXBCR.stcField.u1CR16)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR17	(CPG_CANFD2.unTXBCR.stcField.u1CR17)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR18	(CPG_CANFD2.unTXBCR.stcField.u1CR18)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR19	(CPG_CANFD2.unTXBCR.stcField.u1CR19)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR20	(CPG_CANFD2.unTXBCR.stcField.u1CR20)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR21	(CPG_CANFD2.unTXBCR.stcField.u1CR21)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR22	(CPG_CANFD2.unTXBCR.stcField.u1CR22)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR23	(CPG_CANFD2.unTXBCR.stcField.u1CR23)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR24	(CPG_CANFD2.unTXBCR.stcField.u1CR24)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR25	(CPG_CANFD2.unTXBCR.stcField.u1CR25)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR26	(CPG_CANFD2.unTXBCR.stcField.u1CR26)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR27	(CPG_CANFD2.unTXBCR.stcField.u1CR27)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR28	(CPG_CANFD2.unTXBCR.stcField.u1CR28)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR29	(CPG_CANFD2.unTXBCR.stcField.u1CR29)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR30	(CPG_CANFD2.unTXBCR.stcField.u1CR30)  /*@bf@*/
#define CPG_CANFD2_TXBCR_CR31	(CPG_CANFD2.unTXBCR.stcField.u1CR31)  /*@bf@*/

#define CPG_CANFD3_TXBCR	(CPG_CANFD3.unTXBCR.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXBCR_CR0	(CPG_CANFD3.unTXBCR.stcField.u1CR0)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR1	(CPG_CANFD3.unTXBCR.stcField.u1CR1)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR2	(CPG_CANFD3.unTXBCR.stcField.u1CR2)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR3	(CPG_CANFD3.unTXBCR.stcField.u1CR3)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR4	(CPG_CANFD3.unTXBCR.stcField.u1CR4)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR5	(CPG_CANFD3.unTXBCR.stcField.u1CR5)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR6	(CPG_CANFD3.unTXBCR.stcField.u1CR6)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR7	(CPG_CANFD3.unTXBCR.stcField.u1CR7)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR8	(CPG_CANFD3.unTXBCR.stcField.u1CR8)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR9	(CPG_CANFD3.unTXBCR.stcField.u1CR9)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR10	(CPG_CANFD3.unTXBCR.stcField.u1CR10)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR11	(CPG_CANFD3.unTXBCR.stcField.u1CR11)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR12	(CPG_CANFD3.unTXBCR.stcField.u1CR12)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR13	(CPG_CANFD3.unTXBCR.stcField.u1CR13)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR14	(CPG_CANFD3.unTXBCR.stcField.u1CR14)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR15	(CPG_CANFD3.unTXBCR.stcField.u1CR15)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR16	(CPG_CANFD3.unTXBCR.stcField.u1CR16)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR17	(CPG_CANFD3.unTXBCR.stcField.u1CR17)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR18	(CPG_CANFD3.unTXBCR.stcField.u1CR18)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR19	(CPG_CANFD3.unTXBCR.stcField.u1CR19)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR20	(CPG_CANFD3.unTXBCR.stcField.u1CR20)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR21	(CPG_CANFD3.unTXBCR.stcField.u1CR21)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR22	(CPG_CANFD3.unTXBCR.stcField.u1CR22)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR23	(CPG_CANFD3.unTXBCR.stcField.u1CR23)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR24	(CPG_CANFD3.unTXBCR.stcField.u1CR24)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR25	(CPG_CANFD3.unTXBCR.stcField.u1CR25)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR26	(CPG_CANFD3.unTXBCR.stcField.u1CR26)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR27	(CPG_CANFD3.unTXBCR.stcField.u1CR27)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR28	(CPG_CANFD3.unTXBCR.stcField.u1CR28)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR29	(CPG_CANFD3.unTXBCR.stcField.u1CR29)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR30	(CPG_CANFD3.unTXBCR.stcField.u1CR30)  /*@bf@*/
#define CPG_CANFD3_TXBCR_CR31	(CPG_CANFD3.unTXBCR.stcField.u1CR31)  /*@bf@*/

typedef struct stc_cpg_canfdn_txbcr_field{
    uint_io32_t		u1CR0:1;
    uint_io32_t		u1CR1:1;
    uint_io32_t		u1CR2:1;
    uint_io32_t		u1CR3:1;
    uint_io32_t		u1CR4:1;
    uint_io32_t		u1CR5:1;
    uint_io32_t		u1CR6:1;
    uint_io32_t		u1CR7:1;
    uint_io32_t		u1CR8:1;
    uint_io32_t		u1CR9:1;
    uint_io32_t		u1CR10:1;
    uint_io32_t		u1CR11:1;
    uint_io32_t		u1CR12:1;
    uint_io32_t		u1CR13:1;
    uint_io32_t		u1CR14:1;
    uint_io32_t		u1CR15:1;
    uint_io32_t		u1CR16:1;
    uint_io32_t		u1CR17:1;
    uint_io32_t		u1CR18:1;
    uint_io32_t		u1CR19:1;
    uint_io32_t		u1CR20:1;
    uint_io32_t		u1CR21:1;
    uint_io32_t		u1CR22:1;
    uint_io32_t		u1CR23:1;
    uint_io32_t		u1CR24:1;
    uint_io32_t		u1CR25:1;
    uint_io32_t		u1CR26:1;
    uint_io32_t		u1CR27:1;
    uint_io32_t		u1CR28:1;
    uint_io32_t		u1CR29:1;
    uint_io32_t		u1CR30:1;
    uint_io32_t		u1CR31:1;
}stc_cpg_canfdn_txbcr_field_t;

typedef union un_cpg_canfdn_txbcr{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txbcr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txbcr_t;

/* TXBTO */
#define CPG_CANFD0_TXBTO	(CPG_CANFD0.unTXBTO.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXBTO_TO0	(CPG_CANFD0.unTXBTO.stcField.u1TO0)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO1	(CPG_CANFD0.unTXBTO.stcField.u1TO1)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO2	(CPG_CANFD0.unTXBTO.stcField.u1TO2)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO3	(CPG_CANFD0.unTXBTO.stcField.u1TO3)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO4	(CPG_CANFD0.unTXBTO.stcField.u1TO4)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO5	(CPG_CANFD0.unTXBTO.stcField.u1TO5)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO6	(CPG_CANFD0.unTXBTO.stcField.u1TO6)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO7	(CPG_CANFD0.unTXBTO.stcField.u1TO7)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO8	(CPG_CANFD0.unTXBTO.stcField.u1TO8)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO9	(CPG_CANFD0.unTXBTO.stcField.u1TO9)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO10	(CPG_CANFD0.unTXBTO.stcField.u1TO10)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO11	(CPG_CANFD0.unTXBTO.stcField.u1TO11)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO12	(CPG_CANFD0.unTXBTO.stcField.u1TO12)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO13	(CPG_CANFD0.unTXBTO.stcField.u1TO13)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO14	(CPG_CANFD0.unTXBTO.stcField.u1TO14)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO15	(CPG_CANFD0.unTXBTO.stcField.u1TO15)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO16	(CPG_CANFD0.unTXBTO.stcField.u1TO16)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO17	(CPG_CANFD0.unTXBTO.stcField.u1TO17)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO18	(CPG_CANFD0.unTXBTO.stcField.u1TO18)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO19	(CPG_CANFD0.unTXBTO.stcField.u1TO19)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO20	(CPG_CANFD0.unTXBTO.stcField.u1TO20)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO21	(CPG_CANFD0.unTXBTO.stcField.u1TO21)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO22	(CPG_CANFD0.unTXBTO.stcField.u1TO22)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO23	(CPG_CANFD0.unTXBTO.stcField.u1TO23)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO24	(CPG_CANFD0.unTXBTO.stcField.u1TO24)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO25	(CPG_CANFD0.unTXBTO.stcField.u1TO25)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO26	(CPG_CANFD0.unTXBTO.stcField.u1TO26)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO27	(CPG_CANFD0.unTXBTO.stcField.u1TO27)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO28	(CPG_CANFD0.unTXBTO.stcField.u1TO28)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO29	(CPG_CANFD0.unTXBTO.stcField.u1TO29)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO30	(CPG_CANFD0.unTXBTO.stcField.u1TO30)  /*@bf@*/
#define CPG_CANFD0_TXBTO_TO31	(CPG_CANFD0.unTXBTO.stcField.u1TO31)  /*@bf@*/

#define CPG_CANFD1_TXBTO	(CPG_CANFD1.unTXBTO.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXBTO_TO0	(CPG_CANFD1.unTXBTO.stcField.u1TO0)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO1	(CPG_CANFD1.unTXBTO.stcField.u1TO1)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO2	(CPG_CANFD1.unTXBTO.stcField.u1TO2)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO3	(CPG_CANFD1.unTXBTO.stcField.u1TO3)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO4	(CPG_CANFD1.unTXBTO.stcField.u1TO4)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO5	(CPG_CANFD1.unTXBTO.stcField.u1TO5)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO6	(CPG_CANFD1.unTXBTO.stcField.u1TO6)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO7	(CPG_CANFD1.unTXBTO.stcField.u1TO7)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO8	(CPG_CANFD1.unTXBTO.stcField.u1TO8)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO9	(CPG_CANFD1.unTXBTO.stcField.u1TO9)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO10	(CPG_CANFD1.unTXBTO.stcField.u1TO10)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO11	(CPG_CANFD1.unTXBTO.stcField.u1TO11)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO12	(CPG_CANFD1.unTXBTO.stcField.u1TO12)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO13	(CPG_CANFD1.unTXBTO.stcField.u1TO13)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO14	(CPG_CANFD1.unTXBTO.stcField.u1TO14)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO15	(CPG_CANFD1.unTXBTO.stcField.u1TO15)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO16	(CPG_CANFD1.unTXBTO.stcField.u1TO16)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO17	(CPG_CANFD1.unTXBTO.stcField.u1TO17)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO18	(CPG_CANFD1.unTXBTO.stcField.u1TO18)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO19	(CPG_CANFD1.unTXBTO.stcField.u1TO19)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO20	(CPG_CANFD1.unTXBTO.stcField.u1TO20)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO21	(CPG_CANFD1.unTXBTO.stcField.u1TO21)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO22	(CPG_CANFD1.unTXBTO.stcField.u1TO22)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO23	(CPG_CANFD1.unTXBTO.stcField.u1TO23)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO24	(CPG_CANFD1.unTXBTO.stcField.u1TO24)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO25	(CPG_CANFD1.unTXBTO.stcField.u1TO25)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO26	(CPG_CANFD1.unTXBTO.stcField.u1TO26)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO27	(CPG_CANFD1.unTXBTO.stcField.u1TO27)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO28	(CPG_CANFD1.unTXBTO.stcField.u1TO28)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO29	(CPG_CANFD1.unTXBTO.stcField.u1TO29)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO30	(CPG_CANFD1.unTXBTO.stcField.u1TO30)  /*@bf@*/
#define CPG_CANFD1_TXBTO_TO31	(CPG_CANFD1.unTXBTO.stcField.u1TO31)  /*@bf@*/

#define CPG_CANFD2_TXBTO	(CPG_CANFD2.unTXBTO.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXBTO_TO0	(CPG_CANFD2.unTXBTO.stcField.u1TO0)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO1	(CPG_CANFD2.unTXBTO.stcField.u1TO1)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO2	(CPG_CANFD2.unTXBTO.stcField.u1TO2)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO3	(CPG_CANFD2.unTXBTO.stcField.u1TO3)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO4	(CPG_CANFD2.unTXBTO.stcField.u1TO4)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO5	(CPG_CANFD2.unTXBTO.stcField.u1TO5)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO6	(CPG_CANFD2.unTXBTO.stcField.u1TO6)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO7	(CPG_CANFD2.unTXBTO.stcField.u1TO7)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO8	(CPG_CANFD2.unTXBTO.stcField.u1TO8)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO9	(CPG_CANFD2.unTXBTO.stcField.u1TO9)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO10	(CPG_CANFD2.unTXBTO.stcField.u1TO10)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO11	(CPG_CANFD2.unTXBTO.stcField.u1TO11)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO12	(CPG_CANFD2.unTXBTO.stcField.u1TO12)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO13	(CPG_CANFD2.unTXBTO.stcField.u1TO13)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO14	(CPG_CANFD2.unTXBTO.stcField.u1TO14)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO15	(CPG_CANFD2.unTXBTO.stcField.u1TO15)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO16	(CPG_CANFD2.unTXBTO.stcField.u1TO16)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO17	(CPG_CANFD2.unTXBTO.stcField.u1TO17)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO18	(CPG_CANFD2.unTXBTO.stcField.u1TO18)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO19	(CPG_CANFD2.unTXBTO.stcField.u1TO19)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO20	(CPG_CANFD2.unTXBTO.stcField.u1TO20)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO21	(CPG_CANFD2.unTXBTO.stcField.u1TO21)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO22	(CPG_CANFD2.unTXBTO.stcField.u1TO22)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO23	(CPG_CANFD2.unTXBTO.stcField.u1TO23)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO24	(CPG_CANFD2.unTXBTO.stcField.u1TO24)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO25	(CPG_CANFD2.unTXBTO.stcField.u1TO25)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO26	(CPG_CANFD2.unTXBTO.stcField.u1TO26)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO27	(CPG_CANFD2.unTXBTO.stcField.u1TO27)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO28	(CPG_CANFD2.unTXBTO.stcField.u1TO28)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO29	(CPG_CANFD2.unTXBTO.stcField.u1TO29)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO30	(CPG_CANFD2.unTXBTO.stcField.u1TO30)  /*@bf@*/
#define CPG_CANFD2_TXBTO_TO31	(CPG_CANFD2.unTXBTO.stcField.u1TO31)  /*@bf@*/

#define CPG_CANFD3_TXBTO	(CPG_CANFD3.unTXBTO.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXBTO_TO0	(CPG_CANFD3.unTXBTO.stcField.u1TO0)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO1	(CPG_CANFD3.unTXBTO.stcField.u1TO1)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO2	(CPG_CANFD3.unTXBTO.stcField.u1TO2)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO3	(CPG_CANFD3.unTXBTO.stcField.u1TO3)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO4	(CPG_CANFD3.unTXBTO.stcField.u1TO4)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO5	(CPG_CANFD3.unTXBTO.stcField.u1TO5)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO6	(CPG_CANFD3.unTXBTO.stcField.u1TO6)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO7	(CPG_CANFD3.unTXBTO.stcField.u1TO7)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO8	(CPG_CANFD3.unTXBTO.stcField.u1TO8)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO9	(CPG_CANFD3.unTXBTO.stcField.u1TO9)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO10	(CPG_CANFD3.unTXBTO.stcField.u1TO10)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO11	(CPG_CANFD3.unTXBTO.stcField.u1TO11)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO12	(CPG_CANFD3.unTXBTO.stcField.u1TO12)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO13	(CPG_CANFD3.unTXBTO.stcField.u1TO13)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO14	(CPG_CANFD3.unTXBTO.stcField.u1TO14)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO15	(CPG_CANFD3.unTXBTO.stcField.u1TO15)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO16	(CPG_CANFD3.unTXBTO.stcField.u1TO16)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO17	(CPG_CANFD3.unTXBTO.stcField.u1TO17)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO18	(CPG_CANFD3.unTXBTO.stcField.u1TO18)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO19	(CPG_CANFD3.unTXBTO.stcField.u1TO19)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO20	(CPG_CANFD3.unTXBTO.stcField.u1TO20)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO21	(CPG_CANFD3.unTXBTO.stcField.u1TO21)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO22	(CPG_CANFD3.unTXBTO.stcField.u1TO22)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO23	(CPG_CANFD3.unTXBTO.stcField.u1TO23)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO24	(CPG_CANFD3.unTXBTO.stcField.u1TO24)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO25	(CPG_CANFD3.unTXBTO.stcField.u1TO25)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO26	(CPG_CANFD3.unTXBTO.stcField.u1TO26)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO27	(CPG_CANFD3.unTXBTO.stcField.u1TO27)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO28	(CPG_CANFD3.unTXBTO.stcField.u1TO28)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO29	(CPG_CANFD3.unTXBTO.stcField.u1TO29)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO30	(CPG_CANFD3.unTXBTO.stcField.u1TO30)  /*@bf@*/
#define CPG_CANFD3_TXBTO_TO31	(CPG_CANFD3.unTXBTO.stcField.u1TO31)  /*@bf@*/

typedef struct stc_cpg_canfdn_txbto_field{
    uint_io32_t		u1TO0:1;
    uint_io32_t		u1TO1:1;
    uint_io32_t		u1TO2:1;
    uint_io32_t		u1TO3:1;
    uint_io32_t		u1TO4:1;
    uint_io32_t		u1TO5:1;
    uint_io32_t		u1TO6:1;
    uint_io32_t		u1TO7:1;
    uint_io32_t		u1TO8:1;
    uint_io32_t		u1TO9:1;
    uint_io32_t		u1TO10:1;
    uint_io32_t		u1TO11:1;
    uint_io32_t		u1TO12:1;
    uint_io32_t		u1TO13:1;
    uint_io32_t		u1TO14:1;
    uint_io32_t		u1TO15:1;
    uint_io32_t		u1TO16:1;
    uint_io32_t		u1TO17:1;
    uint_io32_t		u1TO18:1;
    uint_io32_t		u1TO19:1;
    uint_io32_t		u1TO20:1;
    uint_io32_t		u1TO21:1;
    uint_io32_t		u1TO22:1;
    uint_io32_t		u1TO23:1;
    uint_io32_t		u1TO24:1;
    uint_io32_t		u1TO25:1;
    uint_io32_t		u1TO26:1;
    uint_io32_t		u1TO27:1;
    uint_io32_t		u1TO28:1;
    uint_io32_t		u1TO29:1;
    uint_io32_t		u1TO30:1;
    uint_io32_t		u1TO31:1;
}stc_cpg_canfdn_txbto_field_t;

typedef union un_cpg_canfdn_txbto{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txbto_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txbto_t;

/* TXBCF */
#define CPG_CANFD0_TXBCF	(CPG_CANFD0.unTXBCF.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXBCF_CF0	(CPG_CANFD0.unTXBCF.stcField.u1CF0)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF1	(CPG_CANFD0.unTXBCF.stcField.u1CF1)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF2	(CPG_CANFD0.unTXBCF.stcField.u1CF2)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF3	(CPG_CANFD0.unTXBCF.stcField.u1CF3)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF4	(CPG_CANFD0.unTXBCF.stcField.u1CF4)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF5	(CPG_CANFD0.unTXBCF.stcField.u1CF5)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF6	(CPG_CANFD0.unTXBCF.stcField.u1CF6)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF7	(CPG_CANFD0.unTXBCF.stcField.u1CF7)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF8	(CPG_CANFD0.unTXBCF.stcField.u1CF8)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF9	(CPG_CANFD0.unTXBCF.stcField.u1CF9)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF10	(CPG_CANFD0.unTXBCF.stcField.u1CF10)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF11	(CPG_CANFD0.unTXBCF.stcField.u1CF11)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF12	(CPG_CANFD0.unTXBCF.stcField.u1CF12)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF13	(CPG_CANFD0.unTXBCF.stcField.u1CF13)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF14	(CPG_CANFD0.unTXBCF.stcField.u1CF14)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF15	(CPG_CANFD0.unTXBCF.stcField.u1CF15)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF16	(CPG_CANFD0.unTXBCF.stcField.u1CF16)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF17	(CPG_CANFD0.unTXBCF.stcField.u1CF17)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF18	(CPG_CANFD0.unTXBCF.stcField.u1CF18)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF19	(CPG_CANFD0.unTXBCF.stcField.u1CF19)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF20	(CPG_CANFD0.unTXBCF.stcField.u1CF20)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF21	(CPG_CANFD0.unTXBCF.stcField.u1CF21)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF22	(CPG_CANFD0.unTXBCF.stcField.u1CF22)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF23	(CPG_CANFD0.unTXBCF.stcField.u1CF23)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF24	(CPG_CANFD0.unTXBCF.stcField.u1CF24)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF25	(CPG_CANFD0.unTXBCF.stcField.u1CF25)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF26	(CPG_CANFD0.unTXBCF.stcField.u1CF26)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF27	(CPG_CANFD0.unTXBCF.stcField.u1CF27)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF28	(CPG_CANFD0.unTXBCF.stcField.u1CF28)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF29	(CPG_CANFD0.unTXBCF.stcField.u1CF29)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF30	(CPG_CANFD0.unTXBCF.stcField.u1CF30)  /*@bf@*/
#define CPG_CANFD0_TXBCF_CF31	(CPG_CANFD0.unTXBCF.stcField.u1CF31)  /*@bf@*/

#define CPG_CANFD1_TXBCF	(CPG_CANFD1.unTXBCF.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXBCF_CF0	(CPG_CANFD1.unTXBCF.stcField.u1CF0)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF1	(CPG_CANFD1.unTXBCF.stcField.u1CF1)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF2	(CPG_CANFD1.unTXBCF.stcField.u1CF2)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF3	(CPG_CANFD1.unTXBCF.stcField.u1CF3)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF4	(CPG_CANFD1.unTXBCF.stcField.u1CF4)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF5	(CPG_CANFD1.unTXBCF.stcField.u1CF5)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF6	(CPG_CANFD1.unTXBCF.stcField.u1CF6)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF7	(CPG_CANFD1.unTXBCF.stcField.u1CF7)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF8	(CPG_CANFD1.unTXBCF.stcField.u1CF8)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF9	(CPG_CANFD1.unTXBCF.stcField.u1CF9)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF10	(CPG_CANFD1.unTXBCF.stcField.u1CF10)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF11	(CPG_CANFD1.unTXBCF.stcField.u1CF11)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF12	(CPG_CANFD1.unTXBCF.stcField.u1CF12)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF13	(CPG_CANFD1.unTXBCF.stcField.u1CF13)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF14	(CPG_CANFD1.unTXBCF.stcField.u1CF14)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF15	(CPG_CANFD1.unTXBCF.stcField.u1CF15)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF16	(CPG_CANFD1.unTXBCF.stcField.u1CF16)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF17	(CPG_CANFD1.unTXBCF.stcField.u1CF17)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF18	(CPG_CANFD1.unTXBCF.stcField.u1CF18)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF19	(CPG_CANFD1.unTXBCF.stcField.u1CF19)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF20	(CPG_CANFD1.unTXBCF.stcField.u1CF20)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF21	(CPG_CANFD1.unTXBCF.stcField.u1CF21)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF22	(CPG_CANFD1.unTXBCF.stcField.u1CF22)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF23	(CPG_CANFD1.unTXBCF.stcField.u1CF23)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF24	(CPG_CANFD1.unTXBCF.stcField.u1CF24)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF25	(CPG_CANFD1.unTXBCF.stcField.u1CF25)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF26	(CPG_CANFD1.unTXBCF.stcField.u1CF26)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF27	(CPG_CANFD1.unTXBCF.stcField.u1CF27)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF28	(CPG_CANFD1.unTXBCF.stcField.u1CF28)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF29	(CPG_CANFD1.unTXBCF.stcField.u1CF29)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF30	(CPG_CANFD1.unTXBCF.stcField.u1CF30)  /*@bf@*/
#define CPG_CANFD1_TXBCF_CF31	(CPG_CANFD1.unTXBCF.stcField.u1CF31)  /*@bf@*/

#define CPG_CANFD2_TXBCF	(CPG_CANFD2.unTXBCF.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXBCF_CF0	(CPG_CANFD2.unTXBCF.stcField.u1CF0)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF1	(CPG_CANFD2.unTXBCF.stcField.u1CF1)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF2	(CPG_CANFD2.unTXBCF.stcField.u1CF2)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF3	(CPG_CANFD2.unTXBCF.stcField.u1CF3)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF4	(CPG_CANFD2.unTXBCF.stcField.u1CF4)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF5	(CPG_CANFD2.unTXBCF.stcField.u1CF5)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF6	(CPG_CANFD2.unTXBCF.stcField.u1CF6)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF7	(CPG_CANFD2.unTXBCF.stcField.u1CF7)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF8	(CPG_CANFD2.unTXBCF.stcField.u1CF8)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF9	(CPG_CANFD2.unTXBCF.stcField.u1CF9)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF10	(CPG_CANFD2.unTXBCF.stcField.u1CF10)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF11	(CPG_CANFD2.unTXBCF.stcField.u1CF11)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF12	(CPG_CANFD2.unTXBCF.stcField.u1CF12)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF13	(CPG_CANFD2.unTXBCF.stcField.u1CF13)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF14	(CPG_CANFD2.unTXBCF.stcField.u1CF14)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF15	(CPG_CANFD2.unTXBCF.stcField.u1CF15)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF16	(CPG_CANFD2.unTXBCF.stcField.u1CF16)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF17	(CPG_CANFD2.unTXBCF.stcField.u1CF17)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF18	(CPG_CANFD2.unTXBCF.stcField.u1CF18)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF19	(CPG_CANFD2.unTXBCF.stcField.u1CF19)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF20	(CPG_CANFD2.unTXBCF.stcField.u1CF20)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF21	(CPG_CANFD2.unTXBCF.stcField.u1CF21)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF22	(CPG_CANFD2.unTXBCF.stcField.u1CF22)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF23	(CPG_CANFD2.unTXBCF.stcField.u1CF23)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF24	(CPG_CANFD2.unTXBCF.stcField.u1CF24)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF25	(CPG_CANFD2.unTXBCF.stcField.u1CF25)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF26	(CPG_CANFD2.unTXBCF.stcField.u1CF26)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF27	(CPG_CANFD2.unTXBCF.stcField.u1CF27)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF28	(CPG_CANFD2.unTXBCF.stcField.u1CF28)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF29	(CPG_CANFD2.unTXBCF.stcField.u1CF29)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF30	(CPG_CANFD2.unTXBCF.stcField.u1CF30)  /*@bf@*/
#define CPG_CANFD2_TXBCF_CF31	(CPG_CANFD2.unTXBCF.stcField.u1CF31)  /*@bf@*/

#define CPG_CANFD3_TXBCF	(CPG_CANFD3.unTXBCF.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXBCF_CF0	(CPG_CANFD3.unTXBCF.stcField.u1CF0)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF1	(CPG_CANFD3.unTXBCF.stcField.u1CF1)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF2	(CPG_CANFD3.unTXBCF.stcField.u1CF2)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF3	(CPG_CANFD3.unTXBCF.stcField.u1CF3)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF4	(CPG_CANFD3.unTXBCF.stcField.u1CF4)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF5	(CPG_CANFD3.unTXBCF.stcField.u1CF5)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF6	(CPG_CANFD3.unTXBCF.stcField.u1CF6)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF7	(CPG_CANFD3.unTXBCF.stcField.u1CF7)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF8	(CPG_CANFD3.unTXBCF.stcField.u1CF8)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF9	(CPG_CANFD3.unTXBCF.stcField.u1CF9)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF10	(CPG_CANFD3.unTXBCF.stcField.u1CF10)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF11	(CPG_CANFD3.unTXBCF.stcField.u1CF11)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF12	(CPG_CANFD3.unTXBCF.stcField.u1CF12)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF13	(CPG_CANFD3.unTXBCF.stcField.u1CF13)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF14	(CPG_CANFD3.unTXBCF.stcField.u1CF14)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF15	(CPG_CANFD3.unTXBCF.stcField.u1CF15)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF16	(CPG_CANFD3.unTXBCF.stcField.u1CF16)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF17	(CPG_CANFD3.unTXBCF.stcField.u1CF17)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF18	(CPG_CANFD3.unTXBCF.stcField.u1CF18)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF19	(CPG_CANFD3.unTXBCF.stcField.u1CF19)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF20	(CPG_CANFD3.unTXBCF.stcField.u1CF20)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF21	(CPG_CANFD3.unTXBCF.stcField.u1CF21)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF22	(CPG_CANFD3.unTXBCF.stcField.u1CF22)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF23	(CPG_CANFD3.unTXBCF.stcField.u1CF23)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF24	(CPG_CANFD3.unTXBCF.stcField.u1CF24)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF25	(CPG_CANFD3.unTXBCF.stcField.u1CF25)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF26	(CPG_CANFD3.unTXBCF.stcField.u1CF26)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF27	(CPG_CANFD3.unTXBCF.stcField.u1CF27)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF28	(CPG_CANFD3.unTXBCF.stcField.u1CF28)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF29	(CPG_CANFD3.unTXBCF.stcField.u1CF29)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF30	(CPG_CANFD3.unTXBCF.stcField.u1CF30)  /*@bf@*/
#define CPG_CANFD3_TXBCF_CF31	(CPG_CANFD3.unTXBCF.stcField.u1CF31)  /*@bf@*/

typedef struct stc_cpg_canfdn_txbcf_field{
    uint_io32_t		u1CF0:1;
    uint_io32_t		u1CF1:1;
    uint_io32_t		u1CF2:1;
    uint_io32_t		u1CF3:1;
    uint_io32_t		u1CF4:1;
    uint_io32_t		u1CF5:1;
    uint_io32_t		u1CF6:1;
    uint_io32_t		u1CF7:1;
    uint_io32_t		u1CF8:1;
    uint_io32_t		u1CF9:1;
    uint_io32_t		u1CF10:1;
    uint_io32_t		u1CF11:1;
    uint_io32_t		u1CF12:1;
    uint_io32_t		u1CF13:1;
    uint_io32_t		u1CF14:1;
    uint_io32_t		u1CF15:1;
    uint_io32_t		u1CF16:1;
    uint_io32_t		u1CF17:1;
    uint_io32_t		u1CF18:1;
    uint_io32_t		u1CF19:1;
    uint_io32_t		u1CF20:1;
    uint_io32_t		u1CF21:1;
    uint_io32_t		u1CF22:1;
    uint_io32_t		u1CF23:1;
    uint_io32_t		u1CF24:1;
    uint_io32_t		u1CF25:1;
    uint_io32_t		u1CF26:1;
    uint_io32_t		u1CF27:1;
    uint_io32_t		u1CF28:1;
    uint_io32_t		u1CF29:1;
    uint_io32_t		u1CF30:1;
    uint_io32_t		u1CF31:1;
}stc_cpg_canfdn_txbcf_field_t;

typedef union un_cpg_canfdn_txbcf{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txbcf_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txbcf_t;

/* TXBTIE */
#define CPG_CANFD0_TXBTIE	(CPG_CANFD0.unTXBTIE.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXBTIE_TIE0	(CPG_CANFD0.unTXBTIE.stcField.u1TIE0)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE1	(CPG_CANFD0.unTXBTIE.stcField.u1TIE1)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE2	(CPG_CANFD0.unTXBTIE.stcField.u1TIE2)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE3	(CPG_CANFD0.unTXBTIE.stcField.u1TIE3)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE4	(CPG_CANFD0.unTXBTIE.stcField.u1TIE4)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE5	(CPG_CANFD0.unTXBTIE.stcField.u1TIE5)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE6	(CPG_CANFD0.unTXBTIE.stcField.u1TIE6)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE7	(CPG_CANFD0.unTXBTIE.stcField.u1TIE7)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE8	(CPG_CANFD0.unTXBTIE.stcField.u1TIE8)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE9	(CPG_CANFD0.unTXBTIE.stcField.u1TIE9)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE10	(CPG_CANFD0.unTXBTIE.stcField.u1TIE10)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE11	(CPG_CANFD0.unTXBTIE.stcField.u1TIE11)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE12	(CPG_CANFD0.unTXBTIE.stcField.u1TIE12)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE13	(CPG_CANFD0.unTXBTIE.stcField.u1TIE13)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE14	(CPG_CANFD0.unTXBTIE.stcField.u1TIE14)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE15	(CPG_CANFD0.unTXBTIE.stcField.u1TIE15)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE16	(CPG_CANFD0.unTXBTIE.stcField.u1TIE16)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE17	(CPG_CANFD0.unTXBTIE.stcField.u1TIE17)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE18	(CPG_CANFD0.unTXBTIE.stcField.u1TIE18)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE19	(CPG_CANFD0.unTXBTIE.stcField.u1TIE19)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE20	(CPG_CANFD0.unTXBTIE.stcField.u1TIE20)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE21	(CPG_CANFD0.unTXBTIE.stcField.u1TIE21)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE22	(CPG_CANFD0.unTXBTIE.stcField.u1TIE22)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE23	(CPG_CANFD0.unTXBTIE.stcField.u1TIE23)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE24	(CPG_CANFD0.unTXBTIE.stcField.u1TIE24)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE25	(CPG_CANFD0.unTXBTIE.stcField.u1TIE25)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE26	(CPG_CANFD0.unTXBTIE.stcField.u1TIE26)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE27	(CPG_CANFD0.unTXBTIE.stcField.u1TIE27)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE28	(CPG_CANFD0.unTXBTIE.stcField.u1TIE28)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE29	(CPG_CANFD0.unTXBTIE.stcField.u1TIE29)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE30	(CPG_CANFD0.unTXBTIE.stcField.u1TIE30)  /*@bf@*/
#define CPG_CANFD0_TXBTIE_TIE31	(CPG_CANFD0.unTXBTIE.stcField.u1TIE31)  /*@bf@*/

#define CPG_CANFD1_TXBTIE	(CPG_CANFD1.unTXBTIE.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXBTIE_TIE0	(CPG_CANFD1.unTXBTIE.stcField.u1TIE0)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE1	(CPG_CANFD1.unTXBTIE.stcField.u1TIE1)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE2	(CPG_CANFD1.unTXBTIE.stcField.u1TIE2)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE3	(CPG_CANFD1.unTXBTIE.stcField.u1TIE3)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE4	(CPG_CANFD1.unTXBTIE.stcField.u1TIE4)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE5	(CPG_CANFD1.unTXBTIE.stcField.u1TIE5)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE6	(CPG_CANFD1.unTXBTIE.stcField.u1TIE6)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE7	(CPG_CANFD1.unTXBTIE.stcField.u1TIE7)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE8	(CPG_CANFD1.unTXBTIE.stcField.u1TIE8)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE9	(CPG_CANFD1.unTXBTIE.stcField.u1TIE9)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE10	(CPG_CANFD1.unTXBTIE.stcField.u1TIE10)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE11	(CPG_CANFD1.unTXBTIE.stcField.u1TIE11)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE12	(CPG_CANFD1.unTXBTIE.stcField.u1TIE12)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE13	(CPG_CANFD1.unTXBTIE.stcField.u1TIE13)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE14	(CPG_CANFD1.unTXBTIE.stcField.u1TIE14)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE15	(CPG_CANFD1.unTXBTIE.stcField.u1TIE15)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE16	(CPG_CANFD1.unTXBTIE.stcField.u1TIE16)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE17	(CPG_CANFD1.unTXBTIE.stcField.u1TIE17)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE18	(CPG_CANFD1.unTXBTIE.stcField.u1TIE18)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE19	(CPG_CANFD1.unTXBTIE.stcField.u1TIE19)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE20	(CPG_CANFD1.unTXBTIE.stcField.u1TIE20)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE21	(CPG_CANFD1.unTXBTIE.stcField.u1TIE21)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE22	(CPG_CANFD1.unTXBTIE.stcField.u1TIE22)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE23	(CPG_CANFD1.unTXBTIE.stcField.u1TIE23)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE24	(CPG_CANFD1.unTXBTIE.stcField.u1TIE24)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE25	(CPG_CANFD1.unTXBTIE.stcField.u1TIE25)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE26	(CPG_CANFD1.unTXBTIE.stcField.u1TIE26)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE27	(CPG_CANFD1.unTXBTIE.stcField.u1TIE27)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE28	(CPG_CANFD1.unTXBTIE.stcField.u1TIE28)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE29	(CPG_CANFD1.unTXBTIE.stcField.u1TIE29)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE30	(CPG_CANFD1.unTXBTIE.stcField.u1TIE30)  /*@bf@*/
#define CPG_CANFD1_TXBTIE_TIE31	(CPG_CANFD1.unTXBTIE.stcField.u1TIE31)  /*@bf@*/

#define CPG_CANFD2_TXBTIE	(CPG_CANFD2.unTXBTIE.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXBTIE_TIE0	(CPG_CANFD2.unTXBTIE.stcField.u1TIE0)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE1	(CPG_CANFD2.unTXBTIE.stcField.u1TIE1)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE2	(CPG_CANFD2.unTXBTIE.stcField.u1TIE2)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE3	(CPG_CANFD2.unTXBTIE.stcField.u1TIE3)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE4	(CPG_CANFD2.unTXBTIE.stcField.u1TIE4)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE5	(CPG_CANFD2.unTXBTIE.stcField.u1TIE5)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE6	(CPG_CANFD2.unTXBTIE.stcField.u1TIE6)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE7	(CPG_CANFD2.unTXBTIE.stcField.u1TIE7)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE8	(CPG_CANFD2.unTXBTIE.stcField.u1TIE8)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE9	(CPG_CANFD2.unTXBTIE.stcField.u1TIE9)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE10	(CPG_CANFD2.unTXBTIE.stcField.u1TIE10)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE11	(CPG_CANFD2.unTXBTIE.stcField.u1TIE11)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE12	(CPG_CANFD2.unTXBTIE.stcField.u1TIE12)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE13	(CPG_CANFD2.unTXBTIE.stcField.u1TIE13)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE14	(CPG_CANFD2.unTXBTIE.stcField.u1TIE14)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE15	(CPG_CANFD2.unTXBTIE.stcField.u1TIE15)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE16	(CPG_CANFD2.unTXBTIE.stcField.u1TIE16)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE17	(CPG_CANFD2.unTXBTIE.stcField.u1TIE17)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE18	(CPG_CANFD2.unTXBTIE.stcField.u1TIE18)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE19	(CPG_CANFD2.unTXBTIE.stcField.u1TIE19)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE20	(CPG_CANFD2.unTXBTIE.stcField.u1TIE20)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE21	(CPG_CANFD2.unTXBTIE.stcField.u1TIE21)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE22	(CPG_CANFD2.unTXBTIE.stcField.u1TIE22)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE23	(CPG_CANFD2.unTXBTIE.stcField.u1TIE23)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE24	(CPG_CANFD2.unTXBTIE.stcField.u1TIE24)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE25	(CPG_CANFD2.unTXBTIE.stcField.u1TIE25)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE26	(CPG_CANFD2.unTXBTIE.stcField.u1TIE26)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE27	(CPG_CANFD2.unTXBTIE.stcField.u1TIE27)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE28	(CPG_CANFD2.unTXBTIE.stcField.u1TIE28)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE29	(CPG_CANFD2.unTXBTIE.stcField.u1TIE29)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE30	(CPG_CANFD2.unTXBTIE.stcField.u1TIE30)  /*@bf@*/
#define CPG_CANFD2_TXBTIE_TIE31	(CPG_CANFD2.unTXBTIE.stcField.u1TIE31)  /*@bf@*/

#define CPG_CANFD3_TXBTIE	(CPG_CANFD3.unTXBTIE.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXBTIE_TIE0	(CPG_CANFD3.unTXBTIE.stcField.u1TIE0)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE1	(CPG_CANFD3.unTXBTIE.stcField.u1TIE1)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE2	(CPG_CANFD3.unTXBTIE.stcField.u1TIE2)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE3	(CPG_CANFD3.unTXBTIE.stcField.u1TIE3)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE4	(CPG_CANFD3.unTXBTIE.stcField.u1TIE4)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE5	(CPG_CANFD3.unTXBTIE.stcField.u1TIE5)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE6	(CPG_CANFD3.unTXBTIE.stcField.u1TIE6)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE7	(CPG_CANFD3.unTXBTIE.stcField.u1TIE7)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE8	(CPG_CANFD3.unTXBTIE.stcField.u1TIE8)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE9	(CPG_CANFD3.unTXBTIE.stcField.u1TIE9)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE10	(CPG_CANFD3.unTXBTIE.stcField.u1TIE10)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE11	(CPG_CANFD3.unTXBTIE.stcField.u1TIE11)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE12	(CPG_CANFD3.unTXBTIE.stcField.u1TIE12)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE13	(CPG_CANFD3.unTXBTIE.stcField.u1TIE13)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE14	(CPG_CANFD3.unTXBTIE.stcField.u1TIE14)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE15	(CPG_CANFD3.unTXBTIE.stcField.u1TIE15)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE16	(CPG_CANFD3.unTXBTIE.stcField.u1TIE16)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE17	(CPG_CANFD3.unTXBTIE.stcField.u1TIE17)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE18	(CPG_CANFD3.unTXBTIE.stcField.u1TIE18)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE19	(CPG_CANFD3.unTXBTIE.stcField.u1TIE19)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE20	(CPG_CANFD3.unTXBTIE.stcField.u1TIE20)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE21	(CPG_CANFD3.unTXBTIE.stcField.u1TIE21)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE22	(CPG_CANFD3.unTXBTIE.stcField.u1TIE22)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE23	(CPG_CANFD3.unTXBTIE.stcField.u1TIE23)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE24	(CPG_CANFD3.unTXBTIE.stcField.u1TIE24)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE25	(CPG_CANFD3.unTXBTIE.stcField.u1TIE25)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE26	(CPG_CANFD3.unTXBTIE.stcField.u1TIE26)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE27	(CPG_CANFD3.unTXBTIE.stcField.u1TIE27)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE28	(CPG_CANFD3.unTXBTIE.stcField.u1TIE28)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE29	(CPG_CANFD3.unTXBTIE.stcField.u1TIE29)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE30	(CPG_CANFD3.unTXBTIE.stcField.u1TIE30)  /*@bf@*/
#define CPG_CANFD3_TXBTIE_TIE31	(CPG_CANFD3.unTXBTIE.stcField.u1TIE31)  /*@bf@*/

typedef struct stc_cpg_canfdn_txbtie_field{
    uint_io32_t		u1TIE0:1;
    uint_io32_t		u1TIE1:1;
    uint_io32_t		u1TIE2:1;
    uint_io32_t		u1TIE3:1;
    uint_io32_t		u1TIE4:1;
    uint_io32_t		u1TIE5:1;
    uint_io32_t		u1TIE6:1;
    uint_io32_t		u1TIE7:1;
    uint_io32_t		u1TIE8:1;
    uint_io32_t		u1TIE9:1;
    uint_io32_t		u1TIE10:1;
    uint_io32_t		u1TIE11:1;
    uint_io32_t		u1TIE12:1;
    uint_io32_t		u1TIE13:1;
    uint_io32_t		u1TIE14:1;
    uint_io32_t		u1TIE15:1;
    uint_io32_t		u1TIE16:1;
    uint_io32_t		u1TIE17:1;
    uint_io32_t		u1TIE18:1;
    uint_io32_t		u1TIE19:1;
    uint_io32_t		u1TIE20:1;
    uint_io32_t		u1TIE21:1;
    uint_io32_t		u1TIE22:1;
    uint_io32_t		u1TIE23:1;
    uint_io32_t		u1TIE24:1;
    uint_io32_t		u1TIE25:1;
    uint_io32_t		u1TIE26:1;
    uint_io32_t		u1TIE27:1;
    uint_io32_t		u1TIE28:1;
    uint_io32_t		u1TIE29:1;
    uint_io32_t		u1TIE30:1;
    uint_io32_t		u1TIE31:1;
}stc_cpg_canfdn_txbtie_field_t;

typedef union un_cpg_canfdn_txbtie{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txbtie_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txbtie_t;

/* TXBCIE */
#define CPG_CANFD0_TXBCIE	(CPG_CANFD0.unTXBCIE.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXBCIE_CFIE0	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE0)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE1	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE1)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE2	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE2)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE3	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE3)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE4	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE4)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE5	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE5)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE6	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE6)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE7	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE7)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE8	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE8)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE9	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE9)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE10	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE10)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE11	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE11)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE12	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE12)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE13	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE13)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE14	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE14)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE15	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE15)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE16	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE16)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE17	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE17)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE18	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE18)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE19	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE19)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE20	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE20)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE21	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE21)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE22	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE22)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE23	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE23)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE24	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE24)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE25	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE25)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE26	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE26)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE27	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE27)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE28	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE28)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE29	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE29)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE30	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE30)  /*@bf@*/
#define CPG_CANFD0_TXBCIE_CFIE31	(CPG_CANFD0.unTXBCIE.stcField.u1CFIE31)  /*@bf@*/

#define CPG_CANFD1_TXBCIE	(CPG_CANFD1.unTXBCIE.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXBCIE_CFIE0	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE0)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE1	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE1)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE2	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE2)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE3	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE3)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE4	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE4)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE5	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE5)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE6	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE6)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE7	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE7)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE8	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE8)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE9	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE9)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE10	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE10)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE11	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE11)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE12	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE12)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE13	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE13)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE14	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE14)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE15	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE15)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE16	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE16)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE17	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE17)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE18	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE18)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE19	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE19)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE20	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE20)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE21	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE21)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE22	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE22)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE23	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE23)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE24	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE24)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE25	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE25)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE26	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE26)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE27	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE27)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE28	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE28)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE29	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE29)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE30	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE30)  /*@bf@*/
#define CPG_CANFD1_TXBCIE_CFIE31	(CPG_CANFD1.unTXBCIE.stcField.u1CFIE31)  /*@bf@*/

#define CPG_CANFD2_TXBCIE	(CPG_CANFD2.unTXBCIE.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXBCIE_CFIE0	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE0)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE1	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE1)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE2	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE2)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE3	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE3)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE4	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE4)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE5	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE5)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE6	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE6)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE7	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE7)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE8	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE8)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE9	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE9)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE10	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE10)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE11	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE11)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE12	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE12)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE13	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE13)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE14	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE14)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE15	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE15)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE16	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE16)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE17	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE17)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE18	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE18)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE19	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE19)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE20	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE20)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE21	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE21)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE22	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE22)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE23	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE23)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE24	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE24)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE25	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE25)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE26	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE26)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE27	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE27)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE28	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE28)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE29	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE29)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE30	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE30)  /*@bf@*/
#define CPG_CANFD2_TXBCIE_CFIE31	(CPG_CANFD2.unTXBCIE.stcField.u1CFIE31)  /*@bf@*/

#define CPG_CANFD3_TXBCIE	(CPG_CANFD3.unTXBCIE.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXBCIE_CFIE0	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE0)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE1	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE1)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE2	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE2)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE3	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE3)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE4	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE4)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE5	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE5)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE6	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE6)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE7	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE7)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE8	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE8)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE9	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE9)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE10	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE10)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE11	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE11)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE12	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE12)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE13	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE13)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE14	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE14)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE15	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE15)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE16	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE16)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE17	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE17)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE18	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE18)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE19	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE19)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE20	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE20)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE21	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE21)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE22	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE22)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE23	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE23)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE24	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE24)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE25	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE25)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE26	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE26)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE27	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE27)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE28	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE28)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE29	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE29)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE30	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE30)  /*@bf@*/
#define CPG_CANFD3_TXBCIE_CFIE31	(CPG_CANFD3.unTXBCIE.stcField.u1CFIE31)  /*@bf@*/

typedef struct stc_cpg_canfdn_txbcie_field{
    uint_io32_t		u1CFIE0:1;
    uint_io32_t		u1CFIE1:1;
    uint_io32_t		u1CFIE2:1;
    uint_io32_t		u1CFIE3:1;
    uint_io32_t		u1CFIE4:1;
    uint_io32_t		u1CFIE5:1;
    uint_io32_t		u1CFIE6:1;
    uint_io32_t		u1CFIE7:1;
    uint_io32_t		u1CFIE8:1;
    uint_io32_t		u1CFIE9:1;
    uint_io32_t		u1CFIE10:1;
    uint_io32_t		u1CFIE11:1;
    uint_io32_t		u1CFIE12:1;
    uint_io32_t		u1CFIE13:1;
    uint_io32_t		u1CFIE14:1;
    uint_io32_t		u1CFIE15:1;
    uint_io32_t		u1CFIE16:1;
    uint_io32_t		u1CFIE17:1;
    uint_io32_t		u1CFIE18:1;
    uint_io32_t		u1CFIE19:1;
    uint_io32_t		u1CFIE20:1;
    uint_io32_t		u1CFIE21:1;
    uint_io32_t		u1CFIE22:1;
    uint_io32_t		u1CFIE23:1;
    uint_io32_t		u1CFIE24:1;
    uint_io32_t		u1CFIE25:1;
    uint_io32_t		u1CFIE26:1;
    uint_io32_t		u1CFIE27:1;
    uint_io32_t		u1CFIE28:1;
    uint_io32_t		u1CFIE29:1;
    uint_io32_t		u1CFIE30:1;
    uint_io32_t		u1CFIE31:1;
}stc_cpg_canfdn_txbcie_field_t;

typedef union un_cpg_canfdn_txbcie{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txbcie_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txbcie_t;

/* TXEFC */
#define CPG_CANFD0_TXEFC	(CPG_CANFD0.unTXEFC.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXEFC_EFSA	(CPG_CANFD0.unTXEFC.stcField.u14EFSA)  /*@bf@*/
#define CPG_CANFD0_TXEFC_EFS	(CPG_CANFD0.unTXEFC.stcField.u6EFS)  /*@bf@*/
#define CPG_CANFD0_TXEFC_EFWM	(CPG_CANFD0.unTXEFC.stcField.u6EFWM)  /*@bf@*/

#define CPG_CANFD1_TXEFC	(CPG_CANFD1.unTXEFC.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXEFC_EFSA	(CPG_CANFD1.unTXEFC.stcField.u14EFSA)  /*@bf@*/
#define CPG_CANFD1_TXEFC_EFS	(CPG_CANFD1.unTXEFC.stcField.u6EFS)  /*@bf@*/
#define CPG_CANFD1_TXEFC_EFWM	(CPG_CANFD1.unTXEFC.stcField.u6EFWM)  /*@bf@*/

#define CPG_CANFD2_TXEFC	(CPG_CANFD2.unTXEFC.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXEFC_EFSA	(CPG_CANFD2.unTXEFC.stcField.u14EFSA)  /*@bf@*/
#define CPG_CANFD2_TXEFC_EFS	(CPG_CANFD2.unTXEFC.stcField.u6EFS)  /*@bf@*/
#define CPG_CANFD2_TXEFC_EFWM	(CPG_CANFD2.unTXEFC.stcField.u6EFWM)  /*@bf@*/

#define CPG_CANFD3_TXEFC	(CPG_CANFD3.unTXEFC.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXEFC_EFSA	(CPG_CANFD3.unTXEFC.stcField.u14EFSA)  /*@bf@*/
#define CPG_CANFD3_TXEFC_EFS	(CPG_CANFD3.unTXEFC.stcField.u6EFS)  /*@bf@*/
#define CPG_CANFD3_TXEFC_EFWM	(CPG_CANFD3.unTXEFC.stcField.u6EFWM)  /*@bf@*/

typedef struct stc_cpg_canfdn_txefc_field{
    uint_io32_t		:2;
    uint_io32_t		u14EFSA:14;
    uint_io32_t		u6EFS:6;
    uint_io32_t		:2;
    uint_io32_t		u6EFWM:6;
    uint_io32_t		:2;
}stc_cpg_canfdn_txefc_field_t;

typedef union un_cpg_canfdn_txefc{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txefc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txefc_t;

/* TXEFS */
#define CPG_CANFD0_TXEFS	(CPG_CANFD0.unTXEFS.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXEFS_EFFL	(CPG_CANFD0.unTXEFS.stcField.u6EFFL)  /*@bf@*/
#define CPG_CANFD0_TXEFS_EFGI	(CPG_CANFD0.unTXEFS.stcField.u5EFGI)  /*@bf@*/
#define CPG_CANFD0_TXEFS_EFPI	(CPG_CANFD0.unTXEFS.stcField.u5EFPI)  /*@bf@*/
#define CPG_CANFD0_TXEFS_EFF	(CPG_CANFD0.unTXEFS.stcField.u1EFF)  /*@bf@*/
#define CPG_CANFD0_TXEFS_TEFL	(CPG_CANFD0.unTXEFS.stcField.u1TEFL)  /*@bf@*/

#define CPG_CANFD1_TXEFS	(CPG_CANFD1.unTXEFS.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXEFS_EFFL	(CPG_CANFD1.unTXEFS.stcField.u6EFFL)  /*@bf@*/
#define CPG_CANFD1_TXEFS_EFGI	(CPG_CANFD1.unTXEFS.stcField.u5EFGI)  /*@bf@*/
#define CPG_CANFD1_TXEFS_EFPI	(CPG_CANFD1.unTXEFS.stcField.u5EFPI)  /*@bf@*/
#define CPG_CANFD1_TXEFS_EFF	(CPG_CANFD1.unTXEFS.stcField.u1EFF)  /*@bf@*/
#define CPG_CANFD1_TXEFS_TEFL	(CPG_CANFD1.unTXEFS.stcField.u1TEFL)  /*@bf@*/

#define CPG_CANFD2_TXEFS	(CPG_CANFD2.unTXEFS.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXEFS_EFFL	(CPG_CANFD2.unTXEFS.stcField.u6EFFL)  /*@bf@*/
#define CPG_CANFD2_TXEFS_EFGI	(CPG_CANFD2.unTXEFS.stcField.u5EFGI)  /*@bf@*/
#define CPG_CANFD2_TXEFS_EFPI	(CPG_CANFD2.unTXEFS.stcField.u5EFPI)  /*@bf@*/
#define CPG_CANFD2_TXEFS_EFF	(CPG_CANFD2.unTXEFS.stcField.u1EFF)  /*@bf@*/
#define CPG_CANFD2_TXEFS_TEFL	(CPG_CANFD2.unTXEFS.stcField.u1TEFL)  /*@bf@*/

#define CPG_CANFD3_TXEFS	(CPG_CANFD3.unTXEFS.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXEFS_EFFL	(CPG_CANFD3.unTXEFS.stcField.u6EFFL)  /*@bf@*/
#define CPG_CANFD3_TXEFS_EFGI	(CPG_CANFD3.unTXEFS.stcField.u5EFGI)  /*@bf@*/
#define CPG_CANFD3_TXEFS_EFPI	(CPG_CANFD3.unTXEFS.stcField.u5EFPI)  /*@bf@*/
#define CPG_CANFD3_TXEFS_EFF	(CPG_CANFD3.unTXEFS.stcField.u1EFF)  /*@bf@*/
#define CPG_CANFD3_TXEFS_TEFL	(CPG_CANFD3.unTXEFS.stcField.u1TEFL)  /*@bf@*/

typedef struct stc_cpg_canfdn_txefs_field{
    uint_io32_t		u6EFFL:6;
    uint_io32_t		:2;
    uint_io32_t		u5EFGI:5;
    uint_io32_t		:3;
    uint_io32_t		u5EFPI:5;
    uint_io32_t		:3;
    uint_io32_t		u1EFF:1;
    uint_io32_t		u1TEFL:1;
    uint_io32_t		:6;
}stc_cpg_canfdn_txefs_field_t;

typedef union un_cpg_canfdn_txefs{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txefs_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txefs_t;

/* TXEFA */
#define CPG_CANFD0_TXEFA	(CPG_CANFD0.unTXEFA.u32Register)  /*@rg@*/
#define CPG_CANFD0_TXEFA_EFAI	(CPG_CANFD0.unTXEFA.stcField.u5EFAI)  /*@bf@*/

#define CPG_CANFD1_TXEFA	(CPG_CANFD1.unTXEFA.u32Register)  /*@rg@*/
#define CPG_CANFD1_TXEFA_EFAI	(CPG_CANFD1.unTXEFA.stcField.u5EFAI)  /*@bf@*/

#define CPG_CANFD2_TXEFA	(CPG_CANFD2.unTXEFA.u32Register)  /*@rg@*/
#define CPG_CANFD2_TXEFA_EFAI	(CPG_CANFD2.unTXEFA.stcField.u5EFAI)  /*@bf@*/

#define CPG_CANFD3_TXEFA	(CPG_CANFD3.unTXEFA.u32Register)  /*@rg@*/
#define CPG_CANFD3_TXEFA_EFAI	(CPG_CANFD3.unTXEFA.stcField.u5EFAI)  /*@bf@*/

typedef struct stc_cpg_canfdn_txefa_field{
    uint_io32_t		u5EFAI:5;
    uint_io32_t		:27;
}stc_cpg_canfdn_txefa_field_t;

typedef union un_cpg_canfdn_txefa{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_txefa_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_txefa_t;

/* FDECR */
#define CPG_CANFD0_FDECR	(CPG_CANFD0.unFDECR.u8Register)  /*@rg@*/
#define CPG_CANFD0_FDECR_SEIE	(CPG_CANFD0.unFDECR.stcField.u1SEIE)  /*@bf@*/
#define CPG_CANFD0_FDECR_DEIE	(CPG_CANFD0.unFDECR.stcField.u1DEIE)  /*@bf@*/
#define CPG_CANFD0_FDECR_CEREN	(CPG_CANFD0.unFDECR.stcField.u1CEREN)  /*@bf@*/
#define CPG_CANFD0_FDECR_CEIV	(CPG_CANFD0.unFDECR.stcField.u1CEIV)  /*@bf@*/

#define CPG_CANFD1_FDECR	(CPG_CANFD1.unFDECR.u8Register)  /*@rg@*/
#define CPG_CANFD1_FDECR_SEIE	(CPG_CANFD1.unFDECR.stcField.u1SEIE)  /*@bf@*/
#define CPG_CANFD1_FDECR_DEIE	(CPG_CANFD1.unFDECR.stcField.u1DEIE)  /*@bf@*/
#define CPG_CANFD1_FDECR_CEREN	(CPG_CANFD1.unFDECR.stcField.u1CEREN)  /*@bf@*/
#define CPG_CANFD1_FDECR_CEIV	(CPG_CANFD1.unFDECR.stcField.u1CEIV)  /*@bf@*/

#define CPG_CANFD2_FDECR	(CPG_CANFD2.unFDECR.u8Register)  /*@rg@*/
#define CPG_CANFD2_FDECR_SEIE	(CPG_CANFD2.unFDECR.stcField.u1SEIE)  /*@bf@*/
#define CPG_CANFD2_FDECR_DEIE	(CPG_CANFD2.unFDECR.stcField.u1DEIE)  /*@bf@*/
#define CPG_CANFD2_FDECR_CEREN	(CPG_CANFD2.unFDECR.stcField.u1CEREN)  /*@bf@*/
#define CPG_CANFD2_FDECR_CEIV	(CPG_CANFD2.unFDECR.stcField.u1CEIV)  /*@bf@*/

#define CPG_CANFD3_FDECR	(CPG_CANFD3.unFDECR.u8Register)  /*@rg@*/
#define CPG_CANFD3_FDECR_SEIE	(CPG_CANFD3.unFDECR.stcField.u1SEIE)  /*@bf@*/
#define CPG_CANFD3_FDECR_DEIE	(CPG_CANFD3.unFDECR.stcField.u1DEIE)  /*@bf@*/
#define CPG_CANFD3_FDECR_CEREN	(CPG_CANFD3.unFDECR.stcField.u1CEREN)  /*@bf@*/
#define CPG_CANFD3_FDECR_CEIV	(CPG_CANFD3.unFDECR.stcField.u1CEIV)  /*@bf@*/

typedef struct stc_cpg_canfdn_fdecr_field{
    uint_io8_t		u1SEIE:1;
    uint_io8_t		u1DEIE:1;
    uint_io8_t		u1CEREN:1;
    uint_io8_t		u1CEIV:1;
    uint_io8_t		:4;
}stc_cpg_canfdn_fdecr_field_t;

typedef union un_cpg_canfdn_fdecr{
    uint_io8_t		u8Register;
    stc_cpg_canfdn_fdecr_field_t		stcField;
}un_cpg_canfdn_fdecr_t;

/* FDESR */
#define CPG_CANFD0_FDESR	(CPG_CANFD0.unFDESR.u8Register)  /*@rg@*/
#define CPG_CANFD0_FDESR_SEI	(CPG_CANFD0.unFDESR.stcField.u1SEI)  /*@bf@*/
#define CPG_CANFD0_FDESR_DEI	(CPG_CANFD0.unFDESR.stcField.u1DEI)  /*@bf@*/

#define CPG_CANFD1_FDESR	(CPG_CANFD1.unFDESR.u8Register)  /*@rg@*/
#define CPG_CANFD1_FDESR_SEI	(CPG_CANFD1.unFDESR.stcField.u1SEI)  /*@bf@*/
#define CPG_CANFD1_FDESR_DEI	(CPG_CANFD1.unFDESR.stcField.u1DEI)  /*@bf@*/

#define CPG_CANFD2_FDESR	(CPG_CANFD2.unFDESR.u8Register)  /*@rg@*/
#define CPG_CANFD2_FDESR_SEI	(CPG_CANFD2.unFDESR.stcField.u1SEI)  /*@bf@*/
#define CPG_CANFD2_FDESR_DEI	(CPG_CANFD2.unFDESR.stcField.u1DEI)  /*@bf@*/

#define CPG_CANFD3_FDESR	(CPG_CANFD3.unFDESR.u8Register)  /*@rg@*/
#define CPG_CANFD3_FDESR_SEI	(CPG_CANFD3.unFDESR.stcField.u1SEI)  /*@bf@*/
#define CPG_CANFD3_FDESR_DEI	(CPG_CANFD3.unFDESR.stcField.u1DEI)  /*@bf@*/

typedef struct stc_cpg_canfdn_fdesr_field{
    uint_io8_t		u1SEI:1;
    uint_io8_t		u1DEI:1;
    uint_io8_t		:6;
}stc_cpg_canfdn_fdesr_field_t;

typedef union un_cpg_canfdn_fdesr{
    uint_io8_t		u8Register;
    stc_cpg_canfdn_fdesr_field_t		stcField;
}un_cpg_canfdn_fdesr_t;

/* FDSEAR */
#define CPG_CANFD0_FDSEAR	(CPG_CANFD0.unFDSEAR.u16Register)  /*@rg@*/
#define CPG_CANFD0_FDSEAR_SRA	CPG_CANFD0_FDSEAR  /*@bfrg@*/

#define CPG_CANFD1_FDSEAR	(CPG_CANFD1.unFDSEAR.u16Register)  /*@rg@*/
#define CPG_CANFD1_FDSEAR_SRA	CPG_CANFD1_FDSEAR  /*@bfrg@*/

#define CPG_CANFD2_FDSEAR	(CPG_CANFD2.unFDSEAR.u16Register)  /*@rg@*/
#define CPG_CANFD2_FDSEAR_SRA	CPG_CANFD2_FDSEAR  /*@bfrg@*/

#define CPG_CANFD3_FDSEAR	(CPG_CANFD3.unFDSEAR.u16Register)  /*@rg@*/
#define CPG_CANFD3_FDSEAR_SRA	CPG_CANFD3_FDSEAR  /*@bfrg@*/

typedef union un_cpg_canfdn_fdsear{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_cpg_canfdn_fdsear_t;

/* FDESCR */
#define CPG_CANFD0_FDESCR	(CPG_CANFD0.unFDESCR.u8Register)  /*@rg@*/
#define CPG_CANFD0_FDESCR_SEIC	(CPG_CANFD0.unFDESCR.stcField.u1SEIC)  /*@bf@*/
#define CPG_CANFD0_FDESCR_DEIC	(CPG_CANFD0.unFDESCR.stcField.u1DEIC)  /*@bf@*/

#define CPG_CANFD1_FDESCR	(CPG_CANFD1.unFDESCR.u8Register)  /*@rg@*/
#define CPG_CANFD1_FDESCR_SEIC	(CPG_CANFD1.unFDESCR.stcField.u1SEIC)  /*@bf@*/
#define CPG_CANFD1_FDESCR_DEIC	(CPG_CANFD1.unFDESCR.stcField.u1DEIC)  /*@bf@*/

#define CPG_CANFD2_FDESCR	(CPG_CANFD2.unFDESCR.u8Register)  /*@rg@*/
#define CPG_CANFD2_FDESCR_SEIC	(CPG_CANFD2.unFDESCR.stcField.u1SEIC)  /*@bf@*/
#define CPG_CANFD2_FDESCR_DEIC	(CPG_CANFD2.unFDESCR.stcField.u1DEIC)  /*@bf@*/

#define CPG_CANFD3_FDESCR	(CPG_CANFD3.unFDESCR.u8Register)  /*@rg@*/
#define CPG_CANFD3_FDESCR_SEIC	(CPG_CANFD3.unFDESCR.stcField.u1SEIC)  /*@bf@*/
#define CPG_CANFD3_FDESCR_DEIC	(CPG_CANFD3.unFDESCR.stcField.u1DEIC)  /*@bf@*/

typedef struct stc_cpg_canfdn_fdescr_field{
    uint_io8_t		u1SEIC:1;
    uint_io8_t		u1DEIC:1;
    uint_io8_t		:6;
}stc_cpg_canfdn_fdescr_field_t;

typedef union un_cpg_canfdn_fdescr{
    uint_io8_t		u8Register;
    stc_cpg_canfdn_fdescr_field_t		stcField;
}un_cpg_canfdn_fdescr_t;

/* FDDEAR */
#define CPG_CANFD0_FDDEAR	(CPG_CANFD0.unFDDEAR.u16Register)  /*@rg@*/
#define CPG_CANFD0_FDDEAR_DRA	CPG_CANFD0_FDDEAR  /*@bfrg@*/

#define CPG_CANFD1_FDDEAR	(CPG_CANFD1.unFDDEAR.u16Register)  /*@rg@*/
#define CPG_CANFD1_FDDEAR_DRA	CPG_CANFD1_FDDEAR  /*@bfrg@*/

#define CPG_CANFD2_FDDEAR	(CPG_CANFD2.unFDDEAR.u16Register)  /*@rg@*/
#define CPG_CANFD2_FDDEAR_DRA	CPG_CANFD2_FDDEAR  /*@bfrg@*/

#define CPG_CANFD3_FDDEAR	(CPG_CANFD3.unFDDEAR.u16Register)  /*@rg@*/
#define CPG_CANFD3_FDDEAR_DRA	CPG_CANFD3_FDDEAR  /*@bfrg@*/

typedef union un_cpg_canfdn_fddear{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_cpg_canfdn_fddear_t;

/* FDFECR */
#define CPG_CANFD0_FDFECR	(CPG_CANFD0.unFDFECR.u32Register)  /*@rg@*/
#define CPG_CANFD0_FDFECR_EI0	(CPG_CANFD0.unFDFECR.stcField.u1EI0)  /*@bf@*/
#define CPG_CANFD0_FDFECR_EI1	(CPG_CANFD0.unFDFECR.stcField.u1EI1)  /*@bf@*/
#define CPG_CANFD0_FDFECR_EI2	(CPG_CANFD0.unFDFECR.stcField.u1EI2)  /*@bf@*/
#define CPG_CANFD0_FDFECR_EI3	(CPG_CANFD0.unFDFECR.stcField.u1EI3)  /*@bf@*/
#define CPG_CANFD0_FDFECR_EI4	(CPG_CANFD0.unFDFECR.stcField.u1EI4)  /*@bf@*/
#define CPG_CANFD0_FDFECR_EI5	(CPG_CANFD0.unFDFECR.stcField.u1EI5)  /*@bf@*/
#define CPG_CANFD0_FDFECR_EI6	(CPG_CANFD0.unFDFECR.stcField.u1EI6)  /*@bf@*/
#define CPG_CANFD0_FDFECR_EI7	(CPG_CANFD0.unFDFECR.stcField.u1EI7)  /*@bf@*/
#define CPG_CANFD0_FDFECR_EI8	(CPG_CANFD0.unFDFECR.stcField.u1EI8)  /*@bf@*/
#define CPG_CANFD0_FDFECR_EI9	(CPG_CANFD0.unFDFECR.stcField.u1EI9)  /*@bf@*/
#define CPG_CANFD0_FDFECR_EI10	(CPG_CANFD0.unFDFECR.stcField.u1EI10)  /*@bf@*/
#define CPG_CANFD0_FDFECR_EI11	(CPG_CANFD0.unFDFECR.stcField.u1EI11)  /*@bf@*/
#define CPG_CANFD0_FDFECR_EI12	(CPG_CANFD0.unFDFECR.stcField.u1EI12)  /*@bf@*/
#define CPG_CANFD0_FDFECR_EI13	(CPG_CANFD0.unFDFECR.stcField.u1EI13)  /*@bf@*/
#define CPG_CANFD0_FDFECR_EI14	(CPG_CANFD0.unFDFECR.stcField.u1EI14)  /*@bf@*/
#define CPG_CANFD0_FDFECR_EI15	(CPG_CANFD0.unFDFECR.stcField.u1EI15)  /*@bf@*/
#define CPG_CANFD0_FDFECR_EY0	(CPG_CANFD0.unFDFECR.stcField.u1EY0)  /*@bf@*/
#define CPG_CANFD0_FDFECR_EY1	(CPG_CANFD0.unFDFECR.stcField.u1EY1)  /*@bf@*/
#define CPG_CANFD0_FDFECR_EY2	(CPG_CANFD0.unFDFECR.stcField.u1EY2)  /*@bf@*/
#define CPG_CANFD0_FDFECR_FERR	(CPG_CANFD0.unFDFECR.stcField.u1FERR)  /*@bf@*/

#define CPG_CANFD1_FDFECR	(CPG_CANFD1.unFDFECR.u32Register)  /*@rg@*/
#define CPG_CANFD1_FDFECR_EI0	(CPG_CANFD1.unFDFECR.stcField.u1EI0)  /*@bf@*/
#define CPG_CANFD1_FDFECR_EI1	(CPG_CANFD1.unFDFECR.stcField.u1EI1)  /*@bf@*/
#define CPG_CANFD1_FDFECR_EI2	(CPG_CANFD1.unFDFECR.stcField.u1EI2)  /*@bf@*/
#define CPG_CANFD1_FDFECR_EI3	(CPG_CANFD1.unFDFECR.stcField.u1EI3)  /*@bf@*/
#define CPG_CANFD1_FDFECR_EI4	(CPG_CANFD1.unFDFECR.stcField.u1EI4)  /*@bf@*/
#define CPG_CANFD1_FDFECR_EI5	(CPG_CANFD1.unFDFECR.stcField.u1EI5)  /*@bf@*/
#define CPG_CANFD1_FDFECR_EI6	(CPG_CANFD1.unFDFECR.stcField.u1EI6)  /*@bf@*/
#define CPG_CANFD1_FDFECR_EI7	(CPG_CANFD1.unFDFECR.stcField.u1EI7)  /*@bf@*/
#define CPG_CANFD1_FDFECR_EI8	(CPG_CANFD1.unFDFECR.stcField.u1EI8)  /*@bf@*/
#define CPG_CANFD1_FDFECR_EI9	(CPG_CANFD1.unFDFECR.stcField.u1EI9)  /*@bf@*/
#define CPG_CANFD1_FDFECR_EI10	(CPG_CANFD1.unFDFECR.stcField.u1EI10)  /*@bf@*/
#define CPG_CANFD1_FDFECR_EI11	(CPG_CANFD1.unFDFECR.stcField.u1EI11)  /*@bf@*/
#define CPG_CANFD1_FDFECR_EI12	(CPG_CANFD1.unFDFECR.stcField.u1EI12)  /*@bf@*/
#define CPG_CANFD1_FDFECR_EI13	(CPG_CANFD1.unFDFECR.stcField.u1EI13)  /*@bf@*/
#define CPG_CANFD1_FDFECR_EI14	(CPG_CANFD1.unFDFECR.stcField.u1EI14)  /*@bf@*/
#define CPG_CANFD1_FDFECR_EI15	(CPG_CANFD1.unFDFECR.stcField.u1EI15)  /*@bf@*/
#define CPG_CANFD1_FDFECR_EY0	(CPG_CANFD1.unFDFECR.stcField.u1EY0)  /*@bf@*/
#define CPG_CANFD1_FDFECR_EY1	(CPG_CANFD1.unFDFECR.stcField.u1EY1)  /*@bf@*/
#define CPG_CANFD1_FDFECR_EY2	(CPG_CANFD1.unFDFECR.stcField.u1EY2)  /*@bf@*/
#define CPG_CANFD1_FDFECR_FERR	(CPG_CANFD1.unFDFECR.stcField.u1FERR)  /*@bf@*/

#define CPG_CANFD2_FDFECR	(CPG_CANFD2.unFDFECR.u32Register)  /*@rg@*/
#define CPG_CANFD2_FDFECR_EI0	(CPG_CANFD2.unFDFECR.stcField.u1EI0)  /*@bf@*/
#define CPG_CANFD2_FDFECR_EI1	(CPG_CANFD2.unFDFECR.stcField.u1EI1)  /*@bf@*/
#define CPG_CANFD2_FDFECR_EI2	(CPG_CANFD2.unFDFECR.stcField.u1EI2)  /*@bf@*/
#define CPG_CANFD2_FDFECR_EI3	(CPG_CANFD2.unFDFECR.stcField.u1EI3)  /*@bf@*/
#define CPG_CANFD2_FDFECR_EI4	(CPG_CANFD2.unFDFECR.stcField.u1EI4)  /*@bf@*/
#define CPG_CANFD2_FDFECR_EI5	(CPG_CANFD2.unFDFECR.stcField.u1EI5)  /*@bf@*/
#define CPG_CANFD2_FDFECR_EI6	(CPG_CANFD2.unFDFECR.stcField.u1EI6)  /*@bf@*/
#define CPG_CANFD2_FDFECR_EI7	(CPG_CANFD2.unFDFECR.stcField.u1EI7)  /*@bf@*/
#define CPG_CANFD2_FDFECR_EI8	(CPG_CANFD2.unFDFECR.stcField.u1EI8)  /*@bf@*/
#define CPG_CANFD2_FDFECR_EI9	(CPG_CANFD2.unFDFECR.stcField.u1EI9)  /*@bf@*/
#define CPG_CANFD2_FDFECR_EI10	(CPG_CANFD2.unFDFECR.stcField.u1EI10)  /*@bf@*/
#define CPG_CANFD2_FDFECR_EI11	(CPG_CANFD2.unFDFECR.stcField.u1EI11)  /*@bf@*/
#define CPG_CANFD2_FDFECR_EI12	(CPG_CANFD2.unFDFECR.stcField.u1EI12)  /*@bf@*/
#define CPG_CANFD2_FDFECR_EI13	(CPG_CANFD2.unFDFECR.stcField.u1EI13)  /*@bf@*/
#define CPG_CANFD2_FDFECR_EI14	(CPG_CANFD2.unFDFECR.stcField.u1EI14)  /*@bf@*/
#define CPG_CANFD2_FDFECR_EI15	(CPG_CANFD2.unFDFECR.stcField.u1EI15)  /*@bf@*/
#define CPG_CANFD2_FDFECR_EY0	(CPG_CANFD2.unFDFECR.stcField.u1EY0)  /*@bf@*/
#define CPG_CANFD2_FDFECR_EY1	(CPG_CANFD2.unFDFECR.stcField.u1EY1)  /*@bf@*/
#define CPG_CANFD2_FDFECR_EY2	(CPG_CANFD2.unFDFECR.stcField.u1EY2)  /*@bf@*/
#define CPG_CANFD2_FDFECR_FERR	(CPG_CANFD2.unFDFECR.stcField.u1FERR)  /*@bf@*/

#define CPG_CANFD3_FDFECR	(CPG_CANFD3.unFDFECR.u32Register)  /*@rg@*/
#define CPG_CANFD3_FDFECR_EI0	(CPG_CANFD3.unFDFECR.stcField.u1EI0)  /*@bf@*/
#define CPG_CANFD3_FDFECR_EI1	(CPG_CANFD3.unFDFECR.stcField.u1EI1)  /*@bf@*/
#define CPG_CANFD3_FDFECR_EI2	(CPG_CANFD3.unFDFECR.stcField.u1EI2)  /*@bf@*/
#define CPG_CANFD3_FDFECR_EI3	(CPG_CANFD3.unFDFECR.stcField.u1EI3)  /*@bf@*/
#define CPG_CANFD3_FDFECR_EI4	(CPG_CANFD3.unFDFECR.stcField.u1EI4)  /*@bf@*/
#define CPG_CANFD3_FDFECR_EI5	(CPG_CANFD3.unFDFECR.stcField.u1EI5)  /*@bf@*/
#define CPG_CANFD3_FDFECR_EI6	(CPG_CANFD3.unFDFECR.stcField.u1EI6)  /*@bf@*/
#define CPG_CANFD3_FDFECR_EI7	(CPG_CANFD3.unFDFECR.stcField.u1EI7)  /*@bf@*/
#define CPG_CANFD3_FDFECR_EI8	(CPG_CANFD3.unFDFECR.stcField.u1EI8)  /*@bf@*/
#define CPG_CANFD3_FDFECR_EI9	(CPG_CANFD3.unFDFECR.stcField.u1EI9)  /*@bf@*/
#define CPG_CANFD3_FDFECR_EI10	(CPG_CANFD3.unFDFECR.stcField.u1EI10)  /*@bf@*/
#define CPG_CANFD3_FDFECR_EI11	(CPG_CANFD3.unFDFECR.stcField.u1EI11)  /*@bf@*/
#define CPG_CANFD3_FDFECR_EI12	(CPG_CANFD3.unFDFECR.stcField.u1EI12)  /*@bf@*/
#define CPG_CANFD3_FDFECR_EI13	(CPG_CANFD3.unFDFECR.stcField.u1EI13)  /*@bf@*/
#define CPG_CANFD3_FDFECR_EI14	(CPG_CANFD3.unFDFECR.stcField.u1EI14)  /*@bf@*/
#define CPG_CANFD3_FDFECR_EI15	(CPG_CANFD3.unFDFECR.stcField.u1EI15)  /*@bf@*/
#define CPG_CANFD3_FDFECR_EY0	(CPG_CANFD3.unFDFECR.stcField.u1EY0)  /*@bf@*/
#define CPG_CANFD3_FDFECR_EY1	(CPG_CANFD3.unFDFECR.stcField.u1EY1)  /*@bf@*/
#define CPG_CANFD3_FDFECR_EY2	(CPG_CANFD3.unFDFECR.stcField.u1EY2)  /*@bf@*/
#define CPG_CANFD3_FDFECR_FERR	(CPG_CANFD3.unFDFECR.stcField.u1FERR)  /*@bf@*/

typedef struct stc_cpg_canfdn_fdfecr_field{
    uint_io32_t		u1EI0:1;
    uint_io32_t		u1EI1:1;
    uint_io32_t		u1EI2:1;
    uint_io32_t		u1EI3:1;
    uint_io32_t		u1EI4:1;
    uint_io32_t		u1EI5:1;
    uint_io32_t		u1EI6:1;
    uint_io32_t		u1EI7:1;
    uint_io32_t		u1EI8:1;
    uint_io32_t		u1EI9:1;
    uint_io32_t		u1EI10:1;
    uint_io32_t		u1EI11:1;
    uint_io32_t		u1EI12:1;
    uint_io32_t		u1EI13:1;
    uint_io32_t		u1EI14:1;
    uint_io32_t		u1EI15:1;
    uint_io32_t		u1EY0:1;
    uint_io32_t		u1EY1:1;
    uint_io32_t		u1EY2:1;
    uint_io32_t		:12;
    uint_io32_t		u1FERR:1;
}stc_cpg_canfdn_fdfecr_field_t;

typedef union un_cpg_canfdn_fdfecr{
    uint_io32_t		u32Register;
    stc_cpg_canfdn_fdfecr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_cpg_canfdn_fdfecr_t;

/* TSCNTR */
#define CPG_CANFD0_TSCNTR	(CPG_CANFD0.unTSCNTR.u16Register)  /*@rg@*/
#define CPG_CANFD0_TSCNTR_CCLR	(CPG_CANFD0.unTSCNTR.stcField.u1CCLR)  /*@bf@*/

#define CPG_CANFD1_TSCNTR	(CPG_CANFD1.unTSCNTR.u16Register)  /*@rg@*/
#define CPG_CANFD1_TSCNTR_CCLR	(CPG_CANFD1.unTSCNTR.stcField.u1CCLR)  /*@bf@*/

#define CPG_CANFD2_TSCNTR	(CPG_CANFD2.unTSCNTR.u16Register)  /*@rg@*/
#define CPG_CANFD2_TSCNTR_CCLR	(CPG_CANFD2.unTSCNTR.stcField.u1CCLR)  /*@bf@*/

#define CPG_CANFD3_TSCNTR	(CPG_CANFD3.unTSCNTR.u16Register)  /*@rg@*/
#define CPG_CANFD3_TSCNTR_CCLR	(CPG_CANFD3.unTSCNTR.stcField.u1CCLR)  /*@bf@*/

typedef struct stc_cpg_canfdn_tscntr_field{
    uint_io16_t		u1CCLR:1;
    uint_io16_t		:15;
}stc_cpg_canfdn_tscntr_field_t;

typedef union un_cpg_canfdn_tscntr{
    uint_io16_t		u16Register;
    stc_cpg_canfdn_tscntr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_canfdn_tscntr_t;

/* TSMDR */
#define CPG_CANFD0_TSMDR	(CPG_CANFD0.unTSMDR.u16Register)  /*@rg@*/
#define CPG_CANFD0_TSMDR_CNTEN	(CPG_CANFD0.unTSMDR.stcField.u1CNTEN)  /*@bf@*/

#define CPG_CANFD1_TSMDR	(CPG_CANFD1.unTSMDR.u16Register)  /*@rg@*/
#define CPG_CANFD1_TSMDR_CNTEN	(CPG_CANFD1.unTSMDR.stcField.u1CNTEN)  /*@bf@*/

#define CPG_CANFD2_TSMDR	(CPG_CANFD2.unTSMDR.u16Register)  /*@rg@*/
#define CPG_CANFD2_TSMDR_CNTEN	(CPG_CANFD2.unTSMDR.stcField.u1CNTEN)  /*@bf@*/

#define CPG_CANFD3_TSMDR	(CPG_CANFD3.unTSMDR.u16Register)  /*@rg@*/
#define CPG_CANFD3_TSMDR_CNTEN	(CPG_CANFD3.unTSMDR.stcField.u1CNTEN)  /*@bf@*/

typedef struct stc_cpg_canfdn_tsmdr_field{
    uint_io16_t		u1CNTEN:1;
    uint_io16_t		:15;
}stc_cpg_canfdn_tsmdr_field_t;

typedef union un_cpg_canfdn_tsmdr{
    uint_io16_t		u16Register;
    stc_cpg_canfdn_tsmdr_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_cpg_canfdn_tsmdr_t;

/* TSDIVR_L */
#define CPG_CANFD0_TSDIVR_L	(CPG_CANFD0.unTSDIVR_L.u16Register)  /*@rg@*/
#define CPG_CANFD0_TSDIVR_L_CDIV	CPG_CANFD0_TSDIVR_L  /*@bfrg@*/

#define CPG_CANFD1_TSDIVR_L	(CPG_CANFD1.unTSDIVR_L.u16Register)  /*@rg@*/
#define CPG_CANFD1_TSDIVR_L_CDIV	CPG_CANFD1_TSDIVR_L  /*@bfrg@*/

#define CPG_CANFD2_TSDIVR_L	(CPG_CANFD2.unTSDIVR_L.u16Register)  /*@rg@*/
#define CPG_CANFD2_TSDIVR_L_CDIV	CPG_CANFD2_TSDIVR_L  /*@bfrg@*/

#define CPG_CANFD3_TSDIVR_L	(CPG_CANFD3.unTSDIVR_L.u16Register)  /*@rg@*/
#define CPG_CANFD3_TSDIVR_L_CDIV	CPG_CANFD3_TSDIVR_L  /*@bfrg@*/

typedef union un_cpg_canfdn_tsdivr_l{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_cpg_canfdn_tsdivr_l_t;

/* TSCDTR */
#define CPG_CANFD0_TSCDTR	(CPG_CANFD0.unTSCDTR.u16Register)  /*@rg@*/
#define CPG_CANFD0_TSCDTR_CNT	CPG_CANFD0_TSCDTR  /*@bfrg@*/

#define CPG_CANFD1_TSCDTR	(CPG_CANFD1.unTSCDTR.u16Register)  /*@rg@*/
#define CPG_CANFD1_TSCDTR_CNT	CPG_CANFD1_TSCDTR  /*@bfrg@*/

#define CPG_CANFD2_TSCDTR	(CPG_CANFD2.unTSCDTR.u16Register)  /*@rg@*/
#define CPG_CANFD2_TSCDTR_CNT	CPG_CANFD2_TSCDTR  /*@bfrg@*/

#define CPG_CANFD3_TSCDTR	(CPG_CANFD3.unTSCDTR.u16Register)  /*@rg@*/
#define CPG_CANFD3_TSCDTR_CNT	CPG_CANFD3_TSCDTR  /*@bfrg@*/

typedef union un_cpg_canfdn_tscdtr{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_cpg_canfdn_tscdtr_t;

/* TSCPCLR */
#define CPG_CANFD0_TSCPCLR	(CPG_CANFD0.unTSCPCLR.u16Register)  /*@rg@*/
#define CPG_CANFD0_TSCPCLR_CMP	CPG_CANFD0_TSCPCLR  /*@bfrg@*/

#define CPG_CANFD1_TSCPCLR	(CPG_CANFD1.unTSCPCLR.u16Register)  /*@rg@*/
#define CPG_CANFD1_TSCPCLR_CMP	CPG_CANFD1_TSCPCLR  /*@bfrg@*/

#define CPG_CANFD2_TSCPCLR	(CPG_CANFD2.unTSCPCLR.u16Register)  /*@rg@*/
#define CPG_CANFD2_TSCPCLR_CMP	CPG_CANFD2_TSCPCLR  /*@bfrg@*/

#define CPG_CANFD3_TSCPCLR	(CPG_CANFD3.unTSCPCLR.u16Register)  /*@rg@*/
#define CPG_CANFD3_TSCPCLR_CMP	CPG_CANFD3_TSCPCLR  /*@bfrg@*/

typedef union un_cpg_canfdn_tscpclr{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_cpg_canfdn_tscpclr_t;


typedef struct stc_cpg_canfdn{
    un_cpg_canfdn_crel_t	unCREL;	/* 0x00000000 */
    un_cpg_canfdn_endn_t	unENDN;	/* 0x00000004 */
    uint_io8_t	au8Reserved0[4];	/* 0x00000008 */
    un_cpg_canfdn_dbtp_t	unDBTP;	/* 0x0000000C */
    un_cpg_canfdn_test_t	unTEST;	/* 0x00000010 */
    un_cpg_canfdn_rwd_t	unRWD;	/* 0x00000014 */
    un_cpg_canfdn_cccr_t	unCCCR;	/* 0x00000018 */
    un_cpg_canfdn_nbtp_t	unNBTP;	/* 0x0000001C */
    un_cpg_canfdn_tscc_t	unTSCC;	/* 0x00000020 */
    un_cpg_canfdn_tscv_t	unTSCV;	/* 0x00000024 */
    un_cpg_canfdn_tocc_t	unTOCC;	/* 0x00000028 */
    un_cpg_canfdn_tocv_t	unTOCV;	/* 0x0000002C */
    uint_io8_t	au8Reserved1[16];	/* 0x00000030 */
    un_cpg_canfdn_ecr_t	unECR;	/* 0x00000040 */
    un_cpg_canfdn_psr_t	unPSR;	/* 0x00000044 */
    un_cpg_canfdn_tdcr_t	unTDCR;	/* 0x00000048 */
    uint_io8_t	au8Reserved2[4];	/* 0x0000004C */
    un_cpg_canfdn_ir_t	unIR;	/* 0x00000050 */
    un_cpg_canfdn_ie_t	unIE;	/* 0x00000054 */
    un_cpg_canfdn_ils_t	unILS;	/* 0x00000058 */
    un_cpg_canfdn_ile_t	unILE;	/* 0x0000005C */
    uint_io8_t	au8Reserved3[32];	/* 0x00000060 */
    un_cpg_canfdn_gfc_t	unGFC;	/* 0x00000080 */
    un_cpg_canfdn_sidfc_t	unSIDFC;	/* 0x00000084 */
    un_cpg_canfdn_xidfc_t	unXIDFC;	/* 0x00000088 */
    uint_io8_t	au8Reserved4[4];	/* 0x0000008C */
    un_cpg_canfdn_xidam_t	unXIDAM;	/* 0x00000090 */
    un_cpg_canfdn_hpms_t	unHPMS;	/* 0x00000094 */
    un_cpg_canfdn_ndat1_t	unNDAT1;	/* 0x00000098 */
    un_cpg_canfdn_ndat2_t	unNDAT2;	/* 0x0000009C */
    un_cpg_canfdn_rxf0c_t	unRXF0C;	/* 0x000000A0 */
    un_cpg_canfdn_rxf0s_t	unRXF0S;	/* 0x000000A4 */
    un_cpg_canfdn_rxf0a_t	unRXF0A;	/* 0x000000A8 */
    un_cpg_canfdn_rxbc_t	unRXBC;	/* 0x000000AC */
    un_cpg_canfdn_rxf1c_t	unRXF1C;	/* 0x000000B0 */
    un_cpg_canfdn_rxf1s_t	unRXF1S;	/* 0x000000B4 */
    un_cpg_canfdn_rxf1a_t	unRXF1A;	/* 0x000000B8 */
    un_cpg_canfdn_rxesc_t	unRXESC;	/* 0x000000BC */
    un_cpg_canfdn_txbc_t	unTXBC;	/* 0x000000C0 */
    un_cpg_canfdn_txfqs_t	unTXFQS;	/* 0x000000C4 */
    un_cpg_canfdn_txesc_t	unTXESC;	/* 0x000000C8 */
    un_cpg_canfdn_txbrp_t	unTXBRP;	/* 0x000000CC */
    un_cpg_canfdn_txbar_t	unTXBAR;	/* 0x000000D0 */
    un_cpg_canfdn_txbcr_t	unTXBCR;	/* 0x000000D4 */
    un_cpg_canfdn_txbto_t	unTXBTO;	/* 0x000000D8 */
    un_cpg_canfdn_txbcf_t	unTXBCF;	/* 0x000000DC */
    un_cpg_canfdn_txbtie_t	unTXBTIE;	/* 0x000000E0 */
    un_cpg_canfdn_txbcie_t	unTXBCIE;	/* 0x000000E4 */
    uint_io8_t	au8Reserved5[8];	/* 0x000000E8 */
    un_cpg_canfdn_txefc_t	unTXEFC;	/* 0x000000F0 */
    un_cpg_canfdn_txefs_t	unTXEFS;	/* 0x000000F4 */
    un_cpg_canfdn_txefa_t	unTXEFA;	/* 0x000000F8 */
    uint_io8_t	au8Reserved6[260];	/* 0x000000FC */
    un_cpg_canfdn_fdecr_t	unFDECR;	/* 0x00000200 */
    un_cpg_canfdn_fdesr_t	unFDESR;	/* 0x00000201 */
    un_cpg_canfdn_fdsear_t	unFDSEAR;	/* 0x00000202 */
    uint_io8_t	au8Reserved7[1];	/* 0x00000204 */
    un_cpg_canfdn_fdescr_t	unFDESCR;	/* 0x00000205 */
    un_cpg_canfdn_fddear_t	unFDDEAR;	/* 0x00000206 */
    un_cpg_canfdn_fdfecr_t	unFDFECR;	/* 0x00000208 */
    uint_io8_t	au8Reserved8[244];	/* 0x0000020C */
    un_cpg_canfdn_tscntr_t	unTSCNTR;	/* 0x00000300 */
    un_cpg_canfdn_tsmdr_t	unTSMDR;	/* 0x00000302 */
    un_cpg_canfdn_tsdivr_l_t	unTSDIVR_L;	/* 0x00000304 */
    uint_io8_t	au8Reserved9[2];	/* 0x00000306 */
    un_cpg_canfdn_tscdtr_t	unTSCDTR;	/* 0x00000308 */
    un_cpg_canfdn_tscpclr_t	unTSCPCLR;	/* 0x0000030A */
    uint_io8_t	au8Reserved10[64756];	/* 0x0000030C */
}stc_cpg_canfdn_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_cpg_canfdn_t	stcCPG_CANFD[4];
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 65536(0x10000) bytes */


#endif /* __S6J3360_CANFD_H */
