/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_FRT_H
#define __S6J3360_FRT_H

#include "s6j3360io_basetypes.h"

/* FRT[00-04/08-10] base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define FRT00	stcFRT[0]
#define FRT01	stcFRT[1]
#define FRT02	stcFRT[2]
#define FRT03	stcFRT[3]
#define FRT04	stcFRT[4]
#define FRT08	stcFRT[5]
#define FRT09	stcFRT[6]
#define FRT10	stcFRT[7]
#else /* __IO_DEFINE */
#define FRT00	(*((volatile stc_frtn_t*)0xB4820000))
#define FRT01	(*((volatile stc_frtn_t*)0xB4820400))
#define FRT02	(*((volatile stc_frtn_t*)0xB4820800))
#define FRT03	(*((volatile stc_frtn_t*)0xB4820C00))
#define FRT04	(*((volatile stc_frtn_t*)0xB4821000))
#define FRT08	(*((volatile stc_frtn_t*)0xB48A0000))
#define FRT09	(*((volatile stc_frtn_t*)0xB48A0400))
#define FRT10	(*((volatile stc_frtn_t*)0xB48A0800))
#endif /* __IO_DEFINE */

/* CPCLRB */
#define FRT00_CPCLRB	(FRT00.unCPCLRB.u32Register)  /*@rg@*/
#define FRT00_CPCLR	(FRT00_CPCLRB)  /*@rg2@*/
#define FRT00_CPCLRB_CL	FRT00_CPCLRB  /*@bfrg@*/
#define FRT00_CPCLR_CL	FRT00_CPCLRB_CL  /*@bf2@*/

#define FRT01_CPCLRB	(FRT01.unCPCLRB.u32Register)  /*@rg@*/
#define FRT01_CPCLR	(FRT01_CPCLRB)  /*@rg2@*/
#define FRT01_CPCLRB_CL	FRT01_CPCLRB  /*@bfrg@*/
#define FRT01_CPCLR_CL	FRT01_CPCLRB_CL  /*@bf2@*/

#define FRT02_CPCLRB	(FRT02.unCPCLRB.u32Register)  /*@rg@*/
#define FRT02_CPCLR	(FRT02_CPCLRB)  /*@rg2@*/
#define FRT02_CPCLRB_CL	FRT02_CPCLRB  /*@bfrg@*/
#define FRT02_CPCLR_CL	FRT02_CPCLRB_CL  /*@bf2@*/

#define FRT03_CPCLRB	(FRT03.unCPCLRB.u32Register)  /*@rg@*/
#define FRT03_CPCLR	(FRT03_CPCLRB)  /*@rg2@*/
#define FRT03_CPCLRB_CL	FRT03_CPCLRB  /*@bfrg@*/
#define FRT03_CPCLR_CL	FRT03_CPCLRB_CL  /*@bf2@*/

#define FRT04_CPCLRB	(FRT04.unCPCLRB.u32Register)  /*@rg@*/
#define FRT04_CPCLR	(FRT04_CPCLRB)  /*@rg2@*/
#define FRT04_CPCLRB_CL	FRT04_CPCLRB  /*@bfrg@*/
#define FRT04_CPCLR_CL	FRT04_CPCLRB_CL  /*@bf2@*/

#define FRT08_CPCLRB	(FRT08.unCPCLRB.u32Register)  /*@rg@*/
#define FRT08_CPCLR	(FRT08_CPCLRB)  /*@rg2@*/
#define FRT08_CPCLRB_CL	FRT08_CPCLRB  /*@bfrg@*/
#define FRT08_CPCLR_CL	FRT08_CPCLRB_CL  /*@bf2@*/

#define FRT09_CPCLRB	(FRT09.unCPCLRB.u32Register)  /*@rg@*/
#define FRT09_CPCLR	(FRT09_CPCLRB)  /*@rg2@*/
#define FRT09_CPCLRB_CL	FRT09_CPCLRB  /*@bfrg@*/
#define FRT09_CPCLR_CL	FRT09_CPCLRB_CL  /*@bf2@*/

#define FRT10_CPCLRB	(FRT10.unCPCLRB.u32Register)  /*@rg@*/
#define FRT10_CPCLR	(FRT10_CPCLRB)  /*@rg2@*/
#define FRT10_CPCLRB_CL	FRT10_CPCLRB  /*@bfrg@*/
#define FRT10_CPCLR_CL	FRT10_CPCLRB_CL  /*@bf2@*/

typedef union un_frtn_cpclrb{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_frtn_cpclrb_t;

/* TCDT */
#define FRT00_TCDT	(FRT00.unTCDT.u32Register)  /*@rg@*/
#define FRT00_TCDT_T	FRT00_TCDT  /*@bfrg@*/

#define FRT01_TCDT	(FRT01.unTCDT.u32Register)  /*@rg@*/
#define FRT01_TCDT_T	FRT01_TCDT  /*@bfrg@*/

#define FRT02_TCDT	(FRT02.unTCDT.u32Register)  /*@rg@*/
#define FRT02_TCDT_T	FRT02_TCDT  /*@bfrg@*/

#define FRT03_TCDT	(FRT03.unTCDT.u32Register)  /*@rg@*/
#define FRT03_TCDT_T	FRT03_TCDT  /*@bfrg@*/

#define FRT04_TCDT	(FRT04.unTCDT.u32Register)  /*@rg@*/
#define FRT04_TCDT_T	FRT04_TCDT  /*@bfrg@*/

#define FRT08_TCDT	(FRT08.unTCDT.u32Register)  /*@rg@*/
#define FRT08_TCDT_T	FRT08_TCDT  /*@bfrg@*/

#define FRT09_TCDT	(FRT09.unTCDT.u32Register)  /*@rg@*/
#define FRT09_TCDT_T	FRT09_TCDT  /*@bfrg@*/

#define FRT10_TCDT	(FRT10.unTCDT.u32Register)  /*@rg@*/
#define FRT10_TCDT_T	FRT10_TCDT  /*@bfrg@*/

typedef union un_frtn_tcdt{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_frtn_tcdt_t;

/* TCCS */
#define FRT00_TCCS	(FRT00.unTCCS.u32Register)  /*@rg@*/
#define FRT00_TCCS_CLK	(FRT00.unTCCS.stcField.u4CLK)  /*@bf@*/
#define FRT00_TCCS_SCLR	(FRT00.unTCCS.stcField.u1SCLR)  /*@bf@*/
#define FRT00_TCCS_MODE	(FRT00.unTCCS.stcField.u1MODE)  /*@bf@*/
#define FRT00_TCCS_STOP	(FRT00.unTCCS.stcField.u1STOP)  /*@bf@*/
#define FRT00_TCCS_BFE	(FRT00.unTCCS.stcField.u1BFE)  /*@bf@*/
#define FRT00_TCCS_ICRE	(FRT00.unTCCS.stcField.u1ICRE)  /*@bf@*/
#define FRT00_TCCS_ICLR	(FRT00.unTCCS.stcField.u1ICLR)  /*@bf@*/
#define FRT00_TCCS_MSI	(FRT00.unTCCS.stcField.u3MSI)  /*@bf@*/
#define FRT00_TCCS_IRQZE	(FRT00.unTCCS.stcField.u1IRQZE)  /*@bf@*/
#define FRT00_TCCS_IRQZF	(FRT00.unTCCS.stcField.u1IRQZF)  /*@bf@*/
#define FRT00_TCCS_ECKE	(FRT00.unTCCS.stcField.u1ECKE)  /*@bf@*/

#define FRT01_TCCS	(FRT01.unTCCS.u32Register)  /*@rg@*/
#define FRT01_TCCS_CLK	(FRT01.unTCCS.stcField.u4CLK)  /*@bf@*/
#define FRT01_TCCS_SCLR	(FRT01.unTCCS.stcField.u1SCLR)  /*@bf@*/
#define FRT01_TCCS_MODE	(FRT01.unTCCS.stcField.u1MODE)  /*@bf@*/
#define FRT01_TCCS_STOP	(FRT01.unTCCS.stcField.u1STOP)  /*@bf@*/
#define FRT01_TCCS_BFE	(FRT01.unTCCS.stcField.u1BFE)  /*@bf@*/
#define FRT01_TCCS_ICRE	(FRT01.unTCCS.stcField.u1ICRE)  /*@bf@*/
#define FRT01_TCCS_ICLR	(FRT01.unTCCS.stcField.u1ICLR)  /*@bf@*/
#define FRT01_TCCS_MSI	(FRT01.unTCCS.stcField.u3MSI)  /*@bf@*/
#define FRT01_TCCS_IRQZE	(FRT01.unTCCS.stcField.u1IRQZE)  /*@bf@*/
#define FRT01_TCCS_IRQZF	(FRT01.unTCCS.stcField.u1IRQZF)  /*@bf@*/
#define FRT01_TCCS_ECKE	(FRT01.unTCCS.stcField.u1ECKE)  /*@bf@*/

#define FRT02_TCCS	(FRT02.unTCCS.u32Register)  /*@rg@*/
#define FRT02_TCCS_CLK	(FRT02.unTCCS.stcField.u4CLK)  /*@bf@*/
#define FRT02_TCCS_SCLR	(FRT02.unTCCS.stcField.u1SCLR)  /*@bf@*/
#define FRT02_TCCS_MODE	(FRT02.unTCCS.stcField.u1MODE)  /*@bf@*/
#define FRT02_TCCS_STOP	(FRT02.unTCCS.stcField.u1STOP)  /*@bf@*/
#define FRT02_TCCS_BFE	(FRT02.unTCCS.stcField.u1BFE)  /*@bf@*/
#define FRT02_TCCS_ICRE	(FRT02.unTCCS.stcField.u1ICRE)  /*@bf@*/
#define FRT02_TCCS_ICLR	(FRT02.unTCCS.stcField.u1ICLR)  /*@bf@*/
#define FRT02_TCCS_MSI	(FRT02.unTCCS.stcField.u3MSI)  /*@bf@*/
#define FRT02_TCCS_IRQZE	(FRT02.unTCCS.stcField.u1IRQZE)  /*@bf@*/
#define FRT02_TCCS_IRQZF	(FRT02.unTCCS.stcField.u1IRQZF)  /*@bf@*/
#define FRT02_TCCS_ECKE	(FRT02.unTCCS.stcField.u1ECKE)  /*@bf@*/

#define FRT03_TCCS	(FRT03.unTCCS.u32Register)  /*@rg@*/
#define FRT03_TCCS_CLK	(FRT03.unTCCS.stcField.u4CLK)  /*@bf@*/
#define FRT03_TCCS_SCLR	(FRT03.unTCCS.stcField.u1SCLR)  /*@bf@*/
#define FRT03_TCCS_MODE	(FRT03.unTCCS.stcField.u1MODE)  /*@bf@*/
#define FRT03_TCCS_STOP	(FRT03.unTCCS.stcField.u1STOP)  /*@bf@*/
#define FRT03_TCCS_BFE	(FRT03.unTCCS.stcField.u1BFE)  /*@bf@*/
#define FRT03_TCCS_ICRE	(FRT03.unTCCS.stcField.u1ICRE)  /*@bf@*/
#define FRT03_TCCS_ICLR	(FRT03.unTCCS.stcField.u1ICLR)  /*@bf@*/
#define FRT03_TCCS_MSI	(FRT03.unTCCS.stcField.u3MSI)  /*@bf@*/
#define FRT03_TCCS_IRQZE	(FRT03.unTCCS.stcField.u1IRQZE)  /*@bf@*/
#define FRT03_TCCS_IRQZF	(FRT03.unTCCS.stcField.u1IRQZF)  /*@bf@*/
#define FRT03_TCCS_ECKE	(FRT03.unTCCS.stcField.u1ECKE)  /*@bf@*/

#define FRT04_TCCS	(FRT04.unTCCS.u32Register)  /*@rg@*/
#define FRT04_TCCS_CLK	(FRT04.unTCCS.stcField.u4CLK)  /*@bf@*/
#define FRT04_TCCS_SCLR	(FRT04.unTCCS.stcField.u1SCLR)  /*@bf@*/
#define FRT04_TCCS_MODE	(FRT04.unTCCS.stcField.u1MODE)  /*@bf@*/
#define FRT04_TCCS_STOP	(FRT04.unTCCS.stcField.u1STOP)  /*@bf@*/
#define FRT04_TCCS_BFE	(FRT04.unTCCS.stcField.u1BFE)  /*@bf@*/
#define FRT04_TCCS_ICRE	(FRT04.unTCCS.stcField.u1ICRE)  /*@bf@*/
#define FRT04_TCCS_ICLR	(FRT04.unTCCS.stcField.u1ICLR)  /*@bf@*/
#define FRT04_TCCS_MSI	(FRT04.unTCCS.stcField.u3MSI)  /*@bf@*/
#define FRT04_TCCS_IRQZE	(FRT04.unTCCS.stcField.u1IRQZE)  /*@bf@*/
#define FRT04_TCCS_IRQZF	(FRT04.unTCCS.stcField.u1IRQZF)  /*@bf@*/
#define FRT04_TCCS_ECKE	(FRT04.unTCCS.stcField.u1ECKE)  /*@bf@*/

#define FRT08_TCCS	(FRT08.unTCCS.u32Register)  /*@rg@*/
#define FRT08_TCCS_CLK	(FRT08.unTCCS.stcField.u4CLK)  /*@bf@*/
#define FRT08_TCCS_SCLR	(FRT08.unTCCS.stcField.u1SCLR)  /*@bf@*/
#define FRT08_TCCS_MODE	(FRT08.unTCCS.stcField.u1MODE)  /*@bf@*/
#define FRT08_TCCS_STOP	(FRT08.unTCCS.stcField.u1STOP)  /*@bf@*/
#define FRT08_TCCS_BFE	(FRT08.unTCCS.stcField.u1BFE)  /*@bf@*/
#define FRT08_TCCS_ICRE	(FRT08.unTCCS.stcField.u1ICRE)  /*@bf@*/
#define FRT08_TCCS_ICLR	(FRT08.unTCCS.stcField.u1ICLR)  /*@bf@*/
#define FRT08_TCCS_MSI	(FRT08.unTCCS.stcField.u3MSI)  /*@bf@*/
#define FRT08_TCCS_IRQZE	(FRT08.unTCCS.stcField.u1IRQZE)  /*@bf@*/
#define FRT08_TCCS_IRQZF	(FRT08.unTCCS.stcField.u1IRQZF)  /*@bf@*/
#define FRT08_TCCS_ECKE	(FRT08.unTCCS.stcField.u1ECKE)  /*@bf@*/

#define FRT09_TCCS	(FRT09.unTCCS.u32Register)  /*@rg@*/
#define FRT09_TCCS_CLK	(FRT09.unTCCS.stcField.u4CLK)  /*@bf@*/
#define FRT09_TCCS_SCLR	(FRT09.unTCCS.stcField.u1SCLR)  /*@bf@*/
#define FRT09_TCCS_MODE	(FRT09.unTCCS.stcField.u1MODE)  /*@bf@*/
#define FRT09_TCCS_STOP	(FRT09.unTCCS.stcField.u1STOP)  /*@bf@*/
#define FRT09_TCCS_BFE	(FRT09.unTCCS.stcField.u1BFE)  /*@bf@*/
#define FRT09_TCCS_ICRE	(FRT09.unTCCS.stcField.u1ICRE)  /*@bf@*/
#define FRT09_TCCS_ICLR	(FRT09.unTCCS.stcField.u1ICLR)  /*@bf@*/
#define FRT09_TCCS_MSI	(FRT09.unTCCS.stcField.u3MSI)  /*@bf@*/
#define FRT09_TCCS_IRQZE	(FRT09.unTCCS.stcField.u1IRQZE)  /*@bf@*/
#define FRT09_TCCS_IRQZF	(FRT09.unTCCS.stcField.u1IRQZF)  /*@bf@*/
#define FRT09_TCCS_ECKE	(FRT09.unTCCS.stcField.u1ECKE)  /*@bf@*/

#define FRT10_TCCS	(FRT10.unTCCS.u32Register)  /*@rg@*/
#define FRT10_TCCS_CLK	(FRT10.unTCCS.stcField.u4CLK)  /*@bf@*/
#define FRT10_TCCS_SCLR	(FRT10.unTCCS.stcField.u1SCLR)  /*@bf@*/
#define FRT10_TCCS_MODE	(FRT10.unTCCS.stcField.u1MODE)  /*@bf@*/
#define FRT10_TCCS_STOP	(FRT10.unTCCS.stcField.u1STOP)  /*@bf@*/
#define FRT10_TCCS_BFE	(FRT10.unTCCS.stcField.u1BFE)  /*@bf@*/
#define FRT10_TCCS_ICRE	(FRT10.unTCCS.stcField.u1ICRE)  /*@bf@*/
#define FRT10_TCCS_ICLR	(FRT10.unTCCS.stcField.u1ICLR)  /*@bf@*/
#define FRT10_TCCS_MSI	(FRT10.unTCCS.stcField.u3MSI)  /*@bf@*/
#define FRT10_TCCS_IRQZE	(FRT10.unTCCS.stcField.u1IRQZE)  /*@bf@*/
#define FRT10_TCCS_IRQZF	(FRT10.unTCCS.stcField.u1IRQZF)  /*@bf@*/
#define FRT10_TCCS_ECKE	(FRT10.unTCCS.stcField.u1ECKE)  /*@bf@*/

typedef struct stc_frtn_tccs_field{
    uint_io32_t		u4CLK:4;
    uint_io32_t		u1SCLR:1;
    uint_io32_t		u1MODE:1;
    uint_io32_t		u1STOP:1;
    uint_io32_t		u1BFE:1;
    uint_io32_t		u1ICRE:1;
    uint_io32_t		u1ICLR:1;
    uint_io32_t		u3MSI:3;
    uint_io32_t		u1IRQZE:1;
    uint_io32_t		u1IRQZF:1;
    uint_io32_t		u1ECKE:1;
    uint_io32_t		:16;
}stc_frtn_tccs_field_t;

typedef union un_frtn_tccs{
    uint_io32_t		u32Register;
    stc_frtn_tccs_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_frtn_tccs_t;

/* TECCS */
#define FRT00_TECCS	(FRT00.unTECCS.u32Register)  /*@rg@*/
#define FRT00_TECCS_MSI	(FRT00.unTECCS.stcField.u3MSI)  /*@bf@*/
#define FRT00_TECCS_MODE2	(FRT00.unTECCS.stcField.u1MODE2)  /*@bf@*/

#define FRT01_TECCS	(FRT01.unTECCS.u32Register)  /*@rg@*/
#define FRT01_TECCS_MSI	(FRT01.unTECCS.stcField.u3MSI)  /*@bf@*/
#define FRT01_TECCS_MODE2	(FRT01.unTECCS.stcField.u1MODE2)  /*@bf@*/

#define FRT02_TECCS	(FRT02.unTECCS.u32Register)  /*@rg@*/
#define FRT02_TECCS_MSI	(FRT02.unTECCS.stcField.u3MSI)  /*@bf@*/
#define FRT02_TECCS_MODE2	(FRT02.unTECCS.stcField.u1MODE2)  /*@bf@*/

#define FRT03_TECCS	(FRT03.unTECCS.u32Register)  /*@rg@*/
#define FRT03_TECCS_MSI	(FRT03.unTECCS.stcField.u3MSI)  /*@bf@*/
#define FRT03_TECCS_MODE2	(FRT03.unTECCS.stcField.u1MODE2)  /*@bf@*/

#define FRT04_TECCS	(FRT04.unTECCS.u32Register)  /*@rg@*/
#define FRT04_TECCS_MSI	(FRT04.unTECCS.stcField.u3MSI)  /*@bf@*/
#define FRT04_TECCS_MODE2	(FRT04.unTECCS.stcField.u1MODE2)  /*@bf@*/

#define FRT08_TECCS	(FRT08.unTECCS.u32Register)  /*@rg@*/
#define FRT08_TECCS_MSI	(FRT08.unTECCS.stcField.u3MSI)  /*@bf@*/
#define FRT08_TECCS_MODE2	(FRT08.unTECCS.stcField.u1MODE2)  /*@bf@*/

#define FRT09_TECCS	(FRT09.unTECCS.u32Register)  /*@rg@*/
#define FRT09_TECCS_MSI	(FRT09.unTECCS.stcField.u3MSI)  /*@bf@*/
#define FRT09_TECCS_MODE2	(FRT09.unTECCS.stcField.u1MODE2)  /*@bf@*/

#define FRT10_TECCS	(FRT10.unTECCS.u32Register)  /*@rg@*/
#define FRT10_TECCS_MSI	(FRT10.unTECCS.stcField.u3MSI)  /*@bf@*/
#define FRT10_TECCS_MODE2	(FRT10.unTECCS.stcField.u1MODE2)  /*@bf@*/

typedef struct stc_frtn_teccs_field{
    uint_io32_t		:8;
    uint_io32_t		u3MSI:3;
    uint_io32_t		u1MODE2:1;
    uint_io32_t		:20;
}stc_frtn_teccs_field_t;

typedef union un_frtn_teccs{
    uint_io32_t		u32Register;
    stc_frtn_teccs_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_frtn_teccs_t;

/* TCCSC */
#define FRT00_TCCSC	(FRT00.unTCCSC.u32Register)  /*@rg@*/
#define FRT00_TCCSC_MODEC	(FRT00.unTCCSC.stcField.u1MODEC)  /*@bf@*/
#define FRT00_TCCSC_STOPC	(FRT00.unTCCSC.stcField.u1STOPC)  /*@bf@*/
#define FRT00_TCCSC_BFEC	(FRT00.unTCCSC.stcField.u1BFEC)  /*@bf@*/
#define FRT00_TCCSC_ICREC	(FRT00.unTCCSC.stcField.u1ICREC)  /*@bf@*/
#define FRT00_TCCSC_ICLRC	(FRT00.unTCCSC.stcField.u1ICLRC)  /*@bf@*/
#define FRT00_TCCSC_IRQZEC	(FRT00.unTCCSC.stcField.u1IRQZEC)  /*@bf@*/
#define FRT00_TCCSC_IRQZFC	(FRT00.unTCCSC.stcField.u1IRQZFC)  /*@bf@*/
#define FRT00_TCCSC_ECKEC	(FRT00.unTCCSC.stcField.u1ECKEC)  /*@bf@*/

#define FRT01_TCCSC	(FRT01.unTCCSC.u32Register)  /*@rg@*/
#define FRT01_TCCSC_MODEC	(FRT01.unTCCSC.stcField.u1MODEC)  /*@bf@*/
#define FRT01_TCCSC_STOPC	(FRT01.unTCCSC.stcField.u1STOPC)  /*@bf@*/
#define FRT01_TCCSC_BFEC	(FRT01.unTCCSC.stcField.u1BFEC)  /*@bf@*/
#define FRT01_TCCSC_ICREC	(FRT01.unTCCSC.stcField.u1ICREC)  /*@bf@*/
#define FRT01_TCCSC_ICLRC	(FRT01.unTCCSC.stcField.u1ICLRC)  /*@bf@*/
#define FRT01_TCCSC_IRQZEC	(FRT01.unTCCSC.stcField.u1IRQZEC)  /*@bf@*/
#define FRT01_TCCSC_IRQZFC	(FRT01.unTCCSC.stcField.u1IRQZFC)  /*@bf@*/
#define FRT01_TCCSC_ECKEC	(FRT01.unTCCSC.stcField.u1ECKEC)  /*@bf@*/

#define FRT02_TCCSC	(FRT02.unTCCSC.u32Register)  /*@rg@*/
#define FRT02_TCCSC_MODEC	(FRT02.unTCCSC.stcField.u1MODEC)  /*@bf@*/
#define FRT02_TCCSC_STOPC	(FRT02.unTCCSC.stcField.u1STOPC)  /*@bf@*/
#define FRT02_TCCSC_BFEC	(FRT02.unTCCSC.stcField.u1BFEC)  /*@bf@*/
#define FRT02_TCCSC_ICREC	(FRT02.unTCCSC.stcField.u1ICREC)  /*@bf@*/
#define FRT02_TCCSC_ICLRC	(FRT02.unTCCSC.stcField.u1ICLRC)  /*@bf@*/
#define FRT02_TCCSC_IRQZEC	(FRT02.unTCCSC.stcField.u1IRQZEC)  /*@bf@*/
#define FRT02_TCCSC_IRQZFC	(FRT02.unTCCSC.stcField.u1IRQZFC)  /*@bf@*/
#define FRT02_TCCSC_ECKEC	(FRT02.unTCCSC.stcField.u1ECKEC)  /*@bf@*/

#define FRT03_TCCSC	(FRT03.unTCCSC.u32Register)  /*@rg@*/
#define FRT03_TCCSC_MODEC	(FRT03.unTCCSC.stcField.u1MODEC)  /*@bf@*/
#define FRT03_TCCSC_STOPC	(FRT03.unTCCSC.stcField.u1STOPC)  /*@bf@*/
#define FRT03_TCCSC_BFEC	(FRT03.unTCCSC.stcField.u1BFEC)  /*@bf@*/
#define FRT03_TCCSC_ICREC	(FRT03.unTCCSC.stcField.u1ICREC)  /*@bf@*/
#define FRT03_TCCSC_ICLRC	(FRT03.unTCCSC.stcField.u1ICLRC)  /*@bf@*/
#define FRT03_TCCSC_IRQZEC	(FRT03.unTCCSC.stcField.u1IRQZEC)  /*@bf@*/
#define FRT03_TCCSC_IRQZFC	(FRT03.unTCCSC.stcField.u1IRQZFC)  /*@bf@*/
#define FRT03_TCCSC_ECKEC	(FRT03.unTCCSC.stcField.u1ECKEC)  /*@bf@*/

#define FRT04_TCCSC	(FRT04.unTCCSC.u32Register)  /*@rg@*/
#define FRT04_TCCSC_MODEC	(FRT04.unTCCSC.stcField.u1MODEC)  /*@bf@*/
#define FRT04_TCCSC_STOPC	(FRT04.unTCCSC.stcField.u1STOPC)  /*@bf@*/
#define FRT04_TCCSC_BFEC	(FRT04.unTCCSC.stcField.u1BFEC)  /*@bf@*/
#define FRT04_TCCSC_ICREC	(FRT04.unTCCSC.stcField.u1ICREC)  /*@bf@*/
#define FRT04_TCCSC_ICLRC	(FRT04.unTCCSC.stcField.u1ICLRC)  /*@bf@*/
#define FRT04_TCCSC_IRQZEC	(FRT04.unTCCSC.stcField.u1IRQZEC)  /*@bf@*/
#define FRT04_TCCSC_IRQZFC	(FRT04.unTCCSC.stcField.u1IRQZFC)  /*@bf@*/
#define FRT04_TCCSC_ECKEC	(FRT04.unTCCSC.stcField.u1ECKEC)  /*@bf@*/

#define FRT08_TCCSC	(FRT08.unTCCSC.u32Register)  /*@rg@*/
#define FRT08_TCCSC_MODEC	(FRT08.unTCCSC.stcField.u1MODEC)  /*@bf@*/
#define FRT08_TCCSC_STOPC	(FRT08.unTCCSC.stcField.u1STOPC)  /*@bf@*/
#define FRT08_TCCSC_BFEC	(FRT08.unTCCSC.stcField.u1BFEC)  /*@bf@*/
#define FRT08_TCCSC_ICREC	(FRT08.unTCCSC.stcField.u1ICREC)  /*@bf@*/
#define FRT08_TCCSC_ICLRC	(FRT08.unTCCSC.stcField.u1ICLRC)  /*@bf@*/
#define FRT08_TCCSC_IRQZEC	(FRT08.unTCCSC.stcField.u1IRQZEC)  /*@bf@*/
#define FRT08_TCCSC_IRQZFC	(FRT08.unTCCSC.stcField.u1IRQZFC)  /*@bf@*/
#define FRT08_TCCSC_ECKEC	(FRT08.unTCCSC.stcField.u1ECKEC)  /*@bf@*/

#define FRT09_TCCSC	(FRT09.unTCCSC.u32Register)  /*@rg@*/
#define FRT09_TCCSC_MODEC	(FRT09.unTCCSC.stcField.u1MODEC)  /*@bf@*/
#define FRT09_TCCSC_STOPC	(FRT09.unTCCSC.stcField.u1STOPC)  /*@bf@*/
#define FRT09_TCCSC_BFEC	(FRT09.unTCCSC.stcField.u1BFEC)  /*@bf@*/
#define FRT09_TCCSC_ICREC	(FRT09.unTCCSC.stcField.u1ICREC)  /*@bf@*/
#define FRT09_TCCSC_ICLRC	(FRT09.unTCCSC.stcField.u1ICLRC)  /*@bf@*/
#define FRT09_TCCSC_IRQZEC	(FRT09.unTCCSC.stcField.u1IRQZEC)  /*@bf@*/
#define FRT09_TCCSC_IRQZFC	(FRT09.unTCCSC.stcField.u1IRQZFC)  /*@bf@*/
#define FRT09_TCCSC_ECKEC	(FRT09.unTCCSC.stcField.u1ECKEC)  /*@bf@*/

#define FRT10_TCCSC	(FRT10.unTCCSC.u32Register)  /*@rg@*/
#define FRT10_TCCSC_MODEC	(FRT10.unTCCSC.stcField.u1MODEC)  /*@bf@*/
#define FRT10_TCCSC_STOPC	(FRT10.unTCCSC.stcField.u1STOPC)  /*@bf@*/
#define FRT10_TCCSC_BFEC	(FRT10.unTCCSC.stcField.u1BFEC)  /*@bf@*/
#define FRT10_TCCSC_ICREC	(FRT10.unTCCSC.stcField.u1ICREC)  /*@bf@*/
#define FRT10_TCCSC_ICLRC	(FRT10.unTCCSC.stcField.u1ICLRC)  /*@bf@*/
#define FRT10_TCCSC_IRQZEC	(FRT10.unTCCSC.stcField.u1IRQZEC)  /*@bf@*/
#define FRT10_TCCSC_IRQZFC	(FRT10.unTCCSC.stcField.u1IRQZFC)  /*@bf@*/
#define FRT10_TCCSC_ECKEC	(FRT10.unTCCSC.stcField.u1ECKEC)  /*@bf@*/

typedef struct stc_frtn_tccsc_field{
    uint_io32_t		:5;
    uint_io32_t		u1MODEC:1;
    uint_io32_t		u1STOPC:1;
    uint_io32_t		u1BFEC:1;
    uint_io32_t		u1ICREC:1;
    uint_io32_t		u1ICLRC:1;
    uint_io32_t		:3;
    uint_io32_t		u1IRQZEC:1;
    uint_io32_t		u1IRQZFC:1;
    uint_io32_t		u1ECKEC:1;
    uint_io32_t		:16;
}stc_frtn_tccsc_field_t;

typedef union un_frtn_tccsc{
    uint_io32_t		u32Register;
    stc_frtn_tccsc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_frtn_tccsc_t;

/* TCCSS */
#define FRT00_TCCSS	(FRT00.unTCCSS.u32Register)  /*@rg@*/
#define FRT00_TCCSS_SCLRS	(FRT00.unTCCSS.stcField.u1SCLRS)  /*@bf@*/
#define FRT00_TCCSS_MODES	(FRT00.unTCCSS.stcField.u1MODES)  /*@bf@*/
#define FRT00_TCCSS_STOPS	(FRT00.unTCCSS.stcField.u1STOPS)  /*@bf@*/
#define FRT00_TCCSS_BFES	(FRT00.unTCCSS.stcField.u1BFES)  /*@bf@*/
#define FRT00_TCCSS_ICRES	(FRT00.unTCCSS.stcField.u1ICRES)  /*@bf@*/
#define FRT00_TCCSS_IRQZES	(FRT00.unTCCSS.stcField.u1IRQZES)  /*@bf@*/
#define FRT00_TCCSS_ECKES	(FRT00.unTCCSS.stcField.u1ECKES)  /*@bf@*/

#define FRT01_TCCSS	(FRT01.unTCCSS.u32Register)  /*@rg@*/
#define FRT01_TCCSS_SCLRS	(FRT01.unTCCSS.stcField.u1SCLRS)  /*@bf@*/
#define FRT01_TCCSS_MODES	(FRT01.unTCCSS.stcField.u1MODES)  /*@bf@*/
#define FRT01_TCCSS_STOPS	(FRT01.unTCCSS.stcField.u1STOPS)  /*@bf@*/
#define FRT01_TCCSS_BFES	(FRT01.unTCCSS.stcField.u1BFES)  /*@bf@*/
#define FRT01_TCCSS_ICRES	(FRT01.unTCCSS.stcField.u1ICRES)  /*@bf@*/
#define FRT01_TCCSS_IRQZES	(FRT01.unTCCSS.stcField.u1IRQZES)  /*@bf@*/
#define FRT01_TCCSS_ECKES	(FRT01.unTCCSS.stcField.u1ECKES)  /*@bf@*/

#define FRT02_TCCSS	(FRT02.unTCCSS.u32Register)  /*@rg@*/
#define FRT02_TCCSS_SCLRS	(FRT02.unTCCSS.stcField.u1SCLRS)  /*@bf@*/
#define FRT02_TCCSS_MODES	(FRT02.unTCCSS.stcField.u1MODES)  /*@bf@*/
#define FRT02_TCCSS_STOPS	(FRT02.unTCCSS.stcField.u1STOPS)  /*@bf@*/
#define FRT02_TCCSS_BFES	(FRT02.unTCCSS.stcField.u1BFES)  /*@bf@*/
#define FRT02_TCCSS_ICRES	(FRT02.unTCCSS.stcField.u1ICRES)  /*@bf@*/
#define FRT02_TCCSS_IRQZES	(FRT02.unTCCSS.stcField.u1IRQZES)  /*@bf@*/
#define FRT02_TCCSS_ECKES	(FRT02.unTCCSS.stcField.u1ECKES)  /*@bf@*/

#define FRT03_TCCSS	(FRT03.unTCCSS.u32Register)  /*@rg@*/
#define FRT03_TCCSS_SCLRS	(FRT03.unTCCSS.stcField.u1SCLRS)  /*@bf@*/
#define FRT03_TCCSS_MODES	(FRT03.unTCCSS.stcField.u1MODES)  /*@bf@*/
#define FRT03_TCCSS_STOPS	(FRT03.unTCCSS.stcField.u1STOPS)  /*@bf@*/
#define FRT03_TCCSS_BFES	(FRT03.unTCCSS.stcField.u1BFES)  /*@bf@*/
#define FRT03_TCCSS_ICRES	(FRT03.unTCCSS.stcField.u1ICRES)  /*@bf@*/
#define FRT03_TCCSS_IRQZES	(FRT03.unTCCSS.stcField.u1IRQZES)  /*@bf@*/
#define FRT03_TCCSS_ECKES	(FRT03.unTCCSS.stcField.u1ECKES)  /*@bf@*/

#define FRT04_TCCSS	(FRT04.unTCCSS.u32Register)  /*@rg@*/
#define FRT04_TCCSS_SCLRS	(FRT04.unTCCSS.stcField.u1SCLRS)  /*@bf@*/
#define FRT04_TCCSS_MODES	(FRT04.unTCCSS.stcField.u1MODES)  /*@bf@*/
#define FRT04_TCCSS_STOPS	(FRT04.unTCCSS.stcField.u1STOPS)  /*@bf@*/
#define FRT04_TCCSS_BFES	(FRT04.unTCCSS.stcField.u1BFES)  /*@bf@*/
#define FRT04_TCCSS_ICRES	(FRT04.unTCCSS.stcField.u1ICRES)  /*@bf@*/
#define FRT04_TCCSS_IRQZES	(FRT04.unTCCSS.stcField.u1IRQZES)  /*@bf@*/
#define FRT04_TCCSS_ECKES	(FRT04.unTCCSS.stcField.u1ECKES)  /*@bf@*/

#define FRT08_TCCSS	(FRT08.unTCCSS.u32Register)  /*@rg@*/
#define FRT08_TCCSS_SCLRS	(FRT08.unTCCSS.stcField.u1SCLRS)  /*@bf@*/
#define FRT08_TCCSS_MODES	(FRT08.unTCCSS.stcField.u1MODES)  /*@bf@*/
#define FRT08_TCCSS_STOPS	(FRT08.unTCCSS.stcField.u1STOPS)  /*@bf@*/
#define FRT08_TCCSS_BFES	(FRT08.unTCCSS.stcField.u1BFES)  /*@bf@*/
#define FRT08_TCCSS_ICRES	(FRT08.unTCCSS.stcField.u1ICRES)  /*@bf@*/
#define FRT08_TCCSS_IRQZES	(FRT08.unTCCSS.stcField.u1IRQZES)  /*@bf@*/
#define FRT08_TCCSS_ECKES	(FRT08.unTCCSS.stcField.u1ECKES)  /*@bf@*/

#define FRT09_TCCSS	(FRT09.unTCCSS.u32Register)  /*@rg@*/
#define FRT09_TCCSS_SCLRS	(FRT09.unTCCSS.stcField.u1SCLRS)  /*@bf@*/
#define FRT09_TCCSS_MODES	(FRT09.unTCCSS.stcField.u1MODES)  /*@bf@*/
#define FRT09_TCCSS_STOPS	(FRT09.unTCCSS.stcField.u1STOPS)  /*@bf@*/
#define FRT09_TCCSS_BFES	(FRT09.unTCCSS.stcField.u1BFES)  /*@bf@*/
#define FRT09_TCCSS_ICRES	(FRT09.unTCCSS.stcField.u1ICRES)  /*@bf@*/
#define FRT09_TCCSS_IRQZES	(FRT09.unTCCSS.stcField.u1IRQZES)  /*@bf@*/
#define FRT09_TCCSS_ECKES	(FRT09.unTCCSS.stcField.u1ECKES)  /*@bf@*/

#define FRT10_TCCSS	(FRT10.unTCCSS.u32Register)  /*@rg@*/
#define FRT10_TCCSS_SCLRS	(FRT10.unTCCSS.stcField.u1SCLRS)  /*@bf@*/
#define FRT10_TCCSS_MODES	(FRT10.unTCCSS.stcField.u1MODES)  /*@bf@*/
#define FRT10_TCCSS_STOPS	(FRT10.unTCCSS.stcField.u1STOPS)  /*@bf@*/
#define FRT10_TCCSS_BFES	(FRT10.unTCCSS.stcField.u1BFES)  /*@bf@*/
#define FRT10_TCCSS_ICRES	(FRT10.unTCCSS.stcField.u1ICRES)  /*@bf@*/
#define FRT10_TCCSS_IRQZES	(FRT10.unTCCSS.stcField.u1IRQZES)  /*@bf@*/
#define FRT10_TCCSS_ECKES	(FRT10.unTCCSS.stcField.u1ECKES)  /*@bf@*/

typedef struct stc_frtn_tccss_field{
    uint_io32_t		:4;
    uint_io32_t		u1SCLRS:1;
    uint_io32_t		u1MODES:1;
    uint_io32_t		u1STOPS:1;
    uint_io32_t		u1BFES:1;
    uint_io32_t		u1ICRES:1;
    uint_io32_t		:4;
    uint_io32_t		u1IRQZES:1;
    uint_io32_t		:1;
    uint_io32_t		u1ECKES:1;
    uint_io32_t		:16;
}stc_frtn_tccss_field_t;

typedef union un_frtn_tccss{
    uint_io32_t		u32Register;
    stc_frtn_tccss_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_frtn_tccss_t;

/* DEBUG */
#define FRT00_DEBUG	(FRT00.unDEBUG.u16Register)  /*@rg@*/
#define FRT00_DEBUG_DBGEN	(FRT00.unDEBUG.stcField.u1DBGEN)  /*@bf@*/

#define FRT01_DEBUG	(FRT01.unDEBUG.u16Register)  /*@rg@*/
#define FRT01_DEBUG_DBGEN	(FRT01.unDEBUG.stcField.u1DBGEN)  /*@bf@*/

#define FRT02_DEBUG	(FRT02.unDEBUG.u16Register)  /*@rg@*/
#define FRT02_DEBUG_DBGEN	(FRT02.unDEBUG.stcField.u1DBGEN)  /*@bf@*/

#define FRT03_DEBUG	(FRT03.unDEBUG.u16Register)  /*@rg@*/
#define FRT03_DEBUG_DBGEN	(FRT03.unDEBUG.stcField.u1DBGEN)  /*@bf@*/

#define FRT04_DEBUG	(FRT04.unDEBUG.u16Register)  /*@rg@*/
#define FRT04_DEBUG_DBGEN	(FRT04.unDEBUG.stcField.u1DBGEN)  /*@bf@*/

#define FRT08_DEBUG	(FRT08.unDEBUG.u16Register)  /*@rg@*/
#define FRT08_DEBUG_DBGEN	(FRT08.unDEBUG.stcField.u1DBGEN)  /*@bf@*/

#define FRT09_DEBUG	(FRT09.unDEBUG.u16Register)  /*@rg@*/
#define FRT09_DEBUG_DBGEN	(FRT09.unDEBUG.stcField.u1DBGEN)  /*@bf@*/

#define FRT10_DEBUG	(FRT10.unDEBUG.u16Register)  /*@rg@*/
#define FRT10_DEBUG_DBGEN	(FRT10.unDEBUG.stcField.u1DBGEN)  /*@bf@*/

typedef struct stc_frtn_debug_field{
    uint_io16_t		u1DBGEN:1;
    uint_io16_t		:15;
}stc_frtn_debug_field_t;

typedef union un_frtn_debug{
    uint_io16_t		u16Register;
    stc_frtn_debug_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_frtn_debug_t;


typedef struct stc_frtn{
    un_frtn_cpclrb_t	unCPCLRB;	/* 0x00000000 */
    un_frtn_tcdt_t	unTCDT;	/* 0x00000004 */
    un_frtn_tccs_t	unTCCS;	/* 0x00000008 */
    un_frtn_teccs_t	unTECCS;	/* 0x0000000C */
    un_frtn_tccsc_t	unTCCSC;	/* 0x00000010 */
    un_frtn_tccss_t	unTCCSS;	/* 0x00000014 */
    un_frtn_debug_t	unDEBUG;	/* 0x00000018 */
    uint_io8_t	au8Reserved0[998];	/* 0x0000001A */
}stc_frtn_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_frtn_t	stcFRT[8];
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 1024(0x400) bytes */


#endif /* __S6J3360_FRT_H */
