/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_GPIO_H
#define __S6J3360_GPIO_H

#include "s6j3360io_basetypes.h"

/* GPIO base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define GPIO	stcGPIO
#else /* __IO_DEFINE */
#define GPIO	(*((volatile stc_gpio_t*)0xB4738000))
#endif /* __IO_DEFINE */

/* POSR[0-3] */
#define GPIO_POSR0	(GPIO.unPOSR0.u32Register)  /*@rg@*/
#define GPIO_POSR0_POS0	(GPIO.unPOSR0.stcField.u1POS0)  /*@bf@*/
#define GPIO_POSR0_POS1	(GPIO.unPOSR0.stcField.u1POS1)  /*@bf@*/
#define GPIO_POSR0_POS2	(GPIO.unPOSR0.stcField.u1POS2)  /*@bf@*/
#define GPIO_POSR0_POS3	(GPIO.unPOSR0.stcField.u1POS3)  /*@bf@*/
#define GPIO_POSR0_POS4	(GPIO.unPOSR0.stcField.u1POS4)  /*@bf@*/
#define GPIO_POSR0_POS5	(GPIO.unPOSR0.stcField.u1POS5)  /*@bf@*/
#define GPIO_POSR0_POS6	(GPIO.unPOSR0.stcField.u1POS6)  /*@bf@*/
#define GPIO_POSR0_POS7	(GPIO.unPOSR0.stcField.u1POS7)  /*@bf@*/
#define GPIO_POSR0_POS8	(GPIO.unPOSR0.stcField.u1POS8)  /*@bf@*/
#define GPIO_POSR0_POS9	(GPIO.unPOSR0.stcField.u1POS9)  /*@bf@*/
#define GPIO_POSR0_POS10	(GPIO.unPOSR0.stcField.u1POS10)  /*@bf@*/
#define GPIO_POSR0_POS11	(GPIO.unPOSR0.stcField.u1POS11)  /*@bf@*/
#define GPIO_POSR0_POS12	(GPIO.unPOSR0.stcField.u1POS12)  /*@bf@*/
#define GPIO_POSR0_POS13	(GPIO.unPOSR0.stcField.u1POS13)  /*@bf@*/
#define GPIO_POSR0_POS14	(GPIO.unPOSR0.stcField.u1POS14)  /*@bf@*/
#define GPIO_POSR0_POS15	(GPIO.unPOSR0.stcField.u1POS15)  /*@bf@*/
#define GPIO_POSR0_POS16	(GPIO.unPOSR0.stcField.u1POS16)  /*@bf@*/
#define GPIO_POSR0_POS17	(GPIO.unPOSR0.stcField.u1POS17)  /*@bf@*/
#define GPIO_POSR0_POS18	(GPIO.unPOSR0.stcField.u1POS18)  /*@bf@*/
#define GPIO_POSR0_POS19	(GPIO.unPOSR0.stcField.u1POS19)  /*@bf@*/
#define GPIO_POSR0_POS20	(GPIO.unPOSR0.stcField.u1POS20)  /*@bf@*/
#define GPIO_POSR0_POS21	(GPIO.unPOSR0.stcField.u1POS21)  /*@bf@*/
#define GPIO_POSR0_POS22	(GPIO.unPOSR0.stcField.u1POS22)  /*@bf@*/
#define GPIO_POSR0_POS23	(GPIO.unPOSR0.stcField.u1POS23)  /*@bf@*/
#define GPIO_POSR0_POS24	(GPIO.unPOSR0.stcField.u1POS24)  /*@bf@*/
#define GPIO_POSR0_POS25	(GPIO.unPOSR0.stcField.u1POS25)  /*@bf@*/
#define GPIO_POSR0_POS26	(GPIO.unPOSR0.stcField.u1POS26)  /*@bf@*/
#define GPIO_POSR0_POS27	(GPIO.unPOSR0.stcField.u1POS27)  /*@bf@*/
#define GPIO_POSR0_POS28	(GPIO.unPOSR0.stcField.u1POS28)  /*@bf@*/
#define GPIO_POSR0_POS29	(GPIO.unPOSR0.stcField.u1POS29)  /*@bf@*/
#define GPIO_POSR0_POS30	(GPIO.unPOSR0.stcField.u1POS30)  /*@bf@*/
#define GPIO_POSR0_POS31	(GPIO.unPOSR0.stcField.u1POS31)  /*@bf@*/

#define GPIO_POSR1	(GPIO.unPOSR1.u32Register)  /*@rg@*/
#define GPIO_POSR1_POS0	(GPIO.unPOSR1.stcField.u1POS0)  /*@bf@*/
#define GPIO_POSR1_POS1	(GPIO.unPOSR1.stcField.u1POS1)  /*@bf@*/
#define GPIO_POSR1_POS2	(GPIO.unPOSR1.stcField.u1POS2)  /*@bf@*/
#define GPIO_POSR1_POS3	(GPIO.unPOSR1.stcField.u1POS3)  /*@bf@*/
#define GPIO_POSR1_POS4	(GPIO.unPOSR1.stcField.u1POS4)  /*@bf@*/
#define GPIO_POSR1_POS5	(GPIO.unPOSR1.stcField.u1POS5)  /*@bf@*/
#define GPIO_POSR1_POS6	(GPIO.unPOSR1.stcField.u1POS6)  /*@bf@*/
#define GPIO_POSR1_POS7	(GPIO.unPOSR1.stcField.u1POS7)  /*@bf@*/
#define GPIO_POSR1_POS8	(GPIO.unPOSR1.stcField.u1POS8)  /*@bf@*/
#define GPIO_POSR1_POS9	(GPIO.unPOSR1.stcField.u1POS9)  /*@bf@*/
#define GPIO_POSR1_POS10	(GPIO.unPOSR1.stcField.u1POS10)  /*@bf@*/
#define GPIO_POSR1_POS11	(GPIO.unPOSR1.stcField.u1POS11)  /*@bf@*/
#define GPIO_POSR1_POS12	(GPIO.unPOSR1.stcField.u1POS12)  /*@bf@*/
#define GPIO_POSR1_POS13	(GPIO.unPOSR1.stcField.u1POS13)  /*@bf@*/
#define GPIO_POSR1_POS14	(GPIO.unPOSR1.stcField.u1POS14)  /*@bf@*/
#define GPIO_POSR1_POS15	(GPIO.unPOSR1.stcField.u1POS15)  /*@bf@*/
#define GPIO_POSR1_POS16	(GPIO.unPOSR1.stcField.u1POS16)  /*@bf@*/
#define GPIO_POSR1_POS17	(GPIO.unPOSR1.stcField.u1POS17)  /*@bf@*/
#define GPIO_POSR1_POS18	(GPIO.unPOSR1.stcField.u1POS18)  /*@bf@*/
#define GPIO_POSR1_POS19	(GPIO.unPOSR1.stcField.u1POS19)  /*@bf@*/
#define GPIO_POSR1_POS20	(GPIO.unPOSR1.stcField.u1POS20)  /*@bf@*/
#define GPIO_POSR1_POS21	(GPIO.unPOSR1.stcField.u1POS21)  /*@bf@*/
#define GPIO_POSR1_POS22	(GPIO.unPOSR1.stcField.u1POS22)  /*@bf@*/
#define GPIO_POSR1_POS23	(GPIO.unPOSR1.stcField.u1POS23)  /*@bf@*/
#define GPIO_POSR1_POS24	(GPIO.unPOSR1.stcField.u1POS24)  /*@bf@*/
#define GPIO_POSR1_POS25	(GPIO.unPOSR1.stcField.u1POS25)  /*@bf@*/
#define GPIO_POSR1_POS26	(GPIO.unPOSR1.stcField.u1POS26)  /*@bf@*/
#define GPIO_POSR1_POS27	(GPIO.unPOSR1.stcField.u1POS27)  /*@bf@*/
#define GPIO_POSR1_POS28	(GPIO.unPOSR1.stcField.u1POS28)  /*@bf@*/
#define GPIO_POSR1_POS29	(GPIO.unPOSR1.stcField.u1POS29)  /*@bf@*/
#define GPIO_POSR1_POS30	(GPIO.unPOSR1.stcField.u1POS30)  /*@bf@*/
#define GPIO_POSR1_POS31	(GPIO.unPOSR1.stcField.u1POS31)  /*@bf@*/

#define GPIO_POSR2	(GPIO.unPOSR2.u32Register)  /*@rg@*/
#define GPIO_POSR2_POS0	(GPIO.unPOSR2.stcField.u1POS0)  /*@bf@*/
#define GPIO_POSR2_POS1	(GPIO.unPOSR2.stcField.u1POS1)  /*@bf@*/
#define GPIO_POSR2_POS2	(GPIO.unPOSR2.stcField.u1POS2)  /*@bf@*/
#define GPIO_POSR2_POS3	(GPIO.unPOSR2.stcField.u1POS3)  /*@bf@*/
#define GPIO_POSR2_POS4	(GPIO.unPOSR2.stcField.u1POS4)  /*@bf@*/
#define GPIO_POSR2_POS5	(GPIO.unPOSR2.stcField.u1POS5)  /*@bf@*/
#define GPIO_POSR2_POS6	(GPIO.unPOSR2.stcField.u1POS6)  /*@bf@*/
#define GPIO_POSR2_POS7	(GPIO.unPOSR2.stcField.u1POS7)  /*@bf@*/
#define GPIO_POSR2_POS8	(GPIO.unPOSR2.stcField.u1POS8)  /*@bf@*/
#define GPIO_POSR2_POS9	(GPIO.unPOSR2.stcField.u1POS9)  /*@bf@*/
#define GPIO_POSR2_POS10	(GPIO.unPOSR2.stcField.u1POS10)  /*@bf@*/
#define GPIO_POSR2_POS11	(GPIO.unPOSR2.stcField.u1POS11)  /*@bf@*/
#define GPIO_POSR2_POS12	(GPIO.unPOSR2.stcField.u1POS12)  /*@bf@*/
#define GPIO_POSR2_POS13	(GPIO.unPOSR2.stcField.u1POS13)  /*@bf@*/
#define GPIO_POSR2_POS14	(GPIO.unPOSR2.stcField.u1POS14)  /*@bf@*/
#define GPIO_POSR2_POS15	(GPIO.unPOSR2.stcField.u1POS15)  /*@bf@*/
#define GPIO_POSR2_POS16	(GPIO.unPOSR2.stcField.u1POS16)  /*@bf@*/
#define GPIO_POSR2_POS17	(GPIO.unPOSR2.stcField.u1POS17)  /*@bf@*/
#define GPIO_POSR2_POS18	(GPIO.unPOSR2.stcField.u1POS18)  /*@bf@*/
#define GPIO_POSR2_POS19	(GPIO.unPOSR2.stcField.u1POS19)  /*@bf@*/
#define GPIO_POSR2_POS20	(GPIO.unPOSR2.stcField.u1POS20)  /*@bf@*/
#define GPIO_POSR2_POS21	(GPIO.unPOSR2.stcField.u1POS21)  /*@bf@*/
#define GPIO_POSR2_POS22	(GPIO.unPOSR2.stcField.u1POS22)  /*@bf@*/
#define GPIO_POSR2_POS23	(GPIO.unPOSR2.stcField.u1POS23)  /*@bf@*/
#define GPIO_POSR2_POS24	(GPIO.unPOSR2.stcField.u1POS24)  /*@bf@*/
#define GPIO_POSR2_POS25	(GPIO.unPOSR2.stcField.u1POS25)  /*@bf@*/
#define GPIO_POSR2_POS26	(GPIO.unPOSR2.stcField.u1POS26)  /*@bf@*/
#define GPIO_POSR2_POS27	(GPIO.unPOSR2.stcField.u1POS27)  /*@bf@*/
#define GPIO_POSR2_POS28	(GPIO.unPOSR2.stcField.u1POS28)  /*@bf@*/
#define GPIO_POSR2_POS29	(GPIO.unPOSR2.stcField.u1POS29)  /*@bf@*/
#define GPIO_POSR2_POS30	(GPIO.unPOSR2.stcField.u1POS30)  /*@bf@*/
#define GPIO_POSR2_POS31	(GPIO.unPOSR2.stcField.u1POS31)  /*@bf@*/

#define GPIO_POSR3	(GPIO.unPOSR3.u32Register)  /*@rg@*/
#define GPIO_POSR3_POS0	(GPIO.unPOSR3.stcField.u1POS0)  /*@bf@*/
#define GPIO_POSR3_POS1	(GPIO.unPOSR3.stcField.u1POS1)  /*@bf@*/
#define GPIO_POSR3_POS2	(GPIO.unPOSR3.stcField.u1POS2)  /*@bf@*/
#define GPIO_POSR3_POS3	(GPIO.unPOSR3.stcField.u1POS3)  /*@bf@*/
#define GPIO_POSR3_POS4	(GPIO.unPOSR3.stcField.u1POS4)  /*@bf@*/
#define GPIO_POSR3_POS5	(GPIO.unPOSR3.stcField.u1POS5)  /*@bf@*/
#define GPIO_POSR3_POS6	(GPIO.unPOSR3.stcField.u1POS6)  /*@bf@*/
#define GPIO_POSR3_POS7	(GPIO.unPOSR3.stcField.u1POS7)  /*@bf@*/
#define GPIO_POSR3_POS8	(GPIO.unPOSR3.stcField.u1POS8)  /*@bf@*/
#define GPIO_POSR3_POS9	(GPIO.unPOSR3.stcField.u1POS9)  /*@bf@*/
#define GPIO_POSR3_POS10	(GPIO.unPOSR3.stcField.u1POS10)  /*@bf@*/
#define GPIO_POSR3_POS11	(GPIO.unPOSR3.stcField.u1POS11)  /*@bf@*/
#define GPIO_POSR3_POS12	(GPIO.unPOSR3.stcField.u1POS12)  /*@bf@*/
#define GPIO_POSR3_POS13	(GPIO.unPOSR3.stcField.u1POS13)  /*@bf@*/
#define GPIO_POSR3_POS14	(GPIO.unPOSR3.stcField.u1POS14)  /*@bf@*/
#define GPIO_POSR3_POS15	(GPIO.unPOSR3.stcField.u1POS15)  /*@bf@*/
#define GPIO_POSR3_POS16	(GPIO.unPOSR3.stcField.u1POS16)  /*@bf@*/
#define GPIO_POSR3_POS17	(GPIO.unPOSR3.stcField.u1POS17)  /*@bf@*/
#define GPIO_POSR3_POS18	(GPIO.unPOSR3.stcField.u1POS18)  /*@bf@*/
#define GPIO_POSR3_POS19	(GPIO.unPOSR3.stcField.u1POS19)  /*@bf@*/
#define GPIO_POSR3_POS20	(GPIO.unPOSR3.stcField.u1POS20)  /*@bf@*/
#define GPIO_POSR3_POS21	(GPIO.unPOSR3.stcField.u1POS21)  /*@bf@*/
#define GPIO_POSR3_POS22	(GPIO.unPOSR3.stcField.u1POS22)  /*@bf@*/
#define GPIO_POSR3_POS23	(GPIO.unPOSR3.stcField.u1POS23)  /*@bf@*/
#define GPIO_POSR3_POS24	(GPIO.unPOSR3.stcField.u1POS24)  /*@bf@*/
#define GPIO_POSR3_POS25	(GPIO.unPOSR3.stcField.u1POS25)  /*@bf@*/
#define GPIO_POSR3_POS26	(GPIO.unPOSR3.stcField.u1POS26)  /*@bf@*/
#define GPIO_POSR3_POS27	(GPIO.unPOSR3.stcField.u1POS27)  /*@bf@*/
#define GPIO_POSR3_POS28	(GPIO.unPOSR3.stcField.u1POS28)  /*@bf@*/
#define GPIO_POSR3_POS29	(GPIO.unPOSR3.stcField.u1POS29)  /*@bf@*/
#define GPIO_POSR3_POS30	(GPIO.unPOSR3.stcField.u1POS30)  /*@bf@*/
#define GPIO_POSR3_POS31	(GPIO.unPOSR3.stcField.u1POS31)  /*@bf@*/

typedef struct stc_gpio_posrn_field{
    uint_io32_t		u1POS0:1;
    uint_io32_t		u1POS1:1;
    uint_io32_t		u1POS2:1;
    uint_io32_t		u1POS3:1;
    uint_io32_t		u1POS4:1;
    uint_io32_t		u1POS5:1;
    uint_io32_t		u1POS6:1;
    uint_io32_t		u1POS7:1;
    uint_io32_t		u1POS8:1;
    uint_io32_t		u1POS9:1;
    uint_io32_t		u1POS10:1;
    uint_io32_t		u1POS11:1;
    uint_io32_t		u1POS12:1;
    uint_io32_t		u1POS13:1;
    uint_io32_t		u1POS14:1;
    uint_io32_t		u1POS15:1;
    uint_io32_t		u1POS16:1;
    uint_io32_t		u1POS17:1;
    uint_io32_t		u1POS18:1;
    uint_io32_t		u1POS19:1;
    uint_io32_t		u1POS20:1;
    uint_io32_t		u1POS21:1;
    uint_io32_t		u1POS22:1;
    uint_io32_t		u1POS23:1;
    uint_io32_t		u1POS24:1;
    uint_io32_t		u1POS25:1;
    uint_io32_t		u1POS26:1;
    uint_io32_t		u1POS27:1;
    uint_io32_t		u1POS28:1;
    uint_io32_t		u1POS29:1;
    uint_io32_t		u1POS30:1;
    uint_io32_t		u1POS31:1;
}stc_gpio_posrn_field_t;

typedef union un_gpio_posrn{
    uint_io32_t		u32Register;
    stc_gpio_posrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_posrn_t;

/* POCR[0-3] */
#define GPIO_POCR0	(GPIO.unPOCR0.u32Register)  /*@rg@*/
#define GPIO_POCR0_POC0	(GPIO.unPOCR0.stcField.u1POC0)  /*@bf@*/
#define GPIO_POCR0_POC1	(GPIO.unPOCR0.stcField.u1POC1)  /*@bf@*/
#define GPIO_POCR0_POC2	(GPIO.unPOCR0.stcField.u1POC2)  /*@bf@*/
#define GPIO_POCR0_POC3	(GPIO.unPOCR0.stcField.u1POC3)  /*@bf@*/
#define GPIO_POCR0_POC4	(GPIO.unPOCR0.stcField.u1POC4)  /*@bf@*/
#define GPIO_POCR0_POC5	(GPIO.unPOCR0.stcField.u1POC5)  /*@bf@*/
#define GPIO_POCR0_POC6	(GPIO.unPOCR0.stcField.u1POC6)  /*@bf@*/
#define GPIO_POCR0_POC7	(GPIO.unPOCR0.stcField.u1POC7)  /*@bf@*/
#define GPIO_POCR0_POC8	(GPIO.unPOCR0.stcField.u1POC8)  /*@bf@*/
#define GPIO_POCR0_POC9	(GPIO.unPOCR0.stcField.u1POC9)  /*@bf@*/
#define GPIO_POCR0_POC10	(GPIO.unPOCR0.stcField.u1POC10)  /*@bf@*/
#define GPIO_POCR0_POC11	(GPIO.unPOCR0.stcField.u1POC11)  /*@bf@*/
#define GPIO_POCR0_POC12	(GPIO.unPOCR0.stcField.u1POC12)  /*@bf@*/
#define GPIO_POCR0_POC13	(GPIO.unPOCR0.stcField.u1POC13)  /*@bf@*/
#define GPIO_POCR0_POC14	(GPIO.unPOCR0.stcField.u1POC14)  /*@bf@*/
#define GPIO_POCR0_POC15	(GPIO.unPOCR0.stcField.u1POC15)  /*@bf@*/
#define GPIO_POCR0_POC16	(GPIO.unPOCR0.stcField.u1POC16)  /*@bf@*/
#define GPIO_POCR0_POC17	(GPIO.unPOCR0.stcField.u1POC17)  /*@bf@*/
#define GPIO_POCR0_POC18	(GPIO.unPOCR0.stcField.u1POC18)  /*@bf@*/
#define GPIO_POCR0_POC19	(GPIO.unPOCR0.stcField.u1POC19)  /*@bf@*/
#define GPIO_POCR0_POC20	(GPIO.unPOCR0.stcField.u1POC20)  /*@bf@*/
#define GPIO_POCR0_POC21	(GPIO.unPOCR0.stcField.u1POC21)  /*@bf@*/
#define GPIO_POCR0_POC22	(GPIO.unPOCR0.stcField.u1POC22)  /*@bf@*/
#define GPIO_POCR0_POC23	(GPIO.unPOCR0.stcField.u1POC23)  /*@bf@*/
#define GPIO_POCR0_POC24	(GPIO.unPOCR0.stcField.u1POC24)  /*@bf@*/
#define GPIO_POCR0_POC25	(GPIO.unPOCR0.stcField.u1POC25)  /*@bf@*/
#define GPIO_POCR0_POC26	(GPIO.unPOCR0.stcField.u1POC26)  /*@bf@*/
#define GPIO_POCR0_POC27	(GPIO.unPOCR0.stcField.u1POC27)  /*@bf@*/
#define GPIO_POCR0_POC28	(GPIO.unPOCR0.stcField.u1POC28)  /*@bf@*/
#define GPIO_POCR0_POC29	(GPIO.unPOCR0.stcField.u1POC29)  /*@bf@*/
#define GPIO_POCR0_POC30	(GPIO.unPOCR0.stcField.u1POC30)  /*@bf@*/
#define GPIO_POCR0_POC31	(GPIO.unPOCR0.stcField.u1POC31)  /*@bf@*/

#define GPIO_POCR1	(GPIO.unPOCR1.u32Register)  /*@rg@*/
#define GPIO_POCR1_POC0	(GPIO.unPOCR1.stcField.u1POC0)  /*@bf@*/
#define GPIO_POCR1_POC1	(GPIO.unPOCR1.stcField.u1POC1)  /*@bf@*/
#define GPIO_POCR1_POC2	(GPIO.unPOCR1.stcField.u1POC2)  /*@bf@*/
#define GPIO_POCR1_POC3	(GPIO.unPOCR1.stcField.u1POC3)  /*@bf@*/
#define GPIO_POCR1_POC4	(GPIO.unPOCR1.stcField.u1POC4)  /*@bf@*/
#define GPIO_POCR1_POC5	(GPIO.unPOCR1.stcField.u1POC5)  /*@bf@*/
#define GPIO_POCR1_POC6	(GPIO.unPOCR1.stcField.u1POC6)  /*@bf@*/
#define GPIO_POCR1_POC7	(GPIO.unPOCR1.stcField.u1POC7)  /*@bf@*/
#define GPIO_POCR1_POC8	(GPIO.unPOCR1.stcField.u1POC8)  /*@bf@*/
#define GPIO_POCR1_POC9	(GPIO.unPOCR1.stcField.u1POC9)  /*@bf@*/
#define GPIO_POCR1_POC10	(GPIO.unPOCR1.stcField.u1POC10)  /*@bf@*/
#define GPIO_POCR1_POC11	(GPIO.unPOCR1.stcField.u1POC11)  /*@bf@*/
#define GPIO_POCR1_POC12	(GPIO.unPOCR1.stcField.u1POC12)  /*@bf@*/
#define GPIO_POCR1_POC13	(GPIO.unPOCR1.stcField.u1POC13)  /*@bf@*/
#define GPIO_POCR1_POC14	(GPIO.unPOCR1.stcField.u1POC14)  /*@bf@*/
#define GPIO_POCR1_POC15	(GPIO.unPOCR1.stcField.u1POC15)  /*@bf@*/
#define GPIO_POCR1_POC16	(GPIO.unPOCR1.stcField.u1POC16)  /*@bf@*/
#define GPIO_POCR1_POC17	(GPIO.unPOCR1.stcField.u1POC17)  /*@bf@*/
#define GPIO_POCR1_POC18	(GPIO.unPOCR1.stcField.u1POC18)  /*@bf@*/
#define GPIO_POCR1_POC19	(GPIO.unPOCR1.stcField.u1POC19)  /*@bf@*/
#define GPIO_POCR1_POC20	(GPIO.unPOCR1.stcField.u1POC20)  /*@bf@*/
#define GPIO_POCR1_POC21	(GPIO.unPOCR1.stcField.u1POC21)  /*@bf@*/
#define GPIO_POCR1_POC22	(GPIO.unPOCR1.stcField.u1POC22)  /*@bf@*/
#define GPIO_POCR1_POC23	(GPIO.unPOCR1.stcField.u1POC23)  /*@bf@*/
#define GPIO_POCR1_POC24	(GPIO.unPOCR1.stcField.u1POC24)  /*@bf@*/
#define GPIO_POCR1_POC25	(GPIO.unPOCR1.stcField.u1POC25)  /*@bf@*/
#define GPIO_POCR1_POC26	(GPIO.unPOCR1.stcField.u1POC26)  /*@bf@*/
#define GPIO_POCR1_POC27	(GPIO.unPOCR1.stcField.u1POC27)  /*@bf@*/
#define GPIO_POCR1_POC28	(GPIO.unPOCR1.stcField.u1POC28)  /*@bf@*/
#define GPIO_POCR1_POC29	(GPIO.unPOCR1.stcField.u1POC29)  /*@bf@*/
#define GPIO_POCR1_POC30	(GPIO.unPOCR1.stcField.u1POC30)  /*@bf@*/
#define GPIO_POCR1_POC31	(GPIO.unPOCR1.stcField.u1POC31)  /*@bf@*/

#define GPIO_POCR2	(GPIO.unPOCR2.u32Register)  /*@rg@*/
#define GPIO_POCR2_POC0	(GPIO.unPOCR2.stcField.u1POC0)  /*@bf@*/
#define GPIO_POCR2_POC1	(GPIO.unPOCR2.stcField.u1POC1)  /*@bf@*/
#define GPIO_POCR2_POC2	(GPIO.unPOCR2.stcField.u1POC2)  /*@bf@*/
#define GPIO_POCR2_POC3	(GPIO.unPOCR2.stcField.u1POC3)  /*@bf@*/
#define GPIO_POCR2_POC4	(GPIO.unPOCR2.stcField.u1POC4)  /*@bf@*/
#define GPIO_POCR2_POC5	(GPIO.unPOCR2.stcField.u1POC5)  /*@bf@*/
#define GPIO_POCR2_POC6	(GPIO.unPOCR2.stcField.u1POC6)  /*@bf@*/
#define GPIO_POCR2_POC7	(GPIO.unPOCR2.stcField.u1POC7)  /*@bf@*/
#define GPIO_POCR2_POC8	(GPIO.unPOCR2.stcField.u1POC8)  /*@bf@*/
#define GPIO_POCR2_POC9	(GPIO.unPOCR2.stcField.u1POC9)  /*@bf@*/
#define GPIO_POCR2_POC10	(GPIO.unPOCR2.stcField.u1POC10)  /*@bf@*/
#define GPIO_POCR2_POC11	(GPIO.unPOCR2.stcField.u1POC11)  /*@bf@*/
#define GPIO_POCR2_POC12	(GPIO.unPOCR2.stcField.u1POC12)  /*@bf@*/
#define GPIO_POCR2_POC13	(GPIO.unPOCR2.stcField.u1POC13)  /*@bf@*/
#define GPIO_POCR2_POC14	(GPIO.unPOCR2.stcField.u1POC14)  /*@bf@*/
#define GPIO_POCR2_POC15	(GPIO.unPOCR2.stcField.u1POC15)  /*@bf@*/
#define GPIO_POCR2_POC16	(GPIO.unPOCR2.stcField.u1POC16)  /*@bf@*/
#define GPIO_POCR2_POC17	(GPIO.unPOCR2.stcField.u1POC17)  /*@bf@*/
#define GPIO_POCR2_POC18	(GPIO.unPOCR2.stcField.u1POC18)  /*@bf@*/
#define GPIO_POCR2_POC19	(GPIO.unPOCR2.stcField.u1POC19)  /*@bf@*/
#define GPIO_POCR2_POC20	(GPIO.unPOCR2.stcField.u1POC20)  /*@bf@*/
#define GPIO_POCR2_POC21	(GPIO.unPOCR2.stcField.u1POC21)  /*@bf@*/
#define GPIO_POCR2_POC22	(GPIO.unPOCR2.stcField.u1POC22)  /*@bf@*/
#define GPIO_POCR2_POC23	(GPIO.unPOCR2.stcField.u1POC23)  /*@bf@*/
#define GPIO_POCR2_POC24	(GPIO.unPOCR2.stcField.u1POC24)  /*@bf@*/
#define GPIO_POCR2_POC25	(GPIO.unPOCR2.stcField.u1POC25)  /*@bf@*/
#define GPIO_POCR2_POC26	(GPIO.unPOCR2.stcField.u1POC26)  /*@bf@*/
#define GPIO_POCR2_POC27	(GPIO.unPOCR2.stcField.u1POC27)  /*@bf@*/
#define GPIO_POCR2_POC28	(GPIO.unPOCR2.stcField.u1POC28)  /*@bf@*/
#define GPIO_POCR2_POC29	(GPIO.unPOCR2.stcField.u1POC29)  /*@bf@*/
#define GPIO_POCR2_POC30	(GPIO.unPOCR2.stcField.u1POC30)  /*@bf@*/
#define GPIO_POCR2_POC31	(GPIO.unPOCR2.stcField.u1POC31)  /*@bf@*/

#define GPIO_POCR3	(GPIO.unPOCR3.u32Register)  /*@rg@*/
#define GPIO_POCR3_POC0	(GPIO.unPOCR3.stcField.u1POC0)  /*@bf@*/
#define GPIO_POCR3_POC1	(GPIO.unPOCR3.stcField.u1POC1)  /*@bf@*/
#define GPIO_POCR3_POC2	(GPIO.unPOCR3.stcField.u1POC2)  /*@bf@*/
#define GPIO_POCR3_POC3	(GPIO.unPOCR3.stcField.u1POC3)  /*@bf@*/
#define GPIO_POCR3_POC4	(GPIO.unPOCR3.stcField.u1POC4)  /*@bf@*/
#define GPIO_POCR3_POC5	(GPIO.unPOCR3.stcField.u1POC5)  /*@bf@*/
#define GPIO_POCR3_POC6	(GPIO.unPOCR3.stcField.u1POC6)  /*@bf@*/
#define GPIO_POCR3_POC7	(GPIO.unPOCR3.stcField.u1POC7)  /*@bf@*/
#define GPIO_POCR3_POC8	(GPIO.unPOCR3.stcField.u1POC8)  /*@bf@*/
#define GPIO_POCR3_POC9	(GPIO.unPOCR3.stcField.u1POC9)  /*@bf@*/
#define GPIO_POCR3_POC10	(GPIO.unPOCR3.stcField.u1POC10)  /*@bf@*/
#define GPIO_POCR3_POC11	(GPIO.unPOCR3.stcField.u1POC11)  /*@bf@*/
#define GPIO_POCR3_POC12	(GPIO.unPOCR3.stcField.u1POC12)  /*@bf@*/
#define GPIO_POCR3_POC13	(GPIO.unPOCR3.stcField.u1POC13)  /*@bf@*/
#define GPIO_POCR3_POC14	(GPIO.unPOCR3.stcField.u1POC14)  /*@bf@*/
#define GPIO_POCR3_POC15	(GPIO.unPOCR3.stcField.u1POC15)  /*@bf@*/
#define GPIO_POCR3_POC16	(GPIO.unPOCR3.stcField.u1POC16)  /*@bf@*/
#define GPIO_POCR3_POC17	(GPIO.unPOCR3.stcField.u1POC17)  /*@bf@*/
#define GPIO_POCR3_POC18	(GPIO.unPOCR3.stcField.u1POC18)  /*@bf@*/
#define GPIO_POCR3_POC19	(GPIO.unPOCR3.stcField.u1POC19)  /*@bf@*/
#define GPIO_POCR3_POC20	(GPIO.unPOCR3.stcField.u1POC20)  /*@bf@*/
#define GPIO_POCR3_POC21	(GPIO.unPOCR3.stcField.u1POC21)  /*@bf@*/
#define GPIO_POCR3_POC22	(GPIO.unPOCR3.stcField.u1POC22)  /*@bf@*/
#define GPIO_POCR3_POC23	(GPIO.unPOCR3.stcField.u1POC23)  /*@bf@*/
#define GPIO_POCR3_POC24	(GPIO.unPOCR3.stcField.u1POC24)  /*@bf@*/
#define GPIO_POCR3_POC25	(GPIO.unPOCR3.stcField.u1POC25)  /*@bf@*/
#define GPIO_POCR3_POC26	(GPIO.unPOCR3.stcField.u1POC26)  /*@bf@*/
#define GPIO_POCR3_POC27	(GPIO.unPOCR3.stcField.u1POC27)  /*@bf@*/
#define GPIO_POCR3_POC28	(GPIO.unPOCR3.stcField.u1POC28)  /*@bf@*/
#define GPIO_POCR3_POC29	(GPIO.unPOCR3.stcField.u1POC29)  /*@bf@*/
#define GPIO_POCR3_POC30	(GPIO.unPOCR3.stcField.u1POC30)  /*@bf@*/
#define GPIO_POCR3_POC31	(GPIO.unPOCR3.stcField.u1POC31)  /*@bf@*/

typedef struct stc_gpio_pocrn_field{
    uint_io32_t		u1POC0:1;
    uint_io32_t		u1POC1:1;
    uint_io32_t		u1POC2:1;
    uint_io32_t		u1POC3:1;
    uint_io32_t		u1POC4:1;
    uint_io32_t		u1POC5:1;
    uint_io32_t		u1POC6:1;
    uint_io32_t		u1POC7:1;
    uint_io32_t		u1POC8:1;
    uint_io32_t		u1POC9:1;
    uint_io32_t		u1POC10:1;
    uint_io32_t		u1POC11:1;
    uint_io32_t		u1POC12:1;
    uint_io32_t		u1POC13:1;
    uint_io32_t		u1POC14:1;
    uint_io32_t		u1POC15:1;
    uint_io32_t		u1POC16:1;
    uint_io32_t		u1POC17:1;
    uint_io32_t		u1POC18:1;
    uint_io32_t		u1POC19:1;
    uint_io32_t		u1POC20:1;
    uint_io32_t		u1POC21:1;
    uint_io32_t		u1POC22:1;
    uint_io32_t		u1POC23:1;
    uint_io32_t		u1POC24:1;
    uint_io32_t		u1POC25:1;
    uint_io32_t		u1POC26:1;
    uint_io32_t		u1POC27:1;
    uint_io32_t		u1POC28:1;
    uint_io32_t		u1POC29:1;
    uint_io32_t		u1POC30:1;
    uint_io32_t		u1POC31:1;
}stc_gpio_pocrn_field_t;

typedef union un_gpio_pocrn{
    uint_io32_t		u32Register;
    stc_gpio_pocrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_pocrn_t;

/* DDSR[0-3] */
#define GPIO_DDSR0	(GPIO.unDDSR0.u32Register)  /*@rg@*/
#define GPIO_DDSR0_DDS0	(GPIO.unDDSR0.stcField.u1DDS0)  /*@bf@*/
#define GPIO_DDSR0_DDS1	(GPIO.unDDSR0.stcField.u1DDS1)  /*@bf@*/
#define GPIO_DDSR0_DDS2	(GPIO.unDDSR0.stcField.u1DDS2)  /*@bf@*/
#define GPIO_DDSR0_DDS3	(GPIO.unDDSR0.stcField.u1DDS3)  /*@bf@*/
#define GPIO_DDSR0_DDS4	(GPIO.unDDSR0.stcField.u1DDS4)  /*@bf@*/
#define GPIO_DDSR0_DDS5	(GPIO.unDDSR0.stcField.u1DDS5)  /*@bf@*/
#define GPIO_DDSR0_DDS6	(GPIO.unDDSR0.stcField.u1DDS6)  /*@bf@*/
#define GPIO_DDSR0_DDS7	(GPIO.unDDSR0.stcField.u1DDS7)  /*@bf@*/
#define GPIO_DDSR0_DDS8	(GPIO.unDDSR0.stcField.u1DDS8)  /*@bf@*/
#define GPIO_DDSR0_DDS9	(GPIO.unDDSR0.stcField.u1DDS9)  /*@bf@*/
#define GPIO_DDSR0_DDS10	(GPIO.unDDSR0.stcField.u1DDS10)  /*@bf@*/
#define GPIO_DDSR0_DDS11	(GPIO.unDDSR0.stcField.u1DDS11)  /*@bf@*/
#define GPIO_DDSR0_DDS12	(GPIO.unDDSR0.stcField.u1DDS12)  /*@bf@*/
#define GPIO_DDSR0_DDS13	(GPIO.unDDSR0.stcField.u1DDS13)  /*@bf@*/
#define GPIO_DDSR0_DDS14	(GPIO.unDDSR0.stcField.u1DDS14)  /*@bf@*/
#define GPIO_DDSR0_DDS15	(GPIO.unDDSR0.stcField.u1DDS15)  /*@bf@*/
#define GPIO_DDSR0_DDS16	(GPIO.unDDSR0.stcField.u1DDS16)  /*@bf@*/
#define GPIO_DDSR0_DDS17	(GPIO.unDDSR0.stcField.u1DDS17)  /*@bf@*/
#define GPIO_DDSR0_DDS18	(GPIO.unDDSR0.stcField.u1DDS18)  /*@bf@*/
#define GPIO_DDSR0_DDS19	(GPIO.unDDSR0.stcField.u1DDS19)  /*@bf@*/
#define GPIO_DDSR0_DDS20	(GPIO.unDDSR0.stcField.u1DDS20)  /*@bf@*/
#define GPIO_DDSR0_DDS21	(GPIO.unDDSR0.stcField.u1DDS21)  /*@bf@*/
#define GPIO_DDSR0_DDS22	(GPIO.unDDSR0.stcField.u1DDS22)  /*@bf@*/
#define GPIO_DDSR0_DDS23	(GPIO.unDDSR0.stcField.u1DDS23)  /*@bf@*/
#define GPIO_DDSR0_DDS24	(GPIO.unDDSR0.stcField.u1DDS24)  /*@bf@*/
#define GPIO_DDSR0_DDS25	(GPIO.unDDSR0.stcField.u1DDS25)  /*@bf@*/
#define GPIO_DDSR0_DDS26	(GPIO.unDDSR0.stcField.u1DDS26)  /*@bf@*/
#define GPIO_DDSR0_DDS27	(GPIO.unDDSR0.stcField.u1DDS27)  /*@bf@*/
#define GPIO_DDSR0_DDS28	(GPIO.unDDSR0.stcField.u1DDS28)  /*@bf@*/
#define GPIO_DDSR0_DDS29	(GPIO.unDDSR0.stcField.u1DDS29)  /*@bf@*/
#define GPIO_DDSR0_DDS30	(GPIO.unDDSR0.stcField.u1DDS30)  /*@bf@*/
#define GPIO_DDSR0_DDS31	(GPIO.unDDSR0.stcField.u1DDS31)  /*@bf@*/

#define GPIO_DDSR1	(GPIO.unDDSR1.u32Register)  /*@rg@*/
#define GPIO_DDSR1_DDS0	(GPIO.unDDSR1.stcField.u1DDS0)  /*@bf@*/
#define GPIO_DDSR1_DDS1	(GPIO.unDDSR1.stcField.u1DDS1)  /*@bf@*/
#define GPIO_DDSR1_DDS2	(GPIO.unDDSR1.stcField.u1DDS2)  /*@bf@*/
#define GPIO_DDSR1_DDS3	(GPIO.unDDSR1.stcField.u1DDS3)  /*@bf@*/
#define GPIO_DDSR1_DDS4	(GPIO.unDDSR1.stcField.u1DDS4)  /*@bf@*/
#define GPIO_DDSR1_DDS5	(GPIO.unDDSR1.stcField.u1DDS5)  /*@bf@*/
#define GPIO_DDSR1_DDS6	(GPIO.unDDSR1.stcField.u1DDS6)  /*@bf@*/
#define GPIO_DDSR1_DDS7	(GPIO.unDDSR1.stcField.u1DDS7)  /*@bf@*/
#define GPIO_DDSR1_DDS8	(GPIO.unDDSR1.stcField.u1DDS8)  /*@bf@*/
#define GPIO_DDSR1_DDS9	(GPIO.unDDSR1.stcField.u1DDS9)  /*@bf@*/
#define GPIO_DDSR1_DDS10	(GPIO.unDDSR1.stcField.u1DDS10)  /*@bf@*/
#define GPIO_DDSR1_DDS11	(GPIO.unDDSR1.stcField.u1DDS11)  /*@bf@*/
#define GPIO_DDSR1_DDS12	(GPIO.unDDSR1.stcField.u1DDS12)  /*@bf@*/
#define GPIO_DDSR1_DDS13	(GPIO.unDDSR1.stcField.u1DDS13)  /*@bf@*/
#define GPIO_DDSR1_DDS14	(GPIO.unDDSR1.stcField.u1DDS14)  /*@bf@*/
#define GPIO_DDSR1_DDS15	(GPIO.unDDSR1.stcField.u1DDS15)  /*@bf@*/
#define GPIO_DDSR1_DDS16	(GPIO.unDDSR1.stcField.u1DDS16)  /*@bf@*/
#define GPIO_DDSR1_DDS17	(GPIO.unDDSR1.stcField.u1DDS17)  /*@bf@*/
#define GPIO_DDSR1_DDS18	(GPIO.unDDSR1.stcField.u1DDS18)  /*@bf@*/
#define GPIO_DDSR1_DDS19	(GPIO.unDDSR1.stcField.u1DDS19)  /*@bf@*/
#define GPIO_DDSR1_DDS20	(GPIO.unDDSR1.stcField.u1DDS20)  /*@bf@*/
#define GPIO_DDSR1_DDS21	(GPIO.unDDSR1.stcField.u1DDS21)  /*@bf@*/
#define GPIO_DDSR1_DDS22	(GPIO.unDDSR1.stcField.u1DDS22)  /*@bf@*/
#define GPIO_DDSR1_DDS23	(GPIO.unDDSR1.stcField.u1DDS23)  /*@bf@*/
#define GPIO_DDSR1_DDS24	(GPIO.unDDSR1.stcField.u1DDS24)  /*@bf@*/
#define GPIO_DDSR1_DDS25	(GPIO.unDDSR1.stcField.u1DDS25)  /*@bf@*/
#define GPIO_DDSR1_DDS26	(GPIO.unDDSR1.stcField.u1DDS26)  /*@bf@*/
#define GPIO_DDSR1_DDS27	(GPIO.unDDSR1.stcField.u1DDS27)  /*@bf@*/
#define GPIO_DDSR1_DDS28	(GPIO.unDDSR1.stcField.u1DDS28)  /*@bf@*/
#define GPIO_DDSR1_DDS29	(GPIO.unDDSR1.stcField.u1DDS29)  /*@bf@*/
#define GPIO_DDSR1_DDS30	(GPIO.unDDSR1.stcField.u1DDS30)  /*@bf@*/
#define GPIO_DDSR1_DDS31	(GPIO.unDDSR1.stcField.u1DDS31)  /*@bf@*/

#define GPIO_DDSR2	(GPIO.unDDSR2.u32Register)  /*@rg@*/
#define GPIO_DDSR2_DDS0	(GPIO.unDDSR2.stcField.u1DDS0)  /*@bf@*/
#define GPIO_DDSR2_DDS1	(GPIO.unDDSR2.stcField.u1DDS1)  /*@bf@*/
#define GPIO_DDSR2_DDS2	(GPIO.unDDSR2.stcField.u1DDS2)  /*@bf@*/
#define GPIO_DDSR2_DDS3	(GPIO.unDDSR2.stcField.u1DDS3)  /*@bf@*/
#define GPIO_DDSR2_DDS4	(GPIO.unDDSR2.stcField.u1DDS4)  /*@bf@*/
#define GPIO_DDSR2_DDS5	(GPIO.unDDSR2.stcField.u1DDS5)  /*@bf@*/
#define GPIO_DDSR2_DDS6	(GPIO.unDDSR2.stcField.u1DDS6)  /*@bf@*/
#define GPIO_DDSR2_DDS7	(GPIO.unDDSR2.stcField.u1DDS7)  /*@bf@*/
#define GPIO_DDSR2_DDS8	(GPIO.unDDSR2.stcField.u1DDS8)  /*@bf@*/
#define GPIO_DDSR2_DDS9	(GPIO.unDDSR2.stcField.u1DDS9)  /*@bf@*/
#define GPIO_DDSR2_DDS10	(GPIO.unDDSR2.stcField.u1DDS10)  /*@bf@*/
#define GPIO_DDSR2_DDS11	(GPIO.unDDSR2.stcField.u1DDS11)  /*@bf@*/
#define GPIO_DDSR2_DDS12	(GPIO.unDDSR2.stcField.u1DDS12)  /*@bf@*/
#define GPIO_DDSR2_DDS13	(GPIO.unDDSR2.stcField.u1DDS13)  /*@bf@*/
#define GPIO_DDSR2_DDS14	(GPIO.unDDSR2.stcField.u1DDS14)  /*@bf@*/
#define GPIO_DDSR2_DDS15	(GPIO.unDDSR2.stcField.u1DDS15)  /*@bf@*/
#define GPIO_DDSR2_DDS16	(GPIO.unDDSR2.stcField.u1DDS16)  /*@bf@*/
#define GPIO_DDSR2_DDS17	(GPIO.unDDSR2.stcField.u1DDS17)  /*@bf@*/
#define GPIO_DDSR2_DDS18	(GPIO.unDDSR2.stcField.u1DDS18)  /*@bf@*/
#define GPIO_DDSR2_DDS19	(GPIO.unDDSR2.stcField.u1DDS19)  /*@bf@*/
#define GPIO_DDSR2_DDS20	(GPIO.unDDSR2.stcField.u1DDS20)  /*@bf@*/
#define GPIO_DDSR2_DDS21	(GPIO.unDDSR2.stcField.u1DDS21)  /*@bf@*/
#define GPIO_DDSR2_DDS22	(GPIO.unDDSR2.stcField.u1DDS22)  /*@bf@*/
#define GPIO_DDSR2_DDS23	(GPIO.unDDSR2.stcField.u1DDS23)  /*@bf@*/
#define GPIO_DDSR2_DDS24	(GPIO.unDDSR2.stcField.u1DDS24)  /*@bf@*/
#define GPIO_DDSR2_DDS25	(GPIO.unDDSR2.stcField.u1DDS25)  /*@bf@*/
#define GPIO_DDSR2_DDS26	(GPIO.unDDSR2.stcField.u1DDS26)  /*@bf@*/
#define GPIO_DDSR2_DDS27	(GPIO.unDDSR2.stcField.u1DDS27)  /*@bf@*/
#define GPIO_DDSR2_DDS28	(GPIO.unDDSR2.stcField.u1DDS28)  /*@bf@*/
#define GPIO_DDSR2_DDS29	(GPIO.unDDSR2.stcField.u1DDS29)  /*@bf@*/
#define GPIO_DDSR2_DDS30	(GPIO.unDDSR2.stcField.u1DDS30)  /*@bf@*/
#define GPIO_DDSR2_DDS31	(GPIO.unDDSR2.stcField.u1DDS31)  /*@bf@*/

#define GPIO_DDSR3	(GPIO.unDDSR3.u32Register)  /*@rg@*/
#define GPIO_DDSR3_DDS0	(GPIO.unDDSR3.stcField.u1DDS0)  /*@bf@*/
#define GPIO_DDSR3_DDS1	(GPIO.unDDSR3.stcField.u1DDS1)  /*@bf@*/
#define GPIO_DDSR3_DDS2	(GPIO.unDDSR3.stcField.u1DDS2)  /*@bf@*/
#define GPIO_DDSR3_DDS3	(GPIO.unDDSR3.stcField.u1DDS3)  /*@bf@*/
#define GPIO_DDSR3_DDS4	(GPIO.unDDSR3.stcField.u1DDS4)  /*@bf@*/
#define GPIO_DDSR3_DDS5	(GPIO.unDDSR3.stcField.u1DDS5)  /*@bf@*/
#define GPIO_DDSR3_DDS6	(GPIO.unDDSR3.stcField.u1DDS6)  /*@bf@*/
#define GPIO_DDSR3_DDS7	(GPIO.unDDSR3.stcField.u1DDS7)  /*@bf@*/
#define GPIO_DDSR3_DDS8	(GPIO.unDDSR3.stcField.u1DDS8)  /*@bf@*/
#define GPIO_DDSR3_DDS9	(GPIO.unDDSR3.stcField.u1DDS9)  /*@bf@*/
#define GPIO_DDSR3_DDS10	(GPIO.unDDSR3.stcField.u1DDS10)  /*@bf@*/
#define GPIO_DDSR3_DDS11	(GPIO.unDDSR3.stcField.u1DDS11)  /*@bf@*/
#define GPIO_DDSR3_DDS12	(GPIO.unDDSR3.stcField.u1DDS12)  /*@bf@*/
#define GPIO_DDSR3_DDS13	(GPIO.unDDSR3.stcField.u1DDS13)  /*@bf@*/
#define GPIO_DDSR3_DDS14	(GPIO.unDDSR3.stcField.u1DDS14)  /*@bf@*/
#define GPIO_DDSR3_DDS15	(GPIO.unDDSR3.stcField.u1DDS15)  /*@bf@*/
#define GPIO_DDSR3_DDS16	(GPIO.unDDSR3.stcField.u1DDS16)  /*@bf@*/
#define GPIO_DDSR3_DDS17	(GPIO.unDDSR3.stcField.u1DDS17)  /*@bf@*/
#define GPIO_DDSR3_DDS18	(GPIO.unDDSR3.stcField.u1DDS18)  /*@bf@*/
#define GPIO_DDSR3_DDS19	(GPIO.unDDSR3.stcField.u1DDS19)  /*@bf@*/
#define GPIO_DDSR3_DDS20	(GPIO.unDDSR3.stcField.u1DDS20)  /*@bf@*/
#define GPIO_DDSR3_DDS21	(GPIO.unDDSR3.stcField.u1DDS21)  /*@bf@*/
#define GPIO_DDSR3_DDS22	(GPIO.unDDSR3.stcField.u1DDS22)  /*@bf@*/
#define GPIO_DDSR3_DDS23	(GPIO.unDDSR3.stcField.u1DDS23)  /*@bf@*/
#define GPIO_DDSR3_DDS24	(GPIO.unDDSR3.stcField.u1DDS24)  /*@bf@*/
#define GPIO_DDSR3_DDS25	(GPIO.unDDSR3.stcField.u1DDS25)  /*@bf@*/
#define GPIO_DDSR3_DDS26	(GPIO.unDDSR3.stcField.u1DDS26)  /*@bf@*/
#define GPIO_DDSR3_DDS27	(GPIO.unDDSR3.stcField.u1DDS27)  /*@bf@*/
#define GPIO_DDSR3_DDS28	(GPIO.unDDSR3.stcField.u1DDS28)  /*@bf@*/
#define GPIO_DDSR3_DDS29	(GPIO.unDDSR3.stcField.u1DDS29)  /*@bf@*/
#define GPIO_DDSR3_DDS30	(GPIO.unDDSR3.stcField.u1DDS30)  /*@bf@*/
#define GPIO_DDSR3_DDS31	(GPIO.unDDSR3.stcField.u1DDS31)  /*@bf@*/

typedef struct stc_gpio_ddsrn_field{
    uint_io32_t		u1DDS0:1;
    uint_io32_t		u1DDS1:1;
    uint_io32_t		u1DDS2:1;
    uint_io32_t		u1DDS3:1;
    uint_io32_t		u1DDS4:1;
    uint_io32_t		u1DDS5:1;
    uint_io32_t		u1DDS6:1;
    uint_io32_t		u1DDS7:1;
    uint_io32_t		u1DDS8:1;
    uint_io32_t		u1DDS9:1;
    uint_io32_t		u1DDS10:1;
    uint_io32_t		u1DDS11:1;
    uint_io32_t		u1DDS12:1;
    uint_io32_t		u1DDS13:1;
    uint_io32_t		u1DDS14:1;
    uint_io32_t		u1DDS15:1;
    uint_io32_t		u1DDS16:1;
    uint_io32_t		u1DDS17:1;
    uint_io32_t		u1DDS18:1;
    uint_io32_t		u1DDS19:1;
    uint_io32_t		u1DDS20:1;
    uint_io32_t		u1DDS21:1;
    uint_io32_t		u1DDS22:1;
    uint_io32_t		u1DDS23:1;
    uint_io32_t		u1DDS24:1;
    uint_io32_t		u1DDS25:1;
    uint_io32_t		u1DDS26:1;
    uint_io32_t		u1DDS27:1;
    uint_io32_t		u1DDS28:1;
    uint_io32_t		u1DDS29:1;
    uint_io32_t		u1DDS30:1;
    uint_io32_t		u1DDS31:1;
}stc_gpio_ddsrn_field_t;

typedef union un_gpio_ddsrn{
    uint_io32_t		u32Register;
    stc_gpio_ddsrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_ddsrn_t;

/* DDCR[0-3] */
#define GPIO_DDCR0	(GPIO.unDDCR0.u32Register)  /*@rg@*/
#define GPIO_DDCR0_DDC0	(GPIO.unDDCR0.stcField.u1DDC0)  /*@bf@*/
#define GPIO_DDCR0_DDC1	(GPIO.unDDCR0.stcField.u1DDC1)  /*@bf@*/
#define GPIO_DDCR0_DDC2	(GPIO.unDDCR0.stcField.u1DDC2)  /*@bf@*/
#define GPIO_DDCR0_DDC3	(GPIO.unDDCR0.stcField.u1DDC3)  /*@bf@*/
#define GPIO_DDCR0_DDC4	(GPIO.unDDCR0.stcField.u1DDC4)  /*@bf@*/
#define GPIO_DDCR0_DDC5	(GPIO.unDDCR0.stcField.u1DDC5)  /*@bf@*/
#define GPIO_DDCR0_DDC6	(GPIO.unDDCR0.stcField.u1DDC6)  /*@bf@*/
#define GPIO_DDCR0_DDC7	(GPIO.unDDCR0.stcField.u1DDC7)  /*@bf@*/
#define GPIO_DDCR0_DDC8	(GPIO.unDDCR0.stcField.u1DDC8)  /*@bf@*/
#define GPIO_DDCR0_DDC9	(GPIO.unDDCR0.stcField.u1DDC9)  /*@bf@*/
#define GPIO_DDCR0_DDC10	(GPIO.unDDCR0.stcField.u1DDC10)  /*@bf@*/
#define GPIO_DDCR0_DDC11	(GPIO.unDDCR0.stcField.u1DDC11)  /*@bf@*/
#define GPIO_DDCR0_DDC12	(GPIO.unDDCR0.stcField.u1DDC12)  /*@bf@*/
#define GPIO_DDCR0_DDC13	(GPIO.unDDCR0.stcField.u1DDC13)  /*@bf@*/
#define GPIO_DDCR0_DDC14	(GPIO.unDDCR0.stcField.u1DDC14)  /*@bf@*/
#define GPIO_DDCR0_DDC15	(GPIO.unDDCR0.stcField.u1DDC15)  /*@bf@*/
#define GPIO_DDCR0_DDC16	(GPIO.unDDCR0.stcField.u1DDC16)  /*@bf@*/
#define GPIO_DDCR0_DDC17	(GPIO.unDDCR0.stcField.u1DDC17)  /*@bf@*/
#define GPIO_DDCR0_DDC18	(GPIO.unDDCR0.stcField.u1DDC18)  /*@bf@*/
#define GPIO_DDCR0_DDC19	(GPIO.unDDCR0.stcField.u1DDC19)  /*@bf@*/
#define GPIO_DDCR0_DDC20	(GPIO.unDDCR0.stcField.u1DDC20)  /*@bf@*/
#define GPIO_DDCR0_DDC21	(GPIO.unDDCR0.stcField.u1DDC21)  /*@bf@*/
#define GPIO_DDCR0_DDC22	(GPIO.unDDCR0.stcField.u1DDC22)  /*@bf@*/
#define GPIO_DDCR0_DDC23	(GPIO.unDDCR0.stcField.u1DDC23)  /*@bf@*/
#define GPIO_DDCR0_DDC24	(GPIO.unDDCR0.stcField.u1DDC24)  /*@bf@*/
#define GPIO_DDCR0_DDC25	(GPIO.unDDCR0.stcField.u1DDC25)  /*@bf@*/
#define GPIO_DDCR0_DDC26	(GPIO.unDDCR0.stcField.u1DDC26)  /*@bf@*/
#define GPIO_DDCR0_DDC27	(GPIO.unDDCR0.stcField.u1DDC27)  /*@bf@*/
#define GPIO_DDCR0_DDC28	(GPIO.unDDCR0.stcField.u1DDC28)  /*@bf@*/
#define GPIO_DDCR0_DDC29	(GPIO.unDDCR0.stcField.u1DDC29)  /*@bf@*/
#define GPIO_DDCR0_DDC30	(GPIO.unDDCR0.stcField.u1DDC30)  /*@bf@*/
#define GPIO_DDCR0_DDC31	(GPIO.unDDCR0.stcField.u1DDC31)  /*@bf@*/

#define GPIO_DDCR1	(GPIO.unDDCR1.u32Register)  /*@rg@*/
#define GPIO_DDCR1_DDC0	(GPIO.unDDCR1.stcField.u1DDC0)  /*@bf@*/
#define GPIO_DDCR1_DDC1	(GPIO.unDDCR1.stcField.u1DDC1)  /*@bf@*/
#define GPIO_DDCR1_DDC2	(GPIO.unDDCR1.stcField.u1DDC2)  /*@bf@*/
#define GPIO_DDCR1_DDC3	(GPIO.unDDCR1.stcField.u1DDC3)  /*@bf@*/
#define GPIO_DDCR1_DDC4	(GPIO.unDDCR1.stcField.u1DDC4)  /*@bf@*/
#define GPIO_DDCR1_DDC5	(GPIO.unDDCR1.stcField.u1DDC5)  /*@bf@*/
#define GPIO_DDCR1_DDC6	(GPIO.unDDCR1.stcField.u1DDC6)  /*@bf@*/
#define GPIO_DDCR1_DDC7	(GPIO.unDDCR1.stcField.u1DDC7)  /*@bf@*/
#define GPIO_DDCR1_DDC8	(GPIO.unDDCR1.stcField.u1DDC8)  /*@bf@*/
#define GPIO_DDCR1_DDC9	(GPIO.unDDCR1.stcField.u1DDC9)  /*@bf@*/
#define GPIO_DDCR1_DDC10	(GPIO.unDDCR1.stcField.u1DDC10)  /*@bf@*/
#define GPIO_DDCR1_DDC11	(GPIO.unDDCR1.stcField.u1DDC11)  /*@bf@*/
#define GPIO_DDCR1_DDC12	(GPIO.unDDCR1.stcField.u1DDC12)  /*@bf@*/
#define GPIO_DDCR1_DDC13	(GPIO.unDDCR1.stcField.u1DDC13)  /*@bf@*/
#define GPIO_DDCR1_DDC14	(GPIO.unDDCR1.stcField.u1DDC14)  /*@bf@*/
#define GPIO_DDCR1_DDC15	(GPIO.unDDCR1.stcField.u1DDC15)  /*@bf@*/
#define GPIO_DDCR1_DDC16	(GPIO.unDDCR1.stcField.u1DDC16)  /*@bf@*/
#define GPIO_DDCR1_DDC17	(GPIO.unDDCR1.stcField.u1DDC17)  /*@bf@*/
#define GPIO_DDCR1_DDC18	(GPIO.unDDCR1.stcField.u1DDC18)  /*@bf@*/
#define GPIO_DDCR1_DDC19	(GPIO.unDDCR1.stcField.u1DDC19)  /*@bf@*/
#define GPIO_DDCR1_DDC20	(GPIO.unDDCR1.stcField.u1DDC20)  /*@bf@*/
#define GPIO_DDCR1_DDC21	(GPIO.unDDCR1.stcField.u1DDC21)  /*@bf@*/
#define GPIO_DDCR1_DDC22	(GPIO.unDDCR1.stcField.u1DDC22)  /*@bf@*/
#define GPIO_DDCR1_DDC23	(GPIO.unDDCR1.stcField.u1DDC23)  /*@bf@*/
#define GPIO_DDCR1_DDC24	(GPIO.unDDCR1.stcField.u1DDC24)  /*@bf@*/
#define GPIO_DDCR1_DDC25	(GPIO.unDDCR1.stcField.u1DDC25)  /*@bf@*/
#define GPIO_DDCR1_DDC26	(GPIO.unDDCR1.stcField.u1DDC26)  /*@bf@*/
#define GPIO_DDCR1_DDC27	(GPIO.unDDCR1.stcField.u1DDC27)  /*@bf@*/
#define GPIO_DDCR1_DDC28	(GPIO.unDDCR1.stcField.u1DDC28)  /*@bf@*/
#define GPIO_DDCR1_DDC29	(GPIO.unDDCR1.stcField.u1DDC29)  /*@bf@*/
#define GPIO_DDCR1_DDC30	(GPIO.unDDCR1.stcField.u1DDC30)  /*@bf@*/
#define GPIO_DDCR1_DDC31	(GPIO.unDDCR1.stcField.u1DDC31)  /*@bf@*/

#define GPIO_DDCR2	(GPIO.unDDCR2.u32Register)  /*@rg@*/
#define GPIO_DDCR2_DDC0	(GPIO.unDDCR2.stcField.u1DDC0)  /*@bf@*/
#define GPIO_DDCR2_DDC1	(GPIO.unDDCR2.stcField.u1DDC1)  /*@bf@*/
#define GPIO_DDCR2_DDC2	(GPIO.unDDCR2.stcField.u1DDC2)  /*@bf@*/
#define GPIO_DDCR2_DDC3	(GPIO.unDDCR2.stcField.u1DDC3)  /*@bf@*/
#define GPIO_DDCR2_DDC4	(GPIO.unDDCR2.stcField.u1DDC4)  /*@bf@*/
#define GPIO_DDCR2_DDC5	(GPIO.unDDCR2.stcField.u1DDC5)  /*@bf@*/
#define GPIO_DDCR2_DDC6	(GPIO.unDDCR2.stcField.u1DDC6)  /*@bf@*/
#define GPIO_DDCR2_DDC7	(GPIO.unDDCR2.stcField.u1DDC7)  /*@bf@*/
#define GPIO_DDCR2_DDC8	(GPIO.unDDCR2.stcField.u1DDC8)  /*@bf@*/
#define GPIO_DDCR2_DDC9	(GPIO.unDDCR2.stcField.u1DDC9)  /*@bf@*/
#define GPIO_DDCR2_DDC10	(GPIO.unDDCR2.stcField.u1DDC10)  /*@bf@*/
#define GPIO_DDCR2_DDC11	(GPIO.unDDCR2.stcField.u1DDC11)  /*@bf@*/
#define GPIO_DDCR2_DDC12	(GPIO.unDDCR2.stcField.u1DDC12)  /*@bf@*/
#define GPIO_DDCR2_DDC13	(GPIO.unDDCR2.stcField.u1DDC13)  /*@bf@*/
#define GPIO_DDCR2_DDC14	(GPIO.unDDCR2.stcField.u1DDC14)  /*@bf@*/
#define GPIO_DDCR2_DDC15	(GPIO.unDDCR2.stcField.u1DDC15)  /*@bf@*/
#define GPIO_DDCR2_DDC16	(GPIO.unDDCR2.stcField.u1DDC16)  /*@bf@*/
#define GPIO_DDCR2_DDC17	(GPIO.unDDCR2.stcField.u1DDC17)  /*@bf@*/
#define GPIO_DDCR2_DDC18	(GPIO.unDDCR2.stcField.u1DDC18)  /*@bf@*/
#define GPIO_DDCR2_DDC19	(GPIO.unDDCR2.stcField.u1DDC19)  /*@bf@*/
#define GPIO_DDCR2_DDC20	(GPIO.unDDCR2.stcField.u1DDC20)  /*@bf@*/
#define GPIO_DDCR2_DDC21	(GPIO.unDDCR2.stcField.u1DDC21)  /*@bf@*/
#define GPIO_DDCR2_DDC22	(GPIO.unDDCR2.stcField.u1DDC22)  /*@bf@*/
#define GPIO_DDCR2_DDC23	(GPIO.unDDCR2.stcField.u1DDC23)  /*@bf@*/
#define GPIO_DDCR2_DDC24	(GPIO.unDDCR2.stcField.u1DDC24)  /*@bf@*/
#define GPIO_DDCR2_DDC25	(GPIO.unDDCR2.stcField.u1DDC25)  /*@bf@*/
#define GPIO_DDCR2_DDC26	(GPIO.unDDCR2.stcField.u1DDC26)  /*@bf@*/
#define GPIO_DDCR2_DDC27	(GPIO.unDDCR2.stcField.u1DDC27)  /*@bf@*/
#define GPIO_DDCR2_DDC28	(GPIO.unDDCR2.stcField.u1DDC28)  /*@bf@*/
#define GPIO_DDCR2_DDC29	(GPIO.unDDCR2.stcField.u1DDC29)  /*@bf@*/
#define GPIO_DDCR2_DDC30	(GPIO.unDDCR2.stcField.u1DDC30)  /*@bf@*/
#define GPIO_DDCR2_DDC31	(GPIO.unDDCR2.stcField.u1DDC31)  /*@bf@*/

#define GPIO_DDCR3	(GPIO.unDDCR3.u32Register)  /*@rg@*/
#define GPIO_DDCR3_DDC0	(GPIO.unDDCR3.stcField.u1DDC0)  /*@bf@*/
#define GPIO_DDCR3_DDC1	(GPIO.unDDCR3.stcField.u1DDC1)  /*@bf@*/
#define GPIO_DDCR3_DDC2	(GPIO.unDDCR3.stcField.u1DDC2)  /*@bf@*/
#define GPIO_DDCR3_DDC3	(GPIO.unDDCR3.stcField.u1DDC3)  /*@bf@*/
#define GPIO_DDCR3_DDC4	(GPIO.unDDCR3.stcField.u1DDC4)  /*@bf@*/
#define GPIO_DDCR3_DDC5	(GPIO.unDDCR3.stcField.u1DDC5)  /*@bf@*/
#define GPIO_DDCR3_DDC6	(GPIO.unDDCR3.stcField.u1DDC6)  /*@bf@*/
#define GPIO_DDCR3_DDC7	(GPIO.unDDCR3.stcField.u1DDC7)  /*@bf@*/
#define GPIO_DDCR3_DDC8	(GPIO.unDDCR3.stcField.u1DDC8)  /*@bf@*/
#define GPIO_DDCR3_DDC9	(GPIO.unDDCR3.stcField.u1DDC9)  /*@bf@*/
#define GPIO_DDCR3_DDC10	(GPIO.unDDCR3.stcField.u1DDC10)  /*@bf@*/
#define GPIO_DDCR3_DDC11	(GPIO.unDDCR3.stcField.u1DDC11)  /*@bf@*/
#define GPIO_DDCR3_DDC12	(GPIO.unDDCR3.stcField.u1DDC12)  /*@bf@*/
#define GPIO_DDCR3_DDC13	(GPIO.unDDCR3.stcField.u1DDC13)  /*@bf@*/
#define GPIO_DDCR3_DDC14	(GPIO.unDDCR3.stcField.u1DDC14)  /*@bf@*/
#define GPIO_DDCR3_DDC15	(GPIO.unDDCR3.stcField.u1DDC15)  /*@bf@*/
#define GPIO_DDCR3_DDC16	(GPIO.unDDCR3.stcField.u1DDC16)  /*@bf@*/
#define GPIO_DDCR3_DDC17	(GPIO.unDDCR3.stcField.u1DDC17)  /*@bf@*/
#define GPIO_DDCR3_DDC18	(GPIO.unDDCR3.stcField.u1DDC18)  /*@bf@*/
#define GPIO_DDCR3_DDC19	(GPIO.unDDCR3.stcField.u1DDC19)  /*@bf@*/
#define GPIO_DDCR3_DDC20	(GPIO.unDDCR3.stcField.u1DDC20)  /*@bf@*/
#define GPIO_DDCR3_DDC21	(GPIO.unDDCR3.stcField.u1DDC21)  /*@bf@*/
#define GPIO_DDCR3_DDC22	(GPIO.unDDCR3.stcField.u1DDC22)  /*@bf@*/
#define GPIO_DDCR3_DDC23	(GPIO.unDDCR3.stcField.u1DDC23)  /*@bf@*/
#define GPIO_DDCR3_DDC24	(GPIO.unDDCR3.stcField.u1DDC24)  /*@bf@*/
#define GPIO_DDCR3_DDC25	(GPIO.unDDCR3.stcField.u1DDC25)  /*@bf@*/
#define GPIO_DDCR3_DDC26	(GPIO.unDDCR3.stcField.u1DDC26)  /*@bf@*/
#define GPIO_DDCR3_DDC27	(GPIO.unDDCR3.stcField.u1DDC27)  /*@bf@*/
#define GPIO_DDCR3_DDC28	(GPIO.unDDCR3.stcField.u1DDC28)  /*@bf@*/
#define GPIO_DDCR3_DDC29	(GPIO.unDDCR3.stcField.u1DDC29)  /*@bf@*/
#define GPIO_DDCR3_DDC30	(GPIO.unDDCR3.stcField.u1DDC30)  /*@bf@*/
#define GPIO_DDCR3_DDC31	(GPIO.unDDCR3.stcField.u1DDC31)  /*@bf@*/

typedef struct stc_gpio_ddcrn_field{
    uint_io32_t		u1DDC0:1;
    uint_io32_t		u1DDC1:1;
    uint_io32_t		u1DDC2:1;
    uint_io32_t		u1DDC3:1;
    uint_io32_t		u1DDC4:1;
    uint_io32_t		u1DDC5:1;
    uint_io32_t		u1DDC6:1;
    uint_io32_t		u1DDC7:1;
    uint_io32_t		u1DDC8:1;
    uint_io32_t		u1DDC9:1;
    uint_io32_t		u1DDC10:1;
    uint_io32_t		u1DDC11:1;
    uint_io32_t		u1DDC12:1;
    uint_io32_t		u1DDC13:1;
    uint_io32_t		u1DDC14:1;
    uint_io32_t		u1DDC15:1;
    uint_io32_t		u1DDC16:1;
    uint_io32_t		u1DDC17:1;
    uint_io32_t		u1DDC18:1;
    uint_io32_t		u1DDC19:1;
    uint_io32_t		u1DDC20:1;
    uint_io32_t		u1DDC21:1;
    uint_io32_t		u1DDC22:1;
    uint_io32_t		u1DDC23:1;
    uint_io32_t		u1DDC24:1;
    uint_io32_t		u1DDC25:1;
    uint_io32_t		u1DDC26:1;
    uint_io32_t		u1DDC27:1;
    uint_io32_t		u1DDC28:1;
    uint_io32_t		u1DDC29:1;
    uint_io32_t		u1DDC30:1;
    uint_io32_t		u1DDC31:1;
}stc_gpio_ddcrn_field_t;

typedef union un_gpio_ddcrn{
    uint_io32_t		u32Register;
    stc_gpio_ddcrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_ddcrn_t;

/* PODR[0-3] */
#define GPIO_PODR0	(GPIO.unPODR0.u32Register)  /*@rg@*/
#define GPIO_PODR0_POD0	(GPIO.unPODR0.stcField.u1POD0)  /*@bf@*/
#define GPIO_PODR0_POD1	(GPIO.unPODR0.stcField.u1POD1)  /*@bf@*/
#define GPIO_PODR0_POD2	(GPIO.unPODR0.stcField.u1POD2)  /*@bf@*/
#define GPIO_PODR0_POD3	(GPIO.unPODR0.stcField.u1POD3)  /*@bf@*/
#define GPIO_PODR0_POD4	(GPIO.unPODR0.stcField.u1POD4)  /*@bf@*/
#define GPIO_PODR0_POD5	(GPIO.unPODR0.stcField.u1POD5)  /*@bf@*/
#define GPIO_PODR0_POD6	(GPIO.unPODR0.stcField.u1POD6)  /*@bf@*/
#define GPIO_PODR0_POD7	(GPIO.unPODR0.stcField.u1POD7)  /*@bf@*/
#define GPIO_PODR0_POD8	(GPIO.unPODR0.stcField.u1POD8)  /*@bf@*/
#define GPIO_PODR0_POD9	(GPIO.unPODR0.stcField.u1POD9)  /*@bf@*/
#define GPIO_PODR0_POD10	(GPIO.unPODR0.stcField.u1POD10)  /*@bf@*/
#define GPIO_PODR0_POD11	(GPIO.unPODR0.stcField.u1POD11)  /*@bf@*/
#define GPIO_PODR0_POD12	(GPIO.unPODR0.stcField.u1POD12)  /*@bf@*/
#define GPIO_PODR0_POD13	(GPIO.unPODR0.stcField.u1POD13)  /*@bf@*/
#define GPIO_PODR0_POD14	(GPIO.unPODR0.stcField.u1POD14)  /*@bf@*/
#define GPIO_PODR0_POD15	(GPIO.unPODR0.stcField.u1POD15)  /*@bf@*/
#define GPIO_PODR0_POD16	(GPIO.unPODR0.stcField.u1POD16)  /*@bf@*/
#define GPIO_PODR0_POD17	(GPIO.unPODR0.stcField.u1POD17)  /*@bf@*/
#define GPIO_PODR0_POD18	(GPIO.unPODR0.stcField.u1POD18)  /*@bf@*/
#define GPIO_PODR0_POD19	(GPIO.unPODR0.stcField.u1POD19)  /*@bf@*/
#define GPIO_PODR0_POD20	(GPIO.unPODR0.stcField.u1POD20)  /*@bf@*/
#define GPIO_PODR0_POD21	(GPIO.unPODR0.stcField.u1POD21)  /*@bf@*/
#define GPIO_PODR0_POD22	(GPIO.unPODR0.stcField.u1POD22)  /*@bf@*/
#define GPIO_PODR0_POD23	(GPIO.unPODR0.stcField.u1POD23)  /*@bf@*/
#define GPIO_PODR0_POD24	(GPIO.unPODR0.stcField.u1POD24)  /*@bf@*/
#define GPIO_PODR0_POD25	(GPIO.unPODR0.stcField.u1POD25)  /*@bf@*/
#define GPIO_PODR0_POD26	(GPIO.unPODR0.stcField.u1POD26)  /*@bf@*/
#define GPIO_PODR0_POD27	(GPIO.unPODR0.stcField.u1POD27)  /*@bf@*/
#define GPIO_PODR0_POD28	(GPIO.unPODR0.stcField.u1POD28)  /*@bf@*/
#define GPIO_PODR0_POD29	(GPIO.unPODR0.stcField.u1POD29)  /*@bf@*/
#define GPIO_PODR0_POD30	(GPIO.unPODR0.stcField.u1POD30)  /*@bf@*/
#define GPIO_PODR0_POD31	(GPIO.unPODR0.stcField.u1POD31)  /*@bf@*/

#define GPIO_PODR1	(GPIO.unPODR1.u32Register)  /*@rg@*/
#define GPIO_PODR1_POD0	(GPIO.unPODR1.stcField.u1POD0)  /*@bf@*/
#define GPIO_PODR1_POD1	(GPIO.unPODR1.stcField.u1POD1)  /*@bf@*/
#define GPIO_PODR1_POD2	(GPIO.unPODR1.stcField.u1POD2)  /*@bf@*/
#define GPIO_PODR1_POD3	(GPIO.unPODR1.stcField.u1POD3)  /*@bf@*/
#define GPIO_PODR1_POD4	(GPIO.unPODR1.stcField.u1POD4)  /*@bf@*/
#define GPIO_PODR1_POD5	(GPIO.unPODR1.stcField.u1POD5)  /*@bf@*/
#define GPIO_PODR1_POD6	(GPIO.unPODR1.stcField.u1POD6)  /*@bf@*/
#define GPIO_PODR1_POD7	(GPIO.unPODR1.stcField.u1POD7)  /*@bf@*/
#define GPIO_PODR1_POD8	(GPIO.unPODR1.stcField.u1POD8)  /*@bf@*/
#define GPIO_PODR1_POD9	(GPIO.unPODR1.stcField.u1POD9)  /*@bf@*/
#define GPIO_PODR1_POD10	(GPIO.unPODR1.stcField.u1POD10)  /*@bf@*/
#define GPIO_PODR1_POD11	(GPIO.unPODR1.stcField.u1POD11)  /*@bf@*/
#define GPIO_PODR1_POD12	(GPIO.unPODR1.stcField.u1POD12)  /*@bf@*/
#define GPIO_PODR1_POD13	(GPIO.unPODR1.stcField.u1POD13)  /*@bf@*/
#define GPIO_PODR1_POD14	(GPIO.unPODR1.stcField.u1POD14)  /*@bf@*/
#define GPIO_PODR1_POD15	(GPIO.unPODR1.stcField.u1POD15)  /*@bf@*/
#define GPIO_PODR1_POD16	(GPIO.unPODR1.stcField.u1POD16)  /*@bf@*/
#define GPIO_PODR1_POD17	(GPIO.unPODR1.stcField.u1POD17)  /*@bf@*/
#define GPIO_PODR1_POD18	(GPIO.unPODR1.stcField.u1POD18)  /*@bf@*/
#define GPIO_PODR1_POD19	(GPIO.unPODR1.stcField.u1POD19)  /*@bf@*/
#define GPIO_PODR1_POD20	(GPIO.unPODR1.stcField.u1POD20)  /*@bf@*/
#define GPIO_PODR1_POD21	(GPIO.unPODR1.stcField.u1POD21)  /*@bf@*/
#define GPIO_PODR1_POD22	(GPIO.unPODR1.stcField.u1POD22)  /*@bf@*/
#define GPIO_PODR1_POD23	(GPIO.unPODR1.stcField.u1POD23)  /*@bf@*/
#define GPIO_PODR1_POD24	(GPIO.unPODR1.stcField.u1POD24)  /*@bf@*/
#define GPIO_PODR1_POD25	(GPIO.unPODR1.stcField.u1POD25)  /*@bf@*/
#define GPIO_PODR1_POD26	(GPIO.unPODR1.stcField.u1POD26)  /*@bf@*/
#define GPIO_PODR1_POD27	(GPIO.unPODR1.stcField.u1POD27)  /*@bf@*/
#define GPIO_PODR1_POD28	(GPIO.unPODR1.stcField.u1POD28)  /*@bf@*/
#define GPIO_PODR1_POD29	(GPIO.unPODR1.stcField.u1POD29)  /*@bf@*/
#define GPIO_PODR1_POD30	(GPIO.unPODR1.stcField.u1POD30)  /*@bf@*/
#define GPIO_PODR1_POD31	(GPIO.unPODR1.stcField.u1POD31)  /*@bf@*/

#define GPIO_PODR2	(GPIO.unPODR2.u32Register)  /*@rg@*/
#define GPIO_PODR2_POD0	(GPIO.unPODR2.stcField.u1POD0)  /*@bf@*/
#define GPIO_PODR2_POD1	(GPIO.unPODR2.stcField.u1POD1)  /*@bf@*/
#define GPIO_PODR2_POD2	(GPIO.unPODR2.stcField.u1POD2)  /*@bf@*/
#define GPIO_PODR2_POD3	(GPIO.unPODR2.stcField.u1POD3)  /*@bf@*/
#define GPIO_PODR2_POD4	(GPIO.unPODR2.stcField.u1POD4)  /*@bf@*/
#define GPIO_PODR2_POD5	(GPIO.unPODR2.stcField.u1POD5)  /*@bf@*/
#define GPIO_PODR2_POD6	(GPIO.unPODR2.stcField.u1POD6)  /*@bf@*/
#define GPIO_PODR2_POD7	(GPIO.unPODR2.stcField.u1POD7)  /*@bf@*/
#define GPIO_PODR2_POD8	(GPIO.unPODR2.stcField.u1POD8)  /*@bf@*/
#define GPIO_PODR2_POD9	(GPIO.unPODR2.stcField.u1POD9)  /*@bf@*/
#define GPIO_PODR2_POD10	(GPIO.unPODR2.stcField.u1POD10)  /*@bf@*/
#define GPIO_PODR2_POD11	(GPIO.unPODR2.stcField.u1POD11)  /*@bf@*/
#define GPIO_PODR2_POD12	(GPIO.unPODR2.stcField.u1POD12)  /*@bf@*/
#define GPIO_PODR2_POD13	(GPIO.unPODR2.stcField.u1POD13)  /*@bf@*/
#define GPIO_PODR2_POD14	(GPIO.unPODR2.stcField.u1POD14)  /*@bf@*/
#define GPIO_PODR2_POD15	(GPIO.unPODR2.stcField.u1POD15)  /*@bf@*/
#define GPIO_PODR2_POD16	(GPIO.unPODR2.stcField.u1POD16)  /*@bf@*/
#define GPIO_PODR2_POD17	(GPIO.unPODR2.stcField.u1POD17)  /*@bf@*/
#define GPIO_PODR2_POD18	(GPIO.unPODR2.stcField.u1POD18)  /*@bf@*/
#define GPIO_PODR2_POD19	(GPIO.unPODR2.stcField.u1POD19)  /*@bf@*/
#define GPIO_PODR2_POD20	(GPIO.unPODR2.stcField.u1POD20)  /*@bf@*/
#define GPIO_PODR2_POD21	(GPIO.unPODR2.stcField.u1POD21)  /*@bf@*/
#define GPIO_PODR2_POD22	(GPIO.unPODR2.stcField.u1POD22)  /*@bf@*/
#define GPIO_PODR2_POD23	(GPIO.unPODR2.stcField.u1POD23)  /*@bf@*/
#define GPIO_PODR2_POD24	(GPIO.unPODR2.stcField.u1POD24)  /*@bf@*/
#define GPIO_PODR2_POD25	(GPIO.unPODR2.stcField.u1POD25)  /*@bf@*/
#define GPIO_PODR2_POD26	(GPIO.unPODR2.stcField.u1POD26)  /*@bf@*/
#define GPIO_PODR2_POD27	(GPIO.unPODR2.stcField.u1POD27)  /*@bf@*/
#define GPIO_PODR2_POD28	(GPIO.unPODR2.stcField.u1POD28)  /*@bf@*/
#define GPIO_PODR2_POD29	(GPIO.unPODR2.stcField.u1POD29)  /*@bf@*/
#define GPIO_PODR2_POD30	(GPIO.unPODR2.stcField.u1POD30)  /*@bf@*/
#define GPIO_PODR2_POD31	(GPIO.unPODR2.stcField.u1POD31)  /*@bf@*/

#define GPIO_PODR3	(GPIO.unPODR3.u32Register)  /*@rg@*/
#define GPIO_PODR3_POD0	(GPIO.unPODR3.stcField.u1POD0)  /*@bf@*/
#define GPIO_PODR3_POD1	(GPIO.unPODR3.stcField.u1POD1)  /*@bf@*/
#define GPIO_PODR3_POD2	(GPIO.unPODR3.stcField.u1POD2)  /*@bf@*/
#define GPIO_PODR3_POD3	(GPIO.unPODR3.stcField.u1POD3)  /*@bf@*/
#define GPIO_PODR3_POD4	(GPIO.unPODR3.stcField.u1POD4)  /*@bf@*/
#define GPIO_PODR3_POD5	(GPIO.unPODR3.stcField.u1POD5)  /*@bf@*/
#define GPIO_PODR3_POD6	(GPIO.unPODR3.stcField.u1POD6)  /*@bf@*/
#define GPIO_PODR3_POD7	(GPIO.unPODR3.stcField.u1POD7)  /*@bf@*/
#define GPIO_PODR3_POD8	(GPIO.unPODR3.stcField.u1POD8)  /*@bf@*/
#define GPIO_PODR3_POD9	(GPIO.unPODR3.stcField.u1POD9)  /*@bf@*/
#define GPIO_PODR3_POD10	(GPIO.unPODR3.stcField.u1POD10)  /*@bf@*/
#define GPIO_PODR3_POD11	(GPIO.unPODR3.stcField.u1POD11)  /*@bf@*/
#define GPIO_PODR3_POD12	(GPIO.unPODR3.stcField.u1POD12)  /*@bf@*/
#define GPIO_PODR3_POD13	(GPIO.unPODR3.stcField.u1POD13)  /*@bf@*/
#define GPIO_PODR3_POD14	(GPIO.unPODR3.stcField.u1POD14)  /*@bf@*/
#define GPIO_PODR3_POD15	(GPIO.unPODR3.stcField.u1POD15)  /*@bf@*/
#define GPIO_PODR3_POD16	(GPIO.unPODR3.stcField.u1POD16)  /*@bf@*/
#define GPIO_PODR3_POD17	(GPIO.unPODR3.stcField.u1POD17)  /*@bf@*/
#define GPIO_PODR3_POD18	(GPIO.unPODR3.stcField.u1POD18)  /*@bf@*/
#define GPIO_PODR3_POD19	(GPIO.unPODR3.stcField.u1POD19)  /*@bf@*/
#define GPIO_PODR3_POD20	(GPIO.unPODR3.stcField.u1POD20)  /*@bf@*/
#define GPIO_PODR3_POD21	(GPIO.unPODR3.stcField.u1POD21)  /*@bf@*/
#define GPIO_PODR3_POD22	(GPIO.unPODR3.stcField.u1POD22)  /*@bf@*/
#define GPIO_PODR3_POD23	(GPIO.unPODR3.stcField.u1POD23)  /*@bf@*/
#define GPIO_PODR3_POD24	(GPIO.unPODR3.stcField.u1POD24)  /*@bf@*/
#define GPIO_PODR3_POD25	(GPIO.unPODR3.stcField.u1POD25)  /*@bf@*/
#define GPIO_PODR3_POD26	(GPIO.unPODR3.stcField.u1POD26)  /*@bf@*/
#define GPIO_PODR3_POD27	(GPIO.unPODR3.stcField.u1POD27)  /*@bf@*/
#define GPIO_PODR3_POD28	(GPIO.unPODR3.stcField.u1POD28)  /*@bf@*/
#define GPIO_PODR3_POD29	(GPIO.unPODR3.stcField.u1POD29)  /*@bf@*/
#define GPIO_PODR3_POD30	(GPIO.unPODR3.stcField.u1POD30)  /*@bf@*/
#define GPIO_PODR3_POD31	(GPIO.unPODR3.stcField.u1POD31)  /*@bf@*/

typedef struct stc_gpio_podrn_field{
    uint_io32_t		u1POD0:1;
    uint_io32_t		u1POD1:1;
    uint_io32_t		u1POD2:1;
    uint_io32_t		u1POD3:1;
    uint_io32_t		u1POD4:1;
    uint_io32_t		u1POD5:1;
    uint_io32_t		u1POD6:1;
    uint_io32_t		u1POD7:1;
    uint_io32_t		u1POD8:1;
    uint_io32_t		u1POD9:1;
    uint_io32_t		u1POD10:1;
    uint_io32_t		u1POD11:1;
    uint_io32_t		u1POD12:1;
    uint_io32_t		u1POD13:1;
    uint_io32_t		u1POD14:1;
    uint_io32_t		u1POD15:1;
    uint_io32_t		u1POD16:1;
    uint_io32_t		u1POD17:1;
    uint_io32_t		u1POD18:1;
    uint_io32_t		u1POD19:1;
    uint_io32_t		u1POD20:1;
    uint_io32_t		u1POD21:1;
    uint_io32_t		u1POD22:1;
    uint_io32_t		u1POD23:1;
    uint_io32_t		u1POD24:1;
    uint_io32_t		u1POD25:1;
    uint_io32_t		u1POD26:1;
    uint_io32_t		u1POD27:1;
    uint_io32_t		u1POD28:1;
    uint_io32_t		u1POD29:1;
    uint_io32_t		u1POD30:1;
    uint_io32_t		u1POD31:1;
}stc_gpio_podrn_field_t;

typedef union un_gpio_podrn{
    uint_io32_t		u32Register;
    stc_gpio_podrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_podrn_t;

/* DDR[0-3] */
#define GPIO_DDR0	(GPIO.unDDR0.u32Register)  /*@rg@*/
#define GPIO_DDR0_DD0	(GPIO.unDDR0.stcField.u1DD0)  /*@bf@*/
#define GPIO_DDR0_DD1	(GPIO.unDDR0.stcField.u1DD1)  /*@bf@*/
#define GPIO_DDR0_DD2	(GPIO.unDDR0.stcField.u1DD2)  /*@bf@*/
#define GPIO_DDR0_DD3	(GPIO.unDDR0.stcField.u1DD3)  /*@bf@*/
#define GPIO_DDR0_DD4	(GPIO.unDDR0.stcField.u1DD4)  /*@bf@*/
#define GPIO_DDR0_DD5	(GPIO.unDDR0.stcField.u1DD5)  /*@bf@*/
#define GPIO_DDR0_DD6	(GPIO.unDDR0.stcField.u1DD6)  /*@bf@*/
#define GPIO_DDR0_DD7	(GPIO.unDDR0.stcField.u1DD7)  /*@bf@*/
#define GPIO_DDR0_DD8	(GPIO.unDDR0.stcField.u1DD8)  /*@bf@*/
#define GPIO_DDR0_DD9	(GPIO.unDDR0.stcField.u1DD9)  /*@bf@*/
#define GPIO_DDR0_DD10	(GPIO.unDDR0.stcField.u1DD10)  /*@bf@*/
#define GPIO_DDR0_DD11	(GPIO.unDDR0.stcField.u1DD11)  /*@bf@*/
#define GPIO_DDR0_DD12	(GPIO.unDDR0.stcField.u1DD12)  /*@bf@*/
#define GPIO_DDR0_DD13	(GPIO.unDDR0.stcField.u1DD13)  /*@bf@*/
#define GPIO_DDR0_DD14	(GPIO.unDDR0.stcField.u1DD14)  /*@bf@*/
#define GPIO_DDR0_DD15	(GPIO.unDDR0.stcField.u1DD15)  /*@bf@*/
#define GPIO_DDR0_DD16	(GPIO.unDDR0.stcField.u1DD16)  /*@bf@*/
#define GPIO_DDR0_DD17	(GPIO.unDDR0.stcField.u1DD17)  /*@bf@*/
#define GPIO_DDR0_DD18	(GPIO.unDDR0.stcField.u1DD18)  /*@bf@*/
#define GPIO_DDR0_DD19	(GPIO.unDDR0.stcField.u1DD19)  /*@bf@*/
#define GPIO_DDR0_DD20	(GPIO.unDDR0.stcField.u1DD20)  /*@bf@*/
#define GPIO_DDR0_DD21	(GPIO.unDDR0.stcField.u1DD21)  /*@bf@*/
#define GPIO_DDR0_DD22	(GPIO.unDDR0.stcField.u1DD22)  /*@bf@*/
#define GPIO_DDR0_DD23	(GPIO.unDDR0.stcField.u1DD23)  /*@bf@*/
#define GPIO_DDR0_DD24	(GPIO.unDDR0.stcField.u1DD24)  /*@bf@*/
#define GPIO_DDR0_DD25	(GPIO.unDDR0.stcField.u1DD25)  /*@bf@*/
#define GPIO_DDR0_DD26	(GPIO.unDDR0.stcField.u1DD26)  /*@bf@*/
#define GPIO_DDR0_DD27	(GPIO.unDDR0.stcField.u1DD27)  /*@bf@*/
#define GPIO_DDR0_DD28	(GPIO.unDDR0.stcField.u1DD28)  /*@bf@*/
#define GPIO_DDR0_DD29	(GPIO.unDDR0.stcField.u1DD29)  /*@bf@*/
#define GPIO_DDR0_DD30	(GPIO.unDDR0.stcField.u1DD30)  /*@bf@*/
#define GPIO_DDR0_DD31	(GPIO.unDDR0.stcField.u1DD31)  /*@bf@*/

#define GPIO_DDR1	(GPIO.unDDR1.u32Register)  /*@rg@*/
#define GPIO_DDR1_DD0	(GPIO.unDDR1.stcField.u1DD0)  /*@bf@*/
#define GPIO_DDR1_DD1	(GPIO.unDDR1.stcField.u1DD1)  /*@bf@*/
#define GPIO_DDR1_DD2	(GPIO.unDDR1.stcField.u1DD2)  /*@bf@*/
#define GPIO_DDR1_DD3	(GPIO.unDDR1.stcField.u1DD3)  /*@bf@*/
#define GPIO_DDR1_DD4	(GPIO.unDDR1.stcField.u1DD4)  /*@bf@*/
#define GPIO_DDR1_DD5	(GPIO.unDDR1.stcField.u1DD5)  /*@bf@*/
#define GPIO_DDR1_DD6	(GPIO.unDDR1.stcField.u1DD6)  /*@bf@*/
#define GPIO_DDR1_DD7	(GPIO.unDDR1.stcField.u1DD7)  /*@bf@*/
#define GPIO_DDR1_DD8	(GPIO.unDDR1.stcField.u1DD8)  /*@bf@*/
#define GPIO_DDR1_DD9	(GPIO.unDDR1.stcField.u1DD9)  /*@bf@*/
#define GPIO_DDR1_DD10	(GPIO.unDDR1.stcField.u1DD10)  /*@bf@*/
#define GPIO_DDR1_DD11	(GPIO.unDDR1.stcField.u1DD11)  /*@bf@*/
#define GPIO_DDR1_DD12	(GPIO.unDDR1.stcField.u1DD12)  /*@bf@*/
#define GPIO_DDR1_DD13	(GPIO.unDDR1.stcField.u1DD13)  /*@bf@*/
#define GPIO_DDR1_DD14	(GPIO.unDDR1.stcField.u1DD14)  /*@bf@*/
#define GPIO_DDR1_DD15	(GPIO.unDDR1.stcField.u1DD15)  /*@bf@*/
#define GPIO_DDR1_DD16	(GPIO.unDDR1.stcField.u1DD16)  /*@bf@*/
#define GPIO_DDR1_DD17	(GPIO.unDDR1.stcField.u1DD17)  /*@bf@*/
#define GPIO_DDR1_DD18	(GPIO.unDDR1.stcField.u1DD18)  /*@bf@*/
#define GPIO_DDR1_DD19	(GPIO.unDDR1.stcField.u1DD19)  /*@bf@*/
#define GPIO_DDR1_DD20	(GPIO.unDDR1.stcField.u1DD20)  /*@bf@*/
#define GPIO_DDR1_DD21	(GPIO.unDDR1.stcField.u1DD21)  /*@bf@*/
#define GPIO_DDR1_DD22	(GPIO.unDDR1.stcField.u1DD22)  /*@bf@*/
#define GPIO_DDR1_DD23	(GPIO.unDDR1.stcField.u1DD23)  /*@bf@*/
#define GPIO_DDR1_DD24	(GPIO.unDDR1.stcField.u1DD24)  /*@bf@*/
#define GPIO_DDR1_DD25	(GPIO.unDDR1.stcField.u1DD25)  /*@bf@*/
#define GPIO_DDR1_DD26	(GPIO.unDDR1.stcField.u1DD26)  /*@bf@*/
#define GPIO_DDR1_DD27	(GPIO.unDDR1.stcField.u1DD27)  /*@bf@*/
#define GPIO_DDR1_DD28	(GPIO.unDDR1.stcField.u1DD28)  /*@bf@*/
#define GPIO_DDR1_DD29	(GPIO.unDDR1.stcField.u1DD29)  /*@bf@*/
#define GPIO_DDR1_DD30	(GPIO.unDDR1.stcField.u1DD30)  /*@bf@*/
#define GPIO_DDR1_DD31	(GPIO.unDDR1.stcField.u1DD31)  /*@bf@*/

#define GPIO_DDR2	(GPIO.unDDR2.u32Register)  /*@rg@*/
#define GPIO_DDR2_DD0	(GPIO.unDDR2.stcField.u1DD0)  /*@bf@*/
#define GPIO_DDR2_DD1	(GPIO.unDDR2.stcField.u1DD1)  /*@bf@*/
#define GPIO_DDR2_DD2	(GPIO.unDDR2.stcField.u1DD2)  /*@bf@*/
#define GPIO_DDR2_DD3	(GPIO.unDDR2.stcField.u1DD3)  /*@bf@*/
#define GPIO_DDR2_DD4	(GPIO.unDDR2.stcField.u1DD4)  /*@bf@*/
#define GPIO_DDR2_DD5	(GPIO.unDDR2.stcField.u1DD5)  /*@bf@*/
#define GPIO_DDR2_DD6	(GPIO.unDDR2.stcField.u1DD6)  /*@bf@*/
#define GPIO_DDR2_DD7	(GPIO.unDDR2.stcField.u1DD7)  /*@bf@*/
#define GPIO_DDR2_DD8	(GPIO.unDDR2.stcField.u1DD8)  /*@bf@*/
#define GPIO_DDR2_DD9	(GPIO.unDDR2.stcField.u1DD9)  /*@bf@*/
#define GPIO_DDR2_DD10	(GPIO.unDDR2.stcField.u1DD10)  /*@bf@*/
#define GPIO_DDR2_DD11	(GPIO.unDDR2.stcField.u1DD11)  /*@bf@*/
#define GPIO_DDR2_DD12	(GPIO.unDDR2.stcField.u1DD12)  /*@bf@*/
#define GPIO_DDR2_DD13	(GPIO.unDDR2.stcField.u1DD13)  /*@bf@*/
#define GPIO_DDR2_DD14	(GPIO.unDDR2.stcField.u1DD14)  /*@bf@*/
#define GPIO_DDR2_DD15	(GPIO.unDDR2.stcField.u1DD15)  /*@bf@*/
#define GPIO_DDR2_DD16	(GPIO.unDDR2.stcField.u1DD16)  /*@bf@*/
#define GPIO_DDR2_DD17	(GPIO.unDDR2.stcField.u1DD17)  /*@bf@*/
#define GPIO_DDR2_DD18	(GPIO.unDDR2.stcField.u1DD18)  /*@bf@*/
#define GPIO_DDR2_DD19	(GPIO.unDDR2.stcField.u1DD19)  /*@bf@*/
#define GPIO_DDR2_DD20	(GPIO.unDDR2.stcField.u1DD20)  /*@bf@*/
#define GPIO_DDR2_DD21	(GPIO.unDDR2.stcField.u1DD21)  /*@bf@*/
#define GPIO_DDR2_DD22	(GPIO.unDDR2.stcField.u1DD22)  /*@bf@*/
#define GPIO_DDR2_DD23	(GPIO.unDDR2.stcField.u1DD23)  /*@bf@*/
#define GPIO_DDR2_DD24	(GPIO.unDDR2.stcField.u1DD24)  /*@bf@*/
#define GPIO_DDR2_DD25	(GPIO.unDDR2.stcField.u1DD25)  /*@bf@*/
#define GPIO_DDR2_DD26	(GPIO.unDDR2.stcField.u1DD26)  /*@bf@*/
#define GPIO_DDR2_DD27	(GPIO.unDDR2.stcField.u1DD27)  /*@bf@*/
#define GPIO_DDR2_DD28	(GPIO.unDDR2.stcField.u1DD28)  /*@bf@*/
#define GPIO_DDR2_DD29	(GPIO.unDDR2.stcField.u1DD29)  /*@bf@*/
#define GPIO_DDR2_DD30	(GPIO.unDDR2.stcField.u1DD30)  /*@bf@*/
#define GPIO_DDR2_DD31	(GPIO.unDDR2.stcField.u1DD31)  /*@bf@*/

#define GPIO_DDR3	(GPIO.unDDR3.u32Register)  /*@rg@*/
#define GPIO_DDR3_DD0	(GPIO.unDDR3.stcField.u1DD0)  /*@bf@*/
#define GPIO_DDR3_DD1	(GPIO.unDDR3.stcField.u1DD1)  /*@bf@*/
#define GPIO_DDR3_DD2	(GPIO.unDDR3.stcField.u1DD2)  /*@bf@*/
#define GPIO_DDR3_DD3	(GPIO.unDDR3.stcField.u1DD3)  /*@bf@*/
#define GPIO_DDR3_DD4	(GPIO.unDDR3.stcField.u1DD4)  /*@bf@*/
#define GPIO_DDR3_DD5	(GPIO.unDDR3.stcField.u1DD5)  /*@bf@*/
#define GPIO_DDR3_DD6	(GPIO.unDDR3.stcField.u1DD6)  /*@bf@*/
#define GPIO_DDR3_DD7	(GPIO.unDDR3.stcField.u1DD7)  /*@bf@*/
#define GPIO_DDR3_DD8	(GPIO.unDDR3.stcField.u1DD8)  /*@bf@*/
#define GPIO_DDR3_DD9	(GPIO.unDDR3.stcField.u1DD9)  /*@bf@*/
#define GPIO_DDR3_DD10	(GPIO.unDDR3.stcField.u1DD10)  /*@bf@*/
#define GPIO_DDR3_DD11	(GPIO.unDDR3.stcField.u1DD11)  /*@bf@*/
#define GPIO_DDR3_DD12	(GPIO.unDDR3.stcField.u1DD12)  /*@bf@*/
#define GPIO_DDR3_DD13	(GPIO.unDDR3.stcField.u1DD13)  /*@bf@*/
#define GPIO_DDR3_DD14	(GPIO.unDDR3.stcField.u1DD14)  /*@bf@*/
#define GPIO_DDR3_DD15	(GPIO.unDDR3.stcField.u1DD15)  /*@bf@*/
#define GPIO_DDR3_DD16	(GPIO.unDDR3.stcField.u1DD16)  /*@bf@*/
#define GPIO_DDR3_DD17	(GPIO.unDDR3.stcField.u1DD17)  /*@bf@*/
#define GPIO_DDR3_DD18	(GPIO.unDDR3.stcField.u1DD18)  /*@bf@*/
#define GPIO_DDR3_DD19	(GPIO.unDDR3.stcField.u1DD19)  /*@bf@*/
#define GPIO_DDR3_DD20	(GPIO.unDDR3.stcField.u1DD20)  /*@bf@*/
#define GPIO_DDR3_DD21	(GPIO.unDDR3.stcField.u1DD21)  /*@bf@*/
#define GPIO_DDR3_DD22	(GPIO.unDDR3.stcField.u1DD22)  /*@bf@*/
#define GPIO_DDR3_DD23	(GPIO.unDDR3.stcField.u1DD23)  /*@bf@*/
#define GPIO_DDR3_DD24	(GPIO.unDDR3.stcField.u1DD24)  /*@bf@*/
#define GPIO_DDR3_DD25	(GPIO.unDDR3.stcField.u1DD25)  /*@bf@*/
#define GPIO_DDR3_DD26	(GPIO.unDDR3.stcField.u1DD26)  /*@bf@*/
#define GPIO_DDR3_DD27	(GPIO.unDDR3.stcField.u1DD27)  /*@bf@*/
#define GPIO_DDR3_DD28	(GPIO.unDDR3.stcField.u1DD28)  /*@bf@*/
#define GPIO_DDR3_DD29	(GPIO.unDDR3.stcField.u1DD29)  /*@bf@*/
#define GPIO_DDR3_DD30	(GPIO.unDDR3.stcField.u1DD30)  /*@bf@*/
#define GPIO_DDR3_DD31	(GPIO.unDDR3.stcField.u1DD31)  /*@bf@*/

typedef struct stc_gpio_ddrn_field{
    uint_io32_t		u1DD0:1;
    uint_io32_t		u1DD1:1;
    uint_io32_t		u1DD2:1;
    uint_io32_t		u1DD3:1;
    uint_io32_t		u1DD4:1;
    uint_io32_t		u1DD5:1;
    uint_io32_t		u1DD6:1;
    uint_io32_t		u1DD7:1;
    uint_io32_t		u1DD8:1;
    uint_io32_t		u1DD9:1;
    uint_io32_t		u1DD10:1;
    uint_io32_t		u1DD11:1;
    uint_io32_t		u1DD12:1;
    uint_io32_t		u1DD13:1;
    uint_io32_t		u1DD14:1;
    uint_io32_t		u1DD15:1;
    uint_io32_t		u1DD16:1;
    uint_io32_t		u1DD17:1;
    uint_io32_t		u1DD18:1;
    uint_io32_t		u1DD19:1;
    uint_io32_t		u1DD20:1;
    uint_io32_t		u1DD21:1;
    uint_io32_t		u1DD22:1;
    uint_io32_t		u1DD23:1;
    uint_io32_t		u1DD24:1;
    uint_io32_t		u1DD25:1;
    uint_io32_t		u1DD26:1;
    uint_io32_t		u1DD27:1;
    uint_io32_t		u1DD28:1;
    uint_io32_t		u1DD29:1;
    uint_io32_t		u1DD30:1;
    uint_io32_t		u1DD31:1;
}stc_gpio_ddrn_field_t;

typedef union un_gpio_ddrn{
    uint_io32_t		u32Register;
    stc_gpio_ddrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_ddrn_t;

/* PIDR[0-3] */
#define GPIO_PIDR0	(GPIO.unPIDR0.u32Register)  /*@rg@*/
#define GPIO_PIDR0_PID0	(GPIO.unPIDR0.stcField.u1PID0)  /*@bf@*/
#define GPIO_PIDR0_PID1	(GPIO.unPIDR0.stcField.u1PID1)  /*@bf@*/
#define GPIO_PIDR0_PID2	(GPIO.unPIDR0.stcField.u1PID2)  /*@bf@*/
#define GPIO_PIDR0_PID3	(GPIO.unPIDR0.stcField.u1PID3)  /*@bf@*/
#define GPIO_PIDR0_PID4	(GPIO.unPIDR0.stcField.u1PID4)  /*@bf@*/
#define GPIO_PIDR0_PID5	(GPIO.unPIDR0.stcField.u1PID5)  /*@bf@*/
#define GPIO_PIDR0_PID6	(GPIO.unPIDR0.stcField.u1PID6)  /*@bf@*/
#define GPIO_PIDR0_PID7	(GPIO.unPIDR0.stcField.u1PID7)  /*@bf@*/
#define GPIO_PIDR0_PID8	(GPIO.unPIDR0.stcField.u1PID8)  /*@bf@*/
#define GPIO_PIDR0_PID9	(GPIO.unPIDR0.stcField.u1PID9)  /*@bf@*/
#define GPIO_PIDR0_PID10	(GPIO.unPIDR0.stcField.u1PID10)  /*@bf@*/
#define GPIO_PIDR0_PID11	(GPIO.unPIDR0.stcField.u1PID11)  /*@bf@*/
#define GPIO_PIDR0_PID12	(GPIO.unPIDR0.stcField.u1PID12)  /*@bf@*/
#define GPIO_PIDR0_PID13	(GPIO.unPIDR0.stcField.u1PID13)  /*@bf@*/
#define GPIO_PIDR0_PID14	(GPIO.unPIDR0.stcField.u1PID14)  /*@bf@*/
#define GPIO_PIDR0_PID15	(GPIO.unPIDR0.stcField.u1PID15)  /*@bf@*/
#define GPIO_PIDR0_PID16	(GPIO.unPIDR0.stcField.u1PID16)  /*@bf@*/
#define GPIO_PIDR0_PID17	(GPIO.unPIDR0.stcField.u1PID17)  /*@bf@*/
#define GPIO_PIDR0_PID18	(GPIO.unPIDR0.stcField.u1PID18)  /*@bf@*/
#define GPIO_PIDR0_PID19	(GPIO.unPIDR0.stcField.u1PID19)  /*@bf@*/
#define GPIO_PIDR0_PID20	(GPIO.unPIDR0.stcField.u1PID20)  /*@bf@*/
#define GPIO_PIDR0_PID21	(GPIO.unPIDR0.stcField.u1PID21)  /*@bf@*/
#define GPIO_PIDR0_PID22	(GPIO.unPIDR0.stcField.u1PID22)  /*@bf@*/
#define GPIO_PIDR0_PID23	(GPIO.unPIDR0.stcField.u1PID23)  /*@bf@*/
#define GPIO_PIDR0_PID24	(GPIO.unPIDR0.stcField.u1PID24)  /*@bf@*/
#define GPIO_PIDR0_PID25	(GPIO.unPIDR0.stcField.u1PID25)  /*@bf@*/
#define GPIO_PIDR0_PID26	(GPIO.unPIDR0.stcField.u1PID26)  /*@bf@*/
#define GPIO_PIDR0_PID27	(GPIO.unPIDR0.stcField.u1PID27)  /*@bf@*/
#define GPIO_PIDR0_PID28	(GPIO.unPIDR0.stcField.u1PID28)  /*@bf@*/
#define GPIO_PIDR0_PID29	(GPIO.unPIDR0.stcField.u1PID29)  /*@bf@*/
#define GPIO_PIDR0_PID30	(GPIO.unPIDR0.stcField.u1PID30)  /*@bf@*/
#define GPIO_PIDR0_PID31	(GPIO.unPIDR0.stcField.u1PID31)  /*@bf@*/

#define GPIO_PIDR1	(GPIO.unPIDR1.u32Register)  /*@rg@*/
#define GPIO_PIDR1_PID0	(GPIO.unPIDR1.stcField.u1PID0)  /*@bf@*/
#define GPIO_PIDR1_PID1	(GPIO.unPIDR1.stcField.u1PID1)  /*@bf@*/
#define GPIO_PIDR1_PID2	(GPIO.unPIDR1.stcField.u1PID2)  /*@bf@*/
#define GPIO_PIDR1_PID3	(GPIO.unPIDR1.stcField.u1PID3)  /*@bf@*/
#define GPIO_PIDR1_PID4	(GPIO.unPIDR1.stcField.u1PID4)  /*@bf@*/
#define GPIO_PIDR1_PID5	(GPIO.unPIDR1.stcField.u1PID5)  /*@bf@*/
#define GPIO_PIDR1_PID6	(GPIO.unPIDR1.stcField.u1PID6)  /*@bf@*/
#define GPIO_PIDR1_PID7	(GPIO.unPIDR1.stcField.u1PID7)  /*@bf@*/
#define GPIO_PIDR1_PID8	(GPIO.unPIDR1.stcField.u1PID8)  /*@bf@*/
#define GPIO_PIDR1_PID9	(GPIO.unPIDR1.stcField.u1PID9)  /*@bf@*/
#define GPIO_PIDR1_PID10	(GPIO.unPIDR1.stcField.u1PID10)  /*@bf@*/
#define GPIO_PIDR1_PID11	(GPIO.unPIDR1.stcField.u1PID11)  /*@bf@*/
#define GPIO_PIDR1_PID12	(GPIO.unPIDR1.stcField.u1PID12)  /*@bf@*/
#define GPIO_PIDR1_PID13	(GPIO.unPIDR1.stcField.u1PID13)  /*@bf@*/
#define GPIO_PIDR1_PID14	(GPIO.unPIDR1.stcField.u1PID14)  /*@bf@*/
#define GPIO_PIDR1_PID15	(GPIO.unPIDR1.stcField.u1PID15)  /*@bf@*/
#define GPIO_PIDR1_PID16	(GPIO.unPIDR1.stcField.u1PID16)  /*@bf@*/
#define GPIO_PIDR1_PID17	(GPIO.unPIDR1.stcField.u1PID17)  /*@bf@*/
#define GPIO_PIDR1_PID18	(GPIO.unPIDR1.stcField.u1PID18)  /*@bf@*/
#define GPIO_PIDR1_PID19	(GPIO.unPIDR1.stcField.u1PID19)  /*@bf@*/
#define GPIO_PIDR1_PID20	(GPIO.unPIDR1.stcField.u1PID20)  /*@bf@*/
#define GPIO_PIDR1_PID21	(GPIO.unPIDR1.stcField.u1PID21)  /*@bf@*/
#define GPIO_PIDR1_PID22	(GPIO.unPIDR1.stcField.u1PID22)  /*@bf@*/
#define GPIO_PIDR1_PID23	(GPIO.unPIDR1.stcField.u1PID23)  /*@bf@*/
#define GPIO_PIDR1_PID24	(GPIO.unPIDR1.stcField.u1PID24)  /*@bf@*/
#define GPIO_PIDR1_PID25	(GPIO.unPIDR1.stcField.u1PID25)  /*@bf@*/
#define GPIO_PIDR1_PID26	(GPIO.unPIDR1.stcField.u1PID26)  /*@bf@*/
#define GPIO_PIDR1_PID27	(GPIO.unPIDR1.stcField.u1PID27)  /*@bf@*/
#define GPIO_PIDR1_PID28	(GPIO.unPIDR1.stcField.u1PID28)  /*@bf@*/
#define GPIO_PIDR1_PID29	(GPIO.unPIDR1.stcField.u1PID29)  /*@bf@*/
#define GPIO_PIDR1_PID30	(GPIO.unPIDR1.stcField.u1PID30)  /*@bf@*/
#define GPIO_PIDR1_PID31	(GPIO.unPIDR1.stcField.u1PID31)  /*@bf@*/

#define GPIO_PIDR2	(GPIO.unPIDR2.u32Register)  /*@rg@*/
#define GPIO_PIDR2_PID0	(GPIO.unPIDR2.stcField.u1PID0)  /*@bf@*/
#define GPIO_PIDR2_PID1	(GPIO.unPIDR2.stcField.u1PID1)  /*@bf@*/
#define GPIO_PIDR2_PID2	(GPIO.unPIDR2.stcField.u1PID2)  /*@bf@*/
#define GPIO_PIDR2_PID3	(GPIO.unPIDR2.stcField.u1PID3)  /*@bf@*/
#define GPIO_PIDR2_PID4	(GPIO.unPIDR2.stcField.u1PID4)  /*@bf@*/
#define GPIO_PIDR2_PID5	(GPIO.unPIDR2.stcField.u1PID5)  /*@bf@*/
#define GPIO_PIDR2_PID6	(GPIO.unPIDR2.stcField.u1PID6)  /*@bf@*/
#define GPIO_PIDR2_PID7	(GPIO.unPIDR2.stcField.u1PID7)  /*@bf@*/
#define GPIO_PIDR2_PID8	(GPIO.unPIDR2.stcField.u1PID8)  /*@bf@*/
#define GPIO_PIDR2_PID9	(GPIO.unPIDR2.stcField.u1PID9)  /*@bf@*/
#define GPIO_PIDR2_PID10	(GPIO.unPIDR2.stcField.u1PID10)  /*@bf@*/
#define GPIO_PIDR2_PID11	(GPIO.unPIDR2.stcField.u1PID11)  /*@bf@*/
#define GPIO_PIDR2_PID12	(GPIO.unPIDR2.stcField.u1PID12)  /*@bf@*/
#define GPIO_PIDR2_PID13	(GPIO.unPIDR2.stcField.u1PID13)  /*@bf@*/
#define GPIO_PIDR2_PID14	(GPIO.unPIDR2.stcField.u1PID14)  /*@bf@*/
#define GPIO_PIDR2_PID15	(GPIO.unPIDR2.stcField.u1PID15)  /*@bf@*/
#define GPIO_PIDR2_PID16	(GPIO.unPIDR2.stcField.u1PID16)  /*@bf@*/
#define GPIO_PIDR2_PID17	(GPIO.unPIDR2.stcField.u1PID17)  /*@bf@*/
#define GPIO_PIDR2_PID18	(GPIO.unPIDR2.stcField.u1PID18)  /*@bf@*/
#define GPIO_PIDR2_PID19	(GPIO.unPIDR2.stcField.u1PID19)  /*@bf@*/
#define GPIO_PIDR2_PID20	(GPIO.unPIDR2.stcField.u1PID20)  /*@bf@*/
#define GPIO_PIDR2_PID21	(GPIO.unPIDR2.stcField.u1PID21)  /*@bf@*/
#define GPIO_PIDR2_PID22	(GPIO.unPIDR2.stcField.u1PID22)  /*@bf@*/
#define GPIO_PIDR2_PID23	(GPIO.unPIDR2.stcField.u1PID23)  /*@bf@*/
#define GPIO_PIDR2_PID24	(GPIO.unPIDR2.stcField.u1PID24)  /*@bf@*/
#define GPIO_PIDR2_PID25	(GPIO.unPIDR2.stcField.u1PID25)  /*@bf@*/
#define GPIO_PIDR2_PID26	(GPIO.unPIDR2.stcField.u1PID26)  /*@bf@*/
#define GPIO_PIDR2_PID27	(GPIO.unPIDR2.stcField.u1PID27)  /*@bf@*/
#define GPIO_PIDR2_PID28	(GPIO.unPIDR2.stcField.u1PID28)  /*@bf@*/
#define GPIO_PIDR2_PID29	(GPIO.unPIDR2.stcField.u1PID29)  /*@bf@*/
#define GPIO_PIDR2_PID30	(GPIO.unPIDR2.stcField.u1PID30)  /*@bf@*/
#define GPIO_PIDR2_PID31	(GPIO.unPIDR2.stcField.u1PID31)  /*@bf@*/

#define GPIO_PIDR3	(GPIO.unPIDR3.u32Register)  /*@rg@*/
#define GPIO_PIDR3_PID0	(GPIO.unPIDR3.stcField.u1PID0)  /*@bf@*/
#define GPIO_PIDR3_PID1	(GPIO.unPIDR3.stcField.u1PID1)  /*@bf@*/
#define GPIO_PIDR3_PID2	(GPIO.unPIDR3.stcField.u1PID2)  /*@bf@*/
#define GPIO_PIDR3_PID3	(GPIO.unPIDR3.stcField.u1PID3)  /*@bf@*/
#define GPIO_PIDR3_PID4	(GPIO.unPIDR3.stcField.u1PID4)  /*@bf@*/
#define GPIO_PIDR3_PID5	(GPIO.unPIDR3.stcField.u1PID5)  /*@bf@*/
#define GPIO_PIDR3_PID6	(GPIO.unPIDR3.stcField.u1PID6)  /*@bf@*/
#define GPIO_PIDR3_PID7	(GPIO.unPIDR3.stcField.u1PID7)  /*@bf@*/
#define GPIO_PIDR3_PID8	(GPIO.unPIDR3.stcField.u1PID8)  /*@bf@*/
#define GPIO_PIDR3_PID9	(GPIO.unPIDR3.stcField.u1PID9)  /*@bf@*/
#define GPIO_PIDR3_PID10	(GPIO.unPIDR3.stcField.u1PID10)  /*@bf@*/
#define GPIO_PIDR3_PID11	(GPIO.unPIDR3.stcField.u1PID11)  /*@bf@*/
#define GPIO_PIDR3_PID12	(GPIO.unPIDR3.stcField.u1PID12)  /*@bf@*/
#define GPIO_PIDR3_PID13	(GPIO.unPIDR3.stcField.u1PID13)  /*@bf@*/
#define GPIO_PIDR3_PID14	(GPIO.unPIDR3.stcField.u1PID14)  /*@bf@*/
#define GPIO_PIDR3_PID15	(GPIO.unPIDR3.stcField.u1PID15)  /*@bf@*/
#define GPIO_PIDR3_PID16	(GPIO.unPIDR3.stcField.u1PID16)  /*@bf@*/
#define GPIO_PIDR3_PID17	(GPIO.unPIDR3.stcField.u1PID17)  /*@bf@*/
#define GPIO_PIDR3_PID18	(GPIO.unPIDR3.stcField.u1PID18)  /*@bf@*/
#define GPIO_PIDR3_PID19	(GPIO.unPIDR3.stcField.u1PID19)  /*@bf@*/
#define GPIO_PIDR3_PID20	(GPIO.unPIDR3.stcField.u1PID20)  /*@bf@*/
#define GPIO_PIDR3_PID21	(GPIO.unPIDR3.stcField.u1PID21)  /*@bf@*/
#define GPIO_PIDR3_PID22	(GPIO.unPIDR3.stcField.u1PID22)  /*@bf@*/
#define GPIO_PIDR3_PID23	(GPIO.unPIDR3.stcField.u1PID23)  /*@bf@*/
#define GPIO_PIDR3_PID24	(GPIO.unPIDR3.stcField.u1PID24)  /*@bf@*/
#define GPIO_PIDR3_PID25	(GPIO.unPIDR3.stcField.u1PID25)  /*@bf@*/
#define GPIO_PIDR3_PID26	(GPIO.unPIDR3.stcField.u1PID26)  /*@bf@*/
#define GPIO_PIDR3_PID27	(GPIO.unPIDR3.stcField.u1PID27)  /*@bf@*/
#define GPIO_PIDR3_PID28	(GPIO.unPIDR3.stcField.u1PID28)  /*@bf@*/
#define GPIO_PIDR3_PID29	(GPIO.unPIDR3.stcField.u1PID29)  /*@bf@*/
#define GPIO_PIDR3_PID30	(GPIO.unPIDR3.stcField.u1PID30)  /*@bf@*/
#define GPIO_PIDR3_PID31	(GPIO.unPIDR3.stcField.u1PID31)  /*@bf@*/

typedef struct stc_gpio_pidrn_field{
    uint_io32_t		u1PID0:1;
    uint_io32_t		u1PID1:1;
    uint_io32_t		u1PID2:1;
    uint_io32_t		u1PID3:1;
    uint_io32_t		u1PID4:1;
    uint_io32_t		u1PID5:1;
    uint_io32_t		u1PID6:1;
    uint_io32_t		u1PID7:1;
    uint_io32_t		u1PID8:1;
    uint_io32_t		u1PID9:1;
    uint_io32_t		u1PID10:1;
    uint_io32_t		u1PID11:1;
    uint_io32_t		u1PID12:1;
    uint_io32_t		u1PID13:1;
    uint_io32_t		u1PID14:1;
    uint_io32_t		u1PID15:1;
    uint_io32_t		u1PID16:1;
    uint_io32_t		u1PID17:1;
    uint_io32_t		u1PID18:1;
    uint_io32_t		u1PID19:1;
    uint_io32_t		u1PID20:1;
    uint_io32_t		u1PID21:1;
    uint_io32_t		u1PID22:1;
    uint_io32_t		u1PID23:1;
    uint_io32_t		u1PID24:1;
    uint_io32_t		u1PID25:1;
    uint_io32_t		u1PID26:1;
    uint_io32_t		u1PID27:1;
    uint_io32_t		u1PID28:1;
    uint_io32_t		u1PID29:1;
    uint_io32_t		u1PID30:1;
    uint_io32_t		u1PID31:1;
}stc_gpio_pidrn_field_t;

typedef union un_gpio_pidrn{
    uint_io32_t		u32Register;
    stc_gpio_pidrn_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_pidrn_t;

/* PORTEN */
#define GPIO_PORTEN	(GPIO.unPORTEN.u32Register)  /*@rg@*/
#define GPIO_PORTEN_GPORTEN	(GPIO.unPORTEN.stcField.u1GPORTEN)  /*@bf@*/

typedef struct stc_gpio_porten_field{
    uint_io32_t		u1GPORTEN:1;
    uint_io32_t		:31;
}stc_gpio_porten_field_t;

typedef union un_gpio_porten{
    uint_io32_t		u32Register;
    stc_gpio_porten_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_porten_t;

/* KEYCDR */
#define GPIO_KEYCDR	(GPIO.unKEYCDR.u32Register)  /*@rg@*/
#define GPIO_KEYCDR_RADR	(GPIO.unKEYCDR.stcField.u15RADR)  /*@bf@*/
#define GPIO_KEYCDR_SIZE	(GPIO.unKEYCDR.stcField.u2SIZE)  /*@bf@*/
#define GPIO_KEYCDR_KEY	(GPIO.unKEYCDR.stcField.u2KEY)  /*@bf@*/

typedef struct stc_gpio_keycdr_field{
    uint_io32_t		u15RADR:15;
    uint_io32_t		:13;
    uint_io32_t		u2SIZE:2;
    uint_io32_t		u2KEY:2;
}stc_gpio_keycdr_field_t;

typedef union un_gpio_keycdr{
    uint_io32_t		u32Register;
    stc_gpio_keycdr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gpio_keycdr_t;


typedef struct stc_gpio{
    un_gpio_posrn_t	unPOSR0;	/* 0x00000000 */
    un_gpio_pocrn_t	unPOCR0;	/* 0x00000004 */
    un_gpio_ddsrn_t	unDDSR0;	/* 0x00000008 */
    un_gpio_ddcrn_t	unDDCR0;	/* 0x0000000C */
    un_gpio_posrn_t	unPOSR1;	/* 0x00000010 */
    un_gpio_pocrn_t	unPOCR1;	/* 0x00000014 */
    un_gpio_ddsrn_t	unDDSR1;	/* 0x00000018 */
    un_gpio_ddcrn_t	unDDCR1;	/* 0x0000001C */
    un_gpio_posrn_t	unPOSR2;	/* 0x00000020 */
    un_gpio_pocrn_t	unPOCR2;	/* 0x00000024 */
    un_gpio_ddsrn_t	unDDSR2;	/* 0x00000028 */
    un_gpio_ddcrn_t	unDDCR2;	/* 0x0000002C */
    un_gpio_posrn_t	unPOSR3;	/* 0x00000030 */
    un_gpio_pocrn_t	unPOCR3;	/* 0x00000034 */
    un_gpio_ddsrn_t	unDDSR3;	/* 0x00000038 */
    un_gpio_ddcrn_t	unDDCR3;	/* 0x0000003C */
    uint_io8_t	au8Reserved0[448];	/* 0x00000040 */
    un_gpio_podrn_t	unPODR0;	/* 0x00000200 */
    un_gpio_ddrn_t	unDDR0;	/* 0x00000204 */
    un_gpio_podrn_t	unPODR1;	/* 0x00000208 */
    un_gpio_ddrn_t	unDDR1;	/* 0x0000020C */
    un_gpio_podrn_t	unPODR2;	/* 0x00000210 */
    un_gpio_ddrn_t	unDDR2;	/* 0x00000214 */
    un_gpio_podrn_t	unPODR3;	/* 0x00000218 */
    un_gpio_ddrn_t	unDDR3;	/* 0x0000021C */
    uint_io8_t	au8Reserved1[224];	/* 0x00000220 */
    un_gpio_pidrn_t	unPIDR0;	/* 0x00000300 */
    un_gpio_pidrn_t	unPIDR1;	/* 0x00000304 */
    un_gpio_pidrn_t	unPIDR2;	/* 0x00000308 */
    un_gpio_pidrn_t	unPIDR3;	/* 0x0000030C */
    uint_io8_t	au8Reserved2[240];	/* 0x00000310 */
    un_gpio_porten_t	unPORTEN;	/* 0x00000400 */
    un_gpio_keycdr_t	unKEYCDR;	/* 0x00000404 */
    uint_io8_t	au8Reserved3[31736];	/* 0x00000408 */
}stc_gpio_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_gpio_t	stcGPIO;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 32768(0x8000) bytes */


#endif /* __S6J3360_GPIO_H */
