/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_GT_H
#define __S6J3360_GT_H

#include "s6j3360io_basetypes.h"

/* GT base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define GT	stcGT
#else /* __IO_DEFINE */
#define GT	(*((volatile stc_gt_t*)0xB488B000))
#endif /* __IO_DEFINE */

/* CPCLR */
#define GT_CPCLR	(GT.unCPCLR.u16Register)  /*@rg@*/
#define GT_CPCLR_CL	GT_CPCLR  /*@bfrg@*/

typedef union un_gt_cpclr{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_gt_cpclr_t;

/* TCDT */
#define GT_TCDT	(GT.unTCDT.u16Register)  /*@rg@*/
#define GT_TCDT_T	GT_TCDT  /*@bfrg@*/

typedef union un_gt_tcdt{
    uint_io16_t		u16Register;
    uint_io8_t		au8Byte[2];
}un_gt_tcdt_t;

/* TCCS */
#define GT_TCCS	(GT.unTCCS.u32Register)  /*@rg@*/
#define GT_TCCS_CLK	(GT.unTCCS.stcField.u4CLK)  /*@bf@*/
#define GT_TCCS_STOP	(GT.unTCCS.stcField.u1STOP)  /*@bf@*/
#define GT_TCCS_ICRE	(GT.unTCCS.stcField.u1ICRE)  /*@bf@*/
#define GT_TCCS_ICLR	(GT.unTCCS.stcField.u1ICLR)  /*@bf@*/
#define GT_TCCS_MSI	(GT.unTCCS.stcField.u3MSI)  /*@bf@*/

typedef struct stc_gt_tccs_field{
    uint_io32_t		u4CLK:4;
    uint_io32_t		:2;
    uint_io32_t		u1STOP:1;
    uint_io32_t		:1;
    uint_io32_t		u1ICRE:1;
    uint_io32_t		u1ICLR:1;
    uint_io32_t		u3MSI:3;
    uint_io32_t		:19;
}stc_gt_tccs_field_t;

typedef union un_gt_tccs{
    uint_io32_t		u32Register;
    stc_gt_tccs_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gt_tccs_t;

/* TCCSC */
#define GT_TCCSC	(GT.unTCCSC.u32Register)  /*@rg@*/
#define GT_TCCSC_STOPC	(GT.unTCCSC.stcField.u1STOPC)  /*@bf@*/
#define GT_TCCSC_ICREC	(GT.unTCCSC.stcField.u1ICREC)  /*@bf@*/
#define GT_TCCSC_ICLRC	(GT.unTCCSC.stcField.u1ICLRC)  /*@bf@*/

typedef struct stc_gt_tccsc_field{
    uint_io32_t		:6;
    uint_io32_t		u1STOPC:1;
    uint_io32_t		:1;
    uint_io32_t		u1ICREC:1;
    uint_io32_t		u1ICLRC:1;
    uint_io32_t		:22;
}stc_gt_tccsc_field_t;

typedef union un_gt_tccsc{
    uint_io32_t		u32Register;
    stc_gt_tccsc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gt_tccsc_t;

/* TCCSS */
#define GT_TCCSS	(GT.unTCCSS.u32Register)  /*@rg@*/
#define GT_TCCSS_STOPS	(GT.unTCCSS.stcField.u1STOPS)  /*@bf@*/
#define GT_TCCSS_ICRES	(GT.unTCCSS.stcField.u1ICRES)  /*@bf@*/

typedef struct stc_gt_tccss_field{
    uint_io32_t		:6;
    uint_io32_t		u1STOPS:1;
    uint_io32_t		:1;
    uint_io32_t		u1ICRES:1;
    uint_io32_t		:23;
}stc_gt_tccss_field_t;

typedef union un_gt_tccss{
    uint_io32_t		u32Register;
    stc_gt_tccss_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gt_tccss_t;

/* DEBUG */
#define GT_DEBUG	(GT.unDEBUG.u16Register)  /*@rg@*/
#define GT_DEBUG_DBGEN	(GT.unDEBUG.stcField.u1DBGEN)  /*@bf@*/

typedef struct stc_gt_debug_field{
    uint_io16_t		u1DBGEN:1;
    uint_io16_t		:15;
}stc_gt_debug_field_t;

typedef union un_gt_debug{
    uint_io16_t		u16Register;
    stc_gt_debug_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_gt_debug_t;

/* MSCTR */
#define GT_MSCTR	(GT.unMSCTR.u32Register)  /*@rg@*/
#define GT_MSCTR_GTMOE	(GT.unMSCTR.stcField.u1GTMOE)  /*@bf@*/
#define GT_MSCTR_MODE	(GT.unMSCTR.stcField.u1MODE)  /*@bf@*/
#define GT_MSCTR_TREN	(GT.unMSCTR.stcField.u1TREN)  /*@bf@*/

typedef struct stc_gt_msctr_field{
    uint_io32_t		u1GTMOE:1;
    uint_io32_t		u1MODE:1;
    uint_io32_t		u1TREN:1;
    uint_io32_t		:29;
}stc_gt_msctr_field_t;

typedef union un_gt_msctr{
    uint_io32_t		u32Register;
    stc_gt_msctr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gt_msctr_t;

/* MSCHB[0-1] */
#define GT_MSCHB0	(GT.unMSCHB0.u32Register)  /*@rg@*/
#define GT_MSCHB0_GTCH	GT_MSCHB0  /*@bfrg@*/

#define GT_MSCHB1	(GT.unMSCHB1.u32Register)  /*@rg@*/
#define GT_MSCHB1_GTCH	GT_MSCHB1  /*@bfrg@*/

typedef union un_gt_mschbn{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gt_mschbn_t;

/* MSCH[0-1] */
#define GT_MSCH0	(GT.unMSCH0.u32Register)  /*@rg@*/
#define GT_MSCH0_GTCHR	GT_MSCH0  /*@bfrg@*/

#define GT_MSCH1	(GT.unMSCH1.u32Register)  /*@rg@*/
#define GT_MSCH1_GTCHR	GT_MSCH1  /*@bfrg@*/

typedef union un_gt_mschn{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_gt_mschn_t;


typedef struct stc_gt{
    un_gt_cpclr_t	unCPCLR;	/* 0x00000000 */
    uint_io8_t	au8Reserved0[2];	/* 0x00000002 */
    un_gt_tcdt_t	unTCDT;	/* 0x00000004 */
    uint_io8_t	au8Reserved1[2];	/* 0x00000006 */
    un_gt_tccs_t	unTCCS;	/* 0x00000008 */
    uint_io8_t	au8Reserved2[4];	/* 0x0000000C */
    un_gt_tccsc_t	unTCCSC;	/* 0x00000010 */
    un_gt_tccss_t	unTCCSS;	/* 0x00000014 */
    un_gt_debug_t	unDEBUG;	/* 0x00000018 */
    uint_io8_t	au8Reserved3[6];	/* 0x0000001A */
    un_gt_msctr_t	unMSCTR;	/* 0x00000020 */
    un_gt_mschbn_t	unMSCHB0;	/* 0x00000024 */
    un_gt_mschbn_t	unMSCHB1;	/* 0x00000028 */
    un_gt_mschn_t	unMSCH0;	/* 0x0000002C */
    un_gt_mschn_t	unMSCH1;	/* 0x00000030 */
    uint_io8_t	au8Reserved4[972];	/* 0x00000034 */
}stc_gt_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_gt_t	stcGT;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 1024(0x400) bytes */


#endif /* __S6J3360_GT_H */
