#include "RTE_CAN.h"
#include "CAN_Lib.h"
#include "CAN_APP.h"
#include "CAN_Communication_Matrix.h"
#include "Analog_Signals.h"
#include "RSCAN.h"
#include "Key.h"

uint8_t CrcCheckSum(uint8_t *data, uint8_t len)
{
    uint8_t crc        = 0xff;
    uint8_t CRC_POLY   = 0x2f;
    uint8_t crcxor     = 0xff;
    uint8_t bit_index  = 0;
    uint8_t byte_index = 0;

    for ( byte_index = 0; byte_index < len; ++byte_index )
    {
        crc ^= data [ byte_index ];
        for ( bit_index = 0; bit_index < 8; ++bit_index )
        {
            if ( (crc & 0x80) != 0 )
                crc = (crc << 1) ^ CRC_POLY;
            else
                crc = (crc << 1);
        }
    }

    crc = crc ^ crcxor;

    return crc;
}



void CAN_MSG_COUNTER_PLUS(void)
{
}
void  Can_Set_Buff_200(uint8_t CopyData [])
{
    uint8_t i = 0u;
    uint32_t wtemp = 0u;
    CANMsg220Union *pCANMsg;

    pCANMsg = (CANMsg220Union *)CopyData;
    
    if ( pCANMsg != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg->Msg [ i ] = 0u;
        }
    }

    pCANMsg->Sig.Vspeeed = Vspeed;

}
void  Can_Set_Buff_481(uint8_t CopyData [])
{
    uint8_t i = 0u;
    uint32_t wtemp = 0u;
    CANMsg481Union *pCANMsg;

    pCANMsg = (CANMsg481Union *)CopyData;
    
    if ( pCANMsg != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg->Msg [ i ] = 0u;
        }
    }
    pCANMsg->Sig.Year   = 1;
    pCANMsg->Sig.Month  = 1;
    pCANMsg->Sig.Day    = 1;
    pCANMsg->Sig.Minute = 0;
    pCANMsg->Sig.Second = 0;
    pCANMsg->Sig.Hour   = Hour;

}

void  Can_Set_Buff_020(uint8_t CopyData [])
{
    uint8_t i = 0u;
    uint32_t wtemp = 0u;
    CANMsg020Union *pCANMsg;

    pCANMsg = (CANMsg020Union *)CopyData;
    
    if ( pCANMsg != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg->Msg [ i ] = 0u;
        }
    }


    pCANMsg->Sig.Eletricity_H = Eletricity >> 8;
    pCANMsg->Sig.Eletricity_L = Eletricity & 0xff;
}

void  Can_Set_Buff_042(uint8_t CopyData [])
{
    uint8_t i = 0u;
    uint32_t wtemp = 0u;
    CANMsg042Union *pCANMsg;

    pCANMsg = (CANMsg042Union *)CopyData;
    
    if ( pCANMsg != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg->Msg [ i ] = 0u;
        }
    }
    if(Tcs == 1)
    {
        pCANMsg->Sig.Tcs_mode = 1;
        pCANMsg->Sig.Tcs_Control = 1;
    }
    else if(Tcs == 2)
    {
        pCANMsg->Sig.Tcs_Control = 1;
    }
    else
    {
        ;
    }
}

void  Can_Set_Buff_480(uint8_t CopyData [])
{
    uint8_t i = 0u;
    uint32_t wtemp = 0u;
    CANMsg480Union *pCANMsg;

    pCANMsg = (CANMsg480Union *)CopyData;
    
    if ( pCANMsg != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg->Msg [ i ] = 0u;
        }
    }
    pCANMsg->Sig.Signal_Gps = Signal_GPS;
    pCANMsg->Sig.Signal_4g = Signal_4G;
}

void  Can_Set_Buff_280(uint8_t CopyData [])
{
    uint8_t i = 0u;
    uint32_t wtemp = 0u;
    CANMsg280Union *pCANMsg;

    pCANMsg = (CANMsg280Union *)CopyData;
    
    if ( pCANMsg != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg->Msg [ i ] = 0u;
        }
    }
    if(Energy_recovery == 2)
    {
        pCANMsg->Sig.Energy_status = 1;
        pCANMsg->Sig.Energy_recovery = 2;
        pCANMsg->Sig.Side_bracket = 1;
    }
    else if(Energy_recovery == 1)
    {
        pCANMsg->Sig.Energy_status = 1;
        pCANMsg->Sig.Energy_recovery = 1;
    }
    else if(Energy_recovery == 3)
    {
        pCANMsg->Sig.Energy_status = 1;
        pCANMsg->Sig.Energy_recovery = 3;
    }
    else
    {
        ;
    }

    if(Tcs == 1)
    {
        pCANMsg->Sig.Tcs_Status = 1;
    }
}

void  Can_Set_Buff_202(uint8_t CopyData [])
{
    uint8_t i = 0u;
    uint32_t wtemp = 0u;
    CANMsg202Union *pCANMsg;

    pCANMsg = (CANMsg202Union *)CopyData;
    
    if ( pCANMsg != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg->Msg [ i ] = 0u;
        }
    }
    if(Gear == 0)
    {
        pCANMsg->Sig.Gear = 0;
    }
    else if(Gear == 1)
    {
        pCANMsg->Sig.Gear = 1;
    }
    else if(Gear == 2)
    {
        pCANMsg->Sig.Gear = 2;
    }

    if(Cruiste == 1)
    {
        pCANMsg->Sig.Cruiste = 1;
    }

    if(Ready == 1)
    {
        pCANMsg->Sig.Ready = 1;
    }
    else if(Ready == 2)
    {
        pCANMsg->Sig.Ready = 2;
    }
    else if(Ready == 3 )
    {
        pCANMsg->Sig.Ready = 3;
    }
    if(Fault == 1)
    {
        pCANMsg->Sig.Fault = 1;
    }
}
void  Can_Set_Buff_001(uint8_t CopyData [])
{
    uint8_t i = 0u;
    uint32_t wtemp = 0u;
    CANMsg001Union *pCANMsg;

    pCANMsg = (CANMsg001Union *)CopyData;
    
    if ( pCANMsg != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg->Msg [ i ] = 0u;
        }
    }
    if(Motor_hert == 1)
    {
        pCANMsg->Sig.Motor_hert = 1;
    }
}

void  Can_Set_Buff_021(uint8_t CopyData [])
{
    uint8_t i = 0u;
    uint32_t wtemp = 0u;
    CANMsg021Union *pCANMsg;

    pCANMsg = (CANMsg021Union *)CopyData;
    
    if ( pCANMsg != ( void * )0 )
    {
        for ( i = 0u; i < 8u; i++ )
        {
            pCANMsg->Msg [ i ] = 0u;
        }
    }

    if(Battery_temp == 1)
    {
        pCANMsg->Sig.Battery_temp = 1;
    }
}
