#ifndef KEY_H__
#define KEY_H__

#include "TYW_stdint.h"

#define Check_KeepTime  3000 //每个步骤保持时间 
#define Check_Couont  11 //多少个步骤 


typedef enum
{
    KEY_1,
    KEY_2,
    KEY_3,
    KEY_4,
    KEY_5,
    KEY_6,
    KEY_7,
    KEY_8,
    KEY_9,
    KEY_10,
    KEY_NUM_MAX,
} Key_Num_en_t;

/*--------------------------Do not modify the following--------------------------------*/
/*--------------------------Do not modify the following--------------------------------*/
/*--------------------------Do not modify the following--------------------------------*/
typedef enum
{
    KEY_TYPE_CAN = 0U,
    KEY_TYPE_LINE,

} Key_Type_en_t;

typedef enum
{
    KEY_SET_OK = 0U,
    KEY_SET_ERROR,

    KEY_SET_MAX,
} Key_Set_en_t;

typedef enum
{
    KEY_CAN_NONE = 0U,
    KEY_CAN_SHORT_PRESS,
    KEY_CAN_LONG_PRESS,
    KEY_LINE_PRESS,
    KEY_LINE_LOOSEN,

    KEY_REAL_STATUS_MAX,
} Key_Real_Status_en_t;

typedef enum
{
    KEY_EVENT_NONE = 0U,
    KEY_EVENT_SHORT_PRESS,
    KEY_EVENT_LONG_PRESS,
    KEY_EVENT_SUPER_LONG_PRESS,

    KEY_EVENT_MAX,

} Key_Event_en_t;

typedef Key_Real_Status_en_t (*Key_Real_Status_Read)(void);
typedef void (*Key_Operation)(Key_Event_en_t enKeyEvent);

typedef struct
{
    Key_Type_en_t        enKeyType;
    Key_Real_Status_Read pfnKeyReadStatusCallBack;
    Key_Operation        pfnKeyOperationCallBack;

} Key_Attribute_st_t;

/*--------------------------------------------------------------------------------------------*/
extern const Key_Attribute_st_t stKeyAttribute [ KEY_NUM_MAX ];
extern Key_Real_Status_en_t     enKeyLeftRealStatus;
extern Key_Real_Status_en_t     enKeyRightRealStatus;

/*------------------------------------------------------------------------------------*/
extern void Key_Init(void);
extern void Key_Service(void); /*10ms*/

extern Key_Set_en_t Key_Parameter_Set_Short_Press_Time(uint16_t u16Time);
extern Key_Set_en_t Key_Parameter_Set_Long_Press_Time(uint16_t u16Time);
extern Key_Set_en_t Key_Parameter_Set_Super_Long_Press_Time(uint32_t u32Time);
extern uint8_t Check_Steps;
extern void User_CheckMode_Service(uint8_t CbkCycle);
extern void  User_CanSend(uint8_t steps);

extern uint8_t Vspeed;
extern uint8_t Signal_4G;
extern uint8_t Signal_GPS;
extern uint16_t Eletricity;
extern uint8_t Hour;
extern uint8_t Tcs;
extern uint8_t Energy_recovery;
extern uint8_t Gear;
extern uint8_t Ready;
extern uint8_t Cruiste;
extern uint8_t Fault;
extern uint8_t Motor_hert;
extern uint8_t Battery_temp;





#endif

