#include "common_include.h"
#include "s6j3360_RIC.h"
#include "abstract.h"

/*-------------------------------------------------------------------------
* Function Name  : bsp_SDA_IN
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_SDA_IN(void)
{
    stc_port_pin_config_t stc_port_pin_config1_09 = { .enOutputFunction      = PortOutputResourceGPIO,
        .enOutputDrive         = PortOutputDriveA,
        .enPullResistor        = PortPullResistorNone,
        .enInputLevel          = PortInputLevelCmosA,
        .bInputEnable          = TRUE,
        .bNoiseFilterEnable    = FALSE,
        .enGpioDirection       = PortGpioInput,
    .enGpioInitOutputLevel = PortGpioLow};
    Port_SetPinConfig( 1, 9, &stc_port_pin_config1_09 );
    Port_EnableInput();
}
/*-------------------------------------------------------------------------
* Function Name  : bsp_SDA_OUT
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_SDA_OUT(void)
{
    stc_port_pin_config_t stc_port_pin_config1_09 = { .enOutputFunction      = PortOutputResourceGPIO,
        .enOutputDrive         = PortOutputDriveA,
        .enPullResistor        = PortPullResistorNone,
        .enInputLevel          = PortInputLevelCmosA,
        .bInputEnable          = FALSE,
        .bNoiseFilterEnable    = TRUE,
        .enGpioDirection       = PortGpioOutput,
    .enGpioInitOutputLevel = PortGpioLow};
    Port_SetPinConfig( 1, 9, &stc_port_pin_config1_09 );
}
/*-------------------------------------------------------------------------
* Function Name  : bsp_SDA_GetValue
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
unsigned char bsp_SDA_GetValue(void)
{
    unsigned char i = 0;

    en_port_gpio_level_t temp;
    Port_GetPortPinLevel(1,9,(en_port_gpio_level_t*)(&temp));
    i = (unsigned char)(temp);

    return i;
    
}

/*-------------------------------------------------------------------------
* Function Name  : bsp_SCL_Set
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_SCL_Set(unsigned char data)
{

   Port_SetPortPinLevel(1,8,(en_port_gpio_level_t)data);

}


/*-------------------------------------------------------------------------
* Function Name  : bsp_SDA_Set
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_SDA_Set(unsigned char data)
{

   Port_SetPortPinLevel(1,9,(en_port_gpio_level_t)data);

}

/*-------------------------------------------------------------------------
* Function Name  : ClearDog
* Description    :  DOG
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void ClearDog(void)
{

    bsp_HDOG_Feed();

}

/*-------------------------------------------------------------------------
* Function Name  : ClearDog
* Description    :  DOG
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_NOP(void)
{
    NOP();
}
/*-------------------------------------------------------------------------
* Function Name  : bsp_Save_Check_Service
* Description    : ݶ-д--
* Input          : SaveSt -1read -2write -3clear
* Output         : None
* Return         : -3:True -other:Flase
* onther         : xxhh
--------------------------------------------------------------------------*/
DATA_SAVE_PACK NewData;
uint8_t bsp_Save_Check_Service(uint8_t SaveS)
{
    DATA_SAVE_PACK CheckData;
    
    if(SaveS == 1)//read
    {
        memset((void*)&CheckData, 0, sizeof (CheckData));
        if(bsp_IIC_SequentialRead(0xa2,32,(uint8_t*)&CheckData,sizeof(CheckData)) == 1)
        {
            if((CheckData.Head1 == 0x5A) && (CheckData.Head2 == 0xA5) && (CheckData.Tail == 0xFF))
            {
                memcpy(&NewData, &CheckData, sizeof (CheckData));
                return 1;
            }
            else
                return 3; 
        }
        else
            return 2;  
    }
    else if(SaveS == 2)//write
    {
        if((NewData.Head1 == 0x5A) && (NewData.Head2 == 0xA5) && (NewData.Tail == 0xFF))
        {
            if(bsp_IIC_WritePage(0xa2,32,(uint8_t*)&NewData,sizeof(NewData)) == 1)
                return 1;
            else
                return 5;
        }
        else
            return 4;
    } 
    else if(SaveS == 3)//clear
    {
        if((NewData.Head1 == 0x5A) && (NewData.Head2 == 0xA5) && (NewData.Tail == 0xFF))
        {
            NewData.Data1 = 0;
            NewData.Data2 = 0;
            NewData.Data3 = 0;
            NewData.Data4 = 0;
          
            if(bsp_IIC_WritePage(0xa2,32,(uint8_t*)&NewData,sizeof(NewData)) == 1)
                return 1;
            else
                return 7;
        }
        else
            return 6;
    }
}

/*-------------------------------------------------------------------------
* Function Name  : SavePro
* Description    : 
* Input          : SaveState
* Output         : None
* Return         : None
* onther         : xxhh
--------------------------------------------------------------------------*/

uint8_t SaveState,OldSaveState;
void SavePro()
{
    static uint8_t i = 0;
    uint8_t Savebuf = 0;
    
    if(SaveState != OldSaveState)
    {
        Savebuf = bsp_Save_Check_Service(SaveState);
        if(Savebuf == 1)
        {
            i = 0;
            SaveState = 0;
            OldSaveState = 0;
        }
        else if(Savebuf == 3)
        {
            SaveState = 2;
            i++;
        }
        else
           i++; 
        if(i >= 10)
        {
            SaveState = 0;
            OldSaveState = 0;
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : 汾Ŵȡ
* Description    : 
* Input          : SaveState
* Output         : None
* Return         : None
* onther         : xxhh
--------------------------------------------------------------------------*/

uint8_t bsp_eeprom_write(uint8_t  PhyAdd,uint8_t  MemAdd, uint8_t *Data,uint8_t len)
{
    return bsp_IIC_WritePage(PhyAdd, MemAdd, Data, len);
}

uint8_t SaveVINPara(void)
{
    VIN_PACK data;
    VIN_PACK rdata;
    memset((void*)&data, 0, sizeof (data));
    
    ReadVINPara(&rdata);
    if ((memcmp(&rdata.VIN[0], &VIN_NumberBuf[0], 10) != 0)) {
        data.Head1 = ODO_PACK_HEAD1;
        data.Head2 = ODO_PACK_HEAD2;
        memcpy(&data.VIN[0], &VIN_NumberBuf[0], 10);  
        data.COUNT = VIN_Count;
        data.Tail = ODO_PACK_TAIL;
        if (bsp_eeprom_write(SAVE_VIN_BLOCK, SAVE_VIN_ADDR, (uint8_t*)&data, 16) == 0) {
            return 0; 
        }
        bsp_IIC_DelayUs(8500);
        if (bsp_eeprom_write(SAVE_VIN_BLOCK, (SAVE_VIN_ADDR + 16), (uint8_t*)&data + 0x10, sizeof (data) - 16) == 0) {
            return 0;
        }
        
        return 1;
    }
    return 2;
}

void InitVINPara(void)
{
    VIN_PACK data;
    if (ReadVINPara(&data)) {     
        memcpy(&VIN_NumberBuf[0], &data.VIN[0], 10);
        VIN_Count =  data.COUNT;
    } else {   
        memset(&VIN_NumberBuf[0],0x0,10);
        VIN_Count =  2;
        SaveVINPara();
    }  
}

uint8_t ReadVINPara(VIN_PACK *retdata)
{
    uint8_t checksum;   
    VIN_PACK data;
    memset((void*)&data, 0, sizeof (data));
    bsp_IIC_SequentialRead(SAVE_VIN_BLOCK, SAVE_VIN_ADDR, (uint8_t*)&data, sizeof (data));                                       
    if (data.Head1 != ODO_PACK_HEAD1) {
        return 0;    
    }
    if (data.Head2 != ODO_PACK_HEAD2) {
        return 0;        
    }
    if (data.Tail != ODO_PACK_TAIL) {
        return 0;
    }
//    checksum = GenerateCheckSum((uint8_t*)&data.VIN[0], 17); 
//    if (checksum != data.CheckSum) {
//        return 0;
//    }
    
    memcpy(retdata, &data, sizeof (data));
    
    return 1;
}


