#ifndef BSP_PRESS_KEY_H_
#define BSP_PRESS_KEY_H_

#define KEY_NONE        0
#define KEY_30          1
#define KEY_15          2
#define KEY_SW1_MENU    3
#define KEY_SW1_UP      4
#define KEY_SW1_DOWN    5
#define KEY_SW1_OK      6
#define KEY_GRIB_UP     7
#define KEY_GRIB_DOWN   8
#define KEY_GRIB_PUSH   9
#define KEY_GRIB_LOW    10
#define KEY_SW2_CRUISE  11
#define KEY_SW1_UP_LONG 12
#define KEY_SW1_OK_LONG 13
#define KEY_GRIB_TrationMode_LOW 14

#define TIME_0      0
#define TIME_10     10
#define TIME_20     20
#define TIME_30     30
#define TIME_40     40
#define TIME_50     50
#define TIME_100    100
#define TIME_200    200
#define TIME_250    250
#define TIME_300    300
#define TIME_350    350
#define TIME_400    400
#define TIME_500    500
#define TIME_600    600
#define TIME_650    650
#define TIME_700    700
#define TIME_800    800
#define TIME_900    900
#define TIME_1000   1000
#define TIME_1500   1500
#define TIME_2000   2000
#define TIME_2100   2100
#define TIME_2200   2200
#define TIME_2300   2300
#define TIME_2400   2400
#define TIME_2500   2500
#define TIME_3000   3000
#define TIME_3500   3500
#define TIME_4000   4000
#define TIME_4500   4500
#define TIME_5000   5000


#define TRIPSW_OK_LONG_PRESS   0
#define TRIPSW_SHORT_PRESS     1
#define GRIB_SHORT_PRESS       2
#define GRIB_LONG_PRESS        3
#define TRIPSW_UP_LONG_PRESS   4

typedef struct tagGribPressStep{
    uint8_t uiStep1;
    uint8_t uiStep2;
    uint8_t uiStep3;
    uint8_t uiStep4;
    uint8_t uiStep5;
    uint8_t uiStep6;
    uint8_t uiStep7;
    uint8_t uiStep8;
    uint8_t uiStep9;
    uint8_t uiStep10;
}ST_PRESS_KEY_STEP;

#define  SetPressKeySequence(step1,step2,step3,step4,step5,step6,step7,step8,step9,step10)\
    g_stPressKeyStep.uiStep1 = step1;\
    g_stPressKeyStep.uiStep2 = step2;\
    g_stPressKeyStep.uiStep3 = step3;\
    g_stPressKeyStep.uiStep4 = step4;\
    g_stPressKeyStep.uiStep5 = step5;\
    g_stPressKeyStep.uiStep6 = step6;\
    g_stPressKeyStep.uiStep7 = step7;\
    g_stPressKeyStep.uiStep8 = step8;\
    g_stPressKeyStep.uiStep9 = step9;\
    g_stPressKeyStep.uiStep10 = step10
    
extern ST_PRESS_KEY_STEP g_stPressKeyStep;    
extern void PressStateReset(void);
extern uint8_t GetPressUpOver(void);
extern void PressKey(uint32_t uiCurStepPress,uint8_t uiKeyType,uint8_t uiPressType);
extern void EnableSimulation(uint8_t uiEnableFlag);
extern uint8_t GetStepTimer(void);
extern void SetStepTimer(uint32_t uiStepTimer);
extern uint8_t GetCurrentStep(void);
extern void SetCurrentStep(uint8_t uiStep);
extern void InitPressKeySimulation(void);
extern void DoPressKeySimulation(uint32_t uiFirstStepWaitTime);
extern void DoPressKey30(void);
extern void DoPressKey15(void);
extern void DoPressKeyMENU(void);
extern void DoPressKeyUP(void);
extern void DoPressKeyDOWN(void);
extern void DoPressKeyOK(void);
extern void DoPressKeyGribUP(void);
extern void DoPressKeyGribDOWN(void);
extern void DoPressKeyGribPUSH(void);
extern void DoPressKeyGribLow(void);
extern void PressGribCtrlSW_HighLevel(void);
extern void PressGribCtrlSW_LowLevel(void);
#endif
