#include "common_include.h"
#include "bsp_button.h"
#include "bsp_speed_check.h"
#include "bsp_app_led_output.h"
#include "bsp_app_tft_output.h"



uint8_t DMS_ECO = 0;
uint8_t DMS_SPORT = 0;
uint8_t DMS_SPORTPLUS = 0;
uint8_t DMS_NORMAL = 0;
uint8_t DMS_SMART = 0;
uint8_t DMS_Smart_EcoColor = 0;
uint8_t DMS_Smart_SportColor = 0;
uint8_t DMS_Smart_SmartColor = 0;
uint8_t DMS_Snow = 0;
uint8_t DMS_Mud = 0;
uint8_t DMS_Sand = 0;
uint8_t g_ElseDmsMaxCheckSteps = 0;
uint8_t g_ElseMaxCheckSteps = 0;

void PowerReset(void){
    if ((ElseCurrent.Time > 10) && (ElseCurrent.Time < 1010)) {
        //LampState_L.Lamps.RELAY_B = 1;
        //LampState_L.Lamps.RELAY_IGN1 = 0;
        //LampState_L.Lamps.RELAY_IGN3 = 0;

    } else if ((ElseCurrent.Time > 1010) && (ElseCurrent.Time < 1500)) {
        //LampState_L.Lamps.RELAY_B = 1;
        //LampState_L.Lamps.RELAY_IGN1 = 1;
        //LampState_L.Lamps.RELAY_IGN3 = 0;
    }  else {
        PowerCheckFlag = POWER_CHECK_END;
    }
}

void DMS_PressGribUp(void)
{
}

void DMS_PressGribDown(void)
{
}


void DMS_Press(void)
{
#if ((PRO_QXI) || (PRO_SP2) || (PRO_QX23) || (PRO_NQ5C))
    DMS_PressGribDown();
#endif
#if ((PRO_LX2) || (PRO_AX) || (PRO_ONPE))
    if(ElseCurrent.count == 1){ 
        DMS_PressGribDown();
    }
    else if(ElseCurrent.count == 2 ) {
        DMS_PressGribUp();
    }
    else if(ElseCurrent.count == 3) {
        DMS_PressGribUp();
    }
    else if(ElseCurrent.count == 4) {
        DMS_PressGribDown();
    }

#endif
#if ((PRO_NUPE))
    if(ElseCurrent.count == 1){ 
        DMS_PressGribUp();
    }
    else if(ElseCurrent.count == 2 ) {
        DMS_PressGribUp();
    }
    else if(ElseCurrent.count == 3) {
        DMS_PressGribDown();
    }
    else if(ElseCurrent.count == 4) {
        DMS_PressGribDown();
    }

#endif
#if (PRO_NQ5)
     if(g_VehicleType == CAR_TYPE_ICV) {
            if(ElseCurrent.count == 1){ 
                DMS_PressGribDown();
            }
            else if(ElseCurrent.count == 2 ) {
                DMS_PressGribUp();
            }
            else if(ElseCurrent.count == 3) {
                DMS_PressGribUp();
            }
            else if(ElseCurrent.count == 4) {
                DMS_PressGribDown();
            }

     } else {
            if(ElseCurrent.count == 1){ 
                DMS_PressGribDown();
            }
            else if(ElseCurrent.count == 2 ) {
                DMS_PressGribUp();
            }
     }
#endif


#if ((PRO_KY) || (PRO_US4) || (PRO_KS))
    if(MODEtimer > 30)
    {
        Port_SetPortPinLevel(2, 26, 1);
    }
    else if(MODEtimer > 0)
    {
        Port_SetPortPinLevel(2, 26, 0);
    }
    else
    {
        MODEtimer = 0;
    }
#endif 

#if (PRO_SG2)
    if(MODEtimer >  30){
        MODEtimer = 30;
    }
    else if(MODEtimer < 10)
    {
        SWRC_05_200ms.SWRC_DriveModeSwSta=0x1;
        CanFD_Send_StandMsg(CANFD0_Type, 0x08B, BUF_40, TX_ISR_EN, (uint8_t *)&SWRC_05_200ms, 8);
        //Can_Clear((uint8_t *)&Signal, sizeof(Signal));
    }
    else if(MODEtimer < 30)
    {
        SWRC_05_200ms.SWRC_DriveModeSwSta=0x0;
        CanFD_Send_StandMsg(CANFD0_Type, 0x08B, BUF_40, TX_ISR_EN, (uint8_t *)&SWRC_05_200ms, 8);
    }

#endif            
}

//DMS==================================
uint8_t g_uiDmsLedCheckFlag = 0;
uint8_t  g_uiB_PlusResetWaitFlag = 0;
uint32_t g_uiB_PlusResetWaitTimer = 0;
uint8_t  g_uiSmartComfortWaitFlag = 0;
uint32_t g_uiSmartComfortWaitTimer = 0;
uint32_t g_uiLedWaitTimer = 0;
uint8_t  g_uiLowLevelTrigerFlag = 0;

void DMS_Led_Comfort()
{
    g_uiDmsLedCheckFlag = 1;
#if (CAN_2ND)
    CGW_PC2.msg.bits.CF_Tcu_DrivingModeDisp = 0X0;
#endif    
#if (CAN_3RD)    
    TCU_01_10ms.TCU_DrvngModDis = 0x0;
#endif 
#if (PRO_SQFL)
    if(IsHaveSportPlus()) {
        SetPressKeySequence(KEY_GRIB_UP,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
    }
    else {
        SetPressKeySequence(KEY_GRIB_UP,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
    }
#endif
#if ((PRO_PDEPE2) || (PRO_BN7R) || (PRO_CN7C) || (PRO_KY) || (PRO_KS) || (PRO_YB_PE) || (PRO_SK3_PE) || (PRO_GL3) || (PRO_BL7M) || (PRO_CN7) || (PRO_BN7I) || (PRO_BL7R) || (PRO_QYC) || (PRO_NX4C) || (PRO_BC3) || (PRO_DL3C))
    SetPressKeySequence(KEY_GRIB_LOW,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if (PRO_DL3C)
    SetPressKeySequence(KEY_GRIB_LOW,KEY_GRIB_LOW,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if ((PRO_NUPE) || (PRO_NU2) || (PRO_NQ5) || (PRO_AX) || (PRO_QXI))
    SetPressKeySequence(KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if ((PRO_SP2C_PE) || (PRO_QX23) || (PRO_NQ5C) || (PRO_LX2) || (PRO_KU) || (PRO_SP2))
    SetPressKeySequence(KEY_GRIB_UP,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if (PRO_ONPE)
    SetPressKeySequence(KEY_GRIB_UP,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
    DoPressKeySimulation(TIME_400);
}

void DMS_Led_ECO()
{
    g_uiDmsLedCheckFlag = 1;
#if (CAN_2ND)
    CGW_PC2.msg.bits.CF_Tcu_DrivingModeDisp = 0X0;
#endif    
#if (CAN_3RD)    
    TCU_01_10ms.TCU_DrvngModDis = 0x0;
#endif 
#if (PRO_SQFL)
    if(IsHaveSportPlus()){
        SetPressKeySequence(KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
    }
    else {
        SetPressKeySequence(KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
    }
#endif
#if ((PRO_PDEPE2) || (PRO_BN7R) || (PRO_US4) || (PRO_CN7C) || (PRO_KY) || (PRO_KS) || (PRO_YB_PE) || (PRO_SK3_PE) || (PRO_GL3) || (PRO_BL7M) || (PRO_CN7) || (PRO_BN7I) || (PRO_BL7R) || (PRO_QYC) || (PRO_NX4C) || (PRO_BC3) || (PRO_DL3C))
    SetPressKeySequence(KEY_GRIB_LOW,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if ((PRO_SP2C_PE) || (PRO_QX23) || (PRO_LX2) || (PRO_NUPE) || (PRO_NQ5C) || (PRO_NQ5) || (PRO_ONPE) || (PRO_SU2IFL))
    SetPressKeySequence(KEY_GRIB_UP,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if ((PRO_SG2) || (PRO_QXI) || (PRO_KU) || (PRO_NU2) || (PRO_SU2BFL) || (PRO_SU2ID_FL))
    SetPressKeySequence(KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if (PRO_SP2)
    if (JudgePartNum() == PartNum_SP2){
        SetPressKeySequence(KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
    } else if (JudgePartNum() == PartNum_SP2I){
        SetPressKeySequence(KEY_GRIB_UP,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
    }
#endif
    DoPressKeySimulation(TIME_400);
}

uint8_t g_DriveModeFlag = 0;
void DMS_Led_Sport()
{
    g_uiDmsLedCheckFlag = 1;
#if (CAN_2ND)
    CGW_PC2.msg.bits.CF_Tcu_DrivingModeDisp = 0X0;
#endif    
#if (CAN_3RD)    
    TCU_01_10ms.TCU_DrvngModDis = 0x0;
#endif
#if (PRO_SQFL)
    if(IsHaveSportPlus()){
        SetPressKeySequence(KEY_GRIB_UP,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
    }
    else {
        SetPressKeySequence(KEY_GRIB_PUSH,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
    }
#endif
#if ((PRO_PDEPE2) || (PRO_BN7R) || (PRO_US4) || (PRO_CN7C) || (PRO_KY) || (PRO_YB_PE) || (PRO_SK3_PE) || (PRO_GL3) || (PRO_CN7) || (PRO_BN7I) || (PRO_BL7R) || (PRO_QYC) || (PRO_NX4C) || (PRO_BC3) || (PRO_KS) || (PRO_BL7M) || (PRO_DL3C))
    SetPressKeySequence(KEY_GRIB_LOW,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if ((PRO_SP2C_PE) || (PRO_QX23) || (PRO_KU) || (PRO_NUPE))
    SetPressKeySequence(KEY_GRIB_UP,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if ((PRO_NU2) || (PRO_AX) || (PRO_SG2) || (PRO_LX2) || (PRO_QXI) || (PRO_NQ5))
    SetPressKeySequence(KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if ((PRO_NQ5C) || (PRO_ONPE) || (PRO_SU2IFL) || (PRO_SU2BFL) || (PRO_SU2ID_FL))
    SetPressKeySequence(KEY_GRIB_DOWN,KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if (PRO_SP2)
    if (JudgePartNum() == PartNum_SP2){
        SetPressKeySequence(KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
    } else if (JudgePartNum() == PartNum_SP2I){
        SetPressKeySequence(KEY_GRIB_UP,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
    }
#endif
    DoPressKeySimulation(TIME_400);
}

void DMS_Led_SportPlus()
{
    g_uiDmsLedCheckFlag = 1;
#if (CAN_2ND)
    CGW_PC2.msg.bits.CF_Tcu_DrivingModeDisp = 0X0;
#endif    
#if (CAN_3RD)    
    TCU_01_10ms.TCU_DrvngModDis = 0x0;
#endif
#if ((PRO_SQFL) || (PRO_SU2IFL))
    if(IsHaveSportPlus()){
        SetPressKeySequence(KEY_GRIB_PUSH,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
    }
    else {
        SetPressKeySequence(KEY_GRIB_PUSH,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
    }
#endif
    DoPressKeySimulation(TIME_0);
}

void DMS_Led_Smart_ComfortColor()
{
    g_uiDmsLedCheckFlag = 1;
#if (CAN_2ND)
    CGW_PC2.msg.bits.CF_Tcu_DrivingModeDisp = 0X1;//ICV
    //HEV_PC14.msg.bits.CF_Tcu_DrivingModeDisp = 0x1;//HEV
#endif    
#if (CAN_3RD)
    TCU_01_10ms.TCU_DrvngModDis = 0x1;//ICV
    HTCU_07_100ms.HTCU_DrivingModeDis = 0x1;//HEV
#endif
    switch(g_uiSmartComfortWaitFlag){
        case 0:
            g_uiSmartComfortWaitTimer = 4000;
            g_uiSmartComfortWaitFlag = 1;
            break;
        case 1:
#if ((PRO_SQFL) || (PRO_SU2IFL))
            if(IsHaveSportPlus()){
                SetPressKeySequence(KEY_GRIB_UP,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
            }
            else {
                SetPressKeySequence(KEY_GRIB_UP,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
            }
#endif
#if ((PRO_PDEPE2) || (PRO_KS) || (PRO_QYC) || (PRO_NX4C))
            SetPressKeySequence(KEY_GRIB_LOW,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if (PRO_DL3C)
            SetPressKeySequence(KEY_GRIB_LOW,KEY_GRIB_LOW,KEY_GRIB_LOW,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if (PRO_US4)
            if(g_VehicleType == CAR_TYPE_ICV) {
                PressGribCtrlSW_HighLevel();//GPIOߵƽ,һһΪһνӵع,һֱΪHOLD״̬
            }
            else if(g_VehicleType == CAR_TYPE_HEV)
            {
                SetPressKeySequence(KEY_GRIB_LOW,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
            }
#endif
#if (PRO_NUPE)
    		SetPressKeySequence(KEY_GRIB_UP,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if ((PRO_SP2C_PE) || (PRO_KU))
    		SetPressKeySequence(KEY_GRIB_UP,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if (PRO_ONPE)
    		SetPressKeySequence(KEY_GRIB_UP,KEY_GRIB_UP,KEY_GRIB_UP,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if ((PRO_NQ5) || (PRO_SP2))
    		SetPressKeySequence(KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if ((PRO_SU2BFL) || (PRO_SU2ID_FL))
    		SetPressKeySequence(KEY_GRIB_DOWN,KEY_GRIB_DOWN,KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if ((PRO_NQ5C) || (PRO_LX2))
    		SetPressKeySequence(KEY_GRIB_UP,KEY_GRIB_UP,KEY_GRIB_UP,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
            DoPressKeySimulation(TIME_400);
            break;    
    }
}

void DMS_Led_Smart_EcoColor()
{
    g_uiDmsLedCheckFlag = 1;
#if (CAN_2ND)
    CGW_PC2.msg.bits.CF_Tcu_DrivingModeDisp = 0X2;//ICV
    //HEV_PC14.msg.bits.CF_Tcu_DrivingModeDisp = 0x2;//HEV
#endif    
#if (CAN_3RD)
    TCU_01_10ms.TCU_DrvngModDis = 0x2;
    HTCU_07_100ms.HTCU_DrivingModeDis = 0x2;//HEV
#endif
}

void DMS_Led_Smart_SportColor()
{
    g_uiDmsLedCheckFlag = 1;
#if (CAN_2ND)
    CGW_PC2.msg.bits.CF_Tcu_DrivingModeDisp = 0X4;//ICV
    //HEV_PC14.msg.bits.CF_Tcu_DrivingModeDisp = 0x4;//HEV
#endif    
#if (CAN_3RD)
    TCU_01_10ms.TCU_DrvngModDis = 0x4;
    HTCU_07_100ms.HTCU_DrivingModeDis = 0x4;//HEV
#endif     
}

void DMS_Led_Smart_SmartColor()
{
    g_uiDmsLedCheckFlag = 1;
#if (CAN_2ND)
    CGW_PC2.msg.bits.CF_Tcu_DrivingModeDisp = 0X0;//ICV
    //HEV_PC14.msg.bits.CF_Tcu_DrivingModeDisp = 0x0;//HEV
#endif    
#if (CAN_3RD)    
    TCU_01_10ms.TCU_DrvngModDis = 0x0;//ICV
    HTCU_07_100ms.HTCU_DrivingModeDis = 0x0;//HEV
#endif     
}


void DMS_Led_Snow()
{
    g_uiDmsLedCheckFlag = 1;
#if (PRO_SU2IFL)
    SetPressKeySequence(KEY_GRIB_PUSH,KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if (PRO_NUPE)
    SetPressKeySequence(KEY_GRIB_PUSH,KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if ((PRO_SP2C_PE) || (PRO_QX23) || (PRO_NQ5C) || (PRO_SP2) || (PRO_SU2ID_FL))
    SetPressKeySequence(KEY_GRIB_PUSH,KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);//sp2ֻSP2I
#endif
#if (PRO_QYC)
    SetPressKeySequence(KEY_GRIB_TrationMode_LOW,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if (PRO_NU2)
    SetPressKeySequence(KEY_GRIB_PUSH,KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
    DoPressKeySimulation(TIME_400);
}

void DMS_Led_Mud()
{
    g_uiDmsLedCheckFlag = 1;
#if (PRO_SU2IFL)
    SetPressKeySequence(KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if (PRO_NUPE)
    SetPressKeySequence(KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if ((PRO_SP2C_PE) || (PRO_QX23) || (PRO_SP2) || (PRO_SU2ID_FL))
    SetPressKeySequence(KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);//sp2ֻSP2I
#endif
#if (PRO_QYC)
    SetPressKeySequence(KEY_GRIB_TrationMode_LOW,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if (PRO_NU2)
    SetPressKeySequence(KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
    DoPressKeySimulation(TIME_400);
}

void DMS_Led_Sand()
{
    g_uiDmsLedCheckFlag = 1;
#if (PRO_SU2IFL)
    SetPressKeySequence(KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if (PRO_NUPE)
    SetPressKeySequence(KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if ((PRO_SP2C_PE) || (PRO_QX23) || (PRO_SP2) || (PRO_SU2ID_FL))
    SetPressKeySequence(KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);//sp2ֻSP2I
#endif
#if (PRO_QYC)
    SetPressKeySequence(KEY_GRIB_TrationMode_LOW,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
#if (PRO_NU2)
    SetPressKeySequence(KEY_GRIB_DOWN,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE,KEY_NONE);
#endif
    DoPressKeySimulation(TIME_400);
}

void PDWLv3(void)
{
#if (CAN_2ND)  
    PAS11.msg.bits.CF_Gway_PASSystemOn = 0x1;
    PAS11.msg.bits.CF_Gway_PASOption = 0x2;
    PAS11.msg.bits.CF_Gway_PASDisplayRCTR = 0x3;
    PAS11.msg.bits.CF_Gway_PASRsound = 3;
    PAS11.msg.bits.CF_Gway_PASCheckSound = 0x3;
#endif 
#if (CAN_3RD)
    BCM_05_200ms.PDW_FrCtrWrngLvlDis = 0x3;
    BCM_05_200ms.PDW_SysOnSta =  0x1;
    BCM_05_200ms.PDW_OptTyp = 0x2;
    BCM_05_200ms.PDW_FrSnsrWrngLvlSta= 0x3;
#endif
    ElseCurrent.Finsh = FINISH;
}
#define BVM_CLOSE 0
#define BVM_LEFT  2
#define BVM_RIGHT 3

void CheckBVM(uint8_t uiCheckStep) 
{
    switch(uiCheckStep)
    {
        case BVM_CLOSE:
            HU_CLU_PE_05.HU_SVM_View_Display = 0;
            break;
        case BVM_LEFT:
            HU_CLU_PE_05.HU_SVM_View_Display = 2;
            break;
        case BVM_RIGHT:
            HU_CLU_PE_05.HU_SVM_View_Display = 3;
            break;
    }
}

void CheckPower(void)
{
    if(PowerCheckFlag == POWER_CHECK_END) {
        //LampState_L.Lamps.RELAY_B = 1;
        //LampState_L.Lamps.RELAY_IGN1 = 0;
        //LampState_L.Lamps.RELAY_IGN3 = 1;
        PowerCheckFlag = POWER_CHECKING;
        PowerCheckTimer = 13;
    }
    else  if(PowerCheckFlag == POWER_CHECKING) {
        if (CANSendEnable == ON) {
             CANSendEnable = OFF; //رķ
        }
        if (ElseCurrent.Time <= 10000) {
#if CAN_2ND
            CAN_0x4F1 = 0; 
#endif
#if CAN_3RD
            CAN_0x225 = 0; 
#endif
        }
        else if (ElseCurrent.Time > 12000) {
#if CAN_2ND            
            if(CAN_0x4F1 == 1) {
                ElseCurrent.Value = ERROR;
                CANSendEnable = ON;
                PowerCheckFlag = POWER_ABNORMAL;
            }
            else {
                ElseCurrent.count++;
                CANSendEnable = ON;
                PowerCheckFlag = POWER_NORMAL;
                ElseCurrent.Time = 0;
            }
#endif  
#if CAN_3RD            
            if(CAN_0x225 == 1) {
                ElseCurrent.Value = ERROR;
                CANSendEnable = ON;
                PowerCheckFlag = POWER_ABNORMAL;
            }
            else {
                ElseCurrent.count++;
                CANSendEnable = ON;
                PowerCheckFlag = POWER_NORMAL;
                ElseCurrent.Time = 0;
            }
#endif 
        } 
    }
    //else  if(PowerCheckFlag == POWER_NORMAL) {
    //    if ((ElseCurrent.Time > 10) && (ElseCurrent.Time < 1010)) {
    //        LampState_L.Lamps.RELAY_B = 1;
    //        LampState_L.Lamps.RELAY_IGN1 = 0;
    //        LampState_L.Lamps.RELAY_IGN3 = 0;
    //
    //    } else if ((ElseCurrent.Time > 1010) && (ElseCurrent.Time < 1500)) {
    //        LampState_L.Lamps.RELAY_B = 1;
    //        LampState_L.Lamps.RELAY_IGN1 = 1;
    //        LampState_L.Lamps.RELAY_IGN3 = 0;
    //    } else {
    //        PowerCheckFlag = POWER_CHECK_END;
    //    }
    //}
}

void APP_ELSE(void)
{
    Default_flag=1;
#if (PRO_NQ5C) 
    if (JudgePartNum() == PartNum_NQ5C_Outlet){
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break;  
            case 2:     
                DMS_Led_ECO();
                break;
            case 3:
                DMS_Led_Sport();
                break;            
            case 4:
                DMS_Led_Smart_ComfortColor();
                break;       
            case 5:
                DMS_Led_Smart_EcoColor();
                break; 
            case 6:
                DMS_Led_Smart_SportColor();
                break; 
            case 7:
                DMS_Led_Smart_SmartColor();
                break;       
            case 8:
                DMS_Led_Snow();
                break;  
            default:
                PDWLv3();
                break;  
        }
    }else if (JudgePartNum() == PartNum_NQ5C){
        if(g_VehicleType == CAR_TYPE_ICV) {
            if(IsSupportBVM() == BVM_YES){
                switch(ElseCurrent.count)
                {
                case 1:
                    ElseCurrent.Finsh = UNFINISH;          
                    DoPressKeyGribDOWN();
                    break;  
                case 2:     
                    DoPressKeyGribDOWN();
                    break;
                case 3:
                    DoPressKeyGribDOWN();
                    break;   
                case 4:
                    CheckBVM(BVM_LEFT);
                    break;  
                case 5:
                    CheckBVM(BVM_RIGHT);
                    break;      
                case 6:
                    CheckBVM(BVM_CLOSE);
                    PDWLv3();
                    break;      
                }
            }
            else {
                switch(ElseCurrent.count)
                {
                case 1:
                    ElseCurrent.Finsh = UNFINISH;          
                    DoPressKeyGribDOWN();
                    break;  
                case 2:     
                    DoPressKeyGribDOWN();
                    break;
                case 3:
                    DoPressKeyGribDOWN();
                    break;   
                case 4:
                    PDWLv3();
                    break;      
                }
           }
        }
        else if(g_VehicleType == CAR_TYPE_HEV) {
            if (IsSupportBVM() == BVM_YES){
                switch(ElseCurrent.count)
                {
                case 1:
                    ElseCurrent.Finsh = UNFINISH;          
                    DoPressKeyGribDOWN();
                    break;  
                case 2:
                    DoPressKeyGribDOWN();
                    break;   
                case 3:
                    CheckBVM(BVM_LEFT);
                    break;  
                case 4:
                    CheckBVM(BVM_RIGHT);
                    break;      
                case 5:
                    CheckBVM(BVM_CLOSE);
                    PDWLv3();
                    break;                
                }
            }
            else {
                switch(ElseCurrent.count)
                {
                case 1:
                    ElseCurrent.Finsh = UNFINISH;          
                    DoPressKeyGribDOWN();
                    break;  
                case 2:
                    DoPressKeyGribDOWN();
                    break;   
                case 3:
                    PDWLv3();
                    break;
                }
            }
        } 
    }
#elif (PRO_SQFL)   
        if(IsHaveSportPlus() == SPORT_PLUS_YES) {
            switch(ElseCurrent.count)
            {
                case 1:
                    ElseCurrent.Finsh = UNFINISH;          
                    DoPressKeyGribUP();
                    break;  
                case 2:
                    DoPressKeyGribUP();
                    break;   
                case 3:
                    DoPressKeyGribUP();
                    break;    
                //case 4:
                //    DoPressKeyGribPUSH();
                //    break;       
                default:
                    PDWLv3();
                    break;                                           
             }  
        }
        else {
            switch(ElseCurrent.count)
            {
                case 1:
                    ElseCurrent.Finsh = UNFINISH;          
                    DoPressKeyGribUP();
                    break;  
                case 2:
                    DoPressKeyGribUP();
                    break;   
                case 3:
                    DoPressKeyGribPUSH();
                    break;       
                default:
                    PDWLv3();
                    break;                                           
             }  
        }
#elif (PRO_CN7C)
    if (GetCluType() == SVC_CFG) {
            if(IsSupportBVM() == BVM_YES){
               switch(ElseCurrent.count)
               {
                case 1:
                    ElseCurrent.Finsh = UNFINISH;          
                    DMS_RestoreDefault();
                    break; 
                case 2:
                    HU_MON_PE_01.HU_Type = 0x60;
                    HU_MON_PE_01.HU_OptionInfo_L = 0x1;
                    HU_USM_E_05.AVN_Usm_CluThemeAutoSet = 0x1;
                    HU_USM_E_10.AVN_Usm_CluThemeSta_New = 0x4;
                    break;
                case 3:  
                    HU_USM_E_05.AVN_Usm_CluThemeAutoSet = 0x2;
                    DMS_Led_ECO();
                    break;
                case 4:
                    DMS_Led_Sport();
                    break;
                case 5:
                    if ((SupportPartNum("94053BU000")) || (SupportPartNum("94053BU030")) || (SupportPartNum("94033BU000")) || (SupportPartNum("94043BU000"))){
                        DMS_Led_Sport();
                    }else{
                        ElseCurrent.count++;
                    }
                    break;
                case 6:
                    DMS_Led_Smart_ComfortColor();
                    break;       
                case 7:
                    DMS_Led_Smart_EcoColor();
                    break; 
                case 8:
                    DMS_Led_Smart_SportColor();
                    break; 
                case 9:
                    DMS_Led_Smart_SmartColor();
                    break;       
                case 10:
                    CheckBVM(BVM_LEFT);
                    break;  
                case 11:
                    CheckBVM(BVM_RIGHT);
                    break;      
                default:
                    CheckBVM(BVM_CLOSE);
                    PDWLv3();
                    break;  
               }
            }
            else {
                switch(ElseCurrent.count)
                {
                    case 1:
                        ElseCurrent.Finsh = UNFINISH;          
                        DMS_RestoreDefault();
                        break; 
                    case 2:
                        HU_MON_PE_01.HU_Type = 0x60;
                        HU_MON_PE_01.HU_OptionInfo_L = 0x1;
                        HU_USM_E_05.AVN_Usm_CluThemeAutoSet = 0x1;
                        HU_USM_E_10.AVN_Usm_CluThemeSta_New = 0x4;
                        break;
                    case 3:     
                        HU_USM_E_05.AVN_Usm_CluThemeAutoSet = 0x2;
                        DMS_Led_ECO();
                        break;
                    case 4:
                        DMS_Led_Sport();
                        break;
                    case 5:
                        if ((SupportPartNum("94053BU000")) || (SupportPartNum("94053BU030")) || (SupportPartNum("94033BU000")) || (SupportPartNum("94043BU000"))){
                            DMS_Led_Sport();
                        }else{
                            ElseCurrent.count++;
                        }
                    break;
                    case 6:
                        DMS_Led_Smart_ComfortColor();
                        break;       
                    case 7:
                        DMS_Led_Smart_EcoColor();
                        break; 
                    case 8:
                        DMS_Led_Smart_SportColor();
                        break; 
                    case 9:
                        DMS_Led_Smart_SmartColor();
                        break; 
                    default:
                        CheckBVM(BVM_CLOSE);
                        PDWLv3();
                        break;  
                 }
            }
        }
        else{
            switch(ElseCurrent.count)
                {
                    case 1:
                        ElseCurrent.Finsh = UNFINISH;          
                        DMS_RestoreDefault();
                        break;  
                    case 2:     
                        DMS_Led_ECO();
                        break;
                    case 3:
                        DMS_Led_Sport();
                        break;  
                    case 4:
                        if ((SupportPartNum("94053BU000")) || (SupportPartNum("94053BU030")) || (SupportPartNum("94033BU000")) || (SupportPartNum("94043BU000"))){
                            DMS_Led_Sport();
                        }else{
                            ElseCurrent.count++;
                        }
                    break;
                    case 5:
                        DMS_Led_Smart_ComfortColor();
                        break;       
                    case 6:
                        DMS_Led_Smart_EcoColor();
                        break; 
                    case 7:
                        DMS_Led_Smart_SportColor();
                        break; 
                    case 8:
                        DMS_Led_Smart_SmartColor();
                        break; 
                    default:
                        CheckBVM(BVM_CLOSE);
                        PDWLv3();
                        break;  
                 }
        }
#elif (PRO_QYC)
           switch(ElseCurrent.count)
           {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break;  
            case 2:     
                DMS_Led_ECO();
                break;
            case 3:     
                DMS_Led_Comfort();
                break;
            case 4:
                DMS_Led_Sport();
                break;            
            case 5:
                DMS_Led_Sport();
                break;   
            case 6:
                DMS_Led_Sport();
                break;   
            case 7:
                DMS_Led_Smart_ComfortColor();
                break;       
            case 8:
                DMS_Led_Smart_EcoColor();
                break; 
            case 9:
                DMS_Led_Smart_SportColor();
                break; 
            case 10:
                DMS_Led_Smart_SmartColor();
                break;       
            case 11:
                DMS_Led_Snow();
            case 12:
                DMS_Led_Snow();
                break;  
            case 13:
                DMS_Led_Mud();
                break;      
            case 14:
                DMS_Led_Sand();
                break;    
            default:
                PDWLv3();
                break;  
           }
#elif (PRO_PDEPE2)   
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DoPressKeyGribLow();
                break;  
            case 2:
                DoPressKeyGribLow();
                break;   
            case 3:
                DoPressKeyGribLow();
                break;       
            default:
                PDWLv3();
                break;                           
        }  
#elif (PRO_BL7M)   
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break;  
            case 2:
                DoPressKeyGribLow();
                break;   
            case 3:
                DoPressKeyGribLow();
                break;    
            case 4:
                DoPressKeyGribLow();
                break;
            default:
                PDWLv3();
                break;                           
        }  
#elif (PRO_GL3)   
    if (g_VehicleType == CAR_TYPE_ICV){
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;     
                DMS_RestoreDefault();
                break; 
            case 2:
                DMS_Led_Comfort();
                break;   
            case 3:
                DMS_Led_ECO();
                break;       
            case 4:
                DMS_Led_Sport();
                break;
            default:
                PDWLv3();
                break;                           
        } 
    }
    else {
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;     
                DMS_RestoreDefault();
                break; 
            case 2:
                DMS_Led_Sport();
                break;       
            case 3:
                DMS_Led_ECO();
                break;
            default:
                PDWLv3();
                break;                           
        } 
    }
#elif (PRO_BN7R)   
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DoPressKeyGribLow();
                break;  
            case 2:
                DoPressKeyGribLow();
                break;   
            case 3:
                DoPressKeyGribLow();
                break;       
            default:
                PDWLv3();
                break;                            
        } 
#elif (PRO_BN7I)   
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break;  
            case 2:
                DMS_Led_Comfort();
                break; 
            case 3:
                DMS_Led_ECO();
                break;  
            case 4:
                DMS_Led_Sport();
                break;
            default:
                PDWLv3();
                break;                
        } 
#elif (PRO_YB_PE)   
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DoPressKeyGribLow();
                break;  
            case 2:
                DoPressKeyGribLow();
                break;   
            case 3:
                DoPressKeyGribLow();
                break;       
            default:
                PDWLv3();
                break;                            
        }
#elif (PRO_KY)   
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break;  
            case 2:
                DMS_Led_Comfort();
                break;   
            case 3:
                DMS_Led_ECO();
                break;       
            case 4:
                DMS_Led_Sport();
                break;       
            default:
                PDWLv3();
                break;                            
        }
#elif (PRO_SK3_PE)   
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break;  
            case 2:
                DMS_Led_ECO();
                break;   
            case 3:
                DMS_Led_Sport();
                break;    
            case 4:
                DMS_Led_Comfort();
                break;
            default:
                PDWLv3();
                break;                            
        }
#elif (PRO_TAM)   
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break;  
            default:
                PDWLv3();
                break;                            
        }
#elif (PRO_KS)   
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;     
                DMS_RestoreDefault();
                break;
            case 2: 
                DMS_Led_Comfort();
                break;  
            case 3:
                DMS_Led_ECO();
                break;   
            case 4:
                DMS_Led_Sport();
                break;  
            case 5:
                DMS_Led_Sport();
                break;
            case 6:
                DMS_Led_Sport();
                break;
            case 7:
                DMS_Led_Smart_ComfortColor();
                break;       
            case 8:
                DMS_Led_Smart_EcoColor();
                break; 
            case 9:
                DMS_Led_Smart_SportColor();
                break; 
            case 10:
                DMS_Led_Smart_SmartColor();
                break; 
            default:
                PDWLv3();
                break;                            
        }
#elif (PRO_CN7)   
     if (g_VehicleType == CAR_TYPE_ICV){
         switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break;  
            case 2:
                DMS_Led_ECO();
                break; 
            case 3:
                DMS_Led_Sport();
                break;  
            case 4:
                DMS_Led_Smart_ComfortColor();
            case 5:
                DMS_Led_Smart_EcoColor();
                break;  
            case 6:
                DMS_Led_Smart_SportColor();
                break;  
            case 7:
                DMS_Led_Smart_SmartColor();
                break;
            default:
                PDWLv3();
                break;                
        } 
    }
    else {
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break;  
            case 2:
                DMS_Led_ECO();
                break; 
            case 3:
                DMS_Led_Sport();
                break;  
            default:
                PDWLv3();
                break;     
       }
    }
#elif (PRO_SU2IFL)   
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break;  
            case 2:
                DMS_Led_Sport();
                break;   
            case 3:
                DMS_Led_ECO();
                break;  
            case 4:
                DMS_Led_Snow();
                break;  
            case 5:
                DMS_Led_Mud();
                break;  
            case 6:
                DMS_Led_Sand();
                break;                  
            default:
                PDWLv3();
                break;              
        } 
#elif (PRO_SU2BFL)   
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break;  
            case 2:
                DMS_Led_ECO();
                break; 
            case 3:
                DMS_Led_Sport();
                break;  
            case 4:
                DMS_Led_Smart_ComfortColor();
            case 5:
                DMS_Led_Smart_EcoColor();
                break;  
            case 6:
                DMS_Led_Smart_SportColor();
                break;  
            case 7:
                DMS_Led_Smart_SmartColor();
                break;
            default:
                PDWLv3();
                break;                
        } 
#elif (PRO_SU2ID_FL)   
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break;  
            case 2:
                DMS_Led_ECO();
                break; 
            case 3:
                DMS_Led_Sport();
                break;  
            case 4:
                DMS_Led_Smart_ComfortColor();
            case 5:
                DMS_Led_Smart_EcoColor();
                break;  
            case 6:
                DMS_Led_Smart_SportColor();
                break;  
            case 7:
                DMS_Led_Smart_SmartColor();
                break;
            case 8:
                DMS_Led_Snow();
                break;  
            case 9:
                DMS_Led_Mud();
                break;  
            case 10:
                DMS_Led_Sand();
                break;
            default:
                PDWLv3();
                break;                
        } 
#elif (PRO_NUPE)   
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break;  
            case 2:
                DMS_Led_ECO();
                break; 
            case 3:
                DMS_Led_Sport();
                break;  
            case 4:
                DMS_Led_Smart_ComfortColor();
            case 5:
                DMS_Led_Smart_EcoColor();
                break;  
            case 6:
                DMS_Led_Smart_SportColor();
                break;  
            case 7:
                DMS_Led_Smart_SmartColor();
                break;
            case 8:
                DMS_Led_Snow();
                break;
            case 9:
                DMS_Led_Mud();
                break;
            case 10:
                DMS_Led_Sand();
                break;
            default:
                PDWLv3();
                break;                
        } 
#elif (PRO_US4)   
        if(g_VehicleType == CAR_TYPE_ICV) {
            switch(ElseCurrent.count)
            {
                case 1:
                    ElseCurrent.Finsh = UNFINISH;          
                    DoPressKeyGribLow();
                    break;  
                case 2:
                    DoPressKeyGribLow();
                    break;   
                case 3:
                    DoPressKeyGribLow();
                    break;       
                default:
                    PDWLv3();
                    break;               
            }  
        }
        else if(g_VehicleType == CAR_TYPE_HEV) {
            switch(ElseCurrent.count)
            {
                case 1:
                    ElseCurrent.Finsh = UNFINISH;          
                    DoPressKeyGribLow();
                    break;  
                case 2:
                    DoPressKeyGribLow();
                    break;         
                default:
                    PDWLv3();
                    break;                
            }  
        }
#elif (PRO_ONPE)   
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break;  
            case 2:
                DMS_Led_Sport();
                break;  
            case 3:
                DMS_Led_Comfort();
                break;  
            case 4:
                DMS_Led_ECO();
                break;   
            case 5:
                DMS_Led_Smart_ComfortColor();
                break;       
            case 6:
                DMS_Led_Smart_EcoColor();
                break; 
            case 7:
                DMS_Led_Smart_SportColor();
                break; 
            case 8:
                DMS_Led_Smart_SmartColor();
                break; 
            default:
                PDWLv3();
                break;      
        }  
#elif (PRO_DL3C)   
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break;  
            case 2:
                DMS_Led_ECO();
                break;  
            case 3:
                DMS_Led_Comfort();
                break;  
            case 4:
                DMS_Led_Sport();
                break;  
            case 5:
                DMS_Led_Smart_ComfortColor();
                break;
            case 6:
                DMS_Led_Smart_EcoColor();
                break; 
            case 7:
                DMS_Led_Smart_SportColor();
                break; 
            case 8:
                DMS_Led_Smart_SmartColor();
                break; 
            case 9:
                CheckBVM(BVM_LEFT);
                break;  
            case 10:
                CheckBVM(BVM_RIGHT);
                break;      
            default:
                CheckBVM(BVM_CLOSE);
                PDWLv3();
                break;      
        } 
#elif (PRO_SP2C_PE)   
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break;  
            case 2:
                DMS_Led_ECO();
                break; 
            case 3:
                DMS_Led_Sport();
                break;  
            case 4:
                DMS_Led_Smart_ComfortColor();
            case 5:
                DMS_Led_Smart_EcoColor();
                break;  
            case 6:
                DMS_Led_Smart_SportColor();
                break;  
            case 7:
                DMS_Led_Smart_SmartColor();
                break;
            case 8:
                DMS_Led_Snow();
                break;
            case 9:
                DMS_Led_Mud();
                break;
            case 10:
                DMS_Led_Sand();
                break;
            default:
                PDWLv3();
                break;                
        } 
#elif (PRO_NU2)   
        if (GetCluType() == SVC_CFG) {
            if(IsSupportBVM() == BVM_YES){
               switch(ElseCurrent.count)
               {
                case 1:
                    ElseCurrent.Finsh = UNFINISH;          
                    DMS_RestoreDefault();
                    break;  
                case 2:
                    DMS_Led_ECO();
                    break; 
                case 3:
                    DMS_Led_Sport();
                    break;           
                case 4:
                    DMS_Led_Smart_ComfortColor();
                    break;           
                case 5:
                    DMS_Led_Smart_EcoColor();
                    break;           
                case 6:
                    DMS_Led_Smart_SportColor();
                    break;           
                case 7:
                    DMS_Led_Smart_SmartColor();
                    break;           
                case 8:
                    DMS_Led_Snow();
                    break;           
                case 9:
                    DMS_Led_Mud();
                    break;           
                case 10:
                    DMS_Led_Sand();
                    break;                 
                case 11:
                    CheckBVM(BVM_LEFT);
                    break;  
                case 12:
                    CheckBVM(BVM_RIGHT);
                    break;      
                case 13:
                    CheckBVM(BVM_CLOSE);
                    PDWLv3();
                    break;  
               }
            }
            else {
                switch(ElseCurrent.count)
                {
                    case 1:
                        ElseCurrent.Finsh = UNFINISH;          
                        DMS_RestoreDefault();
                        break;  
                    case 2:
                        DMS_Led_ECO();
                        break; 
                    case 3:
                        DMS_Led_Sport();
                        break;           
                    case 4:
                        DMS_Led_Smart_ComfortColor();
                        break;           
                    case 5:
                        DMS_Led_Smart_EcoColor();
                        break;           
                    case 6:
                        DMS_Led_Smart_SportColor();
                        break;           
                    case 7:
                        DMS_Led_Smart_SmartColor();
                        break;           
                    case 8:
                        DMS_Led_Snow();
                        break;           
                    case 9:
                        DMS_Led_Mud();
                        break;           
                    case 10:
                        DMS_Led_Sand();
                        break;            
                 }
            }
        }
        else{
            switch(ElseCurrent.count)
            {
                case 1:
                    ElseCurrent.Finsh = UNFINISH;          
                    DMS_RestoreDefault();
                    break;  
                case 2:
                    DMS_Led_ECO();
                    break; 
                case 3:
                    DMS_Led_Sport();
                    break;           
                case 4:
                    DMS_Led_Smart_ComfortColor();
                    break;           
                case 5:
                    DMS_Led_Smart_EcoColor();
                    break;           
                case 6:
                    DMS_Led_Smart_SportColor();
                    break;           
                case 7:
                    DMS_Led_Smart_SmartColor();
                    break;           
                case 8:
                    DMS_Led_Snow();
                    break;           
                case 9:
                    DMS_Led_Mud();
                    break;           
                case 10:
                    DMS_Led_Sand();
                    break;           
                default:
                    PDWLv3();
                    break;  
             }
        }
#elif (PRO_QX23)   
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break;  
            case 2:
                DMS_Led_ECO();
                break; 
                
            case 3:
                DMS_Led_Sport();
                break;  
            case 4:
                DMS_Led_Snow();
                break;  
            case 5:
                DMS_Led_Mud();
                break;  
            case 6:
                DMS_Led_Sand();
                break;                  
            case 7:
                PDWLv3();
                break;                
        } 
#elif (PRO_NX4C)   
        if(g_VehicleType == CAR_TYPE_ICV) {
            switch(ElseCurrent.count)
            {
                case 1:
                    ElseCurrent.Finsh = UNFINISH;          
                    DMS_RestoreDefault();
                    break;  
                case 2:
                    DMS_Led_ECO();
                    break; 
                case 3:
                    DMS_Led_Sport();
                    break;  
                case 4:
                    DMS_Led_Comfort();
                    break;  
                case 5:
                    DMS_Led_Comfort();
                    break;  
                case 6:
                    DMS_Led_Comfort();
                    break;  
                case 7:
                    DMS_Led_Smart_ComfortColor();
                    break;       
                case 8:
                    DMS_Led_Smart_EcoColor();
                    break; 
                case 9:
                    DMS_Led_Smart_SportColor();
                    break; 
                case 10:
                    DMS_Led_Smart_SmartColor();
                    break; 
                default:
                    PDWLv3();
                    break;                
            } 
       }
       else {
           switch(ElseCurrent.count)
                {
                    case 1:
                        ElseCurrent.Finsh = UNFINISH;          
                        DMS_RestoreDefault();
                        break;  
                    case 2:
                        DMS_Led_ECO();
                        break; 
                    case 3:
                        DMS_Led_Sport();
                        break;  
                    default:
                        PDWLv3();
                        break;                
                } 
       }
#elif (PRO_AI3)  
        switch(ElseCurrent.count)
        {
            default:
                ElseCurrent.Finsh = UNFINISH;
                PDWLv3();
                break;                              
        } 
#elif ((PRO_AC3_PE) || (PRO_JAPE2))
                switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break; 
            case 2:
                    HU_MON_PE_01.HU_Type = 0x60;
                    HU_MON_PE_01.HU_OptionInfo_L = 0x2;
                    HU_USM_E_10.AVN_Usm_CluThemeSta_New = 0x2;
                break;
            case 3:
                    HU_USM_E_10.AVN_Usm_CluThemeSta_New = 0x3;
                    HU_MON_PE_01.HU_Type = 0x60;
                    HU_MON_PE_01.HU_OptionInfo_L = 0x7;
                break;
            case 4:
                    HU_USM_E_10.AVN_Usm_CluThemeSta_New = 0x1;
                    HU_MON_PE_01.HU_Type = 0x60;
                    HU_MON_PE_01.HU_OptionInfo_L = 0x7;
                break;
            default:
                PDWLv3();
                break;           
            }
#elif (PRO_NQ5)   
          if(g_VehicleType == CAR_TYPE_ICV) {
            switch(ElseCurrent.count)
            {
                case 1:
                    ElseCurrent.Finsh = UNFINISH;          
                    DMS_RestoreDefault();
                    break;  
                case 2:
                    DMS_Led_Comfort();
                    break; 
                case 3:
                    DMS_Led_Sport();
                    break;  
                case 4:
                    DMS_Led_Smart_ComfortColor();
                case 5:
                    DMS_Led_Smart_EcoColor();
                    break;  
                case 6:
                    DMS_Led_Smart_SportColor();
                    break;  
                case 7:
                    DMS_Led_Smart_SmartColor();
                    break;
                default:
                    PDWLv3();
                    break;             
            }  
        }
        else {
            switch(ElseCurrent.count)
            {
                case 1:
                    ElseCurrent.Finsh = UNFINISH;          
                    DMS_RestoreDefault();
                    break;  
                case 2:
                    DMS_Led_ECO();
                    break;         
                case 3:
                    DMS_Led_Sport();
                    break;
                default:
                    PDWLv3();
                    break;                
            }  
        } 
#elif (PRO_AX)   
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break;
            case 2:     
                DMS_Led_Sport();
                break;
            default:
                PDWLv3();
                break;                
        }  
#elif (PRO_SP2)
        if (JudgePartNum() == PartNum_SP2){
            switch(ElseCurrent.count)
            {
                case 1:
                    ElseCurrent.Finsh = UNFINISH;          
                    DMS_RestoreDefault();
                    break;  
                case 2:
                    DMS_Led_Comfort();
                    break;
                case 3:
                    DMS_Led_ECO();
                    break; 
                case 4:
                    DMS_Led_Sport();
                    break;  
                case 5:
                    DMS_Led_Smart_ComfortColor();
                case 6:
                    DMS_Led_Smart_EcoColor();
                    break;  
                case 7:
                    DMS_Led_Smart_SportColor();
                    break;  
                case 8:
                    DMS_Led_Smart_SmartColor();
                    break;
                default:
                    PDWLv3();
                    break;                
            } 
        }else if (JudgePartNum() == PartNum_SP2I){
            switch(ElseCurrent.count)
            {
                case 1:
                    ElseCurrent.Finsh = UNFINISH;          
                    DMS_RestoreDefault();
                    break; 
                case 2:
                    DMS_Led_ECO();
                    break;
                case 3:
                    DMS_Led_Sport();
                    break;
                case 4:
                    DMS_Led_Snow();
                    break;
                case 5:
                    DMS_Led_Mud();
                    break;
                case 6:
                    DMS_Led_Sand();
                    break;
                default:
                    PDWLv3();
                    break;           
            }
        }
#elif (PRO_BL7R)
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break; 
            case 2:
                DMS_Led_ECO();
                break;
            case 3:
                DMS_Led_Sport();
                break;
            default:
                PDWLv3();
                break;           
            }
#elif (PRO_BC3)
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break; 
            case 2:
                DMS_Led_ECO();
                if (SupportPartNum("94053Q0000") || SupportPartNum("94053Q0010") || SupportPartNum("94053Q0020") || SupportPartNum("94053Q0030") || SupportPartNum("94053Q0040") || SupportPartNum("94053Q0050") || SupportPartNum("94053Q0060") || SupportPartNum("94053Q0070") || SupportPartNum("94053Q0080") || SupportPartNum("94053Q0270") || SupportPartNum("94053Q0290")){
                    HU_MON_PE_01.HU_Type = 0x60;
                    HU_MON_PE_01.HU_OptionInfo_L = 0x2;
                    HU_USM_E_10.AVN_Usm_CluThemeSta_New = 0x2;
                }
                break;
            case 3:
                DMS_Led_Sport();
                if (SupportPartNum("94053Q0000") || SupportPartNum("94053Q0010") || SupportPartNum("94053Q0020") || SupportPartNum("94053Q0030") || SupportPartNum("94053Q0040") || SupportPartNum("94053Q0050") || SupportPartNum("94053Q0060") || SupportPartNum("94053Q0070") || SupportPartNum("94053Q0080") || SupportPartNum("94053Q0270") || SupportPartNum("94053Q0290")){
                    HU_USM_E_10.AVN_Usm_CluThemeSta_New = 0x3;
                    HU_MON_PE_01.HU_Type = 0x60;
                    HU_MON_PE_01.HU_OptionInfo_L = 0x7;
                }
                break;
            case 4:
                DMS_Led_Comfort();
                if (SupportPartNum("94053Q0000") || SupportPartNum("94053Q0010") || SupportPartNum("94053Q0020") || SupportPartNum("94053Q0030") || SupportPartNum("94053Q0040") || SupportPartNum("94053Q0050") || SupportPartNum("94053Q0060") || SupportPartNum("94053Q0070") || SupportPartNum("94053Q0080") || SupportPartNum("94053Q0270") || SupportPartNum("94053Q0290")){
                    HU_USM_E_10.AVN_Usm_CluThemeSta_New = 0x1;
                    HU_MON_PE_01.HU_Type = 0x60;
                    HU_MON_PE_01.HU_OptionInfo_L = 0x7;
                }
                break;
            default:
                PDWLv3();
                break;           
            }
#elif (PRO_SG2)   
            switch(ElseCurrent.count)
            {
                case 1:
                    ElseCurrent.Finsh = UNFINISH;          
                    DMS_RestoreDefault();
                    break;  
                case 2:
                    DMS_Led_Sport();
                    break;  
                case 3:
                    DMS_Led_ECO();
                    break;   
                default:
                    PDWLv3();
                    break;               
            }  
#elif (PRO_LX2)   
            switch(ElseCurrent.count)
            {
                case 1:
                    ElseCurrent.Finsh = UNFINISH;          
                    DMS_RestoreDefault();
                    break;  
                case 2:
                    DMS_Led_Sport();
                    break;  
                case 3:
                    DMS_Led_Comfort();
                    break;  
                case 4:
                    DMS_Led_ECO();
                    break;   
                case 5:
                    DMS_Led_Smart_ComfortColor();
                    break;       
                case 6:
                    DMS_Led_Smart_EcoColor();
                    break; 
                case 7:
                    DMS_Led_Smart_SportColor();
                    break; 
                case 8:
                    DMS_Led_Smart_SmartColor();
                    break; 
                default:
                    PDWLv3();
                    break;      
            }  
#elif (PRO_QXI)   
        
        PressKey(DOWNKeyCurrent.count,KEY_SW1_DOWN,TRIPSW_SHORT_PRESS);
        // switch(ElseCurrent.count)
        // {
        //     case 1:
        //         ElseCurrent.Finsh = UNFINISH;          
        //         DMS_RestoreDefault();
        //         break;  
        //     case 2:
        //         DMS_Led_Comfort();
        //         break; 
        //     case 3:
        //         DMS_Led_ECO();
        //         break;  
        //     case 4:
        //         DMS_Led_Sport();
        //         break;
        //     default:
        //         PDWLv3();
        //         break;                
        // } 
        //PressKey(DOWNKeyCurrent.count,KEY_SW1_DOWN,TRIPSW_SHORT_PRESS);
#elif (PRO_BR2)   
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break;  
            default:
                PDWLv3();
                break;                
        } 
#elif (PRO_KU)   
        switch(ElseCurrent.count)
        {
            case 1:
                ElseCurrent.Finsh = UNFINISH;          
                DMS_RestoreDefault();
                break;  
            case 2:
                DMS_Led_ECO();
                break; 
            case 3:
                DMS_Led_Comfort();
                break;  
            case 4:
                DMS_Led_Sport();
                break;
            case 5:
                DMS_Led_Smart_ComfortColor();
                break;
            case 6:
                DMS_Led_Smart_EcoColor();
                break;
            case 7:
                DMS_Led_Smart_SportColor();
                break;
            case 8:
                DMS_Led_Smart_SmartColor();
                break;
            default:
                PDWLv3();
                break;                
        } 
//#elif (PRO_SQFL)   
//        switch(ElseCurrent.count)
//        {
//           case 1:
//                ElseCurrent.Finsh = UNFINISH;          
//                DMS_RestoreDefault();
//                break;  
//            case 2:
//                DMS_Led_ECO();
//                break; 
//            case 3:
//                DMS_Led_Comfort();
//                break;  
//            case 4:
//                DMS_Led_Smart_ComfortColor();
//                break;
//            case 5:
//                DMS_Led_Smart_EcoColor();
//                break;
//            case 6:
//                DMS_Led_Smart_SportColor();
//                break;
//            case 7:
//                DMS_Led_Smart_SmartColor();
//                break;
//            case 8:
//                DMS_Led_Sport();
//                break;
//            default:
//               PDWLv3();
//                break;                
//        } 
#else //Ŀʼ=====================================================
#endif//Ŀ=====================================================
    if (ElseCurrent.Value == ERROR || PowerCheckFlag == POWER_ABNORMAL) {
        SetError(98);//ش
        Buzzer_Alarm();//
    }
}


