#include "common_include.h"
#include "bsp_app_led_output.h"

void InitTelltale_KS(void)
{
#if (PRO_KS)
   SetTelltalePos("HighBeam",              HighBeam);
   SetTelltalePos("HBAGreen",              HBAGreen);
   SetTelltalePos("HBAWhite",              HBAWhite);
   SetTelltalePos("LowBeam",                LowBeam);
   SetTelltalePos("LeftTurn",              LeftTurn);
   SetTelltalePos("RightTurn",            RightTurn);
   SetTelltalePos("TailLamp",              TailLamp);
   SetTelltalePos("FrontFog",              FrontFog);
   if (JudgePartNum() == PartNum_KS_23MY) {
     SetTelltalePos("EPB",                        EPB);
   }
   if (JudgePartNum() == PartNum_KS_23MY) {
     SetTelltalePos("OverSpeed",            OverSpeed);
   }
   SetTelltalePos("ParkingBreak",      ParkingBreak);
   SetTelltalePos("MasterSymbol",      MasterSymbol);
   SetTelltalePos("ABS",                        ABS);
   SetTelltalePos("Tpms",                      Tpms);
   SetTelltalePos("Immobilizer",        Immobilizer);
   SetTelltalePos("SeatBelt",              SeatBelt);
   SetTelltalePos("LedLampFail",        LedLampFail);
   if (JudgePartNum() == PartNum_KS_23MY) {
     SetTelltalePos("Ecall",                    Ecall);
   }
   if (IsHaveMph()) {
     SetTelltalePos("MPH",                        MPH);
   }
   SetTelltalePos("InteriorLamp",      InteriorLamp);
   SetTelltalePos("FCA Yellow",           FcaYellow);
   SetTelltalePos("FCA RedBlink",            FcaRed);
   SetTelltalePos("MDPS",                      Mdps);
   SetTelltalePos("Glow",                      Glow);
   SetTelltalePos("BatteryCharge",    BatteryCharge);
   SetTelltalePos("AirBag",                  AirBag);
   SetTelltalePos("OilPressure",        OilPressure);
   SetTelltalePos("ESC",                        ESC);
   SetTelltalePos("EscOff",                  EscOff);
   SetTelltalePos("CheckEngine",        CheckEngine);
   SetTelltalePos("AllLedOpen",          AllLedOpen);
   SetTelltalePos("LowFuel",     DMS_RestoreDefault);
#endif
}


