/******************************************************************************
* $Revision: 423 $
* $Date:: 2017-04-07 16:03:30 +0900#$
*****************************************************************************/
/* __DISCLAIMER_START__                                                      */
/******************************************************************************
* (c)2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ( "Software" ), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ( "EULA" ).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress' s
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ( "High Risk Product" ). By
* including Cypress' s product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/
/* __DISCLAIMER_END__                                                        */
/*****************************************************************************
** \file ppg_generated.c
**
** Generated file for ppg.c module, including variables and functions
** for internal data and interrupt handling. The individual ISRs for each
** peripheral are calling the generic handler in ppg.c
**
** \note This file must not be added to the build files - it will be included
**       by ppg.c automatically!
**
** History:
**   - 2015-01-29  0.01  MAs  Initial version for Traveo
*****************************************************************************/

#ifndef __PPG_GENERATED_C__
#define __PPG_GENERATED_C__

/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include <interrupts.h>

/*****************************************************************************/
/* Local pre-processor symbols/macros ('#define')                            */
/*****************************************************************************/

/* Macro to return the number of enabled PPG instances */
#define PPG_INSTANCE_COUNT (uint32_t)(sizeof(m_astcPpgInstanceDataLut) / sizeof(m_astcPpgInstanceDataLut[0]))

/*****************************************************************************/
/* Global variable definitions (declared in header file with 'extern')       */
/*****************************************************************************/


/*****************************************************************************/
/* Local type definitions ('typedef')                                        */
/*****************************************************************************/

/* Enumeration to define an index for each enabled PPG instance */
typedef enum en_ppg_instance_index
{
#if (PDL_PERIPHERAL_ENABLE_PPG0 == PDL_ON)
        PpgInstanceIndexPpg0,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG1 == PDL_ON)
        PpgInstanceIndexPpg1,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG2 == PDL_ON)
        PpgInstanceIndexPpg2,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG3 == PDL_ON)
        PpgInstanceIndexPpg3,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG4 == PDL_ON)
        PpgInstanceIndexPpg4,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG5 == PDL_ON)
        PpgInstanceIndexPpg5,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG6 == PDL_ON)
        PpgInstanceIndexPpg6,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG7 == PDL_ON)
        PpgInstanceIndexPpg7,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG8 == PDL_ON)
        PpgInstanceIndexPpg8,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG9 == PDL_ON)
        PpgInstanceIndexPpg9,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG10 == PDL_ON)
        PpgInstanceIndexPpg10,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG11 == PDL_ON)
        PpgInstanceIndexPpg11,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG12 == PDL_ON)
        PpgInstanceIndexPpg12,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG13 == PDL_ON)
        PpgInstanceIndexPpg13,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG14 == PDL_ON)
        PpgInstanceIndexPpg14,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG15 == PDL_ON)
        PpgInstanceIndexPpg15,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG16 == PDL_ON)
        PpgInstanceIndexPpg16,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG17 == PDL_ON)
        PpgInstanceIndexPpg17,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG18 == PDL_ON)
        PpgInstanceIndexPpg18,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG19 == PDL_ON)
        PpgInstanceIndexPpg19,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG20 == PDL_ON)
        PpgInstanceIndexPpg20,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG21 == PDL_ON)
        PpgInstanceIndexPpg21,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG22 == PDL_ON)
        PpgInstanceIndexPpg22,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG23 == PDL_ON)
        PpgInstanceIndexPpg23,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG24 == PDL_ON)
        PpgInstanceIndexPpg24,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG25 == PDL_ON)
        PpgInstanceIndexPpg25,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG26 == PDL_ON)
        PpgInstanceIndexPpg26,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG27 == PDL_ON)
        PpgInstanceIndexPpg27,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG28 == PDL_ON)
        PpgInstanceIndexPpg28,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG29 == PDL_ON)
        PpgInstanceIndexPpg29,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG30 == PDL_ON)
        PpgInstanceIndexPpg30,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG31 == PDL_ON)
        PpgInstanceIndexPpg31,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG32 == PDL_ON)
        PpgInstanceIndexPpg32,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG33 == PDL_ON)
        PpgInstanceIndexPpg33,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG34 == PDL_ON)
        PpgInstanceIndexPpg34,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG35 == PDL_ON)
        PpgInstanceIndexPpg35,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG36 == PDL_ON)
        PpgInstanceIndexPpg36,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG37 == PDL_ON)
        PpgInstanceIndexPpg37,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG38 == PDL_ON)
        PpgInstanceIndexPpg38,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG39 == PDL_ON)
        PpgInstanceIndexPpg39,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG40 == PDL_ON)
        PpgInstanceIndexPpg40,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG41 == PDL_ON)
        PpgInstanceIndexPpg41,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG42 == PDL_ON)
        PpgInstanceIndexPpg42,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG43 == PDL_ON)
        PpgInstanceIndexPpg43,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG44 == PDL_ON)
        PpgInstanceIndexPpg44,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG45 == PDL_ON)
        PpgInstanceIndexPpg45,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG46 == PDL_ON)
        PpgInstanceIndexPpg46,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG47 == PDL_ON)
        PpgInstanceIndexPpg47,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG48 == PDL_ON)
        PpgInstanceIndexPpg48,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG49 == PDL_ON)
        PpgInstanceIndexPpg49,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG50 == PDL_ON)
        PpgInstanceIndexPpg50,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG51 == PDL_ON)
        PpgInstanceIndexPpg51,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG52 == PDL_ON)
        PpgInstanceIndexPpg52,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG53 == PDL_ON)
        PpgInstanceIndexPpg53,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG54 == PDL_ON)
        PpgInstanceIndexPpg54,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG55 == PDL_ON)
        PpgInstanceIndexPpg55,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG56 == PDL_ON)
        PpgInstanceIndexPpg56,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG57 == PDL_ON)
        PpgInstanceIndexPpg57,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG58 == PDL_ON)
        PpgInstanceIndexPpg58,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG59 == PDL_ON)
        PpgInstanceIndexPpg59,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG60 == PDL_ON)
        PpgInstanceIndexPpg60,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG61 == PDL_ON)
        PpgInstanceIndexPpg61,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG62 == PDL_ON)
        PpgInstanceIndexPpg62,
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG63 == PDL_ON)
        PpgInstanceIndexPpg63,
#endif
    PpgInstanceIndexMax
} en_ppg_instance_index_t;

/* PPG instance data type */
typedef struct stc_ppg_instance_data
{
    volatile stc_btn_ppg_t* pstcInstance;   /*!< pointer to registers of an instance */
    stc_ppg_intern_data_t stcInternData;    /*!< module internal data of instance */
} stc_ppg_instance_data_t;

/*****************************************************************************/
/* Local variable definitions ('static')                                     */
/*****************************************************************************/

/* Look-up table for all enabled PPG instances and their internal data */
static stc_ppg_instance_data_t m_astcPpgInstanceDataLut[] =
{
#if (PDL_PERIPHERAL_ENABLE_PPG0 == PDL_ON)
    {
        &BT00_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG1 == PDL_ON)
    {
        &BT01_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG2 == PDL_ON)
    {
        &BT02_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG3 == PDL_ON)
    {
        &BT03_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG4 == PDL_ON)
    {
        &BT04_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG5 == PDL_ON)
    {
        &BT05_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG6 == PDL_ON)
    {
        &BT06_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG7 == PDL_ON)
    {
        &BT07_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG8 == PDL_ON)
    {
        &BT08_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG9 == PDL_ON)
    {
        &BT09_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG10 == PDL_ON)
    {
        &BT10_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG11 == PDL_ON)
    {
        &BT11_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG12 == PDL_ON)
    {
        &BT12_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG13 == PDL_ON)
    {
        &BT13_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG14 == PDL_ON)
    {
        &BT14_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG15 == PDL_ON)
    {
        &BT15_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG16 == PDL_ON)
    {
        &BT16_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG17 == PDL_ON)
    {
        &BT17_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG18 == PDL_ON)
    {
        &BT18_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG19 == PDL_ON)
    {
        &BT19_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG20 == PDL_ON)
    {
        &BT20_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG21 == PDL_ON)
    {
        &BT21_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG22 == PDL_ON)
    {
        &BT22_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG23 == PDL_ON)
    {
        &BT23_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG24 == PDL_ON)
    {
        &BT24_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG25 == PDL_ON)
    {
        &BT25_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG26 == PDL_ON)
    {
        &BT26_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG27 == PDL_ON)
    {
        &BT27_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG28 == PDL_ON)
    {
        &BT28_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG29 == PDL_ON)
    {
        &BT29_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG30 == PDL_ON)
    {
        &BT30_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG31 == PDL_ON)
    {
        &BT31_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG32 == PDL_ON)
    {
        &BT32_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG33 == PDL_ON)
    {
        &BT33_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG34 == PDL_ON)
    {
        &BT34_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG35 == PDL_ON)
    {
        &BT35_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG36 == PDL_ON)
    {
        &BT36_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG37 == PDL_ON)
    {
        &BT37_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG38 == PDL_ON)
    {
        &BT38_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG39 == PDL_ON)
    {
        &BT39_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG40 == PDL_ON)
    {
        &BT40_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG41 == PDL_ON)
    {
        &BT41_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG42 == PDL_ON)
    {
        &BT42_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG43 == PDL_ON)
    {
        &BT43_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG44 == PDL_ON)
    {
        &BT44_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG45 == PDL_ON)
    {
        &BT45_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG46 == PDL_ON)
    {
        &BT46_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG47 == PDL_ON)
    {
        &BT47_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG48 == PDL_ON)
    {
        &BT48_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG49 == PDL_ON)
    {
        &BT49_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG50 == PDL_ON)
    {
        &BT50_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG51 == PDL_ON)
    {
        &BT51_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG52 == PDL_ON)
    {
        &BT52_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG53 == PDL_ON)
    {
        &BT53_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG54 == PDL_ON)
    {
        &BT54_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG55 == PDL_ON)
    {
        &BT55_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG56 == PDL_ON)
    {
        &BT56_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG57 == PDL_ON)
    {
        &BT57_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG58 == PDL_ON)
    {
        &BT58_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG59 == PDL_ON)
    {
        &BT59_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG60 == PDL_ON)
    {
        &BT60_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG61 == PDL_ON)
    {
        &BT61_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG62 == PDL_ON)
    {
        &BT62_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG63 == PDL_ON)
    {
        &BT63_PPG,      /* pstcInstance */
        { NULL }        /* stcInternData */
    },
#endif
};

/*****************************************************************************/
/* Local function prototypes ('static')                                      */
/*****************************************************************************/

/*****************************************************************************/
/* Function implementation - global ('extern') and local ('static')          */
/*****************************************************************************/

/**
*****************************************************************************
** \brief Return the internal data for a certain PPG instance.
**
** \param pstcPpg Pointer to PPG instance
**
** \return Pointer to internal data or NULL if instance is not enabled (or not known)
**
*****************************************************************************/
static stc_ppg_intern_data_t* PpgGetInternDataPtr(volatile stc_btn_ppg_t* pstcPpg)
{
    uint32_t u32Instance;
    
    for (u32Instance = 0; u32Instance < PPG_INSTANCE_COUNT; u32Instance++)
    {
        if (pstcPpg == m_astcPpgInstanceDataLut[u32Instance].pstcInstance)
        {
            return &m_astcPpgInstanceDataLut[u32Instance].stcInternData;
        }
    }
    
    return NULL;
}

/**
*****************************************************************************
** Definition of all individual ISRs for each enabled PPG instance.
**
** The individual ISR calls the generic IRQ handler with
** the instance pointer and its internal data to handle the interrupt.
*****************************************************************************/
#if (PDL_PERIPHERAL_ENABLE_PPG0 == PDL_ON) || (PDL_PERIPHERAL_ENABLE_PPG8 == PDL_ON) || (PDL_PERIPHERAL_ENABLE_PPG9 == PDL_ON) \
|| (PDL_PERIPHERAL_ENABLE_PPG10 == PDL_ON) || (PDL_PERIPHERAL_ENABLE_PPG11 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg0, INTERRUPTS_IRQ_NUMBER_100)
{
#if (PDL_PERIPHERAL_ENABLE_PPG0 == PDL_ON)
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT00_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg0].stcInternData));
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG8 == PDL_ON)
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT08_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg8].stcInternData));
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG9 == PDL_ON)
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT09_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg9].stcInternData));
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG10 == PDL_ON)
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT10_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg10].stcInternData));
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG11 == PDL_ON)
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT11_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg11].stcInternData));
#endif
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_PPG1 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg1, INTERRUPTS_IRQ_NUMBER_101)
{
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT01_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg1].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_PPG2 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg2, INTERRUPTS_IRQ_NUMBER_102)
{
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT02_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg2].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_PPG3 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg3, INTERRUPTS_IRQ_NUMBER_103)
{
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT03_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg3].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_PPG4 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg4, INTERRUPTS_IRQ_NUMBER_104)
{
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT04_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg4].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_PPG5 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg5, INTERRUPTS_IRQ_NUMBER_105)
{
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT05_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg5].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_PPG6 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg6, INTERRUPTS_IRQ_NUMBER_106)
{
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT06_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg6].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_PPG7 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg7, INTERRUPTS_IRQ_NUMBER_107)
{
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT07_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg7].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif


#if (PDL_PERIPHERAL_ENABLE_PPG12 == PDL_ON) || (PDL_PERIPHERAL_ENABLE_PPG20 == PDL_ON) || (PDL_PERIPHERAL_ENABLE_PPG21 == PDL_ON) \
|| (PDL_PERIPHERAL_ENABLE_PPG22 == PDL_ON) || (PDL_PERIPHERAL_ENABLE_PPG23 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg12, INTERRUPTS_IRQ_NUMBER_108)
{
#if (PDL_PERIPHERAL_ENABLE_PPG12 == PDL_ON)
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT12_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg12].stcInternData));
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG20 == PDL_ON)
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT20_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg20].stcInternData));
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG21 == PDL_ON)
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT21_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg21].stcInternData));
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG22 == PDL_ON)
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT22_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg22].stcInternData));
#endif
#if (PDL_PERIPHERAL_ENABLE_PPG23 == PDL_ON)
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT23_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg23].stcInternData));
#endif
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_PPG13 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg13, INTERRUPTS_IRQ_NUMBER_109)
{
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT13_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg13].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_PPG14 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg14, INTERRUPTS_IRQ_NUMBER_110)
{
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT14_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg14].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_PPG15 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg15, INTERRUPTS_IRQ_NUMBER_111)
{
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT15_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg15].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_PPG16 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg16, INTERRUPTS_IRQ_NUMBER_112)
{
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT16_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg16].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_PPG17 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg17, INTERRUPTS_IRQ_NUMBER_113)
{
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT17_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg17].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_PPG18 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg18, INTERRUPTS_IRQ_NUMBER_114)
{
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT18_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg18].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_PPG19 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg19, INTERRUPTS_IRQ_NUMBER_115)
{
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT19_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg19].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif


#if (PDL_PERIPHERAL_ENABLE_PPG24 == PDL_ON) || (PDL_PERIPHERAL_ENABLE_PPG32 == PDL_ON) || (PDL_PERIPHERAL_ENABLE_PPG33 == PDL_ON) \
|| (PDL_PERIPHERAL_ENABLE_PPG34 == PDL_ON) || (PDL_PERIPHERAL_ENABLE_PPG35 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg24, INTERRUPTS_IRQ_NUMBER_116)
{
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT24_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg24].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_PPG25 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg25, INTERRUPTS_IRQ_NUMBER_117)
{
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT25_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg25].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_PPG26 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg26, INTERRUPTS_IRQ_NUMBER_118)
{
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT26_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg26].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_PPG27 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg27, INTERRUPTS_IRQ_NUMBER_119)
{
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT27_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg27].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_PPG28 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg28, INTERRUPTS_IRQ_NUMBER_120)
{
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT28_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg28].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_PPG29 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg29, INTERRUPTS_IRQ_NUMBER_121)
{
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT29_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg29].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_PPG30 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg30, INTERRUPTS_IRQ_NUMBER_122)
{
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT30_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg30].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif

#if (PDL_PERIPHERAL_ENABLE_PPG31 == PDL_ON)
FN_IRQ_DEFINE_BEGIN(Ppg_Isr_Ppg31, INTERRUPTS_IRQ_NUMBER_123)
{
    BtPpgIrqHandler((stc_btn_ppg_t*)&BT31_PPG, &(m_astcPpgInstanceDataLut[PpgInstanceIndexPpg31].stcInternData));
}
FN_IRQ_DEFINE_END()
#endif


#endif  // __PPG_GENERATED_C__

