#include "ProjectConfig.h"

#if (PRO_CONFIG_EOL_APPLY)
unsigned int VC_List[][2] = 
{
#if (PRO_BL7M)
    {0xC301, 0x1EC41B61},
    {0xC302, 0x1EC41B61},
    {0xC303, 0x1EC41B61},
    {0xC304, 0x1EC41B61},
    {0xC305, 0x1EC41B61},
    {0xC306, 0x1AC40141},
    {0xC307, 0x1EC41B41},
    {0xC308, 0x1EC01B41},
    {0xC309, 0x1EC41B41},
    {0xC310, 0x1EC41B41},
    {0xC311, 0x1EC41B41},
    {0xC312, 0x1AC00141},
    {0xC313, 0x1AC40141},
    {0xC314, 0x1AC40141},
    {0xC315, 0x1AC00141},
#elif (PRO_BL7R)
    {0xC101, 0x1AD41863},
    {0xC102, 0x18D41841},
    {0xC103, 0x18C01841},
    {0xC104, 0x1AD41863},
    {0xC105, 0x1AD41863},
    {0xC106, 0x1AD41863},
    {0xC107, 0x18D41861},
    {0xC108, 0x18D41841},
    {0xC109, 0x18D41841},
    {0xC110, 0x18D41841},
    {0xC111, 0x18D41861},
    {0xC112, 0x18D41841},
    {0xC113, 0x18D41841},
    {0xC114, 0x18D41841},
    {0xC115, 0x1AD41861},
    {0xC116, 0x1AD41863},
    {0xC117, 0x18D41863},
    {0xC118, 0x18C01841},
    {0xC119, 0x1AD41863},
    {0xC120, 0x18D41861},
//#elif (PRO_CN7C)
//    {0xC01, 0x5CC40705},
//    {0xC04, 0xDEC40707},  
#elif (PRO_SU2IFL)
    {0xC000, 0x00000000},
    {0xC028, 0x1CC04904},
    {0xC031, 0x1CC04904},
    {0xC045, 0x1CC00904},
    {0xC021, 0x5CC00905},
    {0xC029, 0x1CC04904},
    {0xC030, 0x1CC04904},
    {0xC032, 0x1CC04904},
    {0xC046, 0x1CC00904},
    {0xC048, 0x1CC60905},
    {0xC052, 0x1CC00101},
    {0xC053, 0x5CC40109},
    {0xC060, 0x5CC00905},
    {0xC131, 0xDEC4010B},
#elif (PRO_US4) //HEV
    {0xC005, 0xDEC40003},
    {0xC008, 0xDEC40003},
    {0xC009, 0xDEC50003},
    {0xC011, 0xDEC50003},
    {0xC013, 0xDEC50003},
    {0xC027, 0xDEC50003},
    {0xC030, 0xDEC50003},
    {0xC033, 0xDEC50003},
    {0xC042, 0xDEC50003},
    {0xC045, 0xDEC50003},
    {0xC047, 0xDEC50003},
    {0xC050, 0xDEC40003},
    {0xC051, 0xDEC50003},
    {0xC052, 0xDEC50003},
    {0xC053, 0xDEC50003},
    {0xC059, 0xDEC50003},
    {0xC062, 0xDEC40003},
    {0xC064, 0xDEC40003},
    {0xC071, 0xDEC50003},
    {0xC074, 0xDEC50003},
    {0xC076, 0xDEC50003},
    {0xC077, 0xDEC50003},
    {0xC085, 0xDEC40003},
    {0xC086, 0xDEC50003}, 
#elif (PRO_PDEPE2)
    {0xC000, 0x00000000},
    {0xC022, 0x1EC50B2F},   
#elif (PRO_YB_PE)
    {0xC000, 0x00000000},
    {0xC001, 0x9EC4032F},
    {0xC002, 0x1EC0030F},
    {0xC003, 0x9EC4032F},
    {0xC004, 0x1EC4230F},
    {0xC005, 0x9EC4032F},
    {0xC006, 0x9EC4032F},
    {0xC007, 0x9EC4032F},
    {0xC008, 0x9EC4032F},
    {0xC009, 0x1EC0030F},
    {0xC010, 0x9EC4032F},
    {0xC011, 0x9EC4032F},
    {0xC012, 0x9EC4032F},
    {0xC013, 0x9EC4032F},
    {0xC014, 0x9EC4032F},
    {0xC015, 0x1EC0030F},
    {0xC016, 0x1EC0030F},
    {0xC017, 0x9EC4032F},
    {0xC018, 0x1EC0030F},
#elif (PRO_JAPE2)
    {0xC000, 0x00000000},
    {0xC001, 0x9EC40001},
    {0xC002, 0x1EC00305},
    {0xC003, 0x1EC40305},
    {0xC004, 0x1EC00305},
    {0xC005, 0x1EC00305},
    {0xC006, 0x1EC40305},
    {0xC007, 0x1EC00305},
    {0xC008, 0x9EC40001},
    {0xC009, 0x1EC40305},
    {0xC010, 0x9EC40001},
    {0xC011, 0x1EC40305},
    {0xC012, 0x9EC40001},
    {0xC013, 0x1EC00305},
    {0xC014, 0x9EC40001},
    {0xC015, 0x1EC00305},
    {0xC016, 0x1EC40305},
    {0xC017, 0x1EC40003},
    {0xC018, 0x1EC00305},
    {0xC020, 0x1EC00305},
    {0xC021, 0x9EC40001},
    {0xC022, 0x1EC40305},
    {0xC023, 0x1EC40305},
    {0xC024, 0x1EC40305},
    {0xC025, 0x9EC40001},
    {0xC026, 0x9EC40001},
    {0xC027, 0x1CC40801},
    {0xC030, 0x9EC40001},
    {0xC031, 0x1EC00305},
    {0xC034, 0x1EC00305},
    {0xC035, 0x1EC40003},
    {0xC037, 0x1EC00305},
    {0xC038, 0x1EC40305},
    {0xC039, 0x1EC40305},
    {0xC040, 0x1EC00305},
    {0xC042, 0x1EC00305},
    {0xC073, 0x1EC40305},
#elif (PRO_YB_PE)
    {0xC000, 0x00000000},
    {0xC001, 0x9EC4036F},
    {0xC002, 0x1EC0034F},
    {0xC003, 0x9EC4036F},
    {0xC004, 0x1EC4134F},
    {0xC005, 0x9EC4036F},
    {0xC006, 0x9EC4036F},
    {0xC007, 0x9EC4036F},
    {0xC008, 0x9EC4036F},
    {0xC009, 0x1EC0034F},
    {0xC010, 0x9EC4036F},
    {0xC011, 0x9EC4036F},
    {0xC012, 0x9EC4036F},
    {0xC013, 0x9EC4036F},
    {0xC014, 0x9EC4036F},
    {0xC015, 0x1EC0034F},
    {0xC016, 0x1EC0034F},
    {0xC017, 0x9EC4036F},
    {0xC018, 0x1EC0034F},
#elif (PRO_SU2BFL)
    {0xC000, 0x00000000},
    {0xC018, 0x1CC0C104},
    {0xC025, 0x1CC0C104},
    {0xC030, 0x1CC0C104},
    {0xC031, 0x1CC00101},
    {0xC035, 0x1CC00101},
#elif (PRO_AX)
    {0xC000, 0x00000000},
    {0xC001, 0xDEC50023},
    {0xC002, 0xDEC50023},
    {0xC003, 0xDEC50023},
    {0xC004, 0x1EC40003},
    {0xC005, 0xDEC50023},
    {0xC006, 0x1EC40003},
    {0xC007, 0xDEC50027},
    {0xC008, 0xDEC50027},
    {0xC009, 0xDEC50027},
    {0xC010, 0xDEC50027},
    {0xC011, 0xDEC50027},
    {0xC012, 0xDEC50027},
    {0xC013, 0xDEC50027},
    {0xC014, 0xDEC50027},
    {0xC015, 0xDEC50027},
    {0xC016, 0xDEC50027},
    {0xC017, 0xDEC50027},
    {0xC018, 0xDEC50027},
    {0xC019, 0xDEC50027},
    {0xC020, 0x1EC40007},
    {0xC021, 0xDEC50027},
    {0xC022, 0xDEC50027},
    {0xC023, 0xDEC50027},
    {0xC024, 0xDEC50027},
    {0xC025, 0xDEC50027},
#elif (PRO_CN7C)
    {0xC000, 0x00000000},
    {0xC001, 0xDEC50203},
    {0xC002, 0xDEC50203},
    {0xC003, 0x5CC50201},
    {0xC004, 0x5CC50201},
    {0xC005, 0x5CC50201},
    {0xC006, 0x5CC50201},
    {0xC007, 0xDEC50203},
    {0xC008, 0xDEC50203},
    {0xC009, 0xDEC50203},
    {0xC010, 0xDEC50203},
    {0xC011, 0xDEC50203},
    {0xC012, 0x5CC40101},
    {0xC013, 0x5CC40101},
    {0xC014, 0x5CC50201},
    {0xC015, 0x5CC50201},
    {0xC016, 0xDEC50203},
    {0xC017, 0xDEC50203},
    {0xC018, 0xDEC50203},
    {0xC019, 0xDEC50203},
    {0xC020, 0xDEC50203},
    {0xC021, 0xDEC50203},
    {0xC022, 0xDEC50203},
    {0xC023, 0xDEC50203},
    {0xC024, 0xDEC50203},
    {0xC025, 0xDEC50203},
    {0xC026, 0xDEC50203},
    {0xC027, 0xDEC50203},
    {0xC028, 0xDEC50203},
    {0xC031, 0xDEC40103},
    {0xC032, 0xDEC50203},
    {0xC033, 0x5CC50201},
    {0xC034, 0xDEC50203},
    {0xC035, 0xDEC50203},
    {0xC042, 0x5CC50201},
    {0xC043, 0xDEC50203},
    {0xC044, 0xDEC50203},
    {0xC045, 0xDEC50203},
    {0xC046, 0xDEC50203},
#elif (PRO_SU2ID_FL)
    {0xC000, 0x00000000},
    {0xC001, 0x5CC00C05},
    {0xC002, 0x5CC00C05},
    {0xC035, 0xDEC40123},
    {0xC036, 0xDEC40123},
    {0xC046, 0xDCC00101},
    {0xC048, 0xDCC40100},
    {0xC049, 0xDCC40100},
    {0xC050, 0xDCC40100},
#else
    {0xC01, 0xFFFF0705},    
#endif    
};

unsigned char g_uiTotleCount;
unsigned char g_uiRowNum = 0;
unsigned char g_uiColNum = 0;

unsigned char g_uiPosUpdateFlag = 0;
unsigned char g_uiIdx = 0;
ST_POS g_stArrowPos[PER_PAGE_MAX_NUM] = {0};

void SetDspCfg(void)
{
    g_uiTotleCount = sizeof(VC_List) / sizeof(VC_List[0]);
    g_uiRowNum = (g_uiTotleCount % PER_ROW_NUM == 0) ? (g_uiTotleCount / PER_ROW_NUM) : (g_uiTotleCount / PER_ROW_NUM + 1);
}
#endif
/////////////////////EOL/////////////////////////////
unsigned char g_BackLightNum = 0;
#if (PRO_NQ5C)
ST_BACK_LIGHT g_st20Level[] = 
{
    {
        {0,  25, 50, 50, 60, 70, 90,  100, 120, 140, 170, 200, 240, 280, 320, 400, 490, 570, 690, 800, 0},
        {0,  75, 70, 70, 80, 90, 110, 120, 140, 160, 190, 230, 260, 310, 370, 430, 510, 630, 730, 870, 0},
    },
};
#elif ((PRO_NQ5) || (PRO_YB_PE) || (PRO_SK3_PE) || (PRO_GL3) || (PRO_SP2C_PE) || (PRO_AX) || (PRO_KS) || (PRO_SG2) || (PRO_PDEPE2) || (PRO_US4) || (PRO_BC3))
ST_BACK_LIGHT g_st20Level[] = 
{
    {
        {0,  20, 30, 40, 60, 70, 90,  110, 130, 150, 180, 220, 260, 310, 360, 430, 510, 590, 700, 820, 960},
        {0,  60, 70, 80, 100, 110, 130, 150, 170, 190, 220, 260, 300, 350, 400, 470, 550, 630, 740, 860, 1000},
    },
};
#elif (PRO_SQFL)
const unsigned int BackLight_Limit_Down[21] = {0,  25, 50, 50, 60, 70, 90,  100, 120, 140, 170, 200, 0, 280, 320, 400, 490, 570, 0, 800, 870};//ҹı,Сֵ
const unsigned int BackLight_Limit_UP[21] =   {0,  75, 70, 70, 80, 90, 110, 120, 140, 160, 190, 230, 0, 310, 370, 430, 510, 630, 0, 870, 1000};//ҹı,ֵ
#elif (PRO_NX4C)
const unsigned int BackLight_Limit_Down[21] = {0,  25, 50, 50, 60, 70, 90,  100, 120, 140, 170, 200, 220, 280, 320, 400, 490, 570, 600, 800, 870};//ҹı,Сֵ
const unsigned int BackLight_Limit_UP[21] =   {0,  75, 70, 70, 80, 110, 120, 140, 160, 190, 220, 260, 300, 340, 400, 470, 540, 640, 740, 870, 1000};//ҹı,ֵ
#elif (PRO_NU2)
ST_BACK_LIGHT g_st20Level[] =
{
    {
        {0,30,40,40,50, 60, 70, 80, 90,110,120,150, 180,210,240,280,330,390,460,540,630},
        {0,70,80,80,90,100,110,120,130,150,170,190,220,250,280,320,370,430,500,580,670},
    },
};
#elif ((PRO_CN7C) || (PRO_NUPE))
ST_BACK_LIGHT g_st20Level[] =
{
    {
        {0,30,40,40,50, 60, 70, 80,110,130,160,190,230,270,330,400,480,570,690,830,0},
        {0,70,80,80,90,100,110,120,150,170,200,230,270,310,370,430,520,610,730,870,0},
    },
};
#elif (PRO_DL3C)
ST_BACK_LIGHT g_st20Level[] =
{
    {
        {0,110,120,130,140,150,160,180,190,220,240,270,310,360,410,480,560,660,770,920,0},
        {0,140,150,160,160,170,180,200,220,240,260,300,340,380,440,500,580,680,800,940,0},
    },
    {
        {0,30,40,40,50, 60, 70, 80,110,130,160,190,230,270,330,400,480,570,690,830,0},
        {0,70,80,80,90,100,110,120,150,170,200,230,270,310,370,430,520,610,730,870,0},
    },
};
#elif (PRO_QYC)
ST_BACK_LIGHT g_st20Level[] =
{
    {
        {0,30,40, 60, 70,100,110,120,140,150,180,190,270,330,390,450,480,570,690,830,0},
        {0,70,80,100,110,130,140,160,180,210,240,270,310,360,420,490,570,660,760,880,0},
    },
};
#elif (PRO_KY)
ST_BACK_LIGHT g_st20Level[] = 
{
    {
        {0,30,40,40,50, 60, 70, 90,110,130,160,190,230,270,330,390,480,570,690,830,0},
        {0,70,80,80,90,100,110,130,150,180,200,230,270,310,370,430,520,610,730,870,0},
    },
};
#elif ((PRO_SU2IFL))
ST_BACK_LIGHT g_st20Level[] = 
{
    {
        {0,30,30,40,50, 70, 80,100,130,150,180,220,250,300,360,420,500,590,690,810,0},
        {0,70,70,80,90,110,120,140,170,190,220,260,300,350,400,470,540,630,740,860,0},
    },
};
#elif (PRO_SP2)
ST_BACK_LIGHT g_st20Level[] = {
{
{0,20,30,40, 60, 70, 90,110,130,150,180,220,260,310,360,430,510,590,700,820,960},//SP2
{0,60,70,80,100,110,130,150,170,190,220,260,300,350,400,470,550,630,740,860,1000},
},
{
{0,30,30,40,50,70,80,100,130,150,180,220,250,300,360,420,500,590,690,810,0},//SP2I
{0,70,70,80,90,110,120,140,170,190,220,260,300,350,400,470,540,630,740,860,0},
},
};
#elif (PRO_AI3)
ST_BACK_LIGHT g_st20Level[] = 
{
    {
        {0,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    },
};
#elif(PRO_QXI)
ST_BACK_LIGHT g_st20Level[] = 
{
    {
        {0,  30,30,40,50,70,80,100,130,150,180,220,250,300,360,420,500,590,690,810,0},
        {0,  70,70,80,90,110,120,140,170,190,220,260,300,350,400,470,540,630,740,860,0},
    },
};
#elif ((PRO_BL7M) || (PRO_CN7) || (PRO_LX2) || (PRO_QX23) || (PRO_BL7R) || (PRO_ONPE) || (PRO_JAPE2) || (PRO_SU2BFL) || (PRO_SU2ID_FL))
ST_BACK_LIGHT g_st20Level[] = 
{
    {
        {0,30,30,40,50, 70, 80,100,130,150,180,220,250,300,360,420,500,590,690,810,960},
        {0,70,70,80,90,110,120,140,170,190,220,260,300,350,400,470,540,630,740,860,1000},
    },
};
#elif (PRO_BN7I)
ST_BACK_LIGHT g_st20Level[] = 
{
    {
        {0,  30,30,40,50,70,80,100,130,150,180,220,250,300,360,420,500,590,690,810,0},
        {0,  70,70,80,90,110,120,140,170,190,220,260,300,350,400,470,540,630,740,860,0},
    },
};
#elif ((PRO_KU) || (PRO_AC3_PE) || (PRO_BR2))
ST_BACK_LIGHT g_st20Level[] = 
{
    {
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
    },
};
#elif ((PRO_TAM) || (PRO_SU2ID))
ST_BACK_LIGHT g_st20Level[] = 
{
    {
        {0, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,  15, 15, 15, 15, 15, 15, 15, 15},
        {0,700,700,700,700,700,700,700,700,700,700,700,700,700,700,700,700,700,700,700,700},
    },
};
const unsigned int BackLight_Limit_Down[21] = {0,  15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15};//ҹı
const unsigned int BackLight_Limit_UP[21] =   {0,  700,700,700,700,700,700,700,700,700,700,700,700,700,700,700,700,700,700,700,700};
#else
ST_BACK_LIGHT g_st20Level[] = 
{
    {
        {0,  140,150,160,180,200,220,250,280,330,380,430,250,470,520,580,620,670,700,770,820},
        {0,  160,170,180,200,220,240,270,300,350,400,450,300,490,550,590,640,690,730,790,840},
    },
};
#endif

ST_AUTO_CFG g_AutoConfig = {AUTO_CAN_1,AUTO_CAN_SW_HW_1,
                            AUTO_CAN_SW1_1,
                            AUTO_CAN_SW2_1,
                            AUTO_CAN_Engine_1,
                            AUTO_CAN_PRNDS_1,
                            AUTO_CAN_GND_1,
                            AUTO_CAN_Rheo_1,
                            AUTO_CAN_Detent_1,
                            AUTO_CAN_DMS_1,
                            AUTO_CAN_Speed_ILL_1,
                            AUTO_CAN_OutPut};

static ST_VEHICLE_CFG g_VehicleConfig [] = 
{
#if (PRO_QXI)
{"QXI",       PRO_QXI,  CAR_TYPE_ICV,  "94013K3600", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"QXI",       PRO_QXI,  CAR_TYPE_ICV,  "94013K3650", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"QXI",       PRO_QXI,  CAR_TYPE_ICV,  "94013K3620", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"QXI",       PRO_QXI,  CAR_TYPE_ICV,  "94013K3630", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"QXI_23MY",  PRO_QXI,  CAR_TYPE_ICV,  "94013K3610", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
#endif
#if (PRO_QX23)																	   
{"QX23MY",    PRO_QX23, CAR_TYPE_ICV,  "94033K2000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"QX23MY",    PRO_QX23, CAR_TYPE_ICV,  "94033K2100", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"QX23MY",    PRO_QX23, CAR_TYPE_ICV,  "94033K2200", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"QX23MY",    PRO_QX23, CAR_TYPE_ICV,  "94033K2210", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
#endif
#if (PRO_LX2)
{"LX2",       PRO_LX2,  CAR_TYPE_ICV,  "94053S8000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"LX2",       PRO_LX2,  CAR_TYPE_ICV,  "94053S8010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"LX2_24MY",  PRO_LX2,  CAR_TYPE_ICV,  "94053S8100", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"LX2_24MY",  PRO_LX2,  CAR_TYPE_ICV,  "94053S8110", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
#endif
#if (PRO_KY)																	   
{"KY",        PRO_KY,   CAR_TYPE_ICV,  "94013DY010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3},
{"KY",        PRO_KY,   CAR_TYPE_ICV,  "94013DY000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3},
{"KY",        PRO_KY,   CAR_TYPE_ICV,  "94013DY100", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3},
{"KY",        PRO_KY,   CAR_TYPE_ICV,  "94013DY110", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3},
{"KY",        PRO_KY,   CAR_TYPE_ICV,  "94023DY500", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3},
{"KY",        PRO_KY,   CAR_TYPE_ICV,  "94023DY520", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3},

{"KY_RDE",    PRO_KY,   CAR_TYPE_ICV,  "94013DY250", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3},
{"KY_RDE",    PRO_KY,   CAR_TYPE_ICV,  "94013DY260", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3},
{"KY_RDE",    PRO_KY,   CAR_TYPE_ICV,  "94013DY350", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_YES,  RESERVE3},
{"KY_RDE",    PRO_KY,   CAR_TYPE_ICV,  "94013DY360", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_YES,  RESERVE3},
{"KY_RDE",    PRO_KY,   CAR_TYPE_ICV,  "94023DY510", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_YES,  RESERVE3},
{"KY_RDE",    PRO_KY,   CAR_TYPE_ICV,  "94023DY530", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_YES,  RESERVE3},

{"KY_23MY",   PRO_KY,   CAR_TYPE_ICV,  "94023DY000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3},
{"KY_23MY",   PRO_KY,   CAR_TYPE_ICV,  "94023DY020", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3},
{"KY_23MY",   PRO_KY,   CAR_TYPE_ICV,  "94023DY040", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3},
{"KY_23MY",   PRO_KY,   CAR_TYPE_ICV,  "94023DY050", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3},
{"KY_23MY",   PRO_KY,   CAR_TYPE_ICV,  "94023DY010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_YES,  RESERVE3},
{"KY_23MY",   PRO_KY,   CAR_TYPE_ICV,  "94023DY030", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_YES,  RESERVE3},
{"KY_23MY",   PRO_KY,   CAR_TYPE_ICV,  "94023DY060", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_YES,  RESERVE3},
{"KY_23MY",   PRO_KY,   CAR_TYPE_ICV,  "94023DY070", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_YES,  RESERVE3},
{"KY_23MY",   PRO_KY,   CAR_TYPE_ICV,  "94023DY600", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3},
#endif
#if (PRO_KS)
{"KS",        PRO_KS,   CAR_TYPE_ICV,  "94013I6000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"KS",        PRO_KS,   CAR_TYPE_ICV,  "94013I6100", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"KS_23MY",   PRO_KS,   CAR_TYPE_ICV,  "94013I6010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"KS_23MY",   PRO_KS,   CAR_TYPE_ICV,  "94013I6020", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"KS_23MY",   PRO_KS,   CAR_TYPE_ICV,  "94013I6030", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"KS_23MY",   PRO_KS,   CAR_TYPE_ICV,  "94013I6110", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"KS_23MY",   PRO_KS,   CAR_TYPE_ICV,  "94013I6120", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"KS_CROSS",  PRO_KS,   CAR_TYPE_ICV,  "94013I6200", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"KS_CROSS",  PRO_KS,   CAR_TYPE_ICV,  "94013I6210", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
#endif
#if (PRO_AX)
{"AX",        PRO_AX,   CAR_TYPE_ICV,  "94013O6000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"AX",        PRO_AX,   CAR_TYPE_ICV,  "94023O6000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}
#endif
#if (PRO_BR2)
{"BR2",       PRO_BR2,  CAR_TYPE_ICV,  "94043R1000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
#endif
#if (PRO_SG2)
{"SG2_HEV",        PRO_SG2,  CAR_TYPE_HEV,  "94003AT000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},//-HEV
{"SG2_HEV",        PRO_SG2,  CAR_TYPE_HEV,  "94003AT010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_HEV",        PRO_SG2,  CAR_TYPE_HEV,  "94003AT020", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_HEV",        PRO_SG2,  CAR_TYPE_HEV,  "94003AT030", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_HEV",        PRO_SG2,  CAR_TYPE_HEV,  "94001AT000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},//-HEV
{"SG2_HEV",        PRO_SG2,  CAR_TYPE_HEV,  "94001AT010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_HEV",        PRO_SG2,  CAR_TYPE_HEV,  "94001AT020", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_HEV",        PRO_SG2,  CAR_TYPE_HEV,  "94001AT030", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},

{"SG2_PHEV",       PRO_SG2,  CAR_TYPE_PHEV, "94003AT100", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},//-PHEV
{"SG2_PHEV",       PRO_SG2,  CAR_TYPE_PHEV, "94003AT110", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_PHEV",       PRO_SG2,  CAR_TYPE_PHEV, "94003AT120", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_PHEV",       PRO_SG2,  CAR_TYPE_PHEV, "94003AT130", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},  
{"SG2_PHEV",       PRO_SG2,  CAR_TYPE_PHEV, "94001AT100", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},//-PHEV
{"SG2_PHEV",       PRO_SG2,  CAR_TYPE_PHEV, "94001AT110", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_PHEV",       PRO_SG2,  CAR_TYPE_PHEV, "94001AT120", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_PHEV",       PRO_SG2,  CAR_TYPE_PHEV, "94001AT130", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},

{"SG2_24MY_HEV",     PRO_SG2,  CAR_TYPE_HEV,  "94003AT001", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},//-HEV
{"SG2_24MY_HEV",     PRO_SG2,  CAR_TYPE_HEV,  "94003AT011", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_24MY_HEV",     PRO_SG2,  CAR_TYPE_HEV,  "94003AT021", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_24MY_HEV",     PRO_SG2,  CAR_TYPE_HEV,  "94003AT031", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_24MY_HEV",     PRO_SG2,  CAR_TYPE_HEV,  "94001AT001", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},//-HEV
{"SG2_24MY_HEV",     PRO_SG2,  CAR_TYPE_HEV,  "94001AT011", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_24MY_HEV",     PRO_SG2,  CAR_TYPE_HEV,  "94001AT021", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_24MY_HEV",     PRO_SG2,  CAR_TYPE_HEV,  "94001AT031", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},

{"SG2_24MY_PHEV",    PRO_SG2,  CAR_TYPE_PHEV, "94003AT101", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},//-PHEV
{"SG2_24MY_PHEV",    PRO_SG2,  CAR_TYPE_PHEV, "94003AT111", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_24MY_PHEV",    PRO_SG2,  CAR_TYPE_PHEV, "94003AT121", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_24MY_PHEV",    PRO_SG2,  CAR_TYPE_PHEV, "94003AT131", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_24MY_PHEV",    PRO_SG2,  CAR_TYPE_PHEV, "94001AT101", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},//-PHEV
{"SG2_24MY_PHEV",    PRO_SG2,  CAR_TYPE_PHEV, "94001AT111", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_24MY_PHEV",    PRO_SG2,  CAR_TYPE_PHEV, "94001AT121", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_24MY_PHEV",    PRO_SG2,  CAR_TYPE_PHEV, "94001AT131", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},

{"SG2_25MY_HEV",     PRO_SG2,  CAR_TYPE_HEV,  "94003AT200", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},//-HEV
{"SG2_25MY_HEV",     PRO_SG2,  CAR_TYPE_HEV,  "94003AT210", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_25MY_HEV",     PRO_SG2,  CAR_TYPE_HEV,  "94003AT220", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_25MY_HEV",     PRO_SG2,  CAR_TYPE_HEV,  "94003AT230", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_25MY_HEV",     PRO_SG2,  CAR_TYPE_HEV,  "94001AT240", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},//-HEV
{"SG2_25MY_HEV",     PRO_SG2,  CAR_TYPE_HEV,  "94001AT250", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_25MY_HEV",     PRO_SG2,  CAR_TYPE_HEV,  "94001AT260", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_25MY_HEV",     PRO_SG2,  CAR_TYPE_HEV,  "94001AT270", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},

{"SG2_25MY_PHEV",    PRO_SG2,  CAR_TYPE_PHEV, "94003AT300", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},//-PHEV
{"SG2_25MY_PHEV",    PRO_SG2,  CAR_TYPE_PHEV, "94003AT310", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_25MY_PHEV",    PRO_SG2,  CAR_TYPE_PHEV, "94003AT320", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_25MY_PHEV",    PRO_SG2,  CAR_TYPE_PHEV, "94003AT330", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_25MY_PHEV",    PRO_SG2,  CAR_TYPE_PHEV, "94001AT340", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},//-PHEV
{"SG2_25MY_PHEV",    PRO_SG2,  CAR_TYPE_PHEV, "94001AT350", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_25MY_PHEV",    PRO_SG2,  CAR_TYPE_PHEV, "94001AT360", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SG2_25MY_PHEV",    PRO_SG2,  CAR_TYPE_PHEV, "94001AT370", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
#endif
#if (PRO_US4)																	   
{"US4_ICV",   PRO_US4,  CAR_TYPE_ICV,  "94003CG000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},//US4_ICV
{"US4_ICV",   PRO_US4,  CAR_TYPE_ICV,  "94003CG010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},//US4_ICV
{"US4_ICV",   PRO_US4,  CAR_TYPE_ICV,  "94003CG100", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},//US4_ICV
{"US4_ICV",   PRO_US4,  CAR_TYPE_ICV,  "94003CG110", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},//US4_ICV
{"US4_ICV",   PRO_US4,  CAR_TYPE_ICV,  "94003CG200", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},//US4_ICV
{"US4_ICV",   PRO_US4,  CAR_TYPE_ICV,  "94003CG210", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},//US4_ICV
{"US4_HEV",   PRO_US4,  CAR_TYPE_HEV,  "94003DR000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},//US4_HEV
{"US4_HEV",   PRO_US4,  CAR_TYPE_HEV,  "94003DR010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},//US4_HEV
#endif
#if (PRO_GL3)																	   
{"GL3_ICV",       PRO_GL3,  CAR_TYPE_ICV,  "94003L8000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"GL3_ICV",       PRO_GL3,  CAR_TYPE_ICV,  "94003L8010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},    
{"GL3_HEV",       PRO_GL3,  CAR_TYPE_HEV,  "94003N0000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, 
{"GL3_HEV",       PRO_GL3,  CAR_TYPE_HEV,  "94003N0100", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, 
#endif
#if (PRO_NQ5)																	   
{"NQ5_ICV",        PRO_NQ5,  CAR_TYPE_ICV,  "94003P1000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5 
{"NQ5_ICV",        PRO_NQ5,  CAR_TYPE_ICV,  "94003P1010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5 
{"NQ5_ICV",        PRO_NQ5,  CAR_TYPE_ICV,  "94003P1500", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5  
{"NQ5_ICV",        PRO_NQ5,  CAR_TYPE_ICV,  "94003P1020", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5 
{"NQ5_ICV",        PRO_NQ5,  CAR_TYPE_ICV,  "94003P1520", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5
{"NQ5_ICV",        PRO_NQ5,  CAR_TYPE_ICV,  "94003P1510", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5  
{"NQ5_ICV",        PRO_NQ5,  CAR_TYPE_ICV,  "94003P1600", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5  
{"NQ5_ICV",        PRO_NQ5,  CAR_TYPE_ICV,  "94003P1610", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5   
{"NQ5_HEV",        PRO_NQ5,  CAR_TYPE_HEV,  "94003CH000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5 HEV 
{"NQ5_HEV",        PRO_NQ5,  CAR_TYPE_HEV,  "94003CH010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5 HEV 
{"NQ5_HEV",        PRO_NQ5,  CAR_TYPE_HEV,  "94003CH500", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5 HEV 
{"NQ5_HEV",        PRO_NQ5,  CAR_TYPE_HEV,  "94003CH510", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5 HEV 
{"NQ5_HEV",        PRO_NQ5,  CAR_TYPE_HEV,  "94003CH520", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5 HEV 
{"NQ5_HEV",        PRO_NQ5,  CAR_TYPE_HEV,  "94003CH530", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5 HEV 
{"NQ5_PHEV",       PRO_NQ5,  CAR_TYPE_PHEV, "94003CH100", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5 PHEV 
{"NQ5_PHEV",       PRO_NQ5,  CAR_TYPE_PHEV, "94003CH600", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5 PHEV 
																   
{"NQ5a_ICV",       PRO_NQ5,  CAR_TYPE_ICV,  "94003DW000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5a 
{"NQ5a_ICV",       PRO_NQ5,  CAR_TYPE_ICV,  "94003DW500", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5a  
{"NQ5a_ICV",       PRO_NQ5,  CAR_TYPE_ICV,  "94003DW510", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5a  
																   
{"NQ5e_ICV",       PRO_NQ5,  CAR_TYPE_ICV,  "94003R2000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e 
{"NQ5e_ICV",       PRO_NQ5,  CAR_TYPE_ICV,  "94003R2010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e 
{"NQ5e_ICV",       PRO_NQ5,  CAR_TYPE_ICV,  "94003R2500", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e  
{"NQ5e_ICV",       PRO_NQ5,  CAR_TYPE_ICV,  "94003R2510", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e  
{"NQ5e_ICV",       PRO_NQ5,  CAR_TYPE_ICV,  "94003R2600", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e  
{"NQ5e_ICV",       PRO_NQ5,  CAR_TYPE_ICV,  "94003R2610", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e  
{"NQ5e_HEV",       PRO_NQ5,  CAR_TYPE_HEV,  "94003CJ000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e HEV 
{"NQ5e_HEV",       PRO_NQ5,  CAR_TYPE_HEV,  "94003CJ500", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e HEV   
{"NQ5e_HEV",       PRO_NQ5,  CAR_TYPE_HEV,  "94003CJ600", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e HEV   
{"NQ5e_HEV",       PRO_NQ5,  CAR_TYPE_HEV,  "94003CJ620", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e HEV 
{"NQ5e_HEV",       PRO_NQ5,  CAR_TYPE_HEV,  "94003CJ010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e HEV   
{"NQ5e_HEV",       PRO_NQ5,  CAR_TYPE_HEV,  "94003CJ520", &g_AutoConfig,STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e HEV  
{"NQ5e_PHEV",      PRO_NQ5,  CAR_TYPE_PHEV, "94003CJ100", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e PHEV 
{"NQ5e_PHEV",      PRO_NQ5,  CAR_TYPE_PHEV, "94003CJ510", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e PHEV 
{"NQ5e_PHEV",      PRO_NQ5,  CAR_TYPE_PHEV, "94003CJ610", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e PHEV 
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
{"NQ5e_24MY",      PRO_NQ5,  CAR_TYPE_ICV,  "94003R2100", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_YES,  HBA_WHITE_YES}, //NQ5e_24MY
{"NQ5e_24MY",      PRO_NQ5,  CAR_TYPE_ICV,  "94003R2110", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_YES,  HBA_WHITE_YES}, //NQ5e_24MY
{"NQ5e_24MY",      PRO_NQ5,  CAR_TYPE_ICV,  "94003R2700", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_YES,  HBA_WHITE_YES}, //NQ5e_24MY
{"NQ5e_24MY",      PRO_NQ5,  CAR_TYPE_ICV,  "94003R2710", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_YES,  HBA_WHITE_YES}, //NQ5e_24MY
{"NQ5e_24MY",      PRO_NQ5,  CAR_TYPE_ICV,  "94003R2800", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_YES,  HBA_WHITE_YES}, //NQ5e_24MY
{"NQ5e_24MY",      PRO_NQ5,  CAR_TYPE_ICV,  "94003R2810", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_YES,  HBA_WHITE_YES}, //NQ5e_24MY
{"NQ5e_24MY",      PRO_NQ5,  CAR_TYPE_HEV,  "94003CJ200", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_YES,  HBA_WHITE_YES}, //NQ5e_24MY
{"NQ5e_24MY",      PRO_NQ5,  CAR_TYPE_HEV,  "94003CJ210", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_YES,  HBA_WHITE_YES}, //NQ5e_24MY
{"NQ5e_24MY",      PRO_NQ5,  CAR_TYPE_HEV,  "94003CJ700", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_YES,  HBA_WHITE_YES}, //NQ5e_24MY
{"NQ5e_24MY",      PRO_NQ5,  CAR_TYPE_HEV,  "94003CJ710", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_YES,  HBA_WHITE_YES}, //NQ5e_24MY
{"NQ5e_24MY",      PRO_NQ5,  CAR_TYPE_HEV,  "94003CJ730", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_YES,  HBA_WHITE_YES}, //NQ5e_24MY
{"NQ5e_24MY",      PRO_NQ5,  CAR_TYPE_PHEV, "94003CJ220", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_YES,  HBA_WHITE_YES}, //NQ5e_24MY
{"NQ5e_24MY",      PRO_NQ5,  CAR_TYPE_PHEV, "94003CJ720", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_YES,  HBA_WHITE_YES}, //NQ5e_24MY
{"NQ5e_24MY",      PRO_NQ5,  CAR_TYPE_PHEV, "94003CJ740", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_YES,  HBA_WHITE_YES}, //NQ5e_24MY
{"NQ5_24MY",       PRO_NQ5,  CAR_TYPE_ICV,  "94003P1030", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5_24MY",       PRO_NQ5,  CAR_TYPE_ICV,  "94003P1040", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5_24MY",       PRO_NQ5,  CAR_TYPE_ICV,  "94003P1060", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5_24MY",       PRO_NQ5,  CAR_TYPE_ICV,  "94003P1530", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5_24MY",       PRO_NQ5,  CAR_TYPE_ICV,  "94003P1540", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5_24MY",       PRO_NQ5,  CAR_TYPE_ICV,  "94003P1560", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5_24MY",       PRO_NQ5,  CAR_TYPE_ICV,  "94003P1620", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5_24MY",       PRO_NQ5,  CAR_TYPE_ICV,  "94003P1630", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5_24MY",       PRO_NQ5,  CAR_TYPE_ICV,  "94003P1640", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5_24MY",       PRO_NQ5,  CAR_TYPE_HEV,  "94003CH200", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5_24MY",       PRO_NQ5,  CAR_TYPE_HEV,  "94003CH210", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5_24MY",       PRO_NQ5,  CAR_TYPE_HEV,  "94003CH220", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5_24MY",       PRO_NQ5,  CAR_TYPE_HEV,  "94003CH700", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5_24MY",       PRO_NQ5,  CAR_TYPE_HEV,  "94003CH710", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5_24MY",       PRO_NQ5,  CAR_TYPE_HEV,  "94003CH720", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5_24MY",       PRO_NQ5,  CAR_TYPE_HEV,  "94003CH730", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5_24MY",       PRO_NQ5,  CAR_TYPE_HEV,  "94003CH740", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5_24MY",       PRO_NQ5,  CAR_TYPE_HEV,  "94003CH750", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5_24MY",       PRO_NQ5,  CAR_TYPE_PHEV, "94003CH300", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5_24MY",       PRO_NQ5,  CAR_TYPE_PHEV, "94003CH800", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5_24MY",       PRO_NQ5,  CAR_TYPE_ICV,  "94003P1050", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5_24MY",       PRO_NQ5,  CAR_TYPE_ICV,  "94003P1550", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5a_24MY",      PRO_NQ5,  CAR_TYPE_ICV,  "94003DW100", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
{"NQ5a_24MY",      PRO_NQ5,  CAR_TYPE_ICV,  "94003DW600", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  FCA_RED_NO,  HBA_WHITE_NO}, //NQ5e_24MY
#endif
#if (PRO_ONPE)																	   
{"ONPE",      PRO_ONPE, CAR_TYPE_ICV,  "94051S9000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //ONPE 
#endif
#if (PRO_NUPE)																	   
{"NUPE",      PRO_NUPE, CAR_TYPE_ICV,  "94033S6000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //NUPE STD
{"NUPE",      PRO_NUPE, CAR_TYPE_ICV,  "94033S6020", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //NUPE SVC
#endif
#if (PRO_KU)																	   
{"KU",        PRO_KU,   CAR_TYPE_ICV,  "94003O3000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //KU SVC
{"KU",        PRO_KU,   CAR_TYPE_ICV,  "94023O3000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //KU SVC
{"KU",        PRO_KU,   CAR_TYPE_ICV,  "94033O3000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //KU SVC
{"KU",        PRO_KU,   CAR_TYPE_ICV,  "94043O3000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //KU SVC
#endif
#if (PRO_NQ5C)																	   
{"NQ5C_ICV",  PRO_NQ5C, CAR_TYPE_ICV,  "94003R4000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //NQ5C ICV STD
{"NQ5C_ICV",  PRO_NQ5C, CAR_TYPE_ICV,  "94003R4020", &g_AutoConfig, STD_CFG, BVM_NO, SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //NQ5C ICV STD
{"NQ5C_ICV",  PRO_NQ5C, CAR_TYPE_ICV,  "94003R4030", &g_AutoConfig, STD_CFG, BVM_YES, SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //NQ5C ICV STD
{"NQ5C_ICV",  PRO_NQ5C, CAR_TYPE_ICV,  "94003R4040", &g_AutoConfig, STD_CFG, BVM_YES, SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //NQ5C ICV STD
{"NQ5C_ICV",  PRO_NQ5C, CAR_TYPE_ICV,  "94013R4000", &g_AutoConfig, SVC_CFG, BVM_YES, SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //NQ5C ICV SVC

{"NQ5C_HEV",  PRO_NQ5C, CAR_TYPE_HEV,  "94003CK000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //NQ5C HEV STD
{"NQ5C_HEV",  PRO_NQ5C, CAR_TYPE_HEV,  "94003CK010", &g_AutoConfig, STD_CFG, BVM_YES, SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //NQ5C HEV STD
{"NQ5C_HEV",  PRO_NQ5C, CAR_TYPE_HEV,  "94013CK000", &g_AutoConfig, SVC_CFG, BVM_YES, SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //NQ5C HEV SVC
{"NQ5C_HEV",  PRO_NQ5C, CAR_TYPE_HEV,  "94013CK010", &g_AutoConfig, SVC_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //NQ5C HEV SVC

{"NQ5C_ICV",  PRO_NQ5C, CAR_TYPE_ICV,  "94043R4000", &g_AutoConfig, SVC_CFG, BVM_NO, SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //NQ5C ICV SVC
{"NQ5C_ICV",  PRO_NQ5C, CAR_TYPE_ICV,  "94043R4010", &g_AutoConfig, SVC_CFG, BVM_NO, SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //NQ5C ICV SVC
{"NQ5C_ICV",  PRO_NQ5C, CAR_TYPE_ICV,  "94033R4010", &g_AutoConfig, STD_CFG, BVM_NO, SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //NQ5C ICV STD
{"NQ5C_ICV",  PRO_NQ5C, CAR_TYPE_ICV,  "94033R4000", &g_AutoConfig, STD_CFG, BVM_NO, SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //NQ5C ICV STD
#endif

#if (PRO_BL7M)																	   
{"BL7M",      PRO_BL7M, CAR_TYPE_ICV,  "94013BC000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BL7M
{"BL7M",      PRO_BL7M, CAR_TYPE_ICV,  "94013BC010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BL7M
{"BL7M",      PRO_BL7M, CAR_TYPE_ICV,  "94011BC000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BL7M
{"BL7M",      PRO_BL7M, CAR_TYPE_ICV,  "94011BC010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BL7M
#endif
#if (PRO_BL7R)																	   
{"BL7R",      PRO_BL7R, CAR_TYPE_ICV,  "94013BA000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BL7R
{"BL7R",      PRO_BL7R, CAR_TYPE_ICV,  "94011BA000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BL7R
#endif
#if (PRO_CN7C)																	   
{"CN7C_STD",      PRO_CN7C, CAR_TYPE_ICV,  "94033BU000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7C
{"CN7C_STD",      PRO_CN7C, CAR_TYPE_ICV,  "94033BU010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7C
{"CN7C_STD",      PRO_CN7C, CAR_TYPE_ICV,  "94033BU020", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7C
{"CN7C_STD",      PRO_CN7C, CAR_TYPE_ICV,  "94033BU030", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7C
{"CN7C_STD",      PRO_CN7C, CAR_TYPE_ICV,  "94033BU050", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7C

{"CN7C_MID",      PRO_CN7C, CAR_TYPE_ICV,  "94043BU000", &g_AutoConfig, MID_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7C
{"CN7C_MID",      PRO_CN7C, CAR_TYPE_ICV,  "94043BU010", &g_AutoConfig, MID_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7C
{"CN7C_MID",      PRO_CN7C, CAR_TYPE_ICV,  "94043BU020", &g_AutoConfig, MID_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7C
{"CN7C_MID",      PRO_CN7C, CAR_TYPE_ICV,  "94043BU030", &g_AutoConfig, MID_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7C
{"CN7C_MID",      PRO_CN7C, CAR_TYPE_ICV,  "94043BU040", &g_AutoConfig, MID_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7C
{"CN7C_MID",      PRO_CN7C, CAR_TYPE_ICV,  "94043BU050", &g_AutoConfig, MID_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7C

{"CN7C_SVC",      PRO_CN7C, CAR_TYPE_ICV,  "94053BU000", &g_AutoConfig, SVC_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7C
{"CN7C_SVC",      PRO_CN7C, CAR_TYPE_ICV,  "94053BU010", &g_AutoConfig, SVC_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7C
{"CN7C_SVC",      PRO_CN7C, CAR_TYPE_ICV,  "94053BU020", &g_AutoConfig, SVC_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7C
{"CN7C_SVC",      PRO_CN7C, CAR_TYPE_ICV,  "94053BU030", &g_AutoConfig, SVC_CFG, BVM_YES, SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7C
{"CN7C_SVC",      PRO_CN7C, CAR_TYPE_ICV,  "94053BU040", &g_AutoConfig, SVC_CFG, BVM_YES, SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7C
{"CN7C_SVC",      PRO_CN7C, CAR_TYPE_ICV,  "94053BU050", &g_AutoConfig, SVC_CFG, BVM_YES, SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7C
{"CN7C_SVC",      PRO_CN7C, CAR_TYPE_ICV,  "94053BU060", &g_AutoConfig, SVC_CFG, BVM_YES, SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7C
{"CN7C_SVC",      PRO_CN7C, CAR_TYPE_ICV,  "94053BU070", &g_AutoConfig, SVC_CFG, BVM_YES, SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7C
#endif
#if (PRO_SQFL)																	   
{"SQFL",      PRO_SQFL, CAR_TYPE_ICV,  "94023J1000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //SQFL
{"SQFL",      PRO_SQFL, CAR_TYPE_ICV,  "94023J1020", &g_AutoConfig, SVC_CFG, BVM_NO,  SPORT_PLUS_YES, RESERVE2,  RESERVE3}, //SQFL
{"SQFL",      PRO_SQFL, CAR_TYPE_ICV,  "94023J1030", &g_AutoConfig, SVC_CFG, BVM_NO,  SPORT_PLUS_YES, RESERVE2,  RESERVE3}, //SQFL
{"SQFL",      PRO_SQFL, CAR_TYPE_ICV,  "94013BC000", &g_AutoConfig, SVC_CFG, BVM_NO,  SPORT_PLUS_YES, RESERVE2,  RESERVE3}, //SQFL
#endif
#if (PRO_SK3_PE)																	   
{"SK3_PE",      PRO_SK3_PE, CAR_TYPE_ICV,    "94023K0000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //SK3
{"SK3_PE",      PRO_SK3_PE, CAR_TYPE_ICV,    "94023K0010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //SK3
{"SK3_24MY",    PRO_SK3_PE, CAR_TYPE_ICV,    "94023K0020", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SK3_24MY",    PRO_SK3_PE, CAR_TYPE_ICV,    "94023K0030", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
#endif
#if (PRO_PDEPE2)																	   
{"PDE_PE2",  PRO_PDEPE2, CAR_TYPE_ICV,  "94073G4000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO, RESERVE2,  RESERVE3}, //PRO_PDEPE2
{"PDE_PE2",  PRO_PDEPE2, CAR_TYPE_ICV,  "94073G4010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO, RESERVE2,  RESERVE3}, //PRO_PDEPE2
#endif
#if (PRO_BN7R)																	   
{"BN7R",      PRO_BN7R, CAR_TYPE_ICV,  "94013AW000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BN7R
#endif
#if (PRO_SU2IFL)																	   
{"SU2I_FL", PRO_SU2IFL, CAR_TYPE_ICV,  "94003BV700", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3}, //SU2I_FL
{"SU2I_FL", PRO_SU2IFL, CAR_TYPE_ICV,  "94003BV710", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_YES,  RESERVE3}, //SU2I_FL
{"SU2I_FL", PRO_SU2IFL, CAR_TYPE_ICV,  "94003BV720", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3}, //SU2I_FL
{"SU2I_FL", PRO_SU2IFL, CAR_TYPE_ICV,  "94003BV730", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_YES,  RESERVE3}, //SU2I_FL
{"SU2I_FL", PRO_SU2IFL, CAR_TYPE_ICV,  "94003BV740", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3}, //SU2I_FL
{"SU2I_FL", PRO_SU2IFL, CAR_TYPE_ICV,  "94003BV750", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_YES,  RESERVE3}, //SU2I_FL
{"SU2I_FL", PRO_SU2IFL, CAR_TYPE_ICV,  "94003BV800", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3}, //SU2I_FL
{"SU2I_FL", PRO_SU2IFL, CAR_TYPE_ICV,  "94003BV810", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3}, //SU2I_FL
{"SU2I_FL", PRO_SU2IFL, CAR_TYPE_ICV,  "94003BV820", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3}, //SU2I_FL
{"SU2I_LWB_FL", PRO_SU2IFL, CAR_TYPE_ICV,  "94023BV700", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_YES,  RESERVE3}, //SU2I_FL
{"SU2I_LWB_FL", PRO_SU2IFL, CAR_TYPE_ICV,  "94023BV710", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3}, //SU2I_FL
{"SU2I_LWB_FL", PRO_SU2IFL, CAR_TYPE_ICV,  "94023BV720", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_YES,  RESERVE3}, //SU2I_FL
{"SU2I_LWB_FL", PRO_SU2IFL, CAR_TYPE_ICV,  "94023BV730", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3}, //SU2I_FL
{"SU2I_LWB_FL", PRO_SU2IFL, CAR_TYPE_ICV,  "94023BV740", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_YES,  RESERVE3}, //SU2I_FL
{"SU2I_LWB_FL", PRO_SU2IFL, CAR_TYPE_ICV,  "94023BV750", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3}, //SU2I_FL
{"SU2I_LWB_FL", PRO_SU2IFL, CAR_TYPE_ICV,  "94023BV800", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_YES,  RESERVE3}, //SU2I_FL
{"SU2I_LWB_FL", PRO_SU2IFL, CAR_TYPE_ICV,  "94023BV810", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3}, //SU2I_FL
{"SU2I_LWB_FL", PRO_SU2IFL, CAR_TYPE_ICV,  "94023BV820", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_YES,  RESERVE3}, //SU2I_FL
{"SU2I_LWB_FL", PRO_SU2IFL, CAR_TYPE_ICV,  "94023BV830", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3}, //SU2I_FL
{"SU2I_LWB_FL", PRO_SU2IFL, CAR_TYPE_ICV,  "94023BV840", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_YES,  RESERVE3}, //SU2I_FL
{"SU2I_LWB_FL", PRO_SU2IFL, CAR_TYPE_ICV,  "94023BV850", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  DBC_NO,  RESERVE3}, //SU2I_FL
#endif
#if (PRO_SP2C_PE)																	   
{"SP2C_PE",PRO_SP2C_PE, CAR_TYPE_ICV,  "94023Q7000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //SP2C_PE
{"SP2C_PE",PRO_SP2C_PE, CAR_TYPE_ICV,  "94023Q7010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SP2C_PE",PRO_SP2C_PE, CAR_TYPE_ICV,  "94023Q7500", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SP2C_PE",PRO_SP2C_PE, CAR_TYPE_ICV,  "94023Q7510", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SP2C_PE",PRO_SP2C_PE, CAR_TYPE_ICV,  "94023Q7520", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SP2C_PE",PRO_SP2C_PE, CAR_TYPE_ICV,  "94023Q7700", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SP2C_PE",PRO_SP2C_PE, CAR_TYPE_ICV,  "94023Q7710", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SP2C_PE",PRO_SP2C_PE, CAR_TYPE_ICV,  "94023Q7720", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SP2C_PE",PRO_SP2C_PE, CAR_TYPE_ICV,  "94023Q7900", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SP2C_PE",PRO_SP2C_PE, CAR_TYPE_ICV,  "94023Q7910", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SP2C_PE",PRO_SP2C_PE, CAR_TYPE_ICV,  "94023Q7920", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
#endif
#if (PRO_JAPE2)																	   
{"JAPE2",PRO_JAPE2, CAR_TYPE_ICV,      "94053G6000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //JAPE2
{"JAPE2",PRO_JAPE2, CAR_TYPE_ICV,      "94053G6010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //JAPE2
#endif
#if (PRO_NU2)																	   
{"NU2 STD",PRO_NU2, CAR_TYPE_ICV,       "94003MA000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},//NU2_LOW_CFG
{"NU2 SVC",PRO_NU2, CAR_TYPE_ICV,       "94013MA000", &g_AutoConfig, SVC_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},//NU2_HIGH_CFG															   
{"NU2 SVC",PRO_NU2, CAR_TYPE_ICV,       "94013MA010", &g_AutoConfig, SVC_CFG, BVM_YES, SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, 
#endif
#if (PRO_AC3_PE)																	   
{"AC3_PE",   PRO_AC3_PE, CAR_TYPE_ICV,  "94013K7000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //AC3
{"AC3_PE",   PRO_AC3_PE, CAR_TYPE_ICV,  "94013K7010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"AC3_PE",   PRO_AC3_PE, CAR_TYPE_ICV,  "94013K7020", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"AC3_PE",   PRO_AC3_PE, CAR_TYPE_ICV,  "94013K7030", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"AC3_PE",   PRO_AC3_PE, CAR_TYPE_ICV,  "94013K7040", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"AC3_PE",   PRO_AC3_PE, CAR_TYPE_ICV,  "94013K7050", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"AC3_PE",   PRO_AC3_PE, CAR_TYPE_ICV,  "94013K7060", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
#endif
#if (PRO_YB_PE)																	   
{"YB_PE25MY",   PRO_YB_PE, CAR_TYPE_ICV, "94053H8000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //YB_PE_25MY
{"YB_PE25MY",   PRO_YB_PE, CAR_TYPE_ICV, "94053H8010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
#endif
#if (PRO_AI3)																	   
{"AI3_SUV",     PRO_AI3,   CAR_TYPE_ICV, "94013K6800", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //AI3
{"AI3_SUV", 	PRO_AI3,   CAR_TYPE_CNG, "94013K6810", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
#endif
#if (PRO_TAM)																	   
{"TAM_PE2",     PRO_TAM,   CAR_TYPE_ICV, "94053A3000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //TAM_PE2
{"TAM_PE2",     PRO_TAM,   CAR_TYPE_ICV, "94053A3001", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //TAM_PE2
{"TAM_25MY",    PRO_TAM,   CAR_TYPE_ICV, "94053A3010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //TAM_PE2
#endif
#if (PRO_CN7)																	   
{"CN7_ICV",         PRO_CN7,   CAR_TYPE_ICV, "94073AA000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7
{"CN7_ICV",         PRO_CN7,   CAR_TYPE_ICV, "94073AA010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7
{"CN7_HEV",         PRO_CN7,   CAR_TYPE_HEV, "94073BY000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7
{"CN7_HEV",         PRO_CN7,   CAR_TYPE_HEV, "94073BY010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //CN7
#endif
#if (PRO_BN7I)																	   
{"BN7I",     PRO_BN7I,   CAR_TYPE_ICV, "94013AY000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BN7I
{"BN7I",     PRO_BN7I,   CAR_TYPE_ICV, "94013AY020", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"BN7I",     PRO_BN7I,   CAR_TYPE_ICV, "94013AY010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BN7I
#endif
#if (PRO_SP2)																	   
{"SP2I_PE",  PRO_SP2,   CAR_TYPE_ICV, "94003Q6700", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //SP2I_PE
{"SP2I_PE",  PRO_SP2,   CAR_TYPE_ICV, "94003Q6710", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //SP2I_PE
{"SP2I_PE",  PRO_SP2,   CAR_TYPE_ICV, "94003Q6730", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //SP2I_PE
{"SP2I_PE",  PRO_SP2,   CAR_TYPE_ICV, "94003Q6740", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //SP2I_PE
{"SP2I_PE",  PRO_SP2,   CAR_TYPE_ICV, "94003Q6800", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //SP2I_PE
{"SP2I_PE",  PRO_SP2,   CAR_TYPE_ICV, "94003Q6810", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //SP2I_PE
{"SP2I_PE",  PRO_SP2,   CAR_TYPE_ICV, "94003Q6820", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //SP2I_PE
{"SP2I_PE",  PRO_SP2,   CAR_TYPE_ICV, "94003Q6830", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //SP2I_PE
{"SP2",      PRO_SP2,   CAR_TYPE_ICV, "94033Q5700", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //SP2
{"SP2",      PRO_SP2,   CAR_TYPE_ICV, "94033Q5510", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //SP2
{"SP2",      PRO_SP2,   CAR_TYPE_ICV, "94033Q5600", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //SP2
{"SP2",      PRO_SP2,   CAR_TYPE_ICV, "94033Q5500", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //SP2
{"SP2",      PRO_SP2,   CAR_TYPE_ICV, "94033Q5710", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //SP2
#endif 
#if (PRO_SU2ID)																	   
{"SU2ID",  PRO_SU2ID,   CAR_TYPE_ICV, "94003I7000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //SU2ID
{"SU2ID",  PRO_SU2ID,   CAR_TYPE_ICV, "94003I7020", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //SU2ID
#endif
#if (PRO_QYC)																	   
{"QYC_SVC",  PRO_QYC,   CAR_TYPE_ICV, "94013IX000", &g_AutoConfig, SVC_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //QYC
{"QYC_SVC",  PRO_QYC,   CAR_TYPE_ICV, "94013IX100", &g_AutoConfig, SVC_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"QYC_SVC",  PRO_QYC,   CAR_TYPE_ICV, "94013IX200", &g_AutoConfig, SVC_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //QYC
{"QYC_SVC",  PRO_QYC,   CAR_TYPE_ICV, "94013IX300", &g_AutoConfig, SVC_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"QYC_STD",  PRO_QYC,   CAR_TYPE_ICV, "94003IX000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //QYC
{"QYC_STD",  PRO_QYC,   CAR_TYPE_ICV, "94003IX100", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"QYC_STD",  PRO_QYC,   CAR_TYPE_ICV, "94003IX200", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //QYC
{"QYC_STD",  PRO_QYC,   CAR_TYPE_ICV, "94003IX300", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
#endif
#if (PRO_NX4C)																	   
{"NX4C_ICV",      PRO_NX4C, CAR_TYPE_ICV,  "94003N8000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //NX4C
{"NX4C_ICV",      PRO_NX4C, CAR_TYPE_ICV,  "94023N8000", &g_AutoConfig, SVC_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"NX4C_HEV",      PRO_NX4C, CAR_TYPE_HEV,  "94003CF000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"NX4C_HEV",      PRO_NX4C, CAR_TYPE_HEV,  "94013CF000", &g_AutoConfig, SVC_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
#endif
#if (PRO_BC3)																	   
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0020", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0030", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0040", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0050", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0060", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0070", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0080", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0090", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0100", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0110", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0120", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0130", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0140", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0150", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0160", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0170", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0180", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0190", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0200", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0210", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0220", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0230", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0240", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0250", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0260", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0270", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0280", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0290", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0300", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0310", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
{"BC3",            PRO_BC3, CAR_TYPE_ICV,  "94053Q0320", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //BC3
#endif
#if (PRO_BDC_PE)																	   
{"BDC_PE_STD",  PRO_BDC_PE, CAR_TYPE_ICV,  "94023Q8000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //NX4C
{"BDC_PE_STD",  PRO_BDC_PE, CAR_TYPE_ICV,  "94023Q8020", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"BDC_PE_SVC",  PRO_BDC_PE, CAR_TYPE_ICV,  "94033Q8000", &g_AutoConfig, SVC_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"BDC_PE_SVC",  PRO_BDC_PE, CAR_TYPE_ICV,  "94033Q8020", &g_AutoConfig, SVC_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
#endif
#if (PRO_SU2BFL)																	   
{"SU2BFL",  PRO_SU2BFL, CAR_TYPE_ICV,  "94023BX000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //SU2BFL
#endif
#if (PRO_DL3C)				
{"DL3C_STD",  PRO_DL3C, CAR_TYPE_ICV,  "94023L6000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //NX4C
{"DL3C_STD",  PRO_DL3C, CAR_TYPE_ICV,  "94023L6010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"DL3C_SVC",  PRO_DL3C, CAR_TYPE_ICV,  "94033L6000", &g_AutoConfig, SVC_CFG, BVM_YES,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"DL3C_SVC",  PRO_DL3C, CAR_TYPE_ICV,  "94033L6010", &g_AutoConfig, SVC_CFG, BVM_YES,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"DL3C_SVC",  PRO_DL3C, CAR_TYPE_ICV,  "94033L6020", &g_AutoConfig, SVC_CFG, BVM_YES,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"DL3C_SVC",  PRO_DL3C, CAR_TYPE_ICV,  "94033L6030", &g_AutoConfig, SVC_CFG, BVM_YES,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"DL3C_STD",  PRO_DL3C, CAR_TYPE_ICV,  "94043L6000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //NX4C
{"DL3C_STD",  PRO_DL3C, CAR_TYPE_ICV,  "94043L6010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"DL3C_SVC",  PRO_DL3C, CAR_TYPE_ICV,  "94053L6000", &g_AutoConfig, SVC_CFG, BVM_YES,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"DL3C_SVC",  PRO_DL3C, CAR_TYPE_ICV,  "94053L6010", &g_AutoConfig, SVC_CFG, BVM_YES,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"DL3C_SVC",  PRO_DL3C, CAR_TYPE_ICV,  "94053L6020", &g_AutoConfig, SVC_CFG, BVM_YES,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"DL3C_SVC",  PRO_DL3C, CAR_TYPE_ICV,  "94053L6030", &g_AutoConfig, SVC_CFG, BVM_YES,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
#endif
#if (PRO_SU2ID_FL)				
{"SUID_FL",  PRO_SU2ID_FL, CAR_TYPE_ICV,  "94023I7000", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3}, //NX4C
{"SUID_FL",  PRO_SU2ID_FL, CAR_TYPE_ICV,  "94023I7010", &g_AutoConfig, STD_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SUID_FL",  PRO_SU2ID_FL, CAR_TYPE_ICV,  "94023I7020", &g_AutoConfig, SVC_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
{"SUID_FL",  PRO_SU2ID_FL, CAR_TYPE_ICV,  "94023I7030", &g_AutoConfig, SVC_CFG, BVM_NO,  SPORT_PLUS_NO,  RESERVE2,  RESERVE3},
#endif
};
unsigned char g_VehicleType = CAR_TYPE_ICV;
static unsigned char g_BvmSupport = BVM_NO; 
static unsigned char g_HaveSportPlus = SPORT_PLUS_NO; 
static unsigned char g_HaveDBC       = DBC_NO; 
static unsigned char g_HaveFcaRed    = FCA_RED_NO; 
static unsigned char g_HaveHBA_WHITE    = HBA_WHITE_NO; 
static unsigned char g_CarCfg       = STD_CFG; 
static unsigned int  g_PartNumIndex       = 0; 

void BackLightNum(void){
#if (PRO_SP2)
    if (JudgePartNum() == PartNum_SP2){
        g_BackLightNum = 0;
    }else if (JudgePartNum() == PartNum_SP2I){
        g_BackLightNum = 1;
    }
#endif
#if (PRO_DL3C)
    if (GetCluType() == SVC_CFG){
        g_BackLightNum = 0;
    }else if (GetCluType() == STD_CFG){
        g_BackLightNum = 1;
    }
#endif
}
void CheckAuto(void){
#if (PRO_KS)
    if (JudgePartNum() == PartNum_KS) {
        g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
        g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
        g_AutoConfig.AUTO_STEP6_APPLY = AUTO_CAN_GND_0;
        g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
    } else if (JudgePartNum() == PartNum_KS_23MY){
        g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
        g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
        g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
    }
#elif (PRO_QXI)
    g_AutoConfig.AUTO_STEP6_APPLY = AUTO_CAN_GND_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
#elif (PRO_LX2)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP5_APPLY = AUTO_CAN_PRNDS_0;
#elif (PRO_SK3_PE)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
#elif (PRO_NQ5)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
#elif (PRO_SG2)
    g_AutoConfig.AUTO_STEP2_APPLY = AUTO_CAN_SW1_0;
    g_AutoConfig.AUTO_STEP3_APPLY = AUTO_CAN_SW2_0;
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_PRNDS_0;
#elif (PRO_TAM)
    g_AutoConfig.AUTO_STEP3_APPLY = AUTO_CAN_SW2_0;
    g_AutoConfig.AUTO_STEP5_APPLY = AUTO_CAN_PRNDS_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
    g_AutoConfig.AUTO_STEP9_APPLY = AUTO_CAN_DMS_0;
#elif (PRO_AX)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP5_APPLY = AUTO_CAN_PRNDS_0;
    g_AutoConfig.AUTO_STEP6_APPLY = AUTO_CAN_GND_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
#elif (PRO_KY)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP6_APPLY = AUTO_CAN_GND_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
#elif (PRO_US4)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    //g_AutoConfig.AUTO_STEP6_APPLY = AUTO_CAN_GND_0;//
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
#elif (PRO_BR2)
    g_AutoConfig.AUTO_STEP3_APPLY = AUTO_CAN_SW2_0;
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
    g_AutoConfig.AUTO_STEP9_APPLY = AUTO_CAN_DMS_0;
#elif (PRO_SP2)
    if (JudgePartNum() == PartNum_SP2){
        g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    } else if (JudgePartNum() == PartNum_SP2I){
        g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
        g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
        g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
    }
#elif (PRO_ONPE)

#elif (PRO_GL3)
    g_AutoConfig.AUTO_STEP2_APPLY = AUTO_CAN_SW1_0;
    g_AutoConfig.AUTO_STEP3_APPLY = AUTO_CAN_SW2_0;
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP5_APPLY = AUTO_CAN_PRNDS_0;
    g_AutoConfig.AUTO_STEP6_APPLY = AUTO_CAN_GND_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
#elif (PRO_QX23)
#if (PRO_CONFIG_CHECK_APPLY_TYPE2)
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP9_APPLY = AUTO_CAN_DMS_0;
#endif
#elif (PRO_NUPE)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP5_APPLY = AUTO_CAN_PRNDS_0;
    g_AutoConfig.AUTO_STEP6_APPLY = AUTO_CAN_GND_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
#elif (PRO_KU)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP5_APPLY = AUTO_CAN_PRNDS_0;
    g_AutoConfig.AUTO_STEP6_APPLY = AUTO_CAN_GND_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
#elif (PRO_NQ5C)
    if (JudgePartNum() == PartNum_NQ5C){
        g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
        g_AutoConfig.AUTO_STEP5_APPLY = AUTO_CAN_PRNDS_0;
        g_AutoConfig.AUTO_STEP6_APPLY = AUTO_CAN_GND_0;
        g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
        g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
    } else if (JudgePartNum() == PartNum_NQ5C_Outlet){
        g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
        g_AutoConfig.AUTO_STEP5_APPLY = AUTO_CAN_PRNDS_0;
        g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
        g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
    }
#elif (PRO_BL7M)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
#elif (PRO_CN7C)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP5_APPLY = AUTO_CAN_PRNDS_0;
    g_AutoConfig.AUTO_STEP6_APPLY = AUTO_CAN_GND_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
#elif (PRO_SQFL)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP5_APPLY = AUTO_CAN_PRNDS_0;
    g_AutoConfig.AUTO_STEP6_APPLY = AUTO_CAN_GND_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
#elif (PRO_PDEPE2)

#elif (PRO_BN7R)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
#elif (PRO_BL7R)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
#elif (PRO_SU2IFL)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
#elif (PRO_SP2C_PE)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP5_APPLY = AUTO_CAN_PRNDS_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
#elif (PRO_JAPE2)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
    g_AutoConfig.AUTO_STEP9_APPLY = AUTO_CAN_DMS_0;
#elif (PRO_NU2)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP5_APPLY = AUTO_CAN_PRNDS_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
#elif (PRO_AC3_PE)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
    g_AutoConfig.AUTO_STEP9_APPLY = AUTO_CAN_DMS_0;
#elif (PRO_YB_PE)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
#elif (PRO_AI3)
    g_AutoConfig.AUTO_STEP3_APPLY = AUTO_CAN_SW2_0;
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
#elif (PRO_CN7)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
#elif (PRO_BN7I)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
#elif (PRO_SU2ID)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
    g_AutoConfig.AUTO_STEP9_APPLY = AUTO_CAN_DMS_0;
#elif (PRO_QYC)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
#elif (PRO_NX4C)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP5_APPLY = AUTO_CAN_PRNDS_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
#elif (PRO_BC3)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
#elif (PRO_BDC_PE)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP5_APPLY = AUTO_CAN_PRNDS_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
#elif (PRO_SU2BFL)
    g_AutoConfig.AUTO_STEP4_APPLY = AUTO_CAN_Engine_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
#elif (PRO_DL3C)
    g_AutoConfig.AUTO_STEP5_APPLY = AUTO_CAN_PRNDS_0;
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
#elif (PRO_SU2ID_FL)
    g_AutoConfig.AUTO_STEP7_APPLY = AUTO_CAN_Rheo_0;
    g_AutoConfig.AUTO_STEP8_APPLY = AUTO_CAN_Detent_0;
#endif
}
unsigned char CheckPartNumber(unsigned char *pPartNum)
{
    unsigned char ucRet = 0;
    for(unsigned int i = 0; i < sizeof(g_VehicleConfig)/sizeof(g_VehicleConfig[0]); i++) {
            if(g_VehicleConfig[i].ucProName ==0) {
                continue;
            } else if(g_VehicleConfig[i].ucProName ==1) {
                if(memcmp(pPartNum,g_VehicleConfig[i].ucPartNumber,10) == 0) {
                    ucRet = 1;
                    g_BvmSupport = g_VehicleConfig[i].ucBvmSupport;
                    g_HaveSportPlus  = g_VehicleConfig[i].ucHaveSportPlus;
                    g_HaveDBC        = g_VehicleConfig[i].ucRESERVE2;
                    g_HaveFcaRed        = g_VehicleConfig[i].ucRESERVE2;
                    g_HaveHBA_WHITE     = g_VehicleConfig[i].ucReserve3;
                    //g_Have        = g_VehicleConfig[i].ucRESERVE2;
                    g_CarCfg         = g_VehicleConfig[i].ucCluType;
                    g_PartNumIndex         = i;
                    CheckAuto();
                    //BackLight();
                    BackLightNum();
                    break;
               }
            } else {
                //reserve
            }
    }
    return ucRet;
}

unsigned char GetVehicleType(unsigned char *pPartNum)
{
    unsigned char ucRet = CAR_TYPE_ICV;
    for(unsigned int i = 0; i < sizeof(g_VehicleConfig)/sizeof(g_VehicleConfig[0]); i++)
    {
        if(g_VehicleConfig[i].ucProName ==0) {
            continue;
        } else if(g_VehicleConfig[i].ucProName ==1) {
            if(memcmp(pPartNum,g_VehicleConfig[i].ucPartNumber,10) == 0) {
                ucRet = g_VehicleConfig[i].ucVehicleType;
                break;
            }
        } else {
            //reserve
        }
    }
    return ucRet;
}

unsigned char *GetProjectName(unsigned char *pPartNum)
{
    unsigned char ucRet = CAR_TYPE_ICV;
    unsigned int uiIdx = 0;
    for(uiIdx = 0; uiIdx < sizeof(g_VehicleConfig)/sizeof(g_VehicleConfig[0]); uiIdx++)
    {
       if(memcmp(pPartNum,g_VehicleConfig[uiIdx].ucPartNumber,10) == 0) {
                break;
       }
    }
    return g_VehicleConfig[uiIdx].szProName;
}


unsigned char IsSupportBVM(void)
{
    return g_BvmSupport;
}

unsigned char IsHaveSportPlus(void)
{
    return g_HaveSportPlus;
}

unsigned char IsHaveDBC(void)
{
    return g_HaveDBC;
}

unsigned char IsHaveFcaRed(void)
{
    return g_HaveFcaRed;
}

unsigned char IsHaveHBA_WHITE(void)
{
    return g_HaveHBA_WHITE;
}

unsigned char IsHaveMph(void)
{
#if (PRO_KS)
    if (g_PartNumIndex == 4 || g_PartNumIndex == 6){
        1;
    }else{
        0;
    }
#endif
}

unsigned char GetCluType(void)
{
    return g_CarCfg;
}

unsigned char JudgePartNum(void)
{
#if (PRO_SG2)
    if (g_PartNumIndex >= 16){
        return PartNum_SG2_24MY;
    }else{
        return PartNum_SG2;
    }
#endif
#if (PRO_NQ5)
    if (g_PartNumIndex >= 31){
        return PartNum_NQ5_24MY;
    }else{
        return PartNum_NQ5;
    }
#endif
#if (PRO_KY)
    if (g_PartNumIndex >= 6){
        return PartNum_KY_23MY;
    }else{
        return PartNum_KY;
    }
#endif
#if (PRO_KS)
    if (g_PartNumIndex >= 2){
        return PartNum_KS_23MY;
    }else{
        return PartNum_KS;
    }
#endif
#if (PRO_AX)
    if (g_PartNumIndex >= 1){
        return PartNum_AX_PE;
    }else{
        return PartNum_AX;
    }
#endif
#if (PRO_NQ5C)
    if (g_PartNumIndex >= 9){
        return PartNum_NQ5C_Outlet;
    }else{
        return PartNum_NQ5C;
    }
#endif
#if (PRO_SP2)
    if (g_PartNumIndex >= 8){
        return PartNum_SP2;
    }else{
        return PartNum_SP2I;
    }
#endif
}

