#ifndef API_CAN_H_
#define API_CAN_H_

#ifdef    GLOBALS_VARIABLE
    #define   EXTERN_VAR

#else
    #define   EXTERN_VAR     extern

#endif

typedef             char            INT8;
typedef             short  	    INT16;
typedef             unsigned char   INT8U;



typedef struct {
    uint8_t ModuleFCA;
    uint8_t ModuleFCARecvCnt;
    uint8_t ModuleDAW;
    uint8_t ModuleDAWRecvCnt;
    uint8_t ModuleAVN_AV;
    uint8_t ModuleAVN_TBT;
    uint8_t ModuleAVN_Language;
    uint8_t ModuleBCW;
    uint8_t ModuleBCWRecvCnt;
    uint8_t ModuleHBA;
    uint8_t ModuleHBARecvCnt;
    uint8_t ModuleISLW;
    uint8_t ModuleISLWRecvCnt;
    uint8_t ModuleTPMS;
    uint8_t ModuleTPMSRecvCnt;
    uint8_t ModuleDCT;
    uint8_t ModuleDCTRecvCnt;
    uint8_t ModuleSBW;
    uint8_t ModuleSBWRecvCnt;
    uint8_t ModuleSMART;
    uint8_t ModuleSMARTRecvCnt;
    uint8_t ModuleBLE;
    uint8_t ModuleBLERecvCnt;
}SOFTWARE_VARIANT_CODING_STRUCT;
extern SOFTWARE_VARIANT_CODING_STRUCT SoftwareVariantCoding;  

extern uint8_t UDSSend;
extern uint8_t UDSSend_check;
extern void SetCan0Mode(uint8_t n);
extern void SetCan1Mode(uint8_t n);
extern void CANInit(void);
extern void Send0x553(void);

//#pragma pack(1)
//SMKmsg20  ID:0x113  200ms
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                     :   3 ;
            unsigned int C_HfreeTrunkTgRValue:   3 ;
            unsigned int                     :   8 ;
            unsigned int C_WALRValue         :   2 ;
            
        }bits;
    }msg;
    
}SMKmsg20_;

    
//SMKmsg19  ID:0x112  200
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
            
            unsigned int    C_AccINDforCLU                          : 1 ;
            unsigned int                                            : 2 ;
            unsigned int    C_DrvToggleButton                       : 1 ;
            unsigned int    C_BrakeSW                               : 1 ;
            unsigned int                                            : 1 ;
            unsigned int    C_AccSMK                                : 1 ;
            unsigned int    C_AccRelayStatus                        : 1 ;
            
               
            
            unsigned int                                            : 2 ;
            unsigned int    C_EsclLowBat                            : 2 ;
            unsigned int    C_EsclEnableStatus                      : 1 ;
            unsigned int    C_EsclBoltStatus                        : 3 ;
            
            
            
            
            unsigned int    C_LFSearchingOn                         : 1 ;
            unsigned int    C_EsclUnitStatus                        : 3 ;
            unsigned int    C_EsclManagerState                      : 4 ;
            
            unsigned int    C_PpositionClutch                       : 1 ;
            unsigned int    C_Ign2SMK                               : 1 ;
            unsigned int    C_Ign2RelayState                        : 1 ;
            unsigned int    C_Ign1SMK                               : 1 ;
            unsigned int    C_Ign1RelayState                        : 1 ;
            unsigned int    C_EsclPowerSupplystatus                 : 1 ;
            unsigned int    C_EsclUnlock                            : 2 ;
            
            
            
            unsigned int                                            : 1 ;
            unsigned int    C_TerminalControlState                  : 4 ;
            unsigned int    C_StartFeedback                         : 1 ;
            unsigned int    C_SSBSW2                                : 1 ;
            unsigned int    C_SSBSW1                                : 1 ;
            
            
            unsigned int                                            : 3 ;
            unsigned int    C_TerminalsManagerState                 : 5 ;
            unsigned int                                            : 16 ;
        }bits;
    }msg;
    
}SMKmsg19_;

//SMKmsg18  ID:0x111  200
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           
             
//            unsigned int                              : 1 ;
//            unsigned int  C_StarterRlyState           : 1 ;
//            unsigned int  C_SMKTeleEngineRunning      : 1 ;
//            unsigned int  C_SMKTeleCrankingState      : 1 ;
//            unsigned int  C_SMKDiagState              : 1 ;
//            unsigned int                              : 1 ;
//            unsigned int  C_AuthState                 : 2 ;
            unsigned int                              : 8 ;  
            unsigned int                              : 8 ;
            unsigned int                              : 8 ;
            unsigned int                              : 8 ;
            
            unsigned int                              : 2 ;
            unsigned int   ISG_Power                  : 1 ;
            unsigned int                              : 1 ;
            unsigned int   ISG_Power_Enable           : 2 ;
            unsigned int                              : 2 ;
            //unsigned int                              : 8 ;
            unsigned int                              : 8 ;
            unsigned int                              : 8 ;
            unsigned int                              : 8 ;
            
        }bits;
    }msg;
    
}ISG_111_;

//SMKmsg17  ID:0x110  200
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           
            unsigned int C_KeyBATDischargeWarn :   1 ;
            unsigned int                     :   1 ;
            unsigned int C_ImmoLp            :   1 ;
            unsigned int C_IDoutWarn         :   1 ;
            unsigned int C_ESCLNotUnlockWarn :   1 ;
            unsigned int C_ESCLNotLockedWarn :   1 ;
            unsigned int C_ESCLFailWarn      :   1 ;
            unsigned int C_DeactivationWarn  :   1 ;
            
            unsigned int C_SMKExtBuzWarn     :   3 ;
            unsigned int                     :   4 ;
            unsigned int C_KeyoutLp          :   1 ;
            
            unsigned int                     :  2 ;
            unsigned int C_VehicleNotPWarn   :   1 ;
            unsigned int C_SSBWarn           :   1 ;
            unsigned int C_SMKDispWarn       :   4 ;
            
            unsigned int                     :  16 ;
            unsigned int                     :  16 ;
            unsigned int                     :  6 ;
            unsigned int C_HazardFromSMK     :  2 ;//???????
            
        }bits;
    }msg;
    
}SMKmsg17_;

//SMKmsg01  ID:0x10  200
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           
            unsigned int  C_PassiveAccessLock         : 2 ;
            unsigned int                              : 1 ; 
            unsigned int  C_PassiveAccessUnlock       : 2 ;
            unsigned int                              : 1 ;
            unsigned int  C_PassiveFrtDrv             : 1 ;
            unsigned int  C_PassiveFrtAst             : 1 ;
            
            
            
            unsigned int                              : 2 ;
            unsigned int  C_PassiveTrunkTg            : 1 ;
            unsigned int                              : 1 ;
            unsigned int  C_SMKFobID                  : 3 ;
            unsigned int                              : 1 ;
            

            
            
            unsigned int   C_SMKRKECmd                : 4 ;
            unsigned int                              : 4 ;
            unsigned int                              : 8 ;
            unsigned int                              : 8 ;
            unsigned int                              : 8 ;
            unsigned int                              : 8 ;
            unsigned int                              : 8 ;
            
        }bits;
    }msg;
    
}SMKmsg01_;

//BCMmsgDvp1  ID:0x602  
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           
         
            unsigned int  BCMmsgDvp1DataByte0                            : 8 ;
            unsigned int  BCMmsgDvp1DataByte1                            : 8 ;
            unsigned int  BCMmsgDvp1DataByte2                            : 8 ;
            unsigned int  BCMmsgDvp1DataByte3                            : 8 ;
            unsigned int  BCMmsgDvp1DataByte4                            : 8 ;
            unsigned int  BCMmsgDvp1DataByte5                            : 8 ;
            unsigned int  BCMmsgDvp1DataByte6                            : 8 ;
            unsigned int  BCMmsgDvp1DataByte7                            : 8 ;
            
        }bits;
    }msg;
    
}BCMmsgDvp1_;        
    

//BCMmsg24  ID:0x107  200
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           
            
            unsigned int                             : 8 ;
            unsigned int                             : 8 ;
            unsigned int                             : 8 ;
            
            unsigned int                             : 5 ;
            unsigned int  C_AutolightValue           : 1 ;
            unsigned int                             : 2 ;
            
            unsigned int                             : 8 ;
            unsigned int                             : 8 ;
            
            
            unsigned int                             : 2 ;
            unsigned int C_WiperMistSw               : 1 ;
            unsigned int C_WiperLowSw                : 1 ;
            unsigned int C_WiperHighSw               : 1 ;
            unsigned int C_WiperAutoSw               : 1 ;
            unsigned int C_LightSwState              : 2 ;
            
            
            unsigned int                             : 4 ;
            unsigned int C_RrWiperSwState            : 2 ;
            unsigned int C_WiperSwState              : 2 ;
            
            unsigned int                             : 8 ;
            
        }bits;
    }msg;
    
}BCMmsg24_; 


//BCMmsg22  ID:0x105     200
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           
            
            unsigned int                             : 8 ;
            unsigned int                             : 8 ;
            unsigned int                             : 8 ;
            unsigned int                             : 8 ;
            
            unsigned int                             : 2 ;
            unsigned int C_HBAControlMode            : 1 ;
            unsigned int                             : 5 ;
            
            unsigned int                             : 8 ;
            unsigned int                             : 8 ;
            unsigned int                             : 8 ;
            
        }bits;
    }msg;
    
}BCMmsg22_; 

//WPCmsg03  ID: 0x19B  200
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           
            
            unsigned int                     :   5 ;
	    unsigned int C_WPCWarning        :   3 ;
	    unsigned int                     :   6 ;
	    unsigned int C_WPCRValue         :   2 ;
            
        }bits;
    }msg;
    
}WPCmsg03_; 

//BCMmsg21  ID:0x104   200
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
        unsigned int                     :   2 ;
        unsigned int C_ADrURValue        :   3 ;
        unsigned int C_ADrLRValue        :   3 ;
        unsigned int C_RearWiperRValue   :   2 ;
        unsigned int                     :   3 ;
        unsigned int C_EscortHLRValue    :   3 ;
        unsigned int                     :   3 ;
        unsigned int C_OTTurnRValue      :   3 ;
            
            
        }bits;
    }msg;
    
}BCMmsg21_; 

//BCMmsg20  ID:0x103  200
typedef struct
{   

    union                                          //SMKmsgDvp1  ID:0x608
    {   
        unsigned        data[8];
        struct
        {   
           
            
        unsigned int                     :   2 ;
        unsigned int C_HfreeTrunkTgRValue     :   3 ;
        unsigned int C_AstUnlockStat          :   1 ;
        unsigned int                     :   1 ;
        unsigned int C_AstDrSw           :   1 ;
        unsigned int                     :   8 ;
        
        unsigned int                     :   3 ;
        unsigned int C_DrvUnlockState    :   1 ;
        unsigned int                     :   1 ;
        unsigned int C_DrvKeyUnlockSw    :   1 ;
        unsigned int C_DrvKeyLockSw      :   1 ;
        unsigned int C_DrvDrSw           :   1 ;
        
        unsigned int                     :   1 ;
        unsigned int C_HLpLowAct         :   1 ;
        unsigned int C_HLpHighAct        :   1 ;
        unsigned int C_HazardSw          :   1 ;
        unsigned int C_FrtFogAct         :   1 ;
        unsigned int C_ExtTailAct        :   1 ;
        unsigned int                     :   2 ;
        
        unsigned int                     :   4 ;
        unsigned int C_RearFogAct        :   1 ;
        unsigned int                     :   1 ;
        unsigned int C_IntTailAct        :   1 ;
        unsigned int                     :   1 ;
        
        unsigned int                     :   2 ;
        
        unsigned int C_RRUnlockState     :   1 ;
        unsigned int                     :   1 ;
        unsigned int C_RRDrSw            :   1 ;
        unsigned int C_RLUnlockState     :   1 ;
        unsigned int                     :   1 ;
        unsigned int C_RLDrSw            :   1 ;
        unsigned int                     :   1 ;
        unsigned int C_TSigRhSw          :   1 ;
        unsigned int C_TSigLhSw          :   1 ;
        unsigned int C_TrunkTgSw         :   1 ;
        unsigned int C_TrunkTgOtrReleaseSW         :   1 ;
        unsigned int                     :   1 ;
        unsigned int C_StaticBendRhAct   :   1 ;
        unsigned int C_StaticBendLhAct   :   1 ;
        unsigned int                     :   4 ;
        unsigned int C_SunRoofOpenState  :   1 ;
        unsigned int                     :   1 ;
        unsigned int C_TSigRhAct         :   1 ;
        unsigned int C_TSigLhAct          :   1 ;
            
            
        }bits;
    }msg;
    
}BCMmsg20_; 


//BCMmsg19  ID:0x102   200
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           
            
        unsigned int                     :  8 ;
        unsigned int                     :  4 ;
        unsigned int C_FrtFogOn          :   1 ;
        unsigned int                     :   1 ;
        unsigned int C_ExtTailOn         :   1 ;
        unsigned int                     :   2 ;
        unsigned int C_IntTailOn         :   1 ;
        unsigned int C_HLpLowOn          :   1 ;
        unsigned int C_HLpHighOn         :   1 ;
        unsigned int                     :   5 ;
        unsigned int C_StaticBendRhOn    :   1 ;
        unsigned int C_StaticBendLhOn    :   1 ; 
        unsigned int                     :   2 ;
        unsigned int C_RearFogOn         :   1 ;
        unsigned int                     :   4 ;
        unsigned int C_DedicatedDRLOn    :   1 ;
        unsigned int C_PassingLpOn       :   1 ;
        unsigned int                     :   2 ;
        unsigned int C_TSigRHOn          :   1 ;
        unsigned int C_TSigLHOn          :   1 ;
            
            
        }bits;
    }msg;
    
}BCMmsg19_;


//BCMmsg18  ID:0x101  200 old
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
       
        unsigned int                     :   3 ;
        unsigned int C_BCMDiagState      :   1 ;
        unsigned int C_AvTail            :   1 ;
        unsigned int C_AutoLightSwOn     :   1 ;
        unsigned int                     :   2 ;
        
        
        unsigned int C_PASOption         :   2 ;
        unsigned int                     :   3 ;
        unsigned int C_PASCheckSound     :   3 ;
        
        unsigned int                     :   8 ;
       unsigned int                      :   2 ;        
        unsigned int C_PASDisplayRLH     :   3 ;
        unsigned int C_PASDisplayRCTR    :   3 ;
        
        unsigned int                     :   5 ;
        unsigned int C_PASDisplayRRH     :   3 ;
        
        unsigned int                     :   2 ;
        unsigned int C_PASSystemOn       :   3 ;
        unsigned int C_PASRsound         :   3 ;
        
        unsigned int                     :   8 ;
        
        unsigned int C_PASDistance       :   1 ;
        unsigned int C_WngBuz            :   3 ;
        unsigned int C_WiperIntT         :   3 ;
        unsigned int C_WiperIntSw        :   1 ;
            
        }bits;
    }msg;
    
}BCMmsg18_;


//BCMmsg17  ID:0x100    200
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            unsigned int                     :   2 ;
	    unsigned int C_BAlarmState       :   4 ;
	    unsigned int                     :   1 ;
	    unsigned int C_Acc               :   1 ;
            unsigned int                     :   6 ;
            unsigned int C_BodyTypeOption    :   2 ;
            unsigned int                     :  11 ;
            unsigned int C_IGNSw             :   3 ;
            unsigned int C_Ign2              :   1 ;
            unsigned int C_Ign1              :   1 ;
            unsigned int C_AutoLightOption   :   1 ;
            unsigned int                     :  10 ;
            unsigned int C_ParkBrakeSw       :   1 ;
            unsigned int                     :   7 ;
            unsigned int C_PanicState        :   1 ;
            unsigned int                     :   3 ;
            unsigned int C_SMKOption         :   1 ;
            
            
        }bits;
    }msg;
    
}BCMmsg17_;


//BCMmsg01  ID:0x0   200
typedef struct
{   
    union
    {   
        unsigned        data[8];
        struct
        {   
           
            

            unsigned int                     :   3 ;
	    unsigned int C_RKECmd            :   3 ;
            
            
        }bits;
    }msg;
    
}BCMmsg01_;

//BCMGst  ID:0x720  200
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           
            

            unsigned int BCMGstByte0Tpci     :   8 ;
	    unsigned int BCMGstByte1Data     :   8 ;
	    unsigned int BCMGstByte2Data     :   8 ;
	    unsigned int BCMGstByte3Data     :   8 ;
	    unsigned int BCMGstByte4Data     :   8 ;
	    unsigned int BCMGstByte5Data     :   8 ;
	    unsigned int BCMGstByte6Data     :   8 ;
            unsigned int BCMGstByte7Data     :   8 ;

            
        }bits;
    }msg;
    
}BCMGst_;

//FCA12  ID:0x483   200
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
          uint32_t FCA_USM          :  3 ;
          uint32_t FCA_DrvSetState  :  3 ;
          uint32_t                  :  2 ;
          uint32_t FCA_WarningTargetDisplay : 5 ;
          uint32_t                  :  3 ;
          uint32_t                  : 16 ;
          uint32_t                  : 32 ;
        }bits;
    }msg;
    
}FCA12_;


//TPMS11  ID:0x593  200
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int  TPMS_W_LAMP                        : 2 ;
            unsigned int  TREAD_W_LAMP                      : 2 ;
            unsigned int  POS_FL_W_LAMP                     : 1 ;
            unsigned int  POS_FR_W_LAMP                     : 1 ;
            unsigned int  POS_RL_W_LAMP                     : 1 ;  
            unsigned int  POS_RR_W_LAMP                     : 1 ;  //8
 
            unsigned int  STATUS_TPMS                             : 3 ; //11
            unsigned int  UNIT                                                : 2 ;//13
            unsigned int                                                            : 3 ;//16  
      
            unsigned int   PRESSURE_FL                             : 8 ; //24
            unsigned int   PRESSURE_FR                             : 8 ; //32
            unsigned int   PRESSURE_RL                             : 8 ;//40 
            unsigned int   PRESSURE_RR                             : 8 ;//48
            
            unsigned int                                                            : 8 ;
            unsigned int                                                            : 8 ; 
        }bits;
    }msg;
    
}TPMS11_;

//TCU14  ID:0x502   100
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           
            

            unsigned int                                  : 5 ;
            unsigned int  CF_Tcu_GSel_BlinkReq            : 1 ;
            unsigned int                                  : 2 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
        }bits;
    }msg;
    
}TCU14_;

//0x410
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           
            
            unsigned int                                  : 4 ;
            unsigned int      CF_Gway_EscortHLRValue      : 2 ;//6
            unsigned int                                  : 2 ;//8
            
            
            unsigned int CF_Gway_ADrLRValue               : 3 ;//11
            unsigned int    CF_Gway_ADrURValue            : 3 ; //14
            unsigned int                                  : 2 ; //16
            
            
            unsigned int                                  : 5 ; //21
            unsigned int    CF_Gway_OTTurnRValue          : 3 ;  //24
            
            unsigned int                                  : 3 ; //27
            unsigned int   CF_Gway_HAnBRValue             : 3 ; //30
            unsigned int                                  : 2 ; //32
            
            
            unsigned int                                  : 3 ; //35
            unsigned int     CF_Gway_MoodLpRValue         : 3 ; //38
            unsigned int     CF_Gway_RearWiperRValue      : 2 ;  //40
            
            
            unsigned int       CF_Gway_PasSpkrLvRValue    : 3 ;     //43
            unsigned int                                  : 5 ;    //48
            
            
            unsigned int                                  : 8 ;      //56
            
             unsigned int                                  : 4 ;    //60
             unsigned int         CF_Gway_WPCRValue        : 2 ;     //62
            unsigned int                                   : 2 ;     //  64
          
            
        }bits;
    }msg;
    
}TCUA3_;

//TCU13  ID:0x113   10
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {                      
            unsigned int ISG_BATT_Voltage_H               : 8 ;
            unsigned int ISG_BATT_Voltage_L               : 8 ;
            unsigned int Tbatt                            : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int ISTOP_display                    : 1 ;
            unsigned int                                  : 1 ;
            unsigned int LIGHT_0N                         : 1 ;
            unsigned int                                  : 5 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
        }bits;
    }msg;
    
}TCU13_;

//TCU11  ID:0x111   10
typedef struct
{   
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                                  : 8 ;
            
            unsigned int G_SEL_DISP                       : 4 ;
            unsigned int                                  : 2 ;
            unsigned int TCU_TYPE                         : 2 ;
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int ISG_Batt                         : 1 ;
            unsigned int ISG_Ready                        : 1 ;
            unsigned int ISG_Power                        : 1 ;
            unsigned int ISG_SideStand                    : 1 ;
            unsigned int ISG_Power_Enable                 : 2 ;
            unsigned int                                  : 2 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int SWI_CC                           : 8 ;
        }bits;
    }msg;
}TCU11_;


//SAS11  ID:0x2b0   10
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           
            

            unsigned int  SAS_Angle                       : 16 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
        }bits;
    }msg;
    
}SAS11_;


//MDPS11  ID:0x381   20
typedef struct
{   
                                                             
    union
    {   
        unsigned        data[8];
        struct
        {   
           
            

            unsigned int  CF_Mdps_WLmp                    : 2 ;
            unsigned int                                  : 6 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
        }bits;
    }msg;
    
}MDPS11_;

//LKA12  ID:0x53e   100
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   

            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;//32
            
            unsigned int  CF_LeadVehDptAlert_Display      : 2 ; //34
            unsigned int  CF_LeadVehDptAlert_USM          : 2 ; //36
            unsigned int  CF_DAW_TimeReset                 : 1 ;
            unsigned int                                   : 3 ;    //40
            
            unsigned int CF_DAW_Status                    : 4 ;
            unsigned int CF_DAW_Warn                      : 2 ;
            unsigned int CF_DAW_Opt_USM_NEW               : 2 ;   //48
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
            
        }bits;
    }msg;
    
}LKA12_;

//LKA11  ID:0x340    10
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
          uint32_t CF_LKA_LaneRecogState :  2 ;
          uint32_t                       :  4 ;
          uint32_t CF_LKA_SysWarning     :  4 ;
          uint32_t CF_LKA_LHWarning      :  2 ;
          uint32_t CF_LKA_RHWarning      :  2 ;
          uint32_t CF_HBA_Lamp           :  1 ;
          uint32_t CF_LKA_HandsOff_Snd   :  1 ;
          uint32_t                       : 13 ;
          uint32_t CF_HBA_SysState       :  3 ;
          uint32_t CF_HBA_Opt_USM        :  2 ;
          uint32_t CF_HBA_Opt            :  1 ;
          uint32_t                       :  5 ;
          uint32_t CF_LKA_USM_Mode       :  2 ;
          uint32_t                       : 14 ;
          uint32_t CF_LKA_SymbolState    :  3 ;
          uint32_t CF_LKA_Opt_USM        :  3 ;
          uint32_t CF_FCA_LO_Warning     :  2 ;
        }bits;
    }msg;
    
}LKA11_;


//FCA11  ID:0x38d    20
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           
            

            unsigned int                                  : 3 ;
            unsigned int CF_VSM_Warn                      : 2 ;
            unsigned int                                  : 3 ;
            
            unsigned int                                  : 8 ;
            
            unsigned int                                  : 2 ;
            unsigned int FCA_Status                       : 2 ;
            unsigned int                                  : 4 ;
            
            unsigned int                                  : 3 ;
            unsigned int FCA_StopReq         : 1 ;
            unsigned int                                  : 4 ;
            
            unsigned int FCA_Failinfo                     : 3;
            unsigned int                                  : 5 ;
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
        }bits;
    }msg;
    
}FCA11_;


//TCS15  ID:0x507    100
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           
            

            unsigned int  ABS_W_LAMP                        : 1 ;
            unsigned int  TCS_OFF_LAMP                     : 2 ;
            unsigned int  TCS_LAMP                               : 2 ;
            unsigned int                                                      : 3 ;//8
            
            unsigned int  ESC_Off_Step                           : 2 ;
            unsigned int                                                      : 6 ; //16
            
            unsigned int  AVH_CLU                                 : 8 ;  //24
            
            unsigned int                                                      : 2 ;//26
            unsigned int  EBD_W_LAMP                        : 1 ;//27
            unsigned int                                                      : 2 ;//29
            unsigned int   AVH_LAMP                             : 3 ; //32
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
            
        }bits;
    }msg;
    
}TCS15_;

//TCS11  ID:0x153        10
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 3 ;
            unsigned int HAC_CTL                          : 1 ;
            unsigned int                                  : 2 ;
            
            unsigned int ESS_STAT                         : 2 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
        }bits;
    }msg;
    
}TCS11_;

//ESP12  ID:0x220    10
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           
            unsigned int CYL_PRES_FLAG                    : 1 ;
            unsigned int                                  : 7 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 6 ;
            unsigned int CYL_PRES_STAT                    : 2 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
            
        }bits;
    }msg;
    
}ESP12_;


//EMS_H11  ID:0x1bf  10
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           
            
            unsigned int                                  : 4 ;
            unsigned int  RR_DEF_CUTOFF                   : 1 ;
            unsigned int                                  : 3 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
            
        }bits;
    }msg;
    
}EMS_H11_;

//EMS_H12  ID:0x18f    10
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
 
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 3 ;
            unsigned int CF_Ems_IsgStat                   : 3 ;
            unsigned int                                  : 2 ;
            unsigned int                                  : 8 ;
            
            unsigned int CF_Ems_UpTarGr                   : 1 ;
            unsigned int CF_Ems_DownTarGr                 : 1 ;
            unsigned int CF_Ems_DesCurGr                  : 4 ;
            unsigned int                                  : 2 ;
            unsigned int                                  : 1 ;
            unsigned int CF_Ems_IsgBuz                    : 1 ;
            unsigned int                                  : 4 ;
            unsigned int CF_Ems_IsgStat2                  : 2 ;
            
        }bits;
    }msg;
    
}EMS_H12_;

//EMS20  ID:0x200    10
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
 
            unsigned int FCO                              : 16 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
        }bits;
    }msg;
    
}EMS20_;

//EMS19  ID:0x492    50
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                                                  : 8 ;
            unsigned int                                                  : 8 ;
            unsigned int                                                  : 8 ;
            unsigned int                                                  : 8 ;//32
            
            unsigned int  CR_Ems_EngOilTemp         : 8 ;//40
            
            unsigned int DPF_LAMP_STAT                : 2 ; //42
            unsigned int BAT_LAMP_STAT                : 1 ; //43
            unsigned int                                                   : 5 ;//48 
             
            unsigned int                                                   : 8 ;//56
            
            unsigned int CF_Ems_OPSFail                   : 1 ;//57
            unsigned int                                                   : 7 ;//64        
            
        }bits;
    }msg;
    
}EMS19_;
//CGW_PC2  ID:0x568
typedef struct
{   
    union
    {   
        unsigned        data[8];
        struct
        {         
            uint32_t                  : 10 ;
            uint32_t L_MIL            :  1 ;
            uint32_t                  :  2 ;
            uint32_t CF_TCU_WarnMsg   :  3 ;
            uint32_t CF_TCU_WarnImg   :  1 ;
            uint32_t CF_TCU_WarnSnd   :  1 ;
            uint32_t                  :  1 ;
            uint32_t CF_Tcu_DriWarn1  :  3 ;
            uint32_t CF_Tcu_DriWarn2  :  2 ;
            uint32_t                  : 13 ;
            uint32_t CF_Tcu_GSel_BlinkReq :  1 ;
            uint32_t                  :  1 ;
            uint32_t CF_Tcu_SmartShift_Inf :  1 ;
            uint32_t CF_Tcu_SiCluster :  5 ;
            uint32_t CF_Tcu_DrivingModeDisp :  3 ;
            //uint32_t BAT_SOC          :  8 ;
            uint32_t                  :  8 ;
            uint32_t                  :  3 ;
            uint32_t CF_Tcu_DriWarn3  :  2 ;
            uint32_t Bat_dischrg      :  1 ;
            uint32_t                    : 1 ;
            uint32_t CF_EMS_SAFETY_FUNCTION  :  1 ;
        }bits;
    }msg;
    
}CGW_PC2_;















//CGW4  ID:0x559
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {           
            uint32_t CF_Gway_MemoryP1Cmd     : 1 ;
            uint32_t CF_Gway_MemoryP2Cmd     : 1 ;
            uint32_t CF_Gway_PBackP1Cmd     : 1 ;
            uint32_t CF_Gway_PBackP2Cmd     : 1 ;
            uint32_t CF_Gway_StrgWhlHeatedState     : 1 ;
            uint32_t CF_Gway_PBackStopCmd     : 1 ;
            uint32_t                        : 1 ;
            uint32_t                        : 1 ;
            //uint32_t                        : 8 ;
            uint32_t CF_Gway_DrvWdwStat     : 1 ;
            uint32_t CF_Gway_RLWdwState     : 1 ;
            uint32_t CF_Gway_RRWdwState     : 1 ;
            uint32_t CF_Gway_AstWdwStat     : 1 ;
            uint32_t CF_Gway_MemoryEnable   : 1 ;
            uint32_t CF_Gway_StrgWhlAutoOffState   : 1 ;
            uint32_t                        : 1 ;
            uint32_t CF_Gway_IMSBuzzer      : 1 ;
            uint32_t                        : 2 ;
            uint32_t CF_Gway_WiperSwState   :  2 ;
            uint32_t                        : 4 ;
            uint32_t                        : 8 ;
            uint32_t                        : 4 ;
            uint32_t CF_Gway_DrvSeatBeltIND :  2 ;
            uint32_t                        :  2 ;
            uint32_t                        :  6 ;
            uint32_t CF_Gway_RrWiperSwState :  2 ;
            uint32_t                        :  8 ;
            uint32_t CF_Gway_WPCWarning     :  3 ;
            uint32_t                        :  5 ;
        }bits;
    }msg;
    
}CGW4_;





//EMS16  ID:0x492    10
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
 
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int GLOW_STAT                        : 1 ;
            unsigned int                                  : 3 ;
            unsigned int ENG_STAT                         : 3 ;
            unsigned int                                  : 1 ;

            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;            
            
        }bits;
    }msg;
    
}EMS16_;

//EMS14  ID:0x545    100
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
 
            unsigned int                                  : 1 ;
            unsigned int L_MIL                            : 1 ;
            unsigned int                                  : 1 ;
            unsigned int AMP_CAN                          : 5 ;
            
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int  VB                              : 8 ; 
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;           
            
        }bits;
    }msg;
    
}EMS14_;

//EMS12  ID:0x329    10
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                                  : 8 ;
            unsigned int  TEMP_ENG                        : 8 ;
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 6 ; 
            unsigned int ACC_ACT                          : 2 ;
            
            unsigned int BRAKE_ACT                        : 2 ;
            unsigned int                                  : 6 ;
            unsigned int TPS                              : 8 ;
            unsigned int PV_AV_CAN                        : 8 ;
            unsigned int                                  : 8 ;           
            
        }bits;
    }msg;
    
}EMS12_;


//EMS11  ID:0x316   10
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                                  : 1 ;
           
            unsigned int  F_N_ENG                         : 1 ;
            unsigned int                                  : 6 ;
            unsigned int                                  : 8 ;
            unsigned int  N                               : 16 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int  VS                              : 8 ;           
            
        }bits;
    }msg;
    
}EMS11_;

//DATC13  ID:0x43   1000
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int  CF_Datc_TempDispUnit            : 2 ;
            unsigned int                                  : 6 ;
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;

           
            
        }bits;
    }msg;
    
}DATC13_;


//DATC11  ID:0x44   1000   
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int CR_Datc_OutTempC                 : 8 ;
            unsigned int CR_Datc_OutTempF                 : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
           
            
        }bits;
    }msg;
    
}DATC11_;

//ACU14  ID:0x500   100
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           
          unsigned int CF_SWL_Ind       :  2 ;
           unsigned int      :  6 ;
           
            
        }bits;
    }msg;
    
}ACU14_;

//BCW11 ID:0x58B   50
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            
            
            unsigned int      CF_BCW_Stat               :  4  ;
            unsigned int      CF_RCCW_Stat              :  4  ;
            
            
            unsigned int      CF_BCW_IndLeft            :  2  ;
            unsigned int                                :  6  ;
            
            unsigned int        CF_BCW_IndRight        :  2  ;
            unsigned int                                :  2 ;
            unsigned int      CF_FR_SndWan              :  1  ;
            unsigned int      CF_FL_SndWan              :  1  ;
            unsigned int      CF_RR_SndWan              :  1  ;
            unsigned int      CF_RL_SndWan              :  1  ;
            
            unsigned int                               :  8  ;
            unsigned int                               :  8  ;
            unsigned int                               :  8  ;
            unsigned int                               :  8  ;
            
                
                
            unsigned int      CF_RCCW_IndLeft           :  2  ;
            unsigned int      CF_RCCW_IndRight          :  2  ;
            unsigned int                               :  4  ;


            
        }bits;
    }msg;
    
}BCW11_;

typedef union 
{
	unsigned char      m_aucData[8];
	struct {
	    unsigned int                        :  6 ;
            unsigned int CF_RCCA_WarnLh         :  2 ;
            unsigned int CF_BCA_R_Plus_WarnLh   :  2 ;
            unsigned int CF_BCA_R_Plus_WarnRh   :  2 ;
            unsigned int                        :  2 ;
            unsigned int CF_RCCA_WarnRh         :  2 ;
	    unsigned int CF_BCA_State           :  3 ;
            unsigned int                        :  5 ;
            unsigned int                        :  6 ;
	    unsigned int BCW_IndSta             :  2 ;
	    unsigned int CF_SEA_Stat            :  2 ;
            unsigned int CF_RCCA_FuncState      :  1 ;
            unsigned int CF_BCA_RH_SndWan       :  1 ;
            unsigned int CF_BCA_LH_SndWan       :  1 ;
            unsigned int                        :  3 ;
            unsigned int CF_RCCA_SW_Stat        :  3 ;
	    unsigned int                        :  2 ;
	    unsigned int CF_BCA_R_Warning       :  3 ;
            unsigned int BCA_Plus_Deccel_Req    :  4 ;
            unsigned int BCA_Plus_BrkCmdSta     :  1 ;
            unsigned int CF_BCA_R_Plus_State    :  3 ;
            unsigned int                        :  8 ;
	};
}BCA11_;



//ACU13  ID:0x10     0 10    
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           
            unsigned int CF_Acu_CshAct                    : 1 ;
            unsigned int                                  : 7 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
         
            
        }bits;
    }msg;
    
}ACU13_;


//WHL_SPD11  ID:0x386   20
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           
            unsigned int WHL_SPD_FL                       : 16 ;
            //unsigned int                                  : 2 ;
            unsigned int WHL_SPD_FR                       : 16 ;
            //unsigned int                                  : 2 ;
            unsigned int WHL_SPD_RL                       : 16 ;
           // unsigned int                                  : 2 ;
            unsigned int WHL_SPD_RR                       : 16 ;
            //unsigned int                                  : 2 ;
                       
            
        }bits;
    }msg;
    
}WHL_SPD11_;

//ABS11  ID:0x38a   20
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           

            unsigned int                                  : 3 ;
            unsigned int  ABS_W_LAMP                      : 1 ;
            unsigned int  EBD_W_LAMP                      : 1 ;
            unsigned int                                  : 1 ;
            unsigned int  ESS_STAT                        : 2 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
                       
                       
            
        }bits;
    }msg;
    
}ABS11_;

//SCC11  ID:0x420 
typedef struct
{   
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int  MainMode_SCC                      : 1 ;
            unsigned int  SCCInfoDisplay                       : 3 ;
            unsigned int  AliveCounterSCC                    : 4 ; 
            
            unsigned int  VSetDis                                     : 8 ; //16
            
            unsigned int   ObjValid                                   : 1 ; //17
            unsigned int   DriverAlertDisplay                 : 2 ; // 19
            unsigned int   TauGapSet                                : 3 ; // 22
            unsigned int                                                     : 2 ; // 24  
             
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
        }bits;
    }msg;
}SCC11_;

//SCC12  ID:0x421 
typedef struct
{   
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                  : 11 ;
            unsigned int SCCFailInfo      :  2 ;
            unsigned int                  : 22 ;
            unsigned int TakeOverReq      :  1 ;
            unsigned int                  : 28 ;
        }bits;
    }msg;
}SCC12_;

//SCC14  ID:0x389
typedef struct
{   
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                  : 32 ;
            unsigned int SCCMode2         :  3 ;
            unsigned int NSCC_AutoSetSpdUpdtSta :  2 ;
            unsigned int NSCC_AutoSetSpdSta :  2 ;
            unsigned int                  :  3 ;
            unsigned int                  :  3 ;
            unsigned int                  : 11 ;
            unsigned int ObjGap           :  8 ;
        }bits;
    }msg;
}SCC14_;


//HDA11  ID:0x485
typedef struct
{   
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int CF_HDA_Opt_USM   : 2 ;
            unsigned int CF_HDA_AutoSetSpdEnable  : 1 ;
            unsigned int CF_HDA_Mode      : 2 ;
            unsigned int                  : 2 ;
            unsigned int CF_HDA_AutoSetSpdUpdate : 1 ;
            unsigned int CF_HDA_AutoSetSpd    : 8 ;     //dn8c adas
            unsigned int CF_HDA_InfoDisplay :  3 ;
            unsigned int                  :  4 ;
            unsigned int CF_HDA_LFA_Wrn_Snd     :  1 ;
            unsigned int CF_HDA_LFA_SymbolState :  2 ;
            unsigned int                  :  1 ;
            unsigned int                  :  2 ;
            unsigned int CF_HDA_InfoDisplay2 : 3 ;
            unsigned int                  :  32 ;
        }bits;
    }msg;
}HDA11_;


//CLU19  ID:0x4a6   0   10
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           


            unsigned int  CF_AVN_FCANValueSet             : 3 ;
            unsigned int  CF_AVN_CluUSMReset              : 1 ;
            unsigned int                                  : 4 ;
            unsigned int                                  : 3 ;
            unsigned int  CF_AVN_DAWModeNValueSet         : 3 ;
            unsigned int                                  : 2 ;
            
            
            unsigned int                                  : 8 ;
            
            unsigned int                                  : 4 ;
            unsigned int  CF_AVN_WarningTimingNValueSet   : 3 ;
            unsigned int                                  : 1 ;
            unsigned int  CF_AVN_SccFrVehDptNValueSet     : 2 ;
            unsigned int                                  : 6 ;
            
            unsigned int                                  : 8 ;
            
            unsigned int                                  : 1 ;
            unsigned int CF_AVN_LkaModeNValueSet          : 3 ;
            unsigned int                                  : 2 ;
            unsigned int CF_AVN_HBANValueSet              : 2 ;
            unsigned int                                  : 8 ;
                       
                       
            
        }bits;
    }msg;
    
}CLU19_;

//CLU16  ID:0x51b   0
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           
            unsigned int CF_Clu_TirePressUnitNValueSet :  3 ;
	          unsigned int                  :  5 ;
	          unsigned int                  :  8 ;
	          
	          unsigned int                  :  1 ;
	          unsigned int CF_Clu_FCAModeNValueSet :  3 ;
	          unsigned int                  : 3 ;
	          unsigned int                  : 1 ;
	          
	          unsigned int                  :  7 ;
	          unsigned int                  : 1 ;
	          
	          unsigned int                  :  7 ;
	          unsigned int CF_Clu_USMReset  :  1 ;
	          unsigned int                  : 8 ;
	          unsigned int                  : 8 ;
	          unsigned int                  : 8 ;
        }bits;
    }msg;
    
}CLU16_;
 //CGW_PC4  ID:0x366
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                 :  8 ;
            unsigned int N               : 16 ; 
            unsigned int                 : 8  ;
            
            
            
            unsigned int                 : 8 ;
            unsigned int                 : 8 ;
            
            unsigned int                 : 1 ;
            unsigned int F_N_ENG          :  1 ;
            unsigned int                 :  2 ;
            unsigned int SCU_WarnMsg      :  4 ;
            
            unsigned int                 :  8 ;                      
        }bits;
    }msg;
}CGW_PC4_;


//EPB11  ID:0x490 
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
                unsigned int   EPB_I_LAMP                           : 4 ;
                unsigned int   EPB_F_LAMP                          : 2 ; 
                unsigned int   EPB_ALARM                           : 2 ; //8

                unsigned int   EPB_CLU                                 : 8  ;//16   

                unsigned int                                                      : 8 ;
                unsigned int                                                      : 8 ;
                unsigned int                                                      : 8 ;
                unsigned int                                                      : 8 ;
                unsigned int                                                      : 8 ;    
                unsigned int                                                      : 8 ;
        }bits;
    }msg;
}EPB11_;



//CGW_PC5  ID:0x367
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {                                                                    
                unsigned int  SLD_VS                                    : 8 ;

                unsigned int   CF_Ems_IsgStat                     : 3 ;//11
                unsigned int   CF_Ems_OilChg                    : 1 ;//12
                unsigned int                                                    : 1 ;//13   
                unsigned int   CF_Ems_UpTarGr                 : 1 ;//14 
                unsigned int   CF_Ems_DownTarGr            : 1 ;//15  
                unsigned int                                                    : 1 ;//16    
                                     
                unsigned int   CF_Ems_DesCurGr               : 4 ; //20    
                unsigned int                                                    : 1 ;  //21
                unsigned int  CF_Ems_IsgBuz                      : 1 ;  //22
                unsigned int                                                    : 2 ;  //24  
                
                unsigned int                                                    : 1 ;  //25   
                unsigned int  CF_Ems_IsgStat2                   : 2 ;  //27 
                unsigned int                                                    : 5 ;  //32   

                unsigned int   G_SEL_DISP                          : 4 ;//36 
                unsigned int   GEAR_TYPE                          : 4 ;//40                          : 4 ; 

                unsigned int                                                    : 8 ;
                unsigned int                                                    : 8 ;
                unsigned int                                                    : 8 ; 
        }bits;
    }msg;
}CGW_PC5_; 

//CGW_PC12  ID:0x4C9
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                                                             : 8 ; 
            unsigned int                                                             : 8 ;  //16
            unsigned int                                                             : 8 ;  //24  
            unsigned int                                                             : 8 ; //32
                
            unsigned int                                                             : 4 ; 
            unsigned int                                                             : 4 ; //40
           
            unsigned int                                                             : 1 ;
            unsigned int   CF_Ems_ISG_Equipped                                                          : 1 ;
            unsigned int                                                             : 6 ; 
            unsigned int                                                             : 8 ;//56 
             
            unsigned int                                                             : 5 ; //61     
            unsigned int                                                             : 2 ; //63
            unsigned int                                                             : 1 ; //64                                      
        }bits;
    }msg;
}CGW_PC12_;

















//CGW_PC6  ID:0x368
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                                                             : 8 ; 
            unsigned int                                                             : 8 ;  //16
            unsigned int                                                             : 8 ;  //24  
            unsigned int                                                             : 8 ; //32
                
            unsigned int  CF_Tcu_TarGr                                 : 4 ; 
            unsigned int                                                             : 4 ; //40
           
            unsigned int                                                             : 8 ; //48
            unsigned int                                                             : 8 ;//56 
             
            unsigned int                                                             : 5 ; //61     
            unsigned int TCU_TYPE                                        : 2 ; //63
            unsigned int                                                             : 1 ; //64                                      
        }bits;
    }msg;
}CGW_PC6_;

//CGW_PC8  ID:0x356  10
typedef struct
{   
    
    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                                                : 8 ; 
            unsigned int                                                : 8 ; 
            unsigned int                                                : 8 ; 
            unsigned int                                                : 4 ; 
            unsigned int         CF_Lvr_Wrn                             : 3 ; 
            unsigned int                                                : 1 ; 
            unsigned int         FCO                                    : 16 ; 
            unsigned int                                                : 8 ; 
            
        }bits;
        
    }msg;
}CGW_PC8_;












 //CGW5  ID:0x7F
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
	    unsigned int C_StopLampLhOpenSts :  1 ;
	    unsigned int C_StopLampRhOpenSts :  1 ;
	    unsigned int                     : 7 ;
	    unsigned int C_RearFOGLhOpenSts  : 1 ;
	    unsigned int                     : 7 ;
	    unsigned int C_RearTSIGLhOpenSts :  1 ;
	    unsigned int C_RearTSIGRhOpenSts :  1 ;
	    unsigned int C_FrontTSIGLhOpenSts :  1 ;
	    unsigned int C_FrontTSIGRhOpenSts :  1 ;
      unsigned int C_SBendingLhOpenSts     :  1 ;
	    unsigned int C_SBendingRhOpenSts     :  1 ;
	    unsigned int                  :  2 ;
	    //unsigned int C_HLampBifuncLhOpenSts :  1 ;
	    //unsigned int C_HLampBifuncRhOpenSts :  1 ;
      unsigned int                  :  2 ;
      unsigned int                  :  3 ;
	    unsigned int CF_Afs_LedHLStat :  2 ;
      unsigned int                  :  2 ;
      unsigned int                  :  2 ;
      unsigned int CF_Gway_RrSeatRemindInfo : 2 ;
      unsigned int                  :  2 ;
      unsigned int                  :  24 ;
        }bits;
    }msg;
    
}CGW5_;


typedef union 
{
    uint8_t      m_aucData[8];
    struct {
        uint32_t CF_Evp_Stat            :  1 ;
    uint32_t                        :  31 ;
    uint32_t                        :  32 ;
    };
}EVP11_;

 //CGW7  ID:0x7F
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
            uint32_t CF_Gway_SeatBeltWngBuz :  2 ;
            uint32_t    CF_Gway_DrvSeatBeltInd              : 19 ;
            uint32_t CF_Gway_IMSErrorWarningDispaly :  2 ;
            uint32_t                  : 9 ;
            uint32_t                  : 32 ;
        }bits;
    }msg;
    
}CGW7_;






 //PAS11  ID:0x436
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int CF_Gway_PASDisplayFLH  :  3 ;
            unsigned int CF_Gway_PASDisplayFRH  :  3 ;
            unsigned int CF_Gway_PASRsound      :  2 ;
            unsigned int CF_Gway_PASDisplayFCTR :  3 ;
            unsigned int CF_Gway_PASDisplayRCTR :  3 ;
            unsigned int CF_Gway_PASFsound      :  2 ;
            unsigned int CF_Gway_PASDisplayRLH  :  3 ;
            unsigned int CF_Gway_PASDisplayRRH  :  3 ;
            unsigned int CF_Gway_PASCheckSound  :  2 ;
            unsigned int CF_Gway_PASSystemOn    :  2 ;
            unsigned int CF_Gway_PASOption      :  2 ;
            unsigned int                        :  4 ;
        }bits;
    }msg;
    
}PAS11_;





//CLU15  ID:0x52a   200
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           

            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 1 ;
            unsigned int  CF_Clu_LanguageInfo             : 5 ;
            unsigned int                                  : 2 ;
            unsigned int                                  : 6 ;
            unsigned int  CF_Gway_RVMSw                   : 2 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
  
        }bits;
    }msg;
    
}CLU15_;



//CLU12  ID:0x5b0   1000
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
           

            unsigned long   CF_Clu_Odometer               : 24 ;
            unsigned int    CR_Clu_OutTempSns             : 8 ;
        
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
      
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
           
  
        }bits;
    }msg;
    
}CLU12_;

//CLU11  ID:0x4f1   20
typedef union 
{
    uint8_t      m_aucData[8];
    struct {
    uint32_t CF_Clu_CruiseSwState :  3 ;
    uint32_t CF_Clu_CruiseSwMain :  1 ;
    uint32_t CF_Clu_SldMainSW :  1 ;
    uint32_t CF_Clu_ParityBit1 :  1 ;
    uint32_t CF_Clu_VanzDecimal :  2 ;
    uint32_t CF_Clu_Vanz      :  9 ;
    uint32_t CF_Clu_SPEED_UNIT :  1 ;
    uint32_t                  :  1 ;
    uint32_t CF_Clu_RheostatLevel :  5 ;
    uint32_t                  :  1 ;
    uint32_t                  :  3 ;
    uint32_t CF_Clu_AliveCnt1 :  4 ;
    };
}CLU11_;




//CLU_HU_PE_05  ID:0x1D4  20
typedef union 
{
	uint8_t      m_aucData[8];
	struct
	{
	    uint32_t Clu_Usm_VoiceVolume :  3 ;
	    uint32_t Clu_Usm_AutoinitFuelEconomy :  3 ;
	    uint32_t Clu_Usm_WelcomeSound :  2 ;
	    uint32_t CLU_Usm_Roadinfoguide :  2 ;
	    uint32_t CLU_Usm_WiperLight :  2 ;
	    uint32_t Clu_Usm_TransmissionDisp :  2 ;
	    uint32_t Clu_Usm_FuelEconUnit_km :  2 ;
	    uint32_t                  :  1 ;
	    uint32_t Clu_Usm_AdasVolume :  3 ;
	    uint32_t Clu_Usm_SubspeedometerDisp :  2 ;
	    uint32_t Clu_Usm_FuelEconUnit_mi :  2 ;
	    uint32_t                  :  2 ;
	    uint32_t Warn_Sound_AdasVolumeFeedback :  3 ;
	    uint32_t                  : 32 ;
	    uint32_t                  :  3 ;

	} ;
}CLU_HU_PE_05_;


//CGW6  ID:0x50e     200
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                                  : 5 ;
            unsigned int  CF_Gway_ClutchIgnLockSW         : 1 ;
            unsigned int                                  : 2 ;
            unsigned int                                  : 4 ;
            unsigned int  CF_Gway_WasherFluidSw           : 4 ;
            unsigned int                                  : 7 ;
            unsigned int  CF_Gway_RrDefoggerInd           : 1 ; 
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 4 ;
            unsigned int    CF_ICU_SeaWarn_Lh             : 2 ;
            unsigned int   CF_ICU_SeaWarn_Rh              : 2 ;
            unsigned int                                  : 8 ;
            unsigned int                                  : 8 ;
  
        }bits;
    }msg;
    
}CGW6_;

//CGW2  ID:0x553         200`   
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int                                                                : 8 ;  
            
            unsigned int  CF_Gway_ExtTailAct                          :2 ;   //10
            unsigned int                                                                 : 6 ; //16
            
            unsigned int  CF_Gway_AutoLightValue                  : 1 ; //17
            unsigned int  CF_Gway_BrakeFluidSw                     : 1 ;  //18
            unsigned int  CF_Gway_ICUPowerAutoCutMode     : 2 ; //20
            unsigned int  CF_Gway_AvTail                                  : 1 ; //21
            unsigned int  CF_Gway_RearFogAct                         : 1 ; //22
            unsigned int                                                                  : 1 ; //23 
            unsigned int  CF_Gway_RRDrSw                              : 1 ; //24
            
            unsigned int  CF_Gway_RLDrSw                              : 1 ; //25
            unsigned int  CF_Gway_IntTailAct                            : 1 ; //26
            unsigned int                                                                  : 6 ; //32
            
            unsigned int                                                                  : 3 ; //35 
            unsigned int  CF_Gway_ESCLFailWarn                   : 1 ; //36
            unsigned int  CF_Gway_ESCLNotLockedWarn      : 1 ; //37    
            unsigned int  CF_Gway_ESCLNotUnlockWarn      : 1 ; //38    
            unsigned int  CF_Gway_IDoutWarn                         : 1 ; //39  
            unsigned int                                                                 : 1 ; //40 
                              
            unsigned int  CF_Gway_ImmoLp                               : 1 ; //41
            unsigned int                                                                   : 3 ; //44  
            unsigned int  CF_Gway_VehicleNotPWarn               : 1 ; //45  
            unsigned int  CF_Gway_DeactivationWarn               : 1 ; //46 
            unsigned int  CF_Gway_KeyBATDischargeWarn    : 1 ; //47
            unsigned int  CF_Gway_SSBWarn                             : 1 ; //48  
            
            unsigned int                                                                   : 3 ; //51
            unsigned int  CF_Gway_SMKRKECmd                     : 3 ;//54
            unsigned int                                                                   : 1 ; //55  
            unsigned int  CF_Gway_SJBDeliveryMode               : 1 ; //56 
            
            unsigned int  CF_Gway_KeyoutLp                              : 1 ; //57
            unsigned int  CF_Gway_SMKDispWarn                     : 4 ; //61
            unsigned int  CF_Gway_WngBuz                                 : 3 ; //64
        }bits;
    }msg;
    
}CGW2_;
 
typedef struct 
{

   
    union 
    {
        	unsigned char      data[8];
        	struct 
        	{
          unsigned int CF_Ahb_SLmp      : 2 ;
          unsigned int                  : 5 ;    
          unsigned int CF_Ahb_WLmp      : 1 ;
          }bits;
    }msg;
}AHB1_;


//CGW1  ID:0x541    100
typedef struct
{   

    union
    {   
        unsigned        data[8];
        struct
        {   
            unsigned int  CF_Gway_IGNSw                   : 3 ;
            unsigned int  CF_Gway_RKECmd                  : 3 ;
            unsigned int  CF_Gway_DrvKeyLockSw            : 1 ;
            unsigned int  CF_Gway_DrvKeyUnlockSw          : 1 ;
            
            
            unsigned int  CF_Gway_DrvDrSw                 : 2 ;
            unsigned int  CF_Gway_DrvSeatBeltSw           : 2 ;
            unsigned int  CF_Gway_TrunkTgSw               : 2 ;
            unsigned int  CF_Gway_AstSeatBeltSw           : 2 ;
            
            
            
            unsigned int  CF_Gway_SMKOption               : 1 ;
            unsigned int  CF_Gway_HoodSw                  : 2 ;
            unsigned int  CF_Gway_TurnSigLh               : 2 ;
            unsigned int  CF_Gway_WiperIntT               : 3 ;
            
            unsigned int  CF_Gway_WiperIntSw              : 1 ;
            unsigned int  CF_Gway_WiperLowSw              : 1 ;
            unsigned int  CF_Gway_WiperHighSw             : 1 ;
            unsigned int  CF_Gway_WiperAutoSw             : 1 ;
            unsigned int  CF_Gway_RainSnsState            : 3 ;
            unsigned int  CF_Gway_HeadLampLow             : 1 ;
            
            unsigned int  CF_Gway_HeadLampHigh            : 1 ;
            unsigned int  CF_Gway_HazardSw                : 2 ;
            unsigned int  CF_Gway_AstDrSw                 : 1 ;
            unsigned int  CF_Gway_DefoggerRly             : 1 ;
            unsigned int  CF_Gway_ALightStat              : 1 ;
            unsigned int  CF_Gway_LightSwState            : 2 ;
            
            unsigned int  CF_Gway_Frt_Fog_Act             : 1 ;
            unsigned int  CF_Gway_TSigRHSw                : 1 ;
            unsigned int  CF_Gway_TSigLHSw                : 1 ;
            unsigned int  CF_Gway_DriveTypeOption         : 1 ;
            unsigned int  CF_Gway_StarterRlyState         : 1 ;
            unsigned int  CF_Gway_PassiveAccessLock       : 2 ;
            unsigned int                                  : 1 ;
            
            unsigned int  CF_Gway_PassiveAccessUnlock     : 2 ;
            unsigned int                                  : 1 ;
            unsigned int  CF_Gway_PassingSW               : 1 ;
            unsigned int  CF_Gway_HBAControlMode          : 1 ;
            unsigned int  CF_Gway_HLpHighSw               : 1 ;
            unsigned int  CF_Gway_InhibitRMT              : 2 ;
            
            
            unsigned int                                  : 1 ;
            unsigned int  C_SunRoofOpenState              : 1 ;
            unsigned int                                  : 2 ;
            unsigned int  CF_Gway_ParkBrakeSw             : 2 ;
            unsigned int  CF_Gway_TurnSigRh               : 2 ;
            
  
        }bits;
    }msg;
    
}CGW1_;            


//0x424
typedef union 
{
    unsigned char      m_aucData[8];
    
    struct {
        unsigned int                        :   6   ;
        unsigned int  C_BLEOption           :    2   ;
        
        
        
        unsigned int                        :   8   ;
        unsigned int                        :    6  ;
        
        
        unsigned int C_BLEIDOut             :    2   ;
        unsigned int                        :   7  ;

        
        
        
        unsigned int        C_BLEKeyreminder        :   3   ;
        unsigned int                        :    6  ;
        unsigned int                        :   16   ;
        unsigned int                        :    8  ;

    };
}HU_BLE_PE_00_;

//EV_PC9  ID 50B
typedef struct 
{

    union 
    {
        	unsigned char      data[8];
        	struct 
        	{
                unsigned int                                                         : 8; 
                unsigned int                                                         : 8;   
                unsigned int CR_Bms_DisplaySoc                   : 8 ;
                unsigned int CF_Vcu_ResvAirCtrInfo              : 1 ;
                unsigned int CF_Datc_ServiceLamp                 : 1 ;
                unsigned int CF_Bms_PShiftForCharging        : 1 ;
                unsigned int                                                          : 1 ;          
                unsigned int CF_OBC_AC_CONNECT_FLAG          : 1 ;
                unsigned int                                 : 2 ;
                unsigned int CF_OBC_SERVICE_LAMP_Req         : 1 ;//
                unsigned int                                                          : 8;
                unsigned int                                                          : 8;
                unsigned int                                                          : 5;   
                unsigned int CF_Vuc_ProgCharWaitForCharInd   : 1 ;
                unsigned int DATC_TempUnit                            : 2 ;
                unsigned int CF_Bms_FstEvseFltAlram            : 1 ;
                unsigned int CF_Vcu_ResvInfo                          : 1 ;
                unsigned int                                                          : 2 ; 
                unsigned int CF_Vcu_WarnMsg                        : 4 ;
          }bits;
    }msg;
}EV_PC9_;

typedef struct
{   
    union
    {  
        uint8_t data[8];
        struct
        {   
 
            unsigned int   Byte0Data        : 8 ;
            unsigned int   Byte1Data        : 8 ;
            unsigned int   Byte2Data        : 8 ;
            unsigned int   Byte3Data        : 8 ;
            unsigned int   Byte4Data        : 8 ;
            unsigned int   Byte5Data        : 8 ;       
            unsigned int   Byte6Data        : 8 ;
            unsigned int   Byte7Data        : 8 ;
        }bits;
    }msg;
}Send_7DF;  



typedef struct
{   
    union
    {  
        uint8_t data[8];
        struct
        {   
 
            unsigned int                  : 8 ;
            unsigned int                  : 8 ;
            unsigned int                  : 8 ;
            unsigned int                  : 8 ;
            unsigned int                  : 8 ;
            unsigned int                  : 8 ;       
            unsigned int                  : 8 ;
            unsigned int     LVR12_STS    : 2 ;
            unsigned int                  : 6 ;
        }bits;
    }msg;
}P_STS_;  

typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int   Byte0Data        : 8 ;
            unsigned int   Byte1Data        : 8 ;
            unsigned int   Byte2Data        : 8 ;
            unsigned int   Byte3Data        : 8 ;
            unsigned int   Byte4Data        : 8 ;
            unsigned int   Byte5Data        : 8 ;       
            unsigned int   Byte6Data        : 8 ;
            unsigned int   Byte7Data        : 8 ;
        }bits; 
    }msg;
}Send_7C6; 
typedef struct
{       uint32_t ID; 
        uint8_t DataLen;
        uint8_t data[8];
        struct
        {   
            unsigned int   Byte0Data        : 8 ;
            unsigned int   Byte1Data        : 8 ;
            unsigned int   Byte2Data        : 8 ;
            unsigned int   Byte3Data        : 8 ;
            unsigned int   Byte4Data        : 8 ;
            unsigned int   Byte5Data        : 8 ;       
            unsigned int   Byte6Data        : 8 ;
            unsigned int   Byte7Data        : 8 ;
        }; 
}Receive_7CE; 

typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int   Byte0Data        : 8 ;
            unsigned int   Byte1Data        : 8 ;
            unsigned int   Byte2Data        : 8 ;
            unsigned int   Byte3Data        : 8 ;
            unsigned int   Byte4Data        : 8 ;
            unsigned int   Byte5Data        : 8 ;       
            unsigned int   Byte6Data        : 8 ;
            unsigned int   Byte7Data        : 8 ;
        }bits; 
    }msg;
}Send_null;

typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int   Byte0Data        : 8 ;
            unsigned int   Byte1Data        : 8 ;
            unsigned int   Byte2Data        : 8 ;
            unsigned int   Byte3Data        : 8 ;
            unsigned int   Byte4Data        : 3 ;
            unsigned int   ISG_SideStand    : 1 ;
            unsigned int   ISG_Power_Enable : 2 ;
            unsigned int   null             : 2 ;
            unsigned int   Byte5Data        : 8 ;       
            unsigned int   Byte6Data        : 8 ;
            unsigned int   Byte7Data        : 8 ;
        }bits; 
    }msg;
}Send_111_;




typedef union 
{
    unsigned char      mdata[8];
    struct {
        unsigned int Byte0Data     :   8 ;
        unsigned int Byte1Data     :   8 ;
        unsigned int Byte2Data     :   8 ;
        unsigned int Byte3Data     :   8 ;
        unsigned int Byte4Data     :   8 ;
        unsigned int Byte5Data     :   8 ;
        unsigned int Byte6Data     :   8 ;
        unsigned int Byte7Data     :   8 ;
    };
}Send_Data;

typedef union 
{
    uint8_t      m_aucData[8];
    struct {
    uint32_t   : 16;
    uint32_t SCU_N_MODE : 2;
    uint32_t   : 2;
    uint32_t SCU_POS_ACT : 4;
    uint32_t   : 3;
    uint32_t CF_Lvr_Wrn : 5;
    uint32_t   : 32;
    };
}CGW_PC11_;


typedef struct
{   
    union
    {   
        unsigned        data[8];
        struct
        {   
            uint32_t   : 16;
            uint32_t CR_Fatc_OutTempSns : 8;
            uint32_t   : 4;
            uint32_t ENG_SldSwSta : 2;
            uint32_t   : 2;
            uint32_t   : 32;
        }bits;
    }msg;
}CGW_PC1_;










//CGW_PC3  0X572 200MS
typedef union 
{
    uint8_t      m_aucData[8];
    struct {
    uint8_t                       : 8;
    uint8_t                       : 8;
    uint8_t                       : 8;
    uint8_t                       : 8;
    uint8_t                       : 8;
    uint8_t                       : 8;
    uint8_t                       : 8;
    uint32_t  HILL_HOLD_WARNING    : 1 ;
    uint32_t  Clutch_Burst_Warning : 1 ;
    uint32_t  Vehicle_Stop_Time    : 5 ;
    uint32_t                : 1 ;
    
    };
}CGW_PC3_;

typedef struct
{ 
    union
    {  
        uint8_t data[1];
        struct
        {   
            
            unsigned int   Byte0Data        : 8 ;
        }bits;
    }msg;
}Send_7DF_ectype; 

//ECU_Engine_Data_M2 0x240 20ms
typedef struct
{ 
    union
    {  
      uint8_t data[8];
        struct
        {   
            
            unsigned int   ECU_Eng_Tans                    : 8 ;//发动机进气温度
            //unsigned int   ECU_Dash_Drive_Mode_Ack         : 8 ;//仪表设置反馈信号
            unsigned int   ECU_VBattery                    : 8 ;//蓄电池电压
            unsigned int   ECU_Side_Stand_Position         : 8 ;//边撑位置
            unsigned int          s01                      : 8 ;
            unsigned int          s02                      : 3 ;
            unsigned int   ECU_MILLampSts                  : 2 ;//ECUMIL灯状态
            unsigned int   ECU_Temperature_Water_Malf      : 3 ;//冷却水温度有效位
            unsigned int   ECU_Eng_Tans_Malf               : 8 ;//发动机进气温度有效位
            //unsigned int   ECU_Eng_Rpm_Signal_Failure      : 8 ;//发动机转速有效性标志位
            unsigned int   ECU_Eng_Rpm_120                 : 8 ;//发动机当前转速
            unsigned int   ECU_Temperature_Water           : 8 ;//冷却水温度
        }bits;
    }msg;
}ECU_Engine_Data_M2_; 

//HU_GW_PE_01  0x173 200ms
//typedef union 
//{
//    uint8_t      m_aucData[8];
//    struct {
//        uint8_t     HU_AliveStatus       : 2;
//    uint8_t                       : 4;
//    uint8_t    HU_DistanceUnit    : 2;
//    
//    uint8_t                       : 8;
//    uint8_t                       : 8;
//    uint8_t                       : 8;
//    uint8_t                       : 8;
//    
//    uint8_t                      : 4 ;
//    uint8_t  CF_AVN_ProfileIDRValue : 4 ;
//    uint8_t                      : 8 ;
//    uint8_t                      : 8 ;
//    };
//}HU_GW_PE_01_;
//CGW_PC3  0X572 200MS
typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int                 : 8 ;
            unsigned int                 : 8 ;
            
            unsigned int                 : 3 ;
            unsigned int TCS_WorkMode    : 4 ;
            unsigned int                 : 1 ;
            
            unsigned int  TCS_SysState    : 2;
            unsigned int                 : 6;
            unsigned int TCS_WarningLamp : 1 ;
            unsigned int                 : 7;
            
            unsigned int                 : 8 ;       
            unsigned int                 : 8 ;
            unsigned int                 : 8 ;
        }bits; 
    }msg;
}TCS_125_;

//ECU_402 ID:402
typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int                     : 8 ;
            unsigned int                     : 8 ;
            unsigned int                     : 8 ;
            unsigned int                     : 8 ;
            unsigned int                     : 8 ;       
            unsigned int                     : 8 ;
            unsigned int                     : 8 ;
            unsigned int                     : 7 ;
            unsigned int  ECU_Warning_Lamp   : 1 ;
        }bits; 
    }msg;
}ECU_402_;

typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int      TBOX_WorkMode           : 1 ;
            unsigned int                     : 7 ;
            unsigned int                     : 8 ;
            unsigned int                     : 8 ;
            unsigned int                     : 8 ;
            unsigned int                     : 8 ;  
            unsigned int                     : 8 ;       
            unsigned int                     : 8 ;
            unsigned int                     : 8 ;
        }bits; 
    }msg;
}TBOX_;
//QS_341  ID:341  200ms
typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int                           : 8 ;
            unsigned int    QS_status              : 2 ;

            unsigned int   Launch_ControlSwitch    : 1 ;
            unsigned int   Launch_ControlStatus    : 1 ;
            unsigned int                           : 4 ;       
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
        }bits; 
    }msg;
}QS_341_;
//ECU_101 ID:101 new
typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int  ECU_Engine_Speed_H       : 8 ;
            unsigned int  ECU_Engine_Speed_L       : 8 ;
            unsigned int  ECU_Vehicle_Speed        : 8 ;
            unsigned int                           : 8 ;
            unsigned int ECU_Engine_Temperature_H  : 8 ;       
            unsigned int ECU_Engine_Temperature_L  : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
        }bits; 
    }msg;
}ECU_101_;

typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int         : 8 ;
            unsigned int         : 8 ;
            unsigned int         : 8 ;
            unsigned int         : 8 ;
            unsigned int MBMS_Soc  : 8 ;       
            unsigned int         : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
        }bits; 
    }msg;
}SOC1_;

typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int         : 8 ;
            unsigned int         : 8 ;
            unsigned int         : 8 ;
            unsigned int         : 8 ;
            unsigned int MBMS_Soc  : 8 ;       
            unsigned int         : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
        }bits; 
    }msg;
}SOC2_;

typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int         : 2 ;
            unsigned int  MMCU_PowerMode       : 4 ;
            unsigned int         : 2 ;

            unsigned int MMCU_TravelSpeedGear        : 2 ;
            unsigned int         : 6 ;

            unsigned int         : 1 ;
            unsigned int MMCU_SeatDetectState        : 1 ;
            unsigned int         : 5 ;
            unsigned int MMCU_ParkingGearState        : 1 ;
            
            unsigned int         : 8 ;
            unsigned int   : 8 ;       
            unsigned int         : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
        }bits; 
    }msg;
}CAN125_;

typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int         : 3 ;
            unsigned int BMCU_PTOSwicthState        : 1 ;
            unsigned int BMCU_BladeSpeedGear        : 3 ;
            unsigned int         : 1 ;
            unsigned int         : 8 ;
            unsigned int         : 8 ;
            unsigned int   : 8 ;       
            unsigned int         : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
        }bits; 
    }msg;
}CAN157_;

typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int         : 8 ;
            unsigned int BMCU_Moto1_Locked_RotorFault        : 1 ;
            unsigned int BMCU_Moto2_Locked_RotorFault        : 1 ;
            unsigned int         : 6 ;
            unsigned int   : 8 ;       
            unsigned int         : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
        }bits; 
    }msg;
}CAN38E_;

typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int         : 8 ;
            unsigned int         : 8 ;
            unsigned int   : 8 ;       
            unsigned int         : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
            unsigned int  MMCU_AccumulatedWorkHour_H                         : 8 ;
            unsigned int  MMCU_AccumulatedWorkHour_L                         : 8 ;
        }bits; 
    }msg;
}CAN339_;

typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int MBMS_TOTALSigCharg        : 1 ;
            unsigned int MBMS_TOTALSigAcc        : 1 ;
            unsigned int         : 5 ;
            unsigned int         : 1;
            unsigned int         : 8 ;
            unsigned int         : 8 ;
            unsigned int  : 8 ;       
            unsigned int         : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
        }bits; 
    }msg;
}CAN18202922_;

typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int MBMS_StatBattWorkState       : 4 ;
            unsigned int         : 4;
            unsigned int MBMS_StatBattChargeState        : 3 ;
            unsigned int         : 5 ;
            unsigned int  : 8 ;       
            unsigned int         : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
        }bits; 
    }msg;
}CAN18203220_;
 
//TCS_37B ID:37B
typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 2 ;
            unsigned int TCS_Warning_Lamp          : 1 ;
            unsigned int                           : 1 ;
            unsigned int TCS_Work_Mode             : 4 ;       
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
            unsigned int                           : 8 ;
        }bits; 
    }msg;
}TCS_37B_;

//ECU_401 ID:101 new
typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int                     : 8 ;
            unsigned int                     : 8 ;
            unsigned int  ECU_Battery_Voltage: 8 ;
            unsigned int                     : 8 ;
            unsigned int                     : 8 ;       
            unsigned int                     : 8 ;
            unsigned int                     : 8 ;
            unsigned int                     : 8 ;
        }bits; 
    }msg;
}ECU_401_;
//ISG_114 ID:114
typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int ISG_DTC_Sum         : 8 ;
            unsigned int ISG_DTC_SSCU        : 8 ;
            unsigned int ISG_DTC_ACG         : 8 ;
            unsigned int ISG_DTC_START_H     : 8 ;
            unsigned int                     : 8 ;       
            unsigned int ISG_DTC_ISTOP_H     : 8 ;
            unsigned int                     : 8 ;
            unsigned int                     : 8 ;
        }bits; 
    }msg;
}ECU_114_;
//0x12B
typedef struct
{ 
    union
    {  
        uint8_t data[8];
        struct
        {   
            unsigned int   Front_Speed_H     : 8 ;
            unsigned int   Front_Speed_L     : 8 ;
            unsigned int                     : 8 ;
            unsigned int                     : 8 ;
            unsigned int                     : 4 ;  
            unsigned int   FrontWheelSpeedValidity      : 1 ;  
            unsigned int                     : 3 ;   
            unsigned int                     : 8 ;
            unsigned int                     : 8 ;
            unsigned int                     : 8 ;
        }bits; 
    }msg;
}ECU_12B_;



EXTERN_VAR     volatile CGW_PC1_            CGW_PC1;

EXTERN_VAR     volatile CGW_PC11_            CGW_PC11;
EXTERN_VAR     volatile SMKmsg20_            SMKmsg20;
EXTERN_VAR     volatile SMKmsg19_            SMKmsg19;
EXTERN_VAR     volatile ISG_111_             ISG_111;
EXTERN_VAR     volatile SMKmsg17_            SMKmsg17;
EXTERN_VAR     volatile SMKmsg01_            SMKmsg01;
EXTERN_VAR     volatile BCMmsgDvp1_          BCMmsgDvp1;
EXTERN_VAR     volatile BCMmsg24_            BCMmsg24;
EXTERN_VAR     volatile BCMmsg22_            BCMmsg22;
EXTERN_VAR     volatile BCMmsg21_            BCMmsg21;
EXTERN_VAR     volatile BCMmsg20_            BCMmsg20;
EXTERN_VAR     volatile BCMmsg19_            BCMmsg19;
EXTERN_VAR     volatile BCMmsg18_            BCMmsg18;
EXTERN_VAR     volatile BCMmsg17_            BCMmsg17;
EXTERN_VAR     volatile BCMmsg01_            BCMmsg01;
EXTERN_VAR     volatile BCMGst_              BCMGst;
EXTERN_VAR     volatile FCA12_               FCA12;
EXTERN_VAR     volatile TPMS11_              TPMS11;
EXTERN_VAR     volatile TCU14_               TCU14;
EXTERN_VAR     volatile TCU13_               TCU13;
EXTERN_VAR     volatile TCU11_               TCU11;
EXTERN_VAR     volatile SAS11_               SAS11;
EXTERN_VAR     volatile MDPS11_              MDPS11;
EXTERN_VAR     volatile LKA12_               LKA12;
EXTERN_VAR     volatile LKA11_               LKA11;
EXTERN_VAR     volatile FCA11_               FCA11;
EXTERN_VAR     volatile TCS15_               TCS15;
EXTERN_VAR     volatile TCS11_               TCS11;
EXTERN_VAR     volatile ESP12_               ESP12;
EXTERN_VAR     volatile EMS_H12_             EMS_H12;
EXTERN_VAR     volatile EMS20_               EMS20;
EXTERN_VAR     volatile EMS19_               EMS19;
EXTERN_VAR     volatile CGW_PC2_             CGW_PC2;             
EXTERN_VAR     volatile CGW4_                CGW4;        
EXTERN_VAR     volatile EMS16_               EMS16;
EXTERN_VAR     volatile EMS14_               EMS14;
EXTERN_VAR     volatile EMS12_               EMS12;
EXTERN_VAR     volatile EMS11_               EMS11;
EXTERN_VAR     volatile DATC13_              DATC13;
EXTERN_VAR     volatile DATC11_              DATC11;
EXTERN_VAR     volatile ACU14_               ACU14;
EXTERN_VAR     volatile ACU13_               ACU13;
EXTERN_VAR     volatile WHL_SPD11_           WHL_SPD11;
EXTERN_VAR     volatile ABS11_               ABS11;
EXTERN_VAR     volatile SCC11_               SCC11;
EXTERN_VAR     volatile SCC12_               SCC12;
EXTERN_VAR     volatile SCC14_               SCC14;
EXTERN_VAR     volatile HDA11_               HDA11;
EXTERN_VAR     volatile CLU19_               CLU19;
EXTERN_VAR     volatile CLU16_               CLU16;
EXTERN_VAR     volatile CGW_PC4_             CGW_PC4;           
EXTERN_VAR     volatile EPB11_               EPB11;                
EXTERN_VAR     volatile TCUA3_               CGW_USM1;
EXTERN_VAR     volatile CLU15_               CLU15;
EXTERN_VAR     volatile CLU12_               CLU12;
EXTERN_VAR     volatile CLU11_               CLU11;
EXTERN_VAR     volatile CGW6_                CGW6;
EXTERN_VAR     volatile CGW2_                CGW2;
EXTERN_VAR     volatile CGW1_                CGW1; 
EXTERN_VAR     volatile CGW_PC5_             CGW_PC5;           
EXTERN_VAR     volatile CGW_PC6_             CGW_PC6; 
EXTERN_VAR     volatile CGW_PC12_             CGW_PC12; 
EXTERN_VAR     volatile PAS11_               PAS11;  
EXTERN_VAR     volatile CGW5_                CGW5; 
EXTERN_VAR     volatile CGW7_                CGW7; 
EXTERN_VAR     volatile EVP11_               EVP11; 
EXTERN_VAR     volatile TCS_125_             TCS_125; 
EXTERN_VAR     volatile ECU_402_             ECU_402; 
EXTERN_VAR     volatile ECU_101_             ECU_101;
EXTERN_VAR     volatile TCS_37B_             TCS_37B;
EXTERN_VAR     volatile ECU_401_             ECU_401;
EXTERN_VAR     volatile ECU_114_             ECU_114;
EXTERN_VAR     volatile ECU_12B_             ECU_12B;
EXTERN_VAR     volatile QS_341_              QS_341;
EXTERN_VAR     volatile TBOX_                TBOX;
EXTERN_VAR     volatile SOC2_                   SOC2;
EXTERN_VAR     volatile SOC1_                   SOC1;
EXTERN_VAR     volatile CAN125_                 CAN125;
EXTERN_VAR     volatile CAN157_                 CAN157;
EXTERN_VAR     volatile CAN38E_                 CAN38E;
EXTERN_VAR     volatile CAN339_                 CAN339;
EXTERN_VAR     volatile CAN18202922_            CAN18202922;
EXTERN_VAR     volatile CAN18203220_            CAN18203220;
//EXTERN_VAR     volatile Send_111_             Send_111 ;


EXTERN_VAR     volatile HU_BLE_PE_00_        HU_BLE_PE_00;
EXTERN_VAR     volatile EMS_H11_             EMS_H11;
EXTERN_VAR     volatile AHB1_                AHB1;
EXTERN_VAR     volatile HU_CLU_PE_05_        HU_CLU_PE_05;

EXTERN_VAR     volatile ECU_Engine_Data_M2_  ECU_Engine_Data_M2;

EXTERN_VAR     volatile HU_MON_PE_01_        HU_MON_PE_01;
EXTERN_VAR     volatile HU_USM_E_04_	     HU_USM_E_04;
EXTERN_VAR     volatile HU_USM_E_05_	     HU_USM_E_05;
EXTERN_VAR     volatile HU_CLU_PE_06_        HU_CLU_PE_06;
EXTERN_VAR     volatile HU_USM_E_01_         HU_USM_E_01;
EXTERN_VAR     volatile BCW11_                   BCW11;
EXTERN_VAR     volatile CGW_PC8_                 CGW_PC8;
EXTERN_VAR     volatile CGW_PC3_                 CGW_PC3;
EXTERN_VAR     volatile  HU_GW_PE_01_          HU_GW_PE_01;
EXTERN_VAR     volatile  BCA11_                BCA11;
EXTERN_VAR     volatile  P_STS_                P_STS;
EXTERN_VAR     volatile Send_7DF_ectype      Send_7DF_ectype_Data ;//LHY  






EXTERN_VAR     volatile Send_7DF             Send_7DF_Data ;//LHY  
EXTERN_VAR     volatile Send_7C6             Send_7C6_Data ;//LHY 
EXTERN_VAR     volatile Receive_7CE          Receive_7CE_Data ;//LHY
EXTERN_VAR     volatile Receive_7CE          Receive_709_Data ;//LHY

EXTERN_VAR     volatile Send_null             Send_420 ;//LHY  
EXTERN_VAR     volatile Send_null             Send_490 ;//LHY 
EXTERN_VAR     volatile Send_null             Send_381 ;//LHY  
EXTERN_VAR     volatile Send_null             Send_507 ;//LHY 
EXTERN_VAR     volatile Send_null             Send_593 ;//LHY  
EXTERN_VAR     volatile Send_null             Send_340 ;//LHY 
EXTERN_VAR     volatile Send_null             Send_500 ;//LHY  
EXTERN_VAR     volatile Send_null             Send_586 ;//LHY  

//EXTERN_VAR     volatile Send_111_             Send_111 ;//LHY 

EXTERN_VAR     volatile WPCmsg03_            WPCmsg03;
EXTERN_VAR     volatile Send_Data            Send_7CE_Data;
EXTERN_VAR     volatile Send_Data            Send_701_Data;
EXTERN_VAR     volatile CLU_HU_PE_01_		CLU_HU_PE_01;
EXTERN_VAR     volatile CLU_HU_PE_05_		CLU_HU_PE_05;
EXTERN_VAR     volatile HU_CLU_PE_02_		HU_CLU_PE_02;
EXTERN_VAR     volatile HU_CLU_P_03_         HU_CLU_P_03;



EXTERN_VAR  void Can_Clear(uint8_t *data);

#pragma pack()
#endif /* API_CAN_H_ */