/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_CRC_H
#define __S6J3360_CRC_H

#include "s6j3360io_basetypes.h"

/* CRC[00-03] base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define CRC00	stcCRC[0]
#define CRC01	stcCRC[1]
#define CRC02	stcCRC[2]
#define CRC03	stcCRC[3]
#else /* __IO_DEFINE */
#define CRC00	(*((volatile stc_crcn_t*)0xB4718000))
#define CRC01	(*((volatile stc_crcn_t*)0xB4718400))
#define CRC02	(*((volatile stc_crcn_t*)0xB4718800))
#define CRC03	(*((volatile stc_crcn_t*)0xB4718C00))
#endif /* __IO_DEFINE */

/* CRCCR */
#define CRC00_CRCCR	(CRC00.unCRCCR.u8Register)  /*@rg@*/
#define CRC00_CRCCR_INIT	(CRC00.unCRCCR.stcField.u1INIT)  /*@bf@*/
#define CRC00_CRCCR_CRC32	(CRC00.unCRCCR.stcField.u1CRC32)  /*@bf@*/
#define CRC00_CRCCR_LTLEND	(CRC00.unCRCCR.stcField.u1LTLEND)  /*@bf@*/
#define CRC00_CRCCR_LSBFST	(CRC00.unCRCCR.stcField.u1LSBFST)  /*@bf@*/
#define CRC00_CRCCR_CRCLTE	(CRC00.unCRCCR.stcField.u1CRCLTE)  /*@bf@*/
#define CRC00_CRCCR_CRCLSF	(CRC00.unCRCCR.stcField.u1CRCLSF)  /*@bf@*/
#define CRC00_CRCCR_FXOR	(CRC00.unCRCCR.stcField.u1FXOR)  /*@bf@*/

#define CRC01_CRCCR	(CRC01.unCRCCR.u8Register)  /*@rg@*/
#define CRC01_CRCCR_INIT	(CRC01.unCRCCR.stcField.u1INIT)  /*@bf@*/
#define CRC01_CRCCR_CRC32	(CRC01.unCRCCR.stcField.u1CRC32)  /*@bf@*/
#define CRC01_CRCCR_LTLEND	(CRC01.unCRCCR.stcField.u1LTLEND)  /*@bf@*/
#define CRC01_CRCCR_LSBFST	(CRC01.unCRCCR.stcField.u1LSBFST)  /*@bf@*/
#define CRC01_CRCCR_CRCLTE	(CRC01.unCRCCR.stcField.u1CRCLTE)  /*@bf@*/
#define CRC01_CRCCR_CRCLSF	(CRC01.unCRCCR.stcField.u1CRCLSF)  /*@bf@*/
#define CRC01_CRCCR_FXOR	(CRC01.unCRCCR.stcField.u1FXOR)  /*@bf@*/

#define CRC02_CRCCR	(CRC02.unCRCCR.u8Register)  /*@rg@*/
#define CRC02_CRCCR_INIT	(CRC02.unCRCCR.stcField.u1INIT)  /*@bf@*/
#define CRC02_CRCCR_CRC32	(CRC02.unCRCCR.stcField.u1CRC32)  /*@bf@*/
#define CRC02_CRCCR_LTLEND	(CRC02.unCRCCR.stcField.u1LTLEND)  /*@bf@*/
#define CRC02_CRCCR_LSBFST	(CRC02.unCRCCR.stcField.u1LSBFST)  /*@bf@*/
#define CRC02_CRCCR_CRCLTE	(CRC02.unCRCCR.stcField.u1CRCLTE)  /*@bf@*/
#define CRC02_CRCCR_CRCLSF	(CRC02.unCRCCR.stcField.u1CRCLSF)  /*@bf@*/
#define CRC02_CRCCR_FXOR	(CRC02.unCRCCR.stcField.u1FXOR)  /*@bf@*/

#define CRC03_CRCCR	(CRC03.unCRCCR.u8Register)  /*@rg@*/
#define CRC03_CRCCR_INIT	(CRC03.unCRCCR.stcField.u1INIT)  /*@bf@*/
#define CRC03_CRCCR_CRC32	(CRC03.unCRCCR.stcField.u1CRC32)  /*@bf@*/
#define CRC03_CRCCR_LTLEND	(CRC03.unCRCCR.stcField.u1LTLEND)  /*@bf@*/
#define CRC03_CRCCR_LSBFST	(CRC03.unCRCCR.stcField.u1LSBFST)  /*@bf@*/
#define CRC03_CRCCR_CRCLTE	(CRC03.unCRCCR.stcField.u1CRCLTE)  /*@bf@*/
#define CRC03_CRCCR_CRCLSF	(CRC03.unCRCCR.stcField.u1CRCLSF)  /*@bf@*/
#define CRC03_CRCCR_FXOR	(CRC03.unCRCCR.stcField.u1FXOR)  /*@bf@*/

typedef struct stc_crcn_crccr_field{
    uint_io8_t		u1INIT:1;
    uint_io8_t		u1CRC32:1;
    uint_io8_t		u1LTLEND:1;
    uint_io8_t		u1LSBFST:1;
    uint_io8_t		u1CRCLTE:1;
    uint_io8_t		u1CRCLSF:1;
    uint_io8_t		u1FXOR:1;
    uint_io8_t		:1;
}stc_crcn_crccr_field_t;

typedef union un_crcn_crccr{
    uint_io8_t		u8Register;
    stc_crcn_crccr_field_t		stcField;
}un_crcn_crccr_t;

/* CRCINIT */
#define CRC00_CRCINIT	(CRC00.unCRCINIT.u32Register)  /*@rg@*/
#define CRC00_CRCINIT_D	CRC00_CRCINIT  /*@bfrg@*/

#define CRC01_CRCINIT	(CRC01.unCRCINIT.u32Register)  /*@rg@*/
#define CRC01_CRCINIT_D	CRC01_CRCINIT  /*@bfrg@*/

#define CRC02_CRCINIT	(CRC02.unCRCINIT.u32Register)  /*@rg@*/
#define CRC02_CRCINIT_D	CRC02_CRCINIT  /*@bfrg@*/

#define CRC03_CRCINIT	(CRC03.unCRCINIT.u32Register)  /*@rg@*/
#define CRC03_CRCINIT_D	CRC03_CRCINIT  /*@bfrg@*/

typedef union un_crcn_crcinit{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_crcn_crcinit_t;

/* CRCIN */
#define CRC00_CRCIN	(CRC00.unCRCIN.u32Register)  /*@rg@*/
#define CRC00_CRCIN_D	CRC00_CRCIN  /*@bfrg@*/

#define CRC01_CRCIN	(CRC01.unCRCIN.u32Register)  /*@rg@*/
#define CRC01_CRCIN_D	CRC01_CRCIN  /*@bfrg@*/

#define CRC02_CRCIN	(CRC02.unCRCIN.u32Register)  /*@rg@*/
#define CRC02_CRCIN_D	CRC02_CRCIN  /*@bfrg@*/

#define CRC03_CRCIN	(CRC03.unCRCIN.u32Register)  /*@rg@*/
#define CRC03_CRCIN_D	CRC03_CRCIN  /*@bfrg@*/

typedef union un_crcn_crcin{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_crcn_crcin_t;

/* CRCR */
#define CRC00_CRCR	(CRC00.unCRCR.u32Register)  /*@rg@*/
#define CRC00_CRCR_D	CRC00_CRCR  /*@bfrg@*/

#define CRC01_CRCR	(CRC01.unCRCR.u32Register)  /*@rg@*/
#define CRC01_CRCR_D	CRC01_CRCR  /*@bfrg@*/

#define CRC02_CRCR	(CRC02.unCRCR.u32Register)  /*@rg@*/
#define CRC02_CRCR_D	CRC02_CRCR  /*@bfrg@*/

#define CRC03_CRCR	(CRC03.unCRCR.u32Register)  /*@rg@*/
#define CRC03_CRCR_D	CRC03_CRCR  /*@bfrg@*/

typedef union un_crcn_crcr{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_crcn_crcr_t;


typedef struct stc_crcn{
    un_crcn_crccr_t	unCRCCR;	/* 0x00000000 */
    uint_io8_t	au8Reserved0[3];	/* 0x00000001 */
    un_crcn_crcinit_t	unCRCINIT;	/* 0x00000004 */
    un_crcn_crcin_t	unCRCIN;	/* 0x00000008 */
    un_crcn_crcr_t	unCRCR;	/* 0x0000000C */
    uint_io8_t	au8Reserved1[1008];	/* 0x00000010 */
}stc_crcn_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_crcn_t	stcCRC[4];
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 1024(0x400) bytes */


#endif /* __S6J3360_CRC_H */
