#define GLOBALS_BSP_TPM
#include "../app_Headers/g_includes.h"


/*-------------------------------------------------------------------------
* Function Name  : bsp_Timer0_Init
* Description    : ʱ0ʼ
* Input          : 
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void bsp_Timer0_Init(INT8U TPM_DIV)
{
    
    TIM0_TSCR1_TSWAI = Enable;   //timer 0 MCUȴģʽ²
    TIM0_TSCR1_TSWAI = WaitRun;
    TIM0_TSCR1_TSFRZ = Enable;   //timer 0 ڶģʽ½ֹ
    TIM0_TSCR1_TFFCA = Disable;  //־λ
    TIM0_TSCR1_PRNT  = Disable;  // 
    TIM0_TSCR2_PR    = TPM_DIV;  //Bus g_Clock / 4
    TIM0_TSCR2_TCRE  = Disable;
    TIM0_TTOV        = Disable;

    TIM0_TCTL1 = Disable;        //ֹȽϹ
    TIM0_TCTL2 = Disable;
    TIM0_TCTL3 = Disable;        //ֹȽϹ
    TIM0_TCTL4 = Disable; 
        
    TIM0_TFLG2_TOF   = Enable;
    TIM0_TSCR1_TEN   = Enable;   //ʹtimer 0 
    TIM0_TSCR2_TOI   = Enable;   //жʹ
    
}
/*-------------------------------------------------------------------------
* Function Name  : bsp_Timer1_Init
* Description    : ʱ1ʼ
* Input          : 
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
void bsp_Timer1_Init(INT8U TPM_DIV)
{

    TIM1_TSCR1_TSWAI = Enable;   //timer 0 MCUȴģʽ²
    TIM1_TSCR1_TSFRZ = Enable;   //timer 0 ڶģʽ½ֹ
    TIM1_TSCR1_TFFCA = Disable;  //־λ
    TIM1_TSCR1_PRNT  = Disable;  // 
    TIM1_TSCR2_PR    = TPM_DIV; //Bus g_Clock / 4
    TIM1_TSCR2_TCRE  = Disable;
    TIM1_TTOV        = Disable;

    TIM1_TCTL1 = Disable;        //ֹȽϹ
    TIM1_TCTL2 = Disable;
    TIM1_TCTL3 = Disable;        //ֹȽϹ
    TIM1_TCTL4 = Disable; 
    
    TIM1_TFLG2_TOF   = Enable;
    TIM1_TSCR1_TEN   = Enable;   //ʹtimer 0 
    TIM1_TSCR2_TOI   = Enable;   //жʹ
    

}

/*-------------------------------------------------------------------------
* Function Name  : bsp_Timer0_isr
* Description    : ʱж
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
interrupt void bsp_Timer0_isr(void)
{
    if((CANRFLG_RSTAT == 0x03)||(CANRFLG_TSTAT == 0x03))
    {
        if(g_busOffTime == null) 
        {                       
            g_busOffTime = TT_200ms;
            CANMISC_BOHOLD = ClearFlag;                                                 
        }  
        if(g_busOffTime > null)
        {
             g_busOffTime--;                 
        }         
    }  
    
    if(g_Clock.TEnable1)
    {
        if(g_Clock.Time1 < g_Clock.OverTime1)
        {
            g_Clock.Time1++;
        }
    }      
    if(g_Clock.TEnable0)
    {
        if(g_Clock.Time0 < g_Clock.OverTime0)
        {
            g_Clock.Time0++;
        }
    }

    if(g_Clock.TEnable2)
    {
        if(g_Clock.Time2 < g_Clock.OverTime2)
        {
            g_Clock.Time2++;
        }
    }
    if(g_Clock.TEnable3)
    {
        if(g_Clock.Time3 < g_Clock.OverTime3)
        {
            g_Clock.Time3++;
        }
    }
    if(g_Clock.TEnable4)
    {
        if(g_Clock.Time4 < g_Clock.OverTime4)
        {
            g_Clock.Time4++;
        }
    }
    if(g_Clock.TEnable5)
    {
        if(g_Clock.Time5 < g_Clock.OverTime5)
        {
            g_Clock.Time5++;
        }
    }
    if(g_Clock.TEnable6)
    {
        if(g_Clock.Time6 < g_Clock.OverTime6)
        {
            g_Clock.Time6++;
        }
    }
    if(g_Clock.TEnable7)
    {
        if(g_Clock.Time7 < g_Clock.OverTime7)
        {
            g_Clock.Time7++;
        }
    }
    
    if(TxDelayTime > 0)
    {
      TxDelayTime--;
    }

      
    TIM0_TFLG2_TOF = ClearFlag;  //жϱ־λ
}
/*-------------------------------------------------------------------------
* Function Name  : bsp_Timer1_isr
* Description    : ʱж
* Input          : None
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
interrupt void bsp_Timer1_isr(void)
{
  
    TIM1_TFLG2_TOF = ClearFlag;  //жϱ־λ
}
/*-------------------------------------------------------------------------
* Function Name  : VehCap_isr
* Description    : 벶׽
* Input          : 
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
interrupt void VehCap_isr(void)
{

    TIM1_TFLG1_C7F = ClearFlag;
}

/*-------------------------------------------------------------------------
* Function Name  : RevCap_isr
* Description    : 벶׽
* Input          : 
* Output         : None
* Return         : None
* onther         : 
--------------------------------------------------------------------------*/
interrupt void RevCap_isr(void)
{

    TIM0_TFLG1_C7F = ClearFlag;
}

/*-------------------------------------------------------------------------
* Function Name  : Api_SetTimer
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Api_SetTimer(INT16U Second, _Clock *T)
{
    T->TEnable = Enable;
    T->OverTime = Second;
    T->Time = null;
}
/*-------------------------------------------------------------------------
* Function Name  : Api_TimerOver
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
INT8U Api_TimerOver(_Clock *T)
{
    if((T->Time >= T->OverTime) && (T->TEnable))
    {
        T->TEnable = Disable;
        return 1;
    }
    else
    {
        return 0;
    }
}
