/*
 * API_Device_Init.h
 *
 *  Created on: 2012-3-27
 *      Author: arno.qi
 */

#ifdef        GLOBALS_BSP_SYS
    #define   EXTERN_BSP_SYS
    
#else
    #define   EXTERN_BSP_SYS     extern
#endif

#ifndef API_DEVICE_INIT_H_
#define API_DEVICE_INIT_H_

    #define     NormalChip               0x80
    #define     SpecialChip              0x00
    #define     InitDIRECT               0          
    #define     InitIVBR                 0xFF
    #define     InitCPMUPROT             0x26
    #define     InitCPMUCLKS             0x87
    #define     InitCPMUREFDIV           0x40
    #define     InitCPMUSYNR             0x47 //0X47 4M;  8M 0X43
    #define     InitCPMUPOSTDIV          0x00
    #define     InitCPMUPLL              0
    #define     InitPUCR                 0x40
    #define     InitCPMUCOP              0x07 
    #define     Enable                   1
    #define     Disable                  0
    #define     WaitRun                  0
    #define     null                     0
    #define     one                      1
    #define     ClearFlag                1
    #define     clear                    0
    #define     True                     1
    #define     false                    0
    #define     PushDown                 0
    #define     UpSpring                 1
    #define     BusClock                 32000000 //16777216
    #define     SafetyVeh                10 *64
    #define     Prio1                    1 
    #define     Prio2                    2  
    #define     Prio3                    3  
    #define     Prio4                    4  
    #define     Prio5                    5   
    #define     Prio6                    6 
    #define     Prio7                    7    
    
    
    #define     CSB_PER                  PWMPER2 
    #define     ZSB_PER                  PWMPER3       

                     
    EXTERN_BSP_SYS     void    bsp_Sys_Init(void);
    EXTERN_BSP_SYS     void    bsp_Clock_Init(void);
    
    
    
    
EXTERN_BSP_SYS    interrupt   void      bsp_API_isr(void);


void Api_API_Init(INT8U tog);
void GJ_CS10_JS_ECUOUT_N(void);


#endif 
