/******************************************************************************
 * $Revision: 423 $
 * $Date:: 2017-04-07 16:03:30 +0900#$
 *****************************************************************************/
/* __DISCLAIMER_START__                                                      */
/******************************************************************************
* (c)2017, Cypress Semiconductor Corporation
* or a subsidiary of Cypress Semiconductor Corporation. All rights
* reserved.
*
* This software, including source code, documentation and related
* materials ( "Software" ), is owned by Cypress Semiconductor
* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
* and subject to worldwide patent protection (United States and foreign),
* United States copyright laws and international treaty provisions.
* Therefore, you may use this Software only as provided in the license
* agreement accompanying the software package from which you
* obtained this Software ( "EULA" ).
*
* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
* non-transferable license to copy, modify, and compile the
* Software source code solely for use in connection with Cypress' s
* integrated circuit products. Any reproduction, modification, translation,
* compilation, or representation of this Software except as specified
* above is prohibited without the express written permission of Cypress.
*
* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE. Cypress reserves the right to make
* changes to the Software without notice. Cypress does not assume any
* liability arising out of the application or use of the Software or any
* product or circuit described in the Software. Cypress does not
* authorize its products for use in any products where a malfunction or
* failure of the Cypress product may reasonably be expected to result in
* significant property damage, injury or death ( "High Risk Product" ). By
* including Cypress' s product in a High Risk Product, the manufacturer
* of such system or application assumes all risk of such use and in doing
* so agrees to indemnify Cypress against all liability.
******************************************************************************/
/* __DISCLAIMER_END__                                                        */
/*****************************************************************************
 ** \file mfs_uart_generated.c
 **
 ** Generated file for uart.c module, including variables and functions
 ** for internal data and interrupt handling. The individual ISRs for each
 ** peripheral are calling the generic handler in mfs_uart.c.
 **
 ** \note This file must not be added to the build files - it will be included
 **       by mfs_uart.c automatically!
 **
 ** History:
 **   - 2014-06-26  0.01  HS  Initial version for Traveo
 **   - 2015-09-09  0.02  ST  Fixed interrupt enable/disable to use the bit band unit
 *****************************************************************************/

#ifndef __MFS_UART_GENERATED_C__
#define __MFS_UART_GENERATED_C__

/*****************************************************************************/
/* Include files                                                             */
/*****************************************************************************/
#include "common_include.h"
#include "mfs_uart.h"

/*****************************************************************************/
/* Local pre-processor symbols/macros ('#define')                            */
/*****************************************************************************/

/** Macro to return the number of enabled UART instances */
#define UART_INSTANCE_COUNT (uint32_t)(sizeof(m_astcUartInstanceDataLut) / sizeof(m_astcUartInstanceDataLut[0]))

/*****************************************************************************/
/* Global variable definitions (declared in header file with 'extern')       */
/*****************************************************************************/


/*****************************************************************************/
/* Local type definitions ('typedef')                                        */
/*****************************************************************************/

/// Enumeration to define an index for each enabled UART instance
typedef enum en_uart_instance_index
{
    UartInstanceIndexUart0,
    UartInstanceIndexUart1,
    UartInstanceIndexUart2,
    UartInstanceIndexUart3,
    UartInstanceIndexUart4,
    UartInstanceIndexUart5,
    UartInstanceIndexUart6,
    UartInstanceIndexUart7,
    UartInstanceIndexUart8,
    UartInstanceIndexUart9,
    UartInstanceIndexUart10,
    UartInstanceIndexUart11,
    UartInstanceIndexMax
} en_uart_instance_index_t;
    
/** UART instance data type */
typedef struct stc_uart_instance_data
{
    pstc_uart_type_t       pstcInstance;          /*!< pointer to registers of an instance */
    stc_uart_intern_data_t stcInternData;         /*!< module internal data of instance */
    u8_uart_int_t*         pu8TxIntEnable;        /*!< Transmission interrupt enable (Bit Band Unit) */
    u8_uart_int_t*         pu8RxIntEnable;        /*!< Reception interrupt enable (Bit Band Unit) */
} stc_uart_instance_data_t;

/*****************************************************************************/
/* Local variable definitions ('static')                                     */
/*****************************************************************************/

/** Look-up table for all enabled UART instances and their internal data */
static stc_uart_instance_data_t m_astcUartInstanceDataLut[UartInstanceIndexMax] =
{
    {UART0_Type, {NULL}, &UART0_TIE, &UART0_RIE},/* pstcInstance *//* stc_uart_intern_data_t *//* pu8TxIntEnable *//* pu8RxIntEnable */
    {UART1_Type, {NULL}, &UART1_TIE, &UART1_RIE},
    {UART2_Type, {NULL}, &UART2_TIE, &UART2_RIE},
    {UART3_Type, {NULL}, &UART3_TIE, &UART3_RIE},
    {UART4_Type, {NULL}, &UART4_TIE, &UART4_RIE},
    {UART5_Type, {NULL}, &UART5_TIE, &UART5_RIE},
    {UART6_Type, {NULL}, &UART6_TIE, &UART6_RIE},
    {UART7_Type, {NULL}, &UART7_TIE, &UART7_RIE},
    {UART8_Type, {NULL}, &UART8_TIE, &UART8_RIE},
    {UART9_Type, {NULL}, &UART9_TIE, &UART9_RIE},
    {UART10_Type, {NULL}, &UART10_TIE, &UART10_RIE},
    {UART11_Type, {NULL}, &UART11_TIE, &UART11_RIE},
};

/*****************************************************************************/
/* Local function prototypes ('static')                                      */
/*****************************************************************************/

/*****************************************************************************/
/* Function implementation - global ('extern') and local ('static')          */
/*****************************************************************************/

/**
 ******************************************************************************
 ** \brief Return the internal data for a certain UART instance.
 **
 ** \param pstcUart Pointer to UART instance
 **
 ** \return Pointer to internal data or NULL if instance is not enabled (or not known)
 **
 ******************************************************************************/
stc_uart_intern_data_t* MfsUartGetInternDataPtr(pstc_uart_type_t pstcUart)
{
    stc_uart_intern_data_t *pstcInternData = NULL;
    uint32_t                u32Instance;

    if (pstcUart != NULL)
    {
        for (u32Instance = 0; u32Instance < (uint32_t)UartInstanceIndexMax; u32Instance++)
        {
            if (pstcUart == m_astcUartInstanceDataLut[u32Instance].pstcInstance)
            {
                pstcInternData = &m_astcUartInstanceDataLut[u32Instance].stcInternData;
                break;
            }
        }
    }

    return pstcInternData;
}

/**
 ******************************************************************************
 ** \brief Return Transmission interrupt enable (Bit Band Unit).
 **
 ** \param pstcUart Pointer to UART instance
 **
 ** \return pointer to Transmission interrupt enable register
 **
 ******************************************************************************/
u8_uart_int_t* MfsUartGetTIE(pstc_uart_type_t pstcUart)
{
    u8_uart_int_t*          pu8TxIntEnable;
    uint32_t                u32Instance;

    if (pstcUart != NULL)
    {
        for (u32Instance = 0; u32Instance < (uint32_t)UartInstanceIndexMax; u32Instance++)
        {
            if (pstcUart == m_astcUartInstanceDataLut[u32Instance].pstcInstance)
            {
                pu8TxIntEnable = m_astcUartInstanceDataLut[u32Instance].pu8TxIntEnable;
                break;
            }
        }
    }

    return pu8TxIntEnable;
}

/**
 ******************************************************************************
 ** \brief Return Reception interrupt enable (Bit Band Unit).
 **
 ** \param pstcUart Pointer to UART instance
 **
 ** \return pointer to Reception interrupt enable register
 **
 ******************************************************************************/
u8_uart_int_t* MfsUartGetRIE(pstc_uart_type_t pstcUart)
{
    u8_uart_int_t*          pu8RxIntEnable;
    uint32_t                u32Instance;

    if (pstcUart != NULL)
    {
        for (u32Instance = 0; u32Instance < (uint32_t)UartInstanceIndexMax; u32Instance++)
        {
            if (pstcUart == m_astcUartInstanceDataLut[u32Instance].pstcInstance)
            {
                pu8RxIntEnable = m_astcUartInstanceDataLut[u32Instance].pu8RxIntEnable;
                break;
            }
        }
    }

    return pu8RxIntEnable;
}



/*
 * Definition of ISR for each enabled UART instance.
 * The individual ISR calls the generic IRQ handler with
 * the instance pointer and its internal data to handle the interrupt.
 */
FN_IRQ_NOT_NESTED void Uart_Isr_Uart0_Rx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_46;
    MfsUartIrqHandlerRx(UART0_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart0].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}
FN_IRQ_NOT_NESTED void Uart_Isr_Uart0_Tx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_47;
    MfsUartIrqHandlerTx(UART0_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart0].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}



FN_IRQ_NOT_NESTED void Uart_Isr_Uart1_Rx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_48;
    MfsUartIrqHandlerRx(UART1_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart1].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}
FN_IRQ_NOT_NESTED void Uart_Isr_Uart1_Tx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_49;
    MfsUartIrqHandlerTx(UART1_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart1].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}



FN_IRQ_NOT_NESTED void Uart_Isr_Uart2_Rx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_50;
    MfsUartIrqHandlerRx(UART2_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart2].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}
FN_IRQ_NOT_NESTED void Uart_Isr_Uart2_Tx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_51;
    MfsUartIrqHandlerTx(UART2_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart2].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}



FN_IRQ_NOT_NESTED void Uart_Isr_Uart3_Rx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_52;
    MfsUartIrqHandlerRx(UART3_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart3].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}
FN_IRQ_NOT_NESTED void Uart_Isr_Uart3_Tx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_53;
    MfsUartIrqHandlerTx(UART3_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart3].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}



FN_IRQ_NOT_NESTED void Uart_Isr_Uart4_Rx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_54;
    MfsUartIrqHandlerRx(UART4_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart4].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}
FN_IRQ_NOT_NESTED void Uart_Isr_Uart4_Tx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_55;
    MfsUartIrqHandlerTx(UART4_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart4].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}



FN_IRQ_NOT_NESTED void Uart_Isr_Uart5_Rx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_56;
    MfsUartIrqHandlerRx(UART5_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart5].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}
FN_IRQ_NOT_NESTED void Uart_Isr_Uart5_Tx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_57;
    MfsUartIrqHandlerTx(UART5_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart5].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}



FN_IRQ_NOT_NESTED void Uart_Isr_Uart6_Rx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_58;
    MfsUartIrqHandlerRx(UART6_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart6].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}
FN_IRQ_NOT_NESTED void Uart_Isr_Uart6_Tx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_59;
    MfsUartIrqHandlerTx(UART6_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart6].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}



FN_IRQ_NOT_NESTED void Uart_Isr_Uart7_Rx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_60;
    MfsUartIrqHandlerRx(UART7_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart7].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}
FN_IRQ_NOT_NESTED void Uart_Isr_Uart7_Tx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_61;
    MfsUartIrqHandlerTx(UART7_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart7].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}



FN_IRQ_NOT_NESTED void Uart_Isr_Uart8_Rx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_62;
    MfsUartIrqHandlerRx(UART8_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart8].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}
FN_IRQ_NOT_NESTED void Uart_Isr_Uart8_Tx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_63;
    MfsUartIrqHandlerTx(UART8_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart8].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}



FN_IRQ_NOT_NESTED void Uart_Isr_Uart9_Rx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_64;
    MfsUartIrqHandlerRx(UART9_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart9].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}
FN_IRQ_NOT_NESTED void Uart_Isr_Uart9_Tx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_65;
    MfsUartIrqHandlerTx(UART9_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart9].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}



FN_IRQ_NOT_NESTED void Uart_Isr_Uart10_Rx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_66;
    MfsUartIrqHandlerRx(UART10_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart10].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}
FN_IRQ_NOT_NESTED void Uart_Isr_Uart10_Tx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_67;
    MfsUartIrqHandlerTx(UART10_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart10].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}



FN_IRQ_NOT_NESTED void Uart_Isr_Uart11_Rx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_68;
    MfsUartIrqHandlerRx(UART11_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart11].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}
FN_IRQ_NOT_NESTED void Uart_Isr_Uart11_Tx(void)
{
    const uint32_t u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN = INTERRUPTS_IRQ_NUMBER_69;
    MfsUartIrqHandlerTx(UART11_Type, &(m_astcUartInstanceDataLut[UartInstanceIndexUart11].stcInternData));
    IRC0_IRQHC = u32IrqNumSetBy_FN_IRQ_DEFINE_BEGIN;
}  // __MFS_UART_GENERATED_C__


#define SAMPLE_UART_TX_BUFFSIZE         (64)
#define SAMPLE_UART_RX_BUFFSIZE         (64)
static uint8_t au8UartTxBuf[SAMPLE_UART_TX_BUFFSIZE];   // TX buffer
static uint8_t au8UartRxBuf[SAMPLE_UART_RX_BUFFSIZE];   // RX buffer

/**
 ******************************************************************************
 ** \brief uart init
 **
 ** \param [in]   ch              channel 
 ** \param [in]   BootRate        bootrate
 ** \param [in]   MSB             TRUE=MSB first, FALSE=LSB first       
 ******************************************************************************/
#if 0
en_result_t UART_init(uint8_t ch, uint32_t BootRate, boolean_t MSB, uart_rx_cb_func_ptr_t Callback)
{
    en_result_t ret = 0;
    stc_uart_config_t stcUartConf = { 0 };
    // Uart configuration
    stcUartConf.u32DataRate = bootrate;                             // baurate
    stcUartConf.bHardwareFlow = FALSE;                              // Not use hardware flow control
    stcUartConf.bTransferDirecton = MSB;                            // LSB first
    stcUartConf.enDataFormat = UartFormatNRZ;                       // NRZ format
    stcUartConf.enDataLength = UartLength8Bits;                     // 8bit length
    stcUartConf.enParity = UartParityNone;                          // No parity
    stcUartConf.enStopBit= UartOneStopBit;                          // 1 stop bit
    stcUartConf.u16TxBufSize = SAMPLE_UART_TX_BUFFSIZE;             // Set buffer size
    stcUartConf.pu8TxBuf = au8UartTxBuf;                            // Set buffer pointer
    stcUartConf.u16RxBufSize = SAMPLE_UART_RX_BUFFSIZE;             // Set buffer size
    stcUartConf.pu8RxBuf = au8UartRxBuf;                            // Set buffer pointer
    stcUartConf.bFifoUsage = TRUE;                                  // use HW FIFO
    stcUartConf.u16RxCbFillLevel = 1;                               // Unread counts of data buffer to call RX Callback function
    stcUartConf.pfnRxCb = Callback;                                 // Rx callback not used
    stcUartConf.pfnTxCb = NULL;                                     // Tx callback not used
    ret = Mfs_Uart_Init(m_astcUartInstanceDataLut[ch].pstcInstance, &stcUartConf);
    return ret;
}
#endif