#ifndef __MW_WMH_COMM_H_
#define __MW_WMH_COMM_H_
#include "TYW_stdint.h"

#define NULL_P (void *)0

typedef enum {
    EM_WMH_COMM_PIN_TX_IDX = 0,
    EM_WMH_COMM_PIN_RX_ID_0x90,
    EM_WMH_COMM_PIN_RX_ID_wibox,
    EM_WMH_COMM_PIN_TOTAL,
} EM_WMH_COMM_PIN_T;

// static const IO_NUM_ENUM mwWMHCommPin[EM_WMH_COMM_PIN_TOTAL] = {
//     IO_NUM_MCU_ONE_LINE_COMM_TX,
//     IO_NUM_MCU_ONE_LINE_COMM_RX,
// };

typedef enum {
    EM_WMH_COMM_FRAME_STANDBAY = 0,
    EM_WMH_COMM_FRAME_START,
    EM_WMH_COMM_FRAME_LOGIC_1,
    EM_WMH_COMM_FRAME_LOGIC_0,
    EM_WMH_COMM_FRAME_STOP,

    EM_WMH_COMM_FRAME_TOTAL,
} EM_WMH_COMM_FRAME_T;

typedef struct {
    uint32_t LowLevelTime;  // us
    uint32_t HighLevelTime; // us
} MW_WMH_COMM_TIMER_T;

typedef struct {
    MW_WMH_COMM_TIMER_T Standard;
    MW_WMH_COMM_TIMER_T UpperLimit;
    MW_WMH_COMM_TIMER_T LowerLimit;
} MW_WMH_COMM_SEQUENTIAL_T;

extern void mwWMHCommInit(void);
extern void mwWMHCommRecvIsr_0x90(uint32_t tmpCnts);
extern void mwWMHCommRecvIsr_wibox(uint32_t tmpCnts);
extern void mwWMHCommSendIsr(uint32_t tmpCnts);
extern void mwWMHCommTransmitBytes(uint8_t *data, uint32_t length);
extern uint8_t *mwWMHCommGetRecvData(uint32_t *BufferLen, uint32_t *RecvPos);
extern void mwWMHCommRecvByte_0x90(uint8_t data);
extern void mwWMHCommRecvByte_wibox(uint8_t data);



#endif
