#define  GLOBALS_BSP_MOTOR
#include "common_include.h"

void     Set_SMC_ClkDiv(stc_smcn_t* psmc_cofig,uint8_t div);
/*************************************************
Function:       // Set_SMC_ClkDiv
Description:    // ����ʱ�ӷ�Ƶ
Input:          //
Output:         // ��
Return:         // ��
Others:         // ����˵��
*************************************************/
void Set_SMC_ClkDiv(stc_smcn_t* psmc_cofig,uint8_t div)
{
    switch(div)
    {
        case 2:
            psmc_cofig->unPWC.stcField.u3P2_0 = 0;
            psmc_cofig->unPWC.stcField.u1P3 = 1;
            break;
        case 4:
            psmc_cofig->unPWC.stcField.u3P2_0 = 1;
            psmc_cofig->unPWC.stcField.u1P3 = 0;
            break;
        case 5:
            psmc_cofig->unPWC.stcField.u3P2_0 = 2;
            psmc_cofig->unPWC.stcField.u1P3 = 0;
            break;
        case 8:
            psmc_cofig->unPWC.stcField.u3P2_0 = 4;
            psmc_cofig->unPWC.stcField.u1P3 = 0;
            break;
        case 10:
            psmc_cofig->unPWC.stcField.u3P2_0 = 5;
            psmc_cofig->unPWC.stcField.u1P3 = 0;
            break;
        case 12:
            psmc_cofig->unPWC.stcField.u3P2_0 = 6;
            psmc_cofig->unPWC.stcField.u1P3 = 0;
            break;
        case 16:
            psmc_cofig->unPWC.stcField.u3P2_0 = 7;
            psmc_cofig->unPWC.stcField.u1P3 = 0;
            break;
        case 20:
            psmc_cofig->unPWC.stcField.u3P2_0 = 5;
            psmc_cofig->unPWC.stcField.u1P3 = 1;
            break;
        case 24:
            psmc_cofig->unPWC.stcField.u3P2_0 = 6;
            psmc_cofig->unPWC.stcField.u1P3 = 1;
            break;
        case 32:
            psmc_cofig->unPWC.stcField.u3P2_0 = 7;
            psmc_cofig->unPWC.stcField.u1P3 = 1;
            break;
        default: //4div
            psmc_cofig->unPWC.stcField.u3P2_0 = 1;
            psmc_cofig->unPWC.stcField.u1P3 = 0;
    }
    
}
/*************************************************
Function:       // SMC_Drive_Init
Description:    // ��ʼ�� ��� ģ��
Input:          // motorConfig
// motorConfig.motor_sel bit0: [SMC0] --- bit5[SMC5] 1: Enalbe
// cycle_with:����λ�� 0��8λ��1��10λ
Output:         // ��
Return:         // ��
Others:         // ����˵��
*************************************************/
void SMC_Drive_Init(stc_motor_t *motorConfig,uint8_t cycle_width,uint8_t clkdiv)
{
    stc_smcn_t   m_stc_smc;
    
    //motor0
    if(motorConfig->motor_sel & 0x01)
    {
        // PORT - port pin configuration
        //80 pin PWM1P0
        // stc_port_pin_config_t stc_port_pin_config1_10 =
        // {
        //     .enOutputFunction      = PortOutputResourceF,
        //     .enOutputDrive         = PortOutputDriveD,
        //     .enPullResistor        = PortPullResistorNone,
        //     .enInputLevel          = PortInputLevelCmosA,
        //     .bInputEnable          = FALSE,
        //     .bNoiseFilterEnable    = TRUE,
        //     .enGpioDirection       = PortGpioOutput,
        //     .enGpioInitOutputLevel = PortGpioLow
        // };
        // Port_SetPinConfig( 1, 10, &stc_port_pin_config1_10 );
        //81 pin PWM1M0
     
        //82 pin PWM2P0
        stc_port_pin_config_t stc_port_pin_config1_12 =
        {
            .enOutputFunction      = PortOutputResourceF,
            .enOutputDrive         = PortOutputDriveD,
            .enPullResistor        = PortPullResistorNone,
            .enInputLevel          = PortInputLevelCmosA,
            .bInputEnable          = FALSE,
            .bNoiseFilterEnable    = TRUE,
            .enGpioDirection       = PortGpioOutput,
            .enGpioInitOutputLevel = PortGpioLow
        };
        Port_SetPinConfig( 1, 12, &stc_port_pin_config1_12 );
        //83 pin PWM2M0
       
        
        //
        m_stc_smc.unPWC.u16Register = 0;
        m_stc_smc.unPWSS.u16Register = 0;
        
        m_stc_smc.unPWC.stcField.u1SC = cycle_width;    //10-bit operation mode
        Set_SMC_ClkDiv(&m_stc_smc,clkdiv);
        SMC0_PWC  = m_stc_smc.unPWC.u16Register;
        
        m_stc_smc.unPWC1.stcField.u10D = 0;   //duty = 0
        m_stc_smc.unPWC2.stcField.u10D = 0;   //duty = 0
        SMC0_PWC1 = m_stc_smc.unPWC1.u16Register;
        SMC0_PWC2 = m_stc_smc.unPWC1.u16Register;
        
        m_stc_smc.unPWS.stcField.u1BS = 1;
        m_stc_smc.unPWS.stcField.u3P1 = 0;    //"L": PWM1P output is fixed to low level
        m_stc_smc.unPWS.stcField.u3M1 = 0;    //"L": PWM1M output is fixed to low level
        m_stc_smc.unPWS.stcField.u3P2 = 0;    //"L": PWM2P output is fixed to low level
        m_stc_smc.unPWS.stcField.u3M2 = 0;    //"L": PWM2M output is fixed to low level
        SMC0_PWS  = m_stc_smc.unPWS.u16Register;
        
        m_stc_smc.unPWC.stcField.u1CE = 1;    //PWM Pulse Generator is started
        
        SMC0_PWC  = m_stc_smc.unPWC.u16Register;
    }
    
    //motor1
    if(motorConfig->motor_sel & 0x02)
    {
        // PORT - port pin configuration
        //84 pin PWM1P1
        stc_port_pin_config_t stc_port_pin_config1_14 =
        {
            .enOutputFunction      = PortOutputResourceF,
            .enOutputDrive         = PortOutputDriveD,
            .enPullResistor        = PortPullResistorNone,
            .enInputLevel          = PortInputLevelCmosA,
            .bInputEnable          = FALSE,
            .bNoiseFilterEnable    = TRUE,
            .enGpioDirection       = PortGpioOutput,
            .enGpioInitOutputLevel = PortGpioLow
        };
        Port_SetPinConfig( 1, 14, &stc_port_pin_config1_14 );
        //85 pin PWM1M1
       
        //86 pin PWM2P1
        stc_port_pin_config_t stc_port_pin_config1_16 =
        {
            .enOutputFunction      = PortOutputResourceF,
            .enOutputDrive         = PortOutputDriveD,
            .enPullResistor        = PortPullResistorNone,
            .enInputLevel          = PortInputLevelCmosA,
            .bInputEnable          = FALSE,
            .bNoiseFilterEnable    = TRUE,
            .enGpioDirection       = PortGpioOutput,
            .enGpioInitOutputLevel = PortGpioLow
        };
        Port_SetPinConfig( 1, 16, &stc_port_pin_config1_16 );
        //87 pin PWM2M1

        
        
        m_stc_smc.unPWC.u16Register = 0;
        m_stc_smc.unPWSS.u16Register = 0;
        
        m_stc_smc.unPWC.stcField.u1SC = cycle_width;    //10-bit operation mode
        Set_SMC_ClkDiv(&m_stc_smc,clkdiv);
        SMC1_PWC  = m_stc_smc.unPWC.u16Register;
        
        m_stc_smc.unPWC1.stcField.u10D = 0;   //duty = 0
        m_stc_smc.unPWC2.stcField.u10D = 0;   //duty = 0
        SMC1_PWC1 = m_stc_smc.unPWC1.u16Register;
        SMC1_PWC2 = m_stc_smc.unPWC1.u16Register;
        
        m_stc_smc.unPWS.stcField.u1BS = 1;
        m_stc_smc.unPWS.stcField.u3P1 = 0;    //"L": PWM1P output is fixed to low level
        m_stc_smc.unPWS.stcField.u3M1 = 0;    //"L": PWM1M output is fixed to low level
        m_stc_smc.unPWS.stcField.u3P2 = 0;    //"L": PWM2P output is fixed to low level
        m_stc_smc.unPWS.stcField.u3M2 = 0;    //"L": PWM2M output is fixed to low level
        SMC1_PWS  = m_stc_smc.unPWS.u16Register;
        
        m_stc_smc.unPWC.stcField.u1CE = 1;    //PWM Pulse Generator is started
        
        SMC1_PWC  = m_stc_smc.unPWC.u16Register;
    }
    
    //motor2
    if(motorConfig->motor_sel & 0x04)
    {
        //91 pin PWM1M2
        stc_port_pin_config_t stc_port_pin_config1_19 =
        {
            .enOutputFunction      = PortOutputResourceF,
            .enOutputDrive         = PortOutputDriveD,
            .enPullResistor        = PortPullResistorNone,
            .enInputLevel          = PortInputLevelCmosA,
            .bInputEnable          = FALSE,
            .bNoiseFilterEnable    = TRUE,
            .enGpioDirection       = PortGpioOutput,
            .enGpioInitOutputLevel = PortGpioLow
        };
        Port_SetPinConfig( 1, 19, &stc_port_pin_config1_19 );
        //92 pin PWM2P2
        stc_port_pin_config_t stc_port_pin_config1_20 =
        {
            .enOutputFunction      = PortOutputResourceF,
            .enOutputDrive         = PortOutputDriveD,
            .enPullResistor        = PortPullResistorNone,
            .enInputLevel          = PortInputLevelCmosA,
            .bInputEnable          = FALSE,
            .bNoiseFilterEnable    = TRUE,
            .enGpioDirection       = PortGpioOutput,
            .enGpioInitOutputLevel = PortGpioLow
        };
        Port_SetPinConfig( 1, 20, &stc_port_pin_config1_20 );
        //93 pin PWM2M2
        stc_port_pin_config_t stc_port_pin_config1_21 =
        {
            .enOutputFunction      = PortOutputResourceF,
            .enOutputDrive         = PortOutputDriveD,
            .enPullResistor        = PortPullResistorNone,
            .enInputLevel          = PortInputLevelCmosA,
            .bInputEnable          = FALSE,
            .bNoiseFilterEnable    = TRUE,
            .enGpioDirection       = PortGpioOutput,
            .enGpioInitOutputLevel = PortGpioLow
        };
        Port_SetPinConfig( 1, 21, &stc_port_pin_config1_21 );
        
        //
        m_stc_smc.unPWC.u16Register = 0;
        m_stc_smc.unPWSS.u16Register = 0;
        
        m_stc_smc.unPWC.stcField.u1SC = cycle_width;    //10-bit operation mode
        Set_SMC_ClkDiv(&m_stc_smc,clkdiv);
        SMC2_PWC  = m_stc_smc.unPWC.u16Register;
        
        m_stc_smc.unPWC1.stcField.u10D = 0;   //duty = 0
        m_stc_smc.unPWC2.stcField.u10D = 0;   //duty = 0
        SMC2_PWC1 = m_stc_smc.unPWC1.u16Register;
        SMC2_PWC2 = m_stc_smc.unPWC1.u16Register;
        
        m_stc_smc.unPWS.stcField.u1BS = 1;
        m_stc_smc.unPWS.stcField.u3P1 = 0;    //"L": PWM1P output is fixed to low level
        m_stc_smc.unPWS.stcField.u3M1 = 0;    //"L": PWM1M output is fixed to low level
        m_stc_smc.unPWS.stcField.u3P2 = 0;    //"L": PWM2P output is fixed to low level
        m_stc_smc.unPWS.stcField.u3M2 = 0;    //"L": PWM2M output is fixed to low level
        SMC2_PWS  = m_stc_smc.unPWS.u16Register;
        
        m_stc_smc.unPWC.stcField.u1CE = 1;    //PWM Pulse Generator is started
        
        SMC2_PWC  = m_stc_smc.unPWC.u16Register;
    }
    
    //motor3
    if(motorConfig->motor_sel & 0x08)
    {
        // PORT - port pin configuration
        //94 pin PWM1P3
        stc_port_pin_config_t stc_port_pin_config1_22 =
        {
            .enOutputFunction      = PortOutputResourceF,
            .enOutputDrive         = PortOutputDriveD,
            .enPullResistor        = PortPullResistorNone,
            .enInputLevel          = PortInputLevelCmosA,
            .bInputEnable          = FALSE,
            .bNoiseFilterEnable    = TRUE,
            .enGpioDirection       = PortGpioOutput,
            .enGpioInitOutputLevel = PortGpioLow
        };
        Port_SetPinConfig( 1, 22, &stc_port_pin_config1_22 );
        //95 pin PWM1M3
        stc_port_pin_config_t stc_port_pin_config1_23 =
        {
            .enOutputFunction      = PortOutputResourceF,
            .enOutputDrive         = PortOutputDriveD,
            .enPullResistor        = PortPullResistorNone,
            .enInputLevel          = PortInputLevelCmosA,
            .bInputEnable          = FALSE,
            .bNoiseFilterEnable    = TRUE,
            .enGpioDirection       = PortGpioOutput,
            .enGpioInitOutputLevel = PortGpioLow
        };
        Port_SetPinConfig( 1, 23, &stc_port_pin_config1_23 );
        //96 pin PWM2P3

        //97 pin PWM2M3

        
        //
        m_stc_smc.unPWC.u16Register = 0;
        m_stc_smc.unPWSS.u16Register = 0;
        
        m_stc_smc.unPWC.stcField.u1SC = cycle_width;    //10-bit operation mode
        Set_SMC_ClkDiv(&m_stc_smc,clkdiv);
        SMC3_PWC  = m_stc_smc.unPWC.u16Register;
        
        m_stc_smc.unPWC1.stcField.u10D = 0;   //duty = 0
        m_stc_smc.unPWC2.stcField.u10D = 0;   //duty = 0
        SMC3_PWC1 = m_stc_smc.unPWC1.u16Register;
        SMC3_PWC2 = m_stc_smc.unPWC1.u16Register;
        
        m_stc_smc.unPWS.stcField.u1BS = 1;
        m_stc_smc.unPWS.stcField.u3P1 = 0;    //"L": PWM1P output is fixed to low level
        m_stc_smc.unPWS.stcField.u3M1 = 0;    //"L": PWM1M output is fixed to low level
        m_stc_smc.unPWS.stcField.u3P2 = 0;    //"L": PWM2P output is fixed to low level
        m_stc_smc.unPWS.stcField.u3M2 = 0;    //"L": PWM2M output is fixed to low level
        SMC3_PWS  = m_stc_smc.unPWS.u16Register;
        
        m_stc_smc.unPWC.stcField.u1CE = 1;    //PWM Pulse Generator is started
        
        SMC3_PWC  = m_stc_smc.unPWC.u16Register;
    }
    
    //motor4
    if(motorConfig->motor_sel & 0x10)
    {
        // PORT - port pin configuration
        //100 pin PWM1P4
      
  

        m_stc_smc.unPWC.u16Register = 0;
        m_stc_smc.unPWSS.u16Register = 0;
        
        m_stc_smc.unPWC.stcField.u1SC = cycle_width;    //10-bit operation mode
        Set_SMC_ClkDiv(&m_stc_smc,clkdiv);
        SMC4_PWC  = m_stc_smc.unPWC.u16Register;
        
        m_stc_smc.unPWC1.stcField.u10D = 0;   //duty = 0
        m_stc_smc.unPWC2.stcField.u10D = 0;   //duty = 0
        SMC4_PWC1 = m_stc_smc.unPWC1.u16Register;
        SMC4_PWC2 = m_stc_smc.unPWC1.u16Register;
        
        m_stc_smc.unPWS.stcField.u1BS = 1;
        m_stc_smc.unPWS.stcField.u3P1 = 0;    //"L": PWM1P output is fixed to low level
        m_stc_smc.unPWS.stcField.u3M1 = 0;    //"L": PWM1M output is fixed to low level
        m_stc_smc.unPWS.stcField.u3P2 = 0;    //"L": PWM2P output is fixed to low level
        m_stc_smc.unPWS.stcField.u3M2 = 0;    //"L": PWM2M output is fixed to low level
        SMC4_PWS  = m_stc_smc.unPWS.u16Register;
        
        m_stc_smc.unPWC.stcField.u1CE = 1;    //PWM Pulse Generator is started
        
        SMC4_PWC  = m_stc_smc.unPWC.u16Register;
    }
    
    //motor5
    if(motorConfig->motor_sel & 0x20)
    {
        // PORT - port pin configuration
        //104 pin PWM1P5
        //
        //105 pin PWM1M5
        /*
        stc_port_pin_config_t stc_port_pin_config1_31 =
        {
            .enOutputFunction      = PortOutputResourceF,
            .enOutputDrive         = PortOutputDriveD,
            .enPullResistor        = PortPullResistorNone,
            .enInputLevel          = PortInputLevelCmosA,
            .bInputEnable          = FALSE,
            .bNoiseFilterEnable    = TRUE,
            .enGpioDirection       = PortGpioOutput,
            .enGpioInitOutputLevel = PortGpioLow
        };
        Port_SetPinConfig( 1, 31, &stc_port_pin_config1_31 );*/
        //106 pin PWM2P5
        stc_port_pin_config_t stc_port_pin_config2_00 =
        {
            .enOutputFunction      = PortOutputResourceF,
            .enOutputDrive         = PortOutputDriveD,
            .enPullResistor        = PortPullResistorNone,
            .enInputLevel          = PortInputLevelCmosA,
            .bInputEnable          = FALSE,
            .bNoiseFilterEnable    = TRUE,
            .enGpioDirection       = PortGpioOutput,
            .enGpioInitOutputLevel = PortGpioLow
        };
      //  Port_SetPinConfig( 2, 0, &stc_port_pin_config2_00 );
        //107 pin PWM2M5
        stc_port_pin_config_t stc_port_pin_config2_01 =
        {
            .enOutputFunction      = PortOutputResourceF,
            .enOutputDrive         = PortOutputDriveD,
            .enPullResistor        = PortPullResistorNone,
            .enInputLevel          = PortInputLevelCmosA,
            .bInputEnable          = FALSE,
            .bNoiseFilterEnable    = TRUE,
            .enGpioDirection       = PortGpioOutput,
            .enGpioInitOutputLevel = PortGpioLow
        };
#if (CAN_2ND)		
        // Port_SetPinConfig( 2, 1, &stc_port_pin_config2_01 );
#endif        
        //
        m_stc_smc.unPWC.u16Register = 0;
        m_stc_smc.unPWSS.u16Register = 0;
        
        m_stc_smc.unPWC.stcField.u1SC = cycle_width;    //10-bit operation mode
        Set_SMC_ClkDiv(&m_stc_smc,clkdiv);
        SMC5_PWC  = m_stc_smc.unPWC.u16Register;
        
        m_stc_smc.unPWC1.stcField.u10D = 0;   //duty = 0
        m_stc_smc.unPWC2.stcField.u10D = 0;   //duty = 0
        SMC5_PWC1 = m_stc_smc.unPWC1.u16Register;
        SMC5_PWC2 = m_stc_smc.unPWC1.u16Register;
        
        m_stc_smc.unPWS.stcField.u1BS = 1;
        m_stc_smc.unPWS.stcField.u3P1 = 0;    //"L": PWM1P output is fixed to low level
        m_stc_smc.unPWS.stcField.u3M1 = 0;    //"L": PWM1M output is fixed to low level
        m_stc_smc.unPWS.stcField.u3P2 = 0;    //"L": PWM2P output is fixed to low level
        m_stc_smc.unPWS.stcField.u3M2 = 0;    //"L": PWM2M output is fixed to low level
        SMC5_PWS  = m_stc_smc.unPWS.u16Register;
        
        m_stc_smc.unPWC.stcField.u1CE = 1;    //PWM Pulse Generator is started
        
        SMC5_PWC  = m_stc_smc.unPWC.u16Register;
    }
}
/*************************************************
Function:       // Motor_Move
Description:    // ����߶�����
Input:          // timeLimit:ռ�ձ�ÿ�α仯���ʱ��
// motorIndex [0 - 5]
Output:         // ��
Return:         // ��
Others:         // ����˵��
*************************************************/
void Motor_Move(_MeterPos *meter)
{   
    if(meter->Time)
        meter->Time--;
    if(meter->Time == 0)
    {
        if(meter->DestPosition > meter->CurPosition)
        {
            meter->Dir = 1;
            meter->CurPosition ++;
        }
        else if(meter->DestPosition < meter->CurPosition)
        {
            meter->Dir = 0;
            meter->CurPosition --;
        }
        else
        {
            meter->Dir = 255;
        }
        
        if(meter->ChangeTime <= 4)
        {
            //meter->ChangeTime = 4;
        }
        meter->Time = meter->ChangeTime;                
    }
}

void BSP_MOTOR_Init(void)
{
    stc_motor_t  motor_config;
    
    motor_config.motor_sel = 0x3C;
    SMC_Drive_Init(&motor_config,Duty_8bits,16);
}
