;************************************************************************
;*                                                                      *
;*  Flash marker setting file for security markers and bootrom markers  *
;*                                                                      *
;************************************************************************

;************************************************************************
;* 1  Disclaimer                                                        *
;************************************************************************
;* __DISCLAIMER_START__                                                 *
;************************************************************************
;* (c)2017, Cypress Semiconductor Corporation
;* or a subsidiary of Cypress Semiconductor Corporation. All rights
;* reserved.
;*
;* This software, including source code, documentation and related
;* materials ( "Software" ), is owned by Cypress Semiconductor
;* Corporation or one of its subsidiaries ( "Cypress" ) and is protected by
;* and subject to worldwide patent protection (United States and foreign),
;* United States copyright laws and international treaty provisions.
;* Therefore, you may use this Software only as provided in the license
;* agreement accompanying the software package from which you
;* obtained this Software ( "EULA" ).
;*
;* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
;* non-transferable license to copy, modify, and compile the
;* Software source code solely for use in connection with Cypress' s
;* integrated circuit products. Any reproduction, modification, translation,
;* compilation, or representation of this Software except as specified
;* above is prohibited without the express written permission of Cypress.
;*
;* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
;* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
;* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
;* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
;* PARTICULAR PURPOSE. Cypress reserves the right to make
;* changes to the Software without notice. Cypress does not assume any
;* liability arising out of the application or use of the Software or any
;* product or circuit described in the Software. Cypress does not
;* authorize its products for use in any products where a malfunction or
;* failure of the Cypress product may reasonably be expected to result in
;* significant property damage, injury or death ( "High Risk Product" ). By
;* including Cypress' s product in a High Risk Product, the manufacturer
;* of such system or application assumes all risk of such use and in doing
;* so agrees to indemnify Cypress against all liability.
;************************************************************************
;* __DISCLAIMER_END__                                                   *
;************************************************************************
;************************************************************************
;* 2  Contents                                                          *
;************************************************************************
;*  1  Disclaimer                                                       *
;*  2  Contents                                                         *
;*  3  History                                                          *
;*  4  Include files                                                    *
;*  5  Configuration                                                    *
;*  5.1  Security Record (MK)                                           *
;*  5.2  Debug Authentication Record (DDR)                              *
;*  5.3  Boot Description Record (BDR)                                  *
;*  5.4  Watchdog Description Record (WDR)                              *
;*  6  Flash Marker Settings                                            *
;*  6.1  Fixed definition                                               *
;*  6.2  Security Record (MK)                                           *
;*  6.3  Debug Authentication Record (DDR)                              *
;*  6.4  Boot Description Record (BDR)                                  *
;*  6.5  Watchdog Description Record (WDR)                              *
;*  7  File end                                                         *
;************************************************************************
;* 3  History                                                           *
;************************************************************************
;* Version Date        Author   Description                             *
;* V0.01   2015-09-01  HS       Initial version for Traveo              *
;************************************************************************
;* 4  Include files                                                     *
;************************************************************************
; abstract.h cannot be included because of build error with GHS due to 
; included files in abstract.h
#ifdef __ghs__
    #define __TOOLCHAIN_GHS_MULTI__
#endif
#ifdef __IASMARM__
    #define __TOOLCHAIN_IAR__
#endif

;************************************************************************
;* 5  Configurations                                                    *
;************************************************************************
;* For details of the function of each markers,
;* please see related hardware manuals.

;************************************************************************
;* 5.1  Security Record (MK)                                            *
;************************************************************************
;* This value is used to enable the security feature.
;* < set to MARKER_DISABLE or MARKER_ENABLE
#define MK_SER_ENABLE           (MARKER_DISABLE)

;* This value is used to select security scope of the device.
;* < set to MK_SCOPE_FLASH_PROTECTION or MK_SCOPE_DEVICE_PROTECTION
#define MK_SSR_SECURITY_SCOPE   (MK_SCOPE_FLASH_PROTECTION)

;* This value is the function of the Chip Erase Enable.
;* < set to MARKER_DISABLE or MARKER_ENABLE
#define MK_CEER_ENABLE          (MARKER_ENABLE)

;* This value is the function of the Security Overwrite Enable Marker.
;* < set to MARKER_DISABLE or MARKER_ENABLE
#define MK_SOER_ENABLE          (MARKER_ENABLE)

;* This section describes the function of the Sector Write Permission Overwrite Enable Marker.
;* < set to MARKER_DISABLE or MARKER_ENABLE
#define MK_SWPOER_ENABLE        (MARKER_ENABLE)

;* This configuration will be used to control the TCFLASH "small" sectors write permission.
#define MK_CSWP0_SETTING        (0xFFFFFFFF)

;* This configuration will be used to control the TCFLASH "large" sectors write permission.
#define MK_CSWP1_SETTING        (0xFFFFFFFF)
#define MK_CSWP2_SETTING        (0xFFFFFFFF)
#define MK_CSWP3_SETTING        (0xFFFFFFFF)
#define MK_CSWP4_SETTING        (0xFFFFFFFF)
#define MK_CSWP5_SETTING        (0xFFFFFFFF)
#define MK_CSWP6_SETTING        (0xFFFFFFFF)
#define MK_CSWP7_SETTING        (0xFFFFFFFF)
#define MK_CSWP8_SETTING        (0xFFFFFFFF)

;* This configuration will be used to control the Work Flash Sector Write Permission.
;* Individual bits control the permission to write the each sector of the work flash.
#define MK_WSWP0_SETTING        (0xFFFFFFFF)
#define MK_WSWP1_SETTING        (0xFFFFFFFF)
#define MK_WSWP2_SETTING        (0xFFFFFFFF)
#define MK_WSWP3_SETTING        (0xFFFFFFFF)


;************************************************************************
;* 5.2  Debug Authentication Record (DDR)                               *
;************************************************************************
;* Following settings are effective only when the security setting is enabled.
;* (MK_SER_ENABLE == MARKER_ENABLE) */

;* setting of Debugger Connection Enable Marker (DDR_DSM)
;* This value is used to enable debugger connection.
;* < set to MARKER_DISABLE or MARKER_ENABLE */
#define DDR_DSM_ENABLE          (MARKER_ENABLE)

;* Debugger Security Key Marker 0
;* This value are the bit127:96 of the key of the debugger authentication.
#define DDR_DSKM0_SETTING       (0xFFFFFFFF)

;* Debugger Security Key Marker 1 */
;* This value are the bit95:64 of the key of the debugger authentication.
#define DDR_DSKM1_SETTING       (0xFFFFFFFF)

;* Debugger Security Key Marker 2
;* This value are the bit63:32 of the key of the debugger authentication.
#define DDR_DSKM2_SETTING       (0xFFFFFFFF)

;* Debugger Security Key Marker 3
;* This value are the bit31:0 of the key of the debugger authentication.
#define DDR_DSKM3_SETTING       (0xFFFFFFFF)


;************************************************************************
;* 5.3  Boot Description Record (BDR)                                   *
;************************************************************************
;* SHE Secure Boot Mode Marker
;* When set to BDR_MEASURING_DURING_APPLICATION, user program will start
;* without waiting SHE Secure Boot processing completion.
;* < set to BDR_MEASURING_BEFORE_APPLICATION or BDR_MEASURING_DURING_APPLICATION
#define BDR_SBMM_SETTING            (BDR_MEASURING_BEFORE_APPLICATION)

;* SHE Secure Boot Size Marker
;* This value is the byte size of the memory area to be verified
;* if the Secure Boot is enabled by the Secure Boot MAC Key.
;* On the one hand, the byte size defines the size for the CMAC algorithm.
#define BDR_SBSM_SECURE_BOOT_SIZE   (0xFFFFFFFF)

;* Debugger Waiting Enable Marker
;* If set to MARKER_ENABLE, the user program is suspended after a hard/PD2
;* reset until the debugger is connected or a maximum waiting time is reached.
;* Otherwise, the user program immediately starts.
;* < set to MARKER_ENABLE or MARKER_DISABLE
#define BDR_DWEM_ENABLE              (MARKER_ENABLE)

;* Alternative Boot Vector Enable Marker
;* If set to MARKER_ENABLE, the user program is started
;* at the address stored in BDR_ABVM.
;* Otherwise, the user program starts at the fixed address.
;* < set to MARKER_DISABLE or MARKER_ENABLE
#define BDR_ABVEM_ENABLE             (MARKER_ENABLE)

;* Alternative Boot Vector Marker
;* This setting is effective only when BDR_ABVEM is set to enable.
;* < set to the user program start address.
;* !!CAUTION!! Must not be put parentheses around.
#ifdef __TOOLCHAIN_GHS_MULTI__
#define BDR_ABVM_SETTING             _start
#endif
#ifdef __TOOLCHAIN_IAR__
#define BDR_ABVM_SETTING             __iar_program_start
#endif


;************************************************************************
;* 5.4  Watchdog Description Record (WDR)                               *
;************************************************************************
;* Hardware Watchdog Interrupt Configuration Marker
;* Reset Enable Marker
;* If set to MARKER_ENABLE, a reset is generated when a watchdog error occurs.
;* Otherwise, an NMI interrupt is generated in the same condition.
;* < set to MARKER_DISABLE or MARKER_ENABLE
#define WDR_INTM_RSTENM_ENABLE              (MARKER_ENABLE)
;* Prior Warning Interrupt Enable Marker
;* If set to MARKER_ENABLE, prior warning interrupt is enabled.
;* Otherwise, it is disabled.
;* < set to MARKER_DISABLE or MARKER_ENABLE
#define WDR_INTM_IRQENM_ENABLE              (MARKER_ENABLE)

;* Watchdog Trigger 0 Configuration Marker
;* Following values are used to clear hardware watch dog timer.
;* Valid range: 0x00...0xFF
#define WDR_TRG0CFGM_WDGTRG0CFGM_SETTING    (0x00)
#define WDR_TRG1CFGM_WDGTRG1CFGM_SETTING    (0x00)

;* Hardware Watchdog Lower Limit RUN Setting Marker
;* This value defines the lower border of the Watchdog window for RUN state.
;* When set to "0x00000000", the window function does not work.
#define WDR_WDR_RUNLLM_SETTING              (0x00000000)

;* Hardware Watchdog Upper Limit RUN Setting Marker
;* This value defines the upper border of the Watchdog window for RUN state.
#define WDR_WDR_RUNULM_SETTING              (0x00080000)

;* Hardware Watchdog Lower Limit PSS Setting Marker
;* This value defines the lower border of the Watchdog window for PSS state.
;* When set to "0x00000000", the window function does not work.
#define WDR_WDR_PSSLLM_SETTING              (0x00000000)

;* Hardware Watchdog Upper Limit PSS Setting Marker
;* This value defines the upper border of the Watchdog window for PSS state.
#define WDR_WDR_PSSULM_SETTING              (0x00080000)

;* Hardware Watchdog Reset Delay Counter Marker
;* This value defines the delay to be inserted
;* in Watchdog reset/NMI generation in case of a Hardware Watchdog error.
;* valid range: 0 to 65535 (0xFFFF)
#define WDR_RSTDLYM_WDGRSTDLYM_SETTING      (0x0000)

;* Clock Selection Marker
;* This value is used to select a source clock of the watchdog counter.
;* < set to WDR_CFGM_CLKSELM_LOW_SPEDD_CR or WDR_CFGM_CLKSELM_HIGH_SPEDD_CR
//add by zhangxuesong
//#define WDR_CFGM_CLKSELM_CLK_SELECTION      (WDR_CFGM_CLKSELM_HIGH_SPEDD_CR)
#define WDR_CFGM_CLKSELM_CLK_SELECTION      (WDR_CFGM_CLKSELM_LOW_SPEDD_CR)
;* Watchdog Counter Monitor Bit Output Selection Marker
;* For this product, this setting has no effect.
#define WDR_CFGM_OBSSELM_SETTING            (0x1F)

;* Hardware Watchdog Configuration Enable Marker
;* If set to MARKER_ENABLE, the hardware watchdog is started based
;* on the settings defined with the WDR.
;* Otherwise, the hardware watchdog operates based on the default settings.
;* < set to MARKER_DISABLE or MARKER_ENABLE
#define WDR_CEM_ENABLE                      (MARKER_ENABLE)



;************************************************************************
;* 5.2  Import symbols                                                  *
;************************************************************************

        ;* nothing

;************************************************************************
;* 5.3  Export symbols                                                  *
;************************************************************************

        EXPORT MK_SECTION_START
        EXPORT MK_SECTION_END
        EXPORT DDR_SECTION_START
        EXPORT DDR_SECTION_END
        EXPORT BDR_SECTION_START
        EXPORT BDR_SECTION_END
        EXPORT WDR_SECTION_START
        EXPORT WDR_SECTION_END
        

#ifdef __TOOLCHAIN_GHS_MULTI__
; Forces this object file to be always pulled in from projects using the
; generated library that contains this object file because usually a 
; project will not reference the other symbols in this object
; (an object file in library having a __ghsalwaysimport* symbol will be
; always pulled in from GHS linker)
        EXPORT __ghsalwaysimport_flash_marker
__ghsalwaysimport_flash_marker:

#elif defined __TOOLCHAIN_IAR__
; The following symbol name has no special meaning for IAR. The symbol name
; must be used with the -keep linker option
;(or GUI menu: Options->Linker->Input->Keep symbols)
        EXPORT __iar_keep_flash_marker
__iar_keep_flash_marker:
        
#endif

;************************************************************************
;* 6  Flash Marker Settings                                             *
;************************************************************************

;************************************************************************
;* 6.1  Fixed definitions                                               *
;************************************************************************
#define MARKER_ENABLE                       (1)
#define MARKER_DISABLE                      (0)
#define MK_SCOPE_FLASH_PROTECTION           (1)
#define MK_SCOPE_DEVICE_PROTECTION          (0)
#define BDR_MEASURING_DURING_APPLICATION    (1)
#define BDR_MEASURING_BEFORE_APPLICATION    (0)
#define BIT_POS_WDR_INTM_RSTENM             (17)
#define BIT_POS_WDR_INTM_IRQENM             (16)
#define BIT_POS_WDR_CFGM_OBSSELM            (16)
#define BIT_POS_WDR_CFGM_CLKSELM            (8)
#define WDR_CFGM_CLKSELM_LOW_SPEDD_CR       (1)
#define WDR_CFGM_CLKSELM_HIGH_SPEDD_CR      (0)

DEFAULT_VALUE           EQU    0xFFFFFFFF      ;* value of the erased flash memory

;*------------------------------------------------------------------*
;*  definitions for security markers (MK)                           *
;*------------------------------------------------------------------*
#if MK_SER_ENABLE == MARKER_ENABLE
VALUE_OF_MK_SER         EQU    0x00000001      ;* enable security
#else
VALUE_OF_MK_SER         EQU    DEFAULT_VALUE   ;* disable security
#endif
#if MK_SSR_SECURITY_SCOPE == MK_SCOPE_FLASH_PROTECTION
VALUE_OF_MK_SSR         EQU    DEFAULT_VALUE   ;* Flash protection
#else
VALUE_OF_MK_SSR         EQU    0x00000000      ;* Device protection
#endif
#if MK_CEER_ENABLE == MARKER_ENABLE
VALUE_OF_MK_CEER        EQU    DEFAULT_VALUE   ;* enable chip erase
#else
VALUE_OF_MK_CEER        EQU    0x00000000      ;* disable chip erase
#endif
#if MK_SOER_ENABLE == MARKER_ENABLE
VALUE_OF_MK_SOER        EQU    DEFAULT_VALUE   ;* enable overwrite
#else
VALUE_OF_MK_SOER        EQU    0x00000000      ;* disable overwrite
#endif
#if MK_SWPOER_ENABLE == MARKER_ENABLE
VALUE_OF_MK_SWPOER      EQU    DEFAULT_VALUE   ;* enable overwrite
#else
VALUE_OF_MK_SWPOER      EQU    0x00000000      ;* disable overwrite
#endif

VALUE_OF_MK_CSWP0       EQU    MK_CSWP0_SETTING
VALUE_OF_MK_CSWP1       EQU    MK_CSWP1_SETTING
VALUE_OF_MK_CSWP2       EQU    MK_CSWP2_SETTING
VALUE_OF_MK_CSWP3       EQU    MK_CSWP3_SETTING
VALUE_OF_MK_CSWP4       EQU    MK_CSWP4_SETTING
VALUE_OF_MK_CSWP5       EQU    MK_CSWP5_SETTING
VALUE_OF_MK_CSWP6       EQU    MK_CSWP6_SETTING
VALUE_OF_MK_CSWP7       EQU    MK_CSWP7_SETTING
VALUE_OF_MK_CSWP8       EQU    MK_CSWP8_SETTING
VALUE_OF_MK_WSWP0       EQU    MK_WSWP0_SETTING
VALUE_OF_MK_WSWP1       EQU    MK_WSWP1_SETTING
VALUE_OF_MK_WSWP2       EQU    MK_WSWP2_SETTING
VALUE_OF_MK_WSWP3       EQU    MK_WSWP3_SETTING


;*------------------------------------------------------------------*
;*  definitions for the Debugger Connection Record (DDR)            *
;*------------------------------------------------------------------*
#if DDR_DSM_ENABLE == MARKER_ENABLE
VALUE_OF_DDR_DSM        EQU    0x59F71234      ;* Debugger connection enabled
#else
VALUE_OF_DDR_DSM        EQU    DEFAULT_VALUE   ;* Debugger connection disabled
#endif
VALUE_OF_DDR_DSKM0      EQU    DDR_DSKM0_SETTING
VALUE_OF_DDR_DSKM1      EQU    DDR_DSKM1_SETTING
VALUE_OF_DDR_DSKM2      EQU    DDR_DSKM2_SETTING
VALUE_OF_DDR_DSKM3      EQU    DDR_DSKM3_SETTING


;*------------------------------------------------------------------*
;*  definitions for the Boot Description Record (BDR)               *
;*------------------------------------------------------------------*
#if BDR_SBMM_SETTING == BDR_MEASURING_DURING_APPLICATION
VALUE_OF_BDR_SBMM       EQU    0x00000000      ;* "Measuring during application" mode
#else
VALUE_OF_BDR_SBMM       EQU    DEFAULT_VALUE   ;* "Measuring before application" mode
#endif

VALUE_OF_BDR_SBSM       EQU    BDR_SBSM_SECURE_BOOT_SIZE

#if BDR_DWEM_ENABLE == MARKER_ENABLE
VALUE_OF_BDR_DWEM       EQU    DEFAULT_VALUE
#else
VALUE_OF_BDR_DWEM       EQU    0x292D3A7B
#endif

#if BDR_ABVEM_ENABLE == MARKER_ENABLE
    IMPORT BDR_ABVM_SETTING
VALUE_OF_BDR_ABVEM      EQU    0x292D3A7B
VALUE_OF_BDR_ABVM       EQU    BDR_ABVM_SETTING
#else
VALUE_OF_BDR_ABVEM      EQU    DEFAULT_VALUE
VALUE_OF_BDR_ABVM       EQU    DEFAULT_VALUE
#endif


;*------------------------------------------------------------------*
;*  definitions for the Watchdog Description Record (WDR)           *
;*------------------------------------------------------------------*
#if WDR_CFGM_CLKSELM_CLK_SELECTION == WDR_CFGM_CLKSELM_LOW_SPEDD_CR
#define WDR_CFGM_CLKSELM_SETTING    (1 << BIT_POS_WDR_CFGM_CLKSELM)
#else
#define WDR_CFGM_CLKSELM_SETTING    (0)
#endif

#if WDR_INTM_RSTENM_ENABLE == MARKER_ENABLE
#define WDR_INTM_RSTENM_SETTING     (1 << BIT_POS_WDR_INTM_RSTENM)
#else
#define WDR_INTM_RSTENM_SETTING     (0)
#endif
#if WDR_INTM_IRQENM_ENABLE == MARKER_ENABLE
#define WDR_INTM_IRQENM_SETTING     (1 << BIT_POS_WDR_INTM_IRQENM)
#else
#define WDR_INTM_IRQENM_SETTING     (0)
#endif

VALUE_OF_WDR_INTM       EQU    (0xFFFCFFFF | WDR_INTM_RSTENM_SETTING | WDR_INTM_IRQENM_SETTING)    ;* None functional bits must be "1"
VALUE_OF_WDR_TRG0CFGM   EQU    (0xFFFFFF00 | WDR_TRG0CFGM_WDGTRG0CFGM_SETTING)     ;* Upper 24bits must be "1"
VALUE_OF_WDR_TRG1CFGM   EQU    (0xFFFFFF00 | WDR_TRG1CFGM_WDGTRG1CFGM_SETTING)     ;* Upper 24bits must be "1"
VALUE_OF_WDR_RUNLLM     EQU    WDR_WDR_RUNLLM_SETTING
VALUE_OF_WDR_RUNULM     EQU    WDR_WDR_RUNULM_SETTING
VALUE_OF_WDR_PSSLLM     EQU    WDR_WDR_PSSLLM_SETTING
VALUE_OF_WDR_PSSULM     EQU    WDR_WDR_PSSULM_SETTING
VALUE_OF_WDR_RSTDLYM    EQU    (0xFFFF0000 | WDR_RSTDLYM_WDGRSTDLYM_SETTING)       ;* Upper 16bits must be "1"
VALUE_OF_WDR_CFGM       EQU    (0xFFE0FCFF | WDR_CFGM_CLKSELM_SETTING | (WDR_CFGM_OBSSELM_SETTING << BIT_POS_WDR_CFGM_OBSSELM))

#if WDR_CEM_ENABLE  == MARKER_ENABLE
VALUE_OF_WDR_CEM        EQU    0x292D3A7B
#else
VALUE_OF_WDR_CEM        EQU    DEFAULT_VALUE
#endif


;************************************************************************
;* 6.2  Security Record (MK)                                            *
;************************************************************************
#ifdef __TOOLCHAIN_GHS_MULTI__
        .SECTION ".MK", "a"
#elif defined __TOOLCHAIN_IAR__
        SECTION  .MK:CONST:ROOT (2)
#endif


MK_SECTION_START:
MK_SER:
        DCD VALUE_OF_MK_SER
MK_RSV1:
        DCD DEFAULT_VALUE   ;* reserved
MK_SSR:
        DCD VALUE_OF_MK_SSR
MK_RSV2:
        DCD DEFAULT_VALUE   ;* reserved
MK_CEER:
        DCD VALUE_OF_MK_CEER
MK_RSV3:
        DCD DEFAULT_VALUE   ;* reserved
MK_SOER:
        DCD VALUE_OF_MK_SOER
MK_RSV4:
        DCD DEFAULT_VALUE   ;* reserved
MK_SWPOER:
        DCD VALUE_OF_MK_SWPOER
MK_RSV5:
        DCD DEFAULT_VALUE   ;* reserved
MK_CSWP0:
        DCD VALUE_OF_MK_CSWP0
MK_RSV6:
        DCD DEFAULT_VALUE   ;* reserved
MK_CSWP1:
        DCD VALUE_OF_MK_CSWP1
MK_CSWP2:
        DCD VALUE_OF_MK_CSWP2
MK_CSWP3:
        DCD VALUE_OF_MK_CSWP3
MK_CSWP4:
        DCD VALUE_OF_MK_CSWP4
MK_CSWP5:
        DCD VALUE_OF_MK_CSWP5
MK_CSWP6:
        DCD VALUE_OF_MK_CSWP6
MK_CSWP7:
        DCD VALUE_OF_MK_CSWP7
MK_CSWP8:
        DCD VALUE_OF_MK_CSWP8
MK_RSV7:
        DCD DEFAULT_VALUE   ;* reserved
        DCD DEFAULT_VALUE   ;* reserved
        DCD DEFAULT_VALUE   ;* reserved
        DCD DEFAULT_VALUE   ;* reserved
        DCD DEFAULT_VALUE   ;* reserved
        DCD DEFAULT_VALUE   ;* reserved
        DCD DEFAULT_VALUE   ;* reserved
        DCD DEFAULT_VALUE   ;* reserved
MK_WSWP0:
        DCD VALUE_OF_MK_WSWP0
MK_WSWP1:
        DCD VALUE_OF_MK_WSWP1
MK_WSWP2:
        DCD VALUE_OF_MK_WSWP2
MK_WSWP3:
        DCD VALUE_OF_MK_WSWP3
MK_SECTION_END:

;************************************************************************
;* 6.3  Debug Authentication Record (DDR)                               *
;************************************************************************

#ifdef __TOOLCHAIN_GHS_MULTI__
        .SECTION ".DDR", "a"
#elif defined __TOOLCHAIN_IAR__
        SECTION  .DDR:CONST:ROOT (2)
#endif

DDR_SECTION_START:
DDR_RSV1:
        DCD DEFAULT_VALUE   ;* reserved
        DCD DEFAULT_VALUE   ;* reserved
DDR_DSM:
        DCD VALUE_OF_DDR_DSM
DDR_RSV2:
        DCD DEFAULT_VALUE   ;* reserved
DDR_DSKM0:
        DCD VALUE_OF_DDR_DSKM0
DDR_RSV3:
        DCD DEFAULT_VALUE   ;* reserved
DDR_DSKM1:
        DCD VALUE_OF_DDR_DSKM1
DDR_RSV4:
        DCD DEFAULT_VALUE   ;* reserved
DDR_DSKM2:
        DCD VALUE_OF_DDR_DSKM2
DDR_RSV5:
        DCD DEFAULT_VALUE   ;* reserved
DDR_DSKM3:
        DCD VALUE_OF_DDR_DSKM3
DDR_RSV6:
        DCD DEFAULT_VALUE   ;* reserved
        DCD DEFAULT_VALUE   ;* reserved
        DCD DEFAULT_VALUE   ;* reserved
        DCD DEFAULT_VALUE   ;* reserved
        DCD DEFAULT_VALUE   ;* reserved        
DDR_SECTION_END:

;************************************************************************
;* 6.4  Boot Description Record (BDR)                                   *
;************************************************************************

#ifdef __TOOLCHAIN_GHS_MULTI__
        .SECTION ".BDR", "a"
#elif defined __TOOLCHAIN_IAR__
        SECTION  .BDR:CONST:ROOT (2)
#endif

BDR_SECTION_START:
BDR_SBMM:
        DCD VALUE_OF_BDR_SBMM
BDR_RSV1:
        DCD DEFAULT_VALUE   ;* reserved
BDR_SBSM:
        DCD VALUE_OF_BDR_SBSM
BDR_RSV2:
        DCD DEFAULT_VALUE   ;* reserved
        DCD DEFAULT_VALUE   ;* reserved
        DCD DEFAULT_VALUE   ;* reserved
        DCD DEFAULT_VALUE   ;* reserved
        DCD DEFAULT_VALUE   ;* reserved
BDR_DWEM:
        DCD VALUE_OF_BDR_DWEM
BDR_RSV3:
        DCD DEFAULT_VALUE   ;* reserved
BDR_ABVM:
        DCD VALUE_OF_BDR_ABVM
BDR_RSV4:
        DCD DEFAULT_VALUE   ;* reserved
BDR_ABVEM:
        DCD VALUE_OF_BDR_ABVEM
BDR_RSV5:
        DCD DEFAULT_VALUE   ;* reserved
        DCD DEFAULT_VALUE   ;* reserved
        DCD DEFAULT_VALUE   ;* reserved        
BDR_SECTION_END:

;************************************************************************
;* 6.5  Watchdog Description Record (WDR)                               *
;************************************************************************

#ifdef __TOOLCHAIN_GHS_MULTI__
        .SECTION ".WDR", "a"
#elif defined __TOOLCHAIN_IAR__
        SECTION  .WDR:CONST:ROOT (2)
#endif

WDR_SECTION_START:
WDR_INTM:
        DCD VALUE_OF_WDR_INTM
WDR_RSV1:
        DCD DEFAULT_VALUE   ;* reserved
WDR_TRG0CFGM:
        DCD VALUE_OF_WDR_TRG0CFGM
WDR_RSV2:
        DCD DEFAULT_VALUE   ;* reserved
WDR_TRG1CFGM:
        DCD VALUE_OF_WDR_TRG1CFGM
WDR_RSV3:
        DCD DEFAULT_VALUE   ;* reserved
WDR_RUNLLM:
        DCD VALUE_OF_WDR_RUNLLM
WDR_RSV4:
        DCD DEFAULT_VALUE   ;* reserved
WDR_RUNULM:
        DCD VALUE_OF_WDR_RUNULM
WDR_RSV5:
        DCD DEFAULT_VALUE   ;* reserved
WDR_PSSLLM:
        DCD VALUE_OF_WDR_PSSLLM
WDR_RSV6:
        DCD DEFAULT_VALUE   ;* reserved
WDR_PSSULM:
        DCD VALUE_OF_WDR_PSSULM
WDR_RSV7:
        DCD DEFAULT_VALUE   ;* reserved
WDR_RSTDLYM:
        DCD VALUE_OF_WDR_RSTDLYM
WDR_RSV8:
        DCD DEFAULT_VALUE   ;* reserved
WDR_CFGM:
        DCD VALUE_OF_WDR_CFGM
WDR_RSV9:
        DCD DEFAULT_VALUE   ;* reserved
WDR_CEM:
        DCD VALUE_OF_WDR_CEM
WDR_RSV10:
        DCD DEFAULT_VALUE   ;* reserved        
WDR_SECTION_END:
        

;************************************************************************
;* 7  File end                                                          *
;************************************************************************

        END

