#include "app_lsdn.h"
#include "RTE_GPIO.h"
#include "GenDelay.h"

// 假设的GPIO操作函数
void set_pin_high(uint8_t mode)
{
    // GPIO_DIR_PORT00_PIN08 = 0;
    // TX_OUT = 0;

    if(mode == 0)
    {
        TX_OUT = 0;
    }
    else
    {
        ONE_START = 1;
    }
}
void set_pin_low(uint8_t mode)
{
    // GPIO_DIR_PORT00_PIN08 = 0;
    // TX_OUT = 1;

    if(mode == 0)
    {
        TX_OUT = 1;
    }
    else
    {
        ONE_START = 0;
    }
}
void lsdn_delay_us(uint32_t us)
{
    Gen_TimeDelay(us, 50u);
}

// 发送同步信号
void send_sync(uint8_t mode) {
    set_pin_low(mode);
    lsdn_delay_us(10000);   // 高电平1ms (T2)
    set_pin_high(mode);
    lsdn_delay_us(1000);  // 低电平10ms (T1≥10ms)
}

// 发送单个比特（逻辑"1"或"0"）
void send_bit(uint8_t mode, uint8_t bit) {
    if (bit) {
        
        set_pin_low(mode);
        lsdn_delay_us(500);  // 低电平0.5ms (逻辑"1"的T5)
        set_pin_high(mode);
        lsdn_delay_us(1500);  // 高电平1.5ms (逻辑"1"的T6)
    } else {
        
        set_pin_low(mode);
        lsdn_delay_us(1500);   // 低电平1.5ms (逻辑"0"的T7)
        set_pin_high(mode);
        lsdn_delay_us(500);   // 高电平0.5ms (逻辑"0"的T8)
    }
}

// 发送停止信号
void send_stop(uint8_t mode) {
    
    set_pin_low(mode);
    lsdn_delay_us(5000);   // 低电平50ms (N>50，取最小值50ms)

    set_pin_high(mode);
    lsdn_delay_us(50000);    // 高电平5ms (T9)
}

// 发送完整数据（按字节发送，高位优先）
void lsdn_send_data(uint8_t mode, const uint8_t *data, uint32_t len) {
    send_sync(mode); // 发送同步信号
    for (uint32_t i = 0; i < len; i++) {
        uint8_t byte = data[i];
        for (int j = 0; j < 8; j++) { // 高位先发
            send_bit(mode, (byte >> j) & 0x01);
        }
    }
    send_stop(mode); // 发送停止信号
}






uint8_t c_YXT_sum(uint8_t *buf,uint8_t len)
{
	uint8_t   i=0;
	uint16_t ret = 0;
	for(i=0;i<len;i++)
	{
		ret += buf[i];
	}
	return ret;
}

uint8_t Aima_SLF_DataBuf[50];

uint8_t flag1 = 0;
// mode  = 0,485接口；mode=1，一键启动接口
void Aima_SLF(uint8_t mode, uint8_t cmd, uint8_t data, uint8_t data_len)
{

    // if(flag1 == onoff)
    // {
    //     return;
    // }
    Aima_SLF_DataBuf[0] = 0x55;
    Aima_SLF_DataBuf[1] = 0xaa;
    Aima_SLF_DataBuf[2] = cmd;
    Aima_SLF_DataBuf[3] = data;
    Aima_SLF_DataBuf[4] = c_YXT_sum(Aima_SLF_DataBuf, data_len + 3);  
    lsdn_send_data(mode, Aima_SLF_DataBuf, data_len + 4);

    // flag1 = onoff;
}















