#include "common_include.h"
#include "bsp_button.h"
#include "bsp_trip_key.h"
#include "api_can.h"

_BUTTON   Botton;
_Eol      EOL;

extern uint8_t CAN_0x1DF;
extern uint8_t CAN_0x1D4;
extern uint8_t CAN_0x1D5;
extern uint8_t CAN_0x4F1;
extern uint8_t CAN_0x391;
extern uint8_t CAN_0x50c;
extern uint8_t CAN_0x5b0;
extern uint8_t CAN_0x52A;
extern uint8_t CAN_0x51B;
extern uint8_t CAN_0x5C2;
extern uint8_t CAN_0x486;
extern uint8_t CAN_0x4A6;
extern uint8_t CAN_0x2FC;


uint32_t Speed_down_long;
extern uint32_t TFT_step;
extern uint32_t LIG_step;
extern uint32_t B_step;
extern uint32_t IG_step;
extern uint32_t SPEED_step;
extern uint32_t run_step;
extern uint32_t xunhuan;
uint8_t BDC_PE_ALL;
extern uint32_t MODEtimer;
extern uint8_t  Time_Charge_500ms;

Class   g_UDS;
volatile uint16_t ErrorCode;

volatile uint8_t  Default_flag;
uint16_t ENDCode;
/*-------------------------------------------------------------------------
* Function Name  : Get_Button_Value
* Description    : ��ȡ����״̬
* Input          : None
* Output         : None
* Return         : None
* onther         : xxhh
--------------------------------------------------------------------------*/
extern uint8_t MyRecvCount;
volatile uint8_t  Auto_HW_flag;
extern DATA_SAVE_PACK NewData;
extern uint16_t Diaplay_test;
extern volatile uint8_t  Default_flag;
//extern uint8_t  Time_1s_Flag,Time_2s_Flag,Time_Charge_1s;

union
{
    uint16_t W;
    uint8_t data[2];
    
}X;

void Buzzer_Alarm() //����������3�뱨��
{
    if(!BuzzerAlarm.Flag)
    {
        BuzzerAlarm.enable = ON;
        if(BuzzerAlarm.Time > 0)
        {
            Port_SetPortPinLevel(1, 18, 1);//������
            BuzzerAlarm.Value = 1;
        }
        if(BuzzerAlarm.Time >= 3000)
        {
            Port_SetPortPinLevel(1, 18, 0);//������
            BuzzerAlarm.Value = 2;
            BuzzerAlarm.enable = OFF;
            BuzzerAlarm.Flag = FINISH;
        }
    }
}


void User_Delay(uint16_t Delay_Time) //��ʱ���� ��Ӱ����������
{
    if(!CheckCurrent.Flag)
    {
        CheckCurrent.enable = ON;
        if(CheckCurrent.Time < Delay_Time)
        {
            CheckCurrent.Value = UNFINISH;
        }
        else if(CheckCurrent.Time >= Delay_Time)
        {
            //CheckCurrent.enable = OFF;
            CheckCurrent.Value = FINISH;
            CheckCurrent.Flag = FINISH;
        }
    }
}

void GotoTestMode(){
    PressTripKeyIGN1On();
    TripKeyOk(1);
    TripKeyOk(2);
    TripKeyOk(3);
    TripKeyOk(4);
    TripKeyOk(5);
    TripKeyOk(6);
    TripKeyOk(7);
    TripKeyOk(8);
    PressTripKeyStop();
}








extern uint8_t UUIDisTURE;
void Get_Button_Value()//��ȡ����AD
{
     GET_BUTTON_S30_LEVEL;
    if(BUTTON_S30_IN == 0)
        Botton.S30.Flag = 1;
    else
    Botton.S30.Flag = 0;
    
    GET_BUTTON_S15_LEVEL;
    if(BUTTON_S15_IN == 0)
        Botton.S15.Flag = 1;
    else
    Botton.S15.Flag = 0;
    
    GET_BUTTON_AUTO_LEVEL;
    if(BUTTON_AUTO_IN == 0){
            Botton.Auto.Flag = 1;
        ButtomCurrent.enable = 1;
    }
    else
    Botton.Auto.Flag = 0;
    
    GET_BUTTON_EOL_LEVEL;
    if(BUTTON_EOL_IN == 0){
            Botton.EOL.Flag = 1;
        g_Stage = STAGE_SetEOL;
    }
    else
    Botton.EOL.Flag = 0;
    
    GET_BUTTON_SPEED_UP_LEVEL;
    if(BUTTON_SPEED_UP_IN == 0)
    {
      Botton.SpeedUp.Flag = 1;
        g_Stage == STAGE_TelltaleAndSpeed;
    }
    else
    Botton.SpeedUp.Flag = 0;
    
    GET_BUTTON_SPEED_DOWN_LEVEL;
    if(BUTTON_SPEED_DOWN_IN == 0)
        Botton.SpeedDown.Flag = 1;
    else
    Botton.SpeedDown.Flag = 0;
    
    GET_BUTTON_LED_LEVEL;
    if(BUTTON_LED_IN == 0){
        Botton.LED.Flag = 1;
        g_Stage = STAGE_TelltaleAndSpeed;
    }
    else
    Botton.LED.Flag = 0;
    
    GET_BUTTON_IOL_UP_LEVEL;
    if(BUTTON_IOL_UP_IN == 0)
        Botton.FuelWaterUp.Flag = 1;
    else
    Botton.FuelWaterUp.Flag = 0;
    
    GET_BUTTON_IOL_DOWN_LEVEL;
    if(BUTTON_IOL_DOWN_IN == 0)
        Botton.FuelWaterDown.Flag = 1;
    else
    Botton.FuelWaterDown.Flag = 0;
    
    GET_BUTTON_TFT_UP_LEVEL;
    if(BUTTON_TFT_UP_IN == 0)
        Botton.TFTUp.Flag = 1;
    else
    Botton.TFTUp.Flag = 0;
    
    GET_BUTTON_TFT_DOWN_LEVEL;
    if(BUTTON_TFT_DOWN_IN == 0)
        Botton.TFTDown.Flag = 1;
    else
    Botton.TFTDown.Flag = 0;
    
    GET_BUTTON_ELSE_LEVEL;
    if(BUTTON_ELSE_IN == 0){
            Botton.Other.Flag = 1;
    }
    else
    Botton.Other.Flag = 0;
    
    GET_BUTTON_END_LEVEL;
    if(BUTTON_END_IN == 0)
        Botton.End.Flag = 1;
    else
    Botton.End.Flag = 0;
    // if(GetUUidisTRUEFUN() == 1 || GetUUidisTRUEFUN() == 3)//uuid
    // {
    //     //  ��ɨ��
        
    // }
    // else
    // {
        // ��ť����
        // GET_BUTTON_S30_LEVEL;
        // if(BUTTON_S30_IN == 0)
        //     Botton.S30.Flag = 1;
        // else
        // Botton.S30.Flag = 0;
        
        // GET_BUTTON_S15_LEVEL;
        // if(BUTTON_S15_IN == 0)
        //     Botton.S15.Flag = 1;
        // else
        // Botton.S15.Flag = 0;
        // GET_BUTTON_AUTO_LEVEL;
        // if(BUTTON_AUTO_IN == 0){
        //         Botton.Auto.Flag = 1;
        //     ButtomCurrent.enable = 1;
        // }
        // else
        // Botton.Auto.Flag = 0;
        
        // GET_BUTTON_EOL_LEVEL;
        // if(BUTTON_EOL_IN == 0){
        //         Botton.EOL.Flag = 1;
        //     g_Stage = STAGE_SetEOL;
        // }
        // else
        // Botton.EOL.Flag = 0;
        
        // GET_BUTTON_SPEED_UP_LEVEL;
        // if(BUTTON_SPEED_UP_IN == 0)
        // {
        // Botton.SpeedUp.Flag = 1;
        //     g_Stage == STAGE_TelltaleAndSpeed;
        // }
        // else
        // Botton.SpeedUp.Flag = 0;
        
        // GET_BUTTON_SPEED_DOWN_LEVEL;
        // if(BUTTON_SPEED_DOWN_IN == 0)
        //     Botton.SpeedDown.Flag = 1;
        // else
        // Botton.SpeedDown.Flag = 0;
        
        // GET_BUTTON_LED_LEVEL;
        // if(BUTTON_LED_IN == 0){
        //         Botton.LED.Flag = 1;
        //     g_Stage = STAGE_TelltaleAndSpeed;
        // }
        // else
        // Botton.LED.Flag = 0;
        
        // GET_BUTTON_IOL_UP_LEVEL;
        // if(BUTTON_IOL_UP_IN == 0)
        //     Botton.FuelWaterUp.Flag = 1;
        // else
        // Botton.FuelWaterUp.Flag = 0;
        
        // GET_BUTTON_IOL_DOWN_LEVEL;
        // if(BUTTON_IOL_DOWN_IN == 0)
        //     Botton.FuelWaterDown.Flag = 1;
        // else
        // Botton.FuelWaterDown.Flag = 0;
        
        // GET_BUTTON_TFT_UP_LEVEL;
        // if(BUTTON_TFT_UP_IN == 0)
        //     Botton.TFTUp.Flag = 1;
        // else
        // Botton.TFTUp.Flag = 0;
        
        // GET_BUTTON_TFT_DOWN_LEVEL;
        // if(BUTTON_TFT_DOWN_IN == 0)
        //     Botton.TFTDown.Flag = 1;
        // else
        // Botton.TFTDown.Flag = 0;
        
        // GET_BUTTON_ELSE_LEVEL;
        // if(BUTTON_ELSE_IN == 0){
        //         Botton.Other.Flag = 1;
        // }
        // else
        // Botton.Other.Flag = 0;
        
        // GET_BUTTON_END_LEVEL;
        // if(BUTTON_END_IN == 0)
        //     Botton.End.Flag = 1;
        // else
        // Botton.End.Flag = 0;
    // }
        // GET_BUTTON_S30_LEVEL;
        // if(BUTTON_S30_IN == 0)
        //     Botton.S30.Flag = 1;
        // else
        // Botton.S30.Flag = 0;
        
        // GET_BUTTON_S15_LEVEL;
        // if(BUTTON_S15_IN == 0)
        //     Botton.S15.Flag = 1;
        // else
        // Botton.S15.Flag = 0;
    
    
}


uint8_t g_test;


uint8_t Calc_Checksum(uint8_t  *msg, uint8_t len)
{
    uint8_t i_loop, j_loop;
    uint8_t ret = 0;
    uint8_t bit=0x1;
    
    for (i_loop=0; i_loop < len; i_loop++)
    {
        bit=0x1;
        for (j_loop= 0; j_loop< 8; j_loop++)
        {
            if ((msg[i_loop] & bit) !=0)
            {
                ret++;
            }
            bit = (bit <<1);
            
        }
    }
    
    //g_test = ret;
    ret = 8*len - ret +1;
    
    
    return ret;
}



/*-------------------------------------------------------------------------
* Function Name  : Button_Statu_Manage
* Description    : ����״̬����
* Input          : None
* Output         : None
* Return         : None
* onther         : xxhh
--------------------------------------------------------------------------*/
uint8_t Button_Press = 0;
uint8_t Button_Value=0;
uint8_t g_butto_msg[8];
uint8_t start_uart_timer = 0;
uint8_t uart_timer_300=0;
uint8_t uart_send_end_flag=0;
uint8_t uart_send_flag=0;
uint8_t uart_send_count;
uint8_t  stop_uart_timer;

extern uint8_t Button_Slave_Receive_Flag;
extern uint8_t Button_Value_Slave;
extern uint8_t Button_Slave_Receive_Flag;


void Button_Statu_Manage_Slave()
{
    uint8_t checkSum;
    uint8_t  tmp_val;
    
    if (Button_Slave_Receive_Flag)
    {
        Button_Slave_Receive_Flag=0;
        tmp_val = Button_Value_Slave;
        
        switch (tmp_val)
        {
            case 1:
                Botton.S30.Statu = 1;
                break;
                
            case 2:
                Botton.S15.Statu = 1;
                break;
                
            case 3:
                Botton.Auto.Statu = 1;
                ButtomCurrent.enable = 1;
                break;
                
            case 4:
                Botton.LED.Statu = 1;
                break;
                
            case 5:
                Botton.SpeedUp.Statu = 1;
                break;
                
            case 6:
                Botton.SpeedDown.Statu = 1;
                break;
                
            case 7:
                Botton.FuelWaterUp.Statu = 1;
                break;
                
            case 8:
                Botton.FuelWaterDown.Statu = 1;
                break;
            case 9:
                Botton.TFTUp.Statu = 1;
                break;
            case 10:
                Botton.TFTDown.Statu = 1;
                TFTUp_Switch = 0;
                break;
            case 11:
                Botton.Other.Statu = 1;
                break;
            case 12:
                Botton.End.Statu = 1;
                break;
            case 13:
                Botton.EOL.Statu = 1;
                break;
            case 14:
                TFTUp_Switch = 1;
                TFTCurrent.count = 0;
                break;
                
            default:
                break;
        }
        
        g_butto_msg[0] = 0xFF;
        g_butto_msg[1] = 0x1;
        g_butto_msg[2] = 0x1;
        g_butto_msg[3] = 0x1;
        
        checkSum = Calc_Checksum(g_butto_msg, 4);
        g_butto_msg[4] = checkSum;
        Mfs_Uart_Write(UART0_Type, g_butto_msg, 5, TRUE);
    }
}

uint8_t TFTUp_Switch = 0;
extern uint32_t AutoStepAddTime;
uint8_t CANMOD = 0;
void Button_Statu_Manage()
{
    uint8_t checkSum;
    
    if (0 == Button_Press)
    {
        if(Botton.S30.Flag == 1){   //30
            if(Botton.S30.Time < 3000){
                    Botton.S30.Time += IntervalTimerDelta;
                    
            }
            }
        else{
            if(Botton.S30.Time > 300){
                    Botton.S30.Statu = 1;
                Button_Press= 1;
                Button_Value=1;
            }
            Botton.S30.Time = 0;
        }
        
        if(Botton.S15.Flag == 1){  //15
            if(Botton.S15.Time < 3000){
                    Botton.S15.Time += IntervalTimerDelta;
            }
            }else{
            if(Botton.S15.Time > 300){
                    Botton.S15.Statu = 1;
                Button_Press= 1;
                Button_Value=2;
            }
            Botton.S15.Time = 0;
        }
        
        if(Botton.Auto.Flag == 1){  //AUTO
            if(Botton.Auto.Time < 3000){
                    Botton.Auto.Time += IntervalTimerDelta;
            }
            }else{
            if(Botton.Auto.Time > 300){
                    Botton.Auto.Statu = 1;
                Button_Press= 1;
                Button_Value=3;
            }
            Botton.Auto.Time = 0;
        }
        
        if(Botton.EOL.Flag == 1){  //EOL
            if(Botton.EOL.Time < 3000)
                Botton.EOL.Time += IntervalTimerDelta;
            }else{
            if(Botton.EOL.Time > 300){
                    Botton.EOL.Statu = 1;
                Button_Press= 1;
                Button_Value=13;
            }
            Botton.EOL.Time = 0;
        }
        
        if(Botton.SpeedUp.Flag == 1)
        { //SPEED UP
            if(Botton.SpeedUp.Time < 3000)
            {
                    Botton.SpeedUp.Time += IntervalTimerDelta;
            }
         } 
        else{
            if(Botton.SpeedUp.Time > 300)
            {
                Botton.SpeedUp.Statu = 1;
                Button_Press= 1;
                Button_Value=5;
                xunhuan=0;
                Speed_down_long=0;
                
            }
            Botton.SpeedUp.Time = 0;
        }
        
        if(Botton.SpeedDown.Flag == 1)
        {  //SPEED DOWN
           if(Botton.SpeedDown.Time < 3000)
            {
                    Botton.SpeedDown.Time += IntervalTimerDelta;
             
            }

         }
        else
        {
         if(Botton.SpeedDown.Time > 300)
            {
                Botton.SpeedDown.Statu = 1;
                    
                Button_Press= 1;
                Button_Value=6;
                xunhuan=0;
            }
            Botton.SpeedDown.Time = 0;
          }
       
    //    if((Botton.SpeedDown.Flag == 1)&&(Botton.SpeedDown.Time >= 3000))
    //      {
          
    //       Speed_down_long=1;
       
    //      }
    //     else
    //     {
    //        //Speed_down_long=0;
    //       // AutoStepAddTime=0; 
    //     }
         
        
        
        if(Botton.LED.Flag == 1){            //LED
            if(Botton.LED.Time < 3000){
                    Botton.LED.Time += IntervalTimerDelta;
                
            }
            }else{
            
            if(Botton.LED.Time > 300 && Botton.LED.Time <= 2900){
                    Botton.LED.Statu = 1;
                Button_Press= 1;
                Button_Value= 4;
                LedCurrent.Flag = 0;
                
            }
            if(Botton.LED.Time > 2900)
            {
                LedCurrent.Flag = 1;
            }
            Botton.LED.Time = 0;
            
        }
        if(Botton.FuelWaterUp.Flag == 1){   //IOL UP
            if(Botton.FuelWaterUp.Time < 3000)
                Botton.FuelWaterUp.Time += IntervalTimerDelta;
            }else{
            if(Botton.FuelWaterUp.Time > 300){
                    Botton.FuelWaterUp.Statu = 1;
                Button_Press= 1;
                Button_Value= 7;
            }
            Botton.FuelWaterUp.Time = 0;
        }
        
        if(Botton.FuelWaterDown.Flag == 1){   //IOL DOWN
            if(Botton.FuelWaterDown.Time < 3000)
                Botton.FuelWaterDown.Time += IntervalTimerDelta;
            }else{
            if(Botton.FuelWaterDown.Time > 300){
                    Botton.FuelWaterDown.Statu = 1;
                Button_Press= 1;
                Button_Value= 8;
            }
            Botton.FuelWaterDown.Time = 0;
        }
        
        if(Botton.TFTUp.Flag == 1)
        {   //TFT UP
            if(Botton.TFTUp.Time < 3000)
                Botton.TFTUp.Time += IntervalTimerDelta;
         }else
         {
            if( TFTUp_Switch!=1)
            {
                //TFTCurrent.Time = 0;
                //TFTCurrent.enable = 0;
            }
            //if((Botton.TFTUp.Time > 100)&& (Botton.TFTUp.Time < 800))
            if(Botton.TFTUp.Time > 300)
            {
                Botton.TFTUp.Statu = 1;
                Button_Press= 1;
                Button_Value= 9;
                
            }
            else if (Botton.TFTUp.Time > 2900) 
            {
                    TFTUp_Switch = 1;
                TFTCurrent.count = 0;
                Button_Value = 14;
                Botton.TFTUp.Statu = 1;
                
            }
           
            Botton.TFTUp.Time = 0;
          
            
        }
        
        if(Botton.TFTDown.Flag == 1)
        {   //TFT DOWN
            if(Botton.TFTDown.Time < 3000)
                Botton.TFTDown.Time += IntervalTimerDelta;
         }else
         {
            if(Botton.TFTDown.Time > 300){
                    Botton.TFTDown.Statu = 1;
                Button_Press= 1;
                Button_Value=10;
                TFTUp_Switch = 0;
            }
            Botton.TFTDown.Time = 0;
        }
        
        if(Botton.Other.Flag == 1){   //ELSE
            if(Botton.Other.Time < 3000)
                Botton.Other.Time += IntervalTimerDelta;
            }else{
            if(Botton.Other.Time > 300){
                    Botton.Other.Statu = 1;
                Button_Press= 1;
                Button_Value=11;
                CANMOD++;
                //ElseCurrent.enable = 1;
            }
            Botton.Other.Time = 0;
        }
        
        if(CANMOD>1){
            CANMOD=0;
          }
        if(Botton.End.Flag == 1)
        {   //END
            if(Botton.End.Time < 3000)
                Botton.End.Time += IntervalTimerDelta;
        }else
        {
            if(Botton.End.Time > 100 && Botton.End.Time < 2000)
            {
                Botton.End.Statu = 1;
                Button_Press= 1;
                Button_Value=12;
            }
            if(Botton.End.Time > 2900)
            {
                bsp_Save_Check_Service(3);// �������
                Diaplay_test = NewData.Data1;
            }
            Botton.End.Time = 0;
        }
        
    }
    
    /*added by k --  set button_val*/
    
    
    if (1==Button_Press)
    {
        Button_Press = 0;
        /*
        g_butto_msg[0] = 0xFF;
        g_butto_msg[1] = 0x01;
        g_butto_msg[2] = 0x01;
        g_butto_msg[3] = Button_Value;
        */
        
        g_butto_msg[0] = 0xFF;
        g_butto_msg[1] = 0x1;
        g_butto_msg[2] = 0x1;
        g_butto_msg[3] = Button_Value;
        
        
        checkSum = Calc_Checksum(g_butto_msg, 4);
        
        g_butto_msg[4] = checkSum;
        
        
        start_uart_timer=1;
        
        //if (uart_send_flag==1)
        //{
            Mfs_Uart_Write(UART0_Type, g_butto_msg, 5, TRUE);
                uart_send_flag=0;
        //}
        
    }
}



/*-------------------------------------------------------------------------
* Function Name  : StageManage
* Description    : ��ⲽ�账��
* Input          : None
* Output         : None
* Return         : None
* onther         : xxhh
--------------------------------------------------------------------------*/
uint8_t SW_Data[8];
//uint8_t HW_Data[8];
//uint8_t Manage_Data[8];
uint8_t SendSW_HW;
extern uint8_t uuidWriteFlag;
extern uint8_t uuidWriteStep;
extern uint8_t UUIDData_Write[22];
extern uint8_t GetInfoStep;
void Stage_Manage()
{
    uint8_t i;
    if(Botton.Auto.Statu == 1){
            Botton.Auto.Statu = 0;
        g_Stage = STAGE_PreWarning;
        
        memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
        memset(&CheckCurrent,0,sizeof(CheckCurrent));
        if((g_UDS.Statu == UNFINISH) || (g_OldStage != g_Stage) || (StaticCurrent.statu == UNFINISH) || (ButtomCurrent.statu == UNFINISH)){
                //���δͨ��                �������                   ��̬����δͨ��
            UDSSend = 0;
            g_UDS.Statu = 0;
            SendSW_HW = 0;
            g_UDS.Time = 0;
            ErrorCode = 0;
            StaticCurrent.statu = 0;
            StaticCurrent.Flag = 0;
            //StaticCurrent.Time = 0;
            StaticCurrent.enable = 0;
            ButtomCurrent.statu = 0;
            ButtomCurrent.Flag = 0;
            ButtomCurrent.count = 0;
            MyRecvCount = 0;
            
            memset(&SW_Data,0,sizeof(SW_Data));
            memset(&MultiplePack,0,sizeof(MultiplePack));
            
            Auto_HW_flag = 0;
            RxFinish = 0;
            ButtomCurrent.Time = 0;
            
        }
    }
    
    if(Botton.S30.Statu == 1){  // 30
            Botton.S30.Statu = 0;
            B_step++;
        LampState_L.Lamps.RELAY_B = ~LampState_L.Lamps.RELAY_B;
        memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
        memset(&CheckCurrent,0,sizeof(CheckCurrent));
    }
    
    if(Botton.S15.Statu == 1){  // 15
            Botton.S15.Statu = 0;
            IG_step++;
        LampState_L.Lamps.RELAY_IGN1 = ~LampState_L.Lamps.RELAY_IGN1;
        if(LampState_L.Lamps.RELAY_IGN1){
            ButtomCurrent.enable = 0;
        }
        memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
        memset(&CheckCurrent,0,sizeof(CheckCurrent));
    }
    
    if(Botton.EOL.Statu == 1){  //EOL
            Botton.EOL.Statu = 0;
        g_Stage = STAGE_SetEOL;
        EOL.Flag = 0;
        EOL.Statu = 0;
        memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
        memset(&CheckCurrent,0,sizeof(CheckCurrent));
    }
    
    if(Botton.SpeedUp.Statu == 1){  // SPEED UP
            Botton.SpeedUp.Statu = 0;
        g_Stage = STAGE_TelltaleAndSpeed;
        SpeedCurrent.count ++;
        SPEED_step++;
        run_step=SPEED_step;
        if(uuidWriteFlag){
            if(uuidWriteStep < 21){
                uuidWriteStep++;
            }
            else{
                uuidWriteStep = 0;
            }
        }

        
//        if(SPEED_step>=8)
//        {
//          SPEED_step=0;
//        }
        memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
        memset(&CheckCurrent,0,sizeof(CheckCurrent));
        if(SpeedCurrent.count > 32)
            SpeedCurrent.count = 0;
    }
    if(Botton.SpeedDown.Statu == 1){ // SPEED DOWN
            Botton.SpeedDown.Statu = 0;
        g_Stage = STAGE_TelltaleAndSpeed;
        memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
        memset(&CheckCurrent,0,sizeof(CheckCurrent));

        if(SPEED_step>100)
        {
          //SPEED_step=1;
        }

        else 
        run_step=SPEED_step-1;
        SPEED_step--;
        if(uuidWriteFlag){
            if(uuidWriteStep < 21){
                UUIDData_Write[uuidWriteStep]++;
                if(UUIDData_Write[uuidWriteStep] > 0x39){
                    UUIDData_Write[uuidWriteStep] = 0x30;
                }
            }
            else if(uuidWriteStep == 21){
                GetInfoStep = 10;   //��ʼд��UUID
            }
        }
        
        if(SpeedCurrent.count == 0){
                SpeedCurrent.count = 33;
        }
        SpeedCurrent.count--;
    }
    if(Botton.LED.Statu == 1){   //LED
            Botton.LED.Statu = 0;
        g_Stage = STAGE_TelltaleAndSpeed;
        LedCurrent.count ++;
        memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
        memset(&CheckCurrent,0,sizeof(CheckCurrent));
        //LedCurrent.Flag = 0;
        LIG_step++ ;
        if(BDC_PE_ALL == 2)
        {if(LedCurrent.count > 33){
                LedCurrent.count = 0;
        }}
        if(BDC_PE_ALL == 1)
          {if(LedCurrent.count > 34){
                LedCurrent.count = 0;
        }}
    }
    /*if(LedCurrent.Flag == 1) //LED ������־
    {
        if(LedCurrent.count > 32){
                LedCurrent.count = 32;
            LedCurrent.Flag = 0;
        }
    }*/
    if(Botton.FuelWaterUp.Statu == 1){ // IOL UP
            Botton.FuelWaterUp.Statu = 0;
        g_Stage = STAGE_WaterAndFuil;
        memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
        memset(&CheckCurrent,0,sizeof(CheckCurrent));
        Iol_TempCurrent.enable = 1;
        Iol_TempCurrent.count ++;
        if(Iol_TempCurrent.count > 6){
                Iol_TempCurrent.count = 6;
        }
    }
    
    if(Botton.FuelWaterDown.Statu == 1){ // IOL down
            Botton.FuelWaterDown.Statu = 0;
        g_Stage = STAGE_WaterAndFuil;
        memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
        memset(&CheckCurrent,0,sizeof(CheckCurrent));
        Iol_TempCurrent.enable = 1;
        //if((Iol_TempCurrent.count==0)||(Iol_TempCurrent.count==1))
        if(Iol_TempCurrent.count==0)
        {
               Iol_TempCurrent.count= 6;
        }
        
        Iol_TempCurrent.count --;
    }
    
    if(Botton.TFTUp.Statu == 1){ // TFT UP   ����
            Botton.TFTUp.Statu = 0;
        g_Stage = STAGE_TFTCheck;
        memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
        memset(&CheckCurrent,0,sizeof(CheckCurrent));
        TFTCurrent.count ++;

        TFT_step ++;
        if(TFT_step>=17)
        {
          TFT_step=0;
        }
        InitPressTripKey();
        if(TFTCurrent.count > 29){
                TFTCurrent.count = 0;
        }
    }
    
    if(Botton.TFTDown.Statu == 1){ // TFT down  ����
            Botton.TFTDown.Statu = 0;
        g_Stage = STAGE_TFTCheck;
        memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
        memset(&CheckCurrent,0,sizeof(CheckCurrent));
        InitPressTripKey();
        TFT_step --;
      
        if(TFTCurrent.count == 0){
                TFTCurrent.count= 30;
        }
        TFTCurrent.count --;
    }
    
    if(Botton.Other.Statu == 1){ // ELSE
            Botton.Other.Statu = 0;
        g_Stage = STAGE_Other;
        memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
        memset(&CheckCurrent,0,sizeof(CheckCurrent));
        ElseCurrent.count ++;
        MODEtimer = 0;
        ElseCurrent.Value = 0;
        InitPressTripKey();
        
        if(ElseCurrent.count > 8)
        {
                ElseCurrent.count  = 1;
        }
        
    
    }
    
    if(Botton.End.Statu == 1){ // END
            Botton.End.Statu = 0;
        g_Stage = STAGE_ClearODO;
        memset(&BuzzerAlarm, 0, sizeof(BuzzerAlarm));
        memset(&CheckCurrent,0,sizeof(CheckCurrent));
        if((EndCurrent.Flag != FINISH) || (g_OldStage != g_Stage) )
        {
            EndCurrent.Flag = 0;
            EndCurrent.statu = 0;
            EndCurrent.Time = 0;
            EndCurrent.count = OFF;
            EndCurrent.enable = 1;
          //  LampState_M.Lamps.TripSW1_7 = 0;
        }
    }
    
    g_OldStage = g_Stage;
    
    if(g_Stage != STAGE_PreWarning)
    {
      //  LampState_M.Lamps.TripSW2_6 = 0;
        Auto_HW_flag = 0;
        ErrorCode = 0;
        StaticCurrent.Finsh = 0;
        CANSendEnable = ON;
        ButtomCurrent.Time = 0;
        
    }
    if(g_Stage != STAGE_SetEOL)
    {
     //   LampState_M.Lamps.TripSW1_2 = 0;
    }
    if(g_Stage != STAGE_TelltaleAndSpeed)
    {
        //Port_SetPortPinLevel(2, 0, 0); //AIRBAG
        
       // Port_SetPortPinLevel(2, 3, 0);   //��ȫ��
        
        //Port_SetPortPinLevel(2, 20, 0); //����ѹ��
        
        //SpeedCurrent.count = 0;
        LedCurrent.count = 0;
        LedCurrent.enable = 0;
        LedCurrent.Flag = 0;
        
     //   LampState_M.Lamps.TripSW1_3 = 0;
    }
    
//    if(g_Stage != STAGE_WaterAndFuil)
//    {
//        EMS12.msg.bits.TEMP_ENG = 0x0 ;   //62.25        SEG4 һ��
//        LampState_L.Lamps.LED7 = 0;   
//        LampState_L.Lamps.LED6 = 0;
//        LampState_L.Lamps.LED5 = 0;
//        LampState_L.Lamps.LED4 = 1;
//        Iol_TempCurrent.count = 0;
//        Iol_TempCurrent.statu = UNFINISH;
//     //   LampState_M.Lamps.TripSW1_4 = 0;
//    }
    
    if(g_Stage != STAGE_TFTCheck)
    {
        TFTCurrent.count = 0;
        TFTCurrent.statu = 0;
     //   LampState_M.Lamps.TripSW1_5 = 0;
    }
    
    if(g_Stage != STAGE_Other)
    {
        ElseCurrent.count = 0;
        ElseCurrent.enable = 0;
        ElseCurrent.statu = 0;
        ElseCurrent.Flag = 0;
        ElseCurrent.Finsh = 0;
    //    LampState_M.Lamps.TripSW1_6 = 0;
        Port_SetPortPinLevel(2, 19, 0); // �����������ִ�
        //Port_SetPortPinLevel(2, 21, 0); //BREAK OIL
        //Port_SetPortPinLevel(2, 14, 0 ); // ����
        //Port_SetPortPinLevel(2, 29, 0); // ����ʻ��ȫ��
        Port_SetPortPinLevel(2, 28, 0);
        Port_SetPortPinLevel(2, 26, 0);
        //Port_SetPortPinLevel(0, 0, 0);//���ر���
    }
    if(g_Stage != STAGE_ClearODO)
    {
     //   LampState_M.Lamps.TripSW1_7 = 0;
    }
    
    switch(g_Stage)
    {
        case 0:
            LampState_M.Lamps.LED1 = 0;
            LampState_M.Lamps.LED2 = 0;
            LampState_M.Lamps.LED3 = 0;
            LampState_M.Lamps.LED4 = 0;
            LampState_M.Lamps.LED5 = 0;
            LampState_M.Lamps.LED6 = 0;
            LampState_M.Lamps.LED7 = 0;
            //LampState_M.Lamps.TripSW2_1 = 1;
            break;
        case STAGE_PreWarning:
            APP_AUTO();
            LampState_M.Lamps.LED1 = 1;
            break;
            
        case STAGE_SetEOL: //eol
            APP_EOL();
            LampState_M.Lamps.LED2 = 1;
            break;
            
        case STAGE_TelltaleAndSpeed: //speed led
            //LampState_L.Lamps.RELAY_IGN1=1;
            LampState_M.Lamps.LED3 = 1;
            APP_CAN_Output_Show();
            
            break;
            
        case STAGE_WaterAndFuil://IOL
            Gui_Temp();
            LampState_M.Lamps.LED4 = 1;
            break;
            
        case STAGE_TFTCheck://TFT
            APP_TFT_OUTPUT();
            LampState_M.Lamps.LED5 = 1;
            break;
            
        case STAGE_Other:  // ELSE
            LampState_M.Lamps.LED6 = 1;
            APP_ELSE();
            break;
            
        case STAGE_ClearODO:  //END
            LampState_M.Lamps.LED7 = 1;
            APP_END();
            break;
            
        default:
            break;
    }
}


void Delay(uint16_t msec)
{
    int i = 0;
    int n = 0;
    for (n = 0; n < msec; n++)
    for (i = 0; i < 9600; i++);
}

uint8_t CluPartNum[16] = {0};
uint8_t GetPartNumSent = 0;
uint8_t GetPartNumFinish = 0;
uint16_t GetPartNumTimerCnts = 0;
void GetPartNum(void)
{
    if (GetPartNumSent == 0) {
        GetPartNumSent = 1;
        memset(CluPartNum, 0, sizeof (CluPartNum));
        memset(&MultiplePack, 0, sizeof (MultiplePack));
        MyRecvCount = 0;
        GetPartNumFinish = 0;
        GetPartNumTimerCnts = 0;
        
        Send_7CE_Data.Byte0Data = 0x03;
        Send_7CE_Data.Byte1Data = 0x22;
        Send_7CE_Data.Byte2Data = 0xF1;
        Send_7CE_Data.Byte3Data = 0x95;
        //CanFD_Send_StandMsg(CANFD0_Type, 0x660, BUF_27, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 4);
        RxFinish = UNFINISH;
    }
    if (RxFinish == UNFINISH) {  //��ȡ����
        if (MyRecvCount >= 10) {
            if ((MultiplePack.Data[0] == '9') && (MultiplePack.Data[1] == '4')) {
                memcpy(CluPartNum, MultiplePack.Data, 10);
                memset(&MultiplePack, 0, sizeof (MultiplePack));
                GetPartNumFinish = 1;
            }
        } else {
            if (GetPartNumFinish == 0) {
                if (GetPartNumSent == 1) {
                    if (GetPartNumTimerCnts < 500) {
                        GetPartNumTimerCnts++;
                    }
                    if (GetPartNumTimerCnts >= 150) {
                        GetPartNumSent = 0;
                    } else {
                        if (GetPartNumTimerCnts >= 50) {
                            UpdateGetClusterPartNum();
                        }
                    }
                }
            }
        }
    }
}


uint8_t GetInfoStep = 0;
uint32_t GetInfoDelayTime = 0;
uint8_t UUIDData[32];
uint8_t UUIDData_Write[22] = {0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x00};
uint8_t SW_VERSION_DATA[32];
uint8_t HW_VERSION_DATA[32];
uint8_t PartNum_DATA[32];
extern void WriteUUID(uint8_t* data);
extern uint8_t uuidWriteFlag;
void GetInfo(void)
{
    uint8_t temp[21];
    switch(GetInfoStep)
    {
        case 0:
            GetInfoDelayTime = 2000;
            GetInfoStep = 1;
            break;
    
        case 1:
            if(GetInfoDelayTime == 0){
                Send_701_Data.Byte0Data = 0x03;
                Send_701_Data.Byte1Data = 0x22;
                Send_701_Data.Byte2Data = 0x0F;
                Send_701_Data.Byte3Data = 0xA0;
                Send_701_Data.Byte4Data = 0x00;
                Send_701_Data.Byte5Data = 0x00;
                Send_701_Data.Byte6Data = 0x00;
                Send_701_Data.Byte7Data = 0x00;            
                CanFD_Send_StandMsg(CANFD0_Type, 0x660, BUF_27, TX_ISR_EN, (uint8_t*)&Send_701_Data.mdata, 8);  
                RxFinish = UNFINISH;
                GetInfoStep = 2;
                GetInfoDelayTime = 500;
            }
            break;
        case 2:
            if(RxFinish == FINISH){
                if ((MultiplePack.Data[3] == 0x0f) && (MultiplePack.Data[4] == 0xa0)) {
                    for(uint8_t i=0; i<21; i++){
                        UUIDData[i] = MultiplePack.Data[5+i];
                    }
                }
                if(uuidWriteFlag){
                    GetInfoDelayTime = 500;
                    GetInfoStep = 1;
                }
                else{
                    GetInfoStep = 3;
                }                 
            }
            else if(GetInfoDelayTime == 0){
                for(uint8_t i=0; i<21; i++){
                    UUIDData[i] = 0;
                }                
                if(uuidWriteFlag){
                    GetInfoStep = 1;
                }
                else{
                    GetInfoStep = 3;
                } 
            }
           
            break;
        case 3:
            Send_701_Data.Byte0Data = 0x03;
            Send_701_Data.Byte1Data = 0x22;
            Send_701_Data.Byte2Data = 0xF1;
            Send_701_Data.Byte3Data = 0x95;
            Send_701_Data.Byte4Data = 0x00;
            Send_701_Data.Byte5Data = 0x00;
            Send_701_Data.Byte6Data = 0x00;
            Send_701_Data.Byte7Data = 0x00;            
            CanFD_Send_StandMsg(CANFD0_Type, 0x660, BUF_27, TX_ISR_EN, (uint8_t*)&Send_701_Data.mdata, 8);  
            RxFinish = UNFINISH;
            GetInfoStep = 4;
            GetInfoDelayTime = 500;

            break;
        case 4:
            if(RxFinish == FINISH){
                if ((MultiplePack.Data[3] == 0xF1) && (MultiplePack.Data[4] == 0x95)) {
                    memcpy(SW_VERSION_DATA, &MultiplePack.Data[5], 12);
                }
                GetInfoStep = 5;
              
            }
            else if(GetInfoDelayTime == 0){
                memset(&SW_VERSION_DATA, 0, sizeof(SW_VERSION_DATA));
                GetInfoStep = 5;
            }
            
            break;   
        case 5:
            Send_701_Data.Byte0Data = 0x03;
            Send_701_Data.Byte1Data = 0x22;
            Send_701_Data.Byte2Data = 0xF1;
            Send_701_Data.Byte3Data = 0x93;
            Send_701_Data.Byte4Data = 0x00;
            Send_701_Data.Byte5Data = 0x00;
            Send_701_Data.Byte6Data = 0x00;
            Send_701_Data.Byte7Data = 0x00;            
            CanFD_Send_StandMsg(CANFD0_Type, 0x660, BUF_27, TX_ISR_EN, (uint8_t*)&Send_701_Data.mdata, 8);  
            RxFinish = UNFINISH;
            GetInfoStep = 6;
            GetInfoDelayTime = 500;

            break;
        case 6:
            if(RxFinish == FINISH){
                if ((MultiplePack.Data[3] == 0xF1) && (MultiplePack.Data[4] == 0x93)) {
                    memcpy(HW_VERSION_DATA, &MultiplePack.Data[5], 6);
                }
                GetInfoStep = 7;
            }
            else if(GetInfoDelayTime == 0){
                memset(&HW_VERSION_DATA, 0, sizeof(SW_VERSION_DATA));
                GetInfoStep = 7;
            }
            
            break;                
        case 7:
            Send_701_Data.Byte0Data = 0x03;
            Send_701_Data.Byte1Data = 0x22;
            Send_701_Data.Byte2Data = 0xF1;
            Send_701_Data.Byte3Data = 0x87;
            Send_701_Data.Byte4Data = 0x00;
            Send_701_Data.Byte5Data = 0x00;
            Send_701_Data.Byte6Data = 0x00;
            Send_701_Data.Byte7Data = 0x00;            
            CanFD_Send_StandMsg(CANFD0_Type, 0x660, BUF_27, TX_ISR_EN, (uint8_t*)&Send_701_Data.mdata, 8);  
            RxFinish = UNFINISH;
            GetInfoStep = 8;
            GetInfoDelayTime = 500;

            break;
        case 8:
            if((RxFinish == FINISH)){
                if ((MultiplePack.Data[3] == 0xF1) && (MultiplePack.Data[4] == 0x87)) {
                    memcpy(PartNum_DATA, &MultiplePack.Data[5], 12);
                }
                GetInfoDelayTime = 500;
                GetInfoStep = 1;
             
            }
            else if(GetInfoDelayTime == 0){
                memset(&PartNum_DATA, 0, sizeof(SW_VERSION_DATA));
                GetInfoStep = 1;
            }   
            
            break;  

        case 10:
            if((RxFinish == FINISH) || (GetInfoDelayTime == 0)){

                WriteUUID(UUIDData_Write);
                GetInfoDelayTime = 500;
                GetInfoStep = 1;
              
            }
            break;  

            
        default:
            break;
    }
}

#define KeyK  0x0000000F
uint32_t CalculateKey ( uint8_t *Seed )  
{
   
    uint32_t SaceeSeed ,KeyResult;
    SaceeSeed =0;
    KeyResult =0;
   
    
    SaceeSeed = (uint8_t)Seed[0];
    SaceeSeed = (SaceeSeed << 8)  | (uint8_t)Seed[1];
    SaceeSeed = (SaceeSeed << 8) |(uint8_t)Seed[2];
    SaceeSeed = (SaceeSeed << 8) |(uint8_t)Seed[3];
    
    KeyResult = (( (( SaceeSeed>>1 ) ^ SaceeSeed) <<3) ^ (SaceeSeed >> 2));
    
    KeyResult = KeyResult ^ KeyK; 
    
    return KeyResult;

}

void WriteUUID(uint8_t* data)
{
    uint8_t  seed[4];
    uint32_t  key = 0;
    Send_701_Data.Byte0Data = 0x02;
    Send_701_Data.Byte1Data = 0x10;
    Send_701_Data.Byte2Data = 0x03;

    CanFD_Send_StandMsg(CANFD0_Type, 0x660, BUF_1, TX_ISR_EN, (uint8_t*)&Send_701_Data.mdata, 3);
    Delay(50);//50ms

    Send_701_Data.Byte0Data = 0x02;
    Send_701_Data.Byte1Data = 0x27;
    Send_701_Data.Byte2Data = 0x01;    
    CanFD_Send_StandMsg(CANFD0_Type, 0x660, BUF_1, TX_ISR_EN, (uint8_t*)&Send_701_Data.mdata, 3);
    Delay(200);//200ms

    seed[0] = Receive_709_Data.data[3];
    seed[1] = Receive_709_Data.data[4];
    seed[2] = Receive_709_Data.data[5];
    seed[3] = Receive_709_Data.data[6];
    //�����㷨
    key = CalculateKey(seed);

    Send_701_Data.Byte0Data = 0x06;
    Send_701_Data.Byte1Data = 0x27;
    Send_701_Data.Byte2Data = 0x02;
    Send_701_Data.Byte3Data = (key >> 24) & 0xff;
    Send_701_Data.Byte4Data = (key >> 16) & 0xff;
    Send_701_Data.Byte5Data = (key >> 8) & 0xff;
    Send_701_Data.Byte6Data = (key >> 0) & 0xff;
    CanFD_Send_StandMsg(CANFD0_Type, 0x660, BUF_1, TX_ISR_EN, (uint8_t*)&Send_701_Data.mdata, 7);
    Delay(100);//100ms
    if((Receive_709_Data.data[1] == 0x67) && (Receive_709_Data.data[2]== 0x02))
    {
        Send_701_Data.Byte0Data = 0x10;
        Send_701_Data.Byte1Data = 0x18;
        Send_701_Data.Byte2Data = 0x2E;
        Send_701_Data.Byte3Data = 0x0F;
        Send_701_Data.Byte4Data = 0xA0;
        Send_701_Data.Byte5Data = data[0];
        Send_701_Data.Byte6Data = data[1];
        Send_701_Data.Byte7Data = data[2];       
        CanFD_Send_StandMsg(CANFD0_Type, 0x660, BUF_27, TX_ISR_EN, (uint8_t*)&Send_701_Data.mdata, 8);  
        Delay(100);//50ms

        Send_701_Data.Byte0Data = 0x21;
        Send_701_Data.Byte1Data = data[3];
        Send_701_Data.Byte2Data = data[4];
        Send_701_Data.Byte3Data = data[5];
        Send_701_Data.Byte4Data = data[6];
        Send_701_Data.Byte5Data = data[7];
        Send_701_Data.Byte6Data = data[8];
        Send_701_Data.Byte7Data = data[9];       
        CanFD_Send_StandMsg(CANFD0_Type, 0x660, BUF_27, TX_ISR_EN, (uint8_t*)&Send_701_Data.mdata, 8);  
        Delay(50);//50ms

        Send_701_Data.Byte0Data = 0x22;
        Send_701_Data.Byte1Data = data[10];
        Send_701_Data.Byte2Data = data[11];
        Send_701_Data.Byte3Data = data[12];
        Send_701_Data.Byte4Data = data[13];
        Send_701_Data.Byte5Data = data[14];
        Send_701_Data.Byte6Data = data[15];
        Send_701_Data.Byte7Data = data[16];       
        CanFD_Send_StandMsg(CANFD0_Type, 0x660, BUF_27, TX_ISR_EN, (uint8_t*)&Send_701_Data.mdata, 8);  
        Delay(50);//50ms


        Send_701_Data.Byte0Data = 0x23;
        Send_701_Data.Byte1Data = data[17];
        Send_701_Data.Byte2Data = data[18];
        Send_701_Data.Byte3Data = data[19];
        Send_701_Data.Byte4Data = data[20];
        Send_701_Data.Byte5Data = 0xAA;
        Send_701_Data.Byte6Data = 0xAA;
        Send_701_Data.Byte7Data = 0xAA;   
        CanFD_Send_StandMsg(CANFD0_Type, 0x660, BUF_27, TX_ISR_EN, (uint8_t*)&Send_701_Data.mdata, 8);  
        Delay(100);//100ms

        if((Receive_709_Data.data[0] == 0x03) && (Receive_709_Data.data[1] == 0x6E) && (Receive_709_Data.data[2]== 0x0f) && (Receive_709_Data.data[3]== 0xA0))
        {
            uint8_t i= 0;
            UUIDData_Write[20] += 1;
            for(i=0; i<7; i++){
                if(UUIDData_Write[20-i] > 0x39){
                    UUIDData_Write[20-i] = 0x30;
                    UUIDData_Write[19-i] += 1;
                }
                else{
                    break;
                }

            }
            if(UUIDData_Write[13] > 0x39){
                UUIDData_Write[13] = 0;
            }
        }
    }
}










extern uint8_t EOL_Flag;
uint8_t StartCurrent = 0u;
void APP_AUTO(void)
{
  
    Default_flag=1;
    uint8_t i;
    
    
    if (ButtomCurrent.Time > 0 && ButtomCurrent.Time < 500 && SendSW_HW != FINISH) {
        Auto_HW_flag = 1;
        SendCan0Message_7DF();
        if(UDSSend == ON)
        {
            UDSSend = OFF;
        }
        EOL_Flag = 1;
    }
    if (ButtomCurrent.Time > 500 && ButtomCurrent.Time < 1000 && SendSW_HW != FINISH) {
        if(UDSSend == OFF && Auto_HW_flag == 2) {
            memset(SW_Data,0 , 8);
            memset(MultiplePack.Data,0,128);
            //memset(HW_Data,0 , 8);
            StaticCurrent.statu = 0;
            Send_7CE_Data.Byte0Data = 0x03;
            Send_7CE_Data.Byte1Data = 0x22;
            Send_7CE_Data.Byte2Data = 0xF1;
            Send_7CE_Data.Byte3Data = 0x95;
            //CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_27, TX_ISR_EN, (uint8_t*)&Send_7CE_Data.mdata, 4);
            RxFinish = UNFINISH;
            UDSSend = ON;
        }
    }
    
    if (RxFinish == UNFINISH) {  //��ȡ����
        Delay(20);
        if ((MultiplePack.Data[0] == 0x42) && (MultiplePack.Data[3] == 0x54)) {
            if ( MultiplePack.Data[13] >= 0x30)
                SW_Data[0] = MultiplePack.Data[13] - 0x30;
            else
                SW_Data[0] = MultiplePack.Data[13];
            if(MultiplePack.Data[15] >= 0x30)
                SW_Data[1] = MultiplePack.Data[15] - 0x30;
            else
                SW_Data[1] = MultiplePack.Data[15];
            if(MultiplePack.Data[16] >= 0x30)
                SW_Data[2] = MultiplePack.Data[16] - 0x30;
            else
                SW_Data[2] = MultiplePack.Data[16];
            if(MultiplePack.Data[21] >= 0x30)
                SW_Data[3] = MultiplePack.Data[21] - 0x30;
            else
                SW_Data[3] = MultiplePack.Data[21];
            if(MultiplePack.Data[23] >= 0x30)
                SW_Data[4] = MultiplePack.Data[23] - 0x30;
            else
                SW_Data[4] = MultiplePack.Data[23];
            if(MultiplePack.Data[25] >= 0x30)
                SW_Data[5] = MultiplePack.Data[25] - 0x30;
            else
                SW_Data[5] = MultiplePack.Data[25];
            
            SendSW_HW = FINISH;
            Auto_HW_flag = 0;
            EOL_Flag = 0;
            ButtomCurrent.count = 0;
        }
    } else if ((ButtomCurrent.Time > 1900) && (MultiplePack.Data[0] != 0x42)){
        ErrorCode = 101;//���ش�����
        EOL_Flag = 0;
        SendSW_HW = FINISH;
    }
    
    if ((SendSW_HW == FINISH) && (ButtomCurrent.statu != FINISH)) {
        CANSendEnable = OFF; 
        SendCan0Message_7DF_ectype();
        if (ButtomCurrent.statu == OFF) {
            ButtomCurrent.enable = 1;
            if(ButtomCurrent.Time < 2000)
                ButtomCurrent.count = 1;
            if ((ButtomCurrent.Time > 2000 && ButtomCurrent.Time < 2300)) {
                ButtomCurrent.count = 1;
                if(CAN_0x4F1 == 0)
                    ButtomCurrent.count = 2;
                if(CAN_0x391 == 0)
                    ButtomCurrent.count = 2;
                if(CAN_0x50c == 0)
                    ButtomCurrent.count = 2;
                if(CAN_0x5b0 == 0)
                    ButtomCurrent.count = 2;
                if(CAN_0x52A == 0)
                    ButtomCurrent.count = 2;
                if(CAN_0x1D4 == 0)
                    ButtomCurrent.count = 2;
                if(CAN_0x1D5 == 0)
                    ButtomCurrent.count = 2;
                if(CAN_0x1DF == 0)
                    ButtomCurrent.count = 2;
                if(CAN_0x4A6 == 0)
                    ButtomCurrent.count = 2;
            } else if (ButtomCurrent.Time > 2300 && ButtomCurrent.Time < 3300) {
                CGW2.msg.bits.CF_Gway_ICUPowerAutoCutMode=0x0;
                LampState_M.Lamps.TripSW2_1  = 0;//SW1_OK
            } else if (ButtomCurrent.Time > 3300 && ButtomCurrent.Time < 7300) {
                CGW2.msg.bits.CF_Gway_ICUPowerAutoCutMode=0x0;
                LampState_M.Lamps.TripSW2_1  = 1;//SW1_OK
            } else if (ButtomCurrent.Time > 7300 && ButtomCurrent.Time < 7500) {
                if(CAN_0x51B == 1) {
                    //CAN_0x51B = 0;
                } else {
                    //ButtomCurrent.count = 2;
                }
            } else if (ButtomCurrent.Time > 7500 && ButtomCurrent.Time < 8500) {
                CAN_0x51B = 0;
                CGW_PC11.SCU_N_MODE = 1;
                LampState_M.Lamps.TripSW2_1  = 0;//SW1_OK
            } else if (ButtomCurrent.Time > 8500 && ButtomCurrent.Time < 12500) {
                CGW_PC11.SCU_N_MODE = 1;
                LampState_M.Lamps.TripSW2_1  = 1;//SW1_OK
            } else if (ButtomCurrent.Time > 12500 && ButtomCurrent.Time < 12700) {
                if(CAN_0x5C2 == 1) {
                    //CAN_0x5C2 = 0;
                } else {
                    //ButtomCurrent.count = 2;
                }
            } else if (ButtomCurrent.Time > 12700 && ButtomCurrent.Time < 13700) {
                CAN_0x5C2 = 0;
                LampState_L.Lamps.RELAY_IGN1 = 0;
                CGW_PC11.SCU_N_MODE = 0;
                LampState_M.Lamps.TripSW2_1  = 0;//SW1_OK
            } else if (ButtomCurrent.Time > 12700 && ButtomCurrent.Time < 16700) {
                LampState_L.Lamps.RELAY_IGN1 = 0;
                CGW5.msg.bits.CF_Gway_RrSeatRemindInfo = 2;
                LampState_M.Lamps.TripSW2_1  = 1;//SW1_OK
            } else if (ButtomCurrent.Time > 16700 && ButtomCurrent.Time < 16900) {
                if(CAN_0x486 == 1) {
                    //CAN_0x5C2 = 0;
                } else {
                    //ButtomCurrent.count = 2;
                }
            } else if(ButtomCurrent.Time > 17000){
                CAN_0x486 = 0;
                if(ButtomCurrent.count != 2) {
                    ButtomCurrent.count = 3;
                }
                ButtomCurrent.statu = FINISH;
                StartCurrent = 1;
                Auto_HW_flag = 0;
                LampState_L.Lamps.RELAY_IGN3 = 1;//xxhh add
                if(LampState_L.Lamps.RELAY_IGN3 == 1){
                    LampState_L.Lamps.RELAY_B = 1;
                    LampState_L.Lamps.RELAY_IGN1 = 0;
                    CANSendEnable = OFF;
                }
            }
        }
    }
    
    
    
    
    
    if((StartCurrent == 1) && (StaticCurrent.Finsh == 0) && (ButtomCurrent.Time > 17800)) {
        LampState_L.Lamps.RELAY_B = 0;
        if(StaticCurrent.Time < 100000){//��̬����
            if(StaticCurrent.Time > 5000){
                if((StaticCurrent.Value < 22)&&(StaticCurrent.Time > 30000)){
                    StaticCurrent.Time = 100000;
                    LampState_L.Lamps.RELAY_B = 1;
                    LampState_L.Lamps.RELAY_IGN1 = 1;
                    LampState_L.Lamps.RELAY_IGN3 = 0;
                    StaticCurrent.Finsh = 1;
                    CANSendEnable = ON;
                    ButtomCurrent.count = 3;
                }
            }
        } else {//��̬����������
            if(LampState_L.Lamps.RELAY_IGN3 == 1){
                LampState_L.Lamps.RELAY_B = 1;
                LampState_L.Lamps.RELAY_IGN1 = 1;
                LampState_L.Lamps.RELAY_IGN3 = 0; 
                StaticCurrent.Finsh = 2;
                CANSendEnable = ON;
                ButtomCurrent.Time = 0;
            }  
        }
    }
}


uint8_t EOL_Flag;
void APP_EOL(void)
{
    Default_flag=1;
    uint32_t recvseed = 0;
    uint32_t Key = 0;
    if(EOL.Statu !=4 )
    {
        CANSendEnable = OFF; //�ر��������ķ���
        EOL_Flag = 1;
        if(EOL.Statu == 0)
        {
            Send_7C6_Data.msg.bits.Byte0Data = 0x02;
            Send_7C6_Data.msg.bits.Byte1Data = 0x10;
            Send_7C6_Data.msg.bits.Byte2Data = 0x03;
            CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_1, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 3);
            Delay(20);//20ms
            
            //Send_111.msg.bits.Byte1Data = 0xC0;
            //CanFD_Send_StandMsg(CANFD0_Type, 0x111, BUF_9, TX_ISR_EN, (uint8_t*)&Send_111.msg.data, 8);
            Send_7C6_Data.msg.bits.Byte0Data = 0x02;
            Send_7C6_Data.msg.bits.Byte1Data = 0x27;
            Send_7C6_Data.msg.bits.Byte2Data = 0x01;
            CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_1, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 3);
            Delay(50);//50ms
            
            recvseed = Receive_7CE_Data.data[3];
            recvseed <<= 8;
            recvseed |= Receive_7CE_Data.data[4];
            recvseed <<= 8;
            recvseed |= Receive_7CE_Data.data[5];
            recvseed <<= 8;
            recvseed |= Receive_7CE_Data.data[6];
            //�����㷨
            recvseed = ~recvseed;
            Key = recvseed;
            Key++;
            Key++;
            Key++;
            Key++;
            Key++;
            Key++;
            Key++;
            Key++;
            Key++;
            Key++;
            Key++;
            Key++;
            Key++;
            Delay(200);//200ms
            Send_7C6_Data.msg.bits.Byte0Data = 0x06;
            Send_7C6_Data.msg.bits.Byte1Data = 0x27;
            Send_7C6_Data.msg.bits.Byte2Data = 0x02;
            Send_7C6_Data.msg.bits.Byte3Data = (Key >> 24) & 0xff;
            Send_7C6_Data.msg.bits.Byte4Data = (Key >> 16) & 0xff;
            Send_7C6_Data.msg.bits.Byte5Data = (Key >> 8) & 0xff;
            Send_7C6_Data.msg.bits.Byte6Data = (Key >> 0) & 0xff;
            CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_1, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 7);
            Delay(20);//100ms
            if((Receive_7CE_Data.data[1] == 0x67) && (Receive_7CE_Data.data[2]== 0x02))
            {
                EOL.Statu = 1;
                Can_Clear((uint8_t*)&Receive_7CE_Data.data);
            }
        }
        if(EOL.Statu == 1)
        {
            CanFD_Send_StandMsg(CANFD0_Type, 0x420, BUF_2, TX_ISR_EN, (uint8_t*)&Send_420.msg.data, 8);/* SCC     */
            CanFD_Send_StandMsg(CANFD0_Type, 0x490, BUF_3, TX_ISR_EN, (uint8_t*)&Send_490.msg.data, 8);/* EPB11   */
            CanFD_Send_StandMsg(CANFD0_Type, 0x381, BUF_4, TX_ISR_EN, (uint8_t*)&Send_381.msg.data, 8);/* MDPS11  */
            CanFD_Send_StandMsg(CANFD0_Type, 0x507, BUF_5, TX_ISR_EN, (uint8_t*)&Send_507.msg.data, 8);/* ESC     */
            CanFD_Send_StandMsg(CANFD0_Type, 0x593, BUF_6, TX_ISR_EN, (uint8_t*)&Send_593.msg.data, 8);/* TPMS    */
            //CanFD_Send_StandMsg(CANFD0_Type, 0x340, BUF_7, TX_ISR_EN, (uint8_t*)&Send_340.msg.data, 8);/* LKA     */
            CanFD_Send_StandMsg(CANFD0_Type, 0x500, BUF_8, TX_ISR_EN, (uint8_t*)&Send_500.msg.data, 8);/* Air Bag */
            //CanFD_Send_StandMsg(CANFD0_Type, 0x368, BUF_12, TX_ISR_EN, (uint8_t*)&Send_586.msg.data, 8);/*AT */
            CanFD_Send_StandMsg(CANFD0_Type, 0x586, BUF_13, TX_ISR_EN, (uint8_t*)&Send_586.msg.data, 8);/*EVP */
            
            CGW_PC6.msg.bits.TCU_TYPE = 0x1;
            CanFD_Send_StandMsg(CANFD0_Type, 0x368, BUF_9, TX_ISR_EN, (uint8_t*)&CGW_PC6.msg.data, 8);
            Delay(500);//100ms
            
            Send_7C6_Data.msg.bits.Byte0Data = 0x05;
            Send_7C6_Data.msg.bits.Byte1Data = 0x2E;
            Send_7C6_Data.msg.bits.Byte2Data = 0x00;
            Send_7C6_Data.msg.bits.Byte3Data = 0x60;
            Send_7C6_Data.msg.bits.Byte4Data = 0xff;
            Send_7C6_Data.msg.bits.Byte5Data = 0xfc;
            CanFD_Send_StandMsg(CANFD0_Type, 0x7C6, BUF_1, TX_ISR_EN, (uint8_t*)&Send_7C6_Data.msg.data, 6);
            //Can_Clear((uint8_t*)&Send_7C6_Data.msg.data);
            Delay(20);//20ms
            EOL.Statu = 2 ;
        }
        
        if((Receive_7CE_Data.data[1] == 0x7F) && (Receive_7CE_Data.data[2] == 0x2E)&& (EOL.Statu == 2))//�жϷ���
        {
            CanFD_Send_StandMsg(CANFD0_Type, 0x420, BUF_2, TX_ISR_EN, (uint8_t*)&Send_420.msg.data, 8);/* SCC     */
            CanFD_Send_StandMsg(CANFD0_Type, 0x490, BUF_3, TX_ISR_EN, (uint8_t*)&Send_490.msg.data, 8);/* EPB11   */
            CanFD_Send_StandMsg(CANFD0_Type, 0x381, BUF_4, TX_ISR_EN, (uint8_t*)&Send_381.msg.data, 8);/* MDPS11  */
            CanFD_Send_StandMsg(CANFD0_Type, 0x507, BUF_5, TX_ISR_EN, (uint8_t*)&Send_507.msg.data, 8);/* ESC     */
            CanFD_Send_StandMsg(CANFD0_Type, 0x593, BUF_6, TX_ISR_EN, (uint8_t*)&Send_593.msg.data, 8);/* TPMS    */
            //CanFD_Send_StandMsg(CANFD0_Type, 0x340, BUF_7, TX_ISR_EN, (uint8_t*)&Send_340.msg.data, 8);/* LKA     */
            CanFD_Send_StandMsg(CANFD0_Type, 0x500, BUF_8, TX_ISR_EN, (uint8_t*)&Send_500.msg.data, 8);/* Air Bag */
            //CanFD_Send_StandMsg(CANFD0_Type, 0x368, BUF_12, TX_ISR_EN, (uint8_t*)&Send_586.msg.data, 8);/*AT */
            CanFD_Send_StandMsg(CANFD0_Type, 0x586, BUF_13, TX_ISR_EN, (uint8_t*)&Send_586.msg.data, 8);/*EVP */
            
            CGW_PC6.msg.bits.TCU_TYPE = 0x1;
            CanFD_Send_StandMsg(CANFD0_Type, 0x368, BUF_9, TX_ISR_EN, (uint8_t*)&CGW_PC6.msg.data, 8);
            Delay(20);//20ms
            if((Receive_7CE_Data.data[1] == 0x6E) && (Receive_7CE_Data.data[3] == 0x60))//�жϷ���
            {
                EOL.Statu = 4 ;
                Can_Clear((uint8_t*)&Receive_7CE_Data.data);
            }
        }
        
        if((Receive_7CE_Data.data[1] == 0x6E) && (Receive_7CE_Data.data[3] == 0x60))//�жϷ���
        {
            EOL.Statu = 4 ;
            Can_Clear((uint8_t*)&Receive_7CE_Data.data);
        }
    }
    
    else{
        CANSendEnable = ON;  //�����������ķ���
        EOL_Flag = 0;
    }
}
void part_num_jiexi()
{
    
    if (memcmp(CluPartNum, DL3C_SVC_PART_NUM, 10) == 0u)
    {
        BDC_PE_ALL = 1;
    }
    
    if (memcmp(CluPartNum, DL3C_STD_PART_NUM, 10) == 0u)
    {
        BDC_PE_ALL = 2;
    }
    
    
}

extern uint8_t Time_Charge_1s;
void APP_LED_OUTPUT(void)   //LED ���ķ���  һ������
{
    Default_flag=1;
    if(LedCurrent.count == 34)
    {
        LedCurrent.statu = FINISH;  //LED������һ���־
    }
    else
    {
        LedCurrent.statu = UNFINISH;  //δ���
    }
    
    if((LedCurrent.count == 20) || (LedCurrent.count == 34)) Port_SetPortPinLevel(2, 0, 1);           //��������
   // else Port_SetPortPinLevel(2, 0, 0); //AIRBAG
    
    
    if(LedCurrent.count == 6 || LedCurrent.count == 34)Port_SetPortPinLevel(2, 3, 1);//DU2�źſ���
   // else Port_SetPortPinLevel(2, 3, 0);   //��ȫ��ָʾ��
    
    //if(LedCurrent.count == 24 || LedCurrent.count == 34)Port_SetPortPinLevel(2, 20, 1);
   // else Port_SetPortPinLevel(2, 20, 0); //����ѹ��
    
    switch(LedCurrent.count)   //LED
    {
    case 0 :
        break;
    case 1 :
        EMS19.msg.bits.DPF_LAMP_STAT = 0x1;             //DPF
        HU_USM_E_05.AVN_Usm_CluThemeSta = 0x1;
        
        break;
    case 2 :
        CGW1.msg.bits.CF_Gway_TurnSigLh = 0x1;          //��ת��
        HU_USM_E_05.AVN_Usm_CluThemeSta = 0x2;
        break;
    case 3 :
        CGW2.msg.bits.CF_Gway_ExtTailAct = 0x1;         //λ�õ�
        CGW1.msg.bits.CF_Gway_HeadLampLow = 0x1;        //�����
        HU_USM_E_05.AVN_Usm_CluThemeSta = 0x3;
        break;
    case 4 :
        CGW1.msg.bits.CF_Gway_HeadLampHigh=0x1;         //Զ���
        HU_USM_E_05.AVN_Usm_CluThemeSta = 0x2;
        break;
    case 5 :
        CGW5.msg.bits.CF_Afs_LedHLStat = 0x2;           //LED LAMP FAIL
        break;
    case 6 :
        CGW4.msg.bits.CF_Gway_DrvSeatBeltIND = 0x2;     //��ȫ��ָʾ��
        break;
    case 7 :
        LKA11.msg.bits.CF_LKA_SymbolState = 0x2;        //LKA ��
        break;
    case 8 :
        LKA11.msg.bits.CF_LKA_SymbolState = 0x1;        //LKA��
        break;
    case 9 :
        LKA11.msg.bits.CF_LKA_SymbolState = 0x4;        //LKA��
        break;
    case 10 :
        HDA11.msg.bits.CF_HDA_LFA_SymbolState = 0x2;    //LFA G
        break;
    case 11 :
        HDA11.msg.bits.CF_HDA_LFA_SymbolState = 0x1;    //LFA W
        break;
    case 12 :
        FCA11.msg.bits.FCA_Failinfo = 0x2;               //FCA
        FCA11.msg.bits.FCA_Status = 0x1;
 //       FCA12.msg.bits.FCA_USM = 0x1;                    //FCA
        break;
    case 13 :
        CGW1.msg.bits.CF_Gway_TurnSigRh = 0x1;          //��ת��
        break;
    case 14 :
        TPMS11.msg.bits.TPMS_W_LAMP = 0x0;              //̥ѹ��
        TPMS11.msg.bits.TREAD_W_LAMP = 0x1;
        break;
    case 15 :
        LKA11.msg.bits.CF_HBA_Lamp = 0x1;               //HBA
        LKA11.msg.bits.CF_HBA_Opt = 0x1;
        break;
    case 16 :
        CGW1.msg.bits.CF_Gway_Frt_Fog_Act = 0x1;        //ǰ���� 
        CGW2.msg.bits.CF_Gway_ExtTailAct = 0x1;         //λ�õ�
        break;  
    case 17 :
        CGW2.msg.bits.CF_Gway_RearFogAct = 0x1;         //������
        break;
    case 18 :
        CGW_PC2.msg.bits.L_MIL = 0x1;                   //��鷢����
        break;
    case 19 :
        EMS19.msg.bits.BAT_LAMP_STAT = 0x1;             //��س��
        break;
    case 20 :      
        //Airbag��ȫ���ҵ�
        break;
    case 21 :
        TCS15.msg.bits.AVH_LAMP = 0x2;                  //AutoHold  green
        break;
    case 22 :
        TCS15.msg.bits.AVH_LAMP = 0x3;                  //AutoHold  white
        break;
    case 23 :
        TCS15.msg.bits.AVH_LAMP = 0x1;                  //AutoHold  yellow
        break;
    case 24 :
        EMS19.msg.bits. CF_Ems_OPSFail = 0x1;           //����ѹ��
        break;
    case 25 :
        CGW_PC5.msg.bits.CF_Ems_IsgStat = 0x1;          //ISG ��
        CGW_PC5.msg.bits.CF_Ems_IsgStat2 = 0x0;         //ISG ��
        break;
    case 26 :
        CGW_PC5.msg.bits.CF_Ems_IsgStat = 0x5;          //ISG ��
        CGW_PC5.msg.bits.CF_Ems_IsgStat2 = 0x0;         //ISG ��
        break;
    case 27 :
        CGW2.msg.bits.CF_Gway_ImmoLp = 0x1;             //����Immobilizer
        EndCurrent.Flag_one = 0;
        break;
    case 28 :
        EPB11.msg.bits.EPB_F_LAMP = 0x1;                //EPB
        break;
    case 29 :
        TCS15.msg.bits.EBD_W_LAMP = 0x1;                //פ���ƶ�������
        break;
    case 30 :
        TCS15.msg.bits.ABS_W_LAMP = 0x1;                //ABS
        break;   
    case 31 :
        MDPS11.msg.bits.CF_Mdps_WLmp = 0x2;             //MDPS
        break;
    case 32 :
        TCS15.msg.bits.TCS_LAMP = 0x1;                  //ESC
        break;
    case 33 :
        TCS15.msg.bits.TCS_OFF_LAMP = 0x1;              //ESC OFF
        break;
    case 34 :
        CGW1.msg.bits.CF_Gway_TurnSigLh = 0x1;          //��ת��
        
        CGW2.msg.bits.CF_Gway_ExtTailAct = 0x1;         //λ�õ�
        CGW1.msg.bits.CF_Gway_HeadLampLow = 0x1;        //�����
        
        CGW1.msg.bits.CF_Gway_HeadLampHigh=0x1;         //Զ���
        
        LKA11.msg.bits.CF_HBA_Lamp = 0x1;               //HBA
        LKA11.msg.bits.CF_HBA_Opt = 0x1;
        
        CGW2.msg.bits.CF_Gway_RearFogAct = 0x1;         //������
        CGW1.msg.bits.CF_Gway_Frt_Fog_Act = 0x1;        //ǰ����
        
        TCS15.msg.bits.ABS_W_LAMP = 0x1;                //ABS
        
        TCS15.msg.bits.TCS_LAMP = 0x1;                  //ESC
        
        TCS15.msg.bits.TCS_OFF_LAMP = 0x1;              //ESC OFF
        
        CGW_PC2.msg.bits.L_MIL = 0x1;                   //��鷢����
        
        CGW1.msg.bits.CF_Gway_TurnSigRh = 0x1;          //��ת��
        
        FCA11.msg.bits.FCA_Failinfo = 0x2;               //FCA
        FCA11.msg.bits.FCA_Status = 0x1;
        
        TPMS11.msg.bits.TPMS_W_LAMP = 0x0;              //̥ѹ��
        TPMS11.msg.bits.TREAD_W_LAMP = 0x1;
        
        MDPS11.msg.bits.CF_Mdps_WLmp = 0x2;             //MDPS
        
        EMS19.msg.bits.BAT_LAMP_STAT = 0x1;             //��س��
        
        EMS19.msg.bits. CF_Ems_OPSFail = 0x1; ;         //����ѹ��
        
        CGW4.msg.bits.CF_Gway_DrvSeatBeltIND = 0x2;     //��ȫ��ָʾ��
        
        CGW5.msg.bits.CF_Afs_LedHLStat = 0x2;           //LED LAMP FAIL
        
        TCS15.msg.bits.EBD_W_LAMP = 0x1;                //פ���ƶ�������
        
        EMS19.msg.bits.DPF_LAMP_STAT = 0x1;             //DPF
        
        EPB11.msg.bits.EPB_F_LAMP = 0x1;                //EPB
        
        CGW2.msg.bits.CF_Gway_ImmoLp = 0x1;             //����
        switch(Time_Charge_1s)
        {
        case 0:
            HDA11.msg.bits.CF_HDA_LFA_SymbolState = 0x1;    //LFA W
            LKA11.msg.bits.CF_LKA_SymbolState = 0x4;        //LAK  yellow
            TCS15.msg.bits.AVH_LAMP = 0x1;                  //AutoHold  yellow
            //CGW_PC5.msg.bits.CF_Ems_IsgStat = 0x5;          //ISG ��
            //CGW_PC5.msg.bits.CF_Ems_IsgStat2 = 0x0;         //ISG ��
            break;
        case 1:
            HDA11.msg.bits.CF_HDA_LFA_SymbolState = 0x2;    //LFA G
            LKA11.msg.bits.CF_LKA_SymbolState = 0x2;        //LAK  green
            TCS15.msg.bits.AVH_LAMP = 0x2;                  //AutoHold  green
            //CGW_PC5.msg.bits.CF_Ems_IsgStat = 0x1;          //ISG ��
            //CGW_PC5.msg.bits.CF_Ems_IsgStat2 = 0x0;         //ISG ��
            break;
        case 2:
            HDA11.msg.bits.CF_HDA_LFA_SymbolState = 0x2;    //LFA G
            LKA11.msg.bits.CF_LKA_SymbolState = 0x1;        //LAK  white
            TCS15.msg.bits.AVH_LAMP = 0x3;                  //AutoHold  white
            //CGW_PC5.msg.bits.CF_Ems_IsgStat = 0x5;          //ISG ��
            //CGW_PC5.msg.bits.CF_Ems_IsgStat2 = 0x0;         //ISG ��
            break;
        default:
            break;
        }
        break;
        
    default:
        break;
    }
}

//uint16_t Clu_DTE,Clu_DTE_H,Clu_DTE_L;
//uint16_t Ausfallzeit;
//uint16_t Speed_Tester,Speed_Indicator;
//uint16_t Ausfallzeit;
uint32_t ODO;
uint16_t DisplaySpeed , DisplaySpeed1 , DisplaySpeed2;
//uint16_t AvgFCI , AvgFCI1 , AvgFCI2  ;
//uint8_t RheostatLevel;
//uint8_t  DelayCount,FuelCount;

void APP_CAN_Output_Show (void)
{
    /*
    if(( CanFDDataStruct.CF_Clu_DTE_H != 0x3) && ( CanFDDataStruct.CF_Clu_DTE_L != 0xFF ))
    {
        Clu_DTE_H = CanFDDataStruct.CF_Clu_DTE_H ;      //�������
        Clu_DTE_L = CanFDDataStruct.CF_Clu_DTE_L ;      //�������
        Clu_DTE_H = Clu_DTE_H << 8 ;
        Clu_DTE = Clu_DTE_H | Clu_DTE_L ; // ��Ҫ��ʾ   Clu_DTE
    }
    if(CanFDDataStruct.CF_Clu_DAWLastBreakTime < 0xE)
    {
        Ausfallzeit = CanFDDataStruct.CF_Clu_DAWLastBreakTime*10/2;   //�жϺ�����ʱ��
    }  // ��Ҫ��ʾ   Ausfallzeit
    */
    DisplaySpeed1 = CanFDDataStruct.CF_Clu_Vanz_L ;
    DisplaySpeed2 = CanFDDataStruct.CF_Clu_Vanz_H ;
    DisplaySpeed2 = DisplaySpeed2 << 8 ;
    DisplaySpeed = DisplaySpeed1 | DisplaySpeed2 ;   //��Ҫ��ʾ   DisplaySpeed     SCC�ٶ�
    SpeedCurrent.Value = DisplaySpeed / 2;
    
    //������
    ODO = CanFDDataStruct.CF_Clu_Odometer1 | CanFDDataStruct.CF_Clu_Odometer2 << 8 | CanFDDataStruct.CF_Clu_Odometer3 <<16 ;
    ODO = ODO/10 ; //��Ҫ��ʾ  ODO
    /*
    if(( CanFDDataStruct.CF_Clu_AvgFCI_L != 0x3) && ( CanFDDataStruct.CF_Clu_AvgFCI_H != 0xFF ))
    {
        AvgFCI1 = CanFDDataStruct.CF_Clu_AvgFCI_L ; // ƽ������������
        AvgFCI2 = CanFDDataStruct.CF_Clu_AvgFCI_H ;  // ƽ������������
        AvgFCI2 = AvgFCI2  << 8 ;
        AvgFCI = AvgFCI1 | AvgFCI2 ;   //��Ҫ��ʾ AvgFCI
    }
    */
}


uint16_t conversion(uint16_t ConvData)
{
    uint8_t x;
    X.W = ConvData;
    x = X.data[1];
    X.data[1] = X.data[0];
    X.data[0] = x;
    return X.W;
}

uint8_t Freque_Flag;

void APP_SPEED_OUTPUT(void) //���� ת�� ���� ����  ��ʮ�� ������������ֹͣ  ��������
{
    Default_flag=0;
    
  //  _speed_out(PortGpioHigh);
 //   _R_speed_out(PortGpioHigh);
    if(SpeedCurrent.count == 32)
    {
        SpeedCurrent.statu = FINISH;  //������һ���־
    }
    else
    {
        SpeedCurrent.statu = UNFINISH;  //δ���
    }
    switch(SpeedCurrent.count)
    {
        case 0:
            break;
        case 1:
            WHL_SPD11.msg.bits.WHL_SPD_FL = 0x280;//����20
            WHL_SPD11.msg.bits.WHL_SPD_RL = 0x280;//����20
            CGW_PC4.msg.bits.N =0xFA0;//1000  ת��
            User_Delay(2000);
            if(CheckCurrent.Value == FINISH)
            {
                if(Frequeice.Value > 139.6 && Frequeice.Value < 247.6)
                {
                    Freque_Flag = 1;
                }
                else
                {
                    Freque_Flag = 2;
                }
            }
            break;
        case 2:
            WHL_SPD11.msg.bits.WHL_SPD_FL = 0x500;//����40
            WHL_SPD11.msg.bits.WHL_SPD_RL = 0x500;//����40
            CGW_PC4.msg.bits.N=0x1F40;//2000  ת��
            User_Delay(200);
            if(CheckCurrent.Value == FINISH)
            {
                if(Frequeice.Value > 263.1 && Frequeice.Value < 475.1)
                {
                    Freque_Flag = 1;
                }
                else
                {
                    Freque_Flag = 2;
                }
            }
            break;
        case 3:
            WHL_SPD11.msg.bits.WHL_SPD_FL = 0x780;//����60
            WHL_SPD11.msg.bits.WHL_SPD_RL = 0x780;//����60
            CGW_PC4.msg.bits.N =0x2EE0;//3000  ת��
            User_Delay(200);
            if(CheckCurrent.Value == FINISH)
            {
                if(Frequeice.Value > 394.7 && Frequeice.Value < 702.7)
                {
                    Freque_Flag = 1;
                }
                else
                {
                    Freque_Flag = 2;
                }
            }
            break;
        case 4:
            WHL_SPD11.msg.bits.WHL_SPD_FL = 0xA00;//����80
            WHL_SPD11.msg.bits.WHL_SPD_RL = 0xA00;//����80
            CGW_PC4.msg.bits.N=0x3E80;//4000 ת��
            User_Delay(200);
            if(CheckCurrent.Value == FINISH)
            {
                if(Frequeice.Value > 536.2 && Frequeice.Value < 930.2)
                {
                    Freque_Flag = 1;
                }
                else
                {
                    Freque_Flag = 2;
                }
            }
            break;
        case 5:
            WHL_SPD11.msg.bits.WHL_SPD_FL = 0xC80;//����100
            WHL_SPD11.msg.bits.WHL_SPD_RL = 0xC80;//����100
            CGW_PC4.msg.bits.N =0x4E20;//5000  ת��
            User_Delay(200);
            if(CheckCurrent.Value == FINISH)
            {
                if(Frequeice.Value > 704.8 && Frequeice.Value < 1157.8)
                {
                    Freque_Flag = 1;
                }
                else
                {
                    Freque_Flag = 2;
                }
            }
            break;
        case 6:
            WHL_SPD11.msg.bits.WHL_SPD_FL = 0xF00;//����120
            WHL_SPD11.msg.bits.WHL_SPD_RL = 0xF00;//����120
            CGW_PC4.msg.bits.N =0x5DC0;//6000  ת��
            User_Delay(200);
            if(CheckCurrent.Value == FINISH)
            {
                if(Frequeice.Value > 809.3 && Frequeice.Value < 1395.3)
                {
                    Freque_Flag = 1;
                }
                else
                {
                    Freque_Flag = 2;
                }
            }
            break;
        case 7:
            WHL_SPD11.msg.bits.WHL_SPD_FL = 0x1180;//����140
            WHL_SPD11.msg.bits.WHL_SPD_RL = 0x1180;//����140
            CGW_PC4.msg.bits.N =0x6D60;//7000  ת��
            User_Delay(200);
            if(CheckCurrent.Value == FINISH)
            {
                if(Frequeice.Value > 950.9 && Frequeice.Value < 1622.9)
                {
                    Freque_Flag = 1;
                }
                else
                {
                    Freque_Flag = 2;
                }
            }
            break;
        case 8:
            WHL_SPD11.msg.bits.WHL_SPD_FL = 0x1400;//����160
            WHL_SPD11.msg.bits.WHL_SPD_RL = 0x1400;//����160
            CGW_PC4.msg.bits.N=0x7D00;//8000  ת��
            User_Delay(200);
            if(CheckCurrent.Value == FINISH)
            {
                if(Frequeice.Value > 1082.4 && Frequeice.Value < 1850.5)
                {
                    Freque_Flag = 1;
                }
                else
                {
                    Freque_Flag = 2;
                }
            }
            break;
        case 9:
            WHL_SPD11.msg.bits.WHL_SPD_FL = 0x1680;//����180
            WHL_SPD11.msg.bits.WHL_SPD_RL = 0x1680;//����180
            CGW_PC4.msg.bits.N =0x7D00;//8000  ת��
            User_Delay(200);
            if(CheckCurrent.Value == FINISH)
            {
                if(Frequeice.Value > 1224 && Frequeice.Value < 2088.1)
                {
                    Freque_Flag = 1;
                }
                else
                {
                    Freque_Flag = 2;
                }
            }
            break;
        case 10:
            WHL_SPD11.msg.bits.WHL_SPD_FL = 0x1900;//����200
            WHL_SPD11.msg.bits.WHL_SPD_RL = 0x1900;//����200
            CGW_PC4.msg.bits.N =0x7D00;//8000  ת��
            User_Delay(200);
            if(CheckCurrent.Value == FINISH)
            {
                if(Frequeice.Value > 1365.6 && Frequeice.Value < 2300)
                {
                    Freque_Flag = 1;
                }
                else
                {
                    Freque_Flag = 2;
                }
            }
            break;
        case 11:
            WHL_SPD11.msg.bits.WHL_SPD_FL = 0x1B80;//220
            WHL_SPD11.msg.bits.WHL_SPD_RL = 0x1B80;//220
            CGW_PC4.msg.bits.N =0x7D00;//8000  ת��
            User_Delay(200);
            if(CheckCurrent.Value == FINISH)
            {
                if(Frequeice.Value > 1507.1 && Frequeice.Value < 2600)
                {
                    Freque_Flag = 1;
                }
                else
                {
                    Freque_Flag = 2;
                }
            }
            break;
        case 12:
            WHL_SPD11.msg.bits.WHL_SPD_FL = 0x1E00;//240
            WHL_SPD11.msg.bits.WHL_SPD_RL = 0x1E00;//240
            CGW_PC4.msg.bits.N =0x7D00;//8000  ת��
            User_Delay(200);
            if(CheckCurrent.Value == FINISH)
            {
                if(Frequeice.Value > 1648.7 && Frequeice.Value < 2900)
                {
                    Freque_Flag = 1;
                }
                else
                {
                    Freque_Flag = 2;
                }
            }
            break;
        case 13:
            WHL_SPD11.msg.bits.WHL_SPD_FL = 8000;//260
            WHL_SPD11.msg.bits.WHL_SPD_RL = 8000;//260
            CGW_PC4.msg.bits.N =0x7D00;//8000  ת��
            CGW2.msg.bits.CF_Gway_AvTail = 1;
            HU_USM_E_04.CF_AVN_CluRheostatLvl = 1;
            User_Delay(2000);
            Freque_Flag = 1;
            if(CanFDDataStruct.CF_Clu_RheostatLevel != 1 || CLU_HU_PE_01.Clu_RheostatLvl != 1)
            {
                Freque_Flag = 2;
            }
            
            break;
        case 14:
            CGW2.msg.bits.CF_Gway_AvTail = 1;
            HU_USM_E_04.CF_AVN_CluRheostatLvl = 2;
            User_Delay(2000);
            Freque_Flag = 1;
            if(CanFDDataStruct.CF_Clu_RheostatLevel != 2 || CLU_HU_PE_01.Clu_RheostatLvl != 2)
            {
                Freque_Flag = 2;
            }
            
            break;
        case 15:
            CGW2.msg.bits.CF_Gway_AvTail = 1;
            HU_USM_E_04.CF_AVN_CluRheostatLvl = 3;
            User_Delay(2000);
            Freque_Flag = 1;
            if(CanFDDataStruct.CF_Clu_RheostatLevel != 3 || CLU_HU_PE_01.Clu_RheostatLvl != 3)
            {
                Freque_Flag = 2;
            }
            
            break;
        case 16:
            CGW2.msg.bits.CF_Gway_AvTail = 1;
            HU_USM_E_04.CF_AVN_CluRheostatLvl = 4;
            User_Delay(2000);
            Freque_Flag = 1;
            if(CanFDDataStruct.CF_Clu_RheostatLevel != 4 || CLU_HU_PE_01.Clu_RheostatLvl != 4)
            {
                Freque_Flag = 2;
            }
            
            break;
        case 17:
            CGW2.msg.bits.CF_Gway_AvTail = 1;
            HU_USM_E_04.CF_AVN_CluRheostatLvl = 5;
            User_Delay(2000);
            Freque_Flag = 1;
            if(CanFDDataStruct.CF_Clu_RheostatLevel != 5 || CLU_HU_PE_01.Clu_RheostatLvl != 5)
            {
                Freque_Flag = 2;
            }
            
            break;
        case 18:
            CGW2.msg.bits.CF_Gway_AvTail = 1;
            HU_USM_E_04.CF_AVN_CluRheostatLvl = 6;
            User_Delay(2000);
            Freque_Flag = 1;
            if(CanFDDataStruct.CF_Clu_RheostatLevel != 6 || CLU_HU_PE_01.Clu_RheostatLvl != 6)
            {
                Freque_Flag = 2;
            }
            
            break;
        case 19:
            CGW2.msg.bits.CF_Gway_AvTail = 1;
            HU_USM_E_04.CF_AVN_CluRheostatLvl = 7;
            User_Delay(2000);
            Freque_Flag = 1;
            if(CanFDDataStruct.CF_Clu_RheostatLevel != 7 || CLU_HU_PE_01.Clu_RheostatLvl != 7)
            {
                Freque_Flag = 2;
            }
            
            break;
        case 20:
            CGW2.msg.bits.CF_Gway_AvTail = 1;
            HU_USM_E_04.CF_AVN_CluRheostatLvl = 8;
            User_Delay(2000);
            Freque_Flag = 1;
            if(CanFDDataStruct.CF_Clu_RheostatLevel != 8 || CLU_HU_PE_01.Clu_RheostatLvl != 8)
            {
                Freque_Flag = 2;
            }
            
            break;
        case 21:
            CGW2.msg.bits.CF_Gway_AvTail = 1;
            HU_USM_E_04.CF_AVN_CluRheostatLvl = 9;
            User_Delay(2000);
            Freque_Flag = 1;
            if(CanFDDataStruct.CF_Clu_RheostatLevel != 9 || CLU_HU_PE_01.Clu_RheostatLvl != 9)
            {
                Freque_Flag = 2;
            }
            
            break;
        case 22:
            CGW2.msg.bits.CF_Gway_AvTail = 1;
            HU_USM_E_04.CF_AVN_CluRheostatLvl = 10;
            User_Delay(2000);
            Freque_Flag = 1;
            if(CanFDDataStruct.CF_Clu_RheostatLevel != 10 || CLU_HU_PE_01.Clu_RheostatLvl != 10)
            {
                Freque_Flag = 2;
            }
            
            break;
        case 23:
            CGW2.msg.bits.CF_Gway_AvTail = 1;
            HU_USM_E_04.CF_AVN_CluRheostatLvl = 11;
            User_Delay(2000);
            Freque_Flag = 1;
            if(CanFDDataStruct.CF_Clu_RheostatLevel != 11 || CLU_HU_PE_01.Clu_RheostatLvl != 11)
            {
                Freque_Flag = 2;
            }
            
            break;
        case 24:
            CGW2.msg.bits.CF_Gway_AvTail = 1;
            HU_USM_E_04.CF_AVN_CluRheostatLvl = 12;
            User_Delay(2000);
            Freque_Flag = 1;
            if(CanFDDataStruct.CF_Clu_RheostatLevel != 12 || CLU_HU_PE_01.Clu_RheostatLvl != 12)
            {
                Freque_Flag = 2;
            }
            
            break;
        case 25:
            CGW2.msg.bits.CF_Gway_AvTail = 1;
            HU_USM_E_04.CF_AVN_CluRheostatLvl = 13;
            User_Delay(2000);
            Freque_Flag = 1;
            if(CanFDDataStruct.CF_Clu_RheostatLevel != 13 || CLU_HU_PE_01.Clu_RheostatLvl != 13)
            {
                Freque_Flag = 2;
            }
            
            break;
        case 26:
            CGW2.msg.bits.CF_Gway_AvTail = 1;
            HU_USM_E_04.CF_AVN_CluRheostatLvl = 14;
            User_Delay(2000);
            Freque_Flag = 1;
            if(CanFDDataStruct.CF_Clu_RheostatLevel != 14 || CLU_HU_PE_01.Clu_RheostatLvl != 14)
            {
                Freque_Flag = 2;
            }
            
            break;
        case 27:
            CGW2.msg.bits.CF_Gway_AvTail = 1;
            HU_USM_E_04.CF_AVN_CluRheostatLvl = 15;
            User_Delay(2000);
            Freque_Flag = 1;
            if(CanFDDataStruct.CF_Clu_RheostatLevel != 15 || CLU_HU_PE_01.Clu_RheostatLvl != 15)
            {
                Freque_Flag = 2;
            }
            
            break;
        case 28:
            CGW2.msg.bits.CF_Gway_AvTail = 1;
            HU_USM_E_04.CF_AVN_CluRheostatLvl = 16;
            User_Delay(2000);
            Freque_Flag = 1;
            if(CanFDDataStruct.CF_Clu_RheostatLevel != 16 || CLU_HU_PE_01.Clu_RheostatLvl != 16)
            {
                Freque_Flag = 2;
            }
            
            break;
        case 29:
            CGW2.msg.bits.CF_Gway_AvTail = 1;
            HU_USM_E_04.CF_AVN_CluRheostatLvl = 17;
            User_Delay(2000);
            Freque_Flag = 1;
            if(CanFDDataStruct.CF_Clu_RheostatLevel != 17 || CLU_HU_PE_01.Clu_RheostatLvl != 17)
            {
                Freque_Flag = 2;
            }
            
            break;
        case 30:
            CGW2.msg.bits.CF_Gway_AvTail = 1;
            HU_USM_E_04.CF_AVN_CluRheostatLvl = 18;
            User_Delay(2000);
            Freque_Flag = 1;
            if(CanFDDataStruct.CF_Clu_RheostatLevel != 18 || CLU_HU_PE_01.Clu_RheostatLvl != 18)
            {
                Freque_Flag = 2;
            }
            
            break;
        case 31:
            CGW2.msg.bits.CF_Gway_AvTail = 1;
            HU_USM_E_04.CF_AVN_CluRheostatLvl = 19;
            User_Delay(2000);
            Freque_Flag = 1;
            if(CanFDDataStruct.CF_Clu_RheostatLevel != 19 || CLU_HU_PE_01.Clu_RheostatLvl != 19)
            {
                Freque_Flag = 2;
            }
            
            break;
        case 32:
            CGW2.msg.bits.CF_Gway_AvTail = 1;
            HU_USM_E_04.CF_AVN_CluRheostatLvl = 20;
            User_Delay(2000);
            Freque_Flag = 1;
            if(CanFDDataStruct.CF_Clu_RheostatLevel != 20 || CLU_HU_PE_01.Clu_RheostatLvl != 20)
            {
                Freque_Flag = 2;
            }
            
            break;
        default:
            break;
    }
    
    if(Freque_Flag == 2)
    {
        // Buzzer_Alarm();//����������
    }
}


void APP_TFT_OUTPUT(void) //��������2020.6.10WH
{
    Default_flag=0;
    LampState_L.Lamps.LED7 = 0;                  //����
    LampState_L.Lamps.LED6 = 0;
    LampState_L.Lamps.LED5 = 0;
    LampState_L.Lamps.LED4 = 1;
    if (TFTUp_Switch == 0) {
        //TFTCurrent.enable = 0;
        if(TFTCurrent.count == 29)
        {
            TFTCurrent.statu = FINISH;
        }
        switch (TFTCurrent.count)      // ����ֵ��Ӧ����
        {
        case 0 :
            TFTCurrent.enable = 0;
            break;
        case 1 :
            TFTCurrent7.enable = 0;
            LampState_L.Lamps.RELAY_B = 1;
            LampState_L.Lamps.RELAY_IGN1 = 1;//1.4.20 DoorOpen_20_All_Door_Open_POPUP_W
            CGW1.msg.bits.CF_Gway_DrvDrSw = 0x1;//����
            CGW1.msg.bits.CF_Gway_AstDrSw = 0x1;//����ʻ�ſ�
            CGW2.msg.bits.CF_Gway_RRDrSw  = 0x1;//����ſ�
            CGW2.msg.bits.CF_Gway_RLDrSw = 0x1;//�Һ��ſ�
            break;
        case 2 :
            LKA11.msg.bits.CF_HBA_SysState = 0x7;//3.10.1 HBA_01_Check_HBA_POPUP_Y
            LKA11.msg.bits.CF_HBA_Opt = 0x1;
            //22.3.2
            HU_MON_PE_01.HU_Type = 0xFD;
            HU_CLU_P_03.WeatherType=0x0;
            HU_CLU_P_03.GPS_Year1=0x1;
            HU_CLU_P_03.GPS_Year1=0x2;
            HU_CLU_P_03.GPS_Month_H=0x2;
            HU_CLU_P_03.GPS_Day_H=0x2;
            HU_CLU_P_03.GPS_Hour=0x10;
            
            break;
        case 3 :
            BCW11.msg.bits.CF_BCW_Stat = 0x3;//3.11.10 BCA_10_Check_BCA_POPUP_Y
            //22.3.3
            HU_CLU_P_03.WeatherType=0x1;
            HU_CLU_P_03.GPS_Year1=0x1;
            HU_CLU_P_03.GPS_Year1=0x2;
            HU_CLU_P_03.GPS_Month_H=0x2;
            HU_CLU_P_03.GPS_Day_H=0x2;
            HU_CLU_P_03.GPS_Hour=0xC;
            break;
        case 4 :
            CGW_PC11.CF_Lvr_Wrn = 0x3;//6.8.14 SBW_14_Check_P_Button_POPUP_Y
            //22.3.6
            HU_CLU_P_03.WeatherType=0x2;
            HU_CLU_P_03.GPS_Year1=0x1;
            HU_CLU_P_03.GPS_Year1=0x2;
            HU_CLU_P_03.GPS_Month_H=0x2;
            HU_CLU_P_03.GPS_Day_H=0x2;
            HU_CLU_P_03.GPS_Hour=0xC;
            break;
        case 5 :
            CGW_PC11.SCU_N_MODE = 0x1;//6.8.29 SBW_29_OK_to_N_Staying_Mode_POPUP_W
            //22.3.8
            HU_CLU_P_03.WeatherType=0x3;
            HU_CLU_P_03.GPS_Year1=0x1;
            HU_CLU_P_03.GPS_Year1=0x2;
            HU_CLU_P_03.GPS_Month_H=0x2;
            HU_CLU_P_03.GPS_Day_H=0x2;
            HU_CLU_P_03.GPS_Hour=0xC;
            break;
        case 6 :
            CGW_PC2.msg.bits.CF_Tcu_DriWarn2 = 0x3;//6.1.7 DCT_07_DCT_Overheated_Cooling_POPUP_Y
            //22.3.10
            HU_CLU_P_03.WeatherType=0x0;
            HU_CLU_P_03.GPS_Year1=0x1;
            HU_CLU_P_03.GPS_Year1=0x2;
            HU_CLU_P_03.GPS_Month_H=0x2;
            HU_CLU_P_03.GPS_Day_H=0x2;
            HU_CLU_P_03.GPS_Hour=0x17;
            break;
        case 7 :
            CGW_PC3.Clutch_Burst_Warning = 0x1;//6.1.5 DCT_05_DCT_Limphome_POPUP_Y
            //22.3.12
            HU_CLU_P_03.WeatherType=0x1;
            HU_CLU_P_03.GPS_Year1=0x1;
            HU_CLU_P_03.GPS_Year1=0x2;
            HU_CLU_P_03.GPS_Month_H=0x2;
            HU_CLU_P_03.GPS_Day_H=0x2;
            HU_CLU_P_03.GPS_Hour=0x17;
            break;
        case 8 :
            BCA11.BCW_IndSta = 0x2;//3.11.36 BCA_36_Check_Outside_Mirror_Warning_Light_POPUP_Y
            //22.3.14
            HU_CLU_P_03.WeatherType=0x2;
            HU_CLU_P_03.GPS_Year1=0x1;
            HU_CLU_P_03.GPS_Year1=0x2;
            HU_CLU_P_03.GPS_Month_H=0x2;
            HU_CLU_P_03.GPS_Day_H=0x2;
            HU_CLU_P_03.GPS_Hour=0x17;
            break;
        case 9 :
            CGW_PC5.msg.bits.CF_Ems_IsgStat=0x6;//3.7.12 ISG_12_Auto_Stop_Off_Shift_P_N_Start_POPUP_Y
            //22.3.16
            HU_CLU_P_03.WeatherType=0x3;
            HU_CLU_P_03.GPS_Year1=0x1;
            HU_CLU_P_03.GPS_Year1=0x2;
            HU_CLU_P_03.GPS_Month_H=0x2;
            HU_CLU_P_03.GPS_Day_H=0x2;
            HU_CLU_P_03.GPS_Hour=0x17;
            break;
        case 10 :
            CGW_PC4.msg.bits.SCU_WarnMsg=0x3; //6.8.2 SBW_02_Brake_to_Change_Gear_POPUP_W
            //CGW1.msg.bits.CF_Gway_DriveTypeOption=0x1;
            HU_CLU_P_03.WeatherType=0x0;
            HU_CLU_P_03.GPS_Year1=0x1;
            HU_CLU_P_03.GPS_Year2=0x15;
            HU_CLU_P_03.GPS_Month_H=0x0;
            HU_CLU_P_03.GPS_Month_L=0x7;
            HU_CLU_P_03.GPS_Day_H=0x18;
            HU_CLU_P_03.GPS_Hour=0x15;
            //22.3.18
            break;
        case 11 :
            CGW2.msg.bits.CF_Gway_SMKDispWarn=0x6;//1.3.11 SMK_11_Brake_and_Start_POPUP_W
            //TCS15.msg.bits.ESC_Off_Step=0x0;
            HU_CLU_P_03.WeatherType=0x0;
            HU_CLU_P_03.GPS_Year1=0x1;
            HU_CLU_P_03.GPS_Year1=0x15;
            HU_CLU_P_03.GPS_Month_H=0x0;
            HU_CLU_P_03.GPS_Month_L=0x7;
            HU_CLU_P_03.GPS_Day_H=0x18;
            HU_CLU_P_03.GPS_Hour=0xB;
            HU_CLU_P_03.GPS_Minute_H=0X2;
            HU_CLU_P_03.GPS_Minute_L=0xD;
            //22.3.20
            break;
        case 12 :
            TCS15.msg.bits.ESC_Off_Step=0x1;//5.4.1 ESC_01_TCS_Off_POPUP_M
            
            HU_MON_PE_01.HU_Type = 0xFD; 
            HU_CLU_PE_06.HU_OpState_New=0x6;//
            break;
        case 13 :
            HU_MON_PE_01.HU_Type = 0xFD; 
            HU_CLU_PE_06.HU_OpState_New=0x65;//4.1.23 AV_23_USB_Music_POPUP_M
            break;
        case 14 :
            HU_MON_PE_01.HU_Type = 0xFD; 
            HU_CLU_PE_06.HU_OpState_New=0x6;//
            
            LKA11.msg.bits.CF_LKA_SysWarning=0xF; //3.2.11 LKA_11_Check_LKA_POPUP_Y
            break;
        case 15 :
            LKA11.msg.bits.CF_LKA_SysWarning=0x6; //3.2.61 LKA_61_Hands_Off_Warning_2nd_POPUP_R
            LKA11.msg.bits.CF_LKA_HandsOff_Snd=0x1;
            break;
        case 16 :
            BCA11.CF_BCA_R_Warning=0x4;//3.11.8 BCA_08_BCA-R_R_POPUP_R
            break;
        case 17 :
            TCS15.msg.bits.AVH_CLU=0x3;//3.6.3 EPB_03_Auto_Hold_Condition_Not_Met_POPUP_Y
            break;
        case 18 :
            LKA12.msg.bits.CF_LeadVehDptAlert_Display=0x1;//3.2.64 LKA_64_Leading_Vehicle_Departure_Alert_POPUP_W
            LKA12.msg.bits.CF_DAW_Opt_USM_NEW=0x1;
            break;
        case 19 :
            LKA12.msg.bits.CF_LeadVehDptAlert_Display=0x1;//3.2.64 LKA_64_Leading_Vehicle_Departure_Alert_POPUP_W
            LKA12.msg.bits.CF_DAW_Opt_USM_NEW=0x1;
            HU_MON_PE_01.HU_Type = 0xFD; 
            HU_CLU_PE_05.HU_LanguageInfo=0x2;//Ӣ��
            break;
        case 20 :
            LKA12.msg.bits.CF_LeadVehDptAlert_Display=0x1;//3.2.64 LKA_64_Leading_Vehicle_Departure_Alert_POPUP_W
            LKA12.msg.bits.CF_DAW_Opt_USM_NEW=0x1;
            HU_MON_PE_01.HU_Type = 0xFD; 
            HU_CLU_PE_05.HU_LanguageInfo=0x1;//���� 
            break;
        case 21 :
            LKA12.msg.bits.CF_LeadVehDptAlert_Display=0x1;//3.2.64 LKA_64_Leading_Vehicle_Departure_Alert_POPUP_W
            LKA12.msg.bits.CF_DAW_Opt_USM_NEW=0x1;
            HU_MON_PE_01.HU_Type = 0xFD; 
            HU_CLU_PE_05.HU_LanguageInfo=0x4;//����
            break;
        case 22 :
            GotoTestMode();
            break;
        case 23 : 
            TripKeyDown(1);
            TripKeyDown(2);
            TripKeyOk(3);
            TripKeyOk(4);
            PressTripKeyStop(); 
            break;
        case 24 : 
            TripKeyOk(1);
            TripKeyDown(2);
            TripKeyOk(3);
            PressTripKeyStop();
            break;
        case 25 :
            TripKeyOk(1);
            TripKeyDown(2);
            TripKeyOk(3);
            PressTripKeyStop();
            break;
        case 26 :
            TripKeyOk(1);
            TripKeyDown(2);
            TripKeyOk(3);
            PressTripKeyStop();
            break;
        case 27 :
            TripKeyOk(1);
            TripKeyDown(2);
            TripKeyOk(3);
            PressTripKeyStop();
            break;
        case 28 :
            TripKeyOk(1);
            TripKeyDown(2);
            TripKeyOk(3);
            PressTripKeyStop();
            break;
        case 29 : 
            PressTripKeyIGN1On();
            break;
            
            
            
        default:
            break;
        }
    }   
}    





uint8_t LastElseCurrentCount = 0xFF;
void APP_ELSE(void)
{
    Default_flag=1;
    
    if (LastElseCurrentCount != ElseCurrent.count) {
        ElseCurrent.Time = 0;
        LastElseCurrentCount = ElseCurrent.count;
        ElseCurrent.enable = 1;
    }
    
    if (ElseCurrent.count == 8) {
        ElseCurrent.Finsh = 1;
    } else {
        ElseCurrent.Finsh = 0;
    }
    
    switch(ElseCurrent.count)
    {
    case 1:
        
        if ((ElseCurrent.Time > 10) && (ElseCurrent.Time < 1010)) {
            LampState_L.Lamps.RELAY_IGN1 = 0;
        } else if ((ElseCurrent.Time > 1010) && (ElseCurrent.Time < 1500)) {
            LampState_L.Lamps.RELAY_IGN1 = 1;
            LampState_M.Lamps.TripSW2_4  = 0;//SW1_MENU
            LampState_M.Lamps.TripSW2_3  = 0;//SW1_UP
            LampState_M.Lamps.TripSW2_2  = 0;//SW1_DOWN
            LampState_M.Lamps.TripSW2_1  = 0;//SW1_OK
        }
        if (ElseCurrent.Time >= 1500) {
            ElseCurrent.Time = 1500;
        }
        break;
    case 2:
        if ((ElseCurrent.Time > 10) && (ElseCurrent.Time < 310)) {
            LampState_M.Lamps.TripSW2_4  = 0;//SW1_MENU
            LampState_M.Lamps.TripSW2_3  = 0;//SW1_UP
            LampState_M.Lamps.TripSW2_2  = 1;//SW1_DOWN               //DOWN
            LampState_M.Lamps.TripSW2_1  = 0;//SW1_OK
        } else if ((ElseCurrent.Time > 310) && (ElseCurrent.Time < 320)) {
            LampState_M.Lamps.TripSW2_4  = 0;//SW1_MENU
            LampState_M.Lamps.TripSW2_3  = 0;//SW1_UP
            LampState_M.Lamps.TripSW2_2  = 0;//SW1_DOWN
            LampState_M.Lamps.TripSW2_1  = 0;//SW1_OK
        }
        
        if (ElseCurrent.Time >= 350) {
            ElseCurrent.Time = 350;
        }
        break;
        /*case 3:
        if ((ElseCurrent.Time > 10) && (ElseCurrent.Time < 310)) {
        LampState_M.Lamps.TripSW2_4  = 1;//SW1_MENU
        LampState_M.Lamps.TripSW2_3  = 0;//SW1_UP
        LampState_M.Lamps.TripSW2_2  = 0;//SW1_DOWN
        LampState_M.Lamps.TripSW2_1  = 0;//SW1_OK
    } else if ((ElseCurrent.Time > 310) && (ElseCurrent.Time < 320)) {
        LampState_M.Lamps.TripSW2_4  = 0;//SW1_MENU
        LampState_M.Lamps.TripSW2_3  = 0;//SW1_UP
        LampState_M.Lamps.TripSW2_2  = 0;//SW1_DOWN
        LampState_M.Lamps.TripSW2_1  = 0;//SW1_OK
    }
        if (ElseCurrent.Time >= 350) {
        ElseCurrent.Time = 350;
    }
        break;*/
    case 3:
        if ((ElseCurrent.Time > 10) && (ElseCurrent.Time < 310)) {
            LampState_M.Lamps.TripSW2_4  = 0;//SW1_MENU
            LampState_M.Lamps.TripSW2_3  = 1;//SW1_UP          //UP
            LampState_M.Lamps.TripSW2_2  = 0;//SW1_DOWN
            LampState_M.Lamps.TripSW2_1  = 0;//SW1_OK
        } else if ((ElseCurrent.Time > 310) && (ElseCurrent.Time < 320)) {
            LampState_M.Lamps.TripSW2_4  = 0;//SW1_MENU
            LampState_M.Lamps.TripSW2_3  = 0;//SW1_UP
            LampState_M.Lamps.TripSW2_2  = 0;//SW1_DOWN
            LampState_M.Lamps.TripSW2_1  = 0;//SW1_OK
        }
        if (ElseCurrent.Time >= 350) {
            ElseCurrent.Time = 350;
        }
        break;
    case 4:
        if ((ElseCurrent.Time > 10) && (ElseCurrent.Time < 310)) {
            LampState_M.Lamps.TripSW2_4  = 0;//SW1_MENU
            LampState_M.Lamps.TripSW2_3  = 1;//SW1_UP                //UP
            LampState_M.Lamps.TripSW2_2  = 0;//SW1_DOWN
            LampState_M.Lamps.TripSW2_1  = 0;//SW1_OK
        } else if ((ElseCurrent.Time > 310) && (ElseCurrent.Time < 320)) {
            LampState_M.Lamps.TripSW2_4  = 0;//SW1_MENU
            LampState_M.Lamps.TripSW2_3  = 0;//SW1_UP
            LampState_M.Lamps.TripSW2_2  = 0;//SW1_DOWN
            LampState_M.Lamps.TripSW2_1  = 0;//SW1_OK
        }
        if (ElseCurrent.Time >= 350) {
            ElseCurrent.Time = 350;
        }
        break;
    case 5:
        if ((ElseCurrent.Time > 10) && (ElseCurrent.Time < 310)) {
            LampState_M.Lamps.TripSW2_4  = 0;//SW1_MENU
            LampState_M.Lamps.TripSW2_3  = 0;//SW1_UP             //DOWN
            LampState_M.Lamps.TripSW2_2  = 1;//SW1_DOWN
            LampState_M.Lamps.TripSW2_1  = 0;//SW1_OK
            LampState_R.Lamps.RELAY_F4 = 1; //SET -
        } else if ((ElseCurrent.Time > 310) && (ElseCurrent.Time < 320)) {
            LampState_M.Lamps.TripSW2_4  = 0;//SW1_MENU
            LampState_M.Lamps.TripSW2_3  = 0;//SW1_UP
            LampState_M.Lamps.TripSW2_2  = 0;//SW1_DOWN
            LampState_M.Lamps.TripSW2_1  = 0;//SW1_OK
            LampState_R.Lamps.RELAY_F4 = 0; //SET -
        }
        if (ElseCurrent.Time >= 350) {
            ElseCurrent.Time = 350;
        }
        break;
    case 6:
        if ((ElseCurrent.Time > 10) && (ElseCurrent.Time < 310)) {
            LampState_M.Lamps.TripSW2_4  = 0;//SW1_MENU
            LampState_M.Lamps.TripSW2_3  = 0;//SW1_UP
            LampState_M.Lamps.TripSW2_2  = 1;//SW1_DOWN
            LampState_M.Lamps.TripSW2_1  = 0;//SW1_OK
            LampState_R.Lamps.RELAY_F3 = 1;  //RES + 
        } else if ((ElseCurrent.Time > 310) && (ElseCurrent.Time < 320)) {
            LampState_M.Lamps.TripSW2_4  = 0;//SW1_MENU
            LampState_M.Lamps.TripSW2_3  = 0;//SW1_UP
            LampState_M.Lamps.TripSW2_2  = 0;//SW1_DOWN
            LampState_M.Lamps.TripSW2_1  = 0;//SW1_OK
            LampState_R.Lamps.RELAY_F3 = 0; //SET -
        }
        if (ElseCurrent.Time >= 350) {
            ElseCurrent.Time = 350;
        }
        break;
    case 7:
        LampState_R.Lamps.TripSW2_7 = 1; //CRUISE ON/OFF
        if ((ElseCurrent.Time > 10) && (ElseCurrent.Time < 310)) {
            LampState_M.Lamps.TripSW2_4  = 1;//SW1_MENU
            LampState_M.Lamps.TripSW2_3  = 0;//SW1_UP
            LampState_M.Lamps.TripSW2_2  = 0;//SW1_DOWN
            LampState_M.Lamps.TripSW2_1  = 0;//SW1_OK
            
        } else if ((ElseCurrent.Time > 310) && (ElseCurrent.Time < 320)) {
            LampState_M.Lamps.TripSW2_4  = 0;//SW1_MENU
            LampState_M.Lamps.TripSW2_3  = 0;//SW1_UP
            LampState_M.Lamps.TripSW2_2  = 0;//SW1_DOWN
            LampState_M.Lamps.TripSW2_1  = 0;//SW1_OK
         
        }
        if (ElseCurrent.Time >= 350) {
            ElseCurrent.Time = 350;
        }
        break;
        
        /*case 9:
        if ((ElseCurrent.Time > 10) && (ElseCurrent.Time < 310)) {
        LampState_M.Lamps.TripSW2_4  = 1;//SW1_MENU
        LampState_M.Lamps.TripSW2_3  = 0;//SW1_UP
        LampState_M.Lamps.TripSW2_2  = 0;//SW1_DOWN
        LampState_M.Lamps.TripSW2_1  = 0;//SW1_OK
    } else if ((ElseCurrent.Time > 310) && (ElseCurrent.Time < 320)) {
        LampState_M.Lamps.TripSW2_4  = 0;//SW1_MENU
        LampState_M.Lamps.TripSW2_3  = 0;//SW1_UP
        LampState_M.Lamps.TripSW2_2  = 0;//SW1_DOWN
        LampState_M.Lamps.TripSW2_1  = 0;//SW1_OK
    }
        if (ElseCurrent.Time >= 350) {
        ElseCurrent.Time = 350;
    }
        break;*/
        
    case 8:
        if(MODEtimer < 10)
        {
            Port_SetPortPinLevel(2, 26, 1);
        }
        else if(MODEtimer < 400)
        {
            Port_SetPortPinLevel(2, 26, 0);
        }
        else
        {
            if(CAN_0x2FC == 1)
            {
                CAN_0x2FC = 0;
                ElseCurrent.Value = 1;
            }
            else
            {
                ElseCurrent.Value = ERROR;
            }
            MODEtimer = 0;
        }
        
        break;
        
    
        
    default:
        break;
    }
    
    if (ElseCurrent.Value == ERROR) {
        Buzzer_Alarm();//����������
    }
}

void Gui_Temp(void) //ȼ��ˮ��  ˮ�µı��ķ��ͷŵ���10ms
{
    Default_flag=1;
    if(g_Stage != STAGE_WaterAndFuil)
    {
        Iol_TempCurrent.enable = 0;
    }
//    switch (Iol_TempCurrent.count)
//    {
//        case 0:
//            LampState_L.Lamps.LED7 = 0;
//            LampState_L.Lamps.LED6 = 0;
//            LampState_L.Lamps.LED5 = 0;
//            LampState_L.Lamps.LED4 = 0;
//            Iol_TempCurrent.statu = UNFINISH;
//            break;
//        case 4:
//            if(Iol_TempCurrent.enable == 1)
//            {
//                LampState_L.Lamps.RELAY_B = 0;
//                LampState_L.Lamps.RELAY_IGN1 = 0;
//                if(Iol_TempCurrent.Time > 1000)
//                {
//                    LampState_L.Lamps.RELAY_IGN1 = 1;
//                    LampState_L.Lamps.RELAY_B = 1;
//                    Iol_TempCurrent.enable = 0;
//                }
//            }
////            LampState_L.Lamps.LED7 = 0;
////            LampState_L.Lamps.LED6 = 0;
////            LampState_L.Lamps.LED5 = 0;
////            LampState_L.Lamps.LED4 = 1;
//            //ECU_Temperature_Water.msg.bits.Byte0Data = 0x67;
//            Iol_TempCurrent.statu = UNFINISH;
//            break;
//        case 3:
//            if(Iol_TempCurrent.enable == 1)
//            {
//                LampState_L.Lamps.RELAY_IGN1 = 0;
//                LampState_L.Lamps.RELAY_B = 0;
//                if(Iol_TempCurrent.Time > 1000)
//                {
//                    LampState_L.Lamps.RELAY_IGN1 = 1;
//                    LampState_L.Lamps.RELAY_B = 1;
//                    Iol_TempCurrent.enable = 0;
//                }
//            }
//            LampState_L.Lamps.LED7 = 0;                   //������
//            LampState_L.Lamps.LED6 = 0;
//            LampState_L.Lamps.LED5 = 1;
//            LampState_L.Lamps.LED4 = 0;
//            Iol_TempCurrent.statu = UNFINISH;
//            break;
//        case 2:
//            
//            if(Iol_TempCurrent.enable == 1)
//            {
//                LampState_L.Lamps.RELAY_IGN1 = 0;
//                LampState_L.Lamps.RELAY_B = 0;
//                if(Iol_TempCurrent.Time > 1000)
//                {
//                    LampState_L.Lamps.RELAY_IGN1 = 1;
//                    LampState_L.Lamps.RELAY_B = 1;
//                    Iol_TempCurrent.enable = 0;
//                }
//            }
//            LampState_L.Lamps.LED7 = 0;                   //�е�
//            LampState_L.Lamps.LED6 = 1;
//            LampState_L.Lamps.LED5 = 0;
//            LampState_L.Lamps.LED4 = 0;
//            Iol_TempCurrent.statu = UNFINISH;
//            break;
//        case 1:
//            if(Iol_TempCurrent.enable == 1)
//            {
//                LampState_L.Lamps.RELAY_IGN1 = 0;
//                LampState_L.Lamps.RELAY_B = 0;
//                if(Iol_TempCurrent.Time > 1000)
//                {
//                    LampState_L.Lamps.RELAY_IGN1 = 1;
//                    LampState_L.Lamps.RELAY_B = 1;
//                    Iol_TempCurrent.enable = 0;
//                }
//            }
//            LampState_L.Lamps.LED7 = 1;                  //����
//            LampState_L.Lamps.LED6 = 0;
//            LampState_L.Lamps.LED5 = 0;
//            LampState_L.Lamps.LED4 = 0;
//            //ECU_Temperature_Water.msg.bits.Byte0Data = 0x67;
//            Iol_TempCurrent.statu = FINISH;
//            break;
//    }
    /*switch (Iol_TempCurrent.count)
    {
        case 0:

            break;
        case 1:
        if(Iol_TempCurrent.Time > 12000 && Iol_TempCurrent.Time < 12600)
        {
            LampState_M.Lamps.TripSW2_4  = 1;//SW1_MENU
        }
        else if(Iol_TempCurrent.Time > 12600 && Iol_TempCurrent.Time < 12610)
        {
            LampState_M.Lamps.TripSW2_4  = 0;//SW1_MENU
        }
        if(Iol_TempCurrent.Time > 14000 && Iol_TempCurrent.Time < 14600)
        {
            LampState_M.Lamps.TripSW2_4  = 1;//SW1_MENU
        }
        else if(Iol_TempCurrent.Time > 1460 && Iol_TempCurrent.Time < 1461)
        {
            LampState_M.Lamps.TripSW2_4  = 0;//SW1_MENU
        }
        if(Iol_TempCurrent.Time > 1600 && Iol_TempCurrent.Time < 1660)
        {
            LampState_M.Lamps.TripSW2_4  = 1;//SW1_MENU
        }
        else if(Iol_TempCurrent.Time > 1660 && Iol_TempCurrent.Time < 1661)
        {
            LampState_M.Lamps.TripSW2_4  = 0;//SW1_MENU
        }
        if(Iol_TempCurrent.Time > 1800 && Iol_TempCurrent.Time < 1860)
        {
            LampState_M.Lamps.TripSW2_2 = 1;//down
        }
        else if(Iol_TempCurrent.Time > 1860 && Iol_TempCurrent.Time < 1861)
        {
            LampState_M.Lamps.TripSW2_2 = 0;//down
        }
        if(Iol_TempCurrent.Time > 2000 && Iol_TempCurrent.Time < 2060) //ok
        {
            LampState_M.Lamps.TripSW2_1 = 1;//SW1_OK
        }
        else if(Iol_TempCurrent.Time > 2060 && Iol_TempCurrent.Time < 2061)
        {
            LampState_M.Lamps.TripSW2_1 = 0;//SW1_OK
        }
        if(Iol_TempCurrent.Time > 2200 && Iol_TempCurrent.Time < 2260)
        {
            LampState_M.Lamps.TripSW2_1 = 1;//SW1_OK
        }
        else if(Iol_TempCurrent.Time > 2260 && Iol_TempCurrent.Time < 2261)
        {
            LampState_M.Lamps.TripSW2_1 = 0;//SW1_OK
        }
        if(Iol_TempCurrent.Time > 2400 && Iol_TempCurrent.Time < 2460)
        {
            LampState_M.Lamps.TripSW2_2 = 1;//down
        }
        else if(Iol_TempCurrent.Time > 2460 && Iol_TempCurrent.Time < 2461)
        {
            LampState_M.Lamps.TripSW2_2 = 0;//down
        }
        if(Iol_TempCurrent.Time > 2600 && Iol_TempCurrent.Time < 2660)
        {
            LampState_M.Lamps.TripSW2_2 = 1;//down
        }
        else if(Iol_TempCurrent.Time > 2660 && Iol_TempCurrent.Time < 2661)
        {
            LampState_M.Lamps.TripSW2_2 = 0;//down
        }
        if(Iol_TempCurrent.Time > 2800 && Iol_TempCurrent.Time < 2860)
        {
            LampState_M.Lamps.TripSW2_2 = 1;//down
        }
        else if(Iol_TempCurrent.Time > 2860 && Iol_TempCurrent.Time < 2861)
        {
            LampState_M.Lamps.TripSW2_2 = 0;//down
        }
        if(Iol_TempCurrent.Time > 3000 && Iol_TempCurrent.Time < 3060)
        {
            LampState_M.Lamps.TripSW2_1 = 1;//SW1_OK
        }
        else if(Iol_TempCurrent.Time > 3060 && Iol_TempCurrent.Time < 3061)
        {
            LampState_M.Lamps.TripSW2_1 = 0;//SW1_OK
        }
            break;           
        case 2:

            break;  
        case 3:

            break;    
        case 4:

            break;                
      
    }*/
}

extern uint16_t Diaplay_test;
extern uint8_t Read_Flag;

void APP_END(void)//����
{
    Default_flag=1;
    LampState_L.Lamps.LED7 = 0;                  //����
    LampState_L.Lamps.LED6 = 0;
    LampState_L.Lamps.LED5 = 0;
    LampState_L.Lamps.LED4 = 1;
    if(EndCurrent.enable == 1 && EndCurrent.Flag != FINISH)
    { 
      if(EndCurrent.Time > 1000 && EndCurrent.Time < 1101)
      {
        LampState_L.Lamps.RELAY_B = 0;
        LampState_L.Lamps.RELAY_IGN1 = 0; 
      }
      else if(EndCurrent.Time > 3101 && EndCurrent.Time < 3200)
      {
        LampState_L.Lamps.RELAY_B = 1;
        LampState_L.Lamps.RELAY_IGN1 = 1;
        
      }
       if(EndCurrent.Time > 5700 && EndCurrent.Time < 9000)//down����
      {
        FCA11.msg.bits.CF_VSM_Warn = 0x3;
//        FCA12.msg.bits.FCA_WarningTargetDisplay = 1;//FCA �����ƶ�
        PAS11.msg.bits.CF_Gway_PASCheckSound = 0x2;//SOUND_PDW_SENSORFAIL
        CGW2.msg.bits.CF_Gway_IDoutWarn = 1;//SOUND_IDOUT
        CGW2.msg.bits.CF_Gway_WngBuz = 0x2;//SOUND_KEY_OPERATED_WARNING    
      }
      if(EndCurrent.Time > 15000 && EndCurrent.Time < 15600)
      {
        LampState_M.Lamps.TripSW2_2  = 1;//SW1_DOWN
      }
      else if(EndCurrent.Time > 15600 && EndCurrent.Time < 15610)
      {
          LampState_M.Lamps.TripSW2_2  = 0;//SW1_DOWN
      }
     
      
      
      
      
      if(EndCurrent.Time > 17000 && EndCurrent.Time < 25000) //ok
      {
        LampState_M.Lamps.TripSW2_1 = 1;//SW1_OK
      }
      else if(EndCurrent.Time > 25000 && EndCurrent.Time < 25200)
      {
        LampState_M.Lamps.TripSW2_1 = 0;//SW1_OK
      }
       if(EndCurrent.Time > 25400 && EndCurrent.Time < 25500)
      {
        LampState_L.Lamps.RELAY_B = 0;
        LampState_L.Lamps.RELAY_IGN1 = 0;
      }
      else if(EndCurrent.Time > 25500 && EndCurrent.Time < 25600)
      {
        LampState_L.Lamps.RELAY_B = 1;
        LampState_L.Lamps.RELAY_IGN1 = 1;
        EndCurrent.statu = 1;// ���ƽ�����־
      }
//      if(EndCurrent.statu == 1)
//      {
//        if(EndCurrent.Time > 25700 && EndCurrent.Time < 25800)
//          GET_BUTTON_S_LEVEL;
//          
//        if(EndCurrent.Time > 25800 && EndCurrent.Time < 27000) 
//        {
//         if(BUTTON_S_IN == PortGpioHigh)
//          {
//              EndCurrent.Flag = 3; // ����ʧ��
//              EndCurrent.enable = 0;
//          }
//          if(BUTTON_S_IN == PortGpioLow)
//          {
//            EndCurrent.enable = 0;
//            EndCurrent.Flag = FINISH; // ���Ƴɹ�
//            WHL_SPD11.msg.bits.WHL_SPD_FL = 0;//260
//            WHL_SPD11.msg.bits.WHL_SPD_RL = 0;//260
//            CGW_PC4.msg.bits.N =0;//8000 ת��
//            g_Stage = 0;
//          }
//        }
//      }
//    }
    
    if(EndCurrent.Flag == 3)
    {
        Buzzer_Alarm();//����������
    }
    
    if(EndCurrent.Flag == FINISH && EndCurrent.count == OFF)
    {
        Diaplay_test ++;
        NewData.Data1 = Diaplay_test ;
        bsp_Save_Check_Service(2);//�洢�������
        EndCurrent.count = ON;
    }
    
}





}
