/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_ICU_H
#define __S6J3360_ICU_H

#include "s6j3360io_basetypes.h"

/* ICU[00-02/08-10] base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define ICU00	stcICU[0]
#define ICU01	stcICU[1]
#define ICU02	stcICU[2]
#define ICU08	stcICU[3]
#define ICU09	stcICU[4]
#define ICU10	stcICU[5]
#else /* __IO_DEFINE */
#define ICU00	(*((volatile stc_icun_t*)0xB4828000))
#define ICU01	(*((volatile stc_icun_t*)0xB4828400))
#define ICU02	(*((volatile stc_icun_t*)0xB4828800))
#define ICU08	(*((volatile stc_icun_t*)0xB48A8000))
#define ICU09	(*((volatile stc_icun_t*)0xB48A8400))
#define ICU10	(*((volatile stc_icun_t*)0xB48A8800))
#endif /* __IO_DEFINE */

/* IPCP[0/1] */
#define ICU00_IPCP0	(ICU00.unIPCP0.u32Register)  /*@rg@*/
#define ICU00_IPCP0_CP	ICU00_IPCP0  /*@bfrg@*/

#define ICU00_IPCP1	(ICU00.unIPCP1.u32Register)  /*@rg@*/
#define ICU00_IPCP1_CP	ICU00_IPCP1  /*@bfrg@*/

#define ICU01_IPCP0	(ICU01.unIPCP0.u32Register)  /*@rg@*/
#define ICU01_IPCP0_CP	ICU01_IPCP0  /*@bfrg@*/

#define ICU01_IPCP1	(ICU01.unIPCP1.u32Register)  /*@rg@*/
#define ICU01_IPCP1_CP	ICU01_IPCP1  /*@bfrg@*/

#define ICU02_IPCP0	(ICU02.unIPCP0.u32Register)  /*@rg@*/
#define ICU02_IPCP0_CP	ICU02_IPCP0  /*@bfrg@*/

#define ICU02_IPCP1	(ICU02.unIPCP1.u32Register)  /*@rg@*/
#define ICU02_IPCP1_CP	ICU02_IPCP1  /*@bfrg@*/

#define ICU08_IPCP0	(ICU08.unIPCP0.u32Register)  /*@rg@*/
#define ICU08_IPCP0_CP	ICU08_IPCP0  /*@bfrg@*/

#define ICU08_IPCP1	(ICU08.unIPCP1.u32Register)  /*@rg@*/
#define ICU08_IPCP1_CP	ICU08_IPCP1  /*@bfrg@*/

#define ICU09_IPCP0	(ICU09.unIPCP0.u32Register)  /*@rg@*/
#define ICU09_IPCP0_CP	ICU09_IPCP0  /*@bfrg@*/

#define ICU09_IPCP1	(ICU09.unIPCP1.u32Register)  /*@rg@*/
#define ICU09_IPCP1_CP	ICU09_IPCP1  /*@bfrg@*/

#define ICU10_IPCP0	(ICU10.unIPCP0.u32Register)  /*@rg@*/
#define ICU10_IPCP0_CP	ICU10_IPCP0  /*@bfrg@*/

#define ICU10_IPCP1	(ICU10.unIPCP1.u32Register)  /*@rg@*/
#define ICU10_IPCP1_CP	ICU10_IPCP1  /*@bfrg@*/

typedef union un_icun_ipcpn{
    uint_io32_t		u32Register;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_icun_ipcpn_t;

/* ICS */
#define ICU00_ICS	(ICU00.unICS.u32Register)  /*@rg@*/
#define ICU00_ICS_EG0	(ICU00.unICS.stcField.u2EG0)  /*@bf@*/
#define ICU00_ICS_EG1	(ICU00.unICS.stcField.u2EG1)  /*@bf@*/
#define ICU00_ICS_ICE0	(ICU00.unICS.stcField.u1ICE0)  /*@bf@*/
#define ICU00_ICS_ICE1	(ICU00.unICS.stcField.u1ICE1)  /*@bf@*/
#define ICU00_ICS_ICP0	(ICU00.unICS.stcField.u1ICP0)  /*@bf@*/
#define ICU00_ICS_ICP1	(ICU00.unICS.stcField.u1ICP1)  /*@bf@*/
#define ICU00_ICS_IEI0	(ICU00.unICS.stcField.u1IEI0)  /*@bf@*/
#define ICU00_ICS_IEI1	(ICU00.unICS.stcField.u1IEI1)  /*@bf@*/

#define ICU01_ICS	(ICU01.unICS.u32Register)  /*@rg@*/
#define ICU01_ICS_EG0	(ICU01.unICS.stcField.u2EG0)  /*@bf@*/
#define ICU01_ICS_EG1	(ICU01.unICS.stcField.u2EG1)  /*@bf@*/
#define ICU01_ICS_ICE0	(ICU01.unICS.stcField.u1ICE0)  /*@bf@*/
#define ICU01_ICS_ICE1	(ICU01.unICS.stcField.u1ICE1)  /*@bf@*/
#define ICU01_ICS_ICP0	(ICU01.unICS.stcField.u1ICP0)  /*@bf@*/
#define ICU01_ICS_ICP1	(ICU01.unICS.stcField.u1ICP1)  /*@bf@*/
#define ICU01_ICS_IEI0	(ICU01.unICS.stcField.u1IEI0)  /*@bf@*/
#define ICU01_ICS_IEI1	(ICU01.unICS.stcField.u1IEI1)  /*@bf@*/

#define ICU02_ICS	(ICU02.unICS.u32Register)  /*@rg@*/
#define ICU02_ICS_EG0	(ICU02.unICS.stcField.u2EG0)  /*@bf@*/
#define ICU02_ICS_EG1	(ICU02.unICS.stcField.u2EG1)  /*@bf@*/
#define ICU02_ICS_ICE0	(ICU02.unICS.stcField.u1ICE0)  /*@bf@*/
#define ICU02_ICS_ICE1	(ICU02.unICS.stcField.u1ICE1)  /*@bf@*/
#define ICU02_ICS_ICP0	(ICU02.unICS.stcField.u1ICP0)  /*@bf@*/
#define ICU02_ICS_ICP1	(ICU02.unICS.stcField.u1ICP1)  /*@bf@*/
#define ICU02_ICS_IEI0	(ICU02.unICS.stcField.u1IEI0)  /*@bf@*/
#define ICU02_ICS_IEI1	(ICU02.unICS.stcField.u1IEI1)  /*@bf@*/

#define ICU08_ICS	(ICU08.unICS.u32Register)  /*@rg@*/
#define ICU08_ICS_EG0	(ICU08.unICS.stcField.u2EG0)  /*@bf@*/
#define ICU08_ICS_EG1	(ICU08.unICS.stcField.u2EG1)  /*@bf@*/
#define ICU08_ICS_ICE0	(ICU08.unICS.stcField.u1ICE0)  /*@bf@*/
#define ICU08_ICS_ICE1	(ICU08.unICS.stcField.u1ICE1)  /*@bf@*/
#define ICU08_ICS_ICP0	(ICU08.unICS.stcField.u1ICP0)  /*@bf@*/
#define ICU08_ICS_ICP1	(ICU08.unICS.stcField.u1ICP1)  /*@bf@*/
#define ICU08_ICS_IEI0	(ICU08.unICS.stcField.u1IEI0)  /*@bf@*/
#define ICU08_ICS_IEI1	(ICU08.unICS.stcField.u1IEI1)  /*@bf@*/

#define ICU09_ICS	(ICU09.unICS.u32Register)  /*@rg@*/
#define ICU09_ICS_EG0	(ICU09.unICS.stcField.u2EG0)  /*@bf@*/
#define ICU09_ICS_EG1	(ICU09.unICS.stcField.u2EG1)  /*@bf@*/
#define ICU09_ICS_ICE0	(ICU09.unICS.stcField.u1ICE0)  /*@bf@*/
#define ICU09_ICS_ICE1	(ICU09.unICS.stcField.u1ICE1)  /*@bf@*/
#define ICU09_ICS_ICP0	(ICU09.unICS.stcField.u1ICP0)  /*@bf@*/
#define ICU09_ICS_ICP1	(ICU09.unICS.stcField.u1ICP1)  /*@bf@*/
#define ICU09_ICS_IEI0	(ICU09.unICS.stcField.u1IEI0)  /*@bf@*/
#define ICU09_ICS_IEI1	(ICU09.unICS.stcField.u1IEI1)  /*@bf@*/

#define ICU10_ICS	(ICU10.unICS.u32Register)  /*@rg@*/
#define ICU10_ICS_EG0	(ICU10.unICS.stcField.u2EG0)  /*@bf@*/
#define ICU10_ICS_EG1	(ICU10.unICS.stcField.u2EG1)  /*@bf@*/
#define ICU10_ICS_ICE0	(ICU10.unICS.stcField.u1ICE0)  /*@bf@*/
#define ICU10_ICS_ICE1	(ICU10.unICS.stcField.u1ICE1)  /*@bf@*/
#define ICU10_ICS_ICP0	(ICU10.unICS.stcField.u1ICP0)  /*@bf@*/
#define ICU10_ICS_ICP1	(ICU10.unICS.stcField.u1ICP1)  /*@bf@*/
#define ICU10_ICS_IEI0	(ICU10.unICS.stcField.u1IEI0)  /*@bf@*/
#define ICU10_ICS_IEI1	(ICU10.unICS.stcField.u1IEI1)  /*@bf@*/

typedef struct stc_icun_ics_field{
    uint_io32_t		u2EG0:2;
    uint_io32_t		u2EG1:2;
    uint_io32_t		u1ICE0:1;
    uint_io32_t		u1ICE1:1;
    uint_io32_t		u1ICP0:1;
    uint_io32_t		u1ICP1:1;
    uint_io32_t		u1IEI0:1;
    uint_io32_t		u1IEI1:1;
    uint_io32_t		:22;
}stc_icun_ics_field_t;

typedef union un_icun_ics{
    uint_io32_t		u32Register;
    stc_icun_ics_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_icun_ics_t;

/* ICSC */
#define ICU00_ICSC	(ICU00.unICSC.u32Register)  /*@rg@*/
#define ICU00_ICSC_ICE0C	(ICU00.unICSC.stcField.u1ICE0C)  /*@bf@*/
#define ICU00_ICSC_ICE1C	(ICU00.unICSC.stcField.u1ICE1C)  /*@bf@*/
#define ICU00_ICSC_ICP0C	(ICU00.unICSC.stcField.u1ICP0C)  /*@bf@*/
#define ICU00_ICSC_ICP1C	(ICU00.unICSC.stcField.u1ICP1C)  /*@bf@*/

#define ICU01_ICSC	(ICU01.unICSC.u32Register)  /*@rg@*/
#define ICU01_ICSC_ICE0C	(ICU01.unICSC.stcField.u1ICE0C)  /*@bf@*/
#define ICU01_ICSC_ICE1C	(ICU01.unICSC.stcField.u1ICE1C)  /*@bf@*/
#define ICU01_ICSC_ICP0C	(ICU01.unICSC.stcField.u1ICP0C)  /*@bf@*/
#define ICU01_ICSC_ICP1C	(ICU01.unICSC.stcField.u1ICP1C)  /*@bf@*/

#define ICU02_ICSC	(ICU02.unICSC.u32Register)  /*@rg@*/
#define ICU02_ICSC_ICE0C	(ICU02.unICSC.stcField.u1ICE0C)  /*@bf@*/
#define ICU02_ICSC_ICE1C	(ICU02.unICSC.stcField.u1ICE1C)  /*@bf@*/
#define ICU02_ICSC_ICP0C	(ICU02.unICSC.stcField.u1ICP0C)  /*@bf@*/
#define ICU02_ICSC_ICP1C	(ICU02.unICSC.stcField.u1ICP1C)  /*@bf@*/

#define ICU08_ICSC	(ICU08.unICSC.u32Register)  /*@rg@*/
#define ICU08_ICSC_ICE0C	(ICU08.unICSC.stcField.u1ICE0C)  /*@bf@*/
#define ICU08_ICSC_ICE1C	(ICU08.unICSC.stcField.u1ICE1C)  /*@bf@*/
#define ICU08_ICSC_ICP0C	(ICU08.unICSC.stcField.u1ICP0C)  /*@bf@*/
#define ICU08_ICSC_ICP1C	(ICU08.unICSC.stcField.u1ICP1C)  /*@bf@*/

#define ICU09_ICSC	(ICU09.unICSC.u32Register)  /*@rg@*/
#define ICU09_ICSC_ICE0C	(ICU09.unICSC.stcField.u1ICE0C)  /*@bf@*/
#define ICU09_ICSC_ICE1C	(ICU09.unICSC.stcField.u1ICE1C)  /*@bf@*/
#define ICU09_ICSC_ICP0C	(ICU09.unICSC.stcField.u1ICP0C)  /*@bf@*/
#define ICU09_ICSC_ICP1C	(ICU09.unICSC.stcField.u1ICP1C)  /*@bf@*/

#define ICU10_ICSC	(ICU10.unICSC.u32Register)  /*@rg@*/
#define ICU10_ICSC_ICE0C	(ICU10.unICSC.stcField.u1ICE0C)  /*@bf@*/
#define ICU10_ICSC_ICE1C	(ICU10.unICSC.stcField.u1ICE1C)  /*@bf@*/
#define ICU10_ICSC_ICP0C	(ICU10.unICSC.stcField.u1ICP0C)  /*@bf@*/
#define ICU10_ICSC_ICP1C	(ICU10.unICSC.stcField.u1ICP1C)  /*@bf@*/

typedef struct stc_icun_icsc_field{
    uint_io32_t		:4;
    uint_io32_t		u1ICE0C:1;
    uint_io32_t		u1ICE1C:1;
    uint_io32_t		u1ICP0C:1;
    uint_io32_t		u1ICP1C:1;
    uint_io32_t		:24;
}stc_icun_icsc_field_t;

typedef union un_icun_icsc{
    uint_io32_t		u32Register;
    stc_icun_icsc_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_icun_icsc_t;

/* ICSS */
#define ICU00_ICSS	(ICU00.unICSS.u32Register)  /*@rg@*/
#define ICU00_ICSS_ICE0S	(ICU00.unICSS.stcField.u1ICE0S)  /*@bf@*/
#define ICU00_ICSS_ICE1S	(ICU00.unICSS.stcField.u1ICE1S)  /*@bf@*/

#define ICU01_ICSS	(ICU01.unICSS.u32Register)  /*@rg@*/
#define ICU01_ICSS_ICE0S	(ICU01.unICSS.stcField.u1ICE0S)  /*@bf@*/
#define ICU01_ICSS_ICE1S	(ICU01.unICSS.stcField.u1ICE1S)  /*@bf@*/

#define ICU02_ICSS	(ICU02.unICSS.u32Register)  /*@rg@*/
#define ICU02_ICSS_ICE0S	(ICU02.unICSS.stcField.u1ICE0S)  /*@bf@*/
#define ICU02_ICSS_ICE1S	(ICU02.unICSS.stcField.u1ICE1S)  /*@bf@*/

#define ICU08_ICSS	(ICU08.unICSS.u32Register)  /*@rg@*/
#define ICU08_ICSS_ICE0S	(ICU08.unICSS.stcField.u1ICE0S)  /*@bf@*/
#define ICU08_ICSS_ICE1S	(ICU08.unICSS.stcField.u1ICE1S)  /*@bf@*/

#define ICU09_ICSS	(ICU09.unICSS.u32Register)  /*@rg@*/
#define ICU09_ICSS_ICE0S	(ICU09.unICSS.stcField.u1ICE0S)  /*@bf@*/
#define ICU09_ICSS_ICE1S	(ICU09.unICSS.stcField.u1ICE1S)  /*@bf@*/

#define ICU10_ICSS	(ICU10.unICSS.u32Register)  /*@rg@*/
#define ICU10_ICSS_ICE0S	(ICU10.unICSS.stcField.u1ICE0S)  /*@bf@*/
#define ICU10_ICSS_ICE1S	(ICU10.unICSS.stcField.u1ICE1S)  /*@bf@*/

typedef struct stc_icun_icss_field{
    uint_io32_t		:4;
    uint_io32_t		u1ICE0S:1;
    uint_io32_t		u1ICE1S:1;
    uint_io32_t		:26;
}stc_icun_icss_field_t;

typedef union un_icun_icss{
    uint_io32_t		u32Register;
    stc_icun_icss_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_icun_icss_t;


typedef struct stc_icun{
    un_icun_ipcpn_t	unIPCP0;	/* 0x00000000 */
    un_icun_ipcpn_t	unIPCP1;	/* 0x00000004 */
    un_icun_ics_t	unICS;	/* 0x00000008 */
    un_icun_icsc_t	unICSC;	/* 0x0000000C */
    un_icun_icss_t	unICSS;	/* 0x00000010 */
    uint_io8_t	au8Reserved0[1004];	/* 0x00000014 */
}stc_icun_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_icun_t	stcICU[6];
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 1024(0x400) bytes */


#endif /* __S6J3360_ICU_H */
