/*
#************************************************************************
#*                                                                      *
#* S6J3360/S6J3370 SERIES I/O REGISTER FILE V01L02                      *
#*                                                                      *
#************************************************************************
#
#************************************************************************
#* 1  Disclaimer                                                        *
#************************************************************************
#* __DISCLAIMER_START__                                                 *
#************************************************************************
#* (C)2017, Cypress Semiconductor Corporation
#* or a subsidiary of Cypress Semiconductor Corporation. All rights
#* reserved.
#*
#* This software, including source code, documentation and related
#* materials ("Software"), is owned by Cypress Semiconductor
#* Corporation or one of its subsidiaries ("Cypress") and is protected by
#* and subject to worldwide patent protection (United States and foreign),
#* United States copyright laws and international treaty provisions.
#* Therefore, you may use this Software only as provided in the license
#* agreement accompanying the software package from which you
#* obtained this Software ("EULA").
#*
#* If no EULA applies, Cypress hereby grants you a personal, nonexclusive,
#* non-transferable license to copy, modify, and compile the
#* Software source code solely for use in connection with Cypress's
#* integrated circuit products. Any reproduction, modification, translation,
#* compilation, or representation of this Software except as specified
#* above is prohibited without the express written permission of Cypress.
#*
#* Disclaimer: THIS SOFTWARE IS PROVIDED AS-IS, WITH NO
#* WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING,
#* BUT NOT LIMITED TO, NONINFRINGEMENT, IMPLIED
#* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
#* PARTICULAR PURPOSE. Cypress reserves the right to make
#* changes to the Software without notice. Cypress does not assume any
#* liability arising out of the application or use of the Software or any
#* product or circuit described in the Software. Cypress does not
#* authorize its products for use in any products where a malfunction or
#* failure of the Cypress product may reasonably be expected to result in
#* significant property damage, injury or death ("High Risk Product"). By
#* including Cypress's product in a High Risk Product, the manufacturer
#* of such system or application assumes all risk of such use and in doing
#* so agrees to indemnify Cypress against all liability.
#************************************************************************
#* __DISCLAIMER_END__                                                   *
#************************************************************************
*/

#ifndef __S6J3360_PPC_H
#define __S6J3360_PPC_H

#include "s6j3360io_basetypes.h"

/* PPC base pointer */
#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
#define PPC	stcPPC
#else /* __IO_DEFINE */
#define PPC	(*((volatile stc_ppc_t*)0xB4740000))
#endif /* __IO_DEFINE */

/* PCFGR[000-031/100-131/200-231/300-331] */
#define PPC_PCFGR000	(PPC.unPCFGR000.u16Register)  /*@rg@*/
#define PPC_PCFGR000_POF	(PPC.unPCFGR000.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR000_NFE	(PPC.unPCFGR000.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR000_ODR	(PPC.unPCFGR000.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR000_PDE	(PPC.unPCFGR000.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR000_PUE	(PPC.unPCFGR000.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR000_PIL	(PPC.unPCFGR000.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR000_PIE	(PPC.unPCFGR000.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR000_PID	(PPC.unPCFGR000.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR000_POD	(PPC.unPCFGR000.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR000_POE	(PPC.unPCFGR000.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR001	(PPC.unPCFGR001.u16Register)  /*@rg@*/
#define PPC_PCFGR001_POF	(PPC.unPCFGR001.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR001_NFE	(PPC.unPCFGR001.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR001_ODR	(PPC.unPCFGR001.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR001_PDE	(PPC.unPCFGR001.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR001_PUE	(PPC.unPCFGR001.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR001_PIL	(PPC.unPCFGR001.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR001_PIE	(PPC.unPCFGR001.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR001_PID	(PPC.unPCFGR001.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR001_POD	(PPC.unPCFGR001.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR001_POE	(PPC.unPCFGR001.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR002	(PPC.unPCFGR002.u16Register)  /*@rg@*/
#define PPC_PCFGR002_POF	(PPC.unPCFGR002.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR002_NFE	(PPC.unPCFGR002.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR002_ODR	(PPC.unPCFGR002.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR002_PDE	(PPC.unPCFGR002.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR002_PUE	(PPC.unPCFGR002.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR002_PIL	(PPC.unPCFGR002.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR002_PIE	(PPC.unPCFGR002.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR002_PID	(PPC.unPCFGR002.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR002_POD	(PPC.unPCFGR002.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR002_POE	(PPC.unPCFGR002.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR003	(PPC.unPCFGR003.u16Register)  /*@rg@*/
#define PPC_PCFGR003_POF	(PPC.unPCFGR003.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR003_NFE	(PPC.unPCFGR003.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR003_ODR	(PPC.unPCFGR003.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR003_PDE	(PPC.unPCFGR003.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR003_PUE	(PPC.unPCFGR003.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR003_PIL	(PPC.unPCFGR003.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR003_PIE	(PPC.unPCFGR003.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR003_PID	(PPC.unPCFGR003.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR003_POD	(PPC.unPCFGR003.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR003_POE	(PPC.unPCFGR003.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR004	(PPC.unPCFGR004.u16Register)  /*@rg@*/
#define PPC_PCFGR004_POF	(PPC.unPCFGR004.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR004_NFE	(PPC.unPCFGR004.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR004_ODR	(PPC.unPCFGR004.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR004_PDE	(PPC.unPCFGR004.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR004_PUE	(PPC.unPCFGR004.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR004_PIL	(PPC.unPCFGR004.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR004_PIE	(PPC.unPCFGR004.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR004_PID	(PPC.unPCFGR004.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR004_POD	(PPC.unPCFGR004.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR004_POE	(PPC.unPCFGR004.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR005	(PPC.unPCFGR005.u16Register)  /*@rg@*/
#define PPC_PCFGR005_POF	(PPC.unPCFGR005.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR005_NFE	(PPC.unPCFGR005.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR005_ODR	(PPC.unPCFGR005.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR005_PDE	(PPC.unPCFGR005.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR005_PUE	(PPC.unPCFGR005.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR005_PIL	(PPC.unPCFGR005.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR005_PIE	(PPC.unPCFGR005.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR005_PID	(PPC.unPCFGR005.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR005_POD	(PPC.unPCFGR005.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR005_POE	(PPC.unPCFGR005.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR006	(PPC.unPCFGR006.u16Register)  /*@rg@*/
#define PPC_PCFGR006_POF	(PPC.unPCFGR006.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR006_NFE	(PPC.unPCFGR006.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR006_ODR	(PPC.unPCFGR006.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR006_PDE	(PPC.unPCFGR006.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR006_PUE	(PPC.unPCFGR006.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR006_PIL	(PPC.unPCFGR006.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR006_PIE	(PPC.unPCFGR006.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR006_PID	(PPC.unPCFGR006.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR006_POD	(PPC.unPCFGR006.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR006_POE	(PPC.unPCFGR006.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR007	(PPC.unPCFGR007.u16Register)  /*@rg@*/
#define PPC_PCFGR007_POF	(PPC.unPCFGR007.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR007_NFE	(PPC.unPCFGR007.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR007_ODR	(PPC.unPCFGR007.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR007_PDE	(PPC.unPCFGR007.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR007_PUE	(PPC.unPCFGR007.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR007_PIL	(PPC.unPCFGR007.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR007_PIE	(PPC.unPCFGR007.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR007_PID	(PPC.unPCFGR007.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR007_POD	(PPC.unPCFGR007.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR007_POE	(PPC.unPCFGR007.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR008	(PPC.unPCFGR008.u16Register)  /*@rg@*/
#define PPC_PCFGR008_POF	(PPC.unPCFGR008.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR008_NFE	(PPC.unPCFGR008.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR008_ODR	(PPC.unPCFGR008.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR008_PDE	(PPC.unPCFGR008.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR008_PUE	(PPC.unPCFGR008.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR008_PIL	(PPC.unPCFGR008.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR008_PIE	(PPC.unPCFGR008.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR008_PID	(PPC.unPCFGR008.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR008_POD	(PPC.unPCFGR008.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR008_POE	(PPC.unPCFGR008.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR009	(PPC.unPCFGR009.u16Register)  /*@rg@*/
#define PPC_PCFGR009_POF	(PPC.unPCFGR009.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR009_NFE	(PPC.unPCFGR009.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR009_ODR	(PPC.unPCFGR009.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR009_PDE	(PPC.unPCFGR009.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR009_PUE	(PPC.unPCFGR009.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR009_PIL	(PPC.unPCFGR009.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR009_PIE	(PPC.unPCFGR009.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR009_PID	(PPC.unPCFGR009.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR009_POD	(PPC.unPCFGR009.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR009_POE	(PPC.unPCFGR009.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR010	(PPC.unPCFGR010.u16Register)  /*@rg@*/
#define PPC_PCFGR010_POF	(PPC.unPCFGR010.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR010_NFE	(PPC.unPCFGR010.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR010_ODR	(PPC.unPCFGR010.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR010_PDE	(PPC.unPCFGR010.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR010_PUE	(PPC.unPCFGR010.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR010_PIL	(PPC.unPCFGR010.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR010_PIE	(PPC.unPCFGR010.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR010_PID	(PPC.unPCFGR010.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR010_POD	(PPC.unPCFGR010.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR010_POE	(PPC.unPCFGR010.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR011	(PPC.unPCFGR011.u16Register)  /*@rg@*/
#define PPC_PCFGR011_POF	(PPC.unPCFGR011.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR011_NFE	(PPC.unPCFGR011.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR011_ODR	(PPC.unPCFGR011.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR011_PDE	(PPC.unPCFGR011.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR011_PUE	(PPC.unPCFGR011.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR011_PIL	(PPC.unPCFGR011.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR011_PIE	(PPC.unPCFGR011.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR011_PID	(PPC.unPCFGR011.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR011_POD	(PPC.unPCFGR011.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR011_POE	(PPC.unPCFGR011.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR012	(PPC.unPCFGR012.u16Register)  /*@rg@*/
#define PPC_PCFGR012_POF	(PPC.unPCFGR012.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR012_NFE	(PPC.unPCFGR012.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR012_ODR	(PPC.unPCFGR012.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR012_PDE	(PPC.unPCFGR012.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR012_PUE	(PPC.unPCFGR012.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR012_PIL	(PPC.unPCFGR012.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR012_PIE	(PPC.unPCFGR012.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR012_PID	(PPC.unPCFGR012.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR012_POD	(PPC.unPCFGR012.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR012_POE	(PPC.unPCFGR012.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR013	(PPC.unPCFGR013.u16Register)  /*@rg@*/
#define PPC_PCFGR013_POF	(PPC.unPCFGR013.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR013_NFE	(PPC.unPCFGR013.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR013_ODR	(PPC.unPCFGR013.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR013_PDE	(PPC.unPCFGR013.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR013_PUE	(PPC.unPCFGR013.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR013_PIL	(PPC.unPCFGR013.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR013_PIE	(PPC.unPCFGR013.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR013_PID	(PPC.unPCFGR013.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR013_POD	(PPC.unPCFGR013.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR013_POE	(PPC.unPCFGR013.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR014	(PPC.unPCFGR014.u16Register)  /*@rg@*/
#define PPC_PCFGR014_POF	(PPC.unPCFGR014.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR014_NFE	(PPC.unPCFGR014.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR014_ODR	(PPC.unPCFGR014.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR014_PDE	(PPC.unPCFGR014.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR014_PUE	(PPC.unPCFGR014.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR014_PIL	(PPC.unPCFGR014.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR014_PIE	(PPC.unPCFGR014.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR014_PID	(PPC.unPCFGR014.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR014_POD	(PPC.unPCFGR014.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR014_POE	(PPC.unPCFGR014.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR015	(PPC.unPCFGR015.u16Register)  /*@rg@*/
#define PPC_PCFGR015_POF	(PPC.unPCFGR015.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR015_NFE	(PPC.unPCFGR015.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR015_ODR	(PPC.unPCFGR015.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR015_PDE	(PPC.unPCFGR015.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR015_PUE	(PPC.unPCFGR015.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR015_PIL	(PPC.unPCFGR015.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR015_PIE	(PPC.unPCFGR015.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR015_PID	(PPC.unPCFGR015.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR015_POD	(PPC.unPCFGR015.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR015_POE	(PPC.unPCFGR015.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR016	(PPC.unPCFGR016.u16Register)  /*@rg@*/
#define PPC_PCFGR016_POF	(PPC.unPCFGR016.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR016_NFE	(PPC.unPCFGR016.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR016_ODR	(PPC.unPCFGR016.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR016_PDE	(PPC.unPCFGR016.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR016_PUE	(PPC.unPCFGR016.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR016_PIL	(PPC.unPCFGR016.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR016_PIE	(PPC.unPCFGR016.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR016_PID	(PPC.unPCFGR016.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR016_POD	(PPC.unPCFGR016.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR016_POE	(PPC.unPCFGR016.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR017	(PPC.unPCFGR017.u16Register)  /*@rg@*/
#define PPC_PCFGR017_POF	(PPC.unPCFGR017.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR017_NFE	(PPC.unPCFGR017.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR017_ODR	(PPC.unPCFGR017.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR017_PDE	(PPC.unPCFGR017.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR017_PUE	(PPC.unPCFGR017.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR017_PIL	(PPC.unPCFGR017.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR017_PIE	(PPC.unPCFGR017.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR017_PID	(PPC.unPCFGR017.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR017_POD	(PPC.unPCFGR017.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR017_POE	(PPC.unPCFGR017.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR018	(PPC.unPCFGR018.u16Register)  /*@rg@*/
#define PPC_PCFGR018_POF	(PPC.unPCFGR018.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR018_NFE	(PPC.unPCFGR018.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR018_ODR	(PPC.unPCFGR018.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR018_PDE	(PPC.unPCFGR018.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR018_PUE	(PPC.unPCFGR018.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR018_PIL	(PPC.unPCFGR018.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR018_PIE	(PPC.unPCFGR018.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR018_PID	(PPC.unPCFGR018.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR018_POD	(PPC.unPCFGR018.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR018_POE	(PPC.unPCFGR018.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR019	(PPC.unPCFGR019.u16Register)  /*@rg@*/
#define PPC_PCFGR019_POF	(PPC.unPCFGR019.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR019_NFE	(PPC.unPCFGR019.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR019_ODR	(PPC.unPCFGR019.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR019_PDE	(PPC.unPCFGR019.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR019_PUE	(PPC.unPCFGR019.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR019_PIL	(PPC.unPCFGR019.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR019_PIE	(PPC.unPCFGR019.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR019_PID	(PPC.unPCFGR019.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR019_POD	(PPC.unPCFGR019.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR019_POE	(PPC.unPCFGR019.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR020	(PPC.unPCFGR020.u16Register)  /*@rg@*/
#define PPC_PCFGR020_POF	(PPC.unPCFGR020.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR020_NFE	(PPC.unPCFGR020.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR020_ODR	(PPC.unPCFGR020.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR020_PDE	(PPC.unPCFGR020.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR020_PUE	(PPC.unPCFGR020.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR020_PIL	(PPC.unPCFGR020.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR020_PIE	(PPC.unPCFGR020.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR020_PID	(PPC.unPCFGR020.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR020_POD	(PPC.unPCFGR020.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR020_POE	(PPC.unPCFGR020.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR021	(PPC.unPCFGR021.u16Register)  /*@rg@*/
#define PPC_PCFGR021_POF	(PPC.unPCFGR021.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR021_NFE	(PPC.unPCFGR021.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR021_ODR	(PPC.unPCFGR021.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR021_PDE	(PPC.unPCFGR021.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR021_PUE	(PPC.unPCFGR021.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR021_PIL	(PPC.unPCFGR021.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR021_PIE	(PPC.unPCFGR021.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR021_PID	(PPC.unPCFGR021.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR021_POD	(PPC.unPCFGR021.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR021_POE	(PPC.unPCFGR021.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR022	(PPC.unPCFGR022.u16Register)  /*@rg@*/
#define PPC_PCFGR022_POF	(PPC.unPCFGR022.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR022_NFE	(PPC.unPCFGR022.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR022_ODR	(PPC.unPCFGR022.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR022_PDE	(PPC.unPCFGR022.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR022_PUE	(PPC.unPCFGR022.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR022_PIL	(PPC.unPCFGR022.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR022_PIE	(PPC.unPCFGR022.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR022_PID	(PPC.unPCFGR022.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR022_POD	(PPC.unPCFGR022.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR022_POE	(PPC.unPCFGR022.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR023	(PPC.unPCFGR023.u16Register)  /*@rg@*/
#define PPC_PCFGR023_POF	(PPC.unPCFGR023.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR023_NFE	(PPC.unPCFGR023.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR023_ODR	(PPC.unPCFGR023.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR023_PDE	(PPC.unPCFGR023.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR023_PUE	(PPC.unPCFGR023.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR023_PIL	(PPC.unPCFGR023.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR023_PIE	(PPC.unPCFGR023.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR023_PID	(PPC.unPCFGR023.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR023_POD	(PPC.unPCFGR023.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR023_POE	(PPC.unPCFGR023.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR024	(PPC.unPCFGR024.u16Register)  /*@rg@*/
#define PPC_PCFGR024_POF	(PPC.unPCFGR024.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR024_NFE	(PPC.unPCFGR024.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR024_ODR	(PPC.unPCFGR024.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR024_PDE	(PPC.unPCFGR024.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR024_PUE	(PPC.unPCFGR024.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR024_PIL	(PPC.unPCFGR024.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR024_PIE	(PPC.unPCFGR024.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR024_PID	(PPC.unPCFGR024.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR024_POD	(PPC.unPCFGR024.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR024_POE	(PPC.unPCFGR024.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR025	(PPC.unPCFGR025.u16Register)  /*@rg@*/
#define PPC_PCFGR025_POF	(PPC.unPCFGR025.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR025_NFE	(PPC.unPCFGR025.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR025_ODR	(PPC.unPCFGR025.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR025_PDE	(PPC.unPCFGR025.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR025_PUE	(PPC.unPCFGR025.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR025_PIL	(PPC.unPCFGR025.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR025_PIE	(PPC.unPCFGR025.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR025_PID	(PPC.unPCFGR025.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR025_POD	(PPC.unPCFGR025.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR025_POE	(PPC.unPCFGR025.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR026	(PPC.unPCFGR026.u16Register)  /*@rg@*/
#define PPC_PCFGR026_POF	(PPC.unPCFGR026.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR026_NFE	(PPC.unPCFGR026.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR026_ODR	(PPC.unPCFGR026.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR026_PDE	(PPC.unPCFGR026.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR026_PUE	(PPC.unPCFGR026.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR026_PIL	(PPC.unPCFGR026.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR026_PIE	(PPC.unPCFGR026.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR026_PID	(PPC.unPCFGR026.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR026_POD	(PPC.unPCFGR026.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR026_POE	(PPC.unPCFGR026.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR027	(PPC.unPCFGR027.u16Register)  /*@rg@*/
#define PPC_PCFGR027_POF	(PPC.unPCFGR027.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR027_NFE	(PPC.unPCFGR027.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR027_ODR	(PPC.unPCFGR027.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR027_PDE	(PPC.unPCFGR027.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR027_PUE	(PPC.unPCFGR027.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR027_PIL	(PPC.unPCFGR027.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR027_PIE	(PPC.unPCFGR027.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR027_PID	(PPC.unPCFGR027.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR027_POD	(PPC.unPCFGR027.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR027_POE	(PPC.unPCFGR027.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR028	(PPC.unPCFGR028.u16Register)  /*@rg@*/
#define PPC_PCFGR028_POF	(PPC.unPCFGR028.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR028_NFE	(PPC.unPCFGR028.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR028_ODR	(PPC.unPCFGR028.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR028_PDE	(PPC.unPCFGR028.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR028_PUE	(PPC.unPCFGR028.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR028_PIL	(PPC.unPCFGR028.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR028_PIE	(PPC.unPCFGR028.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR028_PID	(PPC.unPCFGR028.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR028_POD	(PPC.unPCFGR028.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR028_POE	(PPC.unPCFGR028.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR029	(PPC.unPCFGR029.u16Register)  /*@rg@*/
#define PPC_PCFGR029_POF	(PPC.unPCFGR029.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR029_NFE	(PPC.unPCFGR029.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR029_ODR	(PPC.unPCFGR029.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR029_PDE	(PPC.unPCFGR029.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR029_PUE	(PPC.unPCFGR029.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR029_PIL	(PPC.unPCFGR029.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR029_PIE	(PPC.unPCFGR029.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR029_PID	(PPC.unPCFGR029.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR029_POD	(PPC.unPCFGR029.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR029_POE	(PPC.unPCFGR029.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR030	(PPC.unPCFGR030.u16Register)  /*@rg@*/
#define PPC_PCFGR030_POF	(PPC.unPCFGR030.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR030_NFE	(PPC.unPCFGR030.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR030_ODR	(PPC.unPCFGR030.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR030_PDE	(PPC.unPCFGR030.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR030_PUE	(PPC.unPCFGR030.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR030_PIL	(PPC.unPCFGR030.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR030_PIE	(PPC.unPCFGR030.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR030_PID	(PPC.unPCFGR030.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR030_POD	(PPC.unPCFGR030.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR030_POE	(PPC.unPCFGR030.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR031	(PPC.unPCFGR031.u16Register)  /*@rg@*/
#define PPC_PCFGR031_POF	(PPC.unPCFGR031.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR031_NFE	(PPC.unPCFGR031.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR031_ODR	(PPC.unPCFGR031.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR031_PDE	(PPC.unPCFGR031.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR031_PUE	(PPC.unPCFGR031.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR031_PIL	(PPC.unPCFGR031.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR031_PIE	(PPC.unPCFGR031.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR031_PID	(PPC.unPCFGR031.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR031_POD	(PPC.unPCFGR031.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR031_POE	(PPC.unPCFGR031.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR100	(PPC.unPCFGR100.u16Register)  /*@rg@*/
#define PPC_PCFGR100_POF	(PPC.unPCFGR100.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR100_NFE	(PPC.unPCFGR100.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR100_ODR	(PPC.unPCFGR100.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR100_PDE	(PPC.unPCFGR100.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR100_PUE	(PPC.unPCFGR100.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR100_PIL	(PPC.unPCFGR100.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR100_PIE	(PPC.unPCFGR100.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR100_PID	(PPC.unPCFGR100.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR100_POD	(PPC.unPCFGR100.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR100_POE	(PPC.unPCFGR100.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR101	(PPC.unPCFGR101.u16Register)  /*@rg@*/
#define PPC_PCFGR101_POF	(PPC.unPCFGR101.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR101_NFE	(PPC.unPCFGR101.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR101_ODR	(PPC.unPCFGR101.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR101_PDE	(PPC.unPCFGR101.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR101_PUE	(PPC.unPCFGR101.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR101_PIL	(PPC.unPCFGR101.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR101_PIE	(PPC.unPCFGR101.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR101_PID	(PPC.unPCFGR101.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR101_POD	(PPC.unPCFGR101.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR101_POE	(PPC.unPCFGR101.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR102	(PPC.unPCFGR102.u16Register)  /*@rg@*/
#define PPC_PCFGR102_POF	(PPC.unPCFGR102.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR102_NFE	(PPC.unPCFGR102.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR102_ODR	(PPC.unPCFGR102.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR102_PDE	(PPC.unPCFGR102.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR102_PUE	(PPC.unPCFGR102.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR102_PIL	(PPC.unPCFGR102.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR102_PIE	(PPC.unPCFGR102.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR102_PID	(PPC.unPCFGR102.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR102_POD	(PPC.unPCFGR102.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR102_POE	(PPC.unPCFGR102.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR103	(PPC.unPCFGR103.u16Register)  /*@rg@*/
#define PPC_PCFGR103_POF	(PPC.unPCFGR103.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR103_NFE	(PPC.unPCFGR103.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR103_ODR	(PPC.unPCFGR103.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR103_PDE	(PPC.unPCFGR103.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR103_PUE	(PPC.unPCFGR103.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR103_PIL	(PPC.unPCFGR103.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR103_PIE	(PPC.unPCFGR103.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR103_PID	(PPC.unPCFGR103.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR103_POD	(PPC.unPCFGR103.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR103_POE	(PPC.unPCFGR103.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR104	(PPC.unPCFGR104.u16Register)  /*@rg@*/
#define PPC_PCFGR104_POF	(PPC.unPCFGR104.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR104_NFE	(PPC.unPCFGR104.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR104_ODR	(PPC.unPCFGR104.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR104_PDE	(PPC.unPCFGR104.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR104_PUE	(PPC.unPCFGR104.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR104_PIL	(PPC.unPCFGR104.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR104_PIE	(PPC.unPCFGR104.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR104_PID	(PPC.unPCFGR104.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR104_POD	(PPC.unPCFGR104.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR104_POE	(PPC.unPCFGR104.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR105	(PPC.unPCFGR105.u16Register)  /*@rg@*/
#define PPC_PCFGR105_POF	(PPC.unPCFGR105.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR105_NFE	(PPC.unPCFGR105.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR105_ODR	(PPC.unPCFGR105.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR105_PDE	(PPC.unPCFGR105.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR105_PUE	(PPC.unPCFGR105.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR105_PIL	(PPC.unPCFGR105.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR105_PIE	(PPC.unPCFGR105.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR105_PID	(PPC.unPCFGR105.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR105_POD	(PPC.unPCFGR105.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR105_POE	(PPC.unPCFGR105.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR106	(PPC.unPCFGR106.u16Register)  /*@rg@*/
#define PPC_PCFGR106_POF	(PPC.unPCFGR106.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR106_NFE	(PPC.unPCFGR106.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR106_ODR	(PPC.unPCFGR106.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR106_PDE	(PPC.unPCFGR106.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR106_PUE	(PPC.unPCFGR106.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR106_PIL	(PPC.unPCFGR106.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR106_PIE	(PPC.unPCFGR106.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR106_PID	(PPC.unPCFGR106.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR106_POD	(PPC.unPCFGR106.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR106_POE	(PPC.unPCFGR106.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR107	(PPC.unPCFGR107.u16Register)  /*@rg@*/
#define PPC_PCFGR107_POF	(PPC.unPCFGR107.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR107_NFE	(PPC.unPCFGR107.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR107_ODR	(PPC.unPCFGR107.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR107_PDE	(PPC.unPCFGR107.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR107_PUE	(PPC.unPCFGR107.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR107_PIL	(PPC.unPCFGR107.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR107_PIE	(PPC.unPCFGR107.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR107_PID	(PPC.unPCFGR107.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR107_POD	(PPC.unPCFGR107.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR107_POE	(PPC.unPCFGR107.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR108	(PPC.unPCFGR108.u16Register)  /*@rg@*/
#define PPC_PCFGR108_POF	(PPC.unPCFGR108.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR108_NFE	(PPC.unPCFGR108.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR108_ODR	(PPC.unPCFGR108.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR108_PDE	(PPC.unPCFGR108.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR108_PUE	(PPC.unPCFGR108.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR108_PIL	(PPC.unPCFGR108.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR108_PIE	(PPC.unPCFGR108.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR108_PID	(PPC.unPCFGR108.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR108_POD	(PPC.unPCFGR108.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR108_POE	(PPC.unPCFGR108.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR109	(PPC.unPCFGR109.u16Register)  /*@rg@*/
#define PPC_PCFGR109_POF	(PPC.unPCFGR109.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR109_NFE	(PPC.unPCFGR109.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR109_ODR	(PPC.unPCFGR109.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR109_PDE	(PPC.unPCFGR109.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR109_PUE	(PPC.unPCFGR109.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR109_PIL	(PPC.unPCFGR109.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR109_PIE	(PPC.unPCFGR109.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR109_PID	(PPC.unPCFGR109.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR109_POD	(PPC.unPCFGR109.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR109_POE	(PPC.unPCFGR109.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR110	(PPC.unPCFGR110.u16Register)  /*@rg@*/
#define PPC_PCFGR110_POF	(PPC.unPCFGR110.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR110_NFE	(PPC.unPCFGR110.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR110_ODR	(PPC.unPCFGR110.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR110_PDE	(PPC.unPCFGR110.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR110_PUE	(PPC.unPCFGR110.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR110_PIL	(PPC.unPCFGR110.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR110_PIE	(PPC.unPCFGR110.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR110_PID	(PPC.unPCFGR110.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR110_POD	(PPC.unPCFGR110.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR110_POE	(PPC.unPCFGR110.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR111	(PPC.unPCFGR111.u16Register)  /*@rg@*/
#define PPC_PCFGR111_POF	(PPC.unPCFGR111.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR111_NFE	(PPC.unPCFGR111.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR111_ODR	(PPC.unPCFGR111.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR111_PDE	(PPC.unPCFGR111.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR111_PUE	(PPC.unPCFGR111.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR111_PIL	(PPC.unPCFGR111.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR111_PIE	(PPC.unPCFGR111.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR111_PID	(PPC.unPCFGR111.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR111_POD	(PPC.unPCFGR111.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR111_POE	(PPC.unPCFGR111.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR112	(PPC.unPCFGR112.u16Register)  /*@rg@*/
#define PPC_PCFGR112_POF	(PPC.unPCFGR112.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR112_NFE	(PPC.unPCFGR112.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR112_ODR	(PPC.unPCFGR112.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR112_PDE	(PPC.unPCFGR112.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR112_PUE	(PPC.unPCFGR112.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR112_PIL	(PPC.unPCFGR112.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR112_PIE	(PPC.unPCFGR112.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR112_PID	(PPC.unPCFGR112.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR112_POD	(PPC.unPCFGR112.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR112_POE	(PPC.unPCFGR112.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR113	(PPC.unPCFGR113.u16Register)  /*@rg@*/
#define PPC_PCFGR113_POF	(PPC.unPCFGR113.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR113_NFE	(PPC.unPCFGR113.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR113_ODR	(PPC.unPCFGR113.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR113_PDE	(PPC.unPCFGR113.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR113_PUE	(PPC.unPCFGR113.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR113_PIL	(PPC.unPCFGR113.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR113_PIE	(PPC.unPCFGR113.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR113_PID	(PPC.unPCFGR113.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR113_POD	(PPC.unPCFGR113.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR113_POE	(PPC.unPCFGR113.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR114	(PPC.unPCFGR114.u16Register)  /*@rg@*/
#define PPC_PCFGR114_POF	(PPC.unPCFGR114.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR114_NFE	(PPC.unPCFGR114.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR114_ODR	(PPC.unPCFGR114.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR114_PDE	(PPC.unPCFGR114.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR114_PUE	(PPC.unPCFGR114.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR114_PIL	(PPC.unPCFGR114.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR114_PIE	(PPC.unPCFGR114.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR114_PID	(PPC.unPCFGR114.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR114_POD	(PPC.unPCFGR114.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR114_POE	(PPC.unPCFGR114.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR115	(PPC.unPCFGR115.u16Register)  /*@rg@*/
#define PPC_PCFGR115_POF	(PPC.unPCFGR115.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR115_NFE	(PPC.unPCFGR115.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR115_ODR	(PPC.unPCFGR115.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR115_PDE	(PPC.unPCFGR115.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR115_PUE	(PPC.unPCFGR115.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR115_PIL	(PPC.unPCFGR115.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR115_PIE	(PPC.unPCFGR115.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR115_PID	(PPC.unPCFGR115.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR115_POD	(PPC.unPCFGR115.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR115_POE	(PPC.unPCFGR115.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR116	(PPC.unPCFGR116.u16Register)  /*@rg@*/
#define PPC_PCFGR116_POF	(PPC.unPCFGR116.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR116_NFE	(PPC.unPCFGR116.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR116_ODR	(PPC.unPCFGR116.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR116_PDE	(PPC.unPCFGR116.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR116_PUE	(PPC.unPCFGR116.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR116_PIL	(PPC.unPCFGR116.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR116_PIE	(PPC.unPCFGR116.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR116_PID	(PPC.unPCFGR116.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR116_POD	(PPC.unPCFGR116.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR116_POE	(PPC.unPCFGR116.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR117	(PPC.unPCFGR117.u16Register)  /*@rg@*/
#define PPC_PCFGR117_POF	(PPC.unPCFGR117.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR117_NFE	(PPC.unPCFGR117.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR117_ODR	(PPC.unPCFGR117.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR117_PDE	(PPC.unPCFGR117.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR117_PUE	(PPC.unPCFGR117.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR117_PIL	(PPC.unPCFGR117.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR117_PIE	(PPC.unPCFGR117.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR117_PID	(PPC.unPCFGR117.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR117_POD	(PPC.unPCFGR117.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR117_POE	(PPC.unPCFGR117.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR118	(PPC.unPCFGR118.u16Register)  /*@rg@*/
#define PPC_PCFGR118_POF	(PPC.unPCFGR118.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR118_NFE	(PPC.unPCFGR118.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR118_ODR	(PPC.unPCFGR118.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR118_PDE	(PPC.unPCFGR118.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR118_PUE	(PPC.unPCFGR118.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR118_PIL	(PPC.unPCFGR118.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR118_PIE	(PPC.unPCFGR118.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR118_PID	(PPC.unPCFGR118.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR118_POD	(PPC.unPCFGR118.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR118_POE	(PPC.unPCFGR118.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR119	(PPC.unPCFGR119.u16Register)  /*@rg@*/
#define PPC_PCFGR119_POF	(PPC.unPCFGR119.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR119_NFE	(PPC.unPCFGR119.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR119_ODR	(PPC.unPCFGR119.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR119_PDE	(PPC.unPCFGR119.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR119_PUE	(PPC.unPCFGR119.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR119_PIL	(PPC.unPCFGR119.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR119_PIE	(PPC.unPCFGR119.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR119_PID	(PPC.unPCFGR119.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR119_POD	(PPC.unPCFGR119.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR119_POE	(PPC.unPCFGR119.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR120	(PPC.unPCFGR120.u16Register)  /*@rg@*/
#define PPC_PCFGR120_POF	(PPC.unPCFGR120.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR120_NFE	(PPC.unPCFGR120.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR120_ODR	(PPC.unPCFGR120.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR120_PDE	(PPC.unPCFGR120.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR120_PUE	(PPC.unPCFGR120.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR120_PIL	(PPC.unPCFGR120.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR120_PIE	(PPC.unPCFGR120.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR120_PID	(PPC.unPCFGR120.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR120_POD	(PPC.unPCFGR120.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR120_POE	(PPC.unPCFGR120.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR121	(PPC.unPCFGR121.u16Register)  /*@rg@*/
#define PPC_PCFGR121_POF	(PPC.unPCFGR121.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR121_NFE	(PPC.unPCFGR121.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR121_ODR	(PPC.unPCFGR121.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR121_PDE	(PPC.unPCFGR121.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR121_PUE	(PPC.unPCFGR121.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR121_PIL	(PPC.unPCFGR121.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR121_PIE	(PPC.unPCFGR121.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR121_PID	(PPC.unPCFGR121.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR121_POD	(PPC.unPCFGR121.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR121_POE	(PPC.unPCFGR121.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR122	(PPC.unPCFGR122.u16Register)  /*@rg@*/
#define PPC_PCFGR122_POF	(PPC.unPCFGR122.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR122_NFE	(PPC.unPCFGR122.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR122_ODR	(PPC.unPCFGR122.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR122_PDE	(PPC.unPCFGR122.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR122_PUE	(PPC.unPCFGR122.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR122_PIL	(PPC.unPCFGR122.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR122_PIE	(PPC.unPCFGR122.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR122_PID	(PPC.unPCFGR122.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR122_POD	(PPC.unPCFGR122.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR122_POE	(PPC.unPCFGR122.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR123	(PPC.unPCFGR123.u16Register)  /*@rg@*/
#define PPC_PCFGR123_POF	(PPC.unPCFGR123.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR123_NFE	(PPC.unPCFGR123.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR123_ODR	(PPC.unPCFGR123.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR123_PDE	(PPC.unPCFGR123.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR123_PUE	(PPC.unPCFGR123.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR123_PIL	(PPC.unPCFGR123.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR123_PIE	(PPC.unPCFGR123.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR123_PID	(PPC.unPCFGR123.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR123_POD	(PPC.unPCFGR123.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR123_POE	(PPC.unPCFGR123.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR124	(PPC.unPCFGR124.u16Register)  /*@rg@*/
#define PPC_PCFGR124_POF	(PPC.unPCFGR124.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR124_NFE	(PPC.unPCFGR124.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR124_ODR	(PPC.unPCFGR124.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR124_PDE	(PPC.unPCFGR124.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR124_PUE	(PPC.unPCFGR124.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR124_PIL	(PPC.unPCFGR124.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR124_PIE	(PPC.unPCFGR124.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR124_PID	(PPC.unPCFGR124.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR124_POD	(PPC.unPCFGR124.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR124_POE	(PPC.unPCFGR124.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR125	(PPC.unPCFGR125.u16Register)  /*@rg@*/
#define PPC_PCFGR125_POF	(PPC.unPCFGR125.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR125_NFE	(PPC.unPCFGR125.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR125_ODR	(PPC.unPCFGR125.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR125_PDE	(PPC.unPCFGR125.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR125_PUE	(PPC.unPCFGR125.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR125_PIL	(PPC.unPCFGR125.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR125_PIE	(PPC.unPCFGR125.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR125_PID	(PPC.unPCFGR125.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR125_POD	(PPC.unPCFGR125.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR125_POE	(PPC.unPCFGR125.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR126	(PPC.unPCFGR126.u16Register)  /*@rg@*/
#define PPC_PCFGR126_POF	(PPC.unPCFGR126.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR126_NFE	(PPC.unPCFGR126.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR126_ODR	(PPC.unPCFGR126.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR126_PDE	(PPC.unPCFGR126.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR126_PUE	(PPC.unPCFGR126.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR126_PIL	(PPC.unPCFGR126.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR126_PIE	(PPC.unPCFGR126.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR126_PID	(PPC.unPCFGR126.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR126_POD	(PPC.unPCFGR126.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR126_POE	(PPC.unPCFGR126.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR127	(PPC.unPCFGR127.u16Register)  /*@rg@*/
#define PPC_PCFGR127_POF	(PPC.unPCFGR127.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR127_NFE	(PPC.unPCFGR127.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR127_ODR	(PPC.unPCFGR127.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR127_PDE	(PPC.unPCFGR127.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR127_PUE	(PPC.unPCFGR127.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR127_PIL	(PPC.unPCFGR127.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR127_PIE	(PPC.unPCFGR127.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR127_PID	(PPC.unPCFGR127.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR127_POD	(PPC.unPCFGR127.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR127_POE	(PPC.unPCFGR127.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR128	(PPC.unPCFGR128.u16Register)  /*@rg@*/
#define PPC_PCFGR128_POF	(PPC.unPCFGR128.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR128_NFE	(PPC.unPCFGR128.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR128_ODR	(PPC.unPCFGR128.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR128_PDE	(PPC.unPCFGR128.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR128_PUE	(PPC.unPCFGR128.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR128_PIL	(PPC.unPCFGR128.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR128_PIE	(PPC.unPCFGR128.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR128_PID	(PPC.unPCFGR128.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR128_POD	(PPC.unPCFGR128.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR128_POE	(PPC.unPCFGR128.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR129	(PPC.unPCFGR129.u16Register)  /*@rg@*/
#define PPC_PCFGR129_POF	(PPC.unPCFGR129.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR129_NFE	(PPC.unPCFGR129.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR129_ODR	(PPC.unPCFGR129.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR129_PDE	(PPC.unPCFGR129.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR129_PUE	(PPC.unPCFGR129.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR129_PIL	(PPC.unPCFGR129.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR129_PIE	(PPC.unPCFGR129.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR129_PID	(PPC.unPCFGR129.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR129_POD	(PPC.unPCFGR129.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR129_POE	(PPC.unPCFGR129.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR130	(PPC.unPCFGR130.u16Register)  /*@rg@*/
#define PPC_PCFGR130_POF	(PPC.unPCFGR130.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR130_NFE	(PPC.unPCFGR130.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR130_ODR	(PPC.unPCFGR130.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR130_PDE	(PPC.unPCFGR130.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR130_PUE	(PPC.unPCFGR130.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR130_PIL	(PPC.unPCFGR130.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR130_PIE	(PPC.unPCFGR130.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR130_PID	(PPC.unPCFGR130.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR130_POD	(PPC.unPCFGR130.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR130_POE	(PPC.unPCFGR130.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR131	(PPC.unPCFGR131.u16Register)  /*@rg@*/
#define PPC_PCFGR131_POF	(PPC.unPCFGR131.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR131_NFE	(PPC.unPCFGR131.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR131_ODR	(PPC.unPCFGR131.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR131_PDE	(PPC.unPCFGR131.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR131_PUE	(PPC.unPCFGR131.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR131_PIL	(PPC.unPCFGR131.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR131_PIE	(PPC.unPCFGR131.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR131_PID	(PPC.unPCFGR131.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR131_POD	(PPC.unPCFGR131.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR131_POE	(PPC.unPCFGR131.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR200	(PPC.unPCFGR200.u16Register)  /*@rg@*/
#define PPC_PCFGR200_POF	(PPC.unPCFGR200.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR200_NFE	(PPC.unPCFGR200.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR200_ODR	(PPC.unPCFGR200.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR200_PDE	(PPC.unPCFGR200.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR200_PUE	(PPC.unPCFGR200.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR200_PIL	(PPC.unPCFGR200.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR200_PIE	(PPC.unPCFGR200.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR200_PID	(PPC.unPCFGR200.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR200_POD	(PPC.unPCFGR200.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR200_POE	(PPC.unPCFGR200.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR201	(PPC.unPCFGR201.u16Register)  /*@rg@*/
#define PPC_PCFGR201_POF	(PPC.unPCFGR201.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR201_NFE	(PPC.unPCFGR201.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR201_ODR	(PPC.unPCFGR201.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR201_PDE	(PPC.unPCFGR201.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR201_PUE	(PPC.unPCFGR201.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR201_PIL	(PPC.unPCFGR201.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR201_PIE	(PPC.unPCFGR201.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR201_PID	(PPC.unPCFGR201.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR201_POD	(PPC.unPCFGR201.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR201_POE	(PPC.unPCFGR201.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR202	(PPC.unPCFGR202.u16Register)  /*@rg@*/
#define PPC_PCFGR202_POF	(PPC.unPCFGR202.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR202_NFE	(PPC.unPCFGR202.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR202_ODR	(PPC.unPCFGR202.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR202_PDE	(PPC.unPCFGR202.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR202_PUE	(PPC.unPCFGR202.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR202_PIL	(PPC.unPCFGR202.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR202_PIE	(PPC.unPCFGR202.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR202_PID	(PPC.unPCFGR202.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR202_POD	(PPC.unPCFGR202.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR202_POE	(PPC.unPCFGR202.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR203	(PPC.unPCFGR203.u16Register)  /*@rg@*/
#define PPC_PCFGR203_POF	(PPC.unPCFGR203.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR203_NFE	(PPC.unPCFGR203.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR203_ODR	(PPC.unPCFGR203.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR203_PDE	(PPC.unPCFGR203.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR203_PUE	(PPC.unPCFGR203.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR203_PIL	(PPC.unPCFGR203.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR203_PIE	(PPC.unPCFGR203.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR203_PID	(PPC.unPCFGR203.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR203_POD	(PPC.unPCFGR203.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR203_POE	(PPC.unPCFGR203.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR204	(PPC.unPCFGR204.u16Register)  /*@rg@*/
#define PPC_PCFGR204_POF	(PPC.unPCFGR204.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR204_NFE	(PPC.unPCFGR204.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR204_ODR	(PPC.unPCFGR204.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR204_PDE	(PPC.unPCFGR204.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR204_PUE	(PPC.unPCFGR204.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR204_PIL	(PPC.unPCFGR204.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR204_PIE	(PPC.unPCFGR204.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR204_PID	(PPC.unPCFGR204.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR204_POD	(PPC.unPCFGR204.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR204_POE	(PPC.unPCFGR204.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR205	(PPC.unPCFGR205.u16Register)  /*@rg@*/
#define PPC_PCFGR205_POF	(PPC.unPCFGR205.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR205_NFE	(PPC.unPCFGR205.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR205_ODR	(PPC.unPCFGR205.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR205_PDE	(PPC.unPCFGR205.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR205_PUE	(PPC.unPCFGR205.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR205_PIL	(PPC.unPCFGR205.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR205_PIE	(PPC.unPCFGR205.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR205_PID	(PPC.unPCFGR205.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR205_POD	(PPC.unPCFGR205.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR205_POE	(PPC.unPCFGR205.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR206	(PPC.unPCFGR206.u16Register)  /*@rg@*/
#define PPC_PCFGR206_POF	(PPC.unPCFGR206.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR206_NFE	(PPC.unPCFGR206.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR206_ODR	(PPC.unPCFGR206.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR206_PDE	(PPC.unPCFGR206.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR206_PUE	(PPC.unPCFGR206.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR206_PIL	(PPC.unPCFGR206.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR206_PIE	(PPC.unPCFGR206.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR206_PID	(PPC.unPCFGR206.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR206_POD	(PPC.unPCFGR206.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR206_POE	(PPC.unPCFGR206.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR207	(PPC.unPCFGR207.u16Register)  /*@rg@*/
#define PPC_PCFGR207_POF	(PPC.unPCFGR207.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR207_NFE	(PPC.unPCFGR207.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR207_ODR	(PPC.unPCFGR207.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR207_PDE	(PPC.unPCFGR207.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR207_PUE	(PPC.unPCFGR207.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR207_PIL	(PPC.unPCFGR207.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR207_PIE	(PPC.unPCFGR207.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR207_PID	(PPC.unPCFGR207.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR207_POD	(PPC.unPCFGR207.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR207_POE	(PPC.unPCFGR207.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR208	(PPC.unPCFGR208.u16Register)  /*@rg@*/
#define PPC_PCFGR208_POF	(PPC.unPCFGR208.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR208_NFE	(PPC.unPCFGR208.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR208_ODR	(PPC.unPCFGR208.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR208_PDE	(PPC.unPCFGR208.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR208_PUE	(PPC.unPCFGR208.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR208_PIL	(PPC.unPCFGR208.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR208_PIE	(PPC.unPCFGR208.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR208_PID	(PPC.unPCFGR208.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR208_POD	(PPC.unPCFGR208.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR208_POE	(PPC.unPCFGR208.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR209	(PPC.unPCFGR209.u16Register)  /*@rg@*/
#define PPC_PCFGR209_POF	(PPC.unPCFGR209.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR209_NFE	(PPC.unPCFGR209.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR209_ODR	(PPC.unPCFGR209.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR209_PDE	(PPC.unPCFGR209.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR209_PUE	(PPC.unPCFGR209.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR209_PIL	(PPC.unPCFGR209.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR209_PIE	(PPC.unPCFGR209.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR209_PID	(PPC.unPCFGR209.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR209_POD	(PPC.unPCFGR209.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR209_POE	(PPC.unPCFGR209.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR210	(PPC.unPCFGR210.u16Register)  /*@rg@*/
#define PPC_PCFGR210_POF	(PPC.unPCFGR210.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR210_NFE	(PPC.unPCFGR210.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR210_ODR	(PPC.unPCFGR210.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR210_PDE	(PPC.unPCFGR210.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR210_PUE	(PPC.unPCFGR210.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR210_PIL	(PPC.unPCFGR210.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR210_PIE	(PPC.unPCFGR210.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR210_PID	(PPC.unPCFGR210.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR210_POD	(PPC.unPCFGR210.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR210_POE	(PPC.unPCFGR210.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR211	(PPC.unPCFGR211.u16Register)  /*@rg@*/
#define PPC_PCFGR211_POF	(PPC.unPCFGR211.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR211_NFE	(PPC.unPCFGR211.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR211_ODR	(PPC.unPCFGR211.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR211_PDE	(PPC.unPCFGR211.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR211_PUE	(PPC.unPCFGR211.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR211_PIL	(PPC.unPCFGR211.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR211_PIE	(PPC.unPCFGR211.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR211_PID	(PPC.unPCFGR211.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR211_POD	(PPC.unPCFGR211.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR211_POE	(PPC.unPCFGR211.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR212	(PPC.unPCFGR212.u16Register)  /*@rg@*/
#define PPC_PCFGR212_POF	(PPC.unPCFGR212.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR212_NFE	(PPC.unPCFGR212.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR212_ODR	(PPC.unPCFGR212.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR212_PDE	(PPC.unPCFGR212.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR212_PUE	(PPC.unPCFGR212.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR212_PIL	(PPC.unPCFGR212.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR212_PIE	(PPC.unPCFGR212.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR212_PID	(PPC.unPCFGR212.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR212_POD	(PPC.unPCFGR212.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR212_POE	(PPC.unPCFGR212.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR213	(PPC.unPCFGR213.u16Register)  /*@rg@*/
#define PPC_PCFGR213_POF	(PPC.unPCFGR213.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR213_NFE	(PPC.unPCFGR213.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR213_ODR	(PPC.unPCFGR213.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR213_PDE	(PPC.unPCFGR213.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR213_PUE	(PPC.unPCFGR213.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR213_PIL	(PPC.unPCFGR213.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR213_PIE	(PPC.unPCFGR213.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR213_PID	(PPC.unPCFGR213.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR213_POD	(PPC.unPCFGR213.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR213_POE	(PPC.unPCFGR213.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR214	(PPC.unPCFGR214.u16Register)  /*@rg@*/
#define PPC_PCFGR214_POF	(PPC.unPCFGR214.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR214_NFE	(PPC.unPCFGR214.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR214_ODR	(PPC.unPCFGR214.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR214_PDE	(PPC.unPCFGR214.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR214_PUE	(PPC.unPCFGR214.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR214_PIL	(PPC.unPCFGR214.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR214_PIE	(PPC.unPCFGR214.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR214_PID	(PPC.unPCFGR214.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR214_POD	(PPC.unPCFGR214.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR214_POE	(PPC.unPCFGR214.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR215	(PPC.unPCFGR215.u16Register)  /*@rg@*/
#define PPC_PCFGR215_POF	(PPC.unPCFGR215.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR215_NFE	(PPC.unPCFGR215.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR215_ODR	(PPC.unPCFGR215.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR215_PDE	(PPC.unPCFGR215.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR215_PUE	(PPC.unPCFGR215.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR215_PIL	(PPC.unPCFGR215.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR215_PIE	(PPC.unPCFGR215.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR215_PID	(PPC.unPCFGR215.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR215_POD	(PPC.unPCFGR215.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR215_POE	(PPC.unPCFGR215.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR216	(PPC.unPCFGR216.u16Register)  /*@rg@*/
#define PPC_PCFGR216_POF	(PPC.unPCFGR216.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR216_NFE	(PPC.unPCFGR216.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR216_ODR	(PPC.unPCFGR216.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR216_PDE	(PPC.unPCFGR216.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR216_PUE	(PPC.unPCFGR216.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR216_PIL	(PPC.unPCFGR216.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR216_PIE	(PPC.unPCFGR216.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR216_PID	(PPC.unPCFGR216.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR216_POD	(PPC.unPCFGR216.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR216_POE	(PPC.unPCFGR216.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR217	(PPC.unPCFGR217.u16Register)  /*@rg@*/
#define PPC_PCFGR217_POF	(PPC.unPCFGR217.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR217_NFE	(PPC.unPCFGR217.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR217_ODR	(PPC.unPCFGR217.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR217_PDE	(PPC.unPCFGR217.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR217_PUE	(PPC.unPCFGR217.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR217_PIL	(PPC.unPCFGR217.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR217_PIE	(PPC.unPCFGR217.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR217_PID	(PPC.unPCFGR217.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR217_POD	(PPC.unPCFGR217.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR217_POE	(PPC.unPCFGR217.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR218	(PPC.unPCFGR218.u16Register)  /*@rg@*/
#define PPC_PCFGR218_POF	(PPC.unPCFGR218.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR218_NFE	(PPC.unPCFGR218.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR218_ODR	(PPC.unPCFGR218.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR218_PDE	(PPC.unPCFGR218.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR218_PUE	(PPC.unPCFGR218.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR218_PIL	(PPC.unPCFGR218.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR218_PIE	(PPC.unPCFGR218.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR218_PID	(PPC.unPCFGR218.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR218_POD	(PPC.unPCFGR218.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR218_POE	(PPC.unPCFGR218.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR219	(PPC.unPCFGR219.u16Register)  /*@rg@*/
#define PPC_PCFGR219_POF	(PPC.unPCFGR219.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR219_NFE	(PPC.unPCFGR219.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR219_ODR	(PPC.unPCFGR219.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR219_PDE	(PPC.unPCFGR219.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR219_PUE	(PPC.unPCFGR219.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR219_PIL	(PPC.unPCFGR219.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR219_PIE	(PPC.unPCFGR219.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR219_PID	(PPC.unPCFGR219.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR219_POD	(PPC.unPCFGR219.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR219_POE	(PPC.unPCFGR219.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR220	(PPC.unPCFGR220.u16Register)  /*@rg@*/
#define PPC_PCFGR220_POF	(PPC.unPCFGR220.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR220_NFE	(PPC.unPCFGR220.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR220_ODR	(PPC.unPCFGR220.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR220_PDE	(PPC.unPCFGR220.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR220_PUE	(PPC.unPCFGR220.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR220_PIL	(PPC.unPCFGR220.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR220_PIE	(PPC.unPCFGR220.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR220_PID	(PPC.unPCFGR220.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR220_POD	(PPC.unPCFGR220.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR220_POE	(PPC.unPCFGR220.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR221	(PPC.unPCFGR221.u16Register)  /*@rg@*/
#define PPC_PCFGR221_POF	(PPC.unPCFGR221.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR221_NFE	(PPC.unPCFGR221.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR221_ODR	(PPC.unPCFGR221.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR221_PDE	(PPC.unPCFGR221.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR221_PUE	(PPC.unPCFGR221.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR221_PIL	(PPC.unPCFGR221.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR221_PIE	(PPC.unPCFGR221.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR221_PID	(PPC.unPCFGR221.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR221_POD	(PPC.unPCFGR221.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR221_POE	(PPC.unPCFGR221.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR222	(PPC.unPCFGR222.u16Register)  /*@rg@*/
#define PPC_PCFGR222_POF	(PPC.unPCFGR222.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR222_NFE	(PPC.unPCFGR222.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR222_ODR	(PPC.unPCFGR222.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR222_PDE	(PPC.unPCFGR222.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR222_PUE	(PPC.unPCFGR222.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR222_PIL	(PPC.unPCFGR222.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR222_PIE	(PPC.unPCFGR222.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR222_PID	(PPC.unPCFGR222.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR222_POD	(PPC.unPCFGR222.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR222_POE	(PPC.unPCFGR222.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR223	(PPC.unPCFGR223.u16Register)  /*@rg@*/
#define PPC_PCFGR223_POF	(PPC.unPCFGR223.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR223_NFE	(PPC.unPCFGR223.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR223_ODR	(PPC.unPCFGR223.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR223_PDE	(PPC.unPCFGR223.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR223_PUE	(PPC.unPCFGR223.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR223_PIL	(PPC.unPCFGR223.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR223_PIE	(PPC.unPCFGR223.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR223_PID	(PPC.unPCFGR223.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR223_POD	(PPC.unPCFGR223.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR223_POE	(PPC.unPCFGR223.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR224	(PPC.unPCFGR224.u16Register)  /*@rg@*/
#define PPC_PCFGR224_POF	(PPC.unPCFGR224.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR224_NFE	(PPC.unPCFGR224.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR224_ODR	(PPC.unPCFGR224.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR224_PDE	(PPC.unPCFGR224.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR224_PUE	(PPC.unPCFGR224.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR224_PIL	(PPC.unPCFGR224.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR224_PIE	(PPC.unPCFGR224.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR224_PID	(PPC.unPCFGR224.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR224_POD	(PPC.unPCFGR224.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR224_POE	(PPC.unPCFGR224.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR225	(PPC.unPCFGR225.u16Register)  /*@rg@*/
#define PPC_PCFGR225_POF	(PPC.unPCFGR225.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR225_NFE	(PPC.unPCFGR225.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR225_ODR	(PPC.unPCFGR225.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR225_PDE	(PPC.unPCFGR225.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR225_PUE	(PPC.unPCFGR225.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR225_PIL	(PPC.unPCFGR225.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR225_PIE	(PPC.unPCFGR225.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR225_PID	(PPC.unPCFGR225.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR225_POD	(PPC.unPCFGR225.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR225_POE	(PPC.unPCFGR225.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR226	(PPC.unPCFGR226.u16Register)  /*@rg@*/
#define PPC_PCFGR226_POF	(PPC.unPCFGR226.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR226_NFE	(PPC.unPCFGR226.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR226_ODR	(PPC.unPCFGR226.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR226_PDE	(PPC.unPCFGR226.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR226_PUE	(PPC.unPCFGR226.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR226_PIL	(PPC.unPCFGR226.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR226_PIE	(PPC.unPCFGR226.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR226_PID	(PPC.unPCFGR226.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR226_POD	(PPC.unPCFGR226.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR226_POE	(PPC.unPCFGR226.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR227	(PPC.unPCFGR227.u16Register)  /*@rg@*/
#define PPC_PCFGR227_POF	(PPC.unPCFGR227.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR227_NFE	(PPC.unPCFGR227.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR227_ODR	(PPC.unPCFGR227.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR227_PDE	(PPC.unPCFGR227.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR227_PUE	(PPC.unPCFGR227.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR227_PIL	(PPC.unPCFGR227.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR227_PIE	(PPC.unPCFGR227.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR227_PID	(PPC.unPCFGR227.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR227_POD	(PPC.unPCFGR227.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR227_POE	(PPC.unPCFGR227.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR228	(PPC.unPCFGR228.u16Register)  /*@rg@*/
#define PPC_PCFGR228_POF	(PPC.unPCFGR228.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR228_NFE	(PPC.unPCFGR228.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR228_ODR	(PPC.unPCFGR228.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR228_PDE	(PPC.unPCFGR228.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR228_PUE	(PPC.unPCFGR228.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR228_PIL	(PPC.unPCFGR228.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR228_PIE	(PPC.unPCFGR228.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR228_PID	(PPC.unPCFGR228.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR228_POD	(PPC.unPCFGR228.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR228_POE	(PPC.unPCFGR228.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR229	(PPC.unPCFGR229.u16Register)  /*@rg@*/
#define PPC_PCFGR229_POF	(PPC.unPCFGR229.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR229_NFE	(PPC.unPCFGR229.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR229_ODR	(PPC.unPCFGR229.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR229_PDE	(PPC.unPCFGR229.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR229_PUE	(PPC.unPCFGR229.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR229_PIL	(PPC.unPCFGR229.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR229_PIE	(PPC.unPCFGR229.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR229_PID	(PPC.unPCFGR229.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR229_POD	(PPC.unPCFGR229.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR229_POE	(PPC.unPCFGR229.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR230	(PPC.unPCFGR230.u16Register)  /*@rg@*/
#define PPC_PCFGR230_POF	(PPC.unPCFGR230.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR230_NFE	(PPC.unPCFGR230.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR230_ODR	(PPC.unPCFGR230.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR230_PDE	(PPC.unPCFGR230.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR230_PUE	(PPC.unPCFGR230.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR230_PIL	(PPC.unPCFGR230.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR230_PIE	(PPC.unPCFGR230.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR230_PID	(PPC.unPCFGR230.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR230_POD	(PPC.unPCFGR230.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR230_POE	(PPC.unPCFGR230.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR231	(PPC.unPCFGR231.u16Register)  /*@rg@*/
#define PPC_PCFGR231_POF	(PPC.unPCFGR231.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR231_NFE	(PPC.unPCFGR231.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR231_ODR	(PPC.unPCFGR231.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR231_PDE	(PPC.unPCFGR231.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR231_PUE	(PPC.unPCFGR231.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR231_PIL	(PPC.unPCFGR231.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR231_PIE	(PPC.unPCFGR231.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR231_PID	(PPC.unPCFGR231.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR231_POD	(PPC.unPCFGR231.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR231_POE	(PPC.unPCFGR231.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR300	(PPC.unPCFGR300.u16Register)  /*@rg@*/
#define PPC_PCFGR300_POF	(PPC.unPCFGR300.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR300_NFE	(PPC.unPCFGR300.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR300_ODR	(PPC.unPCFGR300.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR300_PDE	(PPC.unPCFGR300.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR300_PUE	(PPC.unPCFGR300.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR300_PIL	(PPC.unPCFGR300.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR300_PIE	(PPC.unPCFGR300.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR300_PID	(PPC.unPCFGR300.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR300_POD	(PPC.unPCFGR300.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR300_POE	(PPC.unPCFGR300.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR301	(PPC.unPCFGR301.u16Register)  /*@rg@*/
#define PPC_PCFGR301_POF	(PPC.unPCFGR301.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR301_NFE	(PPC.unPCFGR301.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR301_ODR	(PPC.unPCFGR301.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR301_PDE	(PPC.unPCFGR301.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR301_PUE	(PPC.unPCFGR301.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR301_PIL	(PPC.unPCFGR301.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR301_PIE	(PPC.unPCFGR301.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR301_PID	(PPC.unPCFGR301.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR301_POD	(PPC.unPCFGR301.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR301_POE	(PPC.unPCFGR301.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR302	(PPC.unPCFGR302.u16Register)  /*@rg@*/
#define PPC_PCFGR302_POF	(PPC.unPCFGR302.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR302_NFE	(PPC.unPCFGR302.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR302_ODR	(PPC.unPCFGR302.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR302_PDE	(PPC.unPCFGR302.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR302_PUE	(PPC.unPCFGR302.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR302_PIL	(PPC.unPCFGR302.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR302_PIE	(PPC.unPCFGR302.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR302_PID	(PPC.unPCFGR302.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR302_POD	(PPC.unPCFGR302.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR302_POE	(PPC.unPCFGR302.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR303	(PPC.unPCFGR303.u16Register)  /*@rg@*/
#define PPC_PCFGR303_POF	(PPC.unPCFGR303.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR303_NFE	(PPC.unPCFGR303.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR303_ODR	(PPC.unPCFGR303.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR303_PDE	(PPC.unPCFGR303.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR303_PUE	(PPC.unPCFGR303.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR303_PIL	(PPC.unPCFGR303.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR303_PIE	(PPC.unPCFGR303.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR303_PID	(PPC.unPCFGR303.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR303_POD	(PPC.unPCFGR303.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR303_POE	(PPC.unPCFGR303.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR304	(PPC.unPCFGR304.u16Register)  /*@rg@*/
#define PPC_PCFGR304_POF	(PPC.unPCFGR304.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR304_NFE	(PPC.unPCFGR304.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR304_ODR	(PPC.unPCFGR304.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR304_PDE	(PPC.unPCFGR304.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR304_PUE	(PPC.unPCFGR304.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR304_PIL	(PPC.unPCFGR304.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR304_PIE	(PPC.unPCFGR304.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR304_PID	(PPC.unPCFGR304.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR304_POD	(PPC.unPCFGR304.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR304_POE	(PPC.unPCFGR304.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR305	(PPC.unPCFGR305.u16Register)  /*@rg@*/
#define PPC_PCFGR305_POF	(PPC.unPCFGR305.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR305_NFE	(PPC.unPCFGR305.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR305_ODR	(PPC.unPCFGR305.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR305_PDE	(PPC.unPCFGR305.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR305_PUE	(PPC.unPCFGR305.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR305_PIL	(PPC.unPCFGR305.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR305_PIE	(PPC.unPCFGR305.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR305_PID	(PPC.unPCFGR305.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR305_POD	(PPC.unPCFGR305.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR305_POE	(PPC.unPCFGR305.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR306	(PPC.unPCFGR306.u16Register)  /*@rg@*/
#define PPC_PCFGR306_POF	(PPC.unPCFGR306.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR306_NFE	(PPC.unPCFGR306.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR306_ODR	(PPC.unPCFGR306.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR306_PDE	(PPC.unPCFGR306.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR306_PUE	(PPC.unPCFGR306.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR306_PIL	(PPC.unPCFGR306.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR306_PIE	(PPC.unPCFGR306.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR306_PID	(PPC.unPCFGR306.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR306_POD	(PPC.unPCFGR306.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR306_POE	(PPC.unPCFGR306.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR307	(PPC.unPCFGR307.u16Register)  /*@rg@*/
#define PPC_PCFGR307_POF	(PPC.unPCFGR307.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR307_NFE	(PPC.unPCFGR307.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR307_ODR	(PPC.unPCFGR307.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR307_PDE	(PPC.unPCFGR307.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR307_PUE	(PPC.unPCFGR307.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR307_PIL	(PPC.unPCFGR307.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR307_PIE	(PPC.unPCFGR307.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR307_PID	(PPC.unPCFGR307.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR307_POD	(PPC.unPCFGR307.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR307_POE	(PPC.unPCFGR307.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR308	(PPC.unPCFGR308.u16Register)  /*@rg@*/
#define PPC_PCFGR308_POF	(PPC.unPCFGR308.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR308_NFE	(PPC.unPCFGR308.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR308_ODR	(PPC.unPCFGR308.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR308_PDE	(PPC.unPCFGR308.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR308_PUE	(PPC.unPCFGR308.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR308_PIL	(PPC.unPCFGR308.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR308_PIE	(PPC.unPCFGR308.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR308_PID	(PPC.unPCFGR308.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR308_POD	(PPC.unPCFGR308.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR308_POE	(PPC.unPCFGR308.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR309	(PPC.unPCFGR309.u16Register)  /*@rg@*/
#define PPC_PCFGR309_POF	(PPC.unPCFGR309.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR309_NFE	(PPC.unPCFGR309.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR309_ODR	(PPC.unPCFGR309.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR309_PDE	(PPC.unPCFGR309.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR309_PUE	(PPC.unPCFGR309.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR309_PIL	(PPC.unPCFGR309.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR309_PIE	(PPC.unPCFGR309.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR309_PID	(PPC.unPCFGR309.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR309_POD	(PPC.unPCFGR309.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR309_POE	(PPC.unPCFGR309.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR310	(PPC.unPCFGR310.u16Register)  /*@rg@*/
#define PPC_PCFGR310_POF	(PPC.unPCFGR310.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR310_NFE	(PPC.unPCFGR310.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR310_ODR	(PPC.unPCFGR310.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR310_PDE	(PPC.unPCFGR310.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR310_PUE	(PPC.unPCFGR310.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR310_PIL	(PPC.unPCFGR310.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR310_PIE	(PPC.unPCFGR310.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR310_PID	(PPC.unPCFGR310.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR310_POD	(PPC.unPCFGR310.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR310_POE	(PPC.unPCFGR310.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR311	(PPC.unPCFGR311.u16Register)  /*@rg@*/
#define PPC_PCFGR311_POF	(PPC.unPCFGR311.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR311_NFE	(PPC.unPCFGR311.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR311_ODR	(PPC.unPCFGR311.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR311_PDE	(PPC.unPCFGR311.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR311_PUE	(PPC.unPCFGR311.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR311_PIL	(PPC.unPCFGR311.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR311_PIE	(PPC.unPCFGR311.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR311_PID	(PPC.unPCFGR311.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR311_POD	(PPC.unPCFGR311.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR311_POE	(PPC.unPCFGR311.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR312	(PPC.unPCFGR312.u16Register)  /*@rg@*/
#define PPC_PCFGR312_POF	(PPC.unPCFGR312.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR312_NFE	(PPC.unPCFGR312.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR312_ODR	(PPC.unPCFGR312.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR312_PDE	(PPC.unPCFGR312.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR312_PUE	(PPC.unPCFGR312.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR312_PIL	(PPC.unPCFGR312.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR312_PIE	(PPC.unPCFGR312.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR312_PID	(PPC.unPCFGR312.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR312_POD	(PPC.unPCFGR312.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR312_POE	(PPC.unPCFGR312.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR313	(PPC.unPCFGR313.u16Register)  /*@rg@*/
#define PPC_PCFGR313_POF	(PPC.unPCFGR313.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR313_NFE	(PPC.unPCFGR313.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR313_ODR	(PPC.unPCFGR313.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR313_PDE	(PPC.unPCFGR313.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR313_PUE	(PPC.unPCFGR313.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR313_PIL	(PPC.unPCFGR313.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR313_PIE	(PPC.unPCFGR313.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR313_PID	(PPC.unPCFGR313.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR313_POD	(PPC.unPCFGR313.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR313_POE	(PPC.unPCFGR313.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR314	(PPC.unPCFGR314.u16Register)  /*@rg@*/
#define PPC_PCFGR314_POF	(PPC.unPCFGR314.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR314_NFE	(PPC.unPCFGR314.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR314_ODR	(PPC.unPCFGR314.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR314_PDE	(PPC.unPCFGR314.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR314_PUE	(PPC.unPCFGR314.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR314_PIL	(PPC.unPCFGR314.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR314_PIE	(PPC.unPCFGR314.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR314_PID	(PPC.unPCFGR314.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR314_POD	(PPC.unPCFGR314.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR314_POE	(PPC.unPCFGR314.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR315	(PPC.unPCFGR315.u16Register)  /*@rg@*/
#define PPC_PCFGR315_POF	(PPC.unPCFGR315.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR315_NFE	(PPC.unPCFGR315.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR315_ODR	(PPC.unPCFGR315.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR315_PDE	(PPC.unPCFGR315.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR315_PUE	(PPC.unPCFGR315.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR315_PIL	(PPC.unPCFGR315.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR315_PIE	(PPC.unPCFGR315.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR315_PID	(PPC.unPCFGR315.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR315_POD	(PPC.unPCFGR315.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR315_POE	(PPC.unPCFGR315.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR316	(PPC.unPCFGR316.u16Register)  /*@rg@*/
#define PPC_PCFGR316_POF	(PPC.unPCFGR316.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR316_NFE	(PPC.unPCFGR316.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR316_ODR	(PPC.unPCFGR316.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR316_PDE	(PPC.unPCFGR316.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR316_PUE	(PPC.unPCFGR316.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR316_PIL	(PPC.unPCFGR316.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR316_PIE	(PPC.unPCFGR316.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR316_PID	(PPC.unPCFGR316.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR316_POD	(PPC.unPCFGR316.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR316_POE	(PPC.unPCFGR316.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR317	(PPC.unPCFGR317.u16Register)  /*@rg@*/
#define PPC_PCFGR317_POF	(PPC.unPCFGR317.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR317_NFE	(PPC.unPCFGR317.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR317_ODR	(PPC.unPCFGR317.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR317_PDE	(PPC.unPCFGR317.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR317_PUE	(PPC.unPCFGR317.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR317_PIL	(PPC.unPCFGR317.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR317_PIE	(PPC.unPCFGR317.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR317_PID	(PPC.unPCFGR317.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR317_POD	(PPC.unPCFGR317.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR317_POE	(PPC.unPCFGR317.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR318	(PPC.unPCFGR318.u16Register)  /*@rg@*/
#define PPC_PCFGR318_POF	(PPC.unPCFGR318.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR318_NFE	(PPC.unPCFGR318.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR318_ODR	(PPC.unPCFGR318.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR318_PDE	(PPC.unPCFGR318.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR318_PUE	(PPC.unPCFGR318.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR318_PIL	(PPC.unPCFGR318.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR318_PIE	(PPC.unPCFGR318.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR318_PID	(PPC.unPCFGR318.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR318_POD	(PPC.unPCFGR318.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR318_POE	(PPC.unPCFGR318.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR319	(PPC.unPCFGR319.u16Register)  /*@rg@*/
#define PPC_PCFGR319_POF	(PPC.unPCFGR319.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR319_NFE	(PPC.unPCFGR319.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR319_ODR	(PPC.unPCFGR319.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR319_PDE	(PPC.unPCFGR319.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR319_PUE	(PPC.unPCFGR319.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR319_PIL	(PPC.unPCFGR319.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR319_PIE	(PPC.unPCFGR319.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR319_PID	(PPC.unPCFGR319.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR319_POD	(PPC.unPCFGR319.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR319_POE	(PPC.unPCFGR319.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR320	(PPC.unPCFGR320.u16Register)  /*@rg@*/
#define PPC_PCFGR320_POF	(PPC.unPCFGR320.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR320_NFE	(PPC.unPCFGR320.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR320_ODR	(PPC.unPCFGR320.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR320_PDE	(PPC.unPCFGR320.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR320_PUE	(PPC.unPCFGR320.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR320_PIL	(PPC.unPCFGR320.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR320_PIE	(PPC.unPCFGR320.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR320_PID	(PPC.unPCFGR320.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR320_POD	(PPC.unPCFGR320.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR320_POE	(PPC.unPCFGR320.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR321	(PPC.unPCFGR321.u16Register)  /*@rg@*/
#define PPC_PCFGR321_POF	(PPC.unPCFGR321.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR321_NFE	(PPC.unPCFGR321.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR321_ODR	(PPC.unPCFGR321.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR321_PDE	(PPC.unPCFGR321.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR321_PUE	(PPC.unPCFGR321.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR321_PIL	(PPC.unPCFGR321.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR321_PIE	(PPC.unPCFGR321.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR321_PID	(PPC.unPCFGR321.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR321_POD	(PPC.unPCFGR321.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR321_POE	(PPC.unPCFGR321.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR322	(PPC.unPCFGR322.u16Register)  /*@rg@*/
#define PPC_PCFGR322_POF	(PPC.unPCFGR322.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR322_NFE	(PPC.unPCFGR322.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR322_ODR	(PPC.unPCFGR322.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR322_PDE	(PPC.unPCFGR322.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR322_PUE	(PPC.unPCFGR322.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR322_PIL	(PPC.unPCFGR322.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR322_PIE	(PPC.unPCFGR322.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR322_PID	(PPC.unPCFGR322.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR322_POD	(PPC.unPCFGR322.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR322_POE	(PPC.unPCFGR322.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR323	(PPC.unPCFGR323.u16Register)  /*@rg@*/
#define PPC_PCFGR323_POF	(PPC.unPCFGR323.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR323_NFE	(PPC.unPCFGR323.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR323_ODR	(PPC.unPCFGR323.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR323_PDE	(PPC.unPCFGR323.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR323_PUE	(PPC.unPCFGR323.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR323_PIL	(PPC.unPCFGR323.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR323_PIE	(PPC.unPCFGR323.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR323_PID	(PPC.unPCFGR323.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR323_POD	(PPC.unPCFGR323.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR323_POE	(PPC.unPCFGR323.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR324	(PPC.unPCFGR324.u16Register)  /*@rg@*/
#define PPC_PCFGR324_POF	(PPC.unPCFGR324.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR324_NFE	(PPC.unPCFGR324.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR324_ODR	(PPC.unPCFGR324.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR324_PDE	(PPC.unPCFGR324.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR324_PUE	(PPC.unPCFGR324.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR324_PIL	(PPC.unPCFGR324.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR324_PIE	(PPC.unPCFGR324.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR324_PID	(PPC.unPCFGR324.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR324_POD	(PPC.unPCFGR324.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR324_POE	(PPC.unPCFGR324.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR325	(PPC.unPCFGR325.u16Register)  /*@rg@*/
#define PPC_PCFGR325_POF	(PPC.unPCFGR325.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR325_NFE	(PPC.unPCFGR325.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR325_ODR	(PPC.unPCFGR325.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR325_PDE	(PPC.unPCFGR325.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR325_PUE	(PPC.unPCFGR325.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR325_PIL	(PPC.unPCFGR325.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR325_PIE	(PPC.unPCFGR325.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR325_PID	(PPC.unPCFGR325.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR325_POD	(PPC.unPCFGR325.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR325_POE	(PPC.unPCFGR325.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR326	(PPC.unPCFGR326.u16Register)  /*@rg@*/
#define PPC_PCFGR326_POF	(PPC.unPCFGR326.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR326_NFE	(PPC.unPCFGR326.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR326_ODR	(PPC.unPCFGR326.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR326_PDE	(PPC.unPCFGR326.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR326_PUE	(PPC.unPCFGR326.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR326_PIL	(PPC.unPCFGR326.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR326_PIE	(PPC.unPCFGR326.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR326_PID	(PPC.unPCFGR326.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR326_POD	(PPC.unPCFGR326.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR326_POE	(PPC.unPCFGR326.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR327	(PPC.unPCFGR327.u16Register)  /*@rg@*/
#define PPC_PCFGR327_POF	(PPC.unPCFGR327.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR327_NFE	(PPC.unPCFGR327.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR327_ODR	(PPC.unPCFGR327.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR327_PDE	(PPC.unPCFGR327.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR327_PUE	(PPC.unPCFGR327.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR327_PIL	(PPC.unPCFGR327.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR327_PIE	(PPC.unPCFGR327.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR327_PID	(PPC.unPCFGR327.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR327_POD	(PPC.unPCFGR327.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR327_POE	(PPC.unPCFGR327.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR328	(PPC.unPCFGR328.u16Register)  /*@rg@*/
#define PPC_PCFGR328_POF	(PPC.unPCFGR328.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR328_NFE	(PPC.unPCFGR328.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR328_ODR	(PPC.unPCFGR328.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR328_PDE	(PPC.unPCFGR328.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR328_PUE	(PPC.unPCFGR328.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR328_PIL	(PPC.unPCFGR328.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR328_PIE	(PPC.unPCFGR328.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR328_PID	(PPC.unPCFGR328.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR328_POD	(PPC.unPCFGR328.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR328_POE	(PPC.unPCFGR328.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR329	(PPC.unPCFGR329.u16Register)  /*@rg@*/
#define PPC_PCFGR329_POF	(PPC.unPCFGR329.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR329_NFE	(PPC.unPCFGR329.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR329_ODR	(PPC.unPCFGR329.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR329_PDE	(PPC.unPCFGR329.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR329_PUE	(PPC.unPCFGR329.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR329_PIL	(PPC.unPCFGR329.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR329_PIE	(PPC.unPCFGR329.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR329_PID	(PPC.unPCFGR329.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR329_POD	(PPC.unPCFGR329.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR329_POE	(PPC.unPCFGR329.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR330	(PPC.unPCFGR330.u16Register)  /*@rg@*/
#define PPC_PCFGR330_POF	(PPC.unPCFGR330.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR330_NFE	(PPC.unPCFGR330.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR330_ODR	(PPC.unPCFGR330.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR330_PDE	(PPC.unPCFGR330.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR330_PUE	(PPC.unPCFGR330.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR330_PIL	(PPC.unPCFGR330.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR330_PIE	(PPC.unPCFGR330.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR330_PID	(PPC.unPCFGR330.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR330_POD	(PPC.unPCFGR330.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR330_POE	(PPC.unPCFGR330.stcField.u1POE)  /*@bf@*/

#define PPC_PCFGR331	(PPC.unPCFGR331.u16Register)  /*@rg@*/
#define PPC_PCFGR331_POF	(PPC.unPCFGR331.stcField.u3POF)  /*@bf@*/
#define PPC_PCFGR331_NFE	(PPC.unPCFGR331.stcField.u1NFE)  /*@bf@*/
#define PPC_PCFGR331_ODR	(PPC.unPCFGR331.stcField.u2ODR)  /*@bf@*/
#define PPC_PCFGR331_PDE	(PPC.unPCFGR331.stcField.u1PDE)  /*@bf@*/
#define PPC_PCFGR331_PUE	(PPC.unPCFGR331.stcField.u1PUE)  /*@bf@*/
#define PPC_PCFGR331_PIL	(PPC.unPCFGR331.stcField.u2PIL)  /*@bf@*/
#define PPC_PCFGR331_PIE	(PPC.unPCFGR331.stcField.u1PIE)  /*@bf@*/
#define PPC_PCFGR331_PID	(PPC.unPCFGR331.stcField.u1PID)  /*@bf@*/
#define PPC_PCFGR331_POD	(PPC.unPCFGR331.stcField.u1POD)  /*@bf@*/
#define PPC_PCFGR331_POE	(PPC.unPCFGR331.stcField.u1POE)  /*@bf@*/

typedef struct stc_ppc_pcfgrn_field{
    uint_io16_t		u3POF:3;
    uint_io16_t		:2;
    uint_io16_t		u1NFE:1;
    uint_io16_t		u2ODR:2;
    uint_io16_t		u1PDE:1;
    uint_io16_t		u1PUE:1;
    uint_io16_t		u2PIL:2;
    uint_io16_t		u1PIE:1;
    uint_io16_t		u1PID:1;
    uint_io16_t		u1POD:1;
    uint_io16_t		u1POE:1;
}stc_ppc_pcfgrn_field_t;

typedef union un_ppc_pcfgrn{
    uint_io16_t		u16Register;
    stc_ppc_pcfgrn_field_t		stcField;
    uint_io8_t		au8Byte[2];
}un_ppc_pcfgrn_t;

/* KEYCDR */
#define PPC_KEYCDR	(PPC.unKEYCDR.u32Register)  /*@rg@*/
#define PPC_KEYCDR_RADR	(PPC.unKEYCDR.stcField.u15RADR)  /*@bf@*/
#define PPC_KEYCDR_SIZE	(PPC.unKEYCDR.stcField.u2SIZE)  /*@bf@*/
#define PPC_KEYCDR_KEY	(PPC.unKEYCDR.stcField.u2KEY)  /*@bf@*/

typedef struct stc_ppc_keycdr_field{
    uint_io32_t		u15RADR:15;
    uint_io32_t		:13;
    uint_io32_t		u2SIZE:2;
    uint_io32_t		u2KEY:2;
}stc_ppc_keycdr_field_t;

typedef union un_ppc_keycdr{
    uint_io32_t		u32Register;
    stc_ppc_keycdr_field_t		stcField;
    uint_io8_t		au8Byte[4];
    uint_io16_t		au16Halfword[2];
}un_ppc_keycdr_t;


typedef struct stc_ppc{
    un_ppc_pcfgrn_t	unPCFGR000;	/* 0x00000000 */
    un_ppc_pcfgrn_t	unPCFGR001;	/* 0x00000002 */
    un_ppc_pcfgrn_t	unPCFGR002;	/* 0x00000004 */
    un_ppc_pcfgrn_t	unPCFGR003;	/* 0x00000006 */
    un_ppc_pcfgrn_t	unPCFGR004;	/* 0x00000008 */
    un_ppc_pcfgrn_t	unPCFGR005;	/* 0x0000000A */
    un_ppc_pcfgrn_t	unPCFGR006;	/* 0x0000000C */
    un_ppc_pcfgrn_t	unPCFGR007;	/* 0x0000000E */
    un_ppc_pcfgrn_t	unPCFGR008;	/* 0x00000010 */
    un_ppc_pcfgrn_t	unPCFGR009;	/* 0x00000012 */
    un_ppc_pcfgrn_t	unPCFGR010;	/* 0x00000014 */
    un_ppc_pcfgrn_t	unPCFGR011;	/* 0x00000016 */
    un_ppc_pcfgrn_t	unPCFGR012;	/* 0x00000018 */
    un_ppc_pcfgrn_t	unPCFGR013;	/* 0x0000001A */
    un_ppc_pcfgrn_t	unPCFGR014;	/* 0x0000001C */
    un_ppc_pcfgrn_t	unPCFGR015;	/* 0x0000001E */
    un_ppc_pcfgrn_t	unPCFGR016;	/* 0x00000020 */
    un_ppc_pcfgrn_t	unPCFGR017;	/* 0x00000022 */
    un_ppc_pcfgrn_t	unPCFGR018;	/* 0x00000024 */
    un_ppc_pcfgrn_t	unPCFGR019;	/* 0x00000026 */
    un_ppc_pcfgrn_t	unPCFGR020;	/* 0x00000028 */
    un_ppc_pcfgrn_t	unPCFGR021;	/* 0x0000002A */
    un_ppc_pcfgrn_t	unPCFGR022;	/* 0x0000002C */
    un_ppc_pcfgrn_t	unPCFGR023;	/* 0x0000002E */
    un_ppc_pcfgrn_t	unPCFGR024;	/* 0x00000030 */
    un_ppc_pcfgrn_t	unPCFGR025;	/* 0x00000032 */
    un_ppc_pcfgrn_t	unPCFGR026;	/* 0x00000034 */
    un_ppc_pcfgrn_t	unPCFGR027;	/* 0x00000036 */
    un_ppc_pcfgrn_t	unPCFGR028;	/* 0x00000038 */
    un_ppc_pcfgrn_t	unPCFGR029;	/* 0x0000003A */
    un_ppc_pcfgrn_t	unPCFGR030;	/* 0x0000003C */
    un_ppc_pcfgrn_t	unPCFGR031;	/* 0x0000003E */
    un_ppc_pcfgrn_t	unPCFGR100;	/* 0x00000040 */
    un_ppc_pcfgrn_t	unPCFGR101;	/* 0x00000042 */
    un_ppc_pcfgrn_t	unPCFGR102;	/* 0x00000044 */
    un_ppc_pcfgrn_t	unPCFGR103;	/* 0x00000046 */
    un_ppc_pcfgrn_t	unPCFGR104;	/* 0x00000048 */
    un_ppc_pcfgrn_t	unPCFGR105;	/* 0x0000004A */
    un_ppc_pcfgrn_t	unPCFGR106;	/* 0x0000004C */
    un_ppc_pcfgrn_t	unPCFGR107;	/* 0x0000004E */
    un_ppc_pcfgrn_t	unPCFGR108;	/* 0x00000050 */
    un_ppc_pcfgrn_t	unPCFGR109;	/* 0x00000052 */
    un_ppc_pcfgrn_t	unPCFGR110;	/* 0x00000054 */
    un_ppc_pcfgrn_t	unPCFGR111;	/* 0x00000056 */
    un_ppc_pcfgrn_t	unPCFGR112;	/* 0x00000058 */
    un_ppc_pcfgrn_t	unPCFGR113;	/* 0x0000005A */
    un_ppc_pcfgrn_t	unPCFGR114;	/* 0x0000005C */
    un_ppc_pcfgrn_t	unPCFGR115;	/* 0x0000005E */
    un_ppc_pcfgrn_t	unPCFGR116;	/* 0x00000060 */
    un_ppc_pcfgrn_t	unPCFGR117;	/* 0x00000062 */
    un_ppc_pcfgrn_t	unPCFGR118;	/* 0x00000064 */
    un_ppc_pcfgrn_t	unPCFGR119;	/* 0x00000066 */
    un_ppc_pcfgrn_t	unPCFGR120;	/* 0x00000068 */
    un_ppc_pcfgrn_t	unPCFGR121;	/* 0x0000006A */
    un_ppc_pcfgrn_t	unPCFGR122;	/* 0x0000006C */
    un_ppc_pcfgrn_t	unPCFGR123;	/* 0x0000006E */
    un_ppc_pcfgrn_t	unPCFGR124;	/* 0x00000070 */
    un_ppc_pcfgrn_t	unPCFGR125;	/* 0x00000072 */
    un_ppc_pcfgrn_t	unPCFGR126;	/* 0x00000074 */
    un_ppc_pcfgrn_t	unPCFGR127;	/* 0x00000076 */
    un_ppc_pcfgrn_t	unPCFGR128;	/* 0x00000078 */
    un_ppc_pcfgrn_t	unPCFGR129;	/* 0x0000007A */
    un_ppc_pcfgrn_t	unPCFGR130;	/* 0x0000007C */
    un_ppc_pcfgrn_t	unPCFGR131;	/* 0x0000007E */
    un_ppc_pcfgrn_t	unPCFGR200;	/* 0x00000080 */
    un_ppc_pcfgrn_t	unPCFGR201;	/* 0x00000082 */
    un_ppc_pcfgrn_t	unPCFGR202;	/* 0x00000084 */
    un_ppc_pcfgrn_t	unPCFGR203;	/* 0x00000086 */
    un_ppc_pcfgrn_t	unPCFGR204;	/* 0x00000088 */
    un_ppc_pcfgrn_t	unPCFGR205;	/* 0x0000008A */
    un_ppc_pcfgrn_t	unPCFGR206;	/* 0x0000008C */
    un_ppc_pcfgrn_t	unPCFGR207;	/* 0x0000008E */
    un_ppc_pcfgrn_t	unPCFGR208;	/* 0x00000090 */
    un_ppc_pcfgrn_t	unPCFGR209;	/* 0x00000092 */
    un_ppc_pcfgrn_t	unPCFGR210;	/* 0x00000094 */
    un_ppc_pcfgrn_t	unPCFGR211;	/* 0x00000096 */
    un_ppc_pcfgrn_t	unPCFGR212;	/* 0x00000098 */
    un_ppc_pcfgrn_t	unPCFGR213;	/* 0x0000009A */
    un_ppc_pcfgrn_t	unPCFGR214;	/* 0x0000009C */
    un_ppc_pcfgrn_t	unPCFGR215;	/* 0x0000009E */
    un_ppc_pcfgrn_t	unPCFGR216;	/* 0x000000A0 */
    un_ppc_pcfgrn_t	unPCFGR217;	/* 0x000000A2 */
    un_ppc_pcfgrn_t	unPCFGR218;	/* 0x000000A4 */
    un_ppc_pcfgrn_t	unPCFGR219;	/* 0x000000A6 */
    un_ppc_pcfgrn_t	unPCFGR220;	/* 0x000000A8 */
    un_ppc_pcfgrn_t	unPCFGR221;	/* 0x000000AA */
    un_ppc_pcfgrn_t	unPCFGR222;	/* 0x000000AC */
    un_ppc_pcfgrn_t	unPCFGR223;	/* 0x000000AE */
    un_ppc_pcfgrn_t	unPCFGR224;	/* 0x000000B0 */
    un_ppc_pcfgrn_t	unPCFGR225;	/* 0x000000B2 */
    un_ppc_pcfgrn_t	unPCFGR226;	/* 0x000000B4 */
    un_ppc_pcfgrn_t	unPCFGR227;	/* 0x000000B6 */
    un_ppc_pcfgrn_t	unPCFGR228;	/* 0x000000B8 */
    un_ppc_pcfgrn_t	unPCFGR229;	/* 0x000000BA */
    un_ppc_pcfgrn_t	unPCFGR230;	/* 0x000000BC */
    un_ppc_pcfgrn_t	unPCFGR231;	/* 0x000000BE */
    un_ppc_pcfgrn_t	unPCFGR300;	/* 0x000000C0 */
    un_ppc_pcfgrn_t	unPCFGR301;	/* 0x000000C2 */
    un_ppc_pcfgrn_t	unPCFGR302;	/* 0x000000C4 */
    un_ppc_pcfgrn_t	unPCFGR303;	/* 0x000000C6 */
    un_ppc_pcfgrn_t	unPCFGR304;	/* 0x000000C8 */
    un_ppc_pcfgrn_t	unPCFGR305;	/* 0x000000CA */
    un_ppc_pcfgrn_t	unPCFGR306;	/* 0x000000CC */
    un_ppc_pcfgrn_t	unPCFGR307;	/* 0x000000CE */
    un_ppc_pcfgrn_t	unPCFGR308;	/* 0x000000D0 */
    un_ppc_pcfgrn_t	unPCFGR309;	/* 0x000000D2 */
    un_ppc_pcfgrn_t	unPCFGR310;	/* 0x000000D4 */
    un_ppc_pcfgrn_t	unPCFGR311;	/* 0x000000D6 */
    un_ppc_pcfgrn_t	unPCFGR312;	/* 0x000000D8 */
    un_ppc_pcfgrn_t	unPCFGR313;	/* 0x000000DA */
    un_ppc_pcfgrn_t	unPCFGR314;	/* 0x000000DC */
    un_ppc_pcfgrn_t	unPCFGR315;	/* 0x000000DE */
    un_ppc_pcfgrn_t	unPCFGR316;	/* 0x000000E0 */
    un_ppc_pcfgrn_t	unPCFGR317;	/* 0x000000E2 */
    un_ppc_pcfgrn_t	unPCFGR318;	/* 0x000000E4 */
    un_ppc_pcfgrn_t	unPCFGR319;	/* 0x000000E6 */
    un_ppc_pcfgrn_t	unPCFGR320;	/* 0x000000E8 */
    un_ppc_pcfgrn_t	unPCFGR321;	/* 0x000000EA */
    un_ppc_pcfgrn_t	unPCFGR322;	/* 0x000000EC */
    un_ppc_pcfgrn_t	unPCFGR323;	/* 0x000000EE */
    un_ppc_pcfgrn_t	unPCFGR324;	/* 0x000000F0 */
    un_ppc_pcfgrn_t	unPCFGR325;	/* 0x000000F2 */
    un_ppc_pcfgrn_t	unPCFGR326;	/* 0x000000F4 */
    un_ppc_pcfgrn_t	unPCFGR327;	/* 0x000000F6 */
    un_ppc_pcfgrn_t	unPCFGR328;	/* 0x000000F8 */
    un_ppc_pcfgrn_t	unPCFGR329;	/* 0x000000FA */
    un_ppc_pcfgrn_t	unPCFGR330;	/* 0x000000FC */
    un_ppc_pcfgrn_t	unPCFGR331;	/* 0x000000FE */
    uint_io8_t	au8Reserved0[768];	/* 0x00000100 */
    un_ppc_keycdr_t	unKEYCDR;	/* 0x00000400 */
    uint_io8_t	au8Reserved1[31740];	/* 0x00000404 */
}stc_ppc_t;

#if defined(__IO_DEFINE) || defined(__IO_EXTERN)
__IO_DECLARATOR stc_ppc_t	stcPPC;
#endif /* __IO_DEFINE */

/* Total size of each unit/channel: 32768(0x8000) bytes */


#endif /* __S6J3360_PPC_H */
