#ifndef __WMH_COMM_H_
#define __WMH_COMM_H_
#include "TYW_stdint.h"

#define NULL_P (void *)0

typedef struct {
    uint8_t ID;                                                                                             //ID;
    uint16_t Peroid;                                                                                        //报文周期，单位ms;
    uint8_t DLC;                                    	                                                    //报文长度;
    uint16_t TimeoutMax;                                                                                    //最大超时时间，单位ms;
    uint8_t RecoverContinueCnts;                                                                            //报文超时后连续收到RecoverContinueCnts条判定报文恢复，报文周期不超过Peroid*1.2，填0或1为收到1条报文即判定报文恢复;
    uint8_t *SignalList;				                                                                    //信号列表数组
    void (*FrameCallBackFunc)(void);           			                                                    //收到报文时会调用该回调函数;
    void (*FrameTimeoutFunc)(void);                                                                         //TimeoutMax超时时会调用FrameTimeoutFunc(0),TimeoutLv[0]超时时调用FrameTimeoutFunc(1),TimeoutLv[1]超时时调用FrameTimeoutFunc(2),TimeoutLv[2]超时时调用FrameTimeoutFunc(3);
    uint8_t (*FrameGetCheckSum)(uint32_t ID, uint8_t DLC, uint8_t ProtocolVersion, uint8_t *data);          //接收报文时调用该函数，返回1表示checksum正确，0表示错误，如果错误，则不会调用FrameAnalysisFunc函数
} WMH_COMM_INIT_FRAME_T;

typedef enum {
    EM_WMH_COMM_RECV_MSG_WI_BOX_0x90 = 0,
    EM_WMH_COMM_RECV_MSG_WI_BOX_0x91,
    EM_WMH_COMM_RECV_MSG_WI_BOX_0x92,
    EM_WMH_COMM_RECV_MSG_TOTAL,
} EM_WMH_COMM_RECV_MSG_T;

typedef enum {
    // EM_WMH_COMM_SEND_MSG_ICM_0x80 = 0,
    EM_WMH_COMM_SEND_MSG_ICM_0x90 = 0,
    EM_WMH_COMM_SEND_MSG_ICM_0x91,
    
    EM_WMH_COMM_SEND_MSG_TOTAL,
} EM_WMH_COMM_SEND_MSG_T;

extern void WMHCommInit(void);
extern void WMHCommService(uint32_t TimerDelta);
extern void WMHCommFramePackedTransmit(EM_WMH_COMM_SEND_MSG_T MsgIdx);
extern uint8_t WMHCommFrameGetRecvTimeoutSt(uint8_t n);

#endif

