#ifndef __WMH_COMM_DATA_H_
#define __WMH_COMM_DATA_H_
#include "TYW_stdint.h"

#define WMH_COMM_PROTOCOL_VERSION       0x2F;

#define COMM_DATA_UNION_WI_BOX_LENGTH_0X90       15
typedef union {
    struct {
        uint8_t ProductModel :6;            //产品型号      
        uint8_t ManufacturerCodingRules :2; //厂家编码规则
        uint8_t DeviceEncoding :8;          //设备编码
        uint8_t SerialNumberL :8;           //流水号

        uint8_t FaultStatus :1;         //故障状态
        uint8_t ConstantSpeedStatus :1; //定速巡航状态
        uint8_t GearPStatus :1;         //P档状态
        uint8_t ReadyStatus :1;         //READY状态
        uint8_t SerialNumberH :4;       //流水号高字节4

        uint8_t EstimateMileage_H :8;   //预估里程
        uint8_t EstimateMileage_L :8;   //预估里程

        uint8_t EnergyConsumption :8;   //能耗系数

        uint8_t Fault8 :1;//电机缺相故障
        uint8_t Fault7 :1;//堵转保护故障
        uint8_t Fault6 :1;//欠压保护故障
        uint8_t Fault5 :1;//转把故障故障
        uint8_t Fault4 :1;//控制器MOS管故障故障
        uint8_t Fault3 :1;//刹车故障故障
        uint8_t Fault2 :1;//电机霍尔故障故障
        uint8_t Fault1 :1;//过压保护故障
        uint8_t Fault16 :1;//电池充电过流保护故障
        uint8_t Fault15 :1;//电池SOC过低故障
        uint8_t Fault14 :1;//电池总压欠压保护故障
        uint8_t Fault13 :1;//电池总压过压保护故障
        uint8_t Fault12 :1;//电池放电MOS故障故障
        uint8_t Fault11 :1;//电池充电MOS故障故障
        uint8_t Fault10 :1;//控制器过热故障
        uint8_t Fault9 :1; //电机过热故障

        uint8_t Reserved3 :3;
        uint8_t Fault21 :1;//电池充电过温保护故障
        uint8_t Fault20 :1;//电池充电低温保护故障
        uint8_t Fault19 :1;//电池放电过温保护故障
        uint8_t Fault18 :1;//电池放电低温保护故障
        uint8_t Fault17 :1;//电池放电过流保护故障

        uint8_t Espeed_H :8;//电机脉冲数
        uint8_t Espeed_L :8;//电机脉冲数

        uint8_t Electricity :8;//电量

        uint8_t Reserved5 :5;
        uint8_t Fault39 :1; //电池放电过流保护故障
        uint8_t GEAR :1;    //1:S档 0:D档
        uint8_t FaultLED :1;//故障指示灯

        uint8_t BurglarStatus :1;  //防盗状态
        uint8_t Reserved4 :4;
        uint8_t CartStatus :1;     //推车状态
        uint8_t SideBraceStatus :1;//边撑状态
        uint8_t EBSStatus :1;      //EBS状态
        
        // uint8_t MessageWaittingToAnswer :1;//信息
        // uint8_t PhoneWaittingToAnswer :1;//电话
        // uint8_t PositFault :1;//定位故障
        // uint8_t MasterControlFault :1;//主控故障
        // uint8_t BtFault :1;//蓝牙故障
        // uint8_t PowerFault :1;//电源故障
        // uint8_t ThreeAxisSensorFault :1;//三轴传感器故障
        // uint8_t OneServiceFault :1;//一线通故障
        // uint8_t NetWorkFault :1;//网络故障
        // uint8_t ACCFault :1;//ACC故障
        // uint8_t Reserved2 :6;
        // uint8_t AntennaFault :1;//天线故障
        // uint8_t RfFault :1;//射频故障

        //uint8_t EstimateMileage_H :8;//预估里程
        //uint8_t EstimateMileage_L :8;//预估里程

    } bits;
    uint8_t Bytes[COMM_DATA_UNION_WI_BOX_LENGTH_0X90];
} COMM_DATA_UNION_WI_BOX_0x90;
extern   COMM_DATA_UNION_WI_BOX_0x90 WMHCommDataWiBox_0x90;

#define COMM_DATA_UNION_WI_BOX_LENGTH_0X91       12
typedef union {
    struct {
        uint8_t Year :8;
        uint8_t Month :8;
        uint8_t Day :8;
        uint8_t Hour :8;
        uint8_t Minute :8;
        uint8_t Second :8;

        uint8_t BtDistanceSt :1;
        uint8_t BtConnection :1;
        uint8_t SignalStrengthOf4G :3;
        uint8_t SignalStrengthOfGps :3;

        uint8_t Reserved1 :6;
        uint8_t MessageWaittingToAnswer :1; //信息
        uint8_t PhoneWaittingToAnswer :1;   //电话

        uint8_t PositFault :1;          //定位故障
        uint8_t MasterControlFault :1;  //主控故障
        uint8_t BtFault :1;     //蓝牙故障
        uint8_t PowerFault :1;  //电源故障
        uint8_t ThreeAxisSensorFault :1;//三轴传感器故障
        uint8_t OneServiceFault :1;     //一线通故障
        uint8_t NetWorkFault :1;        //网络故障
        uint8_t ACCFault :1;    //ACC故障
        
        uint8_t Reserved2 :6;
        uint8_t AntennaFault :1;//天线故障
        uint8_t RfFault :1;     //射频故障

        uint8_t EstimateMileage_H :8;//预估里程
        uint8_t EstimateMileage_L :8;//预估里程

    } bits;
    uint8_t Bytes[COMM_DATA_UNION_WI_BOX_LENGTH_0X91];
} COMM_DATA_UNION_WI_BOX_0x91;
extern   COMM_DATA_UNION_WI_BOX_0x91 WMHCommDataWiBox_0x91;

#define COMM_DATA_UNION_WI_BOX_LENGTH_0X92       5
typedef union {
    struct {
        uint8_t Inquire :8;   //0x00 未查询 0x11查询里程 0x22 查询NFC卡信息
        uint8_t NfcOperate :8;//0x00 无操作    0x11添卡       0x22 删卡
        uint8_t Card_H :8;    //0x00 (暂不响应)      0x11~0xFF(卡1~卡15)
        uint8_t Card_L :8;
        uint8_t Reserved :8;
    } bits;
    uint8_t Bytes[COMM_DATA_UNION_WI_BOX_LENGTH_0X92];
} COMM_DATA_UNION_WI_BOX_0x92;
extern COMM_DATA_UNION_WI_BOX_0x92 WMHCommDataWiBox_0x92;




#define COMM_DATA_UNION_ICM_LENGTH          13
typedef union {
    struct {
        uint8_t Mileage_H :8;
        uint8_t Mileage_M :8;
        uint8_t Mileage_L :8;

        uint8_t CardKind :8; //卡种类 0x01加密卡 0x02未加密卡
        uint8_t CardNum :8;  //卡序号 0x11 0x22 0x33
        uint8_t CardID1 :8;  //卡ID
        uint8_t CardID2 :8;  //卡ID
        uint8_t CardID3 :8;  //卡ID
        uint8_t CardID4 :8;  //卡ID
        uint8_t CardTotal :8;//卡总数

        uint8_t AddCardStatus:8;   //添卡状态0x01进行中 0x02成功 0x03失败 0x04卡已存在
        uint8_t RemoveCardStatus:8;//删卡状态0x01进行中 0x02成功 0x03失败

        uint8_t Reserved :8;

    } bits;
    uint8_t Bytes[COMM_DATA_UNION_ICM_LENGTH];
} COMM_DATA_UNION_ICM;
extern COMM_DATA_UNION_ICM WMHCommDataIcm;

extern uint8_t WMHCommFrameCheckSumFunc(uint32_t ID, uint8_t DLC, uint8_t ProtocolVersion, uint8_t *data);

extern void WMHCommFrameCallBack_WiBox_0x90(void);
extern void WMHCommFrameCallBack_WiBox_0x91(void);
extern void WMHCommFrameCallBack_WiBox_0x92(void);
extern void WMHCommFrameTimeoutFunc_WiBox(void);

extern void WMHCommFrameCallBack_Icm(void);
extern void WMHCommFrameTimeoutFunc_Icm(void);

#endif

