#include "Check_Ctrl.h"
#include "TYW_stdint.h"
#include "RTE_GPIO.h"
#include "UDS_ISO14229_Server.h"
#include "string.h"
#include "Display_Info.h"
#include "Analog_Signals.h"
#include "CAN_Communication_Matrix.h"
#include "COM_CAN.h"
#include "GenDelay.h"
#include "TFT_LCD.h"
uint32_t NO_IPK_EXIST_Status;
uint32_t NO_IPK_EXIST;
//uint32_t NO_IPK_EXIST_Back;
uint32_t NO_IPK_EXIST_TIMER;
const unsigned char gImage_cuo12[] = {24, 24,0X00,0X00,0X00,0X00,0X30,0X70,0XE0,0XC0,0X80,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,0XC0,0X70,0X30,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X83,0XC7,0X66,0X38,0X38,0X7C,0XE6,0XC3,0X81,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X0C,0X0C,0X06,0X03,0X01,0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X03,0X07,0X0E,0X0C,0X00,0X00,0X00,0X00,};
const unsigned char gImage_dui12[] = {24, 24,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X80,0XC0,0XE0,0X40,0X00,0X00,0X00,0X00,0X08,0X18,0X30,0X70,0XC0,0X80,0X00,0X00,0X80,0XC0,0XE0,0X70,0X38,0X1C,0X0E,0X07,0X03,0X01,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X01,0X03,0X07,0X03,0X01,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,0X00,};
uint8_t InterNal_Version [ 128 ];
uint8_t SW_Version [ 128 ];
uint8_t HW_Version [ 128 ];
uint8_t Part_Version [ 128 ];
uint8_t Risk_Evade [ 128 ];
uint8_t Evade_ODO  [ 128 ];
uint8_t Line_IN_St [ 128 ];
uint8_t Res_St [ 128 ];
uint8_t Made_Date [ 128 ];//制造日期
uint8_t SUPPLIER [ 128 ];//供应商代码
uint8_t Voltage_UDS [ 128 ];
uint8_t BCM_2014 [ 128 ];
//uint8_t InterNal_Version [ 128 ];
uint32_t LCD_CHECN_BEGIN;
uint32_t LCD_CHECN_Retry;

uint32_t LINE_IN_CHECK_BEGIN;
uint32_t LINE_IN_CHECK_Retry;

uint32_t TFT_CHECN_BEGIN;
uint32_t TFT_CHECN_Retry;

uint32_t VOICE_BACK_BEGIN;
uint32_t VOICE_BACK_Retry;

uint32_t VOICE_CHECK_BEGIN;
uint32_t VOICE_CHECK_Retry;

uint32_t VOICE_CHECN_BEGIN;
uint32_t VOICE_CHECN_Retry;

uint32_t LINE_ODO_CLEAR_BEGIN;
uint32_t VOICE_ODO_CLEAR_Retry;

uint32_t RES_CHECK_BEGIN;
uint32_t RES_CHECK_Retry;

uint32_t UnLock_Flag = 0;
uint32_t UnLock_Retry;

uint8_t  KEYBUFFER [ 4 ];

uint32_t CAN_Msg_Tx_Enable;


uint32_t MENU_CHECK_STEP;

uint32_t Global_Session = 0;
uint32_t loc_Step;


void Function_Check_Ctrl(uint32_t cmd);

void MENU_CHECK_STEP_ADD(void)
{
    MENU_CHECK_STEP++;

    if(MENU_CHECK_STEP > 17)
    {
        MENU_CHECK_STEP = 0;
    }
    if((guangganflag == 2 || guangganflag == 1 ) && guangganflag != 3)
    {
        MENU_CHECK_STEP = 3;
    }
}
void MENU_CHECK_STEP_SUB(void)
{
    if ( MENU_CHECK_STEP != 0 );
        MENU_CHECK_STEP--;
  
    
}

void MENU_CHECK_Init(void)
{
    MENU_CHECK_STEP = 0;
}



uint8_t Get_DID_High_Byte(uint16_t Input_DID)
{
    uint16_t Res = 0;

    Res = (Input_DID >> 8);

    return  (uint8_t)(Res);
}

uint8_t Get_DID_Low_Byte(uint16_t Input_DID)
{
    uint16_t Res = 0;

    Res = (Input_DID & 0xFF);

    return  (uint8_t)(Res);
}







void HW_CHECK_IPK_EXIST(void)
{

    uint8_t DIAG_BUFER [ 2 ];

    DIAG_BUFER [ 0 ] = 0x3E;
    DIAG_BUFER [ 1 ] = 0x00;
    UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 2);
    
    SET_IPK_NONE( );
}

void SET_IPK_NONE(void)
{
    NO_IPK_EXIST_TIMER = 12;
    NO_IPK_EXIST       = 12345678;
}
void Clear_IPK_NONE(void)   //CAN在线
{
    NO_IPK_EXIST        = 0;
    NO_IPK_EXIST_Status = 0x55667788;
}
uint8_t ClearFlag = 0;
uint8_t ClearFlagBack = 0;

void CHECK_IPK_COUNT(void)
{
    if ( CAN_Msg_Tx_Enable == 1u )
    {
        if ( NO_IPK_EXIST_TIMER != 0 )
        {
            NO_IPK_EXIST_TIMER--;
        }
        else
        {
            if ( NO_IPK_EXIST == 12345678 )
            {
                NO_IPK_EXIST_Status = 0x11223344;
                memset(InterNal_Version, 0xFF, sizeof(InterNal_Version));
                memset(SW_Version, 0xFF, sizeof(SW_Version));
                memset(HW_Version, 0xFF, sizeof(HW_Version));
                memset(Part_Version, 0xFF, sizeof(Part_Version));
                memset(Made_Date, 0xFF, sizeof(Made_Date));
                memset(SUPPLIER, 0xFF, sizeof(SUPPLIER));
                memset(Voltage_UDS, 0xFF, sizeof(Voltage_UDS));
                
                Display_Menu_Type = 0;
                Display_TFT_Clear( );
                Send_Init();                              
                // MENU_CHECK_Init( );
                Global_Session = 0;//掉线时，认为会话模式归零，重连CAN线后，重新将会话模式切到03扩展会话。
            }
            else
            {
                ClearFlag = 0;
            }
        }


    }
}

// 0x11223344 不在线
// 0x55667788 在线

uint8_t Datajudgment(void)
{
    for(int i = 0; i<34; i++)
    {
        if(erweima[i] != uidread[i])
        {
            return 0;
        }
    }
    return 1;
}

uint32_t Get_IPK_Status(void)
{
    return NO_IPK_EXIST_Status;
}
void Diag_Info_Init(void)
{
    NO_IPK_EXIST_Status = 0x11223344;
    CAN_Msg_Tx_Enable   = 1u;

    memset(InterNal_Version , 0xFF, sizeof(InterNal_Version));
    memset(SW_Version , 0xFF, sizeof(SW_Version));
    memset(HW_Version , 0xFF, sizeof(HW_Version));
    memset(Part_Version , 0xFF, sizeof(Part_Version));
    memset(Risk_Evade, 0xFF, sizeof(Risk_Evade));
    memset(Evade_ODO, 0xFF, sizeof(Evade_ODO));
    memset(Res_St, 0xFF, sizeof(Res_St));
    memset(Made_Date , 0xFF, sizeof(Made_Date));
    memset(SUPPLIER , 0xFF, sizeof(SUPPLIER));
    //memset(Voltage_UDS, 0xFF, sizeof(Voltage_UDS));
    
}
uint8_t Type_Clear = 0;
extern uint8_t BCM_FLAG_2014 = 0;

    uint32_t loc_Type = 0;
    uint8_t erweima[64] ;
    uint8_t UUIDbegin;
    uint8_t uuidlock = 1;
    uint16_t UUIDAccumulate;
void Total_Check(void)
{
uint8_t cmperweima[34];
uint8_t yibiaoshuju[34];
    
    loc_Type          = Get_Display_Type( );
    if ( Type_Clear != loc_Type )
    {
        Type_Clear = loc_Type;
        Display_TFT_Clear();
    }

    // POWER_CTRL_KL30_Current = 0u;//静态电流电阻的远仪表端，永远接通总电源。B+~

    BCM_FLAG_2014 = BCM_2014[1] & 0X40 ;
    // loc_Type = 2;
    switch ( loc_Type )
    {
        case 0:
         
            // Buzzer_Init();            
            // Function_Check_Ctrl(1);    //Excel表格发报文。硬线信号  
            //Buzzer_Warning();      
            // TFT_LCD_Draw_Bmp(200,   90+40,  ( uint8_t * )gImage_dui12 ); 

            // for(int i = 0;i<34;i++)
            // {
            //     erweima[i] = barcode_Msg[i];
            // }
            memcpy(erweima,barcode_Msg,32);
            erweima[32] = 0xFF;
            General_Number_Disp(erweima, 3, 90);  
            if(writeflag == 1 || writeflag == 3)
            {
                TFT_LCD_Draw_Bmp(200,   90+40,  ( uint8_t * )gImage_dui12 );  
            }
            else
            {
                TFT_LCD_Draw_Bmp(200,   90+40,  ( uint8_t * )gImage_cuo12 );
            }

            if(uuidlock == 1)
            {
                for(int i = 0; i < 32; i++)
                {
                    UUIDAccumulate += uidread[i];
                }
                if(UUIDAccumulate != 0)
                {
                    UUIDbegin = 1;
                }
            }
            else
            {
                uidread[32] = 0xFF;
                General_Number_Disp(uidread, 3, 180);
            }
            
            if(UUIDbegin == 1)
            {
                if(Datajudgment())
                {
                    UUIDbegin = 0;
                    uuidlock = 0;
                    zhenduanflag = 0;
                }
                uidread[32] = 0xFF;
                General_Number_Disp(uidread, 3, 180);
            }  
            break;

        case 1: 
            // Buzzer_Warning();    
            memcpy(cmperweima,barcode_Msg1,32);
            
            
            //  for(int i =0;i<34;i++)
            // {
            //     cmperweima[i] = barcode_Msg1[i];
            // }
            cmperweima[34] = 0xFF;
            General_Number_Disp(cmperweima, 3, 90);  
            memcpy(yibiaoshuju,get_num_buf,34);
            // for(int i =0;i<34;i++)
            // {
            //     yibiaoshuju[i] = get_num_buf[i];
            // }
            yibiaoshuju[34] = 0xFF;
            General_Number_Disp(yibiaoshuju, 3, 165);  
            // zhenduanflag = 3;
            // comparestart = 1;
            break; 
        case 2: 
            POWER_CTRL_KL30   = 0u;  //B+
            POWER_CTRL_KL15   = 0u;  //KL15
            CAN_Msg_Tx_Enable = 1u;  
            if(MENU_CHECK_STEP == 0)
            {
                Display_Version_Info(1);  
            }
            else
            {
                loc_Type_back = 0;
                
            }
            if((R485_ID4Dh.Sig.ESP322 == 0) && ( R485_ID4Dh.Sig.G0312 == 0))
            {
                MENU_CHECK_STEP = 0;
            }
            Function_Check_Ctrl(1);    //Excel表格发报文。硬线信号  
            Diag_Info_Init( );       
            Display_Init( );            
            // Send_Init();
            // Send_ODO_Init();             
            // Display_Send_ODO(0); 
            //FUEL_UDS__Display(3);
            Buzzer_Warning();
                  
            break;              
            
        case 3:   
            blename[4] = 0xFF;
            // if(recvflag111 == 1)
            // {
            if((blename[0]+blename[1]+blename[2]+blename[3]) != 0)
            {
                General_Number_Disp(blename, 3, 165); 
            }
                
            //      recvflag111 = 0;
            // }
            
            // POWER_CTRL_KL30   = 0u;  //B+
            // POWER_CTRL_KL15   = 0u;  //KL15
            // CAN_Msg_Tx_Enable = 1u;  
            // Diag_Info_Init( );       
            // Display_Init( );  
            // Display_Version_Info(0); 
                        
            // Display_Set_Buff(); 
            // // Function_Check_Ctrl(1);    //Excel表格发报文。硬线信号  
            // //FUEL_UDS__Display(3);
            // Buzzer_Warning();
            
            
            
                 
        //     break;                   
            
        // case 4:
            
                
        //         break;
            
            
                  
            

        default:            
            POWER_CTRL_KL30   = 0u;
            POWER_CTRL_KL15   = 0u;
            CAN_Msg_Tx_Enable = 1u;
            Display_Menu_Type = 0;
            Diag_Info_Init( );       
            Display_Init( );  
            Display_Version_Info(0);             
            Send_Init();
            Send_ODO_Init();
            // Buzzer_Init(); 
              
            break;
    }
}

void Read_IPK_Session_Type(void)//请求仪表发送 软硬件版本号 等数据。
{
    uint8_t         DIAG_BUFER [ 10 ];

    switch ( loc_Step )
    {
        case 0:
            loc_Step = 5;    
            break;

        case 1:
            if ( Global_Session != 3 )
            {
                DIAG_BUFER [ 0 ] = 0x10;
                DIAG_BUFER [ 1 ] = 0x03;
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 2);//让仪表进入 扩展会话 中。
            }
            break;
        case 2:
            //*******************************
            //UnLock_Flag == 0x00   //初始    阶段
            //UnLock_Flag == 0x01   //请求种子阶段
            //UnLock_Flag == 0x02   //得到种子阶段
            //UnLock_Flag == 0x03   //发送密钥阶段
            //UnLock_Flag == 0x55   //解锁成功阶段
            //*******************************
            if ( UnLock_Flag == 0 )
            {
                UnLock_Retry     = 10;
                UnLock_Flag      = 1;//请求种子阶段
                DIAG_BUFER [ 0 ] = 0x27;
                DIAG_BUFER [ 1 ] = 0x03;
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 2);    //
            }
            if ( UnLock_Flag == 0x55 )//解锁成功阶段
            {
                loc_Step = 3;
            }
            break;
        case 3:
            if ( UnLock_Flag == 2 )//得到种子阶段
            {
                UnLock_Flag      = 3;//发送密钥阶段
                UnLock_Retry     = 10;
                DIAG_BUFER [ 0 ] = 0x27;
                DIAG_BUFER [ 1 ] = 0x04;
                DIAG_BUFER [ 2 ] = KEYBUFFER [ 0 ];
                DIAG_BUFER [ 3 ] = KEYBUFFER [ 1 ];
                DIAG_BUFER [ 4 ] = KEYBUFFER [ 2 ];
                DIAG_BUFER [ 5 ] = KEYBUFFER [ 3 ];
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 4);    //
            }
            if ( UnLock_Flag == 0x55 )//解锁成功阶段
            {
                loc_Step = 4;
            }
            break;
        case 4:

            if ( InterNal_Version [ 0 ] == 0xff )
            {

                DIAG_BUFER [ 0 ] = 0x22;
                DIAG_BUFER [ 1 ] = 0xf0;
                DIAG_BUFER [ 2 ] = 0x86;
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    //（工厂版本号）
            }
            loc_Step = 5;
            break;

        case 5:
            if ( SW_Version [ 0 ] == 0xff )
            {

                DIAG_BUFER [ 0 ] = 0x22;
                DIAG_BUFER [ 1 ] = Get_DID_High_Byte(SV_DID);
                DIAG_BUFER [ 2 ] = Get_DID_Low_Byte(SV_DID);
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    //请求 软件版本号
                //Execute_Specify_Step(2);
            }
            loc_Step = 6;
            break;

        case 6:
            if ( HW_Version [ 0 ] == 0xff )
            {
                DIAG_BUFER [ 0 ] = 0x22;
                DIAG_BUFER [ 1 ] = Get_DID_High_Byte(HV_DID);
                DIAG_BUFER [ 2 ] = Get_DID_Low_Byte(HV_DID);
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    //请求 硬件版本号
            }
            loc_Step = 7;
            break;

        case 7:
            if ( Part_Version [ 0 ] == 0xff )
            {
                DIAG_BUFER [ 0 ] = 0x22;
                DIAG_BUFER [ 1 ] = Get_DID_High_Byte(PV_DID);
                DIAG_BUFER [ 2 ] = Get_DID_Low_Byte(PV_DID);
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    //请求 零件号
            }
            loc_Step = 9;
            break;

        case 8:
            if ( Made_Date [ 0 ] == 0xff )
            {
                DIAG_BUFER [ 0 ] = 0x22;
                DIAG_BUFER [ 1 ] = Get_DID_High_Byte(DATE_DID);
                DIAG_BUFER [ 2 ] = Get_DID_Low_Byte(DATE_DID);
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    //请求 生产日期
            }
            loc_Step = 9;
            break;
        case 9:
            if ( SUPPLIER [ 0 ] == 0xff )
            {
                DIAG_BUFER [ 0 ] = 0x22;
                DIAG_BUFER [ 1 ] = Get_DID_High_Byte(CODE_DID);
                DIAG_BUFER [ 2 ] = Get_DID_Low_Byte(CODE_DID);
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    //请求 制造商代码
            }
            loc_Step = 10;
            break;
        case 10:
            //if ( Voltage_UDS [ 0 ] == 0xff )
            //{
                DIAG_BUFER [ 0 ] = 0x22;
                DIAG_BUFER [ 1 ] = 0x20;
                DIAG_BUFER [ 2 ] = 0x14;
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    
            //}
            loc_Step = 11;
            break;
        case 11:
            //if ( Voltage_UDS [ 0 ] == 0xff )
            //{
                DIAG_BUFER [ 0 ] = 0x19;
                DIAG_BUFER [ 1 ] = 0x0A;
                
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 2);    
            //}
            loc_Step = 0;
            break;
        
        

        /*case 8:  //22 5008  读取燃油阻值
            if (RES_CHECK_BEGIN == 0) //发燃油信号时置0，下一步的时候若是0则请求读取燃油阻值，回复62，则置2，为2则刷图
            {
                if ( Res_St [ 0 ] == 0xff )
                {
                    RES_CHECK_BEGIN  = 1U;
                    DIAG_BUFER [ 0 ] = 0x22;
                    DIAG_BUFER [ 1 ] = Get_DID_High_Byte(FUEL_DID);
                    DIAG_BUFER [ 2 ] = Get_DID_Low_Byte(FUEL_DID);
                    UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 3);    //请求 燃油阻值
                }
            }*/
            
            
            #if 0
                DIAG_BUFER [ 0 ] = 0x2e;
                DIAG_BUFER [ 1 ] = 0x20;
                DIAG_BUFER [ 2 ] = 0x00;//07 07 F7 0B 

                DIAG_BUFER [ 3 ] = 0x4b;
                DIAG_BUFER [ 4 ] = 0x47;
                DIAG_BUFER [ 5 ] = 0xf7;
                DIAG_BUFER [ 6 ] = 0x6b;
                UDS_S_Data_Request(DIAG_ID_Tx, DIAG_BUFER, 7);    //
            #endif
            
            //loc_Step = 0;
            break;


    }

    if ( (UnLock_Flag == 1) || (UnLock_Flag == 3) )
    {
        if ( UnLock_Retry != 0 )
        {
            UnLock_Retry--;
        }
        else
        {
            if ( UnLock_Flag == 1 )
            {
                UnLock_Flag = 0u;
            }
            else if ( UnLock_Flag == 3 )
            {
                UnLock_Flag = 2;
            }
        }
    }
}
uint8_t LED_Waring = 0;
uint8_t ABStime = 0;
void Function_Check_Ctrl(uint32_t cmd)
{
    uint8_t         p [ 20 ];
    uint8_t         DIAG_BUFER [ 40 ];
    uint32_t        i;
    uint32_t        j;
    static uint32_t status    = 0;
    static uint32_t MENU_BACK = 0xff;
    static uint8_t  UDS_EunD = 0;

    if ( cmd == 0 )
    {
        ;
    }
    else if(cmd == 1)
    {
        //Voltage_UDS__Display();
        //FUEL_UDS__Display(1);

        if ( MENU_CHECK_STEP >= Get_Total_CheckStep( ) )
        {
            // MENU_CHECK_STEP = 0;
        }

        if ( MENU_BACK != MENU_CHECK_STEP )
        {
            MENU_BACK = MENU_CHECK_STEP;
            
            Execute_Specify_Step(MENU_CHECK_STEP);//Excel表格发报文。

            if (0)//数字需要3位还是2位
            {
                p [ 0 ] = (MENU_CHECK_STEP + 1) / 100;    // 65535
                p [ 1 ] = ((MENU_CHECK_STEP + 1) % 100) / 10;
                p [ 2 ] = (MENU_CHECK_STEP + 1) % 10;    // 65535
                p [ 3 ] = 0xff;
            }
            else
            {
                p [ 0 ] = ((MENU_CHECK_STEP ) % 100) / 10;
                p [ 1 ] = (MENU_CHECK_STEP ) % 10;    // 65535
                p [ 2 ] = 0xff;
            }
            General_Number_Disp(p, 190, 10);//刷图：报文检测步数
        }
        Display_Send_Vspead(MENU_CHECK_STEP);
        switch (MENU_CHECK_STEP)
        {
            case 0:       
            {
                LED3 = 0;   //右转
                LED4 = 0;
                LINE_OUT_NEG_05 = 0;
                LINE_OUT_NEG_06 = 1;
                LINE_jinguang = 0;
                POWER_CTRL_KL30_Current = 0;
                if(Auto_ONOFF == 0)
                {
                    LINE_OUT_NEG_01 = 1;
                    LINE_OUT_NEG_04 = 1; 
                }
                
                LINE_OUT_NEG_02 = 1;
                LINE_OUT_NEG_03 = 1;
                POWER_CTRL_KL30 = 0;   
                name1= (devicename) & 0xFF;
                name2 = (devicename >> 8) & 0xFF;
                break;
            }
            
            case 1:
            {     
                LED3 = 0;
                LED4 = 0;
                LINE_OUT_NEG_05 = 1;
                LINE_OUT_NEG_06 = 0;
                POWER_CTRL_KL30_Current = 0;
                LINE_jinguang = 1;  
                POWER_CTRL_KL30 = 0;        
                break;
            } 
            case 2:
            {      
                LED3 = 0;
                LINE_OUT_NEG_05 = 1;
                LINE_OUT_NEG_06 = 0;
                LINE_jinguang = 0;
                POWER_CTRL_KL30_Current = 0;
                POWER_CTRL_KL30 = 1;
                LED4 = 1;
                if(LINE_FUEL_RES04 == 1 || LINE_FUEL_RES02 == 1)
                {
                    LED3 = 1;
                }
                break;
            }             
            case 3:
            {       
                LED3 = 1;   
                LINE_OUT_NEG_06 = 0;  
                LINE_OUT_NEG_05 = 1;
                LINE_jinguang = 0;
                POWER_CTRL_KL30_Current = 0;  
                LED4 = 0;
                POWER_CTRL_KL30 = 0;   
                break;
            }            
            case 4:
            {       
                 LED3 = 0;   
                LINE_OUT_NEG_06 = 0;  
                LINE_OUT_NEG_05 = 1;
                LINE_jinguang = 0;
                POWER_CTRL_KL30_Current = 0;  
                LED4 = 0;         
                POWER_CTRL_KL30 = 0;                             
                break;
            }
            
            case 5:
            {      
                 LED3 = 0;   
                LINE_OUT_NEG_06 = 0;  
                LINE_OUT_NEG_05 = 1;
                LINE_jinguang = 0;
                POWER_CTRL_KL30_Current = 0;  
                LED4 = 0;         
                POWER_CTRL_KL30 = 0;    
                // queren = 0     ;       
                // ABStime = 0;
                break;
            }
            case 6:
            {       
                 LED3 = 0;   
                LINE_OUT_NEG_06 = 0;  
                LINE_OUT_NEG_05 = 1;
                LINE_jinguang = 0;
                POWER_CTRL_KL30_Current = 0;  
                LED4 = 0;    
                POWER_CTRL_KL30 = 0;  
                if(ABStime < 30)
                {
                    ABStime++;
                }    
                else
                {
                    // queren = 1;  
                    ABStime = 0; 
                }
                             
                break;
            } 
            case 7:
            {    
                LED3 = 0;   
                LINE_OUT_NEG_06 = 0;  
                LINE_OUT_NEG_05 = 0;
                LINE_jinguang = 0;
                POWER_CTRL_KL30_Current = 0;  
                LED4 = 0;         
                POWER_CTRL_KL30 = 0;   
                // queren = 0;       
                // ABStime = 0;                  
                break;
            }
            case 8:
            {     
                 LED3 = 0;   
                LINE_OUT_NEG_06 = 0;  
                LINE_OUT_NEG_05 = 1;
                LINE_jinguang = 0;
                LED4 = 0;      
                POWER_CTRL_KL30_Current = 1;     
                POWER_CTRL_KL30 = 0;                     
                break;
            }
            case 9:
            {  
                   LED3 = 0;   
                LINE_OUT_NEG_06 = 0;  
                LINE_OUT_NEG_05 = 1;
                LINE_jinguang = 0;
                LED4 = 0;      
                POWER_CTRL_KL30_Current = 0;        
                POWER_CTRL_KL30 = 0;   
                break;
            }
            case 10:
            {          
                   LED3 = 1;
                LED4 = 1;
                LINE_OUT_NEG_05 = 0;
                LINE_OUT_NEG_06 = 1;
                LINE_jinguang = 1;
                POWER_CTRL_KL30_Current = 1;   
                POWER_CTRL_KL30 = 1;                        
                break;
            } 
            case 11:
            {
                if(Auto_ONOFF == 0)
                {
                    LINE_OUT_NEG_01 = 1;
                    LINE_OUT_NEG_04 = 1; 
                }
                LINE_OUT_NEG_02 = 1;
                LINE_OUT_NEG_03 = 1;
                
                LED3 = 1;
                LED4 = 1;
                LINE_OUT_NEG_05 = 0;
                LINE_OUT_NEG_06 = 1;
                LINE_jinguang = 1;
                POWER_CTRL_KL30 = 1;   
                POWER_CTRL_KL30_Current = 1;  
                break;
            }         
            case 12:
            {
                POWER_CTRL_KL30_Current = 1;  
                if(Auto_ONOFF == 0)
                {
                    LINE_OUT_NEG_01 = 0;
                }
                LINE_OUT_NEG_02 = 0;
                LINE_OUT_NEG_03 = 1;
                LINE_OUT_NEG_04 = 0; 
                break;
            } 
            case 13:
            {
                POWER_CTRL_KL30_Current = 0;  
                if(Auto_ONOFF == 0)
                {
                    LINE_OUT_NEG_01 = 0;
                }
                LINE_OUT_NEG_02 = 0;
                LINE_OUT_NEG_03 = 1;
                LINE_OUT_NEG_04 = 0; 
                break;
            } 
            case 14:
            {
                LED3 = 0;   //右转
                LED4 = 0;
                LINE_OUT_NEG_05 = 0;
                LINE_OUT_NEG_06 = 1;
                LINE_jinguang = 0;
                POWER_CTRL_KL30_Current = 0;
                if(Auto_ONOFF == 0)
                {
                    LINE_OUT_NEG_01 = 0;
                    LINE_OUT_NEG_04 = 1; 
                }
                
                LINE_OUT_NEG_02 = 1;
                LINE_OUT_NEG_03 = 1;
                
                POWER_CTRL_KL30 = 0;  
                break;
            } 
            case 15:
            {
                LED3 = 0;   //右转
                LED4 = 0;
                LINE_OUT_NEG_05 = 0;
                LINE_OUT_NEG_06 = 1;
                LINE_jinguang = 0;
                POWER_CTRL_KL30_Current = 0;
                if(Auto_ONOFF == 0)
                {
                    LINE_OUT_NEG_01 = 0;
                    LINE_OUT_NEG_04 = 0; 
                }
                
                LINE_OUT_NEG_02 = 0;
                LINE_OUT_NEG_03 = 0;
                
                POWER_CTRL_KL30 = 0;  
                break;
            } 
            case 16:
            {
                LED3 = 0;   //右转
                LED4 = 0;
                LINE_OUT_NEG_05 = 0;
                LINE_OUT_NEG_06 = 1;
                LINE_jinguang = 0;
                POWER_CTRL_KL30_Current = 0;
                if(Auto_ONOFF == 0)
                {
                    LINE_OUT_NEG_01 = 1;
                    LINE_OUT_NEG_04 = 1; 
                }
                
                LINE_OUT_NEG_02 = 1;
                LINE_OUT_NEG_03 = 1;
                
                POWER_CTRL_KL30 = 0;  

                break;


            } 
    //         case 21:
    //         {
    //             LINE_OUT_POS_01 = 1;                
    //             LINE_OUT_NEG_02 = 0;                
    //             LINE_OUT_NEG_01 = 0;
    //             break;
    //         }
    //         case 22:
    //         {
    //             LINE_OUT_POS_01 = 1;                
    //             LINE_OUT_NEG_02 = 1;                
    //             LINE_OUT_NEG_01 = 1;
    //             Display_Menu_Type = 3;
    //             if( (Get_ID_HandBrakeSts() != 1) ||
    //                 (Get_CAN_CH0_ID_10FF4117_Sig_Seatbeltsts() != 1)  ||
    //                 (Get_CAN_CH0_ID_10FF1017_Sig_HighBeamSts() != 1) ||
    //                 (Get_CAN_CH0_ID_10FF1017_Sig_LowBeamSts() != 1) ||  (Get_CAN_CH0_ID_10FF1017_Sig_FrontFogLightSts() != 1) ) 
    //             {
    //                 LED_Waring = 1;                    
    //             }
    //             else 
    //             {
    //                 LED_Waring = 0;
    //             }               
                
                
    //             break;
    //         }
    //         case 23:
    //         {
    //             LINE_OUT_POS_01 = 0;                
    //             LINE_OUT_NEG_02 = 0;                
    //             LINE_OUT_NEG_01 = 0;
    //             break;
    //         }



            default:
                break;
        
        
       
    // }

        }
    }
}


void Get_ODO_Call(void)
{
}
