#ifndef PROTOCOL_LIB_H
#define PROTOCOL_LIB_H

/*
Platform_32Bit
Platform_16Bit
*/
#ifdef Platform_16Bit
    #define Protocol_uint8_t  unsigned char
    #define Protocol_uint16_t unsigned int
    #define Protocol_uint32_t unsigned long
#else
    #define Protocol_uint8_t  unsigned char
    #define Protocol_uint16_t unsigned short
    #define Protocol_uint32_t unsigned int
    #define Protocol_uint64_t unsigned long long
#endif

#ifndef Protocol_NULL
    #define Protocol_NULL ( void * )0u
#endif /* NULL */

/**<0x59 0x44 ID Len DATA0-DATAN SUM 0x4B 0x4A*/
#define DATA_PACKAGE_MIN_LEN   7 /**< 0x59 0x44 + ID + Len + 至少一个数据字节 + SUM + 0x4B 0x4A */
#define DATA_PACKAGE_FIXED_LEN 6 /**< 未计算在长度内的数据 0x59 0x44 + ID + Len + SUM + 0x4B 0x4A */

#define CMD_HEAD1 0x59
#define CMD_HEAD2 0x44
#define CMD_END1  0x4B
#define CMD_END2  0x4A

/**@struct   Protocol_Data_t
 * @brief    解析后的协议数据
 */
typedef struct
{
    Protocol_uint8_t ID;           /**< 报文ID */
    Protocol_uint8_t DataLen;      /**< 有效数据长度 DATA0-DATAN*/
    Protocol_uint8_t Data [ 256 ]; /**< 有效数据内容 DATA0-DATAN*/
} Protocol_Data_t;

typedef Protocol_uint8_t (*UARTOpen)(void);
typedef Protocol_uint32_t (*UARTSend)(const Protocol_uint8_t *pData, Protocol_uint32_t u32Len);
typedef Protocol_uint32_t (*UARTRead)(Protocol_uint8_t *pData, Protocol_uint32_t u32Len);
typedef void (*ProtocolSetData)(const Protocol_Data_t *pData);
typedef void (*ProcParse)(const Protocol_uint8_t *pData, Protocol_uint32_t u32Len);
typedef void (*UARTClose)(void);

/**@struct   Protocol_Func_t
 * @brief    协议解析回调函数
 */
typedef struct
{
    UARTOpen        UARTOpen_Cbk;        /**< 串口打开回调 */
    UARTSend        UARTSend_Cbk;        /**< 串口发送回调 */
    UARTRead        UARTRead_Cbk;        /**< 串口读取回调 */
    UARTClose       UARTClose_Cbk;       /**< 串口关闭回调 */
    ProcParse       ProcParseCbk;        /**< 解析后的数据, 不包含协议头尾和校验，和ProtocolSetData_Cbk二选一 */
    ProtocolSetData ProtocolSetData_Cbk; /**< 不包含 0x59 0x44 + ID + Len + SUM + 0x4B 0x4A，和ProcParse二选一 */
} Protocol_Func_t;

void              Protocol_Init(Protocol_uint8_t *pMemSpace, Protocol_uint32_t MemLen, Protocol_Func_t *pFunc);
void              Protocol_Service(void);
Protocol_uint32_t Protocol_Parse(const Protocol_uint8_t *pData, Protocol_uint32_t len);
Protocol_uint32_t Protocol_Send(const Protocol_uint16_t cmdID, const Protocol_uint8_t *pData, Protocol_uint8_t len);

#endif
