/******************************************************************************/
/* DISCLAIMER                                                                 */
/* This software is supplied by Renesas Electronics Corporation and is only   */
/* intended for use with Renesas products. No other uses are authorized.This  */
/* software is owned by Renesas Electronics Corporation and is protected      */
/* under all applicable laws, including copyright laws.                       */
/* THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES          */
/* REGARDING THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING  */
/* BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR */
/* PURPOSE AND NON-INFRINGEMENT.  ALL SUCH WARRANTIES ARE EXPRESSLY           */
/* DISCLAIMED.                                                                */
/* TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS     */
/* ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE       */
/* LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL      */
/* DAMAGES FOR ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS    */
/* AFFILIATES HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.           */
/* Renesas reserves the right, without notice, to make changes to this        */
/* software and to discontinue the availability of this software.             */
/* By using this software, you agree to the additional terms and conditions   */
/* found by accessing the following link:                                     */
/* http://www.renesas.com/disclaimer                                          */
/*                                                                            */
/* Device     : RH/RH850G3KH/R7F701684                                        */
/* File Name  : dr7f701684.dvf.h                                              */
/* Abstract   : Definition of I/O Register                                    */
/* History    : V1.00  [Device File version]                                  */
/* Options    : -ghs_pragma_io=off -anonymous=on -indent=4 -structure=on -typ */
/*              edef=on -def=on -autosar=on -modulearray=on -const=on -bitfie */
/*              ld=on -bitsfr=on -df=.\dr7f701684.dvf -o=..\output\update\inc */
/*              _ansi\dr7f701684.dvf.h                                        */
/* Date       : 17.07.2017                                                    */
/* Version    : V1.07.00.02  [df2iodef.exe version]                           */
/* This is a typical example.                                                 */
/*                                                                            */
/******************************************************************************/
#ifndef __R7F701684IODEFINE_HEADER__
#define __R7F701684IODEFINE_HEADER__

#ifndef _IODEF_AUTOSAR_TYPEDEF_
#define _IODEF_AUTOSAR_TYPEDEF_
typedef unsigned char   uint8;
typedef unsigned short  uint16;
typedef unsigned long   uint32;
#endif

typedef struct
{
    uint8 bit00:1;
    uint8 bit01:1;
    uint8 bit02:1;
    uint8 bit03:1;
    uint8 bit04:1;
    uint8 bit05:1;
    uint8 bit06:1;
    uint8 bit07:1;
} __bitf_T;

#define  L 0
#define  H 1
#define LL 0
#define LH 1
#define HL 2
#define HH 3

typedef struct 
{                                                          /* Bit Access       */
    uint8  ATAUD0IENH0:1;                                  /* ATAUD0IENH0      */
    uint8  ATAUD0IENH1:1;                                  /* ATAUD0IENH1      */
    uint8  ATAUD0IENH2:1;                                  /* ATAUD0IENH2      */
    uint8  ATAUD0IENH3:1;                                  /* ATAUD0IENH3      */
    uint8  ATAUD0IENH4:1;                                  /* ATAUD0IENH4      */
    uint8  ATAUD0IENH5:1;                                  /* ATAUD0IENH5      */
    uint8  ATAUD0IENH6:1;                                  /* ATAUD0IENH6      */
    uint8  ATAUD0IENH7:1;                                  /* ATAUD0IENH7      */
} __type0;
typedef struct 
{                                                          /* Bit Access       */
    uint8  ATAUD0IENL0:1;                                  /* ATAUD0IENL0      */
    uint8  ATAUD0IENL1:1;                                  /* ATAUD0IENL1      */
    uint8  ATAUD0IENL2:1;                                  /* ATAUD0IENL2      */
    uint8  ATAUD0IENL3:1;                                  /* ATAUD0IENL3      */
    uint8  ATAUD0IENL4:1;                                  /* ATAUD0IENL4      */
    uint8  ATAUD0IENL5:1;                                  /* ATAUD0IENL5      */
    uint8  ATAUD0IENL6:1;                                  /* ATAUD0IENL6      */
    uint8  ATAUD0IENL7:1;                                  /* ATAUD0IENL7      */
} __type1;
typedef struct 
{                                                          /* Bit Access       */
    uint8  ATAUB0IENH0:1;                                  /* ATAUB0IENH0      */
    uint8  ATAUB0IENH1:1;                                  /* ATAUB0IENH1      */
    uint8  ATAUB0IENH2:1;                                  /* ATAUB0IENH2      */
    uint8  ATAUB0IENH3:1;                                  /* ATAUB0IENH3      */
    uint8  ATAUB0IENH4:1;                                  /* ATAUB0IENH4      */
    uint8  ATAUB0IENH5:1;                                  /* ATAUB0IENH5      */
    uint8  ATAUB0IENH6:1;                                  /* ATAUB0IENH6      */
    uint8  ATAUB0IENH7:1;                                  /* ATAUB0IENH7      */
} __type2;
typedef struct 
{                                                          /* Bit Access       */
    uint8  ATAUB0IENL0:1;                                  /* ATAUB0IENL0      */
    uint8  ATAUB0IENL1:1;                                  /* ATAUB0IENL1      */
    uint8  ATAUB0IENL2:1;                                  /* ATAUB0IENL2      */
    uint8  ATAUB0IENL3:1;                                  /* ATAUB0IENL3      */
    uint8  ATAUB0IENL4:1;                                  /* ATAUB0IENL4      */
    uint8  ATAUB0IENL5:1;                                  /* ATAUB0IENL5      */
    uint8  ATAUB0IENL6:1;                                  /* ATAUB0IENL6      */
    uint8  ATAUB0IENL7:1;                                  /* ATAUB0IENL7      */
} __type3;
typedef struct 
{                                                          /* Bit Access       */
    uint8  AENCA0IENL0:1;                                  /* AENCA0IENL0      */
    uint8  AENCA0IENL1:1;                                  /* AENCA0IENL1      */
    uint8  AENCA0IENL2:1;                                  /* AENCA0IENL2      */
    uint8  AENCA0IENL3:1;                                  /* AENCA0IENL3      */
    uint8  AENCA0IENL4:1;                                  /* AENCA0IENL4      */
    uint8  :3;                                             /* Reserved Bits    */
} __type4;
typedef struct 
{                                                          /* Bit Access       */
    uint8  AADCTL0ENL0:1;                                  /* AADCTL0ENL0      */
    uint8  AADCTL0ENL1:1;                                  /* AADCTL0ENL1      */
    uint8  AADCTL0ENL2:1;                                  /* AADCTL0ENL2      */
    uint8  :5;                                             /* Reserved Bits    */
} __type5;
typedef struct 
{                                                          /* Bit Access       */
    uint8  ASENTIENL0:1;                                   /* ASENTIENL0       */
    uint8  ASENTIENL1:1;                                   /* ASENTIENL1       */
    uint8  :6;                                             /* Reserved Bits    */
} __type6;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :7;                                             /* Reserved Bits    */
    uint8  SVSDIS:1;                                       /* SVSDIS           */
} __type7;
typedef struct 
{                                                          /* Bit Access       */
    uint8  SCE:1;                                          /* SCE              */
    uint8  :7;                                             /* Reserved Bits    */
} __type8;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  SLSB:1;                                         /* SLSB             */
    uint8  AMPM:1;                                         /* AMPM             */
    const uint8  CEST:1;                                   /* CEST             */
    uint8  CE:1;                                           /* CE               */
} __type9;
typedef struct 
{                                                          /* Bit Access       */
    uint8  CT0:1;                                          /* CT0              */
    uint8  CT1:1;                                          /* CT1              */
    uint8  CT2:1;                                          /* CT2              */
    uint8  EN1S:1;                                         /* EN1S             */
    uint8  ENALM:1;                                        /* ENALM            */
    uint8  EN1HZ:1;                                        /* EN1HZ            */
    uint8  :2;                                             /* Reserved Bits    */
} __type10;
typedef struct 
{                                                          /* Bit Access       */
    uint8  WAIT:1;                                         /* WAIT             */
    const uint8  WST:1;                                    /* WST              */
    uint8  RSUB:1;                                         /* RSUB             */
    const uint8  RSST:1;                                   /* RSST             */
    const uint8  WSST:1;                                   /* WSST             */
    const uint8  WUST:1;                                   /* WUST             */
    uint8  :2;                                             /* Reserved Bits    */
} __type11;
typedef struct 
{                                                          /* Bit Access       */
    uint8  KRM0:1;                                         /* KRM0             */
    uint8  KRM1:1;                                         /* KRM1             */
    uint8  KRM2:1;                                         /* KRM2             */
    uint8  KRM3:1;                                         /* KRM3             */
    uint8  KRM4:1;                                         /* KRM4             */
    uint8  KRM5:1;                                         /* KRM5             */
    uint8  KRM6:1;                                         /* KRM6             */
    uint8  KRM7:1;                                         /* KRM7             */
} __type12;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH2IC_1:1;                                  /* P0CSIH2IC_1      */
    uint8  P1CSIH2IC_1:1;                                  /* P1CSIH2IC_1      */
    uint8  P2CSIH2IC_1:1;                                  /* P2CSIH2IC_1      */
    uint8  P3CSIH2IC_1:1;                                  /* P3CSIH2IC_1      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH2IC_1:1;                                  /* TBCSIH2IC_1      */
    uint8  MKCSIH2IC_1:1;                                  /* MKCSIH2IC_1      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH2IC_1:1;                                  /* RFCSIH2IC_1      */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH2IC_1:1;                            /* CTCSIH2IC_1      */
} __type13;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH3IC_1:1;                                  /* P0CSIH3IC_1      */
    uint8  P1CSIH3IC_1:1;                                  /* P1CSIH3IC_1      */
    uint8  P2CSIH3IC_1:1;                                  /* P2CSIH3IC_1      */
    uint8  P3CSIH3IC_1:1;                                  /* P3CSIH3IC_1      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH3IC_1:1;                                  /* TBCSIH3IC_1      */
    uint8  MKCSIH3IC_1:1;                                  /* MKCSIH3IC_1      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH3IC_1:1;                                  /* RFCSIH3IC_1      */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH3IC_1:1;                            /* CTCSIH3IC_1      */
} __type14;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH2IR_1:1;                                  /* P0CSIH2IR_1      */
    uint8  P1CSIH2IR_1:1;                                  /* P1CSIH2IR_1      */
    uint8  P2CSIH2IR_1:1;                                  /* P2CSIH2IR_1      */
    uint8  P3CSIH2IR_1:1;                                  /* P3CSIH2IR_1      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH2IR_1:1;                                  /* TBCSIH2IR_1      */
    uint8  MKCSIH2IR_1:1;                                  /* MKCSIH2IR_1      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH2IR_1:1;                                  /* RFCSIH2IR_1      */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH2IR_1:1;                            /* CTCSIH2IR_1      */
} __type15;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH2IRE_1:1;                                 /* P0CSIH2IRE_1     */
    uint8  P1CSIH2IRE_1:1;                                 /* P1CSIH2IRE_1     */
    uint8  P2CSIH2IRE_1:1;                                 /* P2CSIH2IRE_1     */
    uint8  P3CSIH2IRE_1:1;                                 /* P3CSIH2IRE_1     */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH2IRE_1:1;                                 /* TBCSIH2IRE_1     */
    uint8  MKCSIH2IRE_1:1;                                 /* MKCSIH2IRE_1     */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH2IRE_1:1;                                 /* RFCSIH2IRE_1     */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH2IRE_1:1;                           /* CTCSIH2IRE_1     */
} __type16;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH2IJC_1:1;                                 /* P0CSIH2IJC_1     */
    uint8  P1CSIH2IJC_1:1;                                 /* P1CSIH2IJC_1     */
    uint8  P2CSIH2IJC_1:1;                                 /* P2CSIH2IJC_1     */
    uint8  P3CSIH2IJC_1:1;                                 /* P3CSIH2IJC_1     */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH2IJC_1:1;                                 /* TBCSIH2IJC_1     */
    uint8  MKCSIH2IJC_1:1;                                 /* MKCSIH2IJC_1     */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH2IJC_1:1;                                 /* RFCSIH2IJC_1     */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH2IJC_1:1;                           /* CTCSIH2IJC_1     */
} __type17;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH3IR_1:1;                                  /* P0CSIH3IR_1      */
    uint8  P1CSIH3IR_1:1;                                  /* P1CSIH3IR_1      */
    uint8  P2CSIH3IR_1:1;                                  /* P2CSIH3IR_1      */
    uint8  P3CSIH3IR_1:1;                                  /* P3CSIH3IR_1      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH3IR_1:1;                                  /* TBCSIH3IR_1      */
    uint8  MKCSIH3IR_1:1;                                  /* MKCSIH3IR_1      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH3IR_1:1;                                  /* RFCSIH3IR_1      */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH3IR_1:1;                            /* CTCSIH3IR_1      */
} __type18;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH3IRE_1:1;                                 /* P0CSIH3IRE_1     */
    uint8  P1CSIH3IRE_1:1;                                 /* P1CSIH3IRE_1     */
    uint8  P2CSIH3IRE_1:1;                                 /* P2CSIH3IRE_1     */
    uint8  P3CSIH3IRE_1:1;                                 /* P3CSIH3IRE_1     */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH3IRE_1:1;                                 /* TBCSIH3IRE_1     */
    uint8  MKCSIH3IRE_1:1;                                 /* MKCSIH3IRE_1     */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH3IRE_1:1;                                 /* RFCSIH3IRE_1     */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH3IRE_1:1;                           /* CTCSIH3IRE_1     */
} __type19;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH3IJC_1:1;                                 /* P0CSIH3IJC_1     */
    uint8  P1CSIH3IJC_1:1;                                 /* P1CSIH3IJC_1     */
    uint8  P2CSIH3IJC_1:1;                                 /* P2CSIH3IJC_1     */
    uint8  P3CSIH3IJC_1:1;                                 /* P3CSIH3IJC_1     */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH3IJC_1:1;                                 /* TBCSIH3IJC_1     */
    uint8  MKCSIH3IJC_1:1;                                 /* MKCSIH3IJC_1     */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH3IJC_1:1;                                 /* RFCSIH3IJC_1     */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH3IJC_1:1;                           /* CTCSIH3IJC_1     */
} __type20;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH1IC_1:1;                                  /* P0CSIH1IC_1      */
    uint8  P1CSIH1IC_1:1;                                  /* P1CSIH1IC_1      */
    uint8  P2CSIH1IC_1:1;                                  /* P2CSIH1IC_1      */
    uint8  P3CSIH1IC_1:1;                                  /* P3CSIH1IC_1      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH1IC_1:1;                                  /* TBCSIH1IC_1      */
    uint8  MKCSIH1IC_1:1;                                  /* MKCSIH1IC_1      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH1IC_1:1;                                  /* RFCSIH1IC_1      */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH1IC_1:1;                            /* CTCSIH1IC_1      */
} __type21;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH1IR_1:1;                                  /* P0CSIH1IR_1      */
    uint8  P1CSIH1IR_1:1;                                  /* P1CSIH1IR_1      */
    uint8  P2CSIH1IR_1:1;                                  /* P2CSIH1IR_1      */
    uint8  P3CSIH1IR_1:1;                                  /* P3CSIH1IR_1      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH1IR_1:1;                                  /* TBCSIH1IR_1      */
    uint8  MKCSIH1IR_1:1;                                  /* MKCSIH1IR_1      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH1IR_1:1;                                  /* RFCSIH1IR_1      */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH1IR_1:1;                            /* CTCSIH1IR_1      */
} __type22;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0ADCA0I0:1;                                    /* P0ADCA0I0        */
    uint8  P1ADCA0I0:1;                                    /* P1ADCA0I0        */
    uint8  P2ADCA0I0:1;                                    /* P2ADCA0I0        */
    uint8  P3ADCA0I0:1;                                    /* P3ADCA0I0        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBADCA0I0:1;                                    /* TBADCA0I0        */
    uint8  MKADCA0I0:1;                                    /* MKADCA0I0        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFADCA0I0:1;                                    /* RFADCA0I0        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTADCA0I0:1;                              /* CTADCA0I0        */
} __type23;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0ADCA0I1:1;                                    /* P0ADCA0I1        */
    uint8  P1ADCA0I1:1;                                    /* P1ADCA0I1        */
    uint8  P2ADCA0I1:1;                                    /* P2ADCA0I1        */
    uint8  P3ADCA0I1:1;                                    /* P3ADCA0I1        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBADCA0I1:1;                                    /* TBADCA0I1        */
    uint8  MKADCA0I1:1;                                    /* MKADCA0I1        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFADCA0I1:1;                                    /* RFADCA0I1        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTADCA0I1:1;                              /* CTADCA0I1        */
} __type24;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0ADCA0I2:1;                                    /* P0ADCA0I2        */
    uint8  P1ADCA0I2:1;                                    /* P1ADCA0I2        */
    uint8  P2ADCA0I2:1;                                    /* P2ADCA0I2        */
    uint8  P3ADCA0I2:1;                                    /* P3ADCA0I2        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBADCA0I2:1;                                    /* TBADCA0I2        */
    uint8  MKADCA0I2:1;                                    /* MKADCA0I2        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFADCA0I2:1;                                    /* RFADCA0I2        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTADCA0I2:1;                              /* CTADCA0I2        */
} __type25;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0DCUTDI:1;                                     /* P0DCUTDI         */
    uint8  P1DCUTDI:1;                                     /* P1DCUTDI         */
    uint8  P2DCUTDI:1;                                     /* P2DCUTDI         */
    uint8  P3DCUTDI:1;                                     /* P3DCUTDI         */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBDCUTDI:1;                                     /* TBDCUTDI         */
    uint8  MKDCUTDI:1;                                     /* MKDCUTDI         */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFDCUTDI:1;                                     /* RFDCUTDI         */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTDCUTDI:1;                               /* CTDCUTDI         */
} __type26;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RCANGERR0:1;                                  /* P0RCANGERR0      */
    uint8  P1RCANGERR0:1;                                  /* P1RCANGERR0      */
    uint8  P2RCANGERR0:1;                                  /* P2RCANGERR0      */
    uint8  P3RCANGERR0:1;                                  /* P3RCANGERR0      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRCANGERR0:1;                                  /* TBRCANGERR0      */
    uint8  MKRCANGERR0:1;                                  /* MKRCANGERR0      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRCANGERR0:1;                                  /* RFRCANGERR0      */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRCANGERR0:1;                            /* CTRCANGERR0      */
} __type27;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RCANGRECC0:1;                                 /* P0RCANGRECC0     */
    uint8  P1RCANGRECC0:1;                                 /* P1RCANGRECC0     */
    uint8  P2RCANGRECC0:1;                                 /* P2RCANGRECC0     */
    uint8  P3RCANGRECC0:1;                                 /* P3RCANGRECC0     */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRCANGRECC0:1;                                 /* TBRCANGRECC0     */
    uint8  MKRCANGRECC0:1;                                 /* MKRCANGRECC0     */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRCANGRECC0:1;                                 /* RFRCANGRECC0     */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRCANGRECC0:1;                           /* CTRCANGRECC0     */
} __type28;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RCAN0ERR:1;                                   /* P0RCAN0ERR       */
    uint8  P1RCAN0ERR:1;                                   /* P1RCAN0ERR       */
    uint8  P2RCAN0ERR:1;                                   /* P2RCAN0ERR       */
    uint8  P3RCAN0ERR:1;                                   /* P3RCAN0ERR       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRCAN0ERR:1;                                   /* TBRCAN0ERR       */
    uint8  MKRCAN0ERR:1;                                   /* MKRCAN0ERR       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRCAN0ERR:1;                                   /* RFRCAN0ERR       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRCAN0ERR:1;                             /* CTRCAN0ERR       */
} __type29;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RCAN0REC:1;                                   /* P0RCAN0REC       */
    uint8  P1RCAN0REC:1;                                   /* P1RCAN0REC       */
    uint8  P2RCAN0REC:1;                                   /* P2RCAN0REC       */
    uint8  P3RCAN0REC:1;                                   /* P3RCAN0REC       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRCAN0REC:1;                                   /* TBRCAN0REC       */
    uint8  MKRCAN0REC:1;                                   /* MKRCAN0REC       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRCAN0REC:1;                                   /* RFRCAN0REC       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRCAN0REC:1;                             /* CTRCAN0REC       */
} __type30;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RCAN0TRX:1;                                   /* P0RCAN0TRX       */
    uint8  P1RCAN0TRX:1;                                   /* P1RCAN0TRX       */
    uint8  P2RCAN0TRX:1;                                   /* P2RCAN0TRX       */
    uint8  P3RCAN0TRX:1;                                   /* P3RCAN0TRX       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRCAN0TRX:1;                                   /* TBRCAN0TRX       */
    uint8  MKRCAN0TRX:1;                                   /* MKRCAN0TRX       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRCAN0TRX:1;                                   /* RFRCAN0TRX       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRCAN0TRX:1;                             /* CTRCAN0TRX       */
} __type31;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIG0IC:1;                                    /* P0CSIG0IC        */
    uint8  P1CSIG0IC:1;                                    /* P1CSIG0IC        */
    uint8  P2CSIG0IC:1;                                    /* P2CSIG0IC        */
    uint8  P3CSIG0IC:1;                                    /* P3CSIG0IC        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIG0IC:1;                                    /* TBCSIG0IC        */
    uint8  MKCSIG0IC:1;                                    /* MKCSIG0IC        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIG0IC:1;                                    /* RFCSIG0IC        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIG0IC:1;                              /* CTCSIG0IC        */
} __type32;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIG0IR:1;                                    /* P0CSIG0IR        */
    uint8  P1CSIG0IR:1;                                    /* P1CSIG0IR        */
    uint8  P2CSIG0IR:1;                                    /* P2CSIG0IR        */
    uint8  P3CSIG0IR:1;                                    /* P3CSIG0IR        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIG0IR:1;                                    /* TBCSIG0IR        */
    uint8  MKCSIG0IR:1;                                    /* MKCSIG0IR        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIG0IR:1;                                    /* RFCSIG0IR        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIG0IR:1;                              /* CTCSIG0IR        */
} __type33;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH0IC:1;                                    /* P0CSIH0IC        */
    uint8  P1CSIH0IC:1;                                    /* P1CSIH0IC        */
    uint8  P2CSIH0IC:1;                                    /* P2CSIH0IC        */
    uint8  P3CSIH0IC:1;                                    /* P3CSIH0IC        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH0IC:1;                                    /* TBCSIH0IC        */
    uint8  MKCSIH0IC:1;                                    /* MKCSIH0IC        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH0IC:1;                                    /* RFCSIH0IC        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH0IC:1;                              /* CTCSIH0IC        */
} __type34;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH0IR:1;                                    /* P0CSIH0IR        */
    uint8  P1CSIH0IR:1;                                    /* P1CSIH0IR        */
    uint8  P2CSIH0IR:1;                                    /* P2CSIH0IR        */
    uint8  P3CSIH0IR:1;                                    /* P3CSIH0IR        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH0IR:1;                                    /* TBCSIH0IR        */
    uint8  MKCSIH0IR:1;                                    /* MKCSIH0IR        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH0IR:1;                                    /* RFCSIH0IR        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH0IR:1;                              /* CTCSIH0IR        */
} __type35;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH0IRE:1;                                   /* P0CSIH0IRE       */
    uint8  P1CSIH0IRE:1;                                   /* P1CSIH0IRE       */
    uint8  P2CSIH0IRE:1;                                   /* P2CSIH0IRE       */
    uint8  P3CSIH0IRE:1;                                   /* P3CSIH0IRE       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH0IRE:1;                                   /* TBCSIH0IRE       */
    uint8  MKCSIH0IRE:1;                                   /* MKCSIH0IRE       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH0IRE:1;                                   /* RFCSIH0IRE       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH0IRE:1;                             /* CTCSIH0IRE       */
} __type36;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :4;                                             /* Reserved Bits    */
    const uint8  FNRF:1;                                   /* FNRF             */
    uint8  :3;                                             /* Reserved Bits    */
} __type37;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :4;                                             /* Reserved Bits    */
    const uint8  FIRF:1;                                   /* FIRF             */
    uint8  :3;                                             /* Reserved Bits    */
} __type38;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  IMR0EIMK8:1;                                    /* IMR0EIMK8        */
    uint8  IMR0EIMK9:1;                                    /* IMR0EIMK9        */
    uint8  IMR0EIMK10:1;                                   /* IMR0EIMK10       */
    uint8  IMR0EIMK11:1;                                   /* IMR0EIMK11       */
    uint8  IMR0EIMK12:1;                                   /* IMR0EIMK12       */
    uint8  IMR0EIMK13:1;                                   /* IMR0EIMK13       */
    uint8  IMR0EIMK14:1;                                   /* IMR0EIMK14       */
    uint8  IMR0EIMK15:1;                                   /* IMR0EIMK15       */
    uint8  IMR0EIMK16:1;                                   /* IMR0EIMK16       */
    uint8  IMR0EIMK17:1;                                   /* IMR0EIMK17       */
    uint8  IMR0EIMK18:1;                                   /* IMR0EIMK18       */
    uint8  IMR0EIMK19:1;                                   /* IMR0EIMK19       */
    uint8  IMR0EIMK20:1;                                   /* IMR0EIMK20       */
    uint8  IMR0EIMK21:1;                                   /* IMR0EIMK21       */
    uint8  IMR0EIMK22:1;                                   /* IMR0EIMK22       */
    uint8  IMR0EIMK23:1;                                   /* IMR0EIMK23       */
    uint8  IMR0EIMK24:1;                                   /* IMR0EIMK24       */
    uint8  IMR0EIMK25:1;                                   /* IMR0EIMK25       */
    uint8  IMR0EIMK26:1;                                   /* IMR0EIMK26       */
    uint8  IMR0EIMK27:1;                                   /* IMR0EIMK27       */
    uint8  IMR0EIMK28:1;                                   /* IMR0EIMK28       */
    uint8  IMR0EIMK29:1;                                   /* IMR0EIMK29       */
    uint8  IMR0EIMK30:1;                                   /* IMR0EIMK30       */
    uint8  IMR0EIMK31:1;                                   /* IMR0EIMK31       */
} __type39;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0ADCA0I2_2:1;                                  /* P0ADCA0I2_2      */
    uint8  P1ADCA0I2_2:1;                                  /* P1ADCA0I2_2      */
    uint8  P2ADCA0I2_2:1;                                  /* P2ADCA0I2_2      */
    uint8  P3ADCA0I2_2:1;                                  /* P3ADCA0I2_2      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBADCA0I2_2:1;                                  /* TBADCA0I2_2      */
    uint8  MKADCA0I2_2:1;                                  /* MKADCA0I2_2      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFADCA0I2_2:1;                                  /* RFADCA0I2_2      */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTADCA0I2_2:1;                            /* CTADCA0I2_2      */
} __type40;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RLIN30:1;                                     /* P0RLIN30         */
    uint8  P1RLIN30:1;                                     /* P1RLIN30         */
    uint8  P2RLIN30:1;                                     /* P2RLIN30         */
    uint8  P3RLIN30:1;                                     /* P3RLIN30         */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRLIN30:1;                                     /* TBRLIN30         */
    uint8  MKRLIN30:1;                                     /* MKRLIN30         */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRLIN30:1;                                     /* RFRLIN30         */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRLIN30:1;                               /* CTRLIN30         */
} __type41;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RLIN30UR0:1;                                  /* P0RLIN30UR0      */
    uint8  P1RLIN30UR0:1;                                  /* P1RLIN30UR0      */
    uint8  P2RLIN30UR0:1;                                  /* P2RLIN30UR0      */
    uint8  P3RLIN30UR0:1;                                  /* P3RLIN30UR0      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRLIN30UR0:1;                                  /* TBRLIN30UR0      */
    uint8  MKRLIN30UR0:1;                                  /* MKRLIN30UR0      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRLIN30UR0:1;                                  /* RFRLIN30UR0      */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRLIN30UR0:1;                            /* CTRLIN30UR0      */
} __type42;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RLIN30UR1:1;                                  /* P0RLIN30UR1      */
    uint8  P1RLIN30UR1:1;                                  /* P1RLIN30UR1      */
    uint8  P2RLIN30UR1:1;                                  /* P2RLIN30UR1      */
    uint8  P3RLIN30UR1:1;                                  /* P3RLIN30UR1      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRLIN30UR1:1;                                  /* TBRLIN30UR1      */
    uint8  MKRLIN30UR1:1;                                  /* MKRLIN30UR1      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRLIN30UR1:1;                                  /* RFRLIN30UR1      */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRLIN30UR1:1;                            /* CTRLIN30UR1      */
} __type43;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RLIN30UR2:1;                                  /* P0RLIN30UR2      */
    uint8  P1RLIN30UR2:1;                                  /* P1RLIN30UR2      */
    uint8  P2RLIN30UR2:1;                                  /* P2RLIN30UR2      */
    uint8  P3RLIN30UR2:1;                                  /* P3RLIN30UR2      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRLIN30UR2:1;                                  /* TBRLIN30UR2      */
    uint8  MKRLIN30UR2:1;                                  /* MKRLIN30UR2      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRLIN30UR2:1;                                  /* RFRLIN30UR2      */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRLIN30UR2:1;                            /* CTRLIN30UR2      */
} __type44;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0P0:1;                                         /* P0P0             */
    uint8  P1P0:1;                                         /* P1P0             */
    uint8  P2P0:1;                                         /* P2P0             */
    uint8  P3P0:1;                                         /* P3P0             */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBP0:1;                                         /* TBP0             */
    uint8  MKP0:1;                                         /* MKP0             */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFP0:1;                                         /* RFP0             */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTP0:1;                                   /* CTP0             */
} __type45;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0P1:1;                                         /* P0P1             */
    uint8  P1P1:1;                                         /* P1P1             */
    uint8  P2P1:1;                                         /* P2P1             */
    uint8  P3P1:1;                                         /* P3P1             */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBP1:1;                                         /* TBP1             */
    uint8  MKP1:1;                                         /* MKP1             */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFP1:1;                                         /* RFP1             */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTP1:1;                                   /* CTP1             */
} __type46;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0P2:1;                                         /* P0P2             */
    uint8  P1P2:1;                                         /* P1P2             */
    uint8  P2P2:1;                                         /* P2P2             */
    uint8  P3P2:1;                                         /* P3P2             */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBP2:1;                                         /* TBP2             */
    uint8  MKP2:1;                                         /* MKP2             */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFP2:1;                                         /* RFP2             */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTP2:1;                                   /* CTP2             */
} __type47;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0WDTA0:1;                                      /* P0WDTA0          */
    uint8  P1WDTA0:1;                                      /* P1WDTA0          */
    uint8  P2WDTA0:1;                                      /* P2WDTA0          */
    uint8  P3WDTA0:1;                                      /* P3WDTA0          */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBWDTA0:1;                                      /* TBWDTA0          */
    uint8  MKWDTA0:1;                                      /* MKWDTA0          */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFWDTA0:1;                                      /* RFWDTA0          */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTWDTA0:1;                                /* CTWDTA0          */
} __type48;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0WDTA1:1;                                      /* P0WDTA1          */
    uint8  P1WDTA1:1;                                      /* P1WDTA1          */
    uint8  P2WDTA1:1;                                      /* P2WDTA1          */
    uint8  P3WDTA1:1;                                      /* P3WDTA1          */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBWDTA1:1;                                      /* TBWDTA1          */
    uint8  MKWDTA1:1;                                      /* MKWDTA1          */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFWDTA1:1;                                      /* RFWDTA1          */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTWDTA1:1;                                /* CTWDTA1          */
} __type49;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0P3:1;                                         /* P0P3             */
    uint8  P1P3:1;                                         /* P1P3             */
    uint8  P2P3:1;                                         /* P2P3             */
    uint8  P3P3:1;                                         /* P3P3             */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBP3:1;                                         /* TBP3             */
    uint8  MKP3:1;                                         /* MKP3             */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFP3:1;                                         /* RFP3             */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTP3:1;                                   /* CTP3             */
} __type50;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0P4:1;                                         /* P0P4             */
    uint8  P1P4:1;                                         /* P1P4             */
    uint8  P2P4:1;                                         /* P2P4             */
    uint8  P3P4:1;                                         /* P3P4             */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBP4:1;                                         /* TBP4             */
    uint8  MKP4:1;                                         /* MKP4             */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFP4:1;                                         /* RFP4             */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTP4:1;                                   /* CTP4             */
} __type51;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0P5:1;                                         /* P0P5             */
    uint8  P1P5:1;                                         /* P1P5             */
    uint8  P2P5:1;                                         /* P2P5             */
    uint8  P3P5:1;                                         /* P3P5             */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBP5:1;                                         /* TBP5             */
    uint8  MKP5:1;                                         /* MKP5             */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFP5:1;                                         /* RFP5             */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTP5:1;                                   /* CTP5             */
} __type52;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0P10:1;                                        /* P0P10            */
    uint8  P1P10:1;                                        /* P1P10            */
    uint8  P2P10:1;                                        /* P2P10            */
    uint8  P3P10:1;                                        /* P3P10            */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBP10:1;                                        /* TBP10            */
    uint8  MKP10:1;                                        /* MKP10            */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFP10:1;                                        /* RFP10            */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTP10:1;                                  /* CTP10            */
} __type53;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0P11:1;                                        /* P0P11            */
    uint8  P1P11:1;                                        /* P1P11            */
    uint8  P2P11:1;                                        /* P2P11            */
    uint8  P3P11:1;                                        /* P3P11            */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBP11:1;                                        /* TBP11            */
    uint8  MKP11:1;                                        /* MKP11            */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFP11:1;                                        /* RFP11            */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTP11:1;                                  /* CTP11            */
} __type54;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUD0I1:1;                                    /* P0TAUD0I1        */
    uint8  P1TAUD0I1:1;                                    /* P1TAUD0I1        */
    uint8  P2TAUD0I1:1;                                    /* P2TAUD0I1        */
    uint8  P3TAUD0I1:1;                                    /* P3TAUD0I1        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUD0I1:1;                                    /* TBTAUD0I1        */
    uint8  MKTAUD0I1:1;                                    /* MKTAUD0I1        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUD0I1:1;                                    /* RFTAUD0I1        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUD0I1:1;                              /* CTTAUD0I1        */
} __type55;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUD0I3:1;                                    /* P0TAUD0I3        */
    uint8  P1TAUD0I3:1;                                    /* P1TAUD0I3        */
    uint8  P2TAUD0I3:1;                                    /* P2TAUD0I3        */
    uint8  P3TAUD0I3:1;                                    /* P3TAUD0I3        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUD0I3:1;                                    /* TBTAUD0I3        */
    uint8  MKTAUD0I3:1;                                    /* MKTAUD0I3        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUD0I3:1;                                    /* RFTAUD0I3        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUD0I3:1;                              /* CTTAUD0I3        */
} __type56;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUD0I5:1;                                    /* P0TAUD0I5        */
    uint8  P1TAUD0I5:1;                                    /* P1TAUD0I5        */
    uint8  P2TAUD0I5:1;                                    /* P2TAUD0I5        */
    uint8  P3TAUD0I5:1;                                    /* P3TAUD0I5        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUD0I5:1;                                    /* TBTAUD0I5        */
    uint8  MKTAUD0I5:1;                                    /* MKTAUD0I5        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUD0I5:1;                                    /* RFTAUD0I5        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUD0I5:1;                              /* CTTAUD0I5        */
} __type57;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUD0I7:1;                                    /* P0TAUD0I7        */
    uint8  P1TAUD0I7:1;                                    /* P1TAUD0I7        */
    uint8  P2TAUD0I7:1;                                    /* P2TAUD0I7        */
    uint8  P3TAUD0I7:1;                                    /* P3TAUD0I7        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUD0I7:1;                                    /* TBTAUD0I7        */
    uint8  MKTAUD0I7:1;                                    /* MKTAUD0I7        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUD0I7:1;                                    /* RFTAUD0I7        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUD0I7:1;                              /* CTTAUD0I7        */
} __type58;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUD0I9:1;                                    /* P0TAUD0I9        */
    uint8  P1TAUD0I9:1;                                    /* P1TAUD0I9        */
    uint8  P2TAUD0I9:1;                                    /* P2TAUD0I9        */
    uint8  P3TAUD0I9:1;                                    /* P3TAUD0I9        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUD0I9:1;                                    /* TBTAUD0I9        */
    uint8  MKTAUD0I9:1;                                    /* MKTAUD0I9        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUD0I9:1;                                    /* RFTAUD0I9        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUD0I9:1;                              /* CTTAUD0I9        */
} __type59;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUD0I11:1;                                   /* P0TAUD0I11       */
    uint8  P1TAUD0I11:1;                                   /* P1TAUD0I11       */
    uint8  P2TAUD0I11:1;                                   /* P2TAUD0I11       */
    uint8  P3TAUD0I11:1;                                   /* P3TAUD0I11       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUD0I11:1;                                   /* TBTAUD0I11       */
    uint8  MKTAUD0I11:1;                                   /* MKTAUD0I11       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUD0I11:1;                                   /* RFTAUD0I11       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUD0I11:1;                             /* CTTAUD0I11       */
} __type60;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUD0I13:1;                                   /* P0TAUD0I13       */
    uint8  P1TAUD0I13:1;                                   /* P1TAUD0I13       */
    uint8  P2TAUD0I13:1;                                   /* P2TAUD0I13       */
    uint8  P3TAUD0I13:1;                                   /* P3TAUD0I13       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUD0I13:1;                                   /* TBTAUD0I13       */
    uint8  MKTAUD0I13:1;                                   /* MKTAUD0I13       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUD0I13:1;                                   /* RFTAUD0I13       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUD0I13:1;                             /* CTTAUD0I13       */
} __type61;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUD0I15:1;                                   /* P0TAUD0I15       */
    uint8  P1TAUD0I15:1;                                   /* P1TAUD0I15       */
    uint8  P2TAUD0I15:1;                                   /* P2TAUD0I15       */
    uint8  P3TAUD0I15:1;                                   /* P3TAUD0I15       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUD0I15:1;                                   /* TBTAUD0I15       */
    uint8  MKTAUD0I15:1;                                   /* MKTAUD0I15       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUD0I15:1;                                   /* RFTAUD0I15       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUD0I15:1;                             /* CTTAUD0I15       */
} __type62;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0ADCA0ERR:1;                                   /* P0ADCA0ERR       */
    uint8  P1ADCA0ERR:1;                                   /* P1ADCA0ERR       */
    uint8  P2ADCA0ERR:1;                                   /* P2ADCA0ERR       */
    uint8  P3ADCA0ERR:1;                                   /* P3ADCA0ERR       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBADCA0ERR:1;                                   /* TBADCA0ERR       */
    uint8  MKADCA0ERR:1;                                   /* MKADCA0ERR       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFADCA0ERR:1;                                   /* RFADCA0ERR       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTADCA0ERR:1;                             /* CTADCA0ERR       */
} __type63;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIG0IRE:1;                                   /* P0CSIG0IRE       */
    uint8  P1CSIG0IRE:1;                                   /* P1CSIG0IRE       */
    uint8  P2CSIG0IRE:1;                                   /* P2CSIG0IRE       */
    uint8  P3CSIG0IRE:1;                                   /* P3CSIG0IRE       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIG0IRE:1;                                   /* TBCSIG0IRE       */
    uint8  MKCSIG0IRE:1;                                   /* MKCSIG0IRE       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIG0IRE:1;                                   /* RFCSIG0IRE       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIG0IRE:1;                             /* CTCSIG0IRE       */
} __type64;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RLIN20:1;                                     /* P0RLIN20         */
    uint8  P1RLIN20:1;                                     /* P1RLIN20         */
    uint8  P2RLIN20:1;                                     /* P2RLIN20         */
    uint8  P3RLIN20:1;                                     /* P3RLIN20         */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRLIN20:1;                                     /* TBRLIN20         */
    uint8  MKRLIN20:1;                                     /* MKRLIN20         */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRLIN20:1;                                     /* RFRLIN20         */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRLIN20:1;                               /* CTRLIN20         */
} __type65;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RLIN21:1;                                     /* P0RLIN21         */
    uint8  P1RLIN21:1;                                     /* P1RLIN21         */
    uint8  P2RLIN21:1;                                     /* P2RLIN21         */
    uint8  P3RLIN21:1;                                     /* P3RLIN21         */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRLIN21:1;                                     /* TBRLIN21         */
    uint8  MKRLIN21:1;                                     /* MKRLIN21         */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRLIN21:1;                                     /* RFRLIN21         */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRLIN21:1;                               /* CTRLIN21         */
} __type66;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0DMA0:1;                                       /* P0DMA0           */
    uint8  P1DMA0:1;                                       /* P1DMA0           */
    uint8  P2DMA0:1;                                       /* P2DMA0           */
    uint8  P3DMA0:1;                                       /* P3DMA0           */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBDMA0:1;                                       /* TBDMA0           */
    uint8  MKDMA0:1;                                       /* MKDMA0           */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFDMA0:1;                                       /* RFDMA0           */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTDMA0:1;                                 /* CTDMA0           */
} __type67;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0DMA1:1;                                       /* P0DMA1           */
    uint8  P1DMA1:1;                                       /* P1DMA1           */
    uint8  P2DMA1:1;                                       /* P2DMA1           */
    uint8  P3DMA1:1;                                       /* P3DMA1           */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBDMA1:1;                                       /* TBDMA1           */
    uint8  MKDMA1:1;                                       /* MKDMA1           */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFDMA1:1;                                       /* RFDMA1           */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTDMA1:1;                                 /* CTDMA1           */
} __type68;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0DMA2:1;                                       /* P0DMA2           */
    uint8  P1DMA2:1;                                       /* P1DMA2           */
    uint8  P2DMA2:1;                                       /* P2DMA2           */
    uint8  P3DMA2:1;                                       /* P3DMA2           */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBDMA2:1;                                       /* TBDMA2           */
    uint8  MKDMA2:1;                                       /* MKDMA2           */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFDMA2:1;                                       /* RFDMA2           */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTDMA2:1;                                 /* CTDMA2           */
} __type69;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0DMA3:1;                                       /* P0DMA3           */
    uint8  P1DMA3:1;                                       /* P1DMA3           */
    uint8  P2DMA3:1;                                       /* P2DMA3           */
    uint8  P3DMA3:1;                                       /* P3DMA3           */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBDMA3:1;                                       /* TBDMA3           */
    uint8  MKDMA3:1;                                       /* MKDMA3           */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFDMA3:1;                                       /* RFDMA3           */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTDMA3:1;                                 /* CTDMA3           */
} __type70;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0DMA4:1;                                       /* P0DMA4           */
    uint8  P1DMA4:1;                                       /* P1DMA4           */
    uint8  P2DMA4:1;                                       /* P2DMA4           */
    uint8  P3DMA4:1;                                       /* P3DMA4           */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBDMA4:1;                                       /* TBDMA4           */
    uint8  MKDMA4:1;                                       /* MKDMA4           */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFDMA4:1;                                       /* RFDMA4           */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTDMA4:1;                                 /* CTDMA4           */
} __type71;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0DMA5:1;                                       /* P0DMA5           */
    uint8  P1DMA5:1;                                       /* P1DMA5           */
    uint8  P2DMA5:1;                                       /* P2DMA5           */
    uint8  P3DMA5:1;                                       /* P3DMA5           */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBDMA5:1;                                       /* TBDMA5           */
    uint8  MKDMA5:1;                                       /* MKDMA5           */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFDMA5:1;                                       /* RFDMA5           */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTDMA5:1;                                 /* CTDMA5           */
} __type72;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0DMA6:1;                                       /* P0DMA6           */
    uint8  P1DMA6:1;                                       /* P1DMA6           */
    uint8  P2DMA6:1;                                       /* P2DMA6           */
    uint8  P3DMA6:1;                                       /* P3DMA6           */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBDMA6:1;                                       /* TBDMA6           */
    uint8  MKDMA6:1;                                       /* MKDMA6           */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFDMA6:1;                                       /* RFDMA6           */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTDMA6:1;                                 /* CTDMA6           */
} __type73;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0DMA7:1;                                       /* P0DMA7           */
    uint8  P1DMA7:1;                                       /* P1DMA7           */
    uint8  P2DMA7:1;                                       /* P2DMA7           */
    uint8  P3DMA7:1;                                       /* P3DMA7           */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBDMA7:1;                                       /* TBDMA7           */
    uint8  MKDMA7:1;                                       /* MKDMA7           */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFDMA7:1;                                       /* RFDMA7           */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTDMA7:1;                                 /* CTDMA7           */
} __type74;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0DMA8:1;                                       /* P0DMA8           */
    uint8  P1DMA8:1;                                       /* P1DMA8           */
    uint8  P2DMA8:1;                                       /* P2DMA8           */
    uint8  P3DMA8:1;                                       /* P3DMA8           */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBDMA8:1;                                       /* TBDMA8           */
    uint8  MKDMA8:1;                                       /* MKDMA8           */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFDMA8:1;                                       /* RFDMA8           */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTDMA8:1;                                 /* CTDMA8           */
} __type75;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0DMA9:1;                                       /* P0DMA9           */
    uint8  P1DMA9:1;                                       /* P1DMA9           */
    uint8  P2DMA9:1;                                       /* P2DMA9           */
    uint8  P3DMA9:1;                                       /* P3DMA9           */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBDMA9:1;                                       /* TBDMA9           */
    uint8  MKDMA9:1;                                       /* MKDMA9           */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFDMA9:1;                                       /* RFDMA9           */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTDMA9:1;                                 /* CTDMA9           */
} __type76;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0DMA10:1;                                      /* P0DMA10          */
    uint8  P1DMA10:1;                                      /* P1DMA10          */
    uint8  P2DMA10:1;                                      /* P2DMA10          */
    uint8  P3DMA10:1;                                      /* P3DMA10          */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBDMA10:1;                                      /* TBDMA10          */
    uint8  MKDMA10:1;                                      /* MKDMA10          */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFDMA10:1;                                      /* RFDMA10          */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTDMA10:1;                                /* CTDMA10          */
} __type77;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0DMA11:1;                                      /* P0DMA11          */
    uint8  P1DMA11:1;                                      /* P1DMA11          */
    uint8  P2DMA11:1;                                      /* P2DMA11          */
    uint8  P3DMA11:1;                                      /* P3DMA11          */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBDMA11:1;                                      /* TBDMA11          */
    uint8  MKDMA11:1;                                      /* MKDMA11          */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFDMA11:1;                                      /* RFDMA11          */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTDMA11:1;                                /* CTDMA11          */
} __type78;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0DMA12:1;                                      /* P0DMA12          */
    uint8  P1DMA12:1;                                      /* P1DMA12          */
    uint8  P2DMA12:1;                                      /* P2DMA12          */
    uint8  P3DMA12:1;                                      /* P3DMA12          */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBDMA12:1;                                      /* TBDMA12          */
    uint8  MKDMA12:1;                                      /* MKDMA12          */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFDMA12:1;                                      /* RFDMA12          */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTDMA12:1;                                /* CTDMA12          */
} __type79;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0DMA13:1;                                      /* P0DMA13          */
    uint8  P1DMA13:1;                                      /* P1DMA13          */
    uint8  P2DMA13:1;                                      /* P2DMA13          */
    uint8  P3DMA13:1;                                      /* P3DMA13          */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBDMA13:1;                                      /* TBDMA13          */
    uint8  MKDMA13:1;                                      /* MKDMA13          */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFDMA13:1;                                      /* RFDMA13          */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTDMA13:1;                                /* CTDMA13          */
} __type80;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0DMA14:1;                                      /* P0DMA14          */
    uint8  P1DMA14:1;                                      /* P1DMA14          */
    uint8  P2DMA14:1;                                      /* P2DMA14          */
    uint8  P3DMA14:1;                                      /* P3DMA14          */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBDMA14:1;                                      /* TBDMA14          */
    uint8  MKDMA14:1;                                      /* MKDMA14          */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFDMA14:1;                                      /* RFDMA14          */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTDMA14:1;                                /* CTDMA14          */
} __type81;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0DMA15:1;                                      /* P0DMA15          */
    uint8  P1DMA15:1;                                      /* P1DMA15          */
    uint8  P2DMA15:1;                                      /* P2DMA15          */
    uint8  P3DMA15:1;                                      /* P3DMA15          */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBDMA15:1;                                      /* TBDMA15          */
    uint8  MKDMA15:1;                                      /* MKDMA15          */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFDMA15:1;                                      /* RFDMA15          */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTDMA15:1;                                /* CTDMA15          */
} __type82;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RIIC0TI:1;                                    /* P0RIIC0TI        */
    uint8  P1RIIC0TI:1;                                    /* P1RIIC0TI        */
    uint8  P2RIIC0TI:1;                                    /* P2RIIC0TI        */
    uint8  P3RIIC0TI:1;                                    /* P3RIIC0TI        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRIIC0TI:1;                                    /* TBRIIC0TI        */
    uint8  MKRIIC0TI:1;                                    /* MKRIIC0TI        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRIIC0TI:1;                                    /* RFRIIC0TI        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRIIC0TI:1;                              /* CTRIIC0TI        */
} __type83;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RIIC0EE:1;                                    /* P0RIIC0EE        */
    uint8  P1RIIC0EE:1;                                    /* P1RIIC0EE        */
    uint8  P2RIIC0EE:1;                                    /* P2RIIC0EE        */
    uint8  P3RIIC0EE:1;                                    /* P3RIIC0EE        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRIIC0EE:1;                                    /* TBRIIC0EE        */
    uint8  MKRIIC0EE:1;                                    /* MKRIIC0EE        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRIIC0EE:1;                                    /* RFRIIC0EE        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRIIC0EE:1;                              /* CTRIIC0EE        */
} __type84;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RIIC0RI:1;                                    /* P0RIIC0RI        */
    uint8  P1RIIC0RI:1;                                    /* P1RIIC0RI        */
    uint8  P2RIIC0RI:1;                                    /* P2RIIC0RI        */
    uint8  P3RIIC0RI:1;                                    /* P3RIIC0RI        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRIIC0RI:1;                                    /* TBRIIC0RI        */
    uint8  MKRIIC0RI:1;                                    /* MKRIIC0RI        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRIIC0RI:1;                                    /* RFRIIC0RI        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRIIC0RI:1;                              /* CTRIIC0RI        */
} __type85;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RIIC0TEI:1;                                   /* P0RIIC0TEI       */
    uint8  P1RIIC0TEI:1;                                   /* P1RIIC0TEI       */
    uint8  P2RIIC0TEI:1;                                   /* P2RIIC0TEI       */
    uint8  P3RIIC0TEI:1;                                   /* P3RIIC0TEI       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRIIC0TEI:1;                                   /* TBRIIC0TEI       */
    uint8  MKRIIC0TEI:1;                                   /* MKRIIC0TEI       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRIIC0TEI:1;                                   /* RFRIIC0TEI       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRIIC0TEI:1;                             /* CTRIIC0TEI       */
} __type86;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUJ0I0:1;                                    /* P0TAUJ0I0        */
    uint8  P1TAUJ0I0:1;                                    /* P1TAUJ0I0        */
    uint8  P2TAUJ0I0:1;                                    /* P2TAUJ0I0        */
    uint8  P3TAUJ0I0:1;                                    /* P3TAUJ0I0        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUJ0I0:1;                                    /* TBTAUJ0I0        */
    uint8  MKTAUJ0I0:1;                                    /* MKTAUJ0I0        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUJ0I0:1;                                    /* RFTAUJ0I0        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUJ0I0:1;                              /* CTTAUJ0I0        */
} __type87;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUJ0I1:1;                                    /* P0TAUJ0I1        */
    uint8  P1TAUJ0I1:1;                                    /* P1TAUJ0I1        */
    uint8  P2TAUJ0I1:1;                                    /* P2TAUJ0I1        */
    uint8  P3TAUJ0I1:1;                                    /* P3TAUJ0I1        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUJ0I1:1;                                    /* TBTAUJ0I1        */
    uint8  MKTAUJ0I1:1;                                    /* MKTAUJ0I1        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUJ0I1:1;                                    /* RFTAUJ0I1        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUJ0I1:1;                              /* CTTAUJ0I1        */
} __type88;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUJ0I2:1;                                    /* P0TAUJ0I2        */
    uint8  P1TAUJ0I2:1;                                    /* P1TAUJ0I2        */
    uint8  P2TAUJ0I2:1;                                    /* P2TAUJ0I2        */
    uint8  P3TAUJ0I2:1;                                    /* P3TAUJ0I2        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUJ0I2:1;                                    /* TBTAUJ0I2        */
    uint8  MKTAUJ0I2:1;                                    /* MKTAUJ0I2        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUJ0I2:1;                                    /* RFTAUJ0I2        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUJ0I2:1;                              /* CTTAUJ0I2        */
} __type89;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUJ0I3:1;                                    /* P0TAUJ0I3        */
    uint8  P1TAUJ0I3:1;                                    /* P1TAUJ0I3        */
    uint8  P2TAUJ0I3:1;                                    /* P2TAUJ0I3        */
    uint8  P3TAUJ0I3:1;                                    /* P3TAUJ0I3        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUJ0I3:1;                                    /* TBTAUJ0I3        */
    uint8  MKTAUJ0I3:1;                                    /* MKTAUJ0I3        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUJ0I3:1;                                    /* RFTAUJ0I3        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUJ0I3:1;                              /* CTTAUJ0I3        */
} __type90;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0OSTM0:1;                                      /* P0OSTM0          */
    uint8  P1OSTM0:1;                                      /* P1OSTM0          */
    uint8  P2OSTM0:1;                                      /* P2OSTM0          */
    uint8  P3OSTM0:1;                                      /* P3OSTM0          */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBOSTM0:1;                                      /* TBOSTM0          */
    uint8  MKOSTM0:1;                                      /* MKOSTM0          */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFOSTM0:1;                                      /* RFOSTM0          */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTOSTM0:1;                                /* CTOSTM0          */
} __type91;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0ENCA0IOV:1;                                   /* P0ENCA0IOV       */
    uint8  P1ENCA0IOV:1;                                   /* P1ENCA0IOV       */
    uint8  P2ENCA0IOV:1;                                   /* P2ENCA0IOV       */
    uint8  P3ENCA0IOV:1;                                   /* P3ENCA0IOV       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBENCA0IOV:1;                                   /* TBENCA0IOV       */
    uint8  MKENCA0IOV:1;                                   /* MKENCA0IOV       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFENCA0IOV:1;                                   /* RFENCA0IOV       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTENCA0IOV:1;                             /* CTENCA0IOV       */
} __type92;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0ENCA0IUD:1;                                   /* P0ENCA0IUD       */
    uint8  P1ENCA0IUD:1;                                   /* P1ENCA0IUD       */
    uint8  P2ENCA0IUD:1;                                   /* P2ENCA0IUD       */
    uint8  P3ENCA0IUD:1;                                   /* P3ENCA0IUD       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBENCA0IUD:1;                                   /* TBENCA0IUD       */
    uint8  MKENCA0IUD:1;                                   /* MKENCA0IUD       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFENCA0IUD:1;                                   /* RFENCA0IUD       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTENCA0IUD:1;                             /* CTENCA0IUD       */
} __type93;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0ENCA0I0:1;                                    /* P0ENCA0I0        */
    uint8  P1ENCA0I0:1;                                    /* P1ENCA0I0        */
    uint8  P2ENCA0I0:1;                                    /* P2ENCA0I0        */
    uint8  P3ENCA0I0:1;                                    /* P3ENCA0I0        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBENCA0I0:1;                                    /* TBENCA0I0        */
    uint8  MKENCA0I0:1;                                    /* MKENCA0I0        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFENCA0I0:1;                                    /* RFENCA0I0        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTENCA0I0:1;                              /* CTENCA0I0        */
} __type94;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0ENCA0I1:1;                                    /* P0ENCA0I1        */
    uint8  P1ENCA0I1:1;                                    /* P1ENCA0I1        */
    uint8  P2ENCA0I1:1;                                    /* P2ENCA0I1        */
    uint8  P3ENCA0I1:1;                                    /* P3ENCA0I1        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBENCA0I1:1;                                    /* TBENCA0I1        */
    uint8  MKENCA0I1:1;                                    /* MKENCA0I1        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFENCA0I1:1;                                    /* RFENCA0I1        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTENCA0I1:1;                              /* CTENCA0I1        */
} __type95;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0ENCA0IEC:1;                                   /* P0ENCA0IEC       */
    uint8  P1ENCA0IEC:1;                                   /* P1ENCA0IEC       */
    uint8  P2ENCA0IEC:1;                                   /* P2ENCA0IEC       */
    uint8  P3ENCA0IEC:1;                                   /* P3ENCA0IEC       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBENCA0IEC:1;                                   /* TBENCA0IEC       */
    uint8  MKENCA0IEC:1;                                   /* MKENCA0IEC       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFENCA0IEC:1;                                   /* RFENCA0IEC       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTENCA0IEC:1;                             /* CTENCA0IEC       */
} __type96;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0KR0:1;                                        /* P0KR0            */
    uint8  P1KR0:1;                                        /* P1KR0            */
    uint8  P2KR0:1;                                        /* P2KR0            */
    uint8  P3KR0:1;                                        /* P3KR0            */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBKR0:1;                                        /* TBKR0            */
    uint8  MKKR0:1;                                        /* MKKR0            */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFKR0:1;                                        /* RFKR0            */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTKR0:1;                                  /* CTKR0            */
} __type97;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0QFULL:1;                                      /* P0QFULL          */
    uint8  P1QFULL:1;                                      /* P1QFULL          */
    uint8  P2QFULL:1;                                      /* P2QFULL          */
    uint8  P3QFULL:1;                                      /* P3QFULL          */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBQFULL:1;                                      /* TBQFULL          */
    uint8  MKQFULL:1;                                      /* MKQFULL          */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFQFULL:1;                                      /* RFQFULL          */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTQFULL:1;                                /* CTQFULL          */
} __type98;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0PWGAG00:1;                                    /* P0PWGAG00        */
    uint8  P1PWGAG00:1;                                    /* P1PWGAG00        */
    uint8  P2PWGAG00:1;                                    /* P2PWGAG00        */
    uint8  P3PWGAG00:1;                                    /* P3PWGAG00        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBPWGAG00:1;                                    /* TBPWGAG00        */
    uint8  MKPWGAG00:1;                                    /* MKPWGAG00        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFPWGAG00:1;                                    /* RFPWGAG00        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTPWGAG00:1;                              /* CTPWGAG00        */
} __type99;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0PWGAG01:1;                                    /* P0PWGAG01        */
    uint8  P1PWGAG01:1;                                    /* P1PWGAG01        */
    uint8  P2PWGAG01:1;                                    /* P2PWGAG01        */
    uint8  P3PWGAG01:1;                                    /* P3PWGAG01        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBPWGAG01:1;                                    /* TBPWGAG01        */
    uint8  MKPWGAG01:1;                                    /* MKPWGAG01        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFPWGAG01:1;                                    /* RFPWGAG01        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTPWGAG01:1;                              /* CTPWGAG01        */
} __type100;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0FLERR:1;                                      /* P0FLERR          */
    uint8  P1FLERR:1;                                      /* P1FLERR          */
    uint8  P2FLERR:1;                                      /* P2FLERR          */
    uint8  P3FLERR:1;                                      /* P3FLERR          */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBFLERR:1;                                      /* TBFLERR          */
    uint8  MKFLERR:1;                                      /* MKFLERR          */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFFLERR:1;                                      /* RFFLERR          */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTFLERR:1;                                /* CTFLERR          */
} __type101;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0FLENDNM:1;                                    /* P0FLENDNM        */
    uint8  P1FLENDNM:1;                                    /* P1FLENDNM        */
    uint8  P2FLENDNM:1;                                    /* P2FLENDNM        */
    uint8  P3FLENDNM:1;                                    /* P3FLENDNM        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBFLENDNM:1;                                    /* TBFLENDNM        */
    uint8  MKFLENDNM:1;                                    /* MKFLENDNM        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFFLENDNM:1;                                    /* RFFLENDNM        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTFLENDNM:1;                              /* CTFLENDNM        */
} __type102;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CWEND:1;                                      /* P0CWEND          */
    uint8  P1CWEND:1;                                      /* P1CWEND          */
    uint8  P2CWEND:1;                                      /* P2CWEND          */
    uint8  P3CWEND:1;                                      /* P3CWEND          */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCWEND:1;                                      /* TBCWEND          */
    uint8  MKCWEND:1;                                      /* MKCWEND          */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCWEND:1;                                      /* RFCWEND          */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCWEND:1;                                /* CTCWEND          */
} __type103;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RCAN1ERR:1;                                   /* P0RCAN1ERR       */
    uint8  P1RCAN1ERR:1;                                   /* P1RCAN1ERR       */
    uint8  P2RCAN1ERR:1;                                   /* P2RCAN1ERR       */
    uint8  P3RCAN1ERR:1;                                   /* P3RCAN1ERR       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRCAN1ERR:1;                                   /* TBRCAN1ERR       */
    uint8  MKRCAN1ERR:1;                                   /* MKRCAN1ERR       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRCAN1ERR:1;                                   /* RFRCAN1ERR       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRCAN1ERR:1;                             /* CTRCAN1ERR       */
} __type104;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RCAN1REC:1;                                   /* P0RCAN1REC       */
    uint8  P1RCAN1REC:1;                                   /* P1RCAN1REC       */
    uint8  P2RCAN1REC:1;                                   /* P2RCAN1REC       */
    uint8  P3RCAN1REC:1;                                   /* P3RCAN1REC       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRCAN1REC:1;                                   /* TBRCAN1REC       */
    uint8  MKRCAN1REC:1;                                   /* MKRCAN1REC       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRCAN1REC:1;                                   /* RFRCAN1REC       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRCAN1REC:1;                             /* CTRCAN1REC       */
} __type105;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RCAN1TRX:1;                                   /* P0RCAN1TRX       */
    uint8  P1RCAN1TRX:1;                                   /* P1RCAN1TRX       */
    uint8  P2RCAN1TRX:1;                                   /* P2RCAN1TRX       */
    uint8  P3RCAN1TRX:1;                                   /* P3RCAN1TRX       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRCAN1TRX:1;                                   /* TBRCAN1TRX       */
    uint8  MKRCAN1TRX:1;                                   /* MKRCAN1TRX       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRCAN1TRX:1;                                   /* RFRCAN1TRX       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRCAN1TRX:1;                             /* CTRCAN1TRX       */
} __type106;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH1IC:1;                                    /* P0CSIH1IC        */
    uint8  P1CSIH1IC:1;                                    /* P1CSIH1IC        */
    uint8  P2CSIH1IC:1;                                    /* P2CSIH1IC        */
    uint8  P3CSIH1IC:1;                                    /* P3CSIH1IC        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH1IC:1;                                    /* TBCSIH1IC        */
    uint8  MKCSIH1IC:1;                                    /* MKCSIH1IC        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH1IC:1;                                    /* RFCSIH1IC        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH1IC:1;                              /* CTCSIH1IC        */
} __type107;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH1IR:1;                                    /* P0CSIH1IR        */
    uint8  P1CSIH1IR:1;                                    /* P1CSIH1IR        */
    uint8  P2CSIH1IR:1;                                    /* P2CSIH1IR        */
    uint8  P3CSIH1IR:1;                                    /* P3CSIH1IR        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH1IR:1;                                    /* TBCSIH1IR        */
    uint8  MKCSIH1IR:1;                                    /* MKCSIH1IR        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH1IR:1;                                    /* RFCSIH1IR        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH1IR:1;                              /* CTCSIH1IR        */
} __type108;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIG0IC_2:1;                                  /* P0CSIG0IC_2      */
    uint8  P1CSIG0IC_2:1;                                  /* P1CSIG0IC_2      */
    uint8  P2CSIG0IC_2:1;                                  /* P2CSIG0IC_2      */
    uint8  P3CSIG0IC_2:1;                                  /* P3CSIG0IC_2      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIG0IC_2:1;                                  /* TBCSIG0IC_2      */
    uint8  MKCSIG0IC_2:1;                                  /* MKCSIG0IC_2      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIG0IC_2:1;                                  /* RFCSIG0IC_2      */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIG0IC_2:1;                            /* CTCSIG0IC_2      */
} __type109;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIG0IR_2:1;                                  /* P0CSIG0IR_2      */
    uint8  P1CSIG0IR_2:1;                                  /* P1CSIG0IR_2      */
    uint8  P2CSIG0IR_2:1;                                  /* P2CSIG0IR_2      */
    uint8  P3CSIG0IR_2:1;                                  /* P3CSIG0IR_2      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIG0IR_2:1;                                  /* TBCSIG0IR_2      */
    uint8  MKCSIG0IR_2:1;                                  /* MKCSIG0IR_2      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIG0IR_2:1;                                  /* RFCSIG0IR_2      */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIG0IR_2:1;                            /* CTCSIG0IR_2      */
} __type110;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RLIN31:1;                                     /* P0RLIN31         */
    uint8  P1RLIN31:1;                                     /* P1RLIN31         */
    uint8  P2RLIN31:1;                                     /* P2RLIN31         */
    uint8  P3RLIN31:1;                                     /* P3RLIN31         */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRLIN31:1;                                     /* TBRLIN31         */
    uint8  MKRLIN31:1;                                     /* MKRLIN31         */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRLIN31:1;                                     /* RFRLIN31         */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRLIN31:1;                               /* CTRLIN31         */
} __type111;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RLIN31UR0:1;                                  /* P0RLIN31UR0      */
    uint8  P1RLIN31UR0:1;                                  /* P1RLIN31UR0      */
    uint8  P2RLIN31UR0:1;                                  /* P2RLIN31UR0      */
    uint8  P3RLIN31UR0:1;                                  /* P3RLIN31UR0      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRLIN31UR0:1;                                  /* TBRLIN31UR0      */
    uint8  MKRLIN31UR0:1;                                  /* MKRLIN31UR0      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRLIN31UR0:1;                                  /* RFRLIN31UR0      */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRLIN31UR0:1;                            /* CTRLIN31UR0      */
} __type112;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RLIN31UR1:1;                                  /* P0RLIN31UR1      */
    uint8  P1RLIN31UR1:1;                                  /* P1RLIN31UR1      */
    uint8  P2RLIN31UR1:1;                                  /* P2RLIN31UR1      */
    uint8  P3RLIN31UR1:1;                                  /* P3RLIN31UR1      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRLIN31UR1:1;                                  /* TBRLIN31UR1      */
    uint8  MKRLIN31UR1:1;                                  /* MKRLIN31UR1      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRLIN31UR1:1;                                  /* RFRLIN31UR1      */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRLIN31UR1:1;                            /* CTRLIN31UR1      */
} __type113;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RLIN31UR2:1;                                  /* P0RLIN31UR2      */
    uint8  P1RLIN31UR2:1;                                  /* P1RLIN31UR2      */
    uint8  P2RLIN31UR2:1;                                  /* P2RLIN31UR2      */
    uint8  P3RLIN31UR2:1;                                  /* P3RLIN31UR2      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRLIN31UR2:1;                                  /* TBRLIN31UR2      */
    uint8  MKRLIN31UR2:1;                                  /* MKRLIN31UR2      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRLIN31UR2:1;                                  /* RFRLIN31UR2      */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRLIN31UR2:1;                            /* CTRLIN31UR2      */
} __type114;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0P6:1;                                         /* P0P6             */
    uint8  P1P6:1;                                         /* P1P6             */
    uint8  P2P6:1;                                         /* P2P6             */
    uint8  P3P6:1;                                         /* P3P6             */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBP6:1;                                         /* TBP6             */
    uint8  MKP6:1;                                         /* MKP6             */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFP6:1;                                         /* RFP6             */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTP6:1;                                   /* CTP6             */
} __type115;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0P7:1;                                         /* P0P7             */
    uint8  P1P7:1;                                         /* P1P7             */
    uint8  P2P7:1;                                         /* P2P7             */
    uint8  P3P7:1;                                         /* P3P7             */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBP7:1;                                         /* TBP7             */
    uint8  MKP7:1;                                         /* MKP7             */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFP7:1;                                         /* RFP7             */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTP7:1;                                   /* CTP7             */
} __type116;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0P8:1;                                         /* P0P8             */
    uint8  P1P8:1;                                         /* P1P8             */
    uint8  P2P8:1;                                         /* P2P8             */
    uint8  P3P8:1;                                         /* P3P8             */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBP8:1;                                         /* TBP8             */
    uint8  MKP8:1;                                         /* MKP8             */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFP8:1;                                         /* RFP8             */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTP8:1;                                   /* CTP8             */
} __type117;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0P12:1;                                        /* P0P12            */
    uint8  P1P12:1;                                        /* P1P12            */
    uint8  P2P12:1;                                        /* P2P12            */
    uint8  P3P12:1;                                        /* P3P12            */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBP12:1;                                        /* TBP12            */
    uint8  MKP12:1;                                        /* MKP12            */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFP12:1;                                        /* RFP12            */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTP12:1;                                  /* CTP12            */
} __type118;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH2IC:1;                                    /* P0CSIH2IC        */
    uint8  P1CSIH2IC:1;                                    /* P1CSIH2IC        */
    uint8  P2CSIH2IC:1;                                    /* P2CSIH2IC        */
    uint8  P3CSIH2IC:1;                                    /* P3CSIH2IC        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH2IC:1;                                    /* TBCSIH2IC        */
    uint8  MKCSIH2IC:1;                                    /* MKCSIH2IC        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH2IC:1;                                    /* RFCSIH2IC        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH2IC:1;                              /* CTCSIH2IC        */
} __type119;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH2IR:1;                                    /* P0CSIH2IR        */
    uint8  P1CSIH2IR:1;                                    /* P1CSIH2IR        */
    uint8  P2CSIH2IR:1;                                    /* P2CSIH2IR        */
    uint8  P3CSIH2IR:1;                                    /* P3CSIH2IR        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH2IR:1;                                    /* TBCSIH2IR        */
    uint8  MKCSIH2IR:1;                                    /* MKCSIH2IR        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH2IR:1;                                    /* RFCSIH2IR        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH2IR:1;                              /* CTCSIH2IR        */
} __type120;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH2IRE:1;                                   /* P0CSIH2IRE       */
    uint8  P1CSIH2IRE:1;                                   /* P1CSIH2IRE       */
    uint8  P2CSIH2IRE:1;                                   /* P2CSIH2IRE       */
    uint8  P3CSIH2IRE:1;                                   /* P3CSIH2IRE       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH2IRE:1;                                   /* TBCSIH2IRE       */
    uint8  MKCSIH2IRE:1;                                   /* MKCSIH2IRE       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH2IRE:1;                                   /* RFCSIH2IRE       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH2IRE:1;                             /* CTCSIH2IRE       */
} __type121;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH2IJC:1;                                   /* P0CSIH2IJC       */
    uint8  P1CSIH2IJC:1;                                   /* P1CSIH2IJC       */
    uint8  P2CSIH2IJC:1;                                   /* P2CSIH2IJC       */
    uint8  P3CSIH2IJC:1;                                   /* P3CSIH2IJC       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH2IJC:1;                                   /* TBCSIH2IJC       */
    uint8  MKCSIH2IJC:1;                                   /* MKCSIH2IJC       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH2IJC:1;                                   /* RFCSIH2IJC       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH2IJC:1;                             /* CTCSIH2IJC       */
} __type122;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUB0I0:1;                                    /* P0TAUB0I0        */
    uint8  P1TAUB0I0:1;                                    /* P1TAUB0I0        */
    uint8  P2TAUB0I0:1;                                    /* P2TAUB0I0        */
    uint8  P3TAUB0I0:1;                                    /* P3TAUB0I0        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUB0I0:1;                                    /* TBTAUB0I0        */
    uint8  MKTAUB0I0:1;                                    /* MKTAUB0I0        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUB0I0:1;                                    /* RFTAUB0I0        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUB0I0:1;                              /* CTTAUB0I0        */
} __type123;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUB0I1:1;                                    /* P0TAUB0I1        */
    uint8  P1TAUB0I1:1;                                    /* P1TAUB0I1        */
    uint8  P2TAUB0I1:1;                                    /* P2TAUB0I1        */
    uint8  P3TAUB0I1:1;                                    /* P3TAUB0I1        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUB0I1:1;                                    /* TBTAUB0I1        */
    uint8  MKTAUB0I1:1;                                    /* MKTAUB0I1        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUB0I1:1;                                    /* RFTAUB0I1        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUB0I1:1;                              /* CTTAUB0I1        */
} __type124;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUB0I2:1;                                    /* P0TAUB0I2        */
    uint8  P1TAUB0I2:1;                                    /* P1TAUB0I2        */
    uint8  P2TAUB0I2:1;                                    /* P2TAUB0I2        */
    uint8  P3TAUB0I2:1;                                    /* P3TAUB0I2        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUB0I2:1;                                    /* TBTAUB0I2        */
    uint8  MKTAUB0I2:1;                                    /* MKTAUB0I2        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUB0I2:1;                                    /* RFTAUB0I2        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUB0I2:1;                              /* CTTAUB0I2        */
} __type125;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUB0I3:1;                                    /* P0TAUB0I3        */
    uint8  P1TAUB0I3:1;                                    /* P1TAUB0I3        */
    uint8  P2TAUB0I3:1;                                    /* P2TAUB0I3        */
    uint8  P3TAUB0I3:1;                                    /* P3TAUB0I3        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUB0I3:1;                                    /* TBTAUB0I3        */
    uint8  MKTAUB0I3:1;                                    /* MKTAUB0I3        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUB0I3:1;                                    /* RFTAUB0I3        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUB0I3:1;                              /* CTTAUB0I3        */
} __type126;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUB0I4:1;                                    /* P0TAUB0I4        */
    uint8  P1TAUB0I4:1;                                    /* P1TAUB0I4        */
    uint8  P2TAUB0I4:1;                                    /* P2TAUB0I4        */
    uint8  P3TAUB0I4:1;                                    /* P3TAUB0I4        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUB0I4:1;                                    /* TBTAUB0I4        */
    uint8  MKTAUB0I4:1;                                    /* MKTAUB0I4        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUB0I4:1;                                    /* RFTAUB0I4        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUB0I4:1;                              /* CTTAUB0I4        */
} __type127;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUB0I5:1;                                    /* P0TAUB0I5        */
    uint8  P1TAUB0I5:1;                                    /* P1TAUB0I5        */
    uint8  P2TAUB0I5:1;                                    /* P2TAUB0I5        */
    uint8  P3TAUB0I5:1;                                    /* P3TAUB0I5        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUB0I5:1;                                    /* TBTAUB0I5        */
    uint8  MKTAUB0I5:1;                                    /* MKTAUB0I5        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUB0I5:1;                                    /* RFTAUB0I5        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUB0I5:1;                              /* CTTAUB0I5        */
} __type128;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUB0I6:1;                                    /* P0TAUB0I6        */
    uint8  P1TAUB0I6:1;                                    /* P1TAUB0I6        */
    uint8  P2TAUB0I6:1;                                    /* P2TAUB0I6        */
    uint8  P3TAUB0I6:1;                                    /* P3TAUB0I6        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUB0I6:1;                                    /* TBTAUB0I6        */
    uint8  MKTAUB0I6:1;                                    /* MKTAUB0I6        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUB0I6:1;                                    /* RFTAUB0I6        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUB0I6:1;                              /* CTTAUB0I6        */
} __type129;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUB0I7:1;                                    /* P0TAUB0I7        */
    uint8  P1TAUB0I7:1;                                    /* P1TAUB0I7        */
    uint8  P2TAUB0I7:1;                                    /* P2TAUB0I7        */
    uint8  P3TAUB0I7:1;                                    /* P3TAUB0I7        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUB0I7:1;                                    /* TBTAUB0I7        */
    uint8  MKTAUB0I7:1;                                    /* MKTAUB0I7        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUB0I7:1;                                    /* RFTAUB0I7        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUB0I7:1;                              /* CTTAUB0I7        */
} __type130;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUB0I8:1;                                    /* P0TAUB0I8        */
    uint8  P1TAUB0I8:1;                                    /* P1TAUB0I8        */
    uint8  P2TAUB0I8:1;                                    /* P2TAUB0I8        */
    uint8  P3TAUB0I8:1;                                    /* P3TAUB0I8        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUB0I8:1;                                    /* TBTAUB0I8        */
    uint8  MKTAUB0I8:1;                                    /* MKTAUB0I8        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUB0I8:1;                                    /* RFTAUB0I8        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUB0I8:1;                              /* CTTAUB0I8        */
} __type131;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUB0I9:1;                                    /* P0TAUB0I9        */
    uint8  P1TAUB0I9:1;                                    /* P1TAUB0I9        */
    uint8  P2TAUB0I9:1;                                    /* P2TAUB0I9        */
    uint8  P3TAUB0I9:1;                                    /* P3TAUB0I9        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUB0I9:1;                                    /* TBTAUB0I9        */
    uint8  MKTAUB0I9:1;                                    /* MKTAUB0I9        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUB0I9:1;                                    /* RFTAUB0I9        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUB0I9:1;                              /* CTTAUB0I9        */
} __type132;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUB0I10:1;                                   /* P0TAUB0I10       */
    uint8  P1TAUB0I10:1;                                   /* P1TAUB0I10       */
    uint8  P2TAUB0I10:1;                                   /* P2TAUB0I10       */
    uint8  P3TAUB0I10:1;                                   /* P3TAUB0I10       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUB0I10:1;                                   /* TBTAUB0I10       */
    uint8  MKTAUB0I10:1;                                   /* MKTAUB0I10       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUB0I10:1;                                   /* RFTAUB0I10       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUB0I10:1;                             /* CTTAUB0I10       */
} __type133;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUB0I11:1;                                   /* P0TAUB0I11       */
    uint8  P1TAUB0I11:1;                                   /* P1TAUB0I11       */
    uint8  P2TAUB0I11:1;                                   /* P2TAUB0I11       */
    uint8  P3TAUB0I11:1;                                   /* P3TAUB0I11       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUB0I11:1;                                   /* TBTAUB0I11       */
    uint8  MKTAUB0I11:1;                                   /* MKTAUB0I11       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUB0I11:1;                                   /* RFTAUB0I11       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUB0I11:1;                             /* CTTAUB0I11       */
} __type134;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUB0I12:1;                                   /* P0TAUB0I12       */
    uint8  P1TAUB0I12:1;                                   /* P1TAUB0I12       */
    uint8  P2TAUB0I12:1;                                   /* P2TAUB0I12       */
    uint8  P3TAUB0I12:1;                                   /* P3TAUB0I12       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUB0I12:1;                                   /* TBTAUB0I12       */
    uint8  MKTAUB0I12:1;                                   /* MKTAUB0I12       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUB0I12:1;                                   /* RFTAUB0I12       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUB0I12:1;                             /* CTTAUB0I12       */
} __type135;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUB0I13:1;                                   /* P0TAUB0I13       */
    uint8  P1TAUB0I13:1;                                   /* P1TAUB0I13       */
    uint8  P2TAUB0I13:1;                                   /* P2TAUB0I13       */
    uint8  P3TAUB0I13:1;                                   /* P3TAUB0I13       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUB0I13:1;                                   /* TBTAUB0I13       */
    uint8  MKTAUB0I13:1;                                   /* MKTAUB0I13       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUB0I13:1;                                   /* RFTAUB0I13       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUB0I13:1;                             /* CTTAUB0I13       */
} __type136;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUB0I14:1;                                   /* P0TAUB0I14       */
    uint8  P1TAUB0I14:1;                                   /* P1TAUB0I14       */
    uint8  P2TAUB0I14:1;                                   /* P2TAUB0I14       */
    uint8  P3TAUB0I14:1;                                   /* P3TAUB0I14       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUB0I14:1;                                   /* TBTAUB0I14       */
    uint8  MKTAUB0I14:1;                                   /* MKTAUB0I14       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUB0I14:1;                                   /* RFTAUB0I14       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUB0I14:1;                             /* CTTAUB0I14       */
} __type137;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUB0I15:1;                                   /* P0TAUB0I15       */
    uint8  P1TAUB0I15:1;                                   /* P1TAUB0I15       */
    uint8  P2TAUB0I15:1;                                   /* P2TAUB0I15       */
    uint8  P3TAUB0I15:1;                                   /* P3TAUB0I15       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUB0I15:1;                                   /* TBTAUB0I15       */
    uint8  MKTAUB0I15:1;                                   /* MKTAUB0I15       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUB0I15:1;                                   /* RFTAUB0I15       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUB0I15:1;                             /* CTTAUB0I15       */
} __type138;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH3IC:1;                                    /* P0CSIH3IC        */
    uint8  P1CSIH3IC:1;                                    /* P1CSIH3IC        */
    uint8  P2CSIH3IC:1;                                    /* P2CSIH3IC        */
    uint8  P3CSIH3IC:1;                                    /* P3CSIH3IC        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH3IC:1;                                    /* TBCSIH3IC        */
    uint8  MKCSIH3IC:1;                                    /* MKCSIH3IC        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH3IC:1;                                    /* RFCSIH3IC        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH3IC:1;                              /* CTCSIH3IC        */
} __type139;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH3IR:1;                                    /* P0CSIH3IR        */
    uint8  P1CSIH3IR:1;                                    /* P1CSIH3IR        */
    uint8  P2CSIH3IR:1;                                    /* P2CSIH3IR        */
    uint8  P3CSIH3IR:1;                                    /* P3CSIH3IR        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH3IR:1;                                    /* TBCSIH3IR        */
    uint8  MKCSIH3IR:1;                                    /* MKCSIH3IR        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH3IR:1;                                    /* RFCSIH3IR        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH3IR:1;                              /* CTCSIH3IR        */
} __type140;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH3IRE:1;                                   /* P0CSIH3IRE       */
    uint8  P1CSIH3IRE:1;                                   /* P1CSIH3IRE       */
    uint8  P2CSIH3IRE:1;                                   /* P2CSIH3IRE       */
    uint8  P3CSIH3IRE:1;                                   /* P3CSIH3IRE       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH3IRE:1;                                   /* TBCSIH3IRE       */
    uint8  MKCSIH3IRE:1;                                   /* MKCSIH3IRE       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH3IRE:1;                                   /* RFCSIH3IRE       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH3IRE:1;                             /* CTCSIH3IRE       */
} __type141;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CSIH3IJC:1;                                   /* P0CSIH3IJC       */
    uint8  P1CSIH3IJC:1;                                   /* P1CSIH3IJC       */
    uint8  P2CSIH3IJC:1;                                   /* P2CSIH3IJC       */
    uint8  P3CSIH3IJC:1;                                   /* P3CSIH3IJC       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCSIH3IJC:1;                                   /* TBCSIH3IJC       */
    uint8  MKCSIH3IJC:1;                                   /* MKCSIH3IJC       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCSIH3IJC:1;                                   /* RFCSIH3IJC       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCSIH3IJC:1;                             /* CTCSIH3IJC       */
} __type142;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RLIN22:1;                                     /* P0RLIN22         */
    uint8  P1RLIN22:1;                                     /* P1RLIN22         */
    uint8  P2RLIN22:1;                                     /* P2RLIN22         */
    uint8  P3RLIN22:1;                                     /* P3RLIN22         */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRLIN22:1;                                     /* TBRLIN22         */
    uint8  MKRLIN22:1;                                     /* MKRLIN22         */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRLIN22:1;                                     /* RFRLIN22         */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRLIN22:1;                               /* CTRLIN22         */
} __type143;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RLIN32:1;                                     /* P0RLIN32         */
    uint8  P1RLIN32:1;                                     /* P1RLIN32         */
    uint8  P2RLIN32:1;                                     /* P2RLIN32         */
    uint8  P3RLIN32:1;                                     /* P3RLIN32         */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRLIN32:1;                                     /* TBRLIN32         */
    uint8  MKRLIN32:1;                                     /* MKRLIN32         */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRLIN32:1;                                     /* RFRLIN32         */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRLIN32:1;                               /* CTRLIN32         */
} __type144;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RLIN32UR0:1;                                  /* P0RLIN32UR0      */
    uint8  P1RLIN32UR0:1;                                  /* P1RLIN32UR0      */
    uint8  P2RLIN32UR0:1;                                  /* P2RLIN32UR0      */
    uint8  P3RLIN32UR0:1;                                  /* P3RLIN32UR0      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRLIN32UR0:1;                                  /* TBRLIN32UR0      */
    uint8  MKRLIN32UR0:1;                                  /* MKRLIN32UR0      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRLIN32UR0:1;                                  /* RFRLIN32UR0      */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRLIN32UR0:1;                            /* CTRLIN32UR0      */
} __type145;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RLIN32UR1:1;                                  /* P0RLIN32UR1      */
    uint8  P1RLIN32UR1:1;                                  /* P1RLIN32UR1      */
    uint8  P2RLIN32UR1:1;                                  /* P2RLIN32UR1      */
    uint8  P3RLIN32UR1:1;                                  /* P3RLIN32UR1      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRLIN32UR1:1;                                  /* TBRLIN32UR1      */
    uint8  MKRLIN32UR1:1;                                  /* MKRLIN32UR1      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRLIN32UR1:1;                                  /* RFRLIN32UR1      */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRLIN32UR1:1;                            /* CTRLIN32UR1      */
} __type146;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RLIN32UR2:1;                                  /* P0RLIN32UR2      */
    uint8  P1RLIN32UR2:1;                                  /* P1RLIN32UR2      */
    uint8  P2RLIN32UR2:1;                                  /* P2RLIN32UR2      */
    uint8  P3RLIN32UR2:1;                                  /* P3RLIN32UR2      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRLIN32UR2:1;                                  /* TBRLIN32UR2      */
    uint8  MKRLIN32UR2:1;                                  /* MKRLIN32UR2      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRLIN32UR2:1;                                  /* RFRLIN32UR2      */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRLIN32UR2:1;                            /* CTRLIN32UR2      */
} __type147;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUJ1I0:1;                                    /* P0TAUJ1I0        */
    uint8  P1TAUJ1I0:1;                                    /* P1TAUJ1I0        */
    uint8  P2TAUJ1I0:1;                                    /* P2TAUJ1I0        */
    uint8  P3TAUJ1I0:1;                                    /* P3TAUJ1I0        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUJ1I0:1;                                    /* TBTAUJ1I0        */
    uint8  MKTAUJ1I0:1;                                    /* MKTAUJ1I0        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUJ1I0:1;                                    /* RFTAUJ1I0        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUJ1I0:1;                              /* CTTAUJ1I0        */
} __type148;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUJ1I1:1;                                    /* P0TAUJ1I1        */
    uint8  P1TAUJ1I1:1;                                    /* P1TAUJ1I1        */
    uint8  P2TAUJ1I1:1;                                    /* P2TAUJ1I1        */
    uint8  P3TAUJ1I1:1;                                    /* P3TAUJ1I1        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUJ1I1:1;                                    /* TBTAUJ1I1        */
    uint8  MKTAUJ1I1:1;                                    /* MKTAUJ1I1        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUJ1I1:1;                                    /* RFTAUJ1I1        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUJ1I1:1;                              /* CTTAUJ1I1        */
} __type149;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUJ1I2:1;                                    /* P0TAUJ1I2        */
    uint8  P1TAUJ1I2:1;                                    /* P1TAUJ1I2        */
    uint8  P2TAUJ1I2:1;                                    /* P2TAUJ1I2        */
    uint8  P3TAUJ1I2:1;                                    /* P3TAUJ1I2        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUJ1I2:1;                                    /* TBTAUJ1I2        */
    uint8  MKTAUJ1I2:1;                                    /* MKTAUJ1I2        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUJ1I2:1;                                    /* RFTAUJ1I2        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUJ1I2:1;                              /* CTTAUJ1I2        */
} __type150;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUJ1I3:1;                                    /* P0TAUJ1I3        */
    uint8  P1TAUJ1I3:1;                                    /* P1TAUJ1I3        */
    uint8  P2TAUJ1I3:1;                                    /* P2TAUJ1I3        */
    uint8  P3TAUJ1I3:1;                                    /* P3TAUJ1I3        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUJ1I3:1;                                    /* TBTAUJ1I3        */
    uint8  MKTAUJ1I3:1;                                    /* MKTAUJ1I3        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUJ1I3:1;                                    /* RFTAUJ1I3        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUJ1I3:1;                              /* CTTAUJ1I3        */
} __type151;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0P13:1;                                        /* P0P13            */
    uint8  P1P13:1;                                        /* P1P13            */
    uint8  P2P13:1;                                        /* P2P13            */
    uint8  P3P13:1;                                        /* P3P13            */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBP13:1;                                        /* TBP13            */
    uint8  MKP13:1;                                        /* MKP13            */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFP13:1;                                        /* RFP13            */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTP13:1;                                  /* CTP13            */
} __type152;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RTCA01S:1;                                    /* P0RTCA01S        */
    uint8  P1RTCA01S:1;                                    /* P1RTCA01S        */
    uint8  P2RTCA01S:1;                                    /* P2RTCA01S        */
    uint8  P3RTCA01S:1;                                    /* P3RTCA01S        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRTCA01S:1;                                    /* TBRTCA01S        */
    uint8  MKRTCA01S:1;                                    /* MKRTCA01S        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRTCA01S:1;                                    /* RFRTCA01S        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRTCA01S:1;                              /* CTRTCA01S        */
} __type153;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RTCA0AL:1;                                    /* P0RTCA0AL        */
    uint8  P1RTCA0AL:1;                                    /* P1RTCA0AL        */
    uint8  P2RTCA0AL:1;                                    /* P2RTCA0AL        */
    uint8  P3RTCA0AL:1;                                    /* P3RTCA0AL        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRTCA0AL:1;                                    /* TBRTCA0AL        */
    uint8  MKRTCA0AL:1;                                    /* MKRTCA0AL        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRTCA0AL:1;                                    /* RFRTCA0AL        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRTCA0AL:1;                              /* CTRTCA0AL        */
} __type154;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RTCA0R:1;                                     /* P0RTCA0R         */
    uint8  P1RTCA0R:1;                                     /* P1RTCA0R         */
    uint8  P2RTCA0R:1;                                     /* P2RTCA0R         */
    uint8  P3RTCA0R:1;                                     /* P3RTCA0R         */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRTCA0R:1;                                     /* TBRTCA0R         */
    uint8  MKRTCA0R:1;                                     /* MKRTCA0R         */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRTCA0R:1;                                     /* RFRTCA0R         */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRTCA0R:1;                               /* CTRTCA0R         */
} __type155;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RCAN2ERR:1;                                   /* P0RCAN2ERR       */
    uint8  P1RCAN2ERR:1;                                   /* P1RCAN2ERR       */
    uint8  P2RCAN2ERR:1;                                   /* P2RCAN2ERR       */
    uint8  P3RCAN2ERR:1;                                   /* P3RCAN2ERR       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRCAN2ERR:1;                                   /* TBRCAN2ERR       */
    uint8  MKRCAN2ERR:1;                                   /* MKRCAN2ERR       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRCAN2ERR:1;                                   /* RFRCAN2ERR       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRCAN2ERR:1;                             /* CTRCAN2ERR       */
} __type156;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RCAN2REC:1;                                   /* P0RCAN2REC       */
    uint8  P1RCAN2REC:1;                                   /* P1RCAN2REC       */
    uint8  P2RCAN2REC:1;                                   /* P2RCAN2REC       */
    uint8  P3RCAN2REC:1;                                   /* P3RCAN2REC       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRCAN2REC:1;                                   /* TBRCAN2REC       */
    uint8  MKRCAN2REC:1;                                   /* MKRCAN2REC       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRCAN2REC:1;                                   /* RFRCAN2REC       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRCAN2REC:1;                             /* CTRCAN2REC       */
} __type157;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RCAN2TRX:1;                                   /* P0RCAN2TRX       */
    uint8  P1RCAN2TRX:1;                                   /* P1RCAN2TRX       */
    uint8  P2RCAN2TRX:1;                                   /* P2RCAN2TRX       */
    uint8  P3RCAN2TRX:1;                                   /* P3RCAN2TRX       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRCAN2TRX:1;                                   /* TBRCAN2TRX       */
    uint8  MKRCAN2TRX:1;                                   /* MKRCAN2TRX       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRCAN2TRX:1;                                   /* RFRCAN2TRX       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRCAN2TRX:1;                             /* CTRCAN2TRX       */
} __type158;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RCAN3ERR:1;                                   /* P0RCAN3ERR       */
    uint8  P1RCAN3ERR:1;                                   /* P1RCAN3ERR       */
    uint8  P2RCAN3ERR:1;                                   /* P2RCAN3ERR       */
    uint8  P3RCAN3ERR:1;                                   /* P3RCAN3ERR       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRCAN3ERR:1;                                   /* TBRCAN3ERR       */
    uint8  MKRCAN3ERR:1;                                   /* MKRCAN3ERR       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRCAN3ERR:1;                                   /* RFRCAN3ERR       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRCAN3ERR:1;                             /* CTRCAN3ERR       */
} __type159;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RCAN3REC:1;                                   /* P0RCAN3REC       */
    uint8  P1RCAN3REC:1;                                   /* P1RCAN3REC       */
    uint8  P2RCAN3REC:1;                                   /* P2RCAN3REC       */
    uint8  P3RCAN3REC:1;                                   /* P3RCAN3REC       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRCAN3REC:1;                                   /* TBRCAN3REC       */
    uint8  MKRCAN3REC:1;                                   /* MKRCAN3REC       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRCAN3REC:1;                                   /* RFRCAN3REC       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRCAN3REC:1;                             /* CTRCAN3REC       */
} __type160;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RCAN3TRX:1;                                   /* P0RCAN3TRX       */
    uint8  P1RCAN3TRX:1;                                   /* P1RCAN3TRX       */
    uint8  P2RCAN3TRX:1;                                   /* P2RCAN3TRX       */
    uint8  P3RCAN3TRX:1;                                   /* P3RCAN3TRX       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRCAN3TRX:1;                                   /* TBRCAN3TRX       */
    uint8  MKRCAN3TRX:1;                                   /* MKRCAN3TRX       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRCAN3TRX:1;                                   /* RFRCAN3TRX       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRCAN3TRX:1;                             /* CTRCAN3TRX       */
} __type161;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RLIN33:1;                                     /* P0RLIN33         */
    uint8  P1RLIN33:1;                                     /* P1RLIN33         */
    uint8  P2RLIN33:1;                                     /* P2RLIN33         */
    uint8  P3RLIN33:1;                                     /* P3RLIN33         */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRLIN33:1;                                     /* TBRLIN33         */
    uint8  MKRLIN33:1;                                     /* MKRLIN33         */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRLIN33:1;                                     /* RFRLIN33         */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRLIN33:1;                               /* CTRLIN33         */
} __type162;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RLIN33UR0:1;                                  /* P0RLIN33UR0      */
    uint8  P1RLIN33UR0:1;                                  /* P1RLIN33UR0      */
    uint8  P2RLIN33UR0:1;                                  /* P2RLIN33UR0      */
    uint8  P3RLIN33UR0:1;                                  /* P3RLIN33UR0      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRLIN33UR0:1;                                  /* TBRLIN33UR0      */
    uint8  MKRLIN33UR0:1;                                  /* MKRLIN33UR0      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRLIN33UR0:1;                                  /* RFRLIN33UR0      */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRLIN33UR0:1;                            /* CTRLIN33UR0      */
} __type163;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RLIN33UR1:1;                                  /* P0RLIN33UR1      */
    uint8  P1RLIN33UR1:1;                                  /* P1RLIN33UR1      */
    uint8  P2RLIN33UR1:1;                                  /* P2RLIN33UR1      */
    uint8  P3RLIN33UR1:1;                                  /* P3RLIN33UR1      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRLIN33UR1:1;                                  /* TBRLIN33UR1      */
    uint8  MKRLIN33UR1:1;                                  /* MKRLIN33UR1      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRLIN33UR1:1;                                  /* RFRLIN33UR1      */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRLIN33UR1:1;                            /* CTRLIN33UR1      */
} __type164;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RLIN33UR2:1;                                  /* P0RLIN33UR2      */
    uint8  P1RLIN33UR2:1;                                  /* P1RLIN33UR2      */
    uint8  P2RLIN33UR2:1;                                  /* P2RLIN33UR2      */
    uint8  P3RLIN33UR2:1;                                  /* P3RLIN33UR2      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRLIN33UR2:1;                                  /* TBRLIN33UR2      */
    uint8  MKRLIN33UR2:1;                                  /* MKRLIN33UR2      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRLIN33UR2:1;                                  /* RFRLIN33UR2      */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRLIN33UR2:1;                            /* CTRLIN33UR2      */
} __type165;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RIIC1TI:1;                                    /* P0RIIC1TI        */
    uint8  P1RIIC1TI:1;                                    /* P1RIIC1TI        */
    uint8  P2RIIC1TI:1;                                    /* P2RIIC1TI        */
    uint8  P3RIIC1TI:1;                                    /* P3RIIC1TI        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRIIC1TI:1;                                    /* TBRIIC1TI        */
    uint8  MKRIIC1TI:1;                                    /* MKRIIC1TI        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRIIC1TI:1;                                    /* RFRIIC1TI        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRIIC1TI:1;                              /* CTRIIC1TI        */
} __type166;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RIIC1EE:1;                                    /* P0RIIC1EE        */
    uint8  P1RIIC1EE:1;                                    /* P1RIIC1EE        */
    uint8  P2RIIC1EE:1;                                    /* P2RIIC1EE        */
    uint8  P3RIIC1EE:1;                                    /* P3RIIC1EE        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRIIC1EE:1;                                    /* TBRIIC1EE        */
    uint8  MKRIIC1EE:1;                                    /* MKRIIC1EE        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRIIC1EE:1;                                    /* RFRIIC1EE        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRIIC1EE:1;                              /* CTRIIC1EE        */
} __type167;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RIIC1RI:1;                                    /* P0RIIC1RI        */
    uint8  P1RIIC1RI:1;                                    /* P1RIIC1RI        */
    uint8  P2RIIC1RI:1;                                    /* P2RIIC1RI        */
    uint8  P3RIIC1RI:1;                                    /* P3RIIC1RI        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRIIC1RI:1;                                    /* TBRIIC1RI        */
    uint8  MKRIIC1RI:1;                                    /* MKRIIC1RI        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRIIC1RI:1;                                    /* RFRIIC1RI        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRIIC1RI:1;                              /* CTRIIC1RI        */
} __type168;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RIIC1TEI:1;                                   /* P0RIIC1TEI       */
    uint8  P1RIIC1TEI:1;                                   /* P1RIIC1TEI       */
    uint8  P2RIIC1TEI:1;                                   /* P2RIIC1TEI       */
    uint8  P3RIIC1TEI:1;                                   /* P3RIIC1TEI       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRIIC1TEI:1;                                   /* TBRIIC1TEI       */
    uint8  MKRIIC1TEI:1;                                   /* MKRIIC1TEI       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRIIC1TEI:1;                                   /* RFRIIC1TEI       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRIIC1TEI:1;                             /* CTRIIC1TEI       */
} __type169;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RCAN4ERR:1;                                   /* P0RCAN4ERR       */
    uint8  P1RCAN4ERR:1;                                   /* P1RCAN4ERR       */
    uint8  P2RCAN4ERR:1;                                   /* P2RCAN4ERR       */
    uint8  P3RCAN4ERR:1;                                   /* P3RCAN4ERR       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRCAN4ERR:1;                                   /* TBRCAN4ERR       */
    uint8  MKRCAN4ERR:1;                                   /* MKRCAN4ERR       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRCAN4ERR:1;                                   /* RFRCAN4ERR       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRCAN4ERR:1;                             /* CTRCAN4ERR       */
} __type170;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RCAN4REC:1;                                   /* P0RCAN4REC       */
    uint8  P1RCAN4REC:1;                                   /* P1RCAN4REC       */
    uint8  P2RCAN4REC:1;                                   /* P2RCAN4REC       */
    uint8  P3RCAN4REC:1;                                   /* P3RCAN4REC       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRCAN4REC:1;                                   /* TBRCAN4REC       */
    uint8  MKRCAN4REC:1;                                   /* MKRCAN4REC       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRCAN4REC:1;                                   /* RFRCAN4REC       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRCAN4REC:1;                             /* CTRCAN4REC       */
} __type171;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RCAN4TRX:1;                                   /* P0RCAN4TRX       */
    uint8  P1RCAN4TRX:1;                                   /* P1RCAN4TRX       */
    uint8  P2RCAN4TRX:1;                                   /* P2RCAN4TRX       */
    uint8  P3RCAN4TRX:1;                                   /* P3RCAN4TRX       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRCAN4TRX:1;                                   /* TBRCAN4TRX       */
    uint8  MKRCAN4TRX:1;                                   /* MKRCAN4TRX       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRCAN4TRX:1;                                   /* RFRCAN4TRX       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRCAN4TRX:1;                             /* CTRCAN4TRX       */
} __type172;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUJ2I0:1;                                    /* P0TAUJ2I0        */
    uint8  P1TAUJ2I0:1;                                    /* P1TAUJ2I0        */
    uint8  P2TAUJ2I0:1;                                    /* P2TAUJ2I0        */
    uint8  P3TAUJ2I0:1;                                    /* P3TAUJ2I0        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUJ2I0:1;                                    /* TBTAUJ2I0        */
    uint8  MKTAUJ2I0:1;                                    /* MKTAUJ2I0        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUJ2I0:1;                                    /* RFTAUJ2I0        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUJ2I0:1;                              /* CTTAUJ2I0        */
} __type173;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUJ2I1:1;                                    /* P0TAUJ2I1        */
    uint8  P1TAUJ2I1:1;                                    /* P1TAUJ2I1        */
    uint8  P2TAUJ2I1:1;                                    /* P2TAUJ2I1        */
    uint8  P3TAUJ2I1:1;                                    /* P3TAUJ2I1        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUJ2I1:1;                                    /* TBTAUJ2I1        */
    uint8  MKTAUJ2I1:1;                                    /* MKTAUJ2I1        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUJ2I1:1;                                    /* RFTAUJ2I1        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUJ2I1:1;                              /* CTTAUJ2I1        */
} __type174;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUJ2I2:1;                                    /* P0TAUJ2I2        */
    uint8  P1TAUJ2I2:1;                                    /* P1TAUJ2I2        */
    uint8  P2TAUJ2I2:1;                                    /* P2TAUJ2I2        */
    uint8  P3TAUJ2I2:1;                                    /* P3TAUJ2I2        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUJ2I2:1;                                    /* TBTAUJ2I2        */
    uint8  MKTAUJ2I2:1;                                    /* MKTAUJ2I2        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUJ2I2:1;                                    /* RFTAUJ2I2        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUJ2I2:1;                              /* CTTAUJ2I2        */
} __type175;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUJ2I3:1;                                    /* P0TAUJ2I3        */
    uint8  P1TAUJ2I3:1;                                    /* P1TAUJ2I3        */
    uint8  P2TAUJ2I3:1;                                    /* P2TAUJ2I3        */
    uint8  P3TAUJ2I3:1;                                    /* P3TAUJ2I3        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUJ2I3:1;                                    /* TBTAUJ2I3        */
    uint8  MKTAUJ2I3:1;                                    /* MKTAUJ2I3        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUJ2I3:1;                                    /* RFTAUJ2I3        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUJ2I3:1;                              /* CTTAUJ2I3        */
} __type176;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUJ3I0:1;                                    /* P0TAUJ3I0        */
    uint8  P1TAUJ3I0:1;                                    /* P1TAUJ3I0        */
    uint8  P2TAUJ3I0:1;                                    /* P2TAUJ3I0        */
    uint8  P3TAUJ3I0:1;                                    /* P3TAUJ3I0        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUJ3I0:1;                                    /* TBTAUJ3I0        */
    uint8  MKTAUJ3I0:1;                                    /* MKTAUJ3I0        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUJ3I0:1;                                    /* RFTAUJ3I0        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUJ3I0:1;                              /* CTTAUJ3I0        */
} __type177;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUJ3I1:1;                                    /* P0TAUJ3I1        */
    uint8  P1TAUJ3I1:1;                                    /* P1TAUJ3I1        */
    uint8  P2TAUJ3I1:1;                                    /* P2TAUJ3I1        */
    uint8  P3TAUJ3I1:1;                                    /* P3TAUJ3I1        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUJ3I1:1;                                    /* TBTAUJ3I1        */
    uint8  MKTAUJ3I1:1;                                    /* MKTAUJ3I1        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUJ3I1:1;                                    /* RFTAUJ3I1        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUJ3I1:1;                              /* CTTAUJ3I1        */
} __type178;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUJ3I2:1;                                    /* P0TAUJ3I2        */
    uint8  P1TAUJ3I2:1;                                    /* P1TAUJ3I2        */
    uint8  P2TAUJ3I2:1;                                    /* P2TAUJ3I2        */
    uint8  P3TAUJ3I2:1;                                    /* P3TAUJ3I2        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUJ3I2:1;                                    /* TBTAUJ3I2        */
    uint8  MKTAUJ3I2:1;                                    /* MKTAUJ3I2        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUJ3I2:1;                                    /* RFTAUJ3I2        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUJ3I2:1;                              /* CTTAUJ3I2        */
} __type179;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0TAUJ3I3:1;                                    /* P0TAUJ3I3        */
    uint8  P1TAUJ3I3:1;                                    /* P1TAUJ3I3        */
    uint8  P2TAUJ3I3:1;                                    /* P2TAUJ3I3        */
    uint8  P3TAUJ3I3:1;                                    /* P3TAUJ3I3        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBTAUJ3I3:1;                                    /* TBTAUJ3I3        */
    uint8  MKTAUJ3I3:1;                                    /* MKTAUJ3I3        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFTAUJ3I3:1;                                    /* RFTAUJ3I3        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTTAUJ3I3:1;                              /* CTTAUJ3I3        */
} __type180;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RCAN5ERR:1;                                   /* P0RCAN5ERR       */
    uint8  P1RCAN5ERR:1;                                   /* P1RCAN5ERR       */
    uint8  P2RCAN5ERR:1;                                   /* P2RCAN5ERR       */
    uint8  P3RCAN5ERR:1;                                   /* P3RCAN5ERR       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRCAN5ERR:1;                                   /* TBRCAN5ERR       */
    uint8  MKRCAN5ERR:1;                                   /* MKRCAN5ERR       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRCAN5ERR:1;                                   /* RFRCAN5ERR       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRCAN5ERR:1;                             /* CTRCAN5ERR       */
} __type181;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RCAN5REC:1;                                   /* P0RCAN5REC       */
    uint8  P1RCAN5REC:1;                                   /* P1RCAN5REC       */
    uint8  P2RCAN5REC:1;                                   /* P2RCAN5REC       */
    uint8  P3RCAN5REC:1;                                   /* P3RCAN5REC       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRCAN5REC:1;                                   /* TBRCAN5REC       */
    uint8  MKRCAN5REC:1;                                   /* MKRCAN5REC       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRCAN5REC:1;                                   /* RFRCAN5REC       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRCAN5REC:1;                             /* CTRCAN5REC       */
} __type182;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0RCAN5TRX:1;                                   /* P0RCAN5TRX       */
    uint8  P1RCAN5TRX:1;                                   /* P1RCAN5TRX       */
    uint8  P2RCAN5TRX:1;                                   /* P2RCAN5TRX       */
    uint8  P3RCAN5TRX:1;                                   /* P3RCAN5TRX       */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBRCAN5TRX:1;                                   /* TBRCAN5TRX       */
    uint8  MKRCAN5TRX:1;                                   /* MKRCAN5TRX       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFRCAN5TRX:1;                                   /* RFRCAN5TRX       */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTRCAN5TRX:1;                             /* CTRCAN5TRX       */
} __type183;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CXP10TI:1;                                    /* P0CXP10TI        */
    uint8  P1CXP10TI:1;                                    /* P1CXP10TI        */
    uint8  P2CXP10TI:1;                                    /* P2CXP10TI        */
    uint8  P3CXP10TI:1;                                    /* P3CXP10TI        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCXP10TI:1;                                    /* TBCXP10TI        */
    uint8  MKCXP10TI:1;                                    /* MKCXP10TI        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCXP10TI:1;                                    /* RFCXP10TI        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCXP10TI:1;                              /* CTCXP10TI        */
} __type184;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CXP10RI:1;                                    /* P0CXP10RI        */
    uint8  P1CXP10RI:1;                                    /* P1CXP10RI        */
    uint8  P2CXP10RI:1;                                    /* P2CXP10RI        */
    uint8  P3CXP10RI:1;                                    /* P3CXP10RI        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCXP10RI:1;                                    /* TBCXP10RI        */
    uint8  MKCXP10RI:1;                                    /* MKCXP10RI        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCXP10RI:1;                                    /* RFCXP10RI        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCXP10RI:1;                              /* CTCXP10RI        */
} __type185;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CXP10SI:1;                                    /* P0CXP10SI        */
    uint8  P1CXP10SI:1;                                    /* P1CXP10SI        */
    uint8  P2CXP10SI:1;                                    /* P2CXP10SI        */
    uint8  P3CXP10SI:1;                                    /* P3CXP10SI        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCXP10SI:1;                                    /* TBCXP10SI        */
    uint8  MKCXP10SI:1;                                    /* MKCXP10SI        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCXP10SI:1;                                    /* RFCXP10SI        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCXP10SI:1;                              /* CTCXP10SI        */
} __type186;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CXP11TI:1;                                    /* P0CXP11TI        */
    uint8  P1CXP11TI:1;                                    /* P1CXP11TI        */
    uint8  P2CXP11TI:1;                                    /* P2CXP11TI        */
    uint8  P3CXP11TI:1;                                    /* P3CXP11TI        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCXP11TI:1;                                    /* TBCXP11TI        */
    uint8  MKCXP11TI:1;                                    /* MKCXP11TI        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCXP11TI:1;                                    /* RFCXP11TI        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCXP11TI:1;                              /* CTCXP11TI        */
} __type187;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CXP11RI:1;                                    /* P0CXP11RI        */
    uint8  P1CXP11RI:1;                                    /* P1CXP11RI        */
    uint8  P2CXP11RI:1;                                    /* P2CXP11RI        */
    uint8  P3CXP11RI:1;                                    /* P3CXP11RI        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCXP11RI:1;                                    /* TBCXP11RI        */
    uint8  MKCXP11RI:1;                                    /* MKCXP11RI        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCXP11RI:1;                                    /* RFCXP11RI        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCXP11RI:1;                              /* CTCXP11RI        */
} __type188;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CXP11SI:1;                                    /* P0CXP11SI        */
    uint8  P1CXP11SI:1;                                    /* P1CXP11SI        */
    uint8  P2CXP11SI:1;                                    /* P2CXP11SI        */
    uint8  P3CXP11SI:1;                                    /* P3CXP11SI        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCXP11SI:1;                                    /* TBCXP11SI        */
    uint8  MKCXP11SI:1;                                    /* MKCXP11SI        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCXP11SI:1;                                    /* RFCXP11SI        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCXP11SI:1;                              /* CTCXP11SI        */
} __type189;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CXP12TI:1;                                    /* P0CXP12TI        */
    uint8  P1CXP12TI:1;                                    /* P1CXP12TI        */
    uint8  P2CXP12TI:1;                                    /* P2CXP12TI        */
    uint8  P3CXP12TI:1;                                    /* P3CXP12TI        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCXP12TI:1;                                    /* TBCXP12TI        */
    uint8  MKCXP12TI:1;                                    /* MKCXP12TI        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCXP12TI:1;                                    /* RFCXP12TI        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCXP12TI:1;                              /* CTCXP12TI        */
} __type190;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CXP12RI:1;                                    /* P0CXP12RI        */
    uint8  P1CXP12RI:1;                                    /* P1CXP12RI        */
    uint8  P2CXP12RI:1;                                    /* P2CXP12RI        */
    uint8  P3CXP12RI:1;                                    /* P3CXP12RI        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCXP12RI:1;                                    /* TBCXP12RI        */
    uint8  MKCXP12RI:1;                                    /* MKCXP12RI        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCXP12RI:1;                                    /* RFCXP12RI        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCXP12RI:1;                              /* CTCXP12RI        */
} __type191;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0CXP12SI:1;                                    /* P0CXP12SI        */
    uint8  P1CXP12SI:1;                                    /* P1CXP12SI        */
    uint8  P2CXP12SI:1;                                    /* P2CXP12SI        */
    uint8  P3CXP12SI:1;                                    /* P3CXP12SI        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBCXP12SI:1;                                    /* TBCXP12SI        */
    uint8  MKCXP12SI:1;                                    /* MKCXP12SI        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFCXP12SI:1;                                    /* RFCXP12SI        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTCXP12SI:1;                              /* CTCXP12SI        */
} __type192;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0SENT0SI:1;                                    /* P0SENT0SI        */
    uint8  P1SENT0SI:1;                                    /* P1SENT0SI        */
    uint8  P2SENT0SI:1;                                    /* P2SENT0SI        */
    uint8  P3SENT0SI:1;                                    /* P3SENT0SI        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBSENT0SI:1;                                    /* TBSENT0SI        */
    uint8  MKSENT0SI:1;                                    /* MKSENT0SI        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFSENT0SI:1;                                    /* RFSENT0SI        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTSENT0SI:1;                              /* CTSENT0SI        */
} __type193;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0SENT0RI:1;                                    /* P0SENT0RI        */
    uint8  P1SENT0RI:1;                                    /* P1SENT0RI        */
    uint8  P2SENT0RI:1;                                    /* P2SENT0RI        */
    uint8  P3SENT0RI:1;                                    /* P3SENT0RI        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBSENT0RI:1;                                    /* TBSENT0RI        */
    uint8  MKSENT0RI:1;                                    /* MKSENT0RI        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFSENT0RI:1;                                    /* RFSENT0RI        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTSENT0RI:1;                              /* CTSENT0RI        */
} __type194;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0SENT1SI:1;                                    /* P0SENT1SI        */
    uint8  P1SENT1SI:1;                                    /* P1SENT1SI        */
    uint8  P2SENT1SI:1;                                    /* P2SENT1SI        */
    uint8  P3SENT1SI:1;                                    /* P3SENT1SI        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBSENT1SI:1;                                    /* TBSENT1SI        */
    uint8  MKSENT1SI:1;                                    /* MKSENT1SI        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFSENT1SI:1;                                    /* RFSENT1SI        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTSENT1SI:1;                              /* CTSENT1SI        */
} __type195;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0SENT1RI:1;                                    /* P0SENT1RI        */
    uint8  P1SENT1RI:1;                                    /* P1SENT1RI        */
    uint8  P2SENT1RI:1;                                    /* P2SENT1RI        */
    uint8  P3SENT1RI:1;                                    /* P3SENT1RI        */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBSENT1RI:1;                                    /* TBSENT1RI        */
    uint8  MKSENT1RI:1;                                    /* MKSENT1RI        */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFSENT1RI:1;                                    /* RFSENT1RI        */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTSENT1RI:1;                              /* CTSENT1RI        */
} __type196;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0DPE:1;                                        /* P0DPE            */
    uint8  P1DPE:1;                                        /* P1DPE            */
    uint8  P2DPE:1;                                        /* P2DPE            */
    uint8  P3DPE:1;                                        /* P3DPE            */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBDPE:1;                                        /* TBDPE            */
    uint8  MKDPE:1;                                        /* MKDPE            */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFDPE:1;                                        /* RFDPE            */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTDPE:1;                                  /* CTDPE            */
} __type197;
typedef struct 
{                                                          /* Bit Access       */
    uint8  P0APE:1;                                        /* P0APE            */
    uint8  P1APE:1;                                        /* P1APE            */
    uint8  P2APE:1;                                        /* P2APE            */
    uint8  P3APE:1;                                        /* P3APE            */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  TBAPE:1;                                        /* TBAPE            */
    uint8  MKAPE:1;                                        /* MKAPE            */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  RFAPE:1;                                        /* RFAPE            */
    uint8  :2;                                             /* Reserved Bits    */
    const uint8  CTAPE:1;                                  /* CTAPE            */
} __type198;
typedef struct 
{                                                          /* Bit Access       */
    uint8  IMR1EIMK32:1;                                   /* IMR1EIMK32       */
    uint8  IMR1EIMK33:1;                                   /* IMR1EIMK33       */
    uint8  IMR1EIMK34:1;                                   /* IMR1EIMK34       */
    uint8  IMR1EIMK35:1;                                   /* IMR1EIMK35       */
    uint8  IMR1EIMK36:1;                                   /* IMR1EIMK36       */
    uint8  IMR1EIMK37:1;                                   /* IMR1EIMK37       */
    uint8  IMR1EIMK38:1;                                   /* IMR1EIMK38       */
    uint8  IMR1EIMK39:1;                                   /* IMR1EIMK39       */
    uint8  IMR1EIMK40:1;                                   /* IMR1EIMK40       */
    uint8  IMR1EIMK41:1;                                   /* IMR1EIMK41       */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  IMR1EIMK43:1;                                   /* IMR1EIMK43       */
    uint8  IMR1EIMK44:1;                                   /* IMR1EIMK44       */
    uint8  IMR1EIMK45:1;                                   /* IMR1EIMK45       */
    uint8  IMR1EIMK46:1;                                   /* IMR1EIMK46       */
    uint8  IMR1EIMK47:1;                                   /* IMR1EIMK47       */
    uint8  IMR1EIMK48:1;                                   /* IMR1EIMK48       */
    uint8  IMR1EIMK49:1;                                   /* IMR1EIMK49       */
    uint8  IMR1EIMK50:1;                                   /* IMR1EIMK50       */
    uint8  IMR1EIMK51:1;                                   /* IMR1EIMK51       */
    uint8  IMR1EIMK52:1;                                   /* IMR1EIMK52       */
    uint8  IMR1EIMK53:1;                                   /* IMR1EIMK53       */
    uint8  IMR1EIMK54:1;                                   /* IMR1EIMK54       */
    uint8  IMR1EIMK55:1;                                   /* IMR1EIMK55       */
    uint8  IMR1EIMK56:1;                                   /* IMR1EIMK56       */
    uint8  IMR1EIMK57:1;                                   /* IMR1EIMK57       */
    uint8  IMR1EIMK58:1;                                   /* IMR1EIMK58       */
    uint8  IMR1EIMK59:1;                                   /* IMR1EIMK59       */
    uint8  IMR1EIMK60:1;                                   /* IMR1EIMK60       */
    uint8  IMR1EIMK61:1;                                   /* IMR1EIMK61       */
    uint8  IMR1EIMK62:1;                                   /* IMR1EIMK62       */
    uint8  IMR1EIMK63:1;                                   /* IMR1EIMK63       */
} __type199;
typedef struct 
{                                                          /* Bit Access       */
    uint8  IMR2EIMK64:1;                                   /* IMR2EIMK64       */
    uint8  IMR2EIMK65:1;                                   /* IMR2EIMK65       */
    uint8  IMR2EIMK66:1;                                   /* IMR2EIMK66       */
    uint8  IMR2EIMK67:1;                                   /* IMR2EIMK67       */
    uint8  IMR2EIMK68:1;                                   /* IMR2EIMK68       */
    uint8  IMR2EIMK69:1;                                   /* IMR2EIMK69       */
    uint8  IMR2EIMK70:1;                                   /* IMR2EIMK70       */
    uint8  IMR2EIMK71:1;                                   /* IMR2EIMK71       */
    uint8  IMR2EIMK72:1;                                   /* IMR2EIMK72       */
    uint8  IMR2EIMK73:1;                                   /* IMR2EIMK73       */
    uint8  IMR2EIMK74:1;                                   /* IMR2EIMK74       */
    uint8  IMR2EIMK75:1;                                   /* IMR2EIMK75       */
    uint8  IMR2EIMK76:1;                                   /* IMR2EIMK76       */
    uint8  IMR2EIMK77:1;                                   /* IMR2EIMK77       */
    uint8  IMR2EIMK78:1;                                   /* IMR2EIMK78       */
    uint8  IMR2EIMK79:1;                                   /* IMR2EIMK79       */
    uint8  IMR2EIMK80:1;                                   /* IMR2EIMK80       */
    uint8  IMR2EIMK81:1;                                   /* IMR2EIMK81       */
    uint8  IMR2EIMK82:1;                                   /* IMR2EIMK82       */
    uint8  IMR2EIMK83:1;                                   /* IMR2EIMK83       */
    uint8  IMR2EIMK84:1;                                   /* IMR2EIMK84       */
    uint8  IMR2EIMK85:1;                                   /* IMR2EIMK85       */
    uint8  IMR2EIMK86:1;                                   /* IMR2EIMK86       */
    uint8  IMR2EIMK87:1;                                   /* IMR2EIMK87       */
    uint8  IMR2EIMK88:1;                                   /* IMR2EIMK88       */
    uint8  IMR2EIMK89:1;                                   /* IMR2EIMK89       */
    uint8  IMR2EIMK90:1;                                   /* IMR2EIMK90       */
    uint8  IMR2EIMK91:1;                                   /* IMR2EIMK91       */
    uint8  IMR2EIMK92:1;                                   /* IMR2EIMK92       */
    uint8  IMR2EIMK93:1;                                   /* IMR2EIMK93       */
    uint8  :2;                                             /* Reserved Bits    */
} __type200;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  IMR3EIMK110:1;                                  /* IMR3EIMK110      */
    uint8  IMR3EIMK111:1;                                  /* IMR3EIMK111      */
    uint8  IMR3EIMK112:1;                                  /* IMR3EIMK112      */
    uint8  IMR3EIMK113:1;                                  /* IMR3EIMK113      */
    uint8  IMR3EIMK114:1;                                  /* IMR3EIMK114      */
    uint8  IMR3EIMK115:1;                                  /* IMR3EIMK115      */
    uint8  IMR3EIMK116:1;                                  /* IMR3EIMK116      */
    uint8  IMR3EIMK117:1;                                  /* IMR3EIMK117      */
    uint8  IMR3EIMK118:1;                                  /* IMR3EIMK118      */
    uint8  IMR3EIMK119:1;                                  /* IMR3EIMK119      */
    uint8  IMR3EIMK120:1;                                  /* IMR3EIMK120      */
    uint8  IMR3EIMK121:1;                                  /* IMR3EIMK121      */
    uint8  IMR3EIMK122:1;                                  /* IMR3EIMK122      */
    uint8  IMR3EIMK123:1;                                  /* IMR3EIMK123      */
    uint8  :4;                                             /* Reserved Bits    */
} __type201;
typedef struct 
{                                                          /* Bit Access       */
    uint8  IMR4EIMK128:1;                                  /* IMR4EIMK128      */
    uint8  IMR4EIMK129:1;                                  /* IMR4EIMK129      */
    uint8  IMR4EIMK130:1;                                  /* IMR4EIMK130      */
    uint8  IMR4EIMK131:1;                                  /* IMR4EIMK131      */
    uint8  IMR4EIMK132:1;                                  /* IMR4EIMK132      */
    uint8  IMR4EIMK133:1;                                  /* IMR4EIMK133      */
    uint8  IMR4EIMK134:1;                                  /* IMR4EIMK134      */
    uint8  IMR4EIMK135:1;                                  /* IMR4EIMK135      */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  IMR4EIMK142:1;                                  /* IMR4EIMK142      */
    uint8  IMR4EIMK143:1;                                  /* IMR4EIMK143      */
    uint8  IMR4EIMK144:1;                                  /* IMR4EIMK144      */
    uint8  IMR4EIMK145:1;                                  /* IMR4EIMK145      */
    uint8  IMR4EIMK146:1;                                  /* IMR4EIMK146      */
    uint8  IMR4EIMK147:1;                                  /* IMR4EIMK147      */
    uint8  IMR4EIMK148:1;                                  /* IMR4EIMK148      */
    uint8  IMR4EIMK149:1;                                  /* IMR4EIMK149      */
    uint8  IMR4EIMK150:1;                                  /* IMR4EIMK150      */
    uint8  IMR4EIMK151:1;                                  /* IMR4EIMK151      */
    uint8  IMR4EIMK152:1;                                  /* IMR4EIMK152      */
    uint8  IMR4EIMK153:1;                                  /* IMR4EIMK153      */
    uint8  IMR4EIMK154:1;                                  /* IMR4EIMK154      */
    uint8  IMR4EIMK155:1;                                  /* IMR4EIMK155      */
    uint8  IMR4EIMK156:1;                                  /* IMR4EIMK156      */
    uint8  IMR4EIMK157:1;                                  /* IMR4EIMK157      */
    uint8  IMR4EIMK158:1;                                  /* IMR4EIMK158      */
    uint8  IMR4EIMK159:1;                                  /* IMR4EIMK159      */
} __type202;
typedef struct 
{                                                          /* Bit Access       */
    uint8  IMR5EIMK160:1;                                  /* IMR5EIMK160      */
    uint8  IMR5EIMK161:1;                                  /* IMR5EIMK161      */
    uint8  IMR5EIMK162:1;                                  /* IMR5EIMK162      */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  IMR5EIMK164:1;                                  /* IMR5EIMK164      */
    uint8  IMR5EIMK165:1;                                  /* IMR5EIMK165      */
    uint8  IMR5EIMK166:1;                                  /* IMR5EIMK166      */
    uint8  IMR5EIMK167:1;                                  /* IMR5EIMK167      */
    uint8  IMR5EIMK168:1;                                  /* IMR5EIMK168      */
    uint8  IMR5EIMK169:1;                                  /* IMR5EIMK169      */
    uint8  IMR5EIMK170:1;                                  /* IMR5EIMK170      */
    uint8  IMR5EIMK171:1;                                  /* IMR5EIMK171      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type203;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  IMR6EIMK206:1;                                  /* IMR6EIMK206      */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  IMR6EIMK209:1;                                  /* IMR6EIMK209      */
    uint8  IMR6EIMK210:1;                                  /* IMR6EIMK210      */
    uint8  IMR6EIMK211:1;                                  /* IMR6EIMK211      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  :1;                                             /* Reserved Bits    */
    uint8  IMR6EIMK217:1;                                  /* IMR6EIMK217      */
    uint8  IMR6EIMK218:1;                                  /* IMR6EIMK218      */
    uint8  IMR6EIMK219:1;                                  /* IMR6EIMK219      */
    uint8  IMR6EIMK220:1;                                  /* IMR6EIMK220      */
    uint8  IMR6EIMK221:1;                                  /* IMR6EIMK221      */
    uint8  IMR6EIMK222:1;                                  /* IMR6EIMK222      */
    uint8  :1;                                             /* Reserved Bits    */
} __type204;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  IMR7EIMK228:1;                                  /* IMR7EIMK228      */
    uint8  IMR7EIMK229:1;                                  /* IMR7EIMK229      */
    uint8  IMR7EIMK230:1;                                  /* IMR7EIMK230      */
    uint8  IMR7EIMK231:1;                                  /* IMR7EIMK231      */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  IMR7EIMK240:1;                                  /* IMR7EIMK240      */
    uint8  IMR7EIMK241:1;                                  /* IMR7EIMK241      */
    uint8  IMR7EIMK242:1;                                  /* IMR7EIMK242      */
    uint8  IMR7EIMK243:1;                                  /* IMR7EIMK243      */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type205;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  IMR8EIMK272:1;                                  /* IMR8EIMK272      */
    uint8  IMR8EIMK273:1;                                  /* IMR8EIMK273      */
    uint8  IMR8EIMK274:1;                                  /* IMR8EIMK274      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  IMR8EIMK277:1;                                  /* IMR8EIMK277      */
    uint8  IMR8EIMK278:1;                                  /* IMR8EIMK278      */
    uint8  IMR8EIMK279:1;                                  /* IMR8EIMK279      */
    uint8  IMR8EIMK280:1;                                  /* IMR8EIMK280      */
    uint8  IMR8EIMK281:1;                                  /* IMR8EIMK281      */
    uint8  IMR8EIMK282:1;                                  /* IMR8EIMK282      */
    uint8  IMR8EIMK283:1;                                  /* IMR8EIMK283      */
    uint8  IMR8EIMK284:1;                                  /* IMR8EIMK284      */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  IMR8EIMK287:1;                                  /* IMR8EIMK287      */
} __type206;
typedef struct 
{                                                          /* Bit Access       */
    uint8  IMR9EIMK288:1;                                  /* IMR9EIMK288      */
    uint8  IMR9EIMK289:1;                                  /* IMR9EIMK289      */
    uint8  :6;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type207;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :7;                                             /* Reserved Bits    */
    uint8  IMR10EIMK335:1;                                 /* IMR10EIMK335     */
    uint8  IMR10EIMK336:1;                                 /* IMR10EIMK336     */
    uint8  IMR10EIMK337:1;                                 /* IMR10EIMK337     */
    uint8  IMR10EIMK338:1;                                 /* IMR10EIMK338     */
    uint8  IMR10EIMK339:1;                                 /* IMR10EIMK339     */
    uint8  IMR10EIMK340:1;                                 /* IMR10EIMK340     */
    uint8  IMR10EIMK341:1;                                 /* IMR10EIMK341     */
    uint8  IMR10EIMK342:1;                                 /* IMR10EIMK342     */
    uint8  IMR10EIMK343:1;                                 /* IMR10EIMK343     */
    uint8  :3;                                             /* Reserved Bits    */
    uint8  IMR10EIMK347:1;                                 /* IMR10EIMK347     */
    uint8  IMR10EIMK348:1;                                 /* IMR10EIMK348     */
    uint8  IMR10EIMK349:1;                                 /* IMR10EIMK349     */
    uint8  IMR10EIMK350:1;                                 /* IMR10EIMK350     */
    uint8  :1;                                             /* Reserved Bits    */
} __type208;
typedef struct 
{                                                          /* Bit Access       */
    uint8  :4;                                             /* Reserved Bits    */
    uint8  IMR11EIMK356:1;                                 /* IMR11EIMK356     */
    uint8  IMR11EIMK357:1;                                 /* IMR11EIMK357     */
    uint8  :2;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
    uint8  :8;                                             /* Reserved Bits    */
} __type209;
typedef union
{                                                          /* IOR              */
    uint32 UINT32;                                         /* 32-bit Access    */
    uint16 UINT16[2];                                      /* 16-bit Access    */
    uint8  UINT8[4];                                       /* 8-bit Access     */
} __type210;
typedef union
{                                                          /* IOR              */
    uint8  UINT8;                                          /* 8-bit Access     */
    __type0;                                               /* Bit Access       */
} __type211;
typedef union
{                                                          /* IOR              */
    uint8  UINT8;                                          /* 8-bit Access     */
    __type1;                                               /* Bit Access       */
} __type212;
typedef union
{                                                          /* IOR              */
    uint8  UINT8;                                          /* 8-bit Access     */
    __type2;                                               /* Bit Access       */
} __type213;
typedef union
{                                                          /* IOR              */
    uint8  UINT8;                                          /* 8-bit Access     */
    __type3;                                               /* Bit Access       */
} __type214;
typedef union
{                                                          /* IOR              */
    uint8  UINT8;                                          /* 8-bit Access     */
    __type4;                                               /* Bit Access       */
} __type215;
typedef union
{                                                          /* IOR              */
    uint8  UINT8;                                          /* 8-bit Access     */
    __type5;                                               /* Bit Access       */
} __type216;
typedef union
{                                                          /* IOR              */
    uint8  UINT8;                                          /* 8-bit Access     */
    __type6;                                               /* Bit Access       */
} __type217;
typedef union
{                                                          /* IOR              */
    uint32 UINT32;                                         /* 32-bit Access    */
    uint16 UINT16[2];                                      /* 16-bit Access    */
} __type218;
typedef union
{                                                          /* IOR              */
    uint32 UINT32;                                         /* 32-bit Access    */
    uint8  UINT8[4];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /* 8-bit Access     */
        } ERDB;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /* 8-bit Access     */
        } ECRD;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /* 8-bit Access     */
        } HORD;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /* 8-bit Access     */
        } SYND;
    };
} __type219;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } LBRP0;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } LBRP1;
    };
} __type220;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
} __type221;
typedef union
{                                                          /* IOR              */
    uint8  UINT8;                                          /* 8-bit Access     */
    __type7;                                               /* Bit Access       */
} __type222;
typedef union
{                                                          /* IOR              */
    uint8  UINT8;                                          /* 8-bit Access     */
    __type8;                                               /* Bit Access       */
} __type223;
typedef union
{                                                          /* IOR              */
    uint8  UINT8;                                          /* 8-bit Access     */
    __type9;                                               /* Bit Access       */
} __type224;
typedef union
{                                                          /* IOR              */
    uint8  UINT8;                                          /* 8-bit Access     */
    __type10;                                              /* Bit Access       */
} __type225;
typedef union
{                                                          /* IOR              */
    uint8  UINT8;                                          /* 8-bit Access     */
    __type11;                                              /* Bit Access       */
} __type226;
typedef union
{                                                          /* IOR              */
    uint8  UINT8;                                          /* 8-bit Access     */
    __type12;                                              /* Bit Access       */
} __type227;
typedef union
{                                                          /* IOR              */
    uint32 UINT32;                                         /* 32-bit Access    */
    uint16 UINT16[2];                                      /* 16-bit Access    */
    uint8  UINT8[4];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /* 8-bit Access     */
        } DPSELR1;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /* 8-bit Access     */
        } DPSELR2;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /* 8-bit Access     */
        } DPSELR3;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /* 8-bit Access     */
        } DPSELR4;
    };
} __type228;
typedef union
{                                                          /* IOR              */
    uint32 UINT32;                                         /* 32-bit Access    */
    uint16 UINT16[2];                                      /* 16-bit Access    */
    uint8  UINT8[4];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /* 8-bit Access     */
        } DPSELR5;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /* 8-bit Access     */
        } DPSELR6;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /* 8-bit Access     */
        } DPSELR7;
        uint8  dummy0[1];                                  /* Reserved         */
    };
} __type229;
typedef union
{                                                          /* IOR              */
    uint32 UINT32;                                         /* 32-bit Access    */
    uint16 UINT16[2];                                      /* 16-bit Access    */
    uint8  UINT8[4];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /* 8-bit Access     */
        } DPDSR1;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /* 8-bit Access     */
        } DPDSR2;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /* 8-bit Access     */
        } DPDSR3;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /* 8-bit Access     */
        } DPDSR4;
    };
} __type230;
typedef union
{                                                          /* IOR              */
    uint32 UINT32;                                         /* 32-bit Access    */
    uint16 UINT16[2];                                      /* 16-bit Access    */
    uint8  UINT8[4];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /* 8-bit Access     */
        } DPDSR5;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /* 8-bit Access     */
        } DPDSR6;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /* 8-bit Access     */
        } DPDSR7;
        uint8  dummy1[1];                                  /* Reserved         */
    };
} __type231;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I0L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I0H;
    };
    __type13;                                              /* Bit Access       */
} __type232;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I2L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I2H;
    };
    __type14;                                              /* Bit Access       */
} __type233;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I4L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I4H;
    };
    __type15;                                              /* Bit Access       */
} __type234;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I6L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I6H;
    };
    __type16;                                              /* Bit Access       */
} __type235;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I8L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I8H;
    };
    __type17;                                              /* Bit Access       */
} __type236;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I10L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I10H;
    };
    __type18;                                              /* Bit Access       */
} __type237;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I12L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I12H;
    };
    __type19;                                              /* Bit Access       */
} __type238;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I14L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I14H;
    };
    __type20;                                              /* Bit Access       */
} __type239;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAPA0IPEK0L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAPA0IPEK0H;
    };
    __type21;                                              /* Bit Access       */
} __type240;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAPA0IVLY0L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAPA0IVLY0H;
    };
    __type22;                                              /* Bit Access       */
} __type241;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type23;                                              /* Bit Access       */
} __type242;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type24;                                              /* Bit Access       */
} __type243;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICCSIH0IJC_1L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICCSIH0IJC_1H;
    };
    __type25;                                              /* Bit Access       */
} __type244;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type26;                                              /* Bit Access       */
} __type245;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type27;                                              /* Bit Access       */
} __type246;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type28;                                              /* Bit Access       */
} __type247;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type29;                                              /* Bit Access       */
} __type248;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type30;                                              /* Bit Access       */
} __type249;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type31;                                              /* Bit Access       */
} __type250;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICCSIH1IRE_1L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICCSIH1IRE_1H;
    };
    __type32;                                              /* Bit Access       */
} __type251;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICCSIH1IJC_1L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICCSIH1IJC_1H;
    };
    __type33;                                              /* Bit Access       */
} __type252;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type34;                                              /* Bit Access       */
} __type253;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type35;                                              /* Bit Access       */
} __type254;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type36;                                              /* Bit Access       */
} __type255;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type37;                                              /* Bit Access       */
} __type256;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type38;                                              /* Bit Access       */
} __type257;
typedef union
{                                                          /* IOR              */
    uint32 UINT32;                                         /* 32-bit Access    */
    uint16 UINT16[2];                                      /* 16-bit Access    */
    uint8  UINT8[4];                                       /* 8-bit Access     */
    __type39;                                              /* Bit Access       */
} __type258;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICCSIH0IJCL;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICCSIH0IJCH;
    };
    __type40;                                              /* Bit Access       */
} __type259;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type41;                                              /* Bit Access       */
} __type260;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type42;                                              /* Bit Access       */
} __type261;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type43;                                              /* Bit Access       */
} __type262;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type44;                                              /* Bit Access       */
} __type263;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type45;                                              /* Bit Access       */
} __type264;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type46;                                              /* Bit Access       */
} __type265;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type47;                                              /* Bit Access       */
} __type266;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type48;                                              /* Bit Access       */
} __type267;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type49;                                              /* Bit Access       */
} __type268;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type50;                                              /* Bit Access       */
} __type269;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type51;                                              /* Bit Access       */
} __type270;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type52;                                              /* Bit Access       */
} __type271;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type53;                                              /* Bit Access       */
} __type272;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type54;                                              /* Bit Access       */
} __type273;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type55;                                              /* Bit Access       */
} __type274;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type56;                                              /* Bit Access       */
} __type275;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type57;                                              /* Bit Access       */
} __type276;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type58;                                              /* Bit Access       */
} __type277;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type59;                                              /* Bit Access       */
} __type278;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type60;                                              /* Bit Access       */
} __type279;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type61;                                              /* Bit Access       */
} __type280;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type62;                                              /* Bit Access       */
} __type281;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type63;                                              /* Bit Access       */
} __type282;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type64;                                              /* Bit Access       */
} __type283;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type65;                                              /* Bit Access       */
} __type284;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type66;                                              /* Bit Access       */
} __type285;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type67;                                              /* Bit Access       */
} __type286;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type68;                                              /* Bit Access       */
} __type287;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type69;                                              /* Bit Access       */
} __type288;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type70;                                              /* Bit Access       */
} __type289;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type71;                                              /* Bit Access       */
} __type290;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type72;                                              /* Bit Access       */
} __type291;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type73;                                              /* Bit Access       */
} __type292;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type74;                                              /* Bit Access       */
} __type293;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type75;                                              /* Bit Access       */
} __type294;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type76;                                              /* Bit Access       */
} __type295;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type77;                                              /* Bit Access       */
} __type296;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type78;                                              /* Bit Access       */
} __type297;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type79;                                              /* Bit Access       */
} __type298;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type80;                                              /* Bit Access       */
} __type299;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type81;                                              /* Bit Access       */
} __type300;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type82;                                              /* Bit Access       */
} __type301;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type83;                                              /* Bit Access       */
} __type302;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type84;                                              /* Bit Access       */
} __type303;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type85;                                              /* Bit Access       */
} __type304;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type86;                                              /* Bit Access       */
} __type305;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type87;                                              /* Bit Access       */
} __type306;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type88;                                              /* Bit Access       */
} __type307;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type89;                                              /* Bit Access       */
} __type308;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type90;                                              /* Bit Access       */
} __type309;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type91;                                              /* Bit Access       */
} __type310;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type92;                                              /* Bit Access       */
} __type311;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type93;                                              /* Bit Access       */
} __type312;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type94;                                              /* Bit Access       */
} __type313;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type95;                                              /* Bit Access       */
} __type314;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type96;                                              /* Bit Access       */
} __type315;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type97;                                              /* Bit Access       */
} __type316;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type98;                                              /* Bit Access       */
} __type317;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type99;                                              /* Bit Access       */
} __type318;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type100;                                             /* Bit Access       */
} __type319;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type101;                                             /* Bit Access       */
} __type320;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type102;                                             /* Bit Access       */
} __type321;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type103;                                             /* Bit Access       */
} __type322;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type104;                                             /* Bit Access       */
} __type323;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type105;                                             /* Bit Access       */
} __type324;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type106;                                             /* Bit Access       */
} __type325;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAPA0IPEK0_2L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAPA0IPEK0_2H;
    };
    __type107;                                             /* Bit Access       */
} __type326;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAPA0IVLY0_2L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAPA0IVLY0_2H;
    };
    __type108;                                             /* Bit Access       */
} __type327;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICCSIH1IREL;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICCSIH1IREH;
    };
    __type109;                                             /* Bit Access       */
} __type328;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICCSIH1IJCL;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICCSIH1IJCH;
    };
    __type110;                                             /* Bit Access       */
} __type329;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type111;                                             /* Bit Access       */
} __type330;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type112;                                             /* Bit Access       */
} __type331;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type113;                                             /* Bit Access       */
} __type332;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type114;                                             /* Bit Access       */
} __type333;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type115;                                             /* Bit Access       */
} __type334;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type116;                                             /* Bit Access       */
} __type335;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type117;                                             /* Bit Access       */
} __type336;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type118;                                             /* Bit Access       */
} __type337;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I0_2L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I0_2H;
    };
    __type119;                                             /* Bit Access       */
} __type338;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I4_2L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I4_2H;
    };
    __type120;                                             /* Bit Access       */
} __type339;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I6_2L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I6_2H;
    };
    __type121;                                             /* Bit Access       */
} __type340;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I8_2L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I8_2H;
    };
    __type122;                                             /* Bit Access       */
} __type341;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type123;                                             /* Bit Access       */
} __type342;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type124;                                             /* Bit Access       */
} __type343;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type125;                                             /* Bit Access       */
} __type344;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type126;                                             /* Bit Access       */
} __type345;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type127;                                             /* Bit Access       */
} __type346;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type128;                                             /* Bit Access       */
} __type347;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type129;                                             /* Bit Access       */
} __type348;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type130;                                             /* Bit Access       */
} __type349;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type131;                                             /* Bit Access       */
} __type350;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type132;                                             /* Bit Access       */
} __type351;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type133;                                             /* Bit Access       */
} __type352;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type134;                                             /* Bit Access       */
} __type353;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type135;                                             /* Bit Access       */
} __type354;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type136;                                             /* Bit Access       */
} __type355;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type137;                                             /* Bit Access       */
} __type356;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type138;                                             /* Bit Access       */
} __type357;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I2_2L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I2_2H;
    };
    __type139;                                             /* Bit Access       */
} __type358;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I10_2L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I10_2H;
    };
    __type140;                                             /* Bit Access       */
} __type359;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I12_2L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I12_2H;
    };
    __type141;                                             /* Bit Access       */
} __type360;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    struct 
    {
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I14_2L;
        union
        {                                                  /* IOR              */
            uint8  UINT8;                                  /*  8-bit Access    */
        } ICTAUD0I14_2H;
    };
    __type142;                                             /* Bit Access       */
} __type361;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type143;                                             /* Bit Access       */
} __type362;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type144;                                             /* Bit Access       */
} __type363;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type145;                                             /* Bit Access       */
} __type364;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type146;                                             /* Bit Access       */
} __type365;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type147;                                             /* Bit Access       */
} __type366;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type148;                                             /* Bit Access       */
} __type367;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type149;                                             /* Bit Access       */
} __type368;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type150;                                             /* Bit Access       */
} __type369;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type151;                                             /* Bit Access       */
} __type370;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type152;                                             /* Bit Access       */
} __type371;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type153;                                             /* Bit Access       */
} __type372;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type154;                                             /* Bit Access       */
} __type373;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type155;                                             /* Bit Access       */
} __type374;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type156;                                             /* Bit Access       */
} __type375;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type157;                                             /* Bit Access       */
} __type376;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type158;                                             /* Bit Access       */
} __type377;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type159;                                             /* Bit Access       */
} __type378;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type160;                                             /* Bit Access       */
} __type379;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type161;                                             /* Bit Access       */
} __type380;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type162;                                             /* Bit Access       */
} __type381;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type163;                                             /* Bit Access       */
} __type382;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type164;                                             /* Bit Access       */
} __type383;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type165;                                             /* Bit Access       */
} __type384;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type166;                                             /* Bit Access       */
} __type385;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type167;                                             /* Bit Access       */
} __type386;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type168;                                             /* Bit Access       */
} __type387;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type169;                                             /* Bit Access       */
} __type388;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type170;                                             /* Bit Access       */
} __type389;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type171;                                             /* Bit Access       */
} __type390;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type172;                                             /* Bit Access       */
} __type391;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type173;                                             /* Bit Access       */
} __type392;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type174;                                             /* Bit Access       */
} __type393;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type175;                                             /* Bit Access       */
} __type394;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type176;                                             /* Bit Access       */
} __type395;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type177;                                             /* Bit Access       */
} __type396;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type178;                                             /* Bit Access       */
} __type397;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type179;                                             /* Bit Access       */
} __type398;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type180;                                             /* Bit Access       */
} __type399;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type181;                                             /* Bit Access       */
} __type400;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type182;                                             /* Bit Access       */
} __type401;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type183;                                             /* Bit Access       */
} __type402;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type184;                                             /* Bit Access       */
} __type403;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type185;                                             /* Bit Access       */
} __type404;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type186;                                             /* Bit Access       */
} __type405;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type187;                                             /* Bit Access       */
} __type406;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type188;                                             /* Bit Access       */
} __type407;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type189;                                             /* Bit Access       */
} __type408;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type190;                                             /* Bit Access       */
} __type409;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type191;                                             /* Bit Access       */
} __type410;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type192;                                             /* Bit Access       */
} __type411;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type193;                                             /* Bit Access       */
} __type412;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type194;                                             /* Bit Access       */
} __type413;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type195;                                             /* Bit Access       */
} __type414;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type196;                                             /* Bit Access       */
} __type415;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type197;                                             /* Bit Access       */
} __type416;
typedef union
{                                                          /* IOR              */
    uint16 UINT16;                                         /* 16-bit Access    */
    uint8  UINT8[2];                                       /* 8-bit Access     */
    __type198;                                             /* Bit Access       */
} __type417;
typedef union
{                                                          /* IOR              */
    uint32 UINT32;                                         /* 32-bit Access    */
    uint16 UINT16[2];                                      /* 16-bit Access    */
    uint8  UINT8[4];                                       /* 8-bit Access     */
    __type199;                                             /* Bit Access       */
} __type418;
typedef union
{                                                          /* IOR              */
    uint32 UINT32;                                         /* 32-bit Access    */
    uint16 UINT16[2];                                      /* 16-bit Access    */
    uint8  UINT8[4];                                       /* 8-bit Access     */
    __type200;                                             /* Bit Access       */
} __type419;
typedef union
{                                                          /* IOR              */
    uint32 UINT32;                                         /* 32-bit Access    */
    uint16 UINT16[2];                                      /* 16-bit Access    */
    uint8  UINT8[4];                                       /* 8-bit Access     */
    __type201;                                             /* Bit Access       */
} __type420;
typedef union
{                                                          /* IOR              */
    uint32 UINT32;                                         /* 32-bit Access    */
    uint16 UINT16[2];                                      /* 16-bit Access    */
    uint8  UINT8[4];                                       /* 8-bit Access     */
    __type202;                                             /* Bit Access       */
} __type421;
typedef union
{                                                          /* IOR              */
    uint32 UINT32;                                         /* 32-bit Access    */
    uint16 UINT16[2];                                      /* 16-bit Access    */
    uint8  UINT8[4];                                       /* 8-bit Access     */
    __type203;                                             /* Bit Access       */
} __type422;
typedef union
{                                                          /* IOR              */
    uint32 UINT32;                                         /* 32-bit Access    */
    uint16 UINT16[2];                                      /* 16-bit Access    */
    uint8  UINT8[4];                                       /* 8-bit Access     */
    __type204;                                             /* Bit Access       */
} __type423;
typedef union
{                                                          /* IOR              */
    uint32 UINT32;                                         /* 32-bit Access    */
    uint16 UINT16[2];                                      /* 16-bit Access    */
    uint8  UINT8[4];                                       /* 8-bit Access     */
    __type205;                                             /* Bit Access       */
} __type424;
typedef union
{                                                          /* IOR              */
    uint32 UINT32;                                         /* 32-bit Access    */
    uint16 UINT16[2];                                      /* 16-bit Access    */
    uint8  UINT8[4];                                       /* 8-bit Access     */
    __type206;                                             /* Bit Access       */
} __type425;
typedef union
{                                                          /* IOR              */
    uint32 UINT32;                                         /* 32-bit Access    */
    uint16 UINT16[2];                                      /* 16-bit Access    */
    uint8  UINT8[4];                                       /* 8-bit Access     */
    __type207;                                             /* Bit Access       */
} __type426;
typedef union
{                                                          /* IOR              */
    uint32 UINT32;                                         /* 32-bit Access    */
    uint16 UINT16[2];                                      /* 16-bit Access    */
    uint8  UINT8[4];                                       /* 8-bit Access     */
    __type208;                                             /* Bit Access       */
} __type427;
typedef union
{                                                          /* IOR              */
    uint32 UINT32;                                         /* 32-bit Access    */
    uint16 UINT16[2];                                      /* 16-bit Access    */
    uint8  UINT8[4];                                       /* 8-bit Access     */
    __type209;                                             /* Bit Access       */
} __type428;

typedef struct 
{                                                          /* Module           */
    uint32 CNT;                                            /* CNT              */
    uint32 PCMD;                                           /* PCMD             */
    const uint32 PS;                                       /* PS               */
} __type429;
typedef struct 
{                                                          /* Module           */
    uint32 ID0;                                            /* ID0              */
    uint32 ID1;                                            /* ID1              */
    uint32 ID2;                                            /* ID2              */
    uint32 ID3;                                            /* ID3              */
    const __type210 IDST;                                  /* IDST             */
} __type430;
typedef struct 
{                                                          /* Module           */
    const uint8  FPMON;                                    /* FPMON            */
    uint8  dummy0[15];                                     /* Reserved         */
    uint8  FASTAT;                                         /* FASTAT           */
    uint8  dummy1[3];                                      /* Reserved         */
    uint8  FAEINT;                                         /* FAEINT           */
    uint8  dummy2[11];                                     /* Reserved         */
    uint16 FAREASELC;                                      /* FAREASELC        */
    uint8  dummy3[14];                                     /* Reserved         */
    uint32 FSADDR;                                         /* FSADDR           */
    uint32 FEADDR;                                         /* FEADDR           */
    uint8  dummy4[72];                                     /* Reserved         */
    const __type210 FSTATR;                                /* FSTATR           */
    uint16 FENTRYR;                                        /* FENTRYR          */
    uint8  dummy5[2];                                      /* Reserved         */
    uint16 FPROTR;                                         /* FPROTR           */
    uint8  dummy6[2];                                      /* Reserved         */
    uint16 FSUINITR;                                       /* FSUINITR         */
    uint8  dummy7[2];                                      /* Reserved         */
    const uint8  FLKSTAT;                                  /* FLKSTAT          */
    uint8  dummy8[7];                                      /* Reserved         */
    const uint8  FRTSTAT;                                  /* FRTSTAT          */
    uint8  dummy9[7];                                      /* Reserved         */
    const uint16 FCMDR;                                    /* FCMDR            */
    uint8  dummy10[30];                                    /* Reserved         */
    const uint16 FPESTAT;                                  /* FPESTAT          */
    uint8  dummy11[14];                                    /* Reserved         */
    uint8  FBCCNT;                                         /* FBCCNT           */
    uint8  dummy12[3];                                     /* Reserved         */
    const uint8  FBCSTAT;                                  /* FBCSTAT          */
    uint8  dummy13[3];                                     /* Reserved         */
    const uint32 FPSADDR;                                  /* FPSADDR          */
    uint8  dummy14[4];                                     /* Reserved         */
    uint16 FCPSR;                                          /* FCPSR            */
    uint8  dummy15[2];                                     /* Reserved         */
    uint16 FPCKAR;                                         /* FPCKAR           */
    uint8  dummy16[26];                                    /* Reserved         */
    const uint16 FECCEMON;                                 /* FECCEMON         */
    uint8  dummy17[2];                                     /* Reserved         */
    uint16 FECCTMD;                                        /* FECCTMD          */
    uint8  dummy18[2];                                     /* Reserved         */
    uint16 FDMYECC;                                        /* FDMYECC          */
    uint8  dummy19[2395902];                               /* Reserved         */
    uint8  BFASELR;                                        /* BFASELR          */
} __type431;
typedef struct 
{                                                          /* Module           */
    const uint32 WDTNMIF;                                  /* WDTNMIF          */
    uint8  dummy20[4];                                     /* Reserved         */
    uint32 WDTNMIFC;                                       /* WDTNMIFC         */
} __type432;
typedef struct 
{                                                          /* Module           */
    const uint32 FEINTF;                                   /* FEINTF           */
    uint32 FEINTFMSK;                                      /* FEINTFMSK        */
    uint32 FEINTFC;                                        /* FEINTFC          */
} __type433;
typedef struct 
{                                                          /* Module           */
    uint16 SELB_INTC1;                                     /* SELB_INTC1       */
} __type434;
typedef struct 
{                                                          /* Module           */
    uint32 DTFSEL_TAUD0;                                   /* DTFSEL_TAUD0     */
    uint32 DTFSEL_TAUB0;                                   /* DTFSEL_TAUB0     */
} __type435;
typedef struct 
{                                                          /* Module           */
    uint16 P0;                                             /* P0               */
    uint8  dummy21[30];                                    /* Reserved         */
    uint16 P8;                                             /* P8               */
    uint8  dummy22[2];                                     /* Reserved         */
    uint16 P9;                                             /* P9               */
    uint8  dummy23[2];                                     /* Reserved         */
    uint16 P10;                                            /* P10              */
    uint8  dummy24[2];                                     /* Reserved         */
    uint16 P11;                                            /* P11              */
    uint8  dummy25[154];                                   /* Reserved         */
    uint16 AP0;                                            /* AP0              */
    uint8  dummy26[54];                                    /* Reserved         */
    uint32 PSR0;                                           /* PSR0             */
    uint8  dummy27[28];                                    /* Reserved         */
    uint32 PSR8;                                           /* PSR8             */
    uint32 PSR9;                                           /* PSR9             */
    uint32 PSR10;                                          /* PSR10            */
    uint32 PSR11;                                          /* PSR11            */
    uint8  dummy28[152];                                   /* Reserved         */
    uint32 APSR0;                                          /* APSR0            */
    uint8  dummy29[52];                                    /* Reserved         */
    const uint16 PPR0;                                     /* PPR0             */
    uint8  dummy30[30];                                    /* Reserved         */
    const uint16 PPR8;                                     /* PPR8             */
    uint8  dummy31[2];                                     /* Reserved         */
    const uint16 PPR9;                                     /* PPR9             */
    uint8  dummy32[2];                                     /* Reserved         */
    const uint16 PPR10;                                    /* PPR10            */
    uint8  dummy33[2];                                     /* Reserved         */
    const uint16 PPR11;                                    /* PPR11            */
    uint8  dummy34[154];                                   /* Reserved         */
    const uint16 APPR0;                                    /* APPR0            */
    uint8  dummy35[54];                                    /* Reserved         */
    uint16 PM0;                                            /* PM0              */
    uint8  dummy36[30];                                    /* Reserved         */
    uint16 PM8;                                            /* PM8              */
    uint8  dummy37[2];                                     /* Reserved         */
    uint16 PM9;                                            /* PM9              */
    uint8  dummy38[2];                                     /* Reserved         */
    uint16 PM10;                                           /* PM10             */
    uint8  dummy39[2];                                     /* Reserved         */
    uint16 PM11;                                           /* PM11             */
    uint8  dummy40[154];                                   /* Reserved         */
    uint16 APM0;                                           /* APM0             */
    uint8  dummy41[54];                                    /* Reserved         */
    uint16 PMC0;                                           /* PMC0             */
    uint8  dummy42[30];                                    /* Reserved         */
    uint16 PMC8;                                           /* PMC8             */
    uint8  dummy43[2];                                     /* Reserved         */
    uint16 PMC9;                                           /* PMC9             */
    uint8  dummy44[2];                                     /* Reserved         */
    uint16 PMC10;                                          /* PMC10            */
    uint8  dummy45[2];                                     /* Reserved         */
    uint16 PMC11;                                          /* PMC11            */
    uint8  dummy46[210];                                   /* Reserved         */
    uint16 PFC0;                                           /* PFC0             */
    uint8  dummy47[30];                                    /* Reserved         */
    uint16 PFC8;                                           /* PFC8             */
    uint8  dummy48[2];                                     /* Reserved         */
    uint16 PFC9;                                           /* PFC9             */
    uint8  dummy49[2];                                     /* Reserved         */
    uint16 PFC10;                                          /* PFC10            */
    uint8  dummy50[2];                                     /* Reserved         */
    uint16 PFC11;                                          /* PFC11            */
    uint8  dummy51[210];                                   /* Reserved         */
    uint16 PFCE0;                                          /* PFCE0            */
    uint8  dummy52[30];                                    /* Reserved         */
    uint16 PFCE8;                                          /* PFCE8            */
    uint8  dummy53[2];                                     /* Reserved         */
    uint16 PFCE9;                                          /* PFCE9            */
    uint8  dummy54[2];                                     /* Reserved         */
    uint16 PFCE10;                                         /* PFCE10           */
    uint8  dummy55[2];                                     /* Reserved         */
    uint16 PFCE11;                                         /* PFCE11           */
    uint8  dummy56[210];                                   /* Reserved         */
    uint16 PNOT0;                                          /* PNOT0            */
    uint8  dummy57[30];                                    /* Reserved         */
    uint16 PNOT8;                                          /* PNOT8            */
    uint8  dummy58[2];                                     /* Reserved         */
    uint16 PNOT9;                                          /* PNOT9            */
    uint8  dummy59[2];                                     /* Reserved         */
    uint16 PNOT10;                                         /* PNOT10           */
    uint8  dummy60[2];                                     /* Reserved         */
    uint16 PNOT11;                                         /* PNOT11           */
    uint8  dummy61[154];                                   /* Reserved         */
    uint16 APNOT0;                                         /* APNOT0           */
    uint8  dummy62[54];                                    /* Reserved         */
    uint32 PMSR0;                                          /* PMSR0            */
    uint8  dummy63[28];                                    /* Reserved         */
    uint32 PMSR8;                                          /* PMSR8            */
    uint32 PMSR9;                                          /* PMSR9            */
    uint32 PMSR10;                                         /* PMSR10           */
    uint32 PMSR11;                                         /* PMSR11           */
    uint8  dummy64[152];                                   /* Reserved         */
    uint32 APMSR0;                                         /* APMSR0           */
    uint8  dummy65[52];                                    /* Reserved         */
    uint32 PMCSR0;                                         /* PMCSR0           */
    uint8  dummy66[28];                                    /* Reserved         */
    uint32 PMCSR8;                                         /* PMCSR8           */
    uint32 PMCSR9;                                         /* PMCSR9           */
    uint32 PMCSR10;                                        /* PMCSR10          */
    uint32 PMCSR11;                                        /* PMCSR11          */
    uint8  dummy67[208];                                   /* Reserved         */
    uint16 PFCAE0;                                         /* PFCAE0           */
    uint8  dummy68[30];                                    /* Reserved         */
    uint16 PFCAE8;                                         /* PFCAE8           */
    uint8  dummy69[2];                                     /* Reserved         */
    uint16 PFCAE9;                                         /* PFCAE9           */
    uint8  dummy70[2];                                     /* Reserved         */
    uint16 PFCAE10;                                        /* PFCAE10          */
    uint8  dummy71[2];                                     /* Reserved         */
    uint16 PFCAE11;                                        /* PFCAE11          */
    uint8  dummy72[13778];                                 /* Reserved         */
    uint16 PIBC0;                                          /* PIBC0            */
    uint8  dummy73[30];                                    /* Reserved         */
    uint16 PIBC8;                                          /* PIBC8            */
    uint8  dummy74[2];                                     /* Reserved         */
    uint16 PIBC9;                                          /* PIBC9            */
    uint8  dummy75[2];                                     /* Reserved         */
    uint16 PIBC10;                                         /* PIBC10           */
    uint8  dummy76[2];                                     /* Reserved         */
    uint16 PIBC11;                                         /* PIBC11           */
    uint8  dummy77[154];                                   /* Reserved         */
    uint16 APIBC0;                                         /* APIBC0           */
    uint8  dummy78[54];                                    /* Reserved         */
    uint16 PBDC0;                                          /* PBDC0            */
    uint8  dummy79[30];                                    /* Reserved         */
    uint16 PBDC8;                                          /* PBDC8            */
    uint8  dummy80[2];                                     /* Reserved         */
    uint16 PBDC9;                                          /* PBDC9            */
    uint8  dummy81[2];                                     /* Reserved         */
    uint16 PBDC10;                                         /* PBDC10           */
    uint8  dummy82[2];                                     /* Reserved         */
    uint16 PBDC11;                                         /* PBDC11           */
    uint8  dummy83[154];                                   /* Reserved         */
    uint16 APBDC0;                                         /* APBDC0           */
    uint8  dummy84[54];                                    /* Reserved         */
    uint16 PIPC0;                                          /* PIPC0            */
    uint8  dummy85[38];                                    /* Reserved         */
    uint16 PIPC10;                                         /* PIPC10           */
    uint8  dummy86[2];                                     /* Reserved         */
    uint16 PIPC11;                                         /* PIPC11           */
    uint8  dummy87[210];                                   /* Reserved         */
    uint16 PU0;                                            /* PU0              */
    uint8  dummy88[30];                                    /* Reserved         */
    uint16 PU8;                                            /* PU8              */
    uint8  dummy89[2];                                     /* Reserved         */
    uint16 PU9;                                            /* PU9              */
    uint8  dummy90[2];                                     /* Reserved         */
    uint16 PU10;                                           /* PU10             */
    uint8  dummy91[2];                                     /* Reserved         */
    uint16 PU11;                                           /* PU11             */
    uint8  dummy92[210];                                   /* Reserved         */
    uint16 PD0;                                            /* PD0              */
    uint8  dummy93[30];                                    /* Reserved         */
    uint16 PD8;                                            /* PD8              */
    uint8  dummy94[2];                                     /* Reserved         */
    uint16 PD9;                                            /* PD9              */
    uint8  dummy95[2];                                     /* Reserved         */
    uint16 PD10;                                           /* PD10             */
    uint8  dummy96[2];                                     /* Reserved         */
    uint16 PD11;                                           /* PD11             */
    uint8  dummy97[210];                                   /* Reserved         */
    uint32 PODC0;                                          /* PODC0            */
    uint8  dummy98[28];                                    /* Reserved         */
    uint32 PODC8;                                          /* PODC8            */
    uint32 PODC9;                                          /* PODC9            */
    uint32 PODC10;                                         /* PODC10           */
    uint32 PODC11;                                         /* PODC11           */
    uint8  dummy99[208];                                   /* Reserved         */
    uint32 PDSC0;                                          /* PDSC0            */
    uint8  dummy100[36];                                   /* Reserved         */
    uint32 PDSC10;                                         /* PDSC10           */
    uint32 PDSC11;                                         /* PDSC11           */
    uint8  dummy101[208];                                  /* Reserved         */
    uint16 PIS0;                                           /* PIS0             */
    uint8  dummy102[30];                                   /* Reserved         */
    uint16 PIS8;                                           /* PIS8             */
    uint8  dummy103[2];                                    /* Reserved         */
    uint16 PIS9;                                           /* PIS9             */
    uint8  dummy104[2];                                    /* Reserved         */
    uint16 PIS10;                                          /* PIS10            */
    uint8  dummy105[2];                                    /* Reserved         */
    uint16 PIS11;                                          /* PIS11            */
    uint8  dummy106[978];                                  /* Reserved         */
    const uint32 PPROTS0;                                  /* PPROTS0          */
    uint8  dummy107[28];                                   /* Reserved         */
    const uint32 PPROTS8;                                  /* PPROTS8          */
    const uint32 PPROTS9;                                  /* PPROTS9          */
    const uint32 PPROTS10;                                 /* PPROTS10         */
    const uint32 PPROTS11;                                 /* PPROTS11         */
    uint8  dummy108[208];                                  /* Reserved         */
    uint32 PPCMD0;                                         /* PPCMD0           */
    uint8  dummy109[28];                                   /* Reserved         */
    uint32 PPCMD8;                                         /* PPCMD8           */
    uint32 PPCMD9;                                         /* PPCMD9           */
    uint32 PPCMD10;                                        /* PPCMD10          */
    uint32 PPCMD11;                                        /* PPCMD11          */
} __type436;
typedef struct 
{                                                          /* Module           */
    uint8  JP0;                                            /* JP0              */
    uint8  dummy110[15];                                   /* Reserved         */
    uint32 JPSR0;                                          /* JPSR0            */
    uint8  dummy111[12];                                   /* Reserved         */
    const uint8  JPPR0;                                    /* JPPR0            */
    uint8  dummy112[15];                                   /* Reserved         */
    uint8  JPM0;                                           /* JPM0             */
    uint8  dummy113[15];                                   /* Reserved         */
    uint8  JPMC0;                                          /* JPMC0            */
    uint8  dummy114[15];                                   /* Reserved         */
    uint8  JPFC0;                                          /* JPFC0            */
    uint8  dummy115[15];                                   /* Reserved         */
    uint8  JPFCE0;                                         /* JPFCE0           */
    uint8  dummy116[15];                                   /* Reserved         */
    uint8  JPNOT0;                                         /* JPNOT0           */
    uint8  dummy117[15];                                   /* Reserved         */
    uint32 JPMSR0;                                         /* JPMSR0           */
    uint8  dummy118[12];                                   /* Reserved         */
    uint32 JPMCSR0;                                        /* JPMCSR0          */
    uint8  dummy119[876];                                  /* Reserved         */
    uint8  JPIBC0;                                         /* JPIBC0           */
    uint8  dummy120[15];                                   /* Reserved         */
    uint8  JPBDC0;                                         /* JPBDC0           */
    uint8  dummy121[31];                                   /* Reserved         */
    uint8  JPU0;                                           /* JPU0             */
    uint8  dummy122[15];                                   /* Reserved         */
    uint8  JPD0;                                           /* JPD0             */
    uint8  dummy123[15];                                   /* Reserved         */
    uint32 JPODC0;                                         /* JPODC0           */
    uint8  dummy124[12];                                   /* Reserved         */
    uint32 JPDSC0;                                         /* JPDSC0           */
    uint8  dummy125[12];                                   /* Reserved         */
    uint8  JPIS0;                                          /* JPIS0            */
    uint8  dummy126[47];                                   /* Reserved         */
    uint8  JPISA0;                                         /* JPISA0           */
    uint8  dummy127[15];                                   /* Reserved         */
    const uint32 JPPROTS0;                                 /* JPPROTS0         */
    uint8  dummy128[12];                                   /* Reserved         */
    uint32 JPPCMD0;                                        /* JPPCMD0          */
} __type437;
typedef struct 
{                                                          /* Module           */
    uint8  ATAUD0ICTL;                                     /* ATAUD0ICTL       */
    uint8  dummy129[3];                                    /* Reserved         */
    uint16 ATAUD0IEN;                                      /* ATAUD0IEN        */
    uint8  dummy130[2];                                    /* Reserved         */
    __type211 ATAUD0IENH;                                  /* ATAUD0IENH       */
    uint8  dummy131[3];                                    /* Reserved         */
    __type212 ATAUD0IENL;                                  /* ATAUD0IENL       */
    uint8  dummy132[19];                                   /* Reserved         */
    uint8  ATAUB0ICTL;                                     /* ATAUB0ICTL       */
    uint8  dummy133[3];                                    /* Reserved         */
    uint16 ATAUB0IEN;                                      /* ATAUB0IEN        */
    uint8  dummy134[2];                                    /* Reserved         */
    __type213 ATAUB0IENH;                                  /* ATAUB0IENH       */
    uint8  dummy135[3];                                    /* Reserved         */
    __type214 ATAUB0IENL;                                  /* ATAUB0IENL       */
    uint8  dummy136[51];                                   /* Reserved         */
    uint8  AENCA0ICTL;                                     /* AENCA0ICTL       */
    uint8  dummy137[3];                                    /* Reserved         */
    uint16 AENCA0IEN;                                      /* AENCA0IEN        */
    uint8  dummy138[6];                                    /* Reserved         */
    __type215 AENCA0IENL;                                  /* AENCA0IENL       */
    uint8  dummy139[51];                                   /* Reserved         */
    uint8  AADCTL0CTL;                                     /* AADCTL0CTL       */
    uint8  dummy140[3];                                    /* Reserved         */
    uint16 AADCTL0EN;                                      /* AADCTL0EN        */
    uint8  dummy141[6];                                    /* Reserved         */
    __type216 AADCTL0ENL;                                  /* AADCTL0ENL       */
    uint8  dummy142[51];                                   /* Reserved         */
    uint8  ASENTICTL;                                      /* ASENTICTL        */
    uint8  dummy143[3];                                    /* Reserved         */
    uint16 ASENTIEN;                                       /* ASENTIEN         */
    uint8  dummy144[6];                                    /* Reserved         */
    __type217 ASENTIENL;                                   /* ASENTIENL        */
} __type438;
typedef struct 
{                                                          /* Module           */
    uint8  CTL0_NMI;                                       /* CTL0_NMI         */
    uint8  dummy145[31];                                   /* Reserved         */
    uint8  CTL0_INTPL;                                     /* CTL0_INTPL       */
    uint8  dummy146[3];                                    /* Reserved         */
    uint8  CTL1_INTPL;                                     /* CTL1_INTPL       */
    uint8  dummy147[3];                                    /* Reserved         */
    uint8  CTL2_INTPL;                                     /* CTL2_INTPL       */
    uint8  dummy148[3];                                    /* Reserved         */
    uint8  CTL3_INTPL;                                     /* CTL3_INTPL       */
    uint8  dummy149[3];                                    /* Reserved         */
    uint8  CTL4_INTPL;                                     /* CTL4_INTPL       */
    uint8  dummy150[3];                                    /* Reserved         */
    uint8  CTL5_INTPL;                                     /* CTL5_INTPL       */
    uint8  dummy151[3];                                    /* Reserved         */
    uint8  CTL6_INTPL;                                     /* CTL6_INTPL       */
    uint8  dummy152[3];                                    /* Reserved         */
    uint8  CTL7_INTPL;                                     /* CTL7_INTPL       */
    uint8  dummy153[3];                                    /* Reserved         */
    uint8  CTL0_INTPH;                                     /* CTL0_INTPH       */
    uint8  dummy154[7];                                    /* Reserved         */
    uint8  CTL2_INTPH;                                     /* CTL2_INTPH       */
    uint8  dummy155[3];                                    /* Reserved         */
    uint8  CTL3_INTPH;                                     /* CTL3_INTPH       */
    uint8  dummy156[3];                                    /* Reserved         */
    uint8  CTL4_INTPH;                                     /* CTL4_INTPH       */
    uint8  dummy157[3];                                    /* Reserved         */
    uint8  CTL5_INTPH;                                     /* CTL5_INTPH       */
    uint8  dummy158[11];                                   /* Reserved         */
    uint8  CTL0_ADC0;                                      /* CTL0_ADC0        */
    uint8  dummy159[3];                                    /* Reserved         */
    uint8  CTL1_ADC0;                                      /* CTL1_ADC0        */
    uint8  dummy160[3];                                    /* Reserved         */
    uint8  CTL2_ADC0;                                      /* CTL2_ADC0        */
} __type439;
typedef struct 
{                                                          /* Module           */
    __type210 FSGD00PROT0;                                 /* FSGD00PROT0      */
    __type210 FSGD00PROT1;                                 /* FSGD00PROT1      */
    __type210 FSGD00PROT2;                                 /* FSGD00PROT2      */
    __type210 FSGD00PROT3;                                 /* FSGD00PROT3      */
    __type210 FSGD00PROT4;                                 /* FSGD00PROT4      */
    __type210 FSGD00PROT5;                                 /* FSGD00PROT5      */
    __type210 FSGD00PROT6;                                 /* FSGD00PROT6      */
    __type210 FSGD00PROT7;                                 /* FSGD00PROT7      */
    __type210 FSGD00PROT8;                                 /* FSGD00PROT8      */
    __type210 FSGD00PROT9;                                 /* FSGD00PROT9      */
    __type210 FSGD00PROT10;                                /* FSGD00PROT10     */
    __type210 FSGD00PROT11;                                /* FSGD00PROT11     */
    uint8  dummy161[16];                                   /* Reserved         */
    __type210 ERRSLV00CTL;                                 /* ERRSLV00CTL      */
    const __type210 ERRSLV00STAT;                          /* ERRSLV00STAT     */
    const uint32 ERRSLV00ADDR;                             /* ERRSLV00ADDR     */
    const __type218 ERRSLV00TYPE;                          /* ERRSLV00TYPE     */
} __type440;
typedef struct 
{                                                          /* Module           */
    __type210 FSGD01PROT0;                                 /* FSGD01PROT0      */
    __type210 FSGD01PROT1;                                 /* FSGD01PROT1      */
    __type210 FSGD01PROT2;                                 /* FSGD01PROT2      */
    __type210 FSGD01PROT3;                                 /* FSGD01PROT3      */
    __type210 FSGD01PROT4;                                 /* FSGD01PROT4      */
    __type210 FSGD01PROT5;                                 /* FSGD01PROT5      */
    __type210 FSGD01PROT6;                                 /* FSGD01PROT6      */
    uint8  dummy162[8];                                    /* Reserved         */
    __type210 FSGD01PROT9;                                 /* FSGD01PROT9      */
    uint8  dummy163[8];                                    /* Reserved         */
    __type210 FSGD01PROT12;                                /* FSGD01PROT12     */
    __type210 FSGD01PROT13;                                /* FSGD01PROT13     */
    __type210 FSGD01PROT14;                                /* FSGD01PROT14     */
    uint8  dummy164[4];                                    /* Reserved         */
    __type210 ERRSLV01CTL;                                 /* ERRSLV01CTL      */
    const __type210 ERRSLV01STAT;                          /* ERRSLV01STAT     */
    const uint32 ERRSLV01ADDR;                             /* ERRSLV01ADDR     */
    const __type218 ERRSLV01TYPE;                          /* ERRSLV01TYPE     */
} __type441;
typedef struct 
{                                                          /* Module           */
    __type210 FSGD07PROT0;                                 /* FSGD07PROT0      */
    __type210 FSGD07PROT1;                                 /* FSGD07PROT1      */
    __type210 FSGD07PROT2;                                 /* FSGD07PROT2      */
    __type210 FSGD07PROT3;                                 /* FSGD07PROT3      */
    uint8  dummy165[44];                                   /* Reserved         */
    __type210 FSGD07PROT15;                                /* FSGD07PROT15     */
    __type210 ERRSLV07CTL;                                 /* ERRSLV07CTL      */
    const __type210 ERRSLV07STAT;                          /* ERRSLV07STAT     */
    const uint32 ERRSLV07ADDR;                             /* ERRSLV07ADDR     */
    const __type218 ERRSLV07TYPE;                          /* ERRSLV07TYPE     */
} __type442;
typedef struct 
{                                                          /* Module           */
    __type210 FSGD08PROT0;                                 /* FSGD08PROT0      */
    __type210 FSGD08PROT1;                                 /* FSGD08PROT1      */
    __type210 FSGD08PROT2;                                 /* FSGD08PROT2      */
    __type210 FSGD08PROT3;                                 /* FSGD08PROT3      */
    __type210 FSGD08PROT4;                                 /* FSGD08PROT4      */
    __type210 FSGD08PROT5;                                 /* FSGD08PROT5      */
    __type210 FSGD08PROT6;                                 /* FSGD08PROT6      */
    uint8  dummy166[4];                                    /* Reserved         */
    __type210 FSGD08PROT8;                                 /* FSGD08PROT8      */
    __type210 FSGD08PROT9;                                 /* FSGD08PROT9      */
    __type210 FSGD08PROT10;                                /* FSGD08PROT10     */
    __type210 FSGD08PROT11;                                /* FSGD08PROT11     */
    uint8  dummy167[4];                                    /* Reserved         */
    __type210 FSGD08PROT13;                                /* FSGD08PROT13     */
    __type210 FSGD08PROT14;                                /* FSGD08PROT14     */
    uint8  dummy168[4];                                    /* Reserved         */
    __type210 ERRSLV08CTL;                                 /* ERRSLV08CTL      */
    const __type210 ERRSLV08STAT;                          /* ERRSLV08STAT     */
    const uint32 ERRSLV08ADDR;                             /* ERRSLV08ADDR     */
    const __type218 ERRSLV08TYPE;                          /* ERRSLV08TYPE     */
} __type443;
typedef struct 
{                                                          /* Module           */
    __type210 FSGDC0PROT0;                                 /* FSGDC0PROT0      */
    __type210 FSGDC0PROT1;                                 /* FSGDC0PROT1      */
    uint8  dummy169[2040];                                 /* Reserved         */
    __type210 ERRSLVC0CTL;                                 /* ERRSLVC0CTL      */
    const __type210 ERRSLVC0STAT;                          /* ERRSLVC0STAT     */
    const uint32 ERRSLVC0ADDR;                             /* ERRSLVC0ADDR     */
    const __type218 ERRSLVC0TYPE;                          /* ERRSLVC0TYPE     */
} __type444;
typedef struct 
{                                                          /* Module           */
    __type210 FSGDC1PROT0;                                 /* FSGDC1PROT0      */
    __type210 FSGDC1PROT1;                                 /* FSGDC1PROT1      */
    __type210 FSGDC1PROT2;                                 /* FSGDC1PROT2      */
    __type210 FSGDC1PROT3;                                 /* FSGDC1PROT3      */
    __type210 FSGDC1PROT4;                                 /* FSGDC1PROT4      */
    __type210 FSGDC1PROT5;                                 /* FSGDC1PROT5      */
    uint8  dummy170[1992];                                 /* Reserved         */
    __type210 ERRSLVC1CTL;                                 /* ERRSLVC1CTL      */
    const __type210 ERRSLVC1STAT;                          /* ERRSLVC1STAT     */
    const uint32 ERRSLVC1ADDR;                             /* ERRSLVC1ADDR     */
    const __type218 ERRSLVC1TYPE;                          /* ERRSLVC1TYPE     */
} __type445;
typedef struct 
{                                                          /* Module           */
    uint8  EEPRDCYCL;                                      /* EEPRDCYCL        */
} __type446;
typedef struct 
{                                                          /* Module           */
    __type210 FBUFCCTL;                                    /* FBUFCCTL         */
} __type447;
typedef struct 
{                                                          /* Module           */
    __type218 CFECCCTL_VCI;                                /* CFECCCTL_VCI     */
    __type210 CFERRINT_VCI;                                /* CFERRINT_VCI     */
    __type210 CFSTCLR_VCI;                                 /* CFSTCLR_VCI      */
    const __type210 CFOVFSTR_VCI;                          /* CFOVFSTR_VCI     */
    const __type210 CF1STERSTR_VCI;                        /* CF1STERSTR_VCI   */
    uint8  dummy171[60];                                   /* Reserved         */
    const __type210 CF1STEADR0_VCI;                        /* CF1STEADR0_VCI   */
    uint8  dummy172[252];                                  /* Reserved         */
    __type218 CFSTSTCTL_VCI;                               /* CFSTSTCTL_VCI    */
} __type448;
typedef struct 
{                                                          /* Module           */
    __type218 CFECCCTL_PE1;                                /* CFECCCTL_PE1     */
    __type210 CFERRINT_PE1;                                /* CFERRINT_PE1     */
    __type210 CFSTCLR_PE1;                                 /* CFSTCLR_PE1      */
    const __type210 CFOVFSTR_PE1;                          /* CFOVFSTR_PE1     */
    const __type210 CF1STERSTR_PE1;                        /* CF1STERSTR_PE1   */
    uint8  dummy173[60];                                   /* Reserved         */
    const __type210 CF1STEADR0_PE1;                        /* CF1STEADR0_PE1   */
} __type449;
typedef struct 
{                                                          /* Module           */
    uint16 CTL;                                            /* CTL              */
    uint8  dummy174[2];                                    /* Reserved         */
    const uint8  DFERSTR;                                  /* DFERSTR          */
    uint8  dummy175[3];                                    /* Reserved         */
    uint8  DFERSTC;                                        /* DFERSTC          */
    uint8  dummy176[3];                                    /* Reserved         */
    const uint8  DFOVFSTR;                                 /* DFOVFSTR         */
    uint8  dummy177[3];                                    /* Reserved         */
    uint8  DFOVFSTC;                                       /* DFOVFSTC         */
    uint8  dummy178[3];                                    /* Reserved         */
    uint8  DFERRINT;                                       /* DFERRINT         */
    uint8  dummy179[3];                                    /* Reserved         */
    const uint32 DFEADR;                                   /* DFEADR           */
    uint16 DFTSTCTL;                                       /* DFTSTCTL         */
} __type450;
typedef struct 
{                                                          /* Module           */
    __type218 CTL_PE1;                                     /* CTL_PE1          */
    const uint32 LRTDATBF0_PE1;                            /* LRTDATBF0_PE1    */
} __type451;
typedef struct 
{                                                          /* Module           */
    __type218 CTL_PE1;                                     /* CTL_PE1          */
    __type210 LRERRINT_PE1;                                /* LRERRINT_PE1     */
    __type210 LRSTCLR_PE1;                                 /* LRSTCLR_PE1      */
    const __type210 LROVFSTR_PE1;                          /* LROVFSTR_PE1     */
    const __type210 LR1STERSTR_PE1;                        /* LR1STERSTR_PE1   */
    uint8  dummy180[60];                                   /* Reserved         */
    const __type210 LR1STEADR0_PE1;                        /* LR1STEADR0_PE1   */
} __type452;
typedef struct 
{                                                          /* Module           */
    uint16 CTL;                                            /* CTL              */
    uint8  dummy181[2];                                    /* Reserved         */
    uint16 TMC;                                            /* TMC              */
    uint8  dummy182[2];                                    /* Reserved         */
    __type219 TRC;                                         /* TRC              */
    uint32 TED;                                            /* TED              */
    const uint32 AD0;                                      /* AD0              */
    uint8  dummy183[236];                                  /* Reserved         */
} __type453;
typedef struct 
{                                                          /* Module           */
    uint16 SELB_READTEST;                                  /* SELB_READTEST    */
} __type454;
typedef struct 
{                                                          /* Module           */
    __type210 CR1;                                         /* CR1              */
    __type210 CR2;                                         /* CR2              */
    __type210 MR1;                                         /* MR1              */
    __type210 MR2;                                         /* MR2              */
    __type210 MR3;                                         /* MR3              */
    __type210 FER;                                         /* FER              */
    __type210 SER;                                         /* SER              */
    __type210 IER;                                         /* IER              */
    __type210 SR1;                                         /* SR1              */
    __type210 SR2;                                         /* SR2              */
    __type210 SAR0;                                        /* SAR0             */
    __type210 SAR1;                                        /* SAR1             */
    __type210 SAR2;                                        /* SAR2             */
    __type210 BRL;                                         /* BRL              */
    __type210 BRH;                                         /* BRH              */
    __type210 DRT;                                         /* DRT              */
    const __type210 DRR;                                   /* DRR              */
    uint8  dummy184[60];                                   /* Reserved         */
} __type455;
typedef struct 
{                                                          /* Module           */
    const uint32 PRDNAME1;                                 /* PRDNAME1         */
    const uint32 PRDNAME2;                                 /* PRDNAME2         */
    const uint32 PRDNAME3;                                 /* PRDNAME3         */
    uint8  dummy185[4];                                    /* Reserved         */
    const uint32 CHIPID1LL;                                /* CHIPID1LL        */
    const uint32 CHIPID1LH;                                /* CHIPID1LH        */
    const uint32 CHIPID1HL;                                /* CHIPID1HL        */
    const uint32 CHIPID1HH;                                /* CHIPID1HH        */
    const uint32 CHIPID2LL;                                /* CHIPID2LL        */
    const uint32 CHIPID2LH;                                /* CHIPID2LH        */
    const uint32 CHIPID2HL;                                /* CHIPID2HL        */
    const uint32 CHIPID2HH;                                /* CHIPID2HH        */
} __type456;
typedef struct 
{                                                          /* Module           */
    uint8  dummy186[1];                                    /* Reserved         */
    uint8  GLWBR;                                          /* GLWBR            */
    uint8  GLBRP0;                                         /* GLBRP0           */
    uint8  GLBRP1;                                         /* GLBRP1           */
    uint8  GLSTC;                                          /* GLSTC            */
} __type457;
typedef struct 
{                                                          /* Module           */
    uint8  L0MD;                                           /* L0MD             */
    uint8  L0BFC;                                          /* L0BFC            */
    uint8  L0SC;                                           /* L0SC             */
    uint8  L0WUP;                                          /* L0WUP            */
    uint8  L0IE;                                           /* L0IE             */
    uint8  L0EDE;                                          /* L0EDE            */
    uint8  L0CUC;                                          /* L0CUC            */
    uint8  dummy187[1];                                    /* Reserved         */
    uint8  L0TRC;                                          /* L0TRC            */
    const uint8  L0MST;                                    /* L0MST            */
    uint8  L0ST;                                           /* L0ST             */
    uint8  L0EST;                                          /* L0EST            */
    uint8  L0DFC;                                          /* L0DFC            */
    uint8  L0IDB;                                          /* L0IDB            */
    uint8  L0CBR;                                          /* L0CBR            */
    uint8  dummy188[1];                                    /* Reserved         */
    uint8  L0DBR1;                                         /* L0DBR1           */
    uint8  L0DBR2;                                         /* L0DBR2           */
    uint8  L0DBR3;                                         /* L0DBR3           */
    uint8  L0DBR4;                                         /* L0DBR4           */
    uint8  L0DBR5;                                         /* L0DBR5           */
    uint8  L0DBR6;                                         /* L0DBR6           */
    uint8  L0DBR7;                                         /* L0DBR7           */
    uint8  L0DBR8;                                         /* L0DBR8           */
} __type458;
typedef struct 
{                                                          /* Module           */
    uint8  L1MD;                                           /* L1MD             */
    uint8  L1BFC;                                          /* L1BFC            */
    uint8  L1SC;                                           /* L1SC             */
    uint8  L1WUP;                                          /* L1WUP            */
    uint8  L1IE;                                           /* L1IE             */
    uint8  L1EDE;                                          /* L1EDE            */
    uint8  L1CUC;                                          /* L1CUC            */
    uint8  dummy189[1];                                    /* Reserved         */
    uint8  L1TRC;                                          /* L1TRC            */
    const uint8  L1MST;                                    /* L1MST            */
    uint8  L1ST;                                           /* L1ST             */
    uint8  L1EST;                                          /* L1EST            */
    uint8  L1DFC;                                          /* L1DFC            */
    uint8  L1IDB;                                          /* L1IDB            */
    uint8  L1CBR;                                          /* L1CBR            */
    uint8  dummy190[1];                                    /* Reserved         */
    uint8  L1DBR1;                                         /* L1DBR1           */
    uint8  L1DBR2;                                         /* L1DBR2           */
    uint8  L1DBR3;                                         /* L1DBR3           */
    uint8  L1DBR4;                                         /* L1DBR4           */
    uint8  L1DBR5;                                         /* L1DBR5           */
    uint8  L1DBR6;                                         /* L1DBR6           */
    uint8  L1DBR7;                                         /* L1DBR7           */
    uint8  L1DBR8;                                         /* L1DBR8           */
} __type459;
typedef struct 
{                                                          /* Module           */
    uint8  L2MD;                                           /* L2MD             */
    uint8  L2BFC;                                          /* L2BFC            */
    uint8  L2SC;                                           /* L2SC             */
    uint8  L2WUP;                                          /* L2WUP            */
    uint8  L2IE;                                           /* L2IE             */
    uint8  L2EDE;                                          /* L2EDE            */
    uint8  L2CUC;                                          /* L2CUC            */
    uint8  dummy191[1];                                    /* Reserved         */
    uint8  L2TRC;                                          /* L2TRC            */
    const uint8  L2MST;                                    /* L2MST            */
    uint8  L2ST;                                           /* L2ST             */
    uint8  L2EST;                                          /* L2EST            */
    uint8  L2DFC;                                          /* L2DFC            */
    uint8  L2IDB;                                          /* L2IDB            */
    uint8  L2CBR;                                          /* L2CBR            */
    uint8  dummy192[1];                                    /* Reserved         */
    uint8  L2DBR1;                                         /* L2DBR1           */
    uint8  L2DBR2;                                         /* L2DBR2           */
    uint8  L2DBR3;                                         /* L2DBR3           */
    uint8  L2DBR4;                                         /* L2DBR4           */
    uint8  L2DBR5;                                         /* L2DBR5           */
    uint8  L2DBR6;                                         /* L2DBR6           */
    uint8  L2DBR7;                                         /* L2DBR7           */
    uint8  L2DBR8;                                         /* L2DBR8           */
} __type460;
typedef struct 
{                                                          /* Module           */
    uint8  dummy193[1];                                    /* Reserved         */
    uint8  LWBR;                                           /* LWBR             */
    __type220 LBRP01;                                      /* LBRP01           */
    uint8  LSTC;                                           /* LSTC             */
    uint8  dummy194[3];                                    /* Reserved         */
    uint8  LMD;                                            /* LMD              */
    uint8  LBFC;                                           /* LBFC             */
    uint8  LSC;                                            /* LSC              */
    uint8  LWUP;                                           /* LWUP             */
    uint8  LIE;                                            /* LIE              */
    uint8  LEDE;                                           /* LEDE             */
    uint8  LCUC;                                           /* LCUC             */
    uint8  dummy195[1];                                    /* Reserved         */
    uint8  LTRC;                                           /* LTRC             */
    const uint8  LMST;                                     /* LMST             */
    uint8  LST;                                            /* LST              */
    uint8  LEST;                                           /* LEST             */
    uint8  LDFC;                                           /* LDFC             */
    uint8  LIDB;                                           /* LIDB             */
    uint8  LCBR;                                           /* LCBR             */
    uint8  LUDB0;                                          /* LUDB0            */
    uint8  LDBR1;                                          /* LDBR1            */
    uint8  LDBR2;                                          /* LDBR2            */
    uint8  LDBR3;                                          /* LDBR3            */
    uint8  LDBR4;                                          /* LDBR4            */
    uint8  LDBR5;                                          /* LDBR5            */
    uint8  LDBR6;                                          /* LDBR6            */
    uint8  LDBR7;                                          /* LDBR7            */
    uint8  LDBR8;                                          /* LDBR8            */
    uint8  LUOER;                                          /* LUOER            */
    uint8  LUOR1;                                          /* LUOR1            */
    uint8  dummy196[2];                                    /* Reserved         */
    __type221 LUTDR;                                       /* LUTDR            */
    const __type221 LURDR;                                 /* LURDR            */
    __type221 LUWTDR;                                      /* LUWTDR           */
    uint8  dummy197[22];                                   /* Reserved         */
} __type461;
typedef struct 
{                                                          /* Module           */
    __type210 MODE;                                        /* MODE             */
    __type210 BRT;                                         /* BRT              */
    __type210 V1LW;                                        /* V1LW             */
    __type210 V0LW;                                        /* V0LW             */
    __type210 SAMP;                                        /* SAMP             */
    __type210 FIL;                                         /* FIL              */
    __type210 WU;                                          /* WU               */
    __type210 FRMW;                                        /* FRMW             */
    __type210 SLP;                                         /* SLP              */
    __type210 REP;                                         /* REP              */
    __type210 WUP;                                         /* WUP              */
    __type210 SND;                                         /* SND              */
    __type210 IMSK;                                        /* IMSK             */
    __type210 INT;                                         /* INT              */
    __type210 FLG1;                                        /* FLG1             */
    __type210 FLG2;                                        /* FLG2             */
    const __type210 FLW1;                                  /* FLW1             */
    const __type210 FLW2;                                  /* FLW2             */
    uint8  dummy198[4];                                    /* Reserved         */
    __type210 ERR;                                         /* ERR              */
    uint8  dummy199[16];                                   /* Reserved         */
    const __type210 RPID;                                  /* RPID             */
    uint8  dummy200[12];                                   /* Reserved         */
    __type210 SPID;                                        /* SPID             */
    uint8  dummy201[12];                                   /* Reserved         */
    __type210 RPIDF101;                                    /* RPIDF101         */
    __type210 RPIDF102;                                    /* RPIDF102         */
    __type210 RPIDF103;                                    /* RPIDF103         */
    __type210 RPIDF104;                                    /* RPIDF104         */
    __type210 RPIDF105;                                    /* RPIDF105         */
    __type210 RPIDF106;                                    /* RPIDF106         */
    __type210 RPIDF107;                                    /* RPIDF107         */
    __type210 RPIDF108;                                    /* RPIDF108         */
    __type210 RPIDF109;                                    /* RPIDF109         */
    __type210 RPIDF110;                                    /* RPIDF110         */
    __type210 RPIDF111;                                    /* RPIDF111         */
    __type210 RPIDF112;                                    /* RPIDF112         */
    __type210 RPIDF201;                                    /* RPIDF201         */
    __type210 RPIDF202;                                    /* RPIDF202         */
    __type210 RPIDF203;                                    /* RPIDF203         */
    __type210 RPIDF204;                                    /* RPIDF204         */
    __type210 ARPID;                                       /* ARPID            */
    uint8  dummy202[92];                                   /* Reserved         */
    const __type210 RFRI;                                  /* RFRI             */
    uint8  dummy203[12];                                   /* Reserved         */
    __type210 SFRI;                                        /* SFRI             */
    uint8  dummy204[12];                                   /* Reserved         */
    __type210 ARFRI;                                       /* ARFRI            */
    uint8  dummy205[92];                                   /* Reserved         */
    const __type210 RCRC;                                  /* RCRC             */
    uint8  dummy206[12];                                   /* Reserved         */
    const __type210 SCRC;                                  /* SCRC             */
    uint8  dummy207[12];                                   /* Reserved         */
    const __type210 ARCRC;                                 /* ARCRC            */
    uint8  dummy208[60];                                   /* Reserved         */
    const __type210 RDATA01;                               /* RDATA01          */
    const __type210 RDATA02;                               /* RDATA02          */
    const __type210 RDATA03;                               /* RDATA03          */
    const __type210 RDATA04;                               /* RDATA04          */
    const __type210 RDATA05;                               /* RDATA05          */
    const __type210 RDATA06;                               /* RDATA06          */
    const __type210 RDATA07;                               /* RDATA07          */
    const __type210 RDATA08;                               /* RDATA08          */
    uint8  dummy209[224];                                  /* Reserved         */
    __type210 SDATA01;                                     /* SDATA01          */
    __type210 SDATA02;                                     /* SDATA02          */
    __type210 SDATA03;                                     /* SDATA03          */
    __type210 SDATA04;                                     /* SDATA04          */
    __type210 SDATA05;                                     /* SDATA05          */
    __type210 SDATA06;                                     /* SDATA06          */
    __type210 SDATA07;                                     /* SDATA07          */
    __type210 SDATA08;                                     /* SDATA08          */
    uint8  dummy210[224];                                  /* Reserved         */
    __type210 ARDATA01;                                    /* ARDATA01         */
    __type210 ARDATA02;                                    /* ARDATA02         */
    __type210 ARDATA03;                                    /* ARDATA03         */
    __type210 ARDATA04;                                    /* ARDATA04         */
    __type210 ARDATA05;                                    /* ARDATA05         */
    __type210 ARDATA06;                                    /* ARDATA06         */
    uint8  dummy211[1000];                                 /* Reserved         */
} __type462;
typedef struct 
{                                                          /* Module           */
    uint32 TSPC;                                           /* TSPC             */
    uint32 TSC;                                            /* TSC              */
    uint8  dummy212[8];                                    /* Reserved         */
    uint32 CC;                                             /* CC               */
    uint32 BRP;                                            /* BRP              */
    uint32 IDE;                                            /* IDE              */
    uint32 MDC;                                            /* MDC              */
    uint32 SPCT;                                           /* SPCT             */
    const uint32 MST;                                      /* MST              */
    const uint32 CS;                                       /* CS               */
    uint32 CSC;                                            /* CSC              */
    const uint32 SRTS;                                     /* SRTS             */
    const uint32 SRXD;                                     /* SRXD             */
    const uint32 CPL;                                      /* CPL              */
    const uint32 ML;                                       /* ML               */
    const uint32 FRTS;                                     /* FRTS             */
    const uint32 FRXD;                                     /* FRXD             */
    uint8  dummy213[184];                                  /* Reserved         */
} __type463;
typedef struct 
{                                                          /* Module           */
    __type210 CFDC0NCFG;                                   /* CFDC0NCFG        */
    __type210 CFDC0CTR;                                    /* CFDC0CTR         */
    __type210 CFDC0STS;                                    /* CFDC0STS         */
    __type210 CFDC0ERFL;                                   /* CFDC0ERFL        */
    __type210 CFDC1NCFG;                                   /* CFDC1NCFG        */
    __type210 CFDC1CTR;                                    /* CFDC1CTR         */
    __type210 CFDC1STS;                                    /* CFDC1STS         */
    __type210 CFDC1ERFL;                                   /* CFDC1ERFL        */
    __type210 CFDC2NCFG;                                   /* CFDC2NCFG        */
    __type210 CFDC2CTR;                                    /* CFDC2CTR         */
    __type210 CFDC2STS;                                    /* CFDC2STS         */
    __type210 CFDC2ERFL;                                   /* CFDC2ERFL        */
    __type210 CFDC3NCFG;                                   /* CFDC3NCFG        */
    __type210 CFDC3CTR;                                    /* CFDC3CTR         */
    __type210 CFDC3STS;                                    /* CFDC3STS         */
    __type210 CFDC3ERFL;                                   /* CFDC3ERFL        */
    __type210 CFDC4NCFG;                                   /* CFDC4NCFG        */
    __type210 CFDC4CTR;                                    /* CFDC4CTR         */
    __type210 CFDC4STS;                                    /* CFDC4STS         */
    __type210 CFDC4ERFL;                                   /* CFDC4ERFL        */
    __type210 CFDC5NCFG;                                   /* CFDC5NCFG        */
    __type210 CFDC5CTR;                                    /* CFDC5CTR         */
    __type210 CFDC5STS;                                    /* CFDC5STS         */
    __type210 CFDC5ERFL;                                   /* CFDC5ERFL        */
    uint8  dummy214[36];                                   /* Reserved         */
    __type210 CFDGCFG;                                     /* CFDGCFG          */
    __type210 CFDGCTR;                                     /* CFDGCTR          */
    const __type210 CFDGSTS;                               /* CFDGSTS          */
    __type210 CFDGERFL;                                    /* CFDGERFL         */
    const __type218 CFDGTSC;                               /* CFDGTSC          */
    __type210 CFDGAFLECTR;                                 /* CFDGAFLECTR      */
    __type210 CFDGAFLCFG0;                                 /* CFDGAFLCFG0      */
    __type210 CFDGAFLCFG1;                                 /* CFDGAFLCFG1      */
    __type210 CFDRMNB;                                     /* CFDRMNB          */
    __type210 CFDRMND0;                                    /* CFDRMND0         */
    __type210 CFDRMND1;                                    /* CFDRMND1         */
    __type210 CFDRMND2;                                    /* CFDRMND2         */
    uint8  dummy215[4];                                    /* Reserved         */
    __type210 CFDRFCC0;                                    /* CFDRFCC0         */
    __type210 CFDRFCC1;                                    /* CFDRFCC1         */
    __type210 CFDRFCC2;                                    /* CFDRFCC2         */
    __type210 CFDRFCC3;                                    /* CFDRFCC3         */
    __type210 CFDRFCC4;                                    /* CFDRFCC4         */
    __type210 CFDRFCC5;                                    /* CFDRFCC5         */
    __type210 CFDRFCC6;                                    /* CFDRFCC6         */
    __type210 CFDRFCC7;                                    /* CFDRFCC7         */
    __type210 CFDRFSTS0;                                   /* CFDRFSTS0        */
    __type210 CFDRFSTS1;                                   /* CFDRFSTS1        */
    __type210 CFDRFSTS2;                                   /* CFDRFSTS2        */
    __type210 CFDRFSTS3;                                   /* CFDRFSTS3        */
    __type210 CFDRFSTS4;                                   /* CFDRFSTS4        */
    __type210 CFDRFSTS5;                                   /* CFDRFSTS5        */
    __type210 CFDRFSTS6;                                   /* CFDRFSTS6        */
    __type210 CFDRFSTS7;                                   /* CFDRFSTS7        */
    __type210 CFDRFPCTR0;                                  /* CFDRFPCTR0       */
    __type210 CFDRFPCTR1;                                  /* CFDRFPCTR1       */
    __type210 CFDRFPCTR2;                                  /* CFDRFPCTR2       */
    __type210 CFDRFPCTR3;                                  /* CFDRFPCTR3       */
    __type210 CFDRFPCTR4;                                  /* CFDRFPCTR4       */
    __type210 CFDRFPCTR5;                                  /* CFDRFPCTR5       */
    __type210 CFDRFPCTR6;                                  /* CFDRFPCTR6       */
    __type210 CFDRFPCTR7;                                  /* CFDRFPCTR7       */
    __type210 CFDCFCC0;                                    /* CFDCFCC0         */
    __type210 CFDCFCC1;                                    /* CFDCFCC1         */
    __type210 CFDCFCC2;                                    /* CFDCFCC2         */
    __type210 CFDCFCC3;                                    /* CFDCFCC3         */
    __type210 CFDCFCC4;                                    /* CFDCFCC4         */
    __type210 CFDCFCC5;                                    /* CFDCFCC5         */
    __type210 CFDCFCC6;                                    /* CFDCFCC6         */
    __type210 CFDCFCC7;                                    /* CFDCFCC7         */
    __type210 CFDCFCC8;                                    /* CFDCFCC8         */
    __type210 CFDCFCC9;                                    /* CFDCFCC9         */
    __type210 CFDCFCC10;                                   /* CFDCFCC10        */
    __type210 CFDCFCC11;                                   /* CFDCFCC11        */
    __type210 CFDCFCC12;                                   /* CFDCFCC12        */
    __type210 CFDCFCC13;                                   /* CFDCFCC13        */
    __type210 CFDCFCC14;                                   /* CFDCFCC14        */
    __type210 CFDCFCC15;                                   /* CFDCFCC15        */
    __type210 CFDCFCC16;                                   /* CFDCFCC16        */
    __type210 CFDCFCC17;                                   /* CFDCFCC17        */
    uint8  dummy216[24];                                   /* Reserved         */
    __type210 CFDCFSTS0;                                   /* CFDCFSTS0        */
    __type210 CFDCFSTS1;                                   /* CFDCFSTS1        */
    __type210 CFDCFSTS2;                                   /* CFDCFSTS2        */
    __type210 CFDCFSTS3;                                   /* CFDCFSTS3        */
    __type210 CFDCFSTS4;                                   /* CFDCFSTS4        */
    __type210 CFDCFSTS5;                                   /* CFDCFSTS5        */
    __type210 CFDCFSTS6;                                   /* CFDCFSTS6        */
    __type210 CFDCFSTS7;                                   /* CFDCFSTS7        */
    __type210 CFDCFSTS8;                                   /* CFDCFSTS8        */
    __type210 CFDCFSTS9;                                   /* CFDCFSTS9        */
    __type210 CFDCFSTS10;                                  /* CFDCFSTS10       */
    __type210 CFDCFSTS11;                                  /* CFDCFSTS11       */
    __type210 CFDCFSTS12;                                  /* CFDCFSTS12       */
    __type210 CFDCFSTS13;                                  /* CFDCFSTS13       */
    __type210 CFDCFSTS14;                                  /* CFDCFSTS14       */
    __type210 CFDCFSTS15;                                  /* CFDCFSTS15       */
    __type210 CFDCFSTS16;                                  /* CFDCFSTS16       */
    __type210 CFDCFSTS17;                                  /* CFDCFSTS17       */
    uint8  dummy217[24];                                   /* Reserved         */
    __type210 CFDCFPCTR0;                                  /* CFDCFPCTR0       */
    __type210 CFDCFPCTR1;                                  /* CFDCFPCTR1       */
    __type210 CFDCFPCTR2;                                  /* CFDCFPCTR2       */
    __type210 CFDCFPCTR3;                                  /* CFDCFPCTR3       */
    __type210 CFDCFPCTR4;                                  /* CFDCFPCTR4       */
    __type210 CFDCFPCTR5;                                  /* CFDCFPCTR5       */
    __type210 CFDCFPCTR6;                                  /* CFDCFPCTR6       */
    __type210 CFDCFPCTR7;                                  /* CFDCFPCTR7       */
    __type210 CFDCFPCTR8;                                  /* CFDCFPCTR8       */
    __type210 CFDCFPCTR9;                                  /* CFDCFPCTR9       */
    __type210 CFDCFPCTR10;                                 /* CFDCFPCTR10      */
    __type210 CFDCFPCTR11;                                 /* CFDCFPCTR11      */
    __type210 CFDCFPCTR12;                                 /* CFDCFPCTR12      */
    __type210 CFDCFPCTR13;                                 /* CFDCFPCTR13      */
    __type210 CFDCFPCTR14;                                 /* CFDCFPCTR14      */
    __type210 CFDCFPCTR15;                                 /* CFDCFPCTR15      */
    __type210 CFDCFPCTR16;                                 /* CFDCFPCTR16      */
    __type210 CFDCFPCTR17;                                 /* CFDCFPCTR17      */
    __type210 CFDCFPCTR18;                                 /* CFDCFPCTR18      */
    __type210 CFDCFPCTR19;                                 /* CFDCFPCTR19      */
    __type210 CFDCFPCTR20;                                 /* CFDCFPCTR20      */
    __type210 CFDCFPCTR21;                                 /* CFDCFPCTR21      */
    __type210 CFDCFPCTR22;                                 /* CFDCFPCTR22      */
    __type210 CFDCFPCTR23;                                 /* CFDCFPCTR23      */
    const __type210 CFDFESTS;                              /* CFDFESTS         */
    const __type210 CFDFFSTS;                              /* CFDFFSTS         */
    const __type210 CFDFMSTS;                              /* CFDFMSTS         */
    const __type210 CFDRFISTS;                             /* CFDRFISTS        */
    const __type210 CFDCFRISTS;                            /* CFDCFRISTS       */
    const __type210 CFDCFTISTS;                            /* CFDCFTISTS       */
    uint8  CFDTMC0;                                        /* CFDTMC0          */
    uint8  CFDTMC1;                                        /* CFDTMC1          */
    uint8  CFDTMC2;                                        /* CFDTMC2          */
    uint8  CFDTMC3;                                        /* CFDTMC3          */
    uint8  CFDTMC4;                                        /* CFDTMC4          */
    uint8  CFDTMC5;                                        /* CFDTMC5          */
    uint8  CFDTMC6;                                        /* CFDTMC6          */
    uint8  CFDTMC7;                                        /* CFDTMC7          */
    uint8  CFDTMC8;                                        /* CFDTMC8          */
    uint8  CFDTMC9;                                        /* CFDTMC9          */
    uint8  CFDTMC10;                                       /* CFDTMC10         */
    uint8  CFDTMC11;                                       /* CFDTMC11         */
    uint8  CFDTMC12;                                       /* CFDTMC12         */
    uint8  CFDTMC13;                                       /* CFDTMC13         */
    uint8  CFDTMC14;                                       /* CFDTMC14         */
    uint8  CFDTMC15;                                       /* CFDTMC15         */
    uint8  CFDTMC16;                                       /* CFDTMC16         */
    uint8  CFDTMC17;                                       /* CFDTMC17         */
    uint8  CFDTMC18;                                       /* CFDTMC18         */
    uint8  CFDTMC19;                                       /* CFDTMC19         */
    uint8  CFDTMC20;                                       /* CFDTMC20         */
    uint8  CFDTMC21;                                       /* CFDTMC21         */
    uint8  CFDTMC22;                                       /* CFDTMC22         */
    uint8  CFDTMC23;                                       /* CFDTMC23         */
    uint8  CFDTMC24;                                       /* CFDTMC24         */
    uint8  CFDTMC25;                                       /* CFDTMC25         */
    uint8  CFDTMC26;                                       /* CFDTMC26         */
    uint8  CFDTMC27;                                       /* CFDTMC27         */
    uint8  CFDTMC28;                                       /* CFDTMC28         */
    uint8  CFDTMC29;                                       /* CFDTMC29         */
    uint8  CFDTMC30;                                       /* CFDTMC30         */
    uint8  CFDTMC31;                                       /* CFDTMC31         */
    uint8  CFDTMC32;                                       /* CFDTMC32         */
    uint8  CFDTMC33;                                       /* CFDTMC33         */
    uint8  CFDTMC34;                                       /* CFDTMC34         */
    uint8  CFDTMC35;                                       /* CFDTMC35         */
    uint8  CFDTMC36;                                       /* CFDTMC36         */
    uint8  CFDTMC37;                                       /* CFDTMC37         */
    uint8  CFDTMC38;                                       /* CFDTMC38         */
    uint8  CFDTMC39;                                       /* CFDTMC39         */
    uint8  CFDTMC40;                                       /* CFDTMC40         */
    uint8  CFDTMC41;                                       /* CFDTMC41         */
    uint8  CFDTMC42;                                       /* CFDTMC42         */
    uint8  CFDTMC43;                                       /* CFDTMC43         */
    uint8  CFDTMC44;                                       /* CFDTMC44         */
    uint8  CFDTMC45;                                       /* CFDTMC45         */
    uint8  CFDTMC46;                                       /* CFDTMC46         */
    uint8  CFDTMC47;                                       /* CFDTMC47         */
    uint8  CFDTMC48;                                       /* CFDTMC48         */
    uint8  CFDTMC49;                                       /* CFDTMC49         */
    uint8  CFDTMC50;                                       /* CFDTMC50         */
    uint8  CFDTMC51;                                       /* CFDTMC51         */
    uint8  CFDTMC52;                                       /* CFDTMC52         */
    uint8  CFDTMC53;                                       /* CFDTMC53         */
    uint8  CFDTMC54;                                       /* CFDTMC54         */
    uint8  CFDTMC55;                                       /* CFDTMC55         */
    uint8  CFDTMC56;                                       /* CFDTMC56         */
    uint8  CFDTMC57;                                       /* CFDTMC57         */
    uint8  CFDTMC58;                                       /* CFDTMC58         */
    uint8  CFDTMC59;                                       /* CFDTMC59         */
    uint8  CFDTMC60;                                       /* CFDTMC60         */
    uint8  CFDTMC61;                                       /* CFDTMC61         */
    uint8  CFDTMC62;                                       /* CFDTMC62         */
    uint8  CFDTMC63;                                       /* CFDTMC63         */
    uint8  CFDTMC64;                                       /* CFDTMC64         */
    uint8  CFDTMC65;                                       /* CFDTMC65         */
    uint8  CFDTMC66;                                       /* CFDTMC66         */
    uint8  CFDTMC67;                                       /* CFDTMC67         */
    uint8  CFDTMC68;                                       /* CFDTMC68         */
    uint8  CFDTMC69;                                       /* CFDTMC69         */
    uint8  CFDTMC70;                                       /* CFDTMC70         */
    uint8  CFDTMC71;                                       /* CFDTMC71         */
    uint8  CFDTMC72;                                       /* CFDTMC72         */
    uint8  CFDTMC73;                                       /* CFDTMC73         */
    uint8  CFDTMC74;                                       /* CFDTMC74         */
    uint8  CFDTMC75;                                       /* CFDTMC75         */
    uint8  CFDTMC76;                                       /* CFDTMC76         */
    uint8  CFDTMC77;                                       /* CFDTMC77         */
    uint8  CFDTMC78;                                       /* CFDTMC78         */
    uint8  CFDTMC79;                                       /* CFDTMC79         */
    uint8  CFDTMC80;                                       /* CFDTMC80         */
    uint8  CFDTMC81;                                       /* CFDTMC81         */
    uint8  CFDTMC82;                                       /* CFDTMC82         */
    uint8  CFDTMC83;                                       /* CFDTMC83         */
    uint8  CFDTMC84;                                       /* CFDTMC84         */
    uint8  CFDTMC85;                                       /* CFDTMC85         */
    uint8  CFDTMC86;                                       /* CFDTMC86         */
    uint8  CFDTMC87;                                       /* CFDTMC87         */
    uint8  CFDTMC88;                                       /* CFDTMC88         */
    uint8  CFDTMC89;                                       /* CFDTMC89         */
    uint8  CFDTMC90;                                       /* CFDTMC90         */
    uint8  CFDTMC91;                                       /* CFDTMC91         */
    uint8  CFDTMC92;                                       /* CFDTMC92         */
    uint8  CFDTMC93;                                       /* CFDTMC93         */
    uint8  CFDTMC94;                                       /* CFDTMC94         */
    uint8  CFDTMC95;                                       /* CFDTMC95         */
    uint8  CFDTMC96;                                       /* CFDTMC96         */
    uint8  CFDTMC97;                                       /* CFDTMC97         */
    uint8  CFDTMC98;                                       /* CFDTMC98         */
    uint8  CFDTMC99;                                       /* CFDTMC99         */
    uint8  CFDTMC100;                                      /* CFDTMC100        */
    uint8  CFDTMC101;                                      /* CFDTMC101        */
    uint8  CFDTMC102;                                      /* CFDTMC102        */
    uint8  CFDTMC103;                                      /* CFDTMC103        */
    uint8  CFDTMC104;                                      /* CFDTMC104        */
    uint8  CFDTMC105;                                      /* CFDTMC105        */
    uint8  CFDTMC106;                                      /* CFDTMC106        */
    uint8  CFDTMC107;                                      /* CFDTMC107        */
    uint8  CFDTMC108;                                      /* CFDTMC108        */
    uint8  CFDTMC109;                                      /* CFDTMC109        */
    uint8  CFDTMC110;                                      /* CFDTMC110        */
    uint8  CFDTMC111;                                      /* CFDTMC111        */
    uint8  CFDTMC112;                                      /* CFDTMC112        */
    uint8  CFDTMC113;                                      /* CFDTMC113        */
    uint8  CFDTMC114;                                      /* CFDTMC114        */
    uint8  CFDTMC115;                                      /* CFDTMC115        */
    uint8  CFDTMC116;                                      /* CFDTMC116        */
    uint8  CFDTMC117;                                      /* CFDTMC117        */
    uint8  CFDTMC118;                                      /* CFDTMC118        */
    uint8  CFDTMC119;                                      /* CFDTMC119        */
    uint8  CFDTMC120;                                      /* CFDTMC120        */
    uint8  CFDTMC121;                                      /* CFDTMC121        */
    uint8  CFDTMC122;                                      /* CFDTMC122        */
    uint8  CFDTMC123;                                      /* CFDTMC123        */
    uint8  CFDTMC124;                                      /* CFDTMC124        */
    uint8  CFDTMC125;                                      /* CFDTMC125        */
    uint8  CFDTMC126;                                      /* CFDTMC126        */
    uint8  CFDTMC127;                                      /* CFDTMC127        */
    uint8  CFDTMC128;                                      /* CFDTMC128        */
    uint8  CFDTMC129;                                      /* CFDTMC129        */
    uint8  CFDTMC130;                                      /* CFDTMC130        */
    uint8  CFDTMC131;                                      /* CFDTMC131        */
    uint8  CFDTMC132;                                      /* CFDTMC132        */
    uint8  CFDTMC133;                                      /* CFDTMC133        */
    uint8  CFDTMC134;                                      /* CFDTMC134        */
    uint8  CFDTMC135;                                      /* CFDTMC135        */
    uint8  CFDTMC136;                                      /* CFDTMC136        */
    uint8  CFDTMC137;                                      /* CFDTMC137        */
    uint8  CFDTMC138;                                      /* CFDTMC138        */
    uint8  CFDTMC139;                                      /* CFDTMC139        */
    uint8  CFDTMC140;                                      /* CFDTMC140        */
    uint8  CFDTMC141;                                      /* CFDTMC141        */
    uint8  CFDTMC142;                                      /* CFDTMC142        */
    uint8  CFDTMC143;                                      /* CFDTMC143        */
    uint8  CFDTMC144;                                      /* CFDTMC144        */
    uint8  CFDTMC145;                                      /* CFDTMC145        */
    uint8  CFDTMC146;                                      /* CFDTMC146        */
    uint8  CFDTMC147;                                      /* CFDTMC147        */
    uint8  CFDTMC148;                                      /* CFDTMC148        */
    uint8  CFDTMC149;                                      /* CFDTMC149        */
    uint8  CFDTMC150;                                      /* CFDTMC150        */
    uint8  CFDTMC151;                                      /* CFDTMC151        */
    uint8  CFDTMC152;                                      /* CFDTMC152        */
    uint8  CFDTMC153;                                      /* CFDTMC153        */
    uint8  CFDTMC154;                                      /* CFDTMC154        */
    uint8  CFDTMC155;                                      /* CFDTMC155        */
    uint8  CFDTMC156;                                      /* CFDTMC156        */
    uint8  CFDTMC157;                                      /* CFDTMC157        */
    uint8  CFDTMC158;                                      /* CFDTMC158        */
    uint8  CFDTMC159;                                      /* CFDTMC159        */
    uint8  CFDTMC160;                                      /* CFDTMC160        */
    uint8  CFDTMC161;                                      /* CFDTMC161        */
    uint8  CFDTMC162;                                      /* CFDTMC162        */
    uint8  CFDTMC163;                                      /* CFDTMC163        */
    uint8  CFDTMC164;                                      /* CFDTMC164        */
    uint8  CFDTMC165;                                      /* CFDTMC165        */
    uint8  CFDTMC166;                                      /* CFDTMC166        */
    uint8  CFDTMC167;                                      /* CFDTMC167        */
    uint8  CFDTMC168;                                      /* CFDTMC168        */
    uint8  CFDTMC169;                                      /* CFDTMC169        */
    uint8  CFDTMC170;                                      /* CFDTMC170        */
    uint8  CFDTMC171;                                      /* CFDTMC171        */
    uint8  CFDTMC172;                                      /* CFDTMC172        */
    uint8  CFDTMC173;                                      /* CFDTMC173        */
    uint8  CFDTMC174;                                      /* CFDTMC174        */
    uint8  CFDTMC175;                                      /* CFDTMC175        */
    uint8  CFDTMC176;                                      /* CFDTMC176        */
    uint8  CFDTMC177;                                      /* CFDTMC177        */
    uint8  CFDTMC178;                                      /* CFDTMC178        */
    uint8  CFDTMC179;                                      /* CFDTMC179        */
    uint8  CFDTMC180;                                      /* CFDTMC180        */
    uint8  CFDTMC181;                                      /* CFDTMC181        */
    uint8  CFDTMC182;                                      /* CFDTMC182        */
    uint8  CFDTMC183;                                      /* CFDTMC183        */
    uint8  CFDTMC184;                                      /* CFDTMC184        */
    uint8  CFDTMC185;                                      /* CFDTMC185        */
    uint8  CFDTMC186;                                      /* CFDTMC186        */
    uint8  CFDTMC187;                                      /* CFDTMC187        */
    uint8  CFDTMC188;                                      /* CFDTMC188        */
    uint8  CFDTMC189;                                      /* CFDTMC189        */
    uint8  CFDTMC190;                                      /* CFDTMC190        */
    uint8  CFDTMC191;                                      /* CFDTMC191        */
    uint8  CFDTMC192;                                      /* CFDTMC192        */
    uint8  CFDTMC193;                                      /* CFDTMC193        */
    uint8  CFDTMC194;                                      /* CFDTMC194        */
    uint8  CFDTMC195;                                      /* CFDTMC195        */
    uint8  CFDTMC196;                                      /* CFDTMC196        */
    uint8  CFDTMC197;                                      /* CFDTMC197        */
    uint8  CFDTMC198;                                      /* CFDTMC198        */
    uint8  CFDTMC199;                                      /* CFDTMC199        */
    uint8  CFDTMC200;                                      /* CFDTMC200        */
    uint8  CFDTMC201;                                      /* CFDTMC201        */
    uint8  CFDTMC202;                                      /* CFDTMC202        */
    uint8  CFDTMC203;                                      /* CFDTMC203        */
    uint8  CFDTMC204;                                      /* CFDTMC204        */
    uint8  CFDTMC205;                                      /* CFDTMC205        */
    uint8  CFDTMC206;                                      /* CFDTMC206        */
    uint8  CFDTMC207;                                      /* CFDTMC207        */
    uint8  CFDTMC208;                                      /* CFDTMC208        */
    uint8  CFDTMC209;                                      /* CFDTMC209        */
    uint8  CFDTMC210;                                      /* CFDTMC210        */
    uint8  CFDTMC211;                                      /* CFDTMC211        */
    uint8  CFDTMC212;                                      /* CFDTMC212        */
    uint8  CFDTMC213;                                      /* CFDTMC213        */
    uint8  CFDTMC214;                                      /* CFDTMC214        */
    uint8  CFDTMC215;                                      /* CFDTMC215        */
    uint8  CFDTMC216;                                      /* CFDTMC216        */
    uint8  CFDTMC217;                                      /* CFDTMC217        */
    uint8  CFDTMC218;                                      /* CFDTMC218        */
    uint8  CFDTMC219;                                      /* CFDTMC219        */
    uint8  CFDTMC220;                                      /* CFDTMC220        */
    uint8  CFDTMC221;                                      /* CFDTMC221        */
    uint8  CFDTMC222;                                      /* CFDTMC222        */
    uint8  CFDTMC223;                                      /* CFDTMC223        */
    uint8  CFDTMC224;                                      /* CFDTMC224        */
    uint8  CFDTMC225;                                      /* CFDTMC225        */
    uint8  CFDTMC226;                                      /* CFDTMC226        */
    uint8  CFDTMC227;                                      /* CFDTMC227        */
    uint8  CFDTMC228;                                      /* CFDTMC228        */
    uint8  CFDTMC229;                                      /* CFDTMC229        */
    uint8  CFDTMC230;                                      /* CFDTMC230        */
    uint8  CFDTMC231;                                      /* CFDTMC231        */
    uint8  CFDTMC232;                                      /* CFDTMC232        */
    uint8  CFDTMC233;                                      /* CFDTMC233        */
    uint8  CFDTMC234;                                      /* CFDTMC234        */
    uint8  CFDTMC235;                                      /* CFDTMC235        */
    uint8  CFDTMC236;                                      /* CFDTMC236        */
    uint8  CFDTMC237;                                      /* CFDTMC237        */
    uint8  CFDTMC238;                                      /* CFDTMC238        */
    uint8  CFDTMC239;                                      /* CFDTMC239        */
    uint8  CFDTMC240;                                      /* CFDTMC240        */
    uint8  CFDTMC241;                                      /* CFDTMC241        */
    uint8  CFDTMC242;                                      /* CFDTMC242        */
    uint8  CFDTMC243;                                      /* CFDTMC243        */
    uint8  CFDTMC244;                                      /* CFDTMC244        */
    uint8  CFDTMC245;                                      /* CFDTMC245        */
    uint8  CFDTMC246;                                      /* CFDTMC246        */
    uint8  CFDTMC247;                                      /* CFDTMC247        */
    uint8  CFDTMC248;                                      /* CFDTMC248        */
    uint8  CFDTMC249;                                      /* CFDTMC249        */
    uint8  CFDTMC250;                                      /* CFDTMC250        */
    uint8  CFDTMC251;                                      /* CFDTMC251        */
    uint8  CFDTMC252;                                      /* CFDTMC252        */
    uint8  CFDTMC253;                                      /* CFDTMC253        */
    uint8  CFDTMC254;                                      /* CFDTMC254        */
    uint8  CFDTMC255;                                      /* CFDTMC255        */
    uint8  CFDTMSTS0;                                      /* CFDTMSTS0        */
    uint8  CFDTMSTS1;                                      /* CFDTMSTS1        */
    uint8  CFDTMSTS2;                                      /* CFDTMSTS2        */
    uint8  CFDTMSTS3;                                      /* CFDTMSTS3        */
    uint8  CFDTMSTS4;                                      /* CFDTMSTS4        */
    uint8  CFDTMSTS5;                                      /* CFDTMSTS5        */
    uint8  CFDTMSTS6;                                      /* CFDTMSTS6        */
    uint8  CFDTMSTS7;                                      /* CFDTMSTS7        */
    uint8  CFDTMSTS8;                                      /* CFDTMSTS8        */
    uint8  CFDTMSTS9;                                      /* CFDTMSTS9        */
    uint8  CFDTMSTS10;                                     /* CFDTMSTS10       */
    uint8  CFDTMSTS11;                                     /* CFDTMSTS11       */
    uint8  CFDTMSTS12;                                     /* CFDTMSTS12       */
    uint8  CFDTMSTS13;                                     /* CFDTMSTS13       */
    uint8  CFDTMSTS14;                                     /* CFDTMSTS14       */
    uint8  CFDTMSTS15;                                     /* CFDTMSTS15       */
    uint8  CFDTMSTS16;                                     /* CFDTMSTS16       */
    uint8  CFDTMSTS17;                                     /* CFDTMSTS17       */
    uint8  CFDTMSTS18;                                     /* CFDTMSTS18       */
    uint8  CFDTMSTS19;                                     /* CFDTMSTS19       */
    uint8  CFDTMSTS20;                                     /* CFDTMSTS20       */
    uint8  CFDTMSTS21;                                     /* CFDTMSTS21       */
    uint8  CFDTMSTS22;                                     /* CFDTMSTS22       */
    uint8  CFDTMSTS23;                                     /* CFDTMSTS23       */
    uint8  CFDTMSTS24;                                     /* CFDTMSTS24       */
    uint8  CFDTMSTS25;                                     /* CFDTMSTS25       */
    uint8  CFDTMSTS26;                                     /* CFDTMSTS26       */
    uint8  CFDTMSTS27;                                     /* CFDTMSTS27       */
    uint8  CFDTMSTS28;                                     /* CFDTMSTS28       */
    uint8  CFDTMSTS29;                                     /* CFDTMSTS29       */
    uint8  CFDTMSTS30;                                     /* CFDTMSTS30       */
    uint8  CFDTMSTS31;                                     /* CFDTMSTS31       */
    uint8  CFDTMSTS32;                                     /* CFDTMSTS32       */
    uint8  CFDTMSTS33;                                     /* CFDTMSTS33       */
    uint8  CFDTMSTS34;                                     /* CFDTMSTS34       */
    uint8  CFDTMSTS35;                                     /* CFDTMSTS35       */
    uint8  CFDTMSTS36;                                     /* CFDTMSTS36       */
    uint8  CFDTMSTS37;                                     /* CFDTMSTS37       */
    uint8  CFDTMSTS38;                                     /* CFDTMSTS38       */
    uint8  CFDTMSTS39;                                     /* CFDTMSTS39       */
    uint8  CFDTMSTS40;                                     /* CFDTMSTS40       */
    uint8  CFDTMSTS41;                                     /* CFDTMSTS41       */
    uint8  CFDTMSTS42;                                     /* CFDTMSTS42       */
    uint8  CFDTMSTS43;                                     /* CFDTMSTS43       */
    uint8  CFDTMSTS44;                                     /* CFDTMSTS44       */
    uint8  CFDTMSTS45;                                     /* CFDTMSTS45       */
    uint8  CFDTMSTS46;                                     /* CFDTMSTS46       */
    uint8  CFDTMSTS47;                                     /* CFDTMSTS47       */
    uint8  CFDTMSTS48;                                     /* CFDTMSTS48       */
    uint8  CFDTMSTS49;                                     /* CFDTMSTS49       */
    uint8  CFDTMSTS50;                                     /* CFDTMSTS50       */
    uint8  CFDTMSTS51;                                     /* CFDTMSTS51       */
    uint8  CFDTMSTS52;                                     /* CFDTMSTS52       */
    uint8  CFDTMSTS53;                                     /* CFDTMSTS53       */
    uint8  CFDTMSTS54;                                     /* CFDTMSTS54       */
    uint8  CFDTMSTS55;                                     /* CFDTMSTS55       */
    uint8  CFDTMSTS56;                                     /* CFDTMSTS56       */
    uint8  CFDTMSTS57;                                     /* CFDTMSTS57       */
    uint8  CFDTMSTS58;                                     /* CFDTMSTS58       */
    uint8  CFDTMSTS59;                                     /* CFDTMSTS59       */
    uint8  CFDTMSTS60;                                     /* CFDTMSTS60       */
    uint8  CFDTMSTS61;                                     /* CFDTMSTS61       */
    uint8  CFDTMSTS62;                                     /* CFDTMSTS62       */
    uint8  CFDTMSTS63;                                     /* CFDTMSTS63       */
    uint8  CFDTMSTS64;                                     /* CFDTMSTS64       */
    uint8  CFDTMSTS65;                                     /* CFDTMSTS65       */
    uint8  CFDTMSTS66;                                     /* CFDTMSTS66       */
    uint8  CFDTMSTS67;                                     /* CFDTMSTS67       */
    uint8  CFDTMSTS68;                                     /* CFDTMSTS68       */
    uint8  CFDTMSTS69;                                     /* CFDTMSTS69       */
    uint8  CFDTMSTS70;                                     /* CFDTMSTS70       */
    uint8  CFDTMSTS71;                                     /* CFDTMSTS71       */
    uint8  CFDTMSTS72;                                     /* CFDTMSTS72       */
    uint8  CFDTMSTS73;                                     /* CFDTMSTS73       */
    uint8  CFDTMSTS74;                                     /* CFDTMSTS74       */
    uint8  CFDTMSTS75;                                     /* CFDTMSTS75       */
    uint8  CFDTMSTS76;                                     /* CFDTMSTS76       */
    uint8  CFDTMSTS77;                                     /* CFDTMSTS77       */
    uint8  CFDTMSTS78;                                     /* CFDTMSTS78       */
    uint8  CFDTMSTS79;                                     /* CFDTMSTS79       */
    uint8  CFDTMSTS80;                                     /* CFDTMSTS80       */
    uint8  CFDTMSTS81;                                     /* CFDTMSTS81       */
    uint8  CFDTMSTS82;                                     /* CFDTMSTS82       */
    uint8  CFDTMSTS83;                                     /* CFDTMSTS83       */
    uint8  CFDTMSTS84;                                     /* CFDTMSTS84       */
    uint8  CFDTMSTS85;                                     /* CFDTMSTS85       */
    uint8  CFDTMSTS86;                                     /* CFDTMSTS86       */
    uint8  CFDTMSTS87;                                     /* CFDTMSTS87       */
    uint8  CFDTMSTS88;                                     /* CFDTMSTS88       */
    uint8  CFDTMSTS89;                                     /* CFDTMSTS89       */
    uint8  CFDTMSTS90;                                     /* CFDTMSTS90       */
    uint8  CFDTMSTS91;                                     /* CFDTMSTS91       */
    uint8  CFDTMSTS92;                                     /* CFDTMSTS92       */
    uint8  CFDTMSTS93;                                     /* CFDTMSTS93       */
    uint8  CFDTMSTS94;                                     /* CFDTMSTS94       */
    uint8  CFDTMSTS95;                                     /* CFDTMSTS95       */
    uint8  CFDTMSTS96;                                     /* CFDTMSTS96       */
    uint8  CFDTMSTS97;                                     /* CFDTMSTS97       */
    uint8  CFDTMSTS98;                                     /* CFDTMSTS98       */
    uint8  CFDTMSTS99;                                     /* CFDTMSTS99       */
    uint8  CFDTMSTS100;                                    /* CFDTMSTS100      */
    uint8  CFDTMSTS101;                                    /* CFDTMSTS101      */
    uint8  CFDTMSTS102;                                    /* CFDTMSTS102      */
    uint8  CFDTMSTS103;                                    /* CFDTMSTS103      */
    uint8  CFDTMSTS104;                                    /* CFDTMSTS104      */
    uint8  CFDTMSTS105;                                    /* CFDTMSTS105      */
    uint8  CFDTMSTS106;                                    /* CFDTMSTS106      */
    uint8  CFDTMSTS107;                                    /* CFDTMSTS107      */
    uint8  CFDTMSTS108;                                    /* CFDTMSTS108      */
    uint8  CFDTMSTS109;                                    /* CFDTMSTS109      */
    uint8  CFDTMSTS110;                                    /* CFDTMSTS110      */
    uint8  CFDTMSTS111;                                    /* CFDTMSTS111      */
    uint8  CFDTMSTS112;                                    /* CFDTMSTS112      */
    uint8  CFDTMSTS113;                                    /* CFDTMSTS113      */
    uint8  CFDTMSTS114;                                    /* CFDTMSTS114      */
    uint8  CFDTMSTS115;                                    /* CFDTMSTS115      */
    uint8  CFDTMSTS116;                                    /* CFDTMSTS116      */
    uint8  CFDTMSTS117;                                    /* CFDTMSTS117      */
    uint8  CFDTMSTS118;                                    /* CFDTMSTS118      */
    uint8  CFDTMSTS119;                                    /* CFDTMSTS119      */
    uint8  CFDTMSTS120;                                    /* CFDTMSTS120      */
    uint8  CFDTMSTS121;                                    /* CFDTMSTS121      */
    uint8  CFDTMSTS122;                                    /* CFDTMSTS122      */
    uint8  CFDTMSTS123;                                    /* CFDTMSTS123      */
    uint8  CFDTMSTS124;                                    /* CFDTMSTS124      */
    uint8  CFDTMSTS125;                                    /* CFDTMSTS125      */
    uint8  CFDTMSTS126;                                    /* CFDTMSTS126      */
    uint8  CFDTMSTS127;                                    /* CFDTMSTS127      */
    uint8  CFDTMSTS128;                                    /* CFDTMSTS128      */
    uint8  CFDTMSTS129;                                    /* CFDTMSTS129      */
    uint8  CFDTMSTS130;                                    /* CFDTMSTS130      */
    uint8  CFDTMSTS131;                                    /* CFDTMSTS131      */
    uint8  CFDTMSTS132;                                    /* CFDTMSTS132      */
    uint8  CFDTMSTS133;                                    /* CFDTMSTS133      */
    uint8  CFDTMSTS134;                                    /* CFDTMSTS134      */
    uint8  CFDTMSTS135;                                    /* CFDTMSTS135      */
    uint8  CFDTMSTS136;                                    /* CFDTMSTS136      */
    uint8  CFDTMSTS137;                                    /* CFDTMSTS137      */
    uint8  CFDTMSTS138;                                    /* CFDTMSTS138      */
    uint8  CFDTMSTS139;                                    /* CFDTMSTS139      */
    uint8  CFDTMSTS140;                                    /* CFDTMSTS140      */
    uint8  CFDTMSTS141;                                    /* CFDTMSTS141      */
    uint8  CFDTMSTS142;                                    /* CFDTMSTS142      */
    uint8  CFDTMSTS143;                                    /* CFDTMSTS143      */
    uint8  CFDTMSTS144;                                    /* CFDTMSTS144      */
    uint8  CFDTMSTS145;                                    /* CFDTMSTS145      */
    uint8  CFDTMSTS146;                                    /* CFDTMSTS146      */
    uint8  CFDTMSTS147;                                    /* CFDTMSTS147      */
    uint8  CFDTMSTS148;                                    /* CFDTMSTS148      */
    uint8  CFDTMSTS149;                                    /* CFDTMSTS149      */
    uint8  CFDTMSTS150;                                    /* CFDTMSTS150      */
    uint8  CFDTMSTS151;                                    /* CFDTMSTS151      */
    uint8  CFDTMSTS152;                                    /* CFDTMSTS152      */
    uint8  CFDTMSTS153;                                    /* CFDTMSTS153      */
    uint8  CFDTMSTS154;                                    /* CFDTMSTS154      */
    uint8  CFDTMSTS155;                                    /* CFDTMSTS155      */
    uint8  CFDTMSTS156;                                    /* CFDTMSTS156      */
    uint8  CFDTMSTS157;                                    /* CFDTMSTS157      */
    uint8  CFDTMSTS158;                                    /* CFDTMSTS158      */
    uint8  CFDTMSTS159;                                    /* CFDTMSTS159      */
    uint8  CFDTMSTS160;                                    /* CFDTMSTS160      */
    uint8  CFDTMSTS161;                                    /* CFDTMSTS161      */
    uint8  CFDTMSTS162;                                    /* CFDTMSTS162      */
    uint8  CFDTMSTS163;                                    /* CFDTMSTS163      */
    uint8  CFDTMSTS164;                                    /* CFDTMSTS164      */
    uint8  CFDTMSTS165;                                    /* CFDTMSTS165      */
    uint8  CFDTMSTS166;                                    /* CFDTMSTS166      */
    uint8  CFDTMSTS167;                                    /* CFDTMSTS167      */
    uint8  CFDTMSTS168;                                    /* CFDTMSTS168      */
    uint8  CFDTMSTS169;                                    /* CFDTMSTS169      */
    uint8  CFDTMSTS170;                                    /* CFDTMSTS170      */
    uint8  CFDTMSTS171;                                    /* CFDTMSTS171      */
    uint8  CFDTMSTS172;                                    /* CFDTMSTS172      */
    uint8  CFDTMSTS173;                                    /* CFDTMSTS173      */
    uint8  CFDTMSTS174;                                    /* CFDTMSTS174      */
    uint8  CFDTMSTS175;                                    /* CFDTMSTS175      */
    uint8  CFDTMSTS176;                                    /* CFDTMSTS176      */
    uint8  CFDTMSTS177;                                    /* CFDTMSTS177      */
    uint8  CFDTMSTS178;                                    /* CFDTMSTS178      */
    uint8  CFDTMSTS179;                                    /* CFDTMSTS179      */
    uint8  CFDTMSTS180;                                    /* CFDTMSTS180      */
    uint8  CFDTMSTS181;                                    /* CFDTMSTS181      */
    uint8  CFDTMSTS182;                                    /* CFDTMSTS182      */
    uint8  CFDTMSTS183;                                    /* CFDTMSTS183      */
    uint8  CFDTMSTS184;                                    /* CFDTMSTS184      */
    uint8  CFDTMSTS185;                                    /* CFDTMSTS185      */
    uint8  CFDTMSTS186;                                    /* CFDTMSTS186      */
    uint8  CFDTMSTS187;                                    /* CFDTMSTS187      */
    uint8  CFDTMSTS188;                                    /* CFDTMSTS188      */
    uint8  CFDTMSTS189;                                    /* CFDTMSTS189      */
    uint8  CFDTMSTS190;                                    /* CFDTMSTS190      */
    uint8  CFDTMSTS191;                                    /* CFDTMSTS191      */
    uint8  CFDTMSTS192;                                    /* CFDTMSTS192      */
    uint8  CFDTMSTS193;                                    /* CFDTMSTS193      */
    uint8  CFDTMSTS194;                                    /* CFDTMSTS194      */
    uint8  CFDTMSTS195;                                    /* CFDTMSTS195      */
    uint8  CFDTMSTS196;                                    /* CFDTMSTS196      */
    uint8  CFDTMSTS197;                                    /* CFDTMSTS197      */
    uint8  CFDTMSTS198;                                    /* CFDTMSTS198      */
    uint8  CFDTMSTS199;                                    /* CFDTMSTS199      */
    uint8  CFDTMSTS200;                                    /* CFDTMSTS200      */
    uint8  CFDTMSTS201;                                    /* CFDTMSTS201      */
    uint8  CFDTMSTS202;                                    /* CFDTMSTS202      */
    uint8  CFDTMSTS203;                                    /* CFDTMSTS203      */
    uint8  CFDTMSTS204;                                    /* CFDTMSTS204      */
    uint8  CFDTMSTS205;                                    /* CFDTMSTS205      */
    uint8  CFDTMSTS206;                                    /* CFDTMSTS206      */
    uint8  CFDTMSTS207;                                    /* CFDTMSTS207      */
    uint8  CFDTMSTS208;                                    /* CFDTMSTS208      */
    uint8  CFDTMSTS209;                                    /* CFDTMSTS209      */
    uint8  CFDTMSTS210;                                    /* CFDTMSTS210      */
    uint8  CFDTMSTS211;                                    /* CFDTMSTS211      */
    uint8  CFDTMSTS212;                                    /* CFDTMSTS212      */
    uint8  CFDTMSTS213;                                    /* CFDTMSTS213      */
    uint8  CFDTMSTS214;                                    /* CFDTMSTS214      */
    uint8  CFDTMSTS215;                                    /* CFDTMSTS215      */
    uint8  CFDTMSTS216;                                    /* CFDTMSTS216      */
    uint8  CFDTMSTS217;                                    /* CFDTMSTS217      */
    uint8  CFDTMSTS218;                                    /* CFDTMSTS218      */
    uint8  CFDTMSTS219;                                    /* CFDTMSTS219      */
    uint8  CFDTMSTS220;                                    /* CFDTMSTS220      */
    uint8  CFDTMSTS221;                                    /* CFDTMSTS221      */
    uint8  CFDTMSTS222;                                    /* CFDTMSTS222      */
    uint8  CFDTMSTS223;                                    /* CFDTMSTS223      */
    uint8  CFDTMSTS224;                                    /* CFDTMSTS224      */
    uint8  CFDTMSTS225;                                    /* CFDTMSTS225      */
    uint8  CFDTMSTS226;                                    /* CFDTMSTS226      */
    uint8  CFDTMSTS227;                                    /* CFDTMSTS227      */
    uint8  CFDTMSTS228;                                    /* CFDTMSTS228      */
    uint8  CFDTMSTS229;                                    /* CFDTMSTS229      */
    uint8  CFDTMSTS230;                                    /* CFDTMSTS230      */
    uint8  CFDTMSTS231;                                    /* CFDTMSTS231      */
    uint8  CFDTMSTS232;                                    /* CFDTMSTS232      */
    uint8  CFDTMSTS233;                                    /* CFDTMSTS233      */
    uint8  CFDTMSTS234;                                    /* CFDTMSTS234      */
    uint8  CFDTMSTS235;                                    /* CFDTMSTS235      */
    uint8  CFDTMSTS236;                                    /* CFDTMSTS236      */
    uint8  CFDTMSTS237;                                    /* CFDTMSTS237      */
    uint8  CFDTMSTS238;                                    /* CFDTMSTS238      */
    uint8  CFDTMSTS239;                                    /* CFDTMSTS239      */
    uint8  CFDTMSTS240;                                    /* CFDTMSTS240      */
    uint8  CFDTMSTS241;                                    /* CFDTMSTS241      */
    uint8  CFDTMSTS242;                                    /* CFDTMSTS242      */
    uint8  CFDTMSTS243;                                    /* CFDTMSTS243      */
    uint8  CFDTMSTS244;                                    /* CFDTMSTS244      */
    uint8  CFDTMSTS245;                                    /* CFDTMSTS245      */
    uint8  CFDTMSTS246;                                    /* CFDTMSTS246      */
    uint8  CFDTMSTS247;                                    /* CFDTMSTS247      */
    uint8  CFDTMSTS248;                                    /* CFDTMSTS248      */
    uint8  CFDTMSTS249;                                    /* CFDTMSTS249      */
    uint8  CFDTMSTS250;                                    /* CFDTMSTS250      */
    uint8  CFDTMSTS251;                                    /* CFDTMSTS251      */
    uint8  CFDTMSTS252;                                    /* CFDTMSTS252      */
    uint8  CFDTMSTS253;                                    /* CFDTMSTS253      */
    uint8  CFDTMSTS254;                                    /* CFDTMSTS254      */
    uint8  CFDTMSTS255;                                    /* CFDTMSTS255      */
    const __type210 CFDTMTRSTS0;                           /* CFDTMTRSTS0      */
    const __type210 CFDTMTRSTS1;                           /* CFDTMTRSTS1      */
    const __type210 CFDTMTRSTS2;                           /* CFDTMTRSTS2      */
    const __type210 CFDTMTRSTS3;                           /* CFDTMTRSTS3      */
    const __type210 CFDTMTRSTS4;                           /* CFDTMTRSTS4      */
    const __type210 CFDTMTRSTS5;                           /* CFDTMTRSTS5      */
    uint8  dummy218[8];                                    /* Reserved         */
    const __type210 CFDTMTARSTS0;                          /* CFDTMTARSTS0     */
    const __type210 CFDTMTARSTS1;                          /* CFDTMTARSTS1     */
    const __type210 CFDTMTARSTS2;                          /* CFDTMTARSTS2     */
    const __type210 CFDTMTARSTS3;                          /* CFDTMTARSTS3     */
    const __type210 CFDTMTARSTS4;                          /* CFDTMTARSTS4     */
    const __type210 CFDTMTARSTS5;                          /* CFDTMTARSTS5     */
    uint8  dummy219[8];                                    /* Reserved         */
    const __type210 CFDTMTCSTS0;                           /* CFDTMTCSTS0      */
    const __type210 CFDTMTCSTS1;                           /* CFDTMTCSTS1      */
    const __type210 CFDTMTCSTS2;                           /* CFDTMTCSTS2      */
    const __type210 CFDTMTCSTS3;                           /* CFDTMTCSTS3      */
    const __type210 CFDTMTCSTS4;                           /* CFDTMTCSTS4      */
    const __type210 CFDTMTCSTS5;                           /* CFDTMTCSTS5      */
    uint8  dummy220[8];                                    /* Reserved         */
    const __type210 CFDTMTASTS0;                           /* CFDTMTASTS0      */
    const __type210 CFDTMTASTS1;                           /* CFDTMTASTS1      */
    const __type210 CFDTMTASTS2;                           /* CFDTMTASTS2      */
    const __type210 CFDTMTASTS3;                           /* CFDTMTASTS3      */
    const __type210 CFDTMTASTS4;                           /* CFDTMTASTS4      */
    const __type210 CFDTMTASTS5;                           /* CFDTMTASTS5      */
    uint8  dummy221[8];                                    /* Reserved         */
    __type210 CFDTMIEC0;                                   /* CFDTMIEC0        */
    __type210 CFDTMIEC1;                                   /* CFDTMIEC1        */
    __type210 CFDTMIEC2;                                   /* CFDTMIEC2        */
    __type210 CFDTMIEC3;                                   /* CFDTMIEC3        */
    __type210 CFDTMIEC4;                                   /* CFDTMIEC4        */
    __type210 CFDTMIEC5;                                   /* CFDTMIEC5        */
    uint8  dummy222[104];                                  /* Reserved         */
    __type210 CFDTXQCC0;                                   /* CFDTXQCC0        */
    __type210 CFDTXQCC1;                                   /* CFDTXQCC1        */
    __type210 CFDTXQCC2;                                   /* CFDTXQCC2        */
    __type210 CFDTXQCC3;                                   /* CFDTXQCC3        */
    __type210 CFDTXQCC4;                                   /* CFDTXQCC4        */
    __type210 CFDTXQCC5;                                   /* CFDTXQCC5        */
    __type210 CFDTXQCC6;                                   /* CFDTXQCC6        */
    __type210 CFDTXQCC7;                                   /* CFDTXQCC7        */
    __type210 CFDTXQSTS0;                                  /* CFDTXQSTS0       */
    __type210 CFDTXQSTS1;                                  /* CFDTXQSTS1       */
    __type210 CFDTXQSTS2;                                  /* CFDTXQSTS2       */
    __type210 CFDTXQSTS3;                                  /* CFDTXQSTS3       */
    __type210 CFDTXQSTS4;                                  /* CFDTXQSTS4       */
    __type210 CFDTXQSTS5;                                  /* CFDTXQSTS5       */
    uint8  dummy223[8];                                    /* Reserved         */
    __type210 CFDTXQPCTR0;                                 /* CFDTXQPCTR0      */
    __type210 CFDTXQPCTR1;                                 /* CFDTXQPCTR1      */
    __type210 CFDTXQPCTR2;                                 /* CFDTXQPCTR2      */
    __type210 CFDTXQPCTR3;                                 /* CFDTXQPCTR3      */
    __type210 CFDTXQPCTR4;                                 /* CFDTXQPCTR4      */
    __type210 CFDTXQPCTR5;                                 /* CFDTXQPCTR5      */
    uint8  dummy224[8];                                    /* Reserved         */
    __type210 CFDTHLCC0;                                   /* CFDTHLCC0        */
    __type210 CFDTHLCC1;                                   /* CFDTHLCC1        */
    __type210 CFDTHLCC2;                                   /* CFDTHLCC2        */
    __type210 CFDTHLCC3;                                   /* CFDTHLCC3        */
    __type210 CFDTHLCC4;                                   /* CFDTHLCC4        */
    __type210 CFDTHLCC5;                                   /* CFDTHLCC5        */
    uint8  dummy225[8];                                    /* Reserved         */
    __type210 CFDTHLSTS0;                                  /* CFDTHLSTS0       */
    __type210 CFDTHLSTS1;                                  /* CFDTHLSTS1       */
    __type210 CFDTHLSTS2;                                  /* CFDTHLSTS2       */
    __type210 CFDTHLSTS3;                                  /* CFDTHLSTS3       */
    __type210 CFDTHLSTS4;                                  /* CFDTHLSTS4       */
    __type210 CFDTHLSTS5;                                  /* CFDTHLSTS5       */
    uint8  dummy226[8];                                    /* Reserved         */
    __type210 CFDTHLPCTR0;                                 /* CFDTHLPCTR0      */
    __type210 CFDTHLPCTR1;                                 /* CFDTHLPCTR1      */
    __type210 CFDTHLPCTR2;                                 /* CFDTHLPCTR2      */
    __type210 CFDTHLPCTR3;                                 /* CFDTHLPCTR3      */
    __type210 CFDTHLPCTR4;                                 /* CFDTHLPCTR4      */
    __type210 CFDTHLPCTR5;                                 /* CFDTHLPCTR5      */
    uint8  dummy227[8];                                    /* Reserved         */
    const __type210 CFDGTINTSTS0;                          /* CFDGTINTSTS0     */
    const __type210 CFDGTINTSTS1;                          /* CFDGTINTSTS1     */
    __type210 CFDGTSTCFG;                                  /* CFDGTSTCFG       */
    __type210 CFDGTSTCTR;                                  /* CFDGTSTCTR       */
    uint8  dummy228[4];                                    /* Reserved         */
    __type210 CFDGFDCFG;                                   /* CFDGFDCFG        */
    uint8  dummy229[4];                                    /* Reserved         */
    __type218 CFDGLOCKK;                                   /* CFDGLOCKK        */
    uint8  dummy230[16];                                   /* Reserved         */
    __type210 CFDCDTCT;                                    /* CFDCDTCT         */
    const __type210 CFDCDTSTS;                             /* CFDCDTSTS        */
    uint8  dummy231[184];                                  /* Reserved         */
    __type210 CFDC0DCFG;                                   /* CFDC0DCFG        */
    __type210 CFDC0FDCFG;                                  /* CFDC0FDCFG       */
    __type210 CFDC0FDCTR;                                  /* CFDC0FDCTR       */
    __type210 CFDC0FDSTS;                                  /* CFDC0FDSTS       */
    const __type210 CFDC0FDCRC;                            /* CFDC0FDCRC       */
    uint8  dummy232[12];                                   /* Reserved         */
    __type210 CFDC1DCFG;                                   /* CFDC1DCFG        */
    __type210 CFDC1FDCFG;                                  /* CFDC1FDCFG       */
    __type210 CFDC1FDCTR;                                  /* CFDC1FDCTR       */
    __type210 CFDC1FDSTS;                                  /* CFDC1FDSTS       */
    const __type210 CFDC1FDCRC;                            /* CFDC1FDCRC       */
    uint8  dummy233[12];                                   /* Reserved         */
    __type210 CFDC2DCFG;                                   /* CFDC2DCFG        */
    __type210 CFDC2FDCFG;                                  /* CFDC2FDCFG       */
    __type210 CFDC2FDCTR;                                  /* CFDC2FDCTR       */
    __type210 CFDC2FDSTS;                                  /* CFDC2FDSTS       */
    const __type210 CFDC2FDCRC;                            /* CFDC2FDCRC       */
    uint8  dummy234[12];                                   /* Reserved         */
    __type210 CFDC3DCFG;                                   /* CFDC3DCFG        */
    __type210 CFDC3FDCFG;                                  /* CFDC3FDCFG       */
    __type210 CFDC3FDCTR;                                  /* CFDC3FDCTR       */
    __type210 CFDC3FDSTS;                                  /* CFDC3FDSTS       */
    const __type210 CFDC3FDCRC;                            /* CFDC3FDCRC       */
    uint8  dummy235[12];                                   /* Reserved         */
    __type210 CFDC4DCFG;                                   /* CFDC4DCFG        */
    __type210 CFDC4FDCFG;                                  /* CFDC4FDCFG       */
    __type210 CFDC4FDCTR;                                  /* CFDC4FDCTR       */
    __type210 CFDC4FDSTS;                                  /* CFDC4FDSTS       */
    const __type210 CFDC4FDCRC;                            /* CFDC4FDCRC       */
    uint8  dummy236[12];                                   /* Reserved         */
    __type210 CFDC5DCFG;                                   /* CFDC5DCFG        */
    __type210 CFDC5FDCFG;                                  /* CFDC5FDCFG       */
    __type210 CFDC5FDCTR;                                  /* CFDC5FDCTR       */
    __type210 CFDC5FDSTS;                                  /* CFDC5FDSTS       */
    const __type210 CFDC5FDCRC;                            /* CFDC5FDCRC       */
    uint8  dummy237[2124];                                 /* Reserved         */
    __type210 CFDGAFLID0;                                  /* CFDGAFLID0       */
    __type210 CFDGAFLM0;                                   /* CFDGAFLM0        */
    __type210 CFDGAFLP0_0;                                 /* CFDGAFLP0_0      */
    __type210 CFDGAFLP1_0;                                 /* CFDGAFLP1_0      */
    __type210 CFDGAFLID1;                                  /* CFDGAFLID1       */
    __type210 CFDGAFLM1;                                   /* CFDGAFLM1        */
    __type210 CFDGAFLP0_1;                                 /* CFDGAFLP0_1      */
    __type210 CFDGAFLP1_1;                                 /* CFDGAFLP1_1      */
    __type210 CFDGAFLID2;                                  /* CFDGAFLID2       */
    __type210 CFDGAFLM2;                                   /* CFDGAFLM2        */
    __type210 CFDGAFLP0_2;                                 /* CFDGAFLP0_2      */
    __type210 CFDGAFLP1_2;                                 /* CFDGAFLP1_2      */
    __type210 CFDGAFLID3;                                  /* CFDGAFLID3       */
    __type210 CFDGAFLM3;                                   /* CFDGAFLM3        */
    __type210 CFDGAFLP0_3;                                 /* CFDGAFLP0_3      */
    __type210 CFDGAFLP1_3;                                 /* CFDGAFLP1_3      */
    __type210 CFDGAFLID4;                                  /* CFDGAFLID4       */
    __type210 CFDGAFLM4;                                   /* CFDGAFLM4        */
    __type210 CFDGAFLP0_4;                                 /* CFDGAFLP0_4      */
    __type210 CFDGAFLP1_4;                                 /* CFDGAFLP1_4      */
    __type210 CFDGAFLID5;                                  /* CFDGAFLID5       */
    __type210 CFDGAFLM5;                                   /* CFDGAFLM5        */
    __type210 CFDGAFLP0_5;                                 /* CFDGAFLP0_5      */
    __type210 CFDGAFLP1_5;                                 /* CFDGAFLP1_5      */
    __type210 CFDGAFLID6;                                  /* CFDGAFLID6       */
    __type210 CFDGAFLM6;                                   /* CFDGAFLM6        */
    __type210 CFDGAFLP0_6;                                 /* CFDGAFLP0_6      */
    __type210 CFDGAFLP1_6;                                 /* CFDGAFLP1_6      */
    __type210 CFDGAFLID7;                                  /* CFDGAFLID7       */
    __type210 CFDGAFLM7;                                   /* CFDGAFLM7        */
    __type210 CFDGAFLP0_7;                                 /* CFDGAFLP0_7      */
    __type210 CFDGAFLP1_7;                                 /* CFDGAFLP1_7      */
    __type210 CFDGAFLID8;                                  /* CFDGAFLID8       */
    __type210 CFDGAFLM8;                                   /* CFDGAFLM8        */
    __type210 CFDGAFLP0_8;                                 /* CFDGAFLP0_8      */
    __type210 CFDGAFLP1_8;                                 /* CFDGAFLP1_8      */
    __type210 CFDGAFLID9;                                  /* CFDGAFLID9       */
    __type210 CFDGAFLM9;                                   /* CFDGAFLM9        */
    __type210 CFDGAFLP0_9;                                 /* CFDGAFLP0_9      */
    __type210 CFDGAFLP1_9;                                 /* CFDGAFLP1_9      */
    __type210 CFDGAFLID10;                                 /* CFDGAFLID10      */
    __type210 CFDGAFLM10;                                  /* CFDGAFLM10       */
    __type210 CFDGAFLP0_10;                                /* CFDGAFLP0_10     */
    __type210 CFDGAFLP1_10;                                /* CFDGAFLP1_10     */
    __type210 CFDGAFLID11;                                 /* CFDGAFLID11      */
    __type210 CFDGAFLM11;                                  /* CFDGAFLM11       */
    __type210 CFDGAFLP0_11;                                /* CFDGAFLP0_11     */
    __type210 CFDGAFLP1_11;                                /* CFDGAFLP1_11     */
    __type210 CFDGAFLID12;                                 /* CFDGAFLID12      */
    __type210 CFDGAFLM12;                                  /* CFDGAFLM12       */
    __type210 CFDGAFLP0_12;                                /* CFDGAFLP0_12     */
    __type210 CFDGAFLP1_12;                                /* CFDGAFLP1_12     */
    __type210 CFDGAFLID13;                                 /* CFDGAFLID13      */
    __type210 CFDGAFLM13;                                  /* CFDGAFLM13       */
    __type210 CFDGAFLP0_13;                                /* CFDGAFLP0_13     */
    __type210 CFDGAFLP1_13;                                /* CFDGAFLP1_13     */
    __type210 CFDGAFLID14;                                 /* CFDGAFLID14      */
    __type210 CFDGAFLM14;                                  /* CFDGAFLM14       */
    __type210 CFDGAFLP0_14;                                /* CFDGAFLP0_14     */
    __type210 CFDGAFLP1_14;                                /* CFDGAFLP1_14     */
    __type210 CFDGAFLID15;                                 /* CFDGAFLID15      */
    __type210 CFDGAFLM15;                                  /* CFDGAFLM15       */
    __type210 CFDGAFLP0_15;                                /* CFDGAFLP0_15     */
    __type210 CFDGAFLP1_15;                                /* CFDGAFLP1_15     */
    uint8  dummy238[3840];                                 /* Reserved         */
    const __type210 CFDRMID0;                              /* CFDRMID0         */
    const __type210 CFDRMPTR0;                             /* CFDRMPTR0        */
    const __type210 CFDRMFDSTS0;                           /* CFDRMFDSTS0      */
    const __type210 CFDRMDF0_0;                            /* CFDRMDF0_0       */
    const __type210 CFDRMDF1_0;                            /* CFDRMDF1_0       */
    const __type210 CFDRMDF2_0;                            /* CFDRMDF2_0       */
    const __type210 CFDRMDF3_0;                            /* CFDRMDF3_0       */
    const __type210 CFDRMDF4_0;                            /* CFDRMDF4_0       */
    const __type210 CFDRMDF5_0;                            /* CFDRMDF5_0       */
    const __type210 CFDRMDF6_0;                            /* CFDRMDF6_0       */
    const __type210 CFDRMDF7_0;                            /* CFDRMDF7_0       */
    const __type210 CFDRMDF8_0;                            /* CFDRMDF8_0       */
    const __type210 CFDRMDF9_0;                            /* CFDRMDF9_0       */
    const __type210 CFDRMDF10_0;                           /* CFDRMDF10_0      */
    const __type210 CFDRMDF11_0;                           /* CFDRMDF11_0      */
    const __type210 CFDRMDF12_0;                           /* CFDRMDF12_0      */
    const __type210 CFDRMDF13_0;                           /* CFDRMDF13_0      */
    const __type210 CFDRMDF14_0;                           /* CFDRMDF14_0      */
    const __type210 CFDRMDF15_0;                           /* CFDRMDF15_0      */
    uint8  dummy239[52];                                   /* Reserved         */
    const __type210 CFDRMID1;                              /* CFDRMID1         */
    const __type210 CFDRMPTR1;                             /* CFDRMPTR1        */
    const __type210 CFDRMFDSTS1;                           /* CFDRMFDSTS1      */
    const __type210 CFDRMDF0_1;                            /* CFDRMDF0_1       */
    const __type210 CFDRMDF1_1;                            /* CFDRMDF1_1       */
    const __type210 CFDRMDF2_1;                            /* CFDRMDF2_1       */
    const __type210 CFDRMDF3_1;                            /* CFDRMDF3_1       */
    const __type210 CFDRMDF4_1;                            /* CFDRMDF4_1       */
    const __type210 CFDRMDF5_1;                            /* CFDRMDF5_1       */
    const __type210 CFDRMDF6_1;                            /* CFDRMDF6_1       */
    const __type210 CFDRMDF7_1;                            /* CFDRMDF7_1       */
    const __type210 CFDRMDF8_1;                            /* CFDRMDF8_1       */
    const __type210 CFDRMDF9_1;                            /* CFDRMDF9_1       */
    const __type210 CFDRMDF10_1;                           /* CFDRMDF10_1      */
    const __type210 CFDRMDF11_1;                           /* CFDRMDF11_1      */
    const __type210 CFDRMDF12_1;                           /* CFDRMDF12_1      */
    const __type210 CFDRMDF13_1;                           /* CFDRMDF13_1      */
    const __type210 CFDRMDF14_1;                           /* CFDRMDF14_1      */
    const __type210 CFDRMDF15_1;                           /* CFDRMDF15_1      */
    uint8  dummy240[52];                                   /* Reserved         */
    const __type210 CFDRMID2;                              /* CFDRMID2         */
    const __type210 CFDRMPTR2;                             /* CFDRMPTR2        */
    const __type210 CFDRMFDSTS2;                           /* CFDRMFDSTS2      */
    const __type210 CFDRMDF0_2;                            /* CFDRMDF0_2       */
    const __type210 CFDRMDF1_2;                            /* CFDRMDF1_2       */
    const __type210 CFDRMDF2_2;                            /* CFDRMDF2_2       */
    const __type210 CFDRMDF3_2;                            /* CFDRMDF3_2       */
    const __type210 CFDRMDF4_2;                            /* CFDRMDF4_2       */
    const __type210 CFDRMDF5_2;                            /* CFDRMDF5_2       */
    const __type210 CFDRMDF6_2;                            /* CFDRMDF6_2       */
    const __type210 CFDRMDF7_2;                            /* CFDRMDF7_2       */
    const __type210 CFDRMDF8_2;                            /* CFDRMDF8_2       */
    const __type210 CFDRMDF9_2;                            /* CFDRMDF9_2       */
    const __type210 CFDRMDF10_2;                           /* CFDRMDF10_2      */
    const __type210 CFDRMDF11_2;                           /* CFDRMDF11_2      */
    const __type210 CFDRMDF12_2;                           /* CFDRMDF12_2      */
    const __type210 CFDRMDF13_2;                           /* CFDRMDF13_2      */
    const __type210 CFDRMDF14_2;                           /* CFDRMDF14_2      */
    const __type210 CFDRMDF15_2;                           /* CFDRMDF15_2      */
    uint8  dummy241[52];                                   /* Reserved         */
    const __type210 CFDRMID3;                              /* CFDRMID3         */
    const __type210 CFDRMPTR3;                             /* CFDRMPTR3        */
    const __type210 CFDRMFDSTS3;                           /* CFDRMFDSTS3      */
    const __type210 CFDRMDF0_3;                            /* CFDRMDF0_3       */
    const __type210 CFDRMDF1_3;                            /* CFDRMDF1_3       */
    const __type210 CFDRMDF2_3;                            /* CFDRMDF2_3       */
    const __type210 CFDRMDF3_3;                            /* CFDRMDF3_3       */
    const __type210 CFDRMDF4_3;                            /* CFDRMDF4_3       */
    const __type210 CFDRMDF5_3;                            /* CFDRMDF5_3       */
    const __type210 CFDRMDF6_3;                            /* CFDRMDF6_3       */
    const __type210 CFDRMDF7_3;                            /* CFDRMDF7_3       */
    const __type210 CFDRMDF8_3;                            /* CFDRMDF8_3       */
    const __type210 CFDRMDF9_3;                            /* CFDRMDF9_3       */
    const __type210 CFDRMDF10_3;                           /* CFDRMDF10_3      */
    const __type210 CFDRMDF11_3;                           /* CFDRMDF11_3      */
    const __type210 CFDRMDF12_3;                           /* CFDRMDF12_3      */
    const __type210 CFDRMDF13_3;                           /* CFDRMDF13_3      */
    const __type210 CFDRMDF14_3;                           /* CFDRMDF14_3      */
    const __type210 CFDRMDF15_3;                           /* CFDRMDF15_3      */
    uint8  dummy242[52];                                   /* Reserved         */
    const __type210 CFDRMID4;                              /* CFDRMID4         */
    const __type210 CFDRMPTR4;                             /* CFDRMPTR4        */
    const __type210 CFDRMFDSTS4;                           /* CFDRMFDSTS4      */
    const __type210 CFDRMDF0_4;                            /* CFDRMDF0_4       */
    const __type210 CFDRMDF1_4;                            /* CFDRMDF1_4       */
    const __type210 CFDRMDF2_4;                            /* CFDRMDF2_4       */
    const __type210 CFDRMDF3_4;                            /* CFDRMDF3_4       */
    const __type210 CFDRMDF4_4;                            /* CFDRMDF4_4       */
    const __type210 CFDRMDF5_4;                            /* CFDRMDF5_4       */
    const __type210 CFDRMDF6_4;                            /* CFDRMDF6_4       */
    const __type210 CFDRMDF7_4;                            /* CFDRMDF7_4       */
    const __type210 CFDRMDF8_4;                            /* CFDRMDF8_4       */
    const __type210 CFDRMDF9_4;                            /* CFDRMDF9_4       */
    const __type210 CFDRMDF10_4;                           /* CFDRMDF10_4      */
    const __type210 CFDRMDF11_4;                           /* CFDRMDF11_4      */
    const __type210 CFDRMDF12_4;                           /* CFDRMDF12_4      */
    const __type210 CFDRMDF13_4;                           /* CFDRMDF13_4      */
    const __type210 CFDRMDF14_4;                           /* CFDRMDF14_4      */
    const __type210 CFDRMDF15_4;                           /* CFDRMDF15_4      */
    uint8  dummy243[52];                                   /* Reserved         */
    const __type210 CFDRMID5;                              /* CFDRMID5         */
    const __type210 CFDRMPTR5;                             /* CFDRMPTR5        */
    const __type210 CFDRMFDSTS5;                           /* CFDRMFDSTS5      */
    const __type210 CFDRMDF0_5;                            /* CFDRMDF0_5       */
    const __type210 CFDRMDF1_5;                            /* CFDRMDF1_5       */
    const __type210 CFDRMDF2_5;                            /* CFDRMDF2_5       */
    const __type210 CFDRMDF3_5;                            /* CFDRMDF3_5       */
    const __type210 CFDRMDF4_5;                            /* CFDRMDF4_5       */
    const __type210 CFDRMDF5_5;                            /* CFDRMDF5_5       */
    const __type210 CFDRMDF6_5;                            /* CFDRMDF6_5       */
    const __type210 CFDRMDF7_5;                            /* CFDRMDF7_5       */
    const __type210 CFDRMDF8_5;                            /* CFDRMDF8_5       */
    const __type210 CFDRMDF9_5;                            /* CFDRMDF9_5       */
    const __type210 CFDRMDF10_5;                           /* CFDRMDF10_5      */
    const __type210 CFDRMDF11_5;                           /* CFDRMDF11_5      */
    const __type210 CFDRMDF12_5;                           /* CFDRMDF12_5      */
    const __type210 CFDRMDF13_5;                           /* CFDRMDF13_5      */
    const __type210 CFDRMDF14_5;                           /* CFDRMDF14_5      */
    const __type210 CFDRMDF15_5;                           /* CFDRMDF15_5      */
    uint8  dummy244[52];                                   /* Reserved         */
    const __type210 CFDRMID6;                              /* CFDRMID6         */
    const __type210 CFDRMPTR6;                             /* CFDRMPTR6        */
    const __type210 CFDRMFDSTS6;                           /* CFDRMFDSTS6      */
    const __type210 CFDRMDF0_6;                            /* CFDRMDF0_6       */
    const __type210 CFDRMDF1_6;                            /* CFDRMDF1_6       */
    const __type210 CFDRMDF2_6;                            /* CFDRMDF2_6       */
    const __type210 CFDRMDF3_6;                            /* CFDRMDF3_6       */
    const __type210 CFDRMDF4_6;                            /* CFDRMDF4_6       */
    const __type210 CFDRMDF5_6;                            /* CFDRMDF5_6       */
    const __type210 CFDRMDF6_6;                            /* CFDRMDF6_6       */
    const __type210 CFDRMDF7_6;                            /* CFDRMDF7_6       */
    const __type210 CFDRMDF8_6;                            /* CFDRMDF8_6       */
    const __type210 CFDRMDF9_6;                            /* CFDRMDF9_6       */
    const __type210 CFDRMDF10_6;                           /* CFDRMDF10_6      */
    const __type210 CFDRMDF11_6;                           /* CFDRMDF11_6      */
    const __type210 CFDRMDF12_6;                           /* CFDRMDF12_6      */
    const __type210 CFDRMDF13_6;                           /* CFDRMDF13_6      */
    const __type210 CFDRMDF14_6;                           /* CFDRMDF14_6      */
    const __type210 CFDRMDF15_6;                           /* CFDRMDF15_6      */
    uint8  dummy245[52];                                   /* Reserved         */
    const __type210 CFDRMID7;                              /* CFDRMID7         */
    const __type210 CFDRMPTR7;                             /* CFDRMPTR7        */
    const __type210 CFDRMFDSTS7;                           /* CFDRMFDSTS7      */
    const __type210 CFDRMDF0_7;                            /* CFDRMDF0_7       */
    const __type210 CFDRMDF1_7;                            /* CFDRMDF1_7       */
    const __type210 CFDRMDF2_7;                            /* CFDRMDF2_7       */
    const __type210 CFDRMDF3_7;                            /* CFDRMDF3_7       */
    const __type210 CFDRMDF4_7;                            /* CFDRMDF4_7       */
    const __type210 CFDRMDF5_7;                            /* CFDRMDF5_7       */
    const __type210 CFDRMDF6_7;                            /* CFDRMDF6_7       */
    const __type210 CFDRMDF7_7;                            /* CFDRMDF7_7       */
    const __type210 CFDRMDF8_7;                            /* CFDRMDF8_7       */
    const __type210 CFDRMDF9_7;                            /* CFDRMDF9_7       */
    const __type210 CFDRMDF10_7;                           /* CFDRMDF10_7      */
    const __type210 CFDRMDF11_7;                           /* CFDRMDF11_7      */
    const __type210 CFDRMDF12_7;                           /* CFDRMDF12_7      */
    const __type210 CFDRMDF13_7;                           /* CFDRMDF13_7      */
    const __type210 CFDRMDF14_7;                           /* CFDRMDF14_7      */
    const __type210 CFDRMDF15_7;                           /* CFDRMDF15_7      */
    uint8  dummy246[52];                                   /* Reserved         */
    const __type210 CFDRMID8;                              /* CFDRMID8         */
    const __type210 CFDRMPTR8;                             /* CFDRMPTR8        */
    const __type210 CFDRMFDSTS8;                           /* CFDRMFDSTS8      */
    const __type210 CFDRMDF0_8;                            /* CFDRMDF0_8       */
    const __type210 CFDRMDF1_8;                            /* CFDRMDF1_8       */
    const __type210 CFDRMDF2_8;                            /* CFDRMDF2_8       */
    const __type210 CFDRMDF3_8;                            /* CFDRMDF3_8       */
    const __type210 CFDRMDF4_8;                            /* CFDRMDF4_8       */
    const __type210 CFDRMDF5_8;                            /* CFDRMDF5_8       */
    const __type210 CFDRMDF6_8;                            /* CFDRMDF6_8       */
    const __type210 CFDRMDF7_8;                            /* CFDRMDF7_8       */
    const __type210 CFDRMDF8_8;                            /* CFDRMDF8_8       */
    const __type210 CFDRMDF9_8;                            /* CFDRMDF9_8       */
    const __type210 CFDRMDF10_8;                           /* CFDRMDF10_8      */
    const __type210 CFDRMDF11_8;                           /* CFDRMDF11_8      */
    const __type210 CFDRMDF12_8;                           /* CFDRMDF12_8      */
    const __type210 CFDRMDF13_8;                           /* CFDRMDF13_8      */
    const __type210 CFDRMDF14_8;                           /* CFDRMDF14_8      */
    const __type210 CFDRMDF15_8;                           /* CFDRMDF15_8      */
    uint8  dummy247[52];                                   /* Reserved         */
    const __type210 CFDRMID9;                              /* CFDRMID9         */
    const __type210 CFDRMPTR9;                             /* CFDRMPTR9        */
    const __type210 CFDRMFDSTS9;                           /* CFDRMFDSTS9      */
    const __type210 CFDRMDF0_9;                            /* CFDRMDF0_9       */
    const __type210 CFDRMDF1_9;                            /* CFDRMDF1_9       */
    const __type210 CFDRMDF2_9;                            /* CFDRMDF2_9       */
    const __type210 CFDRMDF3_9;                            /* CFDRMDF3_9       */
    const __type210 CFDRMDF4_9;                            /* CFDRMDF4_9       */
    const __type210 CFDRMDF5_9;                            /* CFDRMDF5_9       */
    const __type210 CFDRMDF6_9;                            /* CFDRMDF6_9       */
    const __type210 CFDRMDF7_9;                            /* CFDRMDF7_9       */
    const __type210 CFDRMDF8_9;                            /* CFDRMDF8_9       */
    const __type210 CFDRMDF9_9;                            /* CFDRMDF9_9       */
    const __type210 CFDRMDF10_9;                           /* CFDRMDF10_9      */
    const __type210 CFDRMDF11_9;                           /* CFDRMDF11_9      */
    const __type210 CFDRMDF12_9;                           /* CFDRMDF12_9      */
    const __type210 CFDRMDF13_9;                           /* CFDRMDF13_9      */
    const __type210 CFDRMDF14_9;                           /* CFDRMDF14_9      */
    const __type210 CFDRMDF15_9;                           /* CFDRMDF15_9      */
    uint8  dummy248[52];                                   /* Reserved         */
    const __type210 CFDRMID10;                             /* CFDRMID10        */
    const __type210 CFDRMPTR10;                            /* CFDRMPTR10       */
    const __type210 CFDRMFDSTS10;                          /* CFDRMFDSTS10     */
    const __type210 CFDRMDF0_10;                           /* CFDRMDF0_10      */
    const __type210 CFDRMDF1_10;                           /* CFDRMDF1_10      */
    const __type210 CFDRMDF2_10;                           /* CFDRMDF2_10      */
    const __type210 CFDRMDF3_10;                           /* CFDRMDF3_10      */
    const __type210 CFDRMDF4_10;                           /* CFDRMDF4_10      */
    const __type210 CFDRMDF5_10;                           /* CFDRMDF5_10      */
    const __type210 CFDRMDF6_10;                           /* CFDRMDF6_10      */
    const __type210 CFDRMDF7_10;                           /* CFDRMDF7_10      */
    const __type210 CFDRMDF8_10;                           /* CFDRMDF8_10      */
    const __type210 CFDRMDF9_10;                           /* CFDRMDF9_10      */
    const __type210 CFDRMDF10_10;                          /* CFDRMDF10_10     */
    const __type210 CFDRMDF11_10;                          /* CFDRMDF11_10     */
    const __type210 CFDRMDF12_10;                          /* CFDRMDF12_10     */
    const __type210 CFDRMDF13_10;                          /* CFDRMDF13_10     */
    const __type210 CFDRMDF14_10;                          /* CFDRMDF14_10     */
    const __type210 CFDRMDF15_10;                          /* CFDRMDF15_10     */
    uint8  dummy249[52];                                   /* Reserved         */
    const __type210 CFDRMID11;                             /* CFDRMID11        */
    const __type210 CFDRMPTR11;                            /* CFDRMPTR11       */
    const __type210 CFDRMFDSTS11;                          /* CFDRMFDSTS11     */
    const __type210 CFDRMDF0_11;                           /* CFDRMDF0_11      */
    const __type210 CFDRMDF1_11;                           /* CFDRMDF1_11      */
    const __type210 CFDRMDF2_11;                           /* CFDRMDF2_11      */
    const __type210 CFDRMDF3_11;                           /* CFDRMDF3_11      */
    const __type210 CFDRMDF4_11;                           /* CFDRMDF4_11      */
    const __type210 CFDRMDF5_11;                           /* CFDRMDF5_11      */
    const __type210 CFDRMDF6_11;                           /* CFDRMDF6_11      */
    const __type210 CFDRMDF7_11;                           /* CFDRMDF7_11      */
    const __type210 CFDRMDF8_11;                           /* CFDRMDF8_11      */
    const __type210 CFDRMDF9_11;                           /* CFDRMDF9_11      */
    const __type210 CFDRMDF10_11;                          /* CFDRMDF10_11     */
    const __type210 CFDRMDF11_11;                          /* CFDRMDF11_11     */
    const __type210 CFDRMDF12_11;                          /* CFDRMDF12_11     */
    const __type210 CFDRMDF13_11;                          /* CFDRMDF13_11     */
    const __type210 CFDRMDF14_11;                          /* CFDRMDF14_11     */
    const __type210 CFDRMDF15_11;                          /* CFDRMDF15_11     */
    uint8  dummy250[52];                                   /* Reserved         */
    const __type210 CFDRMID12;                             /* CFDRMID12        */
    const __type210 CFDRMPTR12;                            /* CFDRMPTR12       */
    const __type210 CFDRMFDSTS12;                          /* CFDRMFDSTS12     */
    const __type210 CFDRMDF0_12;                           /* CFDRMDF0_12      */
    const __type210 CFDRMDF1_12;                           /* CFDRMDF1_12      */
    const __type210 CFDRMDF2_12;                           /* CFDRMDF2_12      */
    const __type210 CFDRMDF3_12;                           /* CFDRMDF3_12      */
    const __type210 CFDRMDF4_12;                           /* CFDRMDF4_12      */
    const __type210 CFDRMDF5_12;                           /* CFDRMDF5_12      */
    const __type210 CFDRMDF6_12;                           /* CFDRMDF6_12      */
    const __type210 CFDRMDF7_12;                           /* CFDRMDF7_12      */
    const __type210 CFDRMDF8_12;                           /* CFDRMDF8_12      */
    const __type210 CFDRMDF9_12;                           /* CFDRMDF9_12      */
    const __type210 CFDRMDF10_12;                          /* CFDRMDF10_12     */
    const __type210 CFDRMDF11_12;                          /* CFDRMDF11_12     */
    const __type210 CFDRMDF12_12;                          /* CFDRMDF12_12     */
    const __type210 CFDRMDF13_12;                          /* CFDRMDF13_12     */
    const __type210 CFDRMDF14_12;                          /* CFDRMDF14_12     */
    const __type210 CFDRMDF15_12;                          /* CFDRMDF15_12     */
    uint8  dummy251[52];                                   /* Reserved         */
    const __type210 CFDRMID13;                             /* CFDRMID13        */
    const __type210 CFDRMPTR13;                            /* CFDRMPTR13       */
    const __type210 CFDRMFDSTS13;                          /* CFDRMFDSTS13     */
    const __type210 CFDRMDF0_13;                           /* CFDRMDF0_13      */
    const __type210 CFDRMDF1_13;                           /* CFDRMDF1_13      */
    const __type210 CFDRMDF2_13;                           /* CFDRMDF2_13      */
    const __type210 CFDRMDF3_13;                           /* CFDRMDF3_13      */
    const __type210 CFDRMDF4_13;                           /* CFDRMDF4_13      */
    const __type210 CFDRMDF5_13;                           /* CFDRMDF5_13      */
    const __type210 CFDRMDF6_13;                           /* CFDRMDF6_13      */
    const __type210 CFDRMDF7_13;                           /* CFDRMDF7_13      */
    const __type210 CFDRMDF8_13;                           /* CFDRMDF8_13      */
    const __type210 CFDRMDF9_13;                           /* CFDRMDF9_13      */
    const __type210 CFDRMDF10_13;                          /* CFDRMDF10_13     */
    const __type210 CFDRMDF11_13;                          /* CFDRMDF11_13     */
    const __type210 CFDRMDF12_13;                          /* CFDRMDF12_13     */
    const __type210 CFDRMDF13_13;                          /* CFDRMDF13_13     */
    const __type210 CFDRMDF14_13;                          /* CFDRMDF14_13     */
    const __type210 CFDRMDF15_13;                          /* CFDRMDF15_13     */
    uint8  dummy252[52];                                   /* Reserved         */
    const __type210 CFDRMID14;                             /* CFDRMID14        */
    const __type210 CFDRMPTR14;                            /* CFDRMPTR14       */
    const __type210 CFDRMFDSTS14;                          /* CFDRMFDSTS14     */
    const __type210 CFDRMDF0_14;                           /* CFDRMDF0_14      */
    const __type210 CFDRMDF1_14;                           /* CFDRMDF1_14      */
    const __type210 CFDRMDF2_14;                           /* CFDRMDF2_14      */
    const __type210 CFDRMDF3_14;                           /* CFDRMDF3_14      */
    const __type210 CFDRMDF4_14;                           /* CFDRMDF4_14      */
    const __type210 CFDRMDF5_14;                           /* CFDRMDF5_14      */
    const __type210 CFDRMDF6_14;                           /* CFDRMDF6_14      */
    const __type210 CFDRMDF7_14;                           /* CFDRMDF7_14      */
    const __type210 CFDRMDF8_14;                           /* CFDRMDF8_14      */
    const __type210 CFDRMDF9_14;                           /* CFDRMDF9_14      */
    const __type210 CFDRMDF10_14;                          /* CFDRMDF10_14     */
    const __type210 CFDRMDF11_14;                          /* CFDRMDF11_14     */
    const __type210 CFDRMDF12_14;                          /* CFDRMDF12_14     */
    const __type210 CFDRMDF13_14;                          /* CFDRMDF13_14     */
    const __type210 CFDRMDF14_14;                          /* CFDRMDF14_14     */
    const __type210 CFDRMDF15_14;                          /* CFDRMDF15_14     */
    uint8  dummy253[52];                                   /* Reserved         */
    const __type210 CFDRMID15;                             /* CFDRMID15        */
    const __type210 CFDRMPTR15;                            /* CFDRMPTR15       */
    const __type210 CFDRMFDSTS15;                          /* CFDRMFDSTS15     */
    const __type210 CFDRMDF0_15;                           /* CFDRMDF0_15      */
    const __type210 CFDRMDF1_15;                           /* CFDRMDF1_15      */
    const __type210 CFDRMDF2_15;                           /* CFDRMDF2_15      */
    const __type210 CFDRMDF3_15;                           /* CFDRMDF3_15      */
    const __type210 CFDRMDF4_15;                           /* CFDRMDF4_15      */
    const __type210 CFDRMDF5_15;                           /* CFDRMDF5_15      */
    const __type210 CFDRMDF6_15;                           /* CFDRMDF6_15      */
    const __type210 CFDRMDF7_15;                           /* CFDRMDF7_15      */
    const __type210 CFDRMDF8_15;                           /* CFDRMDF8_15      */
    const __type210 CFDRMDF9_15;                           /* CFDRMDF9_15      */
    const __type210 CFDRMDF10_15;                          /* CFDRMDF10_15     */
    const __type210 CFDRMDF11_15;                          /* CFDRMDF11_15     */
    const __type210 CFDRMDF12_15;                          /* CFDRMDF12_15     */
    const __type210 CFDRMDF13_15;                          /* CFDRMDF13_15     */
    const __type210 CFDRMDF14_15;                          /* CFDRMDF14_15     */
    const __type210 CFDRMDF15_15;                          /* CFDRMDF15_15     */
    uint8  dummy254[52];                                   /* Reserved         */
    const __type210 CFDRMID16;                             /* CFDRMID16        */
    const __type210 CFDRMPTR16;                            /* CFDRMPTR16       */
    const __type210 CFDRMFDSTS16;                          /* CFDRMFDSTS16     */
    const __type210 CFDRMDF0_16;                           /* CFDRMDF0_16      */
    const __type210 CFDRMDF1_16;                           /* CFDRMDF1_16      */
    const __type210 CFDRMDF2_16;                           /* CFDRMDF2_16      */
    const __type210 CFDRMDF3_16;                           /* CFDRMDF3_16      */
    const __type210 CFDRMDF4_16;                           /* CFDRMDF4_16      */
    const __type210 CFDRMDF5_16;                           /* CFDRMDF5_16      */
    const __type210 CFDRMDF6_16;                           /* CFDRMDF6_16      */
    const __type210 CFDRMDF7_16;                           /* CFDRMDF7_16      */
    const __type210 CFDRMDF8_16;                           /* CFDRMDF8_16      */
    const __type210 CFDRMDF9_16;                           /* CFDRMDF9_16      */
    const __type210 CFDRMDF10_16;                          /* CFDRMDF10_16     */
    const __type210 CFDRMDF11_16;                          /* CFDRMDF11_16     */
    const __type210 CFDRMDF12_16;                          /* CFDRMDF12_16     */
    const __type210 CFDRMDF13_16;                          /* CFDRMDF13_16     */
    const __type210 CFDRMDF14_16;                          /* CFDRMDF14_16     */
    const __type210 CFDRMDF15_16;                          /* CFDRMDF15_16     */
    uint8  dummy255[52];                                   /* Reserved         */
    const __type210 CFDRMID17;                             /* CFDRMID17        */
    const __type210 CFDRMPTR17;                            /* CFDRMPTR17       */
    const __type210 CFDRMFDSTS17;                          /* CFDRMFDSTS17     */
    const __type210 CFDRMDF0_17;                           /* CFDRMDF0_17      */
    const __type210 CFDRMDF1_17;                           /* CFDRMDF1_17      */
    const __type210 CFDRMDF2_17;                           /* CFDRMDF2_17      */
    const __type210 CFDRMDF3_17;                           /* CFDRMDF3_17      */
    const __type210 CFDRMDF4_17;                           /* CFDRMDF4_17      */
    const __type210 CFDRMDF5_17;                           /* CFDRMDF5_17      */
    const __type210 CFDRMDF6_17;                           /* CFDRMDF6_17      */
    const __type210 CFDRMDF7_17;                           /* CFDRMDF7_17      */
    const __type210 CFDRMDF8_17;                           /* CFDRMDF8_17      */
    const __type210 CFDRMDF9_17;                           /* CFDRMDF9_17      */
    const __type210 CFDRMDF10_17;                          /* CFDRMDF10_17     */
    const __type210 CFDRMDF11_17;                          /* CFDRMDF11_17     */
    const __type210 CFDRMDF12_17;                          /* CFDRMDF12_17     */
    const __type210 CFDRMDF13_17;                          /* CFDRMDF13_17     */
    const __type210 CFDRMDF14_17;                          /* CFDRMDF14_17     */
    const __type210 CFDRMDF15_17;                          /* CFDRMDF15_17     */
    uint8  dummy256[52];                                   /* Reserved         */
    const __type210 CFDRMID18;                             /* CFDRMID18        */
    const __type210 CFDRMPTR18;                            /* CFDRMPTR18       */
    const __type210 CFDRMFDSTS18;                          /* CFDRMFDSTS18     */
    const __type210 CFDRMDF0_18;                           /* CFDRMDF0_18      */
    const __type210 CFDRMDF1_18;                           /* CFDRMDF1_18      */
    const __type210 CFDRMDF2_18;                           /* CFDRMDF2_18      */
    const __type210 CFDRMDF3_18;                           /* CFDRMDF3_18      */
    const __type210 CFDRMDF4_18;                           /* CFDRMDF4_18      */
    const __type210 CFDRMDF5_18;                           /* CFDRMDF5_18      */
    const __type210 CFDRMDF6_18;                           /* CFDRMDF6_18      */
    const __type210 CFDRMDF7_18;                           /* CFDRMDF7_18      */
    const __type210 CFDRMDF8_18;                           /* CFDRMDF8_18      */
    const __type210 CFDRMDF9_18;                           /* CFDRMDF9_18      */
    const __type210 CFDRMDF10_18;                          /* CFDRMDF10_18     */
    const __type210 CFDRMDF11_18;                          /* CFDRMDF11_18     */
    const __type210 CFDRMDF12_18;                          /* CFDRMDF12_18     */
    const __type210 CFDRMDF13_18;                          /* CFDRMDF13_18     */
    const __type210 CFDRMDF14_18;                          /* CFDRMDF14_18     */
    const __type210 CFDRMDF15_18;                          /* CFDRMDF15_18     */
    uint8  dummy257[52];                                   /* Reserved         */
    const __type210 CFDRMID19;                             /* CFDRMID19        */
    const __type210 CFDRMPTR19;                            /* CFDRMPTR19       */
    const __type210 CFDRMFDSTS19;                          /* CFDRMFDSTS19     */
    const __type210 CFDRMDF0_19;                           /* CFDRMDF0_19      */
    const __type210 CFDRMDF1_19;                           /* CFDRMDF1_19      */
    const __type210 CFDRMDF2_19;                           /* CFDRMDF2_19      */
    const __type210 CFDRMDF3_19;                           /* CFDRMDF3_19      */
    const __type210 CFDRMDF4_19;                           /* CFDRMDF4_19      */
    const __type210 CFDRMDF5_19;                           /* CFDRMDF5_19      */
    const __type210 CFDRMDF6_19;                           /* CFDRMDF6_19      */
    const __type210 CFDRMDF7_19;                           /* CFDRMDF7_19      */
    const __type210 CFDRMDF8_19;                           /* CFDRMDF8_19      */
    const __type210 CFDRMDF9_19;                           /* CFDRMDF9_19      */
    const __type210 CFDRMDF10_19;                          /* CFDRMDF10_19     */
    const __type210 CFDRMDF11_19;                          /* CFDRMDF11_19     */
    const __type210 CFDRMDF12_19;                          /* CFDRMDF12_19     */
    const __type210 CFDRMDF13_19;                          /* CFDRMDF13_19     */
    const __type210 CFDRMDF14_19;                          /* CFDRMDF14_19     */
    const __type210 CFDRMDF15_19;                          /* CFDRMDF15_19     */
    uint8  dummy258[52];                                   /* Reserved         */
    const __type210 CFDRMID20;                             /* CFDRMID20        */
    const __type210 CFDRMPTR20;                            /* CFDRMPTR20       */
    const __type210 CFDRMFDSTS20;                          /* CFDRMFDSTS20     */
    const __type210 CFDRMDF0_20;                           /* CFDRMDF0_20      */
    const __type210 CFDRMDF1_20;                           /* CFDRMDF1_20      */
    const __type210 CFDRMDF2_20;                           /* CFDRMDF2_20      */
    const __type210 CFDRMDF3_20;                           /* CFDRMDF3_20      */
    const __type210 CFDRMDF4_20;                           /* CFDRMDF4_20      */
    const __type210 CFDRMDF5_20;                           /* CFDRMDF5_20      */
    const __type210 CFDRMDF6_20;                           /* CFDRMDF6_20      */
    const __type210 CFDRMDF7_20;                           /* CFDRMDF7_20      */
    const __type210 CFDRMDF8_20;                           /* CFDRMDF8_20      */
    const __type210 CFDRMDF9_20;                           /* CFDRMDF9_20      */
    const __type210 CFDRMDF10_20;                          /* CFDRMDF10_20     */
    const __type210 CFDRMDF11_20;                          /* CFDRMDF11_20     */
    const __type210 CFDRMDF12_20;                          /* CFDRMDF12_20     */
    const __type210 CFDRMDF13_20;                          /* CFDRMDF13_20     */
    const __type210 CFDRMDF14_20;                          /* CFDRMDF14_20     */
    const __type210 CFDRMDF15_20;                          /* CFDRMDF15_20     */
    uint8  dummy259[52];                                   /* Reserved         */
    const __type210 CFDRMID21;                             /* CFDRMID21        */
    const __type210 CFDRMPTR21;                            /* CFDRMPTR21       */
    const __type210 CFDRMFDSTS21;                          /* CFDRMFDSTS21     */
    const __type210 CFDRMDF0_21;                           /* CFDRMDF0_21      */
    const __type210 CFDRMDF1_21;                           /* CFDRMDF1_21      */
    const __type210 CFDRMDF2_21;                           /* CFDRMDF2_21      */
    const __type210 CFDRMDF3_21;                           /* CFDRMDF3_21      */
    const __type210 CFDRMDF4_21;                           /* CFDRMDF4_21      */
    const __type210 CFDRMDF5_21;                           /* CFDRMDF5_21      */
    const __type210 CFDRMDF6_21;                           /* CFDRMDF6_21      */
    const __type210 CFDRMDF7_21;                           /* CFDRMDF7_21      */
    const __type210 CFDRMDF8_21;                           /* CFDRMDF8_21      */
    const __type210 CFDRMDF9_21;                           /* CFDRMDF9_21      */
    const __type210 CFDRMDF10_21;                          /* CFDRMDF10_21     */
    const __type210 CFDRMDF11_21;                          /* CFDRMDF11_21     */
    const __type210 CFDRMDF12_21;                          /* CFDRMDF12_21     */
    const __type210 CFDRMDF13_21;                          /* CFDRMDF13_21     */
    const __type210 CFDRMDF14_21;                          /* CFDRMDF14_21     */
    const __type210 CFDRMDF15_21;                          /* CFDRMDF15_21     */
    uint8  dummy260[52];                                   /* Reserved         */
    const __type210 CFDRMID22;                             /* CFDRMID22        */
    const __type210 CFDRMPTR22;                            /* CFDRMPTR22       */
    const __type210 CFDRMFDSTS22;                          /* CFDRMFDSTS22     */
    const __type210 CFDRMDF0_22;                           /* CFDRMDF0_22      */
    const __type210 CFDRMDF1_22;                           /* CFDRMDF1_22      */
    const __type210 CFDRMDF2_22;                           /* CFDRMDF2_22      */
    const __type210 CFDRMDF3_22;                           /* CFDRMDF3_22      */
    const __type210 CFDRMDF4_22;                           /* CFDRMDF4_22      */
    const __type210 CFDRMDF5_22;                           /* CFDRMDF5_22      */
    const __type210 CFDRMDF6_22;                           /* CFDRMDF6_22      */
    const __type210 CFDRMDF7_22;                           /* CFDRMDF7_22      */
    const __type210 CFDRMDF8_22;                           /* CFDRMDF8_22      */
    const __type210 CFDRMDF9_22;                           /* CFDRMDF9_22      */
    const __type210 CFDRMDF10_22;                          /* CFDRMDF10_22     */
    const __type210 CFDRMDF11_22;                          /* CFDRMDF11_22     */
    const __type210 CFDRMDF12_22;                          /* CFDRMDF12_22     */
    const __type210 CFDRMDF13_22;                          /* CFDRMDF13_22     */
    const __type210 CFDRMDF14_22;                          /* CFDRMDF14_22     */
    const __type210 CFDRMDF15_22;                          /* CFDRMDF15_22     */
    uint8  dummy261[52];                                   /* Reserved         */
    const __type210 CFDRMID23;                             /* CFDRMID23        */
    const __type210 CFDRMPTR23;                            /* CFDRMPTR23       */
    const __type210 CFDRMFDSTS23;                          /* CFDRMFDSTS23     */
    const __type210 CFDRMDF0_23;                           /* CFDRMDF0_23      */
    const __type210 CFDRMDF1_23;                           /* CFDRMDF1_23      */
    const __type210 CFDRMDF2_23;                           /* CFDRMDF2_23      */
    const __type210 CFDRMDF3_23;                           /* CFDRMDF3_23      */
    const __type210 CFDRMDF4_23;                           /* CFDRMDF4_23      */
    const __type210 CFDRMDF5_23;                           /* CFDRMDF5_23      */
    const __type210 CFDRMDF6_23;                           /* CFDRMDF6_23      */
    const __type210 CFDRMDF7_23;                           /* CFDRMDF7_23      */
    const __type210 CFDRMDF8_23;                           /* CFDRMDF8_23      */
    const __type210 CFDRMDF9_23;                           /* CFDRMDF9_23      */
    const __type210 CFDRMDF10_23;                          /* CFDRMDF10_23     */
    const __type210 CFDRMDF11_23;                          /* CFDRMDF11_23     */
    const __type210 CFDRMDF12_23;                          /* CFDRMDF12_23     */
    const __type210 CFDRMDF13_23;                          /* CFDRMDF13_23     */
    const __type210 CFDRMDF14_23;                          /* CFDRMDF14_23     */
    const __type210 CFDRMDF15_23;                          /* CFDRMDF15_23     */
    uint8  dummy262[52];                                   /* Reserved         */
    const __type210 CFDRMID24;                             /* CFDRMID24        */
    const __type210 CFDRMPTR24;                            /* CFDRMPTR24       */
    const __type210 CFDRMFDSTS24;                          /* CFDRMFDSTS24     */
    const __type210 CFDRMDF0_24;                           /* CFDRMDF0_24      */
    const __type210 CFDRMDF1_24;                           /* CFDRMDF1_24      */
    const __type210 CFDRMDF2_24;                           /* CFDRMDF2_24      */
    const __type210 CFDRMDF3_24;                           /* CFDRMDF3_24      */
    const __type210 CFDRMDF4_24;                           /* CFDRMDF4_24      */
    const __type210 CFDRMDF5_24;                           /* CFDRMDF5_24      */
    const __type210 CFDRMDF6_24;                           /* CFDRMDF6_24      */
    const __type210 CFDRMDF7_24;                           /* CFDRMDF7_24      */
    const __type210 CFDRMDF8_24;                           /* CFDRMDF8_24      */
    const __type210 CFDRMDF9_24;                           /* CFDRMDF9_24      */
    const __type210 CFDRMDF10_24;                          /* CFDRMDF10_24     */
    const __type210 CFDRMDF11_24;                          /* CFDRMDF11_24     */
    const __type210 CFDRMDF12_24;                          /* CFDRMDF12_24     */
    const __type210 CFDRMDF13_24;                          /* CFDRMDF13_24     */
    const __type210 CFDRMDF14_24;                          /* CFDRMDF14_24     */
    const __type210 CFDRMDF15_24;                          /* CFDRMDF15_24     */
    uint8  dummy263[52];                                   /* Reserved         */
    const __type210 CFDRMID25;                             /* CFDRMID25        */
    const __type210 CFDRMPTR25;                            /* CFDRMPTR25       */
    const __type210 CFDRMFDSTS25;                          /* CFDRMFDSTS25     */
    const __type210 CFDRMDF0_25;                           /* CFDRMDF0_25      */
    const __type210 CFDRMDF1_25;                           /* CFDRMDF1_25      */
    const __type210 CFDRMDF2_25;                           /* CFDRMDF2_25      */
    const __type210 CFDRMDF3_25;                           /* CFDRMDF3_25      */
    const __type210 CFDRMDF4_25;                           /* CFDRMDF4_25      */
    const __type210 CFDRMDF5_25;                           /* CFDRMDF5_25      */
    const __type210 CFDRMDF6_25;                           /* CFDRMDF6_25      */
    const __type210 CFDRMDF7_25;                           /* CFDRMDF7_25      */
    const __type210 CFDRMDF8_25;                           /* CFDRMDF8_25      */
    const __type210 CFDRMDF9_25;                           /* CFDRMDF9_25      */
    const __type210 CFDRMDF10_25;                          /* CFDRMDF10_25     */
    const __type210 CFDRMDF11_25;                          /* CFDRMDF11_25     */
    const __type210 CFDRMDF12_25;                          /* CFDRMDF12_25     */
    const __type210 CFDRMDF13_25;                          /* CFDRMDF13_25     */
    const __type210 CFDRMDF14_25;                          /* CFDRMDF14_25     */
    const __type210 CFDRMDF15_25;                          /* CFDRMDF15_25     */
    uint8  dummy264[52];                                   /* Reserved         */
    const __type210 CFDRMID26;                             /* CFDRMID26        */
    const __type210 CFDRMPTR26;                            /* CFDRMPTR26       */
    const __type210 CFDRMFDSTS26;                          /* CFDRMFDSTS26     */
    const __type210 CFDRMDF0_26;                           /* CFDRMDF0_26      */
    const __type210 CFDRMDF1_26;                           /* CFDRMDF1_26      */
    const __type210 CFDRMDF2_26;                           /* CFDRMDF2_26      */
    const __type210 CFDRMDF3_26;                           /* CFDRMDF3_26      */
    const __type210 CFDRMDF4_26;                           /* CFDRMDF4_26      */
    const __type210 CFDRMDF5_26;                           /* CFDRMDF5_26      */
    const __type210 CFDRMDF6_26;                           /* CFDRMDF6_26      */
    const __type210 CFDRMDF7_26;                           /* CFDRMDF7_26      */
    const __type210 CFDRMDF8_26;                           /* CFDRMDF8_26      */
    const __type210 CFDRMDF9_26;                           /* CFDRMDF9_26      */
    const __type210 CFDRMDF10_26;                          /* CFDRMDF10_26     */
    const __type210 CFDRMDF11_26;                          /* CFDRMDF11_26     */
    const __type210 CFDRMDF12_26;                          /* CFDRMDF12_26     */
    const __type210 CFDRMDF13_26;                          /* CFDRMDF13_26     */
    const __type210 CFDRMDF14_26;                          /* CFDRMDF14_26     */
    const __type210 CFDRMDF15_26;                          /* CFDRMDF15_26     */
    uint8  dummy265[52];                                   /* Reserved         */
    const __type210 CFDRMID27;                             /* CFDRMID27        */
    const __type210 CFDRMPTR27;                            /* CFDRMPTR27       */
    const __type210 CFDRMFDSTS27;                          /* CFDRMFDSTS27     */
    const __type210 CFDRMDF0_27;                           /* CFDRMDF0_27      */
    const __type210 CFDRMDF1_27;                           /* CFDRMDF1_27      */
    const __type210 CFDRMDF2_27;                           /* CFDRMDF2_27      */
    const __type210 CFDRMDF3_27;                           /* CFDRMDF3_27      */
    const __type210 CFDRMDF4_27;                           /* CFDRMDF4_27      */
    const __type210 CFDRMDF5_27;                           /* CFDRMDF5_27      */
    const __type210 CFDRMDF6_27;                           /* CFDRMDF6_27      */
    const __type210 CFDRMDF7_27;                           /* CFDRMDF7_27      */
    const __type210 CFDRMDF8_27;                           /* CFDRMDF8_27      */
    const __type210 CFDRMDF9_27;                           /* CFDRMDF9_27      */
    const __type210 CFDRMDF10_27;                          /* CFDRMDF10_27     */
    const __type210 CFDRMDF11_27;                          /* CFDRMDF11_27     */
    const __type210 CFDRMDF12_27;                          /* CFDRMDF12_27     */
    const __type210 CFDRMDF13_27;                          /* CFDRMDF13_27     */
    const __type210 CFDRMDF14_27;                          /* CFDRMDF14_27     */
    const __type210 CFDRMDF15_27;                          /* CFDRMDF15_27     */
    uint8  dummy266[52];                                   /* Reserved         */
    const __type210 CFDRMID28;                             /* CFDRMID28        */
    const __type210 CFDRMPTR28;                            /* CFDRMPTR28       */
    const __type210 CFDRMFDSTS28;                          /* CFDRMFDSTS28     */
    const __type210 CFDRMDF0_28;                           /* CFDRMDF0_28      */
    const __type210 CFDRMDF1_28;                           /* CFDRMDF1_28      */
    const __type210 CFDRMDF2_28;                           /* CFDRMDF2_28      */
    const __type210 CFDRMDF3_28;                           /* CFDRMDF3_28      */
    const __type210 CFDRMDF4_28;                           /* CFDRMDF4_28      */
    const __type210 CFDRMDF5_28;                           /* CFDRMDF5_28      */
    const __type210 CFDRMDF6_28;                           /* CFDRMDF6_28      */
    const __type210 CFDRMDF7_28;                           /* CFDRMDF7_28      */
    const __type210 CFDRMDF8_28;                           /* CFDRMDF8_28      */
    const __type210 CFDRMDF9_28;                           /* CFDRMDF9_28      */
    const __type210 CFDRMDF10_28;                          /* CFDRMDF10_28     */
    const __type210 CFDRMDF11_28;                          /* CFDRMDF11_28     */
    const __type210 CFDRMDF12_28;                          /* CFDRMDF12_28     */
    const __type210 CFDRMDF13_28;                          /* CFDRMDF13_28     */
    const __type210 CFDRMDF14_28;                          /* CFDRMDF14_28     */
    const __type210 CFDRMDF15_28;                          /* CFDRMDF15_28     */
    uint8  dummy267[52];                                   /* Reserved         */
    const __type210 CFDRMID29;                             /* CFDRMID29        */
    const __type210 CFDRMPTR29;                            /* CFDRMPTR29       */
    const __type210 CFDRMFDSTS29;                          /* CFDRMFDSTS29     */
    const __type210 CFDRMDF0_29;                           /* CFDRMDF0_29      */
    const __type210 CFDRMDF1_29;                           /* CFDRMDF1_29      */
    const __type210 CFDRMDF2_29;                           /* CFDRMDF2_29      */
    const __type210 CFDRMDF3_29;                           /* CFDRMDF3_29      */
    const __type210 CFDRMDF4_29;                           /* CFDRMDF4_29      */
    const __type210 CFDRMDF5_29;                           /* CFDRMDF5_29      */
    const __type210 CFDRMDF6_29;                           /* CFDRMDF6_29      */
    const __type210 CFDRMDF7_29;                           /* CFDRMDF7_29      */
    const __type210 CFDRMDF8_29;                           /* CFDRMDF8_29      */
    const __type210 CFDRMDF9_29;                           /* CFDRMDF9_29      */
    const __type210 CFDRMDF10_29;                          /* CFDRMDF10_29     */
    const __type210 CFDRMDF11_29;                          /* CFDRMDF11_29     */
    const __type210 CFDRMDF12_29;                          /* CFDRMDF12_29     */
    const __type210 CFDRMDF13_29;                          /* CFDRMDF13_29     */
    const __type210 CFDRMDF14_29;                          /* CFDRMDF14_29     */
    const __type210 CFDRMDF15_29;                          /* CFDRMDF15_29     */
    uint8  dummy268[52];                                   /* Reserved         */
    const __type210 CFDRMID30;                             /* CFDRMID30        */
    const __type210 CFDRMPTR30;                            /* CFDRMPTR30       */
    const __type210 CFDRMFDSTS30;                          /* CFDRMFDSTS30     */
    const __type210 CFDRMDF0_30;                           /* CFDRMDF0_30      */
    const __type210 CFDRMDF1_30;                           /* CFDRMDF1_30      */
    const __type210 CFDRMDF2_30;                           /* CFDRMDF2_30      */
    const __type210 CFDRMDF3_30;                           /* CFDRMDF3_30      */
    const __type210 CFDRMDF4_30;                           /* CFDRMDF4_30      */
    const __type210 CFDRMDF5_30;                           /* CFDRMDF5_30      */
    const __type210 CFDRMDF6_30;                           /* CFDRMDF6_30      */
    const __type210 CFDRMDF7_30;                           /* CFDRMDF7_30      */
    const __type210 CFDRMDF8_30;                           /* CFDRMDF8_30      */
    const __type210 CFDRMDF9_30;                           /* CFDRMDF9_30      */
    const __type210 CFDRMDF10_30;                          /* CFDRMDF10_30     */
    const __type210 CFDRMDF11_30;                          /* CFDRMDF11_30     */
    const __type210 CFDRMDF12_30;                          /* CFDRMDF12_30     */
    const __type210 CFDRMDF13_30;                          /* CFDRMDF13_30     */
    const __type210 CFDRMDF14_30;                          /* CFDRMDF14_30     */
    const __type210 CFDRMDF15_30;                          /* CFDRMDF15_30     */
    uint8  dummy269[52];                                   /* Reserved         */
    const __type210 CFDRMID31;                             /* CFDRMID31        */
    const __type210 CFDRMPTR31;                            /* CFDRMPTR31       */
    const __type210 CFDRMFDSTS31;                          /* CFDRMFDSTS31     */
    const __type210 CFDRMDF0_31;                           /* CFDRMDF0_31      */
    const __type210 CFDRMDF1_31;                           /* CFDRMDF1_31      */
    const __type210 CFDRMDF2_31;                           /* CFDRMDF2_31      */
    const __type210 CFDRMDF3_31;                           /* CFDRMDF3_31      */
    const __type210 CFDRMDF4_31;                           /* CFDRMDF4_31      */
    const __type210 CFDRMDF5_31;                           /* CFDRMDF5_31      */
    const __type210 CFDRMDF6_31;                           /* CFDRMDF6_31      */
    const __type210 CFDRMDF7_31;                           /* CFDRMDF7_31      */
    const __type210 CFDRMDF8_31;                           /* CFDRMDF8_31      */
    const __type210 CFDRMDF9_31;                           /* CFDRMDF9_31      */
    const __type210 CFDRMDF10_31;                          /* CFDRMDF10_31     */
    const __type210 CFDRMDF11_31;                          /* CFDRMDF11_31     */
    const __type210 CFDRMDF12_31;                          /* CFDRMDF12_31     */
    const __type210 CFDRMDF13_31;                          /* CFDRMDF13_31     */
    const __type210 CFDRMDF14_31;                          /* CFDRMDF14_31     */
    const __type210 CFDRMDF15_31;                          /* CFDRMDF15_31     */
    uint8  dummy270[52];                                   /* Reserved         */
    const __type210 CFDRMID32;                             /* CFDRMID32        */
    const __type210 CFDRMPTR32;                            /* CFDRMPTR32       */
    const __type210 CFDRMFDSTS32;                          /* CFDRMFDSTS32     */
    const __type210 CFDRMDF0_32;                           /* CFDRMDF0_32      */
    const __type210 CFDRMDF1_32;                           /* CFDRMDF1_32      */
    const __type210 CFDRMDF2_32;                           /* CFDRMDF2_32      */
    const __type210 CFDRMDF3_32;                           /* CFDRMDF3_32      */
    const __type210 CFDRMDF4_32;                           /* CFDRMDF4_32      */
    const __type210 CFDRMDF5_32;                           /* CFDRMDF5_32      */
    const __type210 CFDRMDF6_32;                           /* CFDRMDF6_32      */
    const __type210 CFDRMDF7_32;                           /* CFDRMDF7_32      */
    const __type210 CFDRMDF8_32;                           /* CFDRMDF8_32      */
    const __type210 CFDRMDF9_32;                           /* CFDRMDF9_32      */
    const __type210 CFDRMDF10_32;                          /* CFDRMDF10_32     */
    const __type210 CFDRMDF11_32;                          /* CFDRMDF11_32     */
    const __type210 CFDRMDF12_32;                          /* CFDRMDF12_32     */
    const __type210 CFDRMDF13_32;                          /* CFDRMDF13_32     */
    const __type210 CFDRMDF14_32;                          /* CFDRMDF14_32     */
    const __type210 CFDRMDF15_32;                          /* CFDRMDF15_32     */
    uint8  dummy271[52];                                   /* Reserved         */
    const __type210 CFDRMID33;                             /* CFDRMID33        */
    const __type210 CFDRMPTR33;                            /* CFDRMPTR33       */
    const __type210 CFDRMFDSTS33;                          /* CFDRMFDSTS33     */
    const __type210 CFDRMDF0_33;                           /* CFDRMDF0_33      */
    const __type210 CFDRMDF1_33;                           /* CFDRMDF1_33      */
    const __type210 CFDRMDF2_33;                           /* CFDRMDF2_33      */
    const __type210 CFDRMDF3_33;                           /* CFDRMDF3_33      */
    const __type210 CFDRMDF4_33;                           /* CFDRMDF4_33      */
    const __type210 CFDRMDF5_33;                           /* CFDRMDF5_33      */
    const __type210 CFDRMDF6_33;                           /* CFDRMDF6_33      */
    const __type210 CFDRMDF7_33;                           /* CFDRMDF7_33      */
    const __type210 CFDRMDF8_33;                           /* CFDRMDF8_33      */
    const __type210 CFDRMDF9_33;                           /* CFDRMDF9_33      */
    const __type210 CFDRMDF10_33;                          /* CFDRMDF10_33     */
    const __type210 CFDRMDF11_33;                          /* CFDRMDF11_33     */
    const __type210 CFDRMDF12_33;                          /* CFDRMDF12_33     */
    const __type210 CFDRMDF13_33;                          /* CFDRMDF13_33     */
    const __type210 CFDRMDF14_33;                          /* CFDRMDF14_33     */
    const __type210 CFDRMDF15_33;                          /* CFDRMDF15_33     */
    uint8  dummy272[52];                                   /* Reserved         */
    const __type210 CFDRMID34;                             /* CFDRMID34        */
    const __type210 CFDRMPTR34;                            /* CFDRMPTR34       */
    const __type210 CFDRMFDSTS34;                          /* CFDRMFDSTS34     */
    const __type210 CFDRMDF0_34;                           /* CFDRMDF0_34      */
    const __type210 CFDRMDF1_34;                           /* CFDRMDF1_34      */
    const __type210 CFDRMDF2_34;                           /* CFDRMDF2_34      */
    const __type210 CFDRMDF3_34;                           /* CFDRMDF3_34      */
    const __type210 CFDRMDF4_34;                           /* CFDRMDF4_34      */
    const __type210 CFDRMDF5_34;                           /* CFDRMDF5_34      */
    const __type210 CFDRMDF6_34;                           /* CFDRMDF6_34      */
    const __type210 CFDRMDF7_34;                           /* CFDRMDF7_34      */
    const __type210 CFDRMDF8_34;                           /* CFDRMDF8_34      */
    const __type210 CFDRMDF9_34;                           /* CFDRMDF9_34      */
    const __type210 CFDRMDF10_34;                          /* CFDRMDF10_34     */
    const __type210 CFDRMDF11_34;                          /* CFDRMDF11_34     */
    const __type210 CFDRMDF12_34;                          /* CFDRMDF12_34     */
    const __type210 CFDRMDF13_34;                          /* CFDRMDF13_34     */
    const __type210 CFDRMDF14_34;                          /* CFDRMDF14_34     */
    const __type210 CFDRMDF15_34;                          /* CFDRMDF15_34     */
    uint8  dummy273[52];                                   /* Reserved         */
    const __type210 CFDRMID35;                             /* CFDRMID35        */
    const __type210 CFDRMPTR35;                            /* CFDRMPTR35       */
    const __type210 CFDRMFDSTS35;                          /* CFDRMFDSTS35     */
    const __type210 CFDRMDF0_35;                           /* CFDRMDF0_35      */
    const __type210 CFDRMDF1_35;                           /* CFDRMDF1_35      */
    const __type210 CFDRMDF2_35;                           /* CFDRMDF2_35      */
    const __type210 CFDRMDF3_35;                           /* CFDRMDF3_35      */
    const __type210 CFDRMDF4_35;                           /* CFDRMDF4_35      */
    const __type210 CFDRMDF5_35;                           /* CFDRMDF5_35      */
    const __type210 CFDRMDF6_35;                           /* CFDRMDF6_35      */
    const __type210 CFDRMDF7_35;                           /* CFDRMDF7_35      */
    const __type210 CFDRMDF8_35;                           /* CFDRMDF8_35      */
    const __type210 CFDRMDF9_35;                           /* CFDRMDF9_35      */
    const __type210 CFDRMDF10_35;                          /* CFDRMDF10_35     */
    const __type210 CFDRMDF11_35;                          /* CFDRMDF11_35     */
    const __type210 CFDRMDF12_35;                          /* CFDRMDF12_35     */
    const __type210 CFDRMDF13_35;                          /* CFDRMDF13_35     */
    const __type210 CFDRMDF14_35;                          /* CFDRMDF14_35     */
    const __type210 CFDRMDF15_35;                          /* CFDRMDF15_35     */
    uint8  dummy274[52];                                   /* Reserved         */
    const __type210 CFDRMID36;                             /* CFDRMID36        */
    const __type210 CFDRMPTR36;                            /* CFDRMPTR36       */
    const __type210 CFDRMFDSTS36;                          /* CFDRMFDSTS36     */
    const __type210 CFDRMDF0_36;                           /* CFDRMDF0_36      */
    const __type210 CFDRMDF1_36;                           /* CFDRMDF1_36      */
    const __type210 CFDRMDF2_36;                           /* CFDRMDF2_36      */
    const __type210 CFDRMDF3_36;                           /* CFDRMDF3_36      */
    const __type210 CFDRMDF4_36;                           /* CFDRMDF4_36      */
    const __type210 CFDRMDF5_36;                           /* CFDRMDF5_36      */
    const __type210 CFDRMDF6_36;                           /* CFDRMDF6_36      */
    const __type210 CFDRMDF7_36;                           /* CFDRMDF7_36      */
    const __type210 CFDRMDF8_36;                           /* CFDRMDF8_36      */
    const __type210 CFDRMDF9_36;                           /* CFDRMDF9_36      */
    const __type210 CFDRMDF10_36;                          /* CFDRMDF10_36     */
    const __type210 CFDRMDF11_36;                          /* CFDRMDF11_36     */
    const __type210 CFDRMDF12_36;                          /* CFDRMDF12_36     */
    const __type210 CFDRMDF13_36;                          /* CFDRMDF13_36     */
    const __type210 CFDRMDF14_36;                          /* CFDRMDF14_36     */
    const __type210 CFDRMDF15_36;                          /* CFDRMDF15_36     */
    uint8  dummy275[52];                                   /* Reserved         */
    const __type210 CFDRMID37;                             /* CFDRMID37        */
    const __type210 CFDRMPTR37;                            /* CFDRMPTR37       */
    const __type210 CFDRMFDSTS37;                          /* CFDRMFDSTS37     */
    const __type210 CFDRMDF0_37;                           /* CFDRMDF0_37      */
    const __type210 CFDRMDF1_37;                           /* CFDRMDF1_37      */
    const __type210 CFDRMDF2_37;                           /* CFDRMDF2_37      */
    const __type210 CFDRMDF3_37;                           /* CFDRMDF3_37      */
    const __type210 CFDRMDF4_37;                           /* CFDRMDF4_37      */
    const __type210 CFDRMDF5_37;                           /* CFDRMDF5_37      */
    const __type210 CFDRMDF6_37;                           /* CFDRMDF6_37      */
    const __type210 CFDRMDF7_37;                           /* CFDRMDF7_37      */
    const __type210 CFDRMDF8_37;                           /* CFDRMDF8_37      */
    const __type210 CFDRMDF9_37;                           /* CFDRMDF9_37      */
    const __type210 CFDRMDF10_37;                          /* CFDRMDF10_37     */
    const __type210 CFDRMDF11_37;                          /* CFDRMDF11_37     */
    const __type210 CFDRMDF12_37;                          /* CFDRMDF12_37     */
    const __type210 CFDRMDF13_37;                          /* CFDRMDF13_37     */
    const __type210 CFDRMDF14_37;                          /* CFDRMDF14_37     */
    const __type210 CFDRMDF15_37;                          /* CFDRMDF15_37     */
    uint8  dummy276[52];                                   /* Reserved         */
    const __type210 CFDRMID38;                             /* CFDRMID38        */
    const __type210 CFDRMPTR38;                            /* CFDRMPTR38       */
    const __type210 CFDRMFDSTS38;                          /* CFDRMFDSTS38     */
    const __type210 CFDRMDF0_38;                           /* CFDRMDF0_38      */
    const __type210 CFDRMDF1_38;                           /* CFDRMDF1_38      */
    const __type210 CFDRMDF2_38;                           /* CFDRMDF2_38      */
    const __type210 CFDRMDF3_38;                           /* CFDRMDF3_38      */
    const __type210 CFDRMDF4_38;                           /* CFDRMDF4_38      */
    const __type210 CFDRMDF5_38;                           /* CFDRMDF5_38      */
    const __type210 CFDRMDF6_38;                           /* CFDRMDF6_38      */
    const __type210 CFDRMDF7_38;                           /* CFDRMDF7_38      */
    const __type210 CFDRMDF8_38;                           /* CFDRMDF8_38      */
    const __type210 CFDRMDF9_38;                           /* CFDRMDF9_38      */
    const __type210 CFDRMDF10_38;                          /* CFDRMDF10_38     */
    const __type210 CFDRMDF11_38;                          /* CFDRMDF11_38     */
    const __type210 CFDRMDF12_38;                          /* CFDRMDF12_38     */
    const __type210 CFDRMDF13_38;                          /* CFDRMDF13_38     */
    const __type210 CFDRMDF14_38;                          /* CFDRMDF14_38     */
    const __type210 CFDRMDF15_38;                          /* CFDRMDF15_38     */
    uint8  dummy277[52];                                   /* Reserved         */
    const __type210 CFDRMID39;                             /* CFDRMID39        */
    const __type210 CFDRMPTR39;                            /* CFDRMPTR39       */
    const __type210 CFDRMFDSTS39;                          /* CFDRMFDSTS39     */
    const __type210 CFDRMDF0_39;                           /* CFDRMDF0_39      */
    const __type210 CFDRMDF1_39;                           /* CFDRMDF1_39      */
    const __type210 CFDRMDF2_39;                           /* CFDRMDF2_39      */
    const __type210 CFDRMDF3_39;                           /* CFDRMDF3_39      */
    const __type210 CFDRMDF4_39;                           /* CFDRMDF4_39      */
    const __type210 CFDRMDF5_39;                           /* CFDRMDF5_39      */
    const __type210 CFDRMDF6_39;                           /* CFDRMDF6_39      */
    const __type210 CFDRMDF7_39;                           /* CFDRMDF7_39      */
    const __type210 CFDRMDF8_39;                           /* CFDRMDF8_39      */
    const __type210 CFDRMDF9_39;                           /* CFDRMDF9_39      */
    const __type210 CFDRMDF10_39;                          /* CFDRMDF10_39     */
    const __type210 CFDRMDF11_39;                          /* CFDRMDF11_39     */
    const __type210 CFDRMDF12_39;                          /* CFDRMDF12_39     */
    const __type210 CFDRMDF13_39;                          /* CFDRMDF13_39     */
    const __type210 CFDRMDF14_39;                          /* CFDRMDF14_39     */
    const __type210 CFDRMDF15_39;                          /* CFDRMDF15_39     */
    uint8  dummy278[52];                                   /* Reserved         */
    const __type210 CFDRMID40;                             /* CFDRMID40        */
    const __type210 CFDRMPTR40;                            /* CFDRMPTR40       */
    const __type210 CFDRMFDSTS40;                          /* CFDRMFDSTS40     */
    const __type210 CFDRMDF0_40;                           /* CFDRMDF0_40      */
    const __type210 CFDRMDF1_40;                           /* CFDRMDF1_40      */
    const __type210 CFDRMDF2_40;                           /* CFDRMDF2_40      */
    const __type210 CFDRMDF3_40;                           /* CFDRMDF3_40      */
    const __type210 CFDRMDF4_40;                           /* CFDRMDF4_40      */
    const __type210 CFDRMDF5_40;                           /* CFDRMDF5_40      */
    const __type210 CFDRMDF6_40;                           /* CFDRMDF6_40      */
    const __type210 CFDRMDF7_40;                           /* CFDRMDF7_40      */
    const __type210 CFDRMDF8_40;                           /* CFDRMDF8_40      */
    const __type210 CFDRMDF9_40;                           /* CFDRMDF9_40      */
    const __type210 CFDRMDF10_40;                          /* CFDRMDF10_40     */
    const __type210 CFDRMDF11_40;                          /* CFDRMDF11_40     */
    const __type210 CFDRMDF12_40;                          /* CFDRMDF12_40     */
    const __type210 CFDRMDF13_40;                          /* CFDRMDF13_40     */
    const __type210 CFDRMDF14_40;                          /* CFDRMDF14_40     */
    const __type210 CFDRMDF15_40;                          /* CFDRMDF15_40     */
    uint8  dummy279[52];                                   /* Reserved         */
    const __type210 CFDRMID41;                             /* CFDRMID41        */
    const __type210 CFDRMPTR41;                            /* CFDRMPTR41       */
    const __type210 CFDRMFDSTS41;                          /* CFDRMFDSTS41     */
    const __type210 CFDRMDF0_41;                           /* CFDRMDF0_41      */
    const __type210 CFDRMDF1_41;                           /* CFDRMDF1_41      */
    const __type210 CFDRMDF2_41;                           /* CFDRMDF2_41      */
    const __type210 CFDRMDF3_41;                           /* CFDRMDF3_41      */
    const __type210 CFDRMDF4_41;                           /* CFDRMDF4_41      */
    const __type210 CFDRMDF5_41;                           /* CFDRMDF5_41      */
    const __type210 CFDRMDF6_41;                           /* CFDRMDF6_41      */
    const __type210 CFDRMDF7_41;                           /* CFDRMDF7_41      */
    const __type210 CFDRMDF8_41;                           /* CFDRMDF8_41      */
    const __type210 CFDRMDF9_41;                           /* CFDRMDF9_41      */
    const __type210 CFDRMDF10_41;                          /* CFDRMDF10_41     */
    const __type210 CFDRMDF11_41;                          /* CFDRMDF11_41     */
    const __type210 CFDRMDF12_41;                          /* CFDRMDF12_41     */
    const __type210 CFDRMDF13_41;                          /* CFDRMDF13_41     */
    const __type210 CFDRMDF14_41;                          /* CFDRMDF14_41     */
    const __type210 CFDRMDF15_41;                          /* CFDRMDF15_41     */
    uint8  dummy280[52];                                   /* Reserved         */
    const __type210 CFDRMID42;                             /* CFDRMID42        */
    const __type210 CFDRMPTR42;                            /* CFDRMPTR42       */
    const __type210 CFDRMFDSTS42;                          /* CFDRMFDSTS42     */
    const __type210 CFDRMDF0_42;                           /* CFDRMDF0_42      */
    const __type210 CFDRMDF1_42;                           /* CFDRMDF1_42      */
    const __type210 CFDRMDF2_42;                           /* CFDRMDF2_42      */
    const __type210 CFDRMDF3_42;                           /* CFDRMDF3_42      */
    const __type210 CFDRMDF4_42;                           /* CFDRMDF4_42      */
    const __type210 CFDRMDF5_42;                           /* CFDRMDF5_42      */
    const __type210 CFDRMDF6_42;                           /* CFDRMDF6_42      */
    const __type210 CFDRMDF7_42;                           /* CFDRMDF7_42      */
    const __type210 CFDRMDF8_42;                           /* CFDRMDF8_42      */
    const __type210 CFDRMDF9_42;                           /* CFDRMDF9_42      */
    const __type210 CFDRMDF10_42;                          /* CFDRMDF10_42     */
    const __type210 CFDRMDF11_42;                          /* CFDRMDF11_42     */
    const __type210 CFDRMDF12_42;                          /* CFDRMDF12_42     */
    const __type210 CFDRMDF13_42;                          /* CFDRMDF13_42     */
    const __type210 CFDRMDF14_42;                          /* CFDRMDF14_42     */
    const __type210 CFDRMDF15_42;                          /* CFDRMDF15_42     */
    uint8  dummy281[52];                                   /* Reserved         */
    const __type210 CFDRMID43;                             /* CFDRMID43        */
    const __type210 CFDRMPTR43;                            /* CFDRMPTR43       */
    const __type210 CFDRMFDSTS43;                          /* CFDRMFDSTS43     */
    const __type210 CFDRMDF0_43;                           /* CFDRMDF0_43      */
    const __type210 CFDRMDF1_43;                           /* CFDRMDF1_43      */
    const __type210 CFDRMDF2_43;                           /* CFDRMDF2_43      */
    const __type210 CFDRMDF3_43;                           /* CFDRMDF3_43      */
    const __type210 CFDRMDF4_43;                           /* CFDRMDF4_43      */
    const __type210 CFDRMDF5_43;                           /* CFDRMDF5_43      */
    const __type210 CFDRMDF6_43;                           /* CFDRMDF6_43      */
    const __type210 CFDRMDF7_43;                           /* CFDRMDF7_43      */
    const __type210 CFDRMDF8_43;                           /* CFDRMDF8_43      */
    const __type210 CFDRMDF9_43;                           /* CFDRMDF9_43      */
    const __type210 CFDRMDF10_43;                          /* CFDRMDF10_43     */
    const __type210 CFDRMDF11_43;                          /* CFDRMDF11_43     */
    const __type210 CFDRMDF12_43;                          /* CFDRMDF12_43     */
    const __type210 CFDRMDF13_43;                          /* CFDRMDF13_43     */
    const __type210 CFDRMDF14_43;                          /* CFDRMDF14_43     */
    const __type210 CFDRMDF15_43;                          /* CFDRMDF15_43     */
    uint8  dummy282[52];                                   /* Reserved         */
    const __type210 CFDRMID44;                             /* CFDRMID44        */
    const __type210 CFDRMPTR44;                            /* CFDRMPTR44       */
    const __type210 CFDRMFDSTS44;                          /* CFDRMFDSTS44     */
    const __type210 CFDRMDF0_44;                           /* CFDRMDF0_44      */
    const __type210 CFDRMDF1_44;                           /* CFDRMDF1_44      */
    const __type210 CFDRMDF2_44;                           /* CFDRMDF2_44      */
    const __type210 CFDRMDF3_44;                           /* CFDRMDF3_44      */
    const __type210 CFDRMDF4_44;                           /* CFDRMDF4_44      */
    const __type210 CFDRMDF5_44;                           /* CFDRMDF5_44      */
    const __type210 CFDRMDF6_44;                           /* CFDRMDF6_44      */
    const __type210 CFDRMDF7_44;                           /* CFDRMDF7_44      */
    const __type210 CFDRMDF8_44;                           /* CFDRMDF8_44      */
    const __type210 CFDRMDF9_44;                           /* CFDRMDF9_44      */
    const __type210 CFDRMDF10_44;                          /* CFDRMDF10_44     */
    const __type210 CFDRMDF11_44;                          /* CFDRMDF11_44     */
    const __type210 CFDRMDF12_44;                          /* CFDRMDF12_44     */
    const __type210 CFDRMDF13_44;                          /* CFDRMDF13_44     */
    const __type210 CFDRMDF14_44;                          /* CFDRMDF14_44     */
    const __type210 CFDRMDF15_44;                          /* CFDRMDF15_44     */
    uint8  dummy283[52];                                   /* Reserved         */
    const __type210 CFDRMID45;                             /* CFDRMID45        */
    const __type210 CFDRMPTR45;                            /* CFDRMPTR45       */
    const __type210 CFDRMFDSTS45;                          /* CFDRMFDSTS45     */
    const __type210 CFDRMDF0_45;                           /* CFDRMDF0_45      */
    const __type210 CFDRMDF1_45;                           /* CFDRMDF1_45      */
    const __type210 CFDRMDF2_45;                           /* CFDRMDF2_45      */
    const __type210 CFDRMDF3_45;                           /* CFDRMDF3_45      */
    const __type210 CFDRMDF4_45;                           /* CFDRMDF4_45      */
    const __type210 CFDRMDF5_45;                           /* CFDRMDF5_45      */
    const __type210 CFDRMDF6_45;                           /* CFDRMDF6_45      */
    const __type210 CFDRMDF7_45;                           /* CFDRMDF7_45      */
    const __type210 CFDRMDF8_45;                           /* CFDRMDF8_45      */
    const __type210 CFDRMDF9_45;                           /* CFDRMDF9_45      */
    const __type210 CFDRMDF10_45;                          /* CFDRMDF10_45     */
    const __type210 CFDRMDF11_45;                          /* CFDRMDF11_45     */
    const __type210 CFDRMDF12_45;                          /* CFDRMDF12_45     */
    const __type210 CFDRMDF13_45;                          /* CFDRMDF13_45     */
    const __type210 CFDRMDF14_45;                          /* CFDRMDF14_45     */
    const __type210 CFDRMDF15_45;                          /* CFDRMDF15_45     */
    uint8  dummy284[52];                                   /* Reserved         */
    const __type210 CFDRMID46;                             /* CFDRMID46        */
    const __type210 CFDRMPTR46;                            /* CFDRMPTR46       */
    const __type210 CFDRMFDSTS46;                          /* CFDRMFDSTS46     */
    const __type210 CFDRMDF0_46;                           /* CFDRMDF0_46      */
    const __type210 CFDRMDF1_46;                           /* CFDRMDF1_46      */
    const __type210 CFDRMDF2_46;                           /* CFDRMDF2_46      */
    const __type210 CFDRMDF3_46;                           /* CFDRMDF3_46      */
    const __type210 CFDRMDF4_46;                           /* CFDRMDF4_46      */
    const __type210 CFDRMDF5_46;                           /* CFDRMDF5_46      */
    const __type210 CFDRMDF6_46;                           /* CFDRMDF6_46      */
    const __type210 CFDRMDF7_46;                           /* CFDRMDF7_46      */
    const __type210 CFDRMDF8_46;                           /* CFDRMDF8_46      */
    const __type210 CFDRMDF9_46;                           /* CFDRMDF9_46      */
    const __type210 CFDRMDF10_46;                          /* CFDRMDF10_46     */
    const __type210 CFDRMDF11_46;                          /* CFDRMDF11_46     */
    const __type210 CFDRMDF12_46;                          /* CFDRMDF12_46     */
    const __type210 CFDRMDF13_46;                          /* CFDRMDF13_46     */
    const __type210 CFDRMDF14_46;                          /* CFDRMDF14_46     */
    const __type210 CFDRMDF15_46;                          /* CFDRMDF15_46     */
    uint8  dummy285[52];                                   /* Reserved         */
    const __type210 CFDRMID47;                             /* CFDRMID47        */
    const __type210 CFDRMPTR47;                            /* CFDRMPTR47       */
    const __type210 CFDRMFDSTS47;                          /* CFDRMFDSTS47     */
    const __type210 CFDRMDF0_47;                           /* CFDRMDF0_47      */
    const __type210 CFDRMDF1_47;                           /* CFDRMDF1_47      */
    const __type210 CFDRMDF2_47;                           /* CFDRMDF2_47      */
    const __type210 CFDRMDF3_47;                           /* CFDRMDF3_47      */
    const __type210 CFDRMDF4_47;                           /* CFDRMDF4_47      */
    const __type210 CFDRMDF5_47;                           /* CFDRMDF5_47      */
    const __type210 CFDRMDF6_47;                           /* CFDRMDF6_47      */
    const __type210 CFDRMDF7_47;                           /* CFDRMDF7_47      */
    const __type210 CFDRMDF8_47;                           /* CFDRMDF8_47      */
    const __type210 CFDRMDF9_47;                           /* CFDRMDF9_47      */
    const __type210 CFDRMDF10_47;                          /* CFDRMDF10_47     */
    const __type210 CFDRMDF11_47;                          /* CFDRMDF11_47     */
    const __type210 CFDRMDF12_47;                          /* CFDRMDF12_47     */
    const __type210 CFDRMDF13_47;                          /* CFDRMDF13_47     */
    const __type210 CFDRMDF14_47;                          /* CFDRMDF14_47     */
    const __type210 CFDRMDF15_47;                          /* CFDRMDF15_47     */
    uint8  dummy286[52];                                   /* Reserved         */
    const __type210 CFDRMID48;                             /* CFDRMID48        */
    const __type210 CFDRMPTR48;                            /* CFDRMPTR48       */
    const __type210 CFDRMFDSTS48;                          /* CFDRMFDSTS48     */
    const __type210 CFDRMDF0_48;                           /* CFDRMDF0_48      */
    const __type210 CFDRMDF1_48;                           /* CFDRMDF1_48      */
    const __type210 CFDRMDF2_48;                           /* CFDRMDF2_48      */
    const __type210 CFDRMDF3_48;                           /* CFDRMDF3_48      */
    const __type210 CFDRMDF4_48;                           /* CFDRMDF4_48      */
    const __type210 CFDRMDF5_48;                           /* CFDRMDF5_48      */
    const __type210 CFDRMDF6_48;                           /* CFDRMDF6_48      */
    const __type210 CFDRMDF7_48;                           /* CFDRMDF7_48      */
    const __type210 CFDRMDF8_48;                           /* CFDRMDF8_48      */
    const __type210 CFDRMDF9_48;                           /* CFDRMDF9_48      */
    const __type210 CFDRMDF10_48;                          /* CFDRMDF10_48     */
    const __type210 CFDRMDF11_48;                          /* CFDRMDF11_48     */
    const __type210 CFDRMDF12_48;                          /* CFDRMDF12_48     */
    const __type210 CFDRMDF13_48;                          /* CFDRMDF13_48     */
    const __type210 CFDRMDF14_48;                          /* CFDRMDF14_48     */
    const __type210 CFDRMDF15_48;                          /* CFDRMDF15_48     */
    uint8  dummy287[52];                                   /* Reserved         */
    const __type210 CFDRMID49;                             /* CFDRMID49        */
    const __type210 CFDRMPTR49;                            /* CFDRMPTR49       */
    const __type210 CFDRMFDSTS49;                          /* CFDRMFDSTS49     */
    const __type210 CFDRMDF0_49;                           /* CFDRMDF0_49      */
    const __type210 CFDRMDF1_49;                           /* CFDRMDF1_49      */
    const __type210 CFDRMDF2_49;                           /* CFDRMDF2_49      */
    const __type210 CFDRMDF3_49;                           /* CFDRMDF3_49      */
    const __type210 CFDRMDF4_49;                           /* CFDRMDF4_49      */
    const __type210 CFDRMDF5_49;                           /* CFDRMDF5_49      */
    const __type210 CFDRMDF6_49;                           /* CFDRMDF6_49      */
    const __type210 CFDRMDF7_49;                           /* CFDRMDF7_49      */
    const __type210 CFDRMDF8_49;                           /* CFDRMDF8_49      */
    const __type210 CFDRMDF9_49;                           /* CFDRMDF9_49      */
    const __type210 CFDRMDF10_49;                          /* CFDRMDF10_49     */
    const __type210 CFDRMDF11_49;                          /* CFDRMDF11_49     */
    const __type210 CFDRMDF12_49;                          /* CFDRMDF12_49     */
    const __type210 CFDRMDF13_49;                          /* CFDRMDF13_49     */
    const __type210 CFDRMDF14_49;                          /* CFDRMDF14_49     */
    const __type210 CFDRMDF15_49;                          /* CFDRMDF15_49     */
    uint8  dummy288[52];                                   /* Reserved         */
    const __type210 CFDRMID50;                             /* CFDRMID50        */
    const __type210 CFDRMPTR50;                            /* CFDRMPTR50       */
    const __type210 CFDRMFDSTS50;                          /* CFDRMFDSTS50     */
    const __type210 CFDRMDF0_50;                           /* CFDRMDF0_50      */
    const __type210 CFDRMDF1_50;                           /* CFDRMDF1_50      */
    const __type210 CFDRMDF2_50;                           /* CFDRMDF2_50      */
    const __type210 CFDRMDF3_50;                           /* CFDRMDF3_50      */
    const __type210 CFDRMDF4_50;                           /* CFDRMDF4_50      */
    const __type210 CFDRMDF5_50;                           /* CFDRMDF5_50      */
    const __type210 CFDRMDF6_50;                           /* CFDRMDF6_50      */
    const __type210 CFDRMDF7_50;                           /* CFDRMDF7_50      */
    const __type210 CFDRMDF8_50;                           /* CFDRMDF8_50      */
    const __type210 CFDRMDF9_50;                           /* CFDRMDF9_50      */
    const __type210 CFDRMDF10_50;                          /* CFDRMDF10_50     */
    const __type210 CFDRMDF11_50;                          /* CFDRMDF11_50     */
    const __type210 CFDRMDF12_50;                          /* CFDRMDF12_50     */
    const __type210 CFDRMDF13_50;                          /* CFDRMDF13_50     */
    const __type210 CFDRMDF14_50;                          /* CFDRMDF14_50     */
    const __type210 CFDRMDF15_50;                          /* CFDRMDF15_50     */
    uint8  dummy289[52];                                   /* Reserved         */
    const __type210 CFDRMID51;                             /* CFDRMID51        */
    const __type210 CFDRMPTR51;                            /* CFDRMPTR51       */
    const __type210 CFDRMFDSTS51;                          /* CFDRMFDSTS51     */
    const __type210 CFDRMDF0_51;                           /* CFDRMDF0_51      */
    const __type210 CFDRMDF1_51;                           /* CFDRMDF1_51      */
    const __type210 CFDRMDF2_51;                           /* CFDRMDF2_51      */
    const __type210 CFDRMDF3_51;                           /* CFDRMDF3_51      */
    const __type210 CFDRMDF4_51;                           /* CFDRMDF4_51      */
    const __type210 CFDRMDF5_51;                           /* CFDRMDF5_51      */
    const __type210 CFDRMDF6_51;                           /* CFDRMDF6_51      */
    const __type210 CFDRMDF7_51;                           /* CFDRMDF7_51      */
    const __type210 CFDRMDF8_51;                           /* CFDRMDF8_51      */
    const __type210 CFDRMDF9_51;                           /* CFDRMDF9_51      */
    const __type210 CFDRMDF10_51;                          /* CFDRMDF10_51     */
    const __type210 CFDRMDF11_51;                          /* CFDRMDF11_51     */
    const __type210 CFDRMDF12_51;                          /* CFDRMDF12_51     */
    const __type210 CFDRMDF13_51;                          /* CFDRMDF13_51     */
    const __type210 CFDRMDF14_51;                          /* CFDRMDF14_51     */
    const __type210 CFDRMDF15_51;                          /* CFDRMDF15_51     */
    uint8  dummy290[52];                                   /* Reserved         */
    const __type210 CFDRMID52;                             /* CFDRMID52        */
    const __type210 CFDRMPTR52;                            /* CFDRMPTR52       */
    const __type210 CFDRMFDSTS52;                          /* CFDRMFDSTS52     */
    const __type210 CFDRMDF0_52;                           /* CFDRMDF0_52      */
    const __type210 CFDRMDF1_52;                           /* CFDRMDF1_52      */
    const __type210 CFDRMDF2_52;                           /* CFDRMDF2_52      */
    const __type210 CFDRMDF3_52;                           /* CFDRMDF3_52      */
    const __type210 CFDRMDF4_52;                           /* CFDRMDF4_52      */
    const __type210 CFDRMDF5_52;                           /* CFDRMDF5_52      */
    const __type210 CFDRMDF6_52;                           /* CFDRMDF6_52      */
    const __type210 CFDRMDF7_52;                           /* CFDRMDF7_52      */
    const __type210 CFDRMDF8_52;                           /* CFDRMDF8_52      */
    const __type210 CFDRMDF9_52;                           /* CFDRMDF9_52      */
    const __type210 CFDRMDF10_52;                          /* CFDRMDF10_52     */
    const __type210 CFDRMDF11_52;                          /* CFDRMDF11_52     */
    const __type210 CFDRMDF12_52;                          /* CFDRMDF12_52     */
    const __type210 CFDRMDF13_52;                          /* CFDRMDF13_52     */
    const __type210 CFDRMDF14_52;                          /* CFDRMDF14_52     */
    const __type210 CFDRMDF15_52;                          /* CFDRMDF15_52     */
    uint8  dummy291[52];                                   /* Reserved         */
    const __type210 CFDRMID53;                             /* CFDRMID53        */
    const __type210 CFDRMPTR53;                            /* CFDRMPTR53       */
    const __type210 CFDRMFDSTS53;                          /* CFDRMFDSTS53     */
    const __type210 CFDRMDF0_53;                           /* CFDRMDF0_53      */
    const __type210 CFDRMDF1_53;                           /* CFDRMDF1_53      */
    const __type210 CFDRMDF2_53;                           /* CFDRMDF2_53      */
    const __type210 CFDRMDF3_53;                           /* CFDRMDF3_53      */
    const __type210 CFDRMDF4_53;                           /* CFDRMDF4_53      */
    const __type210 CFDRMDF5_53;                           /* CFDRMDF5_53      */
    const __type210 CFDRMDF6_53;                           /* CFDRMDF6_53      */
    const __type210 CFDRMDF7_53;                           /* CFDRMDF7_53      */
    const __type210 CFDRMDF8_53;                           /* CFDRMDF8_53      */
    const __type210 CFDRMDF9_53;                           /* CFDRMDF9_53      */
    const __type210 CFDRMDF10_53;                          /* CFDRMDF10_53     */
    const __type210 CFDRMDF11_53;                          /* CFDRMDF11_53     */
    const __type210 CFDRMDF12_53;                          /* CFDRMDF12_53     */
    const __type210 CFDRMDF13_53;                          /* CFDRMDF13_53     */
    const __type210 CFDRMDF14_53;                          /* CFDRMDF14_53     */
    const __type210 CFDRMDF15_53;                          /* CFDRMDF15_53     */
    uint8  dummy292[52];                                   /* Reserved         */
    const __type210 CFDRMID54;                             /* CFDRMID54        */
    const __type210 CFDRMPTR54;                            /* CFDRMPTR54       */
    const __type210 CFDRMFDSTS54;                          /* CFDRMFDSTS54     */
    const __type210 CFDRMDF0_54;                           /* CFDRMDF0_54      */
    const __type210 CFDRMDF1_54;                           /* CFDRMDF1_54      */
    const __type210 CFDRMDF2_54;                           /* CFDRMDF2_54      */
    const __type210 CFDRMDF3_54;                           /* CFDRMDF3_54      */
    const __type210 CFDRMDF4_54;                           /* CFDRMDF4_54      */
    const __type210 CFDRMDF5_54;                           /* CFDRMDF5_54      */
    const __type210 CFDRMDF6_54;                           /* CFDRMDF6_54      */
    const __type210 CFDRMDF7_54;                           /* CFDRMDF7_54      */
    const __type210 CFDRMDF8_54;                           /* CFDRMDF8_54      */
    const __type210 CFDRMDF9_54;                           /* CFDRMDF9_54      */
    const __type210 CFDRMDF10_54;                          /* CFDRMDF10_54     */
    const __type210 CFDRMDF11_54;                          /* CFDRMDF11_54     */
    const __type210 CFDRMDF12_54;                          /* CFDRMDF12_54     */
    const __type210 CFDRMDF13_54;                          /* CFDRMDF13_54     */
    const __type210 CFDRMDF14_54;                          /* CFDRMDF14_54     */
    const __type210 CFDRMDF15_54;                          /* CFDRMDF15_54     */
    uint8  dummy293[52];                                   /* Reserved         */
    const __type210 CFDRMID55;                             /* CFDRMID55        */
    const __type210 CFDRMPTR55;                            /* CFDRMPTR55       */
    const __type210 CFDRMFDSTS55;                          /* CFDRMFDSTS55     */
    const __type210 CFDRMDF0_55;                           /* CFDRMDF0_55      */
    const __type210 CFDRMDF1_55;                           /* CFDRMDF1_55      */
    const __type210 CFDRMDF2_55;                           /* CFDRMDF2_55      */
    const __type210 CFDRMDF3_55;                           /* CFDRMDF3_55      */
    const __type210 CFDRMDF4_55;                           /* CFDRMDF4_55      */
    const __type210 CFDRMDF5_55;                           /* CFDRMDF5_55      */
    const __type210 CFDRMDF6_55;                           /* CFDRMDF6_55      */
    const __type210 CFDRMDF7_55;                           /* CFDRMDF7_55      */
    const __type210 CFDRMDF8_55;                           /* CFDRMDF8_55      */
    const __type210 CFDRMDF9_55;                           /* CFDRMDF9_55      */
    const __type210 CFDRMDF10_55;                          /* CFDRMDF10_55     */
    const __type210 CFDRMDF11_55;                          /* CFDRMDF11_55     */
    const __type210 CFDRMDF12_55;                          /* CFDRMDF12_55     */
    const __type210 CFDRMDF13_55;                          /* CFDRMDF13_55     */
    const __type210 CFDRMDF14_55;                          /* CFDRMDF14_55     */
    const __type210 CFDRMDF15_55;                          /* CFDRMDF15_55     */
    uint8  dummy294[52];                                   /* Reserved         */
    const __type210 CFDRMID56;                             /* CFDRMID56        */
    const __type210 CFDRMPTR56;                            /* CFDRMPTR56       */
    const __type210 CFDRMFDSTS56;                          /* CFDRMFDSTS56     */
    const __type210 CFDRMDF0_56;                           /* CFDRMDF0_56      */
    const __type210 CFDRMDF1_56;                           /* CFDRMDF1_56      */
    const __type210 CFDRMDF2_56;                           /* CFDRMDF2_56      */
    const __type210 CFDRMDF3_56;                           /* CFDRMDF3_56      */
    const __type210 CFDRMDF4_56;                           /* CFDRMDF4_56      */
    const __type210 CFDRMDF5_56;                           /* CFDRMDF5_56      */
    const __type210 CFDRMDF6_56;                           /* CFDRMDF6_56      */
    const __type210 CFDRMDF7_56;                           /* CFDRMDF7_56      */
    const __type210 CFDRMDF8_56;                           /* CFDRMDF8_56      */
    const __type210 CFDRMDF9_56;                           /* CFDRMDF9_56      */
    const __type210 CFDRMDF10_56;                          /* CFDRMDF10_56     */
    const __type210 CFDRMDF11_56;                          /* CFDRMDF11_56     */
    const __type210 CFDRMDF12_56;                          /* CFDRMDF12_56     */
    const __type210 CFDRMDF13_56;                          /* CFDRMDF13_56     */
    const __type210 CFDRMDF14_56;                          /* CFDRMDF14_56     */
    const __type210 CFDRMDF15_56;                          /* CFDRMDF15_56     */
    uint8  dummy295[52];                                   /* Reserved         */
    const __type210 CFDRMID57;                             /* CFDRMID57        */
    const __type210 CFDRMPTR57;                            /* CFDRMPTR57       */
    const __type210 CFDRMFDSTS57;                          /* CFDRMFDSTS57     */
    const __type210 CFDRMDF0_57;                           /* CFDRMDF0_57      */
    const __type210 CFDRMDF1_57;                           /* CFDRMDF1_57      */
    const __type210 CFDRMDF2_57;                           /* CFDRMDF2_57      */
    const __type210 CFDRMDF3_57;                           /* CFDRMDF3_57      */
    const __type210 CFDRMDF4_57;                           /* CFDRMDF4_57      */
    const __type210 CFDRMDF5_57;                           /* CFDRMDF5_57      */
    const __type210 CFDRMDF6_57;                           /* CFDRMDF6_57      */
    const __type210 CFDRMDF7_57;                           /* CFDRMDF7_57      */
    const __type210 CFDRMDF8_57;                           /* CFDRMDF8_57      */
    const __type210 CFDRMDF9_57;                           /* CFDRMDF9_57      */
    const __type210 CFDRMDF10_57;                          /* CFDRMDF10_57     */
    const __type210 CFDRMDF11_57;                          /* CFDRMDF11_57     */
    const __type210 CFDRMDF12_57;                          /* CFDRMDF12_57     */
    const __type210 CFDRMDF13_57;                          /* CFDRMDF13_57     */
    const __type210 CFDRMDF14_57;                          /* CFDRMDF14_57     */
    const __type210 CFDRMDF15_57;                          /* CFDRMDF15_57     */
    uint8  dummy296[52];                                   /* Reserved         */
    const __type210 CFDRMID58;                             /* CFDRMID58        */
    const __type210 CFDRMPTR58;                            /* CFDRMPTR58       */
    const __type210 CFDRMFDSTS58;                          /* CFDRMFDSTS58     */
    const __type210 CFDRMDF0_58;                           /* CFDRMDF0_58      */
    const __type210 CFDRMDF1_58;                           /* CFDRMDF1_58      */
    const __type210 CFDRMDF2_58;                           /* CFDRMDF2_58      */
    const __type210 CFDRMDF3_58;                           /* CFDRMDF3_58      */
    const __type210 CFDRMDF4_58;                           /* CFDRMDF4_58      */
    const __type210 CFDRMDF5_58;                           /* CFDRMDF5_58      */
    const __type210 CFDRMDF6_58;                           /* CFDRMDF6_58      */
    const __type210 CFDRMDF7_58;                           /* CFDRMDF7_58      */
    const __type210 CFDRMDF8_58;                           /* CFDRMDF8_58      */
    const __type210 CFDRMDF9_58;                           /* CFDRMDF9_58      */
    const __type210 CFDRMDF10_58;                          /* CFDRMDF10_58     */
    const __type210 CFDRMDF11_58;                          /* CFDRMDF11_58     */
    const __type210 CFDRMDF12_58;                          /* CFDRMDF12_58     */
    const __type210 CFDRMDF13_58;                          /* CFDRMDF13_58     */
    const __type210 CFDRMDF14_58;                          /* CFDRMDF14_58     */
    const __type210 CFDRMDF15_58;                          /* CFDRMDF15_58     */
    uint8  dummy297[52];                                   /* Reserved         */
    const __type210 CFDRMID59;                             /* CFDRMID59        */
    const __type210 CFDRMPTR59;                            /* CFDRMPTR59       */
    const __type210 CFDRMFDSTS59;                          /* CFDRMFDSTS59     */
    const __type210 CFDRMDF0_59;                           /* CFDRMDF0_59      */
    const __type210 CFDRMDF1_59;                           /* CFDRMDF1_59      */
    const __type210 CFDRMDF2_59;                           /* CFDRMDF2_59      */
    const __type210 CFDRMDF3_59;                           /* CFDRMDF3_59      */
    const __type210 CFDRMDF4_59;                           /* CFDRMDF4_59      */
    const __type210 CFDRMDF5_59;                           /* CFDRMDF5_59      */
    const __type210 CFDRMDF6_59;                           /* CFDRMDF6_59      */
    const __type210 CFDRMDF7_59;                           /* CFDRMDF7_59      */
    const __type210 CFDRMDF8_59;                           /* CFDRMDF8_59      */
    const __type210 CFDRMDF9_59;                           /* CFDRMDF9_59      */
    const __type210 CFDRMDF10_59;                          /* CFDRMDF10_59     */
    const __type210 CFDRMDF11_59;                          /* CFDRMDF11_59     */
    const __type210 CFDRMDF12_59;                          /* CFDRMDF12_59     */
    const __type210 CFDRMDF13_59;                          /* CFDRMDF13_59     */
    const __type210 CFDRMDF14_59;                          /* CFDRMDF14_59     */
    const __type210 CFDRMDF15_59;                          /* CFDRMDF15_59     */
    uint8  dummy298[52];                                   /* Reserved         */
    const __type210 CFDRMID60;                             /* CFDRMID60        */
    const __type210 CFDRMPTR60;                            /* CFDRMPTR60       */
    const __type210 CFDRMFDSTS60;                          /* CFDRMFDSTS60     */
    const __type210 CFDRMDF0_60;                           /* CFDRMDF0_60      */
    const __type210 CFDRMDF1_60;                           /* CFDRMDF1_60      */
    const __type210 CFDRMDF2_60;                           /* CFDRMDF2_60      */
    const __type210 CFDRMDF3_60;                           /* CFDRMDF3_60      */
    const __type210 CFDRMDF4_60;                           /* CFDRMDF4_60      */
    const __type210 CFDRMDF5_60;                           /* CFDRMDF5_60      */
    const __type210 CFDRMDF6_60;                           /* CFDRMDF6_60      */
    const __type210 CFDRMDF7_60;                           /* CFDRMDF7_60      */
    const __type210 CFDRMDF8_60;                           /* CFDRMDF8_60      */
    const __type210 CFDRMDF9_60;                           /* CFDRMDF9_60      */
    const __type210 CFDRMDF10_60;                          /* CFDRMDF10_60     */
    const __type210 CFDRMDF11_60;                          /* CFDRMDF11_60     */
    const __type210 CFDRMDF12_60;                          /* CFDRMDF12_60     */
    const __type210 CFDRMDF13_60;                          /* CFDRMDF13_60     */
    const __type210 CFDRMDF14_60;                          /* CFDRMDF14_60     */
    const __type210 CFDRMDF15_60;                          /* CFDRMDF15_60     */
    uint8  dummy299[52];                                   /* Reserved         */
    const __type210 CFDRMID61;                             /* CFDRMID61        */
    const __type210 CFDRMPTR61;                            /* CFDRMPTR61       */
    const __type210 CFDRMFDSTS61;                          /* CFDRMFDSTS61     */
    const __type210 CFDRMDF0_61;                           /* CFDRMDF0_61      */
    const __type210 CFDRMDF1_61;                           /* CFDRMDF1_61      */
    const __type210 CFDRMDF2_61;                           /* CFDRMDF2_61      */
    const __type210 CFDRMDF3_61;                           /* CFDRMDF3_61      */
    const __type210 CFDRMDF4_61;                           /* CFDRMDF4_61      */
    const __type210 CFDRMDF5_61;                           /* CFDRMDF5_61      */
    const __type210 CFDRMDF6_61;                           /* CFDRMDF6_61      */
    const __type210 CFDRMDF7_61;                           /* CFDRMDF7_61      */
    const __type210 CFDRMDF8_61;                           /* CFDRMDF8_61      */
    const __type210 CFDRMDF9_61;                           /* CFDRMDF9_61      */
    const __type210 CFDRMDF10_61;                          /* CFDRMDF10_61     */
    const __type210 CFDRMDF11_61;                          /* CFDRMDF11_61     */
    const __type210 CFDRMDF12_61;                          /* CFDRMDF12_61     */
    const __type210 CFDRMDF13_61;                          /* CFDRMDF13_61     */
    const __type210 CFDRMDF14_61;                          /* CFDRMDF14_61     */
    const __type210 CFDRMDF15_61;                          /* CFDRMDF15_61     */
    uint8  dummy300[52];                                   /* Reserved         */
    const __type210 CFDRMID62;                             /* CFDRMID62        */
    const __type210 CFDRMPTR62;                            /* CFDRMPTR62       */
    const __type210 CFDRMFDSTS62;                          /* CFDRMFDSTS62     */
    const __type210 CFDRMDF0_62;                           /* CFDRMDF0_62      */
    const __type210 CFDRMDF1_62;                           /* CFDRMDF1_62      */
    const __type210 CFDRMDF2_62;                           /* CFDRMDF2_62      */
    const __type210 CFDRMDF3_62;                           /* CFDRMDF3_62      */
    const __type210 CFDRMDF4_62;                           /* CFDRMDF4_62      */
    const __type210 CFDRMDF5_62;                           /* CFDRMDF5_62      */
    const __type210 CFDRMDF6_62;                           /* CFDRMDF6_62      */
    const __type210 CFDRMDF7_62;                           /* CFDRMDF7_62      */
    const __type210 CFDRMDF8_62;                           /* CFDRMDF8_62      */
    const __type210 CFDRMDF9_62;                           /* CFDRMDF9_62      */
    const __type210 CFDRMDF10_62;                          /* CFDRMDF10_62     */
    const __type210 CFDRMDF11_62;                          /* CFDRMDF11_62     */
    const __type210 CFDRMDF12_62;                          /* CFDRMDF12_62     */
    const __type210 CFDRMDF13_62;                          /* CFDRMDF13_62     */
    const __type210 CFDRMDF14_62;                          /* CFDRMDF14_62     */
    const __type210 CFDRMDF15_62;                          /* CFDRMDF15_62     */
    uint8  dummy301[52];                                   /* Reserved         */
    const __type210 CFDRMID63;                             /* CFDRMID63        */
    const __type210 CFDRMPTR63;                            /* CFDRMPTR63       */
    const __type210 CFDRMFDSTS63;                          /* CFDRMFDSTS63     */
    const __type210 CFDRMDF0_63;                           /* CFDRMDF0_63      */
    const __type210 CFDRMDF1_63;                           /* CFDRMDF1_63      */
    const __type210 CFDRMDF2_63;                           /* CFDRMDF2_63      */
    const __type210 CFDRMDF3_63;                           /* CFDRMDF3_63      */
    const __type210 CFDRMDF4_63;                           /* CFDRMDF4_63      */
    const __type210 CFDRMDF5_63;                           /* CFDRMDF5_63      */
    const __type210 CFDRMDF6_63;                           /* CFDRMDF6_63      */
    const __type210 CFDRMDF7_63;                           /* CFDRMDF7_63      */
    const __type210 CFDRMDF8_63;                           /* CFDRMDF8_63      */
    const __type210 CFDRMDF9_63;                           /* CFDRMDF9_63      */
    const __type210 CFDRMDF10_63;                          /* CFDRMDF10_63     */
    const __type210 CFDRMDF11_63;                          /* CFDRMDF11_63     */
    const __type210 CFDRMDF12_63;                          /* CFDRMDF12_63     */
    const __type210 CFDRMDF13_63;                          /* CFDRMDF13_63     */
    const __type210 CFDRMDF14_63;                          /* CFDRMDF14_63     */
    const __type210 CFDRMDF15_63;                          /* CFDRMDF15_63     */
    uint8  dummy302[52];                                   /* Reserved         */
    const __type210 CFDRMID64;                             /* CFDRMID64        */
    const __type210 CFDRMPTR64;                            /* CFDRMPTR64       */
    const __type210 CFDRMFDSTS64;                          /* CFDRMFDSTS64     */
    const __type210 CFDRMDF0_64;                           /* CFDRMDF0_64      */
    const __type210 CFDRMDF1_64;                           /* CFDRMDF1_64      */
    const __type210 CFDRMDF2_64;                           /* CFDRMDF2_64      */
    const __type210 CFDRMDF3_64;                           /* CFDRMDF3_64      */
    const __type210 CFDRMDF4_64;                           /* CFDRMDF4_64      */
    const __type210 CFDRMDF5_64;                           /* CFDRMDF5_64      */
    const __type210 CFDRMDF6_64;                           /* CFDRMDF6_64      */
    const __type210 CFDRMDF7_64;                           /* CFDRMDF7_64      */
    const __type210 CFDRMDF8_64;                           /* CFDRMDF8_64      */
    const __type210 CFDRMDF9_64;                           /* CFDRMDF9_64      */
    const __type210 CFDRMDF10_64;                          /* CFDRMDF10_64     */
    const __type210 CFDRMDF11_64;                          /* CFDRMDF11_64     */
    const __type210 CFDRMDF12_64;                          /* CFDRMDF12_64     */
    const __type210 CFDRMDF13_64;                          /* CFDRMDF13_64     */
    const __type210 CFDRMDF14_64;                          /* CFDRMDF14_64     */
    const __type210 CFDRMDF15_64;                          /* CFDRMDF15_64     */
    uint8  dummy303[52];                                   /* Reserved         */
    const __type210 CFDRMID65;                             /* CFDRMID65        */
    const __type210 CFDRMPTR65;                            /* CFDRMPTR65       */
    const __type210 CFDRMFDSTS65;                          /* CFDRMFDSTS65     */
    const __type210 CFDRMDF0_65;                           /* CFDRMDF0_65      */
    const __type210 CFDRMDF1_65;                           /* CFDRMDF1_65      */
    const __type210 CFDRMDF2_65;                           /* CFDRMDF2_65      */
    const __type210 CFDRMDF3_65;                           /* CFDRMDF3_65      */
    const __type210 CFDRMDF4_65;                           /* CFDRMDF4_65      */
    const __type210 CFDRMDF5_65;                           /* CFDRMDF5_65      */
    const __type210 CFDRMDF6_65;                           /* CFDRMDF6_65      */
    const __type210 CFDRMDF7_65;                           /* CFDRMDF7_65      */
    const __type210 CFDRMDF8_65;                           /* CFDRMDF8_65      */
    const __type210 CFDRMDF9_65;                           /* CFDRMDF9_65      */
    const __type210 CFDRMDF10_65;                          /* CFDRMDF10_65     */
    const __type210 CFDRMDF11_65;                          /* CFDRMDF11_65     */
    const __type210 CFDRMDF12_65;                          /* CFDRMDF12_65     */
    const __type210 CFDRMDF13_65;                          /* CFDRMDF13_65     */
    const __type210 CFDRMDF14_65;                          /* CFDRMDF14_65     */
    const __type210 CFDRMDF15_65;                          /* CFDRMDF15_65     */
    uint8  dummy304[52];                                   /* Reserved         */
    const __type210 CFDRMID66;                             /* CFDRMID66        */
    const __type210 CFDRMPTR66;                            /* CFDRMPTR66       */
    const __type210 CFDRMFDSTS66;                          /* CFDRMFDSTS66     */
    const __type210 CFDRMDF0_66;                           /* CFDRMDF0_66      */
    const __type210 CFDRMDF1_66;                           /* CFDRMDF1_66      */
    const __type210 CFDRMDF2_66;                           /* CFDRMDF2_66      */
    const __type210 CFDRMDF3_66;                           /* CFDRMDF3_66      */
    const __type210 CFDRMDF4_66;                           /* CFDRMDF4_66      */
    const __type210 CFDRMDF5_66;                           /* CFDRMDF5_66      */
    const __type210 CFDRMDF6_66;                           /* CFDRMDF6_66      */
    const __type210 CFDRMDF7_66;                           /* CFDRMDF7_66      */
    const __type210 CFDRMDF8_66;                           /* CFDRMDF8_66      */
    const __type210 CFDRMDF9_66;                           /* CFDRMDF9_66      */
    const __type210 CFDRMDF10_66;                          /* CFDRMDF10_66     */
    const __type210 CFDRMDF11_66;                          /* CFDRMDF11_66     */
    const __type210 CFDRMDF12_66;                          /* CFDRMDF12_66     */
    const __type210 CFDRMDF13_66;                          /* CFDRMDF13_66     */
    const __type210 CFDRMDF14_66;                          /* CFDRMDF14_66     */
    const __type210 CFDRMDF15_66;                          /* CFDRMDF15_66     */
    uint8  dummy305[52];                                   /* Reserved         */
    const __type210 CFDRMID67;                             /* CFDRMID67        */
    const __type210 CFDRMPTR67;                            /* CFDRMPTR67       */
    const __type210 CFDRMFDSTS67;                          /* CFDRMFDSTS67     */
    const __type210 CFDRMDF0_67;                           /* CFDRMDF0_67      */
    const __type210 CFDRMDF1_67;                           /* CFDRMDF1_67      */
    const __type210 CFDRMDF2_67;                           /* CFDRMDF2_67      */
    const __type210 CFDRMDF3_67;                           /* CFDRMDF3_67      */
    const __type210 CFDRMDF4_67;                           /* CFDRMDF4_67      */
    const __type210 CFDRMDF5_67;                           /* CFDRMDF5_67      */
    const __type210 CFDRMDF6_67;                           /* CFDRMDF6_67      */
    const __type210 CFDRMDF7_67;                           /* CFDRMDF7_67      */
    const __type210 CFDRMDF8_67;                           /* CFDRMDF8_67      */
    const __type210 CFDRMDF9_67;                           /* CFDRMDF9_67      */
    const __type210 CFDRMDF10_67;                          /* CFDRMDF10_67     */
    const __type210 CFDRMDF11_67;                          /* CFDRMDF11_67     */
    const __type210 CFDRMDF12_67;                          /* CFDRMDF12_67     */
    const __type210 CFDRMDF13_67;                          /* CFDRMDF13_67     */
    const __type210 CFDRMDF14_67;                          /* CFDRMDF14_67     */
    const __type210 CFDRMDF15_67;                          /* CFDRMDF15_67     */
    uint8  dummy306[52];                                   /* Reserved         */
    const __type210 CFDRMID68;                             /* CFDRMID68        */
    const __type210 CFDRMPTR68;                            /* CFDRMPTR68       */
    const __type210 CFDRMFDSTS68;                          /* CFDRMFDSTS68     */
    const __type210 CFDRMDF0_68;                           /* CFDRMDF0_68      */
    const __type210 CFDRMDF1_68;                           /* CFDRMDF1_68      */
    const __type210 CFDRMDF2_68;                           /* CFDRMDF2_68      */
    const __type210 CFDRMDF3_68;                           /* CFDRMDF3_68      */
    const __type210 CFDRMDF4_68;                           /* CFDRMDF4_68      */
    const __type210 CFDRMDF5_68;                           /* CFDRMDF5_68      */
    const __type210 CFDRMDF6_68;                           /* CFDRMDF6_68      */
    const __type210 CFDRMDF7_68;                           /* CFDRMDF7_68      */
    const __type210 CFDRMDF8_68;                           /* CFDRMDF8_68      */
    const __type210 CFDRMDF9_68;                           /* CFDRMDF9_68      */
    const __type210 CFDRMDF10_68;                          /* CFDRMDF10_68     */
    const __type210 CFDRMDF11_68;                          /* CFDRMDF11_68     */
    const __type210 CFDRMDF12_68;                          /* CFDRMDF12_68     */
    const __type210 CFDRMDF13_68;                          /* CFDRMDF13_68     */
    const __type210 CFDRMDF14_68;                          /* CFDRMDF14_68     */
    const __type210 CFDRMDF15_68;                          /* CFDRMDF15_68     */
    uint8  dummy307[52];                                   /* Reserved         */
    const __type210 CFDRMID69;                             /* CFDRMID69        */
    const __type210 CFDRMPTR69;                            /* CFDRMPTR69       */
    const __type210 CFDRMFDSTS69;                          /* CFDRMFDSTS69     */
    const __type210 CFDRMDF0_69;                           /* CFDRMDF0_69      */
    const __type210 CFDRMDF1_69;                           /* CFDRMDF1_69      */
    const __type210 CFDRMDF2_69;                           /* CFDRMDF2_69      */
    const __type210 CFDRMDF3_69;                           /* CFDRMDF3_69      */
    const __type210 CFDRMDF4_69;                           /* CFDRMDF4_69      */
    const __type210 CFDRMDF5_69;                           /* CFDRMDF5_69      */
    const __type210 CFDRMDF6_69;                           /* CFDRMDF6_69      */
    const __type210 CFDRMDF7_69;                           /* CFDRMDF7_69      */
    const __type210 CFDRMDF8_69;                           /* CFDRMDF8_69      */
    const __type210 CFDRMDF9_69;                           /* CFDRMDF9_69      */
    const __type210 CFDRMDF10_69;                          /* CFDRMDF10_69     */
    const __type210 CFDRMDF11_69;                          /* CFDRMDF11_69     */
    const __type210 CFDRMDF12_69;                          /* CFDRMDF12_69     */
    const __type210 CFDRMDF13_69;                          /* CFDRMDF13_69     */
    const __type210 CFDRMDF14_69;                          /* CFDRMDF14_69     */
    const __type210 CFDRMDF15_69;                          /* CFDRMDF15_69     */
    uint8  dummy308[52];                                   /* Reserved         */
    const __type210 CFDRMID70;                             /* CFDRMID70        */
    const __type210 CFDRMPTR70;                            /* CFDRMPTR70       */
    const __type210 CFDRMFDSTS70;                          /* CFDRMFDSTS70     */
    const __type210 CFDRMDF0_70;                           /* CFDRMDF0_70      */
    const __type210 CFDRMDF1_70;                           /* CFDRMDF1_70      */
    const __type210 CFDRMDF2_70;                           /* CFDRMDF2_70      */
    const __type210 CFDRMDF3_70;                           /* CFDRMDF3_70      */
    const __type210 CFDRMDF4_70;                           /* CFDRMDF4_70      */
    const __type210 CFDRMDF5_70;                           /* CFDRMDF5_70      */
    const __type210 CFDRMDF6_70;                           /* CFDRMDF6_70      */
    const __type210 CFDRMDF7_70;                           /* CFDRMDF7_70      */
    const __type210 CFDRMDF8_70;                           /* CFDRMDF8_70      */
    const __type210 CFDRMDF9_70;                           /* CFDRMDF9_70      */
    const __type210 CFDRMDF10_70;                          /* CFDRMDF10_70     */
    const __type210 CFDRMDF11_70;                          /* CFDRMDF11_70     */
    const __type210 CFDRMDF12_70;                          /* CFDRMDF12_70     */
    const __type210 CFDRMDF13_70;                          /* CFDRMDF13_70     */
    const __type210 CFDRMDF14_70;                          /* CFDRMDF14_70     */
    const __type210 CFDRMDF15_70;                          /* CFDRMDF15_70     */
    uint8  dummy309[52];                                   /* Reserved         */
    const __type210 CFDRMID71;                             /* CFDRMID71        */
    const __type210 CFDRMPTR71;                            /* CFDRMPTR71       */
    const __type210 CFDRMFDSTS71;                          /* CFDRMFDSTS71     */
    const __type210 CFDRMDF0_71;                           /* CFDRMDF0_71      */
    const __type210 CFDRMDF1_71;                           /* CFDRMDF1_71      */
    const __type210 CFDRMDF2_71;                           /* CFDRMDF2_71      */
    const __type210 CFDRMDF3_71;                           /* CFDRMDF3_71      */
    const __type210 CFDRMDF4_71;                           /* CFDRMDF4_71      */
    const __type210 CFDRMDF5_71;                           /* CFDRMDF5_71      */
    const __type210 CFDRMDF6_71;                           /* CFDRMDF6_71      */
    const __type210 CFDRMDF7_71;                           /* CFDRMDF7_71      */
    const __type210 CFDRMDF8_71;                           /* CFDRMDF8_71      */
    const __type210 CFDRMDF9_71;                           /* CFDRMDF9_71      */
    const __type210 CFDRMDF10_71;                          /* CFDRMDF10_71     */
    const __type210 CFDRMDF11_71;                          /* CFDRMDF11_71     */
    const __type210 CFDRMDF12_71;                          /* CFDRMDF12_71     */
    const __type210 CFDRMDF13_71;                          /* CFDRMDF13_71     */
    const __type210 CFDRMDF14_71;                          /* CFDRMDF14_71     */
    const __type210 CFDRMDF15_71;                          /* CFDRMDF15_71     */
    uint8  dummy310[52];                                   /* Reserved         */
    const __type210 CFDRMID72;                             /* CFDRMID72        */
    const __type210 CFDRMPTR72;                            /* CFDRMPTR72       */
    const __type210 CFDRMFDSTS72;                          /* CFDRMFDSTS72     */
    const __type210 CFDRMDF0_72;                           /* CFDRMDF0_72      */
    const __type210 CFDRMDF1_72;                           /* CFDRMDF1_72      */
    const __type210 CFDRMDF2_72;                           /* CFDRMDF2_72      */
    const __type210 CFDRMDF3_72;                           /* CFDRMDF3_72      */
    const __type210 CFDRMDF4_72;                           /* CFDRMDF4_72      */
    const __type210 CFDRMDF5_72;                           /* CFDRMDF5_72      */
    const __type210 CFDRMDF6_72;                           /* CFDRMDF6_72      */
    const __type210 CFDRMDF7_72;                           /* CFDRMDF7_72      */
    const __type210 CFDRMDF8_72;                           /* CFDRMDF8_72      */
    const __type210 CFDRMDF9_72;                           /* CFDRMDF9_72      */
    const __type210 CFDRMDF10_72;                          /* CFDRMDF10_72     */
    const __type210 CFDRMDF11_72;                          /* CFDRMDF11_72     */
    const __type210 CFDRMDF12_72;                          /* CFDRMDF12_72     */
    const __type210 CFDRMDF13_72;                          /* CFDRMDF13_72     */
    const __type210 CFDRMDF14_72;                          /* CFDRMDF14_72     */
    const __type210 CFDRMDF15_72;                          /* CFDRMDF15_72     */
    uint8  dummy311[52];                                   /* Reserved         */
    const __type210 CFDRMID73;                             /* CFDRMID73        */
    const __type210 CFDRMPTR73;                            /* CFDRMPTR73       */
    const __type210 CFDRMFDSTS73;                          /* CFDRMFDSTS73     */
    const __type210 CFDRMDF0_73;                           /* CFDRMDF0_73      */
    const __type210 CFDRMDF1_73;                           /* CFDRMDF1_73      */
    const __type210 CFDRMDF2_73;                           /* CFDRMDF2_73      */
    const __type210 CFDRMDF3_73;                           /* CFDRMDF3_73      */
    const __type210 CFDRMDF4_73;                           /* CFDRMDF4_73      */
    const __type210 CFDRMDF5_73;                           /* CFDRMDF5_73      */
    const __type210 CFDRMDF6_73;                           /* CFDRMDF6_73      */
    const __type210 CFDRMDF7_73;                           /* CFDRMDF7_73      */
    const __type210 CFDRMDF8_73;                           /* CFDRMDF8_73      */
    const __type210 CFDRMDF9_73;                           /* CFDRMDF9_73      */
    const __type210 CFDRMDF10_73;                          /* CFDRMDF10_73     */
    const __type210 CFDRMDF11_73;                          /* CFDRMDF11_73     */
    const __type210 CFDRMDF12_73;                          /* CFDRMDF12_73     */
    const __type210 CFDRMDF13_73;                          /* CFDRMDF13_73     */
    const __type210 CFDRMDF14_73;                          /* CFDRMDF14_73     */
    const __type210 CFDRMDF15_73;                          /* CFDRMDF15_73     */
    uint8  dummy312[52];                                   /* Reserved         */
    const __type210 CFDRMID74;                             /* CFDRMID74        */
    const __type210 CFDRMPTR74;                            /* CFDRMPTR74       */
    const __type210 CFDRMFDSTS74;                          /* CFDRMFDSTS74     */
    const __type210 CFDRMDF0_74;                           /* CFDRMDF0_74      */
    const __type210 CFDRMDF1_74;                           /* CFDRMDF1_74      */
    const __type210 CFDRMDF2_74;                           /* CFDRMDF2_74      */
    const __type210 CFDRMDF3_74;                           /* CFDRMDF3_74      */
    const __type210 CFDRMDF4_74;                           /* CFDRMDF4_74      */
    const __type210 CFDRMDF5_74;                           /* CFDRMDF5_74      */
    const __type210 CFDRMDF6_74;                           /* CFDRMDF6_74      */
    const __type210 CFDRMDF7_74;                           /* CFDRMDF7_74      */
    const __type210 CFDRMDF8_74;                           /* CFDRMDF8_74      */
    const __type210 CFDRMDF9_74;                           /* CFDRMDF9_74      */
    const __type210 CFDRMDF10_74;                          /* CFDRMDF10_74     */
    const __type210 CFDRMDF11_74;                          /* CFDRMDF11_74     */
    const __type210 CFDRMDF12_74;                          /* CFDRMDF12_74     */
    const __type210 CFDRMDF13_74;                          /* CFDRMDF13_74     */
    const __type210 CFDRMDF14_74;                          /* CFDRMDF14_74     */
    const __type210 CFDRMDF15_74;                          /* CFDRMDF15_74     */
    uint8  dummy313[52];                                   /* Reserved         */
    const __type210 CFDRMID75;                             /* CFDRMID75        */
    const __type210 CFDRMPTR75;                            /* CFDRMPTR75       */
    const __type210 CFDRMFDSTS75;                          /* CFDRMFDSTS75     */
    const __type210 CFDRMDF0_75;                           /* CFDRMDF0_75      */
    const __type210 CFDRMDF1_75;                           /* CFDRMDF1_75      */
    const __type210 CFDRMDF2_75;                           /* CFDRMDF2_75      */
    const __type210 CFDRMDF3_75;                           /* CFDRMDF3_75      */
    const __type210 CFDRMDF4_75;                           /* CFDRMDF4_75      */
    const __type210 CFDRMDF5_75;                           /* CFDRMDF5_75      */
    const __type210 CFDRMDF6_75;                           /* CFDRMDF6_75      */
    const __type210 CFDRMDF7_75;                           /* CFDRMDF7_75      */
    const __type210 CFDRMDF8_75;                           /* CFDRMDF8_75      */
    const __type210 CFDRMDF9_75;                           /* CFDRMDF9_75      */
    const __type210 CFDRMDF10_75;                          /* CFDRMDF10_75     */
    const __type210 CFDRMDF11_75;                          /* CFDRMDF11_75     */
    const __type210 CFDRMDF12_75;                          /* CFDRMDF12_75     */
    const __type210 CFDRMDF13_75;                          /* CFDRMDF13_75     */
    const __type210 CFDRMDF14_75;                          /* CFDRMDF14_75     */
    const __type210 CFDRMDF15_75;                          /* CFDRMDF15_75     */
    uint8  dummy314[52];                                   /* Reserved         */
    const __type210 CFDRMID76;                             /* CFDRMID76        */
    const __type210 CFDRMPTR76;                            /* CFDRMPTR76       */
    const __type210 CFDRMFDSTS76;                          /* CFDRMFDSTS76     */
    const __type210 CFDRMDF0_76;                           /* CFDRMDF0_76      */
    const __type210 CFDRMDF1_76;                           /* CFDRMDF1_76      */
    const __type210 CFDRMDF2_76;                           /* CFDRMDF2_76      */
    const __type210 CFDRMDF3_76;                           /* CFDRMDF3_76      */
    const __type210 CFDRMDF4_76;                           /* CFDRMDF4_76      */
    const __type210 CFDRMDF5_76;                           /* CFDRMDF5_76      */
    const __type210 CFDRMDF6_76;                           /* CFDRMDF6_76      */
    const __type210 CFDRMDF7_76;                           /* CFDRMDF7_76      */
    const __type210 CFDRMDF8_76;                           /* CFDRMDF8_76      */
    const __type210 CFDRMDF9_76;                           /* CFDRMDF9_76      */
    const __type210 CFDRMDF10_76;                          /* CFDRMDF10_76     */
    const __type210 CFDRMDF11_76;                          /* CFDRMDF11_76     */
    const __type210 CFDRMDF12_76;                          /* CFDRMDF12_76     */
    const __type210 CFDRMDF13_76;                          /* CFDRMDF13_76     */
    const __type210 CFDRMDF14_76;                          /* CFDRMDF14_76     */
    const __type210 CFDRMDF15_76;                          /* CFDRMDF15_76     */
    uint8  dummy315[52];                                   /* Reserved         */
    const __type210 CFDRMID77;                             /* CFDRMID77        */
    const __type210 CFDRMPTR77;                            /* CFDRMPTR77       */
    const __type210 CFDRMFDSTS77;                          /* CFDRMFDSTS77     */
    const __type210 CFDRMDF0_77;                           /* CFDRMDF0_77      */
    const __type210 CFDRMDF1_77;                           /* CFDRMDF1_77      */
    const __type210 CFDRMDF2_77;                           /* CFDRMDF2_77      */
    const __type210 CFDRMDF3_77;                           /* CFDRMDF3_77      */
    const __type210 CFDRMDF4_77;                           /* CFDRMDF4_77      */
    const __type210 CFDRMDF5_77;                           /* CFDRMDF5_77      */
    const __type210 CFDRMDF6_77;                           /* CFDRMDF6_77      */
    const __type210 CFDRMDF7_77;                           /* CFDRMDF7_77      */
    const __type210 CFDRMDF8_77;                           /* CFDRMDF8_77      */
    const __type210 CFDRMDF9_77;                           /* CFDRMDF9_77      */
    const __type210 CFDRMDF10_77;                          /* CFDRMDF10_77     */
    const __type210 CFDRMDF11_77;                          /* CFDRMDF11_77     */
    const __type210 CFDRMDF12_77;                          /* CFDRMDF12_77     */
    const __type210 CFDRMDF13_77;                          /* CFDRMDF13_77     */
    const __type210 CFDRMDF14_77;                          /* CFDRMDF14_77     */
    const __type210 CFDRMDF15_77;                          /* CFDRMDF15_77     */
    uint8  dummy316[52];                                   /* Reserved         */
    const __type210 CFDRMID78;                             /* CFDRMID78        */
    const __type210 CFDRMPTR78;                            /* CFDRMPTR78       */
    const __type210 CFDRMFDSTS78;                          /* CFDRMFDSTS78     */
    const __type210 CFDRMDF0_78;                           /* CFDRMDF0_78      */
    const __type210 CFDRMDF1_78;                           /* CFDRMDF1_78      */
    const __type210 CFDRMDF2_78;                           /* CFDRMDF2_78      */
    const __type210 CFDRMDF3_78;                           /* CFDRMDF3_78      */
    const __type210 CFDRMDF4_78;                           /* CFDRMDF4_78      */
    const __type210 CFDRMDF5_78;                           /* CFDRMDF5_78      */
    const __type210 CFDRMDF6_78;                           /* CFDRMDF6_78      */
    const __type210 CFDRMDF7_78;                           /* CFDRMDF7_78      */
    const __type210 CFDRMDF8_78;                           /* CFDRMDF8_78      */
    const __type210 CFDRMDF9_78;                           /* CFDRMDF9_78      */
    const __type210 CFDRMDF10_78;                          /* CFDRMDF10_78     */
    const __type210 CFDRMDF11_78;                          /* CFDRMDF11_78     */
    const __type210 CFDRMDF12_78;                          /* CFDRMDF12_78     */
    const __type210 CFDRMDF13_78;                          /* CFDRMDF13_78     */
    const __type210 CFDRMDF14_78;                          /* CFDRMDF14_78     */
    const __type210 CFDRMDF15_78;                          /* CFDRMDF15_78     */
    uint8  dummy317[52];                                   /* Reserved         */
    const __type210 CFDRMID79;                             /* CFDRMID79        */
    const __type210 CFDRMPTR79;                            /* CFDRMPTR79       */
    const __type210 CFDRMFDSTS79;                          /* CFDRMFDSTS79     */
    const __type210 CFDRMDF0_79;                           /* CFDRMDF0_79      */
    const __type210 CFDRMDF1_79;                           /* CFDRMDF1_79      */
    const __type210 CFDRMDF2_79;                           /* CFDRMDF2_79      */
    const __type210 CFDRMDF3_79;                           /* CFDRMDF3_79      */
    const __type210 CFDRMDF4_79;                           /* CFDRMDF4_79      */
    const __type210 CFDRMDF5_79;                           /* CFDRMDF5_79      */
    const __type210 CFDRMDF6_79;                           /* CFDRMDF6_79      */
    const __type210 CFDRMDF7_79;                           /* CFDRMDF7_79      */
    const __type210 CFDRMDF8_79;                           /* CFDRMDF8_79      */
    const __type210 CFDRMDF9_79;                           /* CFDRMDF9_79      */
    const __type210 CFDRMDF10_79;                          /* CFDRMDF10_79     */
    const __type210 CFDRMDF11_79;                          /* CFDRMDF11_79     */
    const __type210 CFDRMDF12_79;                          /* CFDRMDF12_79     */
    const __type210 CFDRMDF13_79;                          /* CFDRMDF13_79     */
    const __type210 CFDRMDF14_79;                          /* CFDRMDF14_79     */
    const __type210 CFDRMDF15_79;                          /* CFDRMDF15_79     */
    uint8  dummy318[52];                                   /* Reserved         */
    const __type210 CFDRMID80;                             /* CFDRMID80        */
    const __type210 CFDRMPTR80;                            /* CFDRMPTR80       */
    const __type210 CFDRMFDSTS80;                          /* CFDRMFDSTS80     */
    const __type210 CFDRMDF0_80;                           /* CFDRMDF0_80      */
    const __type210 CFDRMDF1_80;                           /* CFDRMDF1_80      */
    const __type210 CFDRMDF2_80;                           /* CFDRMDF2_80      */
    const __type210 CFDRMDF3_80;                           /* CFDRMDF3_80      */
    const __type210 CFDRMDF4_80;                           /* CFDRMDF4_80      */
    const __type210 CFDRMDF5_80;                           /* CFDRMDF5_80      */
    const __type210 CFDRMDF6_80;                           /* CFDRMDF6_80      */
    const __type210 CFDRMDF7_80;                           /* CFDRMDF7_80      */
    const __type210 CFDRMDF8_80;                           /* CFDRMDF8_80      */
    const __type210 CFDRMDF9_80;                           /* CFDRMDF9_80      */
    const __type210 CFDRMDF10_80;                          /* CFDRMDF10_80     */
    const __type210 CFDRMDF11_80;                          /* CFDRMDF11_80     */
    const __type210 CFDRMDF12_80;                          /* CFDRMDF12_80     */
    const __type210 CFDRMDF13_80;                          /* CFDRMDF13_80     */
    const __type210 CFDRMDF14_80;                          /* CFDRMDF14_80     */
    const __type210 CFDRMDF15_80;                          /* CFDRMDF15_80     */
    uint8  dummy319[52];                                   /* Reserved         */
    const __type210 CFDRMID81;                             /* CFDRMID81        */
    const __type210 CFDRMPTR81;                            /* CFDRMPTR81       */
    const __type210 CFDRMFDSTS81;                          /* CFDRMFDSTS81     */
    const __type210 CFDRMDF0_81;                           /* CFDRMDF0_81      */
    const __type210 CFDRMDF1_81;                           /* CFDRMDF1_81      */
    const __type210 CFDRMDF2_81;                           /* CFDRMDF2_81      */
    const __type210 CFDRMDF3_81;                           /* CFDRMDF3_81      */
    const __type210 CFDRMDF4_81;                           /* CFDRMDF4_81      */
    const __type210 CFDRMDF5_81;                           /* CFDRMDF5_81      */
    const __type210 CFDRMDF6_81;                           /* CFDRMDF6_81      */
    const __type210 CFDRMDF7_81;                           /* CFDRMDF7_81      */
    const __type210 CFDRMDF8_81;                           /* CFDRMDF8_81      */
    const __type210 CFDRMDF9_81;                           /* CFDRMDF9_81      */
    const __type210 CFDRMDF10_81;                          /* CFDRMDF10_81     */
    const __type210 CFDRMDF11_81;                          /* CFDRMDF11_81     */
    const __type210 CFDRMDF12_81;                          /* CFDRMDF12_81     */
    const __type210 CFDRMDF13_81;                          /* CFDRMDF13_81     */
    const __type210 CFDRMDF14_81;                          /* CFDRMDF14_81     */
    const __type210 CFDRMDF15_81;                          /* CFDRMDF15_81     */
    uint8  dummy320[52];                                   /* Reserved         */
    const __type210 CFDRMID82;                             /* CFDRMID82        */
    const __type210 CFDRMPTR82;                            /* CFDRMPTR82       */
    const __type210 CFDRMFDSTS82;                          /* CFDRMFDSTS82     */
    const __type210 CFDRMDF0_82;                           /* CFDRMDF0_82      */
    const __type210 CFDRMDF1_82;                           /* CFDRMDF1_82      */
    const __type210 CFDRMDF2_82;                           /* CFDRMDF2_82      */
    const __type210 CFDRMDF3_82;                           /* CFDRMDF3_82      */
    const __type210 CFDRMDF4_82;                           /* CFDRMDF4_82      */
    const __type210 CFDRMDF5_82;                           /* CFDRMDF5_82      */
    const __type210 CFDRMDF6_82;                           /* CFDRMDF6_82      */
    const __type210 CFDRMDF7_82;                           /* CFDRMDF7_82      */
    const __type210 CFDRMDF8_82;                           /* CFDRMDF8_82      */
    const __type210 CFDRMDF9_82;                           /* CFDRMDF9_82      */
    const __type210 CFDRMDF10_82;                          /* CFDRMDF10_82     */
    const __type210 CFDRMDF11_82;                          /* CFDRMDF11_82     */
    const __type210 CFDRMDF12_82;                          /* CFDRMDF12_82     */
    const __type210 CFDRMDF13_82;                          /* CFDRMDF13_82     */
    const __type210 CFDRMDF14_82;                          /* CFDRMDF14_82     */
    const __type210 CFDRMDF15_82;                          /* CFDRMDF15_82     */
    uint8  dummy321[52];                                   /* Reserved         */
    const __type210 CFDRMID83;                             /* CFDRMID83        */
    const __type210 CFDRMPTR83;                            /* CFDRMPTR83       */
    const __type210 CFDRMFDSTS83;                          /* CFDRMFDSTS83     */
    const __type210 CFDRMDF0_83;                           /* CFDRMDF0_83      */
    const __type210 CFDRMDF1_83;                           /* CFDRMDF1_83      */
    const __type210 CFDRMDF2_83;                           /* CFDRMDF2_83      */
    const __type210 CFDRMDF3_83;                           /* CFDRMDF3_83      */
    const __type210 CFDRMDF4_83;                           /* CFDRMDF4_83      */
    const __type210 CFDRMDF5_83;                           /* CFDRMDF5_83      */
    const __type210 CFDRMDF6_83;                           /* CFDRMDF6_83      */
    const __type210 CFDRMDF7_83;                           /* CFDRMDF7_83      */
    const __type210 CFDRMDF8_83;                           /* CFDRMDF8_83      */
    const __type210 CFDRMDF9_83;                           /* CFDRMDF9_83      */
    const __type210 CFDRMDF10_83;                          /* CFDRMDF10_83     */
    const __type210 CFDRMDF11_83;                          /* CFDRMDF11_83     */
    const __type210 CFDRMDF12_83;                          /* CFDRMDF12_83     */
    const __type210 CFDRMDF13_83;                          /* CFDRMDF13_83     */
    const __type210 CFDRMDF14_83;                          /* CFDRMDF14_83     */
    const __type210 CFDRMDF15_83;                          /* CFDRMDF15_83     */
    uint8  dummy322[52];                                   /* Reserved         */
    const __type210 CFDRMID84;                             /* CFDRMID84        */
    const __type210 CFDRMPTR84;                            /* CFDRMPTR84       */
    const __type210 CFDRMFDSTS84;                          /* CFDRMFDSTS84     */
    const __type210 CFDRMDF0_84;                           /* CFDRMDF0_84      */
    const __type210 CFDRMDF1_84;                           /* CFDRMDF1_84      */
    const __type210 CFDRMDF2_84;                           /* CFDRMDF2_84      */
    const __type210 CFDRMDF3_84;                           /* CFDRMDF3_84      */
    const __type210 CFDRMDF4_84;                           /* CFDRMDF4_84      */
    const __type210 CFDRMDF5_84;                           /* CFDRMDF5_84      */
    const __type210 CFDRMDF6_84;                           /* CFDRMDF6_84      */
    const __type210 CFDRMDF7_84;                           /* CFDRMDF7_84      */
    const __type210 CFDRMDF8_84;                           /* CFDRMDF8_84      */
    const __type210 CFDRMDF9_84;                           /* CFDRMDF9_84      */
    const __type210 CFDRMDF10_84;                          /* CFDRMDF10_84     */
    const __type210 CFDRMDF11_84;                          /* CFDRMDF11_84     */
    const __type210 CFDRMDF12_84;                          /* CFDRMDF12_84     */
    const __type210 CFDRMDF13_84;                          /* CFDRMDF13_84     */
    const __type210 CFDRMDF14_84;                          /* CFDRMDF14_84     */
    const __type210 CFDRMDF15_84;                          /* CFDRMDF15_84     */
    uint8  dummy323[52];                                   /* Reserved         */
    const __type210 CFDRMID85;                             /* CFDRMID85        */
    const __type210 CFDRMPTR85;                            /* CFDRMPTR85       */
    const __type210 CFDRMFDSTS85;                          /* CFDRMFDSTS85     */
    const __type210 CFDRMDF0_85;                           /* CFDRMDF0_85      */
    const __type210 CFDRMDF1_85;                           /* CFDRMDF1_85      */
    const __type210 CFDRMDF2_85;                           /* CFDRMDF2_85      */
    const __type210 CFDRMDF3_85;                           /* CFDRMDF3_85      */
    const __type210 CFDRMDF4_85;                           /* CFDRMDF4_85      */
    const __type210 CFDRMDF5_85;                           /* CFDRMDF5_85      */
    const __type210 CFDRMDF6_85;                           /* CFDRMDF6_85      */
    const __type210 CFDRMDF7_85;                           /* CFDRMDF7_85      */
    const __type210 CFDRMDF8_85;                           /* CFDRMDF8_85      */
    const __type210 CFDRMDF9_85;                           /* CFDRMDF9_85      */
    const __type210 CFDRMDF10_85;                          /* CFDRMDF10_85     */
    const __type210 CFDRMDF11_85;                          /* CFDRMDF11_85     */
    const __type210 CFDRMDF12_85;                          /* CFDRMDF12_85     */
    const __type210 CFDRMDF13_85;                          /* CFDRMDF13_85     */
    const __type210 CFDRMDF14_85;                          /* CFDRMDF14_85     */
    const __type210 CFDRMDF15_85;                          /* CFDRMDF15_85     */
    uint8  dummy324[52];                                   /* Reserved         */
    const __type210 CFDRMID86;                             /* CFDRMID86        */
    const __type210 CFDRMPTR86;                            /* CFDRMPTR86       */
    const __type210 CFDRMFDSTS86;                          /* CFDRMFDSTS86     */
    const __type210 CFDRMDF0_86;                           /* CFDRMDF0_86      */
    const __type210 CFDRMDF1_86;                           /* CFDRMDF1_86      */
    const __type210 CFDRMDF2_86;                           /* CFDRMDF2_86      */
    const __type210 CFDRMDF3_86;                           /* CFDRMDF3_86      */
    const __type210 CFDRMDF4_86;                           /* CFDRMDF4_86      */
    const __type210 CFDRMDF5_86;                           /* CFDRMDF5_86      */
    const __type210 CFDRMDF6_86;                           /* CFDRMDF6_86      */
    const __type210 CFDRMDF7_86;                           /* CFDRMDF7_86      */
    const __type210 CFDRMDF8_86;                           /* CFDRMDF8_86      */
    const __type210 CFDRMDF9_86;                           /* CFDRMDF9_86      */
    const __type210 CFDRMDF10_86;                          /* CFDRMDF10_86     */
    const __type210 CFDRMDF11_86;                          /* CFDRMDF11_86     */
    const __type210 CFDRMDF12_86;                          /* CFDRMDF12_86     */
    const __type210 CFDRMDF13_86;                          /* CFDRMDF13_86     */
    const __type210 CFDRMDF14_86;                          /* CFDRMDF14_86     */
    const __type210 CFDRMDF15_86;                          /* CFDRMDF15_86     */
    uint8  dummy325[52];                                   /* Reserved         */
    const __type210 CFDRMID87;                             /* CFDRMID87        */
    const __type210 CFDRMPTR87;                            /* CFDRMPTR87       */
    const __type210 CFDRMFDSTS87;                          /* CFDRMFDSTS87     */
    const __type210 CFDRMDF0_87;                           /* CFDRMDF0_87      */
    const __type210 CFDRMDF1_87;                           /* CFDRMDF1_87      */
    const __type210 CFDRMDF2_87;                           /* CFDRMDF2_87      */
    const __type210 CFDRMDF3_87;                           /* CFDRMDF3_87      */
    const __type210 CFDRMDF4_87;                           /* CFDRMDF4_87      */
    const __type210 CFDRMDF5_87;                           /* CFDRMDF5_87      */
    const __type210 CFDRMDF6_87;                           /* CFDRMDF6_87      */
    const __type210 CFDRMDF7_87;                           /* CFDRMDF7_87      */
    const __type210 CFDRMDF8_87;                           /* CFDRMDF8_87      */
    const __type210 CFDRMDF9_87;                           /* CFDRMDF9_87      */
    const __type210 CFDRMDF10_87;                          /* CFDRMDF10_87     */
    const __type210 CFDRMDF11_87;                          /* CFDRMDF11_87     */
    const __type210 CFDRMDF12_87;                          /* CFDRMDF12_87     */
    const __type210 CFDRMDF13_87;                          /* CFDRMDF13_87     */
    const __type210 CFDRMDF14_87;                          /* CFDRMDF14_87     */
    const __type210 CFDRMDF15_87;                          /* CFDRMDF15_87     */
    uint8  dummy326[52];                                   /* Reserved         */
    const __type210 CFDRMID88;                             /* CFDRMID88        */
    const __type210 CFDRMPTR88;                            /* CFDRMPTR88       */
    const __type210 CFDRMFDSTS88;                          /* CFDRMFDSTS88     */
    const __type210 CFDRMDF0_88;                           /* CFDRMDF0_88      */
    const __type210 CFDRMDF1_88;                           /* CFDRMDF1_88      */
    const __type210 CFDRMDF2_88;                           /* CFDRMDF2_88      */
    const __type210 CFDRMDF3_88;                           /* CFDRMDF3_88      */
    const __type210 CFDRMDF4_88;                           /* CFDRMDF4_88      */
    const __type210 CFDRMDF5_88;                           /* CFDRMDF5_88      */
    const __type210 CFDRMDF6_88;                           /* CFDRMDF6_88      */
    const __type210 CFDRMDF7_88;                           /* CFDRMDF7_88      */
    const __type210 CFDRMDF8_88;                           /* CFDRMDF8_88      */
    const __type210 CFDRMDF9_88;                           /* CFDRMDF9_88      */
    const __type210 CFDRMDF10_88;                          /* CFDRMDF10_88     */
    const __type210 CFDRMDF11_88;                          /* CFDRMDF11_88     */
    const __type210 CFDRMDF12_88;                          /* CFDRMDF12_88     */
    const __type210 CFDRMDF13_88;                          /* CFDRMDF13_88     */
    const __type210 CFDRMDF14_88;                          /* CFDRMDF14_88     */
    const __type210 CFDRMDF15_88;                          /* CFDRMDF15_88     */
    uint8  dummy327[52];                                   /* Reserved         */
    const __type210 CFDRMID89;                             /* CFDRMID89        */
    const __type210 CFDRMPTR89;                            /* CFDRMPTR89       */
    const __type210 CFDRMFDSTS89;                          /* CFDRMFDSTS89     */
    const __type210 CFDRMDF0_89;                           /* CFDRMDF0_89      */
    const __type210 CFDRMDF1_89;                           /* CFDRMDF1_89      */
    const __type210 CFDRMDF2_89;                           /* CFDRMDF2_89      */
    const __type210 CFDRMDF3_89;                           /* CFDRMDF3_89      */
    const __type210 CFDRMDF4_89;                           /* CFDRMDF4_89      */
    const __type210 CFDRMDF5_89;                           /* CFDRMDF5_89      */
    const __type210 CFDRMDF6_89;                           /* CFDRMDF6_89      */
    const __type210 CFDRMDF7_89;                           /* CFDRMDF7_89      */
    const __type210 CFDRMDF8_89;                           /* CFDRMDF8_89      */
    const __type210 CFDRMDF9_89;                           /* CFDRMDF9_89      */
    const __type210 CFDRMDF10_89;                          /* CFDRMDF10_89     */
    const __type210 CFDRMDF11_89;                          /* CFDRMDF11_89     */
    const __type210 CFDRMDF12_89;                          /* CFDRMDF12_89     */
    const __type210 CFDRMDF13_89;                          /* CFDRMDF13_89     */
    const __type210 CFDRMDF14_89;                          /* CFDRMDF14_89     */
    const __type210 CFDRMDF15_89;                          /* CFDRMDF15_89     */
    uint8  dummy328[52];                                   /* Reserved         */
    const __type210 CFDRMID90;                             /* CFDRMID90        */
    const __type210 CFDRMPTR90;                            /* CFDRMPTR90       */
    const __type210 CFDRMFDSTS90;                          /* CFDRMFDSTS90     */
    const __type210 CFDRMDF0_90;                           /* CFDRMDF0_90      */
    const __type210 CFDRMDF1_90;                           /* CFDRMDF1_90      */
    const __type210 CFDRMDF2_90;                           /* CFDRMDF2_90      */
    const __type210 CFDRMDF3_90;                           /* CFDRMDF3_90      */
    const __type210 CFDRMDF4_90;                           /* CFDRMDF4_90      */
    const __type210 CFDRMDF5_90;                           /* CFDRMDF5_90      */
    const __type210 CFDRMDF6_90;                           /* CFDRMDF6_90      */
    const __type210 CFDRMDF7_90;                           /* CFDRMDF7_90      */
    const __type210 CFDRMDF8_90;                           /* CFDRMDF8_90      */
    const __type210 CFDRMDF9_90;                           /* CFDRMDF9_90      */
    const __type210 CFDRMDF10_90;                          /* CFDRMDF10_90     */
    const __type210 CFDRMDF11_90;                          /* CFDRMDF11_90     */
    const __type210 CFDRMDF12_90;                          /* CFDRMDF12_90     */
    const __type210 CFDRMDF13_90;                          /* CFDRMDF13_90     */
    const __type210 CFDRMDF14_90;                          /* CFDRMDF14_90     */
    const __type210 CFDRMDF15_90;                          /* CFDRMDF15_90     */
    uint8  dummy329[52];                                   /* Reserved         */
    const __type210 CFDRMID91;                             /* CFDRMID91        */
    const __type210 CFDRMPTR91;                            /* CFDRMPTR91       */
    const __type210 CFDRMFDSTS91;                          /* CFDRMFDSTS91     */
    const __type210 CFDRMDF0_91;                           /* CFDRMDF0_91      */
    const __type210 CFDRMDF1_91;                           /* CFDRMDF1_91      */
    const __type210 CFDRMDF2_91;                           /* CFDRMDF2_91      */
    const __type210 CFDRMDF3_91;                           /* CFDRMDF3_91      */
    const __type210 CFDRMDF4_91;                           /* CFDRMDF4_91      */
    const __type210 CFDRMDF5_91;                           /* CFDRMDF5_91      */
    const __type210 CFDRMDF6_91;                           /* CFDRMDF6_91      */
    const __type210 CFDRMDF7_91;                           /* CFDRMDF7_91      */
    const __type210 CFDRMDF8_91;                           /* CFDRMDF8_91      */
    const __type210 CFDRMDF9_91;                           /* CFDRMDF9_91      */
    const __type210 CFDRMDF10_91;                          /* CFDRMDF10_91     */
    const __type210 CFDRMDF11_91;                          /* CFDRMDF11_91     */
    const __type210 CFDRMDF12_91;                          /* CFDRMDF12_91     */
    const __type210 CFDRMDF13_91;                          /* CFDRMDF13_91     */
    const __type210 CFDRMDF14_91;                          /* CFDRMDF14_91     */
    const __type210 CFDRMDF15_91;                          /* CFDRMDF15_91     */
    uint8  dummy330[52];                                   /* Reserved         */
    const __type210 CFDRMID92;                             /* CFDRMID92        */
    const __type210 CFDRMPTR92;                            /* CFDRMPTR92       */
    const __type210 CFDRMFDSTS92;                          /* CFDRMFDSTS92     */
    const __type210 CFDRMDF0_92;                           /* CFDRMDF0_92      */
    const __type210 CFDRMDF1_92;                           /* CFDRMDF1_92      */
    const __type210 CFDRMDF2_92;                           /* CFDRMDF2_92      */
    const __type210 CFDRMDF3_92;                           /* CFDRMDF3_92      */
    const __type210 CFDRMDF4_92;                           /* CFDRMDF4_92      */
    const __type210 CFDRMDF5_92;                           /* CFDRMDF5_92      */
    const __type210 CFDRMDF6_92;                           /* CFDRMDF6_92      */
    const __type210 CFDRMDF7_92;                           /* CFDRMDF7_92      */
    const __type210 CFDRMDF8_92;                           /* CFDRMDF8_92      */
    const __type210 CFDRMDF9_92;                           /* CFDRMDF9_92      */
    const __type210 CFDRMDF10_92;                          /* CFDRMDF10_92     */
    const __type210 CFDRMDF11_92;                          /* CFDRMDF11_92     */
    const __type210 CFDRMDF12_92;                          /* CFDRMDF12_92     */
    const __type210 CFDRMDF13_92;                          /* CFDRMDF13_92     */
    const __type210 CFDRMDF14_92;                          /* CFDRMDF14_92     */
    const __type210 CFDRMDF15_92;                          /* CFDRMDF15_92     */
    uint8  dummy331[52];                                   /* Reserved         */
    const __type210 CFDRMID93;                             /* CFDRMID93        */
    const __type210 CFDRMPTR93;                            /* CFDRMPTR93       */
    const __type210 CFDRMFDSTS93;                          /* CFDRMFDSTS93     */
    const __type210 CFDRMDF0_93;                           /* CFDRMDF0_93      */
    const __type210 CFDRMDF1_93;                           /* CFDRMDF1_93      */
    const __type210 CFDRMDF2_93;                           /* CFDRMDF2_93      */
    const __type210 CFDRMDF3_93;                           /* CFDRMDF3_93      */
    const __type210 CFDRMDF4_93;                           /* CFDRMDF4_93      */
    const __type210 CFDRMDF5_93;                           /* CFDRMDF5_93      */
    const __type210 CFDRMDF6_93;                           /* CFDRMDF6_93      */
    const __type210 CFDRMDF7_93;                           /* CFDRMDF7_93      */
    const __type210 CFDRMDF8_93;                           /* CFDRMDF8_93      */
    const __type210 CFDRMDF9_93;                           /* CFDRMDF9_93      */
    const __type210 CFDRMDF10_93;                          /* CFDRMDF10_93     */
    const __type210 CFDRMDF11_93;                          /* CFDRMDF11_93     */
    const __type210 CFDRMDF12_93;                          /* CFDRMDF12_93     */
    const __type210 CFDRMDF13_93;                          /* CFDRMDF13_93     */
    const __type210 CFDRMDF14_93;                          /* CFDRMDF14_93     */
    const __type210 CFDRMDF15_93;                          /* CFDRMDF15_93     */
    uint8  dummy332[52];                                   /* Reserved         */
    const __type210 CFDRMID94;                             /* CFDRMID94        */
    const __type210 CFDRMPTR94;                            /* CFDRMPTR94       */
    const __type210 CFDRMFDSTS94;                          /* CFDRMFDSTS94     */
    const __type210 CFDRMDF0_94;                           /* CFDRMDF0_94      */
    const __type210 CFDRMDF1_94;                           /* CFDRMDF1_94      */
    const __type210 CFDRMDF2_94;                           /* CFDRMDF2_94      */
    const __type210 CFDRMDF3_94;                           /* CFDRMDF3_94      */
    const __type210 CFDRMDF4_94;                           /* CFDRMDF4_94      */
    const __type210 CFDRMDF5_94;                           /* CFDRMDF5_94      */
    const __type210 CFDRMDF6_94;                           /* CFDRMDF6_94      */
    const __type210 CFDRMDF7_94;                           /* CFDRMDF7_94      */
    const __type210 CFDRMDF8_94;                           /* CFDRMDF8_94      */
    const __type210 CFDRMDF9_94;                           /* CFDRMDF9_94      */
    const __type210 CFDRMDF10_94;                          /* CFDRMDF10_94     */
    const __type210 CFDRMDF11_94;                          /* CFDRMDF11_94     */
    const __type210 CFDRMDF12_94;                          /* CFDRMDF12_94     */
    const __type210 CFDRMDF13_94;                          /* CFDRMDF13_94     */
    const __type210 CFDRMDF14_94;                          /* CFDRMDF14_94     */
    const __type210 CFDRMDF15_94;                          /* CFDRMDF15_94     */
    uint8  dummy333[52];                                   /* Reserved         */
    const __type210 CFDRMID95;                             /* CFDRMID95        */
    const __type210 CFDRMPTR95;                            /* CFDRMPTR95       */
    const __type210 CFDRMFDSTS95;                          /* CFDRMFDSTS95     */
    const __type210 CFDRMDF0_95;                           /* CFDRMDF0_95      */
    const __type210 CFDRMDF1_95;                           /* CFDRMDF1_95      */
    const __type210 CFDRMDF2_95;                           /* CFDRMDF2_95      */
    const __type210 CFDRMDF3_95;                           /* CFDRMDF3_95      */
    const __type210 CFDRMDF4_95;                           /* CFDRMDF4_95      */
    const __type210 CFDRMDF5_95;                           /* CFDRMDF5_95      */
    const __type210 CFDRMDF6_95;                           /* CFDRMDF6_95      */
    const __type210 CFDRMDF7_95;                           /* CFDRMDF7_95      */
    const __type210 CFDRMDF8_95;                           /* CFDRMDF8_95      */
    const __type210 CFDRMDF9_95;                           /* CFDRMDF9_95      */
    const __type210 CFDRMDF10_95;                          /* CFDRMDF10_95     */
    const __type210 CFDRMDF11_95;                          /* CFDRMDF11_95     */
    const __type210 CFDRMDF12_95;                          /* CFDRMDF12_95     */
    const __type210 CFDRMDF13_95;                          /* CFDRMDF13_95     */
    const __type210 CFDRMDF14_95;                          /* CFDRMDF14_95     */
    const __type210 CFDRMDF15_95;                          /* CFDRMDF15_95     */
    uint8  dummy334[4148];                                 /* Reserved         */
    const __type210 CFDRFID0;                              /* CFDRFID0         */
    const __type210 CFDRFPTR0;                             /* CFDRFPTR0        */
    const __type210 CFDRFFDSTS0;                           /* CFDRFFDSTS0      */
    const __type210 CFDRFDF0_0;                            /* CFDRFDF0_0       */
    const __type210 CFDRFDF1_0;                            /* CFDRFDF1_0       */
    const __type210 CFDRFDF2_0;                            /* CFDRFDF2_0       */
    const __type210 CFDRFDF3_0;                            /* CFDRFDF3_0       */
    const __type210 CFDRFDF4_0;                            /* CFDRFDF4_0       */
    const __type210 CFDRFDF5_0;                            /* CFDRFDF5_0       */
    const __type210 CFDRFDF6_0;                            /* CFDRFDF6_0       */
    const __type210 CFDRFDF7_0;                            /* CFDRFDF7_0       */
    const __type210 CFDRFDF8_0;                            /* CFDRFDF8_0       */
    const __type210 CFDRFDF9_0;                            /* CFDRFDF9_0       */
    const __type210 CFDRFDF10_0;                           /* CFDRFDF10_0      */
    const __type210 CFDRFDF11_0;                           /* CFDRFDF11_0      */
    const __type210 CFDRFDF12_0;                           /* CFDRFDF12_0      */
    const __type210 CFDRFDF13_0;                           /* CFDRFDF13_0      */
    const __type210 CFDRFDF14_0;                           /* CFDRFDF14_0      */
    const __type210 CFDRFDF15_0;                           /* CFDRFDF15_0      */
    uint8  dummy335[52];                                   /* Reserved         */
    const __type210 CFDRFID1;                              /* CFDRFID1         */
    const __type210 CFDRFPTR1;                             /* CFDRFPTR1        */
    const __type210 CFDRFFDSTS1;                           /* CFDRFFDSTS1      */
    const __type210 CFDRFDF0_1;                            /* CFDRFDF0_1       */
    const __type210 CFDRFDF1_1;                            /* CFDRFDF1_1       */
    const __type210 CFDRFDF2_1;                            /* CFDRFDF2_1       */
    const __type210 CFDRFDF3_1;                            /* CFDRFDF3_1       */
    const __type210 CFDRFDF4_1;                            /* CFDRFDF4_1       */
    const __type210 CFDRFDF5_1;                            /* CFDRFDF5_1       */
    const __type210 CFDRFDF6_1;                            /* CFDRFDF6_1       */
    const __type210 CFDRFDF7_1;                            /* CFDRFDF7_1       */
    const __type210 CFDRFDF8_1;                            /* CFDRFDF8_1       */
    const __type210 CFDRFDF9_1;                            /* CFDRFDF9_1       */
    const __type210 CFDRFDF10_1;                           /* CFDRFDF10_1      */
    const __type210 CFDRFDF11_1;                           /* CFDRFDF11_1      */
    const __type210 CFDRFDF12_1;                           /* CFDRFDF12_1      */
    const __type210 CFDRFDF13_1;                           /* CFDRFDF13_1      */
    const __type210 CFDRFDF14_1;                           /* CFDRFDF14_1      */
    const __type210 CFDRFDF15_1;                           /* CFDRFDF15_1      */
    uint8  dummy336[52];                                   /* Reserved         */
    const __type210 CFDRFID2;                              /* CFDRFID2         */
    const __type210 CFDRFPTR2;                             /* CFDRFPTR2        */
    const __type210 CFDRFFDSTS2;                           /* CFDRFFDSTS2      */
    const __type210 CFDRFDF0_2;                            /* CFDRFDF0_2       */
    const __type210 CFDRFDF1_2;                            /* CFDRFDF1_2       */
    const __type210 CFDRFDF2_2;                            /* CFDRFDF2_2       */
    const __type210 CFDRFDF3_2;                            /* CFDRFDF3_2       */
    const __type210 CFDRFDF4_2;                            /* CFDRFDF4_2       */
    const __type210 CFDRFDF5_2;                            /* CFDRFDF5_2       */
    const __type210 CFDRFDF6_2;                            /* CFDRFDF6_2       */
    const __type210 CFDRFDF7_2;                            /* CFDRFDF7_2       */
    const __type210 CFDRFDF8_2;                            /* CFDRFDF8_2       */
    const __type210 CFDRFDF9_2;                            /* CFDRFDF9_2       */
    const __type210 CFDRFDF10_2;                           /* CFDRFDF10_2      */
    const __type210 CFDRFDF11_2;                           /* CFDRFDF11_2      */
    const __type210 CFDRFDF12_2;                           /* CFDRFDF12_2      */
    const __type210 CFDRFDF13_2;                           /* CFDRFDF13_2      */
    const __type210 CFDRFDF14_2;                           /* CFDRFDF14_2      */
    const __type210 CFDRFDF15_2;                           /* CFDRFDF15_2      */
    uint8  dummy337[52];                                   /* Reserved         */
    const __type210 CFDRFID3;                              /* CFDRFID3         */
    const __type210 CFDRFPTR3;                             /* CFDRFPTR3        */
    const __type210 CFDRFFDSTS3;                           /* CFDRFFDSTS3      */
    const __type210 CFDRFDF0_3;                            /* CFDRFDF0_3       */
    const __type210 CFDRFDF1_3;                            /* CFDRFDF1_3       */
    const __type210 CFDRFDF2_3;                            /* CFDRFDF2_3       */
    const __type210 CFDRFDF3_3;                            /* CFDRFDF3_3       */
    const __type210 CFDRFDF4_3;                            /* CFDRFDF4_3       */
    const __type210 CFDRFDF5_3;                            /* CFDRFDF5_3       */
    const __type210 CFDRFDF6_3;                            /* CFDRFDF6_3       */
    const __type210 CFDRFDF7_3;                            /* CFDRFDF7_3       */
    const __type210 CFDRFDF8_3;                            /* CFDRFDF8_3       */
    const __type210 CFDRFDF9_3;                            /* CFDRFDF9_3       */
    const __type210 CFDRFDF10_3;                           /* CFDRFDF10_3      */
    const __type210 CFDRFDF11_3;                           /* CFDRFDF11_3      */
    const __type210 CFDRFDF12_3;                           /* CFDRFDF12_3      */
    const __type210 CFDRFDF13_3;                           /* CFDRFDF13_3      */
    const __type210 CFDRFDF14_3;                           /* CFDRFDF14_3      */
    const __type210 CFDRFDF15_3;                           /* CFDRFDF15_3      */
    uint8  dummy338[52];                                   /* Reserved         */
    const __type210 CFDRFID4;                              /* CFDRFID4         */
    const __type210 CFDRFPTR4;                             /* CFDRFPTR4        */
    const __type210 CFDRFFDSTS4;                           /* CFDRFFDSTS4      */
    const __type210 CFDRFDF0_4;                            /* CFDRFDF0_4       */
    const __type210 CFDRFDF1_4;                            /* CFDRFDF1_4       */
    const __type210 CFDRFDF2_4;                            /* CFDRFDF2_4       */
    const __type210 CFDRFDF3_4;                            /* CFDRFDF3_4       */
    const __type210 CFDRFDF4_4;                            /* CFDRFDF4_4       */
    const __type210 CFDRFDF5_4;                            /* CFDRFDF5_4       */
    const __type210 CFDRFDF6_4;                            /* CFDRFDF6_4       */
    const __type210 CFDRFDF7_4;                            /* CFDRFDF7_4       */
    const __type210 CFDRFDF8_4;                            /* CFDRFDF8_4       */
    const __type210 CFDRFDF9_4;                            /* CFDRFDF9_4       */
    const __type210 CFDRFDF10_4;                           /* CFDRFDF10_4      */
    const __type210 CFDRFDF11_4;                           /* CFDRFDF11_4      */
    const __type210 CFDRFDF12_4;                           /* CFDRFDF12_4      */
    const __type210 CFDRFDF13_4;                           /* CFDRFDF13_4      */
    const __type210 CFDRFDF14_4;                           /* CFDRFDF14_4      */
    const __type210 CFDRFDF15_4;                           /* CFDRFDF15_4      */
    uint8  dummy339[52];                                   /* Reserved         */
    const __type210 CFDRFID5;                              /* CFDRFID5         */
    const __type210 CFDRFPTR5;                             /* CFDRFPTR5        */
    const __type210 CFDRFFDSTS5;                           /* CFDRFFDSTS5      */
    const __type210 CFDRFDF0_5;                            /* CFDRFDF0_5       */
    const __type210 CFDRFDF1_5;                            /* CFDRFDF1_5       */
    const __type210 CFDRFDF2_5;                            /* CFDRFDF2_5       */
    const __type210 CFDRFDF3_5;                            /* CFDRFDF3_5       */
    const __type210 CFDRFDF4_5;                            /* CFDRFDF4_5       */
    const __type210 CFDRFDF5_5;                            /* CFDRFDF5_5       */
    const __type210 CFDRFDF6_5;                            /* CFDRFDF6_5       */
    const __type210 CFDRFDF7_5;                            /* CFDRFDF7_5       */
    const __type210 CFDRFDF8_5;                            /* CFDRFDF8_5       */
    const __type210 CFDRFDF9_5;                            /* CFDRFDF9_5       */
    const __type210 CFDRFDF10_5;                           /* CFDRFDF10_5      */
    const __type210 CFDRFDF11_5;                           /* CFDRFDF11_5      */
    const __type210 CFDRFDF12_5;                           /* CFDRFDF12_5      */
    const __type210 CFDRFDF13_5;                           /* CFDRFDF13_5      */
    const __type210 CFDRFDF14_5;                           /* CFDRFDF14_5      */
    const __type210 CFDRFDF15_5;                           /* CFDRFDF15_5      */
    uint8  dummy340[52];                                   /* Reserved         */
    const __type210 CFDRFID6;                              /* CFDRFID6         */
    const __type210 CFDRFPTR6;                             /* CFDRFPTR6        */
    const __type210 CFDRFFDSTS6;                           /* CFDRFFDSTS6      */
    const __type210 CFDRFDF0_6;                            /* CFDRFDF0_6       */
    const __type210 CFDRFDF1_6;                            /* CFDRFDF1_6       */
    const __type210 CFDRFDF2_6;                            /* CFDRFDF2_6       */
    const __type210 CFDRFDF3_6;                            /* CFDRFDF3_6       */
    const __type210 CFDRFDF4_6;                            /* CFDRFDF4_6       */
    const __type210 CFDRFDF5_6;                            /* CFDRFDF5_6       */
    const __type210 CFDRFDF6_6;                            /* CFDRFDF6_6       */
    const __type210 CFDRFDF7_6;                            /* CFDRFDF7_6       */
    const __type210 CFDRFDF8_6;                            /* CFDRFDF8_6       */
    const __type210 CFDRFDF9_6;                            /* CFDRFDF9_6       */
    const __type210 CFDRFDF10_6;                           /* CFDRFDF10_6      */
    const __type210 CFDRFDF11_6;                           /* CFDRFDF11_6      */
    const __type210 CFDRFDF12_6;                           /* CFDRFDF12_6      */
    const __type210 CFDRFDF13_6;                           /* CFDRFDF13_6      */
    const __type210 CFDRFDF14_6;                           /* CFDRFDF14_6      */
    const __type210 CFDRFDF15_6;                           /* CFDRFDF15_6      */
    uint8  dummy341[52];                                   /* Reserved         */
    const __type210 CFDRFID7;                              /* CFDRFID7         */
    const __type210 CFDRFPTR7;                             /* CFDRFPTR7        */
    const __type210 CFDRFFDSTS7;                           /* CFDRFFDSTS7      */
    const __type210 CFDRFDF0_7;                            /* CFDRFDF0_7       */
    const __type210 CFDRFDF1_7;                            /* CFDRFDF1_7       */
    const __type210 CFDRFDF2_7;                            /* CFDRFDF2_7       */
    const __type210 CFDRFDF3_7;                            /* CFDRFDF3_7       */
    const __type210 CFDRFDF4_7;                            /* CFDRFDF4_7       */
    const __type210 CFDRFDF5_7;                            /* CFDRFDF5_7       */
    const __type210 CFDRFDF6_7;                            /* CFDRFDF6_7       */
    const __type210 CFDRFDF7_7;                            /* CFDRFDF7_7       */
    const __type210 CFDRFDF8_7;                            /* CFDRFDF8_7       */
    const __type210 CFDRFDF9_7;                            /* CFDRFDF9_7       */
    const __type210 CFDRFDF10_7;                           /* CFDRFDF10_7      */
    const __type210 CFDRFDF11_7;                           /* CFDRFDF11_7      */
    const __type210 CFDRFDF12_7;                           /* CFDRFDF12_7      */
    const __type210 CFDRFDF13_7;                           /* CFDRFDF13_7      */
    const __type210 CFDRFDF14_7;                           /* CFDRFDF14_7      */
    const __type210 CFDRFDF15_7;                           /* CFDRFDF15_7      */
    uint8  dummy342[52];                                   /* Reserved         */
    __type210 CFDCFID0;                                    /* CFDCFID0         */
    __type210 CFDCFPTR0;                                   /* CFDCFPTR0        */
    __type210 CFDCFFDCSTS0;                                /* CFDCFFDCSTS0     */
    __type210 CFDCFDF0_0;                                  /* CFDCFDF0_0       */
    __type210 CFDCFDF1_0;                                  /* CFDCFDF1_0       */
    __type210 CFDCFDF2_0;                                  /* CFDCFDF2_0       */
    __type210 CFDCFDF3_0;                                  /* CFDCFDF3_0       */
    __type210 CFDCFDF4_0;                                  /* CFDCFDF4_0       */
    __type210 CFDCFDF5_0;                                  /* CFDCFDF5_0       */
    __type210 CFDCFDF6_0;                                  /* CFDCFDF6_0       */
    __type210 CFDCFDF7_0;                                  /* CFDCFDF7_0       */
    __type210 CFDCFDF8_0;                                  /* CFDCFDF8_0       */
    __type210 CFDCFDF9_0;                                  /* CFDCFDF9_0       */
    __type210 CFDCFDF10_0;                                 /* CFDCFDF10_0      */
    __type210 CFDCFDF11_0;                                 /* CFDCFDF11_0      */
    __type210 CFDCFDF12_0;                                 /* CFDCFDF12_0      */
    __type210 CFDCFDF13_0;                                 /* CFDCFDF13_0      */
    __type210 CFDCFDF14_0;                                 /* CFDCFDF14_0      */
    __type210 CFDCFDF15_0;                                 /* CFDCFDF15_0      */
    uint8  dummy343[52];                                   /* Reserved         */
    __type210 CFDCFID1;                                    /* CFDCFID1         */
    __type210 CFDCFPTR1;                                   /* CFDCFPTR1        */
    __type210 CFDCFFDCSTS1;                                /* CFDCFFDCSTS1     */
    __type210 CFDCFDF0_1;                                  /* CFDCFDF0_1       */
    __type210 CFDCFDF1_1;                                  /* CFDCFDF1_1       */
    __type210 CFDCFDF2_1;                                  /* CFDCFDF2_1       */
    __type210 CFDCFDF3_1;                                  /* CFDCFDF3_1       */
    __type210 CFDCFDF4_1;                                  /* CFDCFDF4_1       */
    __type210 CFDCFDF5_1;                                  /* CFDCFDF5_1       */
    __type210 CFDCFDF6_1;                                  /* CFDCFDF6_1       */
    __type210 CFDCFDF7_1;                                  /* CFDCFDF7_1       */
    __type210 CFDCFDF8_1;                                  /* CFDCFDF8_1       */
    __type210 CFDCFDF9_1;                                  /* CFDCFDF9_1       */
    __type210 CFDCFDF10_1;                                 /* CFDCFDF10_1      */
    __type210 CFDCFDF11_1;                                 /* CFDCFDF11_1      */
    __type210 CFDCFDF12_1;                                 /* CFDCFDF12_1      */
    __type210 CFDCFDF13_1;                                 /* CFDCFDF13_1      */
    __type210 CFDCFDF14_1;                                 /* CFDCFDF14_1      */
    __type210 CFDCFDF15_1;                                 /* CFDCFDF15_1      */
    uint8  dummy344[52];                                   /* Reserved         */
    __type210 CFDCFID2;                                    /* CFDCFID2         */
    __type210 CFDCFPTR2;                                   /* CFDCFPTR2        */
    __type210 CFDCFFDCSTS2;                                /* CFDCFFDCSTS2     */
    __type210 CFDCFDF0_2;                                  /* CFDCFDF0_2       */
    __type210 CFDCFDF1_2;                                  /* CFDCFDF1_2       */
    __type210 CFDCFDF2_2;                                  /* CFDCFDF2_2       */
    __type210 CFDCFDF3_2;                                  /* CFDCFDF3_2       */
    __type210 CFDCFDF4_2;                                  /* CFDCFDF4_2       */
    __type210 CFDCFDF5_2;                                  /* CFDCFDF5_2       */
    __type210 CFDCFDF6_2;                                  /* CFDCFDF6_2       */
    __type210 CFDCFDF7_2;                                  /* CFDCFDF7_2       */
    __type210 CFDCFDF8_2;                                  /* CFDCFDF8_2       */
    __type210 CFDCFDF9_2;                                  /* CFDCFDF9_2       */
    __type210 CFDCFDF10_2;                                 /* CFDCFDF10_2      */
    __type210 CFDCFDF11_2;                                 /* CFDCFDF11_2      */
    __type210 CFDCFDF12_2;                                 /* CFDCFDF12_2      */
    __type210 CFDCFDF13_2;                                 /* CFDCFDF13_2      */
    __type210 CFDCFDF14_2;                                 /* CFDCFDF14_2      */
    __type210 CFDCFDF15_2;                                 /* CFDCFDF15_2      */
    uint8  dummy345[52];                                   /* Reserved         */
    __type210 CFDCFID3;                                    /* CFDCFID3         */
    __type210 CFDCFPTR3;                                   /* CFDCFPTR3        */
    __type210 CFDCFFDCSTS3;                                /* CFDCFFDCSTS3     */
    __type210 CFDCFDF0_3;                                  /* CFDCFDF0_3       */
    __type210 CFDCFDF1_3;                                  /* CFDCFDF1_3       */
    __type210 CFDCFDF2_3;                                  /* CFDCFDF2_3       */
    __type210 CFDCFDF3_3;                                  /* CFDCFDF3_3       */
    __type210 CFDCFDF4_3;                                  /* CFDCFDF4_3       */
    __type210 CFDCFDF5_3;                                  /* CFDCFDF5_3       */
    __type210 CFDCFDF6_3;                                  /* CFDCFDF6_3       */
    __type210 CFDCFDF7_3;                                  /* CFDCFDF7_3       */
    __type210 CFDCFDF8_3;                                  /* CFDCFDF8_3       */
    __type210 CFDCFDF9_3;                                  /* CFDCFDF9_3       */
    __type210 CFDCFDF10_3;                                 /* CFDCFDF10_3      */
    __type210 CFDCFDF11_3;                                 /* CFDCFDF11_3      */
    __type210 CFDCFDF12_3;                                 /* CFDCFDF12_3      */
    __type210 CFDCFDF13_3;                                 /* CFDCFDF13_3      */
    __type210 CFDCFDF14_3;                                 /* CFDCFDF14_3      */
    __type210 CFDCFDF15_3;                                 /* CFDCFDF15_3      */
    uint8  dummy346[52];                                   /* Reserved         */
    __type210 CFDCFID4;                                    /* CFDCFID4         */
    __type210 CFDCFPTR4;                                   /* CFDCFPTR4        */
    __type210 CFDCFFDCSTS4;                                /* CFDCFFDCSTS4     */
    __type210 CFDCFDF0_4;                                  /* CFDCFDF0_4       */
    __type210 CFDCFDF1_4;                                  /* CFDCFDF1_4       */
    __type210 CFDCFDF2_4;                                  /* CFDCFDF2_4       */
    __type210 CFDCFDF3_4;                                  /* CFDCFDF3_4       */
    __type210 CFDCFDF4_4;                                  /* CFDCFDF4_4       */
    __type210 CFDCFDF5_4;                                  /* CFDCFDF5_4       */
    __type210 CFDCFDF6_4;                                  /* CFDCFDF6_4       */
    __type210 CFDCFDF7_4;                                  /* CFDCFDF7_4       */
    __type210 CFDCFDF8_4;                                  /* CFDCFDF8_4       */
    __type210 CFDCFDF9_4;                                  /* CFDCFDF9_4       */
    __type210 CFDCFDF10_4;                                 /* CFDCFDF10_4      */
    __type210 CFDCFDF11_4;                                 /* CFDCFDF11_4      */
    __type210 CFDCFDF12_4;                                 /* CFDCFDF12_4      */
    __type210 CFDCFDF13_4;                                 /* CFDCFDF13_4      */
    __type210 CFDCFDF14_4;                                 /* CFDCFDF14_4      */
    __type210 CFDCFDF15_4;                                 /* CFDCFDF15_4      */
    uint8  dummy347[52];                                   /* Reserved         */
    __type210 CFDCFID5;                                    /* CFDCFID5         */
    __type210 CFDCFPTR5;                                   /* CFDCFPTR5        */
    __type210 CFDCFFDCSTS5;                                /* CFDCFFDCSTS5     */
    __type210 CFDCFDF0_5;                                  /* CFDCFDF0_5       */
    __type210 CFDCFDF1_5;                                  /* CFDCFDF1_5       */
    __type210 CFDCFDF2_5;                                  /* CFDCFDF2_5       */
    __type210 CFDCFDF3_5;                                  /* CFDCFDF3_5       */
    __type210 CFDCFDF4_5;                                  /* CFDCFDF4_5       */
    __type210 CFDCFDF5_5;                                  /* CFDCFDF5_5       */
    __type210 CFDCFDF6_5;                                  /* CFDCFDF6_5       */
    __type210 CFDCFDF7_5;                                  /* CFDCFDF7_5       */
    __type210 CFDCFDF8_5;                                  /* CFDCFDF8_5       */
    __type210 CFDCFDF9_5;                                  /* CFDCFDF9_5       */
    __type210 CFDCFDF10_5;                                 /* CFDCFDF10_5      */
    __type210 CFDCFDF11_5;                                 /* CFDCFDF11_5      */
    __type210 CFDCFDF12_5;                                 /* CFDCFDF12_5      */
    __type210 CFDCFDF13_5;                                 /* CFDCFDF13_5      */
    __type210 CFDCFDF14_5;                                 /* CFDCFDF14_5      */
    __type210 CFDCFDF15_5;                                 /* CFDCFDF15_5      */
    uint8  dummy348[52];                                   /* Reserved         */
    __type210 CFDCFID6;                                    /* CFDCFID6         */
    __type210 CFDCFPTR6;                                   /* CFDCFPTR6        */
    __type210 CFDCFFDCSTS6;                                /* CFDCFFDCSTS6     */
    __type210 CFDCFDF0_6;                                  /* CFDCFDF0_6       */
    __type210 CFDCFDF1_6;                                  /* CFDCFDF1_6       */
    __type210 CFDCFDF2_6;                                  /* CFDCFDF2_6       */
    __type210 CFDCFDF3_6;                                  /* CFDCFDF3_6       */
    __type210 CFDCFDF4_6;                                  /* CFDCFDF4_6       */
    __type210 CFDCFDF5_6;                                  /* CFDCFDF5_6       */
    __type210 CFDCFDF6_6;                                  /* CFDCFDF6_6       */
    __type210 CFDCFDF7_6;                                  /* CFDCFDF7_6       */
    __type210 CFDCFDF8_6;                                  /* CFDCFDF8_6       */
    __type210 CFDCFDF9_6;                                  /* CFDCFDF9_6       */
    __type210 CFDCFDF10_6;                                 /* CFDCFDF10_6      */
    __type210 CFDCFDF11_6;                                 /* CFDCFDF11_6      */
    __type210 CFDCFDF12_6;                                 /* CFDCFDF12_6      */
    __type210 CFDCFDF13_6;                                 /* CFDCFDF13_6      */
    __type210 CFDCFDF14_6;                                 /* CFDCFDF14_6      */
    __type210 CFDCFDF15_6;                                 /* CFDCFDF15_6      */
    uint8  dummy349[52];                                   /* Reserved         */
    __type210 CFDCFID7;                                    /* CFDCFID7         */
    __type210 CFDCFPTR7;                                   /* CFDCFPTR7        */
    __type210 CFDCFFDCSTS7;                                /* CFDCFFDCSTS7     */
    __type210 CFDCFDF0_7;                                  /* CFDCFDF0_7       */
    __type210 CFDCFDF1_7;                                  /* CFDCFDF1_7       */
    __type210 CFDCFDF2_7;                                  /* CFDCFDF2_7       */
    __type210 CFDCFDF3_7;                                  /* CFDCFDF3_7       */
    __type210 CFDCFDF4_7;                                  /* CFDCFDF4_7       */
    __type210 CFDCFDF5_7;                                  /* CFDCFDF5_7       */
    __type210 CFDCFDF6_7;                                  /* CFDCFDF6_7       */
    __type210 CFDCFDF7_7;                                  /* CFDCFDF7_7       */
    __type210 CFDCFDF8_7;                                  /* CFDCFDF8_7       */
    __type210 CFDCFDF9_7;                                  /* CFDCFDF9_7       */
    __type210 CFDCFDF10_7;                                 /* CFDCFDF10_7      */
    __type210 CFDCFDF11_7;                                 /* CFDCFDF11_7      */
    __type210 CFDCFDF12_7;                                 /* CFDCFDF12_7      */
    __type210 CFDCFDF13_7;                                 /* CFDCFDF13_7      */
    __type210 CFDCFDF14_7;                                 /* CFDCFDF14_7      */
    __type210 CFDCFDF15_7;                                 /* CFDCFDF15_7      */
    uint8  dummy350[52];                                   /* Reserved         */
    __type210 CFDCFID8;                                    /* CFDCFID8         */
    __type210 CFDCFPTR8;                                   /* CFDCFPTR8        */
    __type210 CFDCFFDCSTS8;                                /* CFDCFFDCSTS8     */
    __type210 CFDCFDF0_8;                                  /* CFDCFDF0_8       */
    __type210 CFDCFDF1_8;                                  /* CFDCFDF1_8       */
    __type210 CFDCFDF2_8;                                  /* CFDCFDF2_8       */
    __type210 CFDCFDF3_8;                                  /* CFDCFDF3_8       */
    __type210 CFDCFDF4_8;                                  /* CFDCFDF4_8       */
    __type210 CFDCFDF5_8;                                  /* CFDCFDF5_8       */
    __type210 CFDCFDF6_8;                                  /* CFDCFDF6_8       */
    __type210 CFDCFDF7_8;                                  /* CFDCFDF7_8       */
    __type210 CFDCFDF8_8;                                  /* CFDCFDF8_8       */
    __type210 CFDCFDF9_8;                                  /* CFDCFDF9_8       */
    __type210 CFDCFDF10_8;                                 /* CFDCFDF10_8      */
    __type210 CFDCFDF11_8;                                 /* CFDCFDF11_8      */
    __type210 CFDCFDF12_8;                                 /* CFDCFDF12_8      */
    __type210 CFDCFDF13_8;                                 /* CFDCFDF13_8      */
    __type210 CFDCFDF14_8;                                 /* CFDCFDF14_8      */
    __type210 CFDCFDF15_8;                                 /* CFDCFDF15_8      */
    uint8  dummy351[52];                                   /* Reserved         */
    __type210 CFDCFID9;                                    /* CFDCFID9         */
    __type210 CFDCFPTR9;                                   /* CFDCFPTR9        */
    __type210 CFDCFFDCSTS9;                                /* CFDCFFDCSTS9     */
    __type210 CFDCFDF0_9;                                  /* CFDCFDF0_9       */
    __type210 CFDCFDF1_9;                                  /* CFDCFDF1_9       */
    __type210 CFDCFDF2_9;                                  /* CFDCFDF2_9       */
    __type210 CFDCFDF3_9;                                  /* CFDCFDF3_9       */
    __type210 CFDCFDF4_9;                                  /* CFDCFDF4_9       */
    __type210 CFDCFDF5_9;                                  /* CFDCFDF5_9       */
    __type210 CFDCFDF6_9;                                  /* CFDCFDF6_9       */
    __type210 CFDCFDF7_9;                                  /* CFDCFDF7_9       */
    __type210 CFDCFDF8_9;                                  /* CFDCFDF8_9       */
    __type210 CFDCFDF9_9;                                  /* CFDCFDF9_9       */
    __type210 CFDCFDF10_9;                                 /* CFDCFDF10_9      */
    __type210 CFDCFDF11_9;                                 /* CFDCFDF11_9      */
    __type210 CFDCFDF12_9;                                 /* CFDCFDF12_9      */
    __type210 CFDCFDF13_9;                                 /* CFDCFDF13_9      */
    __type210 CFDCFDF14_9;                                 /* CFDCFDF14_9      */
    __type210 CFDCFDF15_9;                                 /* CFDCFDF15_9      */
    uint8  dummy352[52];                                   /* Reserved         */
    __type210 CFDCFID10;                                   /* CFDCFID10        */
    __type210 CFDCFPTR10;                                  /* CFDCFPTR10       */
    __type210 CFDCFFDCSTS10;                               /* CFDCFFDCSTS10    */
    __type210 CFDCFDF0_10;                                 /* CFDCFDF0_10      */
    __type210 CFDCFDF1_10;                                 /* CFDCFDF1_10      */
    __type210 CFDCFDF2_10;                                 /* CFDCFDF2_10      */
    __type210 CFDCFDF3_10;                                 /* CFDCFDF3_10      */
    __type210 CFDCFDF4_10;                                 /* CFDCFDF4_10      */
    __type210 CFDCFDF5_10;                                 /* CFDCFDF5_10      */
    __type210 CFDCFDF6_10;                                 /* CFDCFDF6_10      */
    __type210 CFDCFDF7_10;                                 /* CFDCFDF7_10      */
    __type210 CFDCFDF8_10;                                 /* CFDCFDF8_10      */
    __type210 CFDCFDF9_10;                                 /* CFDCFDF9_10      */
    __type210 CFDCFDF10_10;                                /* CFDCFDF10_10     */
    __type210 CFDCFDF11_10;                                /* CFDCFDF11_10     */
    __type210 CFDCFDF12_10;                                /* CFDCFDF12_10     */
    __type210 CFDCFDF13_10;                                /* CFDCFDF13_10     */
    __type210 CFDCFDF14_10;                                /* CFDCFDF14_10     */
    __type210 CFDCFDF15_10;                                /* CFDCFDF15_10     */
    uint8  dummy353[52];                                   /* Reserved         */
    __type210 CFDCFID11;                                   /* CFDCFID11        */
    __type210 CFDCFPTR11;                                  /* CFDCFPTR11       */
    __type210 CFDCFFDCSTS11;                               /* CFDCFFDCSTS11    */
    __type210 CFDCFDF0_11;                                 /* CFDCFDF0_11      */
    __type210 CFDCFDF1_11;                                 /* CFDCFDF1_11      */
    __type210 CFDCFDF2_11;                                 /* CFDCFDF2_11      */
    __type210 CFDCFDF3_11;                                 /* CFDCFDF3_11      */
    __type210 CFDCFDF4_11;                                 /* CFDCFDF4_11      */
    __type210 CFDCFDF5_11;                                 /* CFDCFDF5_11      */
    __type210 CFDCFDF6_11;                                 /* CFDCFDF6_11      */
    __type210 CFDCFDF7_11;                                 /* CFDCFDF7_11      */
    __type210 CFDCFDF8_11;                                 /* CFDCFDF8_11      */
    __type210 CFDCFDF9_11;                                 /* CFDCFDF9_11      */
    __type210 CFDCFDF10_11;                                /* CFDCFDF10_11     */
    __type210 CFDCFDF11_11;                                /* CFDCFDF11_11     */
    __type210 CFDCFDF12_11;                                /* CFDCFDF12_11     */
    __type210 CFDCFDF13_11;                                /* CFDCFDF13_11     */
    __type210 CFDCFDF14_11;                                /* CFDCFDF14_11     */
    __type210 CFDCFDF15_11;                                /* CFDCFDF15_11     */
    uint8  dummy354[52];                                   /* Reserved         */
    __type210 CFDCFID12;                                   /* CFDCFID12        */
    __type210 CFDCFPTR12;                                  /* CFDCFPTR12       */
    __type210 CFDCFFDCSTS12;                               /* CFDCFFDCSTS12    */
    __type210 CFDCFDF0_12;                                 /* CFDCFDF0_12      */
    __type210 CFDCFDF1_12;                                 /* CFDCFDF1_12      */
    __type210 CFDCFDF2_12;                                 /* CFDCFDF2_12      */
    __type210 CFDCFDF3_12;                                 /* CFDCFDF3_12      */
    __type210 CFDCFDF4_12;                                 /* CFDCFDF4_12      */
    __type210 CFDCFDF5_12;                                 /* CFDCFDF5_12      */
    __type210 CFDCFDF6_12;                                 /* CFDCFDF6_12      */
    __type210 CFDCFDF7_12;                                 /* CFDCFDF7_12      */
    __type210 CFDCFDF8_12;                                 /* CFDCFDF8_12      */
    __type210 CFDCFDF9_12;                                 /* CFDCFDF9_12      */
    __type210 CFDCFDF10_12;                                /* CFDCFDF10_12     */
    __type210 CFDCFDF11_12;                                /* CFDCFDF11_12     */
    __type210 CFDCFDF12_12;                                /* CFDCFDF12_12     */
    __type210 CFDCFDF13_12;                                /* CFDCFDF13_12     */
    __type210 CFDCFDF14_12;                                /* CFDCFDF14_12     */
    __type210 CFDCFDF15_12;                                /* CFDCFDF15_12     */
    uint8  dummy355[52];                                   /* Reserved         */
    __type210 CFDCFID13;                                   /* CFDCFID13        */
    __type210 CFDCFPTR13;                                  /* CFDCFPTR13       */
    __type210 CFDCFFDCSTS13;                               /* CFDCFFDCSTS13    */
    __type210 CFDCFDF0_13;                                 /* CFDCFDF0_13      */
    __type210 CFDCFDF1_13;                                 /* CFDCFDF1_13      */
    __type210 CFDCFDF2_13;                                 /* CFDCFDF2_13      */
    __type210 CFDCFDF3_13;                                 /* CFDCFDF3_13      */
    __type210 CFDCFDF4_13;                                 /* CFDCFDF4_13      */
    __type210 CFDCFDF5_13;                                 /* CFDCFDF5_13      */
    __type210 CFDCFDF6_13;                                 /* CFDCFDF6_13      */
    __type210 CFDCFDF7_13;                                 /* CFDCFDF7_13      */
    __type210 CFDCFDF8_13;                                 /* CFDCFDF8_13      */
    __type210 CFDCFDF9_13;                                 /* CFDCFDF9_13      */
    __type210 CFDCFDF10_13;                                /* CFDCFDF10_13     */
    __type210 CFDCFDF11_13;                                /* CFDCFDF11_13     */
    __type210 CFDCFDF12_13;                                /* CFDCFDF12_13     */
    __type210 CFDCFDF13_13;                                /* CFDCFDF13_13     */
    __type210 CFDCFDF14_13;                                /* CFDCFDF14_13     */
    __type210 CFDCFDF15_13;                                /* CFDCFDF15_13     */
    uint8  dummy356[52];                                   /* Reserved         */
    __type210 CFDCFID14;                                   /* CFDCFID14        */
    __type210 CFDCFPTR14;                                  /* CFDCFPTR14       */
    __type210 CFDCFFDCSTS14;                               /* CFDCFFDCSTS14    */
    __type210 CFDCFDF0_14;                                 /* CFDCFDF0_14      */
    __type210 CFDCFDF1_14;                                 /* CFDCFDF1_14      */
    __type210 CFDCFDF2_14;                                 /* CFDCFDF2_14      */
    __type210 CFDCFDF3_14;                                 /* CFDCFDF3_14      */
    __type210 CFDCFDF4_14;                                 /* CFDCFDF4_14      */
    __type210 CFDCFDF5_14;                                 /* CFDCFDF5_14      */
    __type210 CFDCFDF6_14;                                 /* CFDCFDF6_14      */
    __type210 CFDCFDF7_14;                                 /* CFDCFDF7_14      */
    __type210 CFDCFDF8_14;                                 /* CFDCFDF8_14      */
    __type210 CFDCFDF9_14;                                 /* CFDCFDF9_14      */
    __type210 CFDCFDF10_14;                                /* CFDCFDF10_14     */
    __type210 CFDCFDF11_14;                                /* CFDCFDF11_14     */
    __type210 CFDCFDF12_14;                                /* CFDCFDF12_14     */
    __type210 CFDCFDF13_14;                                /* CFDCFDF13_14     */
    __type210 CFDCFDF14_14;                                /* CFDCFDF14_14     */
    __type210 CFDCFDF15_14;                                /* CFDCFDF15_14     */
    uint8  dummy357[52];                                   /* Reserved         */
    __type210 CFDCFID15;                                   /* CFDCFID15        */
    __type210 CFDCFPTR15;                                  /* CFDCFPTR15       */
    __type210 CFDCFFDCSTS15;                               /* CFDCFFDCSTS15    */
    __type210 CFDCFDF0_15;                                 /* CFDCFDF0_15      */
    __type210 CFDCFDF1_15;                                 /* CFDCFDF1_15      */
    __type210 CFDCFDF2_15;                                 /* CFDCFDF2_15      */
    __type210 CFDCFDF3_15;                                 /* CFDCFDF3_15      */
    __type210 CFDCFDF4_15;                                 /* CFDCFDF4_15      */
    __type210 CFDCFDF5_15;                                 /* CFDCFDF5_15      */
    __type210 CFDCFDF6_15;                                 /* CFDCFDF6_15      */
    __type210 CFDCFDF7_15;                                 /* CFDCFDF7_15      */
    __type210 CFDCFDF8_15;                                 /* CFDCFDF8_15      */
    __type210 CFDCFDF9_15;                                 /* CFDCFDF9_15      */
    __type210 CFDCFDF10_15;                                /* CFDCFDF10_15     */
    __type210 CFDCFDF11_15;                                /* CFDCFDF11_15     */
    __type210 CFDCFDF12_15;                                /* CFDCFDF12_15     */
    __type210 CFDCFDF13_15;                                /* CFDCFDF13_15     */
    __type210 CFDCFDF14_15;                                /* CFDCFDF14_15     */
    __type210 CFDCFDF15_15;                                /* CFDCFDF15_15     */
    uint8  dummy358[52];                                   /* Reserved         */
    __type210 CFDCFID16;                                   /* CFDCFID16        */
    __type210 CFDCFPTR16;                                  /* CFDCFPTR16       */
    __type210 CFDCFFDCSTS16;                               /* CFDCFFDCSTS16    */
    __type210 CFDCFDF0_16;                                 /* CFDCFDF0_16      */
    __type210 CFDCFDF1_16;                                 /* CFDCFDF1_16      */
    __type210 CFDCFDF2_16;                                 /* CFDCFDF2_16      */
    __type210 CFDCFDF3_16;                                 /* CFDCFDF3_16      */
    __type210 CFDCFDF4_16;                                 /* CFDCFDF4_16      */
    __type210 CFDCFDF5_16;                                 /* CFDCFDF5_16      */
    __type210 CFDCFDF6_16;                                 /* CFDCFDF6_16      */
    __type210 CFDCFDF7_16;                                 /* CFDCFDF7_16      */
    __type210 CFDCFDF8_16;                                 /* CFDCFDF8_16      */
    __type210 CFDCFDF9_16;                                 /* CFDCFDF9_16      */
    __type210 CFDCFDF10_16;                                /* CFDCFDF10_16     */
    __type210 CFDCFDF11_16;                                /* CFDCFDF11_16     */
    __type210 CFDCFDF12_16;                                /* CFDCFDF12_16     */
    __type210 CFDCFDF13_16;                                /* CFDCFDF13_16     */
    __type210 CFDCFDF14_16;                                /* CFDCFDF14_16     */
    __type210 CFDCFDF15_16;                                /* CFDCFDF15_16     */
    uint8  dummy359[52];                                   /* Reserved         */
    __type210 CFDCFID17;                                   /* CFDCFID17        */
    __type210 CFDCFPTR17;                                  /* CFDCFPTR17       */
    __type210 CFDCFFDCSTS17;                               /* CFDCFFDCSTS17    */
    __type210 CFDCFDF0_17;                                 /* CFDCFDF0_17      */
    __type210 CFDCFDF1_17;                                 /* CFDCFDF1_17      */
    __type210 CFDCFDF2_17;                                 /* CFDCFDF2_17      */
    __type210 CFDCFDF3_17;                                 /* CFDCFDF3_17      */
    __type210 CFDCFDF4_17;                                 /* CFDCFDF4_17      */
    __type210 CFDCFDF5_17;                                 /* CFDCFDF5_17      */
    __type210 CFDCFDF6_17;                                 /* CFDCFDF6_17      */
    __type210 CFDCFDF7_17;                                 /* CFDCFDF7_17      */
    __type210 CFDCFDF8_17;                                 /* CFDCFDF8_17      */
    __type210 CFDCFDF9_17;                                 /* CFDCFDF9_17      */
    __type210 CFDCFDF10_17;                                /* CFDCFDF10_17     */
    __type210 CFDCFDF11_17;                                /* CFDCFDF11_17     */
    __type210 CFDCFDF12_17;                                /* CFDCFDF12_17     */
    __type210 CFDCFDF13_17;                                /* CFDCFDF13_17     */
    __type210 CFDCFDF14_17;                                /* CFDCFDF14_17     */
    __type210 CFDCFDF15_17;                                /* CFDCFDF15_17     */
    uint8  dummy360[52];                                   /* Reserved         */
    __type210 CFDCFID18;                                   /* CFDCFID18        */
    __type210 CFDCFPTR18;                                  /* CFDCFPTR18       */
    __type210 CFDCFFDCSTS18;                               /* CFDCFFDCSTS18    */
    uint8  dummy361[116];                                  /* Reserved         */
    __type210 CFDCFID19;                                   /* CFDCFID19        */
    __type210 CFDCFPTR19;                                  /* CFDCFPTR19       */
    __type210 CFDCFFDCSTS19;                               /* CFDCFFDCSTS19    */
    uint8  dummy362[116];                                  /* Reserved         */
    __type210 CFDCFID20;                                   /* CFDCFID20        */
    __type210 CFDCFPTR20;                                  /* CFDCFPTR20       */
    __type210 CFDCFFDCSTS20;                               /* CFDCFFDCSTS20    */
    uint8  dummy363[116];                                  /* Reserved         */
    __type210 CFDCFID21;                                   /* CFDCFID21        */
    __type210 CFDCFPTR21;                                  /* CFDCFPTR21       */
    __type210 CFDCFFDCSTS21;                               /* CFDCFFDCSTS21    */
    uint8  dummy364[116];                                  /* Reserved         */
    __type210 CFDCFID22;                                   /* CFDCFID22        */
    __type210 CFDCFPTR22;                                  /* CFDCFPTR22       */
    __type210 CFDCFFDCSTS22;                               /* CFDCFFDCSTS22    */
    uint8  dummy365[116];                                  /* Reserved         */
    __type210 CFDCFID23;                                   /* CFDCFID23        */
    __type210 CFDCFPTR23;                                  /* CFDCFPTR23       */
    __type210 CFDCFFDCSTS23;                               /* CFDCFFDCSTS23    */
    uint8  dummy366[4212];                                 /* Reserved         */
    __type210 CFDTMID0;                                    /* CFDTMID0         */
    __type210 CFDTMPTR0;                                   /* CFDTMPTR0        */
    __type210 CFDTMFDCTR0;                                 /* CFDTMFDCTR0      */
    __type210 CFDTMDF0_0;                                  /* CFDTMDF0_0       */
    __type210 CFDTMDF1_0;                                  /* CFDTMDF1_0       */
    __type210 CFDTMDF2_0;                                  /* CFDTMDF2_0       */
    __type210 CFDTMDF3_0;                                  /* CFDTMDF3_0       */
    __type210 CFDTMDF4_0;                                  /* CFDTMDF4_0       */
    __type210 CFDTMDF5_0;                                  /* CFDTMDF5_0       */
    __type210 CFDTMDF6_0;                                  /* CFDTMDF6_0       */
    __type210 CFDTMDF7_0;                                  /* CFDTMDF7_0       */
    __type210 CFDTMDF8_0;                                  /* CFDTMDF8_0       */
    __type210 CFDTMDF9_0;                                  /* CFDTMDF9_0       */
    __type210 CFDTMDF10_0;                                 /* CFDTMDF10_0      */
    __type210 CFDTMDF11_0;                                 /* CFDTMDF11_0      */
    __type210 CFDTMDF12_0;                                 /* CFDTMDF12_0      */
    __type210 CFDTMDF13_0;                                 /* CFDTMDF13_0      */
    __type210 CFDTMDF14_0;                                 /* CFDTMDF14_0      */
    __type210 CFDTMDF15_0;                                 /* CFDTMDF15_0      */
    uint8  dummy367[52];                                   /* Reserved         */
    __type210 CFDTMID1;                                    /* CFDTMID1         */
    __type210 CFDTMPTR1;                                   /* CFDTMPTR1        */
    __type210 CFDTMFDCTR1;                                 /* CFDTMFDCTR1      */
    __type210 CFDTMDF0_1;                                  /* CFDTMDF0_1       */
    __type210 CFDTMDF1_1;                                  /* CFDTMDF1_1       */
    __type210 CFDTMDF2_1;                                  /* CFDTMDF2_1       */
    __type210 CFDTMDF3_1;                                  /* CFDTMDF3_1       */
    __type210 CFDTMDF4_1;                                  /* CFDTMDF4_1       */
    __type210 CFDTMDF5_1;                                  /* CFDTMDF5_1       */
    __type210 CFDTMDF6_1;                                  /* CFDTMDF6_1       */
    __type210 CFDTMDF7_1;                                  /* CFDTMDF7_1       */
    __type210 CFDTMDF8_1;                                  /* CFDTMDF8_1       */
    __type210 CFDTMDF9_1;                                  /* CFDTMDF9_1       */
    __type210 CFDTMDF10_1;                                 /* CFDTMDF10_1      */
    __type210 CFDTMDF11_1;                                 /* CFDTMDF11_1      */
    __type210 CFDTMDF12_1;                                 /* CFDTMDF12_1      */
    __type210 CFDTMDF13_1;                                 /* CFDTMDF13_1      */
    __type210 CFDTMDF14_1;                                 /* CFDTMDF14_1      */
    __type210 CFDTMDF15_1;                                 /* CFDTMDF15_1      */
    uint8  dummy368[52];                                   /* Reserved         */
    __type210 CFDTMID2;                                    /* CFDTMID2         */
    __type210 CFDTMPTR2;                                   /* CFDTMPTR2        */
    __type210 CFDTMFDCTR2;                                 /* CFDTMFDCTR2      */
    __type210 CFDTMDF0_2;                                  /* CFDTMDF0_2       */
    __type210 CFDTMDF1_2;                                  /* CFDTMDF1_2       */
    __type210 CFDTMDF2_2;                                  /* CFDTMDF2_2       */
    __type210 CFDTMDF3_2;                                  /* CFDTMDF3_2       */
    __type210 CFDTMDF4_2;                                  /* CFDTMDF4_2       */
    __type210 CFDTMDF5_2;                                  /* CFDTMDF5_2       */
    __type210 CFDTMDF6_2;                                  /* CFDTMDF6_2       */
    __type210 CFDTMDF7_2;                                  /* CFDTMDF7_2       */
    __type210 CFDTMDF8_2;                                  /* CFDTMDF8_2       */
    __type210 CFDTMDF9_2;                                  /* CFDTMDF9_2       */
    __type210 CFDTMDF10_2;                                 /* CFDTMDF10_2      */
    __type210 CFDTMDF11_2;                                 /* CFDTMDF11_2      */
    __type210 CFDTMDF12_2;                                 /* CFDTMDF12_2      */
    __type210 CFDTMDF13_2;                                 /* CFDTMDF13_2      */
    __type210 CFDTMDF14_2;                                 /* CFDTMDF14_2      */
    __type210 CFDTMDF15_2;                                 /* CFDTMDF15_2      */
    uint8  dummy369[52];                                   /* Reserved         */
    __type210 CFDTMID3;                                    /* CFDTMID3         */
    __type210 CFDTMPTR3;                                   /* CFDTMPTR3        */
    __type210 CFDTMFDCTR3;                                 /* CFDTMFDCTR3      */
    __type210 CFDTMDF0_3;                                  /* CFDTMDF0_3       */
    __type210 CFDTMDF1_3;                                  /* CFDTMDF1_3       */
    __type210 CFDTMDF2_3;                                  /* CFDTMDF2_3       */
    __type210 CFDTMDF3_3;                                  /* CFDTMDF3_3       */
    __type210 CFDTMDF4_3;                                  /* CFDTMDF4_3       */
    __type210 CFDTMDF5_3;                                  /* CFDTMDF5_3       */
    __type210 CFDTMDF6_3;                                  /* CFDTMDF6_3       */
    __type210 CFDTMDF7_3;                                  /* CFDTMDF7_3       */
    __type210 CFDTMDF8_3;                                  /* CFDTMDF8_3       */
    __type210 CFDTMDF9_3;                                  /* CFDTMDF9_3       */
    __type210 CFDTMDF10_3;                                 /* CFDTMDF10_3      */
    __type210 CFDTMDF11_3;                                 /* CFDTMDF11_3      */
    __type210 CFDTMDF12_3;                                 /* CFDTMDF12_3      */
    __type210 CFDTMDF13_3;                                 /* CFDTMDF13_3      */
    __type210 CFDTMDF14_3;                                 /* CFDTMDF14_3      */
    __type210 CFDTMDF15_3;                                 /* CFDTMDF15_3      */
    uint8  dummy370[52];                                   /* Reserved         */
    __type210 CFDTMID4;                                    /* CFDTMID4         */
    __type210 CFDTMPTR4;                                   /* CFDTMPTR4        */
    __type210 CFDTMFDCTR4;                                 /* CFDTMFDCTR4      */
    __type210 CFDTMDF0_4;                                  /* CFDTMDF0_4       */
    __type210 CFDTMDF1_4;                                  /* CFDTMDF1_4       */
    __type210 CFDTMDF2_4;                                  /* CFDTMDF2_4       */
    __type210 CFDTMDF3_4;                                  /* CFDTMDF3_4       */
    __type210 CFDTMDF4_4;                                  /* CFDTMDF4_4       */
    __type210 CFDTMDF5_4;                                  /* CFDTMDF5_4       */
    __type210 CFDTMDF6_4;                                  /* CFDTMDF6_4       */
    __type210 CFDTMDF7_4;                                  /* CFDTMDF7_4       */
    __type210 CFDTMDF8_4;                                  /* CFDTMDF8_4       */
    __type210 CFDTMDF9_4;                                  /* CFDTMDF9_4       */
    __type210 CFDTMDF10_4;                                 /* CFDTMDF10_4      */
    __type210 CFDTMDF11_4;                                 /* CFDTMDF11_4      */
    __type210 CFDTMDF12_4;                                 /* CFDTMDF12_4      */
    __type210 CFDTMDF13_4;                                 /* CFDTMDF13_4      */
    __type210 CFDTMDF14_4;                                 /* CFDTMDF14_4      */
    __type210 CFDTMDF15_4;                                 /* CFDTMDF15_4      */
    uint8  dummy371[52];                                   /* Reserved         */
    __type210 CFDTMID5;                                    /* CFDTMID5         */
    __type210 CFDTMPTR5;                                   /* CFDTMPTR5        */
    __type210 CFDTMFDCTR5;                                 /* CFDTMFDCTR5      */
    __type210 CFDTMDF0_5;                                  /* CFDTMDF0_5       */
    __type210 CFDTMDF1_5;                                  /* CFDTMDF1_5       */
    __type210 CFDTMDF2_5;                                  /* CFDTMDF2_5       */
    __type210 CFDTMDF3_5;                                  /* CFDTMDF3_5       */
    __type210 CFDTMDF4_5;                                  /* CFDTMDF4_5       */
    __type210 CFDTMDF5_5;                                  /* CFDTMDF5_5       */
    __type210 CFDTMDF6_5;                                  /* CFDTMDF6_5       */
    __type210 CFDTMDF7_5;                                  /* CFDTMDF7_5       */
    __type210 CFDTMDF8_5;                                  /* CFDTMDF8_5       */
    __type210 CFDTMDF9_5;                                  /* CFDTMDF9_5       */
    __type210 CFDTMDF10_5;                                 /* CFDTMDF10_5      */
    __type210 CFDTMDF11_5;                                 /* CFDTMDF11_5      */
    __type210 CFDTMDF12_5;                                 /* CFDTMDF12_5      */
    __type210 CFDTMDF13_5;                                 /* CFDTMDF13_5      */
    __type210 CFDTMDF14_5;                                 /* CFDTMDF14_5      */
    __type210 CFDTMDF15_5;                                 /* CFDTMDF15_5      */
    uint8  dummy372[52];                                   /* Reserved         */
    __type210 CFDTMID6;                                    /* CFDTMID6         */
    __type210 CFDTMPTR6;                                   /* CFDTMPTR6        */
    __type210 CFDTMFDCTR6;                                 /* CFDTMFDCTR6      */
    __type210 CFDTMDF0_6;                                  /* CFDTMDF0_6       */
    __type210 CFDTMDF1_6;                                  /* CFDTMDF1_6       */
    __type210 CFDTMDF2_6;                                  /* CFDTMDF2_6       */
    __type210 CFDTMDF3_6;                                  /* CFDTMDF3_6       */
    __type210 CFDTMDF4_6;                                  /* CFDTMDF4_6       */
    __type210 CFDTMDF5_6;                                  /* CFDTMDF5_6       */
    __type210 CFDTMDF6_6;                                  /* CFDTMDF6_6       */
    __type210 CFDTMDF7_6;                                  /* CFDTMDF7_6       */
    __type210 CFDTMDF8_6;                                  /* CFDTMDF8_6       */
    __type210 CFDTMDF9_6;                                  /* CFDTMDF9_6       */
    __type210 CFDTMDF10_6;                                 /* CFDTMDF10_6      */
    __type210 CFDTMDF11_6;                                 /* CFDTMDF11_6      */
    __type210 CFDTMDF12_6;                                 /* CFDTMDF12_6      */
    __type210 CFDTMDF13_6;                                 /* CFDTMDF13_6      */
    __type210 CFDTMDF14_6;                                 /* CFDTMDF14_6      */
    __type210 CFDTMDF15_6;                                 /* CFDTMDF15_6      */
    uint8  dummy373[52];                                   /* Reserved         */
    __type210 CFDTMID7;                                    /* CFDTMID7         */
    __type210 CFDTMPTR7;                                   /* CFDTMPTR7        */
    __type210 CFDTMFDCTR7;                                 /* CFDTMFDCTR7      */
    __type210 CFDTMDF0_7;                                  /* CFDTMDF0_7       */
    __type210 CFDTMDF1_7;                                  /* CFDTMDF1_7       */
    __type210 CFDTMDF2_7;                                  /* CFDTMDF2_7       */
    __type210 CFDTMDF3_7;                                  /* CFDTMDF3_7       */
    __type210 CFDTMDF4_7;                                  /* CFDTMDF4_7       */
    __type210 CFDTMDF5_7;                                  /* CFDTMDF5_7       */
    __type210 CFDTMDF6_7;                                  /* CFDTMDF6_7       */
    __type210 CFDTMDF7_7;                                  /* CFDTMDF7_7       */
    __type210 CFDTMDF8_7;                                  /* CFDTMDF8_7       */
    __type210 CFDTMDF9_7;                                  /* CFDTMDF9_7       */
    __type210 CFDTMDF10_7;                                 /* CFDTMDF10_7      */
    __type210 CFDTMDF11_7;                                 /* CFDTMDF11_7      */
    __type210 CFDTMDF12_7;                                 /* CFDTMDF12_7      */
    __type210 CFDTMDF13_7;                                 /* CFDTMDF13_7      */
    __type210 CFDTMDF14_7;                                 /* CFDTMDF14_7      */
    __type210 CFDTMDF15_7;                                 /* CFDTMDF15_7      */
    uint8  dummy374[52];                                   /* Reserved         */
    __type210 CFDTMID8;                                    /* CFDTMID8         */
    __type210 CFDTMPTR8;                                   /* CFDTMPTR8        */
    __type210 CFDTMFDCTR8;                                 /* CFDTMFDCTR8      */
    __type210 CFDTMDF0_8;                                  /* CFDTMDF0_8       */
    __type210 CFDTMDF1_8;                                  /* CFDTMDF1_8       */
    __type210 CFDTMDF2_8;                                  /* CFDTMDF2_8       */
    __type210 CFDTMDF3_8;                                  /* CFDTMDF3_8       */
    __type210 CFDTMDF4_8;                                  /* CFDTMDF4_8       */
    __type210 CFDTMDF5_8;                                  /* CFDTMDF5_8       */
    __type210 CFDTMDF6_8;                                  /* CFDTMDF6_8       */
    __type210 CFDTMDF7_8;                                  /* CFDTMDF7_8       */
    __type210 CFDTMDF8_8;                                  /* CFDTMDF8_8       */
    __type210 CFDTMDF9_8;                                  /* CFDTMDF9_8       */
    __type210 CFDTMDF10_8;                                 /* CFDTMDF10_8      */
    __type210 CFDTMDF11_8;                                 /* CFDTMDF11_8      */
    __type210 CFDTMDF12_8;                                 /* CFDTMDF12_8      */
    __type210 CFDTMDF13_8;                                 /* CFDTMDF13_8      */
    __type210 CFDTMDF14_8;                                 /* CFDTMDF14_8      */
    __type210 CFDTMDF15_8;                                 /* CFDTMDF15_8      */
    uint8  dummy375[52];                                   /* Reserved         */
    __type210 CFDTMID9;                                    /* CFDTMID9         */
    __type210 CFDTMPTR9;                                   /* CFDTMPTR9        */
    __type210 CFDTMFDCTR9;                                 /* CFDTMFDCTR9      */
    __type210 CFDTMDF0_9;                                  /* CFDTMDF0_9       */
    __type210 CFDTMDF1_9;                                  /* CFDTMDF1_9       */
    __type210 CFDTMDF2_9;                                  /* CFDTMDF2_9       */
    __type210 CFDTMDF3_9;                                  /* CFDTMDF3_9       */
    __type210 CFDTMDF4_9;                                  /* CFDTMDF4_9       */
    __type210 CFDTMDF5_9;                                  /* CFDTMDF5_9       */
    __type210 CFDTMDF6_9;                                  /* CFDTMDF6_9       */
    __type210 CFDTMDF7_9;                                  /* CFDTMDF7_9       */
    __type210 CFDTMDF8_9;                                  /* CFDTMDF8_9       */
    __type210 CFDTMDF9_9;                                  /* CFDTMDF9_9       */
    __type210 CFDTMDF10_9;                                 /* CFDTMDF10_9      */
    __type210 CFDTMDF11_9;                                 /* CFDTMDF11_9      */
    __type210 CFDTMDF12_9;                                 /* CFDTMDF12_9      */
    __type210 CFDTMDF13_9;                                 /* CFDTMDF13_9      */
    __type210 CFDTMDF14_9;                                 /* CFDTMDF14_9      */
    __type210 CFDTMDF15_9;                                 /* CFDTMDF15_9      */
    uint8  dummy376[52];                                   /* Reserved         */
    __type210 CFDTMID10;                                   /* CFDTMID10        */
    __type210 CFDTMPTR10;                                  /* CFDTMPTR10       */
    __type210 CFDTMFDCTR10;                                /* CFDTMFDCTR10     */
    __type210 CFDTMDF0_10;                                 /* CFDTMDF0_10      */
    __type210 CFDTMDF1_10;                                 /* CFDTMDF1_10      */
    __type210 CFDTMDF2_10;                                 /* CFDTMDF2_10      */
    __type210 CFDTMDF3_10;                                 /* CFDTMDF3_10      */
    __type210 CFDTMDF4_10;                                 /* CFDTMDF4_10      */
    __type210 CFDTMDF5_10;                                 /* CFDTMDF5_10      */
    __type210 CFDTMDF6_10;                                 /* CFDTMDF6_10      */
    __type210 CFDTMDF7_10;                                 /* CFDTMDF7_10      */
    __type210 CFDTMDF8_10;                                 /* CFDTMDF8_10      */
    __type210 CFDTMDF9_10;                                 /* CFDTMDF9_10      */
    __type210 CFDTMDF10_10;                                /* CFDTMDF10_10     */
    __type210 CFDTMDF11_10;                                /* CFDTMDF11_10     */
    __type210 CFDTMDF12_10;                                /* CFDTMDF12_10     */
    __type210 CFDTMDF13_10;                                /* CFDTMDF13_10     */
    __type210 CFDTMDF14_10;                                /* CFDTMDF14_10     */
    __type210 CFDTMDF15_10;                                /* CFDTMDF15_10     */
    uint8  dummy377[52];                                   /* Reserved         */
    __type210 CFDTMID11;                                   /* CFDTMID11        */
    __type210 CFDTMPTR11;                                  /* CFDTMPTR11       */
    __type210 CFDTMFDCTR11;                                /* CFDTMFDCTR11     */
    __type210 CFDTMDF0_11;                                 /* CFDTMDF0_11      */
    __type210 CFDTMDF1_11;                                 /* CFDTMDF1_11      */
    __type210 CFDTMDF2_11;                                 /* CFDTMDF2_11      */
    __type210 CFDTMDF3_11;                                 /* CFDTMDF3_11      */
    __type210 CFDTMDF4_11;                                 /* CFDTMDF4_11      */
    __type210 CFDTMDF5_11;                                 /* CFDTMDF5_11      */
    __type210 CFDTMDF6_11;                                 /* CFDTMDF6_11      */
    __type210 CFDTMDF7_11;                                 /* CFDTMDF7_11      */
    __type210 CFDTMDF8_11;                                 /* CFDTMDF8_11      */
    __type210 CFDTMDF9_11;                                 /* CFDTMDF9_11      */
    __type210 CFDTMDF10_11;                                /* CFDTMDF10_11     */
    __type210 CFDTMDF11_11;                                /* CFDTMDF11_11     */
    __type210 CFDTMDF12_11;                                /* CFDTMDF12_11     */
    __type210 CFDTMDF13_11;                                /* CFDTMDF13_11     */
    __type210 CFDTMDF14_11;                                /* CFDTMDF14_11     */
    __type210 CFDTMDF15_11;                                /* CFDTMDF15_11     */
    uint8  dummy378[52];                                   /* Reserved         */
    __type210 CFDTMID12;                                   /* CFDTMID12        */
    __type210 CFDTMPTR12;                                  /* CFDTMPTR12       */
    __type210 CFDTMFDCTR12;                                /* CFDTMFDCTR12     */
    __type210 CFDTMDF0_12;                                 /* CFDTMDF0_12      */
    __type210 CFDTMDF1_12;                                 /* CFDTMDF1_12      */
    __type210 CFDTMDF2_12;                                 /* CFDTMDF2_12      */
    __type210 CFDTMDF3_12;                                 /* CFDTMDF3_12      */
    __type210 CFDTMDF4_12;                                 /* CFDTMDF4_12      */
    __type210 CFDTMDF5_12;                                 /* CFDTMDF5_12      */
    __type210 CFDTMDF6_12;                                 /* CFDTMDF6_12      */
    __type210 CFDTMDF7_12;                                 /* CFDTMDF7_12      */
    __type210 CFDTMDF8_12;                                 /* CFDTMDF8_12      */
    __type210 CFDTMDF9_12;                                 /* CFDTMDF9_12      */
    __type210 CFDTMDF10_12;                                /* CFDTMDF10_12     */
    __type210 CFDTMDF11_12;                                /* CFDTMDF11_12     */
    __type210 CFDTMDF12_12;                                /* CFDTMDF12_12     */
    __type210 CFDTMDF13_12;                                /* CFDTMDF13_12     */
    __type210 CFDTMDF14_12;                                /* CFDTMDF14_12     */
    __type210 CFDTMDF15_12;                                /* CFDTMDF15_12     */
    uint8  dummy379[52];                                   /* Reserved         */
    __type210 CFDTMID13;                                   /* CFDTMID13        */
    __type210 CFDTMPTR13;                                  /* CFDTMPTR13       */
    __type210 CFDTMFDCTR13;                                /* CFDTMFDCTR13     */
    __type210 CFDTMDF0_13;                                 /* CFDTMDF0_13      */
    __type210 CFDTMDF1_13;                                 /* CFDTMDF1_13      */
    __type210 CFDTMDF2_13;                                 /* CFDTMDF2_13      */
    __type210 CFDTMDF3_13;                                 /* CFDTMDF3_13      */
    __type210 CFDTMDF4_13;                                 /* CFDTMDF4_13      */
    __type210 CFDTMDF5_13;                                 /* CFDTMDF5_13      */
    __type210 CFDTMDF6_13;                                 /* CFDTMDF6_13      */
    __type210 CFDTMDF7_13;                                 /* CFDTMDF7_13      */
    __type210 CFDTMDF8_13;                                 /* CFDTMDF8_13      */
    __type210 CFDTMDF9_13;                                 /* CFDTMDF9_13      */
    __type210 CFDTMDF10_13;                                /* CFDTMDF10_13     */
    __type210 CFDTMDF11_13;                                /* CFDTMDF11_13     */
    __type210 CFDTMDF12_13;                                /* CFDTMDF12_13     */
    __type210 CFDTMDF13_13;                                /* CFDTMDF13_13     */
    __type210 CFDTMDF14_13;                                /* CFDTMDF14_13     */
    __type210 CFDTMDF15_13;                                /* CFDTMDF15_13     */
    uint8  dummy380[52];                                   /* Reserved         */
    __type210 CFDTMID14;                                   /* CFDTMID14        */
    __type210 CFDTMPTR14;                                  /* CFDTMPTR14       */
    __type210 CFDTMFDCTR14;                                /* CFDTMFDCTR14     */
    __type210 CFDTMDF0_14;                                 /* CFDTMDF0_14      */
    __type210 CFDTMDF1_14;                                 /* CFDTMDF1_14      */
    __type210 CFDTMDF2_14;                                 /* CFDTMDF2_14      */
    __type210 CFDTMDF3_14;                                 /* CFDTMDF3_14      */
    __type210 CFDTMDF4_14;                                 /* CFDTMDF4_14      */
    __type210 CFDTMDF5_14;                                 /* CFDTMDF5_14      */
    __type210 CFDTMDF6_14;                                 /* CFDTMDF6_14      */
    __type210 CFDTMDF7_14;                                 /* CFDTMDF7_14      */
    __type210 CFDTMDF8_14;                                 /* CFDTMDF8_14      */
    __type210 CFDTMDF9_14;                                 /* CFDTMDF9_14      */
    __type210 CFDTMDF10_14;                                /* CFDTMDF10_14     */
    __type210 CFDTMDF11_14;                                /* CFDTMDF11_14     */
    __type210 CFDTMDF12_14;                                /* CFDTMDF12_14     */
    __type210 CFDTMDF13_14;                                /* CFDTMDF13_14     */
    __type210 CFDTMDF14_14;                                /* CFDTMDF14_14     */
    __type210 CFDTMDF15_14;                                /* CFDTMDF15_14     */
    uint8  dummy381[52];                                   /* Reserved         */
    __type210 CFDTMID15;                                   /* CFDTMID15        */
    __type210 CFDTMPTR15;                                  /* CFDTMPTR15       */
    __type210 CFDTMFDCTR15;                                /* CFDTMFDCTR15     */
    __type210 CFDTMDF0_15;                                 /* CFDTMDF0_15      */
    __type210 CFDTMDF1_15;                                 /* CFDTMDF1_15      */
    __type210 CFDTMDF2_15;                                 /* CFDTMDF2_15      */
    __type210 CFDTMDF3_15;                                 /* CFDTMDF3_15      */
    __type210 CFDTMDF4_15;                                 /* CFDTMDF4_15      */
    __type210 CFDTMDF5_15;                                 /* CFDTMDF5_15      */
    __type210 CFDTMDF6_15;                                 /* CFDTMDF6_15      */
    __type210 CFDTMDF7_15;                                 /* CFDTMDF7_15      */
    __type210 CFDTMDF8_15;                                 /* CFDTMDF8_15      */
    __type210 CFDTMDF9_15;                                 /* CFDTMDF9_15      */
    __type210 CFDTMDF10_15;                                /* CFDTMDF10_15     */
    __type210 CFDTMDF11_15;                                /* CFDTMDF11_15     */
    __type210 CFDTMDF12_15;                                /* CFDTMDF12_15     */
    __type210 CFDTMDF13_15;                                /* CFDTMDF13_15     */
    __type210 CFDTMDF14_15;                                /* CFDTMDF14_15     */
    __type210 CFDTMDF15_15;                                /* CFDTMDF15_15     */
    uint8  dummy382[52];                                   /* Reserved         */
    __type210 CFDTMID16;                                   /* CFDTMID16        */
    __type210 CFDTMPTR16;                                  /* CFDTMPTR16       */
    __type210 CFDTMFDCTR16;                                /* CFDTMFDCTR16     */
    __type210 CFDTMDF0_16;                                 /* CFDTMDF0_16      */
    __type210 CFDTMDF1_16;                                 /* CFDTMDF1_16      */
    __type210 CFDTMDF2_16;                                 /* CFDTMDF2_16      */
    __type210 CFDTMDF3_16;                                 /* CFDTMDF3_16      */
    __type210 CFDTMDF4_16;                                 /* CFDTMDF4_16      */
    __type210 CFDTMDF5_16;                                 /* CFDTMDF5_16      */
    __type210 CFDTMDF6_16;                                 /* CFDTMDF6_16      */
    __type210 CFDTMDF7_16;                                 /* CFDTMDF7_16      */
    __type210 CFDTMDF8_16;                                 /* CFDTMDF8_16      */
    __type210 CFDTMDF9_16;                                 /* CFDTMDF9_16      */
    __type210 CFDTMDF10_16;                                /* CFDTMDF10_16     */
    __type210 CFDTMDF11_16;                                /* CFDTMDF11_16     */
    __type210 CFDTMDF12_16;                                /* CFDTMDF12_16     */
    __type210 CFDTMDF13_16;                                /* CFDTMDF13_16     */
    __type210 CFDTMDF14_16;                                /* CFDTMDF14_16     */
    __type210 CFDTMDF15_16;                                /* CFDTMDF15_16     */
    uint8  dummy383[52];                                   /* Reserved         */
    __type210 CFDTMID17;                                   /* CFDTMID17        */
    __type210 CFDTMPTR17;                                  /* CFDTMPTR17       */
    __type210 CFDTMFDCTR17;                                /* CFDTMFDCTR17     */
    __type210 CFDTMDF0_17;                                 /* CFDTMDF0_17      */
    __type210 CFDTMDF1_17;                                 /* CFDTMDF1_17      */
    __type210 CFDTMDF2_17;                                 /* CFDTMDF2_17      */
    __type210 CFDTMDF3_17;                                 /* CFDTMDF3_17      */
    __type210 CFDTMDF4_17;                                 /* CFDTMDF4_17      */
    __type210 CFDTMDF5_17;                                 /* CFDTMDF5_17      */
    __type210 CFDTMDF6_17;                                 /* CFDTMDF6_17      */
    __type210 CFDTMDF7_17;                                 /* CFDTMDF7_17      */
    __type210 CFDTMDF8_17;                                 /* CFDTMDF8_17      */
    __type210 CFDTMDF9_17;                                 /* CFDTMDF9_17      */
    __type210 CFDTMDF10_17;                                /* CFDTMDF10_17     */
    __type210 CFDTMDF11_17;                                /* CFDTMDF11_17     */
    __type210 CFDTMDF12_17;                                /* CFDTMDF12_17     */
    __type210 CFDTMDF13_17;                                /* CFDTMDF13_17     */
    __type210 CFDTMDF14_17;                                /* CFDTMDF14_17     */
    __type210 CFDTMDF15_17;                                /* CFDTMDF15_17     */
    uint8  dummy384[52];                                   /* Reserved         */
    __type210 CFDTMID18;                                   /* CFDTMID18        */
    __type210 CFDTMPTR18;                                  /* CFDTMPTR18       */
    __type210 CFDTMFDCTR18;                                /* CFDTMFDCTR18     */
    __type210 CFDTMDF0_18;                                 /* CFDTMDF0_18      */
    __type210 CFDTMDF1_18;                                 /* CFDTMDF1_18      */
    __type210 CFDTMDF2_18;                                 /* CFDTMDF2_18      */
    __type210 CFDTMDF3_18;                                 /* CFDTMDF3_18      */
    __type210 CFDTMDF4_18;                                 /* CFDTMDF4_18      */
    __type210 CFDTMDF5_18;                                 /* CFDTMDF5_18      */
    __type210 CFDTMDF6_18;                                 /* CFDTMDF6_18      */
    __type210 CFDTMDF7_18;                                 /* CFDTMDF7_18      */
    __type210 CFDTMDF8_18;                                 /* CFDTMDF8_18      */
    __type210 CFDTMDF9_18;                                 /* CFDTMDF9_18      */
    __type210 CFDTMDF10_18;                                /* CFDTMDF10_18     */
    __type210 CFDTMDF11_18;                                /* CFDTMDF11_18     */
    __type210 CFDTMDF12_18;                                /* CFDTMDF12_18     */
    __type210 CFDTMDF13_18;                                /* CFDTMDF13_18     */
    __type210 CFDTMDF14_18;                                /* CFDTMDF14_18     */
    __type210 CFDTMDF15_18;                                /* CFDTMDF15_18     */
    uint8  dummy385[52];                                   /* Reserved         */
    __type210 CFDTMID19;                                   /* CFDTMID19        */
    __type210 CFDTMPTR19;                                  /* CFDTMPTR19       */
    __type210 CFDTMFDCTR19;                                /* CFDTMFDCTR19     */
    __type210 CFDTMDF0_19;                                 /* CFDTMDF0_19      */
    __type210 CFDTMDF1_19;                                 /* CFDTMDF1_19      */
    __type210 CFDTMDF2_19;                                 /* CFDTMDF2_19      */
    __type210 CFDTMDF3_19;                                 /* CFDTMDF3_19      */
    __type210 CFDTMDF4_19;                                 /* CFDTMDF4_19      */
    __type210 CFDTMDF5_19;                                 /* CFDTMDF5_19      */
    __type210 CFDTMDF6_19;                                 /* CFDTMDF6_19      */
    __type210 CFDTMDF7_19;                                 /* CFDTMDF7_19      */
    __type210 CFDTMDF8_19;                                 /* CFDTMDF8_19      */
    __type210 CFDTMDF9_19;                                 /* CFDTMDF9_19      */
    __type210 CFDTMDF10_19;                                /* CFDTMDF10_19     */
    __type210 CFDTMDF11_19;                                /* CFDTMDF11_19     */
    __type210 CFDTMDF12_19;                                /* CFDTMDF12_19     */
    __type210 CFDTMDF13_19;                                /* CFDTMDF13_19     */
    __type210 CFDTMDF14_19;                                /* CFDTMDF14_19     */
    __type210 CFDTMDF15_19;                                /* CFDTMDF15_19     */
    uint8  dummy386[52];                                   /* Reserved         */
    __type210 CFDTMID20;                                   /* CFDTMID20        */
    __type210 CFDTMPTR20;                                  /* CFDTMPTR20       */
    __type210 CFDTMFDCTR20;                                /* CFDTMFDCTR20     */
    __type210 CFDTMDF0_20;                                 /* CFDTMDF0_20      */
    __type210 CFDTMDF1_20;                                 /* CFDTMDF1_20      */
    __type210 CFDTMDF2_20;                                 /* CFDTMDF2_20      */
    __type210 CFDTMDF3_20;                                 /* CFDTMDF3_20      */
    __type210 CFDTMDF4_20;                                 /* CFDTMDF4_20      */
    __type210 CFDTMDF5_20;                                 /* CFDTMDF5_20      */
    __type210 CFDTMDF6_20;                                 /* CFDTMDF6_20      */
    __type210 CFDTMDF7_20;                                 /* CFDTMDF7_20      */
    __type210 CFDTMDF8_20;                                 /* CFDTMDF8_20      */
    __type210 CFDTMDF9_20;                                 /* CFDTMDF9_20      */
    __type210 CFDTMDF10_20;                                /* CFDTMDF10_20     */
    __type210 CFDTMDF11_20;                                /* CFDTMDF11_20     */
    __type210 CFDTMDF12_20;                                /* CFDTMDF12_20     */
    __type210 CFDTMDF13_20;                                /* CFDTMDF13_20     */
    __type210 CFDTMDF14_20;                                /* CFDTMDF14_20     */
    __type210 CFDTMDF15_20;                                /* CFDTMDF15_20     */
    uint8  dummy387[52];                                   /* Reserved         */
    __type210 CFDTMID21;                                   /* CFDTMID21        */
    __type210 CFDTMPTR21;                                  /* CFDTMPTR21       */
    __type210 CFDTMFDCTR21;                                /* CFDTMFDCTR21     */
    __type210 CFDTMDF0_21;                                 /* CFDTMDF0_21      */
    __type210 CFDTMDF1_21;                                 /* CFDTMDF1_21      */
    __type210 CFDTMDF2_21;                                 /* CFDTMDF2_21      */
    __type210 CFDTMDF3_21;                                 /* CFDTMDF3_21      */
    __type210 CFDTMDF4_21;                                 /* CFDTMDF4_21      */
    __type210 CFDTMDF5_21;                                 /* CFDTMDF5_21      */
    __type210 CFDTMDF6_21;                                 /* CFDTMDF6_21      */
    __type210 CFDTMDF7_21;                                 /* CFDTMDF7_21      */
    __type210 CFDTMDF8_21;                                 /* CFDTMDF8_21      */
    __type210 CFDTMDF9_21;                                 /* CFDTMDF9_21      */
    __type210 CFDTMDF10_21;                                /* CFDTMDF10_21     */
    __type210 CFDTMDF11_21;                                /* CFDTMDF11_21     */
    __type210 CFDTMDF12_21;                                /* CFDTMDF12_21     */
    __type210 CFDTMDF13_21;                                /* CFDTMDF13_21     */
    __type210 CFDTMDF14_21;                                /* CFDTMDF14_21     */
    __type210 CFDTMDF15_21;                                /* CFDTMDF15_21     */
    uint8  dummy388[52];                                   /* Reserved         */
    __type210 CFDTMID22;                                   /* CFDTMID22        */
    __type210 CFDTMPTR22;                                  /* CFDTMPTR22       */
    __type210 CFDTMFDCTR22;                                /* CFDTMFDCTR22     */
    __type210 CFDTMDF0_22;                                 /* CFDTMDF0_22      */
    __type210 CFDTMDF1_22;                                 /* CFDTMDF1_22      */
    __type210 CFDTMDF2_22;                                 /* CFDTMDF2_22      */
    __type210 CFDTMDF3_22;                                 /* CFDTMDF3_22      */
    __type210 CFDTMDF4_22;                                 /* CFDTMDF4_22      */
    __type210 CFDTMDF5_22;                                 /* CFDTMDF5_22      */
    __type210 CFDTMDF6_22;                                 /* CFDTMDF6_22      */
    __type210 CFDTMDF7_22;                                 /* CFDTMDF7_22      */
    __type210 CFDTMDF8_22;                                 /* CFDTMDF8_22      */
    __type210 CFDTMDF9_22;                                 /* CFDTMDF9_22      */
    __type210 CFDTMDF10_22;                                /* CFDTMDF10_22     */
    __type210 CFDTMDF11_22;                                /* CFDTMDF11_22     */
    __type210 CFDTMDF12_22;                                /* CFDTMDF12_22     */
    __type210 CFDTMDF13_22;                                /* CFDTMDF13_22     */
    __type210 CFDTMDF14_22;                                /* CFDTMDF14_22     */
    __type210 CFDTMDF15_22;                                /* CFDTMDF15_22     */
    uint8  dummy389[52];                                   /* Reserved         */
    __type210 CFDTMID23;                                   /* CFDTMID23        */
    __type210 CFDTMPTR23;                                  /* CFDTMPTR23       */
    __type210 CFDTMFDCTR23;                                /* CFDTMFDCTR23     */
    __type210 CFDTMDF0_23;                                 /* CFDTMDF0_23      */
    __type210 CFDTMDF1_23;                                 /* CFDTMDF1_23      */
    __type210 CFDTMDF2_23;                                 /* CFDTMDF2_23      */
    __type210 CFDTMDF3_23;                                 /* CFDTMDF3_23      */
    __type210 CFDTMDF4_23;                                 /* CFDTMDF4_23      */
    __type210 CFDTMDF5_23;                                 /* CFDTMDF5_23      */
    __type210 CFDTMDF6_23;                                 /* CFDTMDF6_23      */
    __type210 CFDTMDF7_23;                                 /* CFDTMDF7_23      */
    __type210 CFDTMDF8_23;                                 /* CFDTMDF8_23      */
    __type210 CFDTMDF9_23;                                 /* CFDTMDF9_23      */
    __type210 CFDTMDF10_23;                                /* CFDTMDF10_23     */
    __type210 CFDTMDF11_23;                                /* CFDTMDF11_23     */
    __type210 CFDTMDF12_23;                                /* CFDTMDF12_23     */
    __type210 CFDTMDF13_23;                                /* CFDTMDF13_23     */
    __type210 CFDTMDF14_23;                                /* CFDTMDF14_23     */
    __type210 CFDTMDF15_23;                                /* CFDTMDF15_23     */
    uint8  dummy390[52];                                   /* Reserved         */
    __type210 CFDTMID24;                                   /* CFDTMID24        */
    __type210 CFDTMPTR24;                                  /* CFDTMPTR24       */
    __type210 CFDTMFDCTR24;                                /* CFDTMFDCTR24     */
    __type210 CFDTMDF0_24;                                 /* CFDTMDF0_24      */
    __type210 CFDTMDF1_24;                                 /* CFDTMDF1_24      */
    __type210 CFDTMDF2_24;                                 /* CFDTMDF2_24      */
    __type210 CFDTMDF3_24;                                 /* CFDTMDF3_24      */
    __type210 CFDTMDF4_24;                                 /* CFDTMDF4_24      */
    __type210 CFDTMDF5_24;                                 /* CFDTMDF5_24      */
    __type210 CFDTMDF6_24;                                 /* CFDTMDF6_24      */
    __type210 CFDTMDF7_24;                                 /* CFDTMDF7_24      */
    __type210 CFDTMDF8_24;                                 /* CFDTMDF8_24      */
    __type210 CFDTMDF9_24;                                 /* CFDTMDF9_24      */
    __type210 CFDTMDF10_24;                                /* CFDTMDF10_24     */
    __type210 CFDTMDF11_24;                                /* CFDTMDF11_24     */
    __type210 CFDTMDF12_24;                                /* CFDTMDF12_24     */
    __type210 CFDTMDF13_24;                                /* CFDTMDF13_24     */
    __type210 CFDTMDF14_24;                                /* CFDTMDF14_24     */
    __type210 CFDTMDF15_24;                                /* CFDTMDF15_24     */
    uint8  dummy391[52];                                   /* Reserved         */
    __type210 CFDTMID25;                                   /* CFDTMID25        */
    __type210 CFDTMPTR25;                                  /* CFDTMPTR25       */
    __type210 CFDTMFDCTR25;                                /* CFDTMFDCTR25     */
    __type210 CFDTMDF0_25;                                 /* CFDTMDF0_25      */
    __type210 CFDTMDF1_25;                                 /* CFDTMDF1_25      */
    __type210 CFDTMDF2_25;                                 /* CFDTMDF2_25      */
    __type210 CFDTMDF3_25;                                 /* CFDTMDF3_25      */
    __type210 CFDTMDF4_25;                                 /* CFDTMDF4_25      */
    __type210 CFDTMDF5_25;                                 /* CFDTMDF5_25      */
    __type210 CFDTMDF6_25;                                 /* CFDTMDF6_25      */
    __type210 CFDTMDF7_25;                                 /* CFDTMDF7_25      */
    __type210 CFDTMDF8_25;                                 /* CFDTMDF8_25      */
    __type210 CFDTMDF9_25;                                 /* CFDTMDF9_25      */
    __type210 CFDTMDF10_25;                                /* CFDTMDF10_25     */
    __type210 CFDTMDF11_25;                                /* CFDTMDF11_25     */
    __type210 CFDTMDF12_25;                                /* CFDTMDF12_25     */
    __type210 CFDTMDF13_25;                                /* CFDTMDF13_25     */
    __type210 CFDTMDF14_25;                                /* CFDTMDF14_25     */
    __type210 CFDTMDF15_25;                                /* CFDTMDF15_25     */
    uint8  dummy392[52];                                   /* Reserved         */
    __type210 CFDTMID26;                                   /* CFDTMID26        */
    __type210 CFDTMPTR26;                                  /* CFDTMPTR26       */
    __type210 CFDTMFDCTR26;                                /* CFDTMFDCTR26     */
    __type210 CFDTMDF0_26;                                 /* CFDTMDF0_26      */
    __type210 CFDTMDF1_26;                                 /* CFDTMDF1_26      */
    __type210 CFDTMDF2_26;                                 /* CFDTMDF2_26      */
    __type210 CFDTMDF3_26;                                 /* CFDTMDF3_26      */
    __type210 CFDTMDF4_26;                                 /* CFDTMDF4_26      */
    __type210 CFDTMDF5_26;                                 /* CFDTMDF5_26      */
    __type210 CFDTMDF6_26;                                 /* CFDTMDF6_26      */
    __type210 CFDTMDF7_26;                                 /* CFDTMDF7_26      */
    __type210 CFDTMDF8_26;                                 /* CFDTMDF8_26      */
    __type210 CFDTMDF9_26;                                 /* CFDTMDF9_26      */
    __type210 CFDTMDF10_26;                                /* CFDTMDF10_26     */
    __type210 CFDTMDF11_26;                                /* CFDTMDF11_26     */
    __type210 CFDTMDF12_26;                                /* CFDTMDF12_26     */
    __type210 CFDTMDF13_26;                                /* CFDTMDF13_26     */
    __type210 CFDTMDF14_26;                                /* CFDTMDF14_26     */
    __type210 CFDTMDF15_26;                                /* CFDTMDF15_26     */
    uint8  dummy393[52];                                   /* Reserved         */
    __type210 CFDTMID27;                                   /* CFDTMID27        */
    __type210 CFDTMPTR27;                                  /* CFDTMPTR27       */
    __type210 CFDTMFDCTR27;                                /* CFDTMFDCTR27     */
    __type210 CFDTMDF0_27;                                 /* CFDTMDF0_27      */
    __type210 CFDTMDF1_27;                                 /* CFDTMDF1_27      */
    __type210 CFDTMDF2_27;                                 /* CFDTMDF2_27      */
    __type210 CFDTMDF3_27;                                 /* CFDTMDF3_27      */
    __type210 CFDTMDF4_27;                                 /* CFDTMDF4_27      */
    __type210 CFDTMDF5_27;                                 /* CFDTMDF5_27      */
    __type210 CFDTMDF6_27;                                 /* CFDTMDF6_27      */
    __type210 CFDTMDF7_27;                                 /* CFDTMDF7_27      */
    __type210 CFDTMDF8_27;                                 /* CFDTMDF8_27      */
    __type210 CFDTMDF9_27;                                 /* CFDTMDF9_27      */
    __type210 CFDTMDF10_27;                                /* CFDTMDF10_27     */
    __type210 CFDTMDF11_27;                                /* CFDTMDF11_27     */
    __type210 CFDTMDF12_27;                                /* CFDTMDF12_27     */
    __type210 CFDTMDF13_27;                                /* CFDTMDF13_27     */
    __type210 CFDTMDF14_27;                                /* CFDTMDF14_27     */
    __type210 CFDTMDF15_27;                                /* CFDTMDF15_27     */
    uint8  dummy394[52];                                   /* Reserved         */
    __type210 CFDTMID28;                                   /* CFDTMID28        */
    __type210 CFDTMPTR28;                                  /* CFDTMPTR28       */
    __type210 CFDTMFDCTR28;                                /* CFDTMFDCTR28     */
    __type210 CFDTMDF0_28;                                 /* CFDTMDF0_28      */
    __type210 CFDTMDF1_28;                                 /* CFDTMDF1_28      */
    __type210 CFDTMDF2_28;                                 /* CFDTMDF2_28      */
    __type210 CFDTMDF3_28;                                 /* CFDTMDF3_28      */
    __type210 CFDTMDF4_28;                                 /* CFDTMDF4_28      */
    __type210 CFDTMDF5_28;                                 /* CFDTMDF5_28      */
    __type210 CFDTMDF6_28;                                 /* CFDTMDF6_28      */
    __type210 CFDTMDF7_28;                                 /* CFDTMDF7_28      */
    __type210 CFDTMDF8_28;                                 /* CFDTMDF8_28      */
    __type210 CFDTMDF9_28;                                 /* CFDTMDF9_28      */
    __type210 CFDTMDF10_28;                                /* CFDTMDF10_28     */
    __type210 CFDTMDF11_28;                                /* CFDTMDF11_28     */
    __type210 CFDTMDF12_28;                                /* CFDTMDF12_28     */
    __type210 CFDTMDF13_28;                                /* CFDTMDF13_28     */
    __type210 CFDTMDF14_28;                                /* CFDTMDF14_28     */
    __type210 CFDTMDF15_28;                                /* CFDTMDF15_28     */
    uint8  dummy395[52];                                   /* Reserved         */
    __type210 CFDTMID29;                                   /* CFDTMID29        */
    __type210 CFDTMPTR29;                                  /* CFDTMPTR29       */
    __type210 CFDTMFDCTR29;                                /* CFDTMFDCTR29     */
    __type210 CFDTMDF0_29;                                 /* CFDTMDF0_29      */
    __type210 CFDTMDF1_29;                                 /* CFDTMDF1_29      */
    __type210 CFDTMDF2_29;                                 /* CFDTMDF2_29      */
    __type210 CFDTMDF3_29;                                 /* CFDTMDF3_29      */
    __type210 CFDTMDF4_29;                                 /* CFDTMDF4_29      */
    __type210 CFDTMDF5_29;                                 /* CFDTMDF5_29      */
    __type210 CFDTMDF6_29;                                 /* CFDTMDF6_29      */
    __type210 CFDTMDF7_29;                                 /* CFDTMDF7_29      */
    __type210 CFDTMDF8_29;                                 /* CFDTMDF8_29      */
    __type210 CFDTMDF9_29;                                 /* CFDTMDF9_29      */
    __type210 CFDTMDF10_29;                                /* CFDTMDF10_29     */
    __type210 CFDTMDF11_29;                                /* CFDTMDF11_29     */
    __type210 CFDTMDF12_29;                                /* CFDTMDF12_29     */
    __type210 CFDTMDF13_29;                                /* CFDTMDF13_29     */
    __type210 CFDTMDF14_29;                                /* CFDTMDF14_29     */
    __type210 CFDTMDF15_29;                                /* CFDTMDF15_29     */
    uint8  dummy396[52];                                   /* Reserved         */
    __type210 CFDTMID30;                                   /* CFDTMID30        */
    __type210 CFDTMPTR30;                                  /* CFDTMPTR30       */
    __type210 CFDTMFDCTR30;                                /* CFDTMFDCTR30     */
    __type210 CFDTMDF0_30;                                 /* CFDTMDF0_30      */
    __type210 CFDTMDF1_30;                                 /* CFDTMDF1_30      */
    __type210 CFDTMDF2_30;                                 /* CFDTMDF2_30      */
    __type210 CFDTMDF3_30;                                 /* CFDTMDF3_30      */
    __type210 CFDTMDF4_30;                                 /* CFDTMDF4_30      */
    __type210 CFDTMDF5_30;                                 /* CFDTMDF5_30      */
    __type210 CFDTMDF6_30;                                 /* CFDTMDF6_30      */
    __type210 CFDTMDF7_30;                                 /* CFDTMDF7_30      */
    __type210 CFDTMDF8_30;                                 /* CFDTMDF8_30      */
    __type210 CFDTMDF9_30;                                 /* CFDTMDF9_30      */
    __type210 CFDTMDF10_30;                                /* CFDTMDF10_30     */
    __type210 CFDTMDF11_30;                                /* CFDTMDF11_30     */
    __type210 CFDTMDF12_30;                                /* CFDTMDF12_30     */
    __type210 CFDTMDF13_30;                                /* CFDTMDF13_30     */
    __type210 CFDTMDF14_30;                                /* CFDTMDF14_30     */
    __type210 CFDTMDF15_30;                                /* CFDTMDF15_30     */
    uint8  dummy397[52];                                   /* Reserved         */
    __type210 CFDTMID31;                                   /* CFDTMID31        */
    __type210 CFDTMPTR31;                                  /* CFDTMPTR31       */
    __type210 CFDTMFDCTR31;                                /* CFDTMFDCTR31     */
    __type210 CFDTMDF0_31;                                 /* CFDTMDF0_31      */
    __type210 CFDTMDF1_31;                                 /* CFDTMDF1_31      */
    __type210 CFDTMDF2_31;                                 /* CFDTMDF2_31      */
    __type210 CFDTMDF3_31;                                 /* CFDTMDF3_31      */
    __type210 CFDTMDF4_31;                                 /* CFDTMDF4_31      */
    __type210 CFDTMDF5_31;                                 /* CFDTMDF5_31      */
    __type210 CFDTMDF6_31;                                 /* CFDTMDF6_31      */
    __type210 CFDTMDF7_31;                                 /* CFDTMDF7_31      */
    __type210 CFDTMDF8_31;                                 /* CFDTMDF8_31      */
    __type210 CFDTMDF9_31;                                 /* CFDTMDF9_31      */
    __type210 CFDTMDF10_31;                                /* CFDTMDF10_31     */
    __type210 CFDTMDF11_31;                                /* CFDTMDF11_31     */
    __type210 CFDTMDF12_31;                                /* CFDTMDF12_31     */
    __type210 CFDTMDF13_31;                                /* CFDTMDF13_31     */
    __type210 CFDTMDF14_31;                                /* CFDTMDF14_31     */
    __type210 CFDTMDF15_31;                                /* CFDTMDF15_31     */
    uint8  dummy398[52];                                   /* Reserved         */
    __type210 CFDTMID32;                                   /* CFDTMID32        */
    __type210 CFDTMPTR32;                                  /* CFDTMPTR32       */
    __type210 CFDTMFDCTR32;                                /* CFDTMFDCTR32     */
    __type210 CFDTMDF0_32;                                 /* CFDTMDF0_32      */
    __type210 CFDTMDF1_32;                                 /* CFDTMDF1_32      */
    __type210 CFDTMDF2_32;                                 /* CFDTMDF2_32      */
    __type210 CFDTMDF3_32;                                 /* CFDTMDF3_32      */
    __type210 CFDTMDF4_32;                                 /* CFDTMDF4_32      */
    __type210 CFDTMDF5_32;                                 /* CFDTMDF5_32      */
    __type210 CFDTMDF6_32;                                 /* CFDTMDF6_32      */
    __type210 CFDTMDF7_32;                                 /* CFDTMDF7_32      */
    __type210 CFDTMDF8_32;                                 /* CFDTMDF8_32      */
    __type210 CFDTMDF9_32;                                 /* CFDTMDF9_32      */
    __type210 CFDTMDF10_32;                                /* CFDTMDF10_32     */
    __type210 CFDTMDF11_32;                                /* CFDTMDF11_32     */
    __type210 CFDTMDF12_32;                                /* CFDTMDF12_32     */
    __type210 CFDTMDF13_32;                                /* CFDTMDF13_32     */
    __type210 CFDTMDF14_32;                                /* CFDTMDF14_32     */
    __type210 CFDTMDF15_32;                                /* CFDTMDF15_32     */
    uint8  dummy399[52];                                   /* Reserved         */
    __type210 CFDTMID33;                                   /* CFDTMID33        */
    __type210 CFDTMPTR33;                                  /* CFDTMPTR33       */
    __type210 CFDTMFDCTR33;                                /* CFDTMFDCTR33     */
    __type210 CFDTMDF0_33;                                 /* CFDTMDF0_33      */
    __type210 CFDTMDF1_33;                                 /* CFDTMDF1_33      */
    __type210 CFDTMDF2_33;                                 /* CFDTMDF2_33      */
    __type210 CFDTMDF3_33;                                 /* CFDTMDF3_33      */
    __type210 CFDTMDF4_33;                                 /* CFDTMDF4_33      */
    __type210 CFDTMDF5_33;                                 /* CFDTMDF5_33      */
    __type210 CFDTMDF6_33;                                 /* CFDTMDF6_33      */
    __type210 CFDTMDF7_33;                                 /* CFDTMDF7_33      */
    __type210 CFDTMDF8_33;                                 /* CFDTMDF8_33      */
    __type210 CFDTMDF9_33;                                 /* CFDTMDF9_33      */
    __type210 CFDTMDF10_33;                                /* CFDTMDF10_33     */
    __type210 CFDTMDF11_33;                                /* CFDTMDF11_33     */
    __type210 CFDTMDF12_33;                                /* CFDTMDF12_33     */
    __type210 CFDTMDF13_33;                                /* CFDTMDF13_33     */
    __type210 CFDTMDF14_33;                                /* CFDTMDF14_33     */
    __type210 CFDTMDF15_33;                                /* CFDTMDF15_33     */
    uint8  dummy400[52];                                   /* Reserved         */
    __type210 CFDTMID34;                                   /* CFDTMID34        */
    __type210 CFDTMPTR34;                                  /* CFDTMPTR34       */
    __type210 CFDTMFDCTR34;                                /* CFDTMFDCTR34     */
    __type210 CFDTMDF0_34;                                 /* CFDTMDF0_34      */
    __type210 CFDTMDF1_34;                                 /* CFDTMDF1_34      */
    __type210 CFDTMDF2_34;                                 /* CFDTMDF2_34      */
    __type210 CFDTMDF3_34;                                 /* CFDTMDF3_34      */
    __type210 CFDTMDF4_34;                                 /* CFDTMDF4_34      */
    __type210 CFDTMDF5_34;                                 /* CFDTMDF5_34      */
    __type210 CFDTMDF6_34;                                 /* CFDTMDF6_34      */
    __type210 CFDTMDF7_34;                                 /* CFDTMDF7_34      */
    __type210 CFDTMDF8_34;                                 /* CFDTMDF8_34      */
    __type210 CFDTMDF9_34;                                 /* CFDTMDF9_34      */
    __type210 CFDTMDF10_34;                                /* CFDTMDF10_34     */
    __type210 CFDTMDF11_34;                                /* CFDTMDF11_34     */
    __type210 CFDTMDF12_34;                                /* CFDTMDF12_34     */
    __type210 CFDTMDF13_34;                                /* CFDTMDF13_34     */
    __type210 CFDTMDF14_34;                                /* CFDTMDF14_34     */
    __type210 CFDTMDF15_34;                                /* CFDTMDF15_34     */
    uint8  dummy401[52];                                   /* Reserved         */
    __type210 CFDTMID35;                                   /* CFDTMID35        */
    __type210 CFDTMPTR35;                                  /* CFDTMPTR35       */
    __type210 CFDTMFDCTR35;                                /* CFDTMFDCTR35     */
    __type210 CFDTMDF0_35;                                 /* CFDTMDF0_35      */
    __type210 CFDTMDF1_35;                                 /* CFDTMDF1_35      */
    __type210 CFDTMDF2_35;                                 /* CFDTMDF2_35      */
    __type210 CFDTMDF3_35;                                 /* CFDTMDF3_35      */
    __type210 CFDTMDF4_35;                                 /* CFDTMDF4_35      */
    __type210 CFDTMDF5_35;                                 /* CFDTMDF5_35      */
    __type210 CFDTMDF6_35;                                 /* CFDTMDF6_35      */
    __type210 CFDTMDF7_35;                                 /* CFDTMDF7_35      */
    __type210 CFDTMDF8_35;                                 /* CFDTMDF8_35      */
    __type210 CFDTMDF9_35;                                 /* CFDTMDF9_35      */
    __type210 CFDTMDF10_35;                                /* CFDTMDF10_35     */
    __type210 CFDTMDF11_35;                                /* CFDTMDF11_35     */
    __type210 CFDTMDF12_35;                                /* CFDTMDF12_35     */
    __type210 CFDTMDF13_35;                                /* CFDTMDF13_35     */
    __type210 CFDTMDF14_35;                                /* CFDTMDF14_35     */
    __type210 CFDTMDF15_35;                                /* CFDTMDF15_35     */
    uint8  dummy402[52];                                   /* Reserved         */
    __type210 CFDTMID36;                                   /* CFDTMID36        */
    __type210 CFDTMPTR36;                                  /* CFDTMPTR36       */
    __type210 CFDTMFDCTR36;                                /* CFDTMFDCTR36     */
    __type210 CFDTMDF0_36;                                 /* CFDTMDF0_36      */
    __type210 CFDTMDF1_36;                                 /* CFDTMDF1_36      */
    __type210 CFDTMDF2_36;                                 /* CFDTMDF2_36      */
    __type210 CFDTMDF3_36;                                 /* CFDTMDF3_36      */
    __type210 CFDTMDF4_36;                                 /* CFDTMDF4_36      */
    __type210 CFDTMDF5_36;                                 /* CFDTMDF5_36      */
    __type210 CFDTMDF6_36;                                 /* CFDTMDF6_36      */
    __type210 CFDTMDF7_36;                                 /* CFDTMDF7_36      */
    __type210 CFDTMDF8_36;                                 /* CFDTMDF8_36      */
    __type210 CFDTMDF9_36;                                 /* CFDTMDF9_36      */
    __type210 CFDTMDF10_36;                                /* CFDTMDF10_36     */
    __type210 CFDTMDF11_36;                                /* CFDTMDF11_36     */
    __type210 CFDTMDF12_36;                                /* CFDTMDF12_36     */
    __type210 CFDTMDF13_36;                                /* CFDTMDF13_36     */
    __type210 CFDTMDF14_36;                                /* CFDTMDF14_36     */
    __type210 CFDTMDF15_36;                                /* CFDTMDF15_36     */
    uint8  dummy403[52];                                   /* Reserved         */
    __type210 CFDTMID37;                                   /* CFDTMID37        */
    __type210 CFDTMPTR37;                                  /* CFDTMPTR37       */
    __type210 CFDTMFDCTR37;                                /* CFDTMFDCTR37     */
    __type210 CFDTMDF0_37;                                 /* CFDTMDF0_37      */
    __type210 CFDTMDF1_37;                                 /* CFDTMDF1_37      */
    __type210 CFDTMDF2_37;                                 /* CFDTMDF2_37      */
    __type210 CFDTMDF3_37;                                 /* CFDTMDF3_37      */
    __type210 CFDTMDF4_37;                                 /* CFDTMDF4_37      */
    __type210 CFDTMDF5_37;                                 /* CFDTMDF5_37      */
    __type210 CFDTMDF6_37;                                 /* CFDTMDF6_37      */
    __type210 CFDTMDF7_37;                                 /* CFDTMDF7_37      */
    __type210 CFDTMDF8_37;                                 /* CFDTMDF8_37      */
    __type210 CFDTMDF9_37;                                 /* CFDTMDF9_37      */
    __type210 CFDTMDF10_37;                                /* CFDTMDF10_37     */
    __type210 CFDTMDF11_37;                                /* CFDTMDF11_37     */
    __type210 CFDTMDF12_37;                                /* CFDTMDF12_37     */
    __type210 CFDTMDF13_37;                                /* CFDTMDF13_37     */
    __type210 CFDTMDF14_37;                                /* CFDTMDF14_37     */
    __type210 CFDTMDF15_37;                                /* CFDTMDF15_37     */
    uint8  dummy404[52];                                   /* Reserved         */
    __type210 CFDTMID38;                                   /* CFDTMID38        */
    __type210 CFDTMPTR38;                                  /* CFDTMPTR38       */
    __type210 CFDTMFDCTR38;                                /* CFDTMFDCTR38     */
    __type210 CFDTMDF0_38;                                 /* CFDTMDF0_38      */
    __type210 CFDTMDF1_38;                                 /* CFDTMDF1_38      */
    __type210 CFDTMDF2_38;                                 /* CFDTMDF2_38      */
    __type210 CFDTMDF3_38;                                 /* CFDTMDF3_38      */
    __type210 CFDTMDF4_38;                                 /* CFDTMDF4_38      */
    __type210 CFDTMDF5_38;                                 /* CFDTMDF5_38      */
    __type210 CFDTMDF6_38;                                 /* CFDTMDF6_38      */
    __type210 CFDTMDF7_38;                                 /* CFDTMDF7_38      */
    __type210 CFDTMDF8_38;                                 /* CFDTMDF8_38      */
    __type210 CFDTMDF9_38;                                 /* CFDTMDF9_38      */
    __type210 CFDTMDF10_38;                                /* CFDTMDF10_38     */
    __type210 CFDTMDF11_38;                                /* CFDTMDF11_38     */
    __type210 CFDTMDF12_38;                                /* CFDTMDF12_38     */
    __type210 CFDTMDF13_38;                                /* CFDTMDF13_38     */
    __type210 CFDTMDF14_38;                                /* CFDTMDF14_38     */
    __type210 CFDTMDF15_38;                                /* CFDTMDF15_38     */
    uint8  dummy405[52];                                   /* Reserved         */
    __type210 CFDTMID39;                                   /* CFDTMID39        */
    __type210 CFDTMPTR39;                                  /* CFDTMPTR39       */
    __type210 CFDTMFDCTR39;                                /* CFDTMFDCTR39     */
    __type210 CFDTMDF0_39;                                 /* CFDTMDF0_39      */
    __type210 CFDTMDF1_39;                                 /* CFDTMDF1_39      */
    __type210 CFDTMDF2_39;                                 /* CFDTMDF2_39      */
    __type210 CFDTMDF3_39;                                 /* CFDTMDF3_39      */
    __type210 CFDTMDF4_39;                                 /* CFDTMDF4_39      */
    __type210 CFDTMDF5_39;                                 /* CFDTMDF5_39      */
    __type210 CFDTMDF6_39;                                 /* CFDTMDF6_39      */
    __type210 CFDTMDF7_39;                                 /* CFDTMDF7_39      */
    __type210 CFDTMDF8_39;                                 /* CFDTMDF8_39      */
    __type210 CFDTMDF9_39;                                 /* CFDTMDF9_39      */
    __type210 CFDTMDF10_39;                                /* CFDTMDF10_39     */
    __type210 CFDTMDF11_39;                                /* CFDTMDF11_39     */
    __type210 CFDTMDF12_39;                                /* CFDTMDF12_39     */
    __type210 CFDTMDF13_39;                                /* CFDTMDF13_39     */
    __type210 CFDTMDF14_39;                                /* CFDTMDF14_39     */
    __type210 CFDTMDF15_39;                                /* CFDTMDF15_39     */
    uint8  dummy406[52];                                   /* Reserved         */
    __type210 CFDTMID40;                                   /* CFDTMID40        */
    __type210 CFDTMPTR40;                                  /* CFDTMPTR40       */
    __type210 CFDTMFDCTR40;                                /* CFDTMFDCTR40     */
    __type210 CFDTMDF0_40;                                 /* CFDTMDF0_40      */
    __type210 CFDTMDF1_40;                                 /* CFDTMDF1_40      */
    __type210 CFDTMDF2_40;                                 /* CFDTMDF2_40      */
    __type210 CFDTMDF3_40;                                 /* CFDTMDF3_40      */
    __type210 CFDTMDF4_40;                                 /* CFDTMDF4_40      */
    __type210 CFDTMDF5_40;                                 /* CFDTMDF5_40      */
    __type210 CFDTMDF6_40;                                 /* CFDTMDF6_40      */
    __type210 CFDTMDF7_40;                                 /* CFDTMDF7_40      */
    __type210 CFDTMDF8_40;                                 /* CFDTMDF8_40      */
    __type210 CFDTMDF9_40;                                 /* CFDTMDF9_40      */
    __type210 CFDTMDF10_40;                                /* CFDTMDF10_40     */
    __type210 CFDTMDF11_40;                                /* CFDTMDF11_40     */
    __type210 CFDTMDF12_40;                                /* CFDTMDF12_40     */
    __type210 CFDTMDF13_40;                                /* CFDTMDF13_40     */
    __type210 CFDTMDF14_40;                                /* CFDTMDF14_40     */
    __type210 CFDTMDF15_40;                                /* CFDTMDF15_40     */
    uint8  dummy407[52];                                   /* Reserved         */
    __type210 CFDTMID41;                                   /* CFDTMID41        */
    __type210 CFDTMPTR41;                                  /* CFDTMPTR41       */
    __type210 CFDTMFDCTR41;                                /* CFDTMFDCTR41     */
    __type210 CFDTMDF0_41;                                 /* CFDTMDF0_41      */
    __type210 CFDTMDF1_41;                                 /* CFDTMDF1_41      */
    __type210 CFDTMDF2_41;                                 /* CFDTMDF2_41      */
    __type210 CFDTMDF3_41;                                 /* CFDTMDF3_41      */
    __type210 CFDTMDF4_41;                                 /* CFDTMDF4_41      */
    __type210 CFDTMDF5_41;                                 /* CFDTMDF5_41      */
    __type210 CFDTMDF6_41;                                 /* CFDTMDF6_41      */
    __type210 CFDTMDF7_41;                                 /* CFDTMDF7_41      */
    __type210 CFDTMDF8_41;                                 /* CFDTMDF8_41      */
    __type210 CFDTMDF9_41;                                 /* CFDTMDF9_41      */
    __type210 CFDTMDF10_41;                                /* CFDTMDF10_41     */
    __type210 CFDTMDF11_41;                                /* CFDTMDF11_41     */
    __type210 CFDTMDF12_41;                                /* CFDTMDF12_41     */
    __type210 CFDTMDF13_41;                                /* CFDTMDF13_41     */
    __type210 CFDTMDF14_41;                                /* CFDTMDF14_41     */
    __type210 CFDTMDF15_41;                                /* CFDTMDF15_41     */
    uint8  dummy408[52];                                   /* Reserved         */
    __type210 CFDTMID42;                                   /* CFDTMID42        */
    __type210 CFDTMPTR42;                                  /* CFDTMPTR42       */
    __type210 CFDTMFDCTR42;                                /* CFDTMFDCTR42     */
    __type210 CFDTMDF0_42;                                 /* CFDTMDF0_42      */
    __type210 CFDTMDF1_42;                                 /* CFDTMDF1_42      */
    __type210 CFDTMDF2_42;                                 /* CFDTMDF2_42      */
    __type210 CFDTMDF3_42;                                 /* CFDTMDF3_42      */
    __type210 CFDTMDF4_42;                                 /* CFDTMDF4_42      */
    __type210 CFDTMDF5_42;                                 /* CFDTMDF5_42      */
    __type210 CFDTMDF6_42;                                 /* CFDTMDF6_42      */
    __type210 CFDTMDF7_42;                                 /* CFDTMDF7_42      */
    __type210 CFDTMDF8_42;                                 /* CFDTMDF8_42      */
    __type210 CFDTMDF9_42;                                 /* CFDTMDF9_42      */
    __type210 CFDTMDF10_42;                                /* CFDTMDF10_42     */
    __type210 CFDTMDF11_42;                                /* CFDTMDF11_42     */
    __type210 CFDTMDF12_42;                                /* CFDTMDF12_42     */
    __type210 CFDTMDF13_42;                                /* CFDTMDF13_42     */
    __type210 CFDTMDF14_42;                                /* CFDTMDF14_42     */
    __type210 CFDTMDF15_42;                                /* CFDTMDF15_42     */
    uint8  dummy409[52];                                   /* Reserved         */
    __type210 CFDTMID43;                                   /* CFDTMID43        */
    __type210 CFDTMPTR43;                                  /* CFDTMPTR43       */
    __type210 CFDTMFDCTR43;                                /* CFDTMFDCTR43     */
    __type210 CFDTMDF0_43;                                 /* CFDTMDF0_43      */
    __type210 CFDTMDF1_43;                                 /* CFDTMDF1_43      */
    __type210 CFDTMDF2_43;                                 /* CFDTMDF2_43      */
    __type210 CFDTMDF3_43;                                 /* CFDTMDF3_43      */
    __type210 CFDTMDF4_43;                                 /* CFDTMDF4_43      */
    __type210 CFDTMDF5_43;                                 /* CFDTMDF5_43      */
    __type210 CFDTMDF6_43;                                 /* CFDTMDF6_43      */
    __type210 CFDTMDF7_43;                                 /* CFDTMDF7_43      */
    __type210 CFDTMDF8_43;                                 /* CFDTMDF8_43      */
    __type210 CFDTMDF9_43;                                 /* CFDTMDF9_43      */
    __type210 CFDTMDF10_43;                                /* CFDTMDF10_43     */
    __type210 CFDTMDF11_43;                                /* CFDTMDF11_43     */
    __type210 CFDTMDF12_43;                                /* CFDTMDF12_43     */
    __type210 CFDTMDF13_43;                                /* CFDTMDF13_43     */
    __type210 CFDTMDF14_43;                                /* CFDTMDF14_43     */
    __type210 CFDTMDF15_43;                                /* CFDTMDF15_43     */
    uint8  dummy410[52];                                   /* Reserved         */
    __type210 CFDTMID44;                                   /* CFDTMID44        */
    __type210 CFDTMPTR44;                                  /* CFDTMPTR44       */
    __type210 CFDTMFDCTR44;                                /* CFDTMFDCTR44     */
    __type210 CFDTMDF0_44;                                 /* CFDTMDF0_44      */
    __type210 CFDTMDF1_44;                                 /* CFDTMDF1_44      */
    __type210 CFDTMDF2_44;                                 /* CFDTMDF2_44      */
    __type210 CFDTMDF3_44;                                 /* CFDTMDF3_44      */
    __type210 CFDTMDF4_44;                                 /* CFDTMDF4_44      */
    __type210 CFDTMDF5_44;                                 /* CFDTMDF5_44      */
    __type210 CFDTMDF6_44;                                 /* CFDTMDF6_44      */
    __type210 CFDTMDF7_44;                                 /* CFDTMDF7_44      */
    __type210 CFDTMDF8_44;                                 /* CFDTMDF8_44      */
    __type210 CFDTMDF9_44;                                 /* CFDTMDF9_44      */
    __type210 CFDTMDF10_44;                                /* CFDTMDF10_44     */
    __type210 CFDTMDF11_44;                                /* CFDTMDF11_44     */
    __type210 CFDTMDF12_44;                                /* CFDTMDF12_44     */
    __type210 CFDTMDF13_44;                                /* CFDTMDF13_44     */
    __type210 CFDTMDF14_44;                                /* CFDTMDF14_44     */
    __type210 CFDTMDF15_44;                                /* CFDTMDF15_44     */
    uint8  dummy411[52];                                   /* Reserved         */
    __type210 CFDTMID45;                                   /* CFDTMID45        */
    __type210 CFDTMPTR45;                                  /* CFDTMPTR45       */
    __type210 CFDTMFDCTR45;                                /* CFDTMFDCTR45     */
    __type210 CFDTMDF0_45;                                 /* CFDTMDF0_45      */
    __type210 CFDTMDF1_45;                                 /* CFDTMDF1_45      */
    __type210 CFDTMDF2_45;                                 /* CFDTMDF2_45      */
    __type210 CFDTMDF3_45;                                 /* CFDTMDF3_45      */
    __type210 CFDTMDF4_45;                                 /* CFDTMDF4_45      */
    __type210 CFDTMDF5_45;                                 /* CFDTMDF5_45      */
    __type210 CFDTMDF6_45;                                 /* CFDTMDF6_45      */
    __type210 CFDTMDF7_45;                                 /* CFDTMDF7_45      */
    __type210 CFDTMDF8_45;                                 /* CFDTMDF8_45      */
    __type210 CFDTMDF9_45;                                 /* CFDTMDF9_45      */
    __type210 CFDTMDF10_45;                                /* CFDTMDF10_45     */
    __type210 CFDTMDF11_45;                                /* CFDTMDF11_45     */
    __type210 CFDTMDF12_45;                                /* CFDTMDF12_45     */
    __type210 CFDTMDF13_45;                                /* CFDTMDF13_45     */
    __type210 CFDTMDF14_45;                                /* CFDTMDF14_45     */
    __type210 CFDTMDF15_45;                                /* CFDTMDF15_45     */
    uint8  dummy412[52];                                   /* Reserved         */
    __type210 CFDTMID46;                                   /* CFDTMID46        */
    __type210 CFDTMPTR46;                                  /* CFDTMPTR46       */
    __type210 CFDTMFDCTR46;                                /* CFDTMFDCTR46     */
    __type210 CFDTMDF0_46;                                 /* CFDTMDF0_46      */
    __type210 CFDTMDF1_46;                                 /* CFDTMDF1_46      */
    __type210 CFDTMDF2_46;                                 /* CFDTMDF2_46      */
    __type210 CFDTMDF3_46;                                 /* CFDTMDF3_46      */
    __type210 CFDTMDF4_46;                                 /* CFDTMDF4_46      */
    __type210 CFDTMDF5_46;                                 /* CFDTMDF5_46      */
    __type210 CFDTMDF6_46;                                 /* CFDTMDF6_46      */
    __type210 CFDTMDF7_46;                                 /* CFDTMDF7_46      */
    __type210 CFDTMDF8_46;                                 /* CFDTMDF8_46      */
    __type210 CFDTMDF9_46;                                 /* CFDTMDF9_46      */
    __type210 CFDTMDF10_46;                                /* CFDTMDF10_46     */
    __type210 CFDTMDF11_46;                                /* CFDTMDF11_46     */
    __type210 CFDTMDF12_46;                                /* CFDTMDF12_46     */
    __type210 CFDTMDF13_46;                                /* CFDTMDF13_46     */
    __type210 CFDTMDF14_46;                                /* CFDTMDF14_46     */
    __type210 CFDTMDF15_46;                                /* CFDTMDF15_46     */
    uint8  dummy413[52];                                   /* Reserved         */
    __type210 CFDTMID47;                                   /* CFDTMID47        */
    __type210 CFDTMPTR47;                                  /* CFDTMPTR47       */
    __type210 CFDTMFDCTR47;                                /* CFDTMFDCTR47     */
    __type210 CFDTMDF0_47;                                 /* CFDTMDF0_47      */
    __type210 CFDTMDF1_47;                                 /* CFDTMDF1_47      */
    __type210 CFDTMDF2_47;                                 /* CFDTMDF2_47      */
    __type210 CFDTMDF3_47;                                 /* CFDTMDF3_47      */
    __type210 CFDTMDF4_47;                                 /* CFDTMDF4_47      */
    __type210 CFDTMDF5_47;                                 /* CFDTMDF5_47      */
    __type210 CFDTMDF6_47;                                 /* CFDTMDF6_47      */
    __type210 CFDTMDF7_47;                                 /* CFDTMDF7_47      */
    __type210 CFDTMDF8_47;                                 /* CFDTMDF8_47      */
    __type210 CFDTMDF9_47;                                 /* CFDTMDF9_47      */
    __type210 CFDTMDF10_47;                                /* CFDTMDF10_47     */
    __type210 CFDTMDF11_47;                                /* CFDTMDF11_47     */
    __type210 CFDTMDF12_47;                                /* CFDTMDF12_47     */
    __type210 CFDTMDF13_47;                                /* CFDTMDF13_47     */
    __type210 CFDTMDF14_47;                                /* CFDTMDF14_47     */
    __type210 CFDTMDF15_47;                                /* CFDTMDF15_47     */
    uint8  dummy414[52];                                   /* Reserved         */
    __type210 CFDTMID48;                                   /* CFDTMID48        */
    __type210 CFDTMPTR48;                                  /* CFDTMPTR48       */
    __type210 CFDTMFDCTR48;                                /* CFDTMFDCTR48     */
    __type210 CFDTMDF0_48;                                 /* CFDTMDF0_48      */
    __type210 CFDTMDF1_48;                                 /* CFDTMDF1_48      */
    __type210 CFDTMDF2_48;                                 /* CFDTMDF2_48      */
    __type210 CFDTMDF3_48;                                 /* CFDTMDF3_48      */
    __type210 CFDTMDF4_48;                                 /* CFDTMDF4_48      */
    __type210 CFDTMDF5_48;                                 /* CFDTMDF5_48      */
    __type210 CFDTMDF6_48;                                 /* CFDTMDF6_48      */
    __type210 CFDTMDF7_48;                                 /* CFDTMDF7_48      */
    __type210 CFDTMDF8_48;                                 /* CFDTMDF8_48      */
    __type210 CFDTMDF9_48;                                 /* CFDTMDF9_48      */
    __type210 CFDTMDF10_48;                                /* CFDTMDF10_48     */
    __type210 CFDTMDF11_48;                                /* CFDTMDF11_48     */
    __type210 CFDTMDF12_48;                                /* CFDTMDF12_48     */
    __type210 CFDTMDF13_48;                                /* CFDTMDF13_48     */
    __type210 CFDTMDF14_48;                                /* CFDTMDF14_48     */
    __type210 CFDTMDF15_48;                                /* CFDTMDF15_48     */
    uint8  dummy415[52];                                   /* Reserved         */
    __type210 CFDTMID49;                                   /* CFDTMID49        */
    __type210 CFDTMPTR49;                                  /* CFDTMPTR49       */
    __type210 CFDTMFDCTR49;                                /* CFDTMFDCTR49     */
    __type210 CFDTMDF0_49;                                 /* CFDTMDF0_49      */
    __type210 CFDTMDF1_49;                                 /* CFDTMDF1_49      */
    __type210 CFDTMDF2_49;                                 /* CFDTMDF2_49      */
    __type210 CFDTMDF3_49;                                 /* CFDTMDF3_49      */
    __type210 CFDTMDF4_49;                                 /* CFDTMDF4_49      */
    __type210 CFDTMDF5_49;                                 /* CFDTMDF5_49      */
    __type210 CFDTMDF6_49;                                 /* CFDTMDF6_49      */
    __type210 CFDTMDF7_49;                                 /* CFDTMDF7_49      */
    __type210 CFDTMDF8_49;                                 /* CFDTMDF8_49      */
    __type210 CFDTMDF9_49;                                 /* CFDTMDF9_49      */
    __type210 CFDTMDF10_49;                                /* CFDTMDF10_49     */
    __type210 CFDTMDF11_49;                                /* CFDTMDF11_49     */
    __type210 CFDTMDF12_49;                                /* CFDTMDF12_49     */
    __type210 CFDTMDF13_49;                                /* CFDTMDF13_49     */
    __type210 CFDTMDF14_49;                                /* CFDTMDF14_49     */
    __type210 CFDTMDF15_49;                                /* CFDTMDF15_49     */
    uint8  dummy416[52];                                   /* Reserved         */
    __type210 CFDTMID50;                                   /* CFDTMID50        */
    __type210 CFDTMPTR50;                                  /* CFDTMPTR50       */
    __type210 CFDTMFDCTR50;                                /* CFDTMFDCTR50     */
    __type210 CFDTMDF0_50;                                 /* CFDTMDF0_50      */
    __type210 CFDTMDF1_50;                                 /* CFDTMDF1_50      */
    __type210 CFDTMDF2_50;                                 /* CFDTMDF2_50      */
    __type210 CFDTMDF3_50;                                 /* CFDTMDF3_50      */
    __type210 CFDTMDF4_50;                                 /* CFDTMDF4_50      */
    __type210 CFDTMDF5_50;                                 /* CFDTMDF5_50      */
    __type210 CFDTMDF6_50;                                 /* CFDTMDF6_50      */
    __type210 CFDTMDF7_50;                                 /* CFDTMDF7_50      */
    __type210 CFDTMDF8_50;                                 /* CFDTMDF8_50      */
    __type210 CFDTMDF9_50;                                 /* CFDTMDF9_50      */
    __type210 CFDTMDF10_50;                                /* CFDTMDF10_50     */
    __type210 CFDTMDF11_50;                                /* CFDTMDF11_50     */
    __type210 CFDTMDF12_50;                                /* CFDTMDF12_50     */
    __type210 CFDTMDF13_50;                                /* CFDTMDF13_50     */
    __type210 CFDTMDF14_50;                                /* CFDTMDF14_50     */
    __type210 CFDTMDF15_50;                                /* CFDTMDF15_50     */
    uint8  dummy417[52];                                   /* Reserved         */
    __type210 CFDTMID51;                                   /* CFDTMID51        */
    __type210 CFDTMPTR51;                                  /* CFDTMPTR51       */
    __type210 CFDTMFDCTR51;                                /* CFDTMFDCTR51     */
    __type210 CFDTMDF0_51;                                 /* CFDTMDF0_51      */
    __type210 CFDTMDF1_51;                                 /* CFDTMDF1_51      */
    __type210 CFDTMDF2_51;                                 /* CFDTMDF2_51      */
    __type210 CFDTMDF3_51;                                 /* CFDTMDF3_51      */
    __type210 CFDTMDF4_51;                                 /* CFDTMDF4_51      */
    __type210 CFDTMDF5_51;                                 /* CFDTMDF5_51      */
    __type210 CFDTMDF6_51;                                 /* CFDTMDF6_51      */
    __type210 CFDTMDF7_51;                                 /* CFDTMDF7_51      */
    __type210 CFDTMDF8_51;                                 /* CFDTMDF8_51      */
    __type210 CFDTMDF9_51;                                 /* CFDTMDF9_51      */
    __type210 CFDTMDF10_51;                                /* CFDTMDF10_51     */
    __type210 CFDTMDF11_51;                                /* CFDTMDF11_51     */
    __type210 CFDTMDF12_51;                                /* CFDTMDF12_51     */
    __type210 CFDTMDF13_51;                                /* CFDTMDF13_51     */
    __type210 CFDTMDF14_51;                                /* CFDTMDF14_51     */
    __type210 CFDTMDF15_51;                                /* CFDTMDF15_51     */
    uint8  dummy418[52];                                   /* Reserved         */
    __type210 CFDTMID52;                                   /* CFDTMID52        */
    __type210 CFDTMPTR52;                                  /* CFDTMPTR52       */
    __type210 CFDTMFDCTR52;                                /* CFDTMFDCTR52     */
    __type210 CFDTMDF0_52;                                 /* CFDTMDF0_52      */
    __type210 CFDTMDF1_52;                                 /* CFDTMDF1_52      */
    __type210 CFDTMDF2_52;                                 /* CFDTMDF2_52      */
    __type210 CFDTMDF3_52;                                 /* CFDTMDF3_52      */
    __type210 CFDTMDF4_52;                                 /* CFDTMDF4_52      */
    __type210 CFDTMDF5_52;                                 /* CFDTMDF5_52      */
    __type210 CFDTMDF6_52;                                 /* CFDTMDF6_52      */
    __type210 CFDTMDF7_52;                                 /* CFDTMDF7_52      */
    __type210 CFDTMDF8_52;                                 /* CFDTMDF8_52      */
    __type210 CFDTMDF9_52;                                 /* CFDTMDF9_52      */
    __type210 CFDTMDF10_52;                                /* CFDTMDF10_52     */
    __type210 CFDTMDF11_52;                                /* CFDTMDF11_52     */
    __type210 CFDTMDF12_52;                                /* CFDTMDF12_52     */
    __type210 CFDTMDF13_52;                                /* CFDTMDF13_52     */
    __type210 CFDTMDF14_52;                                /* CFDTMDF14_52     */
    __type210 CFDTMDF15_52;                                /* CFDTMDF15_52     */
    uint8  dummy419[52];                                   /* Reserved         */
    __type210 CFDTMID53;                                   /* CFDTMID53        */
    __type210 CFDTMPTR53;                                  /* CFDTMPTR53       */
    __type210 CFDTMFDCTR53;                                /* CFDTMFDCTR53     */
    __type210 CFDTMDF0_53;                                 /* CFDTMDF0_53      */
    __type210 CFDTMDF1_53;                                 /* CFDTMDF1_53      */
    __type210 CFDTMDF2_53;                                 /* CFDTMDF2_53      */
    __type210 CFDTMDF3_53;                                 /* CFDTMDF3_53      */
    __type210 CFDTMDF4_53;                                 /* CFDTMDF4_53      */
    __type210 CFDTMDF5_53;                                 /* CFDTMDF5_53      */
    __type210 CFDTMDF6_53;                                 /* CFDTMDF6_53      */
    __type210 CFDTMDF7_53;                                 /* CFDTMDF7_53      */
    __type210 CFDTMDF8_53;                                 /* CFDTMDF8_53      */
    __type210 CFDTMDF9_53;                                 /* CFDTMDF9_53      */
    __type210 CFDTMDF10_53;                                /* CFDTMDF10_53     */
    __type210 CFDTMDF11_53;                                /* CFDTMDF11_53     */
    __type210 CFDTMDF12_53;                                /* CFDTMDF12_53     */
    __type210 CFDTMDF13_53;                                /* CFDTMDF13_53     */
    __type210 CFDTMDF14_53;                                /* CFDTMDF14_53     */
    __type210 CFDTMDF15_53;                                /* CFDTMDF15_53     */
    uint8  dummy420[52];                                   /* Reserved         */
    __type210 CFDTMID54;                                   /* CFDTMID54        */
    __type210 CFDTMPTR54;                                  /* CFDTMPTR54       */
    __type210 CFDTMFDCTR54;                                /* CFDTMFDCTR54     */
    __type210 CFDTMDF0_54;                                 /* CFDTMDF0_54      */
    __type210 CFDTMDF1_54;                                 /* CFDTMDF1_54      */
    __type210 CFDTMDF2_54;                                 /* CFDTMDF2_54      */
    __type210 CFDTMDF3_54;                                 /* CFDTMDF3_54      */
    __type210 CFDTMDF4_54;                                 /* CFDTMDF4_54      */
    __type210 CFDTMDF5_54;                                 /* CFDTMDF5_54      */
    __type210 CFDTMDF6_54;                                 /* CFDTMDF6_54      */
    __type210 CFDTMDF7_54;                                 /* CFDTMDF7_54      */
    __type210 CFDTMDF8_54;                                 /* CFDTMDF8_54      */
    __type210 CFDTMDF9_54;                                 /* CFDTMDF9_54      */
    __type210 CFDTMDF10_54;                                /* CFDTMDF10_54     */
    __type210 CFDTMDF11_54;                                /* CFDTMDF11_54     */
    __type210 CFDTMDF12_54;                                /* CFDTMDF12_54     */
    __type210 CFDTMDF13_54;                                /* CFDTMDF13_54     */
    __type210 CFDTMDF14_54;                                /* CFDTMDF14_54     */
    __type210 CFDTMDF15_54;                                /* CFDTMDF15_54     */
    uint8  dummy421[52];                                   /* Reserved         */
    __type210 CFDTMID55;                                   /* CFDTMID55        */
    __type210 CFDTMPTR55;                                  /* CFDTMPTR55       */
    __type210 CFDTMFDCTR55;                                /* CFDTMFDCTR55     */
    __type210 CFDTMDF0_55;                                 /* CFDTMDF0_55      */
    __type210 CFDTMDF1_55;                                 /* CFDTMDF1_55      */
    __type210 CFDTMDF2_55;                                 /* CFDTMDF2_55      */
    __type210 CFDTMDF3_55;                                 /* CFDTMDF3_55      */
    __type210 CFDTMDF4_55;                                 /* CFDTMDF4_55      */
    __type210 CFDTMDF5_55;                                 /* CFDTMDF5_55      */
    __type210 CFDTMDF6_55;                                 /* CFDTMDF6_55      */
    __type210 CFDTMDF7_55;                                 /* CFDTMDF7_55      */
    __type210 CFDTMDF8_55;                                 /* CFDTMDF8_55      */
    __type210 CFDTMDF9_55;                                 /* CFDTMDF9_55      */
    __type210 CFDTMDF10_55;                                /* CFDTMDF10_55     */
    __type210 CFDTMDF11_55;                                /* CFDTMDF11_55     */
    __type210 CFDTMDF12_55;                                /* CFDTMDF12_55     */
    __type210 CFDTMDF13_55;                                /* CFDTMDF13_55     */
    __type210 CFDTMDF14_55;                                /* CFDTMDF14_55     */
    __type210 CFDTMDF15_55;                                /* CFDTMDF15_55     */
    uint8  dummy422[52];                                   /* Reserved         */
    __type210 CFDTMID56;                                   /* CFDTMID56        */
    __type210 CFDTMPTR56;                                  /* CFDTMPTR56       */
    __type210 CFDTMFDCTR56;                                /* CFDTMFDCTR56     */
    __type210 CFDTMDF0_56;                                 /* CFDTMDF0_56      */
    __type210 CFDTMDF1_56;                                 /* CFDTMDF1_56      */
    __type210 CFDTMDF2_56;                                 /* CFDTMDF2_56      */
    __type210 CFDTMDF3_56;                                 /* CFDTMDF3_56      */
    __type210 CFDTMDF4_56;                                 /* CFDTMDF4_56      */
    __type210 CFDTMDF5_56;                                 /* CFDTMDF5_56      */
    __type210 CFDTMDF6_56;                                 /* CFDTMDF6_56      */
    __type210 CFDTMDF7_56;                                 /* CFDTMDF7_56      */
    __type210 CFDTMDF8_56;                                 /* CFDTMDF8_56      */
    __type210 CFDTMDF9_56;                                 /* CFDTMDF9_56      */
    __type210 CFDTMDF10_56;                                /* CFDTMDF10_56     */
    __type210 CFDTMDF11_56;                                /* CFDTMDF11_56     */
    __type210 CFDTMDF12_56;                                /* CFDTMDF12_56     */
    __type210 CFDTMDF13_56;                                /* CFDTMDF13_56     */
    __type210 CFDTMDF14_56;                                /* CFDTMDF14_56     */
    __type210 CFDTMDF15_56;                                /* CFDTMDF15_56     */
    uint8  dummy423[52];                                   /* Reserved         */
    __type210 CFDTMID57;                                   /* CFDTMID57        */
    __type210 CFDTMPTR57;                                  /* CFDTMPTR57       */
    __type210 CFDTMFDCTR57;                                /* CFDTMFDCTR57     */
    __type210 CFDTMDF0_57;                                 /* CFDTMDF0_57      */
    __type210 CFDTMDF1_57;                                 /* CFDTMDF1_57      */
    __type210 CFDTMDF2_57;                                 /* CFDTMDF2_57      */
    __type210 CFDTMDF3_57;                                 /* CFDTMDF3_57      */
    __type210 CFDTMDF4_57;                                 /* CFDTMDF4_57      */
    __type210 CFDTMDF5_57;                                 /* CFDTMDF5_57      */
    __type210 CFDTMDF6_57;                                 /* CFDTMDF6_57      */
    __type210 CFDTMDF7_57;                                 /* CFDTMDF7_57      */
    __type210 CFDTMDF8_57;                                 /* CFDTMDF8_57      */
    __type210 CFDTMDF9_57;                                 /* CFDTMDF9_57      */
    __type210 CFDTMDF10_57;                                /* CFDTMDF10_57     */
    __type210 CFDTMDF11_57;                                /* CFDTMDF11_57     */
    __type210 CFDTMDF12_57;                                /* CFDTMDF12_57     */
    __type210 CFDTMDF13_57;                                /* CFDTMDF13_57     */
    __type210 CFDTMDF14_57;                                /* CFDTMDF14_57     */
    __type210 CFDTMDF15_57;                                /* CFDTMDF15_57     */
    uint8  dummy424[52];                                   /* Reserved         */
    __type210 CFDTMID58;                                   /* CFDTMID58        */
    __type210 CFDTMPTR58;                                  /* CFDTMPTR58       */
    __type210 CFDTMFDCTR58;                                /* CFDTMFDCTR58     */
    __type210 CFDTMDF0_58;                                 /* CFDTMDF0_58      */
    __type210 CFDTMDF1_58;                                 /* CFDTMDF1_58      */
    __type210 CFDTMDF2_58;                                 /* CFDTMDF2_58      */
    __type210 CFDTMDF3_58;                                 /* CFDTMDF3_58      */
    __type210 CFDTMDF4_58;                                 /* CFDTMDF4_58      */
    __type210 CFDTMDF5_58;                                 /* CFDTMDF5_58      */
    __type210 CFDTMDF6_58;                                 /* CFDTMDF6_58      */
    __type210 CFDTMDF7_58;                                 /* CFDTMDF7_58      */
    __type210 CFDTMDF8_58;                                 /* CFDTMDF8_58      */
    __type210 CFDTMDF9_58;                                 /* CFDTMDF9_58      */
    __type210 CFDTMDF10_58;                                /* CFDTMDF10_58     */
    __type210 CFDTMDF11_58;                                /* CFDTMDF11_58     */
    __type210 CFDTMDF12_58;                                /* CFDTMDF12_58     */
    __type210 CFDTMDF13_58;                                /* CFDTMDF13_58     */
    __type210 CFDTMDF14_58;                                /* CFDTMDF14_58     */
    __type210 CFDTMDF15_58;                                /* CFDTMDF15_58     */
    uint8  dummy425[52];                                   /* Reserved         */
    __type210 CFDTMID59;                                   /* CFDTMID59        */
    __type210 CFDTMPTR59;                                  /* CFDTMPTR59       */
    __type210 CFDTMFDCTR59;                                /* CFDTMFDCTR59     */
    __type210 CFDTMDF0_59;                                 /* CFDTMDF0_59      */
    __type210 CFDTMDF1_59;                                 /* CFDTMDF1_59      */
    __type210 CFDTMDF2_59;                                 /* CFDTMDF2_59      */
    __type210 CFDTMDF3_59;                                 /* CFDTMDF3_59      */
    __type210 CFDTMDF4_59;                                 /* CFDTMDF4_59      */
    __type210 CFDTMDF5_59;                                 /* CFDTMDF5_59      */
    __type210 CFDTMDF6_59;                                 /* CFDTMDF6_59      */
    __type210 CFDTMDF7_59;                                 /* CFDTMDF7_59      */
    __type210 CFDTMDF8_59;                                 /* CFDTMDF8_59      */
    __type210 CFDTMDF9_59;                                 /* CFDTMDF9_59      */
    __type210 CFDTMDF10_59;                                /* CFDTMDF10_59     */
    __type210 CFDTMDF11_59;                                /* CFDTMDF11_59     */
    __type210 CFDTMDF12_59;                                /* CFDTMDF12_59     */
    __type210 CFDTMDF13_59;                                /* CFDTMDF13_59     */
    __type210 CFDTMDF14_59;                                /* CFDTMDF14_59     */
    __type210 CFDTMDF15_59;                                /* CFDTMDF15_59     */
    uint8  dummy426[52];                                   /* Reserved         */
    __type210 CFDTMID60;                                   /* CFDTMID60        */
    __type210 CFDTMPTR60;                                  /* CFDTMPTR60       */
    __type210 CFDTMFDCTR60;                                /* CFDTMFDCTR60     */
    __type210 CFDTMDF0_60;                                 /* CFDTMDF0_60      */
    __type210 CFDTMDF1_60;                                 /* CFDTMDF1_60      */
    __type210 CFDTMDF2_60;                                 /* CFDTMDF2_60      */
    __type210 CFDTMDF3_60;                                 /* CFDTMDF3_60      */
    __type210 CFDTMDF4_60;                                 /* CFDTMDF4_60      */
    __type210 CFDTMDF5_60;                                 /* CFDTMDF5_60      */
    __type210 CFDTMDF6_60;                                 /* CFDTMDF6_60      */
    __type210 CFDTMDF7_60;                                 /* CFDTMDF7_60      */
    __type210 CFDTMDF8_60;                                 /* CFDTMDF8_60      */
    __type210 CFDTMDF9_60;                                 /* CFDTMDF9_60      */
    __type210 CFDTMDF10_60;                                /* CFDTMDF10_60     */
    __type210 CFDTMDF11_60;                                /* CFDTMDF11_60     */
    __type210 CFDTMDF12_60;                                /* CFDTMDF12_60     */
    __type210 CFDTMDF13_60;                                /* CFDTMDF13_60     */
    __type210 CFDTMDF14_60;                                /* CFDTMDF14_60     */
    __type210 CFDTMDF15_60;                                /* CFDTMDF15_60     */
    uint8  dummy427[52];                                   /* Reserved         */
    __type210 CFDTMID61;                                   /* CFDTMID61        */
    __type210 CFDTMPTR61;                                  /* CFDTMPTR61       */
    __type210 CFDTMFDCTR61;                                /* CFDTMFDCTR61     */
    __type210 CFDTMDF0_61;                                 /* CFDTMDF0_61      */
    __type210 CFDTMDF1_61;                                 /* CFDTMDF1_61      */
    __type210 CFDTMDF2_61;                                 /* CFDTMDF2_61      */
    __type210 CFDTMDF3_61;                                 /* CFDTMDF3_61      */
    __type210 CFDTMDF4_61;                                 /* CFDTMDF4_61      */
    __type210 CFDTMDF5_61;                                 /* CFDTMDF5_61      */
    __type210 CFDTMDF6_61;                                 /* CFDTMDF6_61      */
    __type210 CFDTMDF7_61;                                 /* CFDTMDF7_61      */
    __type210 CFDTMDF8_61;                                 /* CFDTMDF8_61      */
    __type210 CFDTMDF9_61;                                 /* CFDTMDF9_61      */
    __type210 CFDTMDF10_61;                                /* CFDTMDF10_61     */
    __type210 CFDTMDF11_61;                                /* CFDTMDF11_61     */
    __type210 CFDTMDF12_61;                                /* CFDTMDF12_61     */
    __type210 CFDTMDF13_61;                                /* CFDTMDF13_61     */
    __type210 CFDTMDF14_61;                                /* CFDTMDF14_61     */
    __type210 CFDTMDF15_61;                                /* CFDTMDF15_61     */
    uint8  dummy428[52];                                   /* Reserved         */
    __type210 CFDTMID62;                                   /* CFDTMID62        */
    __type210 CFDTMPTR62;                                  /* CFDTMPTR62       */
    __type210 CFDTMFDCTR62;                                /* CFDTMFDCTR62     */
    __type210 CFDTMDF0_62;                                 /* CFDTMDF0_62      */
    __type210 CFDTMDF1_62;                                 /* CFDTMDF1_62      */
    __type210 CFDTMDF2_62;                                 /* CFDTMDF2_62      */
    __type210 CFDTMDF3_62;                                 /* CFDTMDF3_62      */
    __type210 CFDTMDF4_62;                                 /* CFDTMDF4_62      */
    __type210 CFDTMDF5_62;                                 /* CFDTMDF5_62      */
    __type210 CFDTMDF6_62;                                 /* CFDTMDF6_62      */
    __type210 CFDTMDF7_62;                                 /* CFDTMDF7_62      */
    __type210 CFDTMDF8_62;                                 /* CFDTMDF8_62      */
    __type210 CFDTMDF9_62;                                 /* CFDTMDF9_62      */
    __type210 CFDTMDF10_62;                                /* CFDTMDF10_62     */
    __type210 CFDTMDF11_62;                                /* CFDTMDF11_62     */
    __type210 CFDTMDF12_62;                                /* CFDTMDF12_62     */
    __type210 CFDTMDF13_62;                                /* CFDTMDF13_62     */
    __type210 CFDTMDF14_62;                                /* CFDTMDF14_62     */
    __type210 CFDTMDF15_62;                                /* CFDTMDF15_62     */
    uint8  dummy429[52];                                   /* Reserved         */
    __type210 CFDTMID63;                                   /* CFDTMID63        */
    __type210 CFDTMPTR63;                                  /* CFDTMPTR63       */
    __type210 CFDTMFDCTR63;                                /* CFDTMFDCTR63     */
    __type210 CFDTMDF0_63;                                 /* CFDTMDF0_63      */
    __type210 CFDTMDF1_63;                                 /* CFDTMDF1_63      */
    __type210 CFDTMDF2_63;                                 /* CFDTMDF2_63      */
    __type210 CFDTMDF3_63;                                 /* CFDTMDF3_63      */
    __type210 CFDTMDF4_63;                                 /* CFDTMDF4_63      */
    __type210 CFDTMDF5_63;                                 /* CFDTMDF5_63      */
    __type210 CFDTMDF6_63;                                 /* CFDTMDF6_63      */
    __type210 CFDTMDF7_63;                                 /* CFDTMDF7_63      */
    __type210 CFDTMDF8_63;                                 /* CFDTMDF8_63      */
    __type210 CFDTMDF9_63;                                 /* CFDTMDF9_63      */
    __type210 CFDTMDF10_63;                                /* CFDTMDF10_63     */
    __type210 CFDTMDF11_63;                                /* CFDTMDF11_63     */
    __type210 CFDTMDF12_63;                                /* CFDTMDF12_63     */
    __type210 CFDTMDF13_63;                                /* CFDTMDF13_63     */
    __type210 CFDTMDF14_63;                                /* CFDTMDF14_63     */
    __type210 CFDTMDF15_63;                                /* CFDTMDF15_63     */
    uint8  dummy430[52];                                   /* Reserved         */
    __type210 CFDTMID64;                                   /* CFDTMID64        */
    __type210 CFDTMPTR64;                                  /* CFDTMPTR64       */
    __type210 CFDTMFDCTR64;                                /* CFDTMFDCTR64     */
    __type210 CFDTMDF0_64;                                 /* CFDTMDF0_64      */
    __type210 CFDTMDF1_64;                                 /* CFDTMDF1_64      */
    __type210 CFDTMDF2_64;                                 /* CFDTMDF2_64      */
    __type210 CFDTMDF3_64;                                 /* CFDTMDF3_64      */
    __type210 CFDTMDF4_64;                                 /* CFDTMDF4_64      */
    __type210 CFDTMDF5_64;                                 /* CFDTMDF5_64      */
    __type210 CFDTMDF6_64;                                 /* CFDTMDF6_64      */
    __type210 CFDTMDF7_64;                                 /* CFDTMDF7_64      */
    __type210 CFDTMDF8_64;                                 /* CFDTMDF8_64      */
    __type210 CFDTMDF9_64;                                 /* CFDTMDF9_64      */
    __type210 CFDTMDF10_64;                                /* CFDTMDF10_64     */
    __type210 CFDTMDF11_64;                                /* CFDTMDF11_64     */
    __type210 CFDTMDF12_64;                                /* CFDTMDF12_64     */
    __type210 CFDTMDF13_64;                                /* CFDTMDF13_64     */
    __type210 CFDTMDF14_64;                                /* CFDTMDF14_64     */
    __type210 CFDTMDF15_64;                                /* CFDTMDF15_64     */
    uint8  dummy431[52];                                   /* Reserved         */
    __type210 CFDTMID65;                                   /* CFDTMID65        */
    __type210 CFDTMPTR65;                                  /* CFDTMPTR65       */
    __type210 CFDTMFDCTR65;                                /* CFDTMFDCTR65     */
    __type210 CFDTMDF0_65;                                 /* CFDTMDF0_65      */
    __type210 CFDTMDF1_65;                                 /* CFDTMDF1_65      */
    __type210 CFDTMDF2_65;                                 /* CFDTMDF2_65      */
    __type210 CFDTMDF3_65;                                 /* CFDTMDF3_65      */
    __type210 CFDTMDF4_65;                                 /* CFDTMDF4_65      */
    __type210 CFDTMDF5_65;                                 /* CFDTMDF5_65      */
    __type210 CFDTMDF6_65;                                 /* CFDTMDF6_65      */
    __type210 CFDTMDF7_65;                                 /* CFDTMDF7_65      */
    __type210 CFDTMDF8_65;                                 /* CFDTMDF8_65      */
    __type210 CFDTMDF9_65;                                 /* CFDTMDF9_65      */
    __type210 CFDTMDF10_65;                                /* CFDTMDF10_65     */
    __type210 CFDTMDF11_65;                                /* CFDTMDF11_65     */
    __type210 CFDTMDF12_65;                                /* CFDTMDF12_65     */
    __type210 CFDTMDF13_65;                                /* CFDTMDF13_65     */
    __type210 CFDTMDF14_65;                                /* CFDTMDF14_65     */
    __type210 CFDTMDF15_65;                                /* CFDTMDF15_65     */
    uint8  dummy432[52];                                   /* Reserved         */
    __type210 CFDTMID66;                                   /* CFDTMID66        */
    __type210 CFDTMPTR66;                                  /* CFDTMPTR66       */
    __type210 CFDTMFDCTR66;                                /* CFDTMFDCTR66     */
    __type210 CFDTMDF0_66;                                 /* CFDTMDF0_66      */
    __type210 CFDTMDF1_66;                                 /* CFDTMDF1_66      */
    __type210 CFDTMDF2_66;                                 /* CFDTMDF2_66      */
    __type210 CFDTMDF3_66;                                 /* CFDTMDF3_66      */
    __type210 CFDTMDF4_66;                                 /* CFDTMDF4_66      */
    __type210 CFDTMDF5_66;                                 /* CFDTMDF5_66      */
    __type210 CFDTMDF6_66;                                 /* CFDTMDF6_66      */
    __type210 CFDTMDF7_66;                                 /* CFDTMDF7_66      */
    __type210 CFDTMDF8_66;                                 /* CFDTMDF8_66      */
    __type210 CFDTMDF9_66;                                 /* CFDTMDF9_66      */
    __type210 CFDTMDF10_66;                                /* CFDTMDF10_66     */
    __type210 CFDTMDF11_66;                                /* CFDTMDF11_66     */
    __type210 CFDTMDF12_66;                                /* CFDTMDF12_66     */
    __type210 CFDTMDF13_66;                                /* CFDTMDF13_66     */
    __type210 CFDTMDF14_66;                                /* CFDTMDF14_66     */
    __type210 CFDTMDF15_66;                                /* CFDTMDF15_66     */
    uint8  dummy433[52];                                   /* Reserved         */
    __type210 CFDTMID67;                                   /* CFDTMID67        */
    __type210 CFDTMPTR67;                                  /* CFDTMPTR67       */
    __type210 CFDTMFDCTR67;                                /* CFDTMFDCTR67     */
    __type210 CFDTMDF0_67;                                 /* CFDTMDF0_67      */
    __type210 CFDTMDF1_67;                                 /* CFDTMDF1_67      */
    __type210 CFDTMDF2_67;                                 /* CFDTMDF2_67      */
    __type210 CFDTMDF3_67;                                 /* CFDTMDF3_67      */
    __type210 CFDTMDF4_67;                                 /* CFDTMDF4_67      */
    __type210 CFDTMDF5_67;                                 /* CFDTMDF5_67      */
    __type210 CFDTMDF6_67;                                 /* CFDTMDF6_67      */
    __type210 CFDTMDF7_67;                                 /* CFDTMDF7_67      */
    __type210 CFDTMDF8_67;                                 /* CFDTMDF8_67      */
    __type210 CFDTMDF9_67;                                 /* CFDTMDF9_67      */
    __type210 CFDTMDF10_67;                                /* CFDTMDF10_67     */
    __type210 CFDTMDF11_67;                                /* CFDTMDF11_67     */
    __type210 CFDTMDF12_67;                                /* CFDTMDF12_67     */
    __type210 CFDTMDF13_67;                                /* CFDTMDF13_67     */
    __type210 CFDTMDF14_67;                                /* CFDTMDF14_67     */
    __type210 CFDTMDF15_67;                                /* CFDTMDF15_67     */
    uint8  dummy434[52];                                   /* Reserved         */
    __type210 CFDTMID68;                                   /* CFDTMID68        */
    __type210 CFDTMPTR68;                                  /* CFDTMPTR68       */
    __type210 CFDTMFDCTR68;                                /* CFDTMFDCTR68     */
    __type210 CFDTMDF0_68;                                 /* CFDTMDF0_68      */
    __type210 CFDTMDF1_68;                                 /* CFDTMDF1_68      */
    __type210 CFDTMDF2_68;                                 /* CFDTMDF2_68      */
    __type210 CFDTMDF3_68;                                 /* CFDTMDF3_68      */
    __type210 CFDTMDF4_68;                                 /* CFDTMDF4_68      */
    __type210 CFDTMDF5_68;                                 /* CFDTMDF5_68      */
    __type210 CFDTMDF6_68;                                 /* CFDTMDF6_68      */
    __type210 CFDTMDF7_68;                                 /* CFDTMDF7_68      */
    __type210 CFDTMDF8_68;                                 /* CFDTMDF8_68      */
    __type210 CFDTMDF9_68;                                 /* CFDTMDF9_68      */
    __type210 CFDTMDF10_68;                                /* CFDTMDF10_68     */
    __type210 CFDTMDF11_68;                                /* CFDTMDF11_68     */
    __type210 CFDTMDF12_68;                                /* CFDTMDF12_68     */
    __type210 CFDTMDF13_68;                                /* CFDTMDF13_68     */
    __type210 CFDTMDF14_68;                                /* CFDTMDF14_68     */
    __type210 CFDTMDF15_68;                                /* CFDTMDF15_68     */
    uint8  dummy435[52];                                   /* Reserved         */
    __type210 CFDTMID69;                                   /* CFDTMID69        */
    __type210 CFDTMPTR69;                                  /* CFDTMPTR69       */
    __type210 CFDTMFDCTR69;                                /* CFDTMFDCTR69     */
    __type210 CFDTMDF0_69;                                 /* CFDTMDF0_69      */
    __type210 CFDTMDF1_69;                                 /* CFDTMDF1_69      */
    __type210 CFDTMDF2_69;                                 /* CFDTMDF2_69      */
    __type210 CFDTMDF3_69;                                 /* CFDTMDF3_69      */
    __type210 CFDTMDF4_69;                                 /* CFDTMDF4_69      */
    __type210 CFDTMDF5_69;                                 /* CFDTMDF5_69      */
    __type210 CFDTMDF6_69;                                 /* CFDTMDF6_69      */
    __type210 CFDTMDF7_69;                                 /* CFDTMDF7_69      */
    __type210 CFDTMDF8_69;                                 /* CFDTMDF8_69      */
    __type210 CFDTMDF9_69;                                 /* CFDTMDF9_69      */
    __type210 CFDTMDF10_69;                                /* CFDTMDF10_69     */
    __type210 CFDTMDF11_69;                                /* CFDTMDF11_69     */
    __type210 CFDTMDF12_69;                                /* CFDTMDF12_69     */
    __type210 CFDTMDF13_69;                                /* CFDTMDF13_69     */
    __type210 CFDTMDF14_69;                                /* CFDTMDF14_69     */
    __type210 CFDTMDF15_69;                                /* CFDTMDF15_69     */
    uint8  dummy436[52];                                   /* Reserved         */
    __type210 CFDTMID70;                                   /* CFDTMID70        */
    __type210 CFDTMPTR70;                                  /* CFDTMPTR70       */
    __type210 CFDTMFDCTR70;                                /* CFDTMFDCTR70     */
    __type210 CFDTMDF0_70;                                 /* CFDTMDF0_70      */
    __type210 CFDTMDF1_70;                                 /* CFDTMDF1_70      */
    __type210 CFDTMDF2_70;                                 /* CFDTMDF2_70      */
    __type210 CFDTMDF3_70;                                 /* CFDTMDF3_70      */
    __type210 CFDTMDF4_70;                                 /* CFDTMDF4_70      */
    __type210 CFDTMDF5_70;                                 /* CFDTMDF5_70      */
    __type210 CFDTMDF6_70;                                 /* CFDTMDF6_70      */
    __type210 CFDTMDF7_70;                                 /* CFDTMDF7_70      */
    __type210 CFDTMDF8_70;                                 /* CFDTMDF8_70      */
    __type210 CFDTMDF9_70;                                 /* CFDTMDF9_70      */
    __type210 CFDTMDF10_70;                                /* CFDTMDF10_70     */
    __type210 CFDTMDF11_70;                                /* CFDTMDF11_70     */
    __type210 CFDTMDF12_70;                                /* CFDTMDF12_70     */
    __type210 CFDTMDF13_70;                                /* CFDTMDF13_70     */
    __type210 CFDTMDF14_70;                                /* CFDTMDF14_70     */
    __type210 CFDTMDF15_70;                                /* CFDTMDF15_70     */
    uint8  dummy437[52];                                   /* Reserved         */
    __type210 CFDTMID71;                                   /* CFDTMID71        */
    __type210 CFDTMPTR71;                                  /* CFDTMPTR71       */
    __type210 CFDTMFDCTR71;                                /* CFDTMFDCTR71     */
    __type210 CFDTMDF0_71;                                 /* CFDTMDF0_71      */
    __type210 CFDTMDF1_71;                                 /* CFDTMDF1_71      */
    __type210 CFDTMDF2_71;                                 /* CFDTMDF2_71      */
    __type210 CFDTMDF3_71;                                 /* CFDTMDF3_71      */
    __type210 CFDTMDF4_71;                                 /* CFDTMDF4_71      */
    __type210 CFDTMDF5_71;                                 /* CFDTMDF5_71      */
    __type210 CFDTMDF6_71;                                 /* CFDTMDF6_71      */
    __type210 CFDTMDF7_71;                                 /* CFDTMDF7_71      */
    __type210 CFDTMDF8_71;                                 /* CFDTMDF8_71      */
    __type210 CFDTMDF9_71;                                 /* CFDTMDF9_71      */
    __type210 CFDTMDF10_71;                                /* CFDTMDF10_71     */
    __type210 CFDTMDF11_71;                                /* CFDTMDF11_71     */
    __type210 CFDTMDF12_71;                                /* CFDTMDF12_71     */
    __type210 CFDTMDF13_71;                                /* CFDTMDF13_71     */
    __type210 CFDTMDF14_71;                                /* CFDTMDF14_71     */
    __type210 CFDTMDF15_71;                                /* CFDTMDF15_71     */
    uint8  dummy438[52];                                   /* Reserved         */
    __type210 CFDTMID72;                                   /* CFDTMID72        */
    __type210 CFDTMPTR72;                                  /* CFDTMPTR72       */
    __type210 CFDTMFDCTR72;                                /* CFDTMFDCTR72     */
    __type210 CFDTMDF0_72;                                 /* CFDTMDF0_72      */
    __type210 CFDTMDF1_72;                                 /* CFDTMDF1_72      */
    __type210 CFDTMDF2_72;                                 /* CFDTMDF2_72      */
    __type210 CFDTMDF3_72;                                 /* CFDTMDF3_72      */
    __type210 CFDTMDF4_72;                                 /* CFDTMDF4_72      */
    __type210 CFDTMDF5_72;                                 /* CFDTMDF5_72      */
    __type210 CFDTMDF6_72;                                 /* CFDTMDF6_72      */
    __type210 CFDTMDF7_72;                                 /* CFDTMDF7_72      */
    __type210 CFDTMDF8_72;                                 /* CFDTMDF8_72      */
    __type210 CFDTMDF9_72;                                 /* CFDTMDF9_72      */
    __type210 CFDTMDF10_72;                                /* CFDTMDF10_72     */
    __type210 CFDTMDF11_72;                                /* CFDTMDF11_72     */
    __type210 CFDTMDF12_72;                                /* CFDTMDF12_72     */
    __type210 CFDTMDF13_72;                                /* CFDTMDF13_72     */
    __type210 CFDTMDF14_72;                                /* CFDTMDF14_72     */
    __type210 CFDTMDF15_72;                                /* CFDTMDF15_72     */
    uint8  dummy439[52];                                   /* Reserved         */
    __type210 CFDTMID73;                                   /* CFDTMID73        */
    __type210 CFDTMPTR73;                                  /* CFDTMPTR73       */
    __type210 CFDTMFDCTR73;                                /* CFDTMFDCTR73     */
    __type210 CFDTMDF0_73;                                 /* CFDTMDF0_73      */
    __type210 CFDTMDF1_73;                                 /* CFDTMDF1_73      */
    __type210 CFDTMDF2_73;                                 /* CFDTMDF2_73      */
    __type210 CFDTMDF3_73;                                 /* CFDTMDF3_73      */
    __type210 CFDTMDF4_73;                                 /* CFDTMDF4_73      */
    __type210 CFDTMDF5_73;                                 /* CFDTMDF5_73      */
    __type210 CFDTMDF6_73;                                 /* CFDTMDF6_73      */
    __type210 CFDTMDF7_73;                                 /* CFDTMDF7_73      */
    __type210 CFDTMDF8_73;                                 /* CFDTMDF8_73      */
    __type210 CFDTMDF9_73;                                 /* CFDTMDF9_73      */
    __type210 CFDTMDF10_73;                                /* CFDTMDF10_73     */
    __type210 CFDTMDF11_73;                                /* CFDTMDF11_73     */
    __type210 CFDTMDF12_73;                                /* CFDTMDF12_73     */
    __type210 CFDTMDF13_73;                                /* CFDTMDF13_73     */
    __type210 CFDTMDF14_73;                                /* CFDTMDF14_73     */
    __type210 CFDTMDF15_73;                                /* CFDTMDF15_73     */
    uint8  dummy440[52];                                   /* Reserved         */
    __type210 CFDTMID74;                                   /* CFDTMID74        */
    __type210 CFDTMPTR74;                                  /* CFDTMPTR74       */
    __type210 CFDTMFDCTR74;                                /* CFDTMFDCTR74     */
    __type210 CFDTMDF0_74;                                 /* CFDTMDF0_74      */
    __type210 CFDTMDF1_74;                                 /* CFDTMDF1_74      */
    __type210 CFDTMDF2_74;                                 /* CFDTMDF2_74      */
    __type210 CFDTMDF3_74;                                 /* CFDTMDF3_74      */
    __type210 CFDTMDF4_74;                                 /* CFDTMDF4_74      */
    __type210 CFDTMDF5_74;                                 /* CFDTMDF5_74      */
    __type210 CFDTMDF6_74;                                 /* CFDTMDF6_74      */
    __type210 CFDTMDF7_74;                                 /* CFDTMDF7_74      */
    __type210 CFDTMDF8_74;                                 /* CFDTMDF8_74      */
    __type210 CFDTMDF9_74;                                 /* CFDTMDF9_74      */
    __type210 CFDTMDF10_74;                                /* CFDTMDF10_74     */
    __type210 CFDTMDF11_74;                                /* CFDTMDF11_74     */
    __type210 CFDTMDF12_74;                                /* CFDTMDF12_74     */
    __type210 CFDTMDF13_74;                                /* CFDTMDF13_74     */
    __type210 CFDTMDF14_74;                                /* CFDTMDF14_74     */
    __type210 CFDTMDF15_74;                                /* CFDTMDF15_74     */
    uint8  dummy441[52];                                   /* Reserved         */
    __type210 CFDTMID75;                                   /* CFDTMID75        */
    __type210 CFDTMPTR75;                                  /* CFDTMPTR75       */
    __type210 CFDTMFDCTR75;                                /* CFDTMFDCTR75     */
    __type210 CFDTMDF0_75;                                 /* CFDTMDF0_75      */
    __type210 CFDTMDF1_75;                                 /* CFDTMDF1_75      */
    __type210 CFDTMDF2_75;                                 /* CFDTMDF2_75      */
    __type210 CFDTMDF3_75;                                 /* CFDTMDF3_75      */
    __type210 CFDTMDF4_75;                                 /* CFDTMDF4_75      */
    __type210 CFDTMDF5_75;                                 /* CFDTMDF5_75      */
    __type210 CFDTMDF6_75;                                 /* CFDTMDF6_75      */
    __type210 CFDTMDF7_75;                                 /* CFDTMDF7_75      */
    __type210 CFDTMDF8_75;                                 /* CFDTMDF8_75      */
    __type210 CFDTMDF9_75;                                 /* CFDTMDF9_75      */
    __type210 CFDTMDF10_75;                                /* CFDTMDF10_75     */
    __type210 CFDTMDF11_75;                                /* CFDTMDF11_75     */
    __type210 CFDTMDF12_75;                                /* CFDTMDF12_75     */
    __type210 CFDTMDF13_75;                                /* CFDTMDF13_75     */
    __type210 CFDTMDF14_75;                                /* CFDTMDF14_75     */
    __type210 CFDTMDF15_75;                                /* CFDTMDF15_75     */
    uint8  dummy442[52];                                   /* Reserved         */
    __type210 CFDTMID76;                                   /* CFDTMID76        */
    __type210 CFDTMPTR76;                                  /* CFDTMPTR76       */
    __type210 CFDTMFDCTR76;                                /* CFDTMFDCTR76     */
    __type210 CFDTMDF0_76;                                 /* CFDTMDF0_76      */
    __type210 CFDTMDF1_76;                                 /* CFDTMDF1_76      */
    __type210 CFDTMDF2_76;                                 /* CFDTMDF2_76      */
    __type210 CFDTMDF3_76;                                 /* CFDTMDF3_76      */
    __type210 CFDTMDF4_76;                                 /* CFDTMDF4_76      */
    __type210 CFDTMDF5_76;                                 /* CFDTMDF5_76      */
    __type210 CFDTMDF6_76;                                 /* CFDTMDF6_76      */
    __type210 CFDTMDF7_76;                                 /* CFDTMDF7_76      */
    __type210 CFDTMDF8_76;                                 /* CFDTMDF8_76      */
    __type210 CFDTMDF9_76;                                 /* CFDTMDF9_76      */
    __type210 CFDTMDF10_76;                                /* CFDTMDF10_76     */
    __type210 CFDTMDF11_76;                                /* CFDTMDF11_76     */
    __type210 CFDTMDF12_76;                                /* CFDTMDF12_76     */
    __type210 CFDTMDF13_76;                                /* CFDTMDF13_76     */
    __type210 CFDTMDF14_76;                                /* CFDTMDF14_76     */
    __type210 CFDTMDF15_76;                                /* CFDTMDF15_76     */
    uint8  dummy443[52];                                   /* Reserved         */
    __type210 CFDTMID77;                                   /* CFDTMID77        */
    __type210 CFDTMPTR77;                                  /* CFDTMPTR77       */
    __type210 CFDTMFDCTR77;                                /* CFDTMFDCTR77     */
    __type210 CFDTMDF0_77;                                 /* CFDTMDF0_77      */
    __type210 CFDTMDF1_77;                                 /* CFDTMDF1_77      */
    __type210 CFDTMDF2_77;                                 /* CFDTMDF2_77      */
    __type210 CFDTMDF3_77;                                 /* CFDTMDF3_77      */
    __type210 CFDTMDF4_77;                                 /* CFDTMDF4_77      */
    __type210 CFDTMDF5_77;                                 /* CFDTMDF5_77      */
    __type210 CFDTMDF6_77;                                 /* CFDTMDF6_77      */
    __type210 CFDTMDF7_77;                                 /* CFDTMDF7_77      */
    __type210 CFDTMDF8_77;                                 /* CFDTMDF8_77      */
    __type210 CFDTMDF9_77;                                 /* CFDTMDF9_77      */
    __type210 CFDTMDF10_77;                                /* CFDTMDF10_77     */
    __type210 CFDTMDF11_77;                                /* CFDTMDF11_77     */
    __type210 CFDTMDF12_77;                                /* CFDTMDF12_77     */
    __type210 CFDTMDF13_77;                                /* CFDTMDF13_77     */
    __type210 CFDTMDF14_77;                                /* CFDTMDF14_77     */
    __type210 CFDTMDF15_77;                                /* CFDTMDF15_77     */
    uint8  dummy444[52];                                   /* Reserved         */
    __type210 CFDTMID78;                                   /* CFDTMID78        */
    __type210 CFDTMPTR78;                                  /* CFDTMPTR78       */
    __type210 CFDTMFDCTR78;                                /* CFDTMFDCTR78     */
    __type210 CFDTMDF0_78;                                 /* CFDTMDF0_78      */
    __type210 CFDTMDF1_78;                                 /* CFDTMDF1_78      */
    __type210 CFDTMDF2_78;                                 /* CFDTMDF2_78      */
    __type210 CFDTMDF3_78;                                 /* CFDTMDF3_78      */
    __type210 CFDTMDF4_78;                                 /* CFDTMDF4_78      */
    __type210 CFDTMDF5_78;                                 /* CFDTMDF5_78      */
    __type210 CFDTMDF6_78;                                 /* CFDTMDF6_78      */
    __type210 CFDTMDF7_78;                                 /* CFDTMDF7_78      */
    __type210 CFDTMDF8_78;                                 /* CFDTMDF8_78      */
    __type210 CFDTMDF9_78;                                 /* CFDTMDF9_78      */
    __type210 CFDTMDF10_78;                                /* CFDTMDF10_78     */
    __type210 CFDTMDF11_78;                                /* CFDTMDF11_78     */
    __type210 CFDTMDF12_78;                                /* CFDTMDF12_78     */
    __type210 CFDTMDF13_78;                                /* CFDTMDF13_78     */
    __type210 CFDTMDF14_78;                                /* CFDTMDF14_78     */
    __type210 CFDTMDF15_78;                                /* CFDTMDF15_78     */
    uint8  dummy445[52];                                   /* Reserved         */
    __type210 CFDTMID79;                                   /* CFDTMID79        */
    __type210 CFDTMPTR79;                                  /* CFDTMPTR79       */
    __type210 CFDTMFDCTR79;                                /* CFDTMFDCTR79     */
    __type210 CFDTMDF0_79;                                 /* CFDTMDF0_79      */
    __type210 CFDTMDF1_79;                                 /* CFDTMDF1_79      */
    __type210 CFDTMDF2_79;                                 /* CFDTMDF2_79      */
    __type210 CFDTMDF3_79;                                 /* CFDTMDF3_79      */
    __type210 CFDTMDF4_79;                                 /* CFDTMDF4_79      */
    __type210 CFDTMDF5_79;                                 /* CFDTMDF5_79      */
    __type210 CFDTMDF6_79;                                 /* CFDTMDF6_79      */
    __type210 CFDTMDF7_79;                                 /* CFDTMDF7_79      */
    __type210 CFDTMDF8_79;                                 /* CFDTMDF8_79      */
    __type210 CFDTMDF9_79;                                 /* CFDTMDF9_79      */
    __type210 CFDTMDF10_79;                                /* CFDTMDF10_79     */
    __type210 CFDTMDF11_79;                                /* CFDTMDF11_79     */
    __type210 CFDTMDF12_79;                                /* CFDTMDF12_79     */
    __type210 CFDTMDF13_79;                                /* CFDTMDF13_79     */
    __type210 CFDTMDF14_79;                                /* CFDTMDF14_79     */
    __type210 CFDTMDF15_79;                                /* CFDTMDF15_79     */
    uint8  dummy446[52];                                   /* Reserved         */
    __type210 CFDTMID80;                                   /* CFDTMID80        */
    __type210 CFDTMPTR80;                                  /* CFDTMPTR80       */
    __type210 CFDTMFDCTR80;                                /* CFDTMFDCTR80     */
    __type210 CFDTMDF0_80;                                 /* CFDTMDF0_80      */
    __type210 CFDTMDF1_80;                                 /* CFDTMDF1_80      */
    __type210 CFDTMDF2_80;                                 /* CFDTMDF2_80      */
    __type210 CFDTMDF3_80;                                 /* CFDTMDF3_80      */
    __type210 CFDTMDF4_80;                                 /* CFDTMDF4_80      */
    __type210 CFDTMDF5_80;                                 /* CFDTMDF5_80      */
    __type210 CFDTMDF6_80;                                 /* CFDTMDF6_80      */
    __type210 CFDTMDF7_80;                                 /* CFDTMDF7_80      */
    __type210 CFDTMDF8_80;                                 /* CFDTMDF8_80      */
    __type210 CFDTMDF9_80;                                 /* CFDTMDF9_80      */
    __type210 CFDTMDF10_80;                                /* CFDTMDF10_80     */
    __type210 CFDTMDF11_80;                                /* CFDTMDF11_80     */
    __type210 CFDTMDF12_80;                                /* CFDTMDF12_80     */
    __type210 CFDTMDF13_80;                                /* CFDTMDF13_80     */
    __type210 CFDTMDF14_80;                                /* CFDTMDF14_80     */
    __type210 CFDTMDF15_80;                                /* CFDTMDF15_80     */
    uint8  dummy447[52];                                   /* Reserved         */
    __type210 CFDTMID81;                                   /* CFDTMID81        */
    __type210 CFDTMPTR81;                                  /* CFDTMPTR81       */
    __type210 CFDTMFDCTR81;                                /* CFDTMFDCTR81     */
    __type210 CFDTMDF0_81;                                 /* CFDTMDF0_81      */
    __type210 CFDTMDF1_81;                                 /* CFDTMDF1_81      */
    __type210 CFDTMDF2_81;                                 /* CFDTMDF2_81      */
    __type210 CFDTMDF3_81;                                 /* CFDTMDF3_81      */
    __type210 CFDTMDF4_81;                                 /* CFDTMDF4_81      */
    __type210 CFDTMDF5_81;                                 /* CFDTMDF5_81      */
    __type210 CFDTMDF6_81;                                 /* CFDTMDF6_81      */
    __type210 CFDTMDF7_81;                                 /* CFDTMDF7_81      */
    __type210 CFDTMDF8_81;                                 /* CFDTMDF8_81      */
    __type210 CFDTMDF9_81;                                 /* CFDTMDF9_81      */
    __type210 CFDTMDF10_81;                                /* CFDTMDF10_81     */
    __type210 CFDTMDF11_81;                                /* CFDTMDF11_81     */
    __type210 CFDTMDF12_81;                                /* CFDTMDF12_81     */
    __type210 CFDTMDF13_81;                                /* CFDTMDF13_81     */
    __type210 CFDTMDF14_81;                                /* CFDTMDF14_81     */
    __type210 CFDTMDF15_81;                                /* CFDTMDF15_81     */
    uint8  dummy448[52];                                   /* Reserved         */
    __type210 CFDTMID82;                                   /* CFDTMID82        */
    __type210 CFDTMPTR82;                                  /* CFDTMPTR82       */
    __type210 CFDTMFDCTR82;                                /* CFDTMFDCTR82     */
    __type210 CFDTMDF0_82;                                 /* CFDTMDF0_82      */
    __type210 CFDTMDF1_82;                                 /* CFDTMDF1_82      */
    __type210 CFDTMDF2_82;                                 /* CFDTMDF2_82      */
    __type210 CFDTMDF3_82;                                 /* CFDTMDF3_82      */
    __type210 CFDTMDF4_82;                                 /* CFDTMDF4_82      */
    __type210 CFDTMDF5_82;                                 /* CFDTMDF5_82      */
    __type210 CFDTMDF6_82;                                 /* CFDTMDF6_82      */
    __type210 CFDTMDF7_82;                                 /* CFDTMDF7_82      */
    __type210 CFDTMDF8_82;                                 /* CFDTMDF8_82      */
    __type210 CFDTMDF9_82;                                 /* CFDTMDF9_82      */
    __type210 CFDTMDF10_82;                                /* CFDTMDF10_82     */
    __type210 CFDTMDF11_82;                                /* CFDTMDF11_82     */
    __type210 CFDTMDF12_82;                                /* CFDTMDF12_82     */
    __type210 CFDTMDF13_82;                                /* CFDTMDF13_82     */
    __type210 CFDTMDF14_82;                                /* CFDTMDF14_82     */
    __type210 CFDTMDF15_82;                                /* CFDTMDF15_82     */
    uint8  dummy449[52];                                   /* Reserved         */
    __type210 CFDTMID83;                                   /* CFDTMID83        */
    __type210 CFDTMPTR83;                                  /* CFDTMPTR83       */
    __type210 CFDTMFDCTR83;                                /* CFDTMFDCTR83     */
    __type210 CFDTMDF0_83;                                 /* CFDTMDF0_83      */
    __type210 CFDTMDF1_83;                                 /* CFDTMDF1_83      */
    __type210 CFDTMDF2_83;                                 /* CFDTMDF2_83      */
    __type210 CFDTMDF3_83;                                 /* CFDTMDF3_83      */
    __type210 CFDTMDF4_83;                                 /* CFDTMDF4_83      */
    __type210 CFDTMDF5_83;                                 /* CFDTMDF5_83      */
    __type210 CFDTMDF6_83;                                 /* CFDTMDF6_83      */
    __type210 CFDTMDF7_83;                                 /* CFDTMDF7_83      */
    __type210 CFDTMDF8_83;                                 /* CFDTMDF8_83      */
    __type210 CFDTMDF9_83;                                 /* CFDTMDF9_83      */
    __type210 CFDTMDF10_83;                                /* CFDTMDF10_83     */
    __type210 CFDTMDF11_83;                                /* CFDTMDF11_83     */
    __type210 CFDTMDF12_83;                                /* CFDTMDF12_83     */
    __type210 CFDTMDF13_83;                                /* CFDTMDF13_83     */
    __type210 CFDTMDF14_83;                                /* CFDTMDF14_83     */
    __type210 CFDTMDF15_83;                                /* CFDTMDF15_83     */
    uint8  dummy450[52];                                   /* Reserved         */
    __type210 CFDTMID84;                                   /* CFDTMID84        */
    __type210 CFDTMPTR84;                                  /* CFDTMPTR84       */
    __type210 CFDTMFDCTR84;                                /* CFDTMFDCTR84     */
    __type210 CFDTMDF0_84;                                 /* CFDTMDF0_84      */
    __type210 CFDTMDF1_84;                                 /* CFDTMDF1_84      */
    __type210 CFDTMDF2_84;                                 /* CFDTMDF2_84      */
    __type210 CFDTMDF3_84;                                 /* CFDTMDF3_84      */
    __type210 CFDTMDF4_84;                                 /* CFDTMDF4_84      */
    __type210 CFDTMDF5_84;                                 /* CFDTMDF5_84      */
    __type210 CFDTMDF6_84;                                 /* CFDTMDF6_84      */
    __type210 CFDTMDF7_84;                                 /* CFDTMDF7_84      */
    __type210 CFDTMDF8_84;                                 /* CFDTMDF8_84      */
    __type210 CFDTMDF9_84;                                 /* CFDTMDF9_84      */
    __type210 CFDTMDF10_84;                                /* CFDTMDF10_84     */
    __type210 CFDTMDF11_84;                                /* CFDTMDF11_84     */
    __type210 CFDTMDF12_84;                                /* CFDTMDF12_84     */
    __type210 CFDTMDF13_84;                                /* CFDTMDF13_84     */
    __type210 CFDTMDF14_84;                                /* CFDTMDF14_84     */
    __type210 CFDTMDF15_84;                                /* CFDTMDF15_84     */
    uint8  dummy451[52];                                   /* Reserved         */
    __type210 CFDTMID85;                                   /* CFDTMID85        */
    __type210 CFDTMPTR85;                                  /* CFDTMPTR85       */
    __type210 CFDTMFDCTR85;                                /* CFDTMFDCTR85     */
    __type210 CFDTMDF0_85;                                 /* CFDTMDF0_85      */
    __type210 CFDTMDF1_85;                                 /* CFDTMDF1_85      */
    __type210 CFDTMDF2_85;                                 /* CFDTMDF2_85      */
    __type210 CFDTMDF3_85;                                 /* CFDTMDF3_85      */
    __type210 CFDTMDF4_85;                                 /* CFDTMDF4_85      */
    __type210 CFDTMDF5_85;                                 /* CFDTMDF5_85      */
    __type210 CFDTMDF6_85;                                 /* CFDTMDF6_85      */
    __type210 CFDTMDF7_85;                                 /* CFDTMDF7_85      */
    __type210 CFDTMDF8_85;                                 /* CFDTMDF8_85      */
    __type210 CFDTMDF9_85;                                 /* CFDTMDF9_85      */
    __type210 CFDTMDF10_85;                                /* CFDTMDF10_85     */
    __type210 CFDTMDF11_85;                                /* CFDTMDF11_85     */
    __type210 CFDTMDF12_85;                                /* CFDTMDF12_85     */
    __type210 CFDTMDF13_85;                                /* CFDTMDF13_85     */
    __type210 CFDTMDF14_85;                                /* CFDTMDF14_85     */
    __type210 CFDTMDF15_85;                                /* CFDTMDF15_85     */
    uint8  dummy452[52];                                   /* Reserved         */
    __type210 CFDTMID86;                                   /* CFDTMID86        */
    __type210 CFDTMPTR86;                                  /* CFDTMPTR86       */
    __type210 CFDTMFDCTR86;                                /* CFDTMFDCTR86     */
    __type210 CFDTMDF0_86;                                 /* CFDTMDF0_86      */
    __type210 CFDTMDF1_86;                                 /* CFDTMDF1_86      */
    __type210 CFDTMDF2_86;                                 /* CFDTMDF2_86      */
    __type210 CFDTMDF3_86;                                 /* CFDTMDF3_86      */
    __type210 CFDTMDF4_86;                                 /* CFDTMDF4_86      */
    __type210 CFDTMDF5_86;                                 /* CFDTMDF5_86      */
    __type210 CFDTMDF6_86;                                 /* CFDTMDF6_86      */
    __type210 CFDTMDF7_86;                                 /* CFDTMDF7_86      */
    __type210 CFDTMDF8_86;                                 /* CFDTMDF8_86      */
    __type210 CFDTMDF9_86;                                 /* CFDTMDF9_86      */
    __type210 CFDTMDF10_86;                                /* CFDTMDF10_86     */
    __type210 CFDTMDF11_86;                                /* CFDTMDF11_86     */
    __type210 CFDTMDF12_86;                                /* CFDTMDF12_86     */
    __type210 CFDTMDF13_86;                                /* CFDTMDF13_86     */
    __type210 CFDTMDF14_86;                                /* CFDTMDF14_86     */
    __type210 CFDTMDF15_86;                                /* CFDTMDF15_86     */
    uint8  dummy453[52];                                   /* Reserved         */
    __type210 CFDTMID87;                                   /* CFDTMID87        */
    __type210 CFDTMPTR87;                                  /* CFDTMPTR87       */
    __type210 CFDTMFDCTR87;                                /* CFDTMFDCTR87     */
    __type210 CFDTMDF0_87;                                 /* CFDTMDF0_87      */
    __type210 CFDTMDF1_87;                                 /* CFDTMDF1_87      */
    __type210 CFDTMDF2_87;                                 /* CFDTMDF2_87      */
    __type210 CFDTMDF3_87;                                 /* CFDTMDF3_87      */
    __type210 CFDTMDF4_87;                                 /* CFDTMDF4_87      */
    __type210 CFDTMDF5_87;                                 /* CFDTMDF5_87      */
    __type210 CFDTMDF6_87;                                 /* CFDTMDF6_87      */
    __type210 CFDTMDF7_87;                                 /* CFDTMDF7_87      */
    __type210 CFDTMDF8_87;                                 /* CFDTMDF8_87      */
    __type210 CFDTMDF9_87;                                 /* CFDTMDF9_87      */
    __type210 CFDTMDF10_87;                                /* CFDTMDF10_87     */
    __type210 CFDTMDF11_87;                                /* CFDTMDF11_87     */
    __type210 CFDTMDF12_87;                                /* CFDTMDF12_87     */
    __type210 CFDTMDF13_87;                                /* CFDTMDF13_87     */
    __type210 CFDTMDF14_87;                                /* CFDTMDF14_87     */
    __type210 CFDTMDF15_87;                                /* CFDTMDF15_87     */
    uint8  dummy454[52];                                   /* Reserved         */
    __type210 CFDTMID88;                                   /* CFDTMID88        */
    __type210 CFDTMPTR88;                                  /* CFDTMPTR88       */
    __type210 CFDTMFDCTR88;                                /* CFDTMFDCTR88     */
    __type210 CFDTMDF0_88;                                 /* CFDTMDF0_88      */
    __type210 CFDTMDF1_88;                                 /* CFDTMDF1_88      */
    __type210 CFDTMDF2_88;                                 /* CFDTMDF2_88      */
    __type210 CFDTMDF3_88;                                 /* CFDTMDF3_88      */
    __type210 CFDTMDF4_88;                                 /* CFDTMDF4_88      */
    __type210 CFDTMDF5_88;                                 /* CFDTMDF5_88      */
    __type210 CFDTMDF6_88;                                 /* CFDTMDF6_88      */
    __type210 CFDTMDF7_88;                                 /* CFDTMDF7_88      */
    __type210 CFDTMDF8_88;                                 /* CFDTMDF8_88      */
    __type210 CFDTMDF9_88;                                 /* CFDTMDF9_88      */
    __type210 CFDTMDF10_88;                                /* CFDTMDF10_88     */
    __type210 CFDTMDF11_88;                                /* CFDTMDF11_88     */
    __type210 CFDTMDF12_88;                                /* CFDTMDF12_88     */
    __type210 CFDTMDF13_88;                                /* CFDTMDF13_88     */
    __type210 CFDTMDF14_88;                                /* CFDTMDF14_88     */
    __type210 CFDTMDF15_88;                                /* CFDTMDF15_88     */
    uint8  dummy455[52];                                   /* Reserved         */
    __type210 CFDTMID89;                                   /* CFDTMID89        */
    __type210 CFDTMPTR89;                                  /* CFDTMPTR89       */
    __type210 CFDTMFDCTR89;                                /* CFDTMFDCTR89     */
    __type210 CFDTMDF0_89;                                 /* CFDTMDF0_89      */
    __type210 CFDTMDF1_89;                                 /* CFDTMDF1_89      */
    __type210 CFDTMDF2_89;                                 /* CFDTMDF2_89      */
    __type210 CFDTMDF3_89;                                 /* CFDTMDF3_89      */
    __type210 CFDTMDF4_89;                                 /* CFDTMDF4_89      */
    __type210 CFDTMDF5_89;                                 /* CFDTMDF5_89      */
    __type210 CFDTMDF6_89;                                 /* CFDTMDF6_89      */
    __type210 CFDTMDF7_89;                                 /* CFDTMDF7_89      */
    __type210 CFDTMDF8_89;                                 /* CFDTMDF8_89      */
    __type210 CFDTMDF9_89;                                 /* CFDTMDF9_89      */
    __type210 CFDTMDF10_89;                                /* CFDTMDF10_89     */
    __type210 CFDTMDF11_89;                                /* CFDTMDF11_89     */
    __type210 CFDTMDF12_89;                                /* CFDTMDF12_89     */
    __type210 CFDTMDF13_89;                                /* CFDTMDF13_89     */
    __type210 CFDTMDF14_89;                                /* CFDTMDF14_89     */
    __type210 CFDTMDF15_89;                                /* CFDTMDF15_89     */
    uint8  dummy456[52];                                   /* Reserved         */
    __type210 CFDTMID90;                                   /* CFDTMID90        */
    __type210 CFDTMPTR90;                                  /* CFDTMPTR90       */
    __type210 CFDTMFDCTR90;                                /* CFDTMFDCTR90     */
    __type210 CFDTMDF0_90;                                 /* CFDTMDF0_90      */
    __type210 CFDTMDF1_90;                                 /* CFDTMDF1_90      */
    __type210 CFDTMDF2_90;                                 /* CFDTMDF2_90      */
    __type210 CFDTMDF3_90;                                 /* CFDTMDF3_90      */
    __type210 CFDTMDF4_90;                                 /* CFDTMDF4_90      */
    __type210 CFDTMDF5_90;                                 /* CFDTMDF5_90      */
    __type210 CFDTMDF6_90;                                 /* CFDTMDF6_90      */
    __type210 CFDTMDF7_90;                                 /* CFDTMDF7_90      */
    __type210 CFDTMDF8_90;                                 /* CFDTMDF8_90      */
    __type210 CFDTMDF9_90;                                 /* CFDTMDF9_90      */
    __type210 CFDTMDF10_90;                                /* CFDTMDF10_90     */
    __type210 CFDTMDF11_90;                                /* CFDTMDF11_90     */
    __type210 CFDTMDF12_90;                                /* CFDTMDF12_90     */
    __type210 CFDTMDF13_90;                                /* CFDTMDF13_90     */
    __type210 CFDTMDF14_90;                                /* CFDTMDF14_90     */
    __type210 CFDTMDF15_90;                                /* CFDTMDF15_90     */
    uint8  dummy457[52];                                   /* Reserved         */
    __type210 CFDTMID91;                                   /* CFDTMID91        */
    __type210 CFDTMPTR91;                                  /* CFDTMPTR91       */
    __type210 CFDTMFDCTR91;                                /* CFDTMFDCTR91     */
    __type210 CFDTMDF0_91;                                 /* CFDTMDF0_91      */
    __type210 CFDTMDF1_91;                                 /* CFDTMDF1_91      */
    __type210 CFDTMDF2_91;                                 /* CFDTMDF2_91      */
    __type210 CFDTMDF3_91;                                 /* CFDTMDF3_91      */
    __type210 CFDTMDF4_91;                                 /* CFDTMDF4_91      */
    __type210 CFDTMDF5_91;                                 /* CFDTMDF5_91      */
    __type210 CFDTMDF6_91;                                 /* CFDTMDF6_91      */
    __type210 CFDTMDF7_91;                                 /* CFDTMDF7_91      */
    __type210 CFDTMDF8_91;                                 /* CFDTMDF8_91      */
    __type210 CFDTMDF9_91;                                 /* CFDTMDF9_91      */
    __type210 CFDTMDF10_91;                                /* CFDTMDF10_91     */
    __type210 CFDTMDF11_91;                                /* CFDTMDF11_91     */
    __type210 CFDTMDF12_91;                                /* CFDTMDF12_91     */
    __type210 CFDTMDF13_91;                                /* CFDTMDF13_91     */
    __type210 CFDTMDF14_91;                                /* CFDTMDF14_91     */
    __type210 CFDTMDF15_91;                                /* CFDTMDF15_91     */
    uint8  dummy458[52];                                   /* Reserved         */
    __type210 CFDTMID92;                                   /* CFDTMID92        */
    __type210 CFDTMPTR92;                                  /* CFDTMPTR92       */
    __type210 CFDTMFDCTR92;                                /* CFDTMFDCTR92     */
    __type210 CFDTMDF0_92;                                 /* CFDTMDF0_92      */
    __type210 CFDTMDF1_92;                                 /* CFDTMDF1_92      */
    __type210 CFDTMDF2_92;                                 /* CFDTMDF2_92      */
    __type210 CFDTMDF3_92;                                 /* CFDTMDF3_92      */
    __type210 CFDTMDF4_92;                                 /* CFDTMDF4_92      */
    __type210 CFDTMDF5_92;                                 /* CFDTMDF5_92      */
    __type210 CFDTMDF6_92;                                 /* CFDTMDF6_92      */
    __type210 CFDTMDF7_92;                                 /* CFDTMDF7_92      */
    __type210 CFDTMDF8_92;                                 /* CFDTMDF8_92      */
    __type210 CFDTMDF9_92;                                 /* CFDTMDF9_92      */
    __type210 CFDTMDF10_92;                                /* CFDTMDF10_92     */
    __type210 CFDTMDF11_92;                                /* CFDTMDF11_92     */
    __type210 CFDTMDF12_92;                                /* CFDTMDF12_92     */
    __type210 CFDTMDF13_92;                                /* CFDTMDF13_92     */
    __type210 CFDTMDF14_92;                                /* CFDTMDF14_92     */
    __type210 CFDTMDF15_92;                                /* CFDTMDF15_92     */
    uint8  dummy459[52];                                   /* Reserved         */
    __type210 CFDTMID93;                                   /* CFDTMID93        */
    __type210 CFDTMPTR93;                                  /* CFDTMPTR93       */
    __type210 CFDTMFDCTR93;                                /* CFDTMFDCTR93     */
    __type210 CFDTMDF0_93;                                 /* CFDTMDF0_93      */
    __type210 CFDTMDF1_93;                                 /* CFDTMDF1_93      */
    __type210 CFDTMDF2_93;                                 /* CFDTMDF2_93      */
    __type210 CFDTMDF3_93;                                 /* CFDTMDF3_93      */
    __type210 CFDTMDF4_93;                                 /* CFDTMDF4_93      */
    __type210 CFDTMDF5_93;                                 /* CFDTMDF5_93      */
    __type210 CFDTMDF6_93;                                 /* CFDTMDF6_93      */
    __type210 CFDTMDF7_93;                                 /* CFDTMDF7_93      */
    __type210 CFDTMDF8_93;                                 /* CFDTMDF8_93      */
    __type210 CFDTMDF9_93;                                 /* CFDTMDF9_93      */
    __type210 CFDTMDF10_93;                                /* CFDTMDF10_93     */
    __type210 CFDTMDF11_93;                                /* CFDTMDF11_93     */
    __type210 CFDTMDF12_93;                                /* CFDTMDF12_93     */
    __type210 CFDTMDF13_93;                                /* CFDTMDF13_93     */
    __type210 CFDTMDF14_93;                                /* CFDTMDF14_93     */
    __type210 CFDTMDF15_93;                                /* CFDTMDF15_93     */
    uint8  dummy460[52];                                   /* Reserved         */
    __type210 CFDTMID94;                                   /* CFDTMID94        */
    __type210 CFDTMPTR94;                                  /* CFDTMPTR94       */
    __type210 CFDTMFDCTR94;                                /* CFDTMFDCTR94     */
    __type210 CFDTMDF0_94;                                 /* CFDTMDF0_94      */
    __type210 CFDTMDF1_94;                                 /* CFDTMDF1_94      */
    __type210 CFDTMDF2_94;                                 /* CFDTMDF2_94      */
    __type210 CFDTMDF3_94;                                 /* CFDTMDF3_94      */
    __type210 CFDTMDF4_94;                                 /* CFDTMDF4_94      */
    __type210 CFDTMDF5_94;                                 /* CFDTMDF5_94      */
    __type210 CFDTMDF6_94;                                 /* CFDTMDF6_94      */
    __type210 CFDTMDF7_94;                                 /* CFDTMDF7_94      */
    __type210 CFDTMDF8_94;                                 /* CFDTMDF8_94      */
    __type210 CFDTMDF9_94;                                 /* CFDTMDF9_94      */
    __type210 CFDTMDF10_94;                                /* CFDTMDF10_94     */
    __type210 CFDTMDF11_94;                                /* CFDTMDF11_94     */
    __type210 CFDTMDF12_94;                                /* CFDTMDF12_94     */
    __type210 CFDTMDF13_94;                                /* CFDTMDF13_94     */
    __type210 CFDTMDF14_94;                                /* CFDTMDF14_94     */
    __type210 CFDTMDF15_94;                                /* CFDTMDF15_94     */
    uint8  dummy461[52];                                   /* Reserved         */
    __type210 CFDTMID95;                                   /* CFDTMID95        */
    __type210 CFDTMPTR95;                                  /* CFDTMPTR95       */
    __type210 CFDTMFDCTR95;                                /* CFDTMFDCTR95     */
    __type210 CFDTMDF0_95;                                 /* CFDTMDF0_95      */
    __type210 CFDTMDF1_95;                                 /* CFDTMDF1_95      */
    __type210 CFDTMDF2_95;                                 /* CFDTMDF2_95      */
    __type210 CFDTMDF3_95;                                 /* CFDTMDF3_95      */
    __type210 CFDTMDF4_95;                                 /* CFDTMDF4_95      */
    __type210 CFDTMDF5_95;                                 /* CFDTMDF5_95      */
    __type210 CFDTMDF6_95;                                 /* CFDTMDF6_95      */
    __type210 CFDTMDF7_95;                                 /* CFDTMDF7_95      */
    __type210 CFDTMDF8_95;                                 /* CFDTMDF8_95      */
    __type210 CFDTMDF9_95;                                 /* CFDTMDF9_95      */
    __type210 CFDTMDF10_95;                                /* CFDTMDF10_95     */
    __type210 CFDTMDF11_95;                                /* CFDTMDF11_95     */
    __type210 CFDTMDF12_95;                                /* CFDTMDF12_95     */
    __type210 CFDTMDF13_95;                                /* CFDTMDF13_95     */
    __type210 CFDTMDF14_95;                                /* CFDTMDF14_95     */
    __type210 CFDTMDF15_95;                                /* CFDTMDF15_95     */
    uint8  dummy462[52];                                   /* Reserved         */
    __type210 CFDTMID96;                                   /* CFDTMID96        */
    __type210 CFDTMPTR96;                                  /* CFDTMPTR96       */
    __type210 CFDTMFDCTR96;                                /* CFDTMFDCTR96     */
    __type210 CFDTMDF0_96;                                 /* CFDTMDF0_96      */
    __type210 CFDTMDF1_96;                                 /* CFDTMDF1_96      */
    __type210 CFDTMDF2_96;                                 /* CFDTMDF2_96      */
    __type210 CFDTMDF3_96;                                 /* CFDTMDF3_96      */
    __type210 CFDTMDF4_96;                                 /* CFDTMDF4_96      */
    __type210 CFDTMDF5_96;                                 /* CFDTMDF5_96      */
    __type210 CFDTMDF6_96;                                 /* CFDTMDF6_96      */
    __type210 CFDTMDF7_96;                                 /* CFDTMDF7_96      */
    __type210 CFDTMDF8_96;                                 /* CFDTMDF8_96      */
    __type210 CFDTMDF9_96;                                 /* CFDTMDF9_96      */
    __type210 CFDTMDF10_96;                                /* CFDTMDF10_96     */
    __type210 CFDTMDF11_96;                                /* CFDTMDF11_96     */
    __type210 CFDTMDF12_96;                                /* CFDTMDF12_96     */
    __type210 CFDTMDF13_96;                                /* CFDTMDF13_96     */
    __type210 CFDTMDF14_96;                                /* CFDTMDF14_96     */
    __type210 CFDTMDF15_96;                                /* CFDTMDF15_96     */
    uint8  dummy463[52];                                   /* Reserved         */
    __type210 CFDTMID97;                                   /* CFDTMID97        */
    __type210 CFDTMPTR97;                                  /* CFDTMPTR97       */
    __type210 CFDTMFDCTR97;                                /* CFDTMFDCTR97     */
    __type210 CFDTMDF0_97;                                 /* CFDTMDF0_97      */
    __type210 CFDTMDF1_97;                                 /* CFDTMDF1_97      */
    __type210 CFDTMDF2_97;                                 /* CFDTMDF2_97      */
    __type210 CFDTMDF3_97;                                 /* CFDTMDF3_97      */
    __type210 CFDTMDF4_97;                                 /* CFDTMDF4_97      */
    __type210 CFDTMDF5_97;                                 /* CFDTMDF5_97      */
    __type210 CFDTMDF6_97;                                 /* CFDTMDF6_97      */
    __type210 CFDTMDF7_97;                                 /* CFDTMDF7_97      */
    __type210 CFDTMDF8_97;                                 /* CFDTMDF8_97      */
    __type210 CFDTMDF9_97;                                 /* CFDTMDF9_97      */
    __type210 CFDTMDF10_97;                                /* CFDTMDF10_97     */
    __type210 CFDTMDF11_97;                                /* CFDTMDF11_97     */
    __type210 CFDTMDF12_97;                                /* CFDTMDF12_97     */
    __type210 CFDTMDF13_97;                                /* CFDTMDF13_97     */
    __type210 CFDTMDF14_97;                                /* CFDTMDF14_97     */
    __type210 CFDTMDF15_97;                                /* CFDTMDF15_97     */
    uint8  dummy464[52];                                   /* Reserved         */
    __type210 CFDTMID98;                                   /* CFDTMID98        */
    __type210 CFDTMPTR98;                                  /* CFDTMPTR98       */
    __type210 CFDTMFDCTR98;                                /* CFDTMFDCTR98     */
    __type210 CFDTMDF0_98;                                 /* CFDTMDF0_98      */
    __type210 CFDTMDF1_98;                                 /* CFDTMDF1_98      */
    __type210 CFDTMDF2_98;                                 /* CFDTMDF2_98      */
    __type210 CFDTMDF3_98;                                 /* CFDTMDF3_98      */
    __type210 CFDTMDF4_98;                                 /* CFDTMDF4_98      */
    __type210 CFDTMDF5_98;                                 /* CFDTMDF5_98      */
    __type210 CFDTMDF6_98;                                 /* CFDTMDF6_98      */
    __type210 CFDTMDF7_98;                                 /* CFDTMDF7_98      */
    __type210 CFDTMDF8_98;                                 /* CFDTMDF8_98      */
    __type210 CFDTMDF9_98;                                 /* CFDTMDF9_98      */
    __type210 CFDTMDF10_98;                                /* CFDTMDF10_98     */
    __type210 CFDTMDF11_98;                                /* CFDTMDF11_98     */
    __type210 CFDTMDF12_98;                                /* CFDTMDF12_98     */
    __type210 CFDTMDF13_98;                                /* CFDTMDF13_98     */
    __type210 CFDTMDF14_98;                                /* CFDTMDF14_98     */
    __type210 CFDTMDF15_98;                                /* CFDTMDF15_98     */
    uint8  dummy465[52];                                   /* Reserved         */
    __type210 CFDTMID99;                                   /* CFDTMID99        */
    __type210 CFDTMPTR99;                                  /* CFDTMPTR99       */
    __type210 CFDTMFDCTR99;                                /* CFDTMFDCTR99     */
    __type210 CFDTMDF0_99;                                 /* CFDTMDF0_99      */
    __type210 CFDTMDF1_99;                                 /* CFDTMDF1_99      */
    __type210 CFDTMDF2_99;                                 /* CFDTMDF2_99      */
    __type210 CFDTMDF3_99;                                 /* CFDTMDF3_99      */
    __type210 CFDTMDF4_99;                                 /* CFDTMDF4_99      */
    __type210 CFDTMDF5_99;                                 /* CFDTMDF5_99      */
    __type210 CFDTMDF6_99;                                 /* CFDTMDF6_99      */
    __type210 CFDTMDF7_99;                                 /* CFDTMDF7_99      */
    __type210 CFDTMDF8_99;                                 /* CFDTMDF8_99      */
    __type210 CFDTMDF9_99;                                 /* CFDTMDF9_99      */
    __type210 CFDTMDF10_99;                                /* CFDTMDF10_99     */
    __type210 CFDTMDF11_99;                                /* CFDTMDF11_99     */
    __type210 CFDTMDF12_99;                                /* CFDTMDF12_99     */
    __type210 CFDTMDF13_99;                                /* CFDTMDF13_99     */
    __type210 CFDTMDF14_99;                                /* CFDTMDF14_99     */
    __type210 CFDTMDF15_99;                                /* CFDTMDF15_99     */
    uint8  dummy466[52];                                   /* Reserved         */
    __type210 CFDTMID100;                                  /* CFDTMID100       */
    __type210 CFDTMPTR100;                                 /* CFDTMPTR100      */
    __type210 CFDTMFDCTR100;                               /* CFDTMFDCTR100    */
    __type210 CFDTMDF0_100;                                /* CFDTMDF0_100     */
    __type210 CFDTMDF1_100;                                /* CFDTMDF1_100     */
    __type210 CFDTMDF2_100;                                /* CFDTMDF2_100     */
    __type210 CFDTMDF3_100;                                /* CFDTMDF3_100     */
    __type210 CFDTMDF4_100;                                /* CFDTMDF4_100     */
    __type210 CFDTMDF5_100;                                /* CFDTMDF5_100     */
    __type210 CFDTMDF6_100;                                /* CFDTMDF6_100     */
    __type210 CFDTMDF7_100;                                /* CFDTMDF7_100     */
    __type210 CFDTMDF8_100;                                /* CFDTMDF8_100     */
    __type210 CFDTMDF9_100;                                /* CFDTMDF9_100     */
    __type210 CFDTMDF10_100;                               /* CFDTMDF10_100    */
    __type210 CFDTMDF11_100;                               /* CFDTMDF11_100    */
    __type210 CFDTMDF12_100;                               /* CFDTMDF12_100    */
    __type210 CFDTMDF13_100;                               /* CFDTMDF13_100    */
    __type210 CFDTMDF14_100;                               /* CFDTMDF14_100    */
    __type210 CFDTMDF15_100;                               /* CFDTMDF15_100    */
    uint8  dummy467[52];                                   /* Reserved         */
    __type210 CFDTMID101;                                  /* CFDTMID101       */
    __type210 CFDTMPTR101;                                 /* CFDTMPTR101      */
    __type210 CFDTMFDCTR101;                               /* CFDTMFDCTR101    */
    __type210 CFDTMDF0_101;                                /* CFDTMDF0_101     */
    __type210 CFDTMDF1_101;                                /* CFDTMDF1_101     */
    __type210 CFDTMDF2_101;                                /* CFDTMDF2_101     */
    __type210 CFDTMDF3_101;                                /* CFDTMDF3_101     */
    __type210 CFDTMDF4_101;                                /* CFDTMDF4_101     */
    __type210 CFDTMDF5_101;                                /* CFDTMDF5_101     */
    __type210 CFDTMDF6_101;                                /* CFDTMDF6_101     */
    __type210 CFDTMDF7_101;                                /* CFDTMDF7_101     */
    __type210 CFDTMDF8_101;                                /* CFDTMDF8_101     */
    __type210 CFDTMDF9_101;                                /* CFDTMDF9_101     */
    __type210 CFDTMDF10_101;                               /* CFDTMDF10_101    */
    __type210 CFDTMDF11_101;                               /* CFDTMDF11_101    */
    __type210 CFDTMDF12_101;                               /* CFDTMDF12_101    */
    __type210 CFDTMDF13_101;                               /* CFDTMDF13_101    */
    __type210 CFDTMDF14_101;                               /* CFDTMDF14_101    */
    __type210 CFDTMDF15_101;                               /* CFDTMDF15_101    */
    uint8  dummy468[52];                                   /* Reserved         */
    __type210 CFDTMID102;                                  /* CFDTMID102       */
    __type210 CFDTMPTR102;                                 /* CFDTMPTR102      */
    __type210 CFDTMFDCTR102;                               /* CFDTMFDCTR102    */
    __type210 CFDTMDF0_102;                                /* CFDTMDF0_102     */
    __type210 CFDTMDF1_102;                                /* CFDTMDF1_102     */
    __type210 CFDTMDF2_102;                                /* CFDTMDF2_102     */
    __type210 CFDTMDF3_102;                                /* CFDTMDF3_102     */
    __type210 CFDTMDF4_102;                                /* CFDTMDF4_102     */
    __type210 CFDTMDF5_102;                                /* CFDTMDF5_102     */
    __type210 CFDTMDF6_102;                                /* CFDTMDF6_102     */
    __type210 CFDTMDF7_102;                                /* CFDTMDF7_102     */
    __type210 CFDTMDF8_102;                                /* CFDTMDF8_102     */
    __type210 CFDTMDF9_102;                                /* CFDTMDF9_102     */
    __type210 CFDTMDF10_102;                               /* CFDTMDF10_102    */
    __type210 CFDTMDF11_102;                               /* CFDTMDF11_102    */
    __type210 CFDTMDF12_102;                               /* CFDTMDF12_102    */
    __type210 CFDTMDF13_102;                               /* CFDTMDF13_102    */
    __type210 CFDTMDF14_102;                               /* CFDTMDF14_102    */
    __type210 CFDTMDF15_102;                               /* CFDTMDF15_102    */
    uint8  dummy469[52];                                   /* Reserved         */
    __type210 CFDTMID103;                                  /* CFDTMID103       */
    __type210 CFDTMPTR103;                                 /* CFDTMPTR103      */
    __type210 CFDTMFDCTR103;                               /* CFDTMFDCTR103    */
    __type210 CFDTMDF0_103;                                /* CFDTMDF0_103     */
    __type210 CFDTMDF1_103;                                /* CFDTMDF1_103     */
    __type210 CFDTMDF2_103;                                /* CFDTMDF2_103     */
    __type210 CFDTMDF3_103;                                /* CFDTMDF3_103     */
    __type210 CFDTMDF4_103;                                /* CFDTMDF4_103     */
    __type210 CFDTMDF5_103;                                /* CFDTMDF5_103     */
    __type210 CFDTMDF6_103;                                /* CFDTMDF6_103     */
    __type210 CFDTMDF7_103;                                /* CFDTMDF7_103     */
    __type210 CFDTMDF8_103;                                /* CFDTMDF8_103     */
    __type210 CFDTMDF9_103;                                /* CFDTMDF9_103     */
    __type210 CFDTMDF10_103;                               /* CFDTMDF10_103    */
    __type210 CFDTMDF11_103;                               /* CFDTMDF11_103    */
    __type210 CFDTMDF12_103;                               /* CFDTMDF12_103    */
    __type210 CFDTMDF13_103;                               /* CFDTMDF13_103    */
    __type210 CFDTMDF14_103;                               /* CFDTMDF14_103    */
    __type210 CFDTMDF15_103;                               /* CFDTMDF15_103    */
    uint8  dummy470[52];                                   /* Reserved         */
    __type210 CFDTMID104;                                  /* CFDTMID104       */
    __type210 CFDTMPTR104;                                 /* CFDTMPTR104      */
    __type210 CFDTMFDCTR104;                               /* CFDTMFDCTR104    */
    __type210 CFDTMDF0_104;                                /* CFDTMDF0_104     */
    __type210 CFDTMDF1_104;                                /* CFDTMDF1_104     */
    __type210 CFDTMDF2_104;                                /* CFDTMDF2_104     */
    __type210 CFDTMDF3_104;                                /* CFDTMDF3_104     */
    __type210 CFDTMDF4_104;                                /* CFDTMDF4_104     */
    __type210 CFDTMDF5_104;                                /* CFDTMDF5_104     */
    __type210 CFDTMDF6_104;                                /* CFDTMDF6_104     */
    __type210 CFDTMDF7_104;                                /* CFDTMDF7_104     */
    __type210 CFDTMDF8_104;                                /* CFDTMDF8_104     */
    __type210 CFDTMDF9_104;                                /* CFDTMDF9_104     */
    __type210 CFDTMDF10_104;                               /* CFDTMDF10_104    */
    __type210 CFDTMDF11_104;                               /* CFDTMDF11_104    */
    __type210 CFDTMDF12_104;                               /* CFDTMDF12_104    */
    __type210 CFDTMDF13_104;                               /* CFDTMDF13_104    */
    __type210 CFDTMDF14_104;                               /* CFDTMDF14_104    */
    __type210 CFDTMDF15_104;                               /* CFDTMDF15_104    */
    uint8  dummy471[52];                                   /* Reserved         */
    __type210 CFDTMID105;                                  /* CFDTMID105       */
    __type210 CFDTMPTR105;                                 /* CFDTMPTR105      */
    __type210 CFDTMFDCTR105;                               /* CFDTMFDCTR105    */
    __type210 CFDTMDF0_105;                                /* CFDTMDF0_105     */
    __type210 CFDTMDF1_105;                                /* CFDTMDF1_105     */
    __type210 CFDTMDF2_105;                                /* CFDTMDF2_105     */
    __type210 CFDTMDF3_105;                                /* CFDTMDF3_105     */
    __type210 CFDTMDF4_105;                                /* CFDTMDF4_105     */
    __type210 CFDTMDF5_105;                                /* CFDTMDF5_105     */
    __type210 CFDTMDF6_105;                                /* CFDTMDF6_105     */
    __type210 CFDTMDF7_105;                                /* CFDTMDF7_105     */
    __type210 CFDTMDF8_105;                                /* CFDTMDF8_105     */
    __type210 CFDTMDF9_105;                                /* CFDTMDF9_105     */
    __type210 CFDTMDF10_105;                               /* CFDTMDF10_105    */
    __type210 CFDTMDF11_105;                               /* CFDTMDF11_105    */
    __type210 CFDTMDF12_105;                               /* CFDTMDF12_105    */
    __type210 CFDTMDF13_105;                               /* CFDTMDF13_105    */
    __type210 CFDTMDF14_105;                               /* CFDTMDF14_105    */
    __type210 CFDTMDF15_105;                               /* CFDTMDF15_105    */
    uint8  dummy472[52];                                   /* Reserved         */
    __type210 CFDTMID106;                                  /* CFDTMID106       */
    __type210 CFDTMPTR106;                                 /* CFDTMPTR106      */
    __type210 CFDTMFDCTR106;                               /* CFDTMFDCTR106    */
    __type210 CFDTMDF0_106;                                /* CFDTMDF0_106     */
    __type210 CFDTMDF1_106;                                /* CFDTMDF1_106     */
    __type210 CFDTMDF2_106;                                /* CFDTMDF2_106     */
    __type210 CFDTMDF3_106;                                /* CFDTMDF3_106     */
    __type210 CFDTMDF4_106;                                /* CFDTMDF4_106     */
    __type210 CFDTMDF5_106;                                /* CFDTMDF5_106     */
    __type210 CFDTMDF6_106;                                /* CFDTMDF6_106     */
    __type210 CFDTMDF7_106;                                /* CFDTMDF7_106     */
    __type210 CFDTMDF8_106;                                /* CFDTMDF8_106     */
    __type210 CFDTMDF9_106;                                /* CFDTMDF9_106     */
    __type210 CFDTMDF10_106;                               /* CFDTMDF10_106    */
    __type210 CFDTMDF11_106;                               /* CFDTMDF11_106    */
    __type210 CFDTMDF12_106;                               /* CFDTMDF12_106    */
    __type210 CFDTMDF13_106;                               /* CFDTMDF13_106    */
    __type210 CFDTMDF14_106;                               /* CFDTMDF14_106    */
    __type210 CFDTMDF15_106;                               /* CFDTMDF15_106    */
    uint8  dummy473[52];                                   /* Reserved         */
    __type210 CFDTMID107;                                  /* CFDTMID107       */
    __type210 CFDTMPTR107;                                 /* CFDTMPTR107      */
    __type210 CFDTMFDCTR107;                               /* CFDTMFDCTR107    */
    __type210 CFDTMDF0_107;                                /* CFDTMDF0_107     */
    __type210 CFDTMDF1_107;                                /* CFDTMDF1_107     */
    __type210 CFDTMDF2_107;                                /* CFDTMDF2_107     */
    __type210 CFDTMDF3_107;                                /* CFDTMDF3_107     */
    __type210 CFDTMDF4_107;                                /* CFDTMDF4_107     */
    __type210 CFDTMDF5_107;                                /* CFDTMDF5_107     */
    __type210 CFDTMDF6_107;                                /* CFDTMDF6_107     */
    __type210 CFDTMDF7_107;                                /* CFDTMDF7_107     */
    __type210 CFDTMDF8_107;                                /* CFDTMDF8_107     */
    __type210 CFDTMDF9_107;                                /* CFDTMDF9_107     */
    __type210 CFDTMDF10_107;                               /* CFDTMDF10_107    */
    __type210 CFDTMDF11_107;                               /* CFDTMDF11_107    */
    __type210 CFDTMDF12_107;                               /* CFDTMDF12_107    */
    __type210 CFDTMDF13_107;                               /* CFDTMDF13_107    */
    __type210 CFDTMDF14_107;                               /* CFDTMDF14_107    */
    __type210 CFDTMDF15_107;                               /* CFDTMDF15_107    */
    uint8  dummy474[52];                                   /* Reserved         */
    __type210 CFDTMID108;                                  /* CFDTMID108       */
    __type210 CFDTMPTR108;                                 /* CFDTMPTR108      */
    __type210 CFDTMFDCTR108;                               /* CFDTMFDCTR108    */
    __type210 CFDTMDF0_108;                                /* CFDTMDF0_108     */
    __type210 CFDTMDF1_108;                                /* CFDTMDF1_108     */
    __type210 CFDTMDF2_108;                                /* CFDTMDF2_108     */
    __type210 CFDTMDF3_108;                                /* CFDTMDF3_108     */
    __type210 CFDTMDF4_108;                                /* CFDTMDF4_108     */
    __type210 CFDTMDF5_108;                                /* CFDTMDF5_108     */
    __type210 CFDTMDF6_108;                                /* CFDTMDF6_108     */
    __type210 CFDTMDF7_108;                                /* CFDTMDF7_108     */
    __type210 CFDTMDF8_108;                                /* CFDTMDF8_108     */
    __type210 CFDTMDF9_108;                                /* CFDTMDF9_108     */
    __type210 CFDTMDF10_108;                               /* CFDTMDF10_108    */
    __type210 CFDTMDF11_108;                               /* CFDTMDF11_108    */
    __type210 CFDTMDF12_108;                               /* CFDTMDF12_108    */
    __type210 CFDTMDF13_108;                               /* CFDTMDF13_108    */
    __type210 CFDTMDF14_108;                               /* CFDTMDF14_108    */
    __type210 CFDTMDF15_108;                               /* CFDTMDF15_108    */
    uint8  dummy475[52];                                   /* Reserved         */
    __type210 CFDTMID109;                                  /* CFDTMID109       */
    __type210 CFDTMPTR109;                                 /* CFDTMPTR109      */
    __type210 CFDTMFDCTR109;                               /* CFDTMFDCTR109    */
    __type210 CFDTMDF0_109;                                /* CFDTMDF0_109     */
    __type210 CFDTMDF1_109;                                /* CFDTMDF1_109     */
    __type210 CFDTMDF2_109;                                /* CFDTMDF2_109     */
    __type210 CFDTMDF3_109;                                /* CFDTMDF3_109     */
    __type210 CFDTMDF4_109;                                /* CFDTMDF4_109     */
    __type210 CFDTMDF5_109;                                /* CFDTMDF5_109     */
    __type210 CFDTMDF6_109;                                /* CFDTMDF6_109     */
    __type210 CFDTMDF7_109;                                /* CFDTMDF7_109     */
    __type210 CFDTMDF8_109;                                /* CFDTMDF8_109     */
    __type210 CFDTMDF9_109;                                /* CFDTMDF9_109     */
    __type210 CFDTMDF10_109;                               /* CFDTMDF10_109    */
    __type210 CFDTMDF11_109;                               /* CFDTMDF11_109    */
    __type210 CFDTMDF12_109;                               /* CFDTMDF12_109    */
    __type210 CFDTMDF13_109;                               /* CFDTMDF13_109    */
    __type210 CFDTMDF14_109;                               /* CFDTMDF14_109    */
    __type210 CFDTMDF15_109;                               /* CFDTMDF15_109    */
    uint8  dummy476[52];                                   /* Reserved         */
    __type210 CFDTMID110;                                  /* CFDTMID110       */
    __type210 CFDTMPTR110;                                 /* CFDTMPTR110      */
    __type210 CFDTMFDCTR110;                               /* CFDTMFDCTR110    */
    __type210 CFDTMDF0_110;                                /* CFDTMDF0_110     */
    __type210 CFDTMDF1_110;                                /* CFDTMDF1_110     */
    __type210 CFDTMDF2_110;                                /* CFDTMDF2_110     */
    __type210 CFDTMDF3_110;                                /* CFDTMDF3_110     */
    __type210 CFDTMDF4_110;                                /* CFDTMDF4_110     */
    __type210 CFDTMDF5_110;                                /* CFDTMDF5_110     */
    __type210 CFDTMDF6_110;                                /* CFDTMDF6_110     */
    __type210 CFDTMDF7_110;                                /* CFDTMDF7_110     */
    __type210 CFDTMDF8_110;                                /* CFDTMDF8_110     */
    __type210 CFDTMDF9_110;                                /* CFDTMDF9_110     */
    __type210 CFDTMDF10_110;                               /* CFDTMDF10_110    */
    __type210 CFDTMDF11_110;                               /* CFDTMDF11_110    */
    __type210 CFDTMDF12_110;                               /* CFDTMDF12_110    */
    __type210 CFDTMDF13_110;                               /* CFDTMDF13_110    */
    __type210 CFDTMDF14_110;                               /* CFDTMDF14_110    */
    __type210 CFDTMDF15_110;                               /* CFDTMDF15_110    */
    uint8  dummy477[52];                                   /* Reserved         */
    __type210 CFDTMID111;                                  /* CFDTMID111       */
    __type210 CFDTMPTR111;                                 /* CFDTMPTR111      */
    __type210 CFDTMFDCTR111;                               /* CFDTMFDCTR111    */
    __type210 CFDTMDF0_111;                                /* CFDTMDF0_111     */
    __type210 CFDTMDF1_111;                                /* CFDTMDF1_111     */
    __type210 CFDTMDF2_111;                                /* CFDTMDF2_111     */
    __type210 CFDTMDF3_111;                                /* CFDTMDF3_111     */
    __type210 CFDTMDF4_111;                                /* CFDTMDF4_111     */
    __type210 CFDTMDF5_111;                                /* CFDTMDF5_111     */
    __type210 CFDTMDF6_111;                                /* CFDTMDF6_111     */
    __type210 CFDTMDF7_111;                                /* CFDTMDF7_111     */
    __type210 CFDTMDF8_111;                                /* CFDTMDF8_111     */
    __type210 CFDTMDF9_111;                                /* CFDTMDF9_111     */
    __type210 CFDTMDF10_111;                               /* CFDTMDF10_111    */
    __type210 CFDTMDF11_111;                               /* CFDTMDF11_111    */
    __type210 CFDTMDF12_111;                               /* CFDTMDF12_111    */
    __type210 CFDTMDF13_111;                               /* CFDTMDF13_111    */
    __type210 CFDTMDF14_111;                               /* CFDTMDF14_111    */
    __type210 CFDTMDF15_111;                               /* CFDTMDF15_111    */
    uint8  dummy478[52];                                   /* Reserved         */
    __type210 CFDTMID112;                                  /* CFDTMID112       */
    __type210 CFDTMPTR112;                                 /* CFDTMPTR112      */
    __type210 CFDTMFDCTR112;                               /* CFDTMFDCTR112    */
    __type210 CFDTMDF0_112;                                /* CFDTMDF0_112     */
    __type210 CFDTMDF1_112;                                /* CFDTMDF1_112     */
    __type210 CFDTMDF2_112;                                /* CFDTMDF2_112     */
    __type210 CFDTMDF3_112;                                /* CFDTMDF3_112     */
    __type210 CFDTMDF4_112;                                /* CFDTMDF4_112     */
    __type210 CFDTMDF5_112;                                /* CFDTMDF5_112     */
    __type210 CFDTMDF6_112;                                /* CFDTMDF6_112     */
    __type210 CFDTMDF7_112;                                /* CFDTMDF7_112     */
    __type210 CFDTMDF8_112;                                /* CFDTMDF8_112     */
    __type210 CFDTMDF9_112;                                /* CFDTMDF9_112     */
    __type210 CFDTMDF10_112;                               /* CFDTMDF10_112    */
    __type210 CFDTMDF11_112;                               /* CFDTMDF11_112    */
    __type210 CFDTMDF12_112;                               /* CFDTMDF12_112    */
    __type210 CFDTMDF13_112;                               /* CFDTMDF13_112    */
    __type210 CFDTMDF14_112;                               /* CFDTMDF14_112    */
    __type210 CFDTMDF15_112;                               /* CFDTMDF15_112    */
    uint8  dummy479[52];                                   /* Reserved         */
    __type210 CFDTMID113;                                  /* CFDTMID113       */
    __type210 CFDTMPTR113;                                 /* CFDTMPTR113      */
    __type210 CFDTMFDCTR113;                               /* CFDTMFDCTR113    */
    __type210 CFDTMDF0_113;                                /* CFDTMDF0_113     */
    __type210 CFDTMDF1_113;                                /* CFDTMDF1_113     */
    __type210 CFDTMDF2_113;                                /* CFDTMDF2_113     */
    __type210 CFDTMDF3_113;                                /* CFDTMDF3_113     */
    __type210 CFDTMDF4_113;                                /* CFDTMDF4_113     */
    __type210 CFDTMDF5_113;                                /* CFDTMDF5_113     */
    __type210 CFDTMDF6_113;                                /* CFDTMDF6_113     */
    __type210 CFDTMDF7_113;                                /* CFDTMDF7_113     */
    __type210 CFDTMDF8_113;                                /* CFDTMDF8_113     */
    __type210 CFDTMDF9_113;                                /* CFDTMDF9_113     */
    __type210 CFDTMDF10_113;                               /* CFDTMDF10_113    */
    __type210 CFDTMDF11_113;                               /* CFDTMDF11_113    */
    __type210 CFDTMDF12_113;                               /* CFDTMDF12_113    */
    __type210 CFDTMDF13_113;                               /* CFDTMDF13_113    */
    __type210 CFDTMDF14_113;                               /* CFDTMDF14_113    */
    __type210 CFDTMDF15_113;                               /* CFDTMDF15_113    */
    uint8  dummy480[52];                                   /* Reserved         */
    __type210 CFDTMID114;                                  /* CFDTMID114       */
    __type210 CFDTMPTR114;                                 /* CFDTMPTR114      */
    __type210 CFDTMFDCTR114;                               /* CFDTMFDCTR114    */
    __type210 CFDTMDF0_114;                                /* CFDTMDF0_114     */
    __type210 CFDTMDF1_114;                                /* CFDTMDF1_114     */
    __type210 CFDTMDF2_114;                                /* CFDTMDF2_114     */
    __type210 CFDTMDF3_114;                                /* CFDTMDF3_114     */
    __type210 CFDTMDF4_114;                                /* CFDTMDF4_114     */
    __type210 CFDTMDF5_114;                                /* CFDTMDF5_114     */
    __type210 CFDTMDF6_114;                                /* CFDTMDF6_114     */
    __type210 CFDTMDF7_114;                                /* CFDTMDF7_114     */
    __type210 CFDTMDF8_114;                                /* CFDTMDF8_114     */
    __type210 CFDTMDF9_114;                                /* CFDTMDF9_114     */
    __type210 CFDTMDF10_114;                               /* CFDTMDF10_114    */
    __type210 CFDTMDF11_114;                               /* CFDTMDF11_114    */
    __type210 CFDTMDF12_114;                               /* CFDTMDF12_114    */
    __type210 CFDTMDF13_114;                               /* CFDTMDF13_114    */
    __type210 CFDTMDF14_114;                               /* CFDTMDF14_114    */
    __type210 CFDTMDF15_114;                               /* CFDTMDF15_114    */
    uint8  dummy481[52];                                   /* Reserved         */
    __type210 CFDTMID115;                                  /* CFDTMID115       */
    __type210 CFDTMPTR115;                                 /* CFDTMPTR115      */
    __type210 CFDTMFDCTR115;                               /* CFDTMFDCTR115    */
    __type210 CFDTMDF0_115;                                /* CFDTMDF0_115     */
    __type210 CFDTMDF1_115;                                /* CFDTMDF1_115     */
    __type210 CFDTMDF2_115;                                /* CFDTMDF2_115     */
    __type210 CFDTMDF3_115;                                /* CFDTMDF3_115     */
    __type210 CFDTMDF4_115;                                /* CFDTMDF4_115     */
    __type210 CFDTMDF5_115;                                /* CFDTMDF5_115     */
    __type210 CFDTMDF6_115;                                /* CFDTMDF6_115     */
    __type210 CFDTMDF7_115;                                /* CFDTMDF7_115     */
    __type210 CFDTMDF8_115;                                /* CFDTMDF8_115     */
    __type210 CFDTMDF9_115;                                /* CFDTMDF9_115     */
    __type210 CFDTMDF10_115;                               /* CFDTMDF10_115    */
    __type210 CFDTMDF11_115;                               /* CFDTMDF11_115    */
    __type210 CFDTMDF12_115;                               /* CFDTMDF12_115    */
    __type210 CFDTMDF13_115;                               /* CFDTMDF13_115    */
    __type210 CFDTMDF14_115;                               /* CFDTMDF14_115    */
    __type210 CFDTMDF15_115;                               /* CFDTMDF15_115    */
    uint8  dummy482[52];                                   /* Reserved         */
    __type210 CFDTMID116;                                  /* CFDTMID116       */
    __type210 CFDTMPTR116;                                 /* CFDTMPTR116      */
    __type210 CFDTMFDCTR116;                               /* CFDTMFDCTR116    */
    __type210 CFDTMDF0_116;                                /* CFDTMDF0_116     */
    __type210 CFDTMDF1_116;                                /* CFDTMDF1_116     */
    __type210 CFDTMDF2_116;                                /* CFDTMDF2_116     */
    __type210 CFDTMDF3_116;                                /* CFDTMDF3_116     */
    __type210 CFDTMDF4_116;                                /* CFDTMDF4_116     */
    __type210 CFDTMDF5_116;                                /* CFDTMDF5_116     */
    __type210 CFDTMDF6_116;                                /* CFDTMDF6_116     */
    __type210 CFDTMDF7_116;                                /* CFDTMDF7_116     */
    __type210 CFDTMDF8_116;                                /* CFDTMDF8_116     */
    __type210 CFDTMDF9_116;                                /* CFDTMDF9_116     */
    __type210 CFDTMDF10_116;                               /* CFDTMDF10_116    */
    __type210 CFDTMDF11_116;                               /* CFDTMDF11_116    */
    __type210 CFDTMDF12_116;                               /* CFDTMDF12_116    */
    __type210 CFDTMDF13_116;                               /* CFDTMDF13_116    */
    __type210 CFDTMDF14_116;                               /* CFDTMDF14_116    */
    __type210 CFDTMDF15_116;                               /* CFDTMDF15_116    */
    uint8  dummy483[52];                                   /* Reserved         */
    __type210 CFDTMID117;                                  /* CFDTMID117       */
    __type210 CFDTMPTR117;                                 /* CFDTMPTR117      */
    __type210 CFDTMFDCTR117;                               /* CFDTMFDCTR117    */
    __type210 CFDTMDF0_117;                                /* CFDTMDF0_117     */
    __type210 CFDTMDF1_117;                                /* CFDTMDF1_117     */
    __type210 CFDTMDF2_117;                                /* CFDTMDF2_117     */
    __type210 CFDTMDF3_117;                                /* CFDTMDF3_117     */
    __type210 CFDTMDF4_117;                                /* CFDTMDF4_117     */
    __type210 CFDTMDF5_117;                                /* CFDTMDF5_117     */
    __type210 CFDTMDF6_117;                                /* CFDTMDF6_117     */
    __type210 CFDTMDF7_117;                                /* CFDTMDF7_117     */
    __type210 CFDTMDF8_117;                                /* CFDTMDF8_117     */
    __type210 CFDTMDF9_117;                                /* CFDTMDF9_117     */
    __type210 CFDTMDF10_117;                               /* CFDTMDF10_117    */
    __type210 CFDTMDF11_117;                               /* CFDTMDF11_117    */
    __type210 CFDTMDF12_117;                               /* CFDTMDF12_117    */
    __type210 CFDTMDF13_117;                               /* CFDTMDF13_117    */
    __type210 CFDTMDF14_117;                               /* CFDTMDF14_117    */
    __type210 CFDTMDF15_117;                               /* CFDTMDF15_117    */
    uint8  dummy484[52];                                   /* Reserved         */
    __type210 CFDTMID118;                                  /* CFDTMID118       */
    __type210 CFDTMPTR118;                                 /* CFDTMPTR118      */
    __type210 CFDTMFDCTR118;                               /* CFDTMFDCTR118    */
    __type210 CFDTMDF0_118;                                /* CFDTMDF0_118     */
    __type210 CFDTMDF1_118;                                /* CFDTMDF1_118     */
    __type210 CFDTMDF2_118;                                /* CFDTMDF2_118     */
    __type210 CFDTMDF3_118;                                /* CFDTMDF3_118     */
    __type210 CFDTMDF4_118;                                /* CFDTMDF4_118     */
    __type210 CFDTMDF5_118;                                /* CFDTMDF5_118     */
    __type210 CFDTMDF6_118;                                /* CFDTMDF6_118     */
    __type210 CFDTMDF7_118;                                /* CFDTMDF7_118     */
    __type210 CFDTMDF8_118;                                /* CFDTMDF8_118     */
    __type210 CFDTMDF9_118;                                /* CFDTMDF9_118     */
    __type210 CFDTMDF10_118;                               /* CFDTMDF10_118    */
    __type210 CFDTMDF11_118;                               /* CFDTMDF11_118    */
    __type210 CFDTMDF12_118;                               /* CFDTMDF12_118    */
    __type210 CFDTMDF13_118;                               /* CFDTMDF13_118    */
    __type210 CFDTMDF14_118;                               /* CFDTMDF14_118    */
    __type210 CFDTMDF15_118;                               /* CFDTMDF15_118    */
    uint8  dummy485[52];                                   /* Reserved         */
    __type210 CFDTMID119;                                  /* CFDTMID119       */
    __type210 CFDTMPTR119;                                 /* CFDTMPTR119      */
    __type210 CFDTMFDCTR119;                               /* CFDTMFDCTR119    */
    __type210 CFDTMDF0_119;                                /* CFDTMDF0_119     */
    __type210 CFDTMDF1_119;                                /* CFDTMDF1_119     */
    __type210 CFDTMDF2_119;                                /* CFDTMDF2_119     */
    __type210 CFDTMDF3_119;                                /* CFDTMDF3_119     */
    __type210 CFDTMDF4_119;                                /* CFDTMDF4_119     */
    __type210 CFDTMDF5_119;                                /* CFDTMDF5_119     */
    __type210 CFDTMDF6_119;                                /* CFDTMDF6_119     */
    __type210 CFDTMDF7_119;                                /* CFDTMDF7_119     */
    __type210 CFDTMDF8_119;                                /* CFDTMDF8_119     */
    __type210 CFDTMDF9_119;                                /* CFDTMDF9_119     */
    __type210 CFDTMDF10_119;                               /* CFDTMDF10_119    */
    __type210 CFDTMDF11_119;                               /* CFDTMDF11_119    */
    __type210 CFDTMDF12_119;                               /* CFDTMDF12_119    */
    __type210 CFDTMDF13_119;                               /* CFDTMDF13_119    */
    __type210 CFDTMDF14_119;                               /* CFDTMDF14_119    */
    __type210 CFDTMDF15_119;                               /* CFDTMDF15_119    */
    uint8  dummy486[52];                                   /* Reserved         */
    __type210 CFDTMID120;                                  /* CFDTMID120       */
    __type210 CFDTMPTR120;                                 /* CFDTMPTR120      */
    __type210 CFDTMFDCTR120;                               /* CFDTMFDCTR120    */
    __type210 CFDTMDF0_120;                                /* CFDTMDF0_120     */
    __type210 CFDTMDF1_120;                                /* CFDTMDF1_120     */
    __type210 CFDTMDF2_120;                                /* CFDTMDF2_120     */
    __type210 CFDTMDF3_120;                                /* CFDTMDF3_120     */
    __type210 CFDTMDF4_120;                                /* CFDTMDF4_120     */
    __type210 CFDTMDF5_120;                                /* CFDTMDF5_120     */
    __type210 CFDTMDF6_120;                                /* CFDTMDF6_120     */
    __type210 CFDTMDF7_120;                                /* CFDTMDF7_120     */
    __type210 CFDTMDF8_120;                                /* CFDTMDF8_120     */
    __type210 CFDTMDF9_120;                                /* CFDTMDF9_120     */
    __type210 CFDTMDF10_120;                               /* CFDTMDF10_120    */
    __type210 CFDTMDF11_120;                               /* CFDTMDF11_120    */
    __type210 CFDTMDF12_120;                               /* CFDTMDF12_120    */
    __type210 CFDTMDF13_120;                               /* CFDTMDF13_120    */
    __type210 CFDTMDF14_120;                               /* CFDTMDF14_120    */
    __type210 CFDTMDF15_120;                               /* CFDTMDF15_120    */
    uint8  dummy487[52];                                   /* Reserved         */
    __type210 CFDTMID121;                                  /* CFDTMID121       */
    __type210 CFDTMPTR121;                                 /* CFDTMPTR121      */
    __type210 CFDTMFDCTR121;                               /* CFDTMFDCTR121    */
    __type210 CFDTMDF0_121;                                /* CFDTMDF0_121     */
    __type210 CFDTMDF1_121;                                /* CFDTMDF1_121     */
    __type210 CFDTMDF2_121;                                /* CFDTMDF2_121     */
    __type210 CFDTMDF3_121;                                /* CFDTMDF3_121     */
    __type210 CFDTMDF4_121;                                /* CFDTMDF4_121     */
    __type210 CFDTMDF5_121;                                /* CFDTMDF5_121     */
    __type210 CFDTMDF6_121;                                /* CFDTMDF6_121     */
    __type210 CFDTMDF7_121;                                /* CFDTMDF7_121     */
    __type210 CFDTMDF8_121;                                /* CFDTMDF8_121     */
    __type210 CFDTMDF9_121;                                /* CFDTMDF9_121     */
    __type210 CFDTMDF10_121;                               /* CFDTMDF10_121    */
    __type210 CFDTMDF11_121;                               /* CFDTMDF11_121    */
    __type210 CFDTMDF12_121;                               /* CFDTMDF12_121    */
    __type210 CFDTMDF13_121;                               /* CFDTMDF13_121    */
    __type210 CFDTMDF14_121;                               /* CFDTMDF14_121    */
    __type210 CFDTMDF15_121;                               /* CFDTMDF15_121    */
    uint8  dummy488[52];                                   /* Reserved         */
    __type210 CFDTMID122;                                  /* CFDTMID122       */
    __type210 CFDTMPTR122;                                 /* CFDTMPTR122      */
    __type210 CFDTMFDCTR122;                               /* CFDTMFDCTR122    */
    __type210 CFDTMDF0_122;                                /* CFDTMDF0_122     */
    __type210 CFDTMDF1_122;                                /* CFDTMDF1_122     */
    __type210 CFDTMDF2_122;                                /* CFDTMDF2_122     */
    __type210 CFDTMDF3_122;                                /* CFDTMDF3_122     */
    __type210 CFDTMDF4_122;                                /* CFDTMDF4_122     */
    __type210 CFDTMDF5_122;                                /* CFDTMDF5_122     */
    __type210 CFDTMDF6_122;                                /* CFDTMDF6_122     */
    __type210 CFDTMDF7_122;                                /* CFDTMDF7_122     */
    __type210 CFDTMDF8_122;                                /* CFDTMDF8_122     */
    __type210 CFDTMDF9_122;                                /* CFDTMDF9_122     */
    __type210 CFDTMDF10_122;                               /* CFDTMDF10_122    */
    __type210 CFDTMDF11_122;                               /* CFDTMDF11_122    */
    __type210 CFDTMDF12_122;                               /* CFDTMDF12_122    */
    __type210 CFDTMDF13_122;                               /* CFDTMDF13_122    */
    __type210 CFDTMDF14_122;                               /* CFDTMDF14_122    */
    __type210 CFDTMDF15_122;                               /* CFDTMDF15_122    */
    uint8  dummy489[52];                                   /* Reserved         */
    __type210 CFDTMID123;                                  /* CFDTMID123       */
    __type210 CFDTMPTR123;                                 /* CFDTMPTR123      */
    __type210 CFDTMFDCTR123;                               /* CFDTMFDCTR123    */
    __type210 CFDTMDF0_123;                                /* CFDTMDF0_123     */
    __type210 CFDTMDF1_123;                                /* CFDTMDF1_123     */
    __type210 CFDTMDF2_123;                                /* CFDTMDF2_123     */
    __type210 CFDTMDF3_123;                                /* CFDTMDF3_123     */
    __type210 CFDTMDF4_123;                                /* CFDTMDF4_123     */
    __type210 CFDTMDF5_123;                                /* CFDTMDF5_123     */
    __type210 CFDTMDF6_123;                                /* CFDTMDF6_123     */
    __type210 CFDTMDF7_123;                                /* CFDTMDF7_123     */
    __type210 CFDTMDF8_123;                                /* CFDTMDF8_123     */
    __type210 CFDTMDF9_123;                                /* CFDTMDF9_123     */
    __type210 CFDTMDF10_123;                               /* CFDTMDF10_123    */
    __type210 CFDTMDF11_123;                               /* CFDTMDF11_123    */
    __type210 CFDTMDF12_123;                               /* CFDTMDF12_123    */
    __type210 CFDTMDF13_123;                               /* CFDTMDF13_123    */
    __type210 CFDTMDF14_123;                               /* CFDTMDF14_123    */
    __type210 CFDTMDF15_123;                               /* CFDTMDF15_123    */
    uint8  dummy490[52];                                   /* Reserved         */
    __type210 CFDTMID124;                                  /* CFDTMID124       */
    __type210 CFDTMPTR124;                                 /* CFDTMPTR124      */
    __type210 CFDTMFDCTR124;                               /* CFDTMFDCTR124    */
    __type210 CFDTMDF0_124;                                /* CFDTMDF0_124     */
    __type210 CFDTMDF1_124;                                /* CFDTMDF1_124     */
    __type210 CFDTMDF2_124;                                /* CFDTMDF2_124     */
    __type210 CFDTMDF3_124;                                /* CFDTMDF3_124     */
    __type210 CFDTMDF4_124;                                /* CFDTMDF4_124     */
    __type210 CFDTMDF5_124;                                /* CFDTMDF5_124     */
    __type210 CFDTMDF6_124;                                /* CFDTMDF6_124     */
    __type210 CFDTMDF7_124;                                /* CFDTMDF7_124     */
    __type210 CFDTMDF8_124;                                /* CFDTMDF8_124     */
    __type210 CFDTMDF9_124;                                /* CFDTMDF9_124     */
    __type210 CFDTMDF10_124;                               /* CFDTMDF10_124    */
    __type210 CFDTMDF11_124;                               /* CFDTMDF11_124    */
    __type210 CFDTMDF12_124;                               /* CFDTMDF12_124    */
    __type210 CFDTMDF13_124;                               /* CFDTMDF13_124    */
    __type210 CFDTMDF14_124;                               /* CFDTMDF14_124    */
    __type210 CFDTMDF15_124;                               /* CFDTMDF15_124    */
    uint8  dummy491[52];                                   /* Reserved         */
    __type210 CFDTMID125;                                  /* CFDTMID125       */
    __type210 CFDTMPTR125;                                 /* CFDTMPTR125      */
    __type210 CFDTMFDCTR125;                               /* CFDTMFDCTR125    */
    __type210 CFDTMDF0_125;                                /* CFDTMDF0_125     */
    __type210 CFDTMDF1_125;                                /* CFDTMDF1_125     */
    __type210 CFDTMDF2_125;                                /* CFDTMDF2_125     */
    __type210 CFDTMDF3_125;                                /* CFDTMDF3_125     */
    __type210 CFDTMDF4_125;                                /* CFDTMDF4_125     */
    __type210 CFDTMDF5_125;                                /* CFDTMDF5_125     */
    __type210 CFDTMDF6_125;                                /* CFDTMDF6_125     */
    __type210 CFDTMDF7_125;                                /* CFDTMDF7_125     */
    __type210 CFDTMDF8_125;                                /* CFDTMDF8_125     */
    __type210 CFDTMDF9_125;                                /* CFDTMDF9_125     */
    __type210 CFDTMDF10_125;                               /* CFDTMDF10_125    */
    __type210 CFDTMDF11_125;                               /* CFDTMDF11_125    */
    __type210 CFDTMDF12_125;                               /* CFDTMDF12_125    */
    __type210 CFDTMDF13_125;                               /* CFDTMDF13_125    */
    __type210 CFDTMDF14_125;                               /* CFDTMDF14_125    */
    __type210 CFDTMDF15_125;                               /* CFDTMDF15_125    */
    uint8  dummy492[52];                                   /* Reserved         */
    __type210 CFDTMID126;                                  /* CFDTMID126       */
    __type210 CFDTMPTR126;                                 /* CFDTMPTR126      */
    __type210 CFDTMFDCTR126;                               /* CFDTMFDCTR126    */
    __type210 CFDTMDF0_126;                                /* CFDTMDF0_126     */
    __type210 CFDTMDF1_126;                                /* CFDTMDF1_126     */
    __type210 CFDTMDF2_126;                                /* CFDTMDF2_126     */
    __type210 CFDTMDF3_126;                                /* CFDTMDF3_126     */
    __type210 CFDTMDF4_126;                                /* CFDTMDF4_126     */
    __type210 CFDTMDF5_126;                                /* CFDTMDF5_126     */
    __type210 CFDTMDF6_126;                                /* CFDTMDF6_126     */
    __type210 CFDTMDF7_126;                                /* CFDTMDF7_126     */
    __type210 CFDTMDF8_126;                                /* CFDTMDF8_126     */
    __type210 CFDTMDF9_126;                                /* CFDTMDF9_126     */
    __type210 CFDTMDF10_126;                               /* CFDTMDF10_126    */
    __type210 CFDTMDF11_126;                               /* CFDTMDF11_126    */
    __type210 CFDTMDF12_126;                               /* CFDTMDF12_126    */
    __type210 CFDTMDF13_126;                               /* CFDTMDF13_126    */
    __type210 CFDTMDF14_126;                               /* CFDTMDF14_126    */
    __type210 CFDTMDF15_126;                               /* CFDTMDF15_126    */
    uint8  dummy493[52];                                   /* Reserved         */
    __type210 CFDTMID127;                                  /* CFDTMID127       */
    __type210 CFDTMPTR127;                                 /* CFDTMPTR127      */
    __type210 CFDTMFDCTR127;                               /* CFDTMFDCTR127    */
    __type210 CFDTMDF0_127;                                /* CFDTMDF0_127     */
    __type210 CFDTMDF1_127;                                /* CFDTMDF1_127     */
    __type210 CFDTMDF2_127;                                /* CFDTMDF2_127     */
    __type210 CFDTMDF3_127;                                /* CFDTMDF3_127     */
    __type210 CFDTMDF4_127;                                /* CFDTMDF4_127     */
    __type210 CFDTMDF5_127;                                /* CFDTMDF5_127     */
    __type210 CFDTMDF6_127;                                /* CFDTMDF6_127     */
    __type210 CFDTMDF7_127;                                /* CFDTMDF7_127     */
    __type210 CFDTMDF8_127;                                /* CFDTMDF8_127     */
    __type210 CFDTMDF9_127;                                /* CFDTMDF9_127     */
    __type210 CFDTMDF10_127;                               /* CFDTMDF10_127    */
    __type210 CFDTMDF11_127;                               /* CFDTMDF11_127    */
    __type210 CFDTMDF12_127;                               /* CFDTMDF12_127    */
    __type210 CFDTMDF13_127;                               /* CFDTMDF13_127    */
    __type210 CFDTMDF14_127;                               /* CFDTMDF14_127    */
    __type210 CFDTMDF15_127;                               /* CFDTMDF15_127    */
    uint8  dummy494[52];                                   /* Reserved         */
    __type210 CFDTMID128;                                  /* CFDTMID128       */
    __type210 CFDTMPTR128;                                 /* CFDTMPTR128      */
    __type210 CFDTMFDCTR128;                               /* CFDTMFDCTR128    */
    __type210 CFDTMDF0_128;                                /* CFDTMDF0_128     */
    __type210 CFDTMDF1_128;                                /* CFDTMDF1_128     */
    __type210 CFDTMDF2_128;                                /* CFDTMDF2_128     */
    __type210 CFDTMDF3_128;                                /* CFDTMDF3_128     */
    __type210 CFDTMDF4_128;                                /* CFDTMDF4_128     */
    __type210 CFDTMDF5_128;                                /* CFDTMDF5_128     */
    __type210 CFDTMDF6_128;                                /* CFDTMDF6_128     */
    __type210 CFDTMDF7_128;                                /* CFDTMDF7_128     */
    __type210 CFDTMDF8_128;                                /* CFDTMDF8_128     */
    __type210 CFDTMDF9_128;                                /* CFDTMDF9_128     */
    __type210 CFDTMDF10_128;                               /* CFDTMDF10_128    */
    __type210 CFDTMDF11_128;                               /* CFDTMDF11_128    */
    __type210 CFDTMDF12_128;                               /* CFDTMDF12_128    */
    __type210 CFDTMDF13_128;                               /* CFDTMDF13_128    */
    __type210 CFDTMDF14_128;                               /* CFDTMDF14_128    */
    __type210 CFDTMDF15_128;                               /* CFDTMDF15_128    */
    uint8  dummy495[52];                                   /* Reserved         */
    __type210 CFDTMID129;                                  /* CFDTMID129       */
    __type210 CFDTMPTR129;                                 /* CFDTMPTR129      */
    __type210 CFDTMFDCTR129;                               /* CFDTMFDCTR129    */
    __type210 CFDTMDF0_129;                                /* CFDTMDF0_129     */
    __type210 CFDTMDF1_129;                                /* CFDTMDF1_129     */
    __type210 CFDTMDF2_129;                                /* CFDTMDF2_129     */
    __type210 CFDTMDF3_129;                                /* CFDTMDF3_129     */
    __type210 CFDTMDF4_129;                                /* CFDTMDF4_129     */
    __type210 CFDTMDF5_129;                                /* CFDTMDF5_129     */
    __type210 CFDTMDF6_129;                                /* CFDTMDF6_129     */
    __type210 CFDTMDF7_129;                                /* CFDTMDF7_129     */
    __type210 CFDTMDF8_129;                                /* CFDTMDF8_129     */
    __type210 CFDTMDF9_129;                                /* CFDTMDF9_129     */
    __type210 CFDTMDF10_129;                               /* CFDTMDF10_129    */
    __type210 CFDTMDF11_129;                               /* CFDTMDF11_129    */
    __type210 CFDTMDF12_129;                               /* CFDTMDF12_129    */
    __type210 CFDTMDF13_129;                               /* CFDTMDF13_129    */
    __type210 CFDTMDF14_129;                               /* CFDTMDF14_129    */
    __type210 CFDTMDF15_129;                               /* CFDTMDF15_129    */
    uint8  dummy496[52];                                   /* Reserved         */
    __type210 CFDTMID130;                                  /* CFDTMID130       */
    __type210 CFDTMPTR130;                                 /* CFDTMPTR130      */
    __type210 CFDTMFDCTR130;                               /* CFDTMFDCTR130    */
    __type210 CFDTMDF0_130;                                /* CFDTMDF0_130     */
    __type210 CFDTMDF1_130;                                /* CFDTMDF1_130     */
    __type210 CFDTMDF2_130;                                /* CFDTMDF2_130     */
    __type210 CFDTMDF3_130;                                /* CFDTMDF3_130     */
    __type210 CFDTMDF4_130;                                /* CFDTMDF4_130     */
    __type210 CFDTMDF5_130;                                /* CFDTMDF5_130     */
    __type210 CFDTMDF6_130;                                /* CFDTMDF6_130     */
    __type210 CFDTMDF7_130;                                /* CFDTMDF7_130     */
    __type210 CFDTMDF8_130;                                /* CFDTMDF8_130     */
    __type210 CFDTMDF9_130;                                /* CFDTMDF9_130     */
    __type210 CFDTMDF10_130;                               /* CFDTMDF10_130    */
    __type210 CFDTMDF11_130;                               /* CFDTMDF11_130    */
    __type210 CFDTMDF12_130;                               /* CFDTMDF12_130    */
    __type210 CFDTMDF13_130;                               /* CFDTMDF13_130    */
    __type210 CFDTMDF14_130;                               /* CFDTMDF14_130    */
    __type210 CFDTMDF15_130;                               /* CFDTMDF15_130    */
    uint8  dummy497[52];                                   /* Reserved         */
    __type210 CFDTMID131;                                  /* CFDTMID131       */
    __type210 CFDTMPTR131;                                 /* CFDTMPTR131      */
    __type210 CFDTMFDCTR131;                               /* CFDTMFDCTR131    */
    __type210 CFDTMDF0_131;                                /* CFDTMDF0_131     */
    __type210 CFDTMDF1_131;                                /* CFDTMDF1_131     */
    __type210 CFDTMDF2_131;                                /* CFDTMDF2_131     */
    __type210 CFDTMDF3_131;                                /* CFDTMDF3_131     */
    __type210 CFDTMDF4_131;                                /* CFDTMDF4_131     */
    __type210 CFDTMDF5_131;                                /* CFDTMDF5_131     */
    __type210 CFDTMDF6_131;                                /* CFDTMDF6_131     */
    __type210 CFDTMDF7_131;                                /* CFDTMDF7_131     */
    __type210 CFDTMDF8_131;                                /* CFDTMDF8_131     */
    __type210 CFDTMDF9_131;                                /* CFDTMDF9_131     */
    __type210 CFDTMDF10_131;                               /* CFDTMDF10_131    */
    __type210 CFDTMDF11_131;                               /* CFDTMDF11_131    */
    __type210 CFDTMDF12_131;                               /* CFDTMDF12_131    */
    __type210 CFDTMDF13_131;                               /* CFDTMDF13_131    */
    __type210 CFDTMDF14_131;                               /* CFDTMDF14_131    */
    __type210 CFDTMDF15_131;                               /* CFDTMDF15_131    */
    uint8  dummy498[52];                                   /* Reserved         */
    __type210 CFDTMID132;                                  /* CFDTMID132       */
    __type210 CFDTMPTR132;                                 /* CFDTMPTR132      */
    __type210 CFDTMFDCTR132;                               /* CFDTMFDCTR132    */
    __type210 CFDTMDF0_132;                                /* CFDTMDF0_132     */
    __type210 CFDTMDF1_132;                                /* CFDTMDF1_132     */
    __type210 CFDTMDF2_132;                                /* CFDTMDF2_132     */
    __type210 CFDTMDF3_132;                                /* CFDTMDF3_132     */
    __type210 CFDTMDF4_132;                                /* CFDTMDF4_132     */
    __type210 CFDTMDF5_132;                                /* CFDTMDF5_132     */
    __type210 CFDTMDF6_132;                                /* CFDTMDF6_132     */
    __type210 CFDTMDF7_132;                                /* CFDTMDF7_132     */
    __type210 CFDTMDF8_132;                                /* CFDTMDF8_132     */
    __type210 CFDTMDF9_132;                                /* CFDTMDF9_132     */
    __type210 CFDTMDF10_132;                               /* CFDTMDF10_132    */
    __type210 CFDTMDF11_132;                               /* CFDTMDF11_132    */
    __type210 CFDTMDF12_132;                               /* CFDTMDF12_132    */
    __type210 CFDTMDF13_132;                               /* CFDTMDF13_132    */
    __type210 CFDTMDF14_132;                               /* CFDTMDF14_132    */
    __type210 CFDTMDF15_132;                               /* CFDTMDF15_132    */
    uint8  dummy499[52];                                   /* Reserved         */
    __type210 CFDTMID133;                                  /* CFDTMID133       */
    __type210 CFDTMPTR133;                                 /* CFDTMPTR133      */
    __type210 CFDTMFDCTR133;                               /* CFDTMFDCTR133    */
    __type210 CFDTMDF0_133;                                /* CFDTMDF0_133     */
    __type210 CFDTMDF1_133;                                /* CFDTMDF1_133     */
    __type210 CFDTMDF2_133;                                /* CFDTMDF2_133     */
    __type210 CFDTMDF3_133;                                /* CFDTMDF3_133     */
    __type210 CFDTMDF4_133;                                /* CFDTMDF4_133     */
    __type210 CFDTMDF5_133;                                /* CFDTMDF5_133     */
    __type210 CFDTMDF6_133;                                /* CFDTMDF6_133     */
    __type210 CFDTMDF7_133;                                /* CFDTMDF7_133     */
    __type210 CFDTMDF8_133;                                /* CFDTMDF8_133     */
    __type210 CFDTMDF9_133;                                /* CFDTMDF9_133     */
    __type210 CFDTMDF10_133;                               /* CFDTMDF10_133    */
    __type210 CFDTMDF11_133;                               /* CFDTMDF11_133    */
    __type210 CFDTMDF12_133;                               /* CFDTMDF12_133    */
    __type210 CFDTMDF13_133;                               /* CFDTMDF13_133    */
    __type210 CFDTMDF14_133;                               /* CFDTMDF14_133    */
    __type210 CFDTMDF15_133;                               /* CFDTMDF15_133    */
    uint8  dummy500[52];                                   /* Reserved         */
    __type210 CFDTMID134;                                  /* CFDTMID134       */
    __type210 CFDTMPTR134;                                 /* CFDTMPTR134      */
    __type210 CFDTMFDCTR134;                               /* CFDTMFDCTR134    */
    __type210 CFDTMDF0_134;                                /* CFDTMDF0_134     */
    __type210 CFDTMDF1_134;                                /* CFDTMDF1_134     */
    __type210 CFDTMDF2_134;                                /* CFDTMDF2_134     */
    __type210 CFDTMDF3_134;                                /* CFDTMDF3_134     */
    __type210 CFDTMDF4_134;                                /* CFDTMDF4_134     */
    __type210 CFDTMDF5_134;                                /* CFDTMDF5_134     */
    __type210 CFDTMDF6_134;                                /* CFDTMDF6_134     */
    __type210 CFDTMDF7_134;                                /* CFDTMDF7_134     */
    __type210 CFDTMDF8_134;                                /* CFDTMDF8_134     */
    __type210 CFDTMDF9_134;                                /* CFDTMDF9_134     */
    __type210 CFDTMDF10_134;                               /* CFDTMDF10_134    */
    __type210 CFDTMDF11_134;                               /* CFDTMDF11_134    */
    __type210 CFDTMDF12_134;                               /* CFDTMDF12_134    */
    __type210 CFDTMDF13_134;                               /* CFDTMDF13_134    */
    __type210 CFDTMDF14_134;                               /* CFDTMDF14_134    */
    __type210 CFDTMDF15_134;                               /* CFDTMDF15_134    */
    uint8  dummy501[52];                                   /* Reserved         */
    __type210 CFDTMID135;                                  /* CFDTMID135       */
    __type210 CFDTMPTR135;                                 /* CFDTMPTR135      */
    __type210 CFDTMFDCTR135;                               /* CFDTMFDCTR135    */
    __type210 CFDTMDF0_135;                                /* CFDTMDF0_135     */
    __type210 CFDTMDF1_135;                                /* CFDTMDF1_135     */
    __type210 CFDTMDF2_135;                                /* CFDTMDF2_135     */
    __type210 CFDTMDF3_135;                                /* CFDTMDF3_135     */
    __type210 CFDTMDF4_135;                                /* CFDTMDF4_135     */
    __type210 CFDTMDF5_135;                                /* CFDTMDF5_135     */
    __type210 CFDTMDF6_135;                                /* CFDTMDF6_135     */
    __type210 CFDTMDF7_135;                                /* CFDTMDF7_135     */
    __type210 CFDTMDF8_135;                                /* CFDTMDF8_135     */
    __type210 CFDTMDF9_135;                                /* CFDTMDF9_135     */
    __type210 CFDTMDF10_135;                               /* CFDTMDF10_135    */
    __type210 CFDTMDF11_135;                               /* CFDTMDF11_135    */
    __type210 CFDTMDF12_135;                               /* CFDTMDF12_135    */
    __type210 CFDTMDF13_135;                               /* CFDTMDF13_135    */
    __type210 CFDTMDF14_135;                               /* CFDTMDF14_135    */
    __type210 CFDTMDF15_135;                               /* CFDTMDF15_135    */
    uint8  dummy502[52];                                   /* Reserved         */
    __type210 CFDTMID136;                                  /* CFDTMID136       */
    __type210 CFDTMPTR136;                                 /* CFDTMPTR136      */
    __type210 CFDTMFDCTR136;                               /* CFDTMFDCTR136    */
    __type210 CFDTMDF0_136;                                /* CFDTMDF0_136     */
    __type210 CFDTMDF1_136;                                /* CFDTMDF1_136     */
    __type210 CFDTMDF2_136;                                /* CFDTMDF2_136     */
    __type210 CFDTMDF3_136;                                /* CFDTMDF3_136     */
    __type210 CFDTMDF4_136;                                /* CFDTMDF4_136     */
    __type210 CFDTMDF5_136;                                /* CFDTMDF5_136     */
    __type210 CFDTMDF6_136;                                /* CFDTMDF6_136     */
    __type210 CFDTMDF7_136;                                /* CFDTMDF7_136     */
    __type210 CFDTMDF8_136;                                /* CFDTMDF8_136     */
    __type210 CFDTMDF9_136;                                /* CFDTMDF9_136     */
    __type210 CFDTMDF10_136;                               /* CFDTMDF10_136    */
    __type210 CFDTMDF11_136;                               /* CFDTMDF11_136    */
    __type210 CFDTMDF12_136;                               /* CFDTMDF12_136    */
    __type210 CFDTMDF13_136;                               /* CFDTMDF13_136    */
    __type210 CFDTMDF14_136;                               /* CFDTMDF14_136    */
    __type210 CFDTMDF15_136;                               /* CFDTMDF15_136    */
    uint8  dummy503[52];                                   /* Reserved         */
    __type210 CFDTMID137;                                  /* CFDTMID137       */
    __type210 CFDTMPTR137;                                 /* CFDTMPTR137      */
    __type210 CFDTMFDCTR137;                               /* CFDTMFDCTR137    */
    __type210 CFDTMDF0_137;                                /* CFDTMDF0_137     */
    __type210 CFDTMDF1_137;                                /* CFDTMDF1_137     */
    __type210 CFDTMDF2_137;                                /* CFDTMDF2_137     */
    __type210 CFDTMDF3_137;                                /* CFDTMDF3_137     */
    __type210 CFDTMDF4_137;                                /* CFDTMDF4_137     */
    __type210 CFDTMDF5_137;                                /* CFDTMDF5_137     */
    __type210 CFDTMDF6_137;                                /* CFDTMDF6_137     */
    __type210 CFDTMDF7_137;                                /* CFDTMDF7_137     */
    __type210 CFDTMDF8_137;                                /* CFDTMDF8_137     */
    __type210 CFDTMDF9_137;                                /* CFDTMDF9_137     */
    __type210 CFDTMDF10_137;                               /* CFDTMDF10_137    */
    __type210 CFDTMDF11_137;                               /* CFDTMDF11_137    */
    __type210 CFDTMDF12_137;                               /* CFDTMDF12_137    */
    __type210 CFDTMDF13_137;                               /* CFDTMDF13_137    */
    __type210 CFDTMDF14_137;                               /* CFDTMDF14_137    */
    __type210 CFDTMDF15_137;                               /* CFDTMDF15_137    */
    uint8  dummy504[52];                                   /* Reserved         */
    __type210 CFDTMID138;                                  /* CFDTMID138       */
    __type210 CFDTMPTR138;                                 /* CFDTMPTR138      */
    __type210 CFDTMFDCTR138;                               /* CFDTMFDCTR138    */
    __type210 CFDTMDF0_138;                                /* CFDTMDF0_138     */
    __type210 CFDTMDF1_138;                                /* CFDTMDF1_138     */
    __type210 CFDTMDF2_138;                                /* CFDTMDF2_138     */
    __type210 CFDTMDF3_138;                                /* CFDTMDF3_138     */
    __type210 CFDTMDF4_138;                                /* CFDTMDF4_138     */
    __type210 CFDTMDF5_138;                                /* CFDTMDF5_138     */
    __type210 CFDTMDF6_138;                                /* CFDTMDF6_138     */
    __type210 CFDTMDF7_138;                                /* CFDTMDF7_138     */
    __type210 CFDTMDF8_138;                                /* CFDTMDF8_138     */
    __type210 CFDTMDF9_138;                                /* CFDTMDF9_138     */
    __type210 CFDTMDF10_138;                               /* CFDTMDF10_138    */
    __type210 CFDTMDF11_138;                               /* CFDTMDF11_138    */
    __type210 CFDTMDF12_138;                               /* CFDTMDF12_138    */
    __type210 CFDTMDF13_138;                               /* CFDTMDF13_138    */
    __type210 CFDTMDF14_138;                               /* CFDTMDF14_138    */
    __type210 CFDTMDF15_138;                               /* CFDTMDF15_138    */
    uint8  dummy505[52];                                   /* Reserved         */
    __type210 CFDTMID139;                                  /* CFDTMID139       */
    __type210 CFDTMPTR139;                                 /* CFDTMPTR139      */
    __type210 CFDTMFDCTR139;                               /* CFDTMFDCTR139    */
    __type210 CFDTMDF0_139;                                /* CFDTMDF0_139     */
    __type210 CFDTMDF1_139;                                /* CFDTMDF1_139     */
    __type210 CFDTMDF2_139;                                /* CFDTMDF2_139     */
    __type210 CFDTMDF3_139;                                /* CFDTMDF3_139     */
    __type210 CFDTMDF4_139;                                /* CFDTMDF4_139     */
    __type210 CFDTMDF5_139;                                /* CFDTMDF5_139     */
    __type210 CFDTMDF6_139;                                /* CFDTMDF6_139     */
    __type210 CFDTMDF7_139;                                /* CFDTMDF7_139     */
    __type210 CFDTMDF8_139;                                /* CFDTMDF8_139     */
    __type210 CFDTMDF9_139;                                /* CFDTMDF9_139     */
    __type210 CFDTMDF10_139;                               /* CFDTMDF10_139    */
    __type210 CFDTMDF11_139;                               /* CFDTMDF11_139    */
    __type210 CFDTMDF12_139;                               /* CFDTMDF12_139    */
    __type210 CFDTMDF13_139;                               /* CFDTMDF13_139    */
    __type210 CFDTMDF14_139;                               /* CFDTMDF14_139    */
    __type210 CFDTMDF15_139;                               /* CFDTMDF15_139    */
    uint8  dummy506[52];                                   /* Reserved         */
    __type210 CFDTMID140;                                  /* CFDTMID140       */
    __type210 CFDTMPTR140;                                 /* CFDTMPTR140      */
    __type210 CFDTMFDCTR140;                               /* CFDTMFDCTR140    */
    __type210 CFDTMDF0_140;                                /* CFDTMDF0_140     */
    __type210 CFDTMDF1_140;                                /* CFDTMDF1_140     */
    __type210 CFDTMDF2_140;                                /* CFDTMDF2_140     */
    __type210 CFDTMDF3_140;                                /* CFDTMDF3_140     */
    __type210 CFDTMDF4_140;                                /* CFDTMDF4_140     */
    __type210 CFDTMDF5_140;                                /* CFDTMDF5_140     */
    __type210 CFDTMDF6_140;                                /* CFDTMDF6_140     */
    __type210 CFDTMDF7_140;                                /* CFDTMDF7_140     */
    __type210 CFDTMDF8_140;                                /* CFDTMDF8_140     */
    __type210 CFDTMDF9_140;                                /* CFDTMDF9_140     */
    __type210 CFDTMDF10_140;                               /* CFDTMDF10_140    */
    __type210 CFDTMDF11_140;                               /* CFDTMDF11_140    */
    __type210 CFDTMDF12_140;                               /* CFDTMDF12_140    */
    __type210 CFDTMDF13_140;                               /* CFDTMDF13_140    */
    __type210 CFDTMDF14_140;                               /* CFDTMDF14_140    */
    __type210 CFDTMDF15_140;                               /* CFDTMDF15_140    */
    uint8  dummy507[52];                                   /* Reserved         */
    __type210 CFDTMID141;                                  /* CFDTMID141       */
    __type210 CFDTMPTR141;                                 /* CFDTMPTR141      */
    __type210 CFDTMFDCTR141;                               /* CFDTMFDCTR141    */
    __type210 CFDTMDF0_141;                                /* CFDTMDF0_141     */
    __type210 CFDTMDF1_141;                                /* CFDTMDF1_141     */
    __type210 CFDTMDF2_141;                                /* CFDTMDF2_141     */
    __type210 CFDTMDF3_141;                                /* CFDTMDF3_141     */
    __type210 CFDTMDF4_141;                                /* CFDTMDF4_141     */
    __type210 CFDTMDF5_141;                                /* CFDTMDF5_141     */
    __type210 CFDTMDF6_141;                                /* CFDTMDF6_141     */
    __type210 CFDTMDF7_141;                                /* CFDTMDF7_141     */
    __type210 CFDTMDF8_141;                                /* CFDTMDF8_141     */
    __type210 CFDTMDF9_141;                                /* CFDTMDF9_141     */
    __type210 CFDTMDF10_141;                               /* CFDTMDF10_141    */
    __type210 CFDTMDF11_141;                               /* CFDTMDF11_141    */
    __type210 CFDTMDF12_141;                               /* CFDTMDF12_141    */
    __type210 CFDTMDF13_141;                               /* CFDTMDF13_141    */
    __type210 CFDTMDF14_141;                               /* CFDTMDF14_141    */
    __type210 CFDTMDF15_141;                               /* CFDTMDF15_141    */
    uint8  dummy508[52];                                   /* Reserved         */
    __type210 CFDTMID142;                                  /* CFDTMID142       */
    __type210 CFDTMPTR142;                                 /* CFDTMPTR142      */
    __type210 CFDTMFDCTR142;                               /* CFDTMFDCTR142    */
    __type210 CFDTMDF0_142;                                /* CFDTMDF0_142     */
    __type210 CFDTMDF1_142;                                /* CFDTMDF1_142     */
    __type210 CFDTMDF2_142;                                /* CFDTMDF2_142     */
    __type210 CFDTMDF3_142;                                /* CFDTMDF3_142     */
    __type210 CFDTMDF4_142;                                /* CFDTMDF4_142     */
    __type210 CFDTMDF5_142;                                /* CFDTMDF5_142     */
    __type210 CFDTMDF6_142;                                /* CFDTMDF6_142     */
    __type210 CFDTMDF7_142;                                /* CFDTMDF7_142     */
    __type210 CFDTMDF8_142;                                /* CFDTMDF8_142     */
    __type210 CFDTMDF9_142;                                /* CFDTMDF9_142     */
    __type210 CFDTMDF10_142;                               /* CFDTMDF10_142    */
    __type210 CFDTMDF11_142;                               /* CFDTMDF11_142    */
    __type210 CFDTMDF12_142;                               /* CFDTMDF12_142    */
    __type210 CFDTMDF13_142;                               /* CFDTMDF13_142    */
    __type210 CFDTMDF14_142;                               /* CFDTMDF14_142    */
    __type210 CFDTMDF15_142;                               /* CFDTMDF15_142    */
    uint8  dummy509[52];                                   /* Reserved         */
    __type210 CFDTMID143;                                  /* CFDTMID143       */
    __type210 CFDTMPTR143;                                 /* CFDTMPTR143      */
    __type210 CFDTMFDCTR143;                               /* CFDTMFDCTR143    */
    __type210 CFDTMDF0_143;                                /* CFDTMDF0_143     */
    __type210 CFDTMDF1_143;                                /* CFDTMDF1_143     */
    __type210 CFDTMDF2_143;                                /* CFDTMDF2_143     */
    __type210 CFDTMDF3_143;                                /* CFDTMDF3_143     */
    __type210 CFDTMDF4_143;                                /* CFDTMDF4_143     */
    __type210 CFDTMDF5_143;                                /* CFDTMDF5_143     */
    __type210 CFDTMDF6_143;                                /* CFDTMDF6_143     */
    __type210 CFDTMDF7_143;                                /* CFDTMDF7_143     */
    __type210 CFDTMDF8_143;                                /* CFDTMDF8_143     */
    __type210 CFDTMDF9_143;                                /* CFDTMDF9_143     */
    __type210 CFDTMDF10_143;                               /* CFDTMDF10_143    */
    __type210 CFDTMDF11_143;                               /* CFDTMDF11_143    */
    __type210 CFDTMDF12_143;                               /* CFDTMDF12_143    */
    __type210 CFDTMDF13_143;                               /* CFDTMDF13_143    */
    __type210 CFDTMDF14_143;                               /* CFDTMDF14_143    */
    __type210 CFDTMDF15_143;                               /* CFDTMDF15_143    */
    uint8  dummy510[52];                                   /* Reserved         */
    __type210 CFDTMID144;                                  /* CFDTMID144       */
    __type210 CFDTMPTR144;                                 /* CFDTMPTR144      */
    __type210 CFDTMFDCTR144;                               /* CFDTMFDCTR144    */
    __type210 CFDTMDF0_144;                                /* CFDTMDF0_144     */
    __type210 CFDTMDF1_144;                                /* CFDTMDF1_144     */
    __type210 CFDTMDF2_144;                                /* CFDTMDF2_144     */
    __type210 CFDTMDF3_144;                                /* CFDTMDF3_144     */
    __type210 CFDTMDF4_144;                                /* CFDTMDF4_144     */
    __type210 CFDTMDF5_144;                                /* CFDTMDF5_144     */
    __type210 CFDTMDF6_144;                                /* CFDTMDF6_144     */
    __type210 CFDTMDF7_144;                                /* CFDTMDF7_144     */
    __type210 CFDTMDF8_144;                                /* CFDTMDF8_144     */
    __type210 CFDTMDF9_144;                                /* CFDTMDF9_144     */
    __type210 CFDTMDF10_144;                               /* CFDTMDF10_144    */
    __type210 CFDTMDF11_144;                               /* CFDTMDF11_144    */
    __type210 CFDTMDF12_144;                               /* CFDTMDF12_144    */
    __type210 CFDTMDF13_144;                               /* CFDTMDF13_144    */
    __type210 CFDTMDF14_144;                               /* CFDTMDF14_144    */
    __type210 CFDTMDF15_144;                               /* CFDTMDF15_144    */
    uint8  dummy511[52];                                   /* Reserved         */
    __type210 CFDTMID145;                                  /* CFDTMID145       */
    __type210 CFDTMPTR145;                                 /* CFDTMPTR145      */
    __type210 CFDTMFDCTR145;                               /* CFDTMFDCTR145    */
    __type210 CFDTMDF0_145;                                /* CFDTMDF0_145     */
    __type210 CFDTMDF1_145;                                /* CFDTMDF1_145     */
    __type210 CFDTMDF2_145;                                /* CFDTMDF2_145     */
    __type210 CFDTMDF3_145;                                /* CFDTMDF3_145     */
    __type210 CFDTMDF4_145;                                /* CFDTMDF4_145     */
    __type210 CFDTMDF5_145;                                /* CFDTMDF5_145     */
    __type210 CFDTMDF6_145;                                /* CFDTMDF6_145     */
    __type210 CFDTMDF7_145;                                /* CFDTMDF7_145     */
    __type210 CFDTMDF8_145;                                /* CFDTMDF8_145     */
    __type210 CFDTMDF9_145;                                /* CFDTMDF9_145     */
    __type210 CFDTMDF10_145;                               /* CFDTMDF10_145    */
    __type210 CFDTMDF11_145;                               /* CFDTMDF11_145    */
    __type210 CFDTMDF12_145;                               /* CFDTMDF12_145    */
    __type210 CFDTMDF13_145;                               /* CFDTMDF13_145    */
    __type210 CFDTMDF14_145;                               /* CFDTMDF14_145    */
    __type210 CFDTMDF15_145;                               /* CFDTMDF15_145    */
    uint8  dummy512[52];                                   /* Reserved         */
    __type210 CFDTMID146;                                  /* CFDTMID146       */
    __type210 CFDTMPTR146;                                 /* CFDTMPTR146      */
    __type210 CFDTMFDCTR146;                               /* CFDTMFDCTR146    */
    __type210 CFDTMDF0_146;                                /* CFDTMDF0_146     */
    __type210 CFDTMDF1_146;                                /* CFDTMDF1_146     */
    __type210 CFDTMDF2_146;                                /* CFDTMDF2_146     */
    __type210 CFDTMDF3_146;                                /* CFDTMDF3_146     */
    __type210 CFDTMDF4_146;                                /* CFDTMDF4_146     */
    __type210 CFDTMDF5_146;                                /* CFDTMDF5_146     */
    __type210 CFDTMDF6_146;                                /* CFDTMDF6_146     */
    __type210 CFDTMDF7_146;                                /* CFDTMDF7_146     */
    __type210 CFDTMDF8_146;                                /* CFDTMDF8_146     */
    __type210 CFDTMDF9_146;                                /* CFDTMDF9_146     */
    __type210 CFDTMDF10_146;                               /* CFDTMDF10_146    */
    __type210 CFDTMDF11_146;                               /* CFDTMDF11_146    */
    __type210 CFDTMDF12_146;                               /* CFDTMDF12_146    */
    __type210 CFDTMDF13_146;                               /* CFDTMDF13_146    */
    __type210 CFDTMDF14_146;                               /* CFDTMDF14_146    */
    __type210 CFDTMDF15_146;                               /* CFDTMDF15_146    */
    uint8  dummy513[52];                                   /* Reserved         */
    __type210 CFDTMID147;                                  /* CFDTMID147       */
    __type210 CFDTMPTR147;                                 /* CFDTMPTR147      */
    __type210 CFDTMFDCTR147;                               /* CFDTMFDCTR147    */
    __type210 CFDTMDF0_147;                                /* CFDTMDF0_147     */
    __type210 CFDTMDF1_147;                                /* CFDTMDF1_147     */
    __type210 CFDTMDF2_147;                                /* CFDTMDF2_147     */
    __type210 CFDTMDF3_147;                                /* CFDTMDF3_147     */
    __type210 CFDTMDF4_147;                                /* CFDTMDF4_147     */
    __type210 CFDTMDF5_147;                                /* CFDTMDF5_147     */
    __type210 CFDTMDF6_147;                                /* CFDTMDF6_147     */
    __type210 CFDTMDF7_147;                                /* CFDTMDF7_147     */
    __type210 CFDTMDF8_147;                                /* CFDTMDF8_147     */
    __type210 CFDTMDF9_147;                                /* CFDTMDF9_147     */
    __type210 CFDTMDF10_147;                               /* CFDTMDF10_147    */
    __type210 CFDTMDF11_147;                               /* CFDTMDF11_147    */
    __type210 CFDTMDF12_147;                               /* CFDTMDF12_147    */
    __type210 CFDTMDF13_147;                               /* CFDTMDF13_147    */
    __type210 CFDTMDF14_147;                               /* CFDTMDF14_147    */
    __type210 CFDTMDF15_147;                               /* CFDTMDF15_147    */
    uint8  dummy514[52];                                   /* Reserved         */
    __type210 CFDTMID148;                                  /* CFDTMID148       */
    __type210 CFDTMPTR148;                                 /* CFDTMPTR148      */
    __type210 CFDTMFDCTR148;                               /* CFDTMFDCTR148    */
    __type210 CFDTMDF0_148;                                /* CFDTMDF0_148     */
    __type210 CFDTMDF1_148;                                /* CFDTMDF1_148     */
    __type210 CFDTMDF2_148;                                /* CFDTMDF2_148     */
    __type210 CFDTMDF3_148;                                /* CFDTMDF3_148     */
    __type210 CFDTMDF4_148;                                /* CFDTMDF4_148     */
    __type210 CFDTMDF5_148;                                /* CFDTMDF5_148     */
    __type210 CFDTMDF6_148;                                /* CFDTMDF6_148     */
    __type210 CFDTMDF7_148;                                /* CFDTMDF7_148     */
    __type210 CFDTMDF8_148;                                /* CFDTMDF8_148     */
    __type210 CFDTMDF9_148;                                /* CFDTMDF9_148     */
    __type210 CFDTMDF10_148;                               /* CFDTMDF10_148    */
    __type210 CFDTMDF11_148;                               /* CFDTMDF11_148    */
    __type210 CFDTMDF12_148;                               /* CFDTMDF12_148    */
    __type210 CFDTMDF13_148;                               /* CFDTMDF13_148    */
    __type210 CFDTMDF14_148;                               /* CFDTMDF14_148    */
    __type210 CFDTMDF15_148;                               /* CFDTMDF15_148    */
    uint8  dummy515[52];                                   /* Reserved         */
    __type210 CFDTMID149;                                  /* CFDTMID149       */
    __type210 CFDTMPTR149;                                 /* CFDTMPTR149      */
    __type210 CFDTMFDCTR149;                               /* CFDTMFDCTR149    */
    __type210 CFDTMDF0_149;                                /* CFDTMDF0_149     */
    __type210 CFDTMDF1_149;                                /* CFDTMDF1_149     */
    __type210 CFDTMDF2_149;                                /* CFDTMDF2_149     */
    __type210 CFDTMDF3_149;                                /* CFDTMDF3_149     */
    __type210 CFDTMDF4_149;                                /* CFDTMDF4_149     */
    __type210 CFDTMDF5_149;                                /* CFDTMDF5_149     */
    __type210 CFDTMDF6_149;                                /* CFDTMDF6_149     */
    __type210 CFDTMDF7_149;                                /* CFDTMDF7_149     */
    __type210 CFDTMDF8_149;                                /* CFDTMDF8_149     */
    __type210 CFDTMDF9_149;                                /* CFDTMDF9_149     */
    __type210 CFDTMDF10_149;                               /* CFDTMDF10_149    */
    __type210 CFDTMDF11_149;                               /* CFDTMDF11_149    */
    __type210 CFDTMDF12_149;                               /* CFDTMDF12_149    */
    __type210 CFDTMDF13_149;                               /* CFDTMDF13_149    */
    __type210 CFDTMDF14_149;                               /* CFDTMDF14_149    */
    __type210 CFDTMDF15_149;                               /* CFDTMDF15_149    */
    uint8  dummy516[52];                                   /* Reserved         */
    __type210 CFDTMID150;                                  /* CFDTMID150       */
    __type210 CFDTMPTR150;                                 /* CFDTMPTR150      */
    __type210 CFDTMFDCTR150;                               /* CFDTMFDCTR150    */
    __type210 CFDTMDF0_150;                                /* CFDTMDF0_150     */
    __type210 CFDTMDF1_150;                                /* CFDTMDF1_150     */
    __type210 CFDTMDF2_150;                                /* CFDTMDF2_150     */
    __type210 CFDTMDF3_150;                                /* CFDTMDF3_150     */
    __type210 CFDTMDF4_150;                                /* CFDTMDF4_150     */
    __type210 CFDTMDF5_150;                                /* CFDTMDF5_150     */
    __type210 CFDTMDF6_150;                                /* CFDTMDF6_150     */
    __type210 CFDTMDF7_150;                                /* CFDTMDF7_150     */
    __type210 CFDTMDF8_150;                                /* CFDTMDF8_150     */
    __type210 CFDTMDF9_150;                                /* CFDTMDF9_150     */
    __type210 CFDTMDF10_150;                               /* CFDTMDF10_150    */
    __type210 CFDTMDF11_150;                               /* CFDTMDF11_150    */
    __type210 CFDTMDF12_150;                               /* CFDTMDF12_150    */
    __type210 CFDTMDF13_150;                               /* CFDTMDF13_150    */
    __type210 CFDTMDF14_150;                               /* CFDTMDF14_150    */
    __type210 CFDTMDF15_150;                               /* CFDTMDF15_150    */
    uint8  dummy517[52];                                   /* Reserved         */
    __type210 CFDTMID151;                                  /* CFDTMID151       */
    __type210 CFDTMPTR151;                                 /* CFDTMPTR151      */
    __type210 CFDTMFDCTR151;                               /* CFDTMFDCTR151    */
    __type210 CFDTMDF0_151;                                /* CFDTMDF0_151     */
    __type210 CFDTMDF1_151;                                /* CFDTMDF1_151     */
    __type210 CFDTMDF2_151;                                /* CFDTMDF2_151     */
    __type210 CFDTMDF3_151;                                /* CFDTMDF3_151     */
    __type210 CFDTMDF4_151;                                /* CFDTMDF4_151     */
    __type210 CFDTMDF5_151;                                /* CFDTMDF5_151     */
    __type210 CFDTMDF6_151;                                /* CFDTMDF6_151     */
    __type210 CFDTMDF7_151;                                /* CFDTMDF7_151     */
    __type210 CFDTMDF8_151;                                /* CFDTMDF8_151     */
    __type210 CFDTMDF9_151;                                /* CFDTMDF9_151     */
    __type210 CFDTMDF10_151;                               /* CFDTMDF10_151    */
    __type210 CFDTMDF11_151;                               /* CFDTMDF11_151    */
    __type210 CFDTMDF12_151;                               /* CFDTMDF12_151    */
    __type210 CFDTMDF13_151;                               /* CFDTMDF13_151    */
    __type210 CFDTMDF14_151;                               /* CFDTMDF14_151    */
    __type210 CFDTMDF15_151;                               /* CFDTMDF15_151    */
    uint8  dummy518[52];                                   /* Reserved         */
    __type210 CFDTMID152;                                  /* CFDTMID152       */
    __type210 CFDTMPTR152;                                 /* CFDTMPTR152      */
    __type210 CFDTMFDCTR152;                               /* CFDTMFDCTR152    */
    __type210 CFDTMDF0_152;                                /* CFDTMDF0_152     */
    __type210 CFDTMDF1_152;                                /* CFDTMDF1_152     */
    __type210 CFDTMDF2_152;                                /* CFDTMDF2_152     */
    __type210 CFDTMDF3_152;                                /* CFDTMDF3_152     */
    __type210 CFDTMDF4_152;                                /* CFDTMDF4_152     */
    __type210 CFDTMDF5_152;                                /* CFDTMDF5_152     */
    __type210 CFDTMDF6_152;                                /* CFDTMDF6_152     */
    __type210 CFDTMDF7_152;                                /* CFDTMDF7_152     */
    __type210 CFDTMDF8_152;                                /* CFDTMDF8_152     */
    __type210 CFDTMDF9_152;                                /* CFDTMDF9_152     */
    __type210 CFDTMDF10_152;                               /* CFDTMDF10_152    */
    __type210 CFDTMDF11_152;                               /* CFDTMDF11_152    */
    __type210 CFDTMDF12_152;                               /* CFDTMDF12_152    */
    __type210 CFDTMDF13_152;                               /* CFDTMDF13_152    */
    __type210 CFDTMDF14_152;                               /* CFDTMDF14_152    */
    __type210 CFDTMDF15_152;                               /* CFDTMDF15_152    */
    uint8  dummy519[52];                                   /* Reserved         */
    __type210 CFDTMID153;                                  /* CFDTMID153       */
    __type210 CFDTMPTR153;                                 /* CFDTMPTR153      */
    __type210 CFDTMFDCTR153;                               /* CFDTMFDCTR153    */
    __type210 CFDTMDF0_153;                                /* CFDTMDF0_153     */
    __type210 CFDTMDF1_153;                                /* CFDTMDF1_153     */
    __type210 CFDTMDF2_153;                                /* CFDTMDF2_153     */
    __type210 CFDTMDF3_153;                                /* CFDTMDF3_153     */
    __type210 CFDTMDF4_153;                                /* CFDTMDF4_153     */
    __type210 CFDTMDF5_153;                                /* CFDTMDF5_153     */
    __type210 CFDTMDF6_153;                                /* CFDTMDF6_153     */
    __type210 CFDTMDF7_153;                                /* CFDTMDF7_153     */
    __type210 CFDTMDF8_153;                                /* CFDTMDF8_153     */
    __type210 CFDTMDF9_153;                                /* CFDTMDF9_153     */
    __type210 CFDTMDF10_153;                               /* CFDTMDF10_153    */
    __type210 CFDTMDF11_153;                               /* CFDTMDF11_153    */
    __type210 CFDTMDF12_153;                               /* CFDTMDF12_153    */
    __type210 CFDTMDF13_153;                               /* CFDTMDF13_153    */
    __type210 CFDTMDF14_153;                               /* CFDTMDF14_153    */
    __type210 CFDTMDF15_153;                               /* CFDTMDF15_153    */
    uint8  dummy520[52];                                   /* Reserved         */
    __type210 CFDTMID154;                                  /* CFDTMID154       */
    __type210 CFDTMPTR154;                                 /* CFDTMPTR154      */
    __type210 CFDTMFDCTR154;                               /* CFDTMFDCTR154    */
    __type210 CFDTMDF0_154;                                /* CFDTMDF0_154     */
    __type210 CFDTMDF1_154;                                /* CFDTMDF1_154     */
    __type210 CFDTMDF2_154;                                /* CFDTMDF2_154     */
    __type210 CFDTMDF3_154;                                /* CFDTMDF3_154     */
    __type210 CFDTMDF4_154;                                /* CFDTMDF4_154     */
    __type210 CFDTMDF5_154;                                /* CFDTMDF5_154     */
    __type210 CFDTMDF6_154;                                /* CFDTMDF6_154     */
    __type210 CFDTMDF7_154;                                /* CFDTMDF7_154     */
    __type210 CFDTMDF8_154;                                /* CFDTMDF8_154     */
    __type210 CFDTMDF9_154;                                /* CFDTMDF9_154     */
    __type210 CFDTMDF10_154;                               /* CFDTMDF10_154    */
    __type210 CFDTMDF11_154;                               /* CFDTMDF11_154    */
    __type210 CFDTMDF12_154;                               /* CFDTMDF12_154    */
    __type210 CFDTMDF13_154;                               /* CFDTMDF13_154    */
    __type210 CFDTMDF14_154;                               /* CFDTMDF14_154    */
    __type210 CFDTMDF15_154;                               /* CFDTMDF15_154    */
    uint8  dummy521[52];                                   /* Reserved         */
    __type210 CFDTMID155;                                  /* CFDTMID155       */
    __type210 CFDTMPTR155;                                 /* CFDTMPTR155      */
    __type210 CFDTMFDCTR155;                               /* CFDTMFDCTR155    */
    __type210 CFDTMDF0_155;                                /* CFDTMDF0_155     */
    __type210 CFDTMDF1_155;                                /* CFDTMDF1_155     */
    __type210 CFDTMDF2_155;                                /* CFDTMDF2_155     */
    __type210 CFDTMDF3_155;                                /* CFDTMDF3_155     */
    __type210 CFDTMDF4_155;                                /* CFDTMDF4_155     */
    __type210 CFDTMDF5_155;                                /* CFDTMDF5_155     */
    __type210 CFDTMDF6_155;                                /* CFDTMDF6_155     */
    __type210 CFDTMDF7_155;                                /* CFDTMDF7_155     */
    __type210 CFDTMDF8_155;                                /* CFDTMDF8_155     */
    __type210 CFDTMDF9_155;                                /* CFDTMDF9_155     */
    __type210 CFDTMDF10_155;                               /* CFDTMDF10_155    */
    __type210 CFDTMDF11_155;                               /* CFDTMDF11_155    */
    __type210 CFDTMDF12_155;                               /* CFDTMDF12_155    */
    __type210 CFDTMDF13_155;                               /* CFDTMDF13_155    */
    __type210 CFDTMDF14_155;                               /* CFDTMDF14_155    */
    __type210 CFDTMDF15_155;                               /* CFDTMDF15_155    */
    uint8  dummy522[52];                                   /* Reserved         */
    __type210 CFDTMID156;                                  /* CFDTMID156       */
    __type210 CFDTMPTR156;                                 /* CFDTMPTR156      */
    __type210 CFDTMFDCTR156;                               /* CFDTMFDCTR156    */
    __type210 CFDTMDF0_156;                                /* CFDTMDF0_156     */
    __type210 CFDTMDF1_156;                                /* CFDTMDF1_156     */
    __type210 CFDTMDF2_156;                                /* CFDTMDF2_156     */
    __type210 CFDTMDF3_156;                                /* CFDTMDF3_156     */
    __type210 CFDTMDF4_156;                                /* CFDTMDF4_156     */
    __type210 CFDTMDF5_156;                                /* CFDTMDF5_156     */
    __type210 CFDTMDF6_156;                                /* CFDTMDF6_156     */
    __type210 CFDTMDF7_156;                                /* CFDTMDF7_156     */
    __type210 CFDTMDF8_156;                                /* CFDTMDF8_156     */
    __type210 CFDTMDF9_156;                                /* CFDTMDF9_156     */
    __type210 CFDTMDF10_156;                               /* CFDTMDF10_156    */
    __type210 CFDTMDF11_156;                               /* CFDTMDF11_156    */
    __type210 CFDTMDF12_156;                               /* CFDTMDF12_156    */
    __type210 CFDTMDF13_156;                               /* CFDTMDF13_156    */
    __type210 CFDTMDF14_156;                               /* CFDTMDF14_156    */
    __type210 CFDTMDF15_156;                               /* CFDTMDF15_156    */
    uint8  dummy523[52];                                   /* Reserved         */
    __type210 CFDTMID157;                                  /* CFDTMID157       */
    __type210 CFDTMPTR157;                                 /* CFDTMPTR157      */
    __type210 CFDTMFDCTR157;                               /* CFDTMFDCTR157    */
    __type210 CFDTMDF0_157;                                /* CFDTMDF0_157     */
    __type210 CFDTMDF1_157;                                /* CFDTMDF1_157     */
    __type210 CFDTMDF2_157;                                /* CFDTMDF2_157     */
    __type210 CFDTMDF3_157;                                /* CFDTMDF3_157     */
    __type210 CFDTMDF4_157;                                /* CFDTMDF4_157     */
    __type210 CFDTMDF5_157;                                /* CFDTMDF5_157     */
    __type210 CFDTMDF6_157;                                /* CFDTMDF6_157     */
    __type210 CFDTMDF7_157;                                /* CFDTMDF7_157     */
    __type210 CFDTMDF8_157;                                /* CFDTMDF8_157     */
    __type210 CFDTMDF9_157;                                /* CFDTMDF9_157     */
    __type210 CFDTMDF10_157;                               /* CFDTMDF10_157    */
    __type210 CFDTMDF11_157;                               /* CFDTMDF11_157    */
    __type210 CFDTMDF12_157;                               /* CFDTMDF12_157    */
    __type210 CFDTMDF13_157;                               /* CFDTMDF13_157    */
    __type210 CFDTMDF14_157;                               /* CFDTMDF14_157    */
    __type210 CFDTMDF15_157;                               /* CFDTMDF15_157    */
    uint8  dummy524[52];                                   /* Reserved         */
    __type210 CFDTMID158;                                  /* CFDTMID158       */
    __type210 CFDTMPTR158;                                 /* CFDTMPTR158      */
    __type210 CFDTMFDCTR158;                               /* CFDTMFDCTR158    */
    __type210 CFDTMDF0_158;                                /* CFDTMDF0_158     */
    __type210 CFDTMDF1_158;                                /* CFDTMDF1_158     */
    __type210 CFDTMDF2_158;                                /* CFDTMDF2_158     */
    __type210 CFDTMDF3_158;                                /* CFDTMDF3_158     */
    __type210 CFDTMDF4_158;                                /* CFDTMDF4_158     */
    __type210 CFDTMDF5_158;                                /* CFDTMDF5_158     */
    __type210 CFDTMDF6_158;                                /* CFDTMDF6_158     */
    __type210 CFDTMDF7_158;                                /* CFDTMDF7_158     */
    __type210 CFDTMDF8_158;                                /* CFDTMDF8_158     */
    __type210 CFDTMDF9_158;                                /* CFDTMDF9_158     */
    __type210 CFDTMDF10_158;                               /* CFDTMDF10_158    */
    __type210 CFDTMDF11_158;                               /* CFDTMDF11_158    */
    __type210 CFDTMDF12_158;                               /* CFDTMDF12_158    */
    __type210 CFDTMDF13_158;                               /* CFDTMDF13_158    */
    __type210 CFDTMDF14_158;                               /* CFDTMDF14_158    */
    __type210 CFDTMDF15_158;                               /* CFDTMDF15_158    */
    uint8  dummy525[52];                                   /* Reserved         */
    __type210 CFDTMID159;                                  /* CFDTMID159       */
    __type210 CFDTMPTR159;                                 /* CFDTMPTR159      */
    __type210 CFDTMFDCTR159;                               /* CFDTMFDCTR159    */
    __type210 CFDTMDF0_159;                                /* CFDTMDF0_159     */
    __type210 CFDTMDF1_159;                                /* CFDTMDF1_159     */
    __type210 CFDTMDF2_159;                                /* CFDTMDF2_159     */
    __type210 CFDTMDF3_159;                                /* CFDTMDF3_159     */
    __type210 CFDTMDF4_159;                                /* CFDTMDF4_159     */
    __type210 CFDTMDF5_159;                                /* CFDTMDF5_159     */
    __type210 CFDTMDF6_159;                                /* CFDTMDF6_159     */
    __type210 CFDTMDF7_159;                                /* CFDTMDF7_159     */
    __type210 CFDTMDF8_159;                                /* CFDTMDF8_159     */
    __type210 CFDTMDF9_159;                                /* CFDTMDF9_159     */
    __type210 CFDTMDF10_159;                               /* CFDTMDF10_159    */
    __type210 CFDTMDF11_159;                               /* CFDTMDF11_159    */
    __type210 CFDTMDF12_159;                               /* CFDTMDF12_159    */
    __type210 CFDTMDF13_159;                               /* CFDTMDF13_159    */
    __type210 CFDTMDF14_159;                               /* CFDTMDF14_159    */
    __type210 CFDTMDF15_159;                               /* CFDTMDF15_159    */
    uint8  dummy526[52];                                   /* Reserved         */
    __type210 CFDTMID160;                                  /* CFDTMID160       */
    __type210 CFDTMPTR160;                                 /* CFDTMPTR160      */
    __type210 CFDTMFDCTR160;                               /* CFDTMFDCTR160    */
    __type210 CFDTMDF0_160;                                /* CFDTMDF0_160     */
    __type210 CFDTMDF1_160;                                /* CFDTMDF1_160     */
    __type210 CFDTMDF2_160;                                /* CFDTMDF2_160     */
    __type210 CFDTMDF3_160;                                /* CFDTMDF3_160     */
    __type210 CFDTMDF4_160;                                /* CFDTMDF4_160     */
    __type210 CFDTMDF5_160;                                /* CFDTMDF5_160     */
    __type210 CFDTMDF6_160;                                /* CFDTMDF6_160     */
    __type210 CFDTMDF7_160;                                /* CFDTMDF7_160     */
    __type210 CFDTMDF8_160;                                /* CFDTMDF8_160     */
    __type210 CFDTMDF9_160;                                /* CFDTMDF9_160     */
    __type210 CFDTMDF10_160;                               /* CFDTMDF10_160    */
    __type210 CFDTMDF11_160;                               /* CFDTMDF11_160    */
    __type210 CFDTMDF12_160;                               /* CFDTMDF12_160    */
    __type210 CFDTMDF13_160;                               /* CFDTMDF13_160    */
    __type210 CFDTMDF14_160;                               /* CFDTMDF14_160    */
    __type210 CFDTMDF15_160;                               /* CFDTMDF15_160    */
    uint8  dummy527[52];                                   /* Reserved         */
    __type210 CFDTMID161;                                  /* CFDTMID161       */
    __type210 CFDTMPTR161;                                 /* CFDTMPTR161      */
    __type210 CFDTMFDCTR161;                               /* CFDTMFDCTR161    */
    __type210 CFDTMDF0_161;                                /* CFDTMDF0_161     */
    __type210 CFDTMDF1_161;                                /* CFDTMDF1_161     */
    __type210 CFDTMDF2_161;                                /* CFDTMDF2_161     */
    __type210 CFDTMDF3_161;                                /* CFDTMDF3_161     */
    __type210 CFDTMDF4_161;                                /* CFDTMDF4_161     */
    __type210 CFDTMDF5_161;                                /* CFDTMDF5_161     */
    __type210 CFDTMDF6_161;                                /* CFDTMDF6_161     */
    __type210 CFDTMDF7_161;                                /* CFDTMDF7_161     */
    __type210 CFDTMDF8_161;                                /* CFDTMDF8_161     */
    __type210 CFDTMDF9_161;                                /* CFDTMDF9_161     */
    __type210 CFDTMDF10_161;                               /* CFDTMDF10_161    */
    __type210 CFDTMDF11_161;                               /* CFDTMDF11_161    */
    __type210 CFDTMDF12_161;                               /* CFDTMDF12_161    */
    __type210 CFDTMDF13_161;                               /* CFDTMDF13_161    */
    __type210 CFDTMDF14_161;                               /* CFDTMDF14_161    */
    __type210 CFDTMDF15_161;                               /* CFDTMDF15_161    */
    uint8  dummy528[52];                                   /* Reserved         */
    __type210 CFDTMID162;                                  /* CFDTMID162       */
    __type210 CFDTMPTR162;                                 /* CFDTMPTR162      */
    __type210 CFDTMFDCTR162;                               /* CFDTMFDCTR162    */
    __type210 CFDTMDF0_162;                                /* CFDTMDF0_162     */
    __type210 CFDTMDF1_162;                                /* CFDTMDF1_162     */
    __type210 CFDTMDF2_162;                                /* CFDTMDF2_162     */
    __type210 CFDTMDF3_162;                                /* CFDTMDF3_162     */
    __type210 CFDTMDF4_162;                                /* CFDTMDF4_162     */
    __type210 CFDTMDF5_162;                                /* CFDTMDF5_162     */
    __type210 CFDTMDF6_162;                                /* CFDTMDF6_162     */
    __type210 CFDTMDF7_162;                                /* CFDTMDF7_162     */
    __type210 CFDTMDF8_162;                                /* CFDTMDF8_162     */
    __type210 CFDTMDF9_162;                                /* CFDTMDF9_162     */
    __type210 CFDTMDF10_162;                               /* CFDTMDF10_162    */
    __type210 CFDTMDF11_162;                               /* CFDTMDF11_162    */
    __type210 CFDTMDF12_162;                               /* CFDTMDF12_162    */
    __type210 CFDTMDF13_162;                               /* CFDTMDF13_162    */
    __type210 CFDTMDF14_162;                               /* CFDTMDF14_162    */
    __type210 CFDTMDF15_162;                               /* CFDTMDF15_162    */
    uint8  dummy529[52];                                   /* Reserved         */
    __type210 CFDTMID163;                                  /* CFDTMID163       */
    __type210 CFDTMPTR163;                                 /* CFDTMPTR163      */
    __type210 CFDTMFDCTR163;                               /* CFDTMFDCTR163    */
    __type210 CFDTMDF0_163;                                /* CFDTMDF0_163     */
    __type210 CFDTMDF1_163;                                /* CFDTMDF1_163     */
    __type210 CFDTMDF2_163;                                /* CFDTMDF2_163     */
    __type210 CFDTMDF3_163;                                /* CFDTMDF3_163     */
    __type210 CFDTMDF4_163;                                /* CFDTMDF4_163     */
    __type210 CFDTMDF5_163;                                /* CFDTMDF5_163     */
    __type210 CFDTMDF6_163;                                /* CFDTMDF6_163     */
    __type210 CFDTMDF7_163;                                /* CFDTMDF7_163     */
    __type210 CFDTMDF8_163;                                /* CFDTMDF8_163     */
    __type210 CFDTMDF9_163;                                /* CFDTMDF9_163     */
    __type210 CFDTMDF10_163;                               /* CFDTMDF10_163    */
    __type210 CFDTMDF11_163;                               /* CFDTMDF11_163    */
    __type210 CFDTMDF12_163;                               /* CFDTMDF12_163    */
    __type210 CFDTMDF13_163;                               /* CFDTMDF13_163    */
    __type210 CFDTMDF14_163;                               /* CFDTMDF14_163    */
    __type210 CFDTMDF15_163;                               /* CFDTMDF15_163    */
    uint8  dummy530[52];                                   /* Reserved         */
    __type210 CFDTMID164;                                  /* CFDTMID164       */
    __type210 CFDTMPTR164;                                 /* CFDTMPTR164      */
    __type210 CFDTMFDCTR164;                               /* CFDTMFDCTR164    */
    __type210 CFDTMDF0_164;                                /* CFDTMDF0_164     */
    __type210 CFDTMDF1_164;                                /* CFDTMDF1_164     */
    __type210 CFDTMDF2_164;                                /* CFDTMDF2_164     */
    __type210 CFDTMDF3_164;                                /* CFDTMDF3_164     */
    __type210 CFDTMDF4_164;                                /* CFDTMDF4_164     */
    __type210 CFDTMDF5_164;                                /* CFDTMDF5_164     */
    __type210 CFDTMDF6_164;                                /* CFDTMDF6_164     */
    __type210 CFDTMDF7_164;                                /* CFDTMDF7_164     */
    __type210 CFDTMDF8_164;                                /* CFDTMDF8_164     */
    __type210 CFDTMDF9_164;                                /* CFDTMDF9_164     */
    __type210 CFDTMDF10_164;                               /* CFDTMDF10_164    */
    __type210 CFDTMDF11_164;                               /* CFDTMDF11_164    */
    __type210 CFDTMDF12_164;                               /* CFDTMDF12_164    */
    __type210 CFDTMDF13_164;                               /* CFDTMDF13_164    */
    __type210 CFDTMDF14_164;                               /* CFDTMDF14_164    */
    __type210 CFDTMDF15_164;                               /* CFDTMDF15_164    */
    uint8  dummy531[52];                                   /* Reserved         */
    __type210 CFDTMID165;                                  /* CFDTMID165       */
    __type210 CFDTMPTR165;                                 /* CFDTMPTR165      */
    __type210 CFDTMFDCTR165;                               /* CFDTMFDCTR165    */
    __type210 CFDTMDF0_165;                                /* CFDTMDF0_165     */
    __type210 CFDTMDF1_165;                                /* CFDTMDF1_165     */
    __type210 CFDTMDF2_165;                                /* CFDTMDF2_165     */
    __type210 CFDTMDF3_165;                                /* CFDTMDF3_165     */
    __type210 CFDTMDF4_165;                                /* CFDTMDF4_165     */
    __type210 CFDTMDF5_165;                                /* CFDTMDF5_165     */
    __type210 CFDTMDF6_165;                                /* CFDTMDF6_165     */
    __type210 CFDTMDF7_165;                                /* CFDTMDF7_165     */
    __type210 CFDTMDF8_165;                                /* CFDTMDF8_165     */
    __type210 CFDTMDF9_165;                                /* CFDTMDF9_165     */
    __type210 CFDTMDF10_165;                               /* CFDTMDF10_165    */
    __type210 CFDTMDF11_165;                               /* CFDTMDF11_165    */
    __type210 CFDTMDF12_165;                               /* CFDTMDF12_165    */
    __type210 CFDTMDF13_165;                               /* CFDTMDF13_165    */
    __type210 CFDTMDF14_165;                               /* CFDTMDF14_165    */
    __type210 CFDTMDF15_165;                               /* CFDTMDF15_165    */
    uint8  dummy532[52];                                   /* Reserved         */
    __type210 CFDTMID166;                                  /* CFDTMID166       */
    __type210 CFDTMPTR166;                                 /* CFDTMPTR166      */
    __type210 CFDTMFDCTR166;                               /* CFDTMFDCTR166    */
    __type210 CFDTMDF0_166;                                /* CFDTMDF0_166     */
    __type210 CFDTMDF1_166;                                /* CFDTMDF1_166     */
    __type210 CFDTMDF2_166;                                /* CFDTMDF2_166     */
    __type210 CFDTMDF3_166;                                /* CFDTMDF3_166     */
    __type210 CFDTMDF4_166;                                /* CFDTMDF4_166     */
    __type210 CFDTMDF5_166;                                /* CFDTMDF5_166     */
    __type210 CFDTMDF6_166;                                /* CFDTMDF6_166     */
    __type210 CFDTMDF7_166;                                /* CFDTMDF7_166     */
    __type210 CFDTMDF8_166;                                /* CFDTMDF8_166     */
    __type210 CFDTMDF9_166;                                /* CFDTMDF9_166     */
    __type210 CFDTMDF10_166;                               /* CFDTMDF10_166    */
    __type210 CFDTMDF11_166;                               /* CFDTMDF11_166    */
    __type210 CFDTMDF12_166;                               /* CFDTMDF12_166    */
    __type210 CFDTMDF13_166;                               /* CFDTMDF13_166    */
    __type210 CFDTMDF14_166;                               /* CFDTMDF14_166    */
    __type210 CFDTMDF15_166;                               /* CFDTMDF15_166    */
    uint8  dummy533[52];                                   /* Reserved         */
    __type210 CFDTMID167;                                  /* CFDTMID167       */
    __type210 CFDTMPTR167;                                 /* CFDTMPTR167      */
    __type210 CFDTMFDCTR167;                               /* CFDTMFDCTR167    */
    __type210 CFDTMDF0_167;                                /* CFDTMDF0_167     */
    __type210 CFDTMDF1_167;                                /* CFDTMDF1_167     */
    __type210 CFDTMDF2_167;                                /* CFDTMDF2_167     */
    __type210 CFDTMDF3_167;                                /* CFDTMDF3_167     */
    __type210 CFDTMDF4_167;                                /* CFDTMDF4_167     */
    __type210 CFDTMDF5_167;                                /* CFDTMDF5_167     */
    __type210 CFDTMDF6_167;                                /* CFDTMDF6_167     */
    __type210 CFDTMDF7_167;                                /* CFDTMDF7_167     */
    __type210 CFDTMDF8_167;                                /* CFDTMDF8_167     */
    __type210 CFDTMDF9_167;                                /* CFDTMDF9_167     */
    __type210 CFDTMDF10_167;                               /* CFDTMDF10_167    */
    __type210 CFDTMDF11_167;                               /* CFDTMDF11_167    */
    __type210 CFDTMDF12_167;                               /* CFDTMDF12_167    */
    __type210 CFDTMDF13_167;                               /* CFDTMDF13_167    */
    __type210 CFDTMDF14_167;                               /* CFDTMDF14_167    */
    __type210 CFDTMDF15_167;                               /* CFDTMDF15_167    */
    uint8  dummy534[52];                                   /* Reserved         */
    __type210 CFDTMID168;                                  /* CFDTMID168       */
    __type210 CFDTMPTR168;                                 /* CFDTMPTR168      */
    __type210 CFDTMFDCTR168;                               /* CFDTMFDCTR168    */
    __type210 CFDTMDF0_168;                                /* CFDTMDF0_168     */
    __type210 CFDTMDF1_168;                                /* CFDTMDF1_168     */
    __type210 CFDTMDF2_168;                                /* CFDTMDF2_168     */
    __type210 CFDTMDF3_168;                                /* CFDTMDF3_168     */
    __type210 CFDTMDF4_168;                                /* CFDTMDF4_168     */
    __type210 CFDTMDF5_168;                                /* CFDTMDF5_168     */
    __type210 CFDTMDF6_168;                                /* CFDTMDF6_168     */
    __type210 CFDTMDF7_168;                                /* CFDTMDF7_168     */
    __type210 CFDTMDF8_168;                                /* CFDTMDF8_168     */
    __type210 CFDTMDF9_168;                                /* CFDTMDF9_168     */
    __type210 CFDTMDF10_168;                               /* CFDTMDF10_168    */
    __type210 CFDTMDF11_168;                               /* CFDTMDF11_168    */
    __type210 CFDTMDF12_168;                               /* CFDTMDF12_168    */
    __type210 CFDTMDF13_168;                               /* CFDTMDF13_168    */
    __type210 CFDTMDF14_168;                               /* CFDTMDF14_168    */
    __type210 CFDTMDF15_168;                               /* CFDTMDF15_168    */
    uint8  dummy535[52];                                   /* Reserved         */
    __type210 CFDTMID169;                                  /* CFDTMID169       */
    __type210 CFDTMPTR169;                                 /* CFDTMPTR169      */
    __type210 CFDTMFDCTR169;                               /* CFDTMFDCTR169    */
    __type210 CFDTMDF0_169;                                /* CFDTMDF0_169     */
    __type210 CFDTMDF1_169;                                /* CFDTMDF1_169     */
    __type210 CFDTMDF2_169;                                /* CFDTMDF2_169     */
    __type210 CFDTMDF3_169;                                /* CFDTMDF3_169     */
    __type210 CFDTMDF4_169;                                /* CFDTMDF4_169     */
    __type210 CFDTMDF5_169;                                /* CFDTMDF5_169     */
    __type210 CFDTMDF6_169;                                /* CFDTMDF6_169     */
    __type210 CFDTMDF7_169;                                /* CFDTMDF7_169     */
    __type210 CFDTMDF8_169;                                /* CFDTMDF8_169     */
    __type210 CFDTMDF9_169;                                /* CFDTMDF9_169     */
    __type210 CFDTMDF10_169;                               /* CFDTMDF10_169    */
    __type210 CFDTMDF11_169;                               /* CFDTMDF11_169    */
    __type210 CFDTMDF12_169;                               /* CFDTMDF12_169    */
    __type210 CFDTMDF13_169;                               /* CFDTMDF13_169    */
    __type210 CFDTMDF14_169;                               /* CFDTMDF14_169    */
    __type210 CFDTMDF15_169;                               /* CFDTMDF15_169    */
    uint8  dummy536[52];                                   /* Reserved         */
    __type210 CFDTMID170;                                  /* CFDTMID170       */
    __type210 CFDTMPTR170;                                 /* CFDTMPTR170      */
    __type210 CFDTMFDCTR170;                               /* CFDTMFDCTR170    */
    __type210 CFDTMDF0_170;                                /* CFDTMDF0_170     */
    __type210 CFDTMDF1_170;                                /* CFDTMDF1_170     */
    __type210 CFDTMDF2_170;                                /* CFDTMDF2_170     */
    __type210 CFDTMDF3_170;                                /* CFDTMDF3_170     */
    __type210 CFDTMDF4_170;                                /* CFDTMDF4_170     */
    __type210 CFDTMDF5_170;                                /* CFDTMDF5_170     */
    __type210 CFDTMDF6_170;                                /* CFDTMDF6_170     */
    __type210 CFDTMDF7_170;                                /* CFDTMDF7_170     */
    __type210 CFDTMDF8_170;                                /* CFDTMDF8_170     */
    __type210 CFDTMDF9_170;                                /* CFDTMDF9_170     */
    __type210 CFDTMDF10_170;                               /* CFDTMDF10_170    */
    __type210 CFDTMDF11_170;                               /* CFDTMDF11_170    */
    __type210 CFDTMDF12_170;                               /* CFDTMDF12_170    */
    __type210 CFDTMDF13_170;                               /* CFDTMDF13_170    */
    __type210 CFDTMDF14_170;                               /* CFDTMDF14_170    */
    __type210 CFDTMDF15_170;                               /* CFDTMDF15_170    */
    uint8  dummy537[52];                                   /* Reserved         */
    __type210 CFDTMID171;                                  /* CFDTMID171       */
    __type210 CFDTMPTR171;                                 /* CFDTMPTR171      */
    __type210 CFDTMFDCTR171;                               /* CFDTMFDCTR171    */
    __type210 CFDTMDF0_171;                                /* CFDTMDF0_171     */
    __type210 CFDTMDF1_171;                                /* CFDTMDF1_171     */
    __type210 CFDTMDF2_171;                                /* CFDTMDF2_171     */
    __type210 CFDTMDF3_171;                                /* CFDTMDF3_171     */
    __type210 CFDTMDF4_171;                                /* CFDTMDF4_171     */
    __type210 CFDTMDF5_171;                                /* CFDTMDF5_171     */
    __type210 CFDTMDF6_171;                                /* CFDTMDF6_171     */
    __type210 CFDTMDF7_171;                                /* CFDTMDF7_171     */
    __type210 CFDTMDF8_171;                                /* CFDTMDF8_171     */
    __type210 CFDTMDF9_171;                                /* CFDTMDF9_171     */
    __type210 CFDTMDF10_171;                               /* CFDTMDF10_171    */
    __type210 CFDTMDF11_171;                               /* CFDTMDF11_171    */
    __type210 CFDTMDF12_171;                               /* CFDTMDF12_171    */
    __type210 CFDTMDF13_171;                               /* CFDTMDF13_171    */
    __type210 CFDTMDF14_171;                               /* CFDTMDF14_171    */
    __type210 CFDTMDF15_171;                               /* CFDTMDF15_171    */
    uint8  dummy538[52];                                   /* Reserved         */
    __type210 CFDTMID172;                                  /* CFDTMID172       */
    __type210 CFDTMPTR172;                                 /* CFDTMPTR172      */
    __type210 CFDTMFDCTR172;                               /* CFDTMFDCTR172    */
    __type210 CFDTMDF0_172;                                /* CFDTMDF0_172     */
    __type210 CFDTMDF1_172;                                /* CFDTMDF1_172     */
    __type210 CFDTMDF2_172;                                /* CFDTMDF2_172     */
    __type210 CFDTMDF3_172;                                /* CFDTMDF3_172     */
    __type210 CFDTMDF4_172;                                /* CFDTMDF4_172     */
    __type210 CFDTMDF5_172;                                /* CFDTMDF5_172     */
    __type210 CFDTMDF6_172;                                /* CFDTMDF6_172     */
    __type210 CFDTMDF7_172;                                /* CFDTMDF7_172     */
    __type210 CFDTMDF8_172;                                /* CFDTMDF8_172     */
    __type210 CFDTMDF9_172;                                /* CFDTMDF9_172     */
    __type210 CFDTMDF10_172;                               /* CFDTMDF10_172    */
    __type210 CFDTMDF11_172;                               /* CFDTMDF11_172    */
    __type210 CFDTMDF12_172;                               /* CFDTMDF12_172    */
    __type210 CFDTMDF13_172;                               /* CFDTMDF13_172    */
    __type210 CFDTMDF14_172;                               /* CFDTMDF14_172    */
    __type210 CFDTMDF15_172;                               /* CFDTMDF15_172    */
    uint8  dummy539[52];                                   /* Reserved         */
    __type210 CFDTMID173;                                  /* CFDTMID173       */
    __type210 CFDTMPTR173;                                 /* CFDTMPTR173      */
    __type210 CFDTMFDCTR173;                               /* CFDTMFDCTR173    */
    __type210 CFDTMDF0_173;                                /* CFDTMDF0_173     */
    __type210 CFDTMDF1_173;                                /* CFDTMDF1_173     */
    __type210 CFDTMDF2_173;                                /* CFDTMDF2_173     */
    __type210 CFDTMDF3_173;                                /* CFDTMDF3_173     */
    __type210 CFDTMDF4_173;                                /* CFDTMDF4_173     */
    __type210 CFDTMDF5_173;                                /* CFDTMDF5_173     */
    __type210 CFDTMDF6_173;                                /* CFDTMDF6_173     */
    __type210 CFDTMDF7_173;                                /* CFDTMDF7_173     */
    __type210 CFDTMDF8_173;                                /* CFDTMDF8_173     */
    __type210 CFDTMDF9_173;                                /* CFDTMDF9_173     */
    __type210 CFDTMDF10_173;                               /* CFDTMDF10_173    */
    __type210 CFDTMDF11_173;                               /* CFDTMDF11_173    */
    __type210 CFDTMDF12_173;                               /* CFDTMDF12_173    */
    __type210 CFDTMDF13_173;                               /* CFDTMDF13_173    */
    __type210 CFDTMDF14_173;                               /* CFDTMDF14_173    */
    __type210 CFDTMDF15_173;                               /* CFDTMDF15_173    */
    uint8  dummy540[52];                                   /* Reserved         */
    __type210 CFDTMID174;                                  /* CFDTMID174       */
    __type210 CFDTMPTR174;                                 /* CFDTMPTR174      */
    __type210 CFDTMFDCTR174;                               /* CFDTMFDCTR174    */
    __type210 CFDTMDF0_174;                                /* CFDTMDF0_174     */
    __type210 CFDTMDF1_174;                                /* CFDTMDF1_174     */
    __type210 CFDTMDF2_174;                                /* CFDTMDF2_174     */
    __type210 CFDTMDF3_174;                                /* CFDTMDF3_174     */
    __type210 CFDTMDF4_174;                                /* CFDTMDF4_174     */
    __type210 CFDTMDF5_174;                                /* CFDTMDF5_174     */
    __type210 CFDTMDF6_174;                                /* CFDTMDF6_174     */
    __type210 CFDTMDF7_174;                                /* CFDTMDF7_174     */
    __type210 CFDTMDF8_174;                                /* CFDTMDF8_174     */
    __type210 CFDTMDF9_174;                                /* CFDTMDF9_174     */
    __type210 CFDTMDF10_174;                               /* CFDTMDF10_174    */
    __type210 CFDTMDF11_174;                               /* CFDTMDF11_174    */
    __type210 CFDTMDF12_174;                               /* CFDTMDF12_174    */
    __type210 CFDTMDF13_174;                               /* CFDTMDF13_174    */
    __type210 CFDTMDF14_174;                               /* CFDTMDF14_174    */
    __type210 CFDTMDF15_174;                               /* CFDTMDF15_174    */
    uint8  dummy541[52];                                   /* Reserved         */
    __type210 CFDTMID175;                                  /* CFDTMID175       */
    __type210 CFDTMPTR175;                                 /* CFDTMPTR175      */
    __type210 CFDTMFDCTR175;                               /* CFDTMFDCTR175    */
    __type210 CFDTMDF0_175;                                /* CFDTMDF0_175     */
    __type210 CFDTMDF1_175;                                /* CFDTMDF1_175     */
    __type210 CFDTMDF2_175;                                /* CFDTMDF2_175     */
    __type210 CFDTMDF3_175;                                /* CFDTMDF3_175     */
    __type210 CFDTMDF4_175;                                /* CFDTMDF4_175     */
    __type210 CFDTMDF5_175;                                /* CFDTMDF5_175     */
    __type210 CFDTMDF6_175;                                /* CFDTMDF6_175     */
    __type210 CFDTMDF7_175;                                /* CFDTMDF7_175     */
    __type210 CFDTMDF8_175;                                /* CFDTMDF8_175     */
    __type210 CFDTMDF9_175;                                /* CFDTMDF9_175     */
    __type210 CFDTMDF10_175;                               /* CFDTMDF10_175    */
    __type210 CFDTMDF11_175;                               /* CFDTMDF11_175    */
    __type210 CFDTMDF12_175;                               /* CFDTMDF12_175    */
    __type210 CFDTMDF13_175;                               /* CFDTMDF13_175    */
    __type210 CFDTMDF14_175;                               /* CFDTMDF14_175    */
    __type210 CFDTMDF15_175;                               /* CFDTMDF15_175    */
    uint8  dummy542[52];                                   /* Reserved         */
    __type210 CFDTMID176;                                  /* CFDTMID176       */
    __type210 CFDTMPTR176;                                 /* CFDTMPTR176      */
    __type210 CFDTMFDCTR176;                               /* CFDTMFDCTR176    */
    __type210 CFDTMDF0_176;                                /* CFDTMDF0_176     */
    __type210 CFDTMDF1_176;                                /* CFDTMDF1_176     */
    __type210 CFDTMDF2_176;                                /* CFDTMDF2_176     */
    __type210 CFDTMDF3_176;                                /* CFDTMDF3_176     */
    __type210 CFDTMDF4_176;                                /* CFDTMDF4_176     */
    __type210 CFDTMDF5_176;                                /* CFDTMDF5_176     */
    __type210 CFDTMDF6_176;                                /* CFDTMDF6_176     */
    __type210 CFDTMDF7_176;                                /* CFDTMDF7_176     */
    __type210 CFDTMDF8_176;                                /* CFDTMDF8_176     */
    __type210 CFDTMDF9_176;                                /* CFDTMDF9_176     */
    __type210 CFDTMDF10_176;                               /* CFDTMDF10_176    */
    __type210 CFDTMDF11_176;                               /* CFDTMDF11_176    */
    __type210 CFDTMDF12_176;                               /* CFDTMDF12_176    */
    __type210 CFDTMDF13_176;                               /* CFDTMDF13_176    */
    __type210 CFDTMDF14_176;                               /* CFDTMDF14_176    */
    __type210 CFDTMDF15_176;                               /* CFDTMDF15_176    */
    uint8  dummy543[52];                                   /* Reserved         */
    __type210 CFDTMID177;                                  /* CFDTMID177       */
    __type210 CFDTMPTR177;                                 /* CFDTMPTR177      */
    __type210 CFDTMFDCTR177;                               /* CFDTMFDCTR177    */
    __type210 CFDTMDF0_177;                                /* CFDTMDF0_177     */
    __type210 CFDTMDF1_177;                                /* CFDTMDF1_177     */
    __type210 CFDTMDF2_177;                                /* CFDTMDF2_177     */
    __type210 CFDTMDF3_177;                                /* CFDTMDF3_177     */
    __type210 CFDTMDF4_177;                                /* CFDTMDF4_177     */
    __type210 CFDTMDF5_177;                                /* CFDTMDF5_177     */
    __type210 CFDTMDF6_177;                                /* CFDTMDF6_177     */
    __type210 CFDTMDF7_177;                                /* CFDTMDF7_177     */
    __type210 CFDTMDF8_177;                                /* CFDTMDF8_177     */
    __type210 CFDTMDF9_177;                                /* CFDTMDF9_177     */
    __type210 CFDTMDF10_177;                               /* CFDTMDF10_177    */
    __type210 CFDTMDF11_177;                               /* CFDTMDF11_177    */
    __type210 CFDTMDF12_177;                               /* CFDTMDF12_177    */
    __type210 CFDTMDF13_177;                               /* CFDTMDF13_177    */
    __type210 CFDTMDF14_177;                               /* CFDTMDF14_177    */
    __type210 CFDTMDF15_177;                               /* CFDTMDF15_177    */
    uint8  dummy544[52];                                   /* Reserved         */
    __type210 CFDTMID178;                                  /* CFDTMID178       */
    __type210 CFDTMPTR178;                                 /* CFDTMPTR178      */
    __type210 CFDTMFDCTR178;                               /* CFDTMFDCTR178    */
    __type210 CFDTMDF0_178;                                /* CFDTMDF0_178     */
    __type210 CFDTMDF1_178;                                /* CFDTMDF1_178     */
    __type210 CFDTMDF2_178;                                /* CFDTMDF2_178     */
    __type210 CFDTMDF3_178;                                /* CFDTMDF3_178     */
    __type210 CFDTMDF4_178;                                /* CFDTMDF4_178     */
    __type210 CFDTMDF5_178;                                /* CFDTMDF5_178     */
    __type210 CFDTMDF6_178;                                /* CFDTMDF6_178     */
    __type210 CFDTMDF7_178;                                /* CFDTMDF7_178     */
    __type210 CFDTMDF8_178;                                /* CFDTMDF8_178     */
    __type210 CFDTMDF9_178;                                /* CFDTMDF9_178     */
    __type210 CFDTMDF10_178;                               /* CFDTMDF10_178    */
    __type210 CFDTMDF11_178;                               /* CFDTMDF11_178    */
    __type210 CFDTMDF12_178;                               /* CFDTMDF12_178    */
    __type210 CFDTMDF13_178;                               /* CFDTMDF13_178    */
    __type210 CFDTMDF14_178;                               /* CFDTMDF14_178    */
    __type210 CFDTMDF15_178;                               /* CFDTMDF15_178    */
    uint8  dummy545[52];                                   /* Reserved         */
    __type210 CFDTMID179;                                  /* CFDTMID179       */
    __type210 CFDTMPTR179;                                 /* CFDTMPTR179      */
    __type210 CFDTMFDCTR179;                               /* CFDTMFDCTR179    */
    __type210 CFDTMDF0_179;                                /* CFDTMDF0_179     */
    __type210 CFDTMDF1_179;                                /* CFDTMDF1_179     */
    __type210 CFDTMDF2_179;                                /* CFDTMDF2_179     */
    __type210 CFDTMDF3_179;                                /* CFDTMDF3_179     */
    __type210 CFDTMDF4_179;                                /* CFDTMDF4_179     */
    __type210 CFDTMDF5_179;                                /* CFDTMDF5_179     */
    __type210 CFDTMDF6_179;                                /* CFDTMDF6_179     */
    __type210 CFDTMDF7_179;                                /* CFDTMDF7_179     */
    __type210 CFDTMDF8_179;                                /* CFDTMDF8_179     */
    __type210 CFDTMDF9_179;                                /* CFDTMDF9_179     */
    __type210 CFDTMDF10_179;                               /* CFDTMDF10_179    */
    __type210 CFDTMDF11_179;                               /* CFDTMDF11_179    */
    __type210 CFDTMDF12_179;                               /* CFDTMDF12_179    */
    __type210 CFDTMDF13_179;                               /* CFDTMDF13_179    */
    __type210 CFDTMDF14_179;                               /* CFDTMDF14_179    */
    __type210 CFDTMDF15_179;                               /* CFDTMDF15_179    */
    uint8  dummy546[52];                                   /* Reserved         */
    __type210 CFDTMID180;                                  /* CFDTMID180       */
    __type210 CFDTMPTR180;                                 /* CFDTMPTR180      */
    __type210 CFDTMFDCTR180;                               /* CFDTMFDCTR180    */
    __type210 CFDTMDF0_180;                                /* CFDTMDF0_180     */
    __type210 CFDTMDF1_180;                                /* CFDTMDF1_180     */
    __type210 CFDTMDF2_180;                                /* CFDTMDF2_180     */
    __type210 CFDTMDF3_180;                                /* CFDTMDF3_180     */
    __type210 CFDTMDF4_180;                                /* CFDTMDF4_180     */
    __type210 CFDTMDF5_180;                                /* CFDTMDF5_180     */
    __type210 CFDTMDF6_180;                                /* CFDTMDF6_180     */
    __type210 CFDTMDF7_180;                                /* CFDTMDF7_180     */
    __type210 CFDTMDF8_180;                                /* CFDTMDF8_180     */
    __type210 CFDTMDF9_180;                                /* CFDTMDF9_180     */
    __type210 CFDTMDF10_180;                               /* CFDTMDF10_180    */
    __type210 CFDTMDF11_180;                               /* CFDTMDF11_180    */
    __type210 CFDTMDF12_180;                               /* CFDTMDF12_180    */
    __type210 CFDTMDF13_180;                               /* CFDTMDF13_180    */
    __type210 CFDTMDF14_180;                               /* CFDTMDF14_180    */
    __type210 CFDTMDF15_180;                               /* CFDTMDF15_180    */
    uint8  dummy547[52];                                   /* Reserved         */
    __type210 CFDTMID181;                                  /* CFDTMID181       */
    __type210 CFDTMPTR181;                                 /* CFDTMPTR181      */
    __type210 CFDTMFDCTR181;                               /* CFDTMFDCTR181    */
    __type210 CFDTMDF0_181;                                /* CFDTMDF0_181     */
    __type210 CFDTMDF1_181;                                /* CFDTMDF1_181     */
    __type210 CFDTMDF2_181;                                /* CFDTMDF2_181     */
    __type210 CFDTMDF3_181;                                /* CFDTMDF3_181     */
    __type210 CFDTMDF4_181;                                /* CFDTMDF4_181     */
    __type210 CFDTMDF5_181;                                /* CFDTMDF5_181     */
    __type210 CFDTMDF6_181;                                /* CFDTMDF6_181     */
    __type210 CFDTMDF7_181;                                /* CFDTMDF7_181     */
    __type210 CFDTMDF8_181;                                /* CFDTMDF8_181     */
    __type210 CFDTMDF9_181;                                /* CFDTMDF9_181     */
    __type210 CFDTMDF10_181;                               /* CFDTMDF10_181    */
    __type210 CFDTMDF11_181;                               /* CFDTMDF11_181    */
    __type210 CFDTMDF12_181;                               /* CFDTMDF12_181    */
    __type210 CFDTMDF13_181;                               /* CFDTMDF13_181    */
    __type210 CFDTMDF14_181;                               /* CFDTMDF14_181    */
    __type210 CFDTMDF15_181;                               /* CFDTMDF15_181    */
    uint8  dummy548[52];                                   /* Reserved         */
    __type210 CFDTMID182;                                  /* CFDTMID182       */
    __type210 CFDTMPTR182;                                 /* CFDTMPTR182      */
    __type210 CFDTMFDCTR182;                               /* CFDTMFDCTR182    */
    __type210 CFDTMDF0_182;                                /* CFDTMDF0_182     */
    __type210 CFDTMDF1_182;                                /* CFDTMDF1_182     */
    __type210 CFDTMDF2_182;                                /* CFDTMDF2_182     */
    __type210 CFDTMDF3_182;                                /* CFDTMDF3_182     */
    __type210 CFDTMDF4_182;                                /* CFDTMDF4_182     */
    __type210 CFDTMDF5_182;                                /* CFDTMDF5_182     */
    __type210 CFDTMDF6_182;                                /* CFDTMDF6_182     */
    __type210 CFDTMDF7_182;                                /* CFDTMDF7_182     */
    __type210 CFDTMDF8_182;                                /* CFDTMDF8_182     */
    __type210 CFDTMDF9_182;                                /* CFDTMDF9_182     */
    __type210 CFDTMDF10_182;                               /* CFDTMDF10_182    */
    __type210 CFDTMDF11_182;                               /* CFDTMDF11_182    */
    __type210 CFDTMDF12_182;                               /* CFDTMDF12_182    */
    __type210 CFDTMDF13_182;                               /* CFDTMDF13_182    */
    __type210 CFDTMDF14_182;                               /* CFDTMDF14_182    */
    __type210 CFDTMDF15_182;                               /* CFDTMDF15_182    */
    uint8  dummy549[52];                                   /* Reserved         */
    __type210 CFDTMID183;                                  /* CFDTMID183       */
    __type210 CFDTMPTR183;                                 /* CFDTMPTR183      */
    __type210 CFDTMFDCTR183;                               /* CFDTMFDCTR183    */
    __type210 CFDTMDF0_183;                                /* CFDTMDF0_183     */
    __type210 CFDTMDF1_183;                                /* CFDTMDF1_183     */
    __type210 CFDTMDF2_183;                                /* CFDTMDF2_183     */
    __type210 CFDTMDF3_183;                                /* CFDTMDF3_183     */
    __type210 CFDTMDF4_183;                                /* CFDTMDF4_183     */
    __type210 CFDTMDF5_183;                                /* CFDTMDF5_183     */
    __type210 CFDTMDF6_183;                                /* CFDTMDF6_183     */
    __type210 CFDTMDF7_183;                                /* CFDTMDF7_183     */
    __type210 CFDTMDF8_183;                                /* CFDTMDF8_183     */
    __type210 CFDTMDF9_183;                                /* CFDTMDF9_183     */
    __type210 CFDTMDF10_183;                               /* CFDTMDF10_183    */
    __type210 CFDTMDF11_183;                               /* CFDTMDF11_183    */
    __type210 CFDTMDF12_183;                               /* CFDTMDF12_183    */
    __type210 CFDTMDF13_183;                               /* CFDTMDF13_183    */
    __type210 CFDTMDF14_183;                               /* CFDTMDF14_183    */
    __type210 CFDTMDF15_183;                               /* CFDTMDF15_183    */
    uint8  dummy550[52];                                   /* Reserved         */
    __type210 CFDTMID184;                                  /* CFDTMID184       */
    __type210 CFDTMPTR184;                                 /* CFDTMPTR184      */
    __type210 CFDTMFDCTR184;                               /* CFDTMFDCTR184    */
    __type210 CFDTMDF0_184;                                /* CFDTMDF0_184     */
    __type210 CFDTMDF1_184;                                /* CFDTMDF1_184     */
    __type210 CFDTMDF2_184;                                /* CFDTMDF2_184     */
    __type210 CFDTMDF3_184;                                /* CFDTMDF3_184     */
    __type210 CFDTMDF4_184;                                /* CFDTMDF4_184     */
    __type210 CFDTMDF5_184;                                /* CFDTMDF5_184     */
    __type210 CFDTMDF6_184;                                /* CFDTMDF6_184     */
    __type210 CFDTMDF7_184;                                /* CFDTMDF7_184     */
    __type210 CFDTMDF8_184;                                /* CFDTMDF8_184     */
    __type210 CFDTMDF9_184;                                /* CFDTMDF9_184     */
    __type210 CFDTMDF10_184;                               /* CFDTMDF10_184    */
    __type210 CFDTMDF11_184;                               /* CFDTMDF11_184    */
    __type210 CFDTMDF12_184;                               /* CFDTMDF12_184    */
    __type210 CFDTMDF13_184;                               /* CFDTMDF13_184    */
    __type210 CFDTMDF14_184;                               /* CFDTMDF14_184    */
    __type210 CFDTMDF15_184;                               /* CFDTMDF15_184    */
    uint8  dummy551[52];                                   /* Reserved         */
    __type210 CFDTMID185;                                  /* CFDTMID185       */
    __type210 CFDTMPTR185;                                 /* CFDTMPTR185      */
    __type210 CFDTMFDCTR185;                               /* CFDTMFDCTR185    */
    __type210 CFDTMDF0_185;                                /* CFDTMDF0_185     */
    __type210 CFDTMDF1_185;                                /* CFDTMDF1_185     */
    __type210 CFDTMDF2_185;                                /* CFDTMDF2_185     */
    __type210 CFDTMDF3_185;                                /* CFDTMDF3_185     */
    __type210 CFDTMDF4_185;                                /* CFDTMDF4_185     */
    __type210 CFDTMDF5_185;                                /* CFDTMDF5_185     */
    __type210 CFDTMDF6_185;                                /* CFDTMDF6_185     */
    __type210 CFDTMDF7_185;                                /* CFDTMDF7_185     */
    __type210 CFDTMDF8_185;                                /* CFDTMDF8_185     */
    __type210 CFDTMDF9_185;                                /* CFDTMDF9_185     */
    __type210 CFDTMDF10_185;                               /* CFDTMDF10_185    */
    __type210 CFDTMDF11_185;                               /* CFDTMDF11_185    */
    __type210 CFDTMDF12_185;                               /* CFDTMDF12_185    */
    __type210 CFDTMDF13_185;                               /* CFDTMDF13_185    */
    __type210 CFDTMDF14_185;                               /* CFDTMDF14_185    */
    __type210 CFDTMDF15_185;                               /* CFDTMDF15_185    */
    uint8  dummy552[52];                                   /* Reserved         */
    __type210 CFDTMID186;                                  /* CFDTMID186       */
    __type210 CFDTMPTR186;                                 /* CFDTMPTR186      */
    __type210 CFDTMFDCTR186;                               /* CFDTMFDCTR186    */
    __type210 CFDTMDF0_186;                                /* CFDTMDF0_186     */
    __type210 CFDTMDF1_186;                                /* CFDTMDF1_186     */
    __type210 CFDTMDF2_186;                                /* CFDTMDF2_186     */
    __type210 CFDTMDF3_186;                                /* CFDTMDF3_186     */
    __type210 CFDTMDF4_186;                                /* CFDTMDF4_186     */
    __type210 CFDTMDF5_186;                                /* CFDTMDF5_186     */
    __type210 CFDTMDF6_186;                                /* CFDTMDF6_186     */
    __type210 CFDTMDF7_186;                                /* CFDTMDF7_186     */
    __type210 CFDTMDF8_186;                                /* CFDTMDF8_186     */
    __type210 CFDTMDF9_186;                                /* CFDTMDF9_186     */
    __type210 CFDTMDF10_186;                               /* CFDTMDF10_186    */
    __type210 CFDTMDF11_186;                               /* CFDTMDF11_186    */
    __type210 CFDTMDF12_186;                               /* CFDTMDF12_186    */
    __type210 CFDTMDF13_186;                               /* CFDTMDF13_186    */
    __type210 CFDTMDF14_186;                               /* CFDTMDF14_186    */
    __type210 CFDTMDF15_186;                               /* CFDTMDF15_186    */
    uint8  dummy553[52];                                   /* Reserved         */
    __type210 CFDTMID187;                                  /* CFDTMID187       */
    __type210 CFDTMPTR187;                                 /* CFDTMPTR187      */
    __type210 CFDTMFDCTR187;                               /* CFDTMFDCTR187    */
    __type210 CFDTMDF0_187;                                /* CFDTMDF0_187     */
    __type210 CFDTMDF1_187;                                /* CFDTMDF1_187     */
    __type210 CFDTMDF2_187;                                /* CFDTMDF2_187     */
    __type210 CFDTMDF3_187;                                /* CFDTMDF3_187     */
    __type210 CFDTMDF4_187;                                /* CFDTMDF4_187     */
    __type210 CFDTMDF5_187;                                /* CFDTMDF5_187     */
    __type210 CFDTMDF6_187;                                /* CFDTMDF6_187     */
    __type210 CFDTMDF7_187;                                /* CFDTMDF7_187     */
    __type210 CFDTMDF8_187;                                /* CFDTMDF8_187     */
    __type210 CFDTMDF9_187;                                /* CFDTMDF9_187     */
    __type210 CFDTMDF10_187;                               /* CFDTMDF10_187    */
    __type210 CFDTMDF11_187;                               /* CFDTMDF11_187    */
    __type210 CFDTMDF12_187;                               /* CFDTMDF12_187    */
    __type210 CFDTMDF13_187;                               /* CFDTMDF13_187    */
    __type210 CFDTMDF14_187;                               /* CFDTMDF14_187    */
    __type210 CFDTMDF15_187;                               /* CFDTMDF15_187    */
    uint8  dummy554[52];                                   /* Reserved         */
    __type210 CFDTMID188;                                  /* CFDTMID188       */
    __type210 CFDTMPTR188;                                 /* CFDTMPTR188      */
    __type210 CFDTMFDCTR188;                               /* CFDTMFDCTR188    */
    __type210 CFDTMDF0_188;                                /* CFDTMDF0_188     */
    __type210 CFDTMDF1_188;                                /* CFDTMDF1_188     */
    __type210 CFDTMDF2_188;                                /* CFDTMDF2_188     */
    __type210 CFDTMDF3_188;                                /* CFDTMDF3_188     */
    __type210 CFDTMDF4_188;                                /* CFDTMDF4_188     */
    __type210 CFDTMDF5_188;                                /* CFDTMDF5_188     */
    __type210 CFDTMDF6_188;                                /* CFDTMDF6_188     */
    __type210 CFDTMDF7_188;                                /* CFDTMDF7_188     */
    __type210 CFDTMDF8_188;                                /* CFDTMDF8_188     */
    __type210 CFDTMDF9_188;                                /* CFDTMDF9_188     */
    __type210 CFDTMDF10_188;                               /* CFDTMDF10_188    */
    __type210 CFDTMDF11_188;                               /* CFDTMDF11_188    */
    __type210 CFDTMDF12_188;                               /* CFDTMDF12_188    */
    __type210 CFDTMDF13_188;                               /* CFDTMDF13_188    */
    __type210 CFDTMDF14_188;                               /* CFDTMDF14_188    */
    __type210 CFDTMDF15_188;                               /* CFDTMDF15_188    */
    uint8  dummy555[52];                                   /* Reserved         */
    __type210 CFDTMID189;                                  /* CFDTMID189       */
    __type210 CFDTMPTR189;                                 /* CFDTMPTR189      */
    __type210 CFDTMFDCTR189;                               /* CFDTMFDCTR189    */
    __type210 CFDTMDF0_189;                                /* CFDTMDF0_189     */
    __type210 CFDTMDF1_189;                                /* CFDTMDF1_189     */
    __type210 CFDTMDF2_189;                                /* CFDTMDF2_189     */
    __type210 CFDTMDF3_189;                                /* CFDTMDF3_189     */
    __type210 CFDTMDF4_189;                                /* CFDTMDF4_189     */
    __type210 CFDTMDF5_189;                                /* CFDTMDF5_189     */
    __type210 CFDTMDF6_189;                                /* CFDTMDF6_189     */
    __type210 CFDTMDF7_189;                                /* CFDTMDF7_189     */
    __type210 CFDTMDF8_189;                                /* CFDTMDF8_189     */
    __type210 CFDTMDF9_189;                                /* CFDTMDF9_189     */
    __type210 CFDTMDF10_189;                               /* CFDTMDF10_189    */
    __type210 CFDTMDF11_189;                               /* CFDTMDF11_189    */
    __type210 CFDTMDF12_189;                               /* CFDTMDF12_189    */
    __type210 CFDTMDF13_189;                               /* CFDTMDF13_189    */
    __type210 CFDTMDF14_189;                               /* CFDTMDF14_189    */
    __type210 CFDTMDF15_189;                               /* CFDTMDF15_189    */
    uint8  dummy556[52];                                   /* Reserved         */
    __type210 CFDTMID190;                                  /* CFDTMID190       */
    __type210 CFDTMPTR190;                                 /* CFDTMPTR190      */
    __type210 CFDTMFDCTR190;                               /* CFDTMFDCTR190    */
    __type210 CFDTMDF0_190;                                /* CFDTMDF0_190     */
    __type210 CFDTMDF1_190;                                /* CFDTMDF1_190     */
    __type210 CFDTMDF2_190;                                /* CFDTMDF2_190     */
    __type210 CFDTMDF3_190;                                /* CFDTMDF3_190     */
    __type210 CFDTMDF4_190;                                /* CFDTMDF4_190     */
    __type210 CFDTMDF5_190;                                /* CFDTMDF5_190     */
    __type210 CFDTMDF6_190;                                /* CFDTMDF6_190     */
    __type210 CFDTMDF7_190;                                /* CFDTMDF7_190     */
    __type210 CFDTMDF8_190;                                /* CFDTMDF8_190     */
    __type210 CFDTMDF9_190;                                /* CFDTMDF9_190     */
    __type210 CFDTMDF10_190;                               /* CFDTMDF10_190    */
    __type210 CFDTMDF11_190;                               /* CFDTMDF11_190    */
    __type210 CFDTMDF12_190;                               /* CFDTMDF12_190    */
    __type210 CFDTMDF13_190;                               /* CFDTMDF13_190    */
    __type210 CFDTMDF14_190;                               /* CFDTMDF14_190    */
    __type210 CFDTMDF15_190;                               /* CFDTMDF15_190    */
    uint8  dummy557[52];                                   /* Reserved         */
    __type210 CFDTMID191;                                  /* CFDTMID191       */
    __type210 CFDTMPTR191;                                 /* CFDTMPTR191      */
    __type210 CFDTMFDCTR191;                               /* CFDTMFDCTR191    */
    __type210 CFDTMDF0_191;                                /* CFDTMDF0_191     */
    __type210 CFDTMDF1_191;                                /* CFDTMDF1_191     */
    __type210 CFDTMDF2_191;                                /* CFDTMDF2_191     */
    __type210 CFDTMDF3_191;                                /* CFDTMDF3_191     */
    __type210 CFDTMDF4_191;                                /* CFDTMDF4_191     */
    __type210 CFDTMDF5_191;                                /* CFDTMDF5_191     */
    __type210 CFDTMDF6_191;                                /* CFDTMDF6_191     */
    __type210 CFDTMDF7_191;                                /* CFDTMDF7_191     */
    __type210 CFDTMDF8_191;                                /* CFDTMDF8_191     */
    __type210 CFDTMDF9_191;                                /* CFDTMDF9_191     */
    __type210 CFDTMDF10_191;                               /* CFDTMDF10_191    */
    __type210 CFDTMDF11_191;                               /* CFDTMDF11_191    */
    __type210 CFDTMDF12_191;                               /* CFDTMDF12_191    */
    __type210 CFDTMDF13_191;                               /* CFDTMDF13_191    */
    __type210 CFDTMDF14_191;                               /* CFDTMDF14_191    */
    __type210 CFDTMDF15_191;                               /* CFDTMDF15_191    */
    uint8  dummy558[52];                                   /* Reserved         */
    __type210 CFDTMID192;                                  /* CFDTMID192       */
    __type210 CFDTMPTR192;                                 /* CFDTMPTR192      */
    __type210 CFDTMFDCTR192;                               /* CFDTMFDCTR192    */
    __type210 CFDTMDF0_192;                                /* CFDTMDF0_192     */
    __type210 CFDTMDF1_192;                                /* CFDTMDF1_192     */
    __type210 CFDTMDF2_192;                                /* CFDTMDF2_192     */
    __type210 CFDTMDF3_192;                                /* CFDTMDF3_192     */
    __type210 CFDTMDF4_192;                                /* CFDTMDF4_192     */
    __type210 CFDTMDF5_192;                                /* CFDTMDF5_192     */
    __type210 CFDTMDF6_192;                                /* CFDTMDF6_192     */
    __type210 CFDTMDF7_192;                                /* CFDTMDF7_192     */
    __type210 CFDTMDF8_192;                                /* CFDTMDF8_192     */
    __type210 CFDTMDF9_192;                                /* CFDTMDF9_192     */
    __type210 CFDTMDF10_192;                               /* CFDTMDF10_192    */
    __type210 CFDTMDF11_192;                               /* CFDTMDF11_192    */
    __type210 CFDTMDF12_192;                               /* CFDTMDF12_192    */
    __type210 CFDTMDF13_192;                               /* CFDTMDF13_192    */
    __type210 CFDTMDF14_192;                               /* CFDTMDF14_192    */
    __type210 CFDTMDF15_192;                               /* CFDTMDF15_192    */
    uint8  dummy559[52];                                   /* Reserved         */
    __type210 CFDTMID193;                                  /* CFDTMID193       */
    __type210 CFDTMPTR193;                                 /* CFDTMPTR193      */
    __type210 CFDTMFDCTR193;                               /* CFDTMFDCTR193    */
    __type210 CFDTMDF0_193;                                /* CFDTMDF0_193     */
    __type210 CFDTMDF1_193;                                /* CFDTMDF1_193     */
    __type210 CFDTMDF2_193;                                /* CFDTMDF2_193     */
    __type210 CFDTMDF3_193;                                /* CFDTMDF3_193     */
    __type210 CFDTMDF4_193;                                /* CFDTMDF4_193     */
    __type210 CFDTMDF5_193;                                /* CFDTMDF5_193     */
    __type210 CFDTMDF6_193;                                /* CFDTMDF6_193     */
    __type210 CFDTMDF7_193;                                /* CFDTMDF7_193     */
    __type210 CFDTMDF8_193;                                /* CFDTMDF8_193     */
    __type210 CFDTMDF9_193;                                /* CFDTMDF9_193     */
    __type210 CFDTMDF10_193;                               /* CFDTMDF10_193    */
    __type210 CFDTMDF11_193;                               /* CFDTMDF11_193    */
    __type210 CFDTMDF12_193;                               /* CFDTMDF12_193    */
    __type210 CFDTMDF13_193;                               /* CFDTMDF13_193    */
    __type210 CFDTMDF14_193;                               /* CFDTMDF14_193    */
    __type210 CFDTMDF15_193;                               /* CFDTMDF15_193    */
    uint8  dummy560[52];                                   /* Reserved         */
    __type210 CFDTMID194;                                  /* CFDTMID194       */
    __type210 CFDTMPTR194;                                 /* CFDTMPTR194      */
    __type210 CFDTMFDCTR194;                               /* CFDTMFDCTR194    */
    __type210 CFDTMDF0_194;                                /* CFDTMDF0_194     */
    __type210 CFDTMDF1_194;                                /* CFDTMDF1_194     */
    __type210 CFDTMDF2_194;                                /* CFDTMDF2_194     */
    __type210 CFDTMDF3_194;                                /* CFDTMDF3_194     */
    __type210 CFDTMDF4_194;                                /* CFDTMDF4_194     */
    __type210 CFDTMDF5_194;                                /* CFDTMDF5_194     */
    __type210 CFDTMDF6_194;                                /* CFDTMDF6_194     */
    __type210 CFDTMDF7_194;                                /* CFDTMDF7_194     */
    __type210 CFDTMDF8_194;                                /* CFDTMDF8_194     */
    __type210 CFDTMDF9_194;                                /* CFDTMDF9_194     */
    __type210 CFDTMDF10_194;                               /* CFDTMDF10_194    */
    __type210 CFDTMDF11_194;                               /* CFDTMDF11_194    */
    __type210 CFDTMDF12_194;                               /* CFDTMDF12_194    */
    __type210 CFDTMDF13_194;                               /* CFDTMDF13_194    */
    __type210 CFDTMDF14_194;                               /* CFDTMDF14_194    */
    __type210 CFDTMDF15_194;                               /* CFDTMDF15_194    */
    uint8  dummy561[52];                                   /* Reserved         */
    __type210 CFDTMID195;                                  /* CFDTMID195       */
    __type210 CFDTMPTR195;                                 /* CFDTMPTR195      */
    __type210 CFDTMFDCTR195;                               /* CFDTMFDCTR195    */
    __type210 CFDTMDF0_195;                                /* CFDTMDF0_195     */
    __type210 CFDTMDF1_195;                                /* CFDTMDF1_195     */
    __type210 CFDTMDF2_195;                                /* CFDTMDF2_195     */
    __type210 CFDTMDF3_195;                                /* CFDTMDF3_195     */
    __type210 CFDTMDF4_195;                                /* CFDTMDF4_195     */
    __type210 CFDTMDF5_195;                                /* CFDTMDF5_195     */
    __type210 CFDTMDF6_195;                                /* CFDTMDF6_195     */
    __type210 CFDTMDF7_195;                                /* CFDTMDF7_195     */
    __type210 CFDTMDF8_195;                                /* CFDTMDF8_195     */
    __type210 CFDTMDF9_195;                                /* CFDTMDF9_195     */
    __type210 CFDTMDF10_195;                               /* CFDTMDF10_195    */
    __type210 CFDTMDF11_195;                               /* CFDTMDF11_195    */
    __type210 CFDTMDF12_195;                               /* CFDTMDF12_195    */
    __type210 CFDTMDF13_195;                               /* CFDTMDF13_195    */
    __type210 CFDTMDF14_195;                               /* CFDTMDF14_195    */
    __type210 CFDTMDF15_195;                               /* CFDTMDF15_195    */
    uint8  dummy562[52];                                   /* Reserved         */
    __type210 CFDTMID196;                                  /* CFDTMID196       */
    __type210 CFDTMPTR196;                                 /* CFDTMPTR196      */
    __type210 CFDTMFDCTR196;                               /* CFDTMFDCTR196    */
    __type210 CFDTMDF0_196;                                /* CFDTMDF0_196     */
    __type210 CFDTMDF1_196;                                /* CFDTMDF1_196     */
    __type210 CFDTMDF2_196;                                /* CFDTMDF2_196     */
    __type210 CFDTMDF3_196;                                /* CFDTMDF3_196     */
    __type210 CFDTMDF4_196;                                /* CFDTMDF4_196     */
    __type210 CFDTMDF5_196;                                /* CFDTMDF5_196     */
    __type210 CFDTMDF6_196;                                /* CFDTMDF6_196     */
    __type210 CFDTMDF7_196;                                /* CFDTMDF7_196     */
    __type210 CFDTMDF8_196;                                /* CFDTMDF8_196     */
    __type210 CFDTMDF9_196;                                /* CFDTMDF9_196     */
    __type210 CFDTMDF10_196;                               /* CFDTMDF10_196    */
    __type210 CFDTMDF11_196;                               /* CFDTMDF11_196    */
    __type210 CFDTMDF12_196;                               /* CFDTMDF12_196    */
    __type210 CFDTMDF13_196;                               /* CFDTMDF13_196    */
    __type210 CFDTMDF14_196;                               /* CFDTMDF14_196    */
    __type210 CFDTMDF15_196;                               /* CFDTMDF15_196    */
    uint8  dummy563[52];                                   /* Reserved         */
    __type210 CFDTMID197;                                  /* CFDTMID197       */
    __type210 CFDTMPTR197;                                 /* CFDTMPTR197      */
    __type210 CFDTMFDCTR197;                               /* CFDTMFDCTR197    */
    __type210 CFDTMDF0_197;                                /* CFDTMDF0_197     */
    __type210 CFDTMDF1_197;                                /* CFDTMDF1_197     */
    __type210 CFDTMDF2_197;                                /* CFDTMDF2_197     */
    __type210 CFDTMDF3_197;                                /* CFDTMDF3_197     */
    __type210 CFDTMDF4_197;                                /* CFDTMDF4_197     */
    __type210 CFDTMDF5_197;                                /* CFDTMDF5_197     */
    __type210 CFDTMDF6_197;                                /* CFDTMDF6_197     */
    __type210 CFDTMDF7_197;                                /* CFDTMDF7_197     */
    __type210 CFDTMDF8_197;                                /* CFDTMDF8_197     */
    __type210 CFDTMDF9_197;                                /* CFDTMDF9_197     */
    __type210 CFDTMDF10_197;                               /* CFDTMDF10_197    */
    __type210 CFDTMDF11_197;                               /* CFDTMDF11_197    */
    __type210 CFDTMDF12_197;                               /* CFDTMDF12_197    */
    __type210 CFDTMDF13_197;                               /* CFDTMDF13_197    */
    __type210 CFDTMDF14_197;                               /* CFDTMDF14_197    */
    __type210 CFDTMDF15_197;                               /* CFDTMDF15_197    */
    uint8  dummy564[52];                                   /* Reserved         */
    __type210 CFDTMID198;                                  /* CFDTMID198       */
    __type210 CFDTMPTR198;                                 /* CFDTMPTR198      */
    __type210 CFDTMFDCTR198;                               /* CFDTMFDCTR198    */
    __type210 CFDTMDF0_198;                                /* CFDTMDF0_198     */
    __type210 CFDTMDF1_198;                                /* CFDTMDF1_198     */
    __type210 CFDTMDF2_198;                                /* CFDTMDF2_198     */
    __type210 CFDTMDF3_198;                                /* CFDTMDF3_198     */
    __type210 CFDTMDF4_198;                                /* CFDTMDF4_198     */
    __type210 CFDTMDF5_198;                                /* CFDTMDF5_198     */
    __type210 CFDTMDF6_198;                                /* CFDTMDF6_198     */
    __type210 CFDTMDF7_198;                                /* CFDTMDF7_198     */
    __type210 CFDTMDF8_198;                                /* CFDTMDF8_198     */
    __type210 CFDTMDF9_198;                                /* CFDTMDF9_198     */
    __type210 CFDTMDF10_198;                               /* CFDTMDF10_198    */
    __type210 CFDTMDF11_198;                               /* CFDTMDF11_198    */
    __type210 CFDTMDF12_198;                               /* CFDTMDF12_198    */
    __type210 CFDTMDF13_198;                               /* CFDTMDF13_198    */
    __type210 CFDTMDF14_198;                               /* CFDTMDF14_198    */
    __type210 CFDTMDF15_198;                               /* CFDTMDF15_198    */
    uint8  dummy565[52];                                   /* Reserved         */
    __type210 CFDTMID199;                                  /* CFDTMID199       */
    __type210 CFDTMPTR199;                                 /* CFDTMPTR199      */
    __type210 CFDTMFDCTR199;                               /* CFDTMFDCTR199    */
    __type210 CFDTMDF0_199;                                /* CFDTMDF0_199     */
    __type210 CFDTMDF1_199;                                /* CFDTMDF1_199     */
    __type210 CFDTMDF2_199;                                /* CFDTMDF2_199     */
    __type210 CFDTMDF3_199;                                /* CFDTMDF3_199     */
    __type210 CFDTMDF4_199;                                /* CFDTMDF4_199     */
    __type210 CFDTMDF5_199;                                /* CFDTMDF5_199     */
    __type210 CFDTMDF6_199;                                /* CFDTMDF6_199     */
    __type210 CFDTMDF7_199;                                /* CFDTMDF7_199     */
    __type210 CFDTMDF8_199;                                /* CFDTMDF8_199     */
    __type210 CFDTMDF9_199;                                /* CFDTMDF9_199     */
    __type210 CFDTMDF10_199;                               /* CFDTMDF10_199    */
    __type210 CFDTMDF11_199;                               /* CFDTMDF11_199    */
    __type210 CFDTMDF12_199;                               /* CFDTMDF12_199    */
    __type210 CFDTMDF13_199;                               /* CFDTMDF13_199    */
    __type210 CFDTMDF14_199;                               /* CFDTMDF14_199    */
    __type210 CFDTMDF15_199;                               /* CFDTMDF15_199    */
    uint8  dummy566[52];                                   /* Reserved         */
    __type210 CFDTMID200;                                  /* CFDTMID200       */
    __type210 CFDTMPTR200;                                 /* CFDTMPTR200      */
    __type210 CFDTMFDCTR200;                               /* CFDTMFDCTR200    */
    __type210 CFDTMDF0_200;                                /* CFDTMDF0_200     */
    __type210 CFDTMDF1_200;                                /* CFDTMDF1_200     */
    __type210 CFDTMDF2_200;                                /* CFDTMDF2_200     */
    __type210 CFDTMDF3_200;                                /* CFDTMDF3_200     */
    __type210 CFDTMDF4_200;                                /* CFDTMDF4_200     */
    __type210 CFDTMDF5_200;                                /* CFDTMDF5_200     */
    __type210 CFDTMDF6_200;                                /* CFDTMDF6_200     */
    __type210 CFDTMDF7_200;                                /* CFDTMDF7_200     */
    __type210 CFDTMDF8_200;                                /* CFDTMDF8_200     */
    __type210 CFDTMDF9_200;                                /* CFDTMDF9_200     */
    __type210 CFDTMDF10_200;                               /* CFDTMDF10_200    */
    __type210 CFDTMDF11_200;                               /* CFDTMDF11_200    */
    __type210 CFDTMDF12_200;                               /* CFDTMDF12_200    */
    __type210 CFDTMDF13_200;                               /* CFDTMDF13_200    */
    __type210 CFDTMDF14_200;                               /* CFDTMDF14_200    */
    __type210 CFDTMDF15_200;                               /* CFDTMDF15_200    */
    uint8  dummy567[52];                                   /* Reserved         */
    __type210 CFDTMID201;                                  /* CFDTMID201       */
    __type210 CFDTMPTR201;                                 /* CFDTMPTR201      */
    __type210 CFDTMFDCTR201;                               /* CFDTMFDCTR201    */
    __type210 CFDTMDF0_201;                                /* CFDTMDF0_201     */
    __type210 CFDTMDF1_201;                                /* CFDTMDF1_201     */
    __type210 CFDTMDF2_201;                                /* CFDTMDF2_201     */
    __type210 CFDTMDF3_201;                                /* CFDTMDF3_201     */
    __type210 CFDTMDF4_201;                                /* CFDTMDF4_201     */
    __type210 CFDTMDF5_201;                                /* CFDTMDF5_201     */
    __type210 CFDTMDF6_201;                                /* CFDTMDF6_201     */
    __type210 CFDTMDF7_201;                                /* CFDTMDF7_201     */
    __type210 CFDTMDF8_201;                                /* CFDTMDF8_201     */
    __type210 CFDTMDF9_201;                                /* CFDTMDF9_201     */
    __type210 CFDTMDF10_201;                               /* CFDTMDF10_201    */
    __type210 CFDTMDF11_201;                               /* CFDTMDF11_201    */
    __type210 CFDTMDF12_201;                               /* CFDTMDF12_201    */
    __type210 CFDTMDF13_201;                               /* CFDTMDF13_201    */
    __type210 CFDTMDF14_201;                               /* CFDTMDF14_201    */
    __type210 CFDTMDF15_201;                               /* CFDTMDF15_201    */
    uint8  dummy568[52];                                   /* Reserved         */
    __type210 CFDTMID202;                                  /* CFDTMID202       */
    __type210 CFDTMPTR202;                                 /* CFDTMPTR202      */
    __type210 CFDTMFDCTR202;                               /* CFDTMFDCTR202    */
    __type210 CFDTMDF0_202;                                /* CFDTMDF0_202     */
    __type210 CFDTMDF1_202;                                /* CFDTMDF1_202     */
    __type210 CFDTMDF2_202;                                /* CFDTMDF2_202     */
    __type210 CFDTMDF3_202;                                /* CFDTMDF3_202     */
    __type210 CFDTMDF4_202;                                /* CFDTMDF4_202     */
    __type210 CFDTMDF5_202;                                /* CFDTMDF5_202     */
    __type210 CFDTMDF6_202;                                /* CFDTMDF6_202     */
    __type210 CFDTMDF7_202;                                /* CFDTMDF7_202     */
    __type210 CFDTMDF8_202;                                /* CFDTMDF8_202     */
    __type210 CFDTMDF9_202;                                /* CFDTMDF9_202     */
    __type210 CFDTMDF10_202;                               /* CFDTMDF10_202    */
    __type210 CFDTMDF11_202;                               /* CFDTMDF11_202    */
    __type210 CFDTMDF12_202;                               /* CFDTMDF12_202    */
    __type210 CFDTMDF13_202;                               /* CFDTMDF13_202    */
    __type210 CFDTMDF14_202;                               /* CFDTMDF14_202    */
    __type210 CFDTMDF15_202;                               /* CFDTMDF15_202    */
    uint8  dummy569[52];                                   /* Reserved         */
    __type210 CFDTMID203;                                  /* CFDTMID203       */
    __type210 CFDTMPTR203;                                 /* CFDTMPTR203      */
    __type210 CFDTMFDCTR203;                               /* CFDTMFDCTR203    */
    __type210 CFDTMDF0_203;                                /* CFDTMDF0_203     */
    __type210 CFDTMDF1_203;                                /* CFDTMDF1_203     */
    __type210 CFDTMDF2_203;                                /* CFDTMDF2_203     */
    __type210 CFDTMDF3_203;                                /* CFDTMDF3_203     */
    __type210 CFDTMDF4_203;                                /* CFDTMDF4_203     */
    __type210 CFDTMDF5_203;                                /* CFDTMDF5_203     */
    __type210 CFDTMDF6_203;                                /* CFDTMDF6_203     */
    __type210 CFDTMDF7_203;                                /* CFDTMDF7_203     */
    __type210 CFDTMDF8_203;                                /* CFDTMDF8_203     */
    __type210 CFDTMDF9_203;                                /* CFDTMDF9_203     */
    __type210 CFDTMDF10_203;                               /* CFDTMDF10_203    */
    __type210 CFDTMDF11_203;                               /* CFDTMDF11_203    */
    __type210 CFDTMDF12_203;                               /* CFDTMDF12_203    */
    __type210 CFDTMDF13_203;                               /* CFDTMDF13_203    */
    __type210 CFDTMDF14_203;                               /* CFDTMDF14_203    */
    __type210 CFDTMDF15_203;                               /* CFDTMDF15_203    */
    uint8  dummy570[52];                                   /* Reserved         */
    __type210 CFDTMID204;                                  /* CFDTMID204       */
    __type210 CFDTMPTR204;                                 /* CFDTMPTR204      */
    __type210 CFDTMFDCTR204;                               /* CFDTMFDCTR204    */
    __type210 CFDTMDF0_204;                                /* CFDTMDF0_204     */
    __type210 CFDTMDF1_204;                                /* CFDTMDF1_204     */
    __type210 CFDTMDF2_204;                                /* CFDTMDF2_204     */
    __type210 CFDTMDF3_204;                                /* CFDTMDF3_204     */
    __type210 CFDTMDF4_204;                                /* CFDTMDF4_204     */
    __type210 CFDTMDF5_204;                                /* CFDTMDF5_204     */
    __type210 CFDTMDF6_204;                                /* CFDTMDF6_204     */
    __type210 CFDTMDF7_204;                                /* CFDTMDF7_204     */
    __type210 CFDTMDF8_204;                                /* CFDTMDF8_204     */
    __type210 CFDTMDF9_204;                                /* CFDTMDF9_204     */
    __type210 CFDTMDF10_204;                               /* CFDTMDF10_204    */
    __type210 CFDTMDF11_204;                               /* CFDTMDF11_204    */
    __type210 CFDTMDF12_204;                               /* CFDTMDF12_204    */
    __type210 CFDTMDF13_204;                               /* CFDTMDF13_204    */
    __type210 CFDTMDF14_204;                               /* CFDTMDF14_204    */
    __type210 CFDTMDF15_204;                               /* CFDTMDF15_204    */
    uint8  dummy571[52];                                   /* Reserved         */
    __type210 CFDTMID205;                                  /* CFDTMID205       */
    __type210 CFDTMPTR205;                                 /* CFDTMPTR205      */
    __type210 CFDTMFDCTR205;                               /* CFDTMFDCTR205    */
    __type210 CFDTMDF0_205;                                /* CFDTMDF0_205     */
    __type210 CFDTMDF1_205;                                /* CFDTMDF1_205     */
    __type210 CFDTMDF2_205;                                /* CFDTMDF2_205     */
    __type210 CFDTMDF3_205;                                /* CFDTMDF3_205     */
    __type210 CFDTMDF4_205;                                /* CFDTMDF4_205     */
    __type210 CFDTMDF5_205;                                /* CFDTMDF5_205     */
    __type210 CFDTMDF6_205;                                /* CFDTMDF6_205     */
    __type210 CFDTMDF7_205;                                /* CFDTMDF7_205     */
    __type210 CFDTMDF8_205;                                /* CFDTMDF8_205     */
    __type210 CFDTMDF9_205;                                /* CFDTMDF9_205     */
    __type210 CFDTMDF10_205;                               /* CFDTMDF10_205    */
    __type210 CFDTMDF11_205;                               /* CFDTMDF11_205    */
    __type210 CFDTMDF12_205;                               /* CFDTMDF12_205    */
    __type210 CFDTMDF13_205;                               /* CFDTMDF13_205    */
    __type210 CFDTMDF14_205;                               /* CFDTMDF14_205    */
    __type210 CFDTMDF15_205;                               /* CFDTMDF15_205    */
    uint8  dummy572[52];                                   /* Reserved         */
    __type210 CFDTMID206;                                  /* CFDTMID206       */
    __type210 CFDTMPTR206;                                 /* CFDTMPTR206      */
    __type210 CFDTMFDCTR206;                               /* CFDTMFDCTR206    */
    __type210 CFDTMDF0_206;                                /* CFDTMDF0_206     */
    __type210 CFDTMDF1_206;                                /* CFDTMDF1_206     */
    __type210 CFDTMDF2_206;                                /* CFDTMDF2_206     */
    __type210 CFDTMDF3_206;                                /* CFDTMDF3_206     */
    __type210 CFDTMDF4_206;                                /* CFDTMDF4_206     */
    __type210 CFDTMDF5_206;                                /* CFDTMDF5_206     */
    __type210 CFDTMDF6_206;                                /* CFDTMDF6_206     */
    __type210 CFDTMDF7_206;                                /* CFDTMDF7_206     */
    __type210 CFDTMDF8_206;                                /* CFDTMDF8_206     */
    __type210 CFDTMDF9_206;                                /* CFDTMDF9_206     */
    __type210 CFDTMDF10_206;                               /* CFDTMDF10_206    */
    __type210 CFDTMDF11_206;                               /* CFDTMDF11_206    */
    __type210 CFDTMDF12_206;                               /* CFDTMDF12_206    */
    __type210 CFDTMDF13_206;                               /* CFDTMDF13_206    */
    __type210 CFDTMDF14_206;                               /* CFDTMDF14_206    */
    __type210 CFDTMDF15_206;                               /* CFDTMDF15_206    */
    uint8  dummy573[52];                                   /* Reserved         */
    __type210 CFDTMID207;                                  /* CFDTMID207       */
    __type210 CFDTMPTR207;                                 /* CFDTMPTR207      */
    __type210 CFDTMFDCTR207;                               /* CFDTMFDCTR207    */
    __type210 CFDTMDF0_207;                                /* CFDTMDF0_207     */
    __type210 CFDTMDF1_207;                                /* CFDTMDF1_207     */
    __type210 CFDTMDF2_207;                                /* CFDTMDF2_207     */
    __type210 CFDTMDF3_207;                                /* CFDTMDF3_207     */
    __type210 CFDTMDF4_207;                                /* CFDTMDF4_207     */
    __type210 CFDTMDF5_207;                                /* CFDTMDF5_207     */
    __type210 CFDTMDF6_207;                                /* CFDTMDF6_207     */
    __type210 CFDTMDF7_207;                                /* CFDTMDF7_207     */
    __type210 CFDTMDF8_207;                                /* CFDTMDF8_207     */
    __type210 CFDTMDF9_207;                                /* CFDTMDF9_207     */
    __type210 CFDTMDF10_207;                               /* CFDTMDF10_207    */
    __type210 CFDTMDF11_207;                               /* CFDTMDF11_207    */
    __type210 CFDTMDF12_207;                               /* CFDTMDF12_207    */
    __type210 CFDTMDF13_207;                               /* CFDTMDF13_207    */
    __type210 CFDTMDF14_207;                               /* CFDTMDF14_207    */
    __type210 CFDTMDF15_207;                               /* CFDTMDF15_207    */
    uint8  dummy574[52];                                   /* Reserved         */
    __type210 CFDTMID208;                                  /* CFDTMID208       */
    __type210 CFDTMPTR208;                                 /* CFDTMPTR208      */
    __type210 CFDTMFDCTR208;                               /* CFDTMFDCTR208    */
    __type210 CFDTMDF0_208;                                /* CFDTMDF0_208     */
    __type210 CFDTMDF1_208;                                /* CFDTMDF1_208     */
    __type210 CFDTMDF2_208;                                /* CFDTMDF2_208     */
    __type210 CFDTMDF3_208;                                /* CFDTMDF3_208     */
    __type210 CFDTMDF4_208;                                /* CFDTMDF4_208     */
    __type210 CFDTMDF5_208;                                /* CFDTMDF5_208     */
    __type210 CFDTMDF6_208;                                /* CFDTMDF6_208     */
    __type210 CFDTMDF7_208;                                /* CFDTMDF7_208     */
    __type210 CFDTMDF8_208;                                /* CFDTMDF8_208     */
    __type210 CFDTMDF9_208;                                /* CFDTMDF9_208     */
    __type210 CFDTMDF10_208;                               /* CFDTMDF10_208    */
    __type210 CFDTMDF11_208;                               /* CFDTMDF11_208    */
    __type210 CFDTMDF12_208;                               /* CFDTMDF12_208    */
    __type210 CFDTMDF13_208;                               /* CFDTMDF13_208    */
    __type210 CFDTMDF14_208;                               /* CFDTMDF14_208    */
    __type210 CFDTMDF15_208;                               /* CFDTMDF15_208    */
    uint8  dummy575[52];                                   /* Reserved         */
    __type210 CFDTMID209;                                  /* CFDTMID209       */
    __type210 CFDTMPTR209;                                 /* CFDTMPTR209      */
    __type210 CFDTMFDCTR209;                               /* CFDTMFDCTR209    */
    __type210 CFDTMDF0_209;                                /* CFDTMDF0_209     */
    __type210 CFDTMDF1_209;                                /* CFDTMDF1_209     */
    __type210 CFDTMDF2_209;                                /* CFDTMDF2_209     */
    __type210 CFDTMDF3_209;                                /* CFDTMDF3_209     */
    __type210 CFDTMDF4_209;                                /* CFDTMDF4_209     */
    __type210 CFDTMDF5_209;                                /* CFDTMDF5_209     */
    __type210 CFDTMDF6_209;                                /* CFDTMDF6_209     */
    __type210 CFDTMDF7_209;                                /* CFDTMDF7_209     */
    __type210 CFDTMDF8_209;                                /* CFDTMDF8_209     */
    __type210 CFDTMDF9_209;                                /* CFDTMDF9_209     */
    __type210 CFDTMDF10_209;                               /* CFDTMDF10_209    */
    __type210 CFDTMDF11_209;                               /* CFDTMDF11_209    */
    __type210 CFDTMDF12_209;                               /* CFDTMDF12_209    */
    __type210 CFDTMDF13_209;                               /* CFDTMDF13_209    */
    __type210 CFDTMDF14_209;                               /* CFDTMDF14_209    */
    __type210 CFDTMDF15_209;                               /* CFDTMDF15_209    */
    uint8  dummy576[52];                                   /* Reserved         */
    __type210 CFDTMID210;                                  /* CFDTMID210       */
    __type210 CFDTMPTR210;                                 /* CFDTMPTR210      */
    __type210 CFDTMFDCTR210;                               /* CFDTMFDCTR210    */
    __type210 CFDTMDF0_210;                                /* CFDTMDF0_210     */
    __type210 CFDTMDF1_210;                                /* CFDTMDF1_210     */
    __type210 CFDTMDF2_210;                                /* CFDTMDF2_210     */
    __type210 CFDTMDF3_210;                                /* CFDTMDF3_210     */
    __type210 CFDTMDF4_210;                                /* CFDTMDF4_210     */
    __type210 CFDTMDF5_210;                                /* CFDTMDF5_210     */
    __type210 CFDTMDF6_210;                                /* CFDTMDF6_210     */
    __type210 CFDTMDF7_210;                                /* CFDTMDF7_210     */
    __type210 CFDTMDF8_210;                                /* CFDTMDF8_210     */
    __type210 CFDTMDF9_210;                                /* CFDTMDF9_210     */
    __type210 CFDTMDF10_210;                               /* CFDTMDF10_210    */
    __type210 CFDTMDF11_210;                               /* CFDTMDF11_210    */
    __type210 CFDTMDF12_210;                               /* CFDTMDF12_210    */
    __type210 CFDTMDF13_210;                               /* CFDTMDF13_210    */
    __type210 CFDTMDF14_210;                               /* CFDTMDF14_210    */
    __type210 CFDTMDF15_210;                               /* CFDTMDF15_210    */
    uint8  dummy577[52];                                   /* Reserved         */
    __type210 CFDTMID211;                                  /* CFDTMID211       */
    __type210 CFDTMPTR211;                                 /* CFDTMPTR211      */
    __type210 CFDTMFDCTR211;                               /* CFDTMFDCTR211    */
    __type210 CFDTMDF0_211;                                /* CFDTMDF0_211     */
    __type210 CFDTMDF1_211;                                /* CFDTMDF1_211     */
    __type210 CFDTMDF2_211;                                /* CFDTMDF2_211     */
    __type210 CFDTMDF3_211;                                /* CFDTMDF3_211     */
    __type210 CFDTMDF4_211;                                /* CFDTMDF4_211     */
    __type210 CFDTMDF5_211;                                /* CFDTMDF5_211     */
    __type210 CFDTMDF6_211;                                /* CFDTMDF6_211     */
    __type210 CFDTMDF7_211;                                /* CFDTMDF7_211     */
    __type210 CFDTMDF8_211;                                /* CFDTMDF8_211     */
    __type210 CFDTMDF9_211;                                /* CFDTMDF9_211     */
    __type210 CFDTMDF10_211;                               /* CFDTMDF10_211    */
    __type210 CFDTMDF11_211;                               /* CFDTMDF11_211    */
    __type210 CFDTMDF12_211;                               /* CFDTMDF12_211    */
    __type210 CFDTMDF13_211;                               /* CFDTMDF13_211    */
    __type210 CFDTMDF14_211;                               /* CFDTMDF14_211    */
    __type210 CFDTMDF15_211;                               /* CFDTMDF15_211    */
    uint8  dummy578[52];                                   /* Reserved         */
    __type210 CFDTMID212;                                  /* CFDTMID212       */
    __type210 CFDTMPTR212;                                 /* CFDTMPTR212      */
    __type210 CFDTMFDCTR212;                               /* CFDTMFDCTR212    */
    __type210 CFDTMDF0_212;                                /* CFDTMDF0_212     */
    __type210 CFDTMDF1_212;                                /* CFDTMDF1_212     */
    __type210 CFDTMDF2_212;                                /* CFDTMDF2_212     */
    __type210 CFDTMDF3_212;                                /* CFDTMDF3_212     */
    __type210 CFDTMDF4_212;                                /* CFDTMDF4_212     */
    __type210 CFDTMDF5_212;                                /* CFDTMDF5_212     */
    __type210 CFDTMDF6_212;                                /* CFDTMDF6_212     */
    __type210 CFDTMDF7_212;                                /* CFDTMDF7_212     */
    __type210 CFDTMDF8_212;                                /* CFDTMDF8_212     */
    __type210 CFDTMDF9_212;                                /* CFDTMDF9_212     */
    __type210 CFDTMDF10_212;                               /* CFDTMDF10_212    */
    __type210 CFDTMDF11_212;                               /* CFDTMDF11_212    */
    __type210 CFDTMDF12_212;                               /* CFDTMDF12_212    */
    __type210 CFDTMDF13_212;                               /* CFDTMDF13_212    */
    __type210 CFDTMDF14_212;                               /* CFDTMDF14_212    */
    __type210 CFDTMDF15_212;                               /* CFDTMDF15_212    */
    uint8  dummy579[52];                                   /* Reserved         */
    __type210 CFDTMID213;                                  /* CFDTMID213       */
    __type210 CFDTMPTR213;                                 /* CFDTMPTR213      */
    __type210 CFDTMFDCTR213;                               /* CFDTMFDCTR213    */
    __type210 CFDTMDF0_213;                                /* CFDTMDF0_213     */
    __type210 CFDTMDF1_213;                                /* CFDTMDF1_213     */
    __type210 CFDTMDF2_213;                                /* CFDTMDF2_213     */
    __type210 CFDTMDF3_213;                                /* CFDTMDF3_213     */
    __type210 CFDTMDF4_213;                                /* CFDTMDF4_213     */
    __type210 CFDTMDF5_213;                                /* CFDTMDF5_213     */
    __type210 CFDTMDF6_213;                                /* CFDTMDF6_213     */
    __type210 CFDTMDF7_213;                                /* CFDTMDF7_213     */
    __type210 CFDTMDF8_213;                                /* CFDTMDF8_213     */
    __type210 CFDTMDF9_213;                                /* CFDTMDF9_213     */
    __type210 CFDTMDF10_213;                               /* CFDTMDF10_213    */
    __type210 CFDTMDF11_213;                               /* CFDTMDF11_213    */
    __type210 CFDTMDF12_213;                               /* CFDTMDF12_213    */
    __type210 CFDTMDF13_213;                               /* CFDTMDF13_213    */
    __type210 CFDTMDF14_213;                               /* CFDTMDF14_213    */
    __type210 CFDTMDF15_213;                               /* CFDTMDF15_213    */
    uint8  dummy580[52];                                   /* Reserved         */
    __type210 CFDTMID214;                                  /* CFDTMID214       */
    __type210 CFDTMPTR214;                                 /* CFDTMPTR214      */
    __type210 CFDTMFDCTR214;                               /* CFDTMFDCTR214    */
    __type210 CFDTMDF0_214;                                /* CFDTMDF0_214     */
    __type210 CFDTMDF1_214;                                /* CFDTMDF1_214     */
    __type210 CFDTMDF2_214;                                /* CFDTMDF2_214     */
    __type210 CFDTMDF3_214;                                /* CFDTMDF3_214     */
    __type210 CFDTMDF4_214;                                /* CFDTMDF4_214     */
    __type210 CFDTMDF5_214;                                /* CFDTMDF5_214     */
    __type210 CFDTMDF6_214;                                /* CFDTMDF6_214     */
    __type210 CFDTMDF7_214;                                /* CFDTMDF7_214     */
    __type210 CFDTMDF8_214;                                /* CFDTMDF8_214     */
    __type210 CFDTMDF9_214;                                /* CFDTMDF9_214     */
    __type210 CFDTMDF10_214;                               /* CFDTMDF10_214    */
    __type210 CFDTMDF11_214;                               /* CFDTMDF11_214    */
    __type210 CFDTMDF12_214;                               /* CFDTMDF12_214    */
    __type210 CFDTMDF13_214;                               /* CFDTMDF13_214    */
    __type210 CFDTMDF14_214;                               /* CFDTMDF14_214    */
    __type210 CFDTMDF15_214;                               /* CFDTMDF15_214    */
    uint8  dummy581[52];                                   /* Reserved         */
    __type210 CFDTMID215;                                  /* CFDTMID215       */
    __type210 CFDTMPTR215;                                 /* CFDTMPTR215      */
    __type210 CFDTMFDCTR215;                               /* CFDTMFDCTR215    */
    __type210 CFDTMDF0_215;                                /* CFDTMDF0_215     */
    __type210 CFDTMDF1_215;                                /* CFDTMDF1_215     */
    __type210 CFDTMDF2_215;                                /* CFDTMDF2_215     */
    __type210 CFDTMDF3_215;                                /* CFDTMDF3_215     */
    __type210 CFDTMDF4_215;                                /* CFDTMDF4_215     */
    __type210 CFDTMDF5_215;                                /* CFDTMDF5_215     */
    __type210 CFDTMDF6_215;                                /* CFDTMDF6_215     */
    __type210 CFDTMDF7_215;                                /* CFDTMDF7_215     */
    __type210 CFDTMDF8_215;                                /* CFDTMDF8_215     */
    __type210 CFDTMDF9_215;                                /* CFDTMDF9_215     */
    __type210 CFDTMDF10_215;                               /* CFDTMDF10_215    */
    __type210 CFDTMDF11_215;                               /* CFDTMDF11_215    */
    __type210 CFDTMDF12_215;                               /* CFDTMDF12_215    */
    __type210 CFDTMDF13_215;                               /* CFDTMDF13_215    */
    __type210 CFDTMDF14_215;                               /* CFDTMDF14_215    */
    __type210 CFDTMDF15_215;                               /* CFDTMDF15_215    */
    uint8  dummy582[52];                                   /* Reserved         */
    __type210 CFDTMID216;                                  /* CFDTMID216       */
    __type210 CFDTMPTR216;                                 /* CFDTMPTR216      */
    __type210 CFDTMFDCTR216;                               /* CFDTMFDCTR216    */
    __type210 CFDTMDF0_216;                                /* CFDTMDF0_216     */
    __type210 CFDTMDF1_216;                                /* CFDTMDF1_216     */
    __type210 CFDTMDF2_216;                                /* CFDTMDF2_216     */
    __type210 CFDTMDF3_216;                                /* CFDTMDF3_216     */
    __type210 CFDTMDF4_216;                                /* CFDTMDF4_216     */
    __type210 CFDTMDF5_216;                                /* CFDTMDF5_216     */
    __type210 CFDTMDF6_216;                                /* CFDTMDF6_216     */
    __type210 CFDTMDF7_216;                                /* CFDTMDF7_216     */
    __type210 CFDTMDF8_216;                                /* CFDTMDF8_216     */
    __type210 CFDTMDF9_216;                                /* CFDTMDF9_216     */
    __type210 CFDTMDF10_216;                               /* CFDTMDF10_216    */
    __type210 CFDTMDF11_216;                               /* CFDTMDF11_216    */
    __type210 CFDTMDF12_216;                               /* CFDTMDF12_216    */
    __type210 CFDTMDF13_216;                               /* CFDTMDF13_216    */
    __type210 CFDTMDF14_216;                               /* CFDTMDF14_216    */
    __type210 CFDTMDF15_216;                               /* CFDTMDF15_216    */
    uint8  dummy58